// Code generated by capnpc-go. DO NOT EDIT.

package rpc

import (
	capnp "capnproto.org/go/capnp/v3"
	text "capnproto.org/go/capnp/v3/encoding/text"
	schemas "capnproto.org/go/capnp/v3/schemas"
	strconv "strconv"
)

type Message capnp.Struct
type Message_Which uint16

const (
	Message_Which_unimplemented    Message_Which = 0
	Message_Which_abort            Message_Which = 1
	Message_Which_bootstrap        Message_Which = 8
	Message_Which_call             Message_Which = 2
	Message_Which_return           Message_Which = 3
	Message_Which_finish           Message_Which = 4
	Message_Which_resolve          Message_Which = 5
	Message_Which_release          Message_Which = 6
	Message_Which_disembargo       Message_Which = 13
	Message_Which_obsoleteSave     Message_Which = 7
	Message_Which_obsoleteDelete   Message_Which = 9
	Message_Which_provide          Message_Which = 10
	Message_Which_accept           Message_Which = 11
	Message_Which_thirdPartyAnswer Message_Which = 14
	Message_Which_join             Message_Which = 12
)

func (w Message_Which) String() string {
	const s = "unimplementedabortbootstrapcallreturnfinishresolvereleasedisembargoobsoleteSaveobsoleteDeleteprovideacceptthirdPartyAnswerjoin"
	switch w {
	case Message_Which_unimplemented:
		return s[0:13]
	case Message_Which_abort:
		return s[13:18]
	case Message_Which_bootstrap:
		return s[18:27]
	case Message_Which_call:
		return s[27:31]
	case Message_Which_return:
		return s[31:37]
	case Message_Which_finish:
		return s[37:43]
	case Message_Which_resolve:
		return s[43:50]
	case Message_Which_release:
		return s[50:57]
	case Message_Which_disembargo:
		return s[57:67]
	case Message_Which_obsoleteSave:
		return s[67:79]
	case Message_Which_obsoleteDelete:
		return s[79:93]
	case Message_Which_provide:
		return s[93:100]
	case Message_Which_accept:
		return s[100:106]
	case Message_Which_thirdPartyAnswer:
		return s[106:122]
	case Message_Which_join:
		return s[122:126]

	}
	return "Message_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// Message_TypeID is the unique identifier for the type Message.
const Message_TypeID = 0x91b79f1f808db032

func NewMessage(s *capnp.Segment) (Message, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Message(st), err
}

func NewRootMessage(s *capnp.Segment) (Message, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Message(st), err
}

func ReadRootMessage(msg *capnp.Message) (Message, error) {
	root, err := msg.Root()
	return Message(root.Struct()), err
}

func (s Message) String() string {
	str, _ := text.Marshal(0x91b79f1f808db032, capnp.Struct(s))
	return str
}

func (s Message) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Message) DecodeFromPtr(p capnp.Ptr) Message {
	return Message(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Message) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}

func (s Message) Which() Message_Which {
	return Message_Which(capnp.Struct(s).Uint16(0))
}
func (s Message) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Message) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Message) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Message) Unimplemented() (Message, error) {
	if capnp.Struct(s).Uint16(0) != 0 {
		panic("Which() != unimplemented")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Message(p.Struct()), err
}

func (s Message) HasUnimplemented() bool {
	if capnp.Struct(s).Uint16(0) != 0 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetUnimplemented(v Message) error {
	capnp.Struct(s).SetUint16(0, 0)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewUnimplemented sets the unimplemented field to a newly
// allocated Message struct, preferring placement in s's segment.
func (s Message) NewUnimplemented() (Message, error) {
	capnp.Struct(s).SetUint16(0, 0)
	ss, err := NewMessage(capnp.Struct(s).Segment())
	if err != nil {
		return Message{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) Abort() (Exception, error) {
	if capnp.Struct(s).Uint16(0) != 1 {
		panic("Which() != abort")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Exception(p.Struct()), err
}

func (s Message) HasAbort() bool {
	if capnp.Struct(s).Uint16(0) != 1 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetAbort(v Exception) error {
	capnp.Struct(s).SetUint16(0, 1)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewAbort sets the abort field to a newly
// allocated Exception struct, preferring placement in s's segment.
func (s Message) NewAbort() (Exception, error) {
	capnp.Struct(s).SetUint16(0, 1)
	ss, err := NewException(capnp.Struct(s).Segment())
	if err != nil {
		return Exception{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) Bootstrap() (Bootstrap, error) {
	if capnp.Struct(s).Uint16(0) != 8 {
		panic("Which() != bootstrap")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Bootstrap(p.Struct()), err
}

func (s Message) HasBootstrap() bool {
	if capnp.Struct(s).Uint16(0) != 8 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetBootstrap(v Bootstrap) error {
	capnp.Struct(s).SetUint16(0, 8)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewBootstrap sets the bootstrap field to a newly
// allocated Bootstrap struct, preferring placement in s's segment.
func (s Message) NewBootstrap() (Bootstrap, error) {
	capnp.Struct(s).SetUint16(0, 8)
	ss, err := NewBootstrap(capnp.Struct(s).Segment())
	if err != nil {
		return Bootstrap{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) Call() (Call, error) {
	if capnp.Struct(s).Uint16(0) != 2 {
		panic("Which() != call")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Call(p.Struct()), err
}

func (s Message) HasCall() bool {
	if capnp.Struct(s).Uint16(0) != 2 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetCall(v Call) error {
	capnp.Struct(s).SetUint16(0, 2)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewCall sets the call field to a newly
// allocated Call struct, preferring placement in s's segment.
func (s Message) NewCall() (Call, error) {
	capnp.Struct(s).SetUint16(0, 2)
	ss, err := NewCall(capnp.Struct(s).Segment())
	if err != nil {
		return Call{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) Return() (Return, error) {
	if capnp.Struct(s).Uint16(0) != 3 {
		panic("Which() != return")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Return(p.Struct()), err
}

func (s Message) HasReturn() bool {
	if capnp.Struct(s).Uint16(0) != 3 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetReturn(v Return) error {
	capnp.Struct(s).SetUint16(0, 3)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewReturn sets the return field to a newly
// allocated Return struct, preferring placement in s's segment.
func (s Message) NewReturn() (Return, error) {
	capnp.Struct(s).SetUint16(0, 3)
	ss, err := NewReturn(capnp.Struct(s).Segment())
	if err != nil {
		return Return{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) Finish() (Finish, error) {
	if capnp.Struct(s).Uint16(0) != 4 {
		panic("Which() != finish")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Finish(p.Struct()), err
}

func (s Message) HasFinish() bool {
	if capnp.Struct(s).Uint16(0) != 4 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetFinish(v Finish) error {
	capnp.Struct(s).SetUint16(0, 4)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewFinish sets the finish field to a newly
// allocated Finish struct, preferring placement in s's segment.
func (s Message) NewFinish() (Finish, error) {
	capnp.Struct(s).SetUint16(0, 4)
	ss, err := NewFinish(capnp.Struct(s).Segment())
	if err != nil {
		return Finish{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) Resolve() (Resolve, error) {
	if capnp.Struct(s).Uint16(0) != 5 {
		panic("Which() != resolve")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Resolve(p.Struct()), err
}

func (s Message) HasResolve() bool {
	if capnp.Struct(s).Uint16(0) != 5 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetResolve(v Resolve) error {
	capnp.Struct(s).SetUint16(0, 5)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewResolve sets the resolve field to a newly
// allocated Resolve struct, preferring placement in s's segment.
func (s Message) NewResolve() (Resolve, error) {
	capnp.Struct(s).SetUint16(0, 5)
	ss, err := NewResolve(capnp.Struct(s).Segment())
	if err != nil {
		return Resolve{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) Release() (Release, error) {
	if capnp.Struct(s).Uint16(0) != 6 {
		panic("Which() != release")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Release(p.Struct()), err
}

func (s Message) HasRelease() bool {
	if capnp.Struct(s).Uint16(0) != 6 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetRelease(v Release) error {
	capnp.Struct(s).SetUint16(0, 6)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewRelease sets the release field to a newly
// allocated Release struct, preferring placement in s's segment.
func (s Message) NewRelease() (Release, error) {
	capnp.Struct(s).SetUint16(0, 6)
	ss, err := NewRelease(capnp.Struct(s).Segment())
	if err != nil {
		return Release{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) Disembargo() (Disembargo, error) {
	if capnp.Struct(s).Uint16(0) != 13 {
		panic("Which() != disembargo")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Disembargo(p.Struct()), err
}

func (s Message) HasDisembargo() bool {
	if capnp.Struct(s).Uint16(0) != 13 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetDisembargo(v Disembargo) error {
	capnp.Struct(s).SetUint16(0, 13)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewDisembargo sets the disembargo field to a newly
// allocated Disembargo struct, preferring placement in s's segment.
func (s Message) NewDisembargo() (Disembargo, error) {
	capnp.Struct(s).SetUint16(0, 13)
	ss, err := NewDisembargo(capnp.Struct(s).Segment())
	if err != nil {
		return Disembargo{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) ObsoleteSave() (capnp.Ptr, error) {
	if capnp.Struct(s).Uint16(0) != 7 {
		panic("Which() != obsoleteSave")
	}
	return capnp.Struct(s).Ptr(0)
}

func (s Message) HasObsoleteSave() bool {
	if capnp.Struct(s).Uint16(0) != 7 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetObsoleteSave(v capnp.Ptr) error {
	capnp.Struct(s).SetUint16(0, 7)
	return capnp.Struct(s).SetPtr(0, v)
}
func (s Message) ObsoleteDelete() (capnp.Ptr, error) {
	if capnp.Struct(s).Uint16(0) != 9 {
		panic("Which() != obsoleteDelete")
	}
	return capnp.Struct(s).Ptr(0)
}

func (s Message) HasObsoleteDelete() bool {
	if capnp.Struct(s).Uint16(0) != 9 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetObsoleteDelete(v capnp.Ptr) error {
	capnp.Struct(s).SetUint16(0, 9)
	return capnp.Struct(s).SetPtr(0, v)
}
func (s Message) Provide() (Provide, error) {
	if capnp.Struct(s).Uint16(0) != 10 {
		panic("Which() != provide")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Provide(p.Struct()), err
}

func (s Message) HasProvide() bool {
	if capnp.Struct(s).Uint16(0) != 10 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetProvide(v Provide) error {
	capnp.Struct(s).SetUint16(0, 10)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewProvide sets the provide field to a newly
// allocated Provide struct, preferring placement in s's segment.
func (s Message) NewProvide() (Provide, error) {
	capnp.Struct(s).SetUint16(0, 10)
	ss, err := NewProvide(capnp.Struct(s).Segment())
	if err != nil {
		return Provide{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) Accept() (Accept, error) {
	if capnp.Struct(s).Uint16(0) != 11 {
		panic("Which() != accept")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Accept(p.Struct()), err
}

func (s Message) HasAccept() bool {
	if capnp.Struct(s).Uint16(0) != 11 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetAccept(v Accept) error {
	capnp.Struct(s).SetUint16(0, 11)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewAccept sets the accept field to a newly
// allocated Accept struct, preferring placement in s's segment.
func (s Message) NewAccept() (Accept, error) {
	capnp.Struct(s).SetUint16(0, 11)
	ss, err := NewAccept(capnp.Struct(s).Segment())
	if err != nil {
		return Accept{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) ThirdPartyAnswer() (ThirdPartyAnswer, error) {
	if capnp.Struct(s).Uint16(0) != 14 {
		panic("Which() != thirdPartyAnswer")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return ThirdPartyAnswer(p.Struct()), err
}

func (s Message) HasThirdPartyAnswer() bool {
	if capnp.Struct(s).Uint16(0) != 14 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetThirdPartyAnswer(v ThirdPartyAnswer) error {
	capnp.Struct(s).SetUint16(0, 14)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewThirdPartyAnswer sets the thirdPartyAnswer field to a newly
// allocated ThirdPartyAnswer struct, preferring placement in s's segment.
func (s Message) NewThirdPartyAnswer() (ThirdPartyAnswer, error) {
	capnp.Struct(s).SetUint16(0, 14)
	ss, err := NewThirdPartyAnswer(capnp.Struct(s).Segment())
	if err != nil {
		return ThirdPartyAnswer{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Message) Join() (Join, error) {
	if capnp.Struct(s).Uint16(0) != 12 {
		panic("Which() != join")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Join(p.Struct()), err
}

func (s Message) HasJoin() bool {
	if capnp.Struct(s).Uint16(0) != 12 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Message) SetJoin(v Join) error {
	capnp.Struct(s).SetUint16(0, 12)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewJoin sets the join field to a newly
// allocated Join struct, preferring placement in s's segment.
func (s Message) NewJoin() (Join, error) {
	capnp.Struct(s).SetUint16(0, 12)
	ss, err := NewJoin(capnp.Struct(s).Segment())
	if err != nil {
		return Join{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Message_List is a list of Message.
type Message_List = capnp.StructList[Message]

// NewMessage creates a new list of Message.
func NewMessage_List(s *capnp.Segment, sz int32) (Message_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[Message](l), err
}

// Message_Future is a wrapper for a Message promised by a client call.
type Message_Future struct{ *capnp.Future }

func (f Message_Future) Struct() (Message, error) {
	p, err := f.Future.Ptr()
	return Message(p.Struct()), err
}
func (p Message_Future) Unimplemented() Message_Future {
	return Message_Future{Future: p.Future.Field(0, nil)}
}
func (p Message_Future) Abort() Exception_Future {
	return Exception_Future{Future: p.Future.Field(0, nil)}
}
func (p Message_Future) Bootstrap() Bootstrap_Future {
	return Bootstrap_Future{Future: p.Future.Field(0, nil)}
}
func (p Message_Future) Call() Call_Future {
	return Call_Future{Future: p.Future.Field(0, nil)}
}
func (p Message_Future) Return() Return_Future {
	return Return_Future{Future: p.Future.Field(0, nil)}
}
func (p Message_Future) Finish() Finish_Future {
	return Finish_Future{Future: p.Future.Field(0, nil)}
}
func (p Message_Future) Resolve() Resolve_Future {
	return Resolve_Future{Future: p.Future.Field(0, nil)}
}
func (p Message_Future) Release() Release_Future {
	return Release_Future{Future: p.Future.Field(0, nil)}
}
func (p Message_Future) Disembargo() Disembargo_Future {
	return Disembargo_Future{Future: p.Future.Field(0, nil)}
}
func (p Message_Future) ObsoleteSave() *capnp.Future {
	return p.Future.Field(0, nil)
}
func (p Message_Future) ObsoleteDelete() *capnp.Future {
	return p.Future.Field(0, nil)
}
func (p Message_Future) Provide() Provide_Future {
	return Provide_Future{Future: p.Future.Field(0, nil)}
}
func (p Message_Future) Accept() Accept_Future {
	return Accept_Future{Future: p.Future.Field(0, nil)}
}
func (p Message_Future) ThirdPartyAnswer() ThirdPartyAnswer_Future {
	return ThirdPartyAnswer_Future{Future: p.Future.Field(0, nil)}
}
func (p Message_Future) Join() Join_Future {
	return Join_Future{Future: p.Future.Field(0, nil)}
}

type Bootstrap capnp.Struct

// Bootstrap_TypeID is the unique identifier for the type Bootstrap.
const Bootstrap_TypeID = 0xe94ccf8031176ec4

func NewBootstrap(s *capnp.Segment) (Bootstrap, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Bootstrap(st), err
}

func NewRootBootstrap(s *capnp.Segment) (Bootstrap, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Bootstrap(st), err
}

func ReadRootBootstrap(msg *capnp.Message) (Bootstrap, error) {
	root, err := msg.Root()
	return Bootstrap(root.Struct()), err
}

func (s Bootstrap) String() string {
	str, _ := text.Marshal(0xe94ccf8031176ec4, capnp.Struct(s))
	return str
}

func (s Bootstrap) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Bootstrap) DecodeFromPtr(p capnp.Ptr) Bootstrap {
	return Bootstrap(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Bootstrap) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Bootstrap) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Bootstrap) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Bootstrap) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Bootstrap) QuestionId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s Bootstrap) SetQuestionId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

func (s Bootstrap) DeprecatedObjectId() (capnp.Ptr, error) {
	return capnp.Struct(s).Ptr(0)
}

func (s Bootstrap) HasDeprecatedObjectId() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Bootstrap) SetDeprecatedObjectId(v capnp.Ptr) error {
	return capnp.Struct(s).SetPtr(0, v)
}

// Bootstrap_List is a list of Bootstrap.
type Bootstrap_List = capnp.StructList[Bootstrap]

// NewBootstrap creates a new list of Bootstrap.
func NewBootstrap_List(s *capnp.Segment, sz int32) (Bootstrap_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[Bootstrap](l), err
}

// Bootstrap_Future is a wrapper for a Bootstrap promised by a client call.
type Bootstrap_Future struct{ *capnp.Future }

func (f Bootstrap_Future) Struct() (Bootstrap, error) {
	p, err := f.Future.Ptr()
	return Bootstrap(p.Struct()), err
}
func (p Bootstrap_Future) DeprecatedObjectId() *capnp.Future {
	return p.Future.Field(0, nil)
}

type Call capnp.Struct
type Call_sendResultsTo Call
type Call_sendResultsTo_Which uint16

const (
	Call_sendResultsTo_Which_caller     Call_sendResultsTo_Which = 0
	Call_sendResultsTo_Which_yourself   Call_sendResultsTo_Which = 1
	Call_sendResultsTo_Which_thirdParty Call_sendResultsTo_Which = 2
)

func (w Call_sendResultsTo_Which) String() string {
	const s = "calleryourselfthirdParty"
	switch w {
	case Call_sendResultsTo_Which_caller:
		return s[0:6]
	case Call_sendResultsTo_Which_yourself:
		return s[6:14]
	case Call_sendResultsTo_Which_thirdParty:
		return s[14:24]

	}
	return "Call_sendResultsTo_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// Call_TypeID is the unique identifier for the type Call.
const Call_TypeID = 0x836a53ce789d4cd4

func NewCall(s *capnp.Segment) (Call, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 24, PointerCount: 3})
	return Call(st), err
}

func NewRootCall(s *capnp.Segment) (Call, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 24, PointerCount: 3})
	return Call(st), err
}

func ReadRootCall(msg *capnp.Message) (Call, error) {
	root, err := msg.Root()
	return Call(root.Struct()), err
}

func (s Call) String() string {
	str, _ := text.Marshal(0x836a53ce789d4cd4, capnp.Struct(s))
	return str
}

func (s Call) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Call) DecodeFromPtr(p capnp.Ptr) Call {
	return Call(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Call) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Call) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Call) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Call) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Call) QuestionId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s Call) SetQuestionId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

func (s Call) Target() (MessageTarget, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return MessageTarget(p.Struct()), err
}

func (s Call) HasTarget() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Call) SetTarget(v MessageTarget) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewTarget sets the target field to a newly
// allocated MessageTarget struct, preferring placement in s's segment.
func (s Call) NewTarget() (MessageTarget, error) {
	ss, err := NewMessageTarget(capnp.Struct(s).Segment())
	if err != nil {
		return MessageTarget{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Call) InterfaceId() uint64 {
	return capnp.Struct(s).Uint64(8)
}

func (s Call) SetInterfaceId(v uint64) {
	capnp.Struct(s).SetUint64(8, v)
}

func (s Call) MethodId() uint16 {
	return capnp.Struct(s).Uint16(4)
}

func (s Call) SetMethodId(v uint16) {
	capnp.Struct(s).SetUint16(4, v)
}

func (s Call) AllowThirdPartyTailCall() bool {
	return capnp.Struct(s).Bit(128)
}

func (s Call) SetAllowThirdPartyTailCall(v bool) {
	capnp.Struct(s).SetBit(128, v)
}

func (s Call) NoPromisePipelining() bool {
	return capnp.Struct(s).Bit(129)
}

func (s Call) SetNoPromisePipelining(v bool) {
	capnp.Struct(s).SetBit(129, v)
}

func (s Call) OnlyPromisePipeline() bool {
	return capnp.Struct(s).Bit(130)
}

func (s Call) SetOnlyPromisePipeline(v bool) {
	capnp.Struct(s).SetBit(130, v)
}

func (s Call) Params() (Payload, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return Payload(p.Struct()), err
}

func (s Call) HasParams() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Call) SetParams(v Payload) error {
	return capnp.Struct(s).SetPtr(1, capnp.Struct(v).ToPtr())
}

// NewParams sets the params field to a newly
// allocated Payload struct, preferring placement in s's segment.
func (s Call) NewParams() (Payload, error) {
	ss, err := NewPayload(capnp.Struct(s).Segment())
	if err != nil {
		return Payload{}, err
	}
	err = capnp.Struct(s).SetPtr(1, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Call) SendResultsTo() Call_sendResultsTo { return Call_sendResultsTo(s) }

func (s Call_sendResultsTo) Which() Call_sendResultsTo_Which {
	return Call_sendResultsTo_Which(capnp.Struct(s).Uint16(6))
}
func (s Call_sendResultsTo) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Call_sendResultsTo) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Call_sendResultsTo) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Call_sendResultsTo) SetCaller() {
	capnp.Struct(s).SetUint16(6, 0)

}

func (s Call_sendResultsTo) SetYourself() {
	capnp.Struct(s).SetUint16(6, 1)

}

func (s Call_sendResultsTo) ThirdParty() (capnp.Ptr, error) {
	if capnp.Struct(s).Uint16(6) != 2 {
		panic("Which() != thirdParty")
	}
	return capnp.Struct(s).Ptr(2)
}

func (s Call_sendResultsTo) HasThirdParty() bool {
	if capnp.Struct(s).Uint16(6) != 2 {
		return false
	}
	return capnp.Struct(s).HasPtr(2)
}

func (s Call_sendResultsTo) SetThirdParty(v capnp.Ptr) error {
	capnp.Struct(s).SetUint16(6, 2)
	return capnp.Struct(s).SetPtr(2, v)
}

// Call_List is a list of Call.
type Call_List = capnp.StructList[Call]

// NewCall creates a new list of Call.
func NewCall_List(s *capnp.Segment, sz int32) (Call_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 24, PointerCount: 3}, sz)
	return capnp.StructList[Call](l), err
}

// Call_Future is a wrapper for a Call promised by a client call.
type Call_Future struct{ *capnp.Future }

func (f Call_Future) Struct() (Call, error) {
	p, err := f.Future.Ptr()
	return Call(p.Struct()), err
}
func (p Call_Future) Target() MessageTarget_Future {
	return MessageTarget_Future{Future: p.Future.Field(0, nil)}
}
func (p Call_Future) Params() Payload_Future {
	return Payload_Future{Future: p.Future.Field(1, nil)}
}
func (p Call_Future) SendResultsTo() Call_sendResultsTo_Future {
	return Call_sendResultsTo_Future{p.Future}
}

// Call_sendResultsTo_Future is a wrapper for a Call_sendResultsTo promised by a client call.
type Call_sendResultsTo_Future struct{ *capnp.Future }

func (f Call_sendResultsTo_Future) Struct() (Call_sendResultsTo, error) {
	p, err := f.Future.Ptr()
	return Call_sendResultsTo(p.Struct()), err
}
func (p Call_sendResultsTo_Future) ThirdParty() *capnp.Future {
	return p.Future.Field(2, nil)
}

type Return capnp.Struct
type Return_Which uint16

const (
	Return_Which_results               Return_Which = 0
	Return_Which_exception             Return_Which = 1
	Return_Which_canceled              Return_Which = 2
	Return_Which_resultsSentElsewhere  Return_Which = 3
	Return_Which_takeFromOtherQuestion Return_Which = 4
	Return_Which_awaitFromThirdParty   Return_Which = 5
)

func (w Return_Which) String() string {
	const s = "resultsexceptioncanceledresultsSentElsewheretakeFromOtherQuestionawaitFromThirdParty"
	switch w {
	case Return_Which_results:
		return s[0:7]
	case Return_Which_exception:
		return s[7:16]
	case Return_Which_canceled:
		return s[16:24]
	case Return_Which_resultsSentElsewhere:
		return s[24:44]
	case Return_Which_takeFromOtherQuestion:
		return s[44:65]
	case Return_Which_awaitFromThirdParty:
		return s[65:84]

	}
	return "Return_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// Return_TypeID is the unique identifier for the type Return.
const Return_TypeID = 0x9e19b28d3db3573a

func NewReturn(s *capnp.Segment) (Return, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1})
	return Return(st), err
}

func NewRootReturn(s *capnp.Segment) (Return, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1})
	return Return(st), err
}

func ReadRootReturn(msg *capnp.Message) (Return, error) {
	root, err := msg.Root()
	return Return(root.Struct()), err
}

func (s Return) String() string {
	str, _ := text.Marshal(0x9e19b28d3db3573a, capnp.Struct(s))
	return str
}

func (s Return) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Return) DecodeFromPtr(p capnp.Ptr) Return {
	return Return(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Return) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}

func (s Return) Which() Return_Which {
	return Return_Which(capnp.Struct(s).Uint16(6))
}
func (s Return) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Return) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Return) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Return) AnswerId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s Return) SetAnswerId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

func (s Return) ReleaseParamCaps() bool {
	return !capnp.Struct(s).Bit(32)
}

func (s Return) SetReleaseParamCaps(v bool) {
	capnp.Struct(s).SetBit(32, !v)
}

func (s Return) NoFinishNeeded() bool {
	return capnp.Struct(s).Bit(33)
}

func (s Return) SetNoFinishNeeded(v bool) {
	capnp.Struct(s).SetBit(33, v)
}

func (s Return) Results() (Payload, error) {
	if capnp.Struct(s).Uint16(6) != 0 {
		panic("Which() != results")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Payload(p.Struct()), err
}

func (s Return) HasResults() bool {
	if capnp.Struct(s).Uint16(6) != 0 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Return) SetResults(v Payload) error {
	capnp.Struct(s).SetUint16(6, 0)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewResults sets the results field to a newly
// allocated Payload struct, preferring placement in s's segment.
func (s Return) NewResults() (Payload, error) {
	capnp.Struct(s).SetUint16(6, 0)
	ss, err := NewPayload(capnp.Struct(s).Segment())
	if err != nil {
		return Payload{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Return) Exception() (Exception, error) {
	if capnp.Struct(s).Uint16(6) != 1 {
		panic("Which() != exception")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Exception(p.Struct()), err
}

func (s Return) HasException() bool {
	if capnp.Struct(s).Uint16(6) != 1 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Return) SetException(v Exception) error {
	capnp.Struct(s).SetUint16(6, 1)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewException sets the exception field to a newly
// allocated Exception struct, preferring placement in s's segment.
func (s Return) NewException() (Exception, error) {
	capnp.Struct(s).SetUint16(6, 1)
	ss, err := NewException(capnp.Struct(s).Segment())
	if err != nil {
		return Exception{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Return) SetCanceled() {
	capnp.Struct(s).SetUint16(6, 2)

}

func (s Return) SetResultsSentElsewhere() {
	capnp.Struct(s).SetUint16(6, 3)

}

func (s Return) TakeFromOtherQuestion() uint32 {
	if capnp.Struct(s).Uint16(6) != 4 {
		panic("Which() != takeFromOtherQuestion")
	}
	return capnp.Struct(s).Uint32(8)
}

func (s Return) SetTakeFromOtherQuestion(v uint32) {
	capnp.Struct(s).SetUint16(6, 4)
	capnp.Struct(s).SetUint32(8, v)
}

func (s Return) AwaitFromThirdParty() (capnp.Ptr, error) {
	if capnp.Struct(s).Uint16(6) != 5 {
		panic("Which() != awaitFromThirdParty")
	}
	return capnp.Struct(s).Ptr(0)
}

func (s Return) HasAwaitFromThirdParty() bool {
	if capnp.Struct(s).Uint16(6) != 5 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Return) SetAwaitFromThirdParty(v capnp.Ptr) error {
	capnp.Struct(s).SetUint16(6, 5)
	return capnp.Struct(s).SetPtr(0, v)
}

// Return_List is a list of Return.
type Return_List = capnp.StructList[Return]

// NewReturn creates a new list of Return.
func NewReturn_List(s *capnp.Segment, sz int32) (Return_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 16, PointerCount: 1}, sz)
	return capnp.StructList[Return](l), err
}

// Return_Future is a wrapper for a Return promised by a client call.
type Return_Future struct{ *capnp.Future }

func (f Return_Future) Struct() (Return, error) {
	p, err := f.Future.Ptr()
	return Return(p.Struct()), err
}
func (p Return_Future) Results() Payload_Future {
	return Payload_Future{Future: p.Future.Field(0, nil)}
}
func (p Return_Future) Exception() Exception_Future {
	return Exception_Future{Future: p.Future.Field(0, nil)}
}
func (p Return_Future) AwaitFromThirdParty() *capnp.Future {
	return p.Future.Field(0, nil)
}

type Finish capnp.Struct

// Finish_TypeID is the unique identifier for the type Finish.
const Finish_TypeID = 0xd37d2eb2c2f80e63

func NewFinish(s *capnp.Segment) (Finish, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return Finish(st), err
}

func NewRootFinish(s *capnp.Segment) (Finish, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return Finish(st), err
}

func ReadRootFinish(msg *capnp.Message) (Finish, error) {
	root, err := msg.Root()
	return Finish(root.Struct()), err
}

func (s Finish) String() string {
	str, _ := text.Marshal(0xd37d2eb2c2f80e63, capnp.Struct(s))
	return str
}

func (s Finish) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Finish) DecodeFromPtr(p capnp.Ptr) Finish {
	return Finish(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Finish) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Finish) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Finish) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Finish) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Finish) QuestionId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s Finish) SetQuestionId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

func (s Finish) ReleaseResultCaps() bool {
	return !capnp.Struct(s).Bit(32)
}

func (s Finish) SetReleaseResultCaps(v bool) {
	capnp.Struct(s).SetBit(32, !v)
}

func (s Finish) RequireEarlyCancellationWorkaround() bool {
	return !capnp.Struct(s).Bit(33)
}

func (s Finish) SetRequireEarlyCancellationWorkaround(v bool) {
	capnp.Struct(s).SetBit(33, !v)
}

// Finish_List is a list of Finish.
type Finish_List = capnp.StructList[Finish]

// NewFinish creates a new list of Finish.
func NewFinish_List(s *capnp.Segment, sz int32) (Finish_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0}, sz)
	return capnp.StructList[Finish](l), err
}

// Finish_Future is a wrapper for a Finish promised by a client call.
type Finish_Future struct{ *capnp.Future }

func (f Finish_Future) Struct() (Finish, error) {
	p, err := f.Future.Ptr()
	return Finish(p.Struct()), err
}

type Resolve capnp.Struct
type Resolve_Which uint16

const (
	Resolve_Which_cap       Resolve_Which = 0
	Resolve_Which_exception Resolve_Which = 1
)

func (w Resolve_Which) String() string {
	const s = "capexception"
	switch w {
	case Resolve_Which_cap:
		return s[0:3]
	case Resolve_Which_exception:
		return s[3:12]

	}
	return "Resolve_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// Resolve_TypeID is the unique identifier for the type Resolve.
const Resolve_TypeID = 0xbbc29655fa89086e

func NewResolve(s *capnp.Segment) (Resolve, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Resolve(st), err
}

func NewRootResolve(s *capnp.Segment) (Resolve, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Resolve(st), err
}

func ReadRootResolve(msg *capnp.Message) (Resolve, error) {
	root, err := msg.Root()
	return Resolve(root.Struct()), err
}

func (s Resolve) String() string {
	str, _ := text.Marshal(0xbbc29655fa89086e, capnp.Struct(s))
	return str
}

func (s Resolve) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Resolve) DecodeFromPtr(p capnp.Ptr) Resolve {
	return Resolve(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Resolve) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}

func (s Resolve) Which() Resolve_Which {
	return Resolve_Which(capnp.Struct(s).Uint16(4))
}
func (s Resolve) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Resolve) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Resolve) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Resolve) PromiseId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s Resolve) SetPromiseId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

func (s Resolve) Cap() (CapDescriptor, error) {
	if capnp.Struct(s).Uint16(4) != 0 {
		panic("Which() != cap")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return CapDescriptor(p.Struct()), err
}

func (s Resolve) HasCap() bool {
	if capnp.Struct(s).Uint16(4) != 0 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Resolve) SetCap(v CapDescriptor) error {
	capnp.Struct(s).SetUint16(4, 0)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewCap sets the cap field to a newly
// allocated CapDescriptor struct, preferring placement in s's segment.
func (s Resolve) NewCap() (CapDescriptor, error) {
	capnp.Struct(s).SetUint16(4, 0)
	ss, err := NewCapDescriptor(capnp.Struct(s).Segment())
	if err != nil {
		return CapDescriptor{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Resolve) Exception() (Exception, error) {
	if capnp.Struct(s).Uint16(4) != 1 {
		panic("Which() != exception")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return Exception(p.Struct()), err
}

func (s Resolve) HasException() bool {
	if capnp.Struct(s).Uint16(4) != 1 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s Resolve) SetException(v Exception) error {
	capnp.Struct(s).SetUint16(4, 1)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewException sets the exception field to a newly
// allocated Exception struct, preferring placement in s's segment.
func (s Resolve) NewException() (Exception, error) {
	capnp.Struct(s).SetUint16(4, 1)
	ss, err := NewException(capnp.Struct(s).Segment())
	if err != nil {
		return Exception{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// Resolve_List is a list of Resolve.
type Resolve_List = capnp.StructList[Resolve]

// NewResolve creates a new list of Resolve.
func NewResolve_List(s *capnp.Segment, sz int32) (Resolve_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[Resolve](l), err
}

// Resolve_Future is a wrapper for a Resolve promised by a client call.
type Resolve_Future struct{ *capnp.Future }

func (f Resolve_Future) Struct() (Resolve, error) {
	p, err := f.Future.Ptr()
	return Resolve(p.Struct()), err
}
func (p Resolve_Future) Cap() CapDescriptor_Future {
	return CapDescriptor_Future{Future: p.Future.Field(0, nil)}
}
func (p Resolve_Future) Exception() Exception_Future {
	return Exception_Future{Future: p.Future.Field(0, nil)}
}

type Release capnp.Struct

// Release_TypeID is the unique identifier for the type Release.
const Release_TypeID = 0xad1a6c0d7dd07497

func NewRelease(s *capnp.Segment) (Release, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return Release(st), err
}

func NewRootRelease(s *capnp.Segment) (Release, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return Release(st), err
}

func ReadRootRelease(msg *capnp.Message) (Release, error) {
	root, err := msg.Root()
	return Release(root.Struct()), err
}

func (s Release) String() string {
	str, _ := text.Marshal(0xad1a6c0d7dd07497, capnp.Struct(s))
	return str
}

func (s Release) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Release) DecodeFromPtr(p capnp.Ptr) Release {
	return Release(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Release) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Release) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Release) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Release) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Release) Id() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s Release) SetId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

func (s Release) ReferenceCount() uint32 {
	return capnp.Struct(s).Uint32(4)
}

func (s Release) SetReferenceCount(v uint32) {
	capnp.Struct(s).SetUint32(4, v)
}

// Release_List is a list of Release.
type Release_List = capnp.StructList[Release]

// NewRelease creates a new list of Release.
func NewRelease_List(s *capnp.Segment, sz int32) (Release_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0}, sz)
	return capnp.StructList[Release](l), err
}

// Release_Future is a wrapper for a Release promised by a client call.
type Release_Future struct{ *capnp.Future }

func (f Release_Future) Struct() (Release, error) {
	p, err := f.Future.Ptr()
	return Release(p.Struct()), err
}

type Disembargo capnp.Struct
type Disembargo_context Disembargo
type Disembargo_context_Which uint16

const (
	Disembargo_context_Which_senderLoopback   Disembargo_context_Which = 0
	Disembargo_context_Which_receiverLoopback Disembargo_context_Which = 1
	Disembargo_context_Which_accept           Disembargo_context_Which = 2
)

func (w Disembargo_context_Which) String() string {
	const s = "senderLoopbackreceiverLoopbackaccept"
	switch w {
	case Disembargo_context_Which_senderLoopback:
		return s[0:14]
	case Disembargo_context_Which_receiverLoopback:
		return s[14:30]
	case Disembargo_context_Which_accept:
		return s[30:36]

	}
	return "Disembargo_context_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// Disembargo_TypeID is the unique identifier for the type Disembargo.
const Disembargo_TypeID = 0xf964368b0fbd3711

func NewDisembargo(s *capnp.Segment) (Disembargo, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Disembargo(st), err
}

func NewRootDisembargo(s *capnp.Segment) (Disembargo, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Disembargo(st), err
}

func ReadRootDisembargo(msg *capnp.Message) (Disembargo, error) {
	root, err := msg.Root()
	return Disembargo(root.Struct()), err
}

func (s Disembargo) String() string {
	str, _ := text.Marshal(0xf964368b0fbd3711, capnp.Struct(s))
	return str
}

func (s Disembargo) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Disembargo) DecodeFromPtr(p capnp.Ptr) Disembargo {
	return Disembargo(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Disembargo) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Disembargo) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Disembargo) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Disembargo) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Disembargo) Target() (MessageTarget, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return MessageTarget(p.Struct()), err
}

func (s Disembargo) HasTarget() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Disembargo) SetTarget(v MessageTarget) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewTarget sets the target field to a newly
// allocated MessageTarget struct, preferring placement in s's segment.
func (s Disembargo) NewTarget() (MessageTarget, error) {
	ss, err := NewMessageTarget(capnp.Struct(s).Segment())
	if err != nil {
		return MessageTarget{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Disembargo) Context() Disembargo_context { return Disembargo_context(s) }

func (s Disembargo_context) Which() Disembargo_context_Which {
	return Disembargo_context_Which(capnp.Struct(s).Uint16(4))
}
func (s Disembargo_context) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Disembargo_context) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Disembargo_context) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Disembargo_context) SenderLoopback() uint32 {
	if capnp.Struct(s).Uint16(4) != 0 {
		panic("Which() != senderLoopback")
	}
	return capnp.Struct(s).Uint32(0)
}

func (s Disembargo_context) SetSenderLoopback(v uint32) {
	capnp.Struct(s).SetUint16(4, 0)
	capnp.Struct(s).SetUint32(0, v)
}

func (s Disembargo_context) ReceiverLoopback() uint32 {
	if capnp.Struct(s).Uint16(4) != 1 {
		panic("Which() != receiverLoopback")
	}
	return capnp.Struct(s).Uint32(0)
}

func (s Disembargo_context) SetReceiverLoopback(v uint32) {
	capnp.Struct(s).SetUint16(4, 1)
	capnp.Struct(s).SetUint32(0, v)
}

func (s Disembargo_context) Accept() ([]byte, error) {
	if capnp.Struct(s).Uint16(4) != 2 {
		panic("Which() != accept")
	}
	p, err := capnp.Struct(s).Ptr(1)
	return []byte(p.Data()), err
}

func (s Disembargo_context) HasAccept() bool {
	if capnp.Struct(s).Uint16(4) != 2 {
		return false
	}
	return capnp.Struct(s).HasPtr(1)
}

func (s Disembargo_context) SetAccept(v []byte) error {
	capnp.Struct(s).SetUint16(4, 2)
	return capnp.Struct(s).SetData(1, v)
}

// Disembargo_List is a list of Disembargo.
type Disembargo_List = capnp.StructList[Disembargo]

// NewDisembargo creates a new list of Disembargo.
func NewDisembargo_List(s *capnp.Segment, sz int32) (Disembargo_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2}, sz)
	return capnp.StructList[Disembargo](l), err
}

// Disembargo_Future is a wrapper for a Disembargo promised by a client call.
type Disembargo_Future struct{ *capnp.Future }

func (f Disembargo_Future) Struct() (Disembargo, error) {
	p, err := f.Future.Ptr()
	return Disembargo(p.Struct()), err
}
func (p Disembargo_Future) Target() MessageTarget_Future {
	return MessageTarget_Future{Future: p.Future.Field(0, nil)}
}
func (p Disembargo_Future) Context() Disembargo_context_Future {
	return Disembargo_context_Future{p.Future}
}

// Disembargo_context_Future is a wrapper for a Disembargo_context promised by a client call.
type Disembargo_context_Future struct{ *capnp.Future }

func (f Disembargo_context_Future) Struct() (Disembargo_context, error) {
	p, err := f.Future.Ptr()
	return Disembargo_context(p.Struct()), err
}

type Provide capnp.Struct

// Provide_TypeID is the unique identifier for the type Provide.
const Provide_TypeID = 0x9c6a046bfbc1ac5a

func NewProvide(s *capnp.Segment) (Provide, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Provide(st), err
}

func NewRootProvide(s *capnp.Segment) (Provide, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Provide(st), err
}

func ReadRootProvide(msg *capnp.Message) (Provide, error) {
	root, err := msg.Root()
	return Provide(root.Struct()), err
}

func (s Provide) String() string {
	str, _ := text.Marshal(0x9c6a046bfbc1ac5a, capnp.Struct(s))
	return str
}

func (s Provide) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Provide) DecodeFromPtr(p capnp.Ptr) Provide {
	return Provide(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Provide) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Provide) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Provide) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Provide) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Provide) QuestionId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s Provide) SetQuestionId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

func (s Provide) Target() (MessageTarget, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return MessageTarget(p.Struct()), err
}

func (s Provide) HasTarget() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Provide) SetTarget(v MessageTarget) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewTarget sets the target field to a newly
// allocated MessageTarget struct, preferring placement in s's segment.
func (s Provide) NewTarget() (MessageTarget, error) {
	ss, err := NewMessageTarget(capnp.Struct(s).Segment())
	if err != nil {
		return MessageTarget{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Provide) Recipient() (capnp.Ptr, error) {
	return capnp.Struct(s).Ptr(1)
}

func (s Provide) HasRecipient() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Provide) SetRecipient(v capnp.Ptr) error {
	return capnp.Struct(s).SetPtr(1, v)
}

// Provide_List is a list of Provide.
type Provide_List = capnp.StructList[Provide]

// NewProvide creates a new list of Provide.
func NewProvide_List(s *capnp.Segment, sz int32) (Provide_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2}, sz)
	return capnp.StructList[Provide](l), err
}

// Provide_Future is a wrapper for a Provide promised by a client call.
type Provide_Future struct{ *capnp.Future }

func (f Provide_Future) Struct() (Provide, error) {
	p, err := f.Future.Ptr()
	return Provide(p.Struct()), err
}
func (p Provide_Future) Target() MessageTarget_Future {
	return MessageTarget_Future{Future: p.Future.Field(0, nil)}
}
func (p Provide_Future) Recipient() *capnp.Future {
	return p.Future.Field(1, nil)
}

type Accept capnp.Struct

// Accept_TypeID is the unique identifier for the type Accept.
const Accept_TypeID = 0xd4c9b56290554016

func NewAccept(s *capnp.Segment) (Accept, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Accept(st), err
}

func NewRootAccept(s *capnp.Segment) (Accept, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Accept(st), err
}

func ReadRootAccept(msg *capnp.Message) (Accept, error) {
	root, err := msg.Root()
	return Accept(root.Struct()), err
}

func (s Accept) String() string {
	str, _ := text.Marshal(0xd4c9b56290554016, capnp.Struct(s))
	return str
}

func (s Accept) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Accept) DecodeFromPtr(p capnp.Ptr) Accept {
	return Accept(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Accept) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Accept) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Accept) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Accept) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Accept) QuestionId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s Accept) SetQuestionId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

func (s Accept) Provision() (capnp.Ptr, error) {
	return capnp.Struct(s).Ptr(0)
}

func (s Accept) HasProvision() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Accept) SetProvision(v capnp.Ptr) error {
	return capnp.Struct(s).SetPtr(0, v)
}
func (s Accept) Embargo() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return []byte(p.Data()), err
}

func (s Accept) HasEmbargo() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Accept) SetEmbargo(v []byte) error {
	return capnp.Struct(s).SetData(1, v)
}

// Accept_List is a list of Accept.
type Accept_List = capnp.StructList[Accept]

// NewAccept creates a new list of Accept.
func NewAccept_List(s *capnp.Segment, sz int32) (Accept_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2}, sz)
	return capnp.StructList[Accept](l), err
}

// Accept_Future is a wrapper for a Accept promised by a client call.
type Accept_Future struct{ *capnp.Future }

func (f Accept_Future) Struct() (Accept, error) {
	p, err := f.Future.Ptr()
	return Accept(p.Struct()), err
}
func (p Accept_Future) Provision() *capnp.Future {
	return p.Future.Field(0, nil)
}

type ThirdPartyAnswer capnp.Struct

// ThirdPartyAnswer_TypeID is the unique identifier for the type ThirdPartyAnswer.
const ThirdPartyAnswer_TypeID = 0xb6511ce6c5f0e58c

func NewThirdPartyAnswer(s *capnp.Segment) (ThirdPartyAnswer, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return ThirdPartyAnswer(st), err
}

func NewRootThirdPartyAnswer(s *capnp.Segment) (ThirdPartyAnswer, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return ThirdPartyAnswer(st), err
}

func ReadRootThirdPartyAnswer(msg *capnp.Message) (ThirdPartyAnswer, error) {
	root, err := msg.Root()
	return ThirdPartyAnswer(root.Struct()), err
}

func (s ThirdPartyAnswer) String() string {
	str, _ := text.Marshal(0xb6511ce6c5f0e58c, capnp.Struct(s))
	return str
}

func (s ThirdPartyAnswer) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (ThirdPartyAnswer) DecodeFromPtr(p capnp.Ptr) ThirdPartyAnswer {
	return ThirdPartyAnswer(capnp.Struct{}.DecodeFromPtr(p))
}

func (s ThirdPartyAnswer) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s ThirdPartyAnswer) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s ThirdPartyAnswer) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s ThirdPartyAnswer) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s ThirdPartyAnswer) Completion() (capnp.Ptr, error) {
	return capnp.Struct(s).Ptr(0)
}

func (s ThirdPartyAnswer) HasCompletion() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s ThirdPartyAnswer) SetCompletion(v capnp.Ptr) error {
	return capnp.Struct(s).SetPtr(0, v)
}
func (s ThirdPartyAnswer) AnswerId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s ThirdPartyAnswer) SetAnswerId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

// ThirdPartyAnswer_List is a list of ThirdPartyAnswer.
type ThirdPartyAnswer_List = capnp.StructList[ThirdPartyAnswer]

// NewThirdPartyAnswer creates a new list of ThirdPartyAnswer.
func NewThirdPartyAnswer_List(s *capnp.Segment, sz int32) (ThirdPartyAnswer_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[ThirdPartyAnswer](l), err
}

// ThirdPartyAnswer_Future is a wrapper for a ThirdPartyAnswer promised by a client call.
type ThirdPartyAnswer_Future struct{ *capnp.Future }

func (f ThirdPartyAnswer_Future) Struct() (ThirdPartyAnswer, error) {
	p, err := f.Future.Ptr()
	return ThirdPartyAnswer(p.Struct()), err
}
func (p ThirdPartyAnswer_Future) Completion() *capnp.Future {
	return p.Future.Field(0, nil)
}

type Join capnp.Struct

// Join_TypeID is the unique identifier for the type Join.
const Join_TypeID = 0xfbe1980490e001af

func NewJoin(s *capnp.Segment) (Join, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Join(st), err
}

func NewRootJoin(s *capnp.Segment) (Join, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2})
	return Join(st), err
}

func ReadRootJoin(msg *capnp.Message) (Join, error) {
	root, err := msg.Root()
	return Join(root.Struct()), err
}

func (s Join) String() string {
	str, _ := text.Marshal(0xfbe1980490e001af, capnp.Struct(s))
	return str
}

func (s Join) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Join) DecodeFromPtr(p capnp.Ptr) Join {
	return Join(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Join) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Join) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Join) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Join) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Join) QuestionId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s Join) SetQuestionId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

func (s Join) Target() (MessageTarget, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return MessageTarget(p.Struct()), err
}

func (s Join) HasTarget() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Join) SetTarget(v MessageTarget) error {
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewTarget sets the target field to a newly
// allocated MessageTarget struct, preferring placement in s's segment.
func (s Join) NewTarget() (MessageTarget, error) {
	ss, err := NewMessageTarget(capnp.Struct(s).Segment())
	if err != nil {
		return MessageTarget{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s Join) KeyPart() (capnp.Ptr, error) {
	return capnp.Struct(s).Ptr(1)
}

func (s Join) HasKeyPart() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Join) SetKeyPart(v capnp.Ptr) error {
	return capnp.Struct(s).SetPtr(1, v)
}

// Join_List is a list of Join.
type Join_List = capnp.StructList[Join]

// NewJoin creates a new list of Join.
func NewJoin_List(s *capnp.Segment, sz int32) (Join_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 2}, sz)
	return capnp.StructList[Join](l), err
}

// Join_Future is a wrapper for a Join promised by a client call.
type Join_Future struct{ *capnp.Future }

func (f Join_Future) Struct() (Join, error) {
	p, err := f.Future.Ptr()
	return Join(p.Struct()), err
}
func (p Join_Future) Target() MessageTarget_Future {
	return MessageTarget_Future{Future: p.Future.Field(0, nil)}
}
func (p Join_Future) KeyPart() *capnp.Future {
	return p.Future.Field(1, nil)
}

type MessageTarget capnp.Struct
type MessageTarget_Which uint16

const (
	MessageTarget_Which_importedCap    MessageTarget_Which = 0
	MessageTarget_Which_promisedAnswer MessageTarget_Which = 1
)

func (w MessageTarget_Which) String() string {
	const s = "importedCappromisedAnswer"
	switch w {
	case MessageTarget_Which_importedCap:
		return s[0:11]
	case MessageTarget_Which_promisedAnswer:
		return s[11:25]

	}
	return "MessageTarget_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// MessageTarget_TypeID is the unique identifier for the type MessageTarget.
const MessageTarget_TypeID = 0x95bc14545813fbc1

func NewMessageTarget(s *capnp.Segment) (MessageTarget, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return MessageTarget(st), err
}

func NewRootMessageTarget(s *capnp.Segment) (MessageTarget, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return MessageTarget(st), err
}

func ReadRootMessageTarget(msg *capnp.Message) (MessageTarget, error) {
	root, err := msg.Root()
	return MessageTarget(root.Struct()), err
}

func (s MessageTarget) String() string {
	str, _ := text.Marshal(0x95bc14545813fbc1, capnp.Struct(s))
	return str
}

func (s MessageTarget) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (MessageTarget) DecodeFromPtr(p capnp.Ptr) MessageTarget {
	return MessageTarget(capnp.Struct{}.DecodeFromPtr(p))
}

func (s MessageTarget) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}

func (s MessageTarget) Which() MessageTarget_Which {
	return MessageTarget_Which(capnp.Struct(s).Uint16(4))
}
func (s MessageTarget) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s MessageTarget) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s MessageTarget) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s MessageTarget) ImportedCap() uint32 {
	if capnp.Struct(s).Uint16(4) != 0 {
		panic("Which() != importedCap")
	}
	return capnp.Struct(s).Uint32(0)
}

func (s MessageTarget) SetImportedCap(v uint32) {
	capnp.Struct(s).SetUint16(4, 0)
	capnp.Struct(s).SetUint32(0, v)
}

func (s MessageTarget) PromisedAnswer() (PromisedAnswer, error) {
	if capnp.Struct(s).Uint16(4) != 1 {
		panic("Which() != promisedAnswer")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return PromisedAnswer(p.Struct()), err
}

func (s MessageTarget) HasPromisedAnswer() bool {
	if capnp.Struct(s).Uint16(4) != 1 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s MessageTarget) SetPromisedAnswer(v PromisedAnswer) error {
	capnp.Struct(s).SetUint16(4, 1)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewPromisedAnswer sets the promisedAnswer field to a newly
// allocated PromisedAnswer struct, preferring placement in s's segment.
func (s MessageTarget) NewPromisedAnswer() (PromisedAnswer, error) {
	capnp.Struct(s).SetUint16(4, 1)
	ss, err := NewPromisedAnswer(capnp.Struct(s).Segment())
	if err != nil {
		return PromisedAnswer{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

// MessageTarget_List is a list of MessageTarget.
type MessageTarget_List = capnp.StructList[MessageTarget]

// NewMessageTarget creates a new list of MessageTarget.
func NewMessageTarget_List(s *capnp.Segment, sz int32) (MessageTarget_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[MessageTarget](l), err
}

// MessageTarget_Future is a wrapper for a MessageTarget promised by a client call.
type MessageTarget_Future struct{ *capnp.Future }

func (f MessageTarget_Future) Struct() (MessageTarget, error) {
	p, err := f.Future.Ptr()
	return MessageTarget(p.Struct()), err
}
func (p MessageTarget_Future) PromisedAnswer() PromisedAnswer_Future {
	return PromisedAnswer_Future{Future: p.Future.Field(0, nil)}
}

type Payload capnp.Struct

// Payload_TypeID is the unique identifier for the type Payload.
const Payload_TypeID = 0x9a0e61223d96743b

func NewPayload(s *capnp.Segment) (Payload, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return Payload(st), err
}

func NewRootPayload(s *capnp.Segment) (Payload, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2})
	return Payload(st), err
}

func ReadRootPayload(msg *capnp.Message) (Payload, error) {
	root, err := msg.Root()
	return Payload(root.Struct()), err
}

func (s Payload) String() string {
	str, _ := text.Marshal(0x9a0e61223d96743b, capnp.Struct(s))
	return str
}

func (s Payload) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Payload) DecodeFromPtr(p capnp.Ptr) Payload {
	return Payload(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Payload) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Payload) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Payload) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Payload) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Payload) Content() (capnp.Ptr, error) {
	return capnp.Struct(s).Ptr(0)
}

func (s Payload) HasContent() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Payload) SetContent(v capnp.Ptr) error {
	return capnp.Struct(s).SetPtr(0, v)
}
func (s Payload) CapTable() (CapDescriptor_List, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return CapDescriptor_List(p.List()), err
}

func (s Payload) HasCapTable() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Payload) SetCapTable(v CapDescriptor_List) error {
	return capnp.Struct(s).SetPtr(1, v.ToPtr())
}

// NewCapTable sets the capTable field to a newly
// allocated CapDescriptor_List, preferring placement in s's segment.
func (s Payload) NewCapTable(n int32) (CapDescriptor_List, error) {
	l, err := NewCapDescriptor_List(capnp.Struct(s).Segment(), n)
	if err != nil {
		return CapDescriptor_List{}, err
	}
	err = capnp.Struct(s).SetPtr(1, l.ToPtr())
	return l, err
}

// Payload_List is a list of Payload.
type Payload_List = capnp.StructList[Payload]

// NewPayload creates a new list of Payload.
func NewPayload_List(s *capnp.Segment, sz int32) (Payload_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 0, PointerCount: 2}, sz)
	return capnp.StructList[Payload](l), err
}

// Payload_Future is a wrapper for a Payload promised by a client call.
type Payload_Future struct{ *capnp.Future }

func (f Payload_Future) Struct() (Payload, error) {
	p, err := f.Future.Ptr()
	return Payload(p.Struct()), err
}
func (p Payload_Future) Content() *capnp.Future {
	return p.Future.Field(0, nil)
}

type CapDescriptor capnp.Struct
type CapDescriptor_Which uint16

const (
	CapDescriptor_Which_none             CapDescriptor_Which = 0
	CapDescriptor_Which_senderHosted     CapDescriptor_Which = 1
	CapDescriptor_Which_senderPromise    CapDescriptor_Which = 2
	CapDescriptor_Which_receiverHosted   CapDescriptor_Which = 3
	CapDescriptor_Which_receiverAnswer   CapDescriptor_Which = 4
	CapDescriptor_Which_thirdPartyHosted CapDescriptor_Which = 5
)

func (w CapDescriptor_Which) String() string {
	const s = "nonesenderHostedsenderPromisereceiverHostedreceiverAnswerthirdPartyHosted"
	switch w {
	case CapDescriptor_Which_none:
		return s[0:4]
	case CapDescriptor_Which_senderHosted:
		return s[4:16]
	case CapDescriptor_Which_senderPromise:
		return s[16:29]
	case CapDescriptor_Which_receiverHosted:
		return s[29:43]
	case CapDescriptor_Which_receiverAnswer:
		return s[43:57]
	case CapDescriptor_Which_thirdPartyHosted:
		return s[57:73]

	}
	return "CapDescriptor_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// CapDescriptor_TypeID is the unique identifier for the type CapDescriptor.
const CapDescriptor_TypeID = 0x8523ddc40b86b8b0

func NewCapDescriptor(s *capnp.Segment) (CapDescriptor, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return CapDescriptor(st), err
}

func NewRootCapDescriptor(s *capnp.Segment) (CapDescriptor, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return CapDescriptor(st), err
}

func ReadRootCapDescriptor(msg *capnp.Message) (CapDescriptor, error) {
	root, err := msg.Root()
	return CapDescriptor(root.Struct()), err
}

func (s CapDescriptor) String() string {
	str, _ := text.Marshal(0x8523ddc40b86b8b0, capnp.Struct(s))
	return str
}

func (s CapDescriptor) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (CapDescriptor) DecodeFromPtr(p capnp.Ptr) CapDescriptor {
	return CapDescriptor(capnp.Struct{}.DecodeFromPtr(p))
}

func (s CapDescriptor) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}

func (s CapDescriptor) Which() CapDescriptor_Which {
	return CapDescriptor_Which(capnp.Struct(s).Uint16(0))
}
func (s CapDescriptor) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s CapDescriptor) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s CapDescriptor) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s CapDescriptor) SetNone() {
	capnp.Struct(s).SetUint16(0, 0)

}

func (s CapDescriptor) SenderHosted() uint32 {
	if capnp.Struct(s).Uint16(0) != 1 {
		panic("Which() != senderHosted")
	}
	return capnp.Struct(s).Uint32(4)
}

func (s CapDescriptor) SetSenderHosted(v uint32) {
	capnp.Struct(s).SetUint16(0, 1)
	capnp.Struct(s).SetUint32(4, v)
}

func (s CapDescriptor) SenderPromise() uint32 {
	if capnp.Struct(s).Uint16(0) != 2 {
		panic("Which() != senderPromise")
	}
	return capnp.Struct(s).Uint32(4)
}

func (s CapDescriptor) SetSenderPromise(v uint32) {
	capnp.Struct(s).SetUint16(0, 2)
	capnp.Struct(s).SetUint32(4, v)
}

func (s CapDescriptor) ReceiverHosted() uint32 {
	if capnp.Struct(s).Uint16(0) != 3 {
		panic("Which() != receiverHosted")
	}
	return capnp.Struct(s).Uint32(4)
}

func (s CapDescriptor) SetReceiverHosted(v uint32) {
	capnp.Struct(s).SetUint16(0, 3)
	capnp.Struct(s).SetUint32(4, v)
}

func (s CapDescriptor) ReceiverAnswer() (PromisedAnswer, error) {
	if capnp.Struct(s).Uint16(0) != 4 {
		panic("Which() != receiverAnswer")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return PromisedAnswer(p.Struct()), err
}

func (s CapDescriptor) HasReceiverAnswer() bool {
	if capnp.Struct(s).Uint16(0) != 4 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s CapDescriptor) SetReceiverAnswer(v PromisedAnswer) error {
	capnp.Struct(s).SetUint16(0, 4)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewReceiverAnswer sets the receiverAnswer field to a newly
// allocated PromisedAnswer struct, preferring placement in s's segment.
func (s CapDescriptor) NewReceiverAnswer() (PromisedAnswer, error) {
	capnp.Struct(s).SetUint16(0, 4)
	ss, err := NewPromisedAnswer(capnp.Struct(s).Segment())
	if err != nil {
		return PromisedAnswer{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s CapDescriptor) ThirdPartyHosted() (ThirdPartyCapDescriptor, error) {
	if capnp.Struct(s).Uint16(0) != 5 {
		panic("Which() != thirdPartyHosted")
	}
	p, err := capnp.Struct(s).Ptr(0)
	return ThirdPartyCapDescriptor(p.Struct()), err
}

func (s CapDescriptor) HasThirdPartyHosted() bool {
	if capnp.Struct(s).Uint16(0) != 5 {
		return false
	}
	return capnp.Struct(s).HasPtr(0)
}

func (s CapDescriptor) SetThirdPartyHosted(v ThirdPartyCapDescriptor) error {
	capnp.Struct(s).SetUint16(0, 5)
	return capnp.Struct(s).SetPtr(0, capnp.Struct(v).ToPtr())
}

// NewThirdPartyHosted sets the thirdPartyHosted field to a newly
// allocated ThirdPartyCapDescriptor struct, preferring placement in s's segment.
func (s CapDescriptor) NewThirdPartyHosted() (ThirdPartyCapDescriptor, error) {
	capnp.Struct(s).SetUint16(0, 5)
	ss, err := NewThirdPartyCapDescriptor(capnp.Struct(s).Segment())
	if err != nil {
		return ThirdPartyCapDescriptor{}, err
	}
	err = capnp.Struct(s).SetPtr(0, capnp.Struct(ss).ToPtr())
	return ss, err
}

func (s CapDescriptor) AttachedFd() uint8 {
	return capnp.Struct(s).Uint8(2) ^ 255
}

func (s CapDescriptor) SetAttachedFd(v uint8) {
	capnp.Struct(s).SetUint8(2, v^255)
}

// CapDescriptor_List is a list of CapDescriptor.
type CapDescriptor_List = capnp.StructList[CapDescriptor]

// NewCapDescriptor creates a new list of CapDescriptor.
func NewCapDescriptor_List(s *capnp.Segment, sz int32) (CapDescriptor_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[CapDescriptor](l), err
}

// CapDescriptor_Future is a wrapper for a CapDescriptor promised by a client call.
type CapDescriptor_Future struct{ *capnp.Future }

func (f CapDescriptor_Future) Struct() (CapDescriptor, error) {
	p, err := f.Future.Ptr()
	return CapDescriptor(p.Struct()), err
}
func (p CapDescriptor_Future) ReceiverAnswer() PromisedAnswer_Future {
	return PromisedAnswer_Future{Future: p.Future.Field(0, nil)}
}
func (p CapDescriptor_Future) ThirdPartyHosted() ThirdPartyCapDescriptor_Future {
	return ThirdPartyCapDescriptor_Future{Future: p.Future.Field(0, nil)}
}

type PromisedAnswer capnp.Struct

// PromisedAnswer_TypeID is the unique identifier for the type PromisedAnswer.
const PromisedAnswer_TypeID = 0xd800b1d6cd6f1ca0

func NewPromisedAnswer(s *capnp.Segment) (PromisedAnswer, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return PromisedAnswer(st), err
}

func NewRootPromisedAnswer(s *capnp.Segment) (PromisedAnswer, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return PromisedAnswer(st), err
}

func ReadRootPromisedAnswer(msg *capnp.Message) (PromisedAnswer, error) {
	root, err := msg.Root()
	return PromisedAnswer(root.Struct()), err
}

func (s PromisedAnswer) String() string {
	str, _ := text.Marshal(0xd800b1d6cd6f1ca0, capnp.Struct(s))
	return str
}

func (s PromisedAnswer) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (PromisedAnswer) DecodeFromPtr(p capnp.Ptr) PromisedAnswer {
	return PromisedAnswer(capnp.Struct{}.DecodeFromPtr(p))
}

func (s PromisedAnswer) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s PromisedAnswer) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s PromisedAnswer) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s PromisedAnswer) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s PromisedAnswer) QuestionId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s PromisedAnswer) SetQuestionId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

func (s PromisedAnswer) Transform() (PromisedAnswer_Op_List, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return PromisedAnswer_Op_List(p.List()), err
}

func (s PromisedAnswer) HasTransform() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s PromisedAnswer) SetTransform(v PromisedAnswer_Op_List) error {
	return capnp.Struct(s).SetPtr(0, v.ToPtr())
}

// NewTransform sets the transform field to a newly
// allocated PromisedAnswer_Op_List, preferring placement in s's segment.
func (s PromisedAnswer) NewTransform(n int32) (PromisedAnswer_Op_List, error) {
	l, err := NewPromisedAnswer_Op_List(capnp.Struct(s).Segment(), n)
	if err != nil {
		return PromisedAnswer_Op_List{}, err
	}
	err = capnp.Struct(s).SetPtr(0, l.ToPtr())
	return l, err
}

// PromisedAnswer_List is a list of PromisedAnswer.
type PromisedAnswer_List = capnp.StructList[PromisedAnswer]

// NewPromisedAnswer creates a new list of PromisedAnswer.
func NewPromisedAnswer_List(s *capnp.Segment, sz int32) (PromisedAnswer_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[PromisedAnswer](l), err
}

// PromisedAnswer_Future is a wrapper for a PromisedAnswer promised by a client call.
type PromisedAnswer_Future struct{ *capnp.Future }

func (f PromisedAnswer_Future) Struct() (PromisedAnswer, error) {
	p, err := f.Future.Ptr()
	return PromisedAnswer(p.Struct()), err
}

type PromisedAnswer_Op capnp.Struct
type PromisedAnswer_Op_Which uint16

const (
	PromisedAnswer_Op_Which_noop            PromisedAnswer_Op_Which = 0
	PromisedAnswer_Op_Which_getPointerField PromisedAnswer_Op_Which = 1
)

func (w PromisedAnswer_Op_Which) String() string {
	const s = "noopgetPointerField"
	switch w {
	case PromisedAnswer_Op_Which_noop:
		return s[0:4]
	case PromisedAnswer_Op_Which_getPointerField:
		return s[4:19]

	}
	return "PromisedAnswer_Op_Which(" + strconv.FormatUint(uint64(w), 10) + ")"
}

// PromisedAnswer_Op_TypeID is the unique identifier for the type PromisedAnswer_Op.
const PromisedAnswer_Op_TypeID = 0xf316944415569081

func NewPromisedAnswer_Op(s *capnp.Segment) (PromisedAnswer_Op, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return PromisedAnswer_Op(st), err
}

func NewRootPromisedAnswer_Op(s *capnp.Segment) (PromisedAnswer_Op, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0})
	return PromisedAnswer_Op(st), err
}

func ReadRootPromisedAnswer_Op(msg *capnp.Message) (PromisedAnswer_Op, error) {
	root, err := msg.Root()
	return PromisedAnswer_Op(root.Struct()), err
}

func (s PromisedAnswer_Op) String() string {
	str, _ := text.Marshal(0xf316944415569081, capnp.Struct(s))
	return str
}

func (s PromisedAnswer_Op) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (PromisedAnswer_Op) DecodeFromPtr(p capnp.Ptr) PromisedAnswer_Op {
	return PromisedAnswer_Op(capnp.Struct{}.DecodeFromPtr(p))
}

func (s PromisedAnswer_Op) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}

func (s PromisedAnswer_Op) Which() PromisedAnswer_Op_Which {
	return PromisedAnswer_Op_Which(capnp.Struct(s).Uint16(0))
}
func (s PromisedAnswer_Op) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s PromisedAnswer_Op) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s PromisedAnswer_Op) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s PromisedAnswer_Op) SetNoop() {
	capnp.Struct(s).SetUint16(0, 0)

}

func (s PromisedAnswer_Op) GetPointerField() uint16 {
	if capnp.Struct(s).Uint16(0) != 1 {
		panic("Which() != getPointerField")
	}
	return capnp.Struct(s).Uint16(2)
}

func (s PromisedAnswer_Op) SetGetPointerField(v uint16) {
	capnp.Struct(s).SetUint16(0, 1)
	capnp.Struct(s).SetUint16(2, v)
}

// PromisedAnswer_Op_List is a list of PromisedAnswer_Op.
type PromisedAnswer_Op_List = capnp.StructList[PromisedAnswer_Op]

// NewPromisedAnswer_Op creates a new list of PromisedAnswer_Op.
func NewPromisedAnswer_Op_List(s *capnp.Segment, sz int32) (PromisedAnswer_Op_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 0}, sz)
	return capnp.StructList[PromisedAnswer_Op](l), err
}

// PromisedAnswer_Op_Future is a wrapper for a PromisedAnswer_Op promised by a client call.
type PromisedAnswer_Op_Future struct{ *capnp.Future }

func (f PromisedAnswer_Op_Future) Struct() (PromisedAnswer_Op, error) {
	p, err := f.Future.Ptr()
	return PromisedAnswer_Op(p.Struct()), err
}

type ThirdPartyCapDescriptor capnp.Struct

// ThirdPartyCapDescriptor_TypeID is the unique identifier for the type ThirdPartyCapDescriptor.
const ThirdPartyCapDescriptor_TypeID = 0xd37007fde1f0027d

func NewThirdPartyCapDescriptor(s *capnp.Segment) (ThirdPartyCapDescriptor, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return ThirdPartyCapDescriptor(st), err
}

func NewRootThirdPartyCapDescriptor(s *capnp.Segment) (ThirdPartyCapDescriptor, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return ThirdPartyCapDescriptor(st), err
}

func ReadRootThirdPartyCapDescriptor(msg *capnp.Message) (ThirdPartyCapDescriptor, error) {
	root, err := msg.Root()
	return ThirdPartyCapDescriptor(root.Struct()), err
}

func (s ThirdPartyCapDescriptor) String() string {
	str, _ := text.Marshal(0xd37007fde1f0027d, capnp.Struct(s))
	return str
}

func (s ThirdPartyCapDescriptor) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (ThirdPartyCapDescriptor) DecodeFromPtr(p capnp.Ptr) ThirdPartyCapDescriptor {
	return ThirdPartyCapDescriptor(capnp.Struct{}.DecodeFromPtr(p))
}

func (s ThirdPartyCapDescriptor) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s ThirdPartyCapDescriptor) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s ThirdPartyCapDescriptor) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s ThirdPartyCapDescriptor) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s ThirdPartyCapDescriptor) Id() (capnp.Ptr, error) {
	return capnp.Struct(s).Ptr(0)
}

func (s ThirdPartyCapDescriptor) HasId() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s ThirdPartyCapDescriptor) SetId(v capnp.Ptr) error {
	return capnp.Struct(s).SetPtr(0, v)
}
func (s ThirdPartyCapDescriptor) VineId() uint32 {
	return capnp.Struct(s).Uint32(0)
}

func (s ThirdPartyCapDescriptor) SetVineId(v uint32) {
	capnp.Struct(s).SetUint32(0, v)
}

// ThirdPartyCapDescriptor_List is a list of ThirdPartyCapDescriptor.
type ThirdPartyCapDescriptor_List = capnp.StructList[ThirdPartyCapDescriptor]

// NewThirdPartyCapDescriptor creates a new list of ThirdPartyCapDescriptor.
func NewThirdPartyCapDescriptor_List(s *capnp.Segment, sz int32) (ThirdPartyCapDescriptor_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[ThirdPartyCapDescriptor](l), err
}

// ThirdPartyCapDescriptor_Future is a wrapper for a ThirdPartyCapDescriptor promised by a client call.
type ThirdPartyCapDescriptor_Future struct{ *capnp.Future }

func (f ThirdPartyCapDescriptor_Future) Struct() (ThirdPartyCapDescriptor, error) {
	p, err := f.Future.Ptr()
	return ThirdPartyCapDescriptor(p.Struct()), err
}
func (p ThirdPartyCapDescriptor_Future) Id() *capnp.Future {
	return p.Future.Field(0, nil)
}

type Exception capnp.Struct

// Exception_TypeID is the unique identifier for the type Exception.
const Exception_TypeID = 0xd625b7063acf691a

func NewException(s *capnp.Segment) (Exception, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3})
	return Exception(st), err
}

func NewRootException(s *capnp.Segment) (Exception, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3})
	return Exception(st), err
}

func ReadRootException(msg *capnp.Message) (Exception, error) {
	root, err := msg.Root()
	return Exception(root.Struct()), err
}

func (s Exception) String() string {
	str, _ := text.Marshal(0xd625b7063acf691a, capnp.Struct(s))
	return str
}

func (s Exception) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Exception) DecodeFromPtr(p capnp.Ptr) Exception {
	return Exception(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Exception) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Exception) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Exception) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Exception) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Exception) Reason() (string, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.Text(), err
}

func (s Exception) HasReason() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Exception) ReasonBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return p.TextBytes(), err
}

func (s Exception) SetReason(v string) error {
	return capnp.Struct(s).SetText(0, v)
}

func (s Exception) Type() Exception_Type {
	return Exception_Type(capnp.Struct(s).Uint16(4))
}

func (s Exception) SetType(v Exception_Type) {
	capnp.Struct(s).SetUint16(4, uint16(v))
}

func (s Exception) ObsoleteIsCallersFault() bool {
	return capnp.Struct(s).Bit(0)
}

func (s Exception) SetObsoleteIsCallersFault(v bool) {
	capnp.Struct(s).SetBit(0, v)
}

func (s Exception) ObsoleteDurability() uint16 {
	return capnp.Struct(s).Uint16(2)
}

func (s Exception) SetObsoleteDurability(v uint16) {
	capnp.Struct(s).SetUint16(2, v)
}

func (s Exception) Trace() (string, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return p.Text(), err
}

func (s Exception) HasTrace() bool {
	return capnp.Struct(s).HasPtr(1)
}

func (s Exception) TraceBytes() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(1)
	return p.TextBytes(), err
}

func (s Exception) SetTrace(v string) error {
	return capnp.Struct(s).SetText(1, v)
}

func (s Exception) Details() (Exception_Detail_List, error) {
	p, err := capnp.Struct(s).Ptr(2)
	return Exception_Detail_List(p.List()), err
}

func (s Exception) HasDetails() bool {
	return capnp.Struct(s).HasPtr(2)
}

func (s Exception) SetDetails(v Exception_Detail_List) error {
	return capnp.Struct(s).SetPtr(2, v.ToPtr())
}

// NewDetails sets the details field to a newly
// allocated Exception_Detail_List, preferring placement in s's segment.
func (s Exception) NewDetails(n int32) (Exception_Detail_List, error) {
	l, err := NewException_Detail_List(capnp.Struct(s).Segment(), n)
	if err != nil {
		return Exception_Detail_List{}, err
	}
	err = capnp.Struct(s).SetPtr(2, l.ToPtr())
	return l, err
}

// Exception_List is a list of Exception.
type Exception_List = capnp.StructList[Exception]

// NewException creates a new list of Exception.
func NewException_List(s *capnp.Segment, sz int32) (Exception_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 3}, sz)
	return capnp.StructList[Exception](l), err
}

// Exception_Future is a wrapper for a Exception promised by a client call.
type Exception_Future struct{ *capnp.Future }

func (f Exception_Future) Struct() (Exception, error) {
	p, err := f.Future.Ptr()
	return Exception(p.Struct()), err
}

type Exception_Type uint16

// Exception_Type_TypeID is the unique identifier for the type Exception_Type.
const Exception_Type_TypeID = 0xb28c96e23f4cbd58

// Values of Exception_Type.
const (
	Exception_Type_failed        Exception_Type = 0
	Exception_Type_overloaded    Exception_Type = 1
	Exception_Type_disconnected  Exception_Type = 2
	Exception_Type_unimplemented Exception_Type = 3
)

// String returns the enum's constant name.
func (c Exception_Type) String() string {
	switch c {
	case Exception_Type_failed:
		return "failed"
	case Exception_Type_overloaded:
		return "overloaded"
	case Exception_Type_disconnected:
		return "disconnected"
	case Exception_Type_unimplemented:
		return "unimplemented"

	default:
		return ""
	}
}

// Exception_TypeFromString returns the enum value with a name,
// or the zero value if there's no such value.
func Exception_TypeFromString(c string) Exception_Type {
	switch c {
	case "failed":
		return Exception_Type_failed
	case "overloaded":
		return Exception_Type_overloaded
	case "disconnected":
		return Exception_Type_disconnected
	case "unimplemented":
		return Exception_Type_unimplemented

	default:
		return 0
	}
}

type Exception_Type_List = capnp.EnumList[Exception_Type]

func NewException_Type_List(s *capnp.Segment, sz int32) (Exception_Type_List, error) {
	return capnp.NewEnumList[Exception_Type](s, sz)
}

type Exception_Detail capnp.Struct

// Exception_Detail_TypeID is the unique identifier for the type Exception_Detail.
const Exception_Detail_TypeID = 0xd6c14f121d44f8dd

func NewException_Detail(s *capnp.Segment) (Exception_Detail, error) {
	st, err := capnp.NewStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Exception_Detail(st), err
}

func NewRootException_Detail(s *capnp.Segment) (Exception_Detail, error) {
	st, err := capnp.NewRootStruct(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1})
	return Exception_Detail(st), err
}

func ReadRootException_Detail(msg *capnp.Message) (Exception_Detail, error) {
	root, err := msg.Root()
	return Exception_Detail(root.Struct()), err
}

func (s Exception_Detail) String() string {
	str, _ := text.Marshal(0xd6c14f121d44f8dd, capnp.Struct(s))
	return str
}

func (s Exception_Detail) EncodeAsPtr(seg *capnp.Segment) capnp.Ptr {
	return capnp.Struct(s).EncodeAsPtr(seg)
}

func (Exception_Detail) DecodeFromPtr(p capnp.Ptr) Exception_Detail {
	return Exception_Detail(capnp.Struct{}.DecodeFromPtr(p))
}

func (s Exception_Detail) ToPtr() capnp.Ptr {
	return capnp.Struct(s).ToPtr()
}
func (s Exception_Detail) IsValid() bool {
	return capnp.Struct(s).IsValid()
}

func (s Exception_Detail) Message() *capnp.Message {
	return capnp.Struct(s).Message()
}

func (s Exception_Detail) Segment() *capnp.Segment {
	return capnp.Struct(s).Segment()
}
func (s Exception_Detail) DetailId() uint64 {
	return capnp.Struct(s).Uint64(0)
}

func (s Exception_Detail) SetDetailId(v uint64) {
	capnp.Struct(s).SetUint64(0, v)
}

func (s Exception_Detail) Data() ([]byte, error) {
	p, err := capnp.Struct(s).Ptr(0)
	return []byte(p.Data()), err
}

func (s Exception_Detail) HasData() bool {
	return capnp.Struct(s).HasPtr(0)
}

func (s Exception_Detail) SetData(v []byte) error {
	return capnp.Struct(s).SetData(0, v)
}

// Exception_Detail_List is a list of Exception_Detail.
type Exception_Detail_List = capnp.StructList[Exception_Detail]

// NewException_Detail creates a new list of Exception_Detail.
func NewException_Detail_List(s *capnp.Segment, sz int32) (Exception_Detail_List, error) {
	l, err := capnp.NewCompositeList(s, capnp.ObjectSize{DataSize: 8, PointerCount: 1}, sz)
	return capnp.StructList[Exception_Detail](l), err
}

// Exception_Detail_Future is a wrapper for a Exception_Detail promised by a client call.
type Exception_Detail_Future struct{ *capnp.Future }

func (f Exception_Detail_Future) Struct() (Exception_Detail, error) {
	p, err := f.Future.Ptr()
	return Exception_Detail(p.Struct()), err
}

const schema_b312981b2552a250 = "x\xda\x9cX}\x8c\x15\xd5\x15?\xe7\xde\xf7\xb1\x8b\xef" +
	"\xf1\xde\xec\xbc\x05\xa4\x12\xc4BZH! \xa6\xd5\xad" +
	"\xe6!\xec\x12\x96@\xd9\xd9\xb7T\xa5M\xda\xd9\xf7." +
	"\xcb\xc0\xec\xcc83\x0b,\x09Al\xdaD\xaa\xa9\x12" +
	"\xb5j\xa4\x05\xa2\x89X\x8c\x88X\xb1\x95T\x08&j" +
	"\xb4bD\xa3F\xd2b\xa4\x91\xa6&X\x8b\x05\xf9\x98" +
	"\xe6\xcc\xcc\x9b\x99}\xfb\xb6\xd6\xfe\xb5\x93\xfb;{\xef" +
	"\xb9\xe7\xe3\xf7;\xf7\xcd\xbd>\xbb 5/\xef\xb5\x02" +
	"S\xdct\xc6;\xbel\xc7\xc6?W\xd6\xfe\x0c\x94q" +
	"\xc8\xbd\x9e\xdd\xbd3\xbe\xf1P\xdb\xb3\x90\xe6Y\x00\xf9" +
	"Tj\x93|:\x95\x05\x98\x7f*\xe5!\xa0\xb7\xef\xe0" +
	"/\xae8z\xe2\x9b?'k\x8c\xad\xbb0\x9b\x01\x90" +
	"?\xcb\x1c\x91\xcfg\xc8\xfcl\xe6Wd~\xed\xbe{" +
	"\xee\x98\xfa\xdb\xe7\xef\x1bm^\x00\x90\x1fn\xd9.\xef" +
	"j!\xf3\x1d-+8\xa0w\xf8\x82|k_\xe9\xc5" +
	"\x07F\x9b3d\xf2\xb4\xdc\x11yf\x8e\xdc\x9a\x91\xdb" +
	"\x00\xe8}\xdf}\xf0\xa6k\xd4\xf1\x8f\x804.a\x9c" +
	"fdqWn\xbb|\x9fo{\x8fo\xbbj\xef\xe1" +
	"\x0b\xebRk\x1fm\xd890\xbe\x94\xdb.\xa7\xf3\xf4" +
	"\x85\xf9\xa7\x01\xbd\x8e[\x9e\xbd\xe9\x9e\xfdW\xfe\x86\x8c" +
	"\xd9\xc8K\"\x97w\xe5\xb7\xc9{\xc8z\xfe\xe3y?" +
	"&\xbfv\x8fm\xce\xeb\x93\x9fj\xd8\x9b\xc2&\xbfS" +
	"\xd8.\x9f(\xd0\xd7\xfb\x05\xf2\xe3\xd6C\xcb\xca\x1f=" +
	"x\xf7~\x90J\xcc\x9b\xac\xbd\xd9\x91y~\xc6\xbb\x00" +
	"(\xdfP|M\xee*\x92\xe1\xcd\xc5\x01@\xef\xeeS" +
	"g^\xfe\xdbU\xca\xef\x1b\x1dF2\xb9\xbd\xf8\x81\xbc" +
	"\xd97\x1e.\xd2\xaeF\xcb]_\xae|\xf0\xc8\x1f\x9b" +
	"\xc7\xedDq\xbb|\xca\xb7>Y\xa4\xebmfgN" +
	"^\xcaZo7\xdbz\xfeV\xa9\x0d\xe5\xfb$?r" +
	"\x12\xed]\x1d\x7f\xee\xc8\xfe9\x9b\xdfnv\xbb\xd3\xd2" +
	"6\xf93\xdf\xf6S\x89v\x9e\xb0`\xe5\xbd\xfd\xcf\xbd" +
	"z\xbci\x94w\xb5m\x93\xf7\xb4\xd1\xd7\xe3md\xbc" +
	"\xfc\xc4\x8f\xc4_\x0e\xf4\xbf\x03J;\xa2'}\xefP" +
	"\xe1\x97\xdf\xad\x9d\x87\x95,\x8b\x1c\x99\xdc%\xff\x1dP" +
	"\xee\x96\xc94\x0aT\xc3\xbe~\x8d~*\xef\x96\xcf\xca" +
	"\xdf\x02\x98\xdfZ\xba\x85\xf2q\xe2\\\xe7\x94\xb6\x15\x87" +
	"\xdf\x05\xa5\x84\x89\xff\x0dB7\xd4\xfe\x81\xbc\xb5\x9d\xbe" +
	"6\xb7o\x00\xfc\xd3\xce\xab\xcc7\xde}\xe6\xbdfQ" +
	">\xd1\xfe\x9a|\xba}\"\xd55\x99z\x0f\xff\xe4w" +
	"\x93\xbf\xd8\xf7\xc9\x07\xa0\x14\x90\xc7}\xb3\x92\x93\xc3\\" +
	"\x16\x13\xc8am\x029|\xd4\x988\xef\x8e7\x97\x9d" +
	"n\x9a\xbd\xd6\x89\xbbei\"}\xe5'\xd2\xbe[\xef" +
	"\xfda{\xe7\xfd\x13>\x07\xe5J\x8c\x1c\xea\xcc2\xf2" +
	"v\xe2G\xf2V\xdft\xb3o\x1aE\xa9Y\x80OL" +
	"|R>\xe5\x1b\x9f\xf4\x8d\x9f\xc6\xbf\xde\x9bz\xe8\xe4" +
	"\x85\xa6\xc6\xd3&m\x92gL\x0a\xbe\x9e\x86E\x9em" +
	"U\xe7TU\xcb\x80\xb2\xd5\xb1H\xd5\xf5\x1eDe:" +
	"O\x01\xa4\x10@\xfat\x15\x80\xf2\x0f\x8e\xca9\x86\x88" +
	"%\xa4\xb5\xb3\x1d\x00\xca\x19\x8e\xcaE\x86\x12\xc3\x122" +
	"\x00\xe9|?\x80r\x8ec%\x85\x0c%\xceJ\xc8\xa9" +
	"\xadp)@/r\xac\xe4h9\x8b%LQ \xb0" +
	"\x03\xa0\x92\xa2\xf5\"2\xc4\x16L\x04Y\xce\xa3\x0dL" +
	"J\xddQ\xa2u\xe9\xfc\x11\x00\xe5\"\xc7J\x0b\xed\x90" +
	"\xdeZ\xc2VD9\x8d\xbb\x01*-\xb4C\x89\xd63" +
	"w\x96p\x1c\xa2,\xf9\xeb%Z\xbf\x1a\x19z\xb7\x0f" +
	"\x09\xc7\xd5L\x03xw\x0d[\x80a\x0b`\xd9U\xed" +
	"\x01\xe1b1\xa6\x1d@,\x02z\x9a\xe1\x0a{\xb5Z" +
	"\x85\xac\xe8\xaea+0l\x05\xf4\x06\x85\xbb\xc6\xacu" +
	"\xd7\x00\x00\xb3\xc00\x0bX\xb6T[\x1dt\xb0\x18s" +
	"Q\xb8\x85#\x8cZ\xafp\x86`\xaa\xee:}\xa6\xa7" +
	"\xea\xba\xb9\xa1o\x8d\xc6\xecZ\x8fj\xbb\xc3}\xaa\xa6" +
	"S\x98\x01\x11\x18R\xd5\x1af\x8fm\x0ej\x0e\x8a\x1e" +
	"\xcd\x12\xbafd5c BMC\x1f&\x1c5'" +
	"\xc0\xb3\x9a!\"\xb4\x9e<F\xb9\xb3:\x85S\xb55" +
	"\xcb5m\xa0,^\xc5S9\xcf\xf3\xd3\xf8\xdc,\x00" +
	"e\x1fG\xe5E\x86S\xf0\xb2\x17f\xf2\x85\xb5\x00\xca" +
	"A\x8e\xcaQ\x86S\xd8%/\xcc\xe5a\x1b@y\x89" +
	"\xa3\xf2:\xc3)\xfc\"-s\x00\xe9\xd5M\x00\xca+" +
	"\x1c\x95\xe3\x0c\xf3\xa9\x0b\x9e\x9fK\xe9-Z=\xc6Q" +
	"\xf9\x90a>\xfd\xa5W\xc24\x80\xf4\xfe6\x00\xe5C" +
	"\x8e\xca'\x94\x1cV\xc2\x0c\xa2t\x8a\x8a\xe9c\x8e\xca" +
	"\x19\x86\x05\xc34\x04d\xfcx\x09{\x89\x09\x05\xc7\x15" +
	"Q\x8a\xc2\xe5\x1e\x1b\xa6RhD\xb4n\x8b\xaa\xd0\xd6" +
	"\x0b\x1b\xcaK\xcc\x11\xff\x10\x037\x1b\xce\x06ac\xb1" +
	"\xdePab\xdc5\x9a\x9f\x02t\x87\x83\x7f\x05\xc0b" +
	"L\x89\xa1\x95\xea\xbaju\x8d\xa8\x01_\\\xc3\x0c\xb0" +
	"t\xc6K\x84\x19\xad\x8e\xe5\xc2q\xd4\x01\x14\x14\xe0\x1b" +
	"\xa3\x00\xcb\x0f\xa0\x0dP\xb9\x9f\xean'2\xcc\xe3e" +
	"\xcf\x0f\xb1\xbc\x03\xaf\x05\xa8<D\xc0c\x04\xf0K\x9e" +
	"\x1fdy\x17\xce\x02\xa8<J\xc0\x13\x04\xa4.zA" +
	"\xcf<\xee7\xc7N\x02\xf6\x12\x90\x0e#-\xef\xf1\x81" +
	"\xc7\x08\xd8G@&\x0c\xb6\xfc\x14.\x04\xa8<A\xc0" +
	"\x01\x02\xb2\xe7\xbd\x12\x92,?\xe3\x03{\x098H@" +
	"\xeb9\xaf\xe43\xd1s\xb8\x16\xa0r\x80\x80\x97\x08`" +
	"\xff\xf6J\xd8\x02 \x1f\xc2^\x80\xca\x8b\x04\xbcB\xc0" +
	"\xb8/\xbc\x12\xb6\x02\xc8/\xe3&\x80\xcaQ\x02\x8e\x11" +
	"p\xc5Y\xaf\x84\xe3\x00\xe47\xfc3^!\xe08\x01" +
	"\xb9\x7fy%\xbc\x02@~\xcbw\xf7u\x02\xde#`" +
	"\xfc\xe7^\x09s$\x8d\xfe\xcd\x8f\x11\xf0!\x01-\xff" +
	"\xf4J\x98'\xa5\xc4U\x00\x95\xf7\x08\xf8\x98\x80\xfcg" +
	"^\x09\xc7\x13\xad\xe16\x80\xca\xc7\x04\x9c\xa1\xae\x1e2" +
	"\xb4AK\x17\x830U\x18T\x04\xc5x\xde\x08\xf28" +
	"U\xed7m\xea\xf0\x84\xd2\xd2z\xa1\xaa\xea:\x16c" +
	"\x0e\x0f\x96\xcb\xb6p\x87l\x03\x8b\xf1\x04\x10\x02\xab5" +
	"Cs\xd6`1V\xc3\x00\xd8b\x0b\xc7\xd4\xd7\x0b," +
	"\xc6\x1a\x1c!\xbaP\x1dB\xa2\xf9 ,.\xb3\xdf1" +
	"u\xe1\x0a(T\xd4\xf5\x02\xdb\x80a\x1b\xa0\xd7o\x9a" +
	"\xae\xe3\xda*\xa0\x85\xc5XA\x1a\xff\xa9\xdc)\xe8o" +
	"\xfd\xdf\xb6X\xb6\xb9^\xab\xd19\xd1\x8c\x13:\xadV" +
	"\xab\xc2\xa2\xdbG\xb2\x1c\xde~\xad\xa9\xd1%#}\x08" +
	"\x8f\xa8i\x8e\x18\xecWm\xe0\x03&\x16c\xad\x19\xdd" +
	"9Ao\xf9\x9d\x13\xcd)\xa1U\x82\x8a\x82\x1e\x11}" +
	">\xcd\xfaT\xd4\x12S\xd1L\x12\x8aosT\xaeK" +
	"\xb4\x894\x8fXd.G\xe5F\x86\x9e6h\x996" +
	"uhv\x91jE\x1dn\xf9,)jcvx\xa2" +
	"K{\xd4a\xddT\xb1\x16\x9e\x1d\x8a\xd9\xcc\x85\x00\xca" +
	"t\x8e\xca\\\x86R]\xcdf/\x05P\xbe\xc3QY" +
	"\xc2pK\xd54\\a\xb8Qj\xaa\xaa\xd5\xa7\xf6\xeb" +
	"\x82\xa8\x7f<`\x0fG,\xc6\xa30 -\x8e8\xd7" +
	"\xcfI\xc0\x0e\xb9\xe8\xdc.\xe2\xbdN\x8eJO,\xa2" +
	"\xcbID\x97pT\xfa\x12\"\xaa\xf4\x02(=\x1c\x95" +
	"\x1f\x7fm\xe9\xb2EU\xb34a\x00\xc6\xde'\x1c\xeb" +
	"\xf5\x0b\x1c\xa0A\xdd\x97\xc6\xea.\xe1\xd5%DD\xe9" +
	"\xec\xb6\x84\x92\xe7\xb9\x17\xf2\x15R\x9fGB\x9cO]" +
	"\x0e\xe9*\xed3F\xa4\xe5\xf9\xf4\xa5\x90\xae\xf2\xa4\xfd" +
	"\x95\x1c\x01\x93|\xba\xba\x18\xd2U;>\x09P\x99D" +
	"\xc0td8%{\xc1c\x01_M\xc3\xfd\x00\x95\xe9" +
	"\x84\xcc\xf5\x99\xe1\xcb\x90\xaff\xfb\xb2>\x97\x80\x1bI" +
	"\xee\xd94\x7f8\x90o\xf0Y\xe9zZ\xef$bP" +
	"\xfd\xca\x08\xa4:V\x06\xbf\x1f{\x90${\x91j9" +
	"\xe0ko\x9a\x04\x94\xdaxHw\x9b\x09\xb9\xd8HM" +
	"\xa4\x99\x80\xc6h\x1e\xf1\xaa\xaaQ\x15:\x89H\xd6\x0b" +
	"\xf7\xa8\xa00\xdc.\xdd\x11\x1b\x0ak\x84M\xda\xe6\xaa" +
	"\xeb\xc4b\xd2\xee\x15\xee\x1aa+Cb\xaa\x9f\xd0\xc8" +
	"3u\x83\xaa\xb9\x8bm\x13\x07\xfb\x82\x16\xcb\xda\xeep" +
	"\x94=\xc3\\\xec\x93\x0f\x94\x7f DM\xd4F\x89\xbe" +
	"\x9fV\xba[Po\x89:\x9f\xdc\xac\xce7\x85u~" +
	"=C\xae%\x85s\xb5\xb0\x85Q\x85\xb2Xd\x0e\x19" +
	"n\x0c\xc4\x0d\xdd\x15\xc6\xc2\x98\xd37l\x89\xa0\x8a\x8a" +
	"~\xc5\xce\xec\xa0\x88H\xd3V\x01 \x93\xa6\xac\x05@" +
	".]i\x03\x94W\xab\x9a.j\x9e\xb9^\xd8\xba\xa9" +
	"\xd6\x80\x8b\x1a\x11M\xd54\x0c\x01\x85\xaa+j\x8d4" +
	"\x9e<1\x0c\x88\x1dP\x0e\x17v\xc3\x0dW\xc5$R" +
	"\xbf\xe0\xbc\xa5\x09\x0a\xa9\x9a\xb4\xb3\xab\x017\x8d(\xa2" +
	"M\xab#\x19L\xa2\xf4Q\xcd\xdb\x1b7o\x1e\xbd\x90" +
	"\xaf\x96_\x13\xb7o\x9e]\xf6\x9a\xf4o\xc8W\xdd\x80" +
	"Q\xb0\xb3U\xd5j \x90\xaf.\xb5\xba\x87<\x19\x95" +
	"\xe4\xb4\x87\xf6\xd8\xe9\x8f\xb2\xdf\x11\x07\x8c\xb2\x1f\x86\xa4" +
	"\xbc^3Dw\xadY4\xc2\xe2\x83\xb1\xa9,b\x8c" +
	"\xe5\xdb\xe3k\xfb\xad\xc9\x10\xe7\xdd6\x19\x01\x94\x1aG" +
	"\xc5\x1a\x83\xcc\xea\x9d\xd9\x8b~\x03\x11\xd7;Qgz" +
	"\xb6\xb8}H\xb3E\x17Wm}x\x91\xdfn\xbaJ" +
	"[\xdcb\xda\xebT\xdb\x1c\xe2F-a\x1d;~\xb3" +
	"\xaf~\xff\xcd\xf1\x88\x83)]\xcb8*\xb7&8x" +
	"\xe5\xc2\xaf\xe0`\xcf\x17^'HW]\x8c}\xfd\x1c" +
	"01\x0f\x0c\xf3#\x9b\xa73T\xd7\x01sN\xd54" +
	"\x0a\xae\xd8\xe8\x92_\xb9z)umJ\x16X\xbd\x94" +
	"\x96o\x8b\xdd\x08Gs\x9a\xc1o\xa3<\xf6qT~" +
	"\xca\xeaC\xf22\x13\xca\xa6\xd5\xafV\xd7\x8d\x1a\x86q" +
	"\x99\x19 q\xc1\xd7\x87\x83FG\xb1\xde\xe5Y\xcd4" +
	"\x14z\x90\xc5\xbfX\xb4\xce\x8a\x9f\xd6R\xba\xa3@$" +
	"P\xee\x14\xae\xaa\xe9\xca\xa4(\xc2\x0f\x93k\xf7sT" +
	"v2D\x16\xdcm\xc7\x1f\x00\x94\x9d\x1c\x95\xbd\xf4(" +
	"\x0c#\xbc\xe7\x11\x00e/G\xe5 \xd5P\xf0R\x1c" +
	"\xf1B\x91R\xc1;Qz\xe1Z\x00\xe5\x00G\xe5%" +
	"z\xfa\xb1\xe0iqha\xf8h9\xcehpS\x1d" +
	"\xd3\xc0\x1c0\xcc%\x86%\xecv\xe8\x91%\xec\xb2\xb3" +
	"X\x1d\xd2\xdd\xf89U7\xe8\x1c\xb2\xd5~M\xd7\xb8" +
	";\\\x7f\xd4\x15\xdcaK`!\xbe8 \x16\x00\xa7" +
	"\xba\xb6Z\x15\xf5#\xb6\xd4\xfc{;\xf18\x10\x85\xa6" +
	"a\x1c\x18\xc1\x9b\x14-\xae\xe9\x0d\x8d\xba\xb4\x09\x8b\xcd" +
	"\x8ai\xda\x0b\xce\x0a\x08+|\x8d\x16j\xaa\xab6+" +
	"\xb3\x9ep<\xaa\x8fhJ\x0a\x13\xbf0H8\x99\xaf" +
	"\xb0\xbe\x8aA{C\x06]6V\xe9\xbb\xb6j8\xab" +
	"M\x1bp0\x0e@t\xc8\xe8\x00P\x12\xe6\xd4\x9f\xc4" +
	"z\x81^\xc4Q\xedS.\xbb\xa8f\x16\x04'\x06\xb5" +
	"\x9f\x01\x90\xba\x97\xc6\xe4J\xb5\xcf\xfc!@RV\xc5" +
	"-Q\xae\xfa\xe9\x85\x8c7l\x0e\xd9\x8e\xd0W\x93\x12" +
	"\xd7'U\xe0\x09\x1dMT\xf8B\x7f\xd2\xce\xda\xaa\xf5" +
	"?\xc8\x09U\xe9u\x1c\x95\x05c\x05\xa3&,[T" +
	"U\x17EmE\xffZQu\x09l<uTf\xb2" +
	"sVX\x8d#\xf1\xac\x98\xb0\x13\xaf\xf3\xd9w\xc6\xa5" +
	"P0L\xd3\x82\x8c7 \xdc\x1eS3\\\x14\xf6b" +
	"M\xe8\xb5\xe8\x17\x89\xe45\x03\xc6)\x10\xe54\xdc\xb3" +
	"#\xa9\x0c\x98\xf8)N\x9a\xbd\x10\xd8\x98\xd3e0\x17" +
	"otG\xfcX\xb4\xd4\xd4\x8c\xffw\xce]\x18\x13\xef" +
	"\xd7\x9bs\xb7\xac\x13\xc3$\x80\xf58\xff'\x00\x00\xff" +
	"\xff\xf4\x84\xb9\x0a"

func RegisterSchema(reg *schemas.Registry) {
	reg.Register(&schemas.Schema{
		String: schema_b312981b2552a250,
		Nodes: []uint64{
			0x836a53ce789d4cd4,
			0x8523ddc40b86b8b0,
			0x91b79f1f808db032,
			0x95bc14545813fbc1,
			0x9a0e61223d96743b,
			0x9c6a046bfbc1ac5a,
			0x9e19b28d3db3573a,
			0xad1a6c0d7dd07497,
			0xb28c96e23f4cbd58,
			0xb6511ce6c5f0e58c,
			0xbbc29655fa89086e,
			0xd37007fde1f0027d,
			0xd37d2eb2c2f80e63,
			0xd4c9b56290554016,
			0xd562b4df655bdd4d,
			0xd625b7063acf691a,
			0xd6c14f121d44f8dd,
			0xd800b1d6cd6f1ca0,
			0xdae8b0f61aab5f99,
			0xe94ccf8031176ec4,
			0xf316944415569081,
			0xf964368b0fbd3711,
			0xfbe1980490e001af,
		},
		Compressed: true,
	})
}
