// This file is generated by kconfig_compiler_kf6 from easyeffects_db_equalizer.kcfg.
// All changes you do to this file will be lost.
#ifndef DB_EQUALIZER_H
#define DB_EQUALIZER_H

#include <kconfig_base_ee.hpp>

#include <kconfigskeleton.h>
#include <QCoreApplication>
#include <QDebug>

namespace db {

class Equalizer : public KConfigBaseEE
{
  Q_OBJECT
  public:

    Equalizer( const QString & masterGroup, const QString & instanceIndex );
    ~Equalizer() override;

    /**
      Set bypass
    */
    void setBypass( bool v )
    {
      if (v != mBypass && !isBypassImmutable()) {
        mBypass = v;
        Q_EMIT bypassChanged();
      }
    }

    Q_PROPERTY(bool bypass READ bypass WRITE setBypass NOTIFY bypassChanged)
    Q_PROPERTY(bool isBypassImmutable READ isBypassImmutable CONSTANT)
    Q_PROPERTY(bool defaultBypassValue READ defaultBypassValue CONSTANT)
    /**
      Get bypass
    */
    bool bypass() const
    {
      return mBypass;
    }

    /**
      Is bypass Immutable
    */
    bool isBypassImmutable() const
    {
      return isImmutable( QStringLiteral( "bypass" ) );
    }

    /**
      Get bypass default value
    */
    bool defaultBypassValue() const
    {
        return defaultBypassValue_helper();
    }

    /**
      Set inputGain
    */
    void setInputGain( double v )
    {
      if (v < -36)
      {
        qDebug() << "setInputGain: value " << v << " is less than the minimum value of -36";
        v = -36;
      }

      if (v > 36)
      {
        qDebug() << "setInputGain: value " << v << " is greater than the maximum value of 36";
        v = 36;
      }

      if (v != mInputGain && !isInputGainImmutable()) {
        mInputGain = v;
        Q_EMIT inputGainChanged();
      }
    }

    Q_PROPERTY(double inputGain READ inputGain WRITE setInputGain NOTIFY inputGainChanged)
    Q_PROPERTY(bool isInputGainImmutable READ isInputGainImmutable CONSTANT)
    Q_PROPERTY(double defaultInputGainValue READ defaultInputGainValue CONSTANT)
    /**
      Get inputGain
    */
    double inputGain() const
    {
      return mInputGain;
    }

    /**
      Is inputGain Immutable
    */
    bool isInputGainImmutable() const
    {
      return isImmutable( QStringLiteral( "inputGain" ) );
    }

    /**
      Get inputGain default value
    */
    double defaultInputGainValue() const
    {
        return defaultInputGainValue_helper();
    }

    /**
      Set outputGain
    */
    void setOutputGain( double v )
    {
      if (v < -36)
      {
        qDebug() << "setOutputGain: value " << v << " is less than the minimum value of -36";
        v = -36;
      }

      if (v > 36)
      {
        qDebug() << "setOutputGain: value " << v << " is greater than the maximum value of 36";
        v = 36;
      }

      if (v != mOutputGain && !isOutputGainImmutable()) {
        mOutputGain = v;
        Q_EMIT outputGainChanged();
      }
    }

    Q_PROPERTY(double outputGain READ outputGain WRITE setOutputGain NOTIFY outputGainChanged)
    Q_PROPERTY(bool isOutputGainImmutable READ isOutputGainImmutable CONSTANT)
    Q_PROPERTY(double defaultOutputGainValue READ defaultOutputGainValue CONSTANT)
    /**
      Get outputGain
    */
    double outputGain() const
    {
      return mOutputGain;
    }

    /**
      Is outputGain Immutable
    */
    bool isOutputGainImmutable() const
    {
      return isImmutable( QStringLiteral( "outputGain" ) );
    }

    /**
      Get outputGain default value
    */
    double defaultOutputGainValue() const
    {
        return defaultOutputGainValue_helper();
    }

    /**
      Set numBands
    */
    void setNumBands( int v )
    {
      if (v < 1)
      {
        qDebug() << "setNumBands: value " << v << " is less than the minimum value of 1";
        v = 1;
      }

      if (v > 32)
      {
        qDebug() << "setNumBands: value " << v << " is greater than the maximum value of 32";
        v = 32;
      }

      if (v != mNumBands && !isNumBandsImmutable()) {
        mNumBands = v;
        Q_EMIT numBandsChanged();
      }
    }

    Q_PROPERTY(int numBands READ numBands WRITE setNumBands NOTIFY numBandsChanged)
    Q_PROPERTY(bool isNumBandsImmutable READ isNumBandsImmutable CONSTANT)
    Q_PROPERTY(int defaultNumBandsValue READ defaultNumBandsValue CONSTANT)
    /**
      Get numBands
    */
    int numBands() const
    {
      return mNumBands;
    }

    /**
      Is numBands Immutable
    */
    bool isNumBandsImmutable() const
    {
      return isImmutable( QStringLiteral( "numBands" ) );
    }

    /**
      Get numBands default value
    */
    int defaultNumBandsValue() const
    {
        return defaultNumBandsValue_helper();
    }

    /**
      Set modeLabels
    */
    void setModeLabels( const QStringList & v )
    {
      if (v != mModeLabels && !isModeLabelsImmutable()) {
        mModeLabels = v;
        Q_EMIT modeLabelsChanged();
      }
    }

    Q_PROPERTY(QStringList modeLabels READ modeLabels WRITE setModeLabels NOTIFY modeLabelsChanged)
    Q_PROPERTY(bool isModeLabelsImmutable READ isModeLabelsImmutable CONSTANT)
    Q_PROPERTY(QStringList defaultModeLabelsValue READ defaultModeLabelsValue CONSTANT)
    /**
      Get modeLabels
    */
    QStringList modeLabels() const
    {
      return mModeLabels;
    }

    /**
      Is modeLabels Immutable
    */
    bool isModeLabelsImmutable() const
    {
      return isImmutable( QStringLiteral( "modeLabels" ) );
    }

    /**
      Get modeLabels default value
    */
    QStringList defaultModeLabelsValue() const
    {
        return defaultModeLabelsValue_helper();
    }

    /**
      Set mode
    */
    void setMode( int v )
    {
      if (v != mMode && !isModeImmutable()) {
        mMode = v;
        Q_EMIT modeChanged();
      }
    }

    Q_PROPERTY(int mode READ mode WRITE setMode NOTIFY modeChanged)
    Q_PROPERTY(bool isModeImmutable READ isModeImmutable CONSTANT)
    Q_PROPERTY(int defaultModeValue READ defaultModeValue CONSTANT)
    /**
      Get mode
    */
    int mode() const
    {
      return mMode;
    }

    /**
      Is mode Immutable
    */
    bool isModeImmutable() const
    {
      return isImmutable( QStringLiteral( "mode" ) );
    }

    /**
      Get mode default value
    */
    int defaultModeValue() const
    {
        return defaultModeValue_helper();
    }

    /**
      Set splitChannels
    */
    void setSplitChannels( bool v )
    {
      if (v != mSplitChannels && !isSplitChannelsImmutable()) {
        mSplitChannels = v;
        Q_EMIT splitChannelsChanged();
      }
    }

    Q_PROPERTY(bool splitChannels READ splitChannels WRITE setSplitChannels NOTIFY splitChannelsChanged)
    Q_PROPERTY(bool isSplitChannelsImmutable READ isSplitChannelsImmutable CONSTANT)
    Q_PROPERTY(bool defaultSplitChannelsValue READ defaultSplitChannelsValue CONSTANT)
    /**
      Get splitChannels
    */
    bool splitChannels() const
    {
      return mSplitChannels;
    }

    /**
      Is splitChannels Immutable
    */
    bool isSplitChannelsImmutable() const
    {
      return isImmutable( QStringLiteral( "splitChannels" ) );
    }

    /**
      Get splitChannels default value
    */
    bool defaultSplitChannelsValue() const
    {
        return defaultSplitChannelsValue_helper();
    }

    /**
      Set balance
    */
    void setBalance( double v )
    {
      if (v < -100)
      {
        qDebug() << "setBalance: value " << v << " is less than the minimum value of -100";
        v = -100;
      }

      if (v > 100)
      {
        qDebug() << "setBalance: value " << v << " is greater than the maximum value of 100";
        v = 100;
      }

      if (v != mBalance && !isBalanceImmutable()) {
        mBalance = v;
        Q_EMIT balanceChanged();
      }
    }

    Q_PROPERTY(double balance READ balance WRITE setBalance NOTIFY balanceChanged)
    Q_PROPERTY(bool isBalanceImmutable READ isBalanceImmutable CONSTANT)
    Q_PROPERTY(double defaultBalanceValue READ defaultBalanceValue CONSTANT)
    /**
      Get balance
    */
    double balance() const
    {
      return mBalance;
    }

    /**
      Is balance Immutable
    */
    bool isBalanceImmutable() const
    {
      return isImmutable( QStringLiteral( "balance" ) );
    }

    /**
      Get balance default value
    */
    double defaultBalanceValue() const
    {
        return defaultBalanceValue_helper();
    }

    /**
      Set pitchLeft
    */
    void setPitchLeft( double v )
    {
      if (v < -120)
      {
        qDebug() << "setPitchLeft: value " << v << " is less than the minimum value of -120";
        v = -120;
      }

      if (v > 120)
      {
        qDebug() << "setPitchLeft: value " << v << " is greater than the maximum value of 120";
        v = 120;
      }

      if (v != mPitchLeft && !isPitchLeftImmutable()) {
        mPitchLeft = v;
        Q_EMIT pitchLeftChanged();
      }
    }

    Q_PROPERTY(double pitchLeft READ pitchLeft WRITE setPitchLeft NOTIFY pitchLeftChanged)
    Q_PROPERTY(bool isPitchLeftImmutable READ isPitchLeftImmutable CONSTANT)
    Q_PROPERTY(double defaultPitchLeftValue READ defaultPitchLeftValue CONSTANT)
    /**
      Get pitchLeft
    */
    double pitchLeft() const
    {
      return mPitchLeft;
    }

    /**
      Is pitchLeft Immutable
    */
    bool isPitchLeftImmutable() const
    {
      return isImmutable( QStringLiteral( "pitchLeft" ) );
    }

    /**
      Get pitchLeft default value
    */
    double defaultPitchLeftValue() const
    {
        return defaultPitchLeftValue_helper();
    }

    /**
      Set pitchRight
    */
    void setPitchRight( double v )
    {
      if (v < -120)
      {
        qDebug() << "setPitchRight: value " << v << " is less than the minimum value of -120";
        v = -120;
      }

      if (v > 120)
      {
        qDebug() << "setPitchRight: value " << v << " is greater than the maximum value of 120";
        v = 120;
      }

      if (v != mPitchRight && !isPitchRightImmutable()) {
        mPitchRight = v;
        Q_EMIT pitchRightChanged();
      }
    }

    Q_PROPERTY(double pitchRight READ pitchRight WRITE setPitchRight NOTIFY pitchRightChanged)
    Q_PROPERTY(bool isPitchRightImmutable READ isPitchRightImmutable CONSTANT)
    Q_PROPERTY(double defaultPitchRightValue READ defaultPitchRightValue CONSTANT)
    /**
      Get pitchRight
    */
    double pitchRight() const
    {
      return mPitchRight;
    }

    /**
      Is pitchRight Immutable
    */
    bool isPitchRightImmutable() const
    {
      return isImmutable( QStringLiteral( "pitchRight" ) );
    }

    /**
      Get pitchRight default value
    */
    double defaultPitchRightValue() const
    {
        return defaultPitchRightValue_helper();
    }

    /**
      Set viewLeftChannel
    */
    void setViewLeftChannel( bool v )
    {
      if (v != mViewLeftChannel && !isViewLeftChannelImmutable()) {
        mViewLeftChannel = v;
        Q_EMIT viewLeftChannelChanged();
      }
    }

    Q_PROPERTY(bool viewLeftChannel READ viewLeftChannel WRITE setViewLeftChannel NOTIFY viewLeftChannelChanged)
    Q_PROPERTY(bool isViewLeftChannelImmutable READ isViewLeftChannelImmutable CONSTANT)
    Q_PROPERTY(bool defaultViewLeftChannelValue READ defaultViewLeftChannelValue CONSTANT)
    /**
      Get viewLeftChannel
    */
    bool viewLeftChannel() const
    {
      return mViewLeftChannel;
    }

    /**
      Is viewLeftChannel Immutable
    */
    bool isViewLeftChannelImmutable() const
    {
      return isImmutable( QStringLiteral( "viewLeftChannel" ) );
    }

    /**
      Get viewLeftChannel default value
    */
    bool defaultViewLeftChannelValue() const
    {
        return defaultViewLeftChannelValue_helper();
    }


    enum {
      signalBypassChanged = 1,
      signalInputGainChanged = 2,
      signalOutputGainChanged = 3,
      signalNumBandsChanged = 4,
      signalModeLabelsChanged = 5,
      signalModeChanged = 6,
      signalSplitChannelsChanged = 7,
      signalBalanceChanged = 8,
      signalPitchLeftChanged = 9,
      signalPitchRightChanged = 10,
      signalViewLeftChannelChanged = 11
    };

  Q_SIGNALS:
    void bypassChanged();

    void inputGainChanged();

    void outputGainChanged();

    void numBandsChanged();

    void modeLabelsChanged();

    void modeChanged();

    void splitChannelsChanged();

    void balanceChanged();

    void pitchLeftChanged();

    void pitchRightChanged();

    void viewLeftChannelChanged();

  private:
    void itemChanged(quint64 signalFlag);

  protected:
    QString mParammasterGroup;
    QString mParaminstanceIndex;

    // Equalizer#$(instanceIndex)
    bool mBypass;
    bool defaultBypassValue_helper() const;
    double mInputGain;
    double defaultInputGainValue_helper() const;
    double mOutputGain;
    double defaultOutputGainValue_helper() const;
    int mNumBands;
    int defaultNumBandsValue_helper() const;
    QStringList mModeLabels;
    QStringList defaultModeLabelsValue_helper() const;
    int mMode;
    int defaultModeValue_helper() const;
    bool mSplitChannels;
    bool defaultSplitChannelsValue_helper() const;
    double mBalance;
    double defaultBalanceValue_helper() const;
    double mPitchLeft;
    double defaultPitchLeftValue_helper() const;
    double mPitchRight;
    double defaultPitchRightValue_helper() const;
    bool mViewLeftChannel;
    bool defaultViewLeftChannelValue_helper() const;

  private:
};

}

#endif

