#include <stdint.h>
#include <fcitx/fcitx.h>
#include <fcitx-utils/utils.h>
#include <fcitx/instance.h>
#include <fcitx/addon.h>
#include <fcitx/module.h>


#ifndef __FCITX_MODULE_FCITX_NOTIFICATIONITEM_ADD_FUNCTION_H
#define __FCITX_MODULE_FCITX_NOTIFICATIONITEM_ADD_FUNCTION_H

#ifdef __cplusplus
extern "C" {
#endif

DEFINE_GET_ADDON("fcitx-notificationitem", _NotificationItem_)

static void*
__fcitx_NotificationItem_function_Enable(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxNotificationItem*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(FcitxNotificationItemAvailableCallback, arg0, _args.args[0]);
    FCITX_DEF_CAST_FROM_PTR(void*, arg1, _args.args[1]);
    FcitxNotificationItem* self = __self;
    FCITX_UNUSED(self);
    boolean res = (FcitxNotificationItemEnable(self, arg0, arg1));
    FCITX_RETURN_AS_PTR(boolean, res);
}

static void*
__fcitx_NotificationItem_function_Disable(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxNotificationItem*, __self, _self);
    FCITX_UNUSED(_args);
    FcitxNotificationItem* self = __self;
    FCITX_UNUSED(self);
    FcitxNotificationItemDisable(self);
    return NULL;
}

static void
FcitxNotificationItemAddFunctions(FcitxInstance *instance)
{
    int i;
    FcitxAddon *addon = Fcitx_NotificationItem_GetAddon(instance);
    static const FcitxModuleFunction ____fcitx_NotificationItem_addon_functions_table[] = {
        __fcitx_NotificationItem_function_Enable,
        __fcitx_NotificationItem_function_Disable,
    };
    for (i = 0;i < 2;i++) {
        FcitxModuleAddFunction(addon, ____fcitx_NotificationItem_addon_functions_table[i]);
    }
}

#ifdef __cplusplus
}
#endif

#endif
