/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-aver-hid-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

const gchar *
fu_aver_hid_status_to_string(FuAverHidStatus val)
{
    if (val == FU_AVER_HID_STATUS_READY)
        return "ready";
    if (val == FU_AVER_HID_STATUS_BUSY)
        return "busy";
    if (val == FU_AVER_HID_STATUS_DNLOAD)
        return "dnload";
    if (val == FU_AVER_HID_STATUS_WAITISP)
        return "waitisp";
    if (val == FU_AVER_HID_STATUS_ISPING)
        return "isping";
    if (val == FU_AVER_HID_STATUS_REBOOT)
        return "reboot";
    if (val == FU_AVER_HID_STATUS_FILEERR)
        return "fileerr";
    if (val == FU_AVER_HID_STATUS_POWERISP)
        return "powerisp";
    if (val == FU_AVER_HID_STATUS_VERSION)
        return "version";
    if (val == FU_AVER_HID_STATUS_WAITUSR)
        return "waitusr";
    if (val == FU_AVER_HID_STATUS_STOP)
        return "stop";
    return NULL;
}


static const gchar *
fu_aver_safeisp_custom_cmd_to_string(FuAverSafeispCustomCmd val)
{
    if (val == FU_AVER_SAFEISP_CUSTOM_CMD_GET_VERSION)
        return "get-version";
    if (val == FU_AVER_SAFEISP_CUSTOM_CMD_SUPPORT)
        return "support";
    if (val == FU_AVER_SAFEISP_CUSTOM_CMD_ERASE_TEMP)
        return "erase-temp";
    if (val == FU_AVER_SAFEISP_CUSTOM_CMD_UPLOAD_PREPARE)
        return "upload-prepare";
    if (val == FU_AVER_SAFEISP_CUSTOM_CMD_UPLOAD_COMPARE_CHECKSUM)
        return "upload-compare-checksum";
    if (val == FU_AVER_SAFEISP_CUSTOM_CMD_UPLOAD_TO_CX3)
        return "upload-to-cx3";
    if (val == FU_AVER_SAFEISP_CUSTOM_CMD_UPLOAD_TO_M12MO)
        return "upload-to-m12mo";
    if (val == FU_AVER_SAFEISP_CUSTOM_CMD_UPLOAD_TO_M051)
        return "upload-to-m051";
    if (val == FU_AVER_SAFEISP_CUSTOM_CMD_UPLOAD_TO_TMPM342)
        return "upload-to-tmpm342";
    if (val == FU_AVER_SAFEISP_CUSTOM_CMD_UPLOAD_TO_TMPM342_BOOT)
        return "upload-to-tmpm342-boot";
    if (val == FU_AVER_SAFEISP_CUSTOM_CMD_UPDATE_START)
        return "update-start";
    return NULL;
}

/**
 * fu_struct_aver_hid_req_isp_ref: (skip):
 **/
FuStructAverHidReqIsp *
fu_struct_aver_hid_req_isp_ref(FuStructAverHidReqIsp *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_aver_hid_req_isp_unref: (skip):
 **/
void
fu_struct_aver_hid_req_isp_unref(FuStructAverHidReqIsp *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructAverHidReqIsp refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructAverHidReqIsp *
fu_struct_aver_hid_req_isp_new_internal(void)
{
    FuStructAverHidReqIsp *st = g_new0(FuStructAverHidReqIsp, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_aver_hid_req_isp_get_custom_isp_cmd: (skip):
 **/
FuAverHidCustomIspCmd
fu_struct_aver_hid_req_isp_get_custom_isp_cmd(const FuStructAverHidReqIsp *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_aver_hid_req_isp_get_data: (skip):
 **/
const guint8 *
fu_struct_aver_hid_req_isp_get_data(const FuStructAverHidReqIsp *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 508;
    return st->buf->data + 3;
}

/* setters */
/**
 * fu_struct_aver_hid_req_isp_set_report_id_custom_command: (skip):
 **/
static void
fu_struct_aver_hid_req_isp_set_report_id_custom_command(FuStructAverHidReqIsp *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_aver_hid_req_isp_set_custom_cmd_isp: (skip):
 **/
static void
fu_struct_aver_hid_req_isp_set_custom_cmd_isp(FuStructAverHidReqIsp *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_aver_hid_req_isp_set_custom_isp_cmd: (skip):
 **/
void
fu_struct_aver_hid_req_isp_set_custom_isp_cmd(FuStructAverHidReqIsp *st, FuAverHidCustomIspCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_aver_hid_req_isp_set_data: (skip):
 **/
gboolean
fu_struct_aver_hid_req_isp_set_data(FuStructAverHidReqIsp *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 3, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_aver_hid_req_isp_set_end: (skip):
 **/
static void
fu_struct_aver_hid_req_isp_set_end(FuStructAverHidReqIsp *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[511] = value;
}
/**
 * fu_struct_aver_hid_req_isp_new: (skip):
 **/
FuStructAverHidReqIsp *
fu_struct_aver_hid_req_isp_new(void)
{
    FuStructAverHidReqIsp *st = fu_struct_aver_hid_req_isp_new_internal();
    st->buf = g_byte_array_sized_new(512);
    fu_byte_array_set_size(st->buf, 512, 0x0);
    fu_struct_aver_hid_req_isp_set_report_id_custom_command(st, 0x08);
    fu_struct_aver_hid_req_isp_set_custom_cmd_isp(st, 0x10);
    memcpy(st->buf->data + 0x3, "\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF", 508); /* nocheck:blocked */
    fu_struct_aver_hid_req_isp_set_end(st, 0x00);
    return st;
}
/**
 * fu_struct_aver_hid_req_isp_file_start_ref: (skip):
 **/
FuStructAverHidReqIspFileStart *
fu_struct_aver_hid_req_isp_file_start_ref(FuStructAverHidReqIspFileStart *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_aver_hid_req_isp_file_start_unref: (skip):
 **/
void
fu_struct_aver_hid_req_isp_file_start_unref(FuStructAverHidReqIspFileStart *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructAverHidReqIspFileStart refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructAverHidReqIspFileStart *
fu_struct_aver_hid_req_isp_file_start_new_internal(void)
{
    FuStructAverHidReqIspFileStart *st = g_new0(FuStructAverHidReqIspFileStart, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_aver_hid_req_isp_file_start_get_custom_isp_cmd: (skip):
 **/
FuAverHidCustomIspCmd
fu_struct_aver_hid_req_isp_file_start_get_custom_isp_cmd(const FuStructAverHidReqIspFileStart *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_aver_hid_req_isp_file_start_get_file_name: (skip):
 **/
gchar *
fu_struct_aver_hid_req_isp_file_start_get_file_name(const FuStructAverHidReqIspFileStart *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 3, 52, NULL);
}
/**
 * fu_struct_aver_hid_req_isp_file_start_get_file_size: (skip):
 **/
guint32
fu_struct_aver_hid_req_isp_file_start_get_file_size(const FuStructAverHidReqIspFileStart *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 55, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_aver_hid_req_isp_file_start_get_free_space: (skip):
 **/
guint32
fu_struct_aver_hid_req_isp_file_start_get_free_space(const FuStructAverHidReqIspFileStart *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 59, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_aver_hid_req_isp_file_start_set_report_id_custom_command: (skip):
 **/
static void
fu_struct_aver_hid_req_isp_file_start_set_report_id_custom_command(FuStructAverHidReqIspFileStart *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_aver_hid_req_isp_file_start_set_custom_cmd_isp: (skip):
 **/
static void
fu_struct_aver_hid_req_isp_file_start_set_custom_cmd_isp(FuStructAverHidReqIspFileStart *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_aver_hid_req_isp_file_start_set_custom_isp_cmd: (skip):
 **/
void
fu_struct_aver_hid_req_isp_file_start_set_custom_isp_cmd(FuStructAverHidReqIspFileStart *st, FuAverHidCustomIspCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_aver_hid_req_isp_file_start_set_file_name: (skip):
 **/
gboolean
fu_struct_aver_hid_req_isp_file_start_set_file_name(FuStructAverHidReqIspFileStart *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 3, 0x0, 52);
        return TRUE;
    }
    len = strlen(value);
    if (len > 52) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructAverHidReqIspFileStart.file_name (0x%x bytes)",
                    value, (guint) len, (guint) 52);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 3, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_aver_hid_req_isp_file_start_set_file_size: (skip):
 **/
void
fu_struct_aver_hid_req_isp_file_start_set_file_size(FuStructAverHidReqIspFileStart *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 55, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_aver_hid_req_isp_file_start_set_free_space: (skip):
 **/
void
fu_struct_aver_hid_req_isp_file_start_set_free_space(FuStructAverHidReqIspFileStart *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 59, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_aver_hid_req_isp_file_start_set_end: (skip):
 **/
static void
fu_struct_aver_hid_req_isp_file_start_set_end(FuStructAverHidReqIspFileStart *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[511] = value;
}
/**
 * fu_struct_aver_hid_req_isp_file_start_new: (skip):
 **/
FuStructAverHidReqIspFileStart *
fu_struct_aver_hid_req_isp_file_start_new(void)
{
    FuStructAverHidReqIspFileStart *st = fu_struct_aver_hid_req_isp_file_start_new_internal();
    st->buf = g_byte_array_sized_new(512);
    fu_byte_array_set_size(st->buf, 512, 0x0);
    fu_struct_aver_hid_req_isp_file_start_set_report_id_custom_command(st, 0x08);
    fu_struct_aver_hid_req_isp_file_start_set_custom_cmd_isp(st, 0x10);
    memcpy(st->buf->data + 0x3F, "\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF", 448); /* nocheck:blocked */
    fu_struct_aver_hid_req_isp_file_start_set_end(st, 0x00);
    return st;
}
/**
 * fu_struct_aver_hid_req_isp_file_dnload_ref: (skip):
 **/
FuStructAverHidReqIspFileDnload *
fu_struct_aver_hid_req_isp_file_dnload_ref(FuStructAverHidReqIspFileDnload *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_aver_hid_req_isp_file_dnload_unref: (skip):
 **/
void
fu_struct_aver_hid_req_isp_file_dnload_unref(FuStructAverHidReqIspFileDnload *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructAverHidReqIspFileDnload refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructAverHidReqIspFileDnload *
fu_struct_aver_hid_req_isp_file_dnload_new_internal(void)
{
    FuStructAverHidReqIspFileDnload *st = g_new0(FuStructAverHidReqIspFileDnload, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_aver_hid_req_isp_file_dnload_get_custom_isp_cmd: (skip):
 **/
FuAverHidCustomIspCmd
fu_struct_aver_hid_req_isp_file_dnload_get_custom_isp_cmd(const FuStructAverHidReqIspFileDnload *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_aver_hid_req_isp_file_dnload_get_data: (skip):
 **/
const guint8 *
fu_struct_aver_hid_req_isp_file_dnload_get_data(const FuStructAverHidReqIspFileDnload *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 508;
    return st->buf->data + 3;
}

/* setters */
/**
 * fu_struct_aver_hid_req_isp_file_dnload_set_report_id_custom_command: (skip):
 **/
static void
fu_struct_aver_hid_req_isp_file_dnload_set_report_id_custom_command(FuStructAverHidReqIspFileDnload *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_aver_hid_req_isp_file_dnload_set_custom_cmd_isp: (skip):
 **/
static void
fu_struct_aver_hid_req_isp_file_dnload_set_custom_cmd_isp(FuStructAverHidReqIspFileDnload *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_aver_hid_req_isp_file_dnload_set_custom_isp_cmd: (skip):
 **/
void
fu_struct_aver_hid_req_isp_file_dnload_set_custom_isp_cmd(FuStructAverHidReqIspFileDnload *st, FuAverHidCustomIspCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_aver_hid_req_isp_file_dnload_set_data: (skip):
 **/
gboolean
fu_struct_aver_hid_req_isp_file_dnload_set_data(FuStructAverHidReqIspFileDnload *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 3, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_aver_hid_req_isp_file_dnload_new: (skip):
 **/
FuStructAverHidReqIspFileDnload *
fu_struct_aver_hid_req_isp_file_dnload_new(void)
{
    FuStructAverHidReqIspFileDnload *st = fu_struct_aver_hid_req_isp_file_dnload_new_internal();
    st->buf = g_byte_array_sized_new(511);
    fu_byte_array_set_size(st->buf, 511, 0x0);
    fu_struct_aver_hid_req_isp_file_dnload_set_report_id_custom_command(st, 0x08);
    fu_struct_aver_hid_req_isp_file_dnload_set_custom_cmd_isp(st, 0x10);
    memcpy(st->buf->data + 0x3, "\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF", 508); /* nocheck:blocked */
    return st;
}
/**
 * fu_struct_aver_hid_req_isp_file_end_ref: (skip):
 **/
FuStructAverHidReqIspFileEnd *
fu_struct_aver_hid_req_isp_file_end_ref(FuStructAverHidReqIspFileEnd *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_aver_hid_req_isp_file_end_unref: (skip):
 **/
void
fu_struct_aver_hid_req_isp_file_end_unref(FuStructAverHidReqIspFileEnd *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructAverHidReqIspFileEnd refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructAverHidReqIspFileEnd *
fu_struct_aver_hid_req_isp_file_end_new_internal(void)
{
    FuStructAverHidReqIspFileEnd *st = g_new0(FuStructAverHidReqIspFileEnd, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_aver_hid_req_isp_file_end_get_custom_isp_cmd: (skip):
 **/
FuAverHidCustomIspCmd
fu_struct_aver_hid_req_isp_file_end_get_custom_isp_cmd(const FuStructAverHidReqIspFileEnd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_aver_hid_req_isp_file_end_get_file_name: (skip):
 **/
gchar *
fu_struct_aver_hid_req_isp_file_end_get_file_name(const FuStructAverHidReqIspFileEnd *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 3, 51, NULL);
}
/**
 * fu_struct_aver_hid_req_isp_file_end_get_end_flag: (skip):
 **/
guint8
fu_struct_aver_hid_req_isp_file_end_get_end_flag(const FuStructAverHidReqIspFileEnd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[54];
}
/**
 * fu_struct_aver_hid_req_isp_file_end_get_file_size: (skip):
 **/
guint32
fu_struct_aver_hid_req_isp_file_end_get_file_size(const FuStructAverHidReqIspFileEnd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 55, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_aver_hid_req_isp_file_end_get_free_space: (skip):
 **/
guint32
fu_struct_aver_hid_req_isp_file_end_get_free_space(const FuStructAverHidReqIspFileEnd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 59, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_aver_hid_req_isp_file_end_set_report_id_custom_command: (skip):
 **/
static void
fu_struct_aver_hid_req_isp_file_end_set_report_id_custom_command(FuStructAverHidReqIspFileEnd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_aver_hid_req_isp_file_end_set_custom_cmd_isp: (skip):
 **/
static void
fu_struct_aver_hid_req_isp_file_end_set_custom_cmd_isp(FuStructAverHidReqIspFileEnd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_aver_hid_req_isp_file_end_set_custom_isp_cmd: (skip):
 **/
void
fu_struct_aver_hid_req_isp_file_end_set_custom_isp_cmd(FuStructAverHidReqIspFileEnd *st, FuAverHidCustomIspCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_aver_hid_req_isp_file_end_set_file_name: (skip):
 **/
gboolean
fu_struct_aver_hid_req_isp_file_end_set_file_name(FuStructAverHidReqIspFileEnd *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 3, 0x0, 51);
        return TRUE;
    }
    len = strlen(value);
    if (len > 51) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructAverHidReqIspFileEnd.file_name (0x%x bytes)",
                    value, (guint) len, (guint) 51);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 3, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_aver_hid_req_isp_file_end_set_end_flag: (skip):
 **/
void
fu_struct_aver_hid_req_isp_file_end_set_end_flag(FuStructAverHidReqIspFileEnd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[54] = value;
}
/**
 * fu_struct_aver_hid_req_isp_file_end_set_file_size: (skip):
 **/
void
fu_struct_aver_hid_req_isp_file_end_set_file_size(FuStructAverHidReqIspFileEnd *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 55, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_aver_hid_req_isp_file_end_set_free_space: (skip):
 **/
void
fu_struct_aver_hid_req_isp_file_end_set_free_space(FuStructAverHidReqIspFileEnd *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 59, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_aver_hid_req_isp_file_end_set_end: (skip):
 **/
static void
fu_struct_aver_hid_req_isp_file_end_set_end(FuStructAverHidReqIspFileEnd *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[511] = value;
}
/**
 * fu_struct_aver_hid_req_isp_file_end_new: (skip):
 **/
FuStructAverHidReqIspFileEnd *
fu_struct_aver_hid_req_isp_file_end_new(void)
{
    FuStructAverHidReqIspFileEnd *st = fu_struct_aver_hid_req_isp_file_end_new_internal();
    st->buf = g_byte_array_sized_new(512);
    fu_byte_array_set_size(st->buf, 512, 0x0);
    fu_struct_aver_hid_req_isp_file_end_set_report_id_custom_command(st, 0x08);
    fu_struct_aver_hid_req_isp_file_end_set_custom_cmd_isp(st, 0x10);
    memcpy(st->buf->data + 0x3F, "\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF", 448); /* nocheck:blocked */
    fu_struct_aver_hid_req_isp_file_end_set_end(st, 0x00);
    return st;
}
/**
 * fu_struct_aver_hid_req_isp_start_ref: (skip):
 **/
FuStructAverHidReqIspStart *
fu_struct_aver_hid_req_isp_start_ref(FuStructAverHidReqIspStart *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_aver_hid_req_isp_start_unref: (skip):
 **/
void
fu_struct_aver_hid_req_isp_start_unref(FuStructAverHidReqIspStart *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructAverHidReqIspStart refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructAverHidReqIspStart *
fu_struct_aver_hid_req_isp_start_new_internal(void)
{
    FuStructAverHidReqIspStart *st = g_new0(FuStructAverHidReqIspStart, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_aver_hid_req_isp_start_get_custom_isp_cmd: (skip):
 **/
FuAverHidCustomIspCmd
fu_struct_aver_hid_req_isp_start_get_custom_isp_cmd(const FuStructAverHidReqIspStart *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_aver_hid_req_isp_start_get_isp_cmd: (skip):
 **/
const guint8 *
fu_struct_aver_hid_req_isp_start_get_isp_cmd(const FuStructAverHidReqIspStart *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 60;
    return st->buf->data + 3;
}

/* setters */
/**
 * fu_struct_aver_hid_req_isp_start_set_report_id_custom_command: (skip):
 **/
static void
fu_struct_aver_hid_req_isp_start_set_report_id_custom_command(FuStructAverHidReqIspStart *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_aver_hid_req_isp_start_set_custom_cmd_isp: (skip):
 **/
static void
fu_struct_aver_hid_req_isp_start_set_custom_cmd_isp(FuStructAverHidReqIspStart *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_aver_hid_req_isp_start_set_custom_isp_cmd: (skip):
 **/
void
fu_struct_aver_hid_req_isp_start_set_custom_isp_cmd(FuStructAverHidReqIspStart *st, FuAverHidCustomIspCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_aver_hid_req_isp_start_set_isp_cmd: (skip):
 **/
gboolean
fu_struct_aver_hid_req_isp_start_set_isp_cmd(FuStructAverHidReqIspStart *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 3, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_aver_hid_req_isp_start_set_end: (skip):
 **/
static void
fu_struct_aver_hid_req_isp_start_set_end(FuStructAverHidReqIspStart *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[511] = value;
}
/**
 * fu_struct_aver_hid_req_isp_start_new: (skip):
 **/
FuStructAverHidReqIspStart *
fu_struct_aver_hid_req_isp_start_new(void)
{
    FuStructAverHidReqIspStart *st = fu_struct_aver_hid_req_isp_start_new_internal();
    st->buf = g_byte_array_sized_new(512);
    fu_byte_array_set_size(st->buf, 512, 0x0);
    fu_struct_aver_hid_req_isp_start_set_report_id_custom_command(st, 0x08);
    fu_struct_aver_hid_req_isp_start_set_custom_cmd_isp(st, 0x10);
    memcpy(st->buf->data + 0x3, "\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF", 60); /* nocheck:blocked */
    memcpy(st->buf->data + 0x3F, "\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF", 448); /* nocheck:blocked */
    fu_struct_aver_hid_req_isp_start_set_end(st, 0x00);
    return st;
}
/**
 * fu_struct_aver_hid_req_device_version_ref: (skip):
 **/
FuStructAverHidReqDeviceVersion *
fu_struct_aver_hid_req_device_version_ref(FuStructAverHidReqDeviceVersion *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_aver_hid_req_device_version_unref: (skip):
 **/
void
fu_struct_aver_hid_req_device_version_unref(FuStructAverHidReqDeviceVersion *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructAverHidReqDeviceVersion refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructAverHidReqDeviceVersion *
fu_struct_aver_hid_req_device_version_new_internal(void)
{
    FuStructAverHidReqDeviceVersion *st = g_new0(FuStructAverHidReqDeviceVersion, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_aver_hid_req_device_version_get_ver: (skip):
 **/
const guint8 *
fu_struct_aver_hid_req_device_version_get_ver(const FuStructAverHidReqDeviceVersion *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 11;
    return st->buf->data + 2;
}

/* setters */
/**
 * fu_struct_aver_hid_req_device_version_set_report_id_custom_command: (skip):
 **/
static void
fu_struct_aver_hid_req_device_version_set_report_id_custom_command(FuStructAverHidReqDeviceVersion *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_aver_hid_req_device_version_set_custom_cmd_isp: (skip):
 **/
static void
fu_struct_aver_hid_req_device_version_set_custom_cmd_isp(FuStructAverHidReqDeviceVersion *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_aver_hid_req_device_version_set_ver: (skip):
 **/
gboolean
fu_struct_aver_hid_req_device_version_set_ver(FuStructAverHidReqDeviceVersion *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 2, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_aver_hid_req_device_version_set_end: (skip):
 **/
static void
fu_struct_aver_hid_req_device_version_set_end(FuStructAverHidReqDeviceVersion *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[511] = value;
}
/**
 * fu_struct_aver_hid_req_device_version_new: (skip):
 **/
FuStructAverHidReqDeviceVersion *
fu_struct_aver_hid_req_device_version_new(void)
{
    FuStructAverHidReqDeviceVersion *st = fu_struct_aver_hid_req_device_version_new_internal();
    st->buf = g_byte_array_sized_new(512);
    fu_byte_array_set_size(st->buf, 512, 0x0);
    fu_struct_aver_hid_req_device_version_set_report_id_custom_command(st, 0x08);
    fu_struct_aver_hid_req_device_version_set_custom_cmd_isp(st, 0x25);
    memcpy(st->buf->data + 0xD, "\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF", 498); /* nocheck:blocked */
    fu_struct_aver_hid_req_device_version_set_end(st, 0x00);
    return st;
}
/**
 * fu_struct_aver_hid_res_isp_status_ref: (skip):
 **/
FuStructAverHidResIspStatus *
fu_struct_aver_hid_res_isp_status_ref(FuStructAverHidResIspStatus *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_aver_hid_res_isp_status_unref: (skip):
 **/
void
fu_struct_aver_hid_res_isp_status_unref(FuStructAverHidResIspStatus *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructAverHidResIspStatus refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructAverHidResIspStatus *
fu_struct_aver_hid_res_isp_status_new_internal(void)
{
    FuStructAverHidResIspStatus *st = g_new0(FuStructAverHidResIspStatus, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_aver_hid_res_isp_status_get_report_id_custom_command: (skip):
 **/
static guint8
fu_struct_aver_hid_res_isp_status_get_report_id_custom_command(const FuStructAverHidResIspStatus *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_aver_hid_res_isp_status_get_custom_cmd_isp: (skip):
 **/
static guint8
fu_struct_aver_hid_res_isp_status_get_custom_cmd_isp(const FuStructAverHidResIspStatus *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_aver_hid_res_isp_status_get_custom_isp_cmd: (skip):
 **/
FuAverHidCustomIspCmd
fu_struct_aver_hid_res_isp_status_get_custom_isp_cmd(const FuStructAverHidResIspStatus *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_aver_hid_res_isp_status_get_status: (skip):
 **/
guint8
fu_struct_aver_hid_res_isp_status_get_status(const FuStructAverHidResIspStatus *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}
/**
 * fu_struct_aver_hid_res_isp_status_get_status_string: (skip):
 **/
gchar *
fu_struct_aver_hid_res_isp_status_get_status_string(const FuStructAverHidResIspStatus *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 4, 58, NULL);
}
/**
 * fu_struct_aver_hid_res_isp_status_get_progress: (skip):
 **/
guint8
fu_struct_aver_hid_res_isp_status_get_progress(const FuStructAverHidResIspStatus *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[62];
}
/**
 * fu_struct_aver_hid_res_isp_status_get_end: (skip):
 **/
static guint8
fu_struct_aver_hid_res_isp_status_get_end(const FuStructAverHidResIspStatus *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[511];
}

/* setters */
/**
 * fu_struct_aver_hid_res_isp_status_set_report_id_custom_command: (skip):
 **/
static void
fu_struct_aver_hid_res_isp_status_set_report_id_custom_command(FuStructAverHidResIspStatus *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_aver_hid_res_isp_status_set_custom_cmd_isp: (skip):
 **/
static void
fu_struct_aver_hid_res_isp_status_set_custom_cmd_isp(FuStructAverHidResIspStatus *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_aver_hid_res_isp_status_set_custom_isp_cmd: (skip):
 **/
void
fu_struct_aver_hid_res_isp_status_set_custom_isp_cmd(FuStructAverHidResIspStatus *st, FuAverHidCustomIspCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_aver_hid_res_isp_status_set_status: (skip):
 **/
void
fu_struct_aver_hid_res_isp_status_set_status(FuStructAverHidResIspStatus *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[3] = value;
}
/**
 * fu_struct_aver_hid_res_isp_status_set_status_string: (skip):
 **/
gboolean
fu_struct_aver_hid_res_isp_status_set_status_string(FuStructAverHidResIspStatus *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 4, 0x0, 58);
        return TRUE;
    }
    len = strlen(value);
    if (len > 58) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructAverHidResIspStatus.status_string (0x%x bytes)",
                    value, (guint) len, (guint) 58);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 4, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_aver_hid_res_isp_status_set_progress: (skip):
 **/
void
fu_struct_aver_hid_res_isp_status_set_progress(FuStructAverHidResIspStatus *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[62] = value;
}
/**
 * fu_struct_aver_hid_res_isp_status_set_end: (skip):
 **/
static void
fu_struct_aver_hid_res_isp_status_set_end(FuStructAverHidResIspStatus *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[511] = value;
}
/**
 * fu_struct_aver_hid_res_isp_status_new: (skip):
 **/
FuStructAverHidResIspStatus *
fu_struct_aver_hid_res_isp_status_new(void)
{
    FuStructAverHidResIspStatus *st = fu_struct_aver_hid_res_isp_status_new_internal();
    st->buf = g_byte_array_sized_new(512);
    fu_byte_array_set_size(st->buf, 512, 0x0);
    fu_struct_aver_hid_res_isp_status_set_report_id_custom_command(st, 0x09);
    fu_struct_aver_hid_res_isp_status_set_custom_cmd_isp(st, 0x10);
    memcpy(st->buf->data + 0x3F, "\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF", 448); /* nocheck:blocked */
    fu_struct_aver_hid_res_isp_status_set_end(st, 0x00);
    return st;
}
static gboolean
fu_struct_aver_hid_res_isp_status_validate_internal(FuStructAverHidResIspStatus *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_aver_hid_res_isp_status_get_report_id_custom_command(st) != 0x09) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructAverHidResIspStatus.report_id_custom_command was not valid");
        return FALSE;
    }
    if (fu_struct_aver_hid_res_isp_status_get_custom_cmd_isp(st) != 0x10) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructAverHidResIspStatus.custom_cmd_isp was not valid");
        return FALSE;
    }
    if (fu_struct_aver_hid_res_isp_status_get_end(st) != 0x00) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructAverHidResIspStatus.end was not valid");
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_aver_hid_res_isp_status_validate: (skip):
 **/
gboolean
fu_struct_aver_hid_res_isp_status_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st_buf = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    FuStructAverHidResIspStatus st_tmp = {.buf = &st_buf };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 512, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructAverHidResIspStatus: ");
        return FALSE;
    }
    if (!fu_struct_aver_hid_res_isp_status_validate_internal(&st_tmp, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_aver_hid_res_isp_ref: (skip):
 **/
FuStructAverHidResIsp *
fu_struct_aver_hid_res_isp_ref(FuStructAverHidResIsp *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_aver_hid_res_isp_unref: (skip):
 **/
void
fu_struct_aver_hid_res_isp_unref(FuStructAverHidResIsp *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructAverHidResIsp refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}

/* getters */
/**
 * fu_struct_aver_hid_res_isp_get_custom_isp_cmd: (skip):
 **/
FuAverHidCustomIspCmd
fu_struct_aver_hid_res_isp_get_custom_isp_cmd(const FuStructAverHidResIsp *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}

/* setters */
/**
 * fu_struct_aver_hid_res_isp_set_custom_isp_cmd: (skip):
 **/
void
fu_struct_aver_hid_res_isp_set_custom_isp_cmd(FuStructAverHidResIsp *st, FuAverHidCustomIspCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_aver_hid_res_device_version_ref: (skip):
 **/
FuStructAverHidResDeviceVersion *
fu_struct_aver_hid_res_device_version_ref(FuStructAverHidResDeviceVersion *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_aver_hid_res_device_version_unref: (skip):
 **/
void
fu_struct_aver_hid_res_device_version_unref(FuStructAverHidResDeviceVersion *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructAverHidResDeviceVersion refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructAverHidResDeviceVersion *
fu_struct_aver_hid_res_device_version_new_internal(void)
{
    FuStructAverHidResDeviceVersion *st = g_new0(FuStructAverHidResDeviceVersion, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_aver_hid_res_device_version_get_report_id_custom_command: (skip):
 **/
static guint8
fu_struct_aver_hid_res_device_version_get_report_id_custom_command(const FuStructAverHidResDeviceVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_aver_hid_res_device_version_get_custom_cmd_isp: (skip):
 **/
static guint8
fu_struct_aver_hid_res_device_version_get_custom_cmd_isp(const FuStructAverHidResDeviceVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_aver_hid_res_device_version_get_ver: (skip):
 **/
const guint8 *
fu_struct_aver_hid_res_device_version_get_ver(const FuStructAverHidResDeviceVersion *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 11;
    return st->buf->data + 2;
}
/**
 * fu_struct_aver_hid_res_device_version_get_end: (skip):
 **/
static guint8
fu_struct_aver_hid_res_device_version_get_end(const FuStructAverHidResDeviceVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[511];
}

/* setters */
/**
 * fu_struct_aver_hid_res_device_version_set_report_id_custom_command: (skip):
 **/
static void
fu_struct_aver_hid_res_device_version_set_report_id_custom_command(FuStructAverHidResDeviceVersion *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_aver_hid_res_device_version_set_custom_cmd_isp: (skip):
 **/
static void
fu_struct_aver_hid_res_device_version_set_custom_cmd_isp(FuStructAverHidResDeviceVersion *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_aver_hid_res_device_version_set_ver: (skip):
 **/
gboolean
fu_struct_aver_hid_res_device_version_set_ver(FuStructAverHidResDeviceVersion *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 2, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_aver_hid_res_device_version_set_end: (skip):
 **/
static void
fu_struct_aver_hid_res_device_version_set_end(FuStructAverHidResDeviceVersion *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[511] = value;
}
/**
 * fu_struct_aver_hid_res_device_version_new: (skip):
 **/
FuStructAverHidResDeviceVersion *
fu_struct_aver_hid_res_device_version_new(void)
{
    FuStructAverHidResDeviceVersion *st = fu_struct_aver_hid_res_device_version_new_internal();
    st->buf = g_byte_array_sized_new(512);
    fu_byte_array_set_size(st->buf, 512, 0x0);
    fu_struct_aver_hid_res_device_version_set_report_id_custom_command(st, 0x09);
    fu_struct_aver_hid_res_device_version_set_custom_cmd_isp(st, 0x25);
    memcpy(st->buf->data + 0xD, "\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF\xFF", 498); /* nocheck:blocked */
    fu_struct_aver_hid_res_device_version_set_end(st, 0x00);
    return st;
}
static gboolean
fu_struct_aver_hid_res_device_version_validate_internal(FuStructAverHidResDeviceVersion *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_aver_hid_res_device_version_get_report_id_custom_command(st) != 0x09) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructAverHidResDeviceVersion.report_id_custom_command was not valid");
        return FALSE;
    }
    if (fu_struct_aver_hid_res_device_version_get_custom_cmd_isp(st) != 0x25) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructAverHidResDeviceVersion.custom_cmd_isp was not valid");
        return FALSE;
    }
    if (fu_struct_aver_hid_res_device_version_get_end(st) != 0x00) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructAverHidResDeviceVersion.end was not valid");
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_aver_hid_res_device_version_validate: (skip):
 **/
gboolean
fu_struct_aver_hid_res_device_version_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st_buf = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    FuStructAverHidResDeviceVersion st_tmp = {.buf = &st_buf };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 512, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructAverHidResDeviceVersion: ");
        return FALSE;
    }
    if (!fu_struct_aver_hid_res_device_version_validate_internal(&st_tmp, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_aver_safeisp_req_ref: (skip):
 **/
FuStructAverSafeispReq *
fu_struct_aver_safeisp_req_ref(FuStructAverSafeispReq *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_aver_safeisp_req_unref: (skip):
 **/
void
fu_struct_aver_safeisp_req_unref(FuStructAverSafeispReq *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructAverSafeispReq refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructAverSafeispReq *
fu_struct_aver_safeisp_req_new_internal(void)
{
    FuStructAverSafeispReq *st = g_new0(FuStructAverSafeispReq, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_aver_safeisp_req_get_custom_cmd: (skip):
 **/
FuAverSafeispCustomCmd
fu_struct_aver_safeisp_req_get_custom_cmd(const FuStructAverSafeispReq *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_aver_safeisp_req_get_custom_res: (skip):
 **/
guint16
fu_struct_aver_safeisp_req_get_custom_res(const FuStructAverSafeispReq *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_aver_safeisp_req_get_custom_parm0: (skip):
 **/
guint32
fu_struct_aver_safeisp_req_get_custom_parm0(const FuStructAverSafeispReq *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_aver_safeisp_req_get_custom_parm1: (skip):
 **/
guint32
fu_struct_aver_safeisp_req_get_custom_parm1(const FuStructAverSafeispReq *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_aver_safeisp_req_get_data: (skip):
 **/
const guint8 *
fu_struct_aver_safeisp_req_get_data(const FuStructAverSafeispReq *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 1012;
    return st->buf->data + 12;
}

/* setters */
/**
 * fu_struct_aver_safeisp_req_set_report_id_custom_command: (skip):
 **/
static void
fu_struct_aver_safeisp_req_set_report_id_custom_command(FuStructAverSafeispReq *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_aver_safeisp_req_set_custom_cmd: (skip):
 **/
void
fu_struct_aver_safeisp_req_set_custom_cmd(FuStructAverSafeispReq *st, FuAverSafeispCustomCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_aver_safeisp_req_set_custom_res: (skip):
 **/
void
fu_struct_aver_safeisp_req_set_custom_res(FuStructAverSafeispReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_aver_safeisp_req_set_custom_parm0: (skip):
 **/
void
fu_struct_aver_safeisp_req_set_custom_parm0(FuStructAverSafeispReq *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_aver_safeisp_req_set_custom_parm1: (skip):
 **/
void
fu_struct_aver_safeisp_req_set_custom_parm1(FuStructAverSafeispReq *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_aver_safeisp_req_set_data: (skip):
 **/
gboolean
fu_struct_aver_safeisp_req_set_data(FuStructAverSafeispReq *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 12, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_aver_safeisp_req_new: (skip):
 **/
FuStructAverSafeispReq *
fu_struct_aver_safeisp_req_new(void)
{
    FuStructAverSafeispReq *st = fu_struct_aver_safeisp_req_new_internal();
    st->buf = g_byte_array_sized_new(1024);
    fu_byte_array_set_size(st->buf, 1024, 0x0);
    fu_struct_aver_safeisp_req_set_report_id_custom_command(st, 0x08);
    fu_struct_aver_safeisp_req_set_custom_parm0(st, 0x00);
    fu_struct_aver_safeisp_req_set_custom_parm1(st, 0x00);
    memcpy(st->buf->data + 0xC, "\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00", 1012); /* nocheck:blocked */
    return st;
}
/**
 * fu_struct_aver_safeisp_res_ref: (skip):
 **/
FuStructAverSafeispRes *
fu_struct_aver_safeisp_res_ref(FuStructAverSafeispRes *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_aver_safeisp_res_unref: (skip):
 **/
void
fu_struct_aver_safeisp_res_unref(FuStructAverSafeispRes *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructAverSafeispRes refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructAverSafeispRes *
fu_struct_aver_safeisp_res_new_internal(void)
{
    FuStructAverSafeispRes *st = g_new0(FuStructAverSafeispRes, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_aver_safeisp_res_get_report_id_custom_command: (skip):
 **/
static guint8
fu_struct_aver_safeisp_res_get_report_id_custom_command(const FuStructAverSafeispRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_aver_safeisp_res_get_custom_cmd: (skip):
 **/
guint8
fu_struct_aver_safeisp_res_get_custom_cmd(const FuStructAverSafeispRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_aver_safeisp_res_get_custom_res: (skip):
 **/
guint16
fu_struct_aver_safeisp_res_get_custom_res(const FuStructAverSafeispRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_aver_safeisp_res_get_custom_parm0: (skip):
 **/
guint32
fu_struct_aver_safeisp_res_get_custom_parm0(const FuStructAverSafeispRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_aver_safeisp_res_get_custom_parm1: (skip):
 **/
guint32
fu_struct_aver_safeisp_res_get_custom_parm1(const FuStructAverSafeispRes *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_aver_safeisp_res_get_data: (skip):
 **/
const guint8 *
fu_struct_aver_safeisp_res_get_data(const FuStructAverSafeispRes *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 4;
    return st->buf->data + 12;
}

/* setters */
/**
 * fu_struct_aver_safeisp_res_set_report_id_custom_command: (skip):
 **/
static void
fu_struct_aver_safeisp_res_set_report_id_custom_command(FuStructAverSafeispRes *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_aver_safeisp_res_set_custom_cmd: (skip):
 **/
void
fu_struct_aver_safeisp_res_set_custom_cmd(FuStructAverSafeispRes *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_aver_safeisp_res_set_custom_res: (skip):
 **/
void
fu_struct_aver_safeisp_res_set_custom_res(FuStructAverSafeispRes *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 2, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_aver_safeisp_res_set_custom_parm0: (skip):
 **/
void
fu_struct_aver_safeisp_res_set_custom_parm0(FuStructAverSafeispRes *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_aver_safeisp_res_set_custom_parm1: (skip):
 **/
void
fu_struct_aver_safeisp_res_set_custom_parm1(FuStructAverSafeispRes *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_aver_safeisp_res_set_data: (skip):
 **/
gboolean
fu_struct_aver_safeisp_res_set_data(FuStructAverSafeispRes *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 12, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_aver_safeisp_res_new: (skip):
 **/
FuStructAverSafeispRes *
fu_struct_aver_safeisp_res_new(void)
{
    FuStructAverSafeispRes *st = fu_struct_aver_safeisp_res_new_internal();
    st->buf = g_byte_array_sized_new(16);
    fu_byte_array_set_size(st->buf, 16, 0x0);
    fu_struct_aver_safeisp_res_set_report_id_custom_command(st, 0x09);
    memcpy(st->buf->data + 0xC, "\x00\x00\x00\x00", 4); /* nocheck:blocked */
    return st;
}
static gboolean
fu_struct_aver_safeisp_res_validate_internal(FuStructAverSafeispRes *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_aver_safeisp_res_get_report_id_custom_command(st) != 0x09) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructAverSafeispRes.report_id_custom_command was not valid");
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_aver_safeisp_res_validate: (skip):
 **/
gboolean
fu_struct_aver_safeisp_res_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st_buf = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    FuStructAverSafeispRes st_tmp = {.buf = &st_buf };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 16, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructAverSafeispRes: ");
        return FALSE;
    }
    if (!fu_struct_aver_safeisp_res_validate_internal(&st_tmp, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_aver_safeisp_res_device_version_ref: (skip):
 **/
FuStructAverSafeispResDeviceVersion *
fu_struct_aver_safeisp_res_device_version_ref(FuStructAverSafeispResDeviceVersion *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_aver_safeisp_res_device_version_unref: (skip):
 **/
void
fu_struct_aver_safeisp_res_device_version_unref(FuStructAverSafeispResDeviceVersion *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructAverSafeispResDeviceVersion refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructAverSafeispResDeviceVersion *
fu_struct_aver_safeisp_res_device_version_new_internal(void)
{
    FuStructAverSafeispResDeviceVersion *st = g_new0(FuStructAverSafeispResDeviceVersion, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_aver_safeisp_res_device_version_get_report_id_custom_command: (skip):
 **/
static guint8
fu_struct_aver_safeisp_res_device_version_get_report_id_custom_command(const FuStructAverSafeispResDeviceVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_aver_safeisp_res_device_version_get_custom_cmd: (skip):
 **/
static FuAverSafeispCustomCmd
fu_struct_aver_safeisp_res_device_version_get_custom_cmd(const FuStructAverSafeispResDeviceVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_aver_safeisp_res_device_version_get_ver: (skip):
 **/
const guint8 *
fu_struct_aver_safeisp_res_device_version_get_ver(const FuStructAverSafeispResDeviceVersion *st, gsize *bufsz)
{
    g_return_val_if_fail(st != NULL, NULL);
    if (bufsz != NULL)
        *bufsz = 11;
    return st->buf->data + 2;
}

/* setters */
/**
 * fu_struct_aver_safeisp_res_device_version_set_report_id_custom_command: (skip):
 **/
static void
fu_struct_aver_safeisp_res_device_version_set_report_id_custom_command(FuStructAverSafeispResDeviceVersion *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_aver_safeisp_res_device_version_set_custom_cmd: (skip):
 **/
static void
fu_struct_aver_safeisp_res_device_version_set_custom_cmd(FuStructAverSafeispResDeviceVersion *st, FuAverSafeispCustomCmd value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_aver_safeisp_res_device_version_set_ver: (skip):
 **/
gboolean
fu_struct_aver_safeisp_res_device_version_set_ver(FuStructAverSafeispResDeviceVersion *st, const guint8 *buf, gsize bufsz, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    return fu_memcpy_safe(st->buf->data, st->buf->len, 2, buf, bufsz, 0x0, bufsz, error);
}
/**
 * fu_struct_aver_safeisp_res_device_version_new: (skip):
 **/
FuStructAverSafeispResDeviceVersion *
fu_struct_aver_safeisp_res_device_version_new(void)
{
    FuStructAverSafeispResDeviceVersion *st = fu_struct_aver_safeisp_res_device_version_new_internal();
    st->buf = g_byte_array_sized_new(16);
    fu_byte_array_set_size(st->buf, 16, 0x0);
    fu_struct_aver_safeisp_res_device_version_set_report_id_custom_command(st, 0x09);
    fu_struct_aver_safeisp_res_device_version_set_custom_cmd(st, FU_AVER_SAFEISP_CUSTOM_CMD_GET_VERSION);
    memcpy(st->buf->data + 0xD, "\x00\x00\x00", 3); /* nocheck:blocked */
    return st;
}
static gboolean
fu_struct_aver_safeisp_res_device_version_validate_internal(FuStructAverSafeispResDeviceVersion *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_aver_safeisp_res_device_version_get_report_id_custom_command(st) != 0x09) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructAverSafeispResDeviceVersion.report_id_custom_command was not valid");
        return FALSE;
    }
    if (fu_struct_aver_safeisp_res_device_version_get_custom_cmd(st) != FU_AVER_SAFEISP_CUSTOM_CMD_GET_VERSION) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructAverSafeispResDeviceVersion.custom_cmd was not valid, "
                    "expected 'FuAverSafeispCustomCmd' and got '%s'",
                    fu_aver_safeisp_custom_cmd_to_string(fu_struct_aver_safeisp_res_device_version_get_custom_cmd(st)));
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_aver_safeisp_res_device_version_validate: (skip):
 **/
gboolean
fu_struct_aver_safeisp_res_device_version_validate(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    GByteArray st_buf = {.data = (guint8 *) buf + offset, .len = bufsz - offset, };
    FuStructAverSafeispResDeviceVersion st_tmp = {.buf = &st_buf };
    g_return_val_if_fail(buf != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (!fu_memchk_read(bufsz, offset, 16, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructAverSafeispResDeviceVersion: ");
        return FALSE;
    }
    if (!fu_struct_aver_safeisp_res_device_version_validate_internal(&st_tmp, error))
        return FALSE;
    return TRUE;
}
