/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-ep963x-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

const gchar *
fu_ep963x_smbus_error_to_string(FuEp963xSmbusError val)
{
    if (val == FU_EP963X_SMBUS_ERROR_NONE)
        return "none";
    if (val == FU_EP963X_SMBUS_ERROR_ADDRESS)
        return "address";
    if (val == FU_EP963X_SMBUS_ERROR_NO_ACK)
        return "no-ack";
    if (val == FU_EP963X_SMBUS_ERROR_ARBITRATION)
        return "arbitration";
    if (val == FU_EP963X_SMBUS_ERROR_COMMAND)
        return "command";
    if (val == FU_EP963X_SMBUS_ERROR_TIMEOUT)
        return "timeout";
    if (val == FU_EP963X_SMBUS_ERROR_BUSY)
        return "busy";
    return NULL;
}




/**
 * fu_struct_ep963x_firmware_hdr_ref: (skip):
 **/
FuStructEp963xFirmwareHdr *
fu_struct_ep963x_firmware_hdr_ref(FuStructEp963xFirmwareHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_ep963x_firmware_hdr_unref: (skip):
 **/
void
fu_struct_ep963x_firmware_hdr_unref(FuStructEp963xFirmwareHdr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructEp963xFirmwareHdr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructEp963xFirmwareHdr *
fu_struct_ep963x_firmware_hdr_new_internal(void)
{
    FuStructEp963xFirmwareHdr *st = g_new0(FuStructEp963xFirmwareHdr, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_ep963x_firmware_hdr_get_magic: (skip):
 **/
static gchar *
fu_struct_ep963x_firmware_hdr_get_magic(const FuStructEp963xFirmwareHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 16, 5, NULL);
}

/* setters */
static gboolean
fu_struct_ep963x_firmware_hdr_validate_internal(FuStructEp963xFirmwareHdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (strncmp((const gchar *) (st->buf->data + 16), "EP963", 5) != 0) {
        g_autofree gchar *str = fu_struct_ep963x_firmware_hdr_get_magic(st);
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructEp963xFirmwareHdr.magic was not valid, "
                    "expected 'EP963' and got '%s'",
                    str);
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_ep963x_firmware_hdr_validate_stream: (skip):
 **/
gboolean
fu_struct_ep963x_firmware_hdr_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructEp963xFirmwareHdr) st = fu_struct_ep963x_firmware_hdr_new_internal();
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st->buf = fu_input_stream_read_byte_array(stream, offset, 21, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructEp963xFirmwareHdr failed read of 0x%x: ", (guint) 21);
        return FALSE;
    }
    if (st->buf->len != 21) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructEp963xFirmwareHdr requested 0x%x and got 0x%x",
                    (guint) 21,
                    (guint) st->buf->len);
        return FALSE;
    }
    return fu_struct_ep963x_firmware_hdr_validate_internal(st, error);
}
