/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-fpc-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"


static const gchar *
fu_fpc_ff2_block_dir_to_string(FuFpcFf2BlockDir val)
{
    if (val == FU_FPC_FF2_BLOCK_DIR_OUT)
        return "out";
    if (val == FU_FPC_FF2_BLOCK_DIR_IN)
        return "in";
    return NULL;
}
/**
 * fu_struct_fpc_dfu_ref: (skip):
 **/
FuStructFpcDfu *
fu_struct_fpc_dfu_ref(FuStructFpcDfu *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_fpc_dfu_unref: (skip):
 **/
void
fu_struct_fpc_dfu_unref(FuStructFpcDfu *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructFpcDfu refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructFpcDfu *
fu_struct_fpc_dfu_new_internal(void)
{
    FuStructFpcDfu *st = g_new0(FuStructFpcDfu, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_fpc_dfu_get_status: (skip):
 **/
guint8
fu_struct_fpc_dfu_get_status(const FuStructFpcDfu *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_fpc_dfu_get_max_payload_size: (skip):
 **/
guint8
fu_struct_fpc_dfu_get_max_payload_size(const FuStructFpcDfu *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_fpc_dfu_get_state: (skip):
 **/
FuFpcDfuState
fu_struct_fpc_dfu_get_state(const FuStructFpcDfu *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[4];
}

/* setters */
/**
 * fu_struct_fpc_dfu_set_status: (skip):
 **/
void
fu_struct_fpc_dfu_set_status(FuStructFpcDfu *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[0] = value;
}
/**
 * fu_struct_fpc_dfu_set_max_payload_size: (skip):
 **/
void
fu_struct_fpc_dfu_set_max_payload_size(FuStructFpcDfu *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[1] = value;
}
/**
 * fu_struct_fpc_dfu_set_state: (skip):
 **/
void
fu_struct_fpc_dfu_set_state(FuStructFpcDfu *st, FuFpcDfuState value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[4] = value;
}
/**
 * fu_struct_fpc_dfu_new: (skip):
 **/
FuStructFpcDfu *
fu_struct_fpc_dfu_new(void)
{
    FuStructFpcDfu *st = fu_struct_fpc_dfu_new_internal();
    st->buf = g_byte_array_sized_new(6);
    fu_byte_array_set_size(st->buf, 6, 0x0);
    return st;
}
/**
 * fu_struct_fpc_ff2_hdr_ref: (skip):
 **/
FuStructFpcFf2Hdr *
fu_struct_fpc_ff2_hdr_ref(FuStructFpcFf2Hdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_fpc_ff2_hdr_unref: (skip):
 **/
void
fu_struct_fpc_ff2_hdr_unref(FuStructFpcFf2Hdr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructFpcFf2Hdr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructFpcFf2Hdr *
fu_struct_fpc_ff2_hdr_new_internal(void)
{
    FuStructFpcFf2Hdr *st = g_new0(FuStructFpcFf2Hdr, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_fpc_ff2_hdr_get_compat_sig: (skip):
 **/
static gchar *
fu_struct_fpc_ff2_hdr_get_compat_sig(const FuStructFpcFf2Hdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 7, NULL);
}
/**
 * fu_struct_fpc_ff2_hdr_get_blocks_num: (skip):
 **/
guint32
fu_struct_fpc_ff2_hdr_get_blocks_num(const FuStructFpcFf2Hdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 27, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_fpc_ff2_hdr_to_string: (skip):
 **/
static gchar *
fu_struct_fpc_ff2_hdr_to_string(const FuStructFpcFf2Hdr *st)
{
    g_autoptr(GString) str = g_string_new("FuStructFpcFf2Hdr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  blocks_num: 0x%x\n",
                           (guint) fu_struct_fpc_ff2_hdr_get_blocks_num(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_fpc_ff2_hdr_validate_internal(FuStructFpcFf2Hdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (strncmp((const gchar *) (st->buf->data + 0), "FPC0001", 7) != 0) {
        g_autofree gchar *str = fu_struct_fpc_ff2_hdr_get_compat_sig(st);
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructFpcFf2Hdr.compat_sig was not valid, "
                    "expected 'FPC0001' and got '%s'",
                    str);
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_fpc_ff2_hdr_validate_stream: (skip):
 **/
gboolean
fu_struct_fpc_ff2_hdr_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructFpcFf2Hdr) st = fu_struct_fpc_ff2_hdr_new_internal();
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st->buf = fu_input_stream_read_byte_array(stream, offset, 37, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructFpcFf2Hdr failed read of 0x%x: ", (guint) 37);
        return FALSE;
    }
    if (st->buf->len != 37) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructFpcFf2Hdr requested 0x%x and got 0x%x",
                    (guint) 37,
                    (guint) st->buf->len);
        return FALSE;
    }
    return fu_struct_fpc_ff2_hdr_validate_internal(st, error);
}
static gboolean
fu_struct_fpc_ff2_hdr_parse_internal(FuStructFpcFf2Hdr *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_fpc_ff2_hdr_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_fpc_ff2_hdr_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_fpc_ff2_hdr_parse_stream: (skip):
 **/
FuStructFpcFf2Hdr *
fu_struct_fpc_ff2_hdr_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructFpcFf2Hdr) st = fu_struct_fpc_ff2_hdr_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 37, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructFpcFf2Hdr failed read of 0x%x: ", (guint) 37);
        return NULL;
    }
    if (st->buf->len != 37) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructFpcFf2Hdr requested 0x%x and got 0x%x",
                    (guint) 37,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_fpc_ff2_hdr_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_fpc_ff2_block_hdr_ref: (skip):
 **/
FuStructFpcFf2BlockHdr *
fu_struct_fpc_ff2_block_hdr_ref(FuStructFpcFf2BlockHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_fpc_ff2_block_hdr_unref: (skip):
 **/
void
fu_struct_fpc_ff2_block_hdr_unref(FuStructFpcFf2BlockHdr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructFpcFf2BlockHdr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructFpcFf2BlockHdr *
fu_struct_fpc_ff2_block_hdr_new_internal(void)
{
    FuStructFpcFf2BlockHdr *st = g_new0(FuStructFpcFf2BlockHdr, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_fpc_ff2_block_hdr_get_meta_type: (skip):
 **/
static guint8
fu_struct_fpc_ff2_block_hdr_get_meta_type(const FuStructFpcFf2BlockHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_fpc_ff2_block_hdr_get_meta_id: (skip):
 **/
guint8
fu_struct_fpc_ff2_block_hdr_get_meta_id(const FuStructFpcFf2BlockHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_fpc_ff2_block_hdr_get_dir: (skip):
 **/
FuFpcFf2BlockDir
fu_struct_fpc_ff2_block_hdr_get_dir(const FuStructFpcFf2BlockHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}

/* setters */
/**
 * fu_struct_fpc_ff2_block_hdr_to_string: (skip):
 **/
static gchar *
fu_struct_fpc_ff2_block_hdr_to_string(const FuStructFpcFf2BlockHdr *st)
{
    g_autoptr(GString) str = g_string_new("FuStructFpcFf2BlockHdr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  meta_id: 0x%x\n",
                           (guint) fu_struct_fpc_ff2_block_hdr_get_meta_id(st));
    {
        const gchar *tmp = fu_fpc_ff2_block_dir_to_string(fu_struct_fpc_ff2_block_hdr_get_dir(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  dir: 0x%x [%s]\n", (guint) fu_struct_fpc_ff2_block_hdr_get_dir(st), tmp);
        } else {
            g_string_append_printf(str, "  dir: 0x%x\n", (guint) fu_struct_fpc_ff2_block_hdr_get_dir(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_fpc_ff2_block_hdr_validate_internal(FuStructFpcFf2BlockHdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_fpc_ff2_block_hdr_get_meta_type(st) != 0xCD) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructFpcFf2BlockHdr.meta_type was not valid");
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_fpc_ff2_block_hdr_parse_internal(FuStructFpcFf2BlockHdr *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_fpc_ff2_block_hdr_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_fpc_ff2_block_hdr_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_fpc_ff2_block_hdr_parse_stream: (skip):
 **/
FuStructFpcFf2BlockHdr *
fu_struct_fpc_ff2_block_hdr_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructFpcFf2BlockHdr) st = fu_struct_fpc_ff2_block_hdr_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 3, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructFpcFf2BlockHdr failed read of 0x%x: ", (guint) 3);
        return NULL;
    }
    if (st->buf->len != 3) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructFpcFf2BlockHdr requested 0x%x and got 0x%x",
                    (guint) 3,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_fpc_ff2_block_hdr_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_fpc_ff2_block_sec_ref: (skip):
 **/
FuStructFpcFf2BlockSec *
fu_struct_fpc_ff2_block_sec_ref(FuStructFpcFf2BlockSec *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_fpc_ff2_block_sec_unref: (skip):
 **/
void
fu_struct_fpc_ff2_block_sec_unref(FuStructFpcFf2BlockSec *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructFpcFf2BlockSec refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
static FuStructFpcFf2BlockSec *
fu_struct_fpc_ff2_block_sec_new_internal(void)
{
    FuStructFpcFf2BlockSec *st = g_new0(FuStructFpcFf2BlockSec, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_fpc_ff2_block_sec_get_header: (skip):
 **/
static guint8
fu_struct_fpc_ff2_block_sec_get_header(const FuStructFpcFf2BlockSec *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[0];
}
/**
 * fu_struct_fpc_ff2_block_sec_get_type: (skip):
 **/
guint8
fu_struct_fpc_ff2_block_sec_get_type(const FuStructFpcFf2BlockSec *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[1];
}
/**
 * fu_struct_fpc_ff2_block_sec_get_payload_len: (skip):
 **/
guint16
fu_struct_fpc_ff2_block_sec_get_payload_len(const FuStructFpcFf2BlockSec *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 2, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_fpc_ff2_block_sec_to_string: (skip):
 **/
static gchar *
fu_struct_fpc_ff2_block_sec_to_string(const FuStructFpcFf2BlockSec *st)
{
    g_autoptr(GString) str = g_string_new("FuStructFpcFf2BlockSec:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  type: 0x%x\n",
                           (guint) fu_struct_fpc_ff2_block_sec_get_type(st));
    g_string_append_printf(str, "  payload_len: 0x%x\n",
                           (guint) fu_struct_fpc_ff2_block_sec_get_payload_len(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_fpc_ff2_block_sec_validate_internal(FuStructFpcFf2BlockSec *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_fpc_ff2_block_sec_get_header(st) != 0xEE) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructFpcFf2BlockSec.header was not valid");
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_fpc_ff2_block_sec_parse_internal(FuStructFpcFf2BlockSec *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_fpc_ff2_block_sec_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_fpc_ff2_block_sec_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_fpc_ff2_block_sec_parse_stream: (skip):
 **/
FuStructFpcFf2BlockSec *
fu_struct_fpc_ff2_block_sec_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructFpcFf2BlockSec) st = fu_struct_fpc_ff2_block_sec_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 4, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructFpcFf2BlockSec failed read of 0x%x: ", (guint) 4);
        return NULL;
    }
    if (st->buf->len != 4) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructFpcFf2BlockSec requested 0x%x and got 0x%x",
                    (guint) 4,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_fpc_ff2_block_sec_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
