/* math-history.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from math-history.vala, do not modify */

/*
 * Copyright (C) 2014 ELITA ASTRID ANGELINA LOBO
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
*/

#include <adwaita.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include "calculator.h"
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_HISTORY_VIEW (history_view_get_type ())
#define HISTORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_VIEW, HistoryView))
#define HISTORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_VIEW, HistoryViewClass))
#define IS_HISTORY_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_VIEW))
#define IS_HISTORY_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_VIEW))
#define HISTORY_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_VIEW, HistoryViewClass))

typedef struct _HistoryView HistoryView;
typedef struct _HistoryViewClass HistoryViewClass;
typedef struct _HistoryViewPrivate HistoryViewPrivate;
enum  {
	HISTORY_VIEW_0_PROPERTY,
	HISTORY_VIEW_ROWS_PROPERTY,
	HISTORY_VIEW_CURRENT_PROPERTY,
	HISTORY_VIEW_NUM_PROPERTIES
};
static GParamSpec* history_view_properties[HISTORY_VIEW_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_HISTORY_ENTRY (history_entry_get_type ())
#define HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HISTORY_ENTRY, HistoryEntry))
#define HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HISTORY_ENTRY, HistoryEntryClass))
#define IS_HISTORY_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HISTORY_ENTRY))
#define IS_HISTORY_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HISTORY_ENTRY))
#define HISTORY_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HISTORY_ENTRY, HistoryEntryClass))

typedef struct _HistoryEntry HistoryEntry;
typedef struct _HistoryEntryClass HistoryEntryClass;
enum  {
	HISTORY_VIEW_ANSWER_CLICKED_SIGNAL,
	HISTORY_VIEW_EQUATION_CLICKED_SIGNAL,
	HISTORY_VIEW_ROW_ADDED_SIGNAL,
	HISTORY_VIEW_NUM_SIGNALS
};
static guint history_view_signals[HISTORY_VIEW_NUM_SIGNALS] = {0};
typedef struct _HistoryEntryPrivate HistoryEntryPrivate;
enum  {
	HISTORY_ENTRY_0_PROPERTY,
	HISTORY_ENTRY_NUM_PROPERTIES
};
static GParamSpec* history_entry_properties[HISTORY_ENTRY_NUM_PROPERTIES];
enum  {
	HISTORY_ENTRY_ANSWER_CLICKED_SIGNAL,
	HISTORY_ENTRY_EQUATION_CLICKED_SIGNAL,
	HISTORY_ENTRY_NUM_SIGNALS
};
static guint history_entry_signals[HISTORY_ENTRY_NUM_SIGNALS] = {0};

struct _HistoryView {
	AdwBin parent_instance;
	HistoryViewPrivate * priv;
};

struct _HistoryViewClass {
	AdwBinClass parent_class;
};

struct _HistoryViewPrivate {
	gchar* last_equation;
	GtkListBox* listbox;
	Serializer* serializer;
	gint _rows;
	gint _current;
};

struct _HistoryEntry {
	GtkListBoxRow parent_instance;
	HistoryEntryPrivate * priv;
	GtkLabel* equation_label;
	GtkLabel* answer_label;
	GtkGrid* grid;
};

struct _HistoryEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _HistoryEntryPrivate {
	Number* number;
};

static gint HistoryView_private_offset;
static gpointer history_view_parent_class = NULL;
static gint HistoryEntry_private_offset;
static gpointer history_entry_parent_class = NULL;

VALA_EXTERN GType history_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (HistoryView, g_object_unref)
VALA_EXTERN GType history_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (HistoryEntry, g_object_unref)
VALA_EXTERN HistoryEntry* history_view_get_entry_at (HistoryView* self,
                                         gint index);
VALA_EXTERN gint history_view_get_rows (HistoryView* self);
VALA_EXTERN void history_view_scroll_bottom (HistoryView* self);
static void _history_view_scroll_bottom_history_view_row_added (HistoryView* _sender,
                                                         gpointer self);
VALA_EXTERN void history_view_insert_entry (HistoryView* self,
                                const gchar* equation,
                                Number* answer,
                                gint number_base,
                                guint representation_base);
VALA_EXTERN HistoryEntry* history_entry_new (const gchar* equation,
                                 Number* answer,
                                 Serializer* serializer);
VALA_EXTERN HistoryEntry* history_entry_construct (GType object_type,
                                       const gchar* equation,
                                       Number* answer,
                                       Serializer* serializer);
static void __lambda13_ (HistoryView* self,
                  const gchar* ans);
static void ___lambda13__history_entry_answer_clicked (HistoryEntry* _sender,
                                                const gchar* ans,
                                                gpointer self);
static void __lambda14_ (HistoryView* self,
                  const gchar* eq);
static void ___lambda14__history_entry_equation_clicked (HistoryEntry* _sender,
                                                  const gchar* equation,
                                                  gpointer self);
VALA_EXTERN void history_view_set_current (HistoryView* self,
                               gint value);
VALA_EXTERN void history_view_clear (HistoryView* self);
VALA_EXTERN void history_view_set_serializer (HistoryView* self,
                                  Serializer* serializer);
VALA_EXTERN void history_entry_redisplay (HistoryEntry* self,
                              Serializer* serializer);
VALA_EXTERN HistoryView* history_view_new (void);
VALA_EXTERN HistoryView* history_view_construct (GType object_type);
VALA_EXTERN gint history_view_get_current (HistoryView* self);
static void history_view_finalize (GObject * obj);
static GType history_view_get_type_once (void);
static void _vala_history_view_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec);
static void _vala_history_view_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec);
static void history_entry_finalize (GObject * obj);
static GType history_entry_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
history_view_get_instance_private (HistoryView* self)
{
	return G_STRUCT_MEMBER_P (self, HistoryView_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

HistoryEntry*
history_view_get_entry_at (HistoryView* self,
                           gint index)
{
	gboolean _tmp0_ = FALSE;
	HistoryEntry* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (index >= 0) {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = history_view_get_rows (self);
		_tmp2_ = _tmp1_;
		_tmp0_ = index < _tmp2_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkListBox* _tmp3_;
		GtkListBoxRow* _tmp4_;
		HistoryEntry* _tmp5_;
		_tmp3_ = self->priv->listbox;
		_tmp4_ = gtk_list_box_get_row_at_index (_tmp3_, index);
		_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_HISTORY_ENTRY, HistoryEntry));
		result = _tmp5_;
		return result;
	}
	result = NULL;
	return result;
}

void
history_view_scroll_bottom (HistoryView* self)
{
	GtkAdjustment* adjustment = NULL;
	GtkListBox* _tmp0_;
	GtkAdjustment* _tmp1_;
	GtkAdjustment* _tmp2_;
	gint width = 0;
	gint height = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->listbox;
	_tmp1_ = gtk_list_box_get_adjustment (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	adjustment = _tmp2_;
	gtk_widget_get_size_request ((GtkWidget*) self, &_tmp3_, &_tmp4_);
	width = _tmp3_;
	height = _tmp4_;
	gtk_adjustment_set_page_size (adjustment, (gdouble) (height / 3));
	gtk_adjustment_set_value (adjustment, gtk_adjustment_get_upper (adjustment) - gtk_adjustment_get_page_size (adjustment));
	_g_object_unref0 (adjustment);
}

static void
_history_view_scroll_bottom_history_view_row_added (HistoryView* _sender,
                                                    gpointer self)
{
	history_view_scroll_bottom ((HistoryView*) self);
}

static void
__lambda13_ (HistoryView* self,
             const gchar* ans)
{
	g_return_if_fail (ans != NULL);
	g_signal_emit (self, history_view_signals[HISTORY_VIEW_ANSWER_CLICKED_SIGNAL], 0, ans);
}

static void
___lambda13__history_entry_answer_clicked (HistoryEntry* _sender,
                                           const gchar* ans,
                                           gpointer self)
{
	__lambda13_ ((HistoryView*) self, ans);
}

static void
__lambda14_ (HistoryView* self,
             const gchar* eq)
{
	g_return_if_fail (eq != NULL);
	g_signal_emit (self, history_view_signals[HISTORY_VIEW_EQUATION_CLICKED_SIGNAL], 0, eq);
}

static void
___lambda14__history_entry_equation_clicked (HistoryEntry* _sender,
                                             const gchar* equation,
                                             gpointer self)
{
	__lambda14_ ((HistoryView*) self, equation);
}

void
history_view_insert_entry (HistoryView* self,
                           const gchar* equation,
                           Number* answer,
                           gint number_base,
                           guint representation_base)
{
	const gchar* _tmp0_;
	HistoryEntry* entry = NULL;
	Serializer* _tmp1_;
	HistoryEntry* _tmp2_;
	GtkListBox* _tmp3_;
	HistoryEntry* _tmp4_;
	HistoryEntry* _tmp5_;
	HistoryEntry* _tmp6_;
	gchar* _tmp7_;
	gint _tmp8_;
	gint _tmp9_;
	gint _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (equation != NULL);
	g_return_if_fail (answer != NULL);
	_tmp0_ = self->priv->last_equation;
	if (g_strcmp0 (_tmp0_, equation) == 0) {
		return;
	}
	_tmp1_ = self->priv->serializer;
	_tmp2_ = history_entry_new (equation, answer, _tmp1_);
	g_object_ref_sink (_tmp2_);
	entry = _tmp2_;
	_tmp3_ = self->priv->listbox;
	_tmp4_ = entry;
	gtk_list_box_insert (_tmp3_, (GtkWidget*) _tmp4_, -1);
	_tmp5_ = entry;
	g_signal_connect_object (_tmp5_, "answer-clicked", (GCallback) ___lambda13__history_entry_answer_clicked, self, 0);
	_tmp6_ = entry;
	g_signal_connect_object (_tmp6_, "equation-clicked", (GCallback) ___lambda14__history_entry_equation_clicked, self, 0);
	_tmp7_ = g_strdup (equation);
	_g_free0 (self->priv->last_equation);
	self->priv->last_equation = _tmp7_;
	_tmp8_ = self->priv->_rows;
	self->priv->_rows = _tmp8_ + 1;
	_tmp9_ = history_view_get_rows (self);
	_tmp10_ = _tmp9_;
	history_view_set_current (self, _tmp10_ - 1);
	g_signal_emit (self, history_view_signals[HISTORY_VIEW_ROW_ADDED_SIGNAL], 0);
	_g_object_unref0 (entry);
}

void
history_view_clear (HistoryView* self)
{
	g_return_if_fail (self != NULL);
	self->priv->_rows = 0;
	self->priv->_current = 0;
	{
		GtkWidget* child = NULL;
		GtkListBox* _tmp0_;
		GtkListBoxRow* _tmp1_;
		GtkWidget* _tmp2_;
		_tmp0_ = self->priv->listbox;
		_tmp1_ = gtk_list_box_get_row_at_index (_tmp0_, 0);
		_tmp2_ = _g_object_ref0 ((GtkWidget*) _tmp1_);
		child = _tmp2_;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GtkWidget* _tmp7_;
				GtkListBox* _tmp8_;
				GtkWidget* _tmp9_;
				if (!_tmp3_) {
					GtkListBox* _tmp4_;
					GtkListBoxRow* _tmp5_;
					GtkWidget* _tmp6_;
					_tmp4_ = self->priv->listbox;
					_tmp5_ = gtk_list_box_get_row_at_index (_tmp4_, 0);
					_tmp6_ = _g_object_ref0 ((GtkWidget*) _tmp5_);
					_g_object_unref0 (child);
					child = _tmp6_;
				}
				_tmp3_ = FALSE;
				_tmp7_ = child;
				if (!(_tmp7_ != NULL)) {
					break;
				}
				_tmp8_ = self->priv->listbox;
				_tmp9_ = child;
				gtk_list_box_remove (_tmp8_, _tmp9_);
			}
		}
		_g_object_unref0 (child);
	}
}

void
history_view_set_serializer (HistoryView* self,
                             Serializer* serializer)
{
	Serializer* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (serializer != NULL);
	_tmp0_ = _g_object_ref0 (serializer);
	_g_object_unref0 (self->priv->serializer);
	self->priv->serializer = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				HistoryEntry* child = NULL;
				GtkListBox* _tmp3_;
				GtkListBoxRow* _tmp4_;
				HistoryEntry* _tmp5_;
				HistoryEntry* _tmp6_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < self->priv->_rows)) {
					break;
				}
				_tmp3_ = self->priv->listbox;
				_tmp4_ = gtk_list_box_get_row_at_index (_tmp3_, i);
				_tmp5_ = _g_object_ref0 (IS_HISTORY_ENTRY (_tmp4_) ? ((HistoryEntry*) _tmp4_) : NULL);
				child = _tmp5_;
				_tmp6_ = child;
				history_entry_redisplay (_tmp6_, serializer);
				_g_object_unref0 (child);
			}
		}
	}
}

HistoryView*
history_view_construct (GType object_type)
{
	HistoryView * self = NULL;
	self = (HistoryView*) g_object_new (object_type, NULL);
	return self;
}

HistoryView*
history_view_new (void)
{
	return history_view_construct (TYPE_HISTORY_VIEW);
}

gint
history_view_get_rows (HistoryView* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_rows;
	return result;
}

gint
history_view_get_current (HistoryView* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_current;
	return result;
}

void
history_view_set_current (HistoryView* self,
                          gint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_current = CLAMP (value, 0, self->priv->_rows);
	g_object_notify_by_pspec ((GObject *) self, history_view_properties[HISTORY_VIEW_CURRENT_PROPERTY]);
}

static void
history_view_class_init (HistoryViewClass * klass,
                         gpointer klass_data)
{
	history_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &HistoryView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_history_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_history_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = history_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), HISTORY_VIEW_ROWS_PROPERTY, history_view_properties[HISTORY_VIEW_ROWS_PROPERTY] = g_param_spec_int ("rows", "rows", "rows", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), HISTORY_VIEW_CURRENT_PROPERTY, history_view_properties[HISTORY_VIEW_CURRENT_PROPERTY] = g_param_spec_int ("current", "current", "current", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/calculator/history-view.ui");
	history_view_signals[HISTORY_VIEW_ANSWER_CLICKED_SIGNAL] = g_signal_new ("answer-clicked", TYPE_HISTORY_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	history_view_signals[HISTORY_VIEW_EQUATION_CLICKED_SIGNAL] = g_signal_new ("equation-clicked", TYPE_HISTORY_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	history_view_signals[HISTORY_VIEW_ROW_ADDED_SIGNAL] = g_signal_new ("row-added", TYPE_HISTORY_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "listbox", FALSE, HistoryView_private_offset + G_STRUCT_OFFSET (HistoryViewPrivate, listbox));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "scroll_bottom", G_CALLBACK(_history_view_scroll_bottom_history_view_row_added));
}

static void
history_view_instance_init (HistoryView * self,
                            gpointer klass)
{
	self->priv = history_view_get_instance_private (self);
	self->priv->last_equation = NULL;
	self->priv->_rows = 0;
	self->priv->_current = 0;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
history_view_finalize (GObject * obj)
{
	HistoryView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HISTORY_VIEW, HistoryView);
	_g_free0 (self->priv->last_equation);
	_g_object_unref0 (self->priv->serializer);
	G_OBJECT_CLASS (history_view_parent_class)->finalize (obj);
}

static GType
history_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (HistoryViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) history_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HistoryView), 0, (GInstanceInitFunc) history_view_instance_init, NULL };
	GType history_view_type_id;
	history_view_type_id = g_type_register_static (adw_bin_get_type (), "HistoryView", &g_define_type_info, 0);
	HistoryView_private_offset = g_type_add_instance_private (history_view_type_id, sizeof (HistoryViewPrivate));
	return history_view_type_id;
}

GType
history_view_get_type (void)
{
	static volatile gsize history_view_type_id__once = 0;
	if (g_once_init_enter (&history_view_type_id__once)) {
		GType history_view_type_id;
		history_view_type_id = history_view_get_type_once ();
		g_once_init_leave (&history_view_type_id__once, history_view_type_id);
	}
	return history_view_type_id__once;
}

static void
_vala_history_view_get_property (GObject * object,
                                 guint property_id,
                                 GValue * value,
                                 GParamSpec * pspec)
{
	HistoryView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_HISTORY_VIEW, HistoryView);
	switch (property_id) {
		case HISTORY_VIEW_ROWS_PROPERTY:
		g_value_set_int (value, history_view_get_rows (self));
		break;
		case HISTORY_VIEW_CURRENT_PROPERTY:
		g_value_set_int (value, history_view_get_current (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_history_view_set_property (GObject * object,
                                 guint property_id,
                                 const GValue * value,
                                 GParamSpec * pspec)
{
	HistoryView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_HISTORY_VIEW, HistoryView);
	switch (property_id) {
		case HISTORY_VIEW_CURRENT_PROPERTY:
		history_view_set_current (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
history_entry_get_instance_private (HistoryEntry* self)
{
	return G_STRUCT_MEMBER_P (self, HistoryEntry_private_offset);
}

HistoryEntry*
history_entry_construct (GType object_type,
                         const gchar* equation,
                         Number* answer,
                         Serializer* serializer)
{
	HistoryEntry * self = NULL;
	Number* _tmp0_;
	GtkGrid* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (equation != NULL, NULL);
	g_return_val_if_fail (answer != NULL, NULL);
	g_return_val_if_fail (serializer != NULL, NULL);
	self = (HistoryEntry*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (answer);
	_g_object_unref0 (self->priv->number);
	self->priv->number = _tmp0_;
	_tmp1_ = self->grid;
	gtk_widget_set_direction ((GtkWidget*) _tmp1_, GTK_TEXT_DIR_LTR);
	_tmp2_ = self->equation_label;
	gtk_widget_set_direction ((GtkWidget*) _tmp2_, GTK_TEXT_DIR_LTR);
	_tmp3_ = self->answer_label;
	gtk_widget_set_direction ((GtkWidget*) _tmp3_, GTK_TEXT_DIR_LTR);
	_tmp4_ = self->equation_label;
	gtk_label_set_text (_tmp4_, equation);
	_tmp5_ = self->equation_label;
	_tmp6_ = g_strconcat ("\u200E", equation, NULL);
	_tmp7_ = _tmp6_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp5_, _tmp7_);
	_g_free0 (_tmp7_);
	history_entry_redisplay (self, serializer);
	return self;
}

HistoryEntry*
history_entry_new (const gchar* equation,
                   Number* answer,
                   Serializer* serializer)
{
	return history_entry_construct (TYPE_HISTORY_ENTRY, equation, answer, serializer);
}

void
history_entry_redisplay (HistoryEntry* self,
                         Serializer* serializer)
{
	gchar* answer = NULL;
	Number* _tmp0_;
	gchar* _tmp1_;
	GtkLabel* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GtkLabel* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (serializer != NULL);
	_tmp0_ = self->priv->number;
	_tmp1_ = serializer_to_string (serializer, _tmp0_);
	answer = _tmp1_;
	_tmp2_ = self->answer_label;
	_tmp3_ = g_strconcat ("\u200E", answer, NULL);
	_tmp4_ = _tmp3_;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp2_, _tmp4_);
	_g_free0 (_tmp4_);
	_tmp5_ = self->answer_label;
	gtk_label_set_text (_tmp5_, answer);
	_g_free0 (answer);
}

static void
history_entry_class_init (HistoryEntryClass * klass,
                          gpointer klass_data)
{
	history_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &HistoryEntry_private_offset);
	G_OBJECT_CLASS (klass)->finalize = history_entry_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/calculator/history-entry.ui");
	history_entry_signals[HISTORY_ENTRY_ANSWER_CLICKED_SIGNAL] = g_signal_new ("answer-clicked", TYPE_HISTORY_ENTRY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	history_entry_signals[HISTORY_ENTRY_EQUATION_CLICKED_SIGNAL] = g_signal_new ("equation-clicked", TYPE_HISTORY_ENTRY, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__STRING, G_TYPE_NONE, 1, G_TYPE_STRING);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "equation_label", FALSE, G_STRUCT_OFFSET (HistoryEntry, equation_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "answer_label", FALSE, G_STRUCT_OFFSET (HistoryEntry, answer_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "grid", FALSE, G_STRUCT_OFFSET (HistoryEntry, grid));
}

static void
history_entry_instance_init (HistoryEntry * self,
                             gpointer klass)
{
	self->priv = history_entry_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
history_entry_finalize (GObject * obj)
{
	HistoryEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HISTORY_ENTRY, HistoryEntry);
	_g_object_unref0 (self->priv->number);
	G_OBJECT_CLASS (history_entry_parent_class)->finalize (obj);
}

static GType
history_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (HistoryEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) history_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HistoryEntry), 0, (GInstanceInitFunc) history_entry_instance_init, NULL };
	GType history_entry_type_id;
	history_entry_type_id = g_type_register_static (gtk_list_box_row_get_type (), "HistoryEntry", &g_define_type_info, 0);
	HistoryEntry_private_offset = g_type_add_instance_private (history_entry_type_id, sizeof (HistoryEntryPrivate));
	return history_entry_type_id;
}

GType
history_entry_get_type (void)
{
	static volatile gsize history_entry_type_id__once = 0;
	if (g_once_init_enter (&history_entry_type_id__once)) {
		GType history_entry_type_id;
		history_entry_type_id = history_entry_get_type_once ();
		g_once_init_leave (&history_entry_type_id__once, history_entry_type_id);
	}
	return history_entry_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

