/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, zeromq, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_zeromq_pub_msg_sink = R"doc(Sink the contents of a msg port to a ZMQ PUB socket.

This block acts a message port receiver and writes individual messages to a ZMQ PUB socket. A PUB socket may have subscribers and will pass all incoming messages to each subscriber. Subscribers can be either another gr-zeromq source block or a non-GNU Radio ZMQ socket.

Constructor Specific Documentation:

Return a shared_ptr to a new instance of zeromq::pub_msg_sink.

Args:
    address : ZMQ socket address specifier
    timeout : Receive timeout in milliseconds, default is 100ms, 1us increments
    bind : If true this block will bind to the address, otherwise it will connect; the default is to bind)doc";


static const char* __doc_gr_zeromq_pub_msg_sink_pub_msg_sink_0 = R"doc()doc";


static const char* __doc_gr_zeromq_pub_msg_sink_pub_msg_sink_1 = R"doc()doc";


static const char* __doc_gr_zeromq_pub_msg_sink_make = R"doc(Sink the contents of a msg port to a ZMQ PUB socket.

This block acts a message port receiver and writes individual messages to a ZMQ PUB socket. A PUB socket may have subscribers and will pass all incoming messages to each subscriber. Subscribers can be either another gr-zeromq source block or a non-GNU Radio ZMQ socket.

Constructor Specific Documentation:

Return a shared_ptr to a new instance of zeromq::pub_msg_sink.

Args:
    address : ZMQ socket address specifier
    timeout : Receive timeout in milliseconds, default is 100ms, 1us increments
    bind : If true this block will bind to the address, otherwise it will connect; the default is to bind)doc";


static const char* __doc_gr_zeromq_pub_msg_sink_last_endpoint = R"doc(Return a std::string of ZMQ_LAST_ENDPOINT from the underlying ZMQ socket.)doc";
