{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A representation of a workstation.
-- 
-- Their purpose are two-fold:
-- 
-- * To manage and provide information about input devices (pointers, keyboards, etc)
-- * To manage and provide information about output devices (monitors, projectors, etc)
-- 
-- 
-- Most of the input device handling has been factored out into separate
-- t'GI.Gdk.Objects.Seat.Seat' objects. Every display has a one or more seats, which
-- can be accessed with 'GI.Gdk.Objects.Display.displayGetDefaultSeat' and
-- 'GI.Gdk.Objects.Display.displayListSeats'.
-- 
-- Output devices are represented by t'GI.Gdk.Objects.Monitor.Monitor' objects, which can
-- be accessed with 'GI.Gdk.Objects.Display.displayGetMonitorAtSurface' and similar APIs.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.Display
    ( 

-- * Exported types
    Display(..)                             ,
    IsDisplay                               ,
    toDisplay                               ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [beep]("GI.Gdk.Objects.Display#g:method:beep"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [close]("GI.Gdk.Objects.Display#g:method:close"), [createGlContext]("GI.Gdk.Objects.Display#g:method:createGlContext"), [deviceIsGrabbed]("GI.Gdk.Objects.Display#g:method:deviceIsGrabbed"), [flush]("GI.Gdk.Objects.Display#g:method:flush"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isClosed]("GI.Gdk.Objects.Display#g:method:isClosed"), [isComposited]("GI.Gdk.Objects.Display#g:method:isComposited"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isRgba]("GI.Gdk.Objects.Display#g:method:isRgba"), [listSeats]("GI.Gdk.Objects.Display#g:method:listSeats"), [mapKeycode]("GI.Gdk.Objects.Display#g:method:mapKeycode"), [mapKeyval]("GI.Gdk.Objects.Display#g:method:mapKeyval"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [notifyStartupComplete]("GI.Gdk.Objects.Display#g:method:notifyStartupComplete"), [prepareGl]("GI.Gdk.Objects.Display#g:method:prepareGl"), [putEvent]("GI.Gdk.Objects.Display#g:method:putEvent"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [supportsInputShapes]("GI.Gdk.Objects.Display#g:method:supportsInputShapes"), [supportsShadowWidth]("GI.Gdk.Objects.Display#g:method:supportsShadowWidth"), [sync]("GI.Gdk.Objects.Display#g:method:sync"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateKey]("GI.Gdk.Objects.Display#g:method:translateKey"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAppLaunchContext]("GI.Gdk.Objects.Display#g:method:getAppLaunchContext"), [getClipboard]("GI.Gdk.Objects.Display#g:method:getClipboard"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDefaultSeat]("GI.Gdk.Objects.Display#g:method:getDefaultSeat"), [getDmabufFormats]("GI.Gdk.Objects.Display#g:method:getDmabufFormats"), [getMonitorAtSurface]("GI.Gdk.Objects.Display#g:method:getMonitorAtSurface"), [getMonitors]("GI.Gdk.Objects.Display#g:method:getMonitors"), [getName]("GI.Gdk.Objects.Display#g:method:getName"), [getPrimaryClipboard]("GI.Gdk.Objects.Display#g:method:getPrimaryClipboard"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSetting]("GI.Gdk.Objects.Display#g:method:getSetting"), [getStartupNotificationId]("GI.Gdk.Objects.Display#g:method:getStartupNotificationId").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveDisplayMethod                    ,
#endif

-- ** beep #method:beep#

#if defined(ENABLE_OVERLOADING)
    DisplayBeepMethodInfo                   ,
#endif
    displayBeep                             ,


-- ** close #method:close#

#if defined(ENABLE_OVERLOADING)
    DisplayCloseMethodInfo                  ,
#endif
    displayClose                            ,


-- ** createGlContext #method:createGlContext#

#if defined(ENABLE_OVERLOADING)
    DisplayCreateGlContextMethodInfo        ,
#endif
    displayCreateGlContext                  ,


-- ** deviceIsGrabbed #method:deviceIsGrabbed#

#if defined(ENABLE_OVERLOADING)
    DisplayDeviceIsGrabbedMethodInfo        ,
#endif
    displayDeviceIsGrabbed                  ,


-- ** flush #method:flush#

#if defined(ENABLE_OVERLOADING)
    DisplayFlushMethodInfo                  ,
#endif
    displayFlush                            ,


-- ** getAppLaunchContext #method:getAppLaunchContext#

#if defined(ENABLE_OVERLOADING)
    DisplayGetAppLaunchContextMethodInfo    ,
#endif
    displayGetAppLaunchContext              ,


-- ** getClipboard #method:getClipboard#

#if defined(ENABLE_OVERLOADING)
    DisplayGetClipboardMethodInfo           ,
#endif
    displayGetClipboard                     ,


-- ** getDefault #method:getDefault#

    displayGetDefault                       ,


-- ** getDefaultSeat #method:getDefaultSeat#

#if defined(ENABLE_OVERLOADING)
    DisplayGetDefaultSeatMethodInfo         ,
#endif
    displayGetDefaultSeat                   ,


-- ** getDmabufFormats #method:getDmabufFormats#

#if defined(ENABLE_OVERLOADING)
    DisplayGetDmabufFormatsMethodInfo       ,
#endif
    displayGetDmabufFormats                 ,


-- ** getMonitorAtSurface #method:getMonitorAtSurface#

#if defined(ENABLE_OVERLOADING)
    DisplayGetMonitorAtSurfaceMethodInfo    ,
#endif
    displayGetMonitorAtSurface              ,


-- ** getMonitors #method:getMonitors#

#if defined(ENABLE_OVERLOADING)
    DisplayGetMonitorsMethodInfo            ,
#endif
    displayGetMonitors                      ,


-- ** getName #method:getName#

#if defined(ENABLE_OVERLOADING)
    DisplayGetNameMethodInfo                ,
#endif
    displayGetName                          ,


-- ** getPrimaryClipboard #method:getPrimaryClipboard#

#if defined(ENABLE_OVERLOADING)
    DisplayGetPrimaryClipboardMethodInfo    ,
#endif
    displayGetPrimaryClipboard              ,


-- ** getSetting #method:getSetting#

#if defined(ENABLE_OVERLOADING)
    DisplayGetSettingMethodInfo             ,
#endif
    displayGetSetting                       ,


-- ** getStartupNotificationId #method:getStartupNotificationId#

#if defined(ENABLE_OVERLOADING)
    DisplayGetStartupNotificationIdMethodInfo,
#endif
    displayGetStartupNotificationId         ,


-- ** isClosed #method:isClosed#

#if defined(ENABLE_OVERLOADING)
    DisplayIsClosedMethodInfo               ,
#endif
    displayIsClosed                         ,


-- ** isComposited #method:isComposited#

#if defined(ENABLE_OVERLOADING)
    DisplayIsCompositedMethodInfo           ,
#endif
    displayIsComposited                     ,


-- ** isRgba #method:isRgba#

#if defined(ENABLE_OVERLOADING)
    DisplayIsRgbaMethodInfo                 ,
#endif
    displayIsRgba                           ,


-- ** listSeats #method:listSeats#

#if defined(ENABLE_OVERLOADING)
    DisplayListSeatsMethodInfo              ,
#endif
    displayListSeats                        ,


-- ** mapKeycode #method:mapKeycode#

#if defined(ENABLE_OVERLOADING)
    DisplayMapKeycodeMethodInfo             ,
#endif
    displayMapKeycode                       ,


-- ** mapKeyval #method:mapKeyval#

#if defined(ENABLE_OVERLOADING)
    DisplayMapKeyvalMethodInfo              ,
#endif
    displayMapKeyval                        ,


-- ** notifyStartupComplete #method:notifyStartupComplete#

#if defined(ENABLE_OVERLOADING)
    DisplayNotifyStartupCompleteMethodInfo  ,
#endif
    displayNotifyStartupComplete            ,


-- ** open #method:open#

    displayOpen                             ,


-- ** prepareGl #method:prepareGl#

#if defined(ENABLE_OVERLOADING)
    DisplayPrepareGlMethodInfo              ,
#endif
    displayPrepareGl                        ,


-- ** putEvent #method:putEvent#

#if defined(ENABLE_OVERLOADING)
    DisplayPutEventMethodInfo               ,
#endif
    displayPutEvent                         ,


-- ** supportsInputShapes #method:supportsInputShapes#

#if defined(ENABLE_OVERLOADING)
    DisplaySupportsInputShapesMethodInfo    ,
#endif
    displaySupportsInputShapes              ,


-- ** supportsShadowWidth #method:supportsShadowWidth#

#if defined(ENABLE_OVERLOADING)
    DisplaySupportsShadowWidthMethodInfo    ,
#endif
    displaySupportsShadowWidth              ,


-- ** sync #method:sync#

#if defined(ENABLE_OVERLOADING)
    DisplaySyncMethodInfo                   ,
#endif
    displaySync                             ,


-- ** translateKey #method:translateKey#

#if defined(ENABLE_OVERLOADING)
    DisplayTranslateKeyMethodInfo           ,
#endif
    displayTranslateKey                     ,




 -- * Properties


-- ** composited #attr:composited#
-- | 'P.True' if the display properly composites the alpha channel.

#if defined(ENABLE_OVERLOADING)
    DisplayCompositedPropertyInfo           ,
#endif
#if defined(ENABLE_OVERLOADING)
    displayComposited                       ,
#endif
    getDisplayComposited                    ,


-- ** dmabufFormats #attr:dmabufFormats#
-- | The dma-buf formats that are supported on this display
-- 
-- /Since: 4.14/

#if defined(ENABLE_OVERLOADING)
    DisplayDmabufFormatsPropertyInfo        ,
#endif
#if defined(ENABLE_OVERLOADING)
    displayDmabufFormats                    ,
#endif
    getDisplayDmabufFormats                 ,


-- ** inputShapes #attr:inputShapes#
-- | 'P.True' if the display supports input shapes.

#if defined(ENABLE_OVERLOADING)
    DisplayInputShapesPropertyInfo          ,
#endif
#if defined(ENABLE_OVERLOADING)
    displayInputShapes                      ,
#endif
    getDisplayInputShapes                   ,


-- ** rgba #attr:rgba#
-- | 'P.True' if the display supports an alpha channel.

#if defined(ENABLE_OVERLOADING)
    DisplayRgbaPropertyInfo                 ,
#endif
#if defined(ENABLE_OVERLOADING)
    displayRgba                             ,
#endif
    getDisplayRgba                          ,


-- ** shadowWidth #attr:shadowWidth#
-- | 'P.True' if the display supports extensible frames.
-- 
-- /Since: 4.14/

#if defined(ENABLE_OVERLOADING)
    DisplayShadowWidthPropertyInfo          ,
#endif
#if defined(ENABLE_OVERLOADING)
    displayShadowWidth                      ,
#endif
    getDisplayShadowWidth                   ,




 -- * Signals


-- ** closed #signal:closed#

    DisplayClosedCallback                   ,
#if defined(ENABLE_OVERLOADING)
    DisplayClosedSignalInfo                 ,
#endif
    afterDisplayClosed                      ,
    onDisplayClosed                         ,


-- ** opened #signal:opened#

    DisplayOpenedCallback                   ,
#if defined(ENABLE_OVERLOADING)
    DisplayOpenedSignalInfo                 ,
#endif
    afterDisplayOpened                      ,
    onDisplayOpened                         ,


-- ** seatAdded #signal:seatAdded#

    DisplaySeatAddedCallback                ,
#if defined(ENABLE_OVERLOADING)
    DisplaySeatAddedSignalInfo              ,
#endif
    afterDisplaySeatAdded                   ,
    onDisplaySeatAdded                      ,


-- ** seatRemoved #signal:seatRemoved#

    DisplaySeatRemovedCallback              ,
#if defined(ENABLE_OVERLOADING)
    DisplaySeatRemovedSignalInfo            ,
#endif
    afterDisplaySeatRemoved                 ,
    onDisplaySeatRemoved                    ,


-- ** settingChanged #signal:settingChanged#

    DisplaySettingChangedCallback           ,
#if defined(ENABLE_OVERLOADING)
    DisplaySettingChangedSignalInfo         ,
#endif
    afterDisplaySettingChanged              ,
    onDisplaySettingChanged                 ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CairoContext as Gdk.CairoContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CicpParams as Gdk.CicpParams
import {-# SOURCE #-} qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import {-# SOURCE #-} qualified GI.Gdk.Objects.ContentProvider as Gdk.ContentProvider
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawContext as Gdk.DrawContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Event as Gdk.Event
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import {-# SOURCE #-} qualified GI.Gdk.Objects.Surface as Gdk.Surface
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import {-# SOURCE #-} qualified GI.Gdk.Objects.VulkanContext as Gdk.VulkanContext
import {-# SOURCE #-} qualified GI.Gdk.Structs.ColorState as Gdk.ColorState
import {-# SOURCE #-} qualified GI.Gdk.Structs.ContentFormats as Gdk.ContentFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.DmabufFormats as Gdk.DmabufFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.KeymapKey as Gdk.KeymapKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.TimeCoord as Gdk.TimeCoord
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream
import qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import qualified GI.Pango.Enums as Pango.Enums

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.Event as Gdk.Event
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Surface as Gdk.Surface
import {-# SOURCE #-} qualified GI.Gdk.Structs.DmabufFormats as Gdk.DmabufFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.KeymapKey as Gdk.KeymapKey
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel

#endif

-- | Memory-managed wrapper type.
newtype Display = Display (SP.ManagedPtr Display)
    deriving (Eq)

instance SP.ManagedPtrNewtype Display where
    toManagedPtr (Display p) = p

foreign import ccall "gdk_display_get_type"
    c_gdk_display_get_type :: IO B.Types.GType

instance B.Types.TypedObject Display where
    glibType = c_gdk_display_get_type

instance B.Types.GObject Display

-- | Type class for types which can be safely cast to t'Display', for instance with `toDisplay`.
class (SP.GObject o, O.IsDescendantOf Display o) => IsDisplay o
instance (SP.GObject o, O.IsDescendantOf Display o) => IsDisplay o

instance O.HasParentTypes Display
type instance O.ParentTypes Display = '[GObject.Object.Object]

-- | Cast to t'Display', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toDisplay :: (MIO.MonadIO m, IsDisplay o) => o -> m Display
toDisplay = MIO.liftIO . B.ManagedPtr.unsafeCastTo Display

-- | Convert t'Display' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Display) where
    gvalueGType_ = c_gdk_display_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Display)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Display)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Display ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveDisplayMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDisplayMethod "beep" o = DisplayBeepMethodInfo
    ResolveDisplayMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveDisplayMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveDisplayMethod "close" o = DisplayCloseMethodInfo
    ResolveDisplayMethod "createGlContext" o = DisplayCreateGlContextMethodInfo
    ResolveDisplayMethod "deviceIsGrabbed" o = DisplayDeviceIsGrabbedMethodInfo
    ResolveDisplayMethod "flush" o = DisplayFlushMethodInfo
    ResolveDisplayMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveDisplayMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveDisplayMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveDisplayMethod "isClosed" o = DisplayIsClosedMethodInfo
    ResolveDisplayMethod "isComposited" o = DisplayIsCompositedMethodInfo
    ResolveDisplayMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveDisplayMethod "isRgba" o = DisplayIsRgbaMethodInfo
    ResolveDisplayMethod "listSeats" o = DisplayListSeatsMethodInfo
    ResolveDisplayMethod "mapKeycode" o = DisplayMapKeycodeMethodInfo
    ResolveDisplayMethod "mapKeyval" o = DisplayMapKeyvalMethodInfo
    ResolveDisplayMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveDisplayMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveDisplayMethod "notifyStartupComplete" o = DisplayNotifyStartupCompleteMethodInfo
    ResolveDisplayMethod "prepareGl" o = DisplayPrepareGlMethodInfo
    ResolveDisplayMethod "putEvent" o = DisplayPutEventMethodInfo
    ResolveDisplayMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveDisplayMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveDisplayMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveDisplayMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveDisplayMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveDisplayMethod "supportsInputShapes" o = DisplaySupportsInputShapesMethodInfo
    ResolveDisplayMethod "supportsShadowWidth" o = DisplaySupportsShadowWidthMethodInfo
    ResolveDisplayMethod "sync" o = DisplaySyncMethodInfo
    ResolveDisplayMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveDisplayMethod "translateKey" o = DisplayTranslateKeyMethodInfo
    ResolveDisplayMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveDisplayMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveDisplayMethod "getAppLaunchContext" o = DisplayGetAppLaunchContextMethodInfo
    ResolveDisplayMethod "getClipboard" o = DisplayGetClipboardMethodInfo
    ResolveDisplayMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveDisplayMethod "getDefaultSeat" o = DisplayGetDefaultSeatMethodInfo
    ResolveDisplayMethod "getDmabufFormats" o = DisplayGetDmabufFormatsMethodInfo
    ResolveDisplayMethod "getMonitorAtSurface" o = DisplayGetMonitorAtSurfaceMethodInfo
    ResolveDisplayMethod "getMonitors" o = DisplayGetMonitorsMethodInfo
    ResolveDisplayMethod "getName" o = DisplayGetNameMethodInfo
    ResolveDisplayMethod "getPrimaryClipboard" o = DisplayGetPrimaryClipboardMethodInfo
    ResolveDisplayMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveDisplayMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveDisplayMethod "getSetting" o = DisplayGetSettingMethodInfo
    ResolveDisplayMethod "getStartupNotificationId" o = DisplayGetStartupNotificationIdMethodInfo
    ResolveDisplayMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveDisplayMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveDisplayMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveDisplayMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDisplayMethod t Display, O.OverloadedMethod info Display p) => OL.IsLabel t (Display -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDisplayMethod t Display, O.OverloadedMethod info Display p, R.HasField t Display p) => R.HasField t Display p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDisplayMethod t Display, O.OverloadedMethodInfo info Display) => OL.IsLabel t (O.MethodProxy info Display) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal Display::closed
-- | Emitted when the connection to the windowing system for /@display@/ is closed.
type DisplayClosedCallback =
    Bool
    -- ^ /@isError@/: 'P.True' if the display was closed due to an error
    -> IO ()

type C_DisplayClosedCallback =
    Ptr Display ->                          -- object
    CInt ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DisplayClosedCallback`.
foreign import ccall "wrapper"
    mk_DisplayClosedCallback :: C_DisplayClosedCallback -> IO (FunPtr C_DisplayClosedCallback)

wrap_DisplayClosedCallback :: 
    GObject a => (a -> DisplayClosedCallback) ->
    C_DisplayClosedCallback
wrap_DisplayClosedCallback gi'cb gi'selfPtr isError _ = do
    let isError' = (/= 0) isError
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  isError'


-- | Connect a signal handler for the [closed](#signal:closed) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' display #closed callback
-- @
-- 
-- 
onDisplayClosed :: (IsDisplay a, MonadIO m) => a -> ((?self :: a) => DisplayClosedCallback) -> m SignalHandlerId
onDisplayClosed obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DisplayClosedCallback wrapped
    wrapped'' <- mk_DisplayClosedCallback wrapped'
    connectSignalFunPtr obj "closed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [closed](#signal:closed) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' display #closed callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDisplayClosed :: (IsDisplay a, MonadIO m) => a -> ((?self :: a) => DisplayClosedCallback) -> m SignalHandlerId
afterDisplayClosed obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DisplayClosedCallback wrapped
    wrapped'' <- mk_DisplayClosedCallback wrapped'
    connectSignalFunPtr obj "closed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DisplayClosedSignalInfo
instance SignalInfo DisplayClosedSignalInfo where
    type HaskellCallbackType DisplayClosedSignalInfo = DisplayClosedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DisplayClosedCallback cb
        cb'' <- mk_DisplayClosedCallback cb'
        connectSignalFunPtr obj "closed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display::closed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#g:signal:closed"})

#endif

-- signal Display::opened
-- | Emitted when the connection to the windowing system for /@display@/ is opened.
type DisplayOpenedCallback =
    IO ()

type C_DisplayOpenedCallback =
    Ptr Display ->                          -- object
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DisplayOpenedCallback`.
foreign import ccall "wrapper"
    mk_DisplayOpenedCallback :: C_DisplayOpenedCallback -> IO (FunPtr C_DisplayOpenedCallback)

wrap_DisplayOpenedCallback :: 
    GObject a => (a -> DisplayOpenedCallback) ->
    C_DisplayOpenedCallback
wrap_DisplayOpenedCallback gi'cb gi'selfPtr _ = do
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self) 


-- | Connect a signal handler for the [opened](#signal:opened) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' display #opened callback
-- @
-- 
-- 
onDisplayOpened :: (IsDisplay a, MonadIO m) => a -> ((?self :: a) => DisplayOpenedCallback) -> m SignalHandlerId
onDisplayOpened obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DisplayOpenedCallback wrapped
    wrapped'' <- mk_DisplayOpenedCallback wrapped'
    connectSignalFunPtr obj "opened" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [opened](#signal:opened) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' display #opened callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDisplayOpened :: (IsDisplay a, MonadIO m) => a -> ((?self :: a) => DisplayOpenedCallback) -> m SignalHandlerId
afterDisplayOpened obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DisplayOpenedCallback wrapped
    wrapped'' <- mk_DisplayOpenedCallback wrapped'
    connectSignalFunPtr obj "opened" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DisplayOpenedSignalInfo
instance SignalInfo DisplayOpenedSignalInfo where
    type HaskellCallbackType DisplayOpenedSignalInfo = DisplayOpenedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DisplayOpenedCallback cb
        cb'' <- mk_DisplayOpenedCallback cb'
        connectSignalFunPtr obj "opened" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display::opened"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#g:signal:opened"})

#endif

-- signal Display::seat-added
-- | Emitted whenever a new seat is made known to the windowing system.
type DisplaySeatAddedCallback =
    Gdk.Seat.Seat
    -- ^ /@seat@/: the seat that was just added
    -> IO ()

type C_DisplaySeatAddedCallback =
    Ptr Display ->                          -- object
    Ptr Gdk.Seat.Seat ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DisplaySeatAddedCallback`.
foreign import ccall "wrapper"
    mk_DisplaySeatAddedCallback :: C_DisplaySeatAddedCallback -> IO (FunPtr C_DisplaySeatAddedCallback)

wrap_DisplaySeatAddedCallback :: 
    GObject a => (a -> DisplaySeatAddedCallback) ->
    C_DisplaySeatAddedCallback
wrap_DisplaySeatAddedCallback gi'cb gi'selfPtr seat _ = do
    seat' <- (newObject Gdk.Seat.Seat) seat
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  seat'


-- | Connect a signal handler for the [seatAdded](#signal:seatAdded) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' display #seatAdded callback
-- @
-- 
-- 
onDisplaySeatAdded :: (IsDisplay a, MonadIO m) => a -> ((?self :: a) => DisplaySeatAddedCallback) -> m SignalHandlerId
onDisplaySeatAdded obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DisplaySeatAddedCallback wrapped
    wrapped'' <- mk_DisplaySeatAddedCallback wrapped'
    connectSignalFunPtr obj "seat-added" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [seatAdded](#signal:seatAdded) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' display #seatAdded callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDisplaySeatAdded :: (IsDisplay a, MonadIO m) => a -> ((?self :: a) => DisplaySeatAddedCallback) -> m SignalHandlerId
afterDisplaySeatAdded obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DisplaySeatAddedCallback wrapped
    wrapped'' <- mk_DisplaySeatAddedCallback wrapped'
    connectSignalFunPtr obj "seat-added" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DisplaySeatAddedSignalInfo
instance SignalInfo DisplaySeatAddedSignalInfo where
    type HaskellCallbackType DisplaySeatAddedSignalInfo = DisplaySeatAddedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DisplaySeatAddedCallback cb
        cb'' <- mk_DisplaySeatAddedCallback cb'
        connectSignalFunPtr obj "seat-added" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display::seat-added"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#g:signal:seatAdded"})

#endif

-- signal Display::seat-removed
-- | Emitted whenever a seat is removed by the windowing system.
type DisplaySeatRemovedCallback =
    Gdk.Seat.Seat
    -- ^ /@seat@/: the seat that was just removed
    -> IO ()

type C_DisplaySeatRemovedCallback =
    Ptr Display ->                          -- object
    Ptr Gdk.Seat.Seat ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DisplaySeatRemovedCallback`.
foreign import ccall "wrapper"
    mk_DisplaySeatRemovedCallback :: C_DisplaySeatRemovedCallback -> IO (FunPtr C_DisplaySeatRemovedCallback)

wrap_DisplaySeatRemovedCallback :: 
    GObject a => (a -> DisplaySeatRemovedCallback) ->
    C_DisplaySeatRemovedCallback
wrap_DisplaySeatRemovedCallback gi'cb gi'selfPtr seat _ = do
    seat' <- (newObject Gdk.Seat.Seat) seat
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  seat'


-- | Connect a signal handler for the [seatRemoved](#signal:seatRemoved) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' display #seatRemoved callback
-- @
-- 
-- 
onDisplaySeatRemoved :: (IsDisplay a, MonadIO m) => a -> ((?self :: a) => DisplaySeatRemovedCallback) -> m SignalHandlerId
onDisplaySeatRemoved obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DisplaySeatRemovedCallback wrapped
    wrapped'' <- mk_DisplaySeatRemovedCallback wrapped'
    connectSignalFunPtr obj "seat-removed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [seatRemoved](#signal:seatRemoved) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' display #seatRemoved callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDisplaySeatRemoved :: (IsDisplay a, MonadIO m) => a -> ((?self :: a) => DisplaySeatRemovedCallback) -> m SignalHandlerId
afterDisplaySeatRemoved obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DisplaySeatRemovedCallback wrapped
    wrapped'' <- mk_DisplaySeatRemovedCallback wrapped'
    connectSignalFunPtr obj "seat-removed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DisplaySeatRemovedSignalInfo
instance SignalInfo DisplaySeatRemovedSignalInfo where
    type HaskellCallbackType DisplaySeatRemovedSignalInfo = DisplaySeatRemovedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DisplaySeatRemovedCallback cb
        cb'' <- mk_DisplaySeatRemovedCallback cb'
        connectSignalFunPtr obj "seat-removed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display::seat-removed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#g:signal:seatRemoved"})

#endif

-- signal Display::setting-changed
-- | Emitted whenever a setting changes its value.
type DisplaySettingChangedCallback =
    T.Text
    -- ^ /@setting@/: the name of the setting that changed
    -> IO ()

type C_DisplaySettingChangedCallback =
    Ptr Display ->                          -- object
    CString ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_DisplaySettingChangedCallback`.
foreign import ccall "wrapper"
    mk_DisplaySettingChangedCallback :: C_DisplaySettingChangedCallback -> IO (FunPtr C_DisplaySettingChangedCallback)

wrap_DisplaySettingChangedCallback :: 
    GObject a => (a -> DisplaySettingChangedCallback) ->
    C_DisplaySettingChangedCallback
wrap_DisplaySettingChangedCallback gi'cb gi'selfPtr setting _ = do
    setting' <- cstringToText setting
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  setting'


-- | Connect a signal handler for the [settingChanged](#signal:settingChanged) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' display #settingChanged callback
-- @
-- 
-- 
onDisplaySettingChanged :: (IsDisplay a, MonadIO m) => a -> ((?self :: a) => DisplaySettingChangedCallback) -> m SignalHandlerId
onDisplaySettingChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DisplaySettingChangedCallback wrapped
    wrapped'' <- mk_DisplaySettingChangedCallback wrapped'
    connectSignalFunPtr obj "setting-changed" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [settingChanged](#signal:settingChanged) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' display #settingChanged callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterDisplaySettingChanged :: (IsDisplay a, MonadIO m) => a -> ((?self :: a) => DisplaySettingChangedCallback) -> m SignalHandlerId
afterDisplaySettingChanged obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_DisplaySettingChangedCallback wrapped
    wrapped'' <- mk_DisplaySettingChangedCallback wrapped'
    connectSignalFunPtr obj "setting-changed" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data DisplaySettingChangedSignalInfo
instance SignalInfo DisplaySettingChangedSignalInfo where
    type HaskellCallbackType DisplaySettingChangedSignalInfo = DisplaySettingChangedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_DisplaySettingChangedCallback cb
        cb'' <- mk_DisplaySettingChangedCallback cb'
        connectSignalFunPtr obj "setting-changed" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display::setting-changed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#g:signal:settingChanged"})

#endif

-- VVV Prop "composited"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@composited@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' display #composited
-- @
getDisplayComposited :: (MonadIO m, IsDisplay o) => o -> m Bool
getDisplayComposited obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "composited"

#if defined(ENABLE_OVERLOADING)
data DisplayCompositedPropertyInfo
instance AttrInfo DisplayCompositedPropertyInfo where
    type AttrAllowedOps DisplayCompositedPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint DisplayCompositedPropertyInfo = IsDisplay
    type AttrSetTypeConstraint DisplayCompositedPropertyInfo = (~) ()
    type AttrTransferTypeConstraint DisplayCompositedPropertyInfo = (~) ()
    type AttrTransferType DisplayCompositedPropertyInfo = ()
    type AttrGetType DisplayCompositedPropertyInfo = Bool
    type AttrLabel DisplayCompositedPropertyInfo = "composited"
    type AttrOrigin DisplayCompositedPropertyInfo = Display
    attrGet = getDisplayComposited
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.composited"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#g:attr:composited"
        })
#endif

-- VVV Prop "dmabuf-formats"
   -- Type: TInterface (Name {namespace = "Gdk", name = "DmabufFormats"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@dmabuf-formats@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' display #dmabufFormats
-- @
getDisplayDmabufFormats :: (MonadIO m, IsDisplay o) => o -> m Gdk.DmabufFormats.DmabufFormats
getDisplayDmabufFormats obj = MIO.liftIO $ checkUnexpectedNothing "getDisplayDmabufFormats" $ B.Properties.getObjectPropertyBoxed obj "dmabuf-formats" Gdk.DmabufFormats.DmabufFormats

#if defined(ENABLE_OVERLOADING)
data DisplayDmabufFormatsPropertyInfo
instance AttrInfo DisplayDmabufFormatsPropertyInfo where
    type AttrAllowedOps DisplayDmabufFormatsPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DisplayDmabufFormatsPropertyInfo = IsDisplay
    type AttrSetTypeConstraint DisplayDmabufFormatsPropertyInfo = (~) ()
    type AttrTransferTypeConstraint DisplayDmabufFormatsPropertyInfo = (~) ()
    type AttrTransferType DisplayDmabufFormatsPropertyInfo = ()
    type AttrGetType DisplayDmabufFormatsPropertyInfo = Gdk.DmabufFormats.DmabufFormats
    type AttrLabel DisplayDmabufFormatsPropertyInfo = "dmabuf-formats"
    type AttrOrigin DisplayDmabufFormatsPropertyInfo = Display
    attrGet = getDisplayDmabufFormats
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.dmabufFormats"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#g:attr:dmabufFormats"
        })
#endif

-- VVV Prop "input-shapes"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@input-shapes@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' display #inputShapes
-- @
getDisplayInputShapes :: (MonadIO m, IsDisplay o) => o -> m Bool
getDisplayInputShapes obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "input-shapes"

#if defined(ENABLE_OVERLOADING)
data DisplayInputShapesPropertyInfo
instance AttrInfo DisplayInputShapesPropertyInfo where
    type AttrAllowedOps DisplayInputShapesPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint DisplayInputShapesPropertyInfo = IsDisplay
    type AttrSetTypeConstraint DisplayInputShapesPropertyInfo = (~) ()
    type AttrTransferTypeConstraint DisplayInputShapesPropertyInfo = (~) ()
    type AttrTransferType DisplayInputShapesPropertyInfo = ()
    type AttrGetType DisplayInputShapesPropertyInfo = Bool
    type AttrLabel DisplayInputShapesPropertyInfo = "input-shapes"
    type AttrOrigin DisplayInputShapesPropertyInfo = Display
    attrGet = getDisplayInputShapes
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.inputShapes"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#g:attr:inputShapes"
        })
#endif

-- VVV Prop "rgba"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@rgba@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' display #rgba
-- @
getDisplayRgba :: (MonadIO m, IsDisplay o) => o -> m Bool
getDisplayRgba obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "rgba"

#if defined(ENABLE_OVERLOADING)
data DisplayRgbaPropertyInfo
instance AttrInfo DisplayRgbaPropertyInfo where
    type AttrAllowedOps DisplayRgbaPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint DisplayRgbaPropertyInfo = IsDisplay
    type AttrSetTypeConstraint DisplayRgbaPropertyInfo = (~) ()
    type AttrTransferTypeConstraint DisplayRgbaPropertyInfo = (~) ()
    type AttrTransferType DisplayRgbaPropertyInfo = ()
    type AttrGetType DisplayRgbaPropertyInfo = Bool
    type AttrLabel DisplayRgbaPropertyInfo = "rgba"
    type AttrOrigin DisplayRgbaPropertyInfo = Display
    attrGet = getDisplayRgba
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.rgba"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#g:attr:rgba"
        })
#endif

-- VVV Prop "shadow-width"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@shadow-width@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' display #shadowWidth
-- @
getDisplayShadowWidth :: (MonadIO m, IsDisplay o) => o -> m Bool
getDisplayShadowWidth obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "shadow-width"

#if defined(ENABLE_OVERLOADING)
data DisplayShadowWidthPropertyInfo
instance AttrInfo DisplayShadowWidthPropertyInfo where
    type AttrAllowedOps DisplayShadowWidthPropertyInfo = '[ 'AttrGet]
    type AttrBaseTypeConstraint DisplayShadowWidthPropertyInfo = IsDisplay
    type AttrSetTypeConstraint DisplayShadowWidthPropertyInfo = (~) ()
    type AttrTransferTypeConstraint DisplayShadowWidthPropertyInfo = (~) ()
    type AttrTransferType DisplayShadowWidthPropertyInfo = ()
    type AttrGetType DisplayShadowWidthPropertyInfo = Bool
    type AttrLabel DisplayShadowWidthPropertyInfo = "shadow-width"
    type AttrOrigin DisplayShadowWidthPropertyInfo = Display
    attrGet = getDisplayShadowWidth
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.shadowWidth"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#g:attr:shadowWidth"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Display
type instance O.AttributeList Display = DisplayAttributeList
type DisplayAttributeList = ('[ '("composited", DisplayCompositedPropertyInfo), '("dmabufFormats", DisplayDmabufFormatsPropertyInfo), '("inputShapes", DisplayInputShapesPropertyInfo), '("rgba", DisplayRgbaPropertyInfo), '("shadowWidth", DisplayShadowWidthPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
displayComposited :: AttrLabelProxy "composited"
displayComposited = AttrLabelProxy

displayDmabufFormats :: AttrLabelProxy "dmabufFormats"
displayDmabufFormats = AttrLabelProxy

displayInputShapes :: AttrLabelProxy "inputShapes"
displayInputShapes = AttrLabelProxy

displayRgba :: AttrLabelProxy "rgba"
displayRgba = AttrLabelProxy

displayShadowWidth :: AttrLabelProxy "shadowWidth"
displayShadowWidth = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Display = DisplaySignalList
type DisplaySignalList = ('[ '("closed", DisplayClosedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("opened", DisplayOpenedSignalInfo), '("seatAdded", DisplaySeatAddedSignalInfo), '("seatRemoved", DisplaySeatRemovedSignalInfo), '("settingChanged", DisplaySettingChangedSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Display::beep
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_beep" gdk_display_beep :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO ()

-- | Emits a short beep on /@display@/
displayBeep ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> m ()
displayBeep display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    gdk_display_beep display'
    touchManagedPtr display
    return ()

#if defined(ENABLE_OVERLOADING)
data DisplayBeepMethodInfo
instance (signature ~ (m ()), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayBeepMethodInfo a signature where
    overloadedMethod = displayBeep

instance O.OverloadedMethodInfo DisplayBeepMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayBeep",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#v:displayBeep"
        })


#endif

-- method Display::close
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_close" gdk_display_close :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO ()

-- | Closes the connection to the windowing system for the given display.
-- 
-- This cleans up associated resources.
displayClose ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> m ()
displayClose display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    gdk_display_close display'
    touchManagedPtr display
    return ()

#if defined(ENABLE_OVERLOADING)
data DisplayCloseMethodInfo
instance (signature ~ (m ()), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayCloseMethodInfo a signature where
    overloadedMethod = displayClose

instance O.OverloadedMethodInfo DisplayCloseMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayClose",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#v:displayClose"
        })


#endif

-- method Display::create_gl_context
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "GLContext" })
-- throws : True
-- Skip return : False

foreign import ccall "gdk_display_create_gl_context" gdk_display_create_gl_context :: 
    Ptr Display ->                          -- self : TInterface (Name {namespace = "Gdk", name = "Display"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gdk.GLContext.GLContext)

-- | Creates a new @GdkGLContext@ for the @GdkDisplay@.
-- 
-- The context is disconnected from any particular surface or surface
-- and cannot be used to draw to any surface. It can only be used to
-- draw to non-surface framebuffers like textures.
-- 
-- If the creation of the @GdkGLContext@ failed, /@error@/ will be set.
-- Before using the returned @GdkGLContext@, you will need to
-- call 'GI.Gdk.Objects.GLContext.gLContextMakeCurrent' or 'GI.Gdk.Objects.GLContext.gLContextRealize'.
-- 
-- /Since: 4.6/
displayCreateGlContext ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@self@/: a @GdkDisplay@
    -> m Gdk.GLContext.GLContext
    -- ^ __Returns:__ the newly created @GdkGLContext@ /(Can throw 'Data.GI.Base.GError.GError')/
displayCreateGlContext self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    onException (do
        result <- propagateGError $ gdk_display_create_gl_context self'
        checkUnexpectedReturnNULL "displayCreateGlContext" result
        result' <- (wrapObject Gdk.GLContext.GLContext) result
        touchManagedPtr self
        return result'
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data DisplayCreateGlContextMethodInfo
instance (signature ~ (m Gdk.GLContext.GLContext), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayCreateGlContextMethodInfo a signature where
    overloadedMethod = displayCreateGlContext

instance O.OverloadedMethodInfo DisplayCreateGlContextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayCreateGlContext",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#v:displayCreateGlContext"
        })


#endif

-- method Display::device_is_grabbed
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "device"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Device" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDevice`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_device_is_grabbed" gdk_display_device_is_grabbed :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Ptr Gdk.Device.Device ->                -- device : TInterface (Name {namespace = "Gdk", name = "Device"})
    IO CInt

-- | Returns 'P.True' if there is an ongoing grab on /@device@/ for /@display@/.
displayDeviceIsGrabbed ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a, Gdk.Device.IsDevice b) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> b
    -- ^ /@device@/: a @GdkDevice@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if there is a grab in effect for /@device@/.
displayDeviceIsGrabbed display device = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    device' <- unsafeManagedPtrCastPtr device
    result <- gdk_display_device_is_grabbed display' device'
    let result' = (/= 0) result
    touchManagedPtr display
    touchManagedPtr device
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplayDeviceIsGrabbedMethodInfo
instance (signature ~ (b -> m Bool), MonadIO m, IsDisplay a, Gdk.Device.IsDevice b) => O.OverloadedMethod DisplayDeviceIsGrabbedMethodInfo a signature where
    overloadedMethod = displayDeviceIsGrabbed

instance O.OverloadedMethodInfo DisplayDeviceIsGrabbedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayDeviceIsGrabbed",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#v:displayDeviceIsGrabbed"
        })


#endif

-- method Display::flush
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_flush" gdk_display_flush :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO ()

-- | Flushes any requests queued for the windowing system.
-- 
-- This happens automatically when the main loop blocks waiting for new events,
-- but if your application is drawing without returning control to the main loop,
-- you may need to call this function explicitly. A common case where this function
-- needs to be called is when an application is executing drawing commands
-- from a thread other than the thread where the main loop is running.
-- 
-- This is most useful for X11. On windowing systems where requests are
-- handled synchronously, this function will do nothing.
displayFlush ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> m ()
displayFlush display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    gdk_display_flush display'
    touchManagedPtr display
    return ()

#if defined(ENABLE_OVERLOADING)
data DisplayFlushMethodInfo
instance (signature ~ (m ()), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayFlushMethodInfo a signature where
    overloadedMethod = displayFlush

instance O.OverloadedMethodInfo DisplayFlushMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayFlush",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#v:displayFlush"
        })


#endif

-- method Display::get_app_launch_context
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "AppLaunchContext" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_get_app_launch_context" gdk_display_get_app_launch_context :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO (Ptr Gdk.AppLaunchContext.AppLaunchContext)

-- | Returns a @GdkAppLaunchContext@ suitable for launching
-- applications on the given display.
displayGetAppLaunchContext ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> m Gdk.AppLaunchContext.AppLaunchContext
    -- ^ __Returns:__ a new @GdkAppLaunchContext@ for /@display@/
displayGetAppLaunchContext display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_get_app_launch_context display'
    checkUnexpectedReturnNULL "displayGetAppLaunchContext" result
    result' <- (wrapObject Gdk.AppLaunchContext.AppLaunchContext) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplayGetAppLaunchContextMethodInfo
instance (signature ~ (m Gdk.AppLaunchContext.AppLaunchContext), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayGetAppLaunchContextMethodInfo a signature where
    overloadedMethod = displayGetAppLaunchContext

instance O.OverloadedMethodInfo DisplayGetAppLaunchContextMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayGetAppLaunchContext",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#v:displayGetAppLaunchContext"
        })


#endif

-- method Display::get_clipboard
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Clipboard" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_get_clipboard" gdk_display_get_clipboard :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO (Ptr Gdk.Clipboard.Clipboard)

-- | Gets the clipboard used for copy\/paste operations.
displayGetClipboard ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> m Gdk.Clipboard.Clipboard
    -- ^ __Returns:__ the display\'s clipboard
displayGetClipboard display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_get_clipboard display'
    checkUnexpectedReturnNULL "displayGetClipboard" result
    result' <- (newObject Gdk.Clipboard.Clipboard) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplayGetClipboardMethodInfo
instance (signature ~ (m Gdk.Clipboard.Clipboard), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayGetClipboardMethodInfo a signature where
    overloadedMethod = displayGetClipboard

instance O.OverloadedMethodInfo DisplayGetClipboardMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayGetClipboard",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#v:displayGetClipboard"
        })


#endif

-- method Display::get_default_seat
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Seat" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_get_default_seat" gdk_display_get_default_seat :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO (Ptr Gdk.Seat.Seat)

-- | Returns the default @GdkSeat@ for this display.
-- 
-- Note that a display may not have a seat. In this case,
-- this function will return 'P.Nothing'.
displayGetDefaultSeat ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> m (Maybe Gdk.Seat.Seat)
    -- ^ __Returns:__ the default seat.
displayGetDefaultSeat display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_get_default_seat display'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Seat.Seat) result'
        return result''
    touchManagedPtr display
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DisplayGetDefaultSeatMethodInfo
instance (signature ~ (m (Maybe Gdk.Seat.Seat)), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayGetDefaultSeatMethodInfo a signature where
    overloadedMethod = displayGetDefaultSeat

instance O.OverloadedMethodInfo DisplayGetDefaultSeatMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayGetDefaultSeat",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#v:displayGetDefaultSeat"
        })


#endif

-- method Display::get_dmabuf_formats
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "DmabufFormats" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_get_dmabuf_formats" gdk_display_get_dmabuf_formats :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO (Ptr Gdk.DmabufFormats.DmabufFormats)

-- | Returns the dma-buf formats that are supported on this display.
-- 
-- GTK may use OpenGL or Vulkan to support some formats.
-- Calling this function will then initialize them if they aren\'t yet.
-- 
-- The formats returned by this function can be used for negotiating
-- buffer formats with producers such as v4l, pipewire or GStreamer.
-- 
-- To learn more about dma-bufs, see t'GI.Gdk.Objects.DmabufTextureBuilder.DmabufTextureBuilder'.
-- 
-- This function is threadsafe. It can be called from any thread.
-- 
-- /Since: 4.14/
displayGetDmabufFormats ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> m Gdk.DmabufFormats.DmabufFormats
    -- ^ __Returns:__ a @GdkDmabufFormats@ object
displayGetDmabufFormats display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_get_dmabuf_formats display'
    checkUnexpectedReturnNULL "displayGetDmabufFormats" result
    result' <- (newBoxed Gdk.DmabufFormats.DmabufFormats) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplayGetDmabufFormatsMethodInfo
instance (signature ~ (m Gdk.DmabufFormats.DmabufFormats), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayGetDmabufFormatsMethodInfo a signature where
    overloadedMethod = displayGetDmabufFormats

instance O.OverloadedMethodInfo DisplayGetDmabufFormatsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayGetDmabufFormats",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#v:displayGetDmabufFormats"
        })


#endif

-- method Display::get_monitor_at_surface
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "surface"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Surface" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkSurface`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Monitor" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_get_monitor_at_surface" gdk_display_get_monitor_at_surface :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Ptr Gdk.Surface.Surface ->              -- surface : TInterface (Name {namespace = "Gdk", name = "Surface"})
    IO (Ptr Gdk.Monitor.Monitor)

-- | Gets the monitor in which the largest area of /@surface@/
-- resides.
displayGetMonitorAtSurface ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a, Gdk.Surface.IsSurface b) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> b
    -- ^ /@surface@/: a @GdkSurface@
    -> m (Maybe Gdk.Monitor.Monitor)
    -- ^ __Returns:__ the monitor with the largest
    --   overlap with /@surface@/
displayGetMonitorAtSurface display surface = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    surface' <- unsafeManagedPtrCastPtr surface
    result <- gdk_display_get_monitor_at_surface display' surface'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Monitor.Monitor) result'
        return result''
    touchManagedPtr display
    touchManagedPtr surface
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DisplayGetMonitorAtSurfaceMethodInfo
instance (signature ~ (b -> m (Maybe Gdk.Monitor.Monitor)), MonadIO m, IsDisplay a, Gdk.Surface.IsSurface b) => O.OverloadedMethod DisplayGetMonitorAtSurfaceMethodInfo a signature where
    overloadedMethod = displayGetMonitorAtSurface

instance O.OverloadedMethodInfo DisplayGetMonitorAtSurfaceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayGetMonitorAtSurface",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#v:displayGetMonitorAtSurface"
        })


#endif

-- method Display::get_monitors
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "ListModel" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_get_monitors" gdk_display_get_monitors :: 
    Ptr Display ->                          -- self : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO (Ptr Gio.ListModel.ListModel)

-- | Gets the list of monitors associated with this display.
-- 
-- Subsequent calls to this function will always return the
-- same list for the same display.
-- 
-- You can listen to the GListModel[itemsChanged](#g:signal:itemsChanged) signal on
-- this list to monitor changes to the monitor of this display.
displayGetMonitors ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@self@/: a @GdkDisplay@
    -> m Gio.ListModel.ListModel
    -- ^ __Returns:__ a @GListModel@ of @GdkMonitor@
displayGetMonitors self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gdk_display_get_monitors self'
    checkUnexpectedReturnNULL "displayGetMonitors" result
    result' <- (newObject Gio.ListModel.ListModel) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplayGetMonitorsMethodInfo
instance (signature ~ (m Gio.ListModel.ListModel), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayGetMonitorsMethodInfo a signature where
    overloadedMethod = displayGetMonitors

instance O.OverloadedMethodInfo DisplayGetMonitorsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayGetMonitors",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#v:displayGetMonitors"
        })


#endif

-- method Display::get_name
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_get_name" gdk_display_get_name :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO CString

-- | Gets the name of the display.
displayGetName ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> m T.Text
    -- ^ __Returns:__ a string representing the display name. This string is owned
    --   by GDK and should not be modified or freed.
displayGetName display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_get_name display'
    checkUnexpectedReturnNULL "displayGetName" result
    result' <- cstringToText result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplayGetNameMethodInfo
instance (signature ~ (m T.Text), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayGetNameMethodInfo a signature where
    overloadedMethod = displayGetName

instance O.OverloadedMethodInfo DisplayGetNameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayGetName",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#v:displayGetName"
        })


#endif

-- method Display::get_primary_clipboard
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Clipboard" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_get_primary_clipboard" gdk_display_get_primary_clipboard :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO (Ptr Gdk.Clipboard.Clipboard)

-- | Gets the clipboard used for the primary selection.
-- 
-- On backends where the primary clipboard is not supported natively,
-- GDK emulates this clipboard locally.
displayGetPrimaryClipboard ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> m Gdk.Clipboard.Clipboard
    -- ^ __Returns:__ the primary clipboard
displayGetPrimaryClipboard display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_get_primary_clipboard display'
    checkUnexpectedReturnNULL "displayGetPrimaryClipboard" result
    result' <- (newObject Gdk.Clipboard.Clipboard) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplayGetPrimaryClipboardMethodInfo
instance (signature ~ (m Gdk.Clipboard.Clipboard), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayGetPrimaryClipboardMethodInfo a signature where
    overloadedMethod = displayGetPrimaryClipboard

instance O.OverloadedMethodInfo DisplayGetPrimaryClipboardMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayGetPrimaryClipboard",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#v:displayGetPrimaryClipboard"
        })


#endif

-- method Display::get_setting
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the setting"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "value"
--           , argType = TGValue
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "location to store the value of the setting"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_get_setting" gdk_display_get_setting :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    CString ->                              -- name : TBasicType TUTF8
    Ptr GValue ->                           -- value : TGValue
    IO CInt

-- | Retrieves a desktop-wide setting such as double-click time
-- for the /@display@/.
displayGetSetting ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> T.Text
    -- ^ /@name@/: the name of the setting
    -> GValue
    -- ^ /@value@/: location to store the value of the setting
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the setting existed and a value was stored
    --   in /@value@/, 'P.False' otherwise
displayGetSetting display name value = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    name' <- textToCString name
    value' <- unsafeManagedPtrGetPtr value
    result <- gdk_display_get_setting display' name' value'
    let result' = (/= 0) result
    touchManagedPtr display
    touchManagedPtr value
    freeMem name'
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplayGetSettingMethodInfo
instance (signature ~ (T.Text -> GValue -> m Bool), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayGetSettingMethodInfo a signature where
    overloadedMethod = displayGetSetting

instance O.OverloadedMethodInfo DisplayGetSettingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayGetSetting",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#v:displayGetSetting"
        })


#endif

-- method Display::get_startup_notification_id
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TUTF8)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_get_startup_notification_id" gdk_display_get_startup_notification_id :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO CString

{-# DEPRECATED displayGetStartupNotificationId ["(Since version 4.10)"] #-}
-- | Gets the startup notification ID for a Wayland display, or 'P.Nothing'
-- if no ID has been defined.
displayGetStartupNotificationId ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> m (Maybe T.Text)
    -- ^ __Returns:__ the startup notification ID for /@display@/
displayGetStartupNotificationId display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_get_startup_notification_id display'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- cstringToText result'
        return result''
    touchManagedPtr display
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DisplayGetStartupNotificationIdMethodInfo
instance (signature ~ (m (Maybe T.Text)), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayGetStartupNotificationIdMethodInfo a signature where
    overloadedMethod = displayGetStartupNotificationId

instance O.OverloadedMethodInfo DisplayGetStartupNotificationIdMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayGetStartupNotificationId",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#v:displayGetStartupNotificationId"
        })


#endif

-- method Display::is_closed
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_is_closed" gdk_display_is_closed :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO CInt

-- | Finds out if the display has been closed.
displayIsClosed ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the display is closed.
displayIsClosed display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_is_closed display'
    let result' = (/= 0) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplayIsClosedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayIsClosedMethodInfo a signature where
    overloadedMethod = displayIsClosed

instance O.OverloadedMethodInfo DisplayIsClosedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayIsClosed",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#v:displayIsClosed"
        })


#endif

-- method Display::is_composited
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_is_composited" gdk_display_is_composited :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO CInt

-- | Returns whether surfaces can reasonably be expected to have
-- their alpha channel drawn correctly on the screen.
-- 
-- Check 'GI.Gdk.Objects.Display.displayIsRgba' for whether the display
-- supports an alpha channel.
-- 
-- On X11 this function returns whether a compositing manager is
-- compositing on /@display@/.
-- 
-- On modern displays, this value is always 'P.True'.
displayIsComposited ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> m Bool
    -- ^ __Returns:__ Whether surfaces with RGBA visuals can reasonably
    --   be expected to have their alpha channels drawn correctly
    --   on the screen.
displayIsComposited display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_is_composited display'
    let result' = (/= 0) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplayIsCompositedMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayIsCompositedMethodInfo a signature where
    overloadedMethod = displayIsComposited

instance O.OverloadedMethodInfo DisplayIsCompositedMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayIsComposited",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#v:displayIsComposited"
        })


#endif

-- method Display::is_rgba
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_is_rgba" gdk_display_is_rgba :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO CInt

-- | Returns whether surfaces on this /@display@/ are created with an
-- alpha channel.
-- 
-- Even if a 'P.True' is returned, it is possible that the
-- surface’s alpha channel won’t be honored when displaying the
-- surface on the screen: in particular, for X an appropriate
-- windowing manager and compositing manager must be running to
-- provide appropriate display. Use 'GI.Gdk.Objects.Display.displayIsComposited'
-- to check if that is the case.
-- 
-- On modern displays, this value is always 'P.True'.
displayIsRgba ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if surfaces are created with an alpha channel or
    --   'P.False' if the display does not support this functionality.
displayIsRgba display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_is_rgba display'
    let result' = (/= 0) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplayIsRgbaMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayIsRgbaMethodInfo a signature where
    overloadedMethod = displayIsRgba

instance O.OverloadedMethodInfo DisplayIsRgbaMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayIsRgba",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#v:displayIsRgba"
        })


#endif

-- method Display::list_seats
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TGList (TInterface Name { namespace = "Gdk" , name = "Seat" }))
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_list_seats" gdk_display_list_seats :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO (Ptr (GList (Ptr Gdk.Seat.Seat)))

-- | Returns the list of seats known to /@display@/.
displayListSeats ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> m [Gdk.Seat.Seat]
    -- ^ __Returns:__ the
    --   list of seats known to the @GdkDisplay@
displayListSeats display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_list_seats display'
    result' <- unpackGList result
    result'' <- mapM (newObject Gdk.Seat.Seat) result'
    g_list_free result
    touchManagedPtr display
    return result''

#if defined(ENABLE_OVERLOADING)
data DisplayListSeatsMethodInfo
instance (signature ~ (m [Gdk.Seat.Seat]), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayListSeatsMethodInfo a signature where
    overloadedMethod = displayListSeats

instance O.OverloadedMethodInfo DisplayListSeatsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayListSeats",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#v:displayListSeats"
        })


#endif

-- method Display::map_keycode
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "keycode"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a keycode" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "keys"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 4
--                 (TInterface Name { namespace = "Gdk" , name = "KeymapKey" })
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return\n  location for array of `GdkKeymapKey`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "keyvals"
--           , argType = TCArray False (-1) 4 (TBasicType TUInt)
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return\n  location for array of keyvals"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "n_entries"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "length of @keys and @keyvals"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_entries"
--              , argType = TBasicType TInt
--              , direction = DirectionOut
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "length of @keys and @keyvals"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          , Arg
--              { argCName = "n_entries"
--              , argType = TBasicType TInt
--              , direction = DirectionOut
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "length of @keys and @keyvals"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_map_keycode" gdk_display_map_keycode :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Word32 ->                               -- keycode : TBasicType TUInt
    Ptr (Ptr Gdk.KeymapKey.KeymapKey) ->    -- keys : TCArray False (-1) 4 (TInterface (Name {namespace = "Gdk", name = "KeymapKey"}))
    Ptr (Ptr Word32) ->                     -- keyvals : TCArray False (-1) 4 (TBasicType TUInt)
    Ptr Int32 ->                            -- n_entries : TBasicType TInt
    IO CInt

-- | Returns the keyvals bound to /@keycode@/.
-- 
-- The Nth @GdkKeymapKey@ in /@keys@/ is bound to the Nth keyval in /@keyvals@/.
-- 
-- When a keycode is pressed by the user, the keyval from
-- this list of entries is selected by considering the effective
-- keyboard group and level.
-- 
-- Free the returned arrays with 'GI.GLib.Functions.free'.
displayMapKeycode ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> Word32
    -- ^ /@keycode@/: a keycode
    -> m ((Bool, [Gdk.KeymapKey.KeymapKey], [Word32]))
    -- ^ __Returns:__ 'P.True' if there were any entries
displayMapKeycode display keycode = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    keys <- callocMem :: IO (Ptr (Ptr Gdk.KeymapKey.KeymapKey))
    keyvals <- callocMem :: IO (Ptr (Ptr Word32))
    nEntries <- allocMem :: IO (Ptr Int32)
    result <- gdk_display_map_keycode display' keycode keys keyvals nEntries
    nEntries' <- peek nEntries
    let result' = (/= 0) result
    keys' <- peek keys
    keys'' <- (unpackBlockArrayWithLength 12 nEntries') keys'
    keys''' <- mapM (wrapPtr Gdk.KeymapKey.KeymapKey) keys''
    freeMem keys'
    keyvals' <- peek keyvals
    keyvals'' <- (unpackStorableArrayWithLength nEntries') keyvals'
    freeMem keyvals'
    touchManagedPtr display
    freeMem keys
    freeMem keyvals
    freeMem nEntries
    return (result', keys''', keyvals'')

#if defined(ENABLE_OVERLOADING)
data DisplayMapKeycodeMethodInfo
instance (signature ~ (Word32 -> m ((Bool, [Gdk.KeymapKey.KeymapKey], [Word32]))), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayMapKeycodeMethodInfo a signature where
    overloadedMethod = displayMapKeycode

instance O.OverloadedMethodInfo DisplayMapKeycodeMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayMapKeycode",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#v:displayMapKeycode"
        })


#endif

-- method Display::map_keyval
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "keyval"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a keyval, such as %GDK_KEY_a, %GDK_KEY_Up, %GDK_KEY_Return, etc."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "keys"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 3
--                 (TInterface Name { namespace = "Gdk" , name = "KeymapKey" })
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location\n  for an array of `GdkKeymapKey`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "n_keys"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "return location for number of elements in returned array"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_keys"
--              , argType = TBasicType TInt
--              , direction = DirectionOut
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just "return location for number of elements in returned array"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_map_keyval" gdk_display_map_keyval :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Word32 ->                               -- keyval : TBasicType TUInt
    Ptr (Ptr Gdk.KeymapKey.KeymapKey) ->    -- keys : TCArray False (-1) 3 (TInterface (Name {namespace = "Gdk", name = "KeymapKey"}))
    Ptr Int32 ->                            -- n_keys : TBasicType TInt
    IO CInt

-- | Obtains a list of keycode\/group\/level combinations that will
-- generate /@keyval@/.
-- 
-- Groups and levels are two kinds of keyboard mode; in general, the level
-- determines whether the top or bottom symbol on a key is used, and the
-- group determines whether the left or right symbol is used.
-- 
-- On US keyboards, the shift key changes the keyboard level, and there
-- are no groups. A group switch key might convert a keyboard between
-- Hebrew to English modes, for example.
-- 
-- @GdkEventKey@ contains a @/group/@ field that indicates the active
-- keyboard group. The level is computed from the modifier mask.
-- 
-- The returned array should be freed with 'GI.GLib.Functions.free'.
displayMapKeyval ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> Word32
    -- ^ /@keyval@/: a keyval, such as 'GI.Gdk.Constants.KEY_a', 'GI.Gdk.Constants.KEY_Up', 'GI.Gdk.Constants.KEY_Return', etc.
    -> m ((Bool, [Gdk.KeymapKey.KeymapKey]))
    -- ^ __Returns:__ 'P.True' if keys were found and returned
displayMapKeyval display keyval = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    keys <- callocMem :: IO (Ptr (Ptr Gdk.KeymapKey.KeymapKey))
    nKeys <- allocMem :: IO (Ptr Int32)
    result <- gdk_display_map_keyval display' keyval keys nKeys
    nKeys' <- peek nKeys
    let result' = (/= 0) result
    keys' <- peek keys
    keys'' <- (unpackBlockArrayWithLength 12 nKeys') keys'
    keys''' <- mapM (wrapPtr Gdk.KeymapKey.KeymapKey) keys''
    freeMem keys'
    touchManagedPtr display
    freeMem keys
    freeMem nKeys
    return (result', keys''')

#if defined(ENABLE_OVERLOADING)
data DisplayMapKeyvalMethodInfo
instance (signature ~ (Word32 -> m ((Bool, [Gdk.KeymapKey.KeymapKey]))), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayMapKeyvalMethodInfo a signature where
    overloadedMethod = displayMapKeyval

instance O.OverloadedMethodInfo DisplayMapKeyvalMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayMapKeyval",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#v:displayMapKeyval"
        })


#endif

-- method Display::notify_startup_complete
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "startup_id"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a startup-notification identifier, for which\n  notification process should be completed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_notify_startup_complete" gdk_display_notify_startup_complete :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    CString ->                              -- startup_id : TBasicType TUTF8
    IO ()

{-# DEPRECATED displayNotifyStartupComplete ["(Since version 4.10)","Using 'GI.Gdk.Interfaces.Toplevel.toplevelSetStartupId' is sufficient"] #-}
-- | Indicates to the GUI environment that the application has
-- finished loading, using a given identifier.
-- 
-- GTK will call this function automatically for <http://developer.gnome.org/gdk/stable/../gtk4/class.Window.html GtkWindow>
-- with custom startup-notification identifier unless
-- <http://developer.gnome.org/gdk/stable/../gtk4/method.Window.set_auto_startup_notification.html gtk_window_set_auto_startup_notification()>
-- is called to disable that feature.
displayNotifyStartupComplete ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> T.Text
    -- ^ /@startupId@/: a startup-notification identifier, for which
    --   notification process should be completed
    -> m ()
displayNotifyStartupComplete display startupId = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    startupId' <- textToCString startupId
    gdk_display_notify_startup_complete display' startupId'
    touchManagedPtr display
    freeMem startupId'
    return ()

#if defined(ENABLE_OVERLOADING)
data DisplayNotifyStartupCompleteMethodInfo
instance (signature ~ (T.Text -> m ()), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayNotifyStartupCompleteMethodInfo a signature where
    overloadedMethod = displayNotifyStartupComplete

instance O.OverloadedMethodInfo DisplayNotifyStartupCompleteMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayNotifyStartupComplete",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#v:displayNotifyStartupComplete"
        })


#endif

-- method Display::prepare_gl
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : True
-- Skip return : False

foreign import ccall "gdk_display_prepare_gl" gdk_display_prepare_gl :: 
    Ptr Display ->                          -- self : TInterface (Name {namespace = "Gdk", name = "Display"})
    Ptr (Ptr GError) ->                     -- error
    IO CInt

-- | Checks that OpenGL is available for /@self@/ and ensures that it is
-- properly initialized.
-- When this fails, an /@error@/ will be set describing the error and this
-- function returns 'P.False'.
-- 
-- Note that even if this function succeeds, creating a @GdkGLContext@
-- may still fail.
-- 
-- This function is idempotent. Calling it multiple times will just
-- return the same value or error.
-- 
-- You never need to call this function, GDK will call it automatically
-- as needed. But you can use it as a check when setting up code that
-- might make use of OpenGL.
-- 
-- /Since: 4.4/
displayPrepareGl ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@self@/: a @GdkDisplay@
    -> m ()
    -- ^ /(Can throw 'Data.GI.Base.GError.GError')/
displayPrepareGl self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    onException (do
        _ <- propagateGError $ gdk_display_prepare_gl self'
        touchManagedPtr self
        return ()
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data DisplayPrepareGlMethodInfo
instance (signature ~ (m ()), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayPrepareGlMethodInfo a signature where
    overloadedMethod = displayPrepareGl

instance O.OverloadedMethodInfo DisplayPrepareGlMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayPrepareGl",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#v:displayPrepareGl"
        })


#endif

-- method Display::put_event
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "event"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Event" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkEvent`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_put_event" gdk_display_put_event :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Ptr Gdk.Event.Event ->                  -- event : TInterface (Name {namespace = "Gdk", name = "Event"})
    IO ()

{-# DEPRECATED displayPutEvent ["(Since version 4.10)","This function is only useful in very","special situations and should not be used by applications."] #-}
-- | Adds the given event to the event queue for /@display@/.
displayPutEvent ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a, Gdk.Event.IsEvent b) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> b
    -- ^ /@event@/: a @GdkEvent@
    -> m ()
displayPutEvent display event = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    event' <- unsafeManagedPtrCastPtr event
    gdk_display_put_event display' event'
    touchManagedPtr display
    touchManagedPtr event
    return ()

#if defined(ENABLE_OVERLOADING)
data DisplayPutEventMethodInfo
instance (signature ~ (b -> m ()), MonadIO m, IsDisplay a, Gdk.Event.IsEvent b) => O.OverloadedMethod DisplayPutEventMethodInfo a signature where
    overloadedMethod = displayPutEvent

instance O.OverloadedMethodInfo DisplayPutEventMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayPutEvent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#v:displayPutEvent"
        })


#endif

-- method Display::supports_input_shapes
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_supports_input_shapes" gdk_display_supports_input_shapes :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO CInt

-- | Returns 'P.True' if the display supports input shapes.
-- 
-- This means that 'GI.Gdk.Objects.Surface.surfaceSetInputRegion' can
-- be used to modify the input shape of surfaces on /@display@/.
-- 
-- On modern displays, this value is always 'P.True'.
displaySupportsInputShapes ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if surfaces with modified input shape are supported
displaySupportsInputShapes display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_supports_input_shapes display'
    let result' = (/= 0) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplaySupportsInputShapesMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplaySupportsInputShapesMethodInfo a signature where
    overloadedMethod = displaySupportsInputShapes

instance O.OverloadedMethodInfo DisplaySupportsInputShapesMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displaySupportsInputShapes",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#v:displaySupportsInputShapes"
        })


#endif

-- method Display::supports_shadow_width
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_supports_shadow_width" gdk_display_supports_shadow_width :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO CInt

-- | Returns whether it\'s possible for a surface to draw outside of the window area.
-- 
-- If 'P.True' is returned the application decides if it wants to draw shadows.
-- If 'P.False' is returned, the compositor decides if it wants to draw shadows.
-- 
-- /Since: 4.14/
displaySupportsShadowWidth ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if surfaces can draw shadows or
    --   'P.False' if the display does not support this functionality.
displaySupportsShadowWidth display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    result <- gdk_display_supports_shadow_width display'
    let result' = (/= 0) result
    touchManagedPtr display
    return result'

#if defined(ENABLE_OVERLOADING)
data DisplaySupportsShadowWidthMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplaySupportsShadowWidthMethodInfo a signature where
    overloadedMethod = displaySupportsShadowWidth

instance O.OverloadedMethodInfo DisplaySupportsShadowWidthMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displaySupportsShadowWidth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#v:displaySupportsShadowWidth"
        })


#endif

-- method Display::sync
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_sync" gdk_display_sync :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    IO ()

-- | Flushes any requests queued for the windowing system and waits until all
-- requests have been handled.
-- 
-- This is often used for making sure that the display is synchronized
-- with the current state of the program. Calling 'GI.Gdk.Objects.Display.displaySync'
-- before [method/@gdkX11@/.Display.error_trap_pop] makes sure that any errors
-- generated from earlier requests are handled before the error trap is removed.
-- 
-- This is most useful for X11. On windowing systems where requests are
-- handled synchronously, this function will do nothing.
displaySync ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> m ()
displaySync display = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    gdk_display_sync display'
    touchManagedPtr display
    return ()

#if defined(ENABLE_OVERLOADING)
data DisplaySyncMethodInfo
instance (signature ~ (m ()), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplaySyncMethodInfo a signature where
    overloadedMethod = displaySync

instance O.OverloadedMethodInfo DisplaySyncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displaySync",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#v:displaySync"
        })


#endif

-- method Display::translate_key
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "display"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "Display" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDisplay`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "keycode"
--           , argType = TBasicType TUInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a keycode" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "state"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ModifierType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a modifier state" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "group"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "active keyboard group"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "keyval"
--           , argType = TBasicType TUInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for keyval"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "effective_group"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for effective group"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "level"
--           , argType = TBasicType TInt
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for level"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "consumed"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ModifierType" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "return location for modifiers that were used\n  to determine the group or level"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_translate_key" gdk_display_translate_key :: 
    Ptr Display ->                          -- display : TInterface (Name {namespace = "Gdk", name = "Display"})
    Word32 ->                               -- keycode : TBasicType TUInt
    CUInt ->                                -- state : TInterface (Name {namespace = "Gdk", name = "ModifierType"})
    Int32 ->                                -- group : TBasicType TInt
    Ptr Word32 ->                           -- keyval : TBasicType TUInt
    Ptr Int32 ->                            -- effective_group : TBasicType TInt
    Ptr Int32 ->                            -- level : TBasicType TInt
    Ptr CUInt ->                            -- consumed : TInterface (Name {namespace = "Gdk", name = "ModifierType"})
    IO CInt

-- | Translates the contents of a @GdkEventKey@ into a keyval, effective group,
-- and level.
-- 
-- Modifiers that affected the translation and are thus unavailable for
-- application use are returned in /@consumedModifiers@/.
-- 
-- The /@effectiveGroup@/ is the group that was actually used for the
-- translation; some keys such as Enter are not affected by the active
-- keyboard group. The /@level@/ is derived from /@state@/.
-- 
-- /@consumedModifiers@/ gives modifiers that should be masked out
-- from /@state@/ when comparing this key press to a keyboard shortcut.
-- For instance, on a US keyboard, the @plus@ symbol is shifted, so
-- when comparing a key press to a @\<Control>plus@ accelerator @\<Shift>@
-- should be masked out.
-- 
-- This function should rarely be needed, since @GdkEventKey@ already
-- contains the translated keyval. It is exported for the benefit of
-- virtualized test environments.
displayTranslateKey ::
    (B.CallStack.HasCallStack, MonadIO m, IsDisplay a) =>
    a
    -- ^ /@display@/: a @GdkDisplay@
    -> Word32
    -- ^ /@keycode@/: a keycode
    -> [Gdk.Flags.ModifierType]
    -- ^ /@state@/: a modifier state
    -> Int32
    -- ^ /@group@/: active keyboard group
    -> m ((Bool, Word32, Int32, Int32, [Gdk.Flags.ModifierType]))
    -- ^ __Returns:__ 'P.True' if there was a keyval bound to keycode\/state\/group.
displayTranslateKey display keycode state group = liftIO $ do
    display' <- unsafeManagedPtrCastPtr display
    let state' = gflagsToWord state
    keyval <- allocMem :: IO (Ptr Word32)
    effectiveGroup <- allocMem :: IO (Ptr Int32)
    level <- allocMem :: IO (Ptr Int32)
    consumed <- allocMem :: IO (Ptr CUInt)
    result <- gdk_display_translate_key display' keycode state' group keyval effectiveGroup level consumed
    let result' = (/= 0) result
    keyval' <- peek keyval
    effectiveGroup' <- peek effectiveGroup
    level' <- peek level
    consumed' <- peek consumed
    let consumed'' = wordToGFlags consumed'
    touchManagedPtr display
    freeMem keyval
    freeMem effectiveGroup
    freeMem level
    freeMem consumed
    return (result', keyval', effectiveGroup', level', consumed'')

#if defined(ENABLE_OVERLOADING)
data DisplayTranslateKeyMethodInfo
instance (signature ~ (Word32 -> [Gdk.Flags.ModifierType] -> Int32 -> m ((Bool, Word32, Int32, Int32, [Gdk.Flags.ModifierType]))), MonadIO m, IsDisplay a) => O.OverloadedMethod DisplayTranslateKeyMethodInfo a signature where
    overloadedMethod = displayTranslateKey

instance O.OverloadedMethodInfo DisplayTranslateKeyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Display.displayTranslateKey",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Display.html#v:displayTranslateKey"
        })


#endif

-- method Display::get_default
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Display" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_get_default" gdk_display_get_default :: 
    IO (Ptr Display)

-- | Gets the default @GdkDisplay@.
-- 
-- This is a convenience function for:
-- 
--     gdk_display_manager_get_default_display (gdk_display_manager_get ())
displayGetDefault ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m (Maybe Display)
    -- ^ __Returns:__ a @GdkDisplay@, or 'P.Nothing' if
    --   there is no default display
displayGetDefault  = liftIO $ do
    result <- gdk_display_get_default
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Display) result'
        return result''
    return maybeResult

#if defined(ENABLE_OVERLOADING)
#endif

-- method Display::open
-- method type : MemberFunction
-- Args: [ Arg
--           { argCName = "display_name"
--           , argType = TBasicType TUTF8
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the name of the display to open"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Display" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_display_open" gdk_display_open :: 
    CString ->                              -- display_name : TBasicType TUTF8
    IO (Ptr Display)

-- | Opens a display.
-- 
-- If opening the display fails, @NULL@ is returned.
displayOpen ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Maybe (T.Text)
    -- ^ /@displayName@/: the name of the display to open
    -> m (Maybe Display)
    -- ^ __Returns:__ a @GdkDisplay@
displayOpen displayName = liftIO $ do
    maybeDisplayName <- case displayName of
        Nothing -> return FP.nullPtr
        Just jDisplayName -> do
            jDisplayName' <- textToCString jDisplayName
            return jDisplayName'
    result <- gdk_display_open maybeDisplayName
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Display) result'
        return result''
    freeMem maybeDisplayName
    return maybeResult

#if defined(ENABLE_OVERLOADING)
#endif


