{-# LANGUAGE ImplicitParams, RankNTypes, TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Makes its child scrollable.
-- 
-- \<picture>
--   \<source srcset=\"scrolledwindow-dark.png\" media=\"(prefers-color-scheme: dark)\">
--   \<img alt=\"An example GtkScrolledWindow\" src=\"scrolledwindow.png\">
-- \<\/picture>
-- 
-- It does so using either internally added scrollbars or externally
-- associated adjustments, and optionally draws a frame around the child.
-- 
-- Widgets with native scrolling support, i.e. those whose classes implement
-- the t'GI.Gtk.Interfaces.Scrollable.Scrollable' interface, are added directly. For other types
-- of widget, the class t'GI.Gtk.Objects.Viewport.Viewport' acts as an adaptor, giving
-- scrollability to other widgets. 'GI.Gtk.Objects.ScrolledWindow.scrolledWindowSetChild'
-- intelligently accounts for whether or not the added child is a @GtkScrollable@.
-- If it isn’t, then it wraps the child in a @GtkViewport@. Therefore, you can
-- just add any child widget and not worry about the details.
-- 
-- If 'GI.Gtk.Objects.ScrolledWindow.scrolledWindowSetChild' has added a @GtkViewport@ for you,
-- it will be automatically removed when you unset the child.
-- Unless [ScrolledWindow:hscrollbarPolicy]("GI.Gtk.Objects.ScrolledWindow#g:attr:hscrollbarPolicy") and
-- [ScrolledWindow:vscrollbarPolicy]("GI.Gtk.Objects.ScrolledWindow#g:attr:vscrollbarPolicy") are 'GI.Gtk.Enums.PolicyTypeNever' or
-- 'GI.Gtk.Enums.PolicyTypeExternal', @GtkScrolledWindow@ adds internal @GtkScrollbar@ widgets
-- around its child. The scroll position of the child, and if applicable the
-- scrollbars, is controlled by the [ScrolledWindow:hadjustment]("GI.Gtk.Objects.ScrolledWindow#g:attr:hadjustment")
-- and [ScrolledWindow:vadjustment]("GI.Gtk.Objects.ScrolledWindow#g:attr:vadjustment") that are associated with the
-- @GtkScrolledWindow@. See the docs on t'GI.Gtk.Objects.Scrollbar.Scrollbar' for the details,
-- but note that the “step_increment” and “page_increment” fields are only
-- effective if the policy causes scrollbars to be present.
-- 
-- If a @GtkScrolledWindow@ doesn’t behave quite as you would like, or
-- doesn’t have exactly the right layout, it’s very possible to set up
-- your own scrolling with @GtkScrollbar@ and for example a @GtkGrid@.
-- 
-- = Touch support
-- 
-- @GtkScrolledWindow@ has built-in support for touch devices. When a
-- touchscreen is used, swiping will move the scrolled window, and will
-- expose \'kinetic\' behavior. This can be turned off with the
-- [ScrolledWindow:kineticScrolling]("GI.Gtk.Objects.ScrolledWindow#g:attr:kineticScrolling") property if it is undesired.
-- 
-- @GtkScrolledWindow@ also displays visual \'overshoot\' indication when
-- the content is pulled beyond the end, and this situation can be
-- captured with the [ScrolledWindow::edgeOvershot]("GI.Gtk.Objects.ScrolledWindow#g:signal:edgeOvershot") signal.
-- 
-- If no mouse device is present, the scrollbars will overlaid as
-- narrow, auto-hiding indicators over the content. If traditional
-- scrollbars are desired although no mouse is present, this behaviour
-- can be turned off with the [ScrolledWindow:overlayScrolling]("GI.Gtk.Objects.ScrolledWindow#g:attr:overlayScrolling")
-- property.
-- 
-- = Shortcuts and Gestures
-- 
-- The following signals have default keybindings:
-- 
-- * [ScrolledWindow::scrollChild]("GI.Gtk.Objects.ScrolledWindow#g:signal:scrollChild")
-- 
-- 
-- = CSS nodes
-- 
-- @GtkScrolledWindow@ has a main CSS node with name scrolledwindow.
-- It gets a .frame style class added when [ScrolledWindow:hasFrame]("GI.Gtk.Objects.ScrolledWindow#g:attr:hasFrame")
-- is 'P.True'.
-- 
-- It uses subnodes with names overshoot and undershoot to draw the overflow
-- and underflow indications. These nodes get the .left, .right, .top or .bottom
-- style class added depending on where the indication is drawn.
-- 
-- @GtkScrolledWindow@ also sets the positional style classes (.left, .right,
-- .top, .bottom) and style classes related to overlay scrolling
-- (.overlay-indicator, .dragging, .hovering) on its scrollbars.
-- 
-- If both scrollbars are visible, the area where they meet is drawn
-- with a subnode named junction.
-- 
-- = Accessibility
-- 
-- Until GTK 4.10, @GtkScrolledWindow@ used the 'GI.Gtk.Enums.AccessibleRoleGroup' role.
-- 
-- Starting from GTK 4.12, @GtkScrolledWindow@ uses the 'GI.Gtk.Enums.AccessibleRoleGeneric'
-- role.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.ScrolledWindow
    ( 

-- * Exported types
    ScrolledWindow(..)                      ,
    IsScrolledWindow                        ,
    toScrolledWindow                        ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [actionSetEnabled]("GI.Gtk.Objects.Widget#g:method:actionSetEnabled"), [activate]("GI.Gtk.Objects.Widget#g:method:activate"), [activateAction]("GI.Gtk.Objects.Widget#g:method:activateAction"), [activateDefault]("GI.Gtk.Objects.Widget#g:method:activateDefault"), [addController]("GI.Gtk.Objects.Widget#g:method:addController"), [addCssClass]("GI.Gtk.Objects.Widget#g:method:addCssClass"), [addMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:addMnemonicLabel"), [addTickCallback]("GI.Gtk.Objects.Widget#g:method:addTickCallback"), [allocate]("GI.Gtk.Objects.Widget#g:method:allocate"), [announce]("GI.Gtk.Interfaces.Accessible#g:method:announce"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [childFocus]("GI.Gtk.Objects.Widget#g:method:childFocus"), [computeBounds]("GI.Gtk.Objects.Widget#g:method:computeBounds"), [computeExpand]("GI.Gtk.Objects.Widget#g:method:computeExpand"), [computePoint]("GI.Gtk.Objects.Widget#g:method:computePoint"), [computeTransform]("GI.Gtk.Objects.Widget#g:method:computeTransform"), [contains]("GI.Gtk.Objects.Widget#g:method:contains"), [createPangoContext]("GI.Gtk.Objects.Widget#g:method:createPangoContext"), [createPangoLayout]("GI.Gtk.Objects.Widget#g:method:createPangoLayout"), [disposeTemplate]("GI.Gtk.Objects.Widget#g:method:disposeTemplate"), [dragCheckThreshold]("GI.Gtk.Objects.Widget#g:method:dragCheckThreshold"), [errorBell]("GI.Gtk.Objects.Widget#g:method:errorBell"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [grabFocus]("GI.Gtk.Objects.Widget#g:method:grabFocus"), [hasCssClass]("GI.Gtk.Objects.Widget#g:method:hasCssClass"), [hasDefault]("GI.Gtk.Objects.Widget#g:method:hasDefault"), [hasFocus]("GI.Gtk.Objects.Widget#g:method:hasFocus"), [hasVisibleFocus]("GI.Gtk.Objects.Widget#g:method:hasVisibleFocus"), [hide]("GI.Gtk.Objects.Widget#g:method:hide"), [inDestruction]("GI.Gtk.Objects.Widget#g:method:inDestruction"), [initTemplate]("GI.Gtk.Objects.Widget#g:method:initTemplate"), [insertActionGroup]("GI.Gtk.Objects.Widget#g:method:insertActionGroup"), [insertAfter]("GI.Gtk.Objects.Widget#g:method:insertAfter"), [insertBefore]("GI.Gtk.Objects.Widget#g:method:insertBefore"), [isAncestor]("GI.Gtk.Objects.Widget#g:method:isAncestor"), [isDrawable]("GI.Gtk.Objects.Widget#g:method:isDrawable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [isFocus]("GI.Gtk.Objects.Widget#g:method:isFocus"), [isSensitive]("GI.Gtk.Objects.Widget#g:method:isSensitive"), [isVisible]("GI.Gtk.Objects.Widget#g:method:isVisible"), [keynavFailed]("GI.Gtk.Objects.Widget#g:method:keynavFailed"), [listMnemonicLabels]("GI.Gtk.Objects.Widget#g:method:listMnemonicLabels"), [map]("GI.Gtk.Objects.Widget#g:method:map"), [measure]("GI.Gtk.Objects.Widget#g:method:measure"), [mnemonicActivate]("GI.Gtk.Objects.Widget#g:method:mnemonicActivate"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [observeChildren]("GI.Gtk.Objects.Widget#g:method:observeChildren"), [observeControllers]("GI.Gtk.Objects.Widget#g:method:observeControllers"), [pick]("GI.Gtk.Objects.Widget#g:method:pick"), [queueAllocate]("GI.Gtk.Objects.Widget#g:method:queueAllocate"), [queueDraw]("GI.Gtk.Objects.Widget#g:method:queueDraw"), [queueResize]("GI.Gtk.Objects.Widget#g:method:queueResize"), [realize]("GI.Gtk.Objects.Widget#g:method:realize"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [removeController]("GI.Gtk.Objects.Widget#g:method:removeController"), [removeCssClass]("GI.Gtk.Objects.Widget#g:method:removeCssClass"), [removeMnemonicLabel]("GI.Gtk.Objects.Widget#g:method:removeMnemonicLabel"), [removeTickCallback]("GI.Gtk.Objects.Widget#g:method:removeTickCallback"), [resetProperty]("GI.Gtk.Interfaces.Accessible#g:method:resetProperty"), [resetRelation]("GI.Gtk.Interfaces.Accessible#g:method:resetRelation"), [resetState]("GI.Gtk.Interfaces.Accessible#g:method:resetState"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [shouldLayout]("GI.Gtk.Objects.Widget#g:method:shouldLayout"), [show]("GI.Gtk.Objects.Widget#g:method:show"), [sizeAllocate]("GI.Gtk.Objects.Widget#g:method:sizeAllocate"), [snapshotChild]("GI.Gtk.Objects.Widget#g:method:snapshotChild"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [translateCoordinates]("GI.Gtk.Objects.Widget#g:method:translateCoordinates"), [triggerTooltipQuery]("GI.Gtk.Objects.Widget#g:method:triggerTooltipQuery"), [unmap]("GI.Gtk.Objects.Widget#g:method:unmap"), [unparent]("GI.Gtk.Objects.Widget#g:method:unparent"), [unrealize]("GI.Gtk.Objects.Widget#g:method:unrealize"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [unsetPlacement]("GI.Gtk.Objects.ScrolledWindow#g:method:unsetPlacement"), [unsetStateFlags]("GI.Gtk.Objects.Widget#g:method:unsetStateFlags"), [updateNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:updateNextAccessibleSibling"), [updatePlatformState]("GI.Gtk.Interfaces.Accessible#g:method:updatePlatformState"), [updateProperty]("GI.Gtk.Interfaces.Accessible#g:method:updateProperty"), [updateRelation]("GI.Gtk.Interfaces.Accessible#g:method:updateRelation"), [updateState]("GI.Gtk.Interfaces.Accessible#g:method:updateState"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleParent"), [getAccessibleRole]("GI.Gtk.Interfaces.Accessible#g:method:getAccessibleRole"), [getAllocatedBaseline]("GI.Gtk.Objects.Widget#g:method:getAllocatedBaseline"), [getAllocatedHeight]("GI.Gtk.Objects.Widget#g:method:getAllocatedHeight"), [getAllocatedWidth]("GI.Gtk.Objects.Widget#g:method:getAllocatedWidth"), [getAllocation]("GI.Gtk.Objects.Widget#g:method:getAllocation"), [getAncestor]("GI.Gtk.Objects.Widget#g:method:getAncestor"), [getAtContext]("GI.Gtk.Interfaces.Accessible#g:method:getAtContext"), [getBaseline]("GI.Gtk.Objects.Widget#g:method:getBaseline"), [getBounds]("GI.Gtk.Interfaces.Accessible#g:method:getBounds"), [getBuildableId]("GI.Gtk.Interfaces.Buildable#g:method:getBuildableId"), [getCanFocus]("GI.Gtk.Objects.Widget#g:method:getCanFocus"), [getCanTarget]("GI.Gtk.Objects.Widget#g:method:getCanTarget"), [getChild]("GI.Gtk.Objects.ScrolledWindow#g:method:getChild"), [getChildVisible]("GI.Gtk.Objects.Widget#g:method:getChildVisible"), [getClipboard]("GI.Gtk.Objects.Widget#g:method:getClipboard"), [getColor]("GI.Gtk.Objects.Widget#g:method:getColor"), [getCssClasses]("GI.Gtk.Objects.Widget#g:method:getCssClasses"), [getCssName]("GI.Gtk.Objects.Widget#g:method:getCssName"), [getCursor]("GI.Gtk.Objects.Widget#g:method:getCursor"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDirection]("GI.Gtk.Objects.Widget#g:method:getDirection"), [getDisplay]("GI.Gtk.Objects.Widget#g:method:getDisplay"), [getFirstAccessibleChild]("GI.Gtk.Interfaces.Accessible#g:method:getFirstAccessibleChild"), [getFirstChild]("GI.Gtk.Objects.Widget#g:method:getFirstChild"), [getFocusChild]("GI.Gtk.Objects.Widget#g:method:getFocusChild"), [getFocusOnClick]("GI.Gtk.Objects.Widget#g:method:getFocusOnClick"), [getFocusable]("GI.Gtk.Objects.Widget#g:method:getFocusable"), [getFontMap]("GI.Gtk.Objects.Widget#g:method:getFontMap"), [getFontOptions]("GI.Gtk.Objects.Widget#g:method:getFontOptions"), [getFrameClock]("GI.Gtk.Objects.Widget#g:method:getFrameClock"), [getHadjustment]("GI.Gtk.Objects.ScrolledWindow#g:method:getHadjustment"), [getHalign]("GI.Gtk.Objects.Widget#g:method:getHalign"), [getHasFrame]("GI.Gtk.Objects.ScrolledWindow#g:method:getHasFrame"), [getHasTooltip]("GI.Gtk.Objects.Widget#g:method:getHasTooltip"), [getHeight]("GI.Gtk.Objects.Widget#g:method:getHeight"), [getHexpand]("GI.Gtk.Objects.Widget#g:method:getHexpand"), [getHexpandSet]("GI.Gtk.Objects.Widget#g:method:getHexpandSet"), [getHscrollbar]("GI.Gtk.Objects.ScrolledWindow#g:method:getHscrollbar"), [getKineticScrolling]("GI.Gtk.Objects.ScrolledWindow#g:method:getKineticScrolling"), [getLastChild]("GI.Gtk.Objects.Widget#g:method:getLastChild"), [getLayoutManager]("GI.Gtk.Objects.Widget#g:method:getLayoutManager"), [getLimitEvents]("GI.Gtk.Objects.Widget#g:method:getLimitEvents"), [getMapped]("GI.Gtk.Objects.Widget#g:method:getMapped"), [getMarginBottom]("GI.Gtk.Objects.Widget#g:method:getMarginBottom"), [getMarginEnd]("GI.Gtk.Objects.Widget#g:method:getMarginEnd"), [getMarginStart]("GI.Gtk.Objects.Widget#g:method:getMarginStart"), [getMarginTop]("GI.Gtk.Objects.Widget#g:method:getMarginTop"), [getMaxContentHeight]("GI.Gtk.Objects.ScrolledWindow#g:method:getMaxContentHeight"), [getMaxContentWidth]("GI.Gtk.Objects.ScrolledWindow#g:method:getMaxContentWidth"), [getMinContentHeight]("GI.Gtk.Objects.ScrolledWindow#g:method:getMinContentHeight"), [getMinContentWidth]("GI.Gtk.Objects.ScrolledWindow#g:method:getMinContentWidth"), [getName]("GI.Gtk.Objects.Widget#g:method:getName"), [getNative]("GI.Gtk.Objects.Widget#g:method:getNative"), [getNextAccessibleSibling]("GI.Gtk.Interfaces.Accessible#g:method:getNextAccessibleSibling"), [getNextSibling]("GI.Gtk.Objects.Widget#g:method:getNextSibling"), [getOpacity]("GI.Gtk.Objects.Widget#g:method:getOpacity"), [getOverflow]("GI.Gtk.Objects.Widget#g:method:getOverflow"), [getOverlayScrolling]("GI.Gtk.Objects.ScrolledWindow#g:method:getOverlayScrolling"), [getPangoContext]("GI.Gtk.Objects.Widget#g:method:getPangoContext"), [getParent]("GI.Gtk.Objects.Widget#g:method:getParent"), [getPlacement]("GI.Gtk.Objects.ScrolledWindow#g:method:getPlacement"), [getPlatformState]("GI.Gtk.Interfaces.Accessible#g:method:getPlatformState"), [getPolicy]("GI.Gtk.Objects.ScrolledWindow#g:method:getPolicy"), [getPreferredSize]("GI.Gtk.Objects.Widget#g:method:getPreferredSize"), [getPrevSibling]("GI.Gtk.Objects.Widget#g:method:getPrevSibling"), [getPrimaryClipboard]("GI.Gtk.Objects.Widget#g:method:getPrimaryClipboard"), [getPropagateNaturalHeight]("GI.Gtk.Objects.ScrolledWindow#g:method:getPropagateNaturalHeight"), [getPropagateNaturalWidth]("GI.Gtk.Objects.ScrolledWindow#g:method:getPropagateNaturalWidth"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRealized]("GI.Gtk.Objects.Widget#g:method:getRealized"), [getReceivesDefault]("GI.Gtk.Objects.Widget#g:method:getReceivesDefault"), [getRequestMode]("GI.Gtk.Objects.Widget#g:method:getRequestMode"), [getRoot]("GI.Gtk.Objects.Widget#g:method:getRoot"), [getScaleFactor]("GI.Gtk.Objects.Widget#g:method:getScaleFactor"), [getSensitive]("GI.Gtk.Objects.Widget#g:method:getSensitive"), [getSettings]("GI.Gtk.Objects.Widget#g:method:getSettings"), [getSize]("GI.Gtk.Objects.Widget#g:method:getSize"), [getSizeRequest]("GI.Gtk.Objects.Widget#g:method:getSizeRequest"), [getStateFlags]("GI.Gtk.Objects.Widget#g:method:getStateFlags"), [getStyleContext]("GI.Gtk.Objects.Widget#g:method:getStyleContext"), [getTemplateChild]("GI.Gtk.Objects.Widget#g:method:getTemplateChild"), [getTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:getTooltipMarkup"), [getTooltipText]("GI.Gtk.Objects.Widget#g:method:getTooltipText"), [getVadjustment]("GI.Gtk.Objects.ScrolledWindow#g:method:getVadjustment"), [getValign]("GI.Gtk.Objects.Widget#g:method:getValign"), [getVexpand]("GI.Gtk.Objects.Widget#g:method:getVexpand"), [getVexpandSet]("GI.Gtk.Objects.Widget#g:method:getVexpandSet"), [getVisible]("GI.Gtk.Objects.Widget#g:method:getVisible"), [getVscrollbar]("GI.Gtk.Objects.ScrolledWindow#g:method:getVscrollbar"), [getWidth]("GI.Gtk.Objects.Widget#g:method:getWidth").
-- 
-- ==== Setters
-- [setAccessibleParent]("GI.Gtk.Interfaces.Accessible#g:method:setAccessibleParent"), [setCanFocus]("GI.Gtk.Objects.Widget#g:method:setCanFocus"), [setCanTarget]("GI.Gtk.Objects.Widget#g:method:setCanTarget"), [setChild]("GI.Gtk.Objects.ScrolledWindow#g:method:setChild"), [setChildVisible]("GI.Gtk.Objects.Widget#g:method:setChildVisible"), [setCssClasses]("GI.Gtk.Objects.Widget#g:method:setCssClasses"), [setCursor]("GI.Gtk.Objects.Widget#g:method:setCursor"), [setCursorFromName]("GI.Gtk.Objects.Widget#g:method:setCursorFromName"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setDirection]("GI.Gtk.Objects.Widget#g:method:setDirection"), [setFocusChild]("GI.Gtk.Objects.Widget#g:method:setFocusChild"), [setFocusOnClick]("GI.Gtk.Objects.Widget#g:method:setFocusOnClick"), [setFocusable]("GI.Gtk.Objects.Widget#g:method:setFocusable"), [setFontMap]("GI.Gtk.Objects.Widget#g:method:setFontMap"), [setFontOptions]("GI.Gtk.Objects.Widget#g:method:setFontOptions"), [setHadjustment]("GI.Gtk.Objects.ScrolledWindow#g:method:setHadjustment"), [setHalign]("GI.Gtk.Objects.Widget#g:method:setHalign"), [setHasFrame]("GI.Gtk.Objects.ScrolledWindow#g:method:setHasFrame"), [setHasTooltip]("GI.Gtk.Objects.Widget#g:method:setHasTooltip"), [setHexpand]("GI.Gtk.Objects.Widget#g:method:setHexpand"), [setHexpandSet]("GI.Gtk.Objects.Widget#g:method:setHexpandSet"), [setKineticScrolling]("GI.Gtk.Objects.ScrolledWindow#g:method:setKineticScrolling"), [setLayoutManager]("GI.Gtk.Objects.Widget#g:method:setLayoutManager"), [setLimitEvents]("GI.Gtk.Objects.Widget#g:method:setLimitEvents"), [setMarginBottom]("GI.Gtk.Objects.Widget#g:method:setMarginBottom"), [setMarginEnd]("GI.Gtk.Objects.Widget#g:method:setMarginEnd"), [setMarginStart]("GI.Gtk.Objects.Widget#g:method:setMarginStart"), [setMarginTop]("GI.Gtk.Objects.Widget#g:method:setMarginTop"), [setMaxContentHeight]("GI.Gtk.Objects.ScrolledWindow#g:method:setMaxContentHeight"), [setMaxContentWidth]("GI.Gtk.Objects.ScrolledWindow#g:method:setMaxContentWidth"), [setMinContentHeight]("GI.Gtk.Objects.ScrolledWindow#g:method:setMinContentHeight"), [setMinContentWidth]("GI.Gtk.Objects.ScrolledWindow#g:method:setMinContentWidth"), [setName]("GI.Gtk.Objects.Widget#g:method:setName"), [setOpacity]("GI.Gtk.Objects.Widget#g:method:setOpacity"), [setOverflow]("GI.Gtk.Objects.Widget#g:method:setOverflow"), [setOverlayScrolling]("GI.Gtk.Objects.ScrolledWindow#g:method:setOverlayScrolling"), [setParent]("GI.Gtk.Objects.Widget#g:method:setParent"), [setPlacement]("GI.Gtk.Objects.ScrolledWindow#g:method:setPlacement"), [setPolicy]("GI.Gtk.Objects.ScrolledWindow#g:method:setPolicy"), [setPropagateNaturalHeight]("GI.Gtk.Objects.ScrolledWindow#g:method:setPropagateNaturalHeight"), [setPropagateNaturalWidth]("GI.Gtk.Objects.ScrolledWindow#g:method:setPropagateNaturalWidth"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setReceivesDefault]("GI.Gtk.Objects.Widget#g:method:setReceivesDefault"), [setSensitive]("GI.Gtk.Objects.Widget#g:method:setSensitive"), [setSizeRequest]("GI.Gtk.Objects.Widget#g:method:setSizeRequest"), [setStateFlags]("GI.Gtk.Objects.Widget#g:method:setStateFlags"), [setTooltipMarkup]("GI.Gtk.Objects.Widget#g:method:setTooltipMarkup"), [setTooltipText]("GI.Gtk.Objects.Widget#g:method:setTooltipText"), [setVadjustment]("GI.Gtk.Objects.ScrolledWindow#g:method:setVadjustment"), [setValign]("GI.Gtk.Objects.Widget#g:method:setValign"), [setVexpand]("GI.Gtk.Objects.Widget#g:method:setVexpand"), [setVexpandSet]("GI.Gtk.Objects.Widget#g:method:setVexpandSet"), [setVisible]("GI.Gtk.Objects.Widget#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveScrolledWindowMethod             ,
#endif

-- ** getChild #method:getChild#

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowGetChildMethodInfo        ,
#endif
    scrolledWindowGetChild                  ,


-- ** getHadjustment #method:getHadjustment#

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowGetHadjustmentMethodInfo  ,
#endif
    scrolledWindowGetHadjustment            ,


-- ** getHasFrame #method:getHasFrame#

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowGetHasFrameMethodInfo     ,
#endif
    scrolledWindowGetHasFrame               ,


-- ** getHscrollbar #method:getHscrollbar#

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowGetHscrollbarMethodInfo   ,
#endif
    scrolledWindowGetHscrollbar             ,


-- ** getKineticScrolling #method:getKineticScrolling#

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowGetKineticScrollingMethodInfo,
#endif
    scrolledWindowGetKineticScrolling       ,


-- ** getMaxContentHeight #method:getMaxContentHeight#

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowGetMaxContentHeightMethodInfo,
#endif
    scrolledWindowGetMaxContentHeight       ,


-- ** getMaxContentWidth #method:getMaxContentWidth#

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowGetMaxContentWidthMethodInfo,
#endif
    scrolledWindowGetMaxContentWidth        ,


-- ** getMinContentHeight #method:getMinContentHeight#

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowGetMinContentHeightMethodInfo,
#endif
    scrolledWindowGetMinContentHeight       ,


-- ** getMinContentWidth #method:getMinContentWidth#

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowGetMinContentWidthMethodInfo,
#endif
    scrolledWindowGetMinContentWidth        ,


-- ** getOverlayScrolling #method:getOverlayScrolling#

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowGetOverlayScrollingMethodInfo,
#endif
    scrolledWindowGetOverlayScrolling       ,


-- ** getPlacement #method:getPlacement#

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowGetPlacementMethodInfo    ,
#endif
    scrolledWindowGetPlacement              ,


-- ** getPolicy #method:getPolicy#

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowGetPolicyMethodInfo       ,
#endif
    scrolledWindowGetPolicy                 ,


-- ** getPropagateNaturalHeight #method:getPropagateNaturalHeight#

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowGetPropagateNaturalHeightMethodInfo,
#endif
    scrolledWindowGetPropagateNaturalHeight ,


-- ** getPropagateNaturalWidth #method:getPropagateNaturalWidth#

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowGetPropagateNaturalWidthMethodInfo,
#endif
    scrolledWindowGetPropagateNaturalWidth  ,


-- ** getVadjustment #method:getVadjustment#

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowGetVadjustmentMethodInfo  ,
#endif
    scrolledWindowGetVadjustment            ,


-- ** getVscrollbar #method:getVscrollbar#

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowGetVscrollbarMethodInfo   ,
#endif
    scrolledWindowGetVscrollbar             ,


-- ** new #method:new#

    scrolledWindowNew                       ,


-- ** setChild #method:setChild#

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowSetChildMethodInfo        ,
#endif
    scrolledWindowSetChild                  ,


-- ** setHadjustment #method:setHadjustment#

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowSetHadjustmentMethodInfo  ,
#endif
    scrolledWindowSetHadjustment            ,


-- ** setHasFrame #method:setHasFrame#

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowSetHasFrameMethodInfo     ,
#endif
    scrolledWindowSetHasFrame               ,


-- ** setKineticScrolling #method:setKineticScrolling#

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowSetKineticScrollingMethodInfo,
#endif
    scrolledWindowSetKineticScrolling       ,


-- ** setMaxContentHeight #method:setMaxContentHeight#

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowSetMaxContentHeightMethodInfo,
#endif
    scrolledWindowSetMaxContentHeight       ,


-- ** setMaxContentWidth #method:setMaxContentWidth#

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowSetMaxContentWidthMethodInfo,
#endif
    scrolledWindowSetMaxContentWidth        ,


-- ** setMinContentHeight #method:setMinContentHeight#

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowSetMinContentHeightMethodInfo,
#endif
    scrolledWindowSetMinContentHeight       ,


-- ** setMinContentWidth #method:setMinContentWidth#

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowSetMinContentWidthMethodInfo,
#endif
    scrolledWindowSetMinContentWidth        ,


-- ** setOverlayScrolling #method:setOverlayScrolling#

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowSetOverlayScrollingMethodInfo,
#endif
    scrolledWindowSetOverlayScrolling       ,


-- ** setPlacement #method:setPlacement#

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowSetPlacementMethodInfo    ,
#endif
    scrolledWindowSetPlacement              ,


-- ** setPolicy #method:setPolicy#

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowSetPolicyMethodInfo       ,
#endif
    scrolledWindowSetPolicy                 ,


-- ** setPropagateNaturalHeight #method:setPropagateNaturalHeight#

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowSetPropagateNaturalHeightMethodInfo,
#endif
    scrolledWindowSetPropagateNaturalHeight ,


-- ** setPropagateNaturalWidth #method:setPropagateNaturalWidth#

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowSetPropagateNaturalWidthMethodInfo,
#endif
    scrolledWindowSetPropagateNaturalWidth  ,


-- ** setVadjustment #method:setVadjustment#

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowSetVadjustmentMethodInfo  ,
#endif
    scrolledWindowSetVadjustment            ,


-- ** unsetPlacement #method:unsetPlacement#

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowUnsetPlacementMethodInfo  ,
#endif
    scrolledWindowUnsetPlacement            ,




 -- * Properties


-- ** child #attr:child#
-- | The child widget.
-- 
-- When setting this property, if the child widget does not implement
-- t'GI.Gtk.Interfaces.Scrollable.Scrollable', the scrolled window will add the child to
-- a t'GI.Gtk.Objects.Viewport.Viewport' and then set the viewport as the child.

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowChildPropertyInfo         ,
#endif
    clearScrolledWindowChild                ,
    constructScrolledWindowChild            ,
    getScrolledWindowChild                  ,
#if defined(ENABLE_OVERLOADING)
    scrolledWindowChild                     ,
#endif
    setScrolledWindowChild                  ,


-- ** hadjustment #attr:hadjustment#
-- | The @GtkAdjustment@ for the horizontal position.

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowHadjustmentPropertyInfo   ,
#endif
    clearScrolledWindowHadjustment          ,
    constructScrolledWindowHadjustment      ,
    getScrolledWindowHadjustment            ,
#if defined(ENABLE_OVERLOADING)
    scrolledWindowHadjustment               ,
#endif
    setScrolledWindowHadjustment            ,


-- ** hasFrame #attr:hasFrame#
-- | Whether to draw a frame around the contents.

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowHasFramePropertyInfo      ,
#endif
    constructScrolledWindowHasFrame         ,
    getScrolledWindowHasFrame               ,
#if defined(ENABLE_OVERLOADING)
    scrolledWindowHasFrame                  ,
#endif
    setScrolledWindowHasFrame               ,


-- ** hscrollbarPolicy #attr:hscrollbarPolicy#
-- | When the horizontal scrollbar is displayed.
-- 
-- Use 'GI.Gtk.Objects.ScrolledWindow.scrolledWindowSetPolicy' to set
-- this property.

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowHscrollbarPolicyPropertyInfo,
#endif
    constructScrolledWindowHscrollbarPolicy ,
    getScrolledWindowHscrollbarPolicy       ,
#if defined(ENABLE_OVERLOADING)
    scrolledWindowHscrollbarPolicy          ,
#endif
    setScrolledWindowHscrollbarPolicy       ,


-- ** kineticScrolling #attr:kineticScrolling#
-- | Whether kinetic scrolling is enabled or not.
-- 
-- Kinetic scrolling only applies to devices with source 'GI.Gdk.Enums.InputSourceTouchscreen'.

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowKineticScrollingPropertyInfo,
#endif
    constructScrolledWindowKineticScrolling ,
    getScrolledWindowKineticScrolling       ,
#if defined(ENABLE_OVERLOADING)
    scrolledWindowKineticScrolling          ,
#endif
    setScrolledWindowKineticScrolling       ,


-- ** maxContentHeight #attr:maxContentHeight#
-- | The maximum content height of /@scrolledWindow@/.

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowMaxContentHeightPropertyInfo,
#endif
    constructScrolledWindowMaxContentHeight ,
    getScrolledWindowMaxContentHeight       ,
#if defined(ENABLE_OVERLOADING)
    scrolledWindowMaxContentHeight          ,
#endif
    setScrolledWindowMaxContentHeight       ,


-- ** maxContentWidth #attr:maxContentWidth#
-- | The maximum content width of /@scrolledWindow@/.

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowMaxContentWidthPropertyInfo,
#endif
    constructScrolledWindowMaxContentWidth  ,
    getScrolledWindowMaxContentWidth        ,
#if defined(ENABLE_OVERLOADING)
    scrolledWindowMaxContentWidth           ,
#endif
    setScrolledWindowMaxContentWidth        ,


-- ** minContentHeight #attr:minContentHeight#
-- | The minimum content height of /@scrolledWindow@/.

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowMinContentHeightPropertyInfo,
#endif
    constructScrolledWindowMinContentHeight ,
    getScrolledWindowMinContentHeight       ,
#if defined(ENABLE_OVERLOADING)
    scrolledWindowMinContentHeight          ,
#endif
    setScrolledWindowMinContentHeight       ,


-- ** minContentWidth #attr:minContentWidth#
-- | The minimum content width of /@scrolledWindow@/.

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowMinContentWidthPropertyInfo,
#endif
    constructScrolledWindowMinContentWidth  ,
    getScrolledWindowMinContentWidth        ,
#if defined(ENABLE_OVERLOADING)
    scrolledWindowMinContentWidth           ,
#endif
    setScrolledWindowMinContentWidth        ,


-- ** overlayScrolling #attr:overlayScrolling#
-- | Whether overlay scrolling is enabled or not.
-- 
-- If it is, the scrollbars are only added as traditional widgets
-- when a mouse is present. Otherwise, they are overlaid on top of
-- the content, as narrow indicators.
-- 
-- Note that overlay scrolling can also be globally disabled, with
-- the [Settings:gtkOverlayScrolling]("GI.Gtk.Objects.Settings#g:attr:gtkOverlayScrolling") setting.

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowOverlayScrollingPropertyInfo,
#endif
    constructScrolledWindowOverlayScrolling ,
    getScrolledWindowOverlayScrolling       ,
#if defined(ENABLE_OVERLOADING)
    scrolledWindowOverlayScrolling          ,
#endif
    setScrolledWindowOverlayScrolling       ,


-- ** propagateNaturalHeight #attr:propagateNaturalHeight#
-- | Whether the natural height of the child should be calculated and propagated
-- through the scrolled window’s requested natural height.
-- 
-- This is useful in cases where an attempt should be made to allocate exactly
-- enough space for the natural size of the child.

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowPropagateNaturalHeightPropertyInfo,
#endif
    constructScrolledWindowPropagateNaturalHeight,
    getScrolledWindowPropagateNaturalHeight ,
#if defined(ENABLE_OVERLOADING)
    scrolledWindowPropagateNaturalHeight    ,
#endif
    setScrolledWindowPropagateNaturalHeight ,


-- ** propagateNaturalWidth #attr:propagateNaturalWidth#
-- | Whether the natural width of the child should be calculated and propagated
-- through the scrolled window’s requested natural width.
-- 
-- This is useful in cases where an attempt should be made to allocate exactly
-- enough space for the natural size of the child.

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowPropagateNaturalWidthPropertyInfo,
#endif
    constructScrolledWindowPropagateNaturalWidth,
    getScrolledWindowPropagateNaturalWidth  ,
#if defined(ENABLE_OVERLOADING)
    scrolledWindowPropagateNaturalWidth     ,
#endif
    setScrolledWindowPropagateNaturalWidth  ,


-- ** vadjustment #attr:vadjustment#
-- | The @GtkAdjustment@ for the vertical position.

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowVadjustmentPropertyInfo   ,
#endif
    clearScrolledWindowVadjustment          ,
    constructScrolledWindowVadjustment      ,
    getScrolledWindowVadjustment            ,
#if defined(ENABLE_OVERLOADING)
    scrolledWindowVadjustment               ,
#endif
    setScrolledWindowVadjustment            ,


-- ** vscrollbarPolicy #attr:vscrollbarPolicy#
-- | When the vertical scrollbar is displayed.
-- 
-- Use 'GI.Gtk.Objects.ScrolledWindow.scrolledWindowSetPolicy' to set
-- this property.

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowVscrollbarPolicyPropertyInfo,
#endif
    constructScrolledWindowVscrollbarPolicy ,
    getScrolledWindowVscrollbarPolicy       ,
#if defined(ENABLE_OVERLOADING)
    scrolledWindowVscrollbarPolicy          ,
#endif
    setScrolledWindowVscrollbarPolicy       ,


-- ** windowPlacement #attr:windowPlacement#
-- | Where the contents are located with respect to the scrollbars.

#if defined(ENABLE_OVERLOADING)
    ScrolledWindowWindowPlacementPropertyInfo,
#endif
    constructScrolledWindowWindowPlacement  ,
    getScrolledWindowWindowPlacement        ,
#if defined(ENABLE_OVERLOADING)
    scrolledWindowWindowPlacement           ,
#endif
    setScrolledWindowWindowPlacement        ,




 -- * Signals


-- ** edgeOvershot #signal:edgeOvershot#

    ScrolledWindowEdgeOvershotCallback      ,
#if defined(ENABLE_OVERLOADING)
    ScrolledWindowEdgeOvershotSignalInfo    ,
#endif
    afterScrolledWindowEdgeOvershot         ,
    onScrolledWindowEdgeOvershot            ,


-- ** edgeReached #signal:edgeReached#

    ScrolledWindowEdgeReachedCallback       ,
#if defined(ENABLE_OVERLOADING)
    ScrolledWindowEdgeReachedSignalInfo     ,
#endif
    afterScrolledWindowEdgeReached          ,
    onScrolledWindowEdgeReached             ,


-- ** moveFocusOut #signal:moveFocusOut#

    ScrolledWindowMoveFocusOutCallback      ,
#if defined(ENABLE_OVERLOADING)
    ScrolledWindowMoveFocusOutSignalInfo    ,
#endif
    afterScrolledWindowMoveFocusOut         ,
    onScrolledWindowMoveFocusOut            ,


-- ** scrollChild #signal:scrollChild#

    ScrolledWindowScrollChildCallback       ,
#if defined(ENABLE_OVERLOADING)
    ScrolledWindowScrollChildSignalInfo     ,
#endif
    afterScrolledWindowScrollChild          ,
    onScrolledWindowScrollChild             ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Adjustment as Gtk.Adjustment
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Objects.Adjustment as Gtk.Adjustment
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget

#endif

-- | Memory-managed wrapper type.
newtype ScrolledWindow = ScrolledWindow (SP.ManagedPtr ScrolledWindow)
    deriving (Eq)

instance SP.ManagedPtrNewtype ScrolledWindow where
    toManagedPtr (ScrolledWindow p) = p

foreign import ccall "gtk_scrolled_window_get_type"
    c_gtk_scrolled_window_get_type :: IO B.Types.GType

instance B.Types.TypedObject ScrolledWindow where
    glibType = c_gtk_scrolled_window_get_type

instance B.Types.GObject ScrolledWindow

-- | Type class for types which can be safely cast to t'ScrolledWindow', for instance with `toScrolledWindow`.
class (SP.GObject o, O.IsDescendantOf ScrolledWindow o) => IsScrolledWindow o
instance (SP.GObject o, O.IsDescendantOf ScrolledWindow o) => IsScrolledWindow o

instance O.HasParentTypes ScrolledWindow
type instance O.ParentTypes ScrolledWindow = '[Gtk.Widget.Widget, GObject.Object.Object, Gtk.Accessible.Accessible, Gtk.Buildable.Buildable, Gtk.ConstraintTarget.ConstraintTarget]

-- | Cast to t'ScrolledWindow', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toScrolledWindow :: (MIO.MonadIO m, IsScrolledWindow o) => o -> m ScrolledWindow
toScrolledWindow = MIO.liftIO . B.ManagedPtr.unsafeCastTo ScrolledWindow

-- | Convert t'ScrolledWindow' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ScrolledWindow) where
    gvalueGType_ = c_gtk_scrolled_window_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr ScrolledWindow)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr ScrolledWindow)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject ScrolledWindow ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveScrolledWindowMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveScrolledWindowMethod "actionSetEnabled" o = Gtk.Widget.WidgetActionSetEnabledMethodInfo
    ResolveScrolledWindowMethod "activate" o = Gtk.Widget.WidgetActivateMethodInfo
    ResolveScrolledWindowMethod "activateAction" o = Gtk.Widget.WidgetActivateActionMethodInfo
    ResolveScrolledWindowMethod "activateDefault" o = Gtk.Widget.WidgetActivateDefaultMethodInfo
    ResolveScrolledWindowMethod "addController" o = Gtk.Widget.WidgetAddControllerMethodInfo
    ResolveScrolledWindowMethod "addCssClass" o = Gtk.Widget.WidgetAddCssClassMethodInfo
    ResolveScrolledWindowMethod "addMnemonicLabel" o = Gtk.Widget.WidgetAddMnemonicLabelMethodInfo
    ResolveScrolledWindowMethod "addTickCallback" o = Gtk.Widget.WidgetAddTickCallbackMethodInfo
    ResolveScrolledWindowMethod "allocate" o = Gtk.Widget.WidgetAllocateMethodInfo
    ResolveScrolledWindowMethod "announce" o = Gtk.Accessible.AccessibleAnnounceMethodInfo
    ResolveScrolledWindowMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveScrolledWindowMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveScrolledWindowMethod "childFocus" o = Gtk.Widget.WidgetChildFocusMethodInfo
    ResolveScrolledWindowMethod "computeBounds" o = Gtk.Widget.WidgetComputeBoundsMethodInfo
    ResolveScrolledWindowMethod "computeExpand" o = Gtk.Widget.WidgetComputeExpandMethodInfo
    ResolveScrolledWindowMethod "computePoint" o = Gtk.Widget.WidgetComputePointMethodInfo
    ResolveScrolledWindowMethod "computeTransform" o = Gtk.Widget.WidgetComputeTransformMethodInfo
    ResolveScrolledWindowMethod "contains" o = Gtk.Widget.WidgetContainsMethodInfo
    ResolveScrolledWindowMethod "createPangoContext" o = Gtk.Widget.WidgetCreatePangoContextMethodInfo
    ResolveScrolledWindowMethod "createPangoLayout" o = Gtk.Widget.WidgetCreatePangoLayoutMethodInfo
    ResolveScrolledWindowMethod "disposeTemplate" o = Gtk.Widget.WidgetDisposeTemplateMethodInfo
    ResolveScrolledWindowMethod "dragCheckThreshold" o = Gtk.Widget.WidgetDragCheckThresholdMethodInfo
    ResolveScrolledWindowMethod "errorBell" o = Gtk.Widget.WidgetErrorBellMethodInfo
    ResolveScrolledWindowMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveScrolledWindowMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveScrolledWindowMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveScrolledWindowMethod "grabFocus" o = Gtk.Widget.WidgetGrabFocusMethodInfo
    ResolveScrolledWindowMethod "hasCssClass" o = Gtk.Widget.WidgetHasCssClassMethodInfo
    ResolveScrolledWindowMethod "hasDefault" o = Gtk.Widget.WidgetHasDefaultMethodInfo
    ResolveScrolledWindowMethod "hasFocus" o = Gtk.Widget.WidgetHasFocusMethodInfo
    ResolveScrolledWindowMethod "hasVisibleFocus" o = Gtk.Widget.WidgetHasVisibleFocusMethodInfo
    ResolveScrolledWindowMethod "hide" o = Gtk.Widget.WidgetHideMethodInfo
    ResolveScrolledWindowMethod "inDestruction" o = Gtk.Widget.WidgetInDestructionMethodInfo
    ResolveScrolledWindowMethod "initTemplate" o = Gtk.Widget.WidgetInitTemplateMethodInfo
    ResolveScrolledWindowMethod "insertActionGroup" o = Gtk.Widget.WidgetInsertActionGroupMethodInfo
    ResolveScrolledWindowMethod "insertAfter" o = Gtk.Widget.WidgetInsertAfterMethodInfo
    ResolveScrolledWindowMethod "insertBefore" o = Gtk.Widget.WidgetInsertBeforeMethodInfo
    ResolveScrolledWindowMethod "isAncestor" o = Gtk.Widget.WidgetIsAncestorMethodInfo
    ResolveScrolledWindowMethod "isDrawable" o = Gtk.Widget.WidgetIsDrawableMethodInfo
    ResolveScrolledWindowMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveScrolledWindowMethod "isFocus" o = Gtk.Widget.WidgetIsFocusMethodInfo
    ResolveScrolledWindowMethod "isSensitive" o = Gtk.Widget.WidgetIsSensitiveMethodInfo
    ResolveScrolledWindowMethod "isVisible" o = Gtk.Widget.WidgetIsVisibleMethodInfo
    ResolveScrolledWindowMethod "keynavFailed" o = Gtk.Widget.WidgetKeynavFailedMethodInfo
    ResolveScrolledWindowMethod "listMnemonicLabels" o = Gtk.Widget.WidgetListMnemonicLabelsMethodInfo
    ResolveScrolledWindowMethod "map" o = Gtk.Widget.WidgetMapMethodInfo
    ResolveScrolledWindowMethod "measure" o = Gtk.Widget.WidgetMeasureMethodInfo
    ResolveScrolledWindowMethod "mnemonicActivate" o = Gtk.Widget.WidgetMnemonicActivateMethodInfo
    ResolveScrolledWindowMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveScrolledWindowMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveScrolledWindowMethod "observeChildren" o = Gtk.Widget.WidgetObserveChildrenMethodInfo
    ResolveScrolledWindowMethod "observeControllers" o = Gtk.Widget.WidgetObserveControllersMethodInfo
    ResolveScrolledWindowMethod "pick" o = Gtk.Widget.WidgetPickMethodInfo
    ResolveScrolledWindowMethod "queueAllocate" o = Gtk.Widget.WidgetQueueAllocateMethodInfo
    ResolveScrolledWindowMethod "queueDraw" o = Gtk.Widget.WidgetQueueDrawMethodInfo
    ResolveScrolledWindowMethod "queueResize" o = Gtk.Widget.WidgetQueueResizeMethodInfo
    ResolveScrolledWindowMethod "realize" o = Gtk.Widget.WidgetRealizeMethodInfo
    ResolveScrolledWindowMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveScrolledWindowMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveScrolledWindowMethod "removeController" o = Gtk.Widget.WidgetRemoveControllerMethodInfo
    ResolveScrolledWindowMethod "removeCssClass" o = Gtk.Widget.WidgetRemoveCssClassMethodInfo
    ResolveScrolledWindowMethod "removeMnemonicLabel" o = Gtk.Widget.WidgetRemoveMnemonicLabelMethodInfo
    ResolveScrolledWindowMethod "removeTickCallback" o = Gtk.Widget.WidgetRemoveTickCallbackMethodInfo
    ResolveScrolledWindowMethod "resetProperty" o = Gtk.Accessible.AccessibleResetPropertyMethodInfo
    ResolveScrolledWindowMethod "resetRelation" o = Gtk.Accessible.AccessibleResetRelationMethodInfo
    ResolveScrolledWindowMethod "resetState" o = Gtk.Accessible.AccessibleResetStateMethodInfo
    ResolveScrolledWindowMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveScrolledWindowMethod "shouldLayout" o = Gtk.Widget.WidgetShouldLayoutMethodInfo
    ResolveScrolledWindowMethod "show" o = Gtk.Widget.WidgetShowMethodInfo
    ResolveScrolledWindowMethod "sizeAllocate" o = Gtk.Widget.WidgetSizeAllocateMethodInfo
    ResolveScrolledWindowMethod "snapshotChild" o = Gtk.Widget.WidgetSnapshotChildMethodInfo
    ResolveScrolledWindowMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveScrolledWindowMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveScrolledWindowMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveScrolledWindowMethod "translateCoordinates" o = Gtk.Widget.WidgetTranslateCoordinatesMethodInfo
    ResolveScrolledWindowMethod "triggerTooltipQuery" o = Gtk.Widget.WidgetTriggerTooltipQueryMethodInfo
    ResolveScrolledWindowMethod "unmap" o = Gtk.Widget.WidgetUnmapMethodInfo
    ResolveScrolledWindowMethod "unparent" o = Gtk.Widget.WidgetUnparentMethodInfo
    ResolveScrolledWindowMethod "unrealize" o = Gtk.Widget.WidgetUnrealizeMethodInfo
    ResolveScrolledWindowMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveScrolledWindowMethod "unsetPlacement" o = ScrolledWindowUnsetPlacementMethodInfo
    ResolveScrolledWindowMethod "unsetStateFlags" o = Gtk.Widget.WidgetUnsetStateFlagsMethodInfo
    ResolveScrolledWindowMethod "updateNextAccessibleSibling" o = Gtk.Accessible.AccessibleUpdateNextAccessibleSiblingMethodInfo
    ResolveScrolledWindowMethod "updatePlatformState" o = Gtk.Accessible.AccessibleUpdatePlatformStateMethodInfo
    ResolveScrolledWindowMethod "updateProperty" o = Gtk.Accessible.AccessibleUpdatePropertyMethodInfo
    ResolveScrolledWindowMethod "updateRelation" o = Gtk.Accessible.AccessibleUpdateRelationMethodInfo
    ResolveScrolledWindowMethod "updateState" o = Gtk.Accessible.AccessibleUpdateStateMethodInfo
    ResolveScrolledWindowMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveScrolledWindowMethod "getAccessibleParent" o = Gtk.Accessible.AccessibleGetAccessibleParentMethodInfo
    ResolveScrolledWindowMethod "getAccessibleRole" o = Gtk.Accessible.AccessibleGetAccessibleRoleMethodInfo
    ResolveScrolledWindowMethod "getAllocatedBaseline" o = Gtk.Widget.WidgetGetAllocatedBaselineMethodInfo
    ResolveScrolledWindowMethod "getAllocatedHeight" o = Gtk.Widget.WidgetGetAllocatedHeightMethodInfo
    ResolveScrolledWindowMethod "getAllocatedWidth" o = Gtk.Widget.WidgetGetAllocatedWidthMethodInfo
    ResolveScrolledWindowMethod "getAllocation" o = Gtk.Widget.WidgetGetAllocationMethodInfo
    ResolveScrolledWindowMethod "getAncestor" o = Gtk.Widget.WidgetGetAncestorMethodInfo
    ResolveScrolledWindowMethod "getAtContext" o = Gtk.Accessible.AccessibleGetAtContextMethodInfo
    ResolveScrolledWindowMethod "getBaseline" o = Gtk.Widget.WidgetGetBaselineMethodInfo
    ResolveScrolledWindowMethod "getBounds" o = Gtk.Accessible.AccessibleGetBoundsMethodInfo
    ResolveScrolledWindowMethod "getBuildableId" o = Gtk.Buildable.BuildableGetBuildableIdMethodInfo
    ResolveScrolledWindowMethod "getCanFocus" o = Gtk.Widget.WidgetGetCanFocusMethodInfo
    ResolveScrolledWindowMethod "getCanTarget" o = Gtk.Widget.WidgetGetCanTargetMethodInfo
    ResolveScrolledWindowMethod "getChild" o = ScrolledWindowGetChildMethodInfo
    ResolveScrolledWindowMethod "getChildVisible" o = Gtk.Widget.WidgetGetChildVisibleMethodInfo
    ResolveScrolledWindowMethod "getClipboard" o = Gtk.Widget.WidgetGetClipboardMethodInfo
    ResolveScrolledWindowMethod "getColor" o = Gtk.Widget.WidgetGetColorMethodInfo
    ResolveScrolledWindowMethod "getCssClasses" o = Gtk.Widget.WidgetGetCssClassesMethodInfo
    ResolveScrolledWindowMethod "getCssName" o = Gtk.Widget.WidgetGetCssNameMethodInfo
    ResolveScrolledWindowMethod "getCursor" o = Gtk.Widget.WidgetGetCursorMethodInfo
    ResolveScrolledWindowMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveScrolledWindowMethod "getDirection" o = Gtk.Widget.WidgetGetDirectionMethodInfo
    ResolveScrolledWindowMethod "getDisplay" o = Gtk.Widget.WidgetGetDisplayMethodInfo
    ResolveScrolledWindowMethod "getFirstAccessibleChild" o = Gtk.Accessible.AccessibleGetFirstAccessibleChildMethodInfo
    ResolveScrolledWindowMethod "getFirstChild" o = Gtk.Widget.WidgetGetFirstChildMethodInfo
    ResolveScrolledWindowMethod "getFocusChild" o = Gtk.Widget.WidgetGetFocusChildMethodInfo
    ResolveScrolledWindowMethod "getFocusOnClick" o = Gtk.Widget.WidgetGetFocusOnClickMethodInfo
    ResolveScrolledWindowMethod "getFocusable" o = Gtk.Widget.WidgetGetFocusableMethodInfo
    ResolveScrolledWindowMethod "getFontMap" o = Gtk.Widget.WidgetGetFontMapMethodInfo
    ResolveScrolledWindowMethod "getFontOptions" o = Gtk.Widget.WidgetGetFontOptionsMethodInfo
    ResolveScrolledWindowMethod "getFrameClock" o = Gtk.Widget.WidgetGetFrameClockMethodInfo
    ResolveScrolledWindowMethod "getHadjustment" o = ScrolledWindowGetHadjustmentMethodInfo
    ResolveScrolledWindowMethod "getHalign" o = Gtk.Widget.WidgetGetHalignMethodInfo
    ResolveScrolledWindowMethod "getHasFrame" o = ScrolledWindowGetHasFrameMethodInfo
    ResolveScrolledWindowMethod "getHasTooltip" o = Gtk.Widget.WidgetGetHasTooltipMethodInfo
    ResolveScrolledWindowMethod "getHeight" o = Gtk.Widget.WidgetGetHeightMethodInfo
    ResolveScrolledWindowMethod "getHexpand" o = Gtk.Widget.WidgetGetHexpandMethodInfo
    ResolveScrolledWindowMethod "getHexpandSet" o = Gtk.Widget.WidgetGetHexpandSetMethodInfo
    ResolveScrolledWindowMethod "getHscrollbar" o = ScrolledWindowGetHscrollbarMethodInfo
    ResolveScrolledWindowMethod "getKineticScrolling" o = ScrolledWindowGetKineticScrollingMethodInfo
    ResolveScrolledWindowMethod "getLastChild" o = Gtk.Widget.WidgetGetLastChildMethodInfo
    ResolveScrolledWindowMethod "getLayoutManager" o = Gtk.Widget.WidgetGetLayoutManagerMethodInfo
    ResolveScrolledWindowMethod "getLimitEvents" o = Gtk.Widget.WidgetGetLimitEventsMethodInfo
    ResolveScrolledWindowMethod "getMapped" o = Gtk.Widget.WidgetGetMappedMethodInfo
    ResolveScrolledWindowMethod "getMarginBottom" o = Gtk.Widget.WidgetGetMarginBottomMethodInfo
    ResolveScrolledWindowMethod "getMarginEnd" o = Gtk.Widget.WidgetGetMarginEndMethodInfo
    ResolveScrolledWindowMethod "getMarginStart" o = Gtk.Widget.WidgetGetMarginStartMethodInfo
    ResolveScrolledWindowMethod "getMarginTop" o = Gtk.Widget.WidgetGetMarginTopMethodInfo
    ResolveScrolledWindowMethod "getMaxContentHeight" o = ScrolledWindowGetMaxContentHeightMethodInfo
    ResolveScrolledWindowMethod "getMaxContentWidth" o = ScrolledWindowGetMaxContentWidthMethodInfo
    ResolveScrolledWindowMethod "getMinContentHeight" o = ScrolledWindowGetMinContentHeightMethodInfo
    ResolveScrolledWindowMethod "getMinContentWidth" o = ScrolledWindowGetMinContentWidthMethodInfo
    ResolveScrolledWindowMethod "getName" o = Gtk.Widget.WidgetGetNameMethodInfo
    ResolveScrolledWindowMethod "getNative" o = Gtk.Widget.WidgetGetNativeMethodInfo
    ResolveScrolledWindowMethod "getNextAccessibleSibling" o = Gtk.Accessible.AccessibleGetNextAccessibleSiblingMethodInfo
    ResolveScrolledWindowMethod "getNextSibling" o = Gtk.Widget.WidgetGetNextSiblingMethodInfo
    ResolveScrolledWindowMethod "getOpacity" o = Gtk.Widget.WidgetGetOpacityMethodInfo
    ResolveScrolledWindowMethod "getOverflow" o = Gtk.Widget.WidgetGetOverflowMethodInfo
    ResolveScrolledWindowMethod "getOverlayScrolling" o = ScrolledWindowGetOverlayScrollingMethodInfo
    ResolveScrolledWindowMethod "getPangoContext" o = Gtk.Widget.WidgetGetPangoContextMethodInfo
    ResolveScrolledWindowMethod "getParent" o = Gtk.Widget.WidgetGetParentMethodInfo
    ResolveScrolledWindowMethod "getPlacement" o = ScrolledWindowGetPlacementMethodInfo
    ResolveScrolledWindowMethod "getPlatformState" o = Gtk.Accessible.AccessibleGetPlatformStateMethodInfo
    ResolveScrolledWindowMethod "getPolicy" o = ScrolledWindowGetPolicyMethodInfo
    ResolveScrolledWindowMethod "getPreferredSize" o = Gtk.Widget.WidgetGetPreferredSizeMethodInfo
    ResolveScrolledWindowMethod "getPrevSibling" o = Gtk.Widget.WidgetGetPrevSiblingMethodInfo
    ResolveScrolledWindowMethod "getPrimaryClipboard" o = Gtk.Widget.WidgetGetPrimaryClipboardMethodInfo
    ResolveScrolledWindowMethod "getPropagateNaturalHeight" o = ScrolledWindowGetPropagateNaturalHeightMethodInfo
    ResolveScrolledWindowMethod "getPropagateNaturalWidth" o = ScrolledWindowGetPropagateNaturalWidthMethodInfo
    ResolveScrolledWindowMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveScrolledWindowMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveScrolledWindowMethod "getRealized" o = Gtk.Widget.WidgetGetRealizedMethodInfo
    ResolveScrolledWindowMethod "getReceivesDefault" o = Gtk.Widget.WidgetGetReceivesDefaultMethodInfo
    ResolveScrolledWindowMethod "getRequestMode" o = Gtk.Widget.WidgetGetRequestModeMethodInfo
    ResolveScrolledWindowMethod "getRoot" o = Gtk.Widget.WidgetGetRootMethodInfo
    ResolveScrolledWindowMethod "getScaleFactor" o = Gtk.Widget.WidgetGetScaleFactorMethodInfo
    ResolveScrolledWindowMethod "getSensitive" o = Gtk.Widget.WidgetGetSensitiveMethodInfo
    ResolveScrolledWindowMethod "getSettings" o = Gtk.Widget.WidgetGetSettingsMethodInfo
    ResolveScrolledWindowMethod "getSize" o = Gtk.Widget.WidgetGetSizeMethodInfo
    ResolveScrolledWindowMethod "getSizeRequest" o = Gtk.Widget.WidgetGetSizeRequestMethodInfo
    ResolveScrolledWindowMethod "getStateFlags" o = Gtk.Widget.WidgetGetStateFlagsMethodInfo
    ResolveScrolledWindowMethod "getStyleContext" o = Gtk.Widget.WidgetGetStyleContextMethodInfo
    ResolveScrolledWindowMethod "getTemplateChild" o = Gtk.Widget.WidgetGetTemplateChildMethodInfo
    ResolveScrolledWindowMethod "getTooltipMarkup" o = Gtk.Widget.WidgetGetTooltipMarkupMethodInfo
    ResolveScrolledWindowMethod "getTooltipText" o = Gtk.Widget.WidgetGetTooltipTextMethodInfo
    ResolveScrolledWindowMethod "getVadjustment" o = ScrolledWindowGetVadjustmentMethodInfo
    ResolveScrolledWindowMethod "getValign" o = Gtk.Widget.WidgetGetValignMethodInfo
    ResolveScrolledWindowMethod "getVexpand" o = Gtk.Widget.WidgetGetVexpandMethodInfo
    ResolveScrolledWindowMethod "getVexpandSet" o = Gtk.Widget.WidgetGetVexpandSetMethodInfo
    ResolveScrolledWindowMethod "getVisible" o = Gtk.Widget.WidgetGetVisibleMethodInfo
    ResolveScrolledWindowMethod "getVscrollbar" o = ScrolledWindowGetVscrollbarMethodInfo
    ResolveScrolledWindowMethod "getWidth" o = Gtk.Widget.WidgetGetWidthMethodInfo
    ResolveScrolledWindowMethod "setAccessibleParent" o = Gtk.Accessible.AccessibleSetAccessibleParentMethodInfo
    ResolveScrolledWindowMethod "setCanFocus" o = Gtk.Widget.WidgetSetCanFocusMethodInfo
    ResolveScrolledWindowMethod "setCanTarget" o = Gtk.Widget.WidgetSetCanTargetMethodInfo
    ResolveScrolledWindowMethod "setChild" o = ScrolledWindowSetChildMethodInfo
    ResolveScrolledWindowMethod "setChildVisible" o = Gtk.Widget.WidgetSetChildVisibleMethodInfo
    ResolveScrolledWindowMethod "setCssClasses" o = Gtk.Widget.WidgetSetCssClassesMethodInfo
    ResolveScrolledWindowMethod "setCursor" o = Gtk.Widget.WidgetSetCursorMethodInfo
    ResolveScrolledWindowMethod "setCursorFromName" o = Gtk.Widget.WidgetSetCursorFromNameMethodInfo
    ResolveScrolledWindowMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveScrolledWindowMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveScrolledWindowMethod "setDirection" o = Gtk.Widget.WidgetSetDirectionMethodInfo
    ResolveScrolledWindowMethod "setFocusChild" o = Gtk.Widget.WidgetSetFocusChildMethodInfo
    ResolveScrolledWindowMethod "setFocusOnClick" o = Gtk.Widget.WidgetSetFocusOnClickMethodInfo
    ResolveScrolledWindowMethod "setFocusable" o = Gtk.Widget.WidgetSetFocusableMethodInfo
    ResolveScrolledWindowMethod "setFontMap" o = Gtk.Widget.WidgetSetFontMapMethodInfo
    ResolveScrolledWindowMethod "setFontOptions" o = Gtk.Widget.WidgetSetFontOptionsMethodInfo
    ResolveScrolledWindowMethod "setHadjustment" o = ScrolledWindowSetHadjustmentMethodInfo
    ResolveScrolledWindowMethod "setHalign" o = Gtk.Widget.WidgetSetHalignMethodInfo
    ResolveScrolledWindowMethod "setHasFrame" o = ScrolledWindowSetHasFrameMethodInfo
    ResolveScrolledWindowMethod "setHasTooltip" o = Gtk.Widget.WidgetSetHasTooltipMethodInfo
    ResolveScrolledWindowMethod "setHexpand" o = Gtk.Widget.WidgetSetHexpandMethodInfo
    ResolveScrolledWindowMethod "setHexpandSet" o = Gtk.Widget.WidgetSetHexpandSetMethodInfo
    ResolveScrolledWindowMethod "setKineticScrolling" o = ScrolledWindowSetKineticScrollingMethodInfo
    ResolveScrolledWindowMethod "setLayoutManager" o = Gtk.Widget.WidgetSetLayoutManagerMethodInfo
    ResolveScrolledWindowMethod "setLimitEvents" o = Gtk.Widget.WidgetSetLimitEventsMethodInfo
    ResolveScrolledWindowMethod "setMarginBottom" o = Gtk.Widget.WidgetSetMarginBottomMethodInfo
    ResolveScrolledWindowMethod "setMarginEnd" o = Gtk.Widget.WidgetSetMarginEndMethodInfo
    ResolveScrolledWindowMethod "setMarginStart" o = Gtk.Widget.WidgetSetMarginStartMethodInfo
    ResolveScrolledWindowMethod "setMarginTop" o = Gtk.Widget.WidgetSetMarginTopMethodInfo
    ResolveScrolledWindowMethod "setMaxContentHeight" o = ScrolledWindowSetMaxContentHeightMethodInfo
    ResolveScrolledWindowMethod "setMaxContentWidth" o = ScrolledWindowSetMaxContentWidthMethodInfo
    ResolveScrolledWindowMethod "setMinContentHeight" o = ScrolledWindowSetMinContentHeightMethodInfo
    ResolveScrolledWindowMethod "setMinContentWidth" o = ScrolledWindowSetMinContentWidthMethodInfo
    ResolveScrolledWindowMethod "setName" o = Gtk.Widget.WidgetSetNameMethodInfo
    ResolveScrolledWindowMethod "setOpacity" o = Gtk.Widget.WidgetSetOpacityMethodInfo
    ResolveScrolledWindowMethod "setOverflow" o = Gtk.Widget.WidgetSetOverflowMethodInfo
    ResolveScrolledWindowMethod "setOverlayScrolling" o = ScrolledWindowSetOverlayScrollingMethodInfo
    ResolveScrolledWindowMethod "setParent" o = Gtk.Widget.WidgetSetParentMethodInfo
    ResolveScrolledWindowMethod "setPlacement" o = ScrolledWindowSetPlacementMethodInfo
    ResolveScrolledWindowMethod "setPolicy" o = ScrolledWindowSetPolicyMethodInfo
    ResolveScrolledWindowMethod "setPropagateNaturalHeight" o = ScrolledWindowSetPropagateNaturalHeightMethodInfo
    ResolveScrolledWindowMethod "setPropagateNaturalWidth" o = ScrolledWindowSetPropagateNaturalWidthMethodInfo
    ResolveScrolledWindowMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveScrolledWindowMethod "setReceivesDefault" o = Gtk.Widget.WidgetSetReceivesDefaultMethodInfo
    ResolveScrolledWindowMethod "setSensitive" o = Gtk.Widget.WidgetSetSensitiveMethodInfo
    ResolveScrolledWindowMethod "setSizeRequest" o = Gtk.Widget.WidgetSetSizeRequestMethodInfo
    ResolveScrolledWindowMethod "setStateFlags" o = Gtk.Widget.WidgetSetStateFlagsMethodInfo
    ResolveScrolledWindowMethod "setTooltipMarkup" o = Gtk.Widget.WidgetSetTooltipMarkupMethodInfo
    ResolveScrolledWindowMethod "setTooltipText" o = Gtk.Widget.WidgetSetTooltipTextMethodInfo
    ResolveScrolledWindowMethod "setVadjustment" o = ScrolledWindowSetVadjustmentMethodInfo
    ResolveScrolledWindowMethod "setValign" o = Gtk.Widget.WidgetSetValignMethodInfo
    ResolveScrolledWindowMethod "setVexpand" o = Gtk.Widget.WidgetSetVexpandMethodInfo
    ResolveScrolledWindowMethod "setVexpandSet" o = Gtk.Widget.WidgetSetVexpandSetMethodInfo
    ResolveScrolledWindowMethod "setVisible" o = Gtk.Widget.WidgetSetVisibleMethodInfo
    ResolveScrolledWindowMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveScrolledWindowMethod t ScrolledWindow, O.OverloadedMethod info ScrolledWindow p) => OL.IsLabel t (ScrolledWindow -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveScrolledWindowMethod t ScrolledWindow, O.OverloadedMethod info ScrolledWindow p, R.HasField t ScrolledWindow p) => R.HasField t ScrolledWindow p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveScrolledWindowMethod t ScrolledWindow, O.OverloadedMethodInfo info ScrolledWindow) => OL.IsLabel t (O.MethodProxy info ScrolledWindow) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- signal ScrolledWindow::edge-overshot
-- | Emitted whenever user initiated scrolling makes the scrolled
-- window firmly surpass the limits defined by the adjustment
-- in that orientation.
-- 
-- A similar behavior without edge resistance is provided by the
-- [ScrolledWindow::edgeReached]("GI.Gtk.Objects.ScrolledWindow#g:signal:edgeReached") signal.
-- 
-- Note: The /@pos@/ argument is LTR\/RTL aware, so callers should be
-- aware too if intending to provide behavior on horizontal edges.
type ScrolledWindowEdgeOvershotCallback =
    Gtk.Enums.PositionType
    -- ^ /@pos@/: edge side that was hit
    -> IO ()

type C_ScrolledWindowEdgeOvershotCallback =
    Ptr ScrolledWindow ->                   -- object
    CUInt ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ScrolledWindowEdgeOvershotCallback`.
foreign import ccall "wrapper"
    mk_ScrolledWindowEdgeOvershotCallback :: C_ScrolledWindowEdgeOvershotCallback -> IO (FunPtr C_ScrolledWindowEdgeOvershotCallback)

wrap_ScrolledWindowEdgeOvershotCallback :: 
    GObject a => (a -> ScrolledWindowEdgeOvershotCallback) ->
    C_ScrolledWindowEdgeOvershotCallback
wrap_ScrolledWindowEdgeOvershotCallback gi'cb gi'selfPtr pos _ = do
    let pos' = (toEnum . fromIntegral) pos
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  pos'


-- | Connect a signal handler for the [edgeOvershot](#signal:edgeOvershot) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' scrolledWindow #edgeOvershot callback
-- @
-- 
-- 
onScrolledWindowEdgeOvershot :: (IsScrolledWindow a, MonadIO m) => a -> ((?self :: a) => ScrolledWindowEdgeOvershotCallback) -> m SignalHandlerId
onScrolledWindowEdgeOvershot obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ScrolledWindowEdgeOvershotCallback wrapped
    wrapped'' <- mk_ScrolledWindowEdgeOvershotCallback wrapped'
    connectSignalFunPtr obj "edge-overshot" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [edgeOvershot](#signal:edgeOvershot) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' scrolledWindow #edgeOvershot callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterScrolledWindowEdgeOvershot :: (IsScrolledWindow a, MonadIO m) => a -> ((?self :: a) => ScrolledWindowEdgeOvershotCallback) -> m SignalHandlerId
afterScrolledWindowEdgeOvershot obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ScrolledWindowEdgeOvershotCallback wrapped
    wrapped'' <- mk_ScrolledWindowEdgeOvershotCallback wrapped'
    connectSignalFunPtr obj "edge-overshot" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ScrolledWindowEdgeOvershotSignalInfo
instance SignalInfo ScrolledWindowEdgeOvershotSignalInfo where
    type HaskellCallbackType ScrolledWindowEdgeOvershotSignalInfo = ScrolledWindowEdgeOvershotCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ScrolledWindowEdgeOvershotCallback cb
        cb'' <- mk_ScrolledWindowEdgeOvershotCallback cb'
        connectSignalFunPtr obj "edge-overshot" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow::edge-overshot"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#g:signal:edgeOvershot"})

#endif

-- signal ScrolledWindow::edge-reached
-- | Emitted whenever user-initiated scrolling makes the scrolled
-- window exactly reach the lower or upper limits defined by the
-- adjustment in that orientation.
-- 
-- A similar behavior with edge resistance is provided by the
-- [ScrolledWindow::edgeOvershot]("GI.Gtk.Objects.ScrolledWindow#g:signal:edgeOvershot") signal.
-- 
-- Note: The /@pos@/ argument is LTR\/RTL aware, so callers should be
-- aware too if intending to provide behavior on horizontal edges.
type ScrolledWindowEdgeReachedCallback =
    Gtk.Enums.PositionType
    -- ^ /@pos@/: edge side that was reached
    -> IO ()

type C_ScrolledWindowEdgeReachedCallback =
    Ptr ScrolledWindow ->                   -- object
    CUInt ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ScrolledWindowEdgeReachedCallback`.
foreign import ccall "wrapper"
    mk_ScrolledWindowEdgeReachedCallback :: C_ScrolledWindowEdgeReachedCallback -> IO (FunPtr C_ScrolledWindowEdgeReachedCallback)

wrap_ScrolledWindowEdgeReachedCallback :: 
    GObject a => (a -> ScrolledWindowEdgeReachedCallback) ->
    C_ScrolledWindowEdgeReachedCallback
wrap_ScrolledWindowEdgeReachedCallback gi'cb gi'selfPtr pos _ = do
    let pos' = (toEnum . fromIntegral) pos
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  pos'


-- | Connect a signal handler for the [edgeReached](#signal:edgeReached) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' scrolledWindow #edgeReached callback
-- @
-- 
-- 
onScrolledWindowEdgeReached :: (IsScrolledWindow a, MonadIO m) => a -> ((?self :: a) => ScrolledWindowEdgeReachedCallback) -> m SignalHandlerId
onScrolledWindowEdgeReached obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ScrolledWindowEdgeReachedCallback wrapped
    wrapped'' <- mk_ScrolledWindowEdgeReachedCallback wrapped'
    connectSignalFunPtr obj "edge-reached" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [edgeReached](#signal:edgeReached) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' scrolledWindow #edgeReached callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterScrolledWindowEdgeReached :: (IsScrolledWindow a, MonadIO m) => a -> ((?self :: a) => ScrolledWindowEdgeReachedCallback) -> m SignalHandlerId
afterScrolledWindowEdgeReached obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ScrolledWindowEdgeReachedCallback wrapped
    wrapped'' <- mk_ScrolledWindowEdgeReachedCallback wrapped'
    connectSignalFunPtr obj "edge-reached" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ScrolledWindowEdgeReachedSignalInfo
instance SignalInfo ScrolledWindowEdgeReachedSignalInfo where
    type HaskellCallbackType ScrolledWindowEdgeReachedSignalInfo = ScrolledWindowEdgeReachedCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ScrolledWindowEdgeReachedCallback cb
        cb'' <- mk_ScrolledWindowEdgeReachedCallback cb'
        connectSignalFunPtr obj "edge-reached" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow::edge-reached"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#g:signal:edgeReached"})

#endif

-- signal ScrolledWindow::move-focus-out
-- | Emitted when focus is moved away from the scrolled window by a
-- keybinding.
-- 
-- This is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- The default bindings for this signal are
-- \<kbd>Ctrl\<\/kbd>+\<kbd>Tab\<\/kbd> to move forward and
-- \<kbd>Ctrl\<\/kbd>+\<kbd>Shift\<\/kbd>+\<kbd>Tab\<\/kbd>\` to move backward.
type ScrolledWindowMoveFocusOutCallback =
    Gtk.Enums.DirectionType
    -- ^ /@directionType@/: either 'GI.Gtk.Enums.DirectionTypeTabForward' or
    --   'GI.Gtk.Enums.DirectionTypeTabBackward'
    -> IO ()

type C_ScrolledWindowMoveFocusOutCallback =
    Ptr ScrolledWindow ->                   -- object
    CUInt ->
    Ptr () ->                               -- user_data
    IO ()

-- | Generate a function pointer callable from C code, from a `C_ScrolledWindowMoveFocusOutCallback`.
foreign import ccall "wrapper"
    mk_ScrolledWindowMoveFocusOutCallback :: C_ScrolledWindowMoveFocusOutCallback -> IO (FunPtr C_ScrolledWindowMoveFocusOutCallback)

wrap_ScrolledWindowMoveFocusOutCallback :: 
    GObject a => (a -> ScrolledWindowMoveFocusOutCallback) ->
    C_ScrolledWindowMoveFocusOutCallback
wrap_ScrolledWindowMoveFocusOutCallback gi'cb gi'selfPtr directionType _ = do
    let directionType' = (toEnum . fromIntegral) directionType
    B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  directionType'


-- | Connect a signal handler for the [moveFocusOut](#signal:moveFocusOut) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' scrolledWindow #moveFocusOut callback
-- @
-- 
-- 
onScrolledWindowMoveFocusOut :: (IsScrolledWindow a, MonadIO m) => a -> ((?self :: a) => ScrolledWindowMoveFocusOutCallback) -> m SignalHandlerId
onScrolledWindowMoveFocusOut obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ScrolledWindowMoveFocusOutCallback wrapped
    wrapped'' <- mk_ScrolledWindowMoveFocusOutCallback wrapped'
    connectSignalFunPtr obj "move-focus-out" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [moveFocusOut](#signal:moveFocusOut) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' scrolledWindow #moveFocusOut callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterScrolledWindowMoveFocusOut :: (IsScrolledWindow a, MonadIO m) => a -> ((?self :: a) => ScrolledWindowMoveFocusOutCallback) -> m SignalHandlerId
afterScrolledWindowMoveFocusOut obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ScrolledWindowMoveFocusOutCallback wrapped
    wrapped'' <- mk_ScrolledWindowMoveFocusOutCallback wrapped'
    connectSignalFunPtr obj "move-focus-out" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ScrolledWindowMoveFocusOutSignalInfo
instance SignalInfo ScrolledWindowMoveFocusOutSignalInfo where
    type HaskellCallbackType ScrolledWindowMoveFocusOutSignalInfo = ScrolledWindowMoveFocusOutCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ScrolledWindowMoveFocusOutCallback cb
        cb'' <- mk_ScrolledWindowMoveFocusOutCallback cb'
        connectSignalFunPtr obj "move-focus-out" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow::move-focus-out"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#g:signal:moveFocusOut"})

#endif

-- signal ScrolledWindow::scroll-child
-- | Emitted when a keybinding that scrolls is pressed.
-- 
-- This is a <https://docs.gtk.org/gtk4/class.SignalAction.html keybinding signal>.
-- 
-- The horizontal or vertical adjustment is updated which triggers a
-- signal that the scrolled window’s child may listen to and scroll itself.
type ScrolledWindowScrollChildCallback =
    Gtk.Enums.ScrollType
    -- ^ /@scroll@/: a @GtkScrollType@ describing how much to scroll
    -> Bool
    -- ^ /@horizontal@/: whether the keybinding scrolls the child
    --   horizontally or not
    -> IO Bool
    -- ^ __Returns:__ whether the scroll happened

type C_ScrolledWindowScrollChildCallback =
    Ptr ScrolledWindow ->                   -- object
    CUInt ->
    CInt ->
    Ptr () ->                               -- user_data
    IO CInt

-- | Generate a function pointer callable from C code, from a `C_ScrolledWindowScrollChildCallback`.
foreign import ccall "wrapper"
    mk_ScrolledWindowScrollChildCallback :: C_ScrolledWindowScrollChildCallback -> IO (FunPtr C_ScrolledWindowScrollChildCallback)

wrap_ScrolledWindowScrollChildCallback :: 
    GObject a => (a -> ScrolledWindowScrollChildCallback) ->
    C_ScrolledWindowScrollChildCallback
wrap_ScrolledWindowScrollChildCallback gi'cb gi'selfPtr scroll horizontal _ = do
    let scroll' = (toEnum . fromIntegral) scroll
    let horizontal' = (/= 0) horizontal
    result <- B.ManagedPtr.withNewObject gi'selfPtr $ \gi'self -> gi'cb (Coerce.coerce gi'self)  scroll' horizontal'
    let result' = (P.fromIntegral . P.fromEnum) result
    return result'


-- | Connect a signal handler for the [scrollChild](#signal:scrollChild) signal, to be run before the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.on' scrolledWindow #scrollChild callback
-- @
-- 
-- 
onScrolledWindowScrollChild :: (IsScrolledWindow a, MonadIO m) => a -> ((?self :: a) => ScrolledWindowScrollChildCallback) -> m SignalHandlerId
onScrolledWindowScrollChild obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ScrolledWindowScrollChildCallback wrapped
    wrapped'' <- mk_ScrolledWindowScrollChildCallback wrapped'
    connectSignalFunPtr obj "scroll-child" wrapped'' SignalConnectBefore Nothing

-- | Connect a signal handler for the [scrollChild](#signal:scrollChild) signal, to be run after the default handler.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Signals.after' scrolledWindow #scrollChild callback
-- @
-- 
-- 
-- 
-- By default the object invoking the signal is not passed to the callback.
-- If you need to access it, you can use the implit @?self@ parameter.
-- Note that this requires activating the @ImplicitParams@ GHC extension.
-- 
afterScrolledWindowScrollChild :: (IsScrolledWindow a, MonadIO m) => a -> ((?self :: a) => ScrolledWindowScrollChildCallback) -> m SignalHandlerId
afterScrolledWindowScrollChild obj cb = liftIO $ do
    let wrapped self = let ?self = self in cb
    let wrapped' = wrap_ScrolledWindowScrollChildCallback wrapped
    wrapped'' <- mk_ScrolledWindowScrollChildCallback wrapped'
    connectSignalFunPtr obj "scroll-child" wrapped'' SignalConnectAfter Nothing


#if defined(ENABLE_OVERLOADING)
data ScrolledWindowScrollChildSignalInfo
instance SignalInfo ScrolledWindowScrollChildSignalInfo where
    type HaskellCallbackType ScrolledWindowScrollChildSignalInfo = ScrolledWindowScrollChildCallback
    connectSignal obj cb connectMode detail = do
        let cb' = wrap_ScrolledWindowScrollChildCallback cb
        cb'' <- mk_ScrolledWindowScrollChildCallback cb'
        connectSignalFunPtr obj "scroll-child" cb'' connectMode detail
    dbgSignalInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow::scroll-child"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#g:signal:scrollChild"})

#endif

-- VVV Prop "child"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Widget"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just True,Just True)

-- | Get the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' scrolledWindow #child
-- @
getScrolledWindowChild :: (MonadIO m, IsScrolledWindow o) => o -> m (Maybe Gtk.Widget.Widget)
getScrolledWindowChild obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "child" Gtk.Widget.Widget

-- | Set the value of the “@child@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' scrolledWindow [ #child 'Data.GI.Base.Attributes.:=' value ]
-- @
setScrolledWindowChild :: (MonadIO m, IsScrolledWindow o, Gtk.Widget.IsWidget a) => o -> a -> m ()
setScrolledWindowChild obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "child" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@child@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructScrolledWindowChild :: (IsScrolledWindow o, MIO.MonadIO m, Gtk.Widget.IsWidget a) => a -> m (GValueConstruct o)
constructScrolledWindowChild val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "child" (P.Just val)

-- | Set the value of the “@child@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #child
-- @
clearScrolledWindowChild :: (MonadIO m, IsScrolledWindow o) => o -> m ()
clearScrolledWindowChild obj = liftIO $ B.Properties.setObjectPropertyObject obj "child" (Nothing :: Maybe Gtk.Widget.Widget)

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowChildPropertyInfo
instance AttrInfo ScrolledWindowChildPropertyInfo where
    type AttrAllowedOps ScrolledWindowChildPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ScrolledWindowChildPropertyInfo = IsScrolledWindow
    type AttrSetTypeConstraint ScrolledWindowChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferTypeConstraint ScrolledWindowChildPropertyInfo = Gtk.Widget.IsWidget
    type AttrTransferType ScrolledWindowChildPropertyInfo = Gtk.Widget.Widget
    type AttrGetType ScrolledWindowChildPropertyInfo = (Maybe Gtk.Widget.Widget)
    type AttrLabel ScrolledWindowChildPropertyInfo = "child"
    type AttrOrigin ScrolledWindowChildPropertyInfo = ScrolledWindow
    attrGet = getScrolledWindowChild
    attrSet = setScrolledWindowChild
    attrTransfer _ v = do
        unsafeCastTo Gtk.Widget.Widget v
    attrConstruct = constructScrolledWindowChild
    attrClear = clearScrolledWindowChild
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.child"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#g:attr:child"
        })
#endif

-- VVV Prop "hadjustment"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Adjustment"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just True)

-- | Get the value of the “@hadjustment@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' scrolledWindow #hadjustment
-- @
getScrolledWindowHadjustment :: (MonadIO m, IsScrolledWindow o) => o -> m Gtk.Adjustment.Adjustment
getScrolledWindowHadjustment obj = MIO.liftIO $ checkUnexpectedNothing "getScrolledWindowHadjustment" $ B.Properties.getObjectPropertyObject obj "hadjustment" Gtk.Adjustment.Adjustment

-- | Set the value of the “@hadjustment@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' scrolledWindow [ #hadjustment 'Data.GI.Base.Attributes.:=' value ]
-- @
setScrolledWindowHadjustment :: (MonadIO m, IsScrolledWindow o, Gtk.Adjustment.IsAdjustment a) => o -> a -> m ()
setScrolledWindowHadjustment obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "hadjustment" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@hadjustment@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructScrolledWindowHadjustment :: (IsScrolledWindow o, MIO.MonadIO m, Gtk.Adjustment.IsAdjustment a) => a -> m (GValueConstruct o)
constructScrolledWindowHadjustment val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "hadjustment" (P.Just val)

-- | Set the value of the “@hadjustment@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #hadjustment
-- @
clearScrolledWindowHadjustment :: (MonadIO m, IsScrolledWindow o) => o -> m ()
clearScrolledWindowHadjustment obj = liftIO $ B.Properties.setObjectPropertyObject obj "hadjustment" (Nothing :: Maybe Gtk.Adjustment.Adjustment)

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowHadjustmentPropertyInfo
instance AttrInfo ScrolledWindowHadjustmentPropertyInfo where
    type AttrAllowedOps ScrolledWindowHadjustmentPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ScrolledWindowHadjustmentPropertyInfo = IsScrolledWindow
    type AttrSetTypeConstraint ScrolledWindowHadjustmentPropertyInfo = Gtk.Adjustment.IsAdjustment
    type AttrTransferTypeConstraint ScrolledWindowHadjustmentPropertyInfo = Gtk.Adjustment.IsAdjustment
    type AttrTransferType ScrolledWindowHadjustmentPropertyInfo = Gtk.Adjustment.Adjustment
    type AttrGetType ScrolledWindowHadjustmentPropertyInfo = Gtk.Adjustment.Adjustment
    type AttrLabel ScrolledWindowHadjustmentPropertyInfo = "hadjustment"
    type AttrOrigin ScrolledWindowHadjustmentPropertyInfo = ScrolledWindow
    attrGet = getScrolledWindowHadjustment
    attrSet = setScrolledWindowHadjustment
    attrTransfer _ v = do
        unsafeCastTo Gtk.Adjustment.Adjustment v
    attrConstruct = constructScrolledWindowHadjustment
    attrClear = clearScrolledWindowHadjustment
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.hadjustment"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#g:attr:hadjustment"
        })
#endif

-- VVV Prop "has-frame"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@has-frame@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' scrolledWindow #hasFrame
-- @
getScrolledWindowHasFrame :: (MonadIO m, IsScrolledWindow o) => o -> m Bool
getScrolledWindowHasFrame obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "has-frame"

-- | Set the value of the “@has-frame@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' scrolledWindow [ #hasFrame 'Data.GI.Base.Attributes.:=' value ]
-- @
setScrolledWindowHasFrame :: (MonadIO m, IsScrolledWindow o) => o -> Bool -> m ()
setScrolledWindowHasFrame obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "has-frame" val

-- | Construct a t'GValueConstruct' with valid value for the “@has-frame@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructScrolledWindowHasFrame :: (IsScrolledWindow o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructScrolledWindowHasFrame val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "has-frame" val

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowHasFramePropertyInfo
instance AttrInfo ScrolledWindowHasFramePropertyInfo where
    type AttrAllowedOps ScrolledWindowHasFramePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ScrolledWindowHasFramePropertyInfo = IsScrolledWindow
    type AttrSetTypeConstraint ScrolledWindowHasFramePropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ScrolledWindowHasFramePropertyInfo = (~) Bool
    type AttrTransferType ScrolledWindowHasFramePropertyInfo = Bool
    type AttrGetType ScrolledWindowHasFramePropertyInfo = Bool
    type AttrLabel ScrolledWindowHasFramePropertyInfo = "has-frame"
    type AttrOrigin ScrolledWindowHasFramePropertyInfo = ScrolledWindow
    attrGet = getScrolledWindowHasFrame
    attrSet = setScrolledWindowHasFrame
    attrTransfer _ v = do
        return v
    attrConstruct = constructScrolledWindowHasFrame
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.hasFrame"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#g:attr:hasFrame"
        })
#endif

-- VVV Prop "hscrollbar-policy"
   -- Type: TInterface (Name {namespace = "Gtk", name = "PolicyType"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@hscrollbar-policy@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' scrolledWindow #hscrollbarPolicy
-- @
getScrolledWindowHscrollbarPolicy :: (MonadIO m, IsScrolledWindow o) => o -> m Gtk.Enums.PolicyType
getScrolledWindowHscrollbarPolicy obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "hscrollbar-policy"

-- | Set the value of the “@hscrollbar-policy@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' scrolledWindow [ #hscrollbarPolicy 'Data.GI.Base.Attributes.:=' value ]
-- @
setScrolledWindowHscrollbarPolicy :: (MonadIO m, IsScrolledWindow o) => o -> Gtk.Enums.PolicyType -> m ()
setScrolledWindowHscrollbarPolicy obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "hscrollbar-policy" val

-- | Construct a t'GValueConstruct' with valid value for the “@hscrollbar-policy@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructScrolledWindowHscrollbarPolicy :: (IsScrolledWindow o, MIO.MonadIO m) => Gtk.Enums.PolicyType -> m (GValueConstruct o)
constructScrolledWindowHscrollbarPolicy val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "hscrollbar-policy" val

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowHscrollbarPolicyPropertyInfo
instance AttrInfo ScrolledWindowHscrollbarPolicyPropertyInfo where
    type AttrAllowedOps ScrolledWindowHscrollbarPolicyPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ScrolledWindowHscrollbarPolicyPropertyInfo = IsScrolledWindow
    type AttrSetTypeConstraint ScrolledWindowHscrollbarPolicyPropertyInfo = (~) Gtk.Enums.PolicyType
    type AttrTransferTypeConstraint ScrolledWindowHscrollbarPolicyPropertyInfo = (~) Gtk.Enums.PolicyType
    type AttrTransferType ScrolledWindowHscrollbarPolicyPropertyInfo = Gtk.Enums.PolicyType
    type AttrGetType ScrolledWindowHscrollbarPolicyPropertyInfo = Gtk.Enums.PolicyType
    type AttrLabel ScrolledWindowHscrollbarPolicyPropertyInfo = "hscrollbar-policy"
    type AttrOrigin ScrolledWindowHscrollbarPolicyPropertyInfo = ScrolledWindow
    attrGet = getScrolledWindowHscrollbarPolicy
    attrSet = setScrolledWindowHscrollbarPolicy
    attrTransfer _ v = do
        return v
    attrConstruct = constructScrolledWindowHscrollbarPolicy
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.hscrollbarPolicy"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#g:attr:hscrollbarPolicy"
        })
#endif

-- VVV Prop "kinetic-scrolling"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@kinetic-scrolling@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' scrolledWindow #kineticScrolling
-- @
getScrolledWindowKineticScrolling :: (MonadIO m, IsScrolledWindow o) => o -> m Bool
getScrolledWindowKineticScrolling obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "kinetic-scrolling"

-- | Set the value of the “@kinetic-scrolling@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' scrolledWindow [ #kineticScrolling 'Data.GI.Base.Attributes.:=' value ]
-- @
setScrolledWindowKineticScrolling :: (MonadIO m, IsScrolledWindow o) => o -> Bool -> m ()
setScrolledWindowKineticScrolling obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "kinetic-scrolling" val

-- | Construct a t'GValueConstruct' with valid value for the “@kinetic-scrolling@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructScrolledWindowKineticScrolling :: (IsScrolledWindow o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructScrolledWindowKineticScrolling val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "kinetic-scrolling" val

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowKineticScrollingPropertyInfo
instance AttrInfo ScrolledWindowKineticScrollingPropertyInfo where
    type AttrAllowedOps ScrolledWindowKineticScrollingPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ScrolledWindowKineticScrollingPropertyInfo = IsScrolledWindow
    type AttrSetTypeConstraint ScrolledWindowKineticScrollingPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ScrolledWindowKineticScrollingPropertyInfo = (~) Bool
    type AttrTransferType ScrolledWindowKineticScrollingPropertyInfo = Bool
    type AttrGetType ScrolledWindowKineticScrollingPropertyInfo = Bool
    type AttrLabel ScrolledWindowKineticScrollingPropertyInfo = "kinetic-scrolling"
    type AttrOrigin ScrolledWindowKineticScrollingPropertyInfo = ScrolledWindow
    attrGet = getScrolledWindowKineticScrolling
    attrSet = setScrolledWindowKineticScrolling
    attrTransfer _ v = do
        return v
    attrConstruct = constructScrolledWindowKineticScrolling
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.kineticScrolling"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#g:attr:kineticScrolling"
        })
#endif

-- VVV Prop "max-content-height"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@max-content-height@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' scrolledWindow #maxContentHeight
-- @
getScrolledWindowMaxContentHeight :: (MonadIO m, IsScrolledWindow o) => o -> m Int32
getScrolledWindowMaxContentHeight obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "max-content-height"

-- | Set the value of the “@max-content-height@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' scrolledWindow [ #maxContentHeight 'Data.GI.Base.Attributes.:=' value ]
-- @
setScrolledWindowMaxContentHeight :: (MonadIO m, IsScrolledWindow o) => o -> Int32 -> m ()
setScrolledWindowMaxContentHeight obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "max-content-height" val

-- | Construct a t'GValueConstruct' with valid value for the “@max-content-height@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructScrolledWindowMaxContentHeight :: (IsScrolledWindow o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructScrolledWindowMaxContentHeight val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "max-content-height" val

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowMaxContentHeightPropertyInfo
instance AttrInfo ScrolledWindowMaxContentHeightPropertyInfo where
    type AttrAllowedOps ScrolledWindowMaxContentHeightPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ScrolledWindowMaxContentHeightPropertyInfo = IsScrolledWindow
    type AttrSetTypeConstraint ScrolledWindowMaxContentHeightPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint ScrolledWindowMaxContentHeightPropertyInfo = (~) Int32
    type AttrTransferType ScrolledWindowMaxContentHeightPropertyInfo = Int32
    type AttrGetType ScrolledWindowMaxContentHeightPropertyInfo = Int32
    type AttrLabel ScrolledWindowMaxContentHeightPropertyInfo = "max-content-height"
    type AttrOrigin ScrolledWindowMaxContentHeightPropertyInfo = ScrolledWindow
    attrGet = getScrolledWindowMaxContentHeight
    attrSet = setScrolledWindowMaxContentHeight
    attrTransfer _ v = do
        return v
    attrConstruct = constructScrolledWindowMaxContentHeight
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.maxContentHeight"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#g:attr:maxContentHeight"
        })
#endif

-- VVV Prop "max-content-width"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@max-content-width@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' scrolledWindow #maxContentWidth
-- @
getScrolledWindowMaxContentWidth :: (MonadIO m, IsScrolledWindow o) => o -> m Int32
getScrolledWindowMaxContentWidth obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "max-content-width"

-- | Set the value of the “@max-content-width@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' scrolledWindow [ #maxContentWidth 'Data.GI.Base.Attributes.:=' value ]
-- @
setScrolledWindowMaxContentWidth :: (MonadIO m, IsScrolledWindow o) => o -> Int32 -> m ()
setScrolledWindowMaxContentWidth obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "max-content-width" val

-- | Construct a t'GValueConstruct' with valid value for the “@max-content-width@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructScrolledWindowMaxContentWidth :: (IsScrolledWindow o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructScrolledWindowMaxContentWidth val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "max-content-width" val

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowMaxContentWidthPropertyInfo
instance AttrInfo ScrolledWindowMaxContentWidthPropertyInfo where
    type AttrAllowedOps ScrolledWindowMaxContentWidthPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ScrolledWindowMaxContentWidthPropertyInfo = IsScrolledWindow
    type AttrSetTypeConstraint ScrolledWindowMaxContentWidthPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint ScrolledWindowMaxContentWidthPropertyInfo = (~) Int32
    type AttrTransferType ScrolledWindowMaxContentWidthPropertyInfo = Int32
    type AttrGetType ScrolledWindowMaxContentWidthPropertyInfo = Int32
    type AttrLabel ScrolledWindowMaxContentWidthPropertyInfo = "max-content-width"
    type AttrOrigin ScrolledWindowMaxContentWidthPropertyInfo = ScrolledWindow
    attrGet = getScrolledWindowMaxContentWidth
    attrSet = setScrolledWindowMaxContentWidth
    attrTransfer _ v = do
        return v
    attrConstruct = constructScrolledWindowMaxContentWidth
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.maxContentWidth"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#g:attr:maxContentWidth"
        })
#endif

-- VVV Prop "min-content-height"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@min-content-height@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' scrolledWindow #minContentHeight
-- @
getScrolledWindowMinContentHeight :: (MonadIO m, IsScrolledWindow o) => o -> m Int32
getScrolledWindowMinContentHeight obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "min-content-height"

-- | Set the value of the “@min-content-height@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' scrolledWindow [ #minContentHeight 'Data.GI.Base.Attributes.:=' value ]
-- @
setScrolledWindowMinContentHeight :: (MonadIO m, IsScrolledWindow o) => o -> Int32 -> m ()
setScrolledWindowMinContentHeight obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "min-content-height" val

-- | Construct a t'GValueConstruct' with valid value for the “@min-content-height@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructScrolledWindowMinContentHeight :: (IsScrolledWindow o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructScrolledWindowMinContentHeight val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "min-content-height" val

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowMinContentHeightPropertyInfo
instance AttrInfo ScrolledWindowMinContentHeightPropertyInfo where
    type AttrAllowedOps ScrolledWindowMinContentHeightPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ScrolledWindowMinContentHeightPropertyInfo = IsScrolledWindow
    type AttrSetTypeConstraint ScrolledWindowMinContentHeightPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint ScrolledWindowMinContentHeightPropertyInfo = (~) Int32
    type AttrTransferType ScrolledWindowMinContentHeightPropertyInfo = Int32
    type AttrGetType ScrolledWindowMinContentHeightPropertyInfo = Int32
    type AttrLabel ScrolledWindowMinContentHeightPropertyInfo = "min-content-height"
    type AttrOrigin ScrolledWindowMinContentHeightPropertyInfo = ScrolledWindow
    attrGet = getScrolledWindowMinContentHeight
    attrSet = setScrolledWindowMinContentHeight
    attrTransfer _ v = do
        return v
    attrConstruct = constructScrolledWindowMinContentHeight
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.minContentHeight"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#g:attr:minContentHeight"
        })
#endif

-- VVV Prop "min-content-width"
   -- Type: TBasicType TInt
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@min-content-width@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' scrolledWindow #minContentWidth
-- @
getScrolledWindowMinContentWidth :: (MonadIO m, IsScrolledWindow o) => o -> m Int32
getScrolledWindowMinContentWidth obj = MIO.liftIO $ B.Properties.getObjectPropertyInt32 obj "min-content-width"

-- | Set the value of the “@min-content-width@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' scrolledWindow [ #minContentWidth 'Data.GI.Base.Attributes.:=' value ]
-- @
setScrolledWindowMinContentWidth :: (MonadIO m, IsScrolledWindow o) => o -> Int32 -> m ()
setScrolledWindowMinContentWidth obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyInt32 obj "min-content-width" val

-- | Construct a t'GValueConstruct' with valid value for the “@min-content-width@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructScrolledWindowMinContentWidth :: (IsScrolledWindow o, MIO.MonadIO m) => Int32 -> m (GValueConstruct o)
constructScrolledWindowMinContentWidth val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyInt32 "min-content-width" val

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowMinContentWidthPropertyInfo
instance AttrInfo ScrolledWindowMinContentWidthPropertyInfo where
    type AttrAllowedOps ScrolledWindowMinContentWidthPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ScrolledWindowMinContentWidthPropertyInfo = IsScrolledWindow
    type AttrSetTypeConstraint ScrolledWindowMinContentWidthPropertyInfo = (~) Int32
    type AttrTransferTypeConstraint ScrolledWindowMinContentWidthPropertyInfo = (~) Int32
    type AttrTransferType ScrolledWindowMinContentWidthPropertyInfo = Int32
    type AttrGetType ScrolledWindowMinContentWidthPropertyInfo = Int32
    type AttrLabel ScrolledWindowMinContentWidthPropertyInfo = "min-content-width"
    type AttrOrigin ScrolledWindowMinContentWidthPropertyInfo = ScrolledWindow
    attrGet = getScrolledWindowMinContentWidth
    attrSet = setScrolledWindowMinContentWidth
    attrTransfer _ v = do
        return v
    attrConstruct = constructScrolledWindowMinContentWidth
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.minContentWidth"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#g:attr:minContentWidth"
        })
#endif

-- VVV Prop "overlay-scrolling"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@overlay-scrolling@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' scrolledWindow #overlayScrolling
-- @
getScrolledWindowOverlayScrolling :: (MonadIO m, IsScrolledWindow o) => o -> m Bool
getScrolledWindowOverlayScrolling obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "overlay-scrolling"

-- | Set the value of the “@overlay-scrolling@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' scrolledWindow [ #overlayScrolling 'Data.GI.Base.Attributes.:=' value ]
-- @
setScrolledWindowOverlayScrolling :: (MonadIO m, IsScrolledWindow o) => o -> Bool -> m ()
setScrolledWindowOverlayScrolling obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "overlay-scrolling" val

-- | Construct a t'GValueConstruct' with valid value for the “@overlay-scrolling@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructScrolledWindowOverlayScrolling :: (IsScrolledWindow o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructScrolledWindowOverlayScrolling val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "overlay-scrolling" val

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowOverlayScrollingPropertyInfo
instance AttrInfo ScrolledWindowOverlayScrollingPropertyInfo where
    type AttrAllowedOps ScrolledWindowOverlayScrollingPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ScrolledWindowOverlayScrollingPropertyInfo = IsScrolledWindow
    type AttrSetTypeConstraint ScrolledWindowOverlayScrollingPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ScrolledWindowOverlayScrollingPropertyInfo = (~) Bool
    type AttrTransferType ScrolledWindowOverlayScrollingPropertyInfo = Bool
    type AttrGetType ScrolledWindowOverlayScrollingPropertyInfo = Bool
    type AttrLabel ScrolledWindowOverlayScrollingPropertyInfo = "overlay-scrolling"
    type AttrOrigin ScrolledWindowOverlayScrollingPropertyInfo = ScrolledWindow
    attrGet = getScrolledWindowOverlayScrolling
    attrSet = setScrolledWindowOverlayScrolling
    attrTransfer _ v = do
        return v
    attrConstruct = constructScrolledWindowOverlayScrolling
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.overlayScrolling"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#g:attr:overlayScrolling"
        })
#endif

-- VVV Prop "propagate-natural-height"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@propagate-natural-height@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' scrolledWindow #propagateNaturalHeight
-- @
getScrolledWindowPropagateNaturalHeight :: (MonadIO m, IsScrolledWindow o) => o -> m Bool
getScrolledWindowPropagateNaturalHeight obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "propagate-natural-height"

-- | Set the value of the “@propagate-natural-height@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' scrolledWindow [ #propagateNaturalHeight 'Data.GI.Base.Attributes.:=' value ]
-- @
setScrolledWindowPropagateNaturalHeight :: (MonadIO m, IsScrolledWindow o) => o -> Bool -> m ()
setScrolledWindowPropagateNaturalHeight obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "propagate-natural-height" val

-- | Construct a t'GValueConstruct' with valid value for the “@propagate-natural-height@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructScrolledWindowPropagateNaturalHeight :: (IsScrolledWindow o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructScrolledWindowPropagateNaturalHeight val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "propagate-natural-height" val

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowPropagateNaturalHeightPropertyInfo
instance AttrInfo ScrolledWindowPropagateNaturalHeightPropertyInfo where
    type AttrAllowedOps ScrolledWindowPropagateNaturalHeightPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ScrolledWindowPropagateNaturalHeightPropertyInfo = IsScrolledWindow
    type AttrSetTypeConstraint ScrolledWindowPropagateNaturalHeightPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ScrolledWindowPropagateNaturalHeightPropertyInfo = (~) Bool
    type AttrTransferType ScrolledWindowPropagateNaturalHeightPropertyInfo = Bool
    type AttrGetType ScrolledWindowPropagateNaturalHeightPropertyInfo = Bool
    type AttrLabel ScrolledWindowPropagateNaturalHeightPropertyInfo = "propagate-natural-height"
    type AttrOrigin ScrolledWindowPropagateNaturalHeightPropertyInfo = ScrolledWindow
    attrGet = getScrolledWindowPropagateNaturalHeight
    attrSet = setScrolledWindowPropagateNaturalHeight
    attrTransfer _ v = do
        return v
    attrConstruct = constructScrolledWindowPropagateNaturalHeight
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.propagateNaturalHeight"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#g:attr:propagateNaturalHeight"
        })
#endif

-- VVV Prop "propagate-natural-width"
   -- Type: TBasicType TBoolean
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@propagate-natural-width@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' scrolledWindow #propagateNaturalWidth
-- @
getScrolledWindowPropagateNaturalWidth :: (MonadIO m, IsScrolledWindow o) => o -> m Bool
getScrolledWindowPropagateNaturalWidth obj = MIO.liftIO $ B.Properties.getObjectPropertyBool obj "propagate-natural-width"

-- | Set the value of the “@propagate-natural-width@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' scrolledWindow [ #propagateNaturalWidth 'Data.GI.Base.Attributes.:=' value ]
-- @
setScrolledWindowPropagateNaturalWidth :: (MonadIO m, IsScrolledWindow o) => o -> Bool -> m ()
setScrolledWindowPropagateNaturalWidth obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyBool obj "propagate-natural-width" val

-- | Construct a t'GValueConstruct' with valid value for the “@propagate-natural-width@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructScrolledWindowPropagateNaturalWidth :: (IsScrolledWindow o, MIO.MonadIO m) => Bool -> m (GValueConstruct o)
constructScrolledWindowPropagateNaturalWidth val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBool "propagate-natural-width" val

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowPropagateNaturalWidthPropertyInfo
instance AttrInfo ScrolledWindowPropagateNaturalWidthPropertyInfo where
    type AttrAllowedOps ScrolledWindowPropagateNaturalWidthPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ScrolledWindowPropagateNaturalWidthPropertyInfo = IsScrolledWindow
    type AttrSetTypeConstraint ScrolledWindowPropagateNaturalWidthPropertyInfo = (~) Bool
    type AttrTransferTypeConstraint ScrolledWindowPropagateNaturalWidthPropertyInfo = (~) Bool
    type AttrTransferType ScrolledWindowPropagateNaturalWidthPropertyInfo = Bool
    type AttrGetType ScrolledWindowPropagateNaturalWidthPropertyInfo = Bool
    type AttrLabel ScrolledWindowPropagateNaturalWidthPropertyInfo = "propagate-natural-width"
    type AttrOrigin ScrolledWindowPropagateNaturalWidthPropertyInfo = ScrolledWindow
    attrGet = getScrolledWindowPropagateNaturalWidth
    attrSet = setScrolledWindowPropagateNaturalWidth
    attrTransfer _ v = do
        return v
    attrConstruct = constructScrolledWindowPropagateNaturalWidth
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.propagateNaturalWidth"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#g:attr:propagateNaturalWidth"
        })
#endif

-- VVV Prop "vadjustment"
   -- Type: TInterface (Name {namespace = "Gtk", name = "Adjustment"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstruct]
   -- Nullable: (Just False,Just True)

-- | Get the value of the “@vadjustment@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' scrolledWindow #vadjustment
-- @
getScrolledWindowVadjustment :: (MonadIO m, IsScrolledWindow o) => o -> m Gtk.Adjustment.Adjustment
getScrolledWindowVadjustment obj = MIO.liftIO $ checkUnexpectedNothing "getScrolledWindowVadjustment" $ B.Properties.getObjectPropertyObject obj "vadjustment" Gtk.Adjustment.Adjustment

-- | Set the value of the “@vadjustment@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' scrolledWindow [ #vadjustment 'Data.GI.Base.Attributes.:=' value ]
-- @
setScrolledWindowVadjustment :: (MonadIO m, IsScrolledWindow o, Gtk.Adjustment.IsAdjustment a) => o -> a -> m ()
setScrolledWindowVadjustment obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "vadjustment" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@vadjustment@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructScrolledWindowVadjustment :: (IsScrolledWindow o, MIO.MonadIO m, Gtk.Adjustment.IsAdjustment a) => a -> m (GValueConstruct o)
constructScrolledWindowVadjustment val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "vadjustment" (P.Just val)

-- | Set the value of the “@vadjustment@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #vadjustment
-- @
clearScrolledWindowVadjustment :: (MonadIO m, IsScrolledWindow o) => o -> m ()
clearScrolledWindowVadjustment obj = liftIO $ B.Properties.setObjectPropertyObject obj "vadjustment" (Nothing :: Maybe Gtk.Adjustment.Adjustment)

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowVadjustmentPropertyInfo
instance AttrInfo ScrolledWindowVadjustmentPropertyInfo where
    type AttrAllowedOps ScrolledWindowVadjustmentPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint ScrolledWindowVadjustmentPropertyInfo = IsScrolledWindow
    type AttrSetTypeConstraint ScrolledWindowVadjustmentPropertyInfo = Gtk.Adjustment.IsAdjustment
    type AttrTransferTypeConstraint ScrolledWindowVadjustmentPropertyInfo = Gtk.Adjustment.IsAdjustment
    type AttrTransferType ScrolledWindowVadjustmentPropertyInfo = Gtk.Adjustment.Adjustment
    type AttrGetType ScrolledWindowVadjustmentPropertyInfo = Gtk.Adjustment.Adjustment
    type AttrLabel ScrolledWindowVadjustmentPropertyInfo = "vadjustment"
    type AttrOrigin ScrolledWindowVadjustmentPropertyInfo = ScrolledWindow
    attrGet = getScrolledWindowVadjustment
    attrSet = setScrolledWindowVadjustment
    attrTransfer _ v = do
        unsafeCastTo Gtk.Adjustment.Adjustment v
    attrConstruct = constructScrolledWindowVadjustment
    attrClear = clearScrolledWindowVadjustment
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.vadjustment"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#g:attr:vadjustment"
        })
#endif

-- VVV Prop "vscrollbar-policy"
   -- Type: TInterface (Name {namespace = "Gtk", name = "PolicyType"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@vscrollbar-policy@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' scrolledWindow #vscrollbarPolicy
-- @
getScrolledWindowVscrollbarPolicy :: (MonadIO m, IsScrolledWindow o) => o -> m Gtk.Enums.PolicyType
getScrolledWindowVscrollbarPolicy obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "vscrollbar-policy"

-- | Set the value of the “@vscrollbar-policy@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' scrolledWindow [ #vscrollbarPolicy 'Data.GI.Base.Attributes.:=' value ]
-- @
setScrolledWindowVscrollbarPolicy :: (MonadIO m, IsScrolledWindow o) => o -> Gtk.Enums.PolicyType -> m ()
setScrolledWindowVscrollbarPolicy obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "vscrollbar-policy" val

-- | Construct a t'GValueConstruct' with valid value for the “@vscrollbar-policy@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructScrolledWindowVscrollbarPolicy :: (IsScrolledWindow o, MIO.MonadIO m) => Gtk.Enums.PolicyType -> m (GValueConstruct o)
constructScrolledWindowVscrollbarPolicy val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "vscrollbar-policy" val

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowVscrollbarPolicyPropertyInfo
instance AttrInfo ScrolledWindowVscrollbarPolicyPropertyInfo where
    type AttrAllowedOps ScrolledWindowVscrollbarPolicyPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ScrolledWindowVscrollbarPolicyPropertyInfo = IsScrolledWindow
    type AttrSetTypeConstraint ScrolledWindowVscrollbarPolicyPropertyInfo = (~) Gtk.Enums.PolicyType
    type AttrTransferTypeConstraint ScrolledWindowVscrollbarPolicyPropertyInfo = (~) Gtk.Enums.PolicyType
    type AttrTransferType ScrolledWindowVscrollbarPolicyPropertyInfo = Gtk.Enums.PolicyType
    type AttrGetType ScrolledWindowVscrollbarPolicyPropertyInfo = Gtk.Enums.PolicyType
    type AttrLabel ScrolledWindowVscrollbarPolicyPropertyInfo = "vscrollbar-policy"
    type AttrOrigin ScrolledWindowVscrollbarPolicyPropertyInfo = ScrolledWindow
    attrGet = getScrolledWindowVscrollbarPolicy
    attrSet = setScrolledWindowVscrollbarPolicy
    attrTransfer _ v = do
        return v
    attrConstruct = constructScrolledWindowVscrollbarPolicy
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.vscrollbarPolicy"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#g:attr:vscrollbarPolicy"
        })
#endif

-- VVV Prop "window-placement"
   -- Type: TInterface (Name {namespace = "Gtk", name = "CornerType"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Just False,Just False)

-- | Get the value of the “@window-placement@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' scrolledWindow #windowPlacement
-- @
getScrolledWindowWindowPlacement :: (MonadIO m, IsScrolledWindow o) => o -> m Gtk.Enums.CornerType
getScrolledWindowWindowPlacement obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "window-placement"

-- | Set the value of the “@window-placement@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' scrolledWindow [ #windowPlacement 'Data.GI.Base.Attributes.:=' value ]
-- @
setScrolledWindowWindowPlacement :: (MonadIO m, IsScrolledWindow o) => o -> Gtk.Enums.CornerType -> m ()
setScrolledWindowWindowPlacement obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "window-placement" val

-- | Construct a t'GValueConstruct' with valid value for the “@window-placement@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructScrolledWindowWindowPlacement :: (IsScrolledWindow o, MIO.MonadIO m) => Gtk.Enums.CornerType -> m (GValueConstruct o)
constructScrolledWindowWindowPlacement val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "window-placement" val

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowWindowPlacementPropertyInfo
instance AttrInfo ScrolledWindowWindowPlacementPropertyInfo where
    type AttrAllowedOps ScrolledWindowWindowPlacementPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint ScrolledWindowWindowPlacementPropertyInfo = IsScrolledWindow
    type AttrSetTypeConstraint ScrolledWindowWindowPlacementPropertyInfo = (~) Gtk.Enums.CornerType
    type AttrTransferTypeConstraint ScrolledWindowWindowPlacementPropertyInfo = (~) Gtk.Enums.CornerType
    type AttrTransferType ScrolledWindowWindowPlacementPropertyInfo = Gtk.Enums.CornerType
    type AttrGetType ScrolledWindowWindowPlacementPropertyInfo = Gtk.Enums.CornerType
    type AttrLabel ScrolledWindowWindowPlacementPropertyInfo = "window-placement"
    type AttrOrigin ScrolledWindowWindowPlacementPropertyInfo = ScrolledWindow
    attrGet = getScrolledWindowWindowPlacement
    attrSet = setScrolledWindowWindowPlacement
    attrTransfer _ v = do
        return v
    attrConstruct = constructScrolledWindowWindowPlacement
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.windowPlacement"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#g:attr:windowPlacement"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ScrolledWindow
type instance O.AttributeList ScrolledWindow = ScrolledWindowAttributeList
type ScrolledWindowAttributeList = ('[ '("accessibleRole", Gtk.Accessible.AccessibleAccessibleRolePropertyInfo), '("canFocus", Gtk.Widget.WidgetCanFocusPropertyInfo), '("canTarget", Gtk.Widget.WidgetCanTargetPropertyInfo), '("child", ScrolledWindowChildPropertyInfo), '("cssClasses", Gtk.Widget.WidgetCssClassesPropertyInfo), '("cssName", Gtk.Widget.WidgetCssNamePropertyInfo), '("cursor", Gtk.Widget.WidgetCursorPropertyInfo), '("focusOnClick", Gtk.Widget.WidgetFocusOnClickPropertyInfo), '("focusable", Gtk.Widget.WidgetFocusablePropertyInfo), '("hadjustment", ScrolledWindowHadjustmentPropertyInfo), '("halign", Gtk.Widget.WidgetHalignPropertyInfo), '("hasDefault", Gtk.Widget.WidgetHasDefaultPropertyInfo), '("hasFocus", Gtk.Widget.WidgetHasFocusPropertyInfo), '("hasFrame", ScrolledWindowHasFramePropertyInfo), '("hasTooltip", Gtk.Widget.WidgetHasTooltipPropertyInfo), '("heightRequest", Gtk.Widget.WidgetHeightRequestPropertyInfo), '("hexpand", Gtk.Widget.WidgetHexpandPropertyInfo), '("hexpandSet", Gtk.Widget.WidgetHexpandSetPropertyInfo), '("hscrollbarPolicy", ScrolledWindowHscrollbarPolicyPropertyInfo), '("kineticScrolling", ScrolledWindowKineticScrollingPropertyInfo), '("layoutManager", Gtk.Widget.WidgetLayoutManagerPropertyInfo), '("limitEvents", Gtk.Widget.WidgetLimitEventsPropertyInfo), '("marginBottom", Gtk.Widget.WidgetMarginBottomPropertyInfo), '("marginEnd", Gtk.Widget.WidgetMarginEndPropertyInfo), '("marginStart", Gtk.Widget.WidgetMarginStartPropertyInfo), '("marginTop", Gtk.Widget.WidgetMarginTopPropertyInfo), '("maxContentHeight", ScrolledWindowMaxContentHeightPropertyInfo), '("maxContentWidth", ScrolledWindowMaxContentWidthPropertyInfo), '("minContentHeight", ScrolledWindowMinContentHeightPropertyInfo), '("minContentWidth", ScrolledWindowMinContentWidthPropertyInfo), '("name", Gtk.Widget.WidgetNamePropertyInfo), '("opacity", Gtk.Widget.WidgetOpacityPropertyInfo), '("overflow", Gtk.Widget.WidgetOverflowPropertyInfo), '("overlayScrolling", ScrolledWindowOverlayScrollingPropertyInfo), '("parent", Gtk.Widget.WidgetParentPropertyInfo), '("propagateNaturalHeight", ScrolledWindowPropagateNaturalHeightPropertyInfo), '("propagateNaturalWidth", ScrolledWindowPropagateNaturalWidthPropertyInfo), '("receivesDefault", Gtk.Widget.WidgetReceivesDefaultPropertyInfo), '("root", Gtk.Widget.WidgetRootPropertyInfo), '("scaleFactor", Gtk.Widget.WidgetScaleFactorPropertyInfo), '("sensitive", Gtk.Widget.WidgetSensitivePropertyInfo), '("tooltipMarkup", Gtk.Widget.WidgetTooltipMarkupPropertyInfo), '("tooltipText", Gtk.Widget.WidgetTooltipTextPropertyInfo), '("vadjustment", ScrolledWindowVadjustmentPropertyInfo), '("valign", Gtk.Widget.WidgetValignPropertyInfo), '("vexpand", Gtk.Widget.WidgetVexpandPropertyInfo), '("vexpandSet", Gtk.Widget.WidgetVexpandSetPropertyInfo), '("visible", Gtk.Widget.WidgetVisiblePropertyInfo), '("vscrollbarPolicy", ScrolledWindowVscrollbarPolicyPropertyInfo), '("widthRequest", Gtk.Widget.WidgetWidthRequestPropertyInfo), '("windowPlacement", ScrolledWindowWindowPlacementPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
scrolledWindowChild :: AttrLabelProxy "child"
scrolledWindowChild = AttrLabelProxy

scrolledWindowHadjustment :: AttrLabelProxy "hadjustment"
scrolledWindowHadjustment = AttrLabelProxy

scrolledWindowHasFrame :: AttrLabelProxy "hasFrame"
scrolledWindowHasFrame = AttrLabelProxy

scrolledWindowHscrollbarPolicy :: AttrLabelProxy "hscrollbarPolicy"
scrolledWindowHscrollbarPolicy = AttrLabelProxy

scrolledWindowKineticScrolling :: AttrLabelProxy "kineticScrolling"
scrolledWindowKineticScrolling = AttrLabelProxy

scrolledWindowMaxContentHeight :: AttrLabelProxy "maxContentHeight"
scrolledWindowMaxContentHeight = AttrLabelProxy

scrolledWindowMaxContentWidth :: AttrLabelProxy "maxContentWidth"
scrolledWindowMaxContentWidth = AttrLabelProxy

scrolledWindowMinContentHeight :: AttrLabelProxy "minContentHeight"
scrolledWindowMinContentHeight = AttrLabelProxy

scrolledWindowMinContentWidth :: AttrLabelProxy "minContentWidth"
scrolledWindowMinContentWidth = AttrLabelProxy

scrolledWindowOverlayScrolling :: AttrLabelProxy "overlayScrolling"
scrolledWindowOverlayScrolling = AttrLabelProxy

scrolledWindowPropagateNaturalHeight :: AttrLabelProxy "propagateNaturalHeight"
scrolledWindowPropagateNaturalHeight = AttrLabelProxy

scrolledWindowPropagateNaturalWidth :: AttrLabelProxy "propagateNaturalWidth"
scrolledWindowPropagateNaturalWidth = AttrLabelProxy

scrolledWindowVadjustment :: AttrLabelProxy "vadjustment"
scrolledWindowVadjustment = AttrLabelProxy

scrolledWindowVscrollbarPolicy :: AttrLabelProxy "vscrollbarPolicy"
scrolledWindowVscrollbarPolicy = AttrLabelProxy

scrolledWindowWindowPlacement :: AttrLabelProxy "windowPlacement"
scrolledWindowWindowPlacement = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList ScrolledWindow = ScrolledWindowSignalList
type ScrolledWindowSignalList = ('[ '("destroy", Gtk.Widget.WidgetDestroySignalInfo), '("directionChanged", Gtk.Widget.WidgetDirectionChangedSignalInfo), '("edgeOvershot", ScrolledWindowEdgeOvershotSignalInfo), '("edgeReached", ScrolledWindowEdgeReachedSignalInfo), '("hide", Gtk.Widget.WidgetHideSignalInfo), '("keynavFailed", Gtk.Widget.WidgetKeynavFailedSignalInfo), '("map", Gtk.Widget.WidgetMapSignalInfo), '("mnemonicActivate", Gtk.Widget.WidgetMnemonicActivateSignalInfo), '("moveFocus", Gtk.Widget.WidgetMoveFocusSignalInfo), '("moveFocusOut", ScrolledWindowMoveFocusOutSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo), '("queryTooltip", Gtk.Widget.WidgetQueryTooltipSignalInfo), '("realize", Gtk.Widget.WidgetRealizeSignalInfo), '("scrollChild", ScrolledWindowScrollChildSignalInfo), '("show", Gtk.Widget.WidgetShowSignalInfo), '("stateFlagsChanged", Gtk.Widget.WidgetStateFlagsChangedSignalInfo), '("unmap", Gtk.Widget.WidgetUnmapSignalInfo), '("unrealize", Gtk.Widget.WidgetUnrealizeSignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method ScrolledWindow::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gtk" , name = "ScrolledWindow" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scrolled_window_new" gtk_scrolled_window_new :: 
    IO (Ptr ScrolledWindow)

-- | Creates a new scrolled window.
scrolledWindowNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ScrolledWindow
    -- ^ __Returns:__ a new scrolled window
scrolledWindowNew  = liftIO $ do
    result <- gtk_scrolled_window_new
    checkUnexpectedReturnNULL "scrolledWindowNew" result
    result' <- (newObject ScrolledWindow) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ScrolledWindow::get_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scrolled_window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrolledWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrolledWindow`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scrolled_window_get_child" gtk_scrolled_window_get_child :: 
    Ptr ScrolledWindow ->                   -- scrolled_window : TInterface (Name {namespace = "Gtk", name = "ScrolledWindow"})
    IO (Ptr Gtk.Widget.Widget)

-- | Gets the child widget of /@scrolledWindow@/.
-- 
-- If the scrolled window automatically added a t'GI.Gtk.Objects.Viewport.Viewport', this
-- function will return the viewport widget, and you can retrieve its child
-- using 'GI.Gtk.Objects.Viewport.viewportGetChild'.
scrolledWindowGetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrolledWindow a) =>
    a
    -- ^ /@scrolledWindow@/: a @GtkScrolledWindow@
    -> m (Maybe Gtk.Widget.Widget)
    -- ^ __Returns:__ the child widget of /@scrolledWindow@/
scrolledWindowGetChild scrolledWindow = liftIO $ do
    scrolledWindow' <- unsafeManagedPtrCastPtr scrolledWindow
    result <- gtk_scrolled_window_get_child scrolledWindow'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gtk.Widget.Widget) result'
        return result''
    touchManagedPtr scrolledWindow
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowGetChildMethodInfo
instance (signature ~ (m (Maybe Gtk.Widget.Widget)), MonadIO m, IsScrolledWindow a) => O.OverloadedMethod ScrolledWindowGetChildMethodInfo a signature where
    overloadedMethod = scrolledWindowGetChild

instance O.OverloadedMethodInfo ScrolledWindowGetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.scrolledWindowGetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#v:scrolledWindowGetChild"
        })


#endif

-- method ScrolledWindow::get_hadjustment
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scrolled_window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrolledWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrolledWindow`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Adjustment" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scrolled_window_get_hadjustment" gtk_scrolled_window_get_hadjustment :: 
    Ptr ScrolledWindow ->                   -- scrolled_window : TInterface (Name {namespace = "Gtk", name = "ScrolledWindow"})
    IO (Ptr Gtk.Adjustment.Adjustment)

-- | Returns the horizontal scrollbar’s adjustment.
-- 
-- This is the adjustment used to connect the horizontal scrollbar
-- to the child widget’s horizontal scroll functionality.
scrolledWindowGetHadjustment ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrolledWindow a) =>
    a
    -- ^ /@scrolledWindow@/: a @GtkScrolledWindow@
    -> m Gtk.Adjustment.Adjustment
    -- ^ __Returns:__ the horizontal @GtkAdjustment@
scrolledWindowGetHadjustment scrolledWindow = liftIO $ do
    scrolledWindow' <- unsafeManagedPtrCastPtr scrolledWindow
    result <- gtk_scrolled_window_get_hadjustment scrolledWindow'
    checkUnexpectedReturnNULL "scrolledWindowGetHadjustment" result
    result' <- (newObject Gtk.Adjustment.Adjustment) result
    touchManagedPtr scrolledWindow
    return result'

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowGetHadjustmentMethodInfo
instance (signature ~ (m Gtk.Adjustment.Adjustment), MonadIO m, IsScrolledWindow a) => O.OverloadedMethod ScrolledWindowGetHadjustmentMethodInfo a signature where
    overloadedMethod = scrolledWindowGetHadjustment

instance O.OverloadedMethodInfo ScrolledWindowGetHadjustmentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.scrolledWindowGetHadjustment",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#v:scrolledWindowGetHadjustment"
        })


#endif

-- method ScrolledWindow::get_has_frame
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scrolled_window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrolledWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrolledWindow`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scrolled_window_get_has_frame" gtk_scrolled_window_get_has_frame :: 
    Ptr ScrolledWindow ->                   -- scrolled_window : TInterface (Name {namespace = "Gtk", name = "ScrolledWindow"})
    IO CInt

-- | Gets whether the scrolled window draws a frame.
scrolledWindowGetHasFrame ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrolledWindow a) =>
    a
    -- ^ /@scrolledWindow@/: a @GtkScrolledWindow@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the /@scrolledWindow@/ has a frame
scrolledWindowGetHasFrame scrolledWindow = liftIO $ do
    scrolledWindow' <- unsafeManagedPtrCastPtr scrolledWindow
    result <- gtk_scrolled_window_get_has_frame scrolledWindow'
    let result' = (/= 0) result
    touchManagedPtr scrolledWindow
    return result'

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowGetHasFrameMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsScrolledWindow a) => O.OverloadedMethod ScrolledWindowGetHasFrameMethodInfo a signature where
    overloadedMethod = scrolledWindowGetHasFrame

instance O.OverloadedMethodInfo ScrolledWindowGetHasFrameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.scrolledWindowGetHasFrame",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#v:scrolledWindowGetHasFrame"
        })


#endif

-- method ScrolledWindow::get_hscrollbar
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scrolled_window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrolledWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrolledWindow`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scrolled_window_get_hscrollbar" gtk_scrolled_window_get_hscrollbar :: 
    Ptr ScrolledWindow ->                   -- scrolled_window : TInterface (Name {namespace = "Gtk", name = "ScrolledWindow"})
    IO (Ptr Gtk.Widget.Widget)

-- | Returns the horizontal scrollbar of /@scrolledWindow@/.
scrolledWindowGetHscrollbar ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrolledWindow a) =>
    a
    -- ^ /@scrolledWindow@/: a @GtkScrolledWindow@
    -> m Gtk.Widget.Widget
    -- ^ __Returns:__ the horizontal scrollbar of the scrolled window.
scrolledWindowGetHscrollbar scrolledWindow = liftIO $ do
    scrolledWindow' <- unsafeManagedPtrCastPtr scrolledWindow
    result <- gtk_scrolled_window_get_hscrollbar scrolledWindow'
    checkUnexpectedReturnNULL "scrolledWindowGetHscrollbar" result
    result' <- (newObject Gtk.Widget.Widget) result
    touchManagedPtr scrolledWindow
    return result'

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowGetHscrollbarMethodInfo
instance (signature ~ (m Gtk.Widget.Widget), MonadIO m, IsScrolledWindow a) => O.OverloadedMethod ScrolledWindowGetHscrollbarMethodInfo a signature where
    overloadedMethod = scrolledWindowGetHscrollbar

instance O.OverloadedMethodInfo ScrolledWindowGetHscrollbarMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.scrolledWindowGetHscrollbar",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#v:scrolledWindowGetHscrollbar"
        })


#endif

-- method ScrolledWindow::get_kinetic_scrolling
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scrolled_window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrolledWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrolledWindow`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scrolled_window_get_kinetic_scrolling" gtk_scrolled_window_get_kinetic_scrolling :: 
    Ptr ScrolledWindow ->                   -- scrolled_window : TInterface (Name {namespace = "Gtk", name = "ScrolledWindow"})
    IO CInt

-- | Returns the specified kinetic scrolling behavior.
scrolledWindowGetKineticScrolling ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrolledWindow a) =>
    a
    -- ^ /@scrolledWindow@/: a @GtkScrolledWindow@
    -> m Bool
    -- ^ __Returns:__ the scrolling behavior flags.
scrolledWindowGetKineticScrolling scrolledWindow = liftIO $ do
    scrolledWindow' <- unsafeManagedPtrCastPtr scrolledWindow
    result <- gtk_scrolled_window_get_kinetic_scrolling scrolledWindow'
    let result' = (/= 0) result
    touchManagedPtr scrolledWindow
    return result'

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowGetKineticScrollingMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsScrolledWindow a) => O.OverloadedMethod ScrolledWindowGetKineticScrollingMethodInfo a signature where
    overloadedMethod = scrolledWindowGetKineticScrolling

instance O.OverloadedMethodInfo ScrolledWindowGetKineticScrollingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.scrolledWindowGetKineticScrolling",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#v:scrolledWindowGetKineticScrolling"
        })


#endif

-- method ScrolledWindow::get_max_content_height
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scrolled_window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrolledWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrolledWindow`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scrolled_window_get_max_content_height" gtk_scrolled_window_get_max_content_height :: 
    Ptr ScrolledWindow ->                   -- scrolled_window : TInterface (Name {namespace = "Gtk", name = "ScrolledWindow"})
    IO Int32

-- | Returns the maximum content height set.
scrolledWindowGetMaxContentHeight ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrolledWindow a) =>
    a
    -- ^ /@scrolledWindow@/: a @GtkScrolledWindow@
    -> m Int32
    -- ^ __Returns:__ the maximum content height, or -1
scrolledWindowGetMaxContentHeight scrolledWindow = liftIO $ do
    scrolledWindow' <- unsafeManagedPtrCastPtr scrolledWindow
    result <- gtk_scrolled_window_get_max_content_height scrolledWindow'
    touchManagedPtr scrolledWindow
    return result

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowGetMaxContentHeightMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsScrolledWindow a) => O.OverloadedMethod ScrolledWindowGetMaxContentHeightMethodInfo a signature where
    overloadedMethod = scrolledWindowGetMaxContentHeight

instance O.OverloadedMethodInfo ScrolledWindowGetMaxContentHeightMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.scrolledWindowGetMaxContentHeight",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#v:scrolledWindowGetMaxContentHeight"
        })


#endif

-- method ScrolledWindow::get_max_content_width
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scrolled_window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrolledWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrolledWindow`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scrolled_window_get_max_content_width" gtk_scrolled_window_get_max_content_width :: 
    Ptr ScrolledWindow ->                   -- scrolled_window : TInterface (Name {namespace = "Gtk", name = "ScrolledWindow"})
    IO Int32

-- | Returns the maximum content width set.
scrolledWindowGetMaxContentWidth ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrolledWindow a) =>
    a
    -- ^ /@scrolledWindow@/: a @GtkScrolledWindow@
    -> m Int32
    -- ^ __Returns:__ the maximum content width, or -1
scrolledWindowGetMaxContentWidth scrolledWindow = liftIO $ do
    scrolledWindow' <- unsafeManagedPtrCastPtr scrolledWindow
    result <- gtk_scrolled_window_get_max_content_width scrolledWindow'
    touchManagedPtr scrolledWindow
    return result

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowGetMaxContentWidthMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsScrolledWindow a) => O.OverloadedMethod ScrolledWindowGetMaxContentWidthMethodInfo a signature where
    overloadedMethod = scrolledWindowGetMaxContentWidth

instance O.OverloadedMethodInfo ScrolledWindowGetMaxContentWidthMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.scrolledWindowGetMaxContentWidth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#v:scrolledWindowGetMaxContentWidth"
        })


#endif

-- method ScrolledWindow::get_min_content_height
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scrolled_window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrolledWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrolledWindow`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scrolled_window_get_min_content_height" gtk_scrolled_window_get_min_content_height :: 
    Ptr ScrolledWindow ->                   -- scrolled_window : TInterface (Name {namespace = "Gtk", name = "ScrolledWindow"})
    IO Int32

-- | Gets the minimal content height of /@scrolledWindow@/.
scrolledWindowGetMinContentHeight ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrolledWindow a) =>
    a
    -- ^ /@scrolledWindow@/: a @GtkScrolledWindow@
    -> m Int32
    -- ^ __Returns:__ the minimal content height
scrolledWindowGetMinContentHeight scrolledWindow = liftIO $ do
    scrolledWindow' <- unsafeManagedPtrCastPtr scrolledWindow
    result <- gtk_scrolled_window_get_min_content_height scrolledWindow'
    touchManagedPtr scrolledWindow
    return result

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowGetMinContentHeightMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsScrolledWindow a) => O.OverloadedMethod ScrolledWindowGetMinContentHeightMethodInfo a signature where
    overloadedMethod = scrolledWindowGetMinContentHeight

instance O.OverloadedMethodInfo ScrolledWindowGetMinContentHeightMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.scrolledWindowGetMinContentHeight",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#v:scrolledWindowGetMinContentHeight"
        })


#endif

-- method ScrolledWindow::get_min_content_width
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scrolled_window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrolledWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrolledWindow`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TInt)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scrolled_window_get_min_content_width" gtk_scrolled_window_get_min_content_width :: 
    Ptr ScrolledWindow ->                   -- scrolled_window : TInterface (Name {namespace = "Gtk", name = "ScrolledWindow"})
    IO Int32

-- | Gets the minimum content width of /@scrolledWindow@/.
scrolledWindowGetMinContentWidth ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrolledWindow a) =>
    a
    -- ^ /@scrolledWindow@/: a @GtkScrolledWindow@
    -> m Int32
    -- ^ __Returns:__ the minimum content width
scrolledWindowGetMinContentWidth scrolledWindow = liftIO $ do
    scrolledWindow' <- unsafeManagedPtrCastPtr scrolledWindow
    result <- gtk_scrolled_window_get_min_content_width scrolledWindow'
    touchManagedPtr scrolledWindow
    return result

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowGetMinContentWidthMethodInfo
instance (signature ~ (m Int32), MonadIO m, IsScrolledWindow a) => O.OverloadedMethod ScrolledWindowGetMinContentWidthMethodInfo a signature where
    overloadedMethod = scrolledWindowGetMinContentWidth

instance O.OverloadedMethodInfo ScrolledWindowGetMinContentWidthMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.scrolledWindowGetMinContentWidth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#v:scrolledWindowGetMinContentWidth"
        })


#endif

-- method ScrolledWindow::get_overlay_scrolling
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scrolled_window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrolledWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrolledWindow`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scrolled_window_get_overlay_scrolling" gtk_scrolled_window_get_overlay_scrolling :: 
    Ptr ScrolledWindow ->                   -- scrolled_window : TInterface (Name {namespace = "Gtk", name = "ScrolledWindow"})
    IO CInt

-- | Returns whether overlay scrolling is enabled for this scrolled window.
scrolledWindowGetOverlayScrolling ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrolledWindow a) =>
    a
    -- ^ /@scrolledWindow@/: a @GtkScrolledWindow@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if overlay scrolling is enabled
scrolledWindowGetOverlayScrolling scrolledWindow = liftIO $ do
    scrolledWindow' <- unsafeManagedPtrCastPtr scrolledWindow
    result <- gtk_scrolled_window_get_overlay_scrolling scrolledWindow'
    let result' = (/= 0) result
    touchManagedPtr scrolledWindow
    return result'

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowGetOverlayScrollingMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsScrolledWindow a) => O.OverloadedMethod ScrolledWindowGetOverlayScrollingMethodInfo a signature where
    overloadedMethod = scrolledWindowGetOverlayScrolling

instance O.OverloadedMethodInfo ScrolledWindowGetOverlayScrollingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.scrolledWindowGetOverlayScrolling",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#v:scrolledWindowGetOverlayScrolling"
        })


#endif

-- method ScrolledWindow::get_placement
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scrolled_window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrolledWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrolledWindow`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "CornerType" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scrolled_window_get_placement" gtk_scrolled_window_get_placement :: 
    Ptr ScrolledWindow ->                   -- scrolled_window : TInterface (Name {namespace = "Gtk", name = "ScrolledWindow"})
    IO CUInt

-- | Gets the placement of the contents with respect to the scrollbars.
scrolledWindowGetPlacement ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrolledWindow a) =>
    a
    -- ^ /@scrolledWindow@/: a @GtkScrolledWindow@
    -> m Gtk.Enums.CornerType
    -- ^ __Returns:__ the current placement value.
scrolledWindowGetPlacement scrolledWindow = liftIO $ do
    scrolledWindow' <- unsafeManagedPtrCastPtr scrolledWindow
    result <- gtk_scrolled_window_get_placement scrolledWindow'
    let result' = (toEnum . fromIntegral) result
    touchManagedPtr scrolledWindow
    return result'

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowGetPlacementMethodInfo
instance (signature ~ (m Gtk.Enums.CornerType), MonadIO m, IsScrolledWindow a) => O.OverloadedMethod ScrolledWindowGetPlacementMethodInfo a signature where
    overloadedMethod = scrolledWindowGetPlacement

instance O.OverloadedMethodInfo ScrolledWindowGetPlacementMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.scrolledWindowGetPlacement",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#v:scrolledWindowGetPlacement"
        })


#endif

-- method ScrolledWindow::get_policy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scrolled_window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrolledWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrolledWindow`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "hscrollbar_policy"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PolicyType" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "location to store the policy\n  for the horizontal scrollbar"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       , Arg
--           { argCName = "vscrollbar_policy"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PolicyType" }
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "location to store the policy\n  for the vertical scrollbar"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scrolled_window_get_policy" gtk_scrolled_window_get_policy :: 
    Ptr ScrolledWindow ->                   -- scrolled_window : TInterface (Name {namespace = "Gtk", name = "ScrolledWindow"})
    Ptr CUInt ->                            -- hscrollbar_policy : TInterface (Name {namespace = "Gtk", name = "PolicyType"})
    Ptr CUInt ->                            -- vscrollbar_policy : TInterface (Name {namespace = "Gtk", name = "PolicyType"})
    IO ()

-- | Retrieves the current policy values for the horizontal and vertical
-- scrollbars.
-- 
-- See 'GI.Gtk.Objects.ScrolledWindow.scrolledWindowSetPolicy'.
scrolledWindowGetPolicy ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrolledWindow a) =>
    a
    -- ^ /@scrolledWindow@/: a @GtkScrolledWindow@
    -> m ((Gtk.Enums.PolicyType, Gtk.Enums.PolicyType))
scrolledWindowGetPolicy scrolledWindow = liftIO $ do
    scrolledWindow' <- unsafeManagedPtrCastPtr scrolledWindow
    hscrollbarPolicy <- allocMem :: IO (Ptr CUInt)
    vscrollbarPolicy <- allocMem :: IO (Ptr CUInt)
    gtk_scrolled_window_get_policy scrolledWindow' hscrollbarPolicy vscrollbarPolicy
    hscrollbarPolicy' <- peek hscrollbarPolicy
    let hscrollbarPolicy'' = (toEnum . fromIntegral) hscrollbarPolicy'
    vscrollbarPolicy' <- peek vscrollbarPolicy
    let vscrollbarPolicy'' = (toEnum . fromIntegral) vscrollbarPolicy'
    touchManagedPtr scrolledWindow
    freeMem hscrollbarPolicy
    freeMem vscrollbarPolicy
    return (hscrollbarPolicy'', vscrollbarPolicy'')

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowGetPolicyMethodInfo
instance (signature ~ (m ((Gtk.Enums.PolicyType, Gtk.Enums.PolicyType))), MonadIO m, IsScrolledWindow a) => O.OverloadedMethod ScrolledWindowGetPolicyMethodInfo a signature where
    overloadedMethod = scrolledWindowGetPolicy

instance O.OverloadedMethodInfo ScrolledWindowGetPolicyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.scrolledWindowGetPolicy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#v:scrolledWindowGetPolicy"
        })


#endif

-- method ScrolledWindow::get_propagate_natural_height
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scrolled_window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrolledWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrolledWindow`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scrolled_window_get_propagate_natural_height" gtk_scrolled_window_get_propagate_natural_height :: 
    Ptr ScrolledWindow ->                   -- scrolled_window : TInterface (Name {namespace = "Gtk", name = "ScrolledWindow"})
    IO CInt

-- | Reports whether the natural height of the child will be calculated
-- and propagated through the scrolled window’s requested natural height.
scrolledWindowGetPropagateNaturalHeight ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrolledWindow a) =>
    a
    -- ^ /@scrolledWindow@/: a @GtkScrolledWindow@
    -> m Bool
    -- ^ __Returns:__ whether natural height propagation is enabled.
scrolledWindowGetPropagateNaturalHeight scrolledWindow = liftIO $ do
    scrolledWindow' <- unsafeManagedPtrCastPtr scrolledWindow
    result <- gtk_scrolled_window_get_propagate_natural_height scrolledWindow'
    let result' = (/= 0) result
    touchManagedPtr scrolledWindow
    return result'

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowGetPropagateNaturalHeightMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsScrolledWindow a) => O.OverloadedMethod ScrolledWindowGetPropagateNaturalHeightMethodInfo a signature where
    overloadedMethod = scrolledWindowGetPropagateNaturalHeight

instance O.OverloadedMethodInfo ScrolledWindowGetPropagateNaturalHeightMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.scrolledWindowGetPropagateNaturalHeight",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#v:scrolledWindowGetPropagateNaturalHeight"
        })


#endif

-- method ScrolledWindow::get_propagate_natural_width
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scrolled_window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrolledWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrolledWindow`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scrolled_window_get_propagate_natural_width" gtk_scrolled_window_get_propagate_natural_width :: 
    Ptr ScrolledWindow ->                   -- scrolled_window : TInterface (Name {namespace = "Gtk", name = "ScrolledWindow"})
    IO CInt

-- | Reports whether the natural width of the child will be calculated
-- and propagated through the scrolled window’s requested natural width.
scrolledWindowGetPropagateNaturalWidth ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrolledWindow a) =>
    a
    -- ^ /@scrolledWindow@/: a @GtkScrolledWindow@
    -> m Bool
    -- ^ __Returns:__ whether natural width propagation is enabled.
scrolledWindowGetPropagateNaturalWidth scrolledWindow = liftIO $ do
    scrolledWindow' <- unsafeManagedPtrCastPtr scrolledWindow
    result <- gtk_scrolled_window_get_propagate_natural_width scrolledWindow'
    let result' = (/= 0) result
    touchManagedPtr scrolledWindow
    return result'

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowGetPropagateNaturalWidthMethodInfo
instance (signature ~ (m Bool), MonadIO m, IsScrolledWindow a) => O.OverloadedMethod ScrolledWindowGetPropagateNaturalWidthMethodInfo a signature where
    overloadedMethod = scrolledWindowGetPropagateNaturalWidth

instance O.OverloadedMethodInfo ScrolledWindowGetPropagateNaturalWidthMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.scrolledWindowGetPropagateNaturalWidth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#v:scrolledWindowGetPropagateNaturalWidth"
        })


#endif

-- method ScrolledWindow::get_vadjustment
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scrolled_window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrolledWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrolledWindow`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Adjustment" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scrolled_window_get_vadjustment" gtk_scrolled_window_get_vadjustment :: 
    Ptr ScrolledWindow ->                   -- scrolled_window : TInterface (Name {namespace = "Gtk", name = "ScrolledWindow"})
    IO (Ptr Gtk.Adjustment.Adjustment)

-- | Returns the vertical scrollbar’s adjustment.
-- 
-- This is the adjustment used to connect the vertical
-- scrollbar to the child widget’s vertical scroll functionality.
scrolledWindowGetVadjustment ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrolledWindow a) =>
    a
    -- ^ /@scrolledWindow@/: a @GtkScrolledWindow@
    -> m Gtk.Adjustment.Adjustment
    -- ^ __Returns:__ the vertical @GtkAdjustment@
scrolledWindowGetVadjustment scrolledWindow = liftIO $ do
    scrolledWindow' <- unsafeManagedPtrCastPtr scrolledWindow
    result <- gtk_scrolled_window_get_vadjustment scrolledWindow'
    checkUnexpectedReturnNULL "scrolledWindowGetVadjustment" result
    result' <- (newObject Gtk.Adjustment.Adjustment) result
    touchManagedPtr scrolledWindow
    return result'

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowGetVadjustmentMethodInfo
instance (signature ~ (m Gtk.Adjustment.Adjustment), MonadIO m, IsScrolledWindow a) => O.OverloadedMethod ScrolledWindowGetVadjustmentMethodInfo a signature where
    overloadedMethod = scrolledWindowGetVadjustment

instance O.OverloadedMethodInfo ScrolledWindowGetVadjustmentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.scrolledWindowGetVadjustment",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#v:scrolledWindowGetVadjustment"
        })


#endif

-- method ScrolledWindow::get_vscrollbar
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scrolled_window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrolledWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrolledWindow`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gtk" , name = "Widget" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scrolled_window_get_vscrollbar" gtk_scrolled_window_get_vscrollbar :: 
    Ptr ScrolledWindow ->                   -- scrolled_window : TInterface (Name {namespace = "Gtk", name = "ScrolledWindow"})
    IO (Ptr Gtk.Widget.Widget)

-- | Returns the vertical scrollbar of /@scrolledWindow@/.
scrolledWindowGetVscrollbar ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrolledWindow a) =>
    a
    -- ^ /@scrolledWindow@/: a @GtkScrolledWindow@
    -> m Gtk.Widget.Widget
    -- ^ __Returns:__ the vertical scrollbar of the scrolled window.
scrolledWindowGetVscrollbar scrolledWindow = liftIO $ do
    scrolledWindow' <- unsafeManagedPtrCastPtr scrolledWindow
    result <- gtk_scrolled_window_get_vscrollbar scrolledWindow'
    checkUnexpectedReturnNULL "scrolledWindowGetVscrollbar" result
    result' <- (newObject Gtk.Widget.Widget) result
    touchManagedPtr scrolledWindow
    return result'

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowGetVscrollbarMethodInfo
instance (signature ~ (m Gtk.Widget.Widget), MonadIO m, IsScrolledWindow a) => O.OverloadedMethod ScrolledWindowGetVscrollbarMethodInfo a signature where
    overloadedMethod = scrolledWindowGetVscrollbar

instance O.OverloadedMethodInfo ScrolledWindowGetVscrollbarMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.scrolledWindowGetVscrollbar",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#v:scrolledWindowGetVscrollbar"
        })


#endif

-- method ScrolledWindow::set_child
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scrolled_window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrolledWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrolledWindow`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "child"
--           , argType = TInterface Name { namespace = "Gtk" , name = "Widget" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the child widget" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scrolled_window_set_child" gtk_scrolled_window_set_child :: 
    Ptr ScrolledWindow ->                   -- scrolled_window : TInterface (Name {namespace = "Gtk", name = "ScrolledWindow"})
    Ptr Gtk.Widget.Widget ->                -- child : TInterface (Name {namespace = "Gtk", name = "Widget"})
    IO ()

-- | Sets the child widget of /@scrolledWindow@/.
-- 
-- If /@child@/ does not implement the t'GI.Gtk.Interfaces.Scrollable.Scrollable' interface,
-- the scrolled window will add /@child@/ to a t'GI.Gtk.Objects.Viewport.Viewport' instance
-- and then add the viewport as its child widget.
scrolledWindowSetChild ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrolledWindow a, Gtk.Widget.IsWidget b) =>
    a
    -- ^ /@scrolledWindow@/: a @GtkScrolledWindow@
    -> Maybe (b)
    -- ^ /@child@/: the child widget
    -> m ()
scrolledWindowSetChild scrolledWindow child = liftIO $ do
    scrolledWindow' <- unsafeManagedPtrCastPtr scrolledWindow
    maybeChild <- case child of
        Nothing -> return FP.nullPtr
        Just jChild -> do
            jChild' <- unsafeManagedPtrCastPtr jChild
            return jChild'
    gtk_scrolled_window_set_child scrolledWindow' maybeChild
    touchManagedPtr scrolledWindow
    whenJust child touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowSetChildMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsScrolledWindow a, Gtk.Widget.IsWidget b) => O.OverloadedMethod ScrolledWindowSetChildMethodInfo a signature where
    overloadedMethod = scrolledWindowSetChild

instance O.OverloadedMethodInfo ScrolledWindowSetChildMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.scrolledWindowSetChild",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#v:scrolledWindowSetChild"
        })


#endif

-- method ScrolledWindow::set_hadjustment
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scrolled_window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrolledWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrolledWindow`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "hadjustment"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Adjustment" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the `GtkAdjustment` to use, or %NULL to create a new one"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scrolled_window_set_hadjustment" gtk_scrolled_window_set_hadjustment :: 
    Ptr ScrolledWindow ->                   -- scrolled_window : TInterface (Name {namespace = "Gtk", name = "ScrolledWindow"})
    Ptr Gtk.Adjustment.Adjustment ->        -- hadjustment : TInterface (Name {namespace = "Gtk", name = "Adjustment"})
    IO ()

-- | Sets the @GtkAdjustment@ for the horizontal scrollbar.
scrolledWindowSetHadjustment ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrolledWindow a, Gtk.Adjustment.IsAdjustment b) =>
    a
    -- ^ /@scrolledWindow@/: a @GtkScrolledWindow@
    -> Maybe (b)
    -- ^ /@hadjustment@/: the @GtkAdjustment@ to use, or 'P.Nothing' to create a new one
    -> m ()
scrolledWindowSetHadjustment scrolledWindow hadjustment = liftIO $ do
    scrolledWindow' <- unsafeManagedPtrCastPtr scrolledWindow
    maybeHadjustment <- case hadjustment of
        Nothing -> return FP.nullPtr
        Just jHadjustment -> do
            jHadjustment' <- unsafeManagedPtrCastPtr jHadjustment
            return jHadjustment'
    gtk_scrolled_window_set_hadjustment scrolledWindow' maybeHadjustment
    touchManagedPtr scrolledWindow
    whenJust hadjustment touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowSetHadjustmentMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsScrolledWindow a, Gtk.Adjustment.IsAdjustment b) => O.OverloadedMethod ScrolledWindowSetHadjustmentMethodInfo a signature where
    overloadedMethod = scrolledWindowSetHadjustment

instance O.OverloadedMethodInfo ScrolledWindowSetHadjustmentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.scrolledWindowSetHadjustment",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#v:scrolledWindowSetHadjustment"
        })


#endif

-- method ScrolledWindow::set_has_frame
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scrolled_window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrolledWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrolledWindow`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "has_frame"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "whether to draw a frame around scrolled window contents"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scrolled_window_set_has_frame" gtk_scrolled_window_set_has_frame :: 
    Ptr ScrolledWindow ->                   -- scrolled_window : TInterface (Name {namespace = "Gtk", name = "ScrolledWindow"})
    CInt ->                                 -- has_frame : TBasicType TBoolean
    IO ()

-- | Changes the frame drawn around the contents of /@scrolledWindow@/.
scrolledWindowSetHasFrame ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrolledWindow a) =>
    a
    -- ^ /@scrolledWindow@/: a @GtkScrolledWindow@
    -> Bool
    -- ^ /@hasFrame@/: whether to draw a frame around scrolled window contents
    -> m ()
scrolledWindowSetHasFrame scrolledWindow hasFrame = liftIO $ do
    scrolledWindow' <- unsafeManagedPtrCastPtr scrolledWindow
    let hasFrame' = (P.fromIntegral . P.fromEnum) hasFrame
    gtk_scrolled_window_set_has_frame scrolledWindow' hasFrame'
    touchManagedPtr scrolledWindow
    return ()

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowSetHasFrameMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsScrolledWindow a) => O.OverloadedMethod ScrolledWindowSetHasFrameMethodInfo a signature where
    overloadedMethod = scrolledWindowSetHasFrame

instance O.OverloadedMethodInfo ScrolledWindowSetHasFrameMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.scrolledWindowSetHasFrame",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#v:scrolledWindowSetHasFrame"
        })


#endif

-- method ScrolledWindow::set_kinetic_scrolling
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scrolled_window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrolledWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrolledWindow`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "kinetic_scrolling"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "%TRUE to enable kinetic scrolling"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scrolled_window_set_kinetic_scrolling" gtk_scrolled_window_set_kinetic_scrolling :: 
    Ptr ScrolledWindow ->                   -- scrolled_window : TInterface (Name {namespace = "Gtk", name = "ScrolledWindow"})
    CInt ->                                 -- kinetic_scrolling : TBasicType TBoolean
    IO ()

-- | Turns kinetic scrolling on or off.
-- 
-- Kinetic scrolling only applies to devices with source
-- 'GI.Gdk.Enums.InputSourceTouchscreen'.
scrolledWindowSetKineticScrolling ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrolledWindow a) =>
    a
    -- ^ /@scrolledWindow@/: a @GtkScrolledWindow@
    -> Bool
    -- ^ /@kineticScrolling@/: 'P.True' to enable kinetic scrolling
    -> m ()
scrolledWindowSetKineticScrolling scrolledWindow kineticScrolling = liftIO $ do
    scrolledWindow' <- unsafeManagedPtrCastPtr scrolledWindow
    let kineticScrolling' = (P.fromIntegral . P.fromEnum) kineticScrolling
    gtk_scrolled_window_set_kinetic_scrolling scrolledWindow' kineticScrolling'
    touchManagedPtr scrolledWindow
    return ()

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowSetKineticScrollingMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsScrolledWindow a) => O.OverloadedMethod ScrolledWindowSetKineticScrollingMethodInfo a signature where
    overloadedMethod = scrolledWindowSetKineticScrolling

instance O.OverloadedMethodInfo ScrolledWindowSetKineticScrollingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.scrolledWindowSetKineticScrolling",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#v:scrolledWindowSetKineticScrolling"
        })


#endif

-- method ScrolledWindow::set_max_content_height
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scrolled_window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrolledWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrolledWindow`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the maximum content height"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scrolled_window_set_max_content_height" gtk_scrolled_window_set_max_content_height :: 
    Ptr ScrolledWindow ->                   -- scrolled_window : TInterface (Name {namespace = "Gtk", name = "ScrolledWindow"})
    Int32 ->                                -- height : TBasicType TInt
    IO ()

-- | Sets the maximum height that /@scrolledWindow@/ should keep visible.
-- 
-- The /@scrolledWindow@/ will grow up to this height before it starts
-- scrolling the content.
-- 
-- It is a programming error to set the maximum content height to a value
-- smaller than [ScrolledWindow:minContentHeight]("GI.Gtk.Objects.ScrolledWindow#g:attr:minContentHeight").
scrolledWindowSetMaxContentHeight ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrolledWindow a) =>
    a
    -- ^ /@scrolledWindow@/: a @GtkScrolledWindow@
    -> Int32
    -- ^ /@height@/: the maximum content height
    -> m ()
scrolledWindowSetMaxContentHeight scrolledWindow height = liftIO $ do
    scrolledWindow' <- unsafeManagedPtrCastPtr scrolledWindow
    gtk_scrolled_window_set_max_content_height scrolledWindow' height
    touchManagedPtr scrolledWindow
    return ()

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowSetMaxContentHeightMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsScrolledWindow a) => O.OverloadedMethod ScrolledWindowSetMaxContentHeightMethodInfo a signature where
    overloadedMethod = scrolledWindowSetMaxContentHeight

instance O.OverloadedMethodInfo ScrolledWindowSetMaxContentHeightMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.scrolledWindowSetMaxContentHeight",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#v:scrolledWindowSetMaxContentHeight"
        })


#endif

-- method ScrolledWindow::set_max_content_width
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scrolled_window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrolledWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrolledWindow`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the maximum content width"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scrolled_window_set_max_content_width" gtk_scrolled_window_set_max_content_width :: 
    Ptr ScrolledWindow ->                   -- scrolled_window : TInterface (Name {namespace = "Gtk", name = "ScrolledWindow"})
    Int32 ->                                -- width : TBasicType TInt
    IO ()

-- | Sets the maximum width that /@scrolledWindow@/ should keep visible.
-- 
-- The /@scrolledWindow@/ will grow up to this width before it starts
-- scrolling the content.
-- 
-- It is a programming error to set the maximum content width to a
-- value smaller than [ScrolledWindow:minContentWidth]("GI.Gtk.Objects.ScrolledWindow#g:attr:minContentWidth").
scrolledWindowSetMaxContentWidth ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrolledWindow a) =>
    a
    -- ^ /@scrolledWindow@/: a @GtkScrolledWindow@
    -> Int32
    -- ^ /@width@/: the maximum content width
    -> m ()
scrolledWindowSetMaxContentWidth scrolledWindow width = liftIO $ do
    scrolledWindow' <- unsafeManagedPtrCastPtr scrolledWindow
    gtk_scrolled_window_set_max_content_width scrolledWindow' width
    touchManagedPtr scrolledWindow
    return ()

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowSetMaxContentWidthMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsScrolledWindow a) => O.OverloadedMethod ScrolledWindowSetMaxContentWidthMethodInfo a signature where
    overloadedMethod = scrolledWindowSetMaxContentWidth

instance O.OverloadedMethodInfo ScrolledWindowSetMaxContentWidthMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.scrolledWindowSetMaxContentWidth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#v:scrolledWindowSetMaxContentWidth"
        })


#endif

-- method ScrolledWindow::set_min_content_height
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scrolled_window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrolledWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrolledWindow`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "height"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the minimal content height"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scrolled_window_set_min_content_height" gtk_scrolled_window_set_min_content_height :: 
    Ptr ScrolledWindow ->                   -- scrolled_window : TInterface (Name {namespace = "Gtk", name = "ScrolledWindow"})
    Int32 ->                                -- height : TBasicType TInt
    IO ()

-- | Sets the minimum height that /@scrolledWindow@/ should keep visible.
-- 
-- Note that this can and (usually will) be smaller than the minimum
-- size of the content.
-- 
-- It is a programming error to set the minimum content height to a
-- value greater than [ScrolledWindow:maxContentHeight]("GI.Gtk.Objects.ScrolledWindow#g:attr:maxContentHeight").
scrolledWindowSetMinContentHeight ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrolledWindow a) =>
    a
    -- ^ /@scrolledWindow@/: a @GtkScrolledWindow@
    -> Int32
    -- ^ /@height@/: the minimal content height
    -> m ()
scrolledWindowSetMinContentHeight scrolledWindow height = liftIO $ do
    scrolledWindow' <- unsafeManagedPtrCastPtr scrolledWindow
    gtk_scrolled_window_set_min_content_height scrolledWindow' height
    touchManagedPtr scrolledWindow
    return ()

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowSetMinContentHeightMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsScrolledWindow a) => O.OverloadedMethod ScrolledWindowSetMinContentHeightMethodInfo a signature where
    overloadedMethod = scrolledWindowSetMinContentHeight

instance O.OverloadedMethodInfo ScrolledWindowSetMinContentHeightMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.scrolledWindowSetMinContentHeight",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#v:scrolledWindowSetMinContentHeight"
        })


#endif

-- method ScrolledWindow::set_min_content_width
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scrolled_window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrolledWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrolledWindow`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "width"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the minimal content width"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scrolled_window_set_min_content_width" gtk_scrolled_window_set_min_content_width :: 
    Ptr ScrolledWindow ->                   -- scrolled_window : TInterface (Name {namespace = "Gtk", name = "ScrolledWindow"})
    Int32 ->                                -- width : TBasicType TInt
    IO ()

-- | Sets the minimum width that /@scrolledWindow@/ should keep visible.
-- 
-- Note that this can and (usually will) be smaller than the minimum
-- size of the content.
-- 
-- It is a programming error to set the minimum content width to a
-- value greater than [ScrolledWindow:maxContentWidth]("GI.Gtk.Objects.ScrolledWindow#g:attr:maxContentWidth").
scrolledWindowSetMinContentWidth ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrolledWindow a) =>
    a
    -- ^ /@scrolledWindow@/: a @GtkScrolledWindow@
    -> Int32
    -- ^ /@width@/: the minimal content width
    -> m ()
scrolledWindowSetMinContentWidth scrolledWindow width = liftIO $ do
    scrolledWindow' <- unsafeManagedPtrCastPtr scrolledWindow
    gtk_scrolled_window_set_min_content_width scrolledWindow' width
    touchManagedPtr scrolledWindow
    return ()

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowSetMinContentWidthMethodInfo
instance (signature ~ (Int32 -> m ()), MonadIO m, IsScrolledWindow a) => O.OverloadedMethod ScrolledWindowSetMinContentWidthMethodInfo a signature where
    overloadedMethod = scrolledWindowSetMinContentWidth

instance O.OverloadedMethodInfo ScrolledWindowSetMinContentWidthMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.scrolledWindowSetMinContentWidth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#v:scrolledWindowSetMinContentWidth"
        })


#endif

-- method ScrolledWindow::set_overlay_scrolling
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scrolled_window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrolledWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrolledWindow`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "overlay_scrolling"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to enable overlay scrolling"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scrolled_window_set_overlay_scrolling" gtk_scrolled_window_set_overlay_scrolling :: 
    Ptr ScrolledWindow ->                   -- scrolled_window : TInterface (Name {namespace = "Gtk", name = "ScrolledWindow"})
    CInt ->                                 -- overlay_scrolling : TBasicType TBoolean
    IO ()

-- | Enables or disables overlay scrolling for this scrolled window.
scrolledWindowSetOverlayScrolling ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrolledWindow a) =>
    a
    -- ^ /@scrolledWindow@/: a @GtkScrolledWindow@
    -> Bool
    -- ^ /@overlayScrolling@/: whether to enable overlay scrolling
    -> m ()
scrolledWindowSetOverlayScrolling scrolledWindow overlayScrolling = liftIO $ do
    scrolledWindow' <- unsafeManagedPtrCastPtr scrolledWindow
    let overlayScrolling' = (P.fromIntegral . P.fromEnum) overlayScrolling
    gtk_scrolled_window_set_overlay_scrolling scrolledWindow' overlayScrolling'
    touchManagedPtr scrolledWindow
    return ()

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowSetOverlayScrollingMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsScrolledWindow a) => O.OverloadedMethod ScrolledWindowSetOverlayScrollingMethodInfo a signature where
    overloadedMethod = scrolledWindowSetOverlayScrolling

instance O.OverloadedMethodInfo ScrolledWindowSetOverlayScrollingMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.scrolledWindowSetOverlayScrolling",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#v:scrolledWindowSetOverlayScrolling"
        })


#endif

-- method ScrolledWindow::set_placement
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scrolled_window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrolledWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrolledWindow`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "window_placement"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "CornerType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "position of the child window"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scrolled_window_set_placement" gtk_scrolled_window_set_placement :: 
    Ptr ScrolledWindow ->                   -- scrolled_window : TInterface (Name {namespace = "Gtk", name = "ScrolledWindow"})
    CUInt ->                                -- window_placement : TInterface (Name {namespace = "Gtk", name = "CornerType"})
    IO ()

-- | Sets the placement of the contents with respect to the scrollbars
-- for the scrolled window.
-- 
-- The default is 'GI.Gtk.Enums.CornerTypeTopLeft', meaning the child is
-- in the top left, with the scrollbars underneath and to the right.
-- Other values in t'GI.Gtk.Enums.CornerType' are 'GI.Gtk.Enums.CornerTypeTopRight',
-- 'GI.Gtk.Enums.CornerTypeBottomLeft', and 'GI.Gtk.Enums.CornerTypeBottomRight'.
-- 
-- See also 'GI.Gtk.Objects.ScrolledWindow.scrolledWindowGetPlacement' and
-- 'GI.Gtk.Objects.ScrolledWindow.scrolledWindowUnsetPlacement'.
scrolledWindowSetPlacement ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrolledWindow a) =>
    a
    -- ^ /@scrolledWindow@/: a @GtkScrolledWindow@
    -> Gtk.Enums.CornerType
    -- ^ /@windowPlacement@/: position of the child window
    -> m ()
scrolledWindowSetPlacement scrolledWindow windowPlacement = liftIO $ do
    scrolledWindow' <- unsafeManagedPtrCastPtr scrolledWindow
    let windowPlacement' = (fromIntegral . fromEnum) windowPlacement
    gtk_scrolled_window_set_placement scrolledWindow' windowPlacement'
    touchManagedPtr scrolledWindow
    return ()

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowSetPlacementMethodInfo
instance (signature ~ (Gtk.Enums.CornerType -> m ()), MonadIO m, IsScrolledWindow a) => O.OverloadedMethod ScrolledWindowSetPlacementMethodInfo a signature where
    overloadedMethod = scrolledWindowSetPlacement

instance O.OverloadedMethodInfo ScrolledWindowSetPlacementMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.scrolledWindowSetPlacement",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#v:scrolledWindowSetPlacement"
        })


#endif

-- method ScrolledWindow::set_policy
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scrolled_window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrolledWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrolledWindow`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "hscrollbar_policy"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PolicyType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "policy for horizontal bar"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "vscrollbar_policy"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "PolicyType" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "policy for vertical bar"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scrolled_window_set_policy" gtk_scrolled_window_set_policy :: 
    Ptr ScrolledWindow ->                   -- scrolled_window : TInterface (Name {namespace = "Gtk", name = "ScrolledWindow"})
    CUInt ->                                -- hscrollbar_policy : TInterface (Name {namespace = "Gtk", name = "PolicyType"})
    CUInt ->                                -- vscrollbar_policy : TInterface (Name {namespace = "Gtk", name = "PolicyType"})
    IO ()

-- | Sets the scrollbar policy for the horizontal and vertical scrollbars.
-- 
-- The policy determines when the scrollbar should appear; it is a value
-- from the t'GI.Gtk.Enums.PolicyType' enumeration. If 'GI.Gtk.Enums.PolicyTypeAlways', the
-- scrollbar is always present; if 'GI.Gtk.Enums.PolicyTypeNever', the scrollbar is
-- never present; if 'GI.Gtk.Enums.PolicyTypeAutomatic', the scrollbar is present only
-- if needed (that is, if the slider part of the bar would be smaller
-- than the trough — the display is larger than the page size).
scrolledWindowSetPolicy ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrolledWindow a) =>
    a
    -- ^ /@scrolledWindow@/: a @GtkScrolledWindow@
    -> Gtk.Enums.PolicyType
    -- ^ /@hscrollbarPolicy@/: policy for horizontal bar
    -> Gtk.Enums.PolicyType
    -- ^ /@vscrollbarPolicy@/: policy for vertical bar
    -> m ()
scrolledWindowSetPolicy scrolledWindow hscrollbarPolicy vscrollbarPolicy = liftIO $ do
    scrolledWindow' <- unsafeManagedPtrCastPtr scrolledWindow
    let hscrollbarPolicy' = (fromIntegral . fromEnum) hscrollbarPolicy
    let vscrollbarPolicy' = (fromIntegral . fromEnum) vscrollbarPolicy
    gtk_scrolled_window_set_policy scrolledWindow' hscrollbarPolicy' vscrollbarPolicy'
    touchManagedPtr scrolledWindow
    return ()

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowSetPolicyMethodInfo
instance (signature ~ (Gtk.Enums.PolicyType -> Gtk.Enums.PolicyType -> m ()), MonadIO m, IsScrolledWindow a) => O.OverloadedMethod ScrolledWindowSetPolicyMethodInfo a signature where
    overloadedMethod = scrolledWindowSetPolicy

instance O.OverloadedMethodInfo ScrolledWindowSetPolicyMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.scrolledWindowSetPolicy",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#v:scrolledWindowSetPolicy"
        })


#endif

-- method ScrolledWindow::set_propagate_natural_height
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scrolled_window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrolledWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrolledWindow`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "propagate"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to propagate natural height"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scrolled_window_set_propagate_natural_height" gtk_scrolled_window_set_propagate_natural_height :: 
    Ptr ScrolledWindow ->                   -- scrolled_window : TInterface (Name {namespace = "Gtk", name = "ScrolledWindow"})
    CInt ->                                 -- propagate : TBasicType TBoolean
    IO ()

-- | Sets whether the natural height of the child should be calculated
-- and propagated through the scrolled window’s requested natural height.
scrolledWindowSetPropagateNaturalHeight ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrolledWindow a) =>
    a
    -- ^ /@scrolledWindow@/: a @GtkScrolledWindow@
    -> Bool
    -- ^ /@propagate@/: whether to propagate natural height
    -> m ()
scrolledWindowSetPropagateNaturalHeight scrolledWindow propagate = liftIO $ do
    scrolledWindow' <- unsafeManagedPtrCastPtr scrolledWindow
    let propagate' = (P.fromIntegral . P.fromEnum) propagate
    gtk_scrolled_window_set_propagate_natural_height scrolledWindow' propagate'
    touchManagedPtr scrolledWindow
    return ()

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowSetPropagateNaturalHeightMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsScrolledWindow a) => O.OverloadedMethod ScrolledWindowSetPropagateNaturalHeightMethodInfo a signature where
    overloadedMethod = scrolledWindowSetPropagateNaturalHeight

instance O.OverloadedMethodInfo ScrolledWindowSetPropagateNaturalHeightMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.scrolledWindowSetPropagateNaturalHeight",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#v:scrolledWindowSetPropagateNaturalHeight"
        })


#endif

-- method ScrolledWindow::set_propagate_natural_width
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scrolled_window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrolledWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrolledWindow`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "propagate"
--           , argType = TBasicType TBoolean
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "whether to propagate natural width"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scrolled_window_set_propagate_natural_width" gtk_scrolled_window_set_propagate_natural_width :: 
    Ptr ScrolledWindow ->                   -- scrolled_window : TInterface (Name {namespace = "Gtk", name = "ScrolledWindow"})
    CInt ->                                 -- propagate : TBasicType TBoolean
    IO ()

-- | Sets whether the natural width of the child should be calculated
-- and propagated through the scrolled window’s requested natural width.
scrolledWindowSetPropagateNaturalWidth ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrolledWindow a) =>
    a
    -- ^ /@scrolledWindow@/: a @GtkScrolledWindow@
    -> Bool
    -- ^ /@propagate@/: whether to propagate natural width
    -> m ()
scrolledWindowSetPropagateNaturalWidth scrolledWindow propagate = liftIO $ do
    scrolledWindow' <- unsafeManagedPtrCastPtr scrolledWindow
    let propagate' = (P.fromIntegral . P.fromEnum) propagate
    gtk_scrolled_window_set_propagate_natural_width scrolledWindow' propagate'
    touchManagedPtr scrolledWindow
    return ()

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowSetPropagateNaturalWidthMethodInfo
instance (signature ~ (Bool -> m ()), MonadIO m, IsScrolledWindow a) => O.OverloadedMethod ScrolledWindowSetPropagateNaturalWidthMethodInfo a signature where
    overloadedMethod = scrolledWindowSetPropagateNaturalWidth

instance O.OverloadedMethodInfo ScrolledWindowSetPropagateNaturalWidthMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.scrolledWindowSetPropagateNaturalWidth",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#v:scrolledWindowSetPropagateNaturalWidth"
        })


#endif

-- method ScrolledWindow::set_vadjustment
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scrolled_window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrolledWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrolledWindow`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "vadjustment"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "Adjustment" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the `GtkAdjustment` to use, or %NULL to create a new one"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scrolled_window_set_vadjustment" gtk_scrolled_window_set_vadjustment :: 
    Ptr ScrolledWindow ->                   -- scrolled_window : TInterface (Name {namespace = "Gtk", name = "ScrolledWindow"})
    Ptr Gtk.Adjustment.Adjustment ->        -- vadjustment : TInterface (Name {namespace = "Gtk", name = "Adjustment"})
    IO ()

-- | Sets the @GtkAdjustment@ for the vertical scrollbar.
scrolledWindowSetVadjustment ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrolledWindow a, Gtk.Adjustment.IsAdjustment b) =>
    a
    -- ^ /@scrolledWindow@/: a @GtkScrolledWindow@
    -> Maybe (b)
    -- ^ /@vadjustment@/: the @GtkAdjustment@ to use, or 'P.Nothing' to create a new one
    -> m ()
scrolledWindowSetVadjustment scrolledWindow vadjustment = liftIO $ do
    scrolledWindow' <- unsafeManagedPtrCastPtr scrolledWindow
    maybeVadjustment <- case vadjustment of
        Nothing -> return FP.nullPtr
        Just jVadjustment -> do
            jVadjustment' <- unsafeManagedPtrCastPtr jVadjustment
            return jVadjustment'
    gtk_scrolled_window_set_vadjustment scrolledWindow' maybeVadjustment
    touchManagedPtr scrolledWindow
    whenJust vadjustment touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowSetVadjustmentMethodInfo
instance (signature ~ (Maybe (b) -> m ()), MonadIO m, IsScrolledWindow a, Gtk.Adjustment.IsAdjustment b) => O.OverloadedMethod ScrolledWindowSetVadjustmentMethodInfo a signature where
    overloadedMethod = scrolledWindowSetVadjustment

instance O.OverloadedMethodInfo ScrolledWindowSetVadjustmentMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.scrolledWindowSetVadjustment",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#v:scrolledWindowSetVadjustment"
        })


#endif

-- method ScrolledWindow::unset_placement
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "scrolled_window"
--           , argType =
--               TInterface Name { namespace = "Gtk" , name = "ScrolledWindow" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GtkScrolledWindow`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gtk_scrolled_window_unset_placement" gtk_scrolled_window_unset_placement :: 
    Ptr ScrolledWindow ->                   -- scrolled_window : TInterface (Name {namespace = "Gtk", name = "ScrolledWindow"})
    IO ()

-- | Unsets the placement of the contents with respect to the scrollbars.
-- 
-- If no window placement is set for a scrolled window,
-- it defaults to 'GI.Gtk.Enums.CornerTypeTopLeft'.
scrolledWindowUnsetPlacement ::
    (B.CallStack.HasCallStack, MonadIO m, IsScrolledWindow a) =>
    a
    -- ^ /@scrolledWindow@/: a @GtkScrolledWindow@
    -> m ()
scrolledWindowUnsetPlacement scrolledWindow = liftIO $ do
    scrolledWindow' <- unsafeManagedPtrCastPtr scrolledWindow
    gtk_scrolled_window_unset_placement scrolledWindow'
    touchManagedPtr scrolledWindow
    return ()

#if defined(ENABLE_OVERLOADING)
data ScrolledWindowUnsetPlacementMethodInfo
instance (signature ~ (m ()), MonadIO m, IsScrolledWindow a) => O.OverloadedMethod ScrolledWindowUnsetPlacementMethodInfo a signature where
    overloadedMethod = scrolledWindowUnsetPlacement

instance O.OverloadedMethodInfo ScrolledWindowUnsetPlacementMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.ScrolledWindow.scrolledWindowUnsetPlacement",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-ScrolledWindow.html#v:scrolledWindowUnsetPlacement"
        })


#endif


