/*========================== begin_copyright_notice ============================

Copyright (C) 2023 Intel Corporation

SPDX-License-Identifier: MIT

============================= end_copyright_notice ===========================*/
#pragma once

#include "GenIntrinsicEnum.h"
#include <array>

namespace IGC
{

struct IntrinsicEntry
{
    llvm::GenISAIntrinsic::ID id;
    // the number of characters in the common prefix with other intrinsics
    unsigned num;
    // the lookup name
    const char* str;
};

constexpr auto GetIntrinsicLookupTable()
{
    constexpr unsigned numIntrinsicEntries = 446;
    std::array<IntrinsicEntry, numIntrinsicEntries> lookupTable =
    { {
        { llvm::GenISAIntrinsic::ID::GenISA_2fto2bf, 0, "2fto2bf@" },
        { llvm::GenISAIntrinsic::ID::GenISA_AcceptHitAndEndSearchHL, 1, "AcceptHitAndEndSearchHL@" },
        { llvm::GenISAIntrinsic::ID::GenISA_AllocaNumber, 6, "AllocaNumber@" },
        { llvm::GenISAIntrinsic::ID::GenISA_AllocateRayQuery, 6, "AllocateRayQuery@" },
        { llvm::GenISAIntrinsic::ID::GenISA_AsyncStackID, 10, "AsyncStackID@" },
        { llvm::GenISAIntrinsic::ID::GenISA_AsyncStackPtr, 13, "AsyncStackPtr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_AsyncStackPtrPlaceHolder, 13, "AsyncStackPtrPlaceHolder@" },
        { llvm::GenISAIntrinsic::ID::GenISA_BindlessThreadDispatch, 0, "BindlessThreadDispatch@" },
        { llvm::GenISAIntrinsic::ID::GenISA_CallShaderHL, 2, "CallShaderHL@" },
        { llvm::GenISAIntrinsic::ID::GenISA_CatchAllDebugLine, 2, "CatchAllDebugLine@" },
        { llvm::GenISAIntrinsic::ID::GenISA_ContinuationSignpost, 3, "ContinuationSignpost@" },
        { llvm::GenISAIntrinsic::ID::GenISA_ConvertRayQueryHandleToRTStackPointer, 3, "ConvertRayQueryHandleToRTStackPointer@" },
        { llvm::GenISAIntrinsic::ID::GenISA_DCL_DSCntrlPtInputVec, 6, "DCL_DSCntrlPtInputVec@" },
        { llvm::GenISAIntrinsic::ID::GenISA_DCL_DSInputTessFactor, 6, "DCL_DSInputTessFactor@" },
        { llvm::GenISAIntrinsic::ID::GenISA_DCL_DSPatchConstInputVec, 6, "DCL_DSPatchConstInputVec@" },
        { llvm::GenISAIntrinsic::ID::GenISA_DCL_GSinputVec, 6, "DCL_GSinputVec@" },
        { llvm::GenISAIntrinsic::ID::GenISA_DCL_GSsystemValue, 6, "DCL_GSsystemValue@" },
        { llvm::GenISAIntrinsic::ID::GenISA_DCL_HSControlPointID, 6, "DCL_HSControlPointID@" },
        { llvm::GenISAIntrinsic::ID::GenISA_DCL_HSOutputCntrlPtInputVec, 6, "DCL_HSOutputCntrlPtInputVec@" },
        { llvm::GenISAIntrinsic::ID::GenISA_DCL_HSPatchConstInputVec, 6, "DCL_HSPatchConstInputVec@" },
        { llvm::GenISAIntrinsic::ID::GenISA_DCL_HSinputVec, 6, "DCL_HSinputVec@" },
        { llvm::GenISAIntrinsic::ID::GenISA_DCL_ShaderInputVec, 5, "DCL_ShaderInputVec@" },
        { llvm::GenISAIntrinsic::ID::GenISA_DCL_SystemValue, 5, "DCL_SystemValue@" },
        { llvm::GenISAIntrinsic::ID::GenISA_DCL_input, 9, "DCL_input@" },
        { llvm::GenISAIntrinsic::ID::GenISA_DCL_inputVec, 9, "DCL_inputVec@" },
        { llvm::GenISAIntrinsic::ID::GenISA_DispatchDimensions, 8, "DispatchDimensions@" },
        { llvm::GenISAIntrinsic::ID::GenISA_DispatchRayIndex, 8, "DispatchRayIndex@" },
        { llvm::GenISAIntrinsic::ID::GenISA_EmitHitAttributes, 1, "EmitHitAttributes@" },
        { llvm::GenISAIntrinsic::ID::GenISA_EndPrimitive, 1, "EndPrimitive@" },
        { llvm::GenISAIntrinsic::ID::GenISA_FPBinaryOperator, 1, "FPBinaryOperator@" },
        { llvm::GenISAIntrinsic::ID::GenISA_FillValue, 1, "FillValue@" },
        { llvm::GenISAIntrinsic::ID::GenISA_GetBufferPtr, 3, "GetBufferPtr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_GetGlobalBufferArg, 3, "GetGlobalBufferArg@" },
        { llvm::GenISAIntrinsic::ID::GenISA_GetImplicitBufferPtr, 3, "GetImplicitBufferPtr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_GetLocalIdBufferPtr, 3, "GetLocalIdBufferPtr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_GetPixelMask, 3, "GetPixelMask@" },
        { llvm::GenISAIntrinsic::ID::GenISA_GetShaderRecordPtr, 3, "GetShaderRecordPtr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_GlobalBufferPointer, 6, "GlobalBufferPointer@" },
        { llvm::GenISAIntrinsic::ID::GenISA_GlobalQueuePointer, 6, "GlobalQueuePointer@" },
        { llvm::GenISAIntrinsic::ID::GenISA_GlobalRootSignatureValue, 6, "GlobalRootSignatureValue@" },
        { llvm::GenISAIntrinsic::ID::GenISA_GradientX, 9, "GradientX@" },
        { llvm::GenISAIntrinsic::ID::GenISA_GradientXfine, 9, "GradientXfine@" },
        { llvm::GenISAIntrinsic::ID::GenISA_GradientY, 9, "GradientY@" },
        { llvm::GenISAIntrinsic::ID::GenISA_GradientYfine, 9, "GradientYfine@" },
        { llvm::GenISAIntrinsic::ID::GenISA_GsCutControlHeader, 2, "GsCutControlHeader@" },
        { llvm::GenISAIntrinsic::ID::GenISA_GsStreamHeader, 2, "GsStreamHeader@" },
        { llvm::GenISAIntrinsic::ID::GenISA_HDCCCSFastClear, 3, "HDCCCSFastClear@" },
        { llvm::GenISAIntrinsic::ID::GenISA_HDCuncompressedwrite, 3, "HDCuncompressedwrite@" },
        { llvm::GenISAIntrinsic::ID::GenISA_HSURBPatchHeaderRead, 1, "HSURBPatchHeaderRead@" },
        { llvm::GenISAIntrinsic::ID::GenISA_HitKind, 1, "HitKind@" },
        { llvm::GenISAIntrinsic::ID::GenISA_IEEE_Divide, 5, "IEEE_Divide@" },
        { llvm::GenISAIntrinsic::ID::GenISA_IEEE_Sqrt, 5, "IEEE_Sqrt@" },
        { llvm::GenISAIntrinsic::ID::GenISA_IgnoreHitHL, 1, "IgnoreHitHL@" },
        { llvm::GenISAIntrinsic::ID::GenISA_InitDiscardMask, 2, "InitDiscardMask@" },
        { llvm::GenISAIntrinsic::ID::GenISA_InlinedData, 2, "InlinedData@" },
        { llvm::GenISAIntrinsic::ID::GenISA_InnerScalarTessFactors, 2, "InnerScalarTessFactors@" },
        { llvm::GenISAIntrinsic::ID::GenISA_Interpolant, 9, "Interpolant@" },
        { llvm::GenISAIntrinsic::ID::GenISA_Interpolate, 11, "Interpolate@" },
        { llvm::GenISAIntrinsic::ID::GenISA_Interpolate2, 11, "Interpolate2@" },
        { llvm::GenISAIntrinsic::ID::GenISA_IsHelperInvocation, 1, "IsHelperInvocation@" },
        { llvm::GenISAIntrinsic::ID::GenISA_LSC2DBlockCopyAddrPayload, 11, "LSC2DBlockCopyAddrPayload@" },
        { llvm::GenISAIntrinsic::ID::GenISA_LSC2DBlockCreateAddrPayload, 11, "LSC2DBlockCreateAddrPayload@" },
        { llvm::GenISAIntrinsic::ID::GenISA_LSC2DBlockPrefetch, 18, "LSC2DBlockPrefetch@" },
        { llvm::GenISAIntrinsic::ID::GenISA_LSC2DBlockPrefetchAddrPayload, 18, "LSC2DBlockPrefetchAddrPayload@" },
        { llvm::GenISAIntrinsic::ID::GenISA_LSC2DBlockRead, 14, "LSC2DBlockRead@" },
        { llvm::GenISAIntrinsic::ID::GenISA_LSC2DBlockReadAddrPayload, 14, "LSC2DBlockReadAddrPayload@" },
        { llvm::GenISAIntrinsic::ID::GenISA_LSC2DBlockSetAddrPayloadField, 10, "LSC2DBlockSetAddrPayloadField@" },
        { llvm::GenISAIntrinsic::ID::GenISA_LSC2DBlockWrite, 15, "LSC2DBlockWrite@" },
        { llvm::GenISAIntrinsic::ID::GenISA_LSC2DBlockWriteAddrPayload, 15, "LSC2DBlockWriteAddrPayload@" },
        { llvm::GenISAIntrinsic::ID::GenISA_LSCAtomicFP32, 11, "LSCAtomicFP32@" },
        { llvm::GenISAIntrinsic::ID::GenISA_LSCAtomicFP64, 11, "LSCAtomicFP64@" },
        { llvm::GenISAIntrinsic::ID::GenISA_LSCAtomicInts, 9, "LSCAtomicInts@" },
        { llvm::GenISAIntrinsic::ID::GenISA_LSCFence, 3, "LSCFence@" },
        { llvm::GenISAIntrinsic::ID::GenISA_LSCLoad, 7, "LSCLoad@" },
        { llvm::GenISAIntrinsic::ID::GenISA_LSCLoadBlock, 7, "LSCLoadBlock@" },
        { llvm::GenISAIntrinsic::ID::GenISA_LSCLoadCmask, 7, "LSCLoadCmask@" },
        { llvm::GenISAIntrinsic::ID::GenISA_LSCLoadStatus, 7, "LSCLoadStatus@" },
        { llvm::GenISAIntrinsic::ID::GenISA_LSCLoadWithSideEffects, 7, "LSCLoadWithSideEffects@" },
        { llvm::GenISAIntrinsic::ID::GenISA_LSCPrefetch, 3, "LSCPrefetch@" },
        { llvm::GenISAIntrinsic::ID::GenISA_LSCSimdBlockPrefetch, 4, "LSCSimdBlockPrefetch@" },
        { llvm::GenISAIntrinsic::ID::GenISA_LSCStore, 8, "LSCStore@" },
        { llvm::GenISAIntrinsic::ID::GenISA_LSCStoreBlock, 8, "LSCStoreBlock@" },
        { llvm::GenISAIntrinsic::ID::GenISA_LSCStoreCmask, 8, "LSCStoreCmask@" },
        { llvm::GenISAIntrinsic::ID::GenISA_LocalBufferPointer, 5, "LocalBufferPointer@" },
        { llvm::GenISAIntrinsic::ID::GenISA_LocalRootSignatureValue, 5, "LocalRootSignatureValue@" },
        { llvm::GenISAIntrinsic::ID::GenISA_MediaBlockRead, 12, "MediaBlockRead@" },
        { llvm::GenISAIntrinsic::ID::GenISA_MediaBlockRectangleRead, 12, "MediaBlockRectangleRead@" },
        { llvm::GenISAIntrinsic::ID::GenISA_MediaBlockWrite, 10, "MediaBlockWrite@" },
        { llvm::GenISAIntrinsic::ID::GenISA_OUTPUT, 6, "OUTPUT@" },
        { llvm::GenISAIntrinsic::ID::GenISA_OUTPUTGS, 6, "OUTPUTGS@" },
        { llvm::GenISAIntrinsic::ID::GenISA_OuterScalarTessFactors, 3, "OuterScalarTessFactors@" },
        { llvm::GenISAIntrinsic::ID::GenISA_OutputMeshPrimitiveData, 23, "OutputMeshPrimitiveData@" },
        { llvm::GenISAIntrinsic::ID::GenISA_OutputMeshPrimitiveDataInput, 23, "OutputMeshPrimitiveDataInput@" },
        { llvm::GenISAIntrinsic::ID::GenISA_OutputMeshSivDataInput, 10, "OutputMeshSivDataInput@" },
        { llvm::GenISAIntrinsic::ID::GenISA_OutputMeshVertexData, 20, "OutputMeshVertexData@" },
        { llvm::GenISAIntrinsic::ID::GenISA_OutputMeshVertexDataInput, 20, "OutputMeshVertexDataInput@" },
        { llvm::GenISAIntrinsic::ID::GenISA_OutputTaskData, 14, "OutputTaskData@" },
        { llvm::GenISAIntrinsic::ID::GenISA_OutputTaskDataInput, 14, "OutputTaskDataInput@" },
        { llvm::GenISAIntrinsic::ID::GenISA_OutputTessControlPoint, 7, "OutputTessControlPoint@" },
        { llvm::GenISAIntrinsic::ID::GenISA_PHASE_INPUT, 11, "PHASE_INPUT@" },
        { llvm::GenISAIntrinsic::ID::GenISA_PHASE_INPUTVEC, 11, "PHASE_INPUTVEC@" },
        { llvm::GenISAIntrinsic::ID::GenISA_PHASE_OUTPUT, 12, "PHASE_OUTPUT@" },
        { llvm::GenISAIntrinsic::ID::GenISA_PHASE_OUTPUTVEC, 12, "PHASE_OUTPUTVEC@" },
        { llvm::GenISAIntrinsic::ID::GenISA_PatchConstantOutput, 2, "PatchConstantOutput@" },
        { llvm::GenISAIntrinsic::ID::GenISA_PayloadPtr, 2, "PayloadPtr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_PixelPositionX, 13, "PixelPositionX@" },
        { llvm::GenISAIntrinsic::ID::GenISA_PixelPositionY, 13, "PixelPositionY@" },
        { llvm::GenISAIntrinsic::ID::GenISA_PredicatedLoad, 10, "PredicatedLoad@" },
        { llvm::GenISAIntrinsic::ID::GenISA_PredicatedStore, 10, "PredicatedStore@" },
        { llvm::GenISAIntrinsic::ID::GenISA_PreemptionDisable, 10, "PreemptionDisable@" },
        { llvm::GenISAIntrinsic::ID::GenISA_PreemptionEnable, 10, "PreemptionEnable@" },
        { llvm::GenISAIntrinsic::ID::GenISA_PullCentroidBarys, 4, "PullCentroidBarys@" },
        { llvm::GenISAIntrinsic::ID::GenISA_PullSampleIndexBarys, 5, "PullSampleIndexBarys@" },
        { llvm::GenISAIntrinsic::ID::GenISA_PullSnappedBarys, 5, "PullSnappedBarys@" },
        { llvm::GenISAIntrinsic::ID::GenISA_QuadPrefix, 0, "QuadPrefix@" },
        { llvm::GenISAIntrinsic::ID::GenISA_ROUNDNE, 1, "ROUNDNE@" },
        { llvm::GenISAIntrinsic::ID::GenISA_RTDualBlendSource, 2, "RTDualBlendSource@" },
        { llvm::GenISAIntrinsic::ID::GenISA_RTStatefulBTIAndOffset, 2, "RTStatefulBTIAndOffset@" },
        { llvm::GenISAIntrinsic::ID::GenISA_RTWrite, 2, "RTWrite@" },
        { llvm::GenISAIntrinsic::ID::GenISA_RayInfo, 3, "RayInfo@" },
        { llvm::GenISAIntrinsic::ID::GenISA_RayQueryCheck, 8, "RayQueryCheck@" },
        { llvm::GenISAIntrinsic::ID::GenISA_RayQueryRelease, 8, "RayQueryRelease@" },
        { llvm::GenISAIntrinsic::ID::GenISA_RayTCurrent, 3, "RayTCurrent@" },
        { llvm::GenISAIntrinsic::ID::GenISA_ReadFromReservedArgSpace, 4, "ReadFromReservedArgSpace@" },
        { llvm::GenISAIntrinsic::ID::GenISA_ReadTraceRaySync, 4, "ReadTraceRaySync@" },
        { llvm::GenISAIntrinsic::ID::GenISA_RenderTargetRead, 16, "RenderTargetRead@" },
        { llvm::GenISAIntrinsic::ID::GenISA_RenderTargetReadSampleFreq, 16, "RenderTargetReadSampleFreq@" },
        { llvm::GenISAIntrinsic::ID::GenISA_ReportHitHL, 2, "ReportHitHL@" },
        { llvm::GenISAIntrinsic::ID::GenISA_RuntimeValue, 1, "RuntimeValue@" },
        { llvm::GenISAIntrinsic::ID::GenISA_SWHotZonePtr, 2, "SWHotZonePtr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_SWStackPtr, 2, "SWStackPtr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_SampleOffsetX, 12, "SampleOffsetX@" },
        { llvm::GenISAIntrinsic::ID::GenISA_SampleOffsetY, 12, "SampleOffsetY@" },
        { llvm::GenISAIntrinsic::ID::GenISA_SaveInReservedArgSpace, 2, "SaveInReservedArgSpace@" },
        { llvm::GenISAIntrinsic::ID::GenISA_SetDebugReg, 3, "SetDebugReg@" },
        { llvm::GenISAIntrinsic::ID::GenISA_SetGlobalBufferArg, 3, "SetGlobalBufferArg@" },
        { llvm::GenISAIntrinsic::ID::GenISA_SetImplicitBufferPtr, 3, "SetImplicitBufferPtr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_SetLocalIdBufferPtr, 3, "SetLocalIdBufferPtr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_SetStackCallsBaseAddress, 5, "SetStackCallsBaseAddress@" },
        { llvm::GenISAIntrinsic::ID::GenISA_SetStream, 5, "SetStream@" },
        { llvm::GenISAIntrinsic::ID::GenISA_ShadowMemoryToSyncStack, 1, "ShadowMemoryToSyncStack@" },
        { llvm::GenISAIntrinsic::ID::GenISA_SpillValue, 1, "SpillValue@" },
        { llvm::GenISAIntrinsic::ID::GenISA_StackAlloca, 5, "StackAlloca@" },
        { llvm::GenISAIntrinsic::ID::GenISA_StackIDRelease, 5, "StackIDRelease@" },
        { llvm::GenISAIntrinsic::ID::GenISA_StackSize, 5, "StackSize@" },
        { llvm::GenISAIntrinsic::ID::GenISA_SyncDispatchRaysSplitPoint, 4, "SyncDispatchRaysSplitPoint@" },
        { llvm::GenISAIntrinsic::ID::GenISA_SyncStackPtr, 9, "SyncStackPtr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_SyncStackToShadowMemory, 9, "SyncStackToShadowMemory@" },
        { llvm::GenISAIntrinsic::ID::GenISA_TraceRayAsync, 13, "TraceRayAsync@" },
        { llvm::GenISAIntrinsic::ID::GenISA_TraceRayAsyncHL, 13, "TraceRayAsyncHL@" },
        { llvm::GenISAIntrinsic::ID::GenISA_TraceRayInlineAbort, 14, "TraceRayInlineAbort@" },
        { llvm::GenISAIntrinsic::ID::GenISA_TraceRayInlineCandidateType, 15, "TraceRayInlineCandidateType@" },
        { llvm::GenISAIntrinsic::ID::GenISA_TraceRayInlineCommitNonOpaqueTriangleHit, 20, "TraceRayInlineCommitNonOpaqueTriangleHit@" },
        { llvm::GenISAIntrinsic::ID::GenISA_TraceRayInlineCommitProceduralPrimitiveHit, 20, "TraceRayInlineCommitProceduralPrimitiveHit@" },
        { llvm::GenISAIntrinsic::ID::GenISA_TraceRayInlineCommittedStatus, 20, "TraceRayInlineCommittedStatus@" },
        { llvm::GenISAIntrinsic::ID::GenISA_TraceRayInlineHL, 14, "TraceRayInlineHL@" },
        { llvm::GenISAIntrinsic::ID::GenISA_TraceRayInlineRayInfo, 14, "TraceRayInlineRayInfo@" },
        { llvm::GenISAIntrinsic::ID::GenISA_TraceRaySync, 12, "TraceRaySync@" },
        { llvm::GenISAIntrinsic::ID::GenISA_TraceRaySyncProceed, 19, "TraceRaySyncProceed@" },
        { llvm::GenISAIntrinsic::ID::GenISA_TraceRaySyncProceedHL, 19, "TraceRaySyncProceedHL@" },
        { llvm::GenISAIntrinsic::ID::GenISA_URBRead, 7, "URBRead@" },
        { llvm::GenISAIntrinsic::ID::GenISA_URBReadOutput, 7, "URBReadOutput@" },
        { llvm::GenISAIntrinsic::ID::GenISA_URBWrite, 3, "URBWrite@" },
        { llvm::GenISAIntrinsic::ID::GenISA_UnmaskedRegionBegin, 14, "UnmaskedRegionBegin@" },
        { llvm::GenISAIntrinsic::ID::GenISA_UnmaskedRegionEnd, 14, "UnmaskedRegionEnd@" },
        { llvm::GenISAIntrinsic::ID::GenISA_UpdateDiscardMask, 1, "UpdateDiscardMask@" },
        { llvm::GenISAIntrinsic::ID::GenISA_VLAStackAlloca, 0, "VLAStackAlloca@" },
        { llvm::GenISAIntrinsic::ID::GenISA_WaveAll, 4, "WaveAll@" },
        { llvm::GenISAIntrinsic::ID::GenISA_WaveBallot, 5, "WaveBallot@" },
        { llvm::GenISAIntrinsic::ID::GenISA_WaveBroadcast, 5, "WaveBroadcast@" },
        { llvm::GenISAIntrinsic::ID::GenISA_WaveClustered, 13, "WaveClustered@" },
        { llvm::GenISAIntrinsic::ID::GenISA_WaveClusteredBallot, 14, "WaveClusteredBallot@" },
        { llvm::GenISAIntrinsic::ID::GenISA_WaveClusteredBroadcast, 14, "WaveClusteredBroadcast@" },
        { llvm::GenISAIntrinsic::ID::GenISA_WaveClusteredInterleave, 13, "WaveClusteredInterleave@" },
        { llvm::GenISAIntrinsic::ID::GenISA_WaveClusteredPrefix, 13, "WaveClusteredPrefix@" },
        { llvm::GenISAIntrinsic::ID::GenISA_WaveInterleave, 6, "WaveInterleave@" },
        { llvm::GenISAIntrinsic::ID::GenISA_WaveInverseBallot, 6, "WaveInverseBallot@" },
        { llvm::GenISAIntrinsic::ID::GenISA_WavePrefix, 4, "WavePrefix@" },
        { llvm::GenISAIntrinsic::ID::GenISA_WaveShuffleIndex, 4, "WaveShuffleIndex@" },
        { llvm::GenISAIntrinsic::ID::GenISA_WorkGroupAny, 1, "WorkGroupAny@" },
        { llvm::GenISAIntrinsic::ID::GenISA_add_pair, 4, "add_pair@" },
        { llvm::GenISAIntrinsic::ID::GenISA_add_rte, 6, "add_rte@" },
        { llvm::GenISAIntrinsic::ID::GenISA_add_rtn, 6, "add_rtn@" },
        { llvm::GenISAIntrinsic::ID::GenISA_add_rtp, 6, "add_rtp@" },
        { llvm::GenISAIntrinsic::ID::GenISA_add_rtz, 6, "add_rtz@" },
        { llvm::GenISAIntrinsic::ID::GenISA_assume_uniform, 1, "assume_uniform@" },
        { llvm::GenISAIntrinsic::ID::GenISA_atomiccounterinc, 13, "atomiccounterinc@" },
        { llvm::GenISAIntrinsic::ID::GenISA_atomiccounterpredec, 13, "atomiccounterpredec@" },
        { llvm::GenISAIntrinsic::ID::GenISA_bf8tohf, 2, "bf8tohf@" },
        { llvm::GenISAIntrinsic::ID::GenISA_bfi, 2, "bfi@" },
        { llvm::GenISAIntrinsic::ID::GenISA_bfn, 2, "bfn@" },
        { llvm::GenISAIntrinsic::ID::GenISA_bfrev, 2, "bfrev@" },
        { llvm::GenISAIntrinsic::ID::GenISA_bftof, 2, "bftof@" },
        { llvm::GenISAIntrinsic::ID::GenISA_bitcastfromstruct, 7, "bitcastfromstruct@" },
        { llvm::GenISAIntrinsic::ID::GenISA_bitcasttostruct, 7, "bitcasttostruct@" },
        { llvm::GenISAIntrinsic::ID::GenISA_broadcastMessagePhase, 21, "broadcastMessagePhase@" },
        { llvm::GenISAIntrinsic::ID::GenISA_broadcastMessagePhaseV, 21, "broadcastMessagePhaseV@" },
        { llvm::GenISAIntrinsic::ID::GenISA_cmpSADs, 3, "cmpSADs@" },
        { llvm::GenISAIntrinsic::ID::GenISA_cmpxchgatomicstructured, 3, "cmpxchgatomicstructured@" },
        { llvm::GenISAIntrinsic::ID::GenISA_createMessagePhases, 19, "createMessagePhases@" },
        { llvm::GenISAIntrinsic::ID::GenISA_createMessagePhasesNoInit, 25, "createMessagePhasesNoInit@" },
        { llvm::GenISAIntrinsic::ID::GenISA_createMessagePhasesNoInitV, 25, "createMessagePhasesNoInitV@" },
        { llvm::GenISAIntrinsic::ID::GenISA_createMessagePhasesV, 19, "createMessagePhasesV@" },
        { llvm::GenISAIntrinsic::ID::GenISA_cycleCounter, 1, "cycleCounter@" },
        { llvm::GenISAIntrinsic::ID::GenISA_disable_ieee_exception_trap, 3, "disable_ieee_exception_trap@" },
        { llvm::GenISAIntrinsic::ID::GenISA_discard, 3, "discard@" },
        { llvm::GenISAIntrinsic::ID::GenISA_dp4a_ss, 6, "dp4a_ss@" },
        { llvm::GenISAIntrinsic::ID::GenISA_dp4a_su, 6, "dp4a_su@" },
        { llvm::GenISAIntrinsic::ID::GenISA_dp4a_us, 6, "dp4a_us@" },
        { llvm::GenISAIntrinsic::ID::GenISA_dp4a_uu, 6, "dp4a_uu@" },
        { llvm::GenISAIntrinsic::ID::GenISA_dpas, 2, "dpas@" },
        { llvm::GenISAIntrinsic::ID::GenISA_dual_subslice_id, 2, "dual_subslice_id@" },
        { llvm::GenISAIntrinsic::ID::GenISA_dummyInst, 9, "dummyInst@" },
        { llvm::GenISAIntrinsic::ID::GenISA_dummyInstID, 9, "dummyInstID@" },
        { llvm::GenISAIntrinsic::ID::GenISA_dwordatomicstructured, 1, "dwordatomicstructured@" },
        { llvm::GenISAIntrinsic::ID::GenISA_enable_ieee_exception_trap, 1, "enable_ieee_exception_trap@" },
        { llvm::GenISAIntrinsic::ID::GenISA_eu_id, 3, "eu_id@" },
        { llvm::GenISAIntrinsic::ID::GenISA_eu_thread_id, 10, "eu_thread_id@" },
        { llvm::GenISAIntrinsic::ID::GenISA_eu_thread_pause, 10, "eu_thread_pause@" },
        { llvm::GenISAIntrinsic::ID::GenISA_evaluateSampler, 1, "evaluateSampler@" },
        { llvm::GenISAIntrinsic::ID::GenISA_extractMVAndSAD, 1, "extractMVAndSAD@" },
        { llvm::GenISAIntrinsic::ID::GenISA_f32tof16_rtz, 1, "f32tof16_rtz@" },
        { llvm::GenISAIntrinsic::ID::GenISA_fcmpxchgatomicraw, 17, "fcmpxchgatomicraw@" },
        { llvm::GenISAIntrinsic::ID::GenISA_fcmpxchgatomicrawA64, 17, "fcmpxchgatomicrawA64@" },
        { llvm::GenISAIntrinsic::ID::GenISA_fcmpxchgatomicstructured, 14, "fcmpxchgatomicstructured@" },
        { llvm::GenISAIntrinsic::ID::GenISA_fcmpxchgatomictyped, 14, "fcmpxchgatomictyped@" },
        { llvm::GenISAIntrinsic::ID::GenISA_firstbitHi, 8, "firstbitHi@" },
        { llvm::GenISAIntrinsic::ID::GenISA_firstbitLo, 8, "firstbitLo@" },
        { llvm::GenISAIntrinsic::ID::GenISA_firstbitShi, 8, "firstbitShi@" },
        { llvm::GenISAIntrinsic::ID::GenISA_floatatomicraw, 14, "floatatomicraw@" },
        { llvm::GenISAIntrinsic::ID::GenISA_floatatomicrawA64, 14, "floatatomicrawA64@" },
        { llvm::GenISAIntrinsic::ID::GenISA_floatatomicstructured, 11, "floatatomicstructured@" },
        { llvm::GenISAIntrinsic::ID::GenISA_floatatomictyped, 11, "floatatomictyped@" },
        { llvm::GenISAIntrinsic::ID::GenISA_flushsampler, 2, "flushsampler@" },
        { llvm::GenISAIntrinsic::ID::GenISA_fma_rte, 6, "fma_rte@" },
        { llvm::GenISAIntrinsic::ID::GenISA_fma_rtn, 6, "fma_rtn@" },
        { llvm::GenISAIntrinsic::ID::GenISA_fma_rtp, 6, "fma_rtp@" },
        { llvm::GenISAIntrinsic::ID::GenISA_fma_rtz, 6, "fma_rtz@" },
        { llvm::GenISAIntrinsic::ID::GenISA_frc, 1, "frc@" },
        { llvm::GenISAIntrinsic::ID::GenISA_fsat, 1, "fsat@" },
        { llvm::GenISAIntrinsic::ID::GenISA_ftobf, 3, "ftobf@" },
        { llvm::GenISAIntrinsic::ID::GenISA_ftof_rte, 7, "ftof_rte@" },
        { llvm::GenISAIntrinsic::ID::GenISA_ftof_rtn, 7, "ftof_rtn@" },
        { llvm::GenISAIntrinsic::ID::GenISA_ftof_rtp, 7, "ftof_rtp@" },
        { llvm::GenISAIntrinsic::ID::GenISA_ftof_rtz, 7, "ftof_rtz@" },
        { llvm::GenISAIntrinsic::ID::GenISA_ftoi_rte, 7, "ftoi_rte@" },
        { llvm::GenISAIntrinsic::ID::GenISA_ftoi_rtn, 7, "ftoi_rtn@" },
        { llvm::GenISAIntrinsic::ID::GenISA_ftoi_rtp, 7, "ftoi_rtp@" },
        { llvm::GenISAIntrinsic::ID::GenISA_ftotf32, 3, "ftotf32@" },
        { llvm::GenISAIntrinsic::ID::GenISA_ftoui_rte, 8, "ftoui_rte@" },
        { llvm::GenISAIntrinsic::ID::GenISA_ftoui_rtn, 8, "ftoui_rtn@" },
        { llvm::GenISAIntrinsic::ID::GenISA_ftoui_rtp, 8, "ftoui_rtp@" },
        { llvm::GenISAIntrinsic::ID::GenISA_gather4BPOptr, 8, "gather4BPOptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_gather4Bptr, 8, "gather4Bptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_gather4Cptr, 7, "gather4Cptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_gather4ICPOptr, 9, "gather4ICPOptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_gather4ICptr, 9, "gather4ICptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_gather4IPOptr, 8, "gather4IPOptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_gather4Iptr, 8, "gather4Iptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_gather4LCPOptr, 9, "gather4LCPOptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_gather4LCptr, 9, "gather4LCptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_gather4LPOptr, 8, "gather4LPOptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_gather4Lptr, 8, "gather4Lptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_gather4POCptr, 9, "gather4POCptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_gather4POPackedBptr, 15, "gather4POPackedBptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_gather4POPackedCptr, 15, "gather4POPackedCptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_gather4POPackedICptr, 16, "gather4POPackedICptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_gather4POPackedIptr, 16, "gather4POPackedIptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_gather4POPackedLCptr, 16, "gather4POPackedLCptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_gather4POPackedLptr, 16, "gather4POPackedLptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_gather4POPackedptr, 15, "gather4POPackedptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_gather4POptr, 9, "gather4POptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_gather4ptr, 7, "gather4ptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_getAssertBufferPtr, 3, "getAssertBufferPtr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_getEnqueuedLocalSize, 3, "getEnqueuedLocalSize@" },
        { llvm::GenISAIntrinsic::ID::GenISA_getGlobalOffset, 9, "getGlobalOffset@" },
        { llvm::GenISAIntrinsic::ID::GenISA_getGlobalSize, 9, "getGlobalSize@" },
        { llvm::GenISAIntrinsic::ID::GenISA_getLocalID_X, 11, "getLocalID_X@" },
        { llvm::GenISAIntrinsic::ID::GenISA_getLocalID_Y, 11, "getLocalID_Y@" },
        { llvm::GenISAIntrinsic::ID::GenISA_getLocalID_Z, 11, "getLocalID_Z@" },
        { llvm::GenISAIntrinsic::ID::GenISA_getLocalSize, 8, "getLocalSize@" },
        { llvm::GenISAIntrinsic::ID::GenISA_getMessagePhase, 15, "getMessagePhase@" },
        { llvm::GenISAIntrinsic::ID::GenISA_getMessagePhaseV, 15, "getMessagePhaseV@" },
        { llvm::GenISAIntrinsic::ID::GenISA_getMessagePhaseX, 16, "getMessagePhaseX@" },
        { llvm::GenISAIntrinsic::ID::GenISA_getMessagePhaseXV, 16, "getMessagePhaseXV@" },
        { llvm::GenISAIntrinsic::ID::GenISA_getNumWorkGroups, 3, "getNumWorkGroups@" },
        { llvm::GenISAIntrinsic::ID::GenISA_getPayloadHeader, 4, "getPayloadHeader@" },
        { llvm::GenISAIntrinsic::ID::GenISA_getPrintfBuffer, 6, "getPrintfBuffer@" },
        { llvm::GenISAIntrinsic::ID::GenISA_getPrivateBase, 6, "getPrivateBase@" },
        { llvm::GenISAIntrinsic::ID::GenISA_getR0, 4, "getR0@" },
        { llvm::GenISAIntrinsic::ID::GenISA_getRtGlobalBufferPtr, 4, "getRtGlobalBufferPtr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_getSR0, 6, "getSR0@" },
        { llvm::GenISAIntrinsic::ID::GenISA_getSR0_0, 6, "getSR0_0@" },
        { llvm::GenISAIntrinsic::ID::GenISA_getStackPointer, 8, "getStackPointer@" },
        { llvm::GenISAIntrinsic::ID::GenISA_getStackSizePerThread, 8, "getStackSizePerThread@" },
        { llvm::GenISAIntrinsic::ID::GenISA_getStageInGridOrigin, 14, "getStageInGridOrigin@" },
        { llvm::GenISAIntrinsic::ID::GenISA_getStageInGridSize, 14, "getStageInGridSize@" },
        { llvm::GenISAIntrinsic::ID::GenISA_getSyncBuffer, 4, "getSyncBuffer@" },
        { llvm::GenISAIntrinsic::ID::GenISA_getWorkDim, 3, "getWorkDim@" },
        { llvm::GenISAIntrinsic::ID::GenISA_globalSync, 1, "globalSync@" },
        { llvm::GenISAIntrinsic::ID::GenISA_hf8tohf, 2, "hf8tohf@" },
        { llvm::GenISAIntrinsic::ID::GenISA_hftobf8, 4, "hftobf8@" },
        { llvm::GenISAIntrinsic::ID::GenISA_hftohf8, 4, "hftohf8@" },
        { llvm::GenISAIntrinsic::ID::GenISA_hw_thread_id, 12, "hw_thread_id@" },
        { llvm::GenISAIntrinsic::ID::GenISA_hw_thread_id_alloca, 12, "hw_thread_id_alloca@" },
        { llvm::GenISAIntrinsic::ID::GenISA_ibfe, 1, "ibfe@" },
        { llvm::GenISAIntrinsic::ID::GenISA_icmpxchgatomicraw, 17, "icmpxchgatomicraw@" },
        { llvm::GenISAIntrinsic::ID::GenISA_icmpxchgatomicrawA64, 17, "icmpxchgatomicrawA64@" },
        { llvm::GenISAIntrinsic::ID::GenISA_icmpxchgatomictyped, 14, "icmpxchgatomictyped@" },
        { llvm::GenISAIntrinsic::ID::GenISA_imulH, 1, "imulH@" },
        { llvm::GenISAIntrinsic::ID::GenISA_intatomicraw, 12, "intatomicraw@" },
        { llvm::GenISAIntrinsic::ID::GenISA_intatomicrawA64, 12, "intatomicrawA64@" },
        { llvm::GenISAIntrinsic::ID::GenISA_intatomicrawsinglelane, 12, "intatomicrawsinglelane@" },
        { llvm::GenISAIntrinsic::ID::GenISA_intatomictyped, 9, "intatomictyped@" },
        { llvm::GenISAIntrinsic::ID::GenISA_inv, 2, "inv@" },
        { llvm::GenISAIntrinsic::ID::GenISA_is_uniform, 2, "is_uniform@" },
        { llvm::GenISAIntrinsic::ID::GenISA_isat, 2, "isat@" },
        { llvm::GenISAIntrinsic::ID::GenISA_itof_rtn, 7, "itof_rtn@" },
        { llvm::GenISAIntrinsic::ID::GenISA_itof_rtp, 7, "itof_rtp@" },
        { llvm::GenISAIntrinsic::ID::GenISA_itof_rtz, 7, "itof_rtz@" },
        { llvm::GenISAIntrinsic::ID::GenISA_launder, 1, "launder@" },
        { llvm::GenISAIntrinsic::ID::GenISA_ldlptr, 2, "ldlptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_ldmcsptr, 3, "ldmcsptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_ldmsptr, 7, "ldmsptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_ldmsptr16bit, 7, "ldmsptr16bit@" },
        { llvm::GenISAIntrinsic::ID::GenISA_ldptr, 2, "ldptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_ldraw_indexed, 5, "ldraw_indexed@" },
        { llvm::GenISAIntrinsic::ID::GenISA_ldrawvector_indexed, 5, "ldrawvector_indexed@" },
        { llvm::GenISAIntrinsic::ID::GenISA_ldstructured, 2, "ldstructured@" },
        { llvm::GenISAIntrinsic::ID::GenISA_lodptr, 2, "lodptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_logical_subslice_id, 2, "logical_subslice_id@" },
        { llvm::GenISAIntrinsic::ID::GenISA_memoryfence, 1, "memoryfence@" },
        { llvm::GenISAIntrinsic::ID::GenISA_mov_identity, 3, "mov_identity@" },
        { llvm::GenISAIntrinsic::ID::GenISA_movcr, 3, "movcr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_movflag, 3, "movflag@" },
        { llvm::GenISAIntrinsic::ID::GenISA_mul_pair, 4, "mul_pair@" },
        { llvm::GenISAIntrinsic::ID::GenISA_mul_rte, 6, "mul_rte@" },
        { llvm::GenISAIntrinsic::ID::GenISA_mul_rtn, 6, "mul_rtn@" },
        { llvm::GenISAIntrinsic::ID::GenISA_mul_rtp, 6, "mul_rtp@" },
        { llvm::GenISAIntrinsic::ID::GenISA_mul_rtz, 6, "mul_rtz@" },
        { llvm::GenISAIntrinsic::ID::GenISA_pair_to_ptr, 2, "pair_to_ptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_patchInstanceId, 2, "patchInstanceId@" },
        { llvm::GenISAIntrinsic::ID::GenISA_ptr_to_pair, 1, "ptr_to_pair@" },
        { llvm::GenISAIntrinsic::ID::GenISA_readsurfacetypeandformat, 2, "readsurfacetypeandformat@" },
        { llvm::GenISAIntrinsic::ID::GenISA_resinfoptr, 2, "resinfoptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_rsq, 1, "rsq@" },
        { llvm::GenISAIntrinsic::ID::GenISA_rt_swstack_offset, 1, "rt_swstack_offset@" },
        { llvm::GenISAIntrinsic::ID::GenISA_sampleBCMlodptr, 8, "sampleBCMlodptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_sampleBCptr, 8, "sampleBCptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_sampleBptr, 7, "sampleBptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_sampleCMlodptr, 7, "sampleCMlodptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_sampleCptr, 7, "sampleCptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_sampleDCMlodptr, 8, "sampleDCMlodptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_sampleDCptr, 8, "sampleDCptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_sampleDptr, 7, "sampleDptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_sampleKillPix, 6, "sampleKillPix@" },
        { llvm::GenISAIntrinsic::ID::GenISA_sampleLCptr, 7, "sampleLCptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_sampleLptr, 7, "sampleLptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_sampleMlodptr, 6, "sampleMlodptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_samplePOBptr, 8, "samplePOBptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_samplePOCptr, 8, "samplePOCptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_samplePODptr, 8, "samplePODptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_samplePOLCptr, 9, "samplePOLCptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_samplePOLptr, 9, "samplePOLptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_samplePOptr, 8, "samplePOptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_sampleinfoptr, 6, "sampleinfoptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_sampleptr, 6, "sampleptr@" },
        { llvm::GenISAIntrinsic::ID::GenISA_setMessagePhase, 15, "setMessagePhase@" },
        { llvm::GenISAIntrinsic::ID::GenISA_setMessagePhaseV, 15, "setMessagePhaseV@" },
        { llvm::GenISAIntrinsic::ID::GenISA_setMessagePhaseX, 16, "setMessagePhaseX@" },
        { llvm::GenISAIntrinsic::ID::GenISA_setMessagePhaseXV, 16, "setMessagePhaseXV@" },
        { llvm::GenISAIntrinsic::ID::GenISA_setMessagePhaseX_legacy, 16, "setMessagePhaseX_legacy@" },
        { llvm::GenISAIntrinsic::ID::GenISA_setMessagePhase_legacy, 15, "setMessagePhase_legacy@" },
        { llvm::GenISAIntrinsic::ID::GenISA_setSR0, 3, "setSR0@" },
        { llvm::GenISAIntrinsic::ID::GenISA_simdBlockRead, 13, "simdBlockRead@" },
        { llvm::GenISAIntrinsic::ID::GenISA_simdBlockReadBindless, 13, "simdBlockReadBindless@" },
        { llvm::GenISAIntrinsic::ID::GenISA_simdBlockWrite, 14, "simdBlockWrite@" },
        { llvm::GenISAIntrinsic::ID::GenISA_simdBlockWriteBindless, 14, "simdBlockWriteBindless@" },
        { llvm::GenISAIntrinsic::ID::GenISA_simdGetMessagePhase, 19, "simdGetMessagePhase@" },
        { llvm::GenISAIntrinsic::ID::GenISA_simdGetMessagePhaseV, 19, "simdGetMessagePhaseV@" },
        { llvm::GenISAIntrinsic::ID::GenISA_simdLaneId, 10, "simdLaneId@" },
        { llvm::GenISAIntrinsic::ID::GenISA_simdLaneIdReplicate, 10, "simdLaneIdReplicate@" },
        { llvm::GenISAIntrinsic::ID::GenISA_simdMediaBlockRead, 14, "simdMediaBlockRead@" },
        { llvm::GenISAIntrinsic::ID::GenISA_simdMediaBlockWrite, 14, "simdMediaBlockWrite@" },
        { llvm::GenISAIntrinsic::ID::GenISA_simdMediaRegionCopy, 9, "simdMediaRegionCopy@" },
        { llvm::GenISAIntrinsic::ID::GenISA_simdSetMessagePhase, 19, "simdSetMessagePhase@" },
        { llvm::GenISAIntrinsic::ID::GenISA_simdSetMessagePhaseV, 19, "simdSetMessagePhaseV@" },
        { llvm::GenISAIntrinsic::ID::GenISA_simdShuffleDown, 11, "simdShuffleDown@" },
        { llvm::GenISAIntrinsic::ID::GenISA_simdShuffleXor, 11, "simdShuffleXor@" },
        { llvm::GenISAIntrinsic::ID::GenISA_simdSize, 5, "simdSize@" },
        { llvm::GenISAIntrinsic::ID::GenISA_slice_id, 1, "slice_id@" },
        { llvm::GenISAIntrinsic::ID::GenISA_software_exception, 2, "software_exception@" },
        { llvm::GenISAIntrinsic::ID::GenISA_source_value, 2, "source_value@" },
        { llvm::GenISAIntrinsic::ID::GenISA_srnd_ftohf, 5, "srnd_ftohf@" },
        { llvm::GenISAIntrinsic::ID::GenISA_srnd_hftobf8, 5, "srnd_hftobf8@" },
        { llvm::GenISAIntrinsic::ID::GenISA_staticConstantPatchValue, 2, "staticConstantPatchValue@" },
        { llvm::GenISAIntrinsic::ID::GenISA_storeraw_indexed, 8, "storeraw_indexed@" },
        { llvm::GenISAIntrinsic::ID::GenISA_storerawvector_indexed, 8, "storerawvector_indexed@" },
        { llvm::GenISAIntrinsic::ID::GenISA_storestructured1, 15, "storestructured1@" },
        { llvm::GenISAIntrinsic::ID::GenISA_storestructured2, 15, "storestructured2@" },
        { llvm::GenISAIntrinsic::ID::GenISA_storestructured3, 15, "storestructured3@" },
        { llvm::GenISAIntrinsic::ID::GenISA_storestructured4, 15, "storestructured4@" },
        { llvm::GenISAIntrinsic::ID::GenISA_sub_group_dpas, 4, "sub_group_dpas@" },
        { llvm::GenISAIntrinsic::ID::GenISA_sub_pair, 4, "sub_pair@" },
        { llvm::GenISAIntrinsic::ID::GenISA_subslice_id, 3, "subslice_id@" },
        { llvm::GenISAIntrinsic::ID::GenISA_systemmemoryfence, 1, "systemmemoryfence@" },
        { llvm::GenISAIntrinsic::ID::GenISA_thread_exit, 6, "thread_exit@" },
        { llvm::GenISAIntrinsic::ID::GenISA_threadgroupbarrier, 18, "threadgroupbarrier@" },
        { llvm::GenISAIntrinsic::ID::GenISA_threadgroupbarrier_signal, 19, "threadgroupbarrier_signal@" },
        { llvm::GenISAIntrinsic::ID::GenISA_threadgroupbarrier_wait, 19, "threadgroupbarrier_wait@" },
        { llvm::GenISAIntrinsic::ID::GenISA_threadgroupnamedbarriers_signal, 25, "threadgroupnamedbarriers_signal@" },
        { llvm::GenISAIntrinsic::ID::GenISA_threadgroupnamedbarriers_wait, 25, "threadgroupnamedbarriers_wait@" },
        { llvm::GenISAIntrinsic::ID::GenISA_typedmemoryfence, 5, "typedmemoryfence@" },
        { llvm::GenISAIntrinsic::ID::GenISA_typedread, 9, "typedread@" },
        { llvm::GenISAIntrinsic::ID::GenISA_typedreadMS, 9, "typedreadMS@" },
        { llvm::GenISAIntrinsic::ID::GenISA_typedwrite, 10, "typedwrite@" },
        { llvm::GenISAIntrinsic::ID::GenISA_typedwriteMS, 10, "typedwriteMS@" },
        { llvm::GenISAIntrinsic::ID::GenISA_uaddc, 2, "uaddc@" },
        { llvm::GenISAIntrinsic::ID::GenISA_uavSerializeAll, 12, "uavSerializeAll@" },
        { llvm::GenISAIntrinsic::ID::GenISA_uavSerializeOnResID, 12, "uavSerializeOnResID@" },
        { llvm::GenISAIntrinsic::ID::GenISA_ubfe, 1, "ubfe@" },
        { llvm::GenISAIntrinsic::ID::GenISA_uitof_rtn, 8, "uitof_rtn@" },
        { llvm::GenISAIntrinsic::ID::GenISA_uitof_rtp, 8, "uitof_rtp@" },
        { llvm::GenISAIntrinsic::ID::GenISA_uitof_rtz, 8, "uitof_rtz@" },
        { llvm::GenISAIntrinsic::ID::GenISA_umulH, 1, "umulH@" },
        { llvm::GenISAIntrinsic::ID::GenISA_urbfence, 1, "urbfence@" },
        { llvm::GenISAIntrinsic::ID::GenISA_usat, 2, "usat@" },
        { llvm::GenISAIntrinsic::ID::GenISA_usubb, 2, "usubb@" },
        { llvm::GenISAIntrinsic::ID::GenISA_vaBoolCentroid, 6, "vaBoolCentroid@" },
        { llvm::GenISAIntrinsic::ID::GenISA_vaBoolSum, 6, "vaBoolSum@" },
        { llvm::GenISAIntrinsic::ID::GenISA_vaCentroid, 3, "vaCentroid@" },
        { llvm::GenISAIntrinsic::ID::GenISA_vaConvolve, 10, "vaConvolve@" },
        { llvm::GenISAIntrinsic::ID::GenISA_vaConvolveGRF_16x1, 17, "vaConvolveGRF_16x1@" },
        { llvm::GenISAIntrinsic::ID::GenISA_vaConvolveGRF_16x4, 17, "vaConvolveGRF_16x4@" },
        { llvm::GenISAIntrinsic::ID::GenISA_vaDilate, 2, "vaDilate@" },
        { llvm::GenISAIntrinsic::ID::GenISA_vaErode, 2, "vaErode@" },
        { llvm::GenISAIntrinsic::ID::GenISA_vaMinMax, 8, "vaMinMax@" },
        { llvm::GenISAIntrinsic::ID::GenISA_vaMinMaxFilter, 8, "vaMinMaxFilter@" },
        { llvm::GenISAIntrinsic::ID::GenISA_vectorUniform, 1, "vectorUniform@" },
        { llvm::GenISAIntrinsic::ID::GenISA_vmeSendFBR, 10, "vmeSendFBR@" },
        { llvm::GenISAIntrinsic::ID::GenISA_vmeSendFBR2, 10, "vmeSendFBR2@" },
        { llvm::GenISAIntrinsic::ID::GenISA_vmeSendIME, 10, "vmeSendIME@" },
        { llvm::GenISAIntrinsic::ID::GenISA_vmeSendIME2, 10, "vmeSendIME2@" },
        { llvm::GenISAIntrinsic::ID::GenISA_vmeSendSIC, 10, "vmeSendSIC@" },
        { llvm::GenISAIntrinsic::ID::GenISA_vmeSendSIC2, 10, "vmeSendSIC2@" },
        { llvm::GenISAIntrinsic::ID::GenISA_wavebarrier, 0, "wavebarrier@" }
    } };
    return lookupTable;
}

} // namespace IGC
