#ifndef SBK_KCHARMACROEXPANDERWRAPPER_H
#define SBK_KCHARMACROEXPANDERWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <kmacroexpander.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

class KCharMacroExpanderWrapper : public KCharMacroExpander
{
public:
    KCharMacroExpanderWrapper(::QChar c = QLatin1Char('%'));
    KCharMacroExpanderWrapper(const KCharMacroExpanderWrapper &) = delete;
    KCharMacroExpanderWrapper& operator=(const KCharMacroExpanderWrapper &) = delete;
    KCharMacroExpanderWrapper(KCharMacroExpanderWrapper &&) = delete;
    KCharMacroExpanderWrapper& operator=(KCharMacroExpanderWrapper &&) = delete;
    ~KCharMacroExpanderWrapper() override;

    int expandEscapedMacro(const ::QString & str, int pos, ::QStringList & ret) override;
    bool expandMacro(::QChar chr, ::QStringList & ret) override;
    static bool sbk_o_expandMacro(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QChar chr, ::QStringList & ret);
    int expandPlainMacro(const ::QString & str, int pos, ::QStringList & ret) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 3> m_PyMethodCache = {nullptr, nullptr, nullptr};
};

#endif // SBK_KCHARMACROEXPANDERWRAPPER_H
