
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kmacroexpander_wrapper.h"

// Argument includes
#include <QHash>
#include <QString>
#include <QStringList>
#include <qchar.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KMacroExpander_Type = nullptr;
static PyTypeObject *Sbk_KMacroExpander_TypeF(void)
{
    return _Sbk_KMacroExpander_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int Sbk_KMacroExpander_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNamespace("KMacroExpander");
    return -1;
}

static PyObject *Sbk_KMacroExpanderFunc_expandMacros(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "expandMacros", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKMacroExpander_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:expandMacros", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMacroExpander::expandMacros(QString,QHash<QChar,QString>,QChar=)->QString
    // 1: static KMacroExpander::expandMacros(QString,QHash<QChar,QStringList>,QChar=)->QString
    // 2: static KMacroExpander::expandMacros(QString,QHash<QString,QString>,QChar=)->QString
    // 3: static KMacroExpander::expandMacros(QString,QHash<QString,QStringList>,QChar=)->QString
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QHash_QString_QStringList_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 3; // expandMacros(QString,QHash<QString,QStringList>,QChar)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], (pyArgs[2])))) {
                overloadId = 3; // expandMacros(QString,QHash<QString,QStringList>,QChar)
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QHash_QString_QString_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // expandMacros(QString,QHash<QString,QString>,QChar)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], (pyArgs[2])))) {
                overloadId = 2; // expandMacros(QString,QHash<QString,QString>,QChar)
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QHash_QChar_QStringList_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // expandMacros(QString,QHash<QChar,QStringList>,QChar)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], (pyArgs[2])))) {
                overloadId = 1; // expandMacros(QString,QHash<QChar,QStringList>,QChar)
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QHash_QChar_QString_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // expandMacros(QString,QHash<QChar,QString>,QChar)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], (pyArgs[2])))) {
                overloadId = 0; // expandMacros(QString,QHash<QChar,QString>,QChar)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "expandMacros", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKMacroExpander_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // expandMacros(const QString &str, const QHash<QChar,QString> &map, QChar c)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"c", 2}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], (pyArgs[2]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "expandMacros", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKMacroExpander_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QHash<QChar,QString> cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QChar cppArg2 = QLatin1Char('%');
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // expandMacros(QString,QHash<QChar,QString>,QChar)
                QString cppResult = ::KMacroExpander::expandMacros(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
            }
            break;
        }
        case 1: // expandMacros(const QString &str, const QHash<QChar,QStringList> &map, QChar c)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"c", 2}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], (pyArgs[2]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "expandMacros", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKMacroExpander_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QHash<QChar,QStringList> cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QChar cppArg2 = QLatin1Char('%');
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // expandMacros(QString,QHash<QChar,QStringList>,QChar)
                QString cppResult = ::KMacroExpander::expandMacros(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
            }
            break;
        }
        case 2: // expandMacros(const QString &str, const QHash<QString,QString> &map, QChar c)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"c", 2}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], (pyArgs[2]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "expandMacros", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKMacroExpander_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QHash<QString,QString> cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QChar cppArg2 = QLatin1Char('%');
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // expandMacros(QString,QHash<QString,QString>,QChar)
                QString cppResult = ::KMacroExpander::expandMacros(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
            }
            break;
        }
        case 3: // expandMacros(const QString &str, const QHash<QString,QStringList> &map, QChar c)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"c", 2}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], (pyArgs[2]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "expandMacros", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKMacroExpander_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QHash<QString,QStringList> cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QChar cppArg2 = QLatin1Char('%');
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // expandMacros(QString,QHash<QString,QStringList>,QChar)
                QString cppResult = ::KMacroExpander::expandMacros(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KMacroExpanderFunc_expandMacrosShellQuote(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "expandMacrosShellQuote", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKMacroExpander_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:expandMacrosShellQuote", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KMacroExpander::expandMacrosShellQuote(QString,QHash<QChar,QString>,QChar=)->QString
    // 1: static KMacroExpander::expandMacrosShellQuote(QString,QHash<QChar,QStringList>,QChar=)->QString
    // 2: static KMacroExpander::expandMacrosShellQuote(QString,QHash<QString,QString>,QChar=)->QString
    // 3: static KMacroExpander::expandMacrosShellQuote(QString,QHash<QString,QStringList>,QChar=)->QString
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QHash_QString_QStringList_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 3; // expandMacrosShellQuote(QString,QHash<QString,QStringList>,QChar)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], (pyArgs[2])))) {
                overloadId = 3; // expandMacrosShellQuote(QString,QHash<QString,QStringList>,QChar)
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QHash_QString_QString_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // expandMacrosShellQuote(QString,QHash<QString,QString>,QChar)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], (pyArgs[2])))) {
                overloadId = 2; // expandMacrosShellQuote(QString,QHash<QString,QString>,QChar)
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QHash_QChar_QStringList_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // expandMacrosShellQuote(QString,QHash<QChar,QStringList>,QChar)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], (pyArgs[2])))) {
                overloadId = 1; // expandMacrosShellQuote(QString,QHash<QChar,QStringList>,QChar)
            }
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QHash_QChar_QString_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // expandMacrosShellQuote(QString,QHash<QChar,QString>,QChar)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], (pyArgs[2])))) {
                overloadId = 0; // expandMacrosShellQuote(QString,QHash<QChar,QString>,QChar)
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "expandMacrosShellQuote", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKMacroExpander_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // expandMacrosShellQuote(const QString &str, const QHash<QChar,QString> &map, QChar c)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"c", 2}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], (pyArgs[2]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "expandMacrosShellQuote", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKMacroExpander_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QHash<QChar,QString> cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QChar cppArg2 = QLatin1Char('%');
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // expandMacrosShellQuote(QString,QHash<QChar,QString>,QChar)
                QString cppResult = ::KMacroExpander::expandMacrosShellQuote(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
            }
            break;
        }
        case 1: // expandMacrosShellQuote(const QString &str, const QHash<QChar,QStringList> &map, QChar c)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"c", 2}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], (pyArgs[2]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "expandMacrosShellQuote", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKMacroExpander_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QHash<QChar,QStringList> cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QChar cppArg2 = QLatin1Char('%');
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // expandMacrosShellQuote(QString,QHash<QChar,QStringList>,QChar)
                QString cppResult = ::KMacroExpander::expandMacrosShellQuote(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
            }
            break;
        }
        case 2: // expandMacrosShellQuote(const QString &str, const QHash<QString,QString> &map, QChar c)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"c", 2}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], (pyArgs[2]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "expandMacrosShellQuote", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKMacroExpander_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QHash<QString,QString> cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QChar cppArg2 = QLatin1Char('%');
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // expandMacrosShellQuote(QString,QHash<QString,QString>,QChar)
                QString cppResult = ::KMacroExpander::expandMacrosShellQuote(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
            }
            break;
        }
        case 3: // expandMacrosShellQuote(const QString &str, const QHash<QString,QStringList> &map, QChar c)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"c", 2}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], (pyArgs[2]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "expandMacrosShellQuote", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKMacroExpander_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QHash<QString,QStringList> cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QChar cppArg2 = QLatin1Char('%');
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // expandMacrosShellQuote(QString,QHash<QString,QStringList>,QChar)
                QString cppResult = ::KMacroExpander::expandMacrosShellQuote(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KMacroExpander_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KMacroExpander_methods[] = {
    {"expandMacros", reinterpret_cast<PyCFunction>(Sbk_KMacroExpanderFunc_expandMacros), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"expandMacrosShellQuote", reinterpret_cast<PyCFunction>(Sbk_KMacroExpanderFunc_expandMacrosShellQuote), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KMacroExpander_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KMacroExpander_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KMacroExpander_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KMacroExpander_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KMacroExpander_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KMacroExpander_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KMacroExpander_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkDummyNew /* PYSIDE-595: Prevent replacement of "0" with base->tp_new. */)},
    {0, nullptr}
};
static PyType_Spec Sbk_KMacroExpander_spec = {
    "1:KCoreAddons.KMacroExpander",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KMacroExpander_slots
};

} //extern "C"

// Type conversion functions.

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KCoreAddonsKMacroExpander_SignatureStrings[] = {
    "3:KCoreAddons.KMacroExpander.expandMacros(str:QString,map:QHash[QChar, QString],c:QChar=QLatin1Char('%'))->QString",
    "2:KCoreAddons.KMacroExpander.expandMacros(str:QString,map:QHash[QChar, QStringList],c:QChar=QLatin1Char('%'))->QString",
    "1:KCoreAddons.KMacroExpander.expandMacros(str:QString,map:QHash[QString, QString],c:QChar=QLatin1Char('%'))->QString",
    "0:KCoreAddons.KMacroExpander.expandMacros(str:QString,map:QHash[QString, QStringList],c:QChar=QLatin1Char('%'))->QString",
    "3:KCoreAddons.KMacroExpander.expandMacrosShellQuote(str:QString,map:QHash[QChar, QString],c:QChar=QLatin1Char('%'))->QString",
    "2:KCoreAddons.KMacroExpander.expandMacrosShellQuote(str:QString,map:QHash[QChar, QStringList],c:QChar=QLatin1Char('%'))->QString",
    "1:KCoreAddons.KMacroExpander.expandMacrosShellQuote(str:QString,map:QHash[QString, QString],c:QChar=QLatin1Char('%'))->QString",
    "0:KCoreAddons.KMacroExpander.expandMacrosShellQuote(str:QString,map:QHash[QString, QStringList],c:QChar=QLatin1Char('%'))->QString",
    nullptr}; // Sentinel
#else
static constexpr size_t KCoreAddonsKMacroExpander_SignatureByteSize = 158;
static constexpr uint8_t KCoreAddonsKMacroExpander_SignatureBytes[158] = {
    0x78, 0xda, 0x33, 0xb6, 0xf2, 0x76, 0xce, 0x2f, 0x4a, 0x75, 0x4c, 0x49, 0xc9, 0xcf, 0x2b, 0xd6,
    0xf3, 0xf6, 0x4d, 0x4c, 0x2e, 0xca, 0x77, 0xad, 0x28, 0x48, 0xcc, 0x4b, 0x49, 0x2d, 0xd2, 0x4b,
    0x05, 0x33, 0xc0, 0x62, 0xc5, 0x1a, 0xc5, 0x25, 0x45, 0x56, 0x81, 0xc1, 0x25, 0x45, 0x99, 0x79,
    0xe9, 0x3a, 0xb9, 0x89, 0x05, 0x56, 0x81, 0x1e, 0x89, 0xc5, 0x19, 0xd1, 0x81, 0xce, 0x19, 0x89,
    0x45, 0x3a, 0x0a, 0x50, 0x89, 0x58, 0x9d, 0x64, 0x2b, 0xb0, 0x88, 0x6d, 0xa0, 0x4f, 0x62, 0x49,
    0x66, 0x9e, 0x21, 0x88, 0xad, 0xa1, 0xae, 0xaa, 0xae, 0xa9, 0xa9, 0x6b, 0x07, 0x55, 0xc3, 0x65,
    0x44, 0x55, 0x2b, 0x7d, 0x32, 0x8b, 0x4b, 0x88, 0xb2, 0xd6, 0x90, 0x52, 0x6b, 0xa1, 0x22, 0x24,
    0xf9, 0xd5, 0x80, 0xca, 0x96, 0x12, 0xed, 0x5b, 0x63, 0x62, 0x2d, 0x0e, 0xce, 0x48, 0xcd, 0xc9,
    0x09, 0x2c, 0xcd, 0x2f, 0x49, 0x1d, 0x80, 0x18, 0x26, 0xd1, 0x72, 0xea, 0xc7, 0x35, 0x61, 0x07,
    0xd0, 0x34, 0xd6, 0x49, 0xb6, 0x9e, 0xe8, 0x10, 0x00, 0x00, 0xd2, 0x0c, 0x59, 0x58
};
#endif

PyTypeObject *init_KCoreAddonsKMacroExpander(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKMacroExpander_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKMacroExpander_IDX].type;

    Shiboken::AutoDecRef Sbk_KMacroExpander_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KMacroExpander_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KMacroExpander",
        "KMacroExpander",
        &Sbk_KMacroExpander_spec,
        nullptr,
        Sbk_KMacroExpander_Type_bases.object(),
        0);
    auto *pyType = Sbk_KMacroExpander_TypeF(); // references _Sbk_KMacroExpander_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KCoreAddonsKMacroExpander_SignatureStrings);
#else
    InitSignatureBytes(pyType, KCoreAddonsKMacroExpander_SignatureBytes, KCoreAddonsKMacroExpander_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KMacroExpander_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKMacroExpander_IDX].type = pyType;



    return pyType;
}
