/* FaceLocation.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from FaceLocation.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/* Encapsulate geometry and pixels of a Face*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_FACE_LOCATION_DATA (face_location_data_get_type ())
typedef struct _FaceLocationData FaceLocationData;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_FACE_LOCATION (face_location_get_type ())
#define FACE_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FACE_LOCATION, FaceLocation))
#define FACE_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FACE_LOCATION, FaceLocationClass))
#define IS_FACE_LOCATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FACE_LOCATION))
#define IS_FACE_LOCATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FACE_LOCATION))
#define FACE_LOCATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FACE_LOCATION, FaceLocationClass))

typedef struct _FaceLocation FaceLocation;
typedef struct _FaceLocationClass FaceLocationClass;
typedef struct _FaceLocationPrivate FaceLocationPrivate;

#define TYPE_FACE_LOCATION_ID (face_location_id_get_type ())
typedef struct _FaceLocationID FaceLocationID;

#define TYPE_FACE_ID (face_id_get_type ())
typedef struct _FaceID FaceID;

#define TYPE_PHOTO_ID (photo_id_get_type ())
typedef struct _PhotoID PhotoID;
enum  {
	FACE_LOCATION_0_PROPERTY,
	FACE_LOCATION_NUM_PROPERTIES
};
static GParamSpec* face_location_properties[FACE_LOCATION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;

#define TYPE_FACE_LOCATION_TABLE (face_location_table_get_type ())
#define FACE_LOCATION_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FACE_LOCATION_TABLE, FaceLocationTable))
#define FACE_LOCATION_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FACE_LOCATION_TABLE, FaceLocationTableClass))
#define IS_FACE_LOCATION_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FACE_LOCATION_TABLE))
#define IS_FACE_LOCATION_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FACE_LOCATION_TABLE))
#define FACE_LOCATION_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FACE_LOCATION_TABLE, FaceLocationTableClass))

typedef struct _FaceLocationTable FaceLocationTable;
typedef struct _FaceLocationTableClass FaceLocationTableClass;

#define TYPE_DATABASE_ERROR (database_error_get_type ())
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_FACE_LOCATION_ROW (face_location_row_get_type ())
#define FACE_LOCATION_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FACE_LOCATION_ROW, FaceLocationRow))
#define FACE_LOCATION_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FACE_LOCATION_ROW, FaceLocationRowClass))
#define IS_FACE_LOCATION_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FACE_LOCATION_ROW))
#define IS_FACE_LOCATION_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FACE_LOCATION_ROW))
#define FACE_LOCATION_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FACE_LOCATION_ROW, FaceLocationRowClass))

typedef struct _FaceLocationRow FaceLocationRow;
typedef struct _FaceLocationRowClass FaceLocationRowClass;
#define _face_location_row_unref0(var) ((var == NULL) ? NULL : (var = (face_location_row_unref (var), NULL)))
typedef struct _FaceLocationRowPrivate FaceLocationRowPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;

#define TYPE_FACE (face_get_type ())
#define FACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FACE, Face))
#define FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FACE, FaceClass))
#define IS_FACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FACE))
#define IS_FACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FACE))
#define FACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FACE, FaceClass))

typedef struct _Face Face;
typedef struct _FaceClass FaceClass;
typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, gpointer user_data);
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FaceLocationData {
	gchar* geometry;
	gchar* vec;
};

struct _FaceLocation {
	GObject parent_instance;
	FaceLocationPrivate * priv;
};

struct _FaceLocationClass {
	GObjectClass parent_class;
};

struct _FaceLocationID {
	gint64 id;
};

struct _FaceID {
	gint64 id;
};

struct _PhotoID {
	gint64 id;
};

struct _FaceLocationPrivate {
	FaceLocationID face_location_id;
	FaceID face_id;
	PhotoID photo_id;
	FaceLocationData face_data;
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()

struct _FaceLocationRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FaceLocationRowPrivate * priv;
	FaceLocationID face_location_id;
	FaceID face_id;
	PhotoID photo_id;
	gchar* geometry;
	gchar* vec;
};

struct _FaceLocationRowClass {
	GTypeClass parent_class;
	void (*finalize) (FaceLocationRow *self);
};

static gint FaceLocation_private_offset;
static gpointer face_location_parent_class = NULL;
static GeeMap* face_location_face_photos_map;
static GeeMap* face_location_face_photos_map = NULL;
static GeeMap* face_location_photo_faces_map;
static GeeMap* face_location_photo_faces_map = NULL;

VALA_EXTERN GType face_location_data_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FaceLocationData* face_location_data_dup (const FaceLocationData* self);
VALA_EXTERN void face_location_data_free (FaceLocationData* self);
VALA_EXTERN void face_location_data_copy (const FaceLocationData* self,
                              FaceLocationData* dest);
VALA_EXTERN void face_location_data_destroy (FaceLocationData* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (FaceLocationData, face_location_data_destroy)
VALA_EXTERN GType face_location_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FaceLocation, g_object_unref)
VALA_EXTERN GType face_location_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FaceLocationID* face_location_id_dup (const FaceLocationID* self);
VALA_EXTERN void face_location_id_free (FaceLocationID* self);
VALA_EXTERN GType face_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FaceID* face_id_dup (const FaceID* self);
VALA_EXTERN void face_id_free (FaceID* self);
VALA_EXTERN GType photo_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PhotoID* photo_id_dup (const PhotoID* self);
VALA_EXTERN void photo_id_free (PhotoID* self);
static FaceLocation* face_location_new (FaceLocationID* face_location_id,
                                 FaceID* face_id,
                                 PhotoID* photo_id,
                                 FaceLocationData* face_data);
static FaceLocation* face_location_construct (GType object_type,
                                       FaceLocationID* face_location_id,
                                       FaceID* face_id,
                                       PhotoID* photo_id,
                                       FaceLocationData* face_data);
VALA_EXTERN FaceLocation* face_location_create (FaceID* face_id,
                                    PhotoID* photo_id,
                                    FaceLocationData* face_data);
VALA_EXTERN gchar* face_location_get_serialized_geometry (FaceLocation* self);
static void face_location_set_face_data (FaceLocation* self,
                                  FaceLocationData* face_data);
VALA_EXTERN gpointer database_table_ref (gpointer instance);
VALA_EXTERN void database_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_database_table (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_database_table (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_database_table (const GValue* value);
VALA_EXTERN GType database_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseTable, database_table_unref)
VALA_EXTERN GType face_location_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FaceLocationTable, database_table_unref)
VALA_EXTERN FaceLocationTable* face_location_table_get_instance (void);
VALA_EXTERN GQuark database_error_quark (void);
VALA_EXTERN GType database_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void face_location_table_update_face_location_face_data (FaceLocationTable* self,
                                                         FaceLocation* face_location,
                                                         GError** error);
VALA_EXTERN void app_window_database_error (GError* err);
VALA_EXTERN gpointer face_location_row_ref (gpointer instance);
VALA_EXTERN void face_location_row_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_face_location_row (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void value_set_face_location_row (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void value_take_face_location_row (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer value_get_face_location_row (const GValue* value);
VALA_EXTERN GType face_location_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FaceLocationRow, face_location_row_unref)
VALA_EXTERN FaceLocationRow* face_location_table_add (FaceLocationTable* self,
                                          FaceID* face_id,
                                          PhotoID* photo_id,
                                          const gchar* geometry,
                                          const gchar* vec,
                                          GError** error);
VALA_EXTERN FaceLocation* face_location_add_from_row (FaceLocationRow* row);
VALA_EXTERN void face_location_destroy (FaceID* face_id,
                            PhotoID* photo_id);
VALA_EXTERN void face_location_table_remove_face_from_source (FaceLocationTable* self,
                                                  FaceID* face_id,
                                                  PhotoID* photo_id,
                                                  GError** error);
VALA_EXTERN guint face_location_photo_id_hash (void* p);
VALA_EXTERN gboolean face_location_photo_ids_equal (void* a,
                                        void* b);
VALA_EXTERN guint face_location_face_id_hash (void* p);
VALA_EXTERN gboolean face_location_face_ids_equal (void* a,
                                       void* b);
VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN GType media_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSource, g_object_unref)
VALA_EXTERN GType photo_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoSource, g_object_unref)
VALA_EXTERN GType photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Photo, g_object_unref)
VALA_EXTERN GeeMap* face_location_get_locations_by_photo (Photo* photo);
VALA_EXTERN void photo_get_photo_id (Photo* self,
                         PhotoID* result);
VALA_EXTERN GType face_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Face, g_object_unref)
VALA_EXTERN GeeMap* face_location_get_locations_by_face (Face* face);
VALA_EXTERN void face_get_face_id (Face* self,
                       FaceID* result);
VALA_EXTERN GeeSet* face_location_get_photo_ids_by_face (Face* face);
VALA_EXTERN FaceLocation* face_location_get_face_location (FaceID* face_id,
                                               PhotoID* photo_id);
VALA_EXTERN void face_location_init (ProgressMonitor monitor,
                         gpointer monitor_target);
VALA_EXTERN GeeList* face_location_table_get_all_rows (FaceLocationTable* self,
                                           GError** error);
VALA_EXTERN void face_location_terminate (void);
VALA_EXTERN void face_location_get_face_location_id (FaceLocation* self,
                                         FaceLocationID* result);
VALA_EXTERN gchar* face_location_get_serialized_vec (FaceLocation* self);
VALA_EXTERN void face_location_get_face_data (FaceLocation* self,
                                  FaceLocationData* result);
VALA_EXTERN void face_location_get_photo_id (FaceLocation* self,
                                 PhotoID* result);
static void face_location_finalize (GObject * obj);
static GType face_location_get_type_once (void);

void
face_location_data_copy (const FaceLocationData* self,
                         FaceLocationData* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).geometry;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).geometry);
	(*dest).geometry = _tmp1_;
	_tmp2_ = (*self).vec;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).vec);
	(*dest).vec = _tmp3_;
}

void
face_location_data_destroy (FaceLocationData* self)
{
	_g_free0 ((*self).geometry);
	_g_free0 ((*self).vec);
}

FaceLocationData*
face_location_data_dup (const FaceLocationData* self)
{
	FaceLocationData* dup;
	dup = g_new0 (FaceLocationData, 1);
	face_location_data_copy (self, dup);
	return dup;
}

void
face_location_data_free (FaceLocationData* self)
{
	face_location_data_destroy (self);
	g_free (self);
}

static GType
face_location_data_get_type_once (void)
{
	GType face_location_data_type_id;
	face_location_data_type_id = g_boxed_type_register_static ("FaceLocationData", (GBoxedCopyFunc) face_location_data_dup, (GBoxedFreeFunc) face_location_data_free);
	return face_location_data_type_id;
}

GType
face_location_data_get_type (void)
{
	static volatile gsize face_location_data_type_id__once = 0;
	if (g_once_init_enter (&face_location_data_type_id__once)) {
		GType face_location_data_type_id;
		face_location_data_type_id = face_location_data_get_type_once ();
		g_once_init_leave (&face_location_data_type_id__once, face_location_data_type_id);
	}
	return face_location_data_type_id__once;
}

static inline gpointer
face_location_get_instance_private (FaceLocation* self)
{
	return G_STRUCT_MEMBER_P (self, FaceLocation_private_offset);
}

static FaceLocation*
face_location_construct (GType object_type,
                         FaceLocationID* face_location_id,
                         FaceID* face_id,
                         PhotoID* photo_id,
                         FaceLocationData* face_data)
{
	FaceLocation * self = NULL;
	FaceLocationID _tmp0_;
	FaceID _tmp1_;
	PhotoID _tmp2_;
	FaceLocationData _tmp3_;
	FaceLocationData _tmp4_;
	FaceLocationData _tmp5_ = {0};
	g_return_val_if_fail (face_location_id != NULL, NULL);
	g_return_val_if_fail (face_id != NULL, NULL);
	g_return_val_if_fail (photo_id != NULL, NULL);
	g_return_val_if_fail (face_data != NULL, NULL);
	self = (FaceLocation*) g_object_new (object_type, NULL);
	_tmp0_ = *face_location_id;
	self->priv->face_location_id = _tmp0_;
	_tmp1_ = *face_id;
	self->priv->face_id = _tmp1_;
	_tmp2_ = *photo_id;
	self->priv->photo_id = _tmp2_;
	_tmp3_ = *face_data;
	_tmp4_ = _tmp3_;
	face_location_data_copy (&_tmp4_, &_tmp5_);
	face_location_data_destroy (&self->priv->face_data);
	self->priv->face_data = _tmp5_;
	return self;
}

static FaceLocation*
face_location_new (FaceLocationID* face_location_id,
                   FaceID* face_id,
                   PhotoID* photo_id,
                   FaceLocationData* face_data)
{
	return face_location_construct (TYPE_FACE_LOCATION, face_location_id, face_id, photo_id, face_data);
}

FaceLocation*
face_location_create (FaceID* face_id,
                      PhotoID* photo_id,
                      FaceLocationData* face_data)
{
	FaceLocation* face_location = NULL;
	GeeMap* photos_map = NULL;
	GeeMap* _tmp0_;
	FaceID _tmp1_;
	gpointer _tmp2_;
	GeeMap* faces_map = NULL;
	GeeMap* _tmp3_;
	PhotoID _tmp4_;
	gpointer _tmp5_;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	GeeMap* _tmp8_;
	GError* _inner_error0_ = NULL;
	FaceLocation* result;
	g_return_val_if_fail (face_id != NULL, NULL);
	g_return_val_if_fail (photo_id != NULL, NULL);
	g_return_val_if_fail (face_data != NULL, NULL);
	face_location = NULL;
	_tmp0_ = face_location_face_photos_map;
	_tmp1_ = *face_id;
	_tmp2_ = gee_map_get (_tmp0_, &_tmp1_);
	photos_map = (GeeMap*) _tmp2_;
	_tmp3_ = face_location_photo_faces_map;
	_tmp4_ = *photo_id;
	_tmp5_ = gee_map_get (_tmp3_, &_tmp4_);
	faces_map = (GeeMap*) _tmp5_;
	_tmp8_ = photos_map;
	if (_tmp8_ != NULL) {
		GeeMap* _tmp9_;
		_tmp9_ = faces_map;
		_tmp7_ = _tmp9_ != NULL;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		GeeMap* _tmp10_;
		FaceID _tmp11_;
		_tmp10_ = faces_map;
		_tmp11_ = *face_id;
		_tmp6_ = gee_map_has_key (_tmp10_, &_tmp11_);
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		GeeMap* _tmp12_;
		FaceID _tmp13_;
		gpointer _tmp14_;
		FaceLocation* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		FaceLocationData _tmp18_;
		const gchar* _tmp19_;
		gboolean _tmp20_;
		_tmp12_ = faces_map;
		_tmp13_ = *face_id;
		_tmp14_ = gee_map_get (_tmp12_, &_tmp13_);
		_g_object_unref0 (face_location);
		face_location = (FaceLocation*) _tmp14_;
		_tmp15_ = face_location;
		_tmp16_ = face_location_get_serialized_geometry (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = *face_data;
		_tmp19_ = _tmp18_.geometry;
		_tmp20_ = g_strcmp0 (_tmp17_, _tmp19_) != 0;
		_g_free0 (_tmp17_);
		if (_tmp20_) {
			FaceLocation* _tmp21_;
			FaceLocationData _tmp22_;
			_tmp21_ = face_location;
			_tmp22_ = *face_data;
			face_location_set_face_data (_tmp21_, &_tmp22_);
			{
				FaceLocationTable* _tmp23_;
				FaceLocationTable* _tmp24_;
				FaceLocation* _tmp25_;
				_tmp23_ = face_location_table_get_instance ();
				_tmp24_ = _tmp23_;
				_tmp25_ = face_location;
				face_location_table_update_face_location_face_data (_tmp24_, _tmp25_, &_inner_error0_);
				_database_table_unref0 (_tmp24_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == DATABASE_ERROR) {
						goto __catch0_database_error;
					}
					_g_object_unref0 (faces_map);
					_g_object_unref0 (photos_map);
					_g_object_unref0 (face_location);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			goto __finally0;
			__catch0_database_error:
			{
				GError* err = NULL;
				GError* _tmp26_;
				err = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp26_ = err;
				app_window_database_error (_tmp26_);
				_g_error_free0 (err);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (faces_map);
				_g_object_unref0 (photos_map);
				_g_object_unref0 (face_location);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
		result = face_location;
		_g_object_unref0 (faces_map);
		_g_object_unref0 (photos_map);
		return result;
	}
	{
		FaceLocationRow* _tmp27_ = NULL;
		FaceLocationTable* _tmp28_;
		FaceLocationTable* _tmp29_;
		FaceID _tmp30_;
		PhotoID _tmp31_;
		FaceLocationData _tmp32_;
		const gchar* _tmp33_;
		FaceLocationData _tmp34_;
		const gchar* _tmp35_;
		FaceLocationRow* _tmp36_;
		FaceLocationRow* _tmp37_;
		FaceLocation* _tmp38_;
		_tmp28_ = face_location_table_get_instance ();
		_tmp29_ = _tmp28_;
		_tmp30_ = *face_id;
		_tmp31_ = *photo_id;
		_tmp32_ = *face_data;
		_tmp33_ = _tmp32_.geometry;
		_tmp34_ = *face_data;
		_tmp35_ = _tmp34_.vec;
		_tmp36_ = face_location_table_add (_tmp29_, &_tmp30_, &_tmp31_, _tmp33_, _tmp35_, &_inner_error0_);
		_tmp37_ = _tmp36_;
		_database_table_unref0 (_tmp29_);
		_tmp27_ = _tmp37_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch1_database_error;
			}
			_g_object_unref0 (faces_map);
			_g_object_unref0 (photos_map);
			_g_object_unref0 (face_location);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp38_ = face_location_add_from_row (_tmp27_);
		_g_object_unref0 (face_location);
		face_location = _tmp38_;
		_face_location_row_unref0 (_tmp27_);
	}
	goto __finally1;
	__catch1_database_error:
	{
		GError* err = NULL;
		GError* _tmp39_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp39_ = err;
		app_window_database_error (_tmp39_);
		_g_error_free0 (err);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (faces_map);
		_g_object_unref0 (photos_map);
		_g_object_unref0 (face_location);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = face_location;
	_g_object_unref0 (faces_map);
	_g_object_unref0 (photos_map);
	return result;
}

void
face_location_destroy (FaceID* face_id,
                       PhotoID* photo_id)
{
	GeeMap* photos_map = NULL;
	GeeMap* _tmp0_;
	FaceID _tmp1_;
	gpointer _tmp2_;
	GeeMap* faces_map = NULL;
	GeeMap* _tmp3_;
	PhotoID _tmp4_;
	gpointer _tmp5_;
	GeeMap* _tmp6_;
	GeeMap* _tmp7_;
	GeeMap* _tmp8_;
	FaceID _tmp9_;
	GeeMap* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GeeMap* _tmp15_;
	PhotoID _tmp16_;
	GeeMap* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (face_id != NULL);
	g_return_if_fail (photo_id != NULL);
	_tmp0_ = face_location_face_photos_map;
	_tmp1_ = *face_id;
	_tmp2_ = gee_map_get (_tmp0_, &_tmp1_);
	photos_map = (GeeMap*) _tmp2_;
	_tmp3_ = face_location_photo_faces_map;
	_tmp4_ = *photo_id;
	_tmp5_ = gee_map_get (_tmp3_, &_tmp4_);
	faces_map = (GeeMap*) _tmp5_;
	_tmp6_ = photos_map;
	_vala_assert (_tmp6_ != NULL, "photos_map != null");
	_tmp7_ = faces_map;
	_vala_assert (_tmp7_ != NULL, "faces_map != null");
	_tmp8_ = faces_map;
	_tmp9_ = *face_id;
	gee_map_unset (_tmp8_, &_tmp9_, NULL);
	_tmp10_ = faces_map;
	_tmp11_ = gee_map_get_size (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ == 0) {
		GeeMap* _tmp13_;
		PhotoID _tmp14_;
		_tmp13_ = face_location_photo_faces_map;
		_tmp14_ = *photo_id;
		gee_map_unset (_tmp13_, &_tmp14_, NULL);
	}
	_tmp15_ = photos_map;
	_tmp16_ = *photo_id;
	gee_map_unset (_tmp15_, &_tmp16_, NULL);
	_tmp17_ = photos_map;
	_tmp18_ = gee_map_get_size (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_ == 0) {
		GeeMap* _tmp20_;
		FaceID _tmp21_;
		_tmp20_ = face_location_face_photos_map;
		_tmp21_ = *face_id;
		gee_map_unset (_tmp20_, &_tmp21_, NULL);
	}
	{
		FaceLocationTable* _tmp22_;
		FaceLocationTable* _tmp23_;
		FaceID _tmp24_;
		PhotoID _tmp25_;
		_tmp22_ = face_location_table_get_instance ();
		_tmp23_ = _tmp22_;
		_tmp24_ = *face_id;
		_tmp25_ = *photo_id;
		face_location_table_remove_face_from_source (_tmp23_, &_tmp24_, &_tmp25_, &_inner_error0_);
		_database_table_unref0 (_tmp23_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			_g_object_unref0 (faces_map);
			_g_object_unref0 (photos_map);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp26_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp26_ = err;
		app_window_database_error (_tmp26_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (faces_map);
		_g_object_unref0 (photos_map);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (faces_map);
	_g_object_unref0 (photos_map);
}

FaceLocation*
face_location_add_from_row (FaceLocationRow* row)
{
	FaceLocation* face_location = NULL;
	FaceLocationID _tmp0_;
	FaceID _tmp1_;
	PhotoID _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	FaceLocationData _tmp5_ = {0};
	FaceLocation* _tmp6_;
	GeeMap* photos_map = NULL;
	GeeMap* _tmp7_;
	FaceID _tmp8_;
	gpointer _tmp9_;
	GeeMap* _tmp10_;
	GeeMap* _tmp15_;
	PhotoID _tmp16_;
	FaceLocation* _tmp17_;
	GeeMap* faces_map = NULL;
	GeeMap* _tmp18_;
	PhotoID _tmp19_;
	gpointer _tmp20_;
	GeeMap* _tmp21_;
	GeeMap* _tmp26_;
	FaceID _tmp27_;
	FaceLocation* _tmp28_;
	FaceLocation* result;
	g_return_val_if_fail (IS_FACE_LOCATION_ROW (row), NULL);
	_tmp0_ = row->face_location_id;
	_tmp1_ = row->face_id;
	_tmp2_ = row->photo_id;
	_tmp3_ = row->geometry;
	_tmp4_ = row->vec;
	_g_free0 (_tmp5_.geometry);
	_tmp5_.geometry = _tmp3_;
	_g_free0 (_tmp5_.vec);
	_tmp5_.vec = _tmp4_;
	_tmp6_ = face_location_new (&_tmp0_, &_tmp1_, &_tmp2_, &_tmp5_);
	face_location = _tmp6_;
	_tmp7_ = face_location_face_photos_map;
	_tmp8_ = row->face_id;
	_tmp9_ = gee_map_get (_tmp7_, &_tmp8_);
	photos_map = (GeeMap*) _tmp9_;
	_tmp10_ = photos_map;
	if (_tmp10_ == NULL) {
		GeeHashMap* _tmp11_;
		GeeMap* _tmp12_;
		FaceID _tmp13_;
		GeeMap* _tmp14_;
		_tmp11_ = gee_hash_map_new (TYPE_PHOTO_ID, (GBoxedCopyFunc) photo_id_dup, (GDestroyNotify) photo_id_free, TYPE_FACE_LOCATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeHashDataFunc) face_location_photo_id_hash, NULL, NULL, (GeeEqualDataFunc) face_location_photo_ids_equal, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (photos_map);
		photos_map = G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_MAP, GeeMap);
		_tmp12_ = face_location_face_photos_map;
		_tmp13_ = row->face_id;
		_tmp14_ = photos_map;
		gee_map_set (_tmp12_, &_tmp13_, _tmp14_);
	}
	_tmp15_ = photos_map;
	_tmp16_ = row->photo_id;
	_tmp17_ = face_location;
	gee_map_set (_tmp15_, &_tmp16_, _tmp17_);
	_tmp18_ = face_location_photo_faces_map;
	_tmp19_ = row->photo_id;
	_tmp20_ = gee_map_get (_tmp18_, &_tmp19_);
	faces_map = (GeeMap*) _tmp20_;
	_tmp21_ = faces_map;
	if (_tmp21_ == NULL) {
		GeeHashMap* _tmp22_;
		GeeMap* _tmp23_;
		PhotoID _tmp24_;
		GeeMap* _tmp25_;
		_tmp22_ = gee_hash_map_new (TYPE_FACE_ID, (GBoxedCopyFunc) face_id_dup, (GDestroyNotify) face_id_free, TYPE_FACE_LOCATION, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeHashDataFunc) face_location_face_id_hash, NULL, NULL, (GeeEqualDataFunc) face_location_face_ids_equal, NULL, NULL, NULL, NULL, NULL);
		_g_object_unref0 (faces_map);
		faces_map = G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, GEE_TYPE_MAP, GeeMap);
		_tmp23_ = face_location_photo_faces_map;
		_tmp24_ = row->photo_id;
		_tmp25_ = faces_map;
		gee_map_set (_tmp23_, &_tmp24_, _tmp25_);
	}
	_tmp26_ = faces_map;
	_tmp27_ = row->face_id;
	_tmp28_ = face_location;
	gee_map_set (_tmp26_, &_tmp27_, _tmp28_);
	result = face_location;
	_g_object_unref0 (faces_map);
	_g_object_unref0 (photos_map);
	return result;
}

GeeMap*
face_location_get_locations_by_photo (Photo* photo)
{
	GeeMap* _tmp0_;
	PhotoID _tmp1_ = {0};
	gpointer _tmp2_;
	GeeMap* result;
	g_return_val_if_fail (IS_PHOTO (photo), NULL);
	_tmp0_ = face_location_photo_faces_map;
	photo_get_photo_id (photo, &_tmp1_);
	_tmp2_ = gee_map_get (_tmp0_, &_tmp1_);
	result = (GeeMap*) _tmp2_;
	return result;
}

GeeMap*
face_location_get_locations_by_face (Face* face)
{
	GeeMap* _tmp0_;
	FaceID _tmp1_ = {0};
	gpointer _tmp2_;
	GeeMap* result;
	g_return_val_if_fail (IS_FACE (face), NULL);
	_tmp0_ = face_location_face_photos_map;
	face_get_face_id (face, &_tmp1_);
	_tmp2_ = gee_map_get (_tmp0_, &_tmp1_);
	result = (GeeMap*) _tmp2_;
	return result;
}

GeeSet*
face_location_get_photo_ids_by_face (Face* face)
{
	GeeMap* photos_map = NULL;
	GeeMap* _tmp0_;
	FaceID _tmp1_ = {0};
	gpointer _tmp2_;
	GeeMap* _tmp3_;
	GeeMap* _tmp4_;
	GeeSet* _tmp5_;
	GeeSet* _tmp6_;
	GeeSet* result;
	g_return_val_if_fail (IS_FACE (face), NULL);
	_tmp0_ = face_location_face_photos_map;
	face_get_face_id (face, &_tmp1_);
	_tmp2_ = gee_map_get (_tmp0_, &_tmp1_);
	photos_map = (GeeMap*) _tmp2_;
	_tmp3_ = photos_map;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_object_unref0 (photos_map);
		return result;
	}
	_tmp4_ = photos_map;
	_tmp5_ = gee_map_get_keys (_tmp4_);
	_tmp6_ = _tmp5_;
	result = _tmp6_;
	_g_object_unref0 (photos_map);
	return result;
}

FaceLocation*
face_location_get_face_location (FaceID* face_id,
                                 PhotoID* photo_id)
{
	GeeMap* faces_map = NULL;
	GeeMap* _tmp0_;
	PhotoID _tmp1_;
	gpointer _tmp2_;
	GeeMap* _tmp3_;
	GeeMap* _tmp4_;
	FaceID _tmp5_;
	gpointer _tmp6_;
	FaceLocation* result;
	g_return_val_if_fail (face_id != NULL, NULL);
	g_return_val_if_fail (photo_id != NULL, NULL);
	_tmp0_ = face_location_photo_faces_map;
	_tmp1_ = *photo_id;
	_tmp2_ = gee_map_get (_tmp0_, &_tmp1_);
	faces_map = (GeeMap*) _tmp2_;
	_tmp3_ = faces_map;
	if (_tmp3_ == NULL) {
		result = NULL;
		_g_object_unref0 (faces_map);
		return result;
	}
	_tmp4_ = faces_map;
	_tmp5_ = *face_id;
	_tmp6_ = gee_map_get (_tmp4_, &_tmp5_);
	result = (FaceLocation*) _tmp6_;
	_g_object_unref0 (faces_map);
	return result;
}

gboolean
face_location_photo_ids_equal (void* a,
                               void* b)
{
	PhotoID* aid = NULL;
	PhotoID* bid = NULL;
	gboolean result;
	aid = (PhotoID*) a;
	bid = (PhotoID*) b;
	result = (*aid).id == (*bid).id;
	return result;
}

gboolean
face_location_face_ids_equal (void* a,
                              void* b)
{
	FaceID* aid = NULL;
	FaceID* bid = NULL;
	gboolean result;
	aid = (FaceID*) a;
	bid = (FaceID*) b;
	result = (*aid).id == (*bid).id;
	return result;
}

guint
face_location_photo_id_hash (void* p)
{
	guint8 u8 = 0U;
	guint hash = 0U;
	guint result;
	u8 = (guint8) (*((PhotoID*) p)).id;
	hash = (guint) 0;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint _tmp2_;
				guint _tmp3_;
				guint8 _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = ctr;
					ctr = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(((gulong) ctr) < (sizeof (gint64) / sizeof (guint8)))) {
					break;
				}
				_tmp2_ = hash;
				_tmp3_ = hash;
				_tmp4_ = u8;
				u8 = _tmp4_ + 1;
				hash = ((_tmp2_ << 4) ^ (_tmp3_ >> 28)) ^ _tmp4_;
			}
		}
	}
	result = hash;
	return result;
}

guint
face_location_face_id_hash (void* p)
{
	guint8 u8 = 0U;
	guint hash = 0U;
	guint result;
	u8 = (guint8) (*((FaceID*) p)).id;
	hash = (guint) 0;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				guint _tmp2_;
				guint _tmp3_;
				guint8 _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = ctr;
					ctr = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(((gulong) ctr) < (sizeof (gint64) / sizeof (guint8)))) {
					break;
				}
				_tmp2_ = hash;
				_tmp3_ = hash;
				_tmp4_ = u8;
				u8 = _tmp4_ + 1;
				hash = ((_tmp2_ << 4) ^ (_tmp3_ >> 28)) ^ _tmp4_;
			}
		}
	}
	result = hash;
	return result;
}

void
face_location_init (ProgressMonitor monitor,
                    gpointer monitor_target)
{
	GeeHashMap* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeList* rows = NULL;
	gint count = 0;
	GeeList* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GError* _inner_error0_ = NULL;
	_tmp0_ = gee_hash_map_new (TYPE_FACE_ID, (GBoxedCopyFunc) face_id_dup, (GDestroyNotify) face_id_free, GEE_TYPE_HASH_MAP, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeHashDataFunc) face_location_face_id_hash, NULL, NULL, (GeeEqualDataFunc) face_location_face_ids_equal, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (face_location_face_photos_map);
	face_location_face_photos_map = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_MAP, GeeMap);
	_tmp1_ = gee_hash_map_new (TYPE_PHOTO_ID, (GBoxedCopyFunc) photo_id_dup, (GDestroyNotify) photo_id_free, GEE_TYPE_HASH_MAP, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, (GeeHashDataFunc) face_location_photo_id_hash, NULL, NULL, (GeeEqualDataFunc) face_location_photo_ids_equal, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (face_location_photo_faces_map);
	face_location_photo_faces_map = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_MAP, GeeMap);
	rows = NULL;
	{
		GeeList* _tmp2_ = NULL;
		FaceLocationTable* _tmp3_;
		FaceLocationTable* _tmp4_;
		GeeList* _tmp5_;
		GeeList* _tmp6_;
		GeeList* _tmp7_;
		_tmp3_ = face_location_table_get_instance ();
		_tmp4_ = _tmp3_;
		_tmp5_ = face_location_table_get_all_rows (_tmp4_, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_database_table_unref0 (_tmp4_);
		_tmp2_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				goto __catch0_database_error;
			}
			_g_object_unref0 (rows);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		_tmp7_ = _tmp2_;
		_tmp2_ = NULL;
		_g_object_unref0 (rows);
		rows = _tmp7_;
		_g_object_unref0 (_tmp2_);
	}
	goto __finally0;
	__catch0_database_error:
	{
		GError* err = NULL;
		GError* _tmp8_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = err;
		app_window_database_error (_tmp8_);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (rows);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp9_ = rows;
	_tmp10_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, GEE_TYPE_COLLECTION, GeeCollection));
	_tmp11_ = _tmp10_;
	count = _tmp11_;
	{
		gint ctr = 0;
		ctr = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				GeeList* _tmp14_;
				gpointer _tmp15_;
				FaceLocationRow* _tmp16_;
				FaceLocation* _tmp17_;
				FaceLocation* _tmp18_;
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = ctr;
					ctr = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				if (!(ctr < count)) {
					break;
				}
				_tmp14_ = rows;
				_tmp15_ = gee_list_get (_tmp14_, ctr);
				_tmp16_ = (FaceLocationRow*) _tmp15_;
				_tmp17_ = face_location_add_from_row (_tmp16_);
				_tmp18_ = _tmp17_;
				_g_object_unref0 (_tmp18_);
				_face_location_row_unref0 (_tmp16_);
				if (monitor != NULL) {
					monitor ((guint64) ctr, (guint64) count, TRUE, monitor_target);
				}
			}
		}
	}
	_g_object_unref0 (rows);
}

void
face_location_terminate (void)
{
}

void
face_location_get_face_location_id (FaceLocation* self,
                                    FaceLocationID* result)
{
	FaceLocationID _tmp0_;
	g_return_if_fail (IS_FACE_LOCATION (self));
	_tmp0_ = self->priv->face_location_id;
	*result = _tmp0_;
	return;
}

gchar*
face_location_get_serialized_geometry (FaceLocation* self)
{
	FaceLocationData _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (IS_FACE_LOCATION (self), NULL);
	_tmp0_ = self->priv->face_data;
	_tmp1_ = _tmp0_.geometry;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

gchar*
face_location_get_serialized_vec (FaceLocation* self)
{
	FaceLocationData _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (IS_FACE_LOCATION (self), NULL);
	_tmp0_ = self->priv->face_data;
	_tmp1_ = _tmp0_.vec;
	_tmp2_ = g_strdup (_tmp1_);
	result = _tmp2_;
	return result;
}

void
face_location_get_face_data (FaceLocation* self,
                             FaceLocationData* result)
{
	FaceLocationData _tmp0_;
	FaceLocationData _tmp1_;
	FaceLocationData _tmp2_ = {0};
	g_return_if_fail (IS_FACE_LOCATION (self));
	_tmp0_ = self->priv->face_data;
	_tmp1_ = _tmp0_;
	face_location_data_copy (&_tmp1_, &_tmp2_);
	*result = _tmp2_;
	return;
}

void
face_location_get_photo_id (FaceLocation* self,
                            PhotoID* result)
{
	PhotoID _tmp0_;
	g_return_if_fail (IS_FACE_LOCATION (self));
	_tmp0_ = self->priv->photo_id;
	*result = _tmp0_;
	return;
}

static void
face_location_set_face_data (FaceLocation* self,
                             FaceLocationData* face_data)
{
	FaceLocationData _tmp0_;
	FaceLocationData _tmp1_;
	FaceLocationData _tmp2_ = {0};
	g_return_if_fail (IS_FACE_LOCATION (self));
	g_return_if_fail (face_data != NULL);
	_tmp0_ = *face_data;
	_tmp1_ = _tmp0_;
	face_location_data_copy (&_tmp1_, &_tmp2_);
	face_location_data_destroy (&self->priv->face_data);
	self->priv->face_data = _tmp2_;
}

static void
face_location_class_init (FaceLocationClass * klass,
                          gpointer klass_data)
{
	face_location_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FaceLocation_private_offset);
	G_OBJECT_CLASS (klass)->finalize = face_location_finalize;
}

static void
face_location_instance_init (FaceLocation * self,
                             gpointer klass)
{
	self->priv = face_location_get_instance_private (self);
}

static void
face_location_finalize (GObject * obj)
{
	FaceLocation * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FACE_LOCATION, FaceLocation);
	face_location_data_destroy (&self->priv->face_data);
	G_OBJECT_CLASS (face_location_parent_class)->finalize (obj);
}

static GType
face_location_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FaceLocationClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) face_location_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FaceLocation), 0, (GInstanceInitFunc) face_location_instance_init, NULL };
	GType face_location_type_id;
	face_location_type_id = g_type_register_static (G_TYPE_OBJECT, "FaceLocation", &g_define_type_info, 0);
	FaceLocation_private_offset = g_type_add_instance_private (face_location_type_id, sizeof (FaceLocationPrivate));
	return face_location_type_id;
}

GType
face_location_get_type (void)
{
	static volatile gsize face_location_type_id__once = 0;
	if (g_once_init_enter (&face_location_type_id__once)) {
		GType face_location_type_id;
		face_location_type_id = face_location_get_type_once ();
		g_once_init_leave (&face_location_type_id__once, face_location_type_id);
	}
	return face_location_type_id__once;
}

