﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/lambda/Lambda_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Lambda {
namespace Model {
class GetFunctionConcurrencyResult {
 public:
  AWS_LAMBDA_API GetFunctionConcurrencyResult() = default;
  AWS_LAMBDA_API GetFunctionConcurrencyResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_LAMBDA_API GetFunctionConcurrencyResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The number of simultaneous executions that are reserved for the function.</p>
   */
  inline int GetReservedConcurrentExecutions() const { return m_reservedConcurrentExecutions; }
  inline void SetReservedConcurrentExecutions(int value) {
    m_reservedConcurrentExecutionsHasBeenSet = true;
    m_reservedConcurrentExecutions = value;
  }
  inline GetFunctionConcurrencyResult& WithReservedConcurrentExecutions(int value) {
    SetReservedConcurrentExecutions(value);
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  GetFunctionConcurrencyResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  int m_reservedConcurrentExecutions{0};
  bool m_reservedConcurrentExecutionsHasBeenSet = false;

  Aws::String m_requestId;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Lambda
}  // namespace Aws
