/* baobab-pathbar.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from baobab-pathbar.vala, do not modify */

/* Baobab - disk usage analyzer
 *
 * Copyright (C) 2020 Stefano Facchini <stefano.facchini@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "baobab.h"
#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <float.h>
#include <math.h>
#include <pango/pango.h>
#include <adwaita.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BAOBAB_PATH_BUTTON_0_PROPERTY,
	BAOBAB_PATH_BUTTON_NUM_PROPERTIES
};
static GParamSpec* baobab_path_button_properties[BAOBAB_PATH_BUTTON_NUM_PROPERTIES];
enum  {
	BAOBAB_PATHBAR_0_PROPERTY,
	BAOBAB_PATHBAR_LOCATION_PROPERTY,
	BAOBAB_PATHBAR_PATH_PROPERTY,
	BAOBAB_PATHBAR_NUM_PROPERTIES
};
static GParamSpec* baobab_pathbar_properties[BAOBAB_PATHBAR_NUM_PROPERTIES];
#define _baobab_location_unref0(var) ((var == NULL) ? NULL : (var = (baobab_location_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	BAOBAB_PATHBAR_ITEM_ACTIVATED_SIGNAL,
	BAOBAB_PATHBAR_NUM_SIGNALS
};
static guint baobab_pathbar_signals[BAOBAB_PATHBAR_NUM_SIGNALS] = {0};

struct _BaobabPathButtonPrivate {
	GtkLabel* label;
	GtkImage* icon;
};

struct _BaobabPathbarPrivate {
	GtkBox* button_box;
	BaobabLocation* location_;
};

struct _Block3Data {
	int _ref_count_;
	BaobabPathbar* self;
	BaobabScannerResults* path;
};

static gint BaobabPathButton_private_offset;
static gpointer baobab_path_button_parent_class = NULL;
static gint BaobabPathbar_private_offset;
static gpointer baobab_pathbar_parent_class = NULL;

static void baobab_path_button_finalize (GObject * obj);
static GType baobab_path_button_get_type_once (void);
static void baobab_pathbar_on_adjustment_changed (BaobabPathbar* self,
                                           GtkAdjustment* adjusment);
static void _baobab_pathbar_on_adjustment_changed_gtk_adjustment_changed (GtkAdjustment* _sender,
                                                                   gpointer self);
static void baobab_pathbar_on_page_size_changed (BaobabPathbar* self,
                                          GObject* o,
                                          GParamSpec* spec);
static void _baobab_pathbar_on_page_size_changed_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self);
static void baobab_pathbar_clear (BaobabPathbar* self);
static BaobabPathButton* baobab_pathbar_make_button (BaobabPathbar* self,
                                              BaobabScannerResults* path,
                                              gboolean is_current_dir);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void ___lambda7_ (Block3Data* _data3_);
static void ____lambda7__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void baobab_pathbar_finalize (GObject * obj);
static GType baobab_pathbar_get_type_once (void);
static void _vala_baobab_pathbar_get_property (GObject * object,
                                        guint property_id,
                                        GValue * value,
                                        GParamSpec * pspec);
static void _vala_baobab_pathbar_set_property (GObject * object,
                                        guint property_id,
                                        const GValue * value,
                                        GParamSpec * pspec);

static inline gpointer
baobab_path_button_get_instance_private (BaobabPathButton* self)
{
	return G_STRUCT_MEMBER_P (self, BaobabPathButton_private_offset);
}

BaobabPathButton*
baobab_path_button_construct (GType object_type,
                              const gchar* name,
                              GIcon* gicon,
                              gboolean is_current_dir)
{
	BaobabPathButton * self = NULL;
	gint min_chars = 0;
	GtkLabel* _tmp0_;
	gint _tmp3_;
	gint _tmp4_;
	GtkImage* _tmp7_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (BaobabPathButton*) g_object_new (object_type, NULL);
	min_chars = 7;
	_tmp0_ = self->priv->label;
	gtk_label_set_label (_tmp0_, name);
	gtk_widget_set_tooltip_text ((GtkWidget*) self, name);
	if (!is_current_dir) {
		GtkImage* _tmp1_;
		GtkLabel* _tmp2_;
		_tmp1_ = self->priv->icon;
		gtk_widget_add_css_class ((GtkWidget*) _tmp1_, "dim-label");
		_tmp2_ = self->priv->label;
		gtk_widget_add_css_class ((GtkWidget*) _tmp2_, "dim-label");
	} else {
		min_chars = 4 * min_chars;
		gtk_widget_add_css_class ((GtkWidget*) self, "current-dir");
	}
	_tmp3_ = strlen (name);
	_tmp4_ = _tmp3_;
	if (((gdouble) _tmp4_) > (min_chars * 1.5)) {
		GtkLabel* _tmp5_;
		GtkLabel* _tmp6_;
		_tmp5_ = self->priv->label;
		gtk_label_set_width_chars (_tmp5_, min_chars);
		_tmp6_ = self->priv->label;
		gtk_label_set_ellipsize (_tmp6_, PANGO_ELLIPSIZE_MIDDLE);
	}
	_tmp7_ = self->priv->icon;
	gtk_widget_hide ((GtkWidget*) _tmp7_);
	if (gicon != NULL) {
		GtkImage* _tmp8_;
		GtkImage* _tmp9_;
		_tmp8_ = self->priv->icon;
		g_object_set (_tmp8_, "gicon", gicon, NULL);
		_tmp9_ = self->priv->icon;
		gtk_widget_show ((GtkWidget*) _tmp9_);
	}
	return self;
}

BaobabPathButton*
baobab_path_button_new (const gchar* name,
                        GIcon* gicon,
                        gboolean is_current_dir)
{
	return baobab_path_button_construct (BAOBAB_TYPE_PATH_BUTTON, name, gicon, is_current_dir);
}

static void
baobab_path_button_class_init (BaobabPathButtonClass * klass,
                               gpointer klass_data)
{
	baobab_path_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BaobabPathButton_private_offset);
	G_OBJECT_CLASS (klass)->finalize = baobab_path_button_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/baobab/ui/baobab-pathbutton.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label", FALSE, BaobabPathButton_private_offset + G_STRUCT_OFFSET (BaobabPathButtonPrivate, label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "icon", FALSE, BaobabPathButton_private_offset + G_STRUCT_OFFSET (BaobabPathButtonPrivate, icon));
}

static void
baobab_path_button_instance_init (BaobabPathButton * self,
                                  gpointer klass)
{
	self->priv = baobab_path_button_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
baobab_path_button_finalize (GObject * obj)
{
	BaobabPathButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_PATH_BUTTON, BaobabPathButton);
	G_OBJECT_CLASS (baobab_path_button_parent_class)->finalize (obj);
}

static GType
baobab_path_button_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BaobabPathButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_path_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabPathButton), 0, (GInstanceInitFunc) baobab_path_button_instance_init, NULL };
	GType baobab_path_button_type_id;
	baobab_path_button_type_id = g_type_register_static (gtk_button_get_type (), "BaobabPathButton", &g_define_type_info, 0);
	BaobabPathButton_private_offset = g_type_add_instance_private (baobab_path_button_type_id, sizeof (BaobabPathButtonPrivate));
	return baobab_path_button_type_id;
}

GType
baobab_path_button_get_type (void)
{
	static volatile gsize baobab_path_button_type_id__once = 0;
	if (g_once_init_enter (&baobab_path_button_type_id__once)) {
		GType baobab_path_button_type_id;
		baobab_path_button_type_id = baobab_path_button_get_type_once ();
		g_once_init_leave (&baobab_path_button_type_id__once, baobab_path_button_type_id);
	}
	return baobab_path_button_type_id__once;
}

static inline gpointer
baobab_pathbar_get_instance_private (BaobabPathbar* self)
{
	return G_STRUCT_MEMBER_P (self, BaobabPathbar_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
baobab_pathbar_on_adjustment_changed (BaobabPathbar* self,
                                      GtkAdjustment* adjusment)
{
	static const guint DURATION = (guint) 800;
	AdwPropertyAnimationTarget* target = NULL;
	AdwPropertyAnimationTarget* _tmp0_;
	AdwTimedAnimation* animation = NULL;
	gdouble _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	AdwAnimationTarget* _tmp5_;
	AdwTimedAnimation* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (adjusment != NULL);
	_tmp0_ = (AdwPropertyAnimationTarget*) adw_property_animation_target_new ((GObject*) adjusment, "value");
	target = _tmp0_;
	_tmp1_ = gtk_adjustment_get_value (adjusment);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_adjustment_get_upper (adjusment);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 ((AdwAnimationTarget*) target);
	_tmp6_ = (AdwTimedAnimation*) adw_timed_animation_new ((GtkWidget*) self, _tmp2_, _tmp4_, DURATION, _tmp5_);
	animation = _tmp6_;
	adw_timed_animation_set_easing (animation, ADW_EASE_OUT_CUBIC);
	adw_animation_play ((AdwAnimation*) animation);
	_g_object_unref0 (animation);
	_g_object_unref0 (target);
}

static void
_baobab_pathbar_on_adjustment_changed_gtk_adjustment_changed (GtkAdjustment* _sender,
                                                              gpointer self)
{
	baobab_pathbar_on_adjustment_changed ((BaobabPathbar*) self, _sender);
}

static void
baobab_pathbar_on_page_size_changed (BaobabPathbar* self,
                                     GObject* o,
                                     GParamSpec* spec)
{
	GtkAdjustment* adjustment = NULL;
	GtkAdjustment* _tmp0_;
	gdouble _tmp1_;
	gdouble _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	g_return_if_fail (spec != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (o, gtk_adjustment_get_type (), GtkAdjustment));
	adjustment = _tmp0_;
	_tmp1_ = gtk_adjustment_get_upper (adjustment);
	_tmp2_ = _tmp1_;
	gtk_adjustment_set_value (adjustment, _tmp2_);
	_g_object_unref0 (adjustment);
}

static void
_baobab_pathbar_on_page_size_changed_g_object_notify (GObject* _sender,
                                                      GParamSpec* pspec,
                                                      gpointer self)
{
	baobab_pathbar_on_page_size_changed ((BaobabPathbar*) self, _sender, pspec);
}

static void
baobab_pathbar_clear (BaobabPathbar* self)
{
	g_return_if_fail (self != NULL);
	{
		GtkWidget* child = NULL;
		GtkBox* _tmp0_;
		GtkWidget* _tmp1_;
		GtkWidget* _tmp2_;
		_tmp0_ = self->priv->button_box;
		_tmp1_ = gtk_widget_get_first_child ((GtkWidget*) _tmp0_);
		_tmp2_ = _g_object_ref0 (_tmp1_);
		child = _tmp2_;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GtkWidget* _tmp7_;
				GtkBox* _tmp8_;
				GtkWidget* _tmp9_;
				if (!_tmp3_) {
					GtkBox* _tmp4_;
					GtkWidget* _tmp5_;
					GtkWidget* _tmp6_;
					_tmp4_ = self->priv->button_box;
					_tmp5_ = gtk_widget_get_first_child ((GtkWidget*) _tmp4_);
					_tmp6_ = _g_object_ref0 (_tmp5_);
					_g_object_unref0 (child);
					child = _tmp6_;
				}
				_tmp3_ = FALSE;
				_tmp7_ = child;
				if (!(_tmp7_ != NULL)) {
					break;
				}
				_tmp8_ = self->priv->button_box;
				_tmp9_ = child;
				gtk_box_remove (_tmp8_, _tmp9_);
			}
		}
		_g_object_unref0 (child);
	}
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		BaobabPathbar* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->path);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static void
___lambda7_ (Block3Data* _data3_)
{
	BaobabPathbar* self;
	self = _data3_->self;
	g_signal_emit (self, baobab_pathbar_signals[BAOBAB_PATHBAR_ITEM_ACTIVATED_SIGNAL], 0, _data3_->path);
}

static void
____lambda7__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	___lambda7_ (self);
}

static BaobabPathButton*
baobab_pathbar_make_button (BaobabPathbar* self,
                            BaobabScannerResults* path,
                            gboolean is_current_dir)
{
	Block3Data* _data3_;
	BaobabScannerResults* _tmp0_;
	gchar* label = NULL;
	GIcon* gicon = NULL;
	gboolean _tmp1_ = FALSE;
	BaobabPathButton* button = NULL;
	const gchar* _tmp15_;
	GIcon* _tmp16_;
	BaobabPathButton* _tmp17_;
	gboolean _tmp18_ = FALSE;
	BaobabPathButton* result;
	g_return_val_if_fail (self != NULL, NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (path);
	_g_object_unref0 (_data3_->path);
	_data3_->path = _tmp0_;
	gicon = NULL;
	if (_data3_->path == NULL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = baobab_scanner_results_get_depth (_data3_->path) == 1;
	}
	if (_tmp1_) {
		BaobabLocation* _tmp2_;
		BaobabLocation* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		BaobabLocation* _tmp7_;
		BaobabLocation* _tmp8_;
		GIcon* _tmp9_;
		GIcon* _tmp10_;
		GIcon* _tmp11_;
		_tmp2_ = baobab_pathbar_get_location (self);
		_tmp3_ = _tmp2_;
		_tmp4_ = baobab_location_get_name (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (label);
		label = _tmp6_;
		_tmp7_ = baobab_pathbar_get_location (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = baobab_location_get_symbolic_icon (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = _g_object_ref0 (_tmp10_);
		_g_object_unref0 (gicon);
		gicon = _tmp11_;
	} else {
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		_tmp12_ = baobab_scanner_results_get_display_name (_data3_->path);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strdup (_tmp13_);
		_g_free0 (label);
		label = _tmp14_;
	}
	_tmp15_ = label;
	_tmp16_ = gicon;
	_tmp17_ = baobab_path_button_new (_tmp15_, _tmp16_, is_current_dir);
	g_object_ref_sink (_tmp17_);
	button = _tmp17_;
	if (_data3_->path != NULL) {
		_tmp18_ = !is_current_dir;
	} else {
		_tmp18_ = FALSE;
	}
	if (_tmp18_) {
		BaobabPathButton* _tmp19_;
		_tmp19_ = button;
		g_signal_connect_data ((GtkButton*) _tmp19_, "clicked", (GCallback) ____lambda7__gtk_button_clicked, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
	}
	result = button;
	_g_object_unref0 (gicon);
	_g_free0 (label);
	block3_data_unref (_data3_);
	_data3_ = NULL;
	return result;
}

BaobabPathbar*
baobab_pathbar_construct (GType object_type)
{
	BaobabPathbar * self = NULL;
	self = (BaobabPathbar*) g_object_new (object_type, NULL);
	return self;
}

BaobabPathbar*
baobab_pathbar_new (void)
{
	return baobab_pathbar_construct (BAOBAB_TYPE_PATHBAR);
}

BaobabLocation*
baobab_pathbar_get_location (BaobabPathbar* self)
{
	BaobabLocation* result;
	BaobabLocation* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->location_;
	result = _tmp0_;
	return result;
}

static gpointer
_baobab_location_ref0 (gpointer self)
{
	return self ? baobab_location_ref (self) : NULL;
}

void
baobab_pathbar_set_location (BaobabPathbar* self,
                             BaobabLocation* value)
{
	BaobabLocation* _tmp0_;
	BaobabLocation* _tmp1_;
	BaobabLocation* _tmp2_;
	BaobabScanner* _tmp3_;
	BaobabScanner* _tmp4_;
	BaobabScannerResults* _tmp5_;
	BaobabScannerResults* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _baobab_location_ref0 (value);
	_baobab_location_unref0 (self->priv->location_);
	self->priv->location_ = _tmp0_;
	_tmp1_ = baobab_pathbar_get_location (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = baobab_location_get_scanner (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = baobab_scanner_get_root (_tmp4_);
	_tmp6_ = _tmp5_;
	baobab_pathbar_set_path (self, _tmp6_);
	g_object_notify_by_pspec ((GObject *) self, baobab_pathbar_properties[BAOBAB_PATHBAR_LOCATION_PROPERTY]);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

void
baobab_pathbar_set_path (BaobabPathbar* self,
                         BaobabScannerResults* value)
{
	gboolean _tmp0_ = FALSE;
	BaobabLocation* _tmp1_;
	BaobabLocation* _tmp2_;
	BaobabScannerResults* path_tmp = NULL;
	BaobabScannerResults* _tmp7_;
	GList* buttons = NULL;
	gboolean is_current_dir = FALSE;
	gboolean first_directory = FALSE;
	GList* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp1_ = baobab_pathbar_get_location (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		BaobabLocation* _tmp3_;
		BaobabLocation* _tmp4_;
		BaobabScanner* _tmp5_;
		BaobabScanner* _tmp6_;
		_tmp3_ = baobab_pathbar_get_location (self);
		_tmp4_ = _tmp3_;
		_tmp5_ = baobab_location_get_scanner (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ == NULL;
	}
	if (_tmp0_) {
		return;
	}
	baobab_pathbar_clear (self);
	_tmp7_ = _g_object_ref0 (value);
	path_tmp = _tmp7_;
	buttons = NULL;
	is_current_dir = TRUE;
	{
		gboolean _tmp8_ = FALSE;
		_tmp8_ = TRUE;
		while (TRUE) {
			BaobabScannerResults* _tmp10_;
			BaobabPathButton* _tmp11_;
			BaobabScannerResults* _tmp12_;
			BaobabScannerResults* _tmp13_;
			BaobabScannerResults* _tmp14_;
			BaobabScannerResults* _tmp15_;
			if (!_tmp8_) {
				BaobabScannerResults* _tmp9_;
				_tmp9_ = path_tmp;
				if (!(_tmp9_ != NULL)) {
					break;
				}
			}
			_tmp8_ = FALSE;
			_tmp10_ = path_tmp;
			_tmp11_ = baobab_pathbar_make_button (self, _tmp10_, is_current_dir);
			buttons = g_list_prepend (buttons, _tmp11_);
			_tmp12_ = path_tmp;
			_tmp13_ = baobab_scanner_results_get_parent (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = _g_object_ref0 (_tmp14_);
			_g_object_unref0 (path_tmp);
			path_tmp = _tmp15_;
			is_current_dir = FALSE;
		}
	}
	first_directory = TRUE;
	_tmp16_ = buttons;
	{
		GList* button_collection = NULL;
		GList* button_it = NULL;
		button_collection = _tmp16_;
		for (button_it = button_collection; button_it != NULL; button_it = button_it->next) {
			BaobabPathButton* _tmp17_;
			BaobabPathButton* button = NULL;
			_tmp17_ = _g_object_ref0 ((BaobabPathButton*) button_it->data);
			button = _tmp17_;
			{
				GtkBox* box = NULL;
				GtkBox* _tmp18_;
				GtkBox* _tmp23_;
				BaobabPathButton* _tmp24_;
				GtkBox* _tmp25_;
				GtkBox* _tmp26_;
				_tmp18_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
				g_object_ref_sink (_tmp18_);
				box = _tmp18_;
				if (!first_directory) {
					GtkLabel* label = NULL;
					GtkLabel* _tmp19_;
					GtkLabel* _tmp20_;
					GtkBox* _tmp21_;
					GtkLabel* _tmp22_;
					_tmp19_ = (GtkLabel*) gtk_label_new (G_DIR_SEPARATOR_S);
					g_object_ref_sink (_tmp19_);
					label = _tmp19_;
					_tmp20_ = label;
					gtk_widget_add_css_class ((GtkWidget*) _tmp20_, "dim-label");
					_tmp21_ = box;
					_tmp22_ = label;
					gtk_box_append (_tmp21_, (GtkWidget*) _tmp22_);
					_g_object_unref0 (label);
				}
				_tmp23_ = box;
				_tmp24_ = button;
				gtk_box_append (_tmp23_, (GtkWidget*) _tmp24_);
				_tmp25_ = self->priv->button_box;
				_tmp26_ = box;
				gtk_box_append (_tmp25_, (GtkWidget*) _tmp26_);
				first_directory = FALSE;
				_g_object_unref0 (box);
				_g_object_unref0 (button);
			}
		}
	}
	(buttons == NULL) ? NULL : (buttons = (_g_list_free__g_object_unref0_ (buttons), NULL));
	_g_object_unref0 (path_tmp);
	g_object_notify_by_pspec ((GObject *) self, baobab_pathbar_properties[BAOBAB_PATHBAR_PATH_PROPERTY]);
}

static void
baobab_pathbar_class_init (BaobabPathbarClass * klass,
                           gpointer klass_data)
{
	baobab_pathbar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BaobabPathbar_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_baobab_pathbar_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_baobab_pathbar_set_property;
	G_OBJECT_CLASS (klass)->finalize = baobab_pathbar_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_PATHBAR_LOCATION_PROPERTY, baobab_pathbar_properties[BAOBAB_PATHBAR_LOCATION_PROPERTY] = baobab_param_spec_location ("location", "location", "location", BAOBAB_TYPE_LOCATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BAOBAB_PATHBAR_PATH_PROPERTY, baobab_pathbar_properties[BAOBAB_PATHBAR_PATH_PROPERTY] = g_param_spec_object ("path", "path", "path", BAOBAB_SCANNER_TYPE_RESULTS, G_PARAM_STATIC_STRINGS | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/baobab/ui/baobab-pathbar.ui");
	baobab_pathbar_signals[BAOBAB_PATHBAR_ITEM_ACTIVATED_SIGNAL] = g_signal_new ("item-activated", BAOBAB_TYPE_PATHBAR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, BAOBAB_SCANNER_TYPE_RESULTS);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "button_box", FALSE, BaobabPathbar_private_offset + G_STRUCT_OFFSET (BaobabPathbarPrivate, button_box));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_adjustment_changed", G_CALLBACK(_baobab_pathbar_on_adjustment_changed_gtk_adjustment_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_page_size_changed", G_CALLBACK(_baobab_pathbar_on_page_size_changed_g_object_notify));
}

static void
baobab_pathbar_instance_init (BaobabPathbar * self,
                              gpointer klass)
{
	self->priv = baobab_pathbar_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
baobab_pathbar_finalize (GObject * obj)
{
	BaobabPathbar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BAOBAB_TYPE_PATHBAR, BaobabPathbar);
	_baobab_location_unref0 (self->priv->location_);
	G_OBJECT_CLASS (baobab_pathbar_parent_class)->finalize (obj);
}

static GType
baobab_pathbar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BaobabPathbarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) baobab_pathbar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BaobabPathbar), 0, (GInstanceInitFunc) baobab_pathbar_instance_init, NULL };
	GType baobab_pathbar_type_id;
	baobab_pathbar_type_id = g_type_register_static (gtk_box_get_type (), "BaobabPathbar", &g_define_type_info, 0);
	BaobabPathbar_private_offset = g_type_add_instance_private (baobab_pathbar_type_id, sizeof (BaobabPathbarPrivate));
	return baobab_pathbar_type_id;
}

GType
baobab_pathbar_get_type (void)
{
	static volatile gsize baobab_pathbar_type_id__once = 0;
	if (g_once_init_enter (&baobab_pathbar_type_id__once)) {
		GType baobab_pathbar_type_id;
		baobab_pathbar_type_id = baobab_pathbar_get_type_once ();
		g_once_init_leave (&baobab_pathbar_type_id__once, baobab_pathbar_type_id);
	}
	return baobab_pathbar_type_id__once;
}

static void
_vala_baobab_pathbar_get_property (GObject * object,
                                   guint property_id,
                                   GValue * value,
                                   GParamSpec * pspec)
{
	BaobabPathbar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_PATHBAR, BaobabPathbar);
	switch (property_id) {
		case BAOBAB_PATHBAR_LOCATION_PROPERTY:
		baobab_value_set_location (value, baobab_pathbar_get_location (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_baobab_pathbar_set_property (GObject * object,
                                   guint property_id,
                                   const GValue * value,
                                   GParamSpec * pspec)
{
	BaobabPathbar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BAOBAB_TYPE_PATHBAR, BaobabPathbar);
	switch (property_id) {
		case BAOBAB_PATHBAR_LOCATION_PROPERTY:
		baobab_pathbar_set_location (self, baobab_value_get_location (value));
		break;
		case BAOBAB_PATHBAR_PATH_PROPERTY:
		baobab_pathbar_set_path (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

