/* do not edit automatically generated by mc from M2Base.  */
/* M2Base.def provides a mechanism to check fundamental types.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */


#if !defined (_M2Base_H)
#   define _M2Base_H

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GNameKey.h"
#   include "Ggcctypes.h"

#   if defined (_M2Base_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif

EXTERN unsigned int M2Base_TemplateProcedure;
EXTERN unsigned int M2Base_ActivationPointer;
EXTERN unsigned int M2Base_Nil;
EXTERN unsigned int M2Base_Cardinal;
EXTERN unsigned int M2Base_Integer;
EXTERN unsigned int M2Base_Boolean;
EXTERN unsigned int M2Base_True;
EXTERN unsigned int M2Base_False;
EXTERN unsigned int M2Base_Char;
EXTERN unsigned int M2Base_Proc;
EXTERN unsigned int M2Base_LongInt;
EXTERN unsigned int M2Base_LongCard;
EXTERN unsigned int M2Base_ShortInt;
EXTERN unsigned int M2Base_ShortCard;
EXTERN unsigned int M2Base_ZType;
EXTERN unsigned int M2Base_RType;
EXTERN unsigned int M2Base_CType;
EXTERN unsigned int M2Base_Real;
EXTERN unsigned int M2Base_LongReal;
EXTERN unsigned int M2Base_ShortReal;
EXTERN unsigned int M2Base_Complex;
EXTERN unsigned int M2Base_LongComplex;
EXTERN unsigned int M2Base_ShortComplex;
EXTERN unsigned int M2Base_High;
EXTERN unsigned int M2Base_LengthS;
EXTERN unsigned int M2Base_Cap;
EXTERN unsigned int M2Base_Abs;
EXTERN unsigned int M2Base_Odd;
EXTERN unsigned int M2Base_Convert;
EXTERN unsigned int M2Base_Val;
EXTERN unsigned int M2Base_Chr;
EXTERN unsigned int M2Base_Re;
EXTERN unsigned int M2Base_Im;
EXTERN unsigned int M2Base_Cmplx;
EXTERN unsigned int M2Base_Min;
EXTERN unsigned int M2Base_Max;
EXTERN unsigned int M2Base_New;
EXTERN unsigned int M2Base_Dispose;
EXTERN unsigned int M2Base_Inc;
EXTERN unsigned int M2Base_Dec;
EXTERN unsigned int M2Base_Incl;
EXTERN unsigned int M2Base_Excl;
EXTERN unsigned int M2Base_ExceptionAssign;
EXTERN unsigned int M2Base_ExceptionReturn;
EXTERN unsigned int M2Base_ExceptionInc;
EXTERN unsigned int M2Base_ExceptionDec;
EXTERN unsigned int M2Base_ExceptionIncl;
EXTERN unsigned int M2Base_ExceptionExcl;
EXTERN unsigned int M2Base_ExceptionShift;
EXTERN unsigned int M2Base_ExceptionRotate;
EXTERN unsigned int M2Base_ExceptionStaticArray;
EXTERN unsigned int M2Base_ExceptionDynamicArray;
EXTERN unsigned int M2Base_ExceptionForLoopBegin;
EXTERN unsigned int M2Base_ExceptionForLoopTo;
EXTERN unsigned int M2Base_ExceptionForLoopEnd;
EXTERN unsigned int M2Base_ExceptionPointerNil;
EXTERN unsigned int M2Base_ExceptionNoReturn;
EXTERN unsigned int M2Base_ExceptionCase;
EXTERN unsigned int M2Base_ExceptionNonPosDiv;
EXTERN unsigned int M2Base_ExceptionNonPosMod;
EXTERN unsigned int M2Base_ExceptionZeroDiv;
EXTERN unsigned int M2Base_ExceptionZeroRem;
EXTERN unsigned int M2Base_ExceptionWholeValue;
EXTERN unsigned int M2Base_ExceptionRealValue;
EXTERN unsigned int M2Base_ExceptionParameterBounds;
EXTERN unsigned int M2Base_ExceptionNo;

/*
   InitBase - initializes the base types and functions
              used in the Modula-2 compiler.
*/

EXTERN void M2Base_InitBase (location_t location, unsigned int *sym);

/*
   GetBaseTypeMinMax - returns the minimum and maximum values for a
                       given base type.  This procedure should only
                       be called if the type is NOT a subrange.
*/

EXTERN void M2Base_GetBaseTypeMinMax (unsigned int type, unsigned int *min, unsigned int *max);

/*
   IsPseudoBaseFunction - returns true if Sym is a Base function.
*/

EXTERN bool M2Base_IsPseudoBaseFunction (unsigned int Sym);

/*
   IsPseudoBaseProcedure - returns true if Sym is a Base procedure.
*/

EXTERN bool M2Base_IsPseudoBaseProcedure (unsigned int Sym);

/*
   IsNeededAtRunTime - returns TRUE if procedure, sym, is a
                       runtime procedure. Ie a procedure which is
                       not a pseudo procedure and which is implemented
                       in M2RTS or SYSTEM and also exported.
*/

EXTERN bool M2Base_IsNeededAtRunTime (unsigned int tok, unsigned int sym);

/*
   IsBaseType - returns TRUE if Sym is a Base type.
*/

EXTERN bool M2Base_IsBaseType (unsigned int Sym);

/*
   IsOrdinalType - returns TRUE if, sym, is an ordinal type.
                   An ordinal type is defined as:
                   a base type which contains whole numbers or
                   a subrange type or an enumeration type.
*/

EXTERN bool M2Base_IsOrdinalType (unsigned int Sym);

/*
   IsOrd - returns TRUE if, sym, is ORD or its typed counterparts
           ORDL, ORDS.
*/

EXTERN bool M2Base_IsOrd (unsigned int sym);

/*
   IsTrunc - returns TRUE if, sym, is TRUNC or its typed counterparts
             TRUNCL, TRUNCS.
*/

EXTERN bool M2Base_IsTrunc (unsigned int sym);

/*
   IsFloat - returns TRUE if, sym, is FLOAT or its typed counterparts
             FLOATL, FLOATS.
*/

EXTERN bool M2Base_IsFloat (unsigned int sym);

/*
   IsInt - returns TRUE if, sym, is INT or its typed counterparts
           INTL, INTS.
*/

EXTERN bool M2Base_IsInt (unsigned int sym);

/*
   AssignmentRequiresWarning - returns TRUE if t1 and t2 can be used during
                               an assignment, but should generate a warning.
                               For example in PIM we can assign ADDRESS
                               and WORD providing they are both the
                               same size.
*/

EXTERN bool M2Base_AssignmentRequiresWarning (unsigned int t1, unsigned int t2);

/*
   IsAssignmentCompatible - returns TRUE if t1 and t2 are assignment
                            compatible.
*/

EXTERN bool M2Base_IsAssignmentCompatible (unsigned int t1, unsigned int t2);

/*
   IsExpressionCompatible - returns TRUE if t1 and t2 are expression
                            compatible.
*/

EXTERN bool M2Base_IsExpressionCompatible (unsigned int t1, unsigned int t2);

/*
   IsParameterCompatible - returns TRUE if types t1 and t2 are parameter
                           compatible.
*/

EXTERN bool M2Base_IsParameterCompatible (unsigned int t1, unsigned int t2);

/*
   IsComparisonCompatible - returns TRUE if t1 and t2 are comparison
                            compatible.  PIM allows INTEGER and ADDRESS within
                            expressions but we warn against their comparison.
*/

EXTERN bool M2Base_IsComparisonCompatible (unsigned int t1, unsigned int t2);

/*
   IsValidParameter - returns TRUE if an, actual, parameter can be passed
                      to the, formal, parameter.   This differs from
                      IsParameterCompatible as this procedure includes checks
                      for unbounded formal parameters, var parameters and
                      constant actual parameters.
*/

EXTERN bool M2Base_IsValidParameter (unsigned int formal, unsigned int actual);

/*
   CheckExpressionCompatible - returns if t1 and t2 are compatible types for
                               +, -, *, DIV, >, <, =, etc.
                               If t1 and t2 are not compatible then an error
                               message is displayed.
*/

EXTERN void M2Base_CheckExpressionCompatible (unsigned int tok, unsigned int left, unsigned int right);

/*
   CheckAssignmentCompatible - returns if t1 and t2 are compatible types for
                               :=, =, #.
                               If t1 and t2 are not compatible then an error
                               message is displayed.
*/

EXTERN void M2Base_CheckAssignmentCompatible (unsigned int tok, unsigned int left, unsigned int right);

/*
   CheckParameterCompatible - checks to see if types, t1, and, t2, are
                              compatible for parameter passing.
*/

EXTERN void M2Base_CheckParameterCompatible (unsigned int tok, unsigned int t1, unsigned int t2);

/*
   CannotCheckTypeInPass3 - returns TRUE if we are unable to check the
                            type of, e, in pass 3.
*/

EXTERN bool M2Base_CannotCheckTypeInPass3 (unsigned int e);

/*
   MixTypes - given types leftType and rightType return a type symbol that
              provides expression type compatibility.
              NearTok is used to identify the source position if a type
              incompatability occurs.
*/

EXTERN unsigned int M2Base_MixTypes (unsigned int leftType, unsigned int rightType, unsigned int NearTok);

/*
   MixTypesDecl - returns a type symbol which provides expression compatibility
                  between leftType and rightType.  An error is emitted if this
                  is not possible.  left and right are the source (variable,
                  constant) of leftType and rightType respectively.
*/

EXTERN unsigned int M2Base_MixTypesDecl (unsigned int left, unsigned int right, unsigned int leftType, unsigned int rightType, unsigned int NearTok);

/*
   NegateType - if the type is unsigned then returns the
                signed equivalent.
*/

EXTERN unsigned int M2Base_NegateType (unsigned int type);

/*
   IsMathType - returns TRUE if the type is a mathematical type.
                A mathematical type has a range larger than INTEGER.
                (Typically REAL/LONGREAL/LONGINT)
*/

EXTERN bool M2Base_IsMathType (unsigned int type);

/*
   IsRealType - returns TRUE if, t, is a real type.
*/

EXTERN bool M2Base_IsRealType (unsigned int t);

/*
   IsComplexType - returns TRUE if, sym, is COMPLEX,
                   LONGCOMPLEX or SHORTCOMPLEX.
*/

EXTERN bool M2Base_IsComplexType (unsigned int sym);

/*
   ComplexToScalar - returns the scalar (or base type) of the complex type, sym.
*/

EXTERN unsigned int M2Base_ComplexToScalar (unsigned int sym);

/*
   ScalarToComplex - given a real type, t, return the equivalent complex type.
*/

EXTERN unsigned int M2Base_ScalarToComplex (unsigned int sym);

/*
   GetCmplxReturnType - this code implements the table given in the
                        ISO standard Page 293 with an addition for
                        SHORTCOMPLEX and the fixed sized COMPLEX
                        types found in the GNU Modula-2 SYSTEM
                        Module.
*/

EXTERN unsigned int M2Base_GetCmplxReturnType (unsigned int t1, unsigned int t2);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
