/* do not edit automatically generated by mc from PathName.  */
/* 
   DumpPath - debugging dump of the pathlist.
  */


#if !defined (_PathName_H)
#   define _PathName_H

#include "config.h"
#include "system.h"
#   ifdef __cplusplus
extern "C" {
#   endif
#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   include "GDynamicStrings.h"
#   include "GDynamicPath.h"

#   if defined (_PathName_C)
#      define EXTERN
#   else
#      define EXTERN extern
#   endif

#if !defined (PathName_NamedPath_D)
#  define PathName_NamedPath_D
   typedef void *PathName_NamedPath;
#endif


/*
   FindNamedPathFile - returns NIL if a file cannot be found otherwise
                       it returns the path including the filename.
                       It also returns the name of the path.
*/

EXTERN DynamicStrings_String PathName_FindNamedPathFile (DynamicStrings_String filename, DynamicStrings_String *name);

/*
   AddInclude - adds include path to the named path.  If named path
                is the same as the previous call then the include path
                is appended to the named path PathList otherwise a new
                named path is created and placed at the end of the
                named path list.

                However if named is NIL or empty string then this is treated
                as a user path and it will be appended to the first user
                named list entry.  The user entry will always be the
                first node in the dictionary of named paths.
*/

EXTERN void PathName_AddInclude (DynamicStrings_String named, DynamicStrings_String directory);

/*
   InitNamedPath - creates a new path name with an associated pathlist.
*/

EXTERN PathName_NamedPath PathName_InitNamedPath (DynamicStrings_String name, DynamicPath_PathList pl);

/*
   KillNamedPath - places list np onto the freelist.
                   Postcondition: np will be NIL.
*/

EXTERN void PathName_KillNamedPath (PathName_NamedPath *np);

/*
   Cons - appends pl to the end of a named path.
          If np is NIL a new list is created and returned
          containing named and pl.
*/

EXTERN PathName_NamedPath PathName_Cons (PathName_NamedPath np, DynamicStrings_String named, DynamicPath_PathList pl);

/*
   ConsList - concatenates named path left and right together.
*/

EXTERN PathName_NamedPath PathName_ConsList (PathName_NamedPath left, PathName_NamedPath right);

/*
   Stash - returns np before setting np to NIL.
*/

EXTERN PathName_NamedPath PathName_Stash (PathName_NamedPath *np);

/*
   SetNamedPath - assigns the named path to the default path.
*/

EXTERN void PathName_SetNamedPath (PathName_NamedPath named);

/*
   GetNamedPath - returns the default named path.
*/

EXTERN PathName_NamedPath PathName_GetNamedPath (void);

/*
   DumpPathName - display the dictionary of names and all path entries.
*/

EXTERN void PathName_DumpPathName (const char *name_, unsigned int _name_high);
#   ifdef __cplusplus
}
#   endif

#   undef EXTERN
#endif
