/* do not edit automatically generated by mc from M2Code.  */
/* M2Code.mod coordinate the activity of the front end.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#define _M2Code_C

#include "GM2Code.h"
#   include "GSYSTEM.h"
#   include "GM2Options.h"
#   include "GM2LangDump.h"
#   include "GM2Error.h"
#   include "GM2Students.h"
#   include "GSymbolTable.h"
#   include "GM2Printf.h"
#   include "GNameKey.h"
#   include "GM2Batch.h"
#   include "GM2Quads.h"
#   include "GM2SymInit.h"
#   include "GM2Pass.h"
#   include "GM2BasicBlock.h"
#   include "GM2Optimize.h"
#   include "GM2GenGCC.h"
#   include "GM2GCCDeclare.h"
#   include "GM2Scope.h"
#   include "Gm2top.h"
#   include "GM2Swig.h"
#   include "Gm2flex.h"
#   include "GFIO.h"
#   include "GM2Quiet.h"
#   include "GM2SSA.h"
#   include "Gm2pp.h"
#   include "GDynamicStrings.h"

#   define MaxOptimTimes 10
#   define Debugging true
#   define TraceQuadruples false
static unsigned int Total;
static unsigned int Count;
static unsigned int OptimTimes;
static unsigned int DeltaProc;
static unsigned int Proc;
static unsigned int DeltaConst;
static unsigned int Const;
static unsigned int DeltaJump;
static unsigned int Jump;
static unsigned int DeltaBasicB;
static unsigned int BasicB;

/*
   Code - calls procedures to generates trees from the quadruples.
          All front end quadruple optimization is performed via this call.
*/

extern "C" void M2Code_Code (void);

/*
   CodeBlock - generates all code for this block and also declares
               all types and procedures for this block. It will
               also optimize quadruples within this scope.
*/

extern "C" void M2Code_CodeBlock (unsigned int scope);

/*
   Percent - calculates the percentage from numerator and divisor
*/

static void Percent (unsigned int numerator, unsigned int divisor);

/*
   OptimizationAnalysis - displays some simple front end optimization statistics.
*/

static void OptimizationAnalysis (void);

/*
   RemoveUnreachableCode -
*/

static void RemoveUnreachableCode (void);

/*
   DoModuleDeclare - declare all constants, types, variables, procedures for the
                     main module or all modules.
*/

static void DoModuleDeclare (void);

/*
   DoCodeBlock - generate code for the main module or all modules.
*/

static void DoCodeBlock (void);

/*
   DetermineSubExpTemporaries -
*/

static void DetermineSubExpTemporaries (void);
static void InitialDeclareAndOptimize (unsigned int scope, unsigned int start, unsigned int end);
static void SecondDeclareAndOptimize (unsigned int scope, unsigned int start, unsigned int end);

/*
   InitOptimizeVariables -
*/

static void InitOptimizeVariables (void);

/*
   Init -
*/

static void Init (void);

/*
   OptimizeScopeBlock -
*/

static void OptimizeScopeBlock (M2Scope_ScopeBlock sb);

/*
   CodeProceduresWithinBlock - codes the procedures within the module scope.
*/

static void CodeProceduresWithinBlock (unsigned int scope);

/*
   CodeProcedures -
*/

static void CodeProcedures (unsigned int scope);


/*
   Percent - calculates the percentage from numerator and divisor
*/

static void Percent (unsigned int numerator, unsigned int divisor)
{
  unsigned int value;

  M2Printf_printf0 ((const char *) "  (", 3);
  if (divisor == 0)
    {
      M2Printf_printf0 ((const char *) "overflow error", 14);
    }
  else
    {
      value = (numerator*100) / divisor;
      M2Printf_printf1 ((const char *) "%3d", 3, (const unsigned char *) &value, (sizeof (value)-1));
    }
  M2Printf_printf0 ((const char *) "\\%)", 3);
}


/*
   OptimizationAnalysis - displays some simple front end optimization statistics.
*/

static void OptimizationAnalysis (void)
{
  unsigned int value;

  if (M2Options_Statistics)
    {
      Count = M2Quads_CountQuads ();
      M2Printf_printf1 ((const char *) "M2 initial number of quadruples: %6d", 36, (const unsigned char *) &Total, (sizeof (Total)-1));
      Percent (Total, Total);
      M2Printf_printf0 ((const char *) "\\n", 2);
      M2Printf_printf1 ((const char *) "M2 constant folding achieved   : %6d", 36, (const unsigned char *) &Const, (sizeof (Const)-1));
      Percent (Const, Total);
      M2Printf_printf0 ((const char *) "\\n", 2);
      M2Printf_printf1 ((const char *) "M2 branch folding achieved     : %6d", 36, (const unsigned char *) &Jump, (sizeof (Jump)-1));
      Percent (Jump, Total);
      M2Printf_printf0 ((const char *) "\\n", 2);
      value = (Const+Jump)+Proc;
      M2Printf_printf1 ((const char *) "Front end optimization removed : %6d", 36, (const unsigned char *) &value, (sizeof (value)-1));
      Percent (value, Total);
      M2Printf_printf0 ((const char *) "\\n", 2);
      M2Printf_printf1 ((const char *) "Front end final                : %6d", 36, (const unsigned char *) &Count, (sizeof (Count)-1));
      Percent (Count, Total);
      M2Printf_printf0 ((const char *) "\\n", 2);
      Count = m2flex_GetTotalLines ();
      M2Printf_printf1 ((const char *) "Total source lines compiled    : %6d\\n", 38, (const unsigned char *) &Count, (sizeof (Count)-1));
      FIO_FlushBuffer (FIO_StdOut);
    }
  M2Quads_DumpQuadruples ((const char *) "after all front end optimization\\n", 34);
}


/*
   RemoveUnreachableCode -
*/

static void RemoveUnreachableCode (void)
{
  if (M2Options_WholeProgram)
    {
      M2Batch_ForeachSourceModuleDo ((M2Batch_DoProcedure) {(M2Batch_DoProcedure_t) M2Optimize_RemoveProcedures});
    }
  else
    {
      M2Optimize_RemoveProcedures (SymbolTable_GetMainModule ());
    }
}


/*
   DoModuleDeclare - declare all constants, types, variables, procedures for the
                     main module or all modules.
*/

static void DoModuleDeclare (void)
{
  if (M2Options_GetDumpDecl ())
    {
      M2LangDump_CreateDumpDecl ((const char *) "symbol resolver of filtered symbols\\n", 37);
      M2GCCDeclare_DumpFilteredResolver ();
    }
  if (M2Options_WholeProgram)
    {
      M2Batch_ForeachSourceModuleDo ((M2Batch_DoProcedure) {(M2Batch_DoProcedure_t) M2GCCDeclare_StartDeclareScope});
    }
  else
    {
      M2GCCDeclare_StartDeclareScope (SymbolTable_GetMainModule ());
    }
  if (M2Options_GetDumpDecl ())
    {
      M2LangDump_CloseDumpDecl ();
      M2LangDump_CreateDumpDecl ((const char *) "definitive declaration of filtered symbols\\n", 44);
      M2GCCDeclare_DumpFilteredDefinitive ();
      M2LangDump_CloseDumpDecl ();
    }
}


/*
   DoCodeBlock - generate code for the main module or all modules.
*/

static void DoCodeBlock (void)
{
  DynamicStrings_String filename;
  unsigned int len;

  if (M2Options_GetDumpGimple ())
    {
      filename = M2LangDump_MakeGimpleTemplate (&len);
      m2pp_CreateDumpGimple (reinterpret_cast <void *> (filename), len);
      filename = DynamicStrings_KillString (filename);
      M2Code_CodeBlock (SymbolTable_GetMainModule ());
      m2pp_CloseDumpGimple ();
    }
  else
    {
      M2Code_CodeBlock (SymbolTable_GetMainModule ());
    }
}


/*
   DetermineSubExpTemporaries -
*/

static void DetermineSubExpTemporaries (void)
{
  if (M2Options_WholeProgram)
    {
      M2Batch_ForeachSourceModuleDo ((M2Batch_DoProcedure) {(M2Batch_DoProcedure_t) M2SSA_DiscoverSSA});
    }
  else
    {
      M2SSA_DiscoverSSA (SymbolTable_GetMainModule ());
    }
}

static void InitialDeclareAndOptimize (unsigned int scope, unsigned int start, unsigned int end)
{
  /* 
   InitialDeclareAndCodeBlock - declares all objects within scope,
  */
  Count = M2Quads_CountQuads ();
  M2BasicBlock_FreeBasicBlocks (M2BasicBlock_InitBasicBlocksFromRange (scope, start, end));
  BasicB = Count-(M2Quads_CountQuads ());
  Count = M2Quads_CountQuads ();
  M2Optimize_FoldBranches (start, end);
  Jump = Count-(M2Quads_CountQuads ());
  Count = M2Quads_CountQuads ();
}

static void SecondDeclareAndOptimize (unsigned int scope, unsigned int start, unsigned int end)
{
  M2BasicBlock_BasicBlock bb;

  /* 
   DeclareAndCodeBlock - declares all objects within scope,
  */
  do {
    bb = M2BasicBlock_InitBasicBlocksFromRange (scope, start, end);
    M2BasicBlock_ForeachBasicBlockDo (bb, (M2BasicBlock_BasicBlockProc) {(M2BasicBlock_BasicBlockProc_t) M2GCCDeclare_FoldConstants});
    M2BasicBlock_FreeBasicBlocks (bb);
    DeltaConst = Count-(M2Quads_CountQuads ());
    Count = M2Quads_CountQuads ();
    M2BasicBlock_FreeBasicBlocks (M2BasicBlock_InitBasicBlocksFromRange (scope, start, end));
    DeltaBasicB = Count-(M2Quads_CountQuads ());
    Count = M2Quads_CountQuads ();
    M2BasicBlock_FreeBasicBlocks (M2BasicBlock_InitBasicBlocksFromRange (scope, start, end));
    M2Optimize_FoldBranches (start, end);
    DeltaJump = Count-(M2Quads_CountQuads ());
    Count = M2Quads_CountQuads ();
    M2BasicBlock_FreeBasicBlocks (M2BasicBlock_InitBasicBlocksFromRange (scope, start, end));
    DeltaBasicB += Count-(M2Quads_CountQuads ());
    Count = M2Quads_CountQuads ();
    /* now total the optimization components  */
    Proc += DeltaProc;
    Const += DeltaConst;
    Jump += DeltaJump;
    BasicB += DeltaBasicB;
  } while (! ((OptimTimes >= MaxOptimTimes) || ((((DeltaProc == 0) && (DeltaConst == 0)) && (DeltaJump == 0)) && (DeltaBasicB == 0))));
  if ((((DeltaProc != 0) || (DeltaConst != 0)) || (DeltaJump != 0)) || (DeltaBasicB != 0))
    {
      M2Printf_printf0 ((const char *) "optimization finished although more reduction may be possible (increase MaxOptimTimes)\\n", 88);
    }
}


/*
   InitOptimizeVariables -
*/

static void InitOptimizeVariables (void)
{
  Count = M2Quads_CountQuads ();
  OptimTimes = 0;
  DeltaProc = 0;
  DeltaConst = 0;
  DeltaJump = 0;
  DeltaBasicB = 0;
}


/*
   Init -
*/

static void Init (void)
{
  Proc = 0;
  Const = 0;
  Jump = 0;
  BasicB = 0;
}


/*
   OptimizeScopeBlock -
*/

static void OptimizeScopeBlock (M2Scope_ScopeBlock sb)
{
  unsigned int OptimTimes;
  unsigned int Previous;
  unsigned int Current;

  InitOptimizeVariables ();
  OptimTimes = 1;
  Current = M2Quads_CountQuads ();
  M2Scope_ForeachScopeBlockDo3 (sb, (M2Scope_ScopeProcedure3) {(M2Scope_ScopeProcedure3_t) InitialDeclareAndOptimize});
  M2Scope_ForeachScopeBlockDo3 (sb, (M2Scope_ScopeProcedure3) {(M2Scope_ScopeProcedure3_t) M2SymInit_ScopeBlockVariableAnalysis});
  do {
    M2Scope_ForeachScopeBlockDo3 (sb, (M2Scope_ScopeProcedure3) {(M2Scope_ScopeProcedure3_t) SecondDeclareAndOptimize});
    Previous = Current;
    Current = M2Quads_CountQuads ();
    OptimTimes += 1;
  } while (! ((OptimTimes == MaxOptimTimes) || (Current == Previous)));
  M2Scope_ForeachScopeBlockDo3 (sb, (M2Scope_ScopeProcedure3) {(M2Scope_ScopeProcedure3_t) M2Quads_LoopAnalysis});
}


/*
   CodeProceduresWithinBlock - codes the procedures within the module scope.
*/

static void CodeProceduresWithinBlock (unsigned int scope)
{
  SymbolTable_ForeachProcedureDo (scope, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) M2Code_CodeBlock});
}


/*
   CodeProcedures -
*/

static void CodeProcedures (unsigned int scope)
{
  if ((SymbolTable_IsDefImp (scope)) || (SymbolTable_IsModule (scope)))
    {
      SymbolTable_ForeachProcedureDo (scope, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) M2Code_CodeBlock});
    }
}


/*
   Code - calls procedures to generates trees from the quadruples.
          All front end quadruple optimization is performed via this call.
*/

extern "C" void M2Code_Code (void)
{
  M2Quads_DumpQuadruples ((const char *) "before any optimization\\n", 25);
  SymbolTable_CheckHiddenTypeAreAddress ();
  M2Pass_SetPassToNoPass ();
  M2Quads_BackPatchSubrangesAndOptParam ();
  Total = M2Quads_CountQuads ();
  M2Quads_ForLoopAnalysis ();  /* must be done before any optimization as the index variable increment quad might change  */
  M2Quads_DumpQuadruples ((const char *) "before declaring symbols to gcc\\n", 33);
  /* we know all the front end symbols must be resolved.  */
  if (M2Options_StyleChecking)
    {
      M2Students_StudentVariableCheck ();
    }
  M2Pass_SetPassToCodeGeneration ();
  m2top_SetFlagUnitAtATime (M2Options_Optimizing);
  m2top_StartGlobalContext ();
  M2GCCDeclare_InitDeclarations ();  /* default and fixed sized types are all declared from now on.  */
  RemoveUnreachableCode ();  /* default and fixed sized types are all declared from now on.  */
  M2Quads_DumpQuadruples ((const char *) "after dead procedure elimination\\n", 34);
  DetermineSubExpTemporaries ();
  M2Quads_DumpQuadruples ((const char *) "after identifying simple subexpression temporaries\\n", 52);
  M2Quiet_qprintf0 ((const char *) "        symbols to gcc trees\\n", 30);
  DoModuleDeclare ();
  M2Error_FlushWarnings ();
  M2Error_FlushErrors ();
  M2Quiet_qprintf0 ((const char *) "        statements to gcc trees\\n", 33);
  DoCodeBlock ();
  M2GCCDeclare_MarkExported (SymbolTable_GetMainModule ());
  M2Swig_GenerateSwigFile (SymbolTable_GetMainModule ());
  SymbolTable_DebugLineNumbers (SymbolTable_GetMainModule ());
  M2Quiet_qprintf0 ((const char *) "        gcc trees given to the gcc backend\\n", 44);
  m2top_EndGlobalContext ();
  OptimizationAnalysis ();
}


/*
   CodeBlock - generates all code for this block and also declares
               all types and procedures for this block. It will
               also optimize quadruples within this scope.
*/

extern "C" void M2Code_CodeBlock (unsigned int scope)
{
  M2Scope_ScopeBlock sb;
  NameKey_Name n;

  if (TraceQuadruples)
    {
      n = SymbolTable_GetSymName (scope);
      M2Printf_printf1 ((const char *) "before coding block %a\\n", 24, (const unsigned char *) &n, (sizeof (n)-1));
    }
  sb = M2Scope_InitScopeBlock (scope);
  OptimizeScopeBlock (sb);
  if (SymbolTable_IsProcedure (scope))
    {
      if (TraceQuadruples)
        {
          n = SymbolTable_GetSymName (scope);
          M2Printf_printf1 ((const char *) "before coding procedure %a\\n", 28, (const unsigned char *) &n, (sizeof (n)-1));
          M2Scope_ForeachScopeBlockDo3 (sb, (M2Scope_ScopeProcedure3) {(M2Scope_ScopeProcedure3_t) M2Quads_DisplayQuadRange});
          M2Printf_printf0 ((const char *) "===============\\n", 17);
        }
      M2Scope_ForeachScopeBlockDo2 (sb, (M2Scope_ScopeProcedure2) {(M2Scope_ScopeProcedure2_t) M2GenGCC_ConvertQuadsToTree});
    }
  else if (SymbolTable_IsModuleWithinProcedure (scope))
    {
      /* avoid dangling else.  */
      if (TraceQuadruples)
        {
          n = SymbolTable_GetSymName (scope);
          M2Printf_printf1 ((const char *) "before coding module %a within procedure\\n", 42, (const unsigned char *) &n, (sizeof (n)-1));
          M2Scope_ForeachScopeBlockDo3 (sb, (M2Scope_ScopeProcedure3) {(M2Scope_ScopeProcedure3_t) M2Quads_DisplayQuadRange});
          M2Printf_printf0 ((const char *) "===============\\n", 17);
        }
      M2Scope_ForeachScopeBlockDo2 (sb, (M2Scope_ScopeProcedure2) {(M2Scope_ScopeProcedure2_t) M2GenGCC_ConvertQuadsToTree});
      SymbolTable_ForeachProcedureDo (scope, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) M2Code_CodeBlock});
    }
  else
    {
      /* avoid dangling else.  */
      if (TraceQuadruples)
        {
          n = SymbolTable_GetSymName (scope);
          M2Printf_printf1 ((const char *) "before coding module %a\\n", 25, (const unsigned char *) &n, (sizeof (n)-1));
          M2Scope_ForeachScopeBlockDo3 (sb, (M2Scope_ScopeProcedure3) {(M2Scope_ScopeProcedure3_t) M2Quads_DisplayQuadRange});
          M2Printf_printf0 ((const char *) "===============\\n", 17);
        }
      M2Scope_ForeachScopeBlockDo2 (sb, (M2Scope_ScopeProcedure2) {(M2Scope_ScopeProcedure2_t) M2GenGCC_ConvertQuadsToTree});
      if (M2Options_WholeProgram)
        {
          M2Batch_ForeachSourceModuleDo ((M2Batch_DoProcedure) {(M2Batch_DoProcedure_t) CodeProcedures});
        }
      else
        {
          SymbolTable_ForeachProcedureDo (scope, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) M2Code_CodeBlock});
        }
      SymbolTable_ForeachInnerModuleDo (scope, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) CodeProceduresWithinBlock});
    }
  M2Scope_KillScopeBlock (&sb);
}

extern "C" void _M2_M2Code_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  Init ();
}

extern "C" void _M2_M2Code_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
