/* do not edit automatically generated by mc from M2Preprocess.  */
/* M2Preprocess.mod provides a mechanism to invoke the C preprocessor.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _M2Preprocess_C

#include "GM2Preprocess.h"
#   include "GSYSTEM.h"
#   include "GDynamicStrings.h"
#   include "Gchoosetemp.h"
#   include "Gpexecute.h"
#   include "Glibc.h"
#   include "GLists.h"
#   include "GFIO.h"
#   include "GM2Printf.h"
#   include "GM2Options.h"
#   include "GNameKey.h"
#   include "GM2RTS.h"

#   define Debugging false
static Lists_List ListOfFiles;

/*
   PreprocessModule - preprocess a file, filename, returning the new filename
                      of the preprocessed file.
                      Preprocessing will only occur if requested by the user.
                      If no preprocessing was requested then filename is returned.
                      If preprocessing occurs then a temporary file is created
                      and its name is returned.
                      All temporary files will be deleted when the compiler exits.
                      outputdep is the filename which will contain the dependency
                      info if -M, -MM is provided.  outputdep can be NIL in which case
                      it is ignored.
*/

extern "C" DynamicStrings_String M2Preprocess_PreprocessModule (DynamicStrings_String filename, bool topSource, bool deleteDep, DynamicStrings_String outputDep);

/*
   MakeSaveTempsFileNameExt - creates and return the temporary filename.ext.
                              in the current working directory unless
                              SaveTempsDir = obj, when we put it in the dumpdir
                              if that is specified (or fallback to '.' if not).
*/

extern "C" DynamicStrings_String M2Preprocess_MakeSaveTempsFileNameExt (DynamicStrings_String filename, DynamicStrings_String ext);

/*
   OnExitDelete - when the application finishes delete filename.
*/

extern "C" DynamicStrings_String M2Preprocess_OnExitDelete (DynamicStrings_String filename);

/*
   RemoveFile - removes a single file, s.
*/

static void RemoveFile (unsigned int w);

/*
   RemoveFiles -
*/

static int RemoveFiles (void);
static DynamicStrings_String GetFileName (DynamicStrings_String Path);

/*
   MakeSaveTempsFileName - return a temporary file like
   "./filename.{def,mod}.m2i" in the current working directory unless
   SaveTempsDir = obj, when we put it in the dumpdir if that is specified
   (or fallback to '.' if not).
   We have to keep the original extension because that disambiguates .def
   and .mod files (otherwise, we'd need two 'preprocessed' extensions).
*/

static DynamicStrings_String MakeSaveTempsFileName (DynamicStrings_String filename);

/*
   BuildCommandLineExecute - build the cpp command line and execute the command and return
                             the tempfile containing the preprocessed source.
*/

static DynamicStrings_String BuildCommandLineExecute (DynamicStrings_String filename, bool topSource, bool deleteDep, DynamicStrings_String command, DynamicStrings_String outputdep);


/*
   RemoveFile - removes a single file, s.
*/

static void RemoveFile (unsigned int w)
{
  NameKey_Name n;

  n = static_cast<NameKey_Name> (w);
  if (Debugging)
    {
      libc_printf ((const char *) "removing: %s\\n", 14, NameKey_KeyToCharStar (n));
    }
  if ((libc_unlink (NameKey_KeyToCharStar (n))) != 0)
    {}  /* empty.  */
}


/*
   RemoveFiles -
*/

static int RemoveFiles (void)
{
  Lists_ForeachItemInListDo (ListOfFiles, (SymbolKey_PerformOperation) {(SymbolKey_PerformOperation_t) RemoveFile});
  return 0;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}

static DynamicStrings_String GetFileName (DynamicStrings_String Path)
{
  int fstart;

  /* 
   Return the filename with no path.
  */
  fstart = DynamicStrings_RIndex (Path, '/', 0);
  if (fstart == -1)
    {
      fstart = 0;
    }
  else
    {
      fstart = fstart+1;
    }
  return DynamicStrings_Dup (DynamicStrings_Slice (Path, fstart, static_cast<int> (DynamicStrings_Length (Path))));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeSaveTempsFileName - return a temporary file like
   "./filename.{def,mod}.m2i" in the current working directory unless
   SaveTempsDir = obj, when we put it in the dumpdir if that is specified
   (or fallback to '.' if not).
   We have to keep the original extension because that disambiguates .def
   and .mod files (otherwise, we'd need two 'preprocessed' extensions).
*/

static DynamicStrings_String MakeSaveTempsFileName (DynamicStrings_String filename)
{
  return M2Preprocess_MakeSaveTempsFileNameExt (filename, DynamicStrings_InitString ((const char *) ".m2i", 4));
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   BuildCommandLineExecute - build the cpp command line and execute the command and return
                             the tempfile containing the preprocessed source.
*/

static DynamicStrings_String BuildCommandLineExecute (DynamicStrings_String filename, bool topSource, bool deleteDep, DynamicStrings_String command, DynamicStrings_String outputdep)
{
  DynamicStrings_String tempfile;
  DynamicStrings_String commandLine;

  commandLine = DynamicStrings_Dup (command);
  tempfile = static_cast<DynamicStrings_String> (NULL);
  /* We support MD and MMD for the main file only, at present.  */
  if (topSource || M2Options_PPonly)
    {
      if (M2Options_GetMD ())
        {
          tempfile = DynamicStrings_ConCat (DynamicStrings_InitString ((const char *) " -MD ", 5), outputdep);
        }
      else if (M2Options_GetMMD ())
        {
          /* avoid dangling else.  */
          tempfile = DynamicStrings_ConCat (DynamicStrings_InitString ((const char *) " -MMD ", 6), outputdep);
        }
      if (tempfile != NULL)
        {
          commandLine = DynamicStrings_ConCat (DynamicStrings_Dup (commandLine), DynamicStrings_Dup (tempfile));
          /* We can only add MQ if we already have an MD/MMD.  */
          if ((M2Options_GetMQ ()) != NULL)
            {
              tempfile = DynamicStrings_InitStringCharStar (M2Options_GetMQ ());
              commandLine = DynamicStrings_ConCat (DynamicStrings_Dup (commandLine), DynamicStrings_Dup (tempfile));
            }
        }
    }
  /* The output file depends on whether we are in stand-alone PP mode, and
      if an output file is specified.  */
  tempfile = static_cast<DynamicStrings_String> (NULL);
  if (M2Options_PPonly)
    {
      /* avoid dangling else.  */
      if ((M2Options_GetObj ()) != NULL)
        {
          tempfile = DynamicStrings_InitStringCharStar (M2Options_GetObj ());
        }
    }
  else if (M2Options_SaveTemps)
    {
      /* avoid dangling else.  */
      tempfile = MakeSaveTempsFileName (filename);
    }
  else
    {
      /* avoid dangling else.  */
      tempfile = DynamicStrings_InitStringCharStar (choosetemp_make_temp_file (NameKey_KeyToCharStar (NameKey_MakeKey ((const char *) ".m2i", 4))));
    }
  commandLine = DynamicStrings_ConCat (DynamicStrings_ConCatChar (DynamicStrings_Dup (commandLine), ' '), filename);
  if (tempfile != NULL)
    {
      commandLine = DynamicStrings_ConCat (DynamicStrings_ConCat (DynamicStrings_Dup (commandLine), DynamicStrings_Mark (DynamicStrings_InitString ((const char *) " -o ", 4))), tempfile);
    }
  if (((outputdep != NULL) && ((DynamicStrings_Length (outputdep)) > 0)) && ((M2Options_GetM ()) || (M2Options_GetMM ())))
    {
      commandLine = DynamicStrings_ConCat (commandLine, DynamicStrings_ConCat (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) " -MF ", 5)), outputdep));
      if (deleteDep && ! M2Options_SaveTemps)
        {
          outputdep = M2Preprocess_OnExitDelete (outputdep);
        }
    }
  /* for now we'll use system  */
  if (M2Options_Verbose)
    {
      M2Printf_fprintf1 (FIO_StdOut, (const char *) "preprocess: %s\\n", 16, (const unsigned char *) &commandLine, (sizeof (commandLine)-1));
    }
  if ((libc_system (DynamicStrings_string (commandLine))) != 0)
    {
      M2Printf_fprintf1 (FIO_StdErr, (const char *) "C preprocessor failed when preprocessing %s\\n", 45, (const unsigned char *) &filename, (sizeof (filename)-1));
      libc_exit (1);
    }
  commandLine = DynamicStrings_KillString (commandLine);
  if (M2Options_SaveTemps)
    {
      return tempfile;
    }
  else
    {
      return M2Preprocess_OnExitDelete (tempfile);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PreprocessModule - preprocess a file, filename, returning the new filename
                      of the preprocessed file.
                      Preprocessing will only occur if requested by the user.
                      If no preprocessing was requested then filename is returned.
                      If preprocessing occurs then a temporary file is created
                      and its name is returned.
                      All temporary files will be deleted when the compiler exits.
                      outputdep is the filename which will contain the dependency
                      info if -M, -MM is provided.  outputdep can be NIL in which case
                      it is ignored.
*/

extern "C" DynamicStrings_String M2Preprocess_PreprocessModule (DynamicStrings_String filename, bool topSource, bool deleteDep, DynamicStrings_String outputDep)
{
  DynamicStrings_String command;

  if (M2Options_GetCpp ())
    {
      command = M2Options_CppCommandLine ();
      if ((command == NULL) || (DynamicStrings_EqualArray (command, (const char *) "", 0)))
        {
          return DynamicStrings_Dup (filename);
        }
      command = BuildCommandLineExecute (filename, topSource, deleteDep, command, outputDep);
      if (command == NULL)
        {
          return filename;
        }
      else
        {
          return command;
        }
    }
  else
    {
      return DynamicStrings_Dup (filename);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   MakeSaveTempsFileNameExt - creates and return the temporary filename.ext.
                              in the current working directory unless
                              SaveTempsDir = obj, when we put it in the dumpdir
                              if that is specified (or fallback to '.' if not).
*/

extern "C" DynamicStrings_String M2Preprocess_MakeSaveTempsFileNameExt (DynamicStrings_String filename, DynamicStrings_String ext)
{
  DynamicStrings_String NewName;
  DynamicStrings_String DumpDir;
  DynamicStrings_String NewDir;

  NewName = DynamicStrings_ConCat (DynamicStrings_Dup (GetFileName (filename)), ext);
  NewDir = DynamicStrings_Dup (M2Options_GetSaveTempsDir ());
  DumpDir = DynamicStrings_Dup (M2Options_GetDumpDir ());
  if (Debugging)
    {
      M2Printf_fprintf1 (FIO_StdOut, (const char *) "newname: %s", 11, (const unsigned char *) &NewName, (sizeof (NewName)-1));
      M2Printf_fprintf1 (FIO_StdOut, (const char *) " NewDir: %s", 11, (const unsigned char *) &NewDir, (sizeof (NewDir)-1));
      M2Printf_fprintf1 (FIO_StdOut, (const char *) " DumpDir: %s\\n", 14, (const unsigned char *) &DumpDir, (sizeof (DumpDir)-1));
    }
  if (((NewDir != NULL) && (DynamicStrings_EqualArray (NewDir, (const char *) "obj", 3))) && (DumpDir != NULL))
    {
      return DynamicStrings_ConCat (DumpDir, NewName);
    }
  else
    {
      return DynamicStrings_ConCat (DynamicStrings_InitString ((const char *) "./", 2), NewName);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   OnExitDelete - when the application finishes delete filename.
*/

extern "C" DynamicStrings_String M2Preprocess_OnExitDelete (DynamicStrings_String filename)
{
  if (filename != NULL)
    {
      if (Debugging)
        {
          libc_printf ((const char *) "scheduling removal: %s\\n", 24, DynamicStrings_string (filename));
        }
      Lists_IncludeItemIntoList (ListOfFiles, NameKey_makekey (DynamicStrings_string (filename)));
    }
  return filename;
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}

extern "C" void _M2_M2Preprocess_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  Lists_InitList (&ListOfFiles);
  if ((libc_atexit ((libc_exitP_C) RemoveFiles)) != 0)
    {
      M2RTS_HALT (-1);
      __builtin_unreachable ();
    }
}

extern "C" void _M2_M2Preprocess_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
