/* do not edit automatically generated by mc from M2Students.  */
/* M2Students.mod checks for new programmer errors.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#define _M2Students_C

#include "GM2Students.h"
#   include "GSymbolTable.h"
#   include "GNameKey.h"
#   include "GM2MetaError.h"
#   include "GLists.h"
#   include "GM2Reserved.h"
#   include "GDynamicStrings.h"
#   include "GFormatStrings.h"
#   include "GM2LexBuf.h"
#   include "GASCII.h"
#   include "GM2Options.h"

static Lists_List ErrantNames;
static Lists_List ErrantSymbols;

/*
   CheckVariableAgainstKeyword - checks for a identifier that looks the same
                                 as a keyword except for its case.
*/

extern "C" void M2Students_CheckVariableAgainstKeyword (NameKey_Name name);

/*
   StudentVariableCheck - checks to see that variables are quite different from keywords and
                          issues an message if they are not. It ignores case so to catch
                          1st and 2nd semester programming errors.
*/

extern "C" void M2Students_StudentVariableCheck (void);

/*
   IsNotADuplicate - returns TRUE if either s1 or s2 have not been reported before.
*/

static bool IsNotADuplicate (unsigned int s1, unsigned int s2);

/*
   IsNotADuplicateName - returns TRUE if name has not been reported before.
*/

static bool IsNotADuplicateName (NameKey_Name name);

/*
   PerformVariableKeywordCheck - performs the check and constructs the metaerror notes if appropriate.
*/

static void PerformVariableKeywordCheck (NameKey_Name name);

/*
   CheckAsciiName - checks to see whether ascii names, s1, and, s2, are similar.
*/

static void CheckAsciiName (unsigned int previous, unsigned int s1, unsigned int newblock, unsigned int s2);

/*
   CheckProcedure - checks the procedure, p, for symbols which look like, s.
*/

static void CheckProcedure (unsigned int m, unsigned int p);

/*
   CheckModule - checks the module, m, for symbols which look like, s.
*/

static void CheckModule (unsigned int m, unsigned int s);


/*
   IsNotADuplicate - returns TRUE if either s1 or s2 have not been reported before.
*/

static bool IsNotADuplicate (unsigned int s1, unsigned int s2)
{
  if ((! (Lists_IsItemInList (ErrantSymbols, s1))) && (! (Lists_IsItemInList (ErrantSymbols, s2))))
    {
      Lists_IncludeItemIntoList (ErrantSymbols, s1);
      Lists_IncludeItemIntoList (ErrantSymbols, s2);
      return true;
    }
  else
    {
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   IsNotADuplicateName - returns TRUE if name has not been reported before.
*/

static bool IsNotADuplicateName (NameKey_Name name)
{
  if (! (Lists_IsItemInList (ErrantNames, name)))
    {
      Lists_IncludeItemIntoList (ErrantNames, name);
      return true;
    }
  else
    {
      return false;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PerformVariableKeywordCheck - performs the check and constructs the metaerror notes if appropriate.
*/

static void PerformVariableKeywordCheck (NameKey_Name name)
{
  NameKey_Name upper;
  M2Reserved_toktype token;
  DynamicStrings_String orig;
  DynamicStrings_String upperS;

  orig = DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (name));
  upperS = DynamicStrings_ToUpper (DynamicStrings_Dup (orig));
  upper = NameKey_makekey (DynamicStrings_string (upperS));
  if (M2Reserved_IsReserved (upper, &token))
    {
      if (IsNotADuplicateName (name))
        {
          M2MetaError_MetaErrorString0 (FormatStrings_Sprintf2 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "either the identifier has the same name as a keyword or alternatively a keyword has the wrong case ({%%K%s} and {!%%O:{%%K%s}})", 127)), (const unsigned char *) &upperS, (sizeof (upperS)-1), (const unsigned char *) &orig, (sizeof (orig)-1)));
          M2MetaError_MetaErrorString0 (FormatStrings_Sprintf1 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "the symbol name {!%%O:{%%K%s}} is legal as an identifier, however as such it might cause confusion and is considered bad programming practice", 141)), (const unsigned char *) &orig, (sizeof (orig)-1)));
        }
    }
  upperS = DynamicStrings_KillString (upperS);
  orig = DynamicStrings_KillString (orig);
}


/*
   CheckAsciiName - checks to see whether ascii names, s1, and, s2, are similar.
*/

static void CheckAsciiName (unsigned int previous, unsigned int s1, unsigned int newblock, unsigned int s2)
{
  NameKey_Name a1;
  NameKey_Name a2;

  a1 = SymbolTable_GetSymName (s1);
  a2 = SymbolTable_GetSymName (s2);
  if ((a1 == a2) && (a1 != NameKey_NulName))
    {
      /* avoid dangling else.  */
      if (IsNotADuplicate (s1, s2))
        {
          M2MetaError_MetaError2 ((const char *) "identical symbol name in two different scopes, scope {%1Oad} has symbol {%2Mad}", 79, previous, s1);
          M2MetaError_MetaError2 ((const char *) "identical symbol name in two different scopes, scope {%1Oad} has symbol {%2Mad}", 79, newblock, s2);
        }
    }
  else if (NameKey_IsSameExcludingCase (a1, a2))
    {
      /* avoid dangling else.  */
      if (IsNotADuplicate (s1, s2))
        {
          M2MetaError_MetaError2 ((const char *) "very similar symbol names (different case) in two different scopes, scope {%1ORad} has symbol {%2Mad}", 101, previous, s1);
          M2MetaError_MetaError2 ((const char *) "very similar symbol names (different case) in two different scopes, scope {%1OCad} has symbol {%2Mad}", 101, newblock, s2);
        }
    }
}


/*
   CheckProcedure - checks the procedure, p, for symbols which look like, s.
*/

static void CheckProcedure (unsigned int m, unsigned int p)
{
  unsigned int i;
  unsigned int n1;
  unsigned int j;
  unsigned int n2;

  if (p != SymbolTable_NulSym)
    {
      i = 1;  /* I would have used NoOfParam(p)+1 but Stuart wants parameters checked as well - maybe he is right.  */
      do {  /* I would have used NoOfParam(p)+1 but Stuart wants parameters checked as well - maybe he is right.  */
        n1 = SymbolTable_GetNth (p, i);
        if (n1 != SymbolTable_NulSym)
          {
            if ((((SymbolTable_IsVar (n1)) || (SymbolTable_IsType (n1))) || (SymbolTable_IsProcedure (n1))) || (SymbolTable_IsRecord (n1)))
              {
                j = 1;
                do {
                  n2 = SymbolTable_GetNth (m, j);
                  if (n2 != SymbolTable_NulSym)
                    {
                      if ((((SymbolTable_IsVar (n2)) || (SymbolTable_IsType (n2))) || (SymbolTable_IsProcedure (n2))) || (SymbolTable_IsRecord (n2)))
                        {
                          CheckAsciiName (m, n2, p, n1);
                        }
                    }
                  j += 1;
                } while (! (n2 == SymbolTable_NulSym));
              }
          }
        i += 1;
      } while (! (n1 == SymbolTable_NulSym));
    }
}


/*
   CheckModule - checks the module, m, for symbols which look like, s.
*/

static void CheckModule (unsigned int m, unsigned int s)
{
  unsigned int i;
  unsigned int n;

  if (m != SymbolTable_NulSym)
    {
      i = 1;
      do {
        n = SymbolTable_GetNth (m, i);
        if (n != SymbolTable_NulSym)
          {
            if ((n != SymbolTable_NulSym) && (n != s))
              {
                if ((((SymbolTable_IsVar (n)) || (SymbolTable_IsType (n))) || (SymbolTable_IsProcedure (n))) || (SymbolTable_IsRecord (n)))
                  {
                    CheckAsciiName (m, s, m, n);
                  }
              }
          }
        i += 1;
      } while (! (n == SymbolTable_NulSym));
    }
}


/*
   CheckVariableAgainstKeyword - checks for a identifier that looks the same
                                 as a keyword except for its case.
*/

extern "C" void M2Students_CheckVariableAgainstKeyword (NameKey_Name name)
{
  if (M2Options_StyleChecking)
    {
      PerformVariableKeywordCheck (name);
    }
}


/*
   StudentVariableCheck - checks to see that variables are quite different from keywords and
                          issues an message if they are not. It ignores case so to catch
                          1st and 2nd semester programming errors.
*/

extern "C" void M2Students_StudentVariableCheck (void)
{
  unsigned int i;
  unsigned int n;
  unsigned int m;

  m = SymbolTable_GetMainModule ();
  /* first check global scope  */
  i = 1;
  do {
    n = SymbolTable_GetNth (m, i);
    if (n != SymbolTable_NulSym)
      {
        if ((((SymbolTable_IsVar (n)) || (SymbolTable_IsType (n))) || (SymbolTable_IsProcedure (n))) || (SymbolTable_IsRecord (n)))
          {
            CheckModule (m, n);
          }
      }
    i += 1;
  } while (! (n == SymbolTable_NulSym));
  /* now check local scope  */
  i = 1;
  do {
    n = SymbolTable_GetNthProcedure (m, i);
    if (n != SymbolTable_NulSym)
      {
        if (SymbolTable_IsProcedure (n))
          {
            CheckProcedure (m, n);
          }
      }
    i += 1;
  } while (! (n == SymbolTable_NulSym));
}

extern "C" void _M2_M2Students_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  Lists_InitList (&ErrantSymbols);
  Lists_InitList (&ErrantNames);
}

extern "C" void _M2_M2Students_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
