/* do not edit automatically generated by mc from P1SymBuild.  */
/* P1SymBuild.mod pass 1 symbol creation.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#define _P1SymBuild_C

#include "GP1SymBuild.h"
#   include "GASCII.h"
#   include "GNameKey.h"
#   include "GM2Debug.h"
#   include "GM2LexBuf.h"
#   include "GM2MetaError.h"
#   include "GDynamicStrings.h"
#   include "GM2Printf.h"
#   include "GM2Options.h"
#   include "GM2Reserved.h"
#   include "GFifoQueue.h"
#   include "GP0SymBuild.h"
#   include "GSymbolTable.h"
#   include "GM2Batch.h"
#   include "GM2Quads.h"
#   include "GM2Comp.h"

#   define Debugging false
static unsigned int importStatementCount;
extern "C" void P1SymBuild_P1StartBuildDefinitionModule (void);
extern "C" void P1SymBuild_P1EndBuildDefinitionModule (void);
extern "C" void P1SymBuild_P1StartBuildImplementationModule (void);
extern "C" void P1SymBuild_P1EndBuildImplementationModule (void);
extern "C" void P1SymBuild_P1StartBuildProgramModule (void);
extern "C" void P1SymBuild_P1EndBuildProgramModule (void);

/*
   StartBuildInnerModule - Creates an Inner module and starts
                           a new scope.

                           The Stack is expected:

                           Entry                 Exit

                    Ptr ->                                     <- Ptr
                           +------------+        +-----------+
                           | NameStart  |        | NameStart |
                           |------------|        |-----------|

*/

extern "C" void P1SymBuild_StartBuildInnerModule (void);

/*
   EndBuildInnerModule - Destroys the Inner module scope and
                         checks for correct name.

                         The Stack is expected:

                         Entry                 Exit

                  Ptr ->
                         +------------+        +-----------+
                         | NameEnd    |        |           |
                         |------------|        |-----------|
                         | NameStart  |        |           | <- Ptr
                         |------------|        |-----------|
*/

extern "C" void P1SymBuild_EndBuildInnerModule (void);

/*
   BuildImportOuterModule - Builds imported identifiers into an outer module
                            from a definition module.

                            The Stack is expected:

                            Entry           OR    Entry

                     Ptr ->                Ptr ->
                            +------------+        +-----------+
                            | #          |        | #         |
                            |------------|        |-----------|
                            | Id1        |        | Id1       |
                            |------------|        |-----------|
                            .            .        .           .
                            .            .        .           .
                            .            .        .           .
                            |------------|        |-----------|
                            | Id#        |        | Id#       |
                            |------------|        |-----------|
                            | ImportTok  |        | Ident     |
                            |------------|        |-----------|

                            IMPORT Id1, .. Id# ;  FROM Ident IMPORT Id1 .. Id# ;


                            Exit

                            All above stack discarded
*/

extern "C" void P1SymBuild_BuildImportOuterModule (bool definition);

/*
   BuildExportOuterModule - Builds exported identifiers from an outer module
                            to the outside world of library modules.

                            The Stack is expected:

                            Entry           OR    Entry

                     Ptr ->                Ptr ->
                            +------------+        +--------------+
                            | #          |        | #            |
                            |------------|        |--------------|
                            | Id1        |        | Id1          |
                            |------------|        |--------------|
                            .            .        .              .
                            .            .        .              .
                            .            .        .              .
                            |------------|        |--------------|
                            | Id#        |        | Id#          |
                            |------------|        |--------------|
                            | ExportTok  |        | QualifiedTok |
                            |------------|        |--------------|

                            EXPORT Id1, .. Id# ;  EXPORT QUALIFIED Id1 .. Id# ;

                            Error Condition


                            Exit

                            All above stack discarded
*/

extern "C" void P1SymBuild_BuildExportOuterModule (void);

/*
   CheckExplicitExported - checks to see whether we are compiling
                           a definition module and whether the ident
                           is implicitly export qualified or unqualified.


                                  The Stack is expected:

                                  Entry                 Exit

                           Ptr ->                Ptr ->
                                  +------------+        +-----------+
                                  | Identname  |        | Identname |
                                  |------------|        |-----------|

*/

extern "C" void P1SymBuild_CheckExplicitExported (void);

/*
   BuildImportInnerModule - Builds imported identifiers into an inner module
                            from the last level of module.

                            The Stack is expected:

                            Entry           OR    Entry

                     Ptr ->                Ptr ->
                            +------------+        +-----------+
                            | #          |        | #         |
                            |------------|        |-----------|
                            | Id1        |        | Id1       |
                            |------------|        |-----------|
                            .            .        .           .
                            .            .        .           .
                            .            .        .           .
                            |------------|        |-----------|
                            | Id#        |        | Id#       |
                            |------------|        |-----------|
                            | ImportTok  |        | Ident     |
                            |------------|        |-----------|

                            IMPORT Id1, .. Id# ;  FROM Ident IMPORT Id1 .. Id# ;

                            Exit

                            All above stack discarded
*/

extern "C" void P1SymBuild_BuildImportInnerModule (void);

/*
   BuildExportInnerModule - Builds exported identifiers from an inner module
                            to the next layer module.

                            The Stack is expected:

                            Entry           OR    Entry

                     Ptr ->                Ptr ->
                            +------------+        +--------------+
                            | #          |        | #            |
                            |------------|        |--------------|
                            | Id1        |        | Id1          |
                            |------------|        |--------------|
                            .            .        .              .
                            .            .        .              .
                            .            .        .              .
                            |------------|        |--------------|
                            | Id#        |        | Id#          |
                            |------------|        |--------------|
                            | ExportTok  |        | QualifiedTok |
                            |------------|        |--------------|

                            EXPORT Id1, .. Id# ;  EXPORT QUALIFIED Id1 .. Id# ;


                            Exit


                            All above stack discarded
*/

extern "C" void P1SymBuild_BuildExportInnerModule (void);

/*
   StartBuildEnumeration - Builds an Enumeration type Type.


                           Stack

                           Entry                 Exit

                    Ptr ->
                           +------------+
                           | #          |
                           |------------|
                           | en 1       |
                           |------------|
                           | en 2       |
                           |------------|
                           .            .
                           .            .
                           .            .                       <- Ptr
                           |------------|        +------------+
                           | en #       |        | Type       |
                           |------------|        |------------|
                           | Name       |        | Name       |
                           |------------|        |------------|
*/

extern "C" void P1SymBuild_StartBuildEnumeration (void);

/*
   EndBuildEnumeration - completes the construction of the enumeration type.


                         Stack

                         Entry                 Exit

                  Ptr ->
                         +------------+
                         | Type       |                          <- Ptr
                         |------------|        +---------------+
                         | Name       |        | Type  | Name  |
                         |------------|        |---------------|

                                               Empty
*/

extern "C" void P1SymBuild_EndBuildEnumeration (void);

/*
   BuildHiddenType - Builds a Hidden Type.


                     Stack

                     Entry                 Exit

              Ptr ->
                     +------------+
                     | Name       |                          <- Ptr
                     |------------|        Empty
*/

extern "C" void P1SymBuild_BuildHiddenType (void);

/*
   StartBuildProcedure - Builds a Procedure.

                         The Stack:

                         Entry                 Exit

                  Ptr ->                                      <- Ptr
                         +------------+        +------------+
                         | Name       |        | ProcSym    |
                         |------------|        |------------|
                         | inlinetok  |        |            |
                         | or         |        |            |
                         | builtintok |        |            |
                         | or name or |        | Name       |
                         | NulTok     |        |            |
                         |------------|        |------------|
*/

extern "C" void P1SymBuild_StartBuildProcedure (void);

/*
   EndBuildProcedure - Ends building a Procedure.
                       It checks the start procedure name matches the end
                       procedure name.

                       The Stack:

                       (Procedure Not Defined in definition module)

                       Entry                 Exit

                Ptr ->
                       +------------+
                       | NameEnd    |
                       |------------|
                       | ProcSym    |
                       |------------|
                       | NameStart  |
                       |------------|
                                             Empty
*/

extern "C" void P1SymBuild_EndBuildProcedure (void);

/*
   BuildProcedureHeading - Builds a procedure heading for the definition
                           module procedures.

                           Operation only performed if compiling a
                           definition module.

                           The Stack:

                           Entry                       Exit

                    Ptr ->
                           +------------+
                           | ProcSym    |
                           |------------|
                           | NameStart  |
                           |------------|
                                                       Empty

*/

extern "C" void P1SymBuild_BuildProcedureHeading (void);

/*
   EndBuildForward - Ends building a forward procedure declaration.

                     The Stack:

                     (This procedure is not defined in definition module)

                     Entry                 Exit

              Ptr ->
                     +------------+
                     | ProcSym    |
                     |------------|
                     | NameStart  |
                     |------------|
                                           Empty
*/

extern "C" void P1SymBuild_EndBuildForward (unsigned int forwardPos);

/*
   BuildNulName - Pushes a NulName onto the top of the stack.
                  The Stack:


                  Entry                    Exit

                                                          <- Ptr
                  Empty                    +------------+
                                           | NulName    |
                                           |------------|
*/

extern "C" void P1SymBuild_BuildNulName (void);

/*
   BuildTypeEnd - Pops the type Type and Name.
                  The Stack:


                  Entry                    Exit


           Ptr ->
                  +-------------+
                  | Type | Name |          Empty
                  |-------------|
*/

extern "C" void P1SymBuild_BuildTypeEnd (void);

/*
   BuildImportStatement - create a new import statement in the current module.
                          It ignores local modules.

                          The quadruple stack is not used.
*/

extern "C" void P1SymBuild_BuildImportStatement (unsigned int tok);

/*
   AddImportToImportStatement - the top of stack is expected to be a module name.
                                This is looked up from the module universe and
                                wrapped in an import symbol and placed into the
                                current import statement.

                                The quadruple stack is unchanged.

                                Entry                      Exit


                         Ptr ->                                                   <- Ptr
                                +---------------------+    +---------------------+
                                | ImportedModuleName  |    | ImportedModuleName  |
                                |---------------------|    |---------------------|
*/

extern "C" void P1SymBuild_AddImportToImportStatement (bool qualified);

extern "C" void P1SymBuild_P1StartBuildDefinitionModule (void)
{
  NameKey_Name name;
  unsigned int language;
  unsigned int ModuleSym;

  /* 
   StartBuildDefinitionModule - Creates a definition module and starts
                                a new scope.

                                he Stack is expected:

                                Entry                 Exit

                         Ptr ->
                                +------------+
                                | NameStart  |                       <- Ptr
                                |------------|        +------------+
                                | NulName/"C"|        | NameStart  |
                                |------------|        |------------|
  */
  importStatementCount = 0;
  M2Quads_PopT (&name);
  /* CheckFileName(name, 'definition') ;  */
  ModuleSym = M2Batch_MakeDefinitionSource (M2LexBuf_GetTokenNo (), name);
  SymbolTable_PutDoesNotNeedExportList (ModuleSym);
  SymbolTable_SetCurrentModule (ModuleSym);
  SymbolTable_SetFileModule (ModuleSym);
  SymbolTable_StartScope (ModuleSym);
  M2Debug_Assert (SymbolTable_IsDefImp (ModuleSym));
  M2Debug_Assert (M2Comp_CompilingDefinitionModule ());
  M2Quads_PopT (&language);
  if ((language != SymbolTable_NulSym) && (SymbolTable_IsConstString (language)))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if ((SymbolTable_GetSymName (language)) == (NameKey_MakeKey ((const char *) "C", 1)))
        {
          SymbolTable_PutDefinitionForC (ModuleSym);
        }
      else if ((SymbolTable_GetSymName (language)) == NameKey_NulName)
        {
          /* avoid dangling else.  */
          M2MetaError_MetaError0 ((const char *) "{%E}currently a non modula-2 definition module can only be declared as DEFINITION FOR {%k\"C\"}", 93);
        }
      else
        {
          /* avoid dangling else.  */
          M2MetaError_MetaError1 ((const char *) "unknown definition module language {%1Ea}, currently a non modula-2 definition module can only be declared as DEFINITION FOR {%k\"C\"}", 132, language);
        }
    }
  M2Quads_PushT (name);
  P0SymBuild_EnterBlock (name);
}

extern "C" void P1SymBuild_P1EndBuildDefinitionModule (void)
{
  unsigned int start;
  NameKey_Name NameStart;
  NameKey_Name NameEnd;

  /* 
   EndBuildDefinitionModule - Destroys the definition module scope and
                              checks for correct name.

                              The Stack is expected:

                              Entry                 Exit

                       Ptr ->
                              +------------+        +-----------+
                              | NameEnd    |        |           |
                              |------------|        |-----------|
                              | NameStart  |        |           | <- Ptr
                              |------------|        |-----------|
  */
  M2Debug_Assert (M2Comp_CompilingDefinitionModule ());
  SymbolTable_EndScope ();
  M2Quads_PopTtok (&NameStart, &start);
  M2Quads_PopT (&NameEnd);
  if (Debugging)
    {
      M2Printf_printf0 ((const char *) "pass 1: ", 8);
      SymbolTable_DisplayTrees (SymbolTable_GetCurrentModule ());
    }
  if (NameStart != NameEnd)
    {
      M2MetaError_MetaError1 ((const char *) "inconsistent definition module name {%1Wa}", 42, SymbolTable_MakeError (start, NameStart));
    }
  P0SymBuild_LeaveBlock ();
}

extern "C" void P1SymBuild_P1StartBuildImplementationModule (void)
{
  unsigned int tok;
  NameKey_Name name;
  unsigned int ModuleSym;

  /* 
   StartBuildImplementationModule - Creates an implementation module and starts
                                    a new scope.

                                    The Stack is expected:

                                    Entry                 Exit

                             Ptr ->                                     <- Ptr
                                    +------------+        +-----------+
                                    | NameStart  |        | NameStart |
                                    |------------|        |-----------|

  */
  importStatementCount = 0;
  M2Quads_PopTtok (&name, &tok);
  /* CheckFileName(name, 'implementation') ;  */
  ModuleSym = M2Batch_MakeImplementationSource (tok, name);
  SymbolTable_SetCurrentModule (ModuleSym);
  SymbolTable_SetFileModule (ModuleSym);
  SymbolTable_StartScope (ModuleSym);
  if (! (SymbolTable_IsDefImp (ModuleSym)))
    {
      M2MetaError_MetaError1 ((const char *) "cannot find corresponding definition module for {%1Ea}", 54, ModuleSym);
    }
  M2Debug_Assert (M2Comp_CompilingImplementationModule ());
  M2Quads_PushTtok (name, tok);
  P0SymBuild_EnterBlock (name);
}

extern "C" void P1SymBuild_P1EndBuildImplementationModule (void)
{
  unsigned int start;
  unsigned int end;
  NameKey_Name NameStart;
  NameKey_Name NameEnd;

  /* 
   EndBuildImplementationModule - Destroys the implementation module scope and
                                  checks for correct name.

                                  The Stack is expected:

                                  Entry                 Exit

                           Ptr ->
                                  +------------+        +-----------+
                                  | NameEnd    |        |           |
                                  |------------|        |-----------|
                                  | NameStart  |        |           | <- Ptr
                                  |------------|        |-----------|
  */
  SymbolTable_ResolveImports ();
  M2Debug_Assert (M2Comp_CompilingImplementationModule ());
  SymbolTable_EndScope ();
  M2Quads_PopTtok (&NameStart, &start);
  M2Quads_PopTtok (&NameEnd, &end);
  if (NameStart != NameEnd)
    {
      M2MetaError_MetaErrorT1 (end, (const char *) "inconsistent implementation module name {%1Wa}", 46, SymbolTable_MakeError (start, NameStart));
    }
  P0SymBuild_LeaveBlock ();
}

extern "C" void P1SymBuild_P1StartBuildProgramModule (void)
{
  unsigned int tok;
  NameKey_Name name;
  unsigned int ModuleSym;

  /* 
   StartBuildProgramModule - Creates a program module and starts
                             a new scope.

                             The Stack is expected:

                             Entry                 Exit

                      Ptr ->                                     <- Ptr
                             +------------+        +-----------+
                             | NameStart  |        | NameStart |
                             |------------|        |-----------|

  */
  importStatementCount = 0;
  M2Quads_PopTtok (&name, &tok);
  /* CheckFileName(name, 'main') ;  */
  ModuleSym = M2Batch_MakeProgramSource (tok, name);
  SymbolTable_SetCurrentModule (ModuleSym);
  SymbolTable_SetFileModule (ModuleSym);
  SymbolTable_StartScope (ModuleSym);
  if ((! (M2Comp_CompilingProgramModule ())) || (SymbolTable_IsDefImp (ModuleSym)))
    {
      M2MetaError_MetaErrorT1 (tok, (const char *) "module {%1Ea} has a corresponding DEFINITION MODULE but no IMPLEMENTATION keyword in the main module", 100, ModuleSym);
    }
  M2Quads_PushTtok (name, tok);
  P0SymBuild_EnterBlock (name);
}

extern "C" void P1SymBuild_P1EndBuildProgramModule (void)
{
  unsigned int start;
  unsigned int end;
  NameKey_Name NameStart;
  NameKey_Name NameEnd;

  /* 
   EndBuildProgramModule - Destroys the program module scope and
                           checks for correct name.

                           The Stack is expected:

                           Entry                 Exit

                    Ptr ->
                           +------------+        +-----------+
                           | NameEnd    |        |           |
                           |------------|        |-----------|
                           | NameStart  |        |           | <- Ptr
                           |------------|        |-----------|
  */
  SymbolTable_ResolveImports ();
  M2Debug_Assert (M2Comp_CompilingProgramModule ());
  SymbolTable_EndScope ();
  M2Quads_PopTtok (&NameStart, &start);
  M2Quads_PopTtok (&NameEnd, &end);
  if (Debugging)
    {
      M2Printf_printf0 ((const char *) "pass 1: ", 8);
      SymbolTable_DisplayTrees (SymbolTable_GetCurrentModule ());
    }
  if (NameStart != NameEnd)
    {
      M2MetaError_MetaErrorT1 (end, (const char *) "inconsistent program module name {%1Wa}", 39, SymbolTable_MakeError (start, NameStart));
    }
  P0SymBuild_LeaveBlock ();
}


/*
   StartBuildInnerModule - Creates an Inner module and starts
                           a new scope.

                           The Stack is expected:

                           Entry                 Exit

                    Ptr ->                                     <- Ptr
                           +------------+        +-----------+
                           | NameStart  |        | NameStart |
                           |------------|        |-----------|

*/

extern "C" void P1SymBuild_StartBuildInnerModule (void)
{
  unsigned int tok;
  NameKey_Name name;
  unsigned int ModuleSym;

  M2Quads_PopTtok (&name, &tok);
  ModuleSym = SymbolTable_GetSym (name);
  M2Debug_Assert (ModuleSym != SymbolTable_NulSym);
  SymbolTable_StartScope (ModuleSym);
  M2Debug_Assert (! (SymbolTable_IsDefImp (ModuleSym)));
  M2Quads_PushTtok (name, tok);
  P0SymBuild_EnterBlock (name);
}


/*
   EndBuildInnerModule - Destroys the Inner module scope and
                         checks for correct name.

                         The Stack is expected:

                         Entry                 Exit

                  Ptr ->
                         +------------+        +-----------+
                         | NameEnd    |        |           |
                         |------------|        |-----------|
                         | NameStart  |        |           | <- Ptr
                         |------------|        |-----------|
*/

extern "C" void P1SymBuild_EndBuildInnerModule (void)
{
  unsigned int start;
  unsigned int end;
  NameKey_Name NameStart;
  NameKey_Name NameEnd;

  SymbolTable_EndScope ();
  M2Quads_PopTtok (&NameStart, &start);
  M2Quads_PopTtok (&NameEnd, &end);
  if (NameStart != NameEnd)
    {
      M2MetaError_MetaErrorT1 (end, (const char *) "inconsistent inner module name {%1Wa}", 37, SymbolTable_MakeError (start, NameStart));
    }
  P0SymBuild_LeaveBlock ();
}


/*
   BuildImportOuterModule - Builds imported identifiers into an outer module
                            from a definition module.

                            The Stack is expected:

                            Entry           OR    Entry

                     Ptr ->                Ptr ->
                            +------------+        +-----------+
                            | #          |        | #         |
                            |------------|        |-----------|
                            | Id1        |        | Id1       |
                            |------------|        |-----------|
                            .            .        .           .
                            .            .        .           .
                            .            .        .           .
                            |------------|        |-----------|
                            | Id#        |        | Id#       |
                            |------------|        |-----------|
                            | ImportTok  |        | Ident     |
                            |------------|        |-----------|

                            IMPORT Id1, .. Id# ;  FROM Ident IMPORT Id1 .. Id# ;


                            Exit

                            All above stack discarded
*/

extern "C" void P1SymBuild_BuildImportOuterModule (bool definition)
{
  unsigned int Sym;
  unsigned int ModSym;
  unsigned int i;
  unsigned int n;

  M2Quads_PopT (&n);  /* n   = # of the Ident List  */
  if ((M2Quads_OperandT (n+1)) == M2Reserved_ImportTok)
    {
      /* Ident list contains Module Names  */
      i = 1;
      while (i <= n)
        {
          ModSym = M2Batch_LookupModule (M2Quads_OperandTok ((n+1)-i), M2Quads_OperandT ((n+1)-i));
          SymbolTable_PutImported (ModSym);
          if (definition)
            {
              SymbolTable_PutIncludedByDefinition (ModSym);
            }
          i += 1;
        }
    }
  else
    {
      /* Ident List contains list of objects  */
      ModSym = M2Batch_LookupModule (M2Quads_OperandTok (n+1), M2Quads_OperandT (n+1));
      i = 1;
      /* 
         WriteString('Importing ') ; WriteKey(Operand(j)) ; WriteString(' from ') ; WriteKey(GetSymName(ModSym)) ; WriteLn ;
  */
      while (i <= n)
        {
          Sym = SymbolTable_GetExported (M2Quads_OperandTok ((n+1)-i), ModSym, M2Quads_OperandT ((n+1)-i));
          SymbolTable_PutImported (Sym);
          i += 1;
        }
    }
  M2Quads_PopN (n+1);  /* clear stack  */
}


/*
   BuildExportOuterModule - Builds exported identifiers from an outer module
                            to the outside world of library modules.

                            The Stack is expected:

                            Entry           OR    Entry

                     Ptr ->                Ptr ->
                            +------------+        +--------------+
                            | #          |        | #            |
                            |------------|        |--------------|
                            | Id1        |        | Id1          |
                            |------------|        |--------------|
                            .            .        .              .
                            .            .        .              .
                            .            .        .              .
                            |------------|        |--------------|
                            | Id#        |        | Id#          |
                            |------------|        |--------------|
                            | ExportTok  |        | QualifiedTok |
                            |------------|        |--------------|

                            EXPORT Id1, .. Id# ;  EXPORT QUALIFIED Id1 .. Id# ;

                            Error Condition


                            Exit

                            All above stack discarded
*/

extern "C" void P1SymBuild_BuildExportOuterModule (void)
{
  unsigned int i;
  unsigned int n;

  M2Quads_PopT (&n);  /* n   = # of the Ident List  */
  if (((M2Quads_OperandT (n+1)) == M2Reserved_QualifiedTok) && (M2Comp_CompilingDefinitionModule ()))  /* n   = # of the Ident List  */
    {
      SymbolTable_PutDoesNeedExportList (SymbolTable_GetCurrentModule ());
      /* Ident List contains list of export qualified objects  */
      i = 1;
      while (i <= n)
        {
          SymbolTable_PutExportQualified (M2Quads_OperandTok (i), M2Quads_OperandT (i));
          i += 1;
        }
    }
  else if (((M2Quads_OperandT (n+1)) == M2Reserved_UnQualifiedTok) && (M2Comp_CompilingDefinitionModule ()))
    {
      /* avoid dangling else.  */
      SymbolTable_PutDoesNeedExportList (SymbolTable_GetCurrentModule ());
      /* Ident List contains list of export unqualified objects  */
      i = 1;
      while (i <= n)
        {
          SymbolTable_PutExportUnQualified (M2Quads_OperandTok (i), M2Quads_OperandT (i));
          i += 1;
        }
    }
  else if (M2Comp_CompilingDefinitionModule ())
    {
      /* avoid dangling else.  */
      M2MetaError_MetaError0 ((const char *) "the {%EkEXPORT} must be either {%kQUALIFIED} or {%kUNQUALIFIED} in a definition module", 86);
    }
  else
    {
      /* avoid dangling else.  */
      M2MetaError_MetaError0 ((const char *) "{%E}only allowed inter module exports in a definition module", 60);
    }
  M2Quads_PopN (n+1);  /* clear stack  */
}


/*
   CheckExplicitExported - checks to see whether we are compiling
                           a definition module and whether the ident
                           is implicitly export qualified or unqualified.


                                  The Stack is expected:

                                  Entry                 Exit

                           Ptr ->                Ptr ->
                                  +------------+        +-----------+
                                  | Identname  |        | Identname |
                                  |------------|        |-----------|

*/

extern "C" void P1SymBuild_CheckExplicitExported (void)
{
  if ((M2Comp_CompilingDefinitionModule ()) && (SymbolTable_DoesNotNeedExportList (SymbolTable_GetCurrentModule ())))
    {
      /* printf1('exporting identifier %a
      ', OperandT(1)) ;  */
      SymbolTable_PutExportQualified (M2Quads_OperandTok (1), M2Quads_OperandT (1));
    }
}


/*
   BuildImportInnerModule - Builds imported identifiers into an inner module
                            from the last level of module.

                            The Stack is expected:

                            Entry           OR    Entry

                     Ptr ->                Ptr ->
                            +------------+        +-----------+
                            | #          |        | #         |
                            |------------|        |-----------|
                            | Id1        |        | Id1       |
                            |------------|        |-----------|
                            .            .        .           .
                            .            .        .           .
                            .            .        .           .
                            |------------|        |-----------|
                            | Id#        |        | Id#       |
                            |------------|        |-----------|
                            | ImportTok  |        | Ident     |
                            |------------|        |-----------|

                            IMPORT Id1, .. Id# ;  FROM Ident IMPORT Id1 .. Id# ;

                            Exit

                            All above stack discarded
*/

extern "C" void P1SymBuild_BuildImportInnerModule (void)
{
  unsigned int Sym;
  unsigned int ModSym;
  unsigned int i;
  unsigned int n;

  M2Quads_PopT (&n);  /* n   = # of the Ident List  */
  if ((M2Quads_OperandT (n+1)) == M2Reserved_ImportTok)
    {
      /* Ident List contains list of objects  */
      i = 1;
      while (i <= n)
        {
          SymbolTable_AddNameToImportList (M2Quads_OperandT (i));
          i += 1;
        }
    }
  else
    {
      /* Ident List contains list of objects  */
      ModSym = M2Batch_LookupOuterModule (M2Quads_OperandTok (n+1), M2Quads_OperandT (n+1));
      i = 1;
      while (i <= n)
        {
          Sym = SymbolTable_GetExported (M2Quads_OperandTok ((n+1)-i), ModSym, M2Quads_OperandT ((n+1)-i));
          SymbolTable_PutImported (Sym);
          i += 1;
        }
    }
  M2Quads_PopN (n+1);  /* clear stack  */
}


/*
   BuildExportInnerModule - Builds exported identifiers from an inner module
                            to the next layer module.

                            The Stack is expected:

                            Entry           OR    Entry

                     Ptr ->                Ptr ->
                            +------------+        +--------------+
                            | #          |        | #            |
                            |------------|        |--------------|
                            | Id1        |        | Id1          |
                            |------------|        |--------------|
                            .            .        .              .
                            .            .        .              .
                            .            .        .              .
                            |------------|        |--------------|
                            | Id#        |        | Id#          |
                            |------------|        |--------------|
                            | ExportTok  |        | QualifiedTok |
                            |------------|        |--------------|

                            EXPORT Id1, .. Id# ;  EXPORT QUALIFIED Id1 .. Id# ;


                            Exit


                            All above stack discarded
*/

extern "C" void P1SymBuild_BuildExportInnerModule (void)
{
  unsigned int tok;
  unsigned int PrevMod;
  unsigned int Sym;
  unsigned int i;
  unsigned int n;

  M2Quads_PopT (&n);  /* n   = # of the Ident List  */
  if ((M2Quads_OperandT (n+1)) == M2Reserved_ExportTok)
    {
      /* Ident List contains list of objects  */
      i = 1;
      PrevMod = SymbolTable_GetScope (SymbolTable_GetCurrentScope ());
      while (i <= n)
        {
          tok = static_cast<unsigned int> (M2Quads_OperandTok (i));
          if ((PrevMod != SymbolTable_NulSym) && ((SymbolTable_IsModule (PrevMod)) || (SymbolTable_IsDefImp (PrevMod))))
            {
              Sym = SymbolTable_GetLocalSym (PrevMod, M2Quads_OperandT (i));
              if (Sym == SymbolTable_NulSym)
                {
                  /* avoid dangling else.  */
                  Sym = SymbolTable_TryMoveUndeclaredSymToInnerModule (PrevMod, SymbolTable_GetCurrentScope (), M2Quads_OperandT (i));
                  if (Sym == SymbolTable_NulSym)
                    {
                      Sym = SymbolTable_RequestSym (tok, M2Quads_OperandT (i));
                      SymbolTable_PutExported (Sym);
                    }
                }
              else
                {
                  /* use Sym which has already been created in outer scope  */
                  SymbolTable_AddSymToModuleScope (SymbolTable_GetCurrentScope (), Sym);
                }
            }
          else
            {
              Sym = SymbolTable_RequestSym (tok, M2Quads_OperandT (i));
              SymbolTable_PutExported (Sym);
            }
          i += 1;
        }
    }
  else
    {
      M2MetaError_MetaError0 ((const char *) "{%EkQUALIFIED} not allowed in an inner module", 45);
    }
  M2Quads_PopN (n+1);  /* clear stack  */
}


/*
   StartBuildEnumeration - Builds an Enumeration type Type.


                           Stack

                           Entry                 Exit

                    Ptr ->
                           +------------+
                           | #          |
                           |------------|
                           | en 1       |
                           |------------|
                           | en 2       |
                           |------------|
                           .            .
                           .            .
                           .            .                       <- Ptr
                           |------------|        +------------+
                           | en #       |        | Type       |
                           |------------|        |------------|
                           | Name       |        | Name       |
                           |------------|        |------------|
*/

extern "C" void P1SymBuild_StartBuildEnumeration (void)
{
  NameKey_Name name;
  unsigned int n;
  unsigned int i;
  unsigned int Type;
  unsigned int tokno;

  M2Quads_PopT (&n);  /* No := #  */
  name = static_cast<NameKey_Name> (M2Quads_OperandT (n+1));  /* No := #  */
  tokno = static_cast<unsigned int> (M2Quads_OperandTok (n+1));
  Type = SymbolTable_MakeEnumeration (tokno, name);
  i = 1;
  while (i <= n)
    {
      SymbolTable_PutFieldEnumeration (M2Quads_OperandTok ((n-i)+1), Type, M2Quads_OperandT ((n-i)+1));
      i += 1;
    }
  FifoQueue_PutEnumerationIntoFifoQueue (Type);  /* store enumeration away for pass 2  */
  M2Quads_PopN (n+1);  /* store enumeration away for pass 2  */
  M2Quads_PushTtok (name, tokno);
  M2Quads_PushTtok (Type, tokno);
}


/*
   EndBuildEnumeration - completes the construction of the enumeration type.


                         Stack

                         Entry                 Exit

                  Ptr ->
                         +------------+
                         | Type       |                          <- Ptr
                         |------------|        +---------------+
                         | Name       |        | Type  | Name  |
                         |------------|        |---------------|

                                               Empty
*/

extern "C" void P1SymBuild_EndBuildEnumeration (void)
{
  unsigned int tokno;
  unsigned int Sym;
  unsigned int Type;
  NameKey_Name n1;
  NameKey_Name n2;
  NameKey_Name name;

  /* 
      Two cases

      - the type name the same as Name, or the name is nul. - do nothing.
      - when type with a name that is different to Name. In which case
        we create a new type.
  */
  M2Quads_PopTtok (&Type, &tokno);
  M2Quads_PopT (&name);
  if (Debugging)
    {
      n1 = SymbolTable_GetSymName (SymbolTable_GetCurrentModule ());
      M2Printf_printf2 ((const char *) "inside module %a declaring type name %a\\n", 41, (const unsigned char *) &n1, (sizeof (n1)-1), (const unsigned char *) &name, (sizeof (name)-1));
      if (! (SymbolTable_IsUnknown (Type)))
        {
          n1 = SymbolTable_GetSymName (SymbolTable_GetScope (Type));
          n2 = SymbolTable_GetSymName (Type);
          M2Printf_printf2 ((const char *) "type was created inside scope %a as name %a\\n", 45, (const unsigned char *) &n1, (sizeof (n1)-1), (const unsigned char *) &n2, (sizeof (n2)-1));
        }
    }
  if ((name == NameKey_NulName) || ((SymbolTable_GetSymName (Type)) == name))
    {
      /* 
         Typically the declaration that causes this case is:

         VAR
            a: (blue, green, red) ;
             ^
             |
             +---- type has no name.

         in which case the constructed from StartBuildEnumeration is complete
  */
      M2Quads_PushTFtok (Type, name, tokno);
    }
  else
    {
      /* in this case we are seeing:

         TYPE
            name = (blue, green, red)

         so we construct the type name and define it to have the previously
         created enumeration type
  */
      Sym = SymbolTable_MakeType (tokno, name);
      SymbolTable_PutType (Sym, Type);
      M2Quads_PushTFtok (Sym, name, tokno);
    }
}


/*
   BuildHiddenType - Builds a Hidden Type.


                     Stack

                     Entry                 Exit

              Ptr ->
                     +------------+
                     | Name       |                          <- Ptr
                     |------------|        Empty
*/

extern "C" void P1SymBuild_BuildHiddenType (void)
{
  NameKey_Name name;
  unsigned int tokno;

  M2Quads_PopTtok (&name, &tokno);
  /* WriteKey(Name) ; WriteLn ;  */
  M2Debug_Assert ((SymbolTable_MakeHiddenType (tokno, name)) != SymbolTable_NulSym);
}


/*
   StartBuildProcedure - Builds a Procedure.

                         The Stack:

                         Entry                 Exit

                  Ptr ->                                      <- Ptr
                         +------------+        +------------+
                         | Name       |        | ProcSym    |
                         |------------|        |------------|
                         | inlinetok  |        |            |
                         | or         |        |            |
                         | builtintok |        |            |
                         | or name or |        | Name       |
                         | NulTok     |        |            |
                         |------------|        |------------|
*/

extern "C" void P1SymBuild_StartBuildProcedure (void)
{
  unsigned int tokno;
  NameKey_Name builtin;
  NameKey_Name name;
  unsigned int ProcSym;

  M2Quads_PopTtok (&name, &tokno);
  M2Quads_PopT (&builtin);  /* was this procedure defined as a builtin?  */
  M2Quads_PushTtok (name, tokno);  /* Name saved for the EndBuildProcedure name check  */
  ProcSym = SymbolTable_RequestSym (tokno, name);  /* Name saved for the EndBuildProcedure name check  */
  if (SymbolTable_IsUnknown (ProcSym))
    {
      /* A procedure may be created in a definition or implementation module, remember
         that an implementation module maybe compiled before the corresponding
         definition module.

         The procedure can also be created during a forward declaration.
         We record the forward declaration as the token of creation and adjust this
         later when we see the proper procedure declaration.  Likwwise when the forward
         keyword is seen we assign the procedure forward token location.  */
      ProcSym = SymbolTable_MakeProcedure (tokno, name);
    }
  else if (SymbolTable_IsProcedure (ProcSym))
    {
      /* avoid dangling else.  */
      /* Declared in the other module or it could have been declared by a forward decl,
         we overwrite the declaration to tokno.  The forward location is assigned in
         EndBuildForward.  */
      SymbolTable_PutDeclared (tokno, ProcSym);
    }
  else
    {
      /* avoid dangling else.  */
      M2MetaError_MetaError1 ((const char *) "expecting a procedure name and symbol {%1Ea} has been declared as a {%1d}", 73, ProcSym);
      M2Quads_PushT (ProcSym);
      return;
    }
  if (builtin != M2Reserved_NulTok)
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (builtin == M2Reserved_BuiltinTok)
        {
          SymbolTable_PutProcedureBuiltin (ProcSym, name);
        }
      else if (builtin == M2Reserved_InlineTok)
        {
          /* avoid dangling else.  */
          SymbolTable_PutProcedureInline (ProcSym);
        }
      else
        {
          /* avoid dangling else.  */
          SymbolTable_PutProcedureBuiltin (ProcSym, builtin);
        }
    }
  M2Quads_PushTtok (ProcSym, tokno);
  SymbolTable_StartScope (ProcSym);
  if (M2Comp_CompilingDefinitionModule ())
    {
      if (SymbolTable_GetProcedureDefined (ProcSym, SymbolTable_DefProcedure))
        {
          M2MetaError_MetaErrorT1 (SymbolTable_GetProcedureDeclaredTok (ProcSym, SymbolTable_DefProcedure), (const char *) "first declaration of procedure {%1Ea} in the definition module", 62, ProcSym);
          M2MetaError_MetaErrorT1 (tokno, (const char *) "duplicate declaration of procedure {%1Ea} in the definition module", 66, ProcSym);
        }
      else
        {
          SymbolTable_PutProcedureDeclaredTok (ProcSym, SymbolTable_DefProcedure, tokno);
          SymbolTable_PutProcedureDefined (ProcSym, SymbolTable_DefProcedure);
        }
    }
  else
    {
      P0SymBuild_EnterBlock (name);
    }
}


/*
   EndBuildProcedure - Ends building a Procedure.
                       It checks the start procedure name matches the end
                       procedure name.

                       The Stack:

                       (Procedure Not Defined in definition module)

                       Entry                 Exit

                Ptr ->
                       +------------+
                       | NameEnd    |
                       |------------|
                       | ProcSym    |
                       |------------|
                       | NameStart  |
                       |------------|
                                             Empty
*/

extern "C" void P1SymBuild_EndBuildProcedure (void)
{
  unsigned int tok;
  unsigned int start;
  unsigned int end;
  unsigned int ProcSym;
  NameKey_Name NameEnd;
  NameKey_Name NameStart;

  M2Quads_PopTtok (&NameEnd, &end);
  M2Quads_PopTtok (&ProcSym, &tok);
  M2Quads_PopTtok (&NameStart, &start);
  if (NameEnd != NameStart)
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if (end != M2LexBuf_UnknownTokenNo)
        {
          M2MetaError_MetaErrorT1 (end, (const char *) "procedure name at end does not match name at beginning {%1EDa}", 62, ProcSym);
        }
      else if (start != M2LexBuf_UnknownTokenNo)
        {
          /* avoid dangling else.  */
          M2MetaError_MetaErrorT2 (start, (const char *) "procedure name at end {%1EDa} does not match name at beginning {%2a}", 68, SymbolTable_MakeError (end, NameEnd), ProcSym);
        }
      else
        {
          /* avoid dangling else.  */
          M2MetaError_MetaError1 ((const char *) "procedure name at end does not match name at beginning {%1EDa}", 62, ProcSym);
        }
    }
  SymbolTable_EndScope ();
  if (SymbolTable_GetProcedureDefined (ProcSym, SymbolTable_ProperProcedure))
    {
      M2MetaError_MetaErrorT1 (SymbolTable_GetProcedureDeclaredTok (ProcSym, SymbolTable_ProperProcedure), (const char *) "first proper declaration of procedure {%1Ea}", 44, ProcSym);
      M2MetaError_MetaErrorT1 (tok, (const char *) "procedure {%1Ea} has already been declared", 42, ProcSym);
    }
  else
    {
      SymbolTable_PutProcedureDeclaredTok (ProcSym, SymbolTable_ProperProcedure, tok);
      SymbolTable_PutProcedureDefined (ProcSym, SymbolTable_ProperProcedure);
    }
  M2Debug_Assert (! (M2Comp_CompilingDefinitionModule ()));
  P0SymBuild_LeaveBlock ();
}


/*
   BuildProcedureHeading - Builds a procedure heading for the definition
                           module procedures.

                           Operation only performed if compiling a
                           definition module.

                           The Stack:

                           Entry                       Exit

                    Ptr ->
                           +------------+
                           | ProcSym    |
                           |------------|
                           | NameStart  |
                           |------------|
                                                       Empty

*/

extern "C" void P1SymBuild_BuildProcedureHeading (void)
{
  unsigned int ProcSym;
  NameKey_Name NameStart;

  if (M2Comp_CompilingDefinitionModule ())
    {
      M2Quads_PopT (&ProcSym);
      M2Quads_PopT (&NameStart);
      SymbolTable_EndScope ();
    }
}


/*
   EndBuildForward - Ends building a forward procedure declaration.

                     The Stack:

                     (This procedure is not defined in definition module)

                     Entry                 Exit

              Ptr ->
                     +------------+
                     | ProcSym    |
                     |------------|
                     | NameStart  |
                     |------------|
                                           Empty
*/

extern "C" void P1SymBuild_EndBuildForward (unsigned int forwardPos)
{
  unsigned int ProcSym;
  unsigned int tok;

  ProcSym = static_cast<unsigned int> (M2Quads_OperandT (1));
  tok = static_cast<unsigned int> (M2Quads_OperandTok (1));
  if (! (M2Options_GetEnableForward ()))
    {
      M2MetaError_MetaErrorT0 (forwardPos, (const char *) "forward declaration has not been enabled, use -fiso or -fenable-forward to enable forward procedure declarations", 112);
    }
  if (SymbolTable_GetProcedureDefined (ProcSym, SymbolTable_ForwardProcedure))
    {
      M2MetaError_MetaErrorT1 (SymbolTable_GetProcedureDeclaredTok (ProcSym, SymbolTable_ForwardProcedure), (const char *) "first forward declaration of {%1Ea}", 35, ProcSym);
      M2MetaError_MetaErrorT1 (tok, (const char *) "forward declaration of procedure {%1Ea} has already occurred", 60, ProcSym);
    }
  else
    {
      SymbolTable_PutProcedureDeclaredTok (ProcSym, SymbolTable_ForwardProcedure, tok);
      SymbolTable_PutProcedureDefined (ProcSym, SymbolTable_ForwardProcedure);
    }
  M2Quads_PopN (2);
  SymbolTable_EndScope ();
  M2Debug_Assert (! (M2Comp_CompilingDefinitionModule ()));
  P0SymBuild_LeaveBlock ();
}


/*
   BuildNulName - Pushes a NulName onto the top of the stack.
                  The Stack:


                  Entry                    Exit

                                                          <- Ptr
                  Empty                    +------------+
                                           | NulName    |
                                           |------------|
*/

extern "C" void P1SymBuild_BuildNulName (void)
{
  M2Quads_PushT (static_cast<unsigned int> (NameKey_NulName));
}


/*
   BuildTypeEnd - Pops the type Type and Name.
                  The Stack:


                  Entry                    Exit


           Ptr ->
                  +-------------+
                  | Type | Name |          Empty
                  |-------------|
*/

extern "C" void P1SymBuild_BuildTypeEnd (void)
{
  unsigned int Type;
  NameKey_Name name;

  M2Quads_PopTF (&Type, &name);
}


/*
   BuildImportStatement - create a new import statement in the current module.
                          It ignores local modules.

                          The quadruple stack is not used.
*/

extern "C" void P1SymBuild_BuildImportStatement (unsigned int tok)
{
  unsigned int scope;

  scope = SymbolTable_GetCurrentScope ();
  if ((SymbolTable_IsDefImp (scope)) || ((SymbolTable_IsModule (scope)) && (! (SymbolTable_IsInnerModule (scope)))))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if ((M2Comp_CompilingDefinitionModule ()) && (! (SymbolTable_IsDefImp (scope))))
        {
          M2MetaError_MetaError1 ((const char *) "module scope should be a definition module rather than {%1EDa}", 62, scope);
        }
      else
        {
          importStatementCount += 1;
          SymbolTable_AppendModuleImportStatement (scope, SymbolTable_MakeImportStatement (tok, importStatementCount));
        }
    }
}


/*
   AddImportToImportStatement - the top of stack is expected to be a module name.
                                This is looked up from the module universe and
                                wrapped in an import symbol and placed into the
                                current import statement.

                                The quadruple stack is unchanged.

                                Entry                      Exit


                         Ptr ->                                                   <- Ptr
                                +---------------------+    +---------------------+
                                | ImportedModuleName  |    | ImportedModuleName  |
                                |---------------------|    |---------------------|
*/

extern "C" void P1SymBuild_AddImportToImportStatement (bool qualified)
{
  unsigned int scope;

  scope = SymbolTable_GetCurrentScope ();
  if ((SymbolTable_IsDefImp (scope)) || ((SymbolTable_IsModule (scope)) && (! (SymbolTable_IsInnerModule (scope)))))
    {
      /* avoid gcc warning by using compound statement even if not strictly necessary.  */
      if ((M2Comp_CompilingDefinitionModule ()) && (! (SymbolTable_IsDefImp (scope))))
        {
          M2MetaError_MetaError1 ((const char *) "module scope should be a definition module rather than {%1EDa}", 62, scope);
        }
      else
        {
          SymbolTable_AppendModuleOnImportStatement (scope, SymbolTable_MakeImport (M2Quads_OperandTok (1), M2Batch_LookupModule (M2Quads_OperandTok (1), M2Quads_OperandT (1)), importStatementCount, qualified));
        }
    }
}

extern "C" void _M2_P1SymBuild_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}

extern "C" void _M2_P1SymBuild_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
