/* do not edit automatically generated by mc from P2SymBuild.  */
/* P2SymBuild.mod pass 2 symbol creation.

Copyright (C) 2001-2025 Free Software Foundation, Inc.
Contributed by Gaius Mulley <gaius.mulley@southwales.ac.uk>.

This file is part of GNU Modula-2.

GNU Modula-2 is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 3, or (at your option)
any later version.

GNU Modula-2 is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU Modula-2; see the file COPYING3.  If not see
<http://www.gnu.org/licenses/>.  */

#include "config.h"
#include "system.h"
#include "gcc-consolidation.h"

#include <stdbool.h>
#   if !defined (PROC_D)
#      define PROC_D
       typedef void (*PROC_t) (void);
       typedef struct { PROC_t proc; } PROC;
#   endif

#   if !defined (TRUE)
#      define TRUE (1==1)
#   endif

#   if !defined (FALSE)
#      define FALSE (1==0)
#   endif

#if defined(__cplusplus)
#   undef NULL
#   define NULL 0
#endif
#define _P2SymBuild_C

#include "GP2SymBuild.h"
#   include "Glibc.h"
#   include "GNameKey.h"
#   include "GStrLib.h"
#   include "GM2Debug.h"
#   include "GM2LexBuf.h"
#   include "GM2Error.h"
#   include "GDynamicStrings.h"
#   include "GFormatStrings.h"
#   include "GM2Printf.h"
#   include "GM2StackWord.h"
#   include "GM2Options.h"
#   include "GStrIO.h"
#   include "GM2Base.h"
#   include "GStorage.h"
#   include "Ggcctypes.h"
#   include "GM2Reserved.h"
#   include "GM2MetaError.h"
#   include "GFifoQueue.h"
#   include "GSymbolTable.h"
#   include "GM2Batch.h"
#   include "GM2Quads.h"
#   include "GM2Comp.h"
#   include "GM2Const.h"
#   include "GM2Students.h"

#   define Debugging false
static unsigned int alignTypeNo;
static unsigned int castType;
static M2Const_constType type;
static unsigned int RememberedConstant;
static M2StackWord_StackOfWord RememberStack;
static M2StackWord_StackOfWord TypeStack;
static unsigned int curModuleSym;
static unsigned int curBeginTok;
static unsigned int curFinallyTok;
static unsigned int curStartTok;
static unsigned int curEndTok;
static M2StackWord_StackOfWord BlockStack;

/*
   BlockStart - tokno is the module/procedure/implementation/definition token
*/

extern "C" void P2SymBuild_BlockStart (unsigned int tokno);

/*
   BlockEnd - declare module ctor/init/fini/dep procedures.
*/

extern "C" void P2SymBuild_BlockEnd (unsigned int tokno);

/*
   BlockBegin - assign curBeginTok to tokno.
*/

extern "C" void P2SymBuild_BlockBegin (unsigned int tokno);

/*
   BlockFinally - assign curFinallyTok to tokno.
*/

extern "C" void P2SymBuild_BlockFinally (unsigned int tokno);
extern "C" void P2SymBuild_P2StartBuildDefModule (void);
extern "C" void P2SymBuild_P2EndBuildDefModule (void);
extern "C" void P2SymBuild_P2StartBuildImplementationModule (void);
extern "C" void P2SymBuild_P2EndBuildImplementationModule (void);
extern "C" void P2SymBuild_P2StartBuildProgramModule (void);
extern "C" void P2SymBuild_P2EndBuildProgramModule (void);

/*
   StartBuildInnerModule - Creates an Inner module and starts
                           a new scope.

                           The Stack is expected:

                           Entry                 Exit

                    Ptr ->                                     <- Ptr
                           +------------+        +-----------+
                           | NameStart  |        | NameStart |
                           |------------|        |-----------|

*/

extern "C" void P2SymBuild_StartBuildInnerModule (void);

/*
   EndBuildInnerModule - Destroys the Inner module scope and
                         checks for correct name.

                         The Stack is expected:

                         Entry                 Exit

                  Ptr ->
                         +------------+        +-----------+
                         | NameEnd    |        |           |
                         |------------|        |-----------|
                         | NameStart  |        |           | <- Ptr
                         |------------|        |-----------|
*/

extern "C" void P2SymBuild_EndBuildInnerModule (void);

/*
   BuildImportOuterModule - Builds imported identifiers into an outer module
                            from a definition module.

                            The Stack is expected:

                            Entry           OR    Entry

                     Ptr ->                Ptr ->
                            +------------+        +-----------+
                            | #          |        | #         |
                            |------------|        |-----------|
                            | Id1        |        | Id1       |
                            |------------|        |-----------|
                            .            .        .           .
                            .            .        .           .
                            .            .        .           .
                            |------------|        |-----------|
                            | Id#        |        | Id#       |
                            |------------|        |-----------|
                            | ImportTok  |        | Ident     |
                            |------------|        |-----------|

                            IMPORT Id1, .. Id# ;  FROM Ident IMPORT Id1 .. Id# ;


                            Exit

                            All above stack discarded
*/

extern "C" void P2SymBuild_BuildImportOuterModule (void);

/*
   BuildExportOuterModule - Builds exported identifiers from an outer module
                            to the outside world of library modules.

                            The Stack is expected:

                            Entry           OR    Entry

                     Ptr ->                Ptr ->
                            +------------+        +--------------+
                            | #          |        | #            |
                            |------------|        |--------------|
                            | Id1        |        | Id1          |
                            |------------|        |--------------|
                            .            .        .              .
                            .            .        .              .
                            .            .        .              .
                            |------------|        |--------------|
                            | Id#        |        | Id#          |
                            |------------|        |--------------|
                            | ExportTok  |        | QualifiedTok |
                            |------------|        |--------------|

                            EXPORT Id1, .. Id# ;  EXPORT QUALIFIED Id1 .. Id# ;

                            Error Condition


                            Exit

                            All above stack discarded
*/

extern "C" void P2SymBuild_BuildExportOuterModule (void);

/*
   BuildImportInnerModule - Builds imported identifiers into an inner module
                            from the last level of module.

                            The Stack is expected:

                            Entry           OR    Entry

                     Ptr ->                Ptr ->
                            +------------+        +-----------+
                            | #          |        | #         |
                            |------------|        |-----------|
                            | Id1        |        | Id1       |
                            |------------|        |-----------|
                            .            .        .           .
                            .            .        .           .
                            .            .        .           .
                            |------------|        |-----------|
                            | Id#        |        | Id#       |
                            |------------|        |-----------|
                            | ImportTok  |        | Ident     |
                            |------------|        |-----------|

                            IMPORT Id1, .. Id# ;  FROM Ident IMPORT Id1 .. Id# ;

                            Exit

                            All above stack discarded
*/

extern "C" void P2SymBuild_BuildImportInnerModule (void);

/*
   BuildExportInnerModule - Builds exported identifiers from an inner module
                            to the next layer module.

                            The Stack is expected:

                            Entry           OR    Entry

                     Ptr ->                Ptr ->
                            +------------+        +--------------+
                            | #          |        | #            |
                            |------------|        |--------------|
                            | Id1        |        | Id1          |
                            |------------|        |--------------|
                            .            .        .              .
                            .            .        .              .
                            .            .        .              .
                            |------------|        |--------------|
                            | Id#        |        | Id#          |
                            |------------|        |--------------|
                            | ExportTok  |        | QualifiedTok |
                            |------------|        |--------------|

                            EXPORT Id1, .. Id# ;  EXPORT QUALIFIED Id1 .. Id# ;


                            Exit

                            All above stack discarded
*/

extern "C" void P2SymBuild_BuildExportInnerModule (void);

/*
   BuildNumber - Converts a number into a symbol.


                 Stack

                 Entry                 Exit

          Ptr ->                                             <- Ptr
                 +------------+        +-------------------+
                 | Name | tok |        | Sym | Type | tok  |
                 |------------+        |-------------------|
*/

extern "C" void P2SymBuild_BuildNumber (void);

/*
   BuildString - Converts a string into a symbol.


                 Stack

                 Entry                 Exit

          Ptr ->                                               <- Ptr
                 +-------------+        +--------------------+
                 | Name | | tok|        | Sym | NulSym | tok |
                 |-------------+        |--------------------|
*/

extern "C" void P2SymBuild_BuildString (void);

/*
   BuildConst - builds a constant.
                Stack

                Entry                 Exit

         Ptr ->
                +------------+
                | Name       |
                |------------+                       <- Ptr
*/

extern "C" void P2SymBuild_BuildConst (void);

/*
   StartBuildEnumeration - Builds an Enumeration type Type.


                           Stack

                           Entry                 Exit

                    Ptr ->
                           +------------+
                           | #          |
                           |------------|
                           | en 1       |
                           |------------|
                           | en 2       |
                           |------------|
                           .            .
                           .            .
                           .            .                       <- Ptr
                           |------------|        +------------+
                           | en #       |        | Type       |
                           |------------|        |------------|
                           | Name       |        | Name       |
                           |------------|        |------------|
*/

extern "C" void P2SymBuild_StartBuildEnumeration (void);

/*
   BuildSubrange - Builds a Subrange type Symbol, the base type can also be
                   supplied if known.

                      Stack

                      Entry                 Exit


                                                           <- Ptr
                                            +------------+
               Ptr ->                       | Type       |
                      +------------+        |------------|
                      | Name       |        | Name       |
                      |------------|        |------------|
*/

extern "C" void P2SymBuild_BuildSubrange (unsigned int tok, unsigned int Base);

/*
   BuildAligned - builds an alignment constant symbol which is placed onto
                  the stack.  It expects the ident ALIGNED to be on the
                  stack.

                         Stack

                           Entry                 Exit


                  Ptr ->                                            <- Ptr
                         +---------------+      +-----------------+
                         | bytealignment |      | AlignmentConst  |
                         +---------------+      |-----------------|
*/

extern "C" void P2SymBuild_BuildAligned (void);

/*
   BuildVarAlignment - the AlignmentConst is either a temporary or NulSym.
                       A type may only have one alignment value and
                       error checking is performed.

                       Stack

                           Entry                 Exit


                   Ptr ->
                          +-----------------+
                          | AlignmentConst  |                             <- Ptr
                          |-----------------|        +------------------+
                          | Type            |        | Type  | TypeName |
                          |-----------------|        |------------------|
*/

extern "C" void P2SymBuild_BuildVarAlignment (void);

/*
   BuildTypeAlignment - the AlignmentConst is either a temporary or NulSym.
                        In the case of NulSym it is popped from the stack
                        and the procedure returns.  Otherwise the temporary
                        is popped and recorded as the alignment value for this
                        type.  A type may only have one alignment value and
                        error checking is performed.

                        Stack

                            Entry                 Exit


                    Ptr ->
                           +-----------------+
                           | AlignmentConst  |
                           |-----------------|
                           | Type            |    Empty
                           |-----------------|
*/

extern "C" void P2SymBuild_BuildTypeAlignment (void);
extern "C" void P2SymBuild_P2BuildDefaultFieldAlignment (void);

/*
   BuildPragmaConst - pushes a constant to the stack and stores it away into the
                      const fifo queue ready for pass 3.
*/

extern "C" void P2SymBuild_BuildPragmaConst (void);

/*
   BuildVariable - Builds variables listed in an IdentList with a Type.

                   Stack

                   Entry                 Exit

            Ptr ->
                   +------------+        +------------+
                   | Type | Name|        |            |
                   |------------|        |------------|
                   | #          |        |            |
                   |------------|        |------------|
                   | Ident 1    |        |            |
                   |------------|        |------------|
                   | Ident 2    |        |            |
                   |------------|        |------------|
                   .            .        .            .
                   .            .        .            .
                   .            .        .            .
                   |------------|        |------------|
                   | Ident #    |        |            | <- Ptr
                   |------------|        |------------|

                                           Empty
*/

extern "C" void P2SymBuild_BuildVariable (void);

/*
   BuildType - Builds a Type.


               Stack

               Entry                 Exit

        Ptr ->
               +------------+
               | Type       |                          <- Ptr
               |------------|        +---------------+
               | Name       |        | Type  | Name  |
               |------------|        |---------------|

                                     Empty
*/

extern "C" void P2SymBuild_BuildType (void);

/*
   StartBuildFormalParameters - Initialises the quadruple stack for
                                Formal Parameters.

                                The Stack:

                                Entry                Exit

                                                                    <- Ptr
                                                     +------------+
                                Empty                | 0          |
                                                     |------------|
*/

extern "C" void P2SymBuild_StartBuildFormalParameters (void);

/*
   EndBuildFormalParameters - Resets the quadruple stack after building
                              Formal Parameters.

                              The Stack:

                              Entry                    Exit

                       Ptr ->
                              +------------+
                              | NoOfParam  |                          <- Ptr
                              |------------|           +------------+
                              | ProcSym    |           | ProcSym    |
                              |------------|           |------------|
*/

extern "C" void P2SymBuild_EndBuildFormalParameters (void);

/*
   BuildProcedureHeading - Builds a procedure heading for the definition
                           module procedures.

                           Operation only performed if compiling a
                           definition module.

                           The Stack:

                           Entry                       Exit

                    Ptr ->
                           +------------+
                           | ProcSym    |
                           |------------|
                           | NameStart  |
                           |------------|
                                                       Empty

*/

extern "C" void P2SymBuild_BuildProcedureHeading (void);

/*
   BuildFunction - Builds a procedures return type.
                   Procedure becomes a function.

                    The Stack:

                    Entry                 Exit

             Ptr ->
                    +------------+
                    | TypeSym    |                       <- Ptr
                    |------------|        +------------+
                    | ProcSym    |        | ProcSym    |
                    |------------|        |------------|
*/

extern "C" void P2SymBuild_BuildFunction (void);

/*
   BuildOptFunction - Builds a procedures optional return type.
                      Procedure becomes a function and the user
                      can either call it as a function or a procedure.

                      The Stack:

                      Entry                 Exit

               Ptr ->
                      +------------+
                      | TypeSym    |                       <- Ptr
                      |------------|        +------------+
                      | ProcSym    |        | ProcSym    |
                      |------------|        |------------|
*/

extern "C" void P2SymBuild_BuildOptFunction (void);

/*
   BuildFPSection - Builds a Formal Parameter in a procedure.

                    The Stack:

                    Entry                 Exit

             Ptr ->
                    +------------+
                    | ParamTotal |
                    |------------|
                    | TypeSym    |
                    |------------|
                    | Array/Nul  |
                    |------------|
                    | NoOfIds    |
                    |------------|
                    | Id 1       |
                    |------------|
                    .            .
                    .            .
                    .            .
                    |------------|
                    | Id n       |                       <- Ptr
                    |------------|        +------------+
                    | Var / Nul  |        | ParamTotal |
                    |------------|        |------------|
                    | ProcSym    |        | ProcSym    |
                    |------------|        |------------|
*/

extern "C" void P2SymBuild_BuildFPSection (void);

/*
   BuildVarArgs - indicates that the ProcSym takes varargs
                  after ParamTotal.
                                                         <- Ptr
                    +------------+        +------------+
                    | ParamTotal |        | ParamTotal |
                    |------------|        |------------|
                    | ProcSym    |        | ProcSym    |
                    |------------|        |------------|

*/

extern "C" void P2SymBuild_BuildVarArgs (void);

/*
   BuildFormalVarArgs - indicates that the procedure type takes varargs.

                                                             <- Ptr
                        +------------+        +------------+
                        | ProcSym    |        | ProcSym    |
                        |------------|        |------------|

*/

extern "C" void P2SymBuild_BuildFormalVarArgs (void);

/*
   BuildOptArg - indicates that the ProcSym takes a single optarg
                 after ParamTotal.

                                                         <- Ptr
                 +------------+        +------------+
                 | ParamTotal |        | ParamTotal |
                 |------------|        |------------|
                 | ProcSym    |        | ProcSym    |
                 |------------|        |------------|
*/

extern "C" void P2SymBuild_BuildOptArg (void);

/*
   StartBuildProcedure - Builds a Procedure.

                         The Stack:

                         Entry                 Exit

                                                              <- Ptr
                                               +------------+
                  Ptr ->                       | ProcSym    |
                         +------------+        |------------|
                         | Name       |        | Name       |
                         |------------|        |------------|
*/

extern "C" void P2SymBuild_StartBuildProcedure (void);

/*
   EndBuildProcedure - Ends building a Procedure.
                       It checks the start procedure name matches the end
                       procedure name.

                       The Stack:

                       (Procedure Not Defined in definition module)

                       Entry                 Exit

                Ptr ->
                       +------------+
                       | NameEnd    |
                       |------------|
                       | ProcSym    |
                       |------------|
                       | NameStart  |
                       |------------|
                                             Empty
*/

extern "C" void P2SymBuild_EndBuildProcedure (void);

/*
   EndBuildForward - ends building a forward procedure.
*/

extern "C" void P2SymBuild_EndBuildForward (void);

/*
   BuildNoReturnAttribute - provide an interface to the symbol table module.
*/

extern "C" void P2SymBuild_BuildNoReturnAttribute (void);

/*
   CheckProcedure - checks to see that the top of stack procedure
                    has not been declared as a procedure function.

                    The Stack:

                    Entry                 Exit

             Ptr ->                                      <- Ptr
                    +------------+        +------------+
                    | ProcSym    |        | ProcSym    |
                    |------------|        |------------|
*/

extern "C" void P2SymBuild_CheckProcedure (void);

/*
   BuildPointerType - builds a pointer type.
                      The Stack:

                      Entry                       Exit
                      =====                       ====


               Ptr ->                                             <- Ptr
                      +------------+              +-------------+
                      | Type       |              | PointerType |
                      |------------|              |-------------|
                      | Name       |              | Name        |
                      |------------|              |-------------|
*/

extern "C" void P2SymBuild_BuildPointerType (unsigned int pointerpos);

/*
   BuildSetType - builds a set type.
                  The Stack:

                  Entry                       Exit
                  =====                       ====


           Ptr ->                                             <- Ptr
                  +------------+              +-------------+
                  | Type       |              | SetType     |
                  |------------|              |-------------|
                  | Name       |              | Name        |
                  |------------|              |-------------|
*/

extern "C" void P2SymBuild_BuildSetType (unsigned int setpos, bool ispacked);

/*
   BuildRecord - Builds a record type.
                 The Stack:

                 Entry                              Exit
                 =====                              ====


                                                                  <- Ptr
                                                    +-----------+
          Ptr ->                                    | RecordSym |
                 +------------------+               |-----------|
                 | Name             |               | Name      |
                 |------------------|               |-----------|
*/

extern "C" void P2SymBuild_BuildRecord (void);

/*
   BuildFieldRecord - Builds a field into a record sym.
                      The Stack:


                      Entry                     Exit
                      =====                     ====

               Ptr ->
                      +-------------+
                      | NoOfPragmas |
                      |-------------|
                      | Const1      |
                      |-------------|
                      | PragmaName1 |
                      |-------------|
                      | Type | Name |
                      |-------------|
                      | n           |
                      |-------------|
                      | Id 1        |
                      |-------------|
                      .             .
                      .             .
                      .             .
                      |-------------|
                      | Id n        |                           <- Ptr
                      |-------------|           +-------------+
                      | RecordSym   |           | RecordSym   |
                      |-------------|           |-------------|
                      | RecordName  |           | RecordName  |
                      |-------------|           |-------------|
*/

extern "C" void P2SymBuild_BuildFieldRecord (void);

/*
   StartBuildVarient - Builds a varient symbol on top of a record sym.
                       The Stack:


                       Entry                     Exit
                       =====                     ====

                                                                 <- Ptr
                                                 +-------------+
                Ptr ->                           | VarientSym  |
                       +-------------+           |-------------|
                       | RecordSym   |           | RecordSym   |
                       |-------------|           |-------------|
                       | RecordName  |           | RecordName  |
                       |-------------|           |-------------|
*/

extern "C" void P2SymBuild_StartBuildVarient (void);

/*
   EndBuildVarient - Removes the varient symbol from the stack.
                     The Stack:

                     Entry                     Exit
                     =====                     ====

              Ptr ->
                     +-------------+
                     | VarientSym  |                           <- Ptr
                     |-------------|           +-------------+
                     | RecordSym   |           | RecordSym   |
                     |-------------|           |-------------|
                     | RecordName  |           | RecordName  |
                     |-------------|           |-------------|
*/

extern "C" void P2SymBuild_EndBuildVarient (void);

/*
   BuildVarientSelector - Builds a field into a record sym.
                          The Stack:


                          Entry                     Exit
                          =====                     ====

                   Ptr ->
                          +-------------+
                          | Type        |
                          |-------------|
                          | Tag         |                           <- Ptr
                          |-------------|           +-------------+
                          | RecordSym   |           | RecordSym   |
                          |-------------|           |-------------|
*/

extern "C" void P2SymBuild_BuildVarientSelector (void);

/*
   StartBuildVarientFieldRecord - Builds a varient field into a varient sym.
                                  The Stack:


                                  Entry                     Exit
                                  =====                     ====

                                                                       <- Ptr
                                                       +-------------+
                      Ptr ->                           | VarientField|
                             +-------------+           |-------------|
                             | VarientSym  |           | VarientSym  |
                             |-------------|           |-------------|
*/

extern "C" void P2SymBuild_StartBuildVarientFieldRecord (void);

/*
   EndBuildVarientFieldRecord - Removes a varient field from the stack.
                                The Stack:


                                Entry                     Exit
                                =====                     ====

                         Ptr ->
                                +-------------+
                                | VarientField|                           <- Ptr
                                |-------------|           +-------------+
                                | VarientSym  |           | VarientSym  |
                                |-------------|           |-------------|
*/

extern "C" void P2SymBuild_EndBuildVarientFieldRecord (void);

/*
   BuildNulName - Pushes a NulName onto the top of the stack.
                  The Stack:


                  Entry                    Exit

                                                          <- Ptr
                  Empty                    +------------+
                                           | NulName   |
                                           |------------|
*/

extern "C" void P2SymBuild_BuildNulName (void);

/*
   BuildTypeEnd - Pops the type Type and Name.
                  The Stack:


                  Entry                    Exit


           Ptr ->
                  +-------------+
                  | Type | Name |          Empty
                  |-------------|
*/

extern "C" void P2SymBuild_BuildTypeEnd (void);

/*
   StartBuildArray - Builds an array type.
                     The Stack:

                     Entry                        Exit
                     =====                        ====

                                                                <- Ptr
                                                  +-----------+
              Ptr ->                              | ArraySym  |
                     +------------+               |-----------|
                     | Name       |               | Name      |
                     |------------|               |-----------|
*/

extern "C" void P2SymBuild_StartBuildArray (void);

/*
   EndBuildArray - Builds an array type.
                   The Stack:

                   Entry                        Exit
                   =====                        ====

            Ptr ->
                   +------------+
                   | TypeSym    |                              <- Ptr
                   |------------|               +------------+
                   | ArraySym   |               | ArraySym   |
                   |------------|               |------------|
                   | Name       |               | Name       |
                   |------------|               |------------|
*/

extern "C" void P2SymBuild_EndBuildArray (void);

/*
   BuildFieldArray - Builds a field into an array sym.
                     The Stack:


                     Entry                     Exit
                     =====                     ====

              Ptr ->
                     +-------------+
                     | Type | Name |                           <- Ptr
                     |-------------|           +-------------+
                     | ArraySym    |           | ArraySym    |
                     |-------------|           |-------------|
                     | ArrayName   |           | ArrayName   |
                     |-------------|           |-------------|
*/

extern "C" void P2SymBuild_BuildFieldArray (void);

/*
   BuildArrayComma - converts ARRAY [..], [..] OF into ARRAY [..] OF ARRAY [..]


              Ptr ->                                           <- Ptr
                     +-------------+           +-------------+
                     | ArraySym1   |           | ArraySym2   |
                     |-------------|           |-------------|
                     | ArrayName   |           | ArrayName   |
                     |-------------|           |-------------|
*/

extern "C" void P2SymBuild_BuildArrayComma (void);

/*
   BuildProcedureType - builds a procedure type symbol.
                        The Stack:


                                                               <- Ptr
                                               +-------------+
                 Ptr ->                        | ProcTypeSym |
                        +-------------+        |-------------|
                        | Name        |        | Name        |
                        |-------------|        |-------------|
*/

extern "C" void P2SymBuild_BuildProcedureType (void);

/*
   BuildFormalType - Builds a Formal Parameter in a procedure type.

                     The Stack:

                     Entry                 Exit

              Ptr ->
                     +------------+
                     | TypeSym    |
                     |------------|
                     | Array/Nul  |
                     |------------|
                     | Var / Nul  |                         <- Ptr
                     |------------|        +--------------+
                     | ProcTypeSym|        | ProcTypeSym  |
                     |------------|        |--------------|
*/

extern "C" void P2SymBuild_BuildFormalType (void);

/*
   SeenUnknown - sets the operand type to unknown.
*/

extern "C" void P2SymBuild_SeenUnknown (void);

/*
   SeenCast - sets the operand type to cast.
*/

extern "C" void P2SymBuild_SeenCast (unsigned int sym);

/*
   SeenSet - sets the operand type to set.
*/

extern "C" void P2SymBuild_SeenSet (void);

/*
   SeenConstructor - sets the operand type to constructor.
*/

extern "C" void P2SymBuild_SeenConstructor (void);

/*
   SeenArray - sets the operand type to array.
*/

extern "C" void P2SymBuild_SeenArray (void);

/*
   SeenString - sets the operand type to string.
*/

extern "C" void P2SymBuild_SeenString (void);

/*
   SeenBoolean - sets the operand type to a BOOLEAN.
*/

extern "C" void P2SymBuild_SeenBoolean (void);

/*
   SeenZType - sets the operand type to a Z type.
*/

extern "C" void P2SymBuild_SeenZType (void);

/*
   SeenRType - sets the operand type to a R type.
*/

extern "C" void P2SymBuild_SeenRType (void);

/*
   SeenCType - sets the operand type to a C type.
*/

extern "C" void P2SymBuild_SeenCType (void);

/*
   DetermineType - assigns the top of stack symbol with the type of
                   constant expression, if known.
*/

extern "C" void P2SymBuild_DetermineType (void);

/*
   PushType -
*/

extern "C" void P2SymBuild_PushType (void);

/*
   PopType -
*/

extern "C" void P2SymBuild_PopType (void);

/*
   PushRememberConstant -
*/

extern "C" void P2SymBuild_PushRememberConstant (void);

/*
   PopRememberConstant -
*/

extern "C" void P2SymBuild_PopRememberConstant (void);

/*
   RememberConstant -
*/

extern "C" void P2SymBuild_RememberConstant (unsigned int sym);
static void stop (void);

/*
   propageteTokenPosition - if laterTokPos is unknown then return knownTokPos.
                            else return laterTokPos.
*/

static unsigned int propageteTokenPosition (unsigned int knownTokPos, unsigned int laterTokPos);

/*
   PushBlock - push the block variables to the block stack.
*/

static void PushBlock (unsigned int tokno);

/*
   PopBlock - pop the block variables from the block stack.
*/

static void PopBlock (void);

/*
   BuildFormalParameterSection - Builds a Formal Parameter in a procedure.

                                 The Stack:

                                 Entry and Exit

                          Ptr ->                <- Ptr
                                 +------------+
                                 | ParamTotal |
                                 |------------|
                                 | TypeSym    |
                                 |------------|
                                 | Array/Nul  |
                                 |------------|
                                 | NoOfIds    |
                                 |------------|
                                 | Id 1       |
                                 |------------|
                                 .            .
                                 .            .
                                 .            .
                                 |------------|
                                 | Id n       |
                                 |------------|
                                 | Var / Nul  |
                                 |------------|
                                 | ProcSym    |
                                 |------------|
*/

static void BuildFormalParameterSection (SymbolTable_ProcedureKind kind);

/*
   CheckFormalParameterSection - Checks a Formal Parameter in a procedure.
                                 The stack is unaffected.

                                 The Stack:

                                 Entry and Exit

                          Ptr ->
                                 +------------+
                                 | ParamTotal |
                                 |------------|
                                 | TypeSym    |
                                 |------------|
                                 | Array/Nul  |
                                 |------------|
                                 | NoOfIds    |
                                 |------------|
                                 | Id 1       |
                                 |------------|
                                 .            .
                                 .            .
                                 .            .
                                 |------------|
                                 | Id n       |
                                 |------------|
                                 | Var / Nul  |
                                 |------------|
                                 | ProcSym    |
                                 |------------|
*/

static void CheckFormalParameterSection (SymbolTable_ProcedureKind curkind, SymbolTable_ProcedureKind prevkind);

/*
   RemoveFPParameters - remove the FPSection parameters from the stack and
                        increment the param total with the NoOfIds.

                        The Stack:

                               Entry                 Exit

                        Ptr ->
                               +------------+
                               | ParamTotal |
                               |------------|
                               | TypeSym    |
                               |------------|
                               | Array/Nul  |
                               |------------|
                               | NoOfIds    |
                               |------------|
                               | Id 1       |
                               |------------|
                               .            .
                               .            .
                               .            .
                               |------------|
                               | Id n       |                       <- Ptr
                               |------------|        +------------+
                               | Var / Nul  |        | ParamTotal |
                               |------------|        |------------|
                               | ProcSym    |        | ProcSym    |
                               |------------|        |------------|
*/

static void RemoveFPParameters (void);

/*
   ParameterError - create two error strings chained together.
*/

static void ParameterError (const char *FmtHeader_, unsigned int _FmtHeader_high, const char *PrevDesc_, unsigned int _PrevDesc_high, const char *CurDesc_, unsigned int _CurDesc_high, unsigned int ParamNo, unsigned int ProcSym, SymbolTable_ProcedureKind curkind, SymbolTable_ProcedureKind prevkind);

/*
   ParameterMismatch - generate a parameter mismatch error between the current
                       declaration at tok and a previous ProcSym declaration.
                       NoOfPar is the current number of parameters.
*/

static void ParameterMismatch (unsigned int tok, unsigned int ProcSym, unsigned int NoOfPar, SymbolTable_ProcedureKind prevkind, SymbolTable_ProcedureKind curkind);

/*
   GetComparison - return a simple description from the result of
                   a comparison between left and right.
*/

static DynamicStrings_String GetComparison (unsigned int left, unsigned int right);

/*
   ReturnTypeMismatch - generate two errors showing the return type mismatches between
                        ProcSym and ReturnType at procedure location tok.
*/

static void ReturnTypeMismatch (unsigned int curtok, unsigned int ProcSym, unsigned int CurRetType, unsigned int curtypetok, SymbolTable_ProcedureKind curkind, SymbolTable_ProcedureKind prevkind, unsigned int PrevRetType);

/*
   CheckOptFunction - checks to see whether the optional return value
                      has been set before and if it differs it will
                      generate an error message.  It will set the
                      new value to isopt.
*/

static void CheckOptFunction (unsigned int tok, unsigned int sym, SymbolTable_ProcedureKind kind, bool isopt);

/*
   CheckProcedure - checks to see that the top of stack procedure
                    has not been declared as a procedure function.

                    The Stack:

                    Entry                 Exit

             Ptr ->                                      <- Ptr
                    +------------+        +------------+
                    | ProcSym    |        | ProcSym    |
                    |------------|        |------------|
*/

static void CheckProcedureReturn (unsigned int RetType, unsigned int typetok);

/*
   HandleRecordFieldPragmas -

                      Entry                     Exit
                      =====                     ====

               Ptr ->                                     <- Ptr

                      |-------------|           |-------------|
                      | Const1      |           | Const1      |
                      |-------------|           |-------------|
                      | PragmaName1 |           | PragmaName1 |
                      |-------------|           |-------------|
*/

static void HandleRecordFieldPragmas (unsigned int record, unsigned int field, unsigned int n);

/*
   SaveRememberedConstructor -
*/

static void SaveRememberedConstructor (void);

/*
   GetSeenString - returns a string corresponding to, s.
*/

static DynamicStrings_String GetSeenString (M2Const_constType s);

/*
   SetTypeTo - attempts to set, type, to, s.
*/

static void SetTypeTo (M2Const_constType s);

static void stop (void)
{
}


/*
   propageteTokenPosition - if laterTokPos is unknown then return knownTokPos.
                            else return laterTokPos.
*/

static unsigned int propageteTokenPosition (unsigned int knownTokPos, unsigned int laterTokPos)
{
  if (laterTokPos == M2LexBuf_UnknownTokenNo)
    {
      return knownTokPos;
    }
  else
    {
      return laterTokPos;
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   PushBlock - push the block variables to the block stack.
*/

static void PushBlock (unsigned int tokno)
{
  M2StackWord_PushWord (BlockStack, curStartTok);  /* module/implementation/definition/procedure token pos.  */
  M2StackWord_PushWord (BlockStack, curBeginTok);  /* BEGIN keyword pos.  */
  M2StackWord_PushWord (BlockStack, curEndTok);  /* END keyword pos.  */
  M2StackWord_PushWord (BlockStack, curFinallyTok);  /* FINALLY keyword pos.  */
  M2StackWord_PushWord (BlockStack, curModuleSym);  /* current module.  */
  curStartTok = tokno;  /* current module.  */
  curBeginTok = M2LexBuf_UnknownTokenNo;
  curEndTok = M2LexBuf_UnknownTokenNo;
  curFinallyTok = M2LexBuf_UnknownTokenNo;
  curModuleSym = SymbolTable_NulSym;
}


/*
   PopBlock - pop the block variables from the block stack.
*/

static void PopBlock (void)
{
  curModuleSym = static_cast<unsigned int> (M2StackWord_PopWord (BlockStack));
  curFinallyTok = static_cast<unsigned int> (M2StackWord_PopWord (BlockStack));
  curEndTok = static_cast<unsigned int> (M2StackWord_PopWord (BlockStack));
  curBeginTok = static_cast<unsigned int> (M2StackWord_PopWord (BlockStack));
  curStartTok = static_cast<unsigned int> (M2StackWord_PopWord (BlockStack));
}


/*
   BuildFormalParameterSection - Builds a Formal Parameter in a procedure.

                                 The Stack:

                                 Entry and Exit

                          Ptr ->                <- Ptr
                                 +------------+
                                 | ParamTotal |
                                 |------------|
                                 | TypeSym    |
                                 |------------|
                                 | Array/Nul  |
                                 |------------|
                                 | NoOfIds    |
                                 |------------|
                                 | Id 1       |
                                 |------------|
                                 .            .
                                 .            .
                                 .            .
                                 |------------|
                                 | Id n       |
                                 |------------|
                                 | Var / Nul  |
                                 |------------|
                                 | ProcSym    |
                                 |------------|
*/

static void BuildFormalParameterSection (SymbolTable_ProcedureKind kind)
{
  NameKey_Name ParamName;
  NameKey_Name Var;
  NameKey_Name Array;
  unsigned int tok;
  unsigned int pi;
  unsigned int TypeTok;
  unsigned int ParamTotal;
  unsigned int TypeSym;
  unsigned int UnBoundedSym;
  unsigned int NoOfIds;
  unsigned int ProcSym;
  unsigned int i;
  unsigned int ndim;

  M2Quads_PopT (&ParamTotal);
  M2Quads_PopTtok (&TypeSym, &TypeTok);
  M2Quads_PopTF (&Array, &ndim);
  M2Debug_Assert ((Array == M2Reserved_ArrayTok) || (Array == M2Reserved_NulTok));
  M2Quads_PopT (&NoOfIds);
  ProcSym = static_cast<unsigned int> (M2Quads_OperandT (NoOfIds+2));
  M2Debug_Assert (SymbolTable_IsProcedure (ProcSym));
  Var = static_cast<NameKey_Name> (M2Quads_OperandT (NoOfIds+1));
  tok = static_cast<unsigned int> (M2Quads_OperandTok (NoOfIds+2));
  M2Debug_Assert ((Var == M2Reserved_VarTok) || (Var == M2Reserved_NulTok));
  /* Restore popped elements.  */
  M2Quads_PushT (NoOfIds);
  M2Quads_PushTF (Array, ndim);
  M2Quads_PushTtok (TypeSym, TypeTok);
  M2Quads_PushT (ParamTotal);
  if (Array == M2Reserved_ArrayTok)
    {
      UnBoundedSym = SymbolTable_MakeUnbounded (tok, TypeSym, ndim);
      TypeSym = UnBoundedSym;
    }
  i = 1;
  /* +4 to skip over the top restored elements.  */
  pi = NoOfIds+4;  /* Stack index referencing stacked parameter i.  */
  while (i <= NoOfIds)  /* Stack index referencing stacked parameter i.  */
    {
      if (((M2Comp_CompilingDefinitionModule ()) && ! M2Options_PedanticParamNames) && (((SymbolTable_GetMainModule ()) == (SymbolTable_GetCurrentModule ())) || ((SymbolTable_IsHiddenTypeDeclared (SymbolTable_GetCurrentModule ())) && M2Options_ExtendedOpaque)))
        {
          /* We will see the parameters in the implementation module.  */
          ParamName = NameKey_NulName;
        }
      else
        {
          ParamName = static_cast<NameKey_Name> (M2Quads_OperandT (pi));
        }
      tok = static_cast<unsigned int> (M2Quads_OperandTok (pi));
      if (Var == M2Reserved_VarTok)
        {
          /* avoid dangling else.  */
          /* VAR parameter.  */
          if (! (SymbolTable_PutVarParam (tok, ProcSym, kind, ParamTotal+i, ParamName, TypeSym, Array == M2Reserved_ArrayTok, TypeTok)))
            {
              M2Error_InternalError ((const char *) "problems adding a VarParameter - wrong param number?", 52);
            }
        }
      else
        {
          /* Non VAR parameter.  */
          if (! (SymbolTable_PutParam (tok, ProcSym, kind, ParamTotal+i, ParamName, TypeSym, Array == M2Reserved_ArrayTok, TypeTok)))
            {
              M2Error_InternalError ((const char *) "problems adding a Parameter - wrong param number?", 49);
            }
        }
      /* 
      IF kind = ProperProcedure
      THEN
         PutDeclared (OperandTok (pi), GetParameterShadowVar (GetNthParam (ProcSym, kind, ParamTotal + i)))
      END ;
  */
      i += 1;
      pi -= 1;
    }
}


/*
   CheckFormalParameterSection - Checks a Formal Parameter in a procedure.
                                 The stack is unaffected.

                                 The Stack:

                                 Entry and Exit

                          Ptr ->
                                 +------------+
                                 | ParamTotal |
                                 |------------|
                                 | TypeSym    |
                                 |------------|
                                 | Array/Nul  |
                                 |------------|
                                 | NoOfIds    |
                                 |------------|
                                 | Id 1       |
                                 |------------|
                                 .            .
                                 .            .
                                 .            .
                                 |------------|
                                 | Id n       |
                                 |------------|
                                 | Var / Nul  |
                                 |------------|
                                 | ProcSym    |
                                 |------------|
*/

static void CheckFormalParameterSection (SymbolTable_ProcedureKind curkind, SymbolTable_ProcedureKind prevkind)
{
  NameKey_Name Array;
  NameKey_Name Var;
  bool isVarParam;
  bool Unbounded;
  unsigned int ParamI;
  unsigned int ParamIType;
  unsigned int ParamTotal;
  unsigned int TypeTok;
  unsigned int TypeSym;
  unsigned int NoOfIds;
  unsigned int ProcSym;
  unsigned int pi;
  unsigned int i;
  unsigned int ndim;

  M2Quads_PopT (&ParamTotal);
  M2Quads_PopTtok (&TypeSym, &TypeTok);
  M2Quads_PopTF (&Array, &ndim);
  M2Debug_Assert ((Array == M2Reserved_ArrayTok) || (Array == M2Reserved_NulTok));
  M2Quads_PopT (&NoOfIds);
  ProcSym = static_cast<unsigned int> (M2Quads_OperandT (NoOfIds+2));
  M2Debug_Assert (SymbolTable_IsProcedure (ProcSym));
  Var = static_cast<NameKey_Name> (M2Quads_OperandT (NoOfIds+1));
  M2Debug_Assert ((Var == NameKey_NulName) || (Var == M2Reserved_VarTok));
  isVarParam = Var != NameKey_NulName;
  /* Restore popped elements.  */
  M2Quads_PushT (NoOfIds);
  M2Quads_PushTF (Array, ndim);
  M2Quads_PushTtok (TypeSym, TypeTok);
  M2Quads_PushT (ParamTotal);
  M2Debug_Assert ((Var == M2Reserved_VarTok) || (Var == M2Reserved_NulTok));
  Unbounded = Array == M2Reserved_ArrayTok;  /* ARRAY OF Type, parameter.  */
  i = 1;
  /* +4 to skip over the top restored elements.  */
  pi = NoOfIds+4;
  /* If there are an incorrect number of parameters specified then this
      will be detcted by EndBuildFormalParameters.  */
  while (i <= NoOfIds)
    {
      if ((ParamTotal+i) <= (SymbolTable_NoOfParam (ProcSym, prevkind)))
        {
          /* WarnStringAt (InitString ('parampos?'), OperandTok (pi)) ;  */
          if (Unbounded && (! (SymbolTable_IsUnboundedParam (ProcSym, prevkind, ParamTotal+i))))
            {
              ParameterError ((const char *) "declaration of procedure {%%1a} in the %s differs from the %s, {%%2N} parameter is inconsistent, %s", 99, (const char *) "the parameter {%3EHa} was not declared as an ARRAY OF type", 58, (const char *) "the parameter {%3EVa} was declared as an ARRAY OF type", 54, ParamTotal+i, ProcSym, curkind, prevkind);
            }
          else if (! Unbounded && (SymbolTable_IsUnboundedParam (ProcSym, prevkind, ParamTotal+i)))
            {
              /* avoid dangling else.  */
              ParameterError ((const char *) "declaration of procedure {%%1a} in the %s differs from the %s, {%%2N} parameter is inconsistent, %s", 99, (const char *) "the parameter {%3EHa} was declared as an ARRAY OF type", 54, (const char *) "the parameter {%3EVa} was not declared as an ARRAY OF type", 58, ParamTotal+i, ProcSym, curkind, prevkind);
            }
          if (Unbounded)
            {
              if ((SymbolTable_GetDimension (SymbolTable_GetNthParam (ProcSym, prevkind, ParamTotal+1))) != ndim)
                {
                  ParameterError ((const char *) "declaration of procedure {%%1a} in the %s differs from the %s, {%%2N} parameter is inconsistent, %s", 99, (const char *) "the dynamic array parameter {%3EHa} was declared with a different of dimensions", 79, (const char *) "the dynamic array parameter {%3EVa} was declared with a different of dimensions", 79, ParamTotal+i, ProcSym, curkind, prevkind);
                }
            }
          if (isVarParam && (! (SymbolTable_IsVarParam (ProcSym, prevkind, ParamTotal+i))))
            {
              /* Expecting non VAR parameter.  */
              ParameterError ((const char *) "declaration of procedure {%%1a} in the %s differs from the %s, {%%2N} parameter is inconsistent, %s", 99, (const char *) "{%3EHa} was not declared as a {%kVAR} parameter", 47, (const char *) "{%3EVa} was declared as a {%kVAR} parameter", 43, ParamTotal+i, ProcSym, curkind, prevkind);
            }
          else if (! isVarParam && (SymbolTable_IsVarParam (ProcSym, prevkind, ParamTotal+i)))
            {
              /* avoid dangling else.  */
              /* Expecting VAR pamarater.  */
              ParameterError ((const char *) "declaration of procedure {%%1a} in the %s differs from the %s, {%%2N} parameter is inconsistent, %s", 99, (const char *) "{%3EHa} was declared as a {%kVAR} parameter", 43, (const char *) "{%3EVa} was not declared as a {%kVAR} parameter", 47, ParamTotal+i, ProcSym, curkind, prevkind);
            }
          ParamI = SymbolTable_GetNthParam (ProcSym, prevkind, ParamTotal+i);
          if (M2Options_PedanticParamNames)
            {
              if ((SymbolTable_GetSymName (ParamI)) != (M2Quads_OperandT (pi)))
                {
                  /* Different parameter names.  */
                  ParameterError ((const char *) "procedure {%%1a} in the %s differs from the %s, {%%2N} parameter name is inconsistent, %s", 89, (const char *) "named as {%3EVa}", 16, (const char *) "named as {%3EVa}", 16, ParamTotal+i, ProcSym, curkind, prevkind);
                }
            }
          if (Unbounded)
            {
              /* GetType(ParamI) yields an UnboundedSym or a PartialUnboundedSym,
               depending whether it has been resolved..  */
              ParamIType = SymbolTable_GetType (SymbolTable_GetType (ParamI));
            }
          else
            {
              ParamIType = SymbolTable_GetType (ParamI);
            }
          if (((((SymbolTable_SkipType (ParamIType)) != (SymbolTable_SkipType (TypeSym))) || (M2Options_PedanticParamNames && (ParamIType != TypeSym))) && (! (SymbolTable_IsUnknown (SymbolTable_SkipType (TypeSym))))) && (! (SymbolTable_IsUnknown (SymbolTable_SkipType (ParamIType)))))
            {
              /* Different parameter types.  */
              ParameterError ((const char *) "declaration in the %s differs from the %s, {%%2N} parameter is inconsistent, %s", 79, (const char *) "the parameter {%3EHa} was declared with a different type", 56, (const char *) "the parameter {%3EVa} was declared with a different type", 56, ParamTotal+i, ProcSym, curkind, prevkind);
            }
        }
      i += 1;
      pi -= 1;
    }
}


/*
   RemoveFPParameters - remove the FPSection parameters from the stack and
                        increment the param total with the NoOfIds.

                        The Stack:

                               Entry                 Exit

                        Ptr ->
                               +------------+
                               | ParamTotal |
                               |------------|
                               | TypeSym    |
                               |------------|
                               | Array/Nul  |
                               |------------|
                               | NoOfIds    |
                               |------------|
                               | Id 1       |
                               |------------|
                               .            .
                               .            .
                               .            .
                               |------------|
                               | Id n       |                       <- Ptr
                               |------------|        +------------+
                               | Var / Nul  |        | ParamTotal |
                               |------------|        |------------|
                               | ProcSym    |        | ProcSym    |
                               |------------|        |------------|
*/

static void RemoveFPParameters (void)
{
  unsigned int ParamTotal;
  unsigned int Array;
  unsigned int TypeSym;
  unsigned int NoOfIds;
  unsigned int ProcSym;

  M2Quads_PopT (&ParamTotal);
  M2Quads_PopT (&TypeSym);
  M2Quads_PopT (&Array);
  M2Debug_Assert ((Array == M2Reserved_ArrayTok) || (Array == M2Reserved_NulTok));
  M2Quads_PopT (&NoOfIds);
  ProcSym = static_cast<unsigned int> (M2Quads_OperandT (NoOfIds+2));
  M2Debug_Assert (SymbolTable_IsProcedure (ProcSym));
  M2Quads_PopN (NoOfIds+1);  /* +1 for the Var/Nul.  */
  M2Quads_PushT (ParamTotal+NoOfIds);  /* +1 for the Var/Nul.  */
  M2Quads_Annotate ((const char *) "%1d||running total of no. of parameters", 39);
  M2Debug_Assert (SymbolTable_IsProcedure (M2Quads_OperandT (2)));
}


/*
   ParameterError - create two error strings chained together.
*/

static void ParameterError (const char *FmtHeader_, unsigned int _FmtHeader_high, const char *PrevDesc_, unsigned int _PrevDesc_high, const char *CurDesc_, unsigned int _CurDesc_high, unsigned int ParamNo, unsigned int ProcSym, SymbolTable_ProcedureKind curkind, SymbolTable_ProcedureKind prevkind)
{
  unsigned int PrevParam;
  unsigned int CurParam;
  DynamicStrings_String CurStr;
  DynamicStrings_String PrevStr;
  DynamicStrings_String Msg;
  DynamicStrings_String CurKindStr;
  DynamicStrings_String PrevKindStr;
  char FmtHeader[_FmtHeader_high+1];
  char PrevDesc[_PrevDesc_high+1];
  char CurDesc[_CurDesc_high+1];

  /* make a local copy of each unbounded array.  */
  memcpy (FmtHeader, FmtHeader_, _FmtHeader_high+1);
  memcpy (PrevDesc, PrevDesc_, _PrevDesc_high+1);
  memcpy (CurDesc, CurDesc_, _CurDesc_high+1);

  CurParam = SymbolTable_GetNthParam (ProcSym, curkind, ParamNo);
  CurKindStr = SymbolTable_GetProcedureKindDesc (curkind);
  PrevKindStr = SymbolTable_GetProcedureKindDesc (prevkind);
  PrevParam = SymbolTable_GetNthParam (ProcSym, prevkind, ParamNo);
  PrevStr = DynamicStrings_InitString ((const char *) PrevDesc, _PrevDesc_high);
  CurStr = DynamicStrings_InitString ((const char *) CurDesc, _CurDesc_high);
  Msg = FormatStrings_Sprintf3 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) FmtHeader, _FmtHeader_high)), (const unsigned char *) &CurKindStr, (sizeof (CurKindStr)-1), (const unsigned char *) &PrevKindStr, (sizeof (PrevKindStr)-1), (const unsigned char *) &PrevStr, (sizeof (PrevStr)-1));
  M2MetaError_MetaErrorString3 (Msg, ProcSym, ParamNo, PrevParam);
  Msg = FormatStrings_Sprintf3 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) FmtHeader, _FmtHeader_high)), (const unsigned char *) &CurKindStr, (sizeof (CurKindStr)-1), (const unsigned char *) &PrevKindStr, (sizeof (PrevKindStr)-1), (const unsigned char *) &CurStr, (sizeof (CurStr)-1));
  M2MetaError_MetaErrorString3 (Msg, ProcSym, ParamNo, CurParam);
}


/*
   ParameterMismatch - generate a parameter mismatch error between the current
                       declaration at tok and a previous ProcSym declaration.
                       NoOfPar is the current number of parameters.
*/

static void ParameterMismatch (unsigned int tok, unsigned int ProcSym, unsigned int NoOfPar, SymbolTable_ProcedureKind prevkind, SymbolTable_ProcedureKind curkind)
{
  DynamicStrings_String MsgCurrent;
  DynamicStrings_String MsgPrev;
  DynamicStrings_String CompCur;
  DynamicStrings_String CompPrev;
  DynamicStrings_String CurDesc;
  DynamicStrings_String PrevDesc;

  CurDesc = SymbolTable_GetProcedureKindDesc (curkind);
  PrevDesc = SymbolTable_GetProcedureKindDesc (prevkind);
  CompPrev = GetComparison (SymbolTable_NoOfParam (ProcSym, prevkind), NoOfPar);
  CompCur = GetComparison (NoOfPar, SymbolTable_NoOfParam (ProcSym, prevkind));
  MsgCurrent = FormatStrings_Sprintf3 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "the %s for {%%1ad} has %s parameters than the %s", 48)), (const unsigned char *) &CurDesc, (sizeof (CurDesc)-1), (const unsigned char *) &CompCur, (sizeof (CompCur)-1), (const unsigned char *) &PrevDesc, (sizeof (PrevDesc)-1));
  MsgPrev = FormatStrings_Sprintf3 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "the %s for {%%1ad} has %s parameters than the %s", 48)), (const unsigned char *) &PrevDesc, (sizeof (PrevDesc)-1), (const unsigned char *) &CompPrev, (sizeof (CompPrev)-1), (const unsigned char *) &CurDesc, (sizeof (CurDesc)-1));
  M2MetaError_MetaErrorStringT1 (SymbolTable_GetProcedureDeclaredTok (ProcSym, prevkind), MsgPrev, ProcSym);
  M2MetaError_MetaErrorStringT1 (tok, MsgCurrent, ProcSym);
  CurDesc = DynamicStrings_KillString (CurDesc);
  PrevDesc = DynamicStrings_KillString (PrevDesc);
  CompCur = DynamicStrings_KillString (CompCur);
  CompPrev = DynamicStrings_KillString (CompPrev);
}


/*
   GetComparison - return a simple description from the result of
                   a comparison between left and right.
*/

static DynamicStrings_String GetComparison (unsigned int left, unsigned int right)
{
  if (left < right)
    {
      return DynamicStrings_InitString ((const char *) "fewer", 5);
    }
  else if (left > right)
    {
      /* avoid dangling else.  */
      return DynamicStrings_InitString ((const char *) "more", 4);
    }
  else
    {
      /* avoid dangling else.  */
      return DynamicStrings_InitString ((const char *) "same", 4);
    }
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   ReturnTypeMismatch - generate two errors showing the return type mismatches between
                        ProcSym and ReturnType at procedure location tok.
*/

static void ReturnTypeMismatch (unsigned int curtok, unsigned int ProcSym, unsigned int CurRetType, unsigned int curtypetok, SymbolTable_ProcedureKind curkind, SymbolTable_ProcedureKind prevkind, unsigned int PrevRetType)
{
  unsigned int prevtok;
  DynamicStrings_String CurDesc;
  DynamicStrings_String PrevDesc;
  DynamicStrings_String MsgCurrent;
  DynamicStrings_String MsgPrev;

  CurDesc = SymbolTable_GetProcedureKindDesc (curkind);
  PrevDesc = SymbolTable_GetProcedureKindDesc (prevkind);
  prevtok = SymbolTable_GetProcedureDeclaredTok (ProcSym, prevkind);
  if (CurRetType == SymbolTable_NulSym)
    {
      MsgCurrent = FormatStrings_Sprintf2 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "there is no return type for {%%1ad} specified in the %s whereas a return type is specified in the %s", 100)), (const unsigned char *) &CurDesc, (sizeof (CurDesc)-1), (const unsigned char *) &PrevDesc, (sizeof (PrevDesc)-1));
      MsgPrev = FormatStrings_Sprintf2 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "there is no return type for {%%1ad} specified in the %s whereas a return type is specified in the %s", 100)), (const unsigned char *) &CurDesc, (sizeof (CurDesc)-1), (const unsigned char *) &PrevDesc, (sizeof (PrevDesc)-1));
      prevtok = SymbolTable_GetReturnTypeTok (ProcSym, prevkind);
    }
  else if (PrevRetType == SymbolTable_NulSym)
    {
      /* avoid dangling else.  */
      MsgCurrent = FormatStrings_Sprintf2 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "there is no return type for {%%1ad} specified in the %s whereas a return type is specified in the %s", 100)), (const unsigned char *) &PrevDesc, (sizeof (PrevDesc)-1), (const unsigned char *) &CurDesc, (sizeof (CurDesc)-1));
      MsgPrev = FormatStrings_Sprintf2 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "there is no return type for {%%1ad} specified in the %s whereas a return type is specified in the %s", 100)), (const unsigned char *) &PrevDesc, (sizeof (PrevDesc)-1), (const unsigned char *) &CurDesc, (sizeof (CurDesc)-1));
      curtok = curtypetok;
    }
  else
    {
      /* avoid dangling else.  */
      MsgCurrent = FormatStrings_Sprintf2 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "the return type for {%%1ad} specified in the %s differs in the %s", 65)), (const unsigned char *) &CurDesc, (sizeof (CurDesc)-1), (const unsigned char *) &PrevDesc, (sizeof (PrevDesc)-1));
      MsgPrev = FormatStrings_Sprintf2 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "the return type for {%%1ad} specified in the %s differs in the %s", 65)), (const unsigned char *) &CurDesc, (sizeof (CurDesc)-1), (const unsigned char *) &PrevDesc, (sizeof (PrevDesc)-1));
      curtok = curtypetok;
      prevtok = SymbolTable_GetReturnTypeTok (ProcSym, prevkind);
    }
  M2MetaError_MetaErrorStringT1 (curtok, MsgCurrent, ProcSym);
  M2MetaError_MetaErrorStringT1 (prevtok, MsgPrev, ProcSym);
}


/*
   CheckOptFunction - checks to see whether the optional return value
                      has been set before and if it differs it will
                      generate an error message.  It will set the
                      new value to isopt.
*/

static void CheckOptFunction (unsigned int tok, unsigned int sym, SymbolTable_ProcedureKind kind, bool isopt)
{
  SymbolTable_ProcedureKind other;

  if ((SymbolTable_GetType (sym)) != SymbolTable_NulSym)
    {
      for (other=SymbolTable_ProperProcedure; other<=SymbolTable_DefProcedure; other= static_cast<SymbolTable_ProcedureKind>(static_cast<int>(other+1)))
        {
          /* Procedure sym has been declared as a function.  */
          if ((kind != other) && (SymbolTable_GetProcedureParametersDefined (sym, other)))
            {
              /* avoid gcc warning by using compound statement even if not strictly necessary.  */
              if ((SymbolTable_IsReturnOptional (sym, kind)) && ! isopt)
                {
                  M2MetaError_MetaErrorT1 (tok, (const char *) "procedure {%1Ea} is not declared with an optional return type here", 66, sym);
                  M2MetaError_MetaErrorT1 (SymbolTable_GetReturnTypeTok (sym, kind), (const char *) "previously procedure {%1Ea} was declared with an optional return type", 69, sym);
                }
              else if ((! (SymbolTable_IsReturnOptional (sym, kind))) && isopt)
                {
                  /* avoid dangling else.  */
                  M2MetaError_MetaErrorT1 (tok, (const char *) "procedure {%1Ea} is declared with an optional return type here", 62, sym);
                  M2MetaError_MetaErrorT1 (SymbolTable_GetReturnTypeTok (sym, kind), (const char *) "previously procedure {%1Ea} was declared without an optional return type", 72, sym);
                }
            }
        }
    }
  SymbolTable_SetReturnOptional (sym, kind, isopt);
}


/*
   CheckProcedure - checks to see that the top of stack procedure
                    has not been declared as a procedure function.

                    The Stack:

                    Entry                 Exit

             Ptr ->                                      <- Ptr
                    +------------+        +------------+
                    | ProcSym    |        | ProcSym    |
                    |------------|        |------------|
*/

static void CheckProcedureReturn (unsigned int RetType, unsigned int typetok)
{
  SymbolTable_ProcedureKind curkind;
  SymbolTable_ProcedureKind kind;
  unsigned int tok;
  unsigned int PrevRetType;
  unsigned int ProcSym;

  M2Quads_PopTtok (&ProcSym, &tok);
  M2Quads_PushTtok (ProcSym, tok);
  M2Quads_Annotate ((const char *) "%1s(%1d)||procedure start symbol", 32);
  if (SymbolTable_IsProcedure (ProcSym))
    {
      curkind = SymbolTable_GetProcedureKind (ProcSym, tok);
      for (kind=SymbolTable_ProperProcedure; kind<=SymbolTable_DefProcedure; kind= static_cast<SymbolTable_ProcedureKind>(static_cast<int>(kind+1)))
        {
          /* Check against any previously declared kinds.  */
          if ((kind != curkind) && (SymbolTable_GetProcedureParametersDefined (ProcSym, kind)))
            {
              PrevRetType = SymbolTable_GetType (ProcSym);
              if (PrevRetType != RetType)
                {
                  ReturnTypeMismatch (tok, ProcSym, RetType, typetok, curkind, kind, PrevRetType);
                }
            }
        }
      SymbolTable_PutFunction (tok, ProcSym, curkind, RetType);
    }
}


/*
   HandleRecordFieldPragmas -

                      Entry                     Exit
                      =====                     ====

               Ptr ->                                     <- Ptr

                      |-------------|           |-------------|
                      | Const1      |           | Const1      |
                      |-------------|           |-------------|
                      | PragmaName1 |           | PragmaName1 |
                      |-------------|           |-------------|
*/

static void HandleRecordFieldPragmas (unsigned int record, unsigned int field, unsigned int n)
{
  bool seenAlignment;
  unsigned int defaultAlignment;
  unsigned int sym;
  unsigned int i;
  NameKey_Name name;
  DynamicStrings_String s;

  seenAlignment = false;
  defaultAlignment = SymbolTable_GetDefaultRecordFieldAlignment (record);
  i = 1;
  while (i <= n)
    {
      name = static_cast<NameKey_Name> (M2Quads_OperandT (i*2));
      sym = static_cast<unsigned int> (M2Quads_OperandT ((i*2)-1));
      if (name == (NameKey_MakeKey ((const char *) "unused", 6)))
        {
          if (sym == SymbolTable_NulSym)
            {
              SymbolTable_PutUnused (field);
            }
          else
            {
              M2Error_WriteFormat0 ((const char *) "not expecting pragma 'unused' to contain an expression", 54);
            }
        }
      else if (name == (NameKey_MakeKey ((const char *) "bytealignment", 13)))
        {
          /* avoid dangling else.  */
          if (sym == SymbolTable_NulSym)
            {
              M2Error_WriteFormat0 ((const char *) "expecting an expression with the pragma 'bytealignment'", 55);
            }
          else
            {
              SymbolTable_PutAlignment (field, sym);
              seenAlignment = true;
            }
        }
      else
        {
          /* avoid dangling else.  */
          s = DynamicStrings_InitString ((const char *) "cannot use pragma '", 19);
          s = DynamicStrings_ConCat (s, DynamicStrings_Mark (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (name))));
          s = DynamicStrings_ConCat (s, DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "' on record field {%1ad}", 24)));
          M2MetaError_MetaErrorString1 (s, field);
        }
      i += 1;
    }
  if (! seenAlignment && (defaultAlignment != SymbolTable_NulSym))
    {
      SymbolTable_PutAlignment (field, defaultAlignment);
    }
}


/*
   SaveRememberedConstructor -
*/

static void SaveRememberedConstructor (void)
{
}


/*
   GetSeenString - returns a string corresponding to, s.
*/

static DynamicStrings_String GetSeenString (M2Const_constType s)
{
  switch (s)
    {
      case M2Const_unknown:
        return DynamicStrings_InitString ((const char *) "unknown", 7);
        break;

      case M2Const_set:
        return DynamicStrings_InitString ((const char *) "SET", 3);
        break;

      case M2Const_str:
        return DynamicStrings_InitString ((const char *) "string", 6);
        break;

      case M2Const_constructor:
        return DynamicStrings_InitString ((const char *) "constructor", 11);
        break;

      case M2Const_array:
        return DynamicStrings_InitString ((const char *) "ARRAY", 5);
        break;

      case M2Const_cast:
        return DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (SymbolTable_GetSymName (castType)));
        break;

      case M2Const_boolean:
        return DynamicStrings_InitString ((const char *) "BOOLEAN", 7);
        break;

      case M2Const_ztype:
        return DynamicStrings_InitString ((const char *) "Z type", 6);
        break;

      case M2Const_rtype:
        return DynamicStrings_InitString ((const char *) "R type", 6);
        break;

      case M2Const_ctype:
        return DynamicStrings_InitString ((const char *) "C type", 6);
        break;

      case M2Const_procedure:
        return DynamicStrings_InitString ((const char *) "PROCEDURE", 9);
        break;


      default:
        M2Error_InternalError ((const char *) "unexpected value of type", 24);
        break;
    }
  return static_cast<DynamicStrings_String> (NULL);
  /* static analysis guarentees a RETURN statement will be used before here.  */
  __builtin_unreachable ();
}


/*
   SetTypeTo - attempts to set, type, to, s.
*/

static void SetTypeTo (M2Const_constType s)
{
  DynamicStrings_String s1;
  DynamicStrings_String s2;
  DynamicStrings_String s3;

  if (type == M2Const_unknown)
    {
      type = s;
    }
  /* leave it alone  */
  else if ((type == M2Const_constructor) && (s != M2Const_str))
    {
      /* avoid dangling else.  */
      type = s;
    }
  else if ((s == M2Const_constructor) && ((type == M2Const_array) || (type == M2Const_set)))
    {
      /* avoid dangling else.  */
    }
  else if (type != s)
    {
      /* avoid dangling else.  */
      s1 = GetSeenString (type);
      s2 = GetSeenString (s);
      s3 = FormatStrings_Sprintf2 (DynamicStrings_InitString ((const char *) "cannot create a %s constant together with a %s constant", 55), (const unsigned char *) &s1, (sizeof (s1)-1), (const unsigned char *) &s2, (sizeof (s2)-1));
      M2Error_ErrorStringAt (s3, M2LexBuf_GetTokenNo ());
      s1 = DynamicStrings_KillString (s1);
      s2 = DynamicStrings_KillString (s2);
    }
}


/*
   BlockStart - tokno is the module/procedure/implementation/definition token
*/

extern "C" void P2SymBuild_BlockStart (unsigned int tokno)
{
  PushBlock (tokno);
}


/*
   BlockEnd - declare module ctor/init/fini/dep procedures.
*/

extern "C" void P2SymBuild_BlockEnd (unsigned int tokno)
{
  curBeginTok = propageteTokenPosition (curStartTok, curBeginTok);
  curFinallyTok = propageteTokenPosition (tokno, curFinallyTok);
  M2Debug_Assert (curModuleSym != SymbolTable_NulSym);
  SymbolTable_MakeModuleCtor (curStartTok, curBeginTok, curFinallyTok, curModuleSym);
  PopBlock ();
}


/*
   BlockBegin - assign curBeginTok to tokno.
*/

extern "C" void P2SymBuild_BlockBegin (unsigned int tokno)
{
  curBeginTok = tokno;
}


/*
   BlockFinally - assign curFinallyTok to tokno.
*/

extern "C" void P2SymBuild_BlockFinally (unsigned int tokno)
{
  curFinallyTok = tokno;
}

extern "C" void P2SymBuild_P2StartBuildDefModule (void)
{
  NameKey_Name name;
  unsigned int ModuleSym;
  unsigned int tokno;

  /* 
   StartBuildDefinitionModule - Creates a definition module and starts
                                a new scope.

                                he Stack is expected:

                                Entry                 Exit

                         Ptr ->                                     <- Ptr
                                +------------+        +-----------+
                                | NameStart  |        | NameStart |
                                |------------|        |-----------|

  */
  M2Quads_PopTtok (&name, &tokno);
  ModuleSym = M2Batch_MakeDefinitionSource (tokno, name);
  curModuleSym = ModuleSym;
  SymbolTable_SetCurrentModule (ModuleSym);
  SymbolTable_SetFileModule (ModuleSym);
  SymbolTable_StartScope (ModuleSym);
  M2Debug_Assert (SymbolTable_IsDefImp (ModuleSym));
  M2Debug_Assert (M2Comp_CompilingDefinitionModule ());
  M2Quads_PushT (name);
  M2Quads_Annotate ((const char *) "%1n||definition module name", 27);
  M2Error_EnterDefinitionScope (name);
}

extern "C" void P2SymBuild_P2EndBuildDefModule (void)
{
  NameKey_Name NameStart;
  NameKey_Name NameEnd;

  /* 
   EndBuildDefinitionModule - Destroys the definition module scope and
                              checks for correct name.

                              The Stack is expected:

                              Entry                 Exit

                       Ptr ->
                              +------------+        +-----------+
                              | NameEnd    |        |           |
                              |------------|        |-----------|
                              | NameStart  |        |           | <- Ptr
                              |------------|        |-----------|
  */
  M2Debug_Assert (M2Comp_CompilingDefinitionModule ());
  SymbolTable_CheckForUndeclaredExports (SymbolTable_GetCurrentModule ());
  SymbolTable_EndScope ();
  M2Quads_PopT (&NameStart);
  M2Quads_PopT (&NameEnd);
  if (Debugging)
    {
      M2Printf_printf0 ((const char *) "pass 2: ", 8);
      SymbolTable_DisplayTrees (SymbolTable_GetCurrentModule ());
    }
  if (NameStart != NameEnd)
    {
      M2Error_WriteFormat2 ((const char *) "inconsistent definition module name, module began as (%a) and ended with (%a)", 77, (const unsigned char *) &NameStart, (sizeof (NameStart)-1), (const unsigned char *) &NameEnd, (sizeof (NameEnd)-1));
    }
  M2Error_LeaveErrorScope ();
}

extern "C" void P2SymBuild_P2StartBuildImplementationModule (void)
{
  NameKey_Name name;
  unsigned int ModuleSym;
  unsigned int tokno;

  /* 
   StartBuildImplementationModule - Creates an implementation module and starts
                                    a new scope.

                                    The Stack is expected:

                                    Entry                 Exit

                             Ptr ->                                     <- Ptr
                                    +------------+        +-----------+
                                    | NameStart  |        | NameStart |
                                    |------------|        |-----------|

  */
  M2Quads_PopTtok (&name, &tokno);
  ModuleSym = M2Batch_MakeImplementationSource (tokno, name);
  curModuleSym = ModuleSym;
  SymbolTable_SetCurrentModule (ModuleSym);
  SymbolTable_SetFileModule (ModuleSym);
  SymbolTable_StartScope (ModuleSym);
  M2Debug_Assert (SymbolTable_IsDefImp (ModuleSym));
  M2Debug_Assert (M2Comp_CompilingImplementationModule ());
  M2Quads_PushT (name);
  M2Quads_Annotate ((const char *) "%1n||implementation module name", 31);
  M2Error_EnterImplementationScope (name);
}

extern "C" void P2SymBuild_P2EndBuildImplementationModule (void)
{
  NameKey_Name NameStart;
  NameKey_Name NameEnd;

  /* 
   EndBuildImplementationModule - Destroys the implementation module scope and
                                  checks for correct name.

                                  The Stack is expected:

                                  Entry                 Exit

                           Ptr ->
                                  +------------+        +-----------+
                                  | NameEnd    |        |           |
                                  |------------|        |-----------|
                                  | NameStart  |        |           | <- Ptr
                                  |------------|        |-----------|
  */
  M2Debug_Assert (M2Comp_CompilingImplementationModule ());
  SymbolTable_CheckForUnImplementedExports ();
  SymbolTable_EndScope ();
  M2Quads_PopT (&NameStart);
  M2Quads_PopT (&NameEnd);
  if (NameStart != NameEnd)
    {
      M2Error_WriteFormat1 ((const char *) "inconsistent implementation module name %a", 42, (const unsigned char *) &NameStart, (sizeof (NameStart)-1));
    }
  M2Error_LeaveErrorScope ();
}

extern "C" void P2SymBuild_P2StartBuildProgramModule (void)
{
  NameKey_Name name;
  unsigned int ModuleSym;
  unsigned int tokno;

  /* 
   StartBuildProgramModule - Creates a program module and starts
                             a new scope.

                             The Stack is expected:

                             Entry                 Exit

                      Ptr ->                                     <- Ptr
                             +------------+        +-----------+
                             | NameStart  |        | NameStart |
                             |------------|        |-----------|

  */
  M2Quads_PopTtok (&name, &tokno);
  ModuleSym = M2Batch_MakeProgramSource (tokno, name);
  curModuleSym = ModuleSym;
  SymbolTable_SetCurrentModule (ModuleSym);
  SymbolTable_SetFileModule (ModuleSym);
  SymbolTable_StartScope (ModuleSym);
  M2Debug_Assert (M2Comp_CompilingProgramModule ());
  M2Debug_Assert (! (SymbolTable_IsDefImp (ModuleSym)));
  M2Quads_PushT (name);
  M2Quads_Annotate ((const char *) "%1n||program module name", 24);
  M2Error_EnterProgramScope (name);
}

extern "C" void P2SymBuild_P2EndBuildProgramModule (void)
{
  NameKey_Name NameStart;
  NameKey_Name NameEnd;

  /* 
   EndBuildProgramModule - Destroys the program module scope and
                           checks for correct name.

                           The Stack is expected:

                           Entry                 Exit

                    Ptr ->
                           +------------+        +-----------+
                           | NameEnd    |        |           |
                           |------------|        |-----------|
                           | NameStart  |        |           | <- Ptr
                           |------------|        |-----------|
  */
  M2Debug_Assert (M2Comp_CompilingProgramModule ());
  SymbolTable_CheckForUndeclaredExports (SymbolTable_GetCurrentModule ());  /* Not really allowed exports here though!  */
  SymbolTable_EndScope ();  /* Not really allowed exports here though!  */
  M2Quads_PopT (&NameStart);
  M2Quads_PopT (&NameEnd);
  if (Debugging)
    {
      M2Printf_printf0 ((const char *) "pass 2: ", 8);
      SymbolTable_DisplayTrees (SymbolTable_GetCurrentModule ());
    }
  if (NameStart != NameEnd)
    {
      M2Error_WriteFormat2 ((const char *) "inconsistent program module name %a does not match %a", 53, (const unsigned char *) &NameStart, (sizeof (NameStart)-1), (const unsigned char *) &NameEnd, (sizeof (NameEnd)-1));
    }
  M2Error_LeaveErrorScope ();
}


/*
   StartBuildInnerModule - Creates an Inner module and starts
                           a new scope.

                           The Stack is expected:

                           Entry                 Exit

                    Ptr ->                                     <- Ptr
                           +------------+        +-----------+
                           | NameStart  |        | NameStart |
                           |------------|        |-----------|

*/

extern "C" void P2SymBuild_StartBuildInnerModule (void)
{
  NameKey_Name name;
  unsigned int tok;
  unsigned int ModuleSym;

  M2Quads_PopTtok (&name, &tok);
  ModuleSym = SymbolTable_GetDeclareSym (tok, name);
  curModuleSym = ModuleSym;
  SymbolTable_StartScope (ModuleSym);
  M2Debug_Assert (! (SymbolTable_IsDefImp (ModuleSym)));
  M2Quads_PushTtok (name, tok);
  M2Quads_Annotate ((const char *) "%1n||inner module name", 22);
  M2Error_EnterModuleScope (name);
}


/*
   EndBuildInnerModule - Destroys the Inner module scope and
                         checks for correct name.

                         The Stack is expected:

                         Entry                 Exit

                  Ptr ->
                         +------------+        +-----------+
                         | NameEnd    |        |           |
                         |------------|        |-----------|
                         | NameStart  |        |           | <- Ptr
                         |------------|        |-----------|
*/

extern "C" void P2SymBuild_EndBuildInnerModule (void)
{
  NameKey_Name NameStart;
  NameKey_Name NameEnd;

  SymbolTable_CheckForUndeclaredExports (SymbolTable_GetCurrentModule ());
  SymbolTable_EndScope ();
  M2Quads_PopT (&NameStart);
  M2Quads_PopT (&NameEnd);
  if (NameStart != NameEnd)
    {
      M2Error_WriteFormat2 ((const char *) "inconsistent inner module name %a does not match %a", 51, (const unsigned char *) &NameStart, (sizeof (NameStart)-1), (const unsigned char *) &NameEnd, (sizeof (NameEnd)-1));
    }
  M2Error_LeaveErrorScope ();
}


/*
   BuildImportOuterModule - Builds imported identifiers into an outer module
                            from a definition module.

                            The Stack is expected:

                            Entry           OR    Entry

                     Ptr ->                Ptr ->
                            +------------+        +-----------+
                            | #          |        | #         |
                            |------------|        |-----------|
                            | Id1        |        | Id1       |
                            |------------|        |-----------|
                            .            .        .           .
                            .            .        .           .
                            .            .        .           .
                            |------------|        |-----------|
                            | Id#        |        | Id#       |
                            |------------|        |-----------|
                            | ImportTok  |        | Ident     |
                            |------------|        |-----------|

                            IMPORT Id1, .. Id# ;  FROM Ident IMPORT Id1 .. Id# ;


                            Exit

                            All above stack discarded
*/

extern "C" void P2SymBuild_BuildImportOuterModule (void)
{
  unsigned int Sym;
  unsigned int ModSym;
  unsigned int i;
  unsigned int n;

  M2Quads_PopT (&n);  /* n   = # of the Ident List  */
  if ((M2Quads_OperandT (n+1)) != M2Reserved_ImportTok)
    {
      /* Ident List contains list of objects imported from ModSym  */
      ModSym = M2Batch_LookupModule (M2Quads_OperandTok (n+1), M2Quads_OperandT (n+1));
      i = 1;
      while (i <= n)
        {
          Sym = SymbolTable_GetExported (M2Quads_OperandTok (i), ModSym, M2Quads_OperandT (i));
          SymbolTable_CheckForEnumerationInCurrentModule (Sym);
          i += 1;
        }
    }
  M2Quads_PopN (n+1);  /* clear stack  */
}


/*
   BuildExportOuterModule - Builds exported identifiers from an outer module
                            to the outside world of library modules.

                            The Stack is expected:

                            Entry           OR    Entry

                     Ptr ->                Ptr ->
                            +------------+        +--------------+
                            | #          |        | #            |
                            |------------|        |--------------|
                            | Id1        |        | Id1          |
                            |------------|        |--------------|
                            .            .        .              .
                            .            .        .              .
                            .            .        .              .
                            |------------|        |--------------|
                            | Id#        |        | Id#          |
                            |------------|        |--------------|
                            | ExportTok  |        | QualifiedTok |
                            |------------|        |--------------|

                            EXPORT Id1, .. Id# ;  EXPORT QUALIFIED Id1 .. Id# ;

                            Error Condition


                            Exit

                            All above stack discarded
*/

extern "C" void P2SymBuild_BuildExportOuterModule (void)
{
  unsigned int n;

  M2Quads_PopT (&n);  /* n   = # of the Ident List  */
  M2Quads_PopN (n+1);  /* n   = # of the Ident List  */
}


/*
   BuildImportInnerModule - Builds imported identifiers into an inner module
                            from the last level of module.

                            The Stack is expected:

                            Entry           OR    Entry

                     Ptr ->                Ptr ->
                            +------------+        +-----------+
                            | #          |        | #         |
                            |------------|        |-----------|
                            | Id1        |        | Id1       |
                            |------------|        |-----------|
                            .            .        .           .
                            .            .        .           .
                            .            .        .           .
                            |------------|        |-----------|
                            | Id#        |        | Id#       |
                            |------------|        |-----------|
                            | ImportTok  |        | Ident     |
                            |------------|        |-----------|

                            IMPORT Id1, .. Id# ;  FROM Ident IMPORT Id1 .. Id# ;

                            Exit

                            All above stack discarded
*/

extern "C" void P2SymBuild_BuildImportInnerModule (void)
{
  unsigned int Sym;
  unsigned int ModSym;
  unsigned int n;
  unsigned int i;

  M2Quads_PopT (&n);  /* i   = # of the Ident List  */
  if ((M2Quads_OperandT (n+1)) == M2Reserved_ImportTok)
    {
      /* Ident List contains list of objects  */
      i = 1;
      while (i <= n)
        {
          Sym = SymbolTable_GetFromOuterModule (M2Quads_OperandTok (i), M2Quads_OperandT (i));
          SymbolTable_CheckForEnumerationInCurrentModule (Sym);
          i += 1;
        }
    }
  else
    {
      /* Ident List contains list of objects from ModSym  */
      ModSym = M2Batch_LookupOuterModule (M2Quads_OperandTok (n+1), M2Quads_OperandT (n+1));
      i = 1;
      while (i <= n)
        {
          Sym = SymbolTable_GetExported (M2Quads_OperandTok (i), ModSym, M2Quads_OperandT (i));
          SymbolTable_CheckForEnumerationInCurrentModule (Sym);
          i += 1;
        }
    }
  M2Quads_PopN (n+1);  /* Clear Stack  */
}


/*
   BuildExportInnerModule - Builds exported identifiers from an inner module
                            to the next layer module.

                            The Stack is expected:

                            Entry           OR    Entry

                     Ptr ->                Ptr ->
                            +------------+        +--------------+
                            | #          |        | #            |
                            |------------|        |--------------|
                            | Id1        |        | Id1          |
                            |------------|        |--------------|
                            .            .        .              .
                            .            .        .              .
                            .            .        .              .
                            |------------|        |--------------|
                            | Id#        |        | Id#          |
                            |------------|        |--------------|
                            | ExportTok  |        | QualifiedTok |
                            |------------|        |--------------|

                            EXPORT Id1, .. Id# ;  EXPORT QUALIFIED Id1 .. Id# ;


                            Exit

                            All above stack discarded
*/

extern "C" void P2SymBuild_BuildExportInnerModule (void)
{
  unsigned int n;

  M2Quads_PopT (&n);
  M2Quads_PopN (n+1);  /* clear stack  */
}


/*
   BuildNumber - Converts a number into a symbol.


                 Stack

                 Entry                 Exit

          Ptr ->                                             <- Ptr
                 +------------+        +-------------------+
                 | Name | tok |        | Sym | Type | tok  |
                 |------------+        |-------------------|
*/

extern "C" void P2SymBuild_BuildNumber (void)
{
  NameKey_Name name;
  unsigned int Sym;
  unsigned int tok;

  M2Quads_PopTtok (&name, &tok);
  Sym = SymbolTable_MakeConstLit (tok, name, SymbolTable_NulSym);
  M2Quads_PushTFtok (Sym, SymbolTable_GetType (Sym), tok);
  M2Quads_Annotate ((const char *) "%1s(%1d)||constant number", 25);
}


/*
   BuildString - Converts a string into a symbol.


                 Stack

                 Entry                 Exit

          Ptr ->                                               <- Ptr
                 +-------------+        +--------------------+
                 | Name | | tok|        | Sym | NulSym | tok |
                 |-------------+        |--------------------|
*/

extern "C" void P2SymBuild_BuildString (void)
{
  NameKey_Name name;
  unsigned int Sym;
  unsigned int tok;

  M2Quads_PopTtok (&name, &tok);
  /* slice off the leading and trailing quotes  */
  if (name == 1140)
    {
      stop ();
    }
  Sym = SymbolTable_MakeConstString (tok, NameKey_makekey (DynamicStrings_string (DynamicStrings_Mark (DynamicStrings_Slice (DynamicStrings_Mark (DynamicStrings_InitStringCharStar (NameKey_KeyToCharStar (name))), 1, -1)))));
  M2Quads_PushTFtok (Sym, static_cast<unsigned int> (SymbolTable_NulSym), tok);
  M2Quads_Annotate ((const char *) "%1s(%1d)|%3d||constant string", 29);
}


/*
   BuildConst - builds a constant.
                Stack

                Entry                 Exit

         Ptr ->
                +------------+
                | Name       |
                |------------+                       <- Ptr
*/

extern "C" void P2SymBuild_BuildConst (void)
{
  NameKey_Name name;
  unsigned int sym;
  unsigned int tok;

  M2Quads_PopTtok (&name, &tok);
  sym = SymbolTable_MakeConstVar (tok, name);
  M2Quads_PushTtok (sym, tok);
  P2SymBuild_RememberConstant (sym);
  M2Quads_Annotate ((const char *) "%1s(%1d)|%3d||remembered constant", 33);
}


/*
   StartBuildEnumeration - Builds an Enumeration type Type.


                           Stack

                           Entry                 Exit

                    Ptr ->
                           +------------+
                           | #          |
                           |------------|
                           | en 1       |
                           |------------|
                           | en 2       |
                           |------------|
                           .            .
                           .            .
                           .            .                       <- Ptr
                           |------------|        +------------+
                           | en #       |        | Type       |
                           |------------|        |------------|
                           | Name       |        | Name       |
                           |------------|        |------------|
*/

extern "C" void P2SymBuild_StartBuildEnumeration (void)
{
  unsigned int n;
  unsigned int Type;
  unsigned int tok;

  M2Quads_PopT (&n);  /* n := #  */
  /* name is in OperandT(n+1) but we dont need it here.  */
  tok = static_cast<unsigned int> (M2Quads_OperandTok (n+1));
  FifoQueue_GetEnumerationFromFifoQueue (&Type);
  SymbolTable_CheckForExportedImplementation (Type);  /* May be an exported hidden type  */
  M2Quads_PopN (n);  /* May be an exported hidden type  */
  M2Quads_PushTtok (Type, tok);
  M2Quads_Annotate ((const char *) "%1s(%1d)|%3d||enumerated type", 29);
}


/*
   BuildSubrange - Builds a Subrange type Symbol, the base type can also be
                   supplied if known.

                      Stack

                      Entry                 Exit


                                                           <- Ptr
                                            +------------+
               Ptr ->                       | Type       |
                      +------------+        |------------|
                      | Name       |        | Name       |
                      |------------|        |------------|
*/

extern "C" void P2SymBuild_BuildSubrange (unsigned int tok, unsigned int Base)
{
  NameKey_Name name;
  unsigned int Type;

  M2Quads_PopT (&name);
  Type = SymbolTable_MakeSubrange (tok, name);
  FifoQueue_PutSubrangeIntoFifoQueue (Type);  /* Store Subrange away so that we can fill in  */
  /* its bounds during pass 3.  */
  FifoQueue_PutSubrangeIntoFifoQueue (Base);  /* store Base type of subrange away as well.  */
  SymbolTable_CheckForExportedImplementation (Type);  /* May be an exported hidden type  */
  M2Quads_PushTtok (name, tok);  /* May be an exported hidden type  */
  M2Quads_Annotate ((const char *) "%1n|%3d||subrange name|token no", 31);
  M2Quads_PushTtok (Type, tok);
  M2Quads_Annotate ((const char *) "%1s(%1d)|%3d||subrange type|token no", 36);
}


/*
   BuildAligned - builds an alignment constant symbol which is placed onto
                  the stack.  It expects the ident ALIGNED to be on the
                  stack.

                         Stack

                           Entry                 Exit


                  Ptr ->                                            <- Ptr
                         +---------------+      +-----------------+
                         | bytealignment |      | AlignmentConst  |
                         +---------------+      |-----------------|
*/

extern "C" void P2SymBuild_BuildAligned (void)
{
  unsigned int tok;
  NameKey_Name name;
  unsigned int align;

  M2Quads_PopTtok (&name, &tok);
  if (name == (NameKey_MakeKey ((const char *) "bytealignment", 13)))
    {
      align = SymbolTable_MakeTemporary (tok, SymbolTable_ImmediateValue);
      SymbolTable_PutConst (align, M2Base_ZType);
      FifoQueue_PutConstIntoFifoQueue (align);  /* Store align away so that we can fill in its  */
      M2Quads_PushT (align);  /* value during pass 3.  */
      M2Quads_Annotate ((const char *) "%1s(%1d)|%3d||bytealignment constant generated from <* *>|token no", 66);  /* value during pass 3.  */
      M2Quads_PushTtok (name, tok);
    }
  else
    {
      M2Error_WriteFormat1 ((const char *) "expecting bytealignment identifier, rather than %a", 50, (const unsigned char *) &name, (sizeof (name)-1));
      M2Quads_PushT (static_cast<unsigned int> (SymbolTable_NulSym));
    }
  M2Quads_Annotate ((const char *) "%1n(%1d)||bytealignment constant generated from <* *>", 53);
}


/*
   BuildVarAlignment - the AlignmentConst is either a temporary or NulSym.
                       A type may only have one alignment value and
                       error checking is performed.

                       Stack

                           Entry                 Exit


                   Ptr ->
                          +-----------------+
                          | AlignmentConst  |                             <- Ptr
                          |-----------------|        +------------------+
                          | Type            |        | Type  | TypeName |
                          |-----------------|        |------------------|
*/

extern "C" void P2SymBuild_BuildVarAlignment (void)
{
  unsigned int tokno;
  NameKey_Name alignment;
  NameKey_Name newname;
  unsigned int new_;
  unsigned int type;
  unsigned int align;
  DynamicStrings_String s;

  M2Quads_PopT (&alignment);
  if (alignment == (NameKey_MakeKey ((const char *) "bytealignment", 13)))
    {
      M2Quads_PopT (&align);
      M2Quads_PopTtok (&type, &tokno);
      if (((((SymbolTable_IsRecord (type)) || (SymbolTable_IsRecordField (type))) || (SymbolTable_IsType (type))) || (SymbolTable_IsArray (type))) || (SymbolTable_IsPointer (type)))
        {
          stop ();
          if (SymbolTable_IsNameAnonymous (type))
            {
              SymbolTable_PutAlignment (type, align);
              M2Quads_PushTFtok (type, SymbolTable_GetSymName (type), tokno);
              M2Quads_Annotate ((const char *) "%1s(%1d)|%2n|%3d||aligned type|aligned type name|token no", 57);
            }
          else
            {
              /* create a pseudonym  */
              s = FormatStrings_Sprintf1 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "_$A%d", 5)), (const unsigned char *) &alignTypeNo, (sizeof (alignTypeNo)-1));
              alignTypeNo += 1;
              newname = NameKey_makekey (DynamicStrings_string (s));
              if (SymbolTable_IsPointer (type))
                {
                  new_ = SymbolTable_MakePointer (tokno, newname);
                }
              else
                {
                  new_ = SymbolTable_MakeType (tokno, newname);
                }
              s = DynamicStrings_KillString (s);
              SymbolTable_PutType (new_, type);
              SymbolTable_PutAlignment (new_, align);
              M2Quads_PushTFtok (new_, SymbolTable_GetSymName (new_), tokno);
              M2Quads_Annotate ((const char *) "%1s(%1d)|%2n|%3d||aligned type|aligned type name", 48);
            }
        }
      else
        {
          M2MetaError_MetaError1 ((const char *) "not allowed to add an alignment attribute to type {%1ad}", 56, type);
          M2Quads_PushTFtok (type, SymbolTable_GetSymName (type), tokno);
          M2Quads_Annotate ((const char *) "%1s(%1d)|%2n|%3d||error aligned type|error aligned type name", 60);
        }
    }
  else if (alignment != NameKey_NulName)
    {
      /* avoid dangling else.  */
      M2Error_WriteFormat1 ((const char *) "unknown variable alignment attribute, %a", 40, (const unsigned char *) &alignment, (sizeof (alignment)-1));
    }
}


/*
   BuildTypeAlignment - the AlignmentConst is either a temporary or NulSym.
                        In the case of NulSym it is popped from the stack
                        and the procedure returns.  Otherwise the temporary
                        is popped and recorded as the alignment value for this
                        type.  A type may only have one alignment value and
                        error checking is performed.

                        Stack

                            Entry                 Exit


                    Ptr ->
                           +-----------------+
                           | AlignmentConst  |
                           |-----------------|
                           | Type            |    Empty
                           |-----------------|
*/

extern "C" void P2SymBuild_BuildTypeAlignment (void)
{
  NameKey_Name alignment;
  unsigned int type;
  unsigned int align;

  M2Quads_PopT (&alignment);
  if (alignment == (NameKey_MakeKey ((const char *) "bytealignment", 13)))
    {
      /* avoid dangling else.  */
      M2Quads_PopT (&align);
      M2Quads_PopT (&type);
      if (align != SymbolTable_NulSym)
        {
          /* avoid gcc warning by using compound statement even if not strictly necessary.  */
          if ((((((SymbolTable_IsRecord (type)) || (SymbolTable_IsRecordField (type))) || (SymbolTable_IsType (type))) || (SymbolTable_IsArray (type))) || (SymbolTable_IsPointer (type))) || (SymbolTable_IsSubrange (type)))
            {
              SymbolTable_PutAlignment (type, align);
            }
          else
            {
              M2MetaError_MetaError1 ((const char *) "not allowed to add an alignment attribute to type {%1ad}", 56, type);
            }
        }
    }
  else if (alignment != NameKey_NulName)
    {
      /* avoid dangling else.  */
      M2Error_WriteFormat1 ((const char *) "unknown type alignment attribute, %a", 36, (const unsigned char *) &alignment, (sizeof (alignment)-1));
    }
  else
    {
      /* avoid dangling else.  */
      M2Quads_PopT (&type);
    }
}

extern "C" void P2SymBuild_P2BuildDefaultFieldAlignment (void)
{
  unsigned int tok;
  NameKey_Name alignment;
  unsigned int align;

  /* 
   BuildDefaultFieldAlignment -

                 The Stack:

                 Entry                         Exit
                 =====                         ====


          Ptr ->
                 +-----------+
                 | Alignment |
                 |-----------|                 +-----------+
                 | RecordSym |                 | RecordSym |
                 |-----------|                 |-----------|
                 | Name      |                 | Name      |
                 |-----------|                 |-----------|

  */
  M2Quads_PopTtok (&alignment, &tok);
  align = SymbolTable_MakeTemporary (tok, SymbolTable_ImmediateValue);
  SymbolTable_PutConst (align, M2Base_ZType);
  FifoQueue_PutConstIntoFifoQueue (align);  /* store align away ready for pass 3  */
  SymbolTable_PutDefaultRecordFieldAlignment (M2Quads_OperandT (1), align);  /* store align away ready for pass 3  */
}


/*
   BuildPragmaConst - pushes a constant to the stack and stores it away into the
                      const fifo queue ready for pass 3.
*/

extern "C" void P2SymBuild_BuildPragmaConst (void)
{
  unsigned int value;

  value = SymbolTable_MakeTemporary (M2LexBuf_GetTokenNo (), SymbolTable_ImmediateValue);
  SymbolTable_PutConst (value, M2Base_ZType);
  FifoQueue_PutConstIntoFifoQueue (value);  /* Store value away so that we can fill it in  */
  M2Quads_PushT (value);  /* during pass 3.  */
  M2Quads_Annotate ((const char *) "%1s(%1d)||pragma constant", 25);  /* during pass 3.  */
}


/*
   BuildVariable - Builds variables listed in an IdentList with a Type.

                   Stack

                   Entry                 Exit

            Ptr ->
                   +------------+        +------------+
                   | Type | Name|        |            |
                   |------------|        |------------|
                   | #          |        |            |
                   |------------|        |------------|
                   | Ident 1    |        |            |
                   |------------|        |------------|
                   | Ident 2    |        |            |
                   |------------|        |------------|
                   .            .        .            .
                   .            .        .            .
                   .            .        .            .
                   |------------|        |------------|
                   | Ident #    |        |            | <- Ptr
                   |------------|        |------------|

                                           Empty
*/

extern "C" void P2SymBuild_BuildVariable (void)
{
  NameKey_Name name;
  unsigned int tok;
  unsigned int typetok;
  unsigned int AtAddress;
  unsigned int Type;
  unsigned int Var;
  unsigned int i;
  unsigned int n;

  M2Quads_PopTFtok (&Type, &name, &typetok);
  M2Quads_PopT (&n);
  i = 1;
  while (i <= n)
    {
      M2Students_CheckVariableAgainstKeyword (M2Quads_OperandT ((n+1)-i));
      tok = static_cast<unsigned int> (M2Quads_OperandTok ((n+1)-i));
      Var = SymbolTable_MakeVar (tok, M2Quads_OperandT ((n+1)-i));
      AtAddress = static_cast<unsigned int> (M2Quads_OperandA ((n+1)-i));
      if (AtAddress != SymbolTable_NulSym)
        {
          SymbolTable_PutVariableAtAddress (Var, SymbolTable_NulSym);
          SymbolTable_PutMode (Var, SymbolTable_LeftValue);
        }
      SymbolTable_PutVarTok (Var, Type, typetok);
      if (tok != M2LexBuf_UnknownTokenNo)
        {
          SymbolTable_PutDeclared (tok, Var);
          SymbolTable_PutVarDeclTok (Var, tok);
        }
      i += 1;
    }
  M2Quads_PopN (n);
}


/*
   BuildType - Builds a Type.


               Stack

               Entry                 Exit

        Ptr ->
               +------------+
               | Type       |                          <- Ptr
               |------------|        +---------------+
               | Name       |        | Type  | Name  |
               |------------|        |---------------|

                                     Empty
*/

extern "C" void P2SymBuild_BuildType (void)
{
  bool isunknown;
  NameKey_Name n1;
  NameKey_Name n2;
  unsigned int Sym;
  unsigned int Type;
  NameKey_Name name;
  unsigned int nametokno;
  unsigned int typetokno;

  /* 
      Two cases

      - the type name the same as Name, or the name is nul. - do nothing.
      - when type with a name that is different to Name. In which case
        we create a new type.
  */
  M2Quads_PopTtok (&Type, &typetokno);
  M2Quads_PopTtok (&name, &nametokno);
  if (Debugging)
    {
      n1 = SymbolTable_GetSymName (SymbolTable_GetCurrentModule ());
      M2Printf_printf2 ((const char *) "inside module %a declaring type name %a\\n", 41, (const unsigned char *) &n1, (sizeof (n1)-1), (const unsigned char *) &name, (sizeof (name)-1));
      if (! (SymbolTable_IsUnknown (Type)))
        {
          n1 = SymbolTable_GetSymName (SymbolTable_GetScope (Type));
          n2 = SymbolTable_GetSymName (Type);
          M2Printf_printf2 ((const char *) "type was created inside scope %a as name %a\\n", 45, (const unsigned char *) &n1, (sizeof (n1)-1), (const unsigned char *) &n2, (sizeof (n2)-1));
        }
    }
  if (name == NameKey_NulName)
    {
      /* WriteString('Blank name type') ; WriteLn ;  */
      M2Quads_PushTFtok (Type, name, typetokno);
      M2Quads_Annotate ((const char *) "%1s(%1d)|%2n|%3d||type|type name|token no", 41);
    }
  else if (SymbolTable_IsError (Type))
    {
      /* avoid dangling else.  */
      M2Quads_PushTFtok (Type, name, typetokno);
      M2Quads_Annotate ((const char *) "%1s(%1d)|%2n|%3d||error type|error type name|token no", 53);
    }
  else if ((SymbolTable_GetSymName (Type)) == name)
    {
      /* avoid dangling else.  */
      isunknown = SymbolTable_IsUnknown (Type);
      if (isunknown || (! (SymbolTable_IsDeclaredIn (SymbolTable_GetCurrentScope (), Type))))
        {
          Sym = SymbolTable_MakeType (typetokno, name);
          if (! (SymbolTable_IsError (Sym)))
            {
              /* avoid gcc warning by using compound statement even if not strictly necessary.  */
              if (Sym == Type)
                {
                  if (isunknown)
                    {
                      M2MetaError_MetaError2 ((const char *) "attempting to declare a type {%1ad} to a type which is itself and also unknown {%2ad}", 85, Sym, Type);
                    }
                  else
                    {
                      M2MetaError_MetaError1 ((const char *) "attempting to declare a type {%1ad} as itself", 45, Sym);
                    }
                }
              else
                {
                  SymbolTable_PutType (Sym, Type);
                  SymbolTable_CheckForExportedImplementation (Sym);  /* May be an exported hidden type  */
                  /* if Type is an enumerated type then add its contents to the pseudo scope  */
                  SymbolTable_CheckForEnumerationInCurrentModule (Type);
                }
            }
          M2Quads_PushTFtok (Sym, name, typetokno);
          M2Quads_Annotate ((const char *) "%1s(%1d)|%2n|%3d||type|type name|token no", 41);
        }
      else
        {
          M2Quads_PushTFtok (Type, name, typetokno);
          M2Quads_Annotate ((const char *) "%1s(%1d)|%2n|%3d||type|type name|token no", 41);
        }
    }
  else
    {
      /* avoid dangling else.  */
      /* example   TYPE a = CARDINAL  */
      Sym = SymbolTable_MakeType (nametokno, name);
      SymbolTable_PutType (Sym, Type);
      SymbolTable_CheckForExportedImplementation (Sym);  /* May be an exported hidden type  */
      M2Quads_PushTFtok (Sym, name, nametokno);  /* May be an exported hidden type  */
      M2Quads_Annotate ((const char *) "%1s(%1d)|%2n|%3d||type|type name|token no", 41);
      if (Debugging)
        {
          M2MetaError_MetaErrorT1 (nametokno, (const char *) "type pos {%1Wa}", 15, Sym);
        }
    }
}


/*
   StartBuildFormalParameters - Initialises the quadruple stack for
                                Formal Parameters.

                                The Stack:

                                Entry                Exit

                                                                    <- Ptr
                                                     +------------+
                                Empty                | 0          |
                                                     |------------|
*/

extern "C" void P2SymBuild_StartBuildFormalParameters (void)
{
  M2Quads_PushT (static_cast<unsigned int> (0));
  M2Quads_Annotate ((const char *) "%1d||running total of no. of parameters", 39);
}


/*
   EndBuildFormalParameters - Resets the quadruple stack after building
                              Formal Parameters.

                              The Stack:

                              Entry                    Exit

                       Ptr ->
                              +------------+
                              | NoOfParam  |                          <- Ptr
                              |------------|           +------------+
                              | ProcSym    |           | ProcSym    |
                              |------------|           |------------|
*/

extern "C" void P2SymBuild_EndBuildFormalParameters (void)
{
  SymbolTable_ProcedureKind kind;
  SymbolTable_ProcedureKind curkind;
  unsigned int tok;
  unsigned int NoOfPar;
  unsigned int ProcSym;

  M2Quads_PopT (&NoOfPar);
  M2Quads_PopTtok (&ProcSym, &tok);
  M2Quads_PushTtok (ProcSym, tok);
  M2Quads_Annotate ((const char *) "%1s(%1d)||procedure start symbol", 32);
  M2Debug_Assert (SymbolTable_IsProcedure (ProcSym));
  curkind = SymbolTable_GetProcedureKind (ProcSym, tok);
  for (kind=SymbolTable_ProperProcedure; kind<=SymbolTable_DefProcedure; kind= static_cast<SymbolTable_ProcedureKind>(static_cast<int>(kind+1)))
    {
      if (((SymbolTable_GetProcedureParametersDefined (ProcSym, kind)) && (curkind != kind)) && ((SymbolTable_NoOfParam (ProcSym, kind)) != NoOfPar))
        {
          ParameterMismatch (tok, ProcSym, NoOfPar, kind, curkind);
        }
    }
  /* All parameter seen so set procedure defined.  */
  SymbolTable_PutProcedureParametersDefined (ProcSym, curkind);
  M2Debug_Assert (SymbolTable_IsProcedure (M2Quads_OperandT (1)));
}


/*
   BuildProcedureHeading - Builds a procedure heading for the definition
                           module procedures.

                           Operation only performed if compiling a
                           definition module.

                           The Stack:

                           Entry                       Exit

                    Ptr ->
                           +------------+
                           | ProcSym    |
                           |------------|
                           | NameStart  |
                           |------------|
                                                       Empty

*/

extern "C" void P2SymBuild_BuildProcedureHeading (void)
{
  unsigned int tok;
  unsigned int ProcSym;
  NameKey_Name NameStart;

  ProcSym = static_cast<unsigned int> (M2Quads_OperandT (1));
  tok = static_cast<unsigned int> (M2Quads_OperandTok (1));
  SymbolTable_PutProcedureParametersDefined (ProcSym, SymbolTable_GetProcedureKind (ProcSym, tok));
  if (M2Comp_CompilingDefinitionModule ())
    {
      M2Quads_PopT (&ProcSym);
      M2Debug_Assert (SymbolTable_IsProcedure (ProcSym));
      M2Quads_PopT (&NameStart);
      SymbolTable_EndScope ();
    }
}


/*
   BuildFunction - Builds a procedures return type.
                   Procedure becomes a function.

                    The Stack:

                    Entry                 Exit

             Ptr ->
                    +------------+
                    | TypeSym    |                       <- Ptr
                    |------------|        +------------+
                    | ProcSym    |        | ProcSym    |
                    |------------|        |------------|
*/

extern "C" void P2SymBuild_BuildFunction (void)
{
  unsigned int tok;
  unsigned int ProcSym;
  unsigned int typetok;
  unsigned int RetType;

  M2Quads_PopTtok (&RetType, &typetok);
  M2Quads_PopTtok (&ProcSym, &tok);
  M2Quads_PushTtok (ProcSym, tok);
  SymbolTable_PutFunction (typetok, ProcSym, SymbolTable_GetProcedureKind (ProcSym, tok), RetType);
  CheckOptFunction (tok, ProcSym, SymbolTable_GetProcedureKind (ProcSym, tok), false);
  CheckProcedureReturn (RetType, typetok);
}


/*
   BuildOptFunction - Builds a procedures optional return type.
                      Procedure becomes a function and the user
                      can either call it as a function or a procedure.

                      The Stack:

                      Entry                 Exit

               Ptr ->
                      +------------+
                      | TypeSym    |                       <- Ptr
                      |------------|        +------------+
                      | ProcSym    |        | ProcSym    |
                      |------------|        |------------|
*/

extern "C" void P2SymBuild_BuildOptFunction (void)
{
  unsigned int typetok;
  unsigned int tok;
  unsigned int RetType;
  unsigned int ProcSym;

  M2Quads_PopTtok (&RetType, &typetok);
  M2Quads_PopTtok (&ProcSym, &tok);
  SymbolTable_PutOptFunction (typetok, ProcSym, SymbolTable_GetProcedureKind (ProcSym, tok), RetType);
  CheckOptFunction (tok, ProcSym, SymbolTable_GetProcedureKind (ProcSym, tok), true);
  M2Quads_PushTtok (ProcSym, tok);
}


/*
   BuildFPSection - Builds a Formal Parameter in a procedure.

                    The Stack:

                    Entry                 Exit

             Ptr ->
                    +------------+
                    | ParamTotal |
                    |------------|
                    | TypeSym    |
                    |------------|
                    | Array/Nul  |
                    |------------|
                    | NoOfIds    |
                    |------------|
                    | Id 1       |
                    |------------|
                    .            .
                    .            .
                    .            .
                    |------------|
                    | Id n       |                       <- Ptr
                    |------------|        +------------+
                    | Var / Nul  |        | ParamTotal |
                    |------------|        |------------|
                    | ProcSym    |        | ProcSym    |
                    |------------|        |------------|
*/

extern "C" void P2SymBuild_BuildFPSection (void)
{
  SymbolTable_ProcedureKind kind;
  SymbolTable_ProcedureKind curkind;
  unsigned int tok;
  unsigned int top;
  unsigned int ProcSym;
  unsigned int ParamTotal;

  top = M2Quads_Top ();
  M2Quads_PopT (&ParamTotal);
  ProcSym = (unsigned int ) (M2Quads_OperandT ((3+((unsigned int ) (M2Quads_OperandT (3))))+2));
  tok = (unsigned int ) (M2Quads_OperandTok ((3+((unsigned int ) (M2Quads_OperandT (3))))+2));
  /* Debug (tok, ProcSym, 'foo') ;  */
  curkind = SymbolTable_GetProcedureKind (ProcSym, tok);
  M2Quads_PushT (ParamTotal);
  M2Quads_Annotate ((const char *) "%1d||running total of no. of parameters", 39);
  M2Debug_Assert ((SymbolTable_IsProcedure (ProcSym)) || (SymbolTable_IsProcType (ProcSym)));
  M2Debug_Assert (top == (M2Quads_Top ()));
  ProcSym = (unsigned int ) (M2Quads_OperandT (((3+((unsigned int ) (M2Quads_OperandT (3+1))))+2)+1));
  M2Debug_Assert ((SymbolTable_IsProcedure (ProcSym)) || (SymbolTable_IsProcType (ProcSym)));
  if (! (SymbolTable_GetProcedureParametersDefined (ProcSym, curkind)))
    {
      BuildFormalParameterSection (curkind);
    }
  for (kind=SymbolTable_ProperProcedure; kind<=SymbolTable_DefProcedure; kind= static_cast<SymbolTable_ProcedureKind>(static_cast<int>(kind+1)))
    {
      /* Check against any previous declaration.  */
      if ((kind != curkind) && (SymbolTable_GetProcedureParametersDefined (ProcSym, kind)))
        {
          M2Debug_Assert (top == (M2Quads_Top ()));
          CheckFormalParameterSection (curkind, kind);
          M2Debug_Assert (top == (M2Quads_Top ()));
        }
      ProcSym = (unsigned int ) (M2Quads_OperandT (((3+((unsigned int ) (M2Quads_OperandT (3+1))))+2)+1));
      M2Debug_Assert ((SymbolTable_IsProcedure (ProcSym)) || (SymbolTable_IsProcType (ProcSym)));
    }
  RemoveFPParameters ();
  M2Debug_Assert (SymbolTable_IsProcedure (M2Quads_OperandT (2)));
}


/*
   BuildVarArgs - indicates that the ProcSym takes varargs
                  after ParamTotal.
                                                         <- Ptr
                    +------------+        +------------+
                    | ParamTotal |        | ParamTotal |
                    |------------|        |------------|
                    | ProcSym    |        | ProcSym    |
                    |------------|        |------------|

*/

extern "C" void P2SymBuild_BuildVarArgs (void)
{
  SymbolTable_ProcedureKind kind;
  unsigned int tok;
  unsigned int ProcSym;
  unsigned int ParamTotal;

  M2Quads_PopT (&ParamTotal);
  M2Quads_PopTtok (&ProcSym, &tok);
  kind = SymbolTable_GetProcedureKind (ProcSym, tok);
  if (SymbolTable_UsesOptArg (ProcSym, kind))
    {
      M2Error_WriteFormat0 ((const char *) "procedure can use either a single optional argument or a single vararg section ... at the end of the formal parameter list", 122);
    }
  if (SymbolTable_UsesVarArgs (ProcSym))
    {
      M2Error_WriteFormat0 ((const char *) "procedure can only have one vararg section ... at the end of the formal parameter list", 86);
    }
  SymbolTable_PutUseVarArgs (ProcSym);
  if (SymbolTable_IsDefImp (SymbolTable_GetCurrentModule ()))
    {
      /* avoid dangling else.  */
      if (! (SymbolTable_IsDefinitionForC (SymbolTable_GetCurrentModule ())))
        {
          M2Error_WriteFormat0 ((const char *) "the definition module must be declared as DEFINITION MODULE FOR \"C\" if varargs are to be used", 93);
        }
    }
  else
    {
      M2Error_WriteFormat0 ((const char *) "varargs can only be used in the module declared as DEFINITION MODULE FOR \"C\"", 76);
    }
  M2Quads_PushTtok (ProcSym, tok);
  M2Quads_PushT (ParamTotal);
}


/*
   BuildFormalVarArgs - indicates that the procedure type takes varargs.

                                                             <- Ptr
                        +------------+        +------------+
                        | ProcSym    |        | ProcSym    |
                        |------------|        |------------|

*/

extern "C" void P2SymBuild_BuildFormalVarArgs (void)
{
  unsigned int ProcSym;

  M2Quads_PopT (&ProcSym);
  if (SymbolTable_UsesVarArgs (ProcSym))
    {
      M2Error_WriteFormat0 ((const char *) "procedure type can only have one vararg section ... at the end of the formal parameter list", 91);
    }
  SymbolTable_PutUseVarArgs (ProcSym);
  if (SymbolTable_IsDefImp (SymbolTable_GetCurrentModule ()))
    {
      /* avoid dangling else.  */
      if (! (SymbolTable_IsDefinitionForC (SymbolTable_GetCurrentModule ())))
        {
          M2Error_WriteFormat0 ((const char *) "the definition module must be declared as DEFINITION MODULE FOR \"C\" if varargs are to be used", 93);
        }
    }
  else
    {
      M2Error_WriteFormat0 ((const char *) "varargs can only be used in the module declared as DEFINITION MODULE FOR \"C\"", 76);
    }
  M2Quads_PushT (ProcSym);
}


/*
   BuildOptArg - indicates that the ProcSym takes a single optarg
                 after ParamTotal.

                                                         <- Ptr
                 +------------+        +------------+
                 | ParamTotal |        | ParamTotal |
                 |------------|        |------------|
                 | ProcSym    |        | ProcSym    |
                 |------------|        |------------|
*/

extern "C" void P2SymBuild_BuildOptArg (void)
{
  SymbolTable_ProcedureKind kind;
  unsigned int tok;
  unsigned int ProcSym;
  unsigned int ParamTotal;

  M2Quads_PopT (&ParamTotal);
  M2Quads_PopTtok (&ProcSym, &tok);
  kind = SymbolTable_GetProcedureKind (ProcSym, tok);
  if (SymbolTable_UsesVarArgs (ProcSym))
    {
      M2Error_WriteFormat0 ((const char *) "procedure can not use an optional argument after a vararg ...", 61);
    }
  SymbolTable_PutUseOptArg (ProcSym, kind);
  M2Quads_PushTtok (ProcSym, tok);
  M2Quads_PushT (ParamTotal);
}


/*
   StartBuildProcedure - Builds a Procedure.

                         The Stack:

                         Entry                 Exit

                                                              <- Ptr
                                               +------------+
                  Ptr ->                       | ProcSym    |
                         +------------+        |------------|
                         | Name       |        | Name       |
                         |------------|        |------------|
*/

extern "C" void P2SymBuild_StartBuildProcedure (void)
{
  NameKey_Name name;
  unsigned int ProcSym;
  unsigned int tokno;

  M2Quads_PopTtok (&name, &tokno);
  M2Quads_PushTtok (name, tokno);  /* name saved for the EndBuildProcedure name check  */
  M2Quads_Annotate ((const char *) "%1n|(%1d)||procedure name saved by StartBuildProcedure", 54);  /* name saved for the EndBuildProcedure name check  */
  ProcSym = SymbolTable_GetDeclareSym (tokno, name);
  if (SymbolTable_IsUnknown (ProcSym))
    {
      /* May have been compiled in the definition or implementation module.
         Note we always see an implementation module before its corresponding
         definition module.  */
      ProcSym = SymbolTable_MakeProcedure (tokno, name);
    }
  else if (SymbolTable_IsProcedure (ProcSym))
    {
      /* avoid dangling else.  */
      SymbolTable_PutDeclared (tokno, ProcSym);
    }
  else
    {
      /* avoid dangling else.  */
      M2Error_ErrorStringAt2 (FormatStrings_Sprintf1 (DynamicStrings_Mark (DynamicStrings_InitString ((const char *) "procedure name (%a) has been declared as another object elsewhere", 65)), (const unsigned char *) &name, (sizeof (name)-1)), tokno, SymbolTable_GetDeclaredMod (ProcSym));
    }
  if (M2Comp_CompilingDefinitionModule ())
    {
      SymbolTable_PutExportUnImplemented (tokno, ProcSym);  /* Defined but not yet implemented  */
    }
  else
    {
      SymbolTable_CheckForExportedImplementation (ProcSym);  /* May be exported procedure  */
    }
  M2Quads_PushTtok (ProcSym, tokno);
  M2Quads_Annotate ((const char *) "%1s(%1d)||procedure start symbol", 32);
  SymbolTable_StartScope (ProcSym);
  M2Error_EnterProcedureScope (name);
}


/*
   EndBuildProcedure - Ends building a Procedure.
                       It checks the start procedure name matches the end
                       procedure name.

                       The Stack:

                       (Procedure Not Defined in definition module)

                       Entry                 Exit

                Ptr ->
                       +------------+
                       | NameEnd    |
                       |------------|
                       | ProcSym    |
                       |------------|
                       | NameStart  |
                       |------------|
                                             Empty
*/

extern "C" void P2SymBuild_EndBuildProcedure (void)
{
  NameKey_Name NameEnd;
  NameKey_Name NameStart;
  unsigned int tok;
  unsigned int ProcSym;
  SymbolTable_ProcedureKind kind;

  M2Quads_PopT (&NameEnd);
  M2Quads_PopTtok (&ProcSym, &tok);
  M2Debug_Assert (SymbolTable_IsProcedure (ProcSym));
  kind = SymbolTable_GetProcedureKind (ProcSym, tok);
  M2Quads_PopT (&NameStart);
  if (NameEnd != NameStart)
    {
      M2Error_WriteFormat2 ((const char *) "end procedure name does not match beginning %a name %a", 54, (const unsigned char *) &NameStart, (sizeof (NameStart)-1), (const unsigned char *) &NameEnd, (sizeof (NameEnd)-1));
    }
  SymbolTable_PutProcedureParameterHeapVars (ProcSym);
  SymbolTable_PutProcedureDefined (ProcSym, kind);
  SymbolTable_EndScope ();
  M2Error_LeaveErrorScope ();
}


/*
   EndBuildForward - ends building a forward procedure.
*/

extern "C" void P2SymBuild_EndBuildForward (void)
{
  M2Quads_PopN (2);
  SymbolTable_EndScope ();
  M2Error_LeaveErrorScope ();
}


/*
   BuildNoReturnAttribute - provide an interface to the symbol table module.
*/

extern "C" void P2SymBuild_BuildNoReturnAttribute (void)
{
  SymbolTable_ProcedureKind kind;
  unsigned int ProcSym;
  unsigned int tok;

  M2Quads_PopTtok (&ProcSym, &tok);
  M2Quads_PushTtok (ProcSym, tok);
  kind = SymbolTable_GetProcedureKind (ProcSym, tok);
  M2Debug_Assert (SymbolTable_IsProcedure (ProcSym));
  SymbolTable_PutProcedureNoReturn (ProcSym, kind, true);
}


/*
   CheckProcedure - checks to see that the top of stack procedure
                    has not been declared as a procedure function.

                    The Stack:

                    Entry                 Exit

             Ptr ->                                      <- Ptr
                    +------------+        +------------+
                    | ProcSym    |        | ProcSym    |
                    |------------|        |------------|
*/

extern "C" void P2SymBuild_CheckProcedure (void)
{
  CheckProcedureReturn (SymbolTable_NulSym, M2LexBuf_UnknownTokenNo);
}


/*
   BuildPointerType - builds a pointer type.
                      The Stack:

                      Entry                       Exit
                      =====                       ====


               Ptr ->                                             <- Ptr
                      +------------+              +-------------+
                      | Type       |              | PointerType |
                      |------------|              |-------------|
                      | Name       |              | Name        |
                      |------------|              |-------------|
*/

extern "C" void P2SymBuild_BuildPointerType (unsigned int pointerpos)
{
  unsigned int combined;
  unsigned int namepos;
  unsigned int typepos;
  NameKey_Name name;
  unsigned int Type;
  unsigned int PtrToType;

  M2Quads_PopTtok (&Type, &typepos);
  M2Quads_PopTtok (&name, &namepos);
  name = SymbolTable_CheckAnonymous (name);
  combined = M2LexBuf_MakeVirtual2Tok (pointerpos, typepos);
  PtrToType = SymbolTable_MakePointer (combined, name);
  SymbolTable_PutPointer (PtrToType, Type);
  SymbolTable_CheckForExportedImplementation (PtrToType);  /* May be an exported hidden type  */
  M2Quads_PushTtok (name, namepos);  /* May be an exported hidden type  */
  M2Quads_Annotate ((const char *) "%1n|%3d||pointer type name", 26);
  M2Quads_PushTtok (PtrToType, combined);
  M2Quads_Annotate ((const char *) "%1s(%1d)|%3d||pointer type", 26);
}


/*
   BuildSetType - builds a set type.
                  The Stack:

                  Entry                       Exit
                  =====                       ====


           Ptr ->                                             <- Ptr
                  +------------+              +-------------+
                  | Type       |              | SetType     |
                  |------------|              |-------------|
                  | Name       |              | Name        |
                  |------------|              |-------------|
*/

extern "C" void P2SymBuild_BuildSetType (unsigned int setpos, bool ispacked)
{
  unsigned int combined;
  unsigned int namepos;
  unsigned int typepos;
  NameKey_Name name;
  unsigned int Type;
  unsigned int SetType;

  M2Quads_PopTtok (&Type, &typepos);
  M2Quads_PopTtok (&name, &namepos);
  combined = M2LexBuf_MakeVirtual2Tok (setpos, typepos);
  SetType = SymbolTable_MakeSet (combined, name);
  SymbolTable_CheckForExportedImplementation (SetType);  /* May be an exported hidden type  */
  SymbolTable_PutSet (SetType, Type, ispacked);  /* May be an exported hidden type  */
  M2Quads_PushTtok (name, namepos);
  M2Quads_Annotate ((const char *) "%1n||set type name", 18);
  M2Quads_PushTtok (SetType, combined);
  M2Quads_Annotate ((const char *) "%1s(%1d)|%3d||set type|token no", 31);
}


/*
   BuildRecord - Builds a record type.
                 The Stack:

                 Entry                              Exit
                 =====                              ====


                                                                  <- Ptr
                                                    +-----------+
          Ptr ->                                    | RecordSym |
                 +------------------+               |-----------|
                 | Name             |               | Name      |
                 |------------------|               |-----------|
*/

extern "C" void P2SymBuild_BuildRecord (void)
{
  unsigned int tokno;
  NameKey_Name name;
  unsigned int RecordType;

  name = static_cast<NameKey_Name> (M2Quads_OperandT (1));
  name = SymbolTable_CheckAnonymous (name);
  tokno = static_cast<unsigned int> (M2Quads_OperandTok (1));
  RecordType = SymbolTable_MakeRecord (tokno, name);
  SymbolTable_CheckForExportedImplementation (RecordType);  /* May be an exported hidden type  */
  M2Quads_PushT (RecordType);
  /* ; WriteKey(name) ; WriteString(' RECORD made') ; WriteLn  */
  M2Quads_Annotate ((const char *) "%1s(%1d)||record type", 21);
}


/*
   BuildFieldRecord - Builds a field into a record sym.
                      The Stack:


                      Entry                     Exit
                      =====                     ====

               Ptr ->
                      +-------------+
                      | NoOfPragmas |
                      |-------------|
                      | Const1      |
                      |-------------|
                      | PragmaName1 |
                      |-------------|
                      | Type | Name |
                      |-------------|
                      | n           |
                      |-------------|
                      | Id 1        |
                      |-------------|
                      .             .
                      .             .
                      .             .
                      |-------------|
                      | Id n        |                           <- Ptr
                      |-------------|           +-------------+
                      | RecordSym   |           | RecordSym   |
                      |-------------|           |-------------|
                      | RecordName  |           | RecordName  |
                      |-------------|           |-------------|
*/

extern "C" void P2SymBuild_BuildFieldRecord (void)
{
  NameKey_Name n1;
  unsigned int tok;
  unsigned int fsym;
  unsigned int Field;
  unsigned int Varient;
  unsigned int Parent;
  unsigned int Type;
  unsigned int NoOfPragmas;
  unsigned int NoOfFields;
  unsigned int Record;
  unsigned int i;

  M2Quads_PopT (&NoOfPragmas);
  Type = static_cast<unsigned int> (M2Quads_OperandT ((NoOfPragmas*2)+1));
  /* name := OperandF(NoOfPragmas*2+1) ;  */
  NoOfFields = static_cast<unsigned int> (M2Quads_OperandT ((NoOfPragmas*2)+2));
  Record = static_cast<unsigned int> (M2Quads_OperandT (((NoOfPragmas*2)+NoOfFields)+3));
  if (SymbolTable_IsRecord (Record))
    {
      Parent = Record;
      Varient = SymbolTable_NulSym;
    }
  else
    {
      /* Record maybe FieldVarient  */
      Parent = SymbolTable_GetRecord (SymbolTable_GetParent (Record));
      M2Debug_Assert (SymbolTable_IsFieldVarient (Record));
      Varient = static_cast<unsigned int> (M2Quads_OperandT (((NoOfPragmas*2)+NoOfFields)+4));
      M2Debug_Assert (SymbolTable_IsVarient (Varient));
      SymbolTable_PutFieldVarient (Record, Varient);
      if (Debugging)
        {
          n1 = SymbolTable_GetSymName (Record);
          StrIO_WriteString ((const char *) "Record ", 7);
          NameKey_WriteKey (n1);
          StrIO_WriteString ((const char *) " has varient ", 13);
          n1 = SymbolTable_GetSymName (Varient);
          NameKey_WriteKey (n1);
          StrIO_WriteLn ();
        }
    }
  Field = SymbolTable_NulSym;
  i = 1;
  while (i <= NoOfFields)
    {
      if (Debugging)
        {
          n1 = SymbolTable_GetSymName (Record);
          StrIO_WriteString ((const char *) "Record ", 7);
          NameKey_WriteKey (n1);
          StrIO_WriteString ((const char *) "  ", 2);
          NameKey_WriteKey (M2Quads_OperandT ((((NoOfPragmas*2)+NoOfFields)+3)-i));
          StrIO_WriteString ((const char *) " is a Field with type ", 22);
          NameKey_WriteKey (SymbolTable_GetSymName (Type));
          StrIO_WriteLn ();
        }
      fsym = SymbolTable_GetLocalSym (Parent, M2Quads_OperandT ((((NoOfPragmas*2)+NoOfFields)+3)-i));
      if (fsym == SymbolTable_NulSym)
        {
          Field = SymbolTable_PutFieldRecord (Record, M2Quads_OperandT ((((NoOfPragmas*2)+NoOfFields)+3)-i), Type, Varient);
          HandleRecordFieldPragmas (Record, Field, NoOfPragmas);
        }
      else
        {
          M2MetaError_MetaErrors2 ((const char *) "record field {%1ad} has already been declared inside a {%2Dd} {%2a}", 67, (const char *) "attempting to declare a duplicate record field", 46, fsym, Parent);
        }
      /* adjust the location of declaration to the one on the stack (rather than GetTokenNo).  */
      tok = static_cast<unsigned int> (M2Quads_OperandTok ((((NoOfPragmas*2)+NoOfFields)+3)-i));
      if ((tok != M2LexBuf_UnknownTokenNo) && (Field != SymbolTable_NulSym))
        {
          SymbolTable_PutDeclared (tok, Field);
        }
      i += 1;
    }
  M2Quads_PopN (((NoOfPragmas*2)+NoOfFields)+3);
  M2Quads_PushT (Record);
  if (SymbolTable_IsRecord (Record))
    {
      M2Quads_Annotate ((const char *) "%1s(%1d)||record type", 21);
    }
  else
    {
      M2Debug_Assert (SymbolTable_IsFieldVarient (Record));
      M2Quads_Annotate ((const char *) "%1s(%1d)||varient field type", 28);
    }
}


/*
   StartBuildVarient - Builds a varient symbol on top of a record sym.
                       The Stack:


                       Entry                     Exit
                       =====                     ====

                                                                 <- Ptr
                                                 +-------------+
                Ptr ->                           | VarientSym  |
                       +-------------+           |-------------|
                       | RecordSym   |           | RecordSym   |
                       |-------------|           |-------------|
                       | RecordName  |           | RecordName  |
                       |-------------|           |-------------|
*/

extern "C" void P2SymBuild_StartBuildVarient (void)
{
  unsigned int tokno;
  unsigned int RecordSym;
  unsigned int Sym;

  RecordSym = static_cast<unsigned int> (M2Quads_OperandT (1));
  tokno = static_cast<unsigned int> (M2Quads_OperandTok (1));
  Sym = SymbolTable_MakeVarient (tokno, RecordSym);
  M2Quads_PushT (Sym);
  M2Quads_Annotate ((const char *) "%1s(%1d)||varient type", 22);
}


/*
   EndBuildVarient - Removes the varient symbol from the stack.
                     The Stack:

                     Entry                     Exit
                     =====                     ====

              Ptr ->
                     +-------------+
                     | VarientSym  |                           <- Ptr
                     |-------------|           +-------------+
                     | RecordSym   |           | RecordSym   |
                     |-------------|           |-------------|
                     | RecordName  |           | RecordName  |
                     |-------------|           |-------------|
*/

extern "C" void P2SymBuild_EndBuildVarient (void)
{
  unsigned int Sym;

  M2Quads_PopT (&Sym);
}


/*
   BuildVarientSelector - Builds a field into a record sym.
                          The Stack:


                          Entry                     Exit
                          =====                     ====

                   Ptr ->
                          +-------------+
                          | Type        |
                          |-------------|
                          | Tag         |                           <- Ptr
                          |-------------|           +-------------+
                          | RecordSym   |           | RecordSym   |
                          |-------------|           |-------------|
*/

extern "C" void P2SymBuild_BuildVarientSelector (void)
{
  unsigned int tagtok;
  NameKey_Name tag;
  unsigned int Field;
  unsigned int Type;
  unsigned int Varient;
  unsigned int VarField;
  unsigned int Record;

  M2Quads_PopT (&Type);
  M2Quads_PopTtok (&tag, &tagtok);
  Record = static_cast<unsigned int> (M2Quads_OperandT (1));
  if (SymbolTable_IsRecord (Record))
    {
      Varient = SymbolTable_NulSym;
      M2Error_InternalError ((const char *) "not expecting a record symbol", 29);
    }
  else if (SymbolTable_IsVarient (Record))
    {
      /* avoid dangling else.  */
      Varient = Record;
      VarField = SymbolTable_GetParent (Varient);
      if ((Type == SymbolTable_NulSym) && (tag == NameKey_NulName))
        {
          M2MetaError_MetaError1 ((const char *) "expecting a tag field in the declaration of a varient record {%1Ua}", 67, Record);
        }
      else if (Type == SymbolTable_NulSym)
        {
          /* avoid dangling else.  */
          SymbolTable_PutVarientTag (Varient, SymbolTable_RequestSym (tagtok, tag));
        }
      else
        {
          /* avoid dangling else.  */
          Field = SymbolTable_PutFieldRecord (VarField, tag, Type, Varient);
          SymbolTable_PutVarientTag (Varient, Field);
          if (Debugging)
            {
              StrIO_WriteString ((const char *) "varient field ", 14);
              NameKey_WriteKey (SymbolTable_GetSymName (VarField));
              StrIO_WriteString ((const char *) "varient ", 8);
              NameKey_WriteKey (SymbolTable_GetSymName (Varient));
              StrIO_WriteLn ();
            }
        }
    }
  else
    {
      /* avoid dangling else.  */
      /* Record maybe FieldVarient  */
      M2Debug_Assert (SymbolTable_IsFieldVarient (Record));
      Varient = static_cast<unsigned int> (M2Quads_OperandT (1+2));
      M2Debug_Assert (SymbolTable_IsVarient (Varient));
      SymbolTable_PutFieldVarient (Record, Varient);
      if (Debugging)
        {
          StrIO_WriteString ((const char *) "record ", 7);
          NameKey_WriteKey (SymbolTable_GetSymName (Record));
          StrIO_WriteString ((const char *) "varient ", 8);
          NameKey_WriteKey (SymbolTable_GetSymName (Varient));
          StrIO_WriteLn ();
        }
      if ((Type == SymbolTable_NulSym) && (tag == NameKey_NulName))
        {
          M2MetaError_MetaError1 ((const char *) "expecting a tag field in the declaration of a varient record {%1Ua}", 67, Record);
        }
      else if (Type == SymbolTable_NulSym)
        {
          /* avoid dangling else.  */
          SymbolTable_PutVarientTag (Varient, SymbolTable_RequestSym (tagtok, tag));
        }
      else
        {
          /* avoid dangling else.  */
          Field = SymbolTable_PutFieldRecord (Record, tag, Type, Varient);
          SymbolTable_PutVarientTag (Varient, Field);
          if (Debugging)
            {
              StrIO_WriteString ((const char *) "record ", 7);
              NameKey_WriteKey (SymbolTable_GetSymName (Record));
              StrIO_WriteString ((const char *) "varient ", 8);
              NameKey_WriteKey (SymbolTable_GetSymName (Varient));
              StrIO_WriteLn ();
            }
        }
    }
}


/*
   StartBuildVarientFieldRecord - Builds a varient field into a varient sym.
                                  The Stack:


                                  Entry                     Exit
                                  =====                     ====

                                                                       <- Ptr
                                                       +-------------+
                      Ptr ->                           | VarientField|
                             +-------------+           |-------------|
                             | VarientSym  |           | VarientSym  |
                             |-------------|           |-------------|
*/

extern "C" void P2SymBuild_StartBuildVarientFieldRecord (void)
{
  unsigned int VarientSym;
  unsigned int FieldSym;

  VarientSym = static_cast<unsigned int> (M2Quads_OperandT (1));
  FieldSym = SymbolTable_MakeFieldVarient (SymbolTable_CheckAnonymous (NameKey_NulName), VarientSym);
  M2Quads_Annotate ((const char *) "%1s(%1d)||varient sym", 21);
  M2Quads_PushT (FieldSym);
  M2Quads_Annotate ((const char *) "%1s(%1d)||varient field type", 28);
  M2Debug_Assert (SymbolTable_IsFieldVarient (FieldSym));
  SymbolTable_PutFieldVarient (FieldSym, VarientSym);
  M2Quads_AddVarientFieldToList (FieldSym);
}


/*
   EndBuildVarientFieldRecord - Removes a varient field from the stack.
                                The Stack:


                                Entry                     Exit
                                =====                     ====

                         Ptr ->
                                +-------------+
                                | VarientField|                           <- Ptr
                                |-------------|           +-------------+
                                | VarientSym  |           | VarientSym  |
                                |-------------|           |-------------|
*/

extern "C" void P2SymBuild_EndBuildVarientFieldRecord (void)
{
  unsigned int FieldSym;

  M2Quads_PopT (&FieldSym);
}


/*
   BuildNulName - Pushes a NulName onto the top of the stack.
                  The Stack:


                  Entry                    Exit

                                                          <- Ptr
                  Empty                    +------------+
                                           | NulName   |
                                           |------------|
*/

extern "C" void P2SymBuild_BuildNulName (void)
{
  M2Quads_PushTtok (static_cast<unsigned int> (NameKey_NulName), M2LexBuf_GetTokenNo ());
  M2Quads_Annotate ((const char *) "%1n|%3d||NulName|token no", 25);
}


/*
   BuildTypeEnd - Pops the type Type and Name.
                  The Stack:


                  Entry                    Exit


           Ptr ->
                  +-------------+
                  | Type | Name |          Empty
                  |-------------|
*/

extern "C" void P2SymBuild_BuildTypeEnd (void)
{
  unsigned int Type;
  NameKey_Name name;

  M2Quads_PopTF (&Type, &name);
}


/*
   StartBuildArray - Builds an array type.
                     The Stack:

                     Entry                        Exit
                     =====                        ====

                                                                <- Ptr
                                                  +-----------+
              Ptr ->                              | ArraySym  |
                     +------------+               |-----------|
                     | Name       |               | Name      |
                     |------------|               |-----------|
*/

extern "C" void P2SymBuild_StartBuildArray (void)
{
  unsigned int tok;
  NameKey_Name name;
  unsigned int ArrayType;

  name = static_cast<NameKey_Name> (M2Quads_OperandT (1));
  tok = static_cast<unsigned int> (M2Quads_OperandTok (1));
  ArrayType = SymbolTable_MakeArray (tok, name);
  SymbolTable_CheckForExportedImplementation (ArrayType);  /* May be an exported hidden type  */
  M2Quads_PushTtok (ArrayType, tok);  /* May be an exported hidden type  */
  /* ; WriteKey(Name) ; WriteString(' ARRAY made') ; WriteLn  */
  M2Quads_Annotate ((const char *) "%1s(%1d)|%3d||array type|token no", 33);
}


/*
   EndBuildArray - Builds an array type.
                   The Stack:

                   Entry                        Exit
                   =====                        ====

            Ptr ->
                   +------------+
                   | TypeSym    |                              <- Ptr
                   |------------|               +------------+
                   | ArraySym   |               | ArraySym   |
                   |------------|               |------------|
                   | Name       |               | Name       |
                   |------------|               |------------|
*/

extern "C" void P2SymBuild_EndBuildArray (void)
{
  unsigned int typetok;
  unsigned int arraytok;
  unsigned int combinedtok;
  unsigned int TypeSym;
  unsigned int ArraySym;

  M2Quads_PopTtok (&TypeSym, &typetok);
  M2Quads_PopTtok (&ArraySym, &arraytok);
  M2Debug_Assert (SymbolTable_IsArray (ArraySym));
  combinedtok = M2LexBuf_MakeVirtual2Tok (arraytok, typetok);
  SymbolTable_PutArray (ArraySym, TypeSym);
  SymbolTable_PutDeclared (combinedtok, ArraySym);
  M2Quads_PushTtok (ArraySym, combinedtok);
  M2Quads_Annotate ((const char *) "%1s(%1d)||array type", 20);
}


/*
   BuildFieldArray - Builds a field into an array sym.
                     The Stack:


                     Entry                     Exit
                     =====                     ====

              Ptr ->
                     +-------------+
                     | Type | Name |                           <- Ptr
                     |-------------|           +-------------+
                     | ArraySym    |           | ArraySym    |
                     |-------------|           |-------------|
                     | ArrayName   |           | ArrayName   |
                     |-------------|           |-------------|
*/

extern "C" void P2SymBuild_BuildFieldArray (void)
{
  unsigned int typetok;
  unsigned int arraytok;
  unsigned int Subscript;
  unsigned int Type;
  unsigned int Array;
  NameKey_Name name;

  M2Quads_PopTFtok (&Type, &name, &typetok);
  M2Quads_PopTtok (&Array, &arraytok);
  M2Debug_Assert (SymbolTable_IsArray (Array));
  Subscript = SymbolTable_MakeSubscript ();
  /* 
      We cannot Assert(IsSubrange(Type)) as the subrange type might be
      declared later on in the file.
      We also note it could be an ordinal type or enumerated type.
      Therefore we must save this information and deal with the
      different cases in M2GCCDeclare.mod and M2GenGCC.mod.
      However this works to our advantage as it preserves the
      actual declaration as specified by the source file.
  */
  SymbolTable_PutSubscript (Subscript, Type);
  SymbolTable_PutArraySubscript (Array, Subscript);
  M2Quads_PushTtok (Array, arraytok);
  /* ; WriteString('Field Placed in Array') ; WriteLn  */
  M2Quads_Annotate ((const char *) "%1s(%1d)||array type", 20);
}


/*
   BuildArrayComma - converts ARRAY [..], [..] OF into ARRAY [..] OF ARRAY [..]


              Ptr ->                                           <- Ptr
                     +-------------+           +-------------+
                     | ArraySym1   |           | ArraySym2   |
                     |-------------|           |-------------|
                     | ArrayName   |           | ArrayName   |
                     |-------------|           |-------------|
*/

extern "C" void P2SymBuild_BuildArrayComma (void)
{
  unsigned int Nothing;
  unsigned int ArraySym1;
  unsigned int ArraySym2;

  M2Quads_PushT (static_cast<unsigned int> (NameKey_NulName));
  P2SymBuild_StartBuildArray ();
  M2Quads_PopT (&ArraySym2);
  M2Quads_PopT (&Nothing);
  M2Quads_PushT (ArraySym2);
  P2SymBuild_EndBuildArray ();
  M2Quads_PopT (&ArraySym1);
  M2Quads_PushT (ArraySym2);
  M2Quads_Annotate ((const char *) "%1s(%1d)||array type comma", 26);
}


/*
   BuildProcedureType - builds a procedure type symbol.
                        The Stack:


                                                               <- Ptr
                                               +-------------+
                 Ptr ->                        | ProcTypeSym |
                        +-------------+        |-------------|
                        | Name        |        | Name        |
                        |-------------|        |-------------|
*/

extern "C" void P2SymBuild_BuildProcedureType (void)
{
  unsigned int tok;
  NameKey_Name name;
  unsigned int ProcTypeSym;

  name = static_cast<NameKey_Name> (M2Quads_OperandT (1));
  tok = static_cast<unsigned int> (M2Quads_OperandTok (1));
  ProcTypeSym = SymbolTable_MakeProcType (tok, name);
  SymbolTable_CheckForExportedImplementation (ProcTypeSym);  /* May be an exported hidden type  */
  M2Quads_Annotate ((const char *) "%1n||procedure type name", 24);  /* May be an exported hidden type  */
  M2Quads_PushTtok (ProcTypeSym, tok);
  M2Quads_Annotate ((const char *) "%1s(%1d)|%3d||proc type|token no", 32);
}


/*
   BuildFormalType - Builds a Formal Parameter in a procedure type.

                     The Stack:

                     Entry                 Exit

              Ptr ->
                     +------------+
                     | TypeSym    |
                     |------------|
                     | Array/Nul  |
                     |------------|
                     | Var / Nul  |                         <- Ptr
                     |------------|        +--------------+
                     | ProcTypeSym|        | ProcTypeSym  |
                     |------------|        |--------------|
*/

extern "C" void P2SymBuild_BuildFormalType (void)
{
  unsigned int tok;
  NameKey_Name Array;
  NameKey_Name Var;
  unsigned int TypeSym;
  unsigned int UnboundedSym;
  unsigned int ProcTypeSym;

  M2Quads_PopT (&TypeSym);
  M2Quads_PopT (&Array);
  M2Quads_PopT (&Var);
  M2Quads_PopT (&ProcTypeSym);
  tok = M2LexBuf_GetTokenNo ();
  M2Debug_Assert ((Array == M2Reserved_ArrayTok) || (Array == M2Reserved_NulTok));
  M2Debug_Assert (SymbolTable_IsProcType (ProcTypeSym));
  M2Debug_Assert ((Var == M2Reserved_VarTok) || (Var == M2Reserved_NulTok));
  if (Array == M2Reserved_ArrayTok)
    {
      UnboundedSym = SymbolTable_MakeUnbounded (tok, TypeSym, 1);
      TypeSym = UnboundedSym;
    }
  if (Var == M2Reserved_VarTok)
    {
      /* VAR parameter  */
      SymbolTable_PutProcTypeVarParam (tok, ProcTypeSym, TypeSym, SymbolTable_IsUnbounded (TypeSym));
    }
  else
    {
      /* Non VAR parameter  */
      SymbolTable_PutProcTypeParam (tok, ProcTypeSym, TypeSym, SymbolTable_IsUnbounded (TypeSym));
    }
  M2Quads_PushT (ProcTypeSym);
  M2Quads_Annotate ((const char *) "%1s(%1d)||proc type", 19);
}


/*
   SeenUnknown - sets the operand type to unknown.
*/

extern "C" void P2SymBuild_SeenUnknown (void)
{
  type = M2Const_unknown;
}


/*
   SeenCast - sets the operand type to cast.
*/

extern "C" void P2SymBuild_SeenCast (unsigned int sym)
{
  type = M2Const_cast;
  castType = sym;
  M2Debug_Assert (SymbolTable_IsAModula2Type (sym));
}


/*
   SeenSet - sets the operand type to set.
*/

extern "C" void P2SymBuild_SeenSet (void)
{
  SetTypeTo (M2Const_set);
  SaveRememberedConstructor ();
}


/*
   SeenConstructor - sets the operand type to constructor.
*/

extern "C" void P2SymBuild_SeenConstructor (void)
{
  SetTypeTo (M2Const_constructor);
  SaveRememberedConstructor ();
}


/*
   SeenArray - sets the operand type to array.
*/

extern "C" void P2SymBuild_SeenArray (void)
{
  SetTypeTo (M2Const_array);
}


/*
   SeenString - sets the operand type to string.
*/

extern "C" void P2SymBuild_SeenString (void)
{
  SetTypeTo (M2Const_str);
}


/*
   SeenBoolean - sets the operand type to a BOOLEAN.
*/

extern "C" void P2SymBuild_SeenBoolean (void)
{
  type = M2Const_boolean;
}


/*
   SeenZType - sets the operand type to a Z type.
*/

extern "C" void P2SymBuild_SeenZType (void)
{
  type = M2Const_ztype;
}


/*
   SeenRType - sets the operand type to a R type.
*/

extern "C" void P2SymBuild_SeenRType (void)
{
  type = M2Const_rtype;
}


/*
   SeenCType - sets the operand type to a C type.
*/

extern "C" void P2SymBuild_SeenCType (void)
{
  type = M2Const_ctype;
}


/*
   DetermineType - assigns the top of stack symbol with the type of
                   constant expression, if known.
*/

extern "C" void P2SymBuild_DetermineType (void)
{
  unsigned int Sym;

  Sym = static_cast<unsigned int> (M2Quads_OperandT (1));
  switch (type)
    {
      case M2Const_set:
        SymbolTable_PutConstSet (Sym);
        break;

      case M2Const_str:
        SymbolTable_PutConstStringKnown (M2LexBuf_GetTokenNo (), Sym, NameKey_MakeKey ((const char *) "", 0), false, false);
        break;

      case M2Const_array:
      case M2Const_constructor:
        SymbolTable_PutConstructor (Sym);
        break;

      case M2Const_cast:
        SymbolTable_PutConst (Sym, castType);
        break;

      case M2Const_unknown:
        break;


      default:
        break;
    }
}


/*
   PushType -
*/

extern "C" void P2SymBuild_PushType (void)
{
  M2StackWord_PushWord (TypeStack, static_cast<unsigned int> (type));
}


/*
   PopType -
*/

extern "C" void P2SymBuild_PopType (void)
{
  type = static_cast<M2Const_constType> (M2StackWord_PopWord (TypeStack));
}


/*
   PushRememberConstant -
*/

extern "C" void P2SymBuild_PushRememberConstant (void)
{
  M2StackWord_PushWord (RememberStack, RememberedConstant);
  P2SymBuild_RememberConstant (SymbolTable_NulSym);
}


/*
   PopRememberConstant -
*/

extern "C" void P2SymBuild_PopRememberConstant (void)
{
  RememberedConstant = static_cast<unsigned int> (M2StackWord_PopWord (RememberStack));
}


/*
   RememberConstant -
*/

extern "C" void P2SymBuild_RememberConstant (unsigned int sym)
{
  RememberedConstant = sym;
}

extern "C" void _M2_P2SymBuild_init (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
  alignTypeNo = 0;
  TypeStack = M2StackWord_InitStackWord ();
  RememberStack = M2StackWord_InitStackWord ();
  BlockStack = M2StackWord_InitStackWord ();
  castType = SymbolTable_NulSym;
}

extern "C" void _M2_P2SymBuild_fini (__attribute__((unused)) int argc, __attribute__((unused)) char *argv[], __attribute__((unused)) char *envp[])
{
}
