{-# LANGUAGE OverloadedStrings #-}
-- | Build time configuration used during code generation.
module GI.Cairo.Config ( overrides, modules ) where

import qualified Data.Text as T
import Data.Text (Text)

-- | Overrides used when generating these bindings.
overrides :: Text
overrides = T.unlines
 [ "namespace cairo"
 , ""
 , "set-attr cairo/FontOptions glib:get-type cairo_gobject_font_options_get_type"
 , "set-attr cairo/Matrix glib:get-type cairo_gobject_matrix_get_type "]

-- | Modules in this package
modules :: [Text]
modules =  [ "GI.Cairo.Config"
 , "GI.Cairo"
 , "GI.Cairo.Enums"
 , "GI.Cairo.Functions"
 , "GI.Cairo.Structs"
 , "GI.Cairo.Structs.Context"
 , "GI.Cairo.Structs.Device"
 , "GI.Cairo.Structs.FontFace"
 , "GI.Cairo.Structs.FontOptions"
 , "GI.Cairo.Structs.Glyph"
 , "GI.Cairo.Structs.Matrix"
 , "GI.Cairo.Structs.Path"
 , "GI.Cairo.Structs.Pattern"
 , "GI.Cairo.Structs.Rectangle"
 , "GI.Cairo.Structs.RectangleInt"
 , "GI.Cairo.Structs.Region"
 , "GI.Cairo.Structs.ScaledFont"
 , "GI.Cairo.Structs.Surface"
 , "GI.Cairo.Structs.TextCluster"]
