{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Renders a pixbuf in a cell
-- 
-- A @GtkCellRendererPixbuf@ can be used to render an image in a cell. It allows
-- to render either a given @GdkPixbuf@ (set via the
-- @GtkCellRendererPixbuf:pixbuf@ property) or a named icon (set via the
-- @GtkCellRendererPixbuf:icon-name@ property).
-- 
-- To support the tree view, @GtkCellRendererPixbuf@ also supports rendering two
-- alternative pixbufs, when the @GtkCellRenderer:is-expander@ property is 'P.True'.
-- If the @GtkCellRenderer:is-expanded property@ is 'P.True' and the
-- @GtkCellRendererPixbuf:pixbuf-expander-open@ property is set to a pixbuf, it
-- renders that pixbuf, if the @GtkCellRenderer:is-expanded@ property is 'P.False'
-- and the @GtkCellRendererPixbuf:pixbuf-expander-closed@ property is set to a
-- pixbuf, it renders that one.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gtk.Objects.CellRendererPixbuf
    ( 

-- * Exported types
    CellRendererPixbuf(..)                  ,
    IsCellRendererPixbuf                    ,
    toCellRendererPixbuf                    ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [activate]("GI.Gtk.Objects.CellRenderer#g:method:activate"), [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isActivatable]("GI.Gtk.Objects.CellRenderer#g:method:isActivatable"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [snapshot]("GI.Gtk.Objects.CellRenderer#g:method:snapshot"), [startEditing]("GI.Gtk.Objects.CellRenderer#g:method:startEditing"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [stopEditing]("GI.Gtk.Objects.CellRenderer#g:method:stopEditing"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getAlignedArea]("GI.Gtk.Objects.CellRenderer#g:method:getAlignedArea"), [getAlignment]("GI.Gtk.Objects.CellRenderer#g:method:getAlignment"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getFixedSize]("GI.Gtk.Objects.CellRenderer#g:method:getFixedSize"), [getIsExpanded]("GI.Gtk.Objects.CellRenderer#g:method:getIsExpanded"), [getIsExpander]("GI.Gtk.Objects.CellRenderer#g:method:getIsExpander"), [getPadding]("GI.Gtk.Objects.CellRenderer#g:method:getPadding"), [getPreferredHeight]("GI.Gtk.Objects.CellRenderer#g:method:getPreferredHeight"), [getPreferredHeightForWidth]("GI.Gtk.Objects.CellRenderer#g:method:getPreferredHeightForWidth"), [getPreferredSize]("GI.Gtk.Objects.CellRenderer#g:method:getPreferredSize"), [getPreferredWidth]("GI.Gtk.Objects.CellRenderer#g:method:getPreferredWidth"), [getPreferredWidthForHeight]("GI.Gtk.Objects.CellRenderer#g:method:getPreferredWidthForHeight"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getRequestMode]("GI.Gtk.Objects.CellRenderer#g:method:getRequestMode"), [getSensitive]("GI.Gtk.Objects.CellRenderer#g:method:getSensitive"), [getState]("GI.Gtk.Objects.CellRenderer#g:method:getState"), [getVisible]("GI.Gtk.Objects.CellRenderer#g:method:getVisible").
-- 
-- ==== Setters
-- [setAlignment]("GI.Gtk.Objects.CellRenderer#g:method:setAlignment"), [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setFixedSize]("GI.Gtk.Objects.CellRenderer#g:method:setFixedSize"), [setIsExpanded]("GI.Gtk.Objects.CellRenderer#g:method:setIsExpanded"), [setIsExpander]("GI.Gtk.Objects.CellRenderer#g:method:setIsExpander"), [setPadding]("GI.Gtk.Objects.CellRenderer#g:method:setPadding"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty"), [setSensitive]("GI.Gtk.Objects.CellRenderer#g:method:setSensitive"), [setVisible]("GI.Gtk.Objects.CellRenderer#g:method:setVisible").

#if defined(ENABLE_OVERLOADING)
    ResolveCellRendererPixbufMethod         ,
#endif

-- ** new #method:new#

    cellRendererPixbufNew                   ,




 -- * Properties


-- ** gicon #attr:gicon#
-- | The GIcon representing the icon to display.
-- If the icon theme is changed, the image will be updated
-- automatically.

#if defined(ENABLE_OVERLOADING)
    CellRendererPixbufGiconPropertyInfo     ,
#endif
#if defined(ENABLE_OVERLOADING)
    cellRendererPixbufGicon                 ,
#endif
    clearCellRendererPixbufGicon            ,
    constructCellRendererPixbufGicon        ,
    getCellRendererPixbufGicon              ,
    setCellRendererPixbufGicon              ,


-- ** iconName #attr:iconName#
-- | The name of the themed icon to display.
-- This property only has an effect if not overridden by the \"pixbuf\" property.

#if defined(ENABLE_OVERLOADING)
    CellRendererPixbufIconNamePropertyInfo  ,
#endif
#if defined(ENABLE_OVERLOADING)
    cellRendererPixbufIconName              ,
#endif
    clearCellRendererPixbufIconName         ,
    constructCellRendererPixbufIconName     ,
    getCellRendererPixbufIconName           ,
    setCellRendererPixbufIconName           ,


-- ** iconSize #attr:iconSize#
-- | The @GtkIconSize@ value that specifies the size of the rendered icon.

#if defined(ENABLE_OVERLOADING)
    CellRendererPixbufIconSizePropertyInfo  ,
#endif
#if defined(ENABLE_OVERLOADING)
    cellRendererPixbufIconSize              ,
#endif
    constructCellRendererPixbufIconSize     ,
    getCellRendererPixbufIconSize           ,
    setCellRendererPixbufIconSize           ,


-- ** pixbuf #attr:pixbuf#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    CellRendererPixbufPixbufPropertyInfo    ,
#endif
#if defined(ENABLE_OVERLOADING)
    cellRendererPixbufPixbuf                ,
#endif
    clearCellRendererPixbufPixbuf           ,
    constructCellRendererPixbufPixbuf       ,
    setCellRendererPixbufPixbuf             ,


-- ** pixbufExpanderClosed #attr:pixbufExpanderClosed#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    CellRendererPixbufPixbufExpanderClosedPropertyInfo,
#endif
#if defined(ENABLE_OVERLOADING)
    cellRendererPixbufPixbufExpanderClosed  ,
#endif
    clearCellRendererPixbufPixbufExpanderClosed,
    constructCellRendererPixbufPixbufExpanderClosed,
    getCellRendererPixbufPixbufExpanderClosed,
    setCellRendererPixbufPixbufExpanderClosed,


-- ** pixbufExpanderOpen #attr:pixbufExpanderOpen#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    CellRendererPixbufPixbufExpanderOpenPropertyInfo,
#endif
#if defined(ENABLE_OVERLOADING)
    cellRendererPixbufPixbufExpanderOpen    ,
#endif
    clearCellRendererPixbufPixbufExpanderOpen,
    constructCellRendererPixbufPixbufExpanderOpen,
    getCellRendererPixbufPixbufExpanderOpen ,
    setCellRendererPixbufPixbufExpanderOpen ,


-- ** texture #attr:texture#
-- | /No description available in the introspection data./

#if defined(ENABLE_OVERLOADING)
    CellRendererPixbufTexturePropertyInfo   ,
#endif
#if defined(ENABLE_OVERLOADING)
    cellRendererPixbufTexture               ,
#endif
    clearCellRendererPixbufTexture          ,
    constructCellRendererPixbufTexture      ,
    getCellRendererPixbufTexture            ,
    setCellRendererPixbufTexture            ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.FontOptions as Cairo.FontOptions
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Flags as Gdk.Flags
import qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import qualified GI.Gdk.Objects.Device as Gdk.Device
import qualified GI.Gdk.Objects.Display as Gdk.Display
import qualified GI.Gdk.Objects.Event as Gdk.Event
import qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import qualified GI.Gdk.Objects.Surface as Gdk.Surface
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.ActionGroup as Gio.ActionGroup
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Graphene.Structs.Matrix as Graphene.Matrix
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Point3D as Graphene.Point3D
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Graphene.Structs.Size as Graphene.Size
import qualified GI.Graphene.Structs.Vec3 as Graphene.Vec3
import qualified GI.Graphene.Structs.Vec4 as Graphene.Vec4
import qualified GI.Gsk.Enums as Gsk.Enums
import qualified GI.Gsk.Objects.GLShader as Gsk.GLShader
import qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import qualified GI.Gsk.Objects.Renderer as Gsk.Renderer
import qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop
import qualified GI.Gsk.Structs.ComponentTransfer as Gsk.ComponentTransfer
import qualified GI.Gsk.Structs.Path as Gsk.Path
import qualified GI.Gsk.Structs.RoundedRect as Gsk.RoundedRect
import qualified GI.Gsk.Structs.Shadow as Gsk.Shadow
import qualified GI.Gsk.Structs.Stroke as Gsk.Stroke
import qualified GI.Gsk.Structs.Transform as Gsk.Transform
import qualified GI.Gtk.Callbacks as Gtk.Callbacks
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Flags as Gtk.Flags
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Accessible as Gtk.Accessible
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Buildable as Gtk.Buildable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.CellEditable as Gtk.CellEditable
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.ConstraintTarget as Gtk.ConstraintTarget
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Native as Gtk.Native
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.Root as Gtk.Root
import {-# SOURCE #-} qualified GI.Gtk.Interfaces.StyleProvider as Gtk.StyleProvider
import {-# SOURCE #-} qualified GI.Gtk.Objects.ATContext as Gtk.ATContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.CellRenderer as Gtk.CellRenderer
import {-# SOURCE #-} qualified GI.Gtk.Objects.EventController as Gtk.EventController
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutChild as Gtk.LayoutChild
import {-# SOURCE #-} qualified GI.Gtk.Objects.LayoutManager as Gtk.LayoutManager
import {-# SOURCE #-} qualified GI.Gtk.Objects.Settings as Gtk.Settings
import {-# SOURCE #-} qualified GI.Gtk.Objects.Snapshot as Gtk.Snapshot
import {-# SOURCE #-} qualified GI.Gtk.Objects.StyleContext as Gtk.StyleContext
import {-# SOURCE #-} qualified GI.Gtk.Objects.Tooltip as Gtk.Tooltip
import {-# SOURCE #-} qualified GI.Gtk.Objects.Widget as Gtk.Widget
import {-# SOURCE #-} qualified GI.Gtk.Structs.Border as Gtk.Border
import {-# SOURCE #-} qualified GI.Gtk.Structs.Requisition as Gtk.Requisition
import qualified GI.Pango.Enums as Pango.Enums
import qualified GI.Pango.Objects.Context as Pango.Context
import qualified GI.Pango.Objects.FontMap as Pango.FontMap
import qualified GI.Pango.Objects.Layout as Pango.Layout

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Objects.Texture as Gdk.Texture
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import {-# SOURCE #-} qualified GI.Gtk.Enums as Gtk.Enums
import {-# SOURCE #-} qualified GI.Gtk.Objects.CellRenderer as Gtk.CellRenderer

#endif

-- | Memory-managed wrapper type.
newtype CellRendererPixbuf = CellRendererPixbuf (SP.ManagedPtr CellRendererPixbuf)
    deriving (Eq)

instance SP.ManagedPtrNewtype CellRendererPixbuf where
    toManagedPtr (CellRendererPixbuf p) = p

foreign import ccall "gtk_cell_renderer_pixbuf_get_type"
    c_gtk_cell_renderer_pixbuf_get_type :: IO B.Types.GType

instance B.Types.TypedObject CellRendererPixbuf where
    glibType = c_gtk_cell_renderer_pixbuf_get_type

instance B.Types.GObject CellRendererPixbuf

-- | Type class for types which can be safely cast to t'CellRendererPixbuf', for instance with `toCellRendererPixbuf`.
class (SP.GObject o, O.IsDescendantOf CellRendererPixbuf o) => IsCellRendererPixbuf o
instance (SP.GObject o, O.IsDescendantOf CellRendererPixbuf o) => IsCellRendererPixbuf o

instance O.HasParentTypes CellRendererPixbuf
type instance O.ParentTypes CellRendererPixbuf = '[Gtk.CellRenderer.CellRenderer, GObject.Object.Object]

-- | Cast to t'CellRendererPixbuf', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toCellRendererPixbuf :: (MIO.MonadIO m, IsCellRendererPixbuf o) => o -> m CellRendererPixbuf
toCellRendererPixbuf = MIO.liftIO . B.ManagedPtr.unsafeCastTo CellRendererPixbuf

-- | Convert t'CellRendererPixbuf' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe CellRendererPixbuf) where
    gvalueGType_ = c_gtk_cell_renderer_pixbuf_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr CellRendererPixbuf)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr CellRendererPixbuf)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject CellRendererPixbuf ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveCellRendererPixbufMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveCellRendererPixbufMethod "activate" o = Gtk.CellRenderer.CellRendererActivateMethodInfo
    ResolveCellRendererPixbufMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveCellRendererPixbufMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveCellRendererPixbufMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveCellRendererPixbufMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveCellRendererPixbufMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveCellRendererPixbufMethod "isActivatable" o = Gtk.CellRenderer.CellRendererIsActivatableMethodInfo
    ResolveCellRendererPixbufMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveCellRendererPixbufMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveCellRendererPixbufMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveCellRendererPixbufMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveCellRendererPixbufMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveCellRendererPixbufMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveCellRendererPixbufMethod "snapshot" o = Gtk.CellRenderer.CellRendererSnapshotMethodInfo
    ResolveCellRendererPixbufMethod "startEditing" o = Gtk.CellRenderer.CellRendererStartEditingMethodInfo
    ResolveCellRendererPixbufMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveCellRendererPixbufMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveCellRendererPixbufMethod "stopEditing" o = Gtk.CellRenderer.CellRendererStopEditingMethodInfo
    ResolveCellRendererPixbufMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveCellRendererPixbufMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveCellRendererPixbufMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveCellRendererPixbufMethod "getAlignedArea" o = Gtk.CellRenderer.CellRendererGetAlignedAreaMethodInfo
    ResolveCellRendererPixbufMethod "getAlignment" o = Gtk.CellRenderer.CellRendererGetAlignmentMethodInfo
    ResolveCellRendererPixbufMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveCellRendererPixbufMethod "getFixedSize" o = Gtk.CellRenderer.CellRendererGetFixedSizeMethodInfo
    ResolveCellRendererPixbufMethod "getIsExpanded" o = Gtk.CellRenderer.CellRendererGetIsExpandedMethodInfo
    ResolveCellRendererPixbufMethod "getIsExpander" o = Gtk.CellRenderer.CellRendererGetIsExpanderMethodInfo
    ResolveCellRendererPixbufMethod "getPadding" o = Gtk.CellRenderer.CellRendererGetPaddingMethodInfo
    ResolveCellRendererPixbufMethod "getPreferredHeight" o = Gtk.CellRenderer.CellRendererGetPreferredHeightMethodInfo
    ResolveCellRendererPixbufMethod "getPreferredHeightForWidth" o = Gtk.CellRenderer.CellRendererGetPreferredHeightForWidthMethodInfo
    ResolveCellRendererPixbufMethod "getPreferredSize" o = Gtk.CellRenderer.CellRendererGetPreferredSizeMethodInfo
    ResolveCellRendererPixbufMethod "getPreferredWidth" o = Gtk.CellRenderer.CellRendererGetPreferredWidthMethodInfo
    ResolveCellRendererPixbufMethod "getPreferredWidthForHeight" o = Gtk.CellRenderer.CellRendererGetPreferredWidthForHeightMethodInfo
    ResolveCellRendererPixbufMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveCellRendererPixbufMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveCellRendererPixbufMethod "getRequestMode" o = Gtk.CellRenderer.CellRendererGetRequestModeMethodInfo
    ResolveCellRendererPixbufMethod "getSensitive" o = Gtk.CellRenderer.CellRendererGetSensitiveMethodInfo
    ResolveCellRendererPixbufMethod "getState" o = Gtk.CellRenderer.CellRendererGetStateMethodInfo
    ResolveCellRendererPixbufMethod "getVisible" o = Gtk.CellRenderer.CellRendererGetVisibleMethodInfo
    ResolveCellRendererPixbufMethod "setAlignment" o = Gtk.CellRenderer.CellRendererSetAlignmentMethodInfo
    ResolveCellRendererPixbufMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveCellRendererPixbufMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveCellRendererPixbufMethod "setFixedSize" o = Gtk.CellRenderer.CellRendererSetFixedSizeMethodInfo
    ResolveCellRendererPixbufMethod "setIsExpanded" o = Gtk.CellRenderer.CellRendererSetIsExpandedMethodInfo
    ResolveCellRendererPixbufMethod "setIsExpander" o = Gtk.CellRenderer.CellRendererSetIsExpanderMethodInfo
    ResolveCellRendererPixbufMethod "setPadding" o = Gtk.CellRenderer.CellRendererSetPaddingMethodInfo
    ResolveCellRendererPixbufMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveCellRendererPixbufMethod "setSensitive" o = Gtk.CellRenderer.CellRendererSetSensitiveMethodInfo
    ResolveCellRendererPixbufMethod "setVisible" o = Gtk.CellRenderer.CellRendererSetVisibleMethodInfo
    ResolveCellRendererPixbufMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveCellRendererPixbufMethod t CellRendererPixbuf, O.OverloadedMethod info CellRendererPixbuf p) => OL.IsLabel t (CellRendererPixbuf -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveCellRendererPixbufMethod t CellRendererPixbuf, O.OverloadedMethod info CellRendererPixbuf p, R.HasField t CellRendererPixbuf p) => R.HasField t CellRendererPixbuf p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveCellRendererPixbufMethod t CellRendererPixbuf, O.OverloadedMethodInfo info CellRendererPixbuf) => OL.IsLabel t (O.MethodProxy info CellRendererPixbuf) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "gicon"
   -- Type: TInterface (Name {namespace = "Gio", name = "Icon"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@gicon@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' cellRendererPixbuf #gicon
-- @
getCellRendererPixbufGicon :: (MonadIO m, IsCellRendererPixbuf o) => o -> m (Maybe Gio.Icon.Icon)
getCellRendererPixbufGicon obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "gicon" Gio.Icon.Icon

-- | Set the value of the “@gicon@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' cellRendererPixbuf [ #gicon 'Data.GI.Base.Attributes.:=' value ]
-- @
setCellRendererPixbufGicon :: (MonadIO m, IsCellRendererPixbuf o, Gio.Icon.IsIcon a) => o -> a -> m ()
setCellRendererPixbufGicon obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "gicon" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@gicon@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructCellRendererPixbufGicon :: (IsCellRendererPixbuf o, MIO.MonadIO m, Gio.Icon.IsIcon a) => a -> m (GValueConstruct o)
constructCellRendererPixbufGicon val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "gicon" (P.Just val)

-- | Set the value of the “@gicon@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #gicon
-- @
clearCellRendererPixbufGicon :: (MonadIO m, IsCellRendererPixbuf o) => o -> m ()
clearCellRendererPixbufGicon obj = liftIO $ B.Properties.setObjectPropertyObject obj "gicon" (Nothing :: Maybe Gio.Icon.Icon)

#if defined(ENABLE_OVERLOADING)
data CellRendererPixbufGiconPropertyInfo
instance AttrInfo CellRendererPixbufGiconPropertyInfo where
    type AttrAllowedOps CellRendererPixbufGiconPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint CellRendererPixbufGiconPropertyInfo = IsCellRendererPixbuf
    type AttrSetTypeConstraint CellRendererPixbufGiconPropertyInfo = Gio.Icon.IsIcon
    type AttrTransferTypeConstraint CellRendererPixbufGiconPropertyInfo = Gio.Icon.IsIcon
    type AttrTransferType CellRendererPixbufGiconPropertyInfo = Gio.Icon.Icon
    type AttrGetType CellRendererPixbufGiconPropertyInfo = (Maybe Gio.Icon.Icon)
    type AttrLabel CellRendererPixbufGiconPropertyInfo = "gicon"
    type AttrOrigin CellRendererPixbufGiconPropertyInfo = CellRendererPixbuf
    attrGet = getCellRendererPixbufGicon
    attrSet = setCellRendererPixbufGicon
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gio.Icon.Icon v
    attrConstruct = constructCellRendererPixbufGicon
    attrClear = clearCellRendererPixbufGicon
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CellRendererPixbuf.gicon"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CellRendererPixbuf.html#g:attr:gicon"
        })
#endif

-- VVV Prop "icon-name"
   -- Type: TBasicType TUTF8
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@icon-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' cellRendererPixbuf #iconName
-- @
getCellRendererPixbufIconName :: (MonadIO m, IsCellRendererPixbuf o) => o -> m (Maybe T.Text)
getCellRendererPixbufIconName obj = MIO.liftIO $ B.Properties.getObjectPropertyString obj "icon-name"

-- | Set the value of the “@icon-name@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' cellRendererPixbuf [ #iconName 'Data.GI.Base.Attributes.:=' value ]
-- @
setCellRendererPixbufIconName :: (MonadIO m, IsCellRendererPixbuf o) => o -> T.Text -> m ()
setCellRendererPixbufIconName obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyString obj "icon-name" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@icon-name@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructCellRendererPixbufIconName :: (IsCellRendererPixbuf o, MIO.MonadIO m) => T.Text -> m (GValueConstruct o)
constructCellRendererPixbufIconName val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyString "icon-name" (P.Just val)

-- | Set the value of the “@icon-name@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #iconName
-- @
clearCellRendererPixbufIconName :: (MonadIO m, IsCellRendererPixbuf o) => o -> m ()
clearCellRendererPixbufIconName obj = liftIO $ B.Properties.setObjectPropertyString obj "icon-name" (Nothing :: Maybe T.Text)

#if defined(ENABLE_OVERLOADING)
data CellRendererPixbufIconNamePropertyInfo
instance AttrInfo CellRendererPixbufIconNamePropertyInfo where
    type AttrAllowedOps CellRendererPixbufIconNamePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint CellRendererPixbufIconNamePropertyInfo = IsCellRendererPixbuf
    type AttrSetTypeConstraint CellRendererPixbufIconNamePropertyInfo = (~) T.Text
    type AttrTransferTypeConstraint CellRendererPixbufIconNamePropertyInfo = (~) T.Text
    type AttrTransferType CellRendererPixbufIconNamePropertyInfo = T.Text
    type AttrGetType CellRendererPixbufIconNamePropertyInfo = (Maybe T.Text)
    type AttrLabel CellRendererPixbufIconNamePropertyInfo = "icon-name"
    type AttrOrigin CellRendererPixbufIconNamePropertyInfo = CellRendererPixbuf
    attrGet = getCellRendererPixbufIconName
    attrSet = setCellRendererPixbufIconName
    attrPut = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructCellRendererPixbufIconName
    attrClear = clearCellRendererPixbufIconName
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CellRendererPixbuf.iconName"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CellRendererPixbuf.html#g:attr:iconName"
        })
#endif

-- VVV Prop "icon-size"
   -- Type: TInterface (Name {namespace = "Gtk", name = "IconSize"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@icon-size@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' cellRendererPixbuf #iconSize
-- @
getCellRendererPixbufIconSize :: (MonadIO m, IsCellRendererPixbuf o) => o -> m Gtk.Enums.IconSize
getCellRendererPixbufIconSize obj = MIO.liftIO $ B.Properties.getObjectPropertyEnum obj "icon-size"

-- | Set the value of the “@icon-size@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' cellRendererPixbuf [ #iconSize 'Data.GI.Base.Attributes.:=' value ]
-- @
setCellRendererPixbufIconSize :: (MonadIO m, IsCellRendererPixbuf o) => o -> Gtk.Enums.IconSize -> m ()
setCellRendererPixbufIconSize obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyEnum obj "icon-size" val

-- | Construct a t'GValueConstruct' with valid value for the “@icon-size@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructCellRendererPixbufIconSize :: (IsCellRendererPixbuf o, MIO.MonadIO m) => Gtk.Enums.IconSize -> m (GValueConstruct o)
constructCellRendererPixbufIconSize val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyEnum "icon-size" val

#if defined(ENABLE_OVERLOADING)
data CellRendererPixbufIconSizePropertyInfo
instance AttrInfo CellRendererPixbufIconSizePropertyInfo where
    type AttrAllowedOps CellRendererPixbufIconSizePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrPut]
    type AttrBaseTypeConstraint CellRendererPixbufIconSizePropertyInfo = IsCellRendererPixbuf
    type AttrSetTypeConstraint CellRendererPixbufIconSizePropertyInfo = (~) Gtk.Enums.IconSize
    type AttrTransferTypeConstraint CellRendererPixbufIconSizePropertyInfo = (~) Gtk.Enums.IconSize
    type AttrTransferType CellRendererPixbufIconSizePropertyInfo = Gtk.Enums.IconSize
    type AttrGetType CellRendererPixbufIconSizePropertyInfo = Gtk.Enums.IconSize
    type AttrLabel CellRendererPixbufIconSizePropertyInfo = "icon-size"
    type AttrOrigin CellRendererPixbufIconSizePropertyInfo = CellRendererPixbuf
    attrGet = getCellRendererPixbufIconSize
    attrSet = setCellRendererPixbufIconSize
    attrPut = setCellRendererPixbufIconSize
    attrTransfer _ v = do
        return v
    attrConstruct = constructCellRendererPixbufIconSize
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CellRendererPixbuf.iconSize"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CellRendererPixbuf.html#g:attr:iconSize"
        })
#endif

-- VVV Prop "pixbuf"
   -- Type: TInterface (Name {namespace = "GdkPixbuf", name = "Pixbuf"})
   -- Flags: [PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Set the value of the “@pixbuf@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' cellRendererPixbuf [ #pixbuf 'Data.GI.Base.Attributes.:=' value ]
-- @
setCellRendererPixbufPixbuf :: (MonadIO m, IsCellRendererPixbuf o, GdkPixbuf.Pixbuf.IsPixbuf a) => o -> a -> m ()
setCellRendererPixbufPixbuf obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "pixbuf" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@pixbuf@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructCellRendererPixbufPixbuf :: (IsCellRendererPixbuf o, MIO.MonadIO m, GdkPixbuf.Pixbuf.IsPixbuf a) => a -> m (GValueConstruct o)
constructCellRendererPixbufPixbuf val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "pixbuf" (P.Just val)

-- | Set the value of the “@pixbuf@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #pixbuf
-- @
clearCellRendererPixbufPixbuf :: (MonadIO m, IsCellRendererPixbuf o) => o -> m ()
clearCellRendererPixbufPixbuf obj = liftIO $ B.Properties.setObjectPropertyObject obj "pixbuf" (Nothing :: Maybe GdkPixbuf.Pixbuf.Pixbuf)

#if defined(ENABLE_OVERLOADING)
data CellRendererPixbufPixbufPropertyInfo
instance AttrInfo CellRendererPixbufPixbufPropertyInfo where
    type AttrAllowedOps CellRendererPixbufPixbufPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrClear]
    type AttrBaseTypeConstraint CellRendererPixbufPixbufPropertyInfo = IsCellRendererPixbuf
    type AttrSetTypeConstraint CellRendererPixbufPixbufPropertyInfo = GdkPixbuf.Pixbuf.IsPixbuf
    type AttrTransferTypeConstraint CellRendererPixbufPixbufPropertyInfo = GdkPixbuf.Pixbuf.IsPixbuf
    type AttrTransferType CellRendererPixbufPixbufPropertyInfo = GdkPixbuf.Pixbuf.Pixbuf
    type AttrGetType CellRendererPixbufPixbufPropertyInfo = ()
    type AttrLabel CellRendererPixbufPixbufPropertyInfo = "pixbuf"
    type AttrOrigin CellRendererPixbufPixbufPropertyInfo = CellRendererPixbuf
    attrGet = undefined
    attrSet = setCellRendererPixbufPixbuf
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo GdkPixbuf.Pixbuf.Pixbuf v
    attrConstruct = constructCellRendererPixbufPixbuf
    attrClear = clearCellRendererPixbufPixbuf
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CellRendererPixbuf.pixbuf"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CellRendererPixbuf.html#g:attr:pixbuf"
        })
#endif

-- VVV Prop "pixbuf-expander-closed"
   -- Type: TInterface (Name {namespace = "GdkPixbuf", name = "Pixbuf"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@pixbuf-expander-closed@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' cellRendererPixbuf #pixbufExpanderClosed
-- @
getCellRendererPixbufPixbufExpanderClosed :: (MonadIO m, IsCellRendererPixbuf o) => o -> m (Maybe GdkPixbuf.Pixbuf.Pixbuf)
getCellRendererPixbufPixbufExpanderClosed obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "pixbuf-expander-closed" GdkPixbuf.Pixbuf.Pixbuf

-- | Set the value of the “@pixbuf-expander-closed@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' cellRendererPixbuf [ #pixbufExpanderClosed 'Data.GI.Base.Attributes.:=' value ]
-- @
setCellRendererPixbufPixbufExpanderClosed :: (MonadIO m, IsCellRendererPixbuf o, GdkPixbuf.Pixbuf.IsPixbuf a) => o -> a -> m ()
setCellRendererPixbufPixbufExpanderClosed obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "pixbuf-expander-closed" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@pixbuf-expander-closed@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructCellRendererPixbufPixbufExpanderClosed :: (IsCellRendererPixbuf o, MIO.MonadIO m, GdkPixbuf.Pixbuf.IsPixbuf a) => a -> m (GValueConstruct o)
constructCellRendererPixbufPixbufExpanderClosed val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "pixbuf-expander-closed" (P.Just val)

-- | Set the value of the “@pixbuf-expander-closed@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #pixbufExpanderClosed
-- @
clearCellRendererPixbufPixbufExpanderClosed :: (MonadIO m, IsCellRendererPixbuf o) => o -> m ()
clearCellRendererPixbufPixbufExpanderClosed obj = liftIO $ B.Properties.setObjectPropertyObject obj "pixbuf-expander-closed" (Nothing :: Maybe GdkPixbuf.Pixbuf.Pixbuf)

#if defined(ENABLE_OVERLOADING)
data CellRendererPixbufPixbufExpanderClosedPropertyInfo
instance AttrInfo CellRendererPixbufPixbufExpanderClosedPropertyInfo where
    type AttrAllowedOps CellRendererPixbufPixbufExpanderClosedPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint CellRendererPixbufPixbufExpanderClosedPropertyInfo = IsCellRendererPixbuf
    type AttrSetTypeConstraint CellRendererPixbufPixbufExpanderClosedPropertyInfo = GdkPixbuf.Pixbuf.IsPixbuf
    type AttrTransferTypeConstraint CellRendererPixbufPixbufExpanderClosedPropertyInfo = GdkPixbuf.Pixbuf.IsPixbuf
    type AttrTransferType CellRendererPixbufPixbufExpanderClosedPropertyInfo = GdkPixbuf.Pixbuf.Pixbuf
    type AttrGetType CellRendererPixbufPixbufExpanderClosedPropertyInfo = (Maybe GdkPixbuf.Pixbuf.Pixbuf)
    type AttrLabel CellRendererPixbufPixbufExpanderClosedPropertyInfo = "pixbuf-expander-closed"
    type AttrOrigin CellRendererPixbufPixbufExpanderClosedPropertyInfo = CellRendererPixbuf
    attrGet = getCellRendererPixbufPixbufExpanderClosed
    attrSet = setCellRendererPixbufPixbufExpanderClosed
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo GdkPixbuf.Pixbuf.Pixbuf v
    attrConstruct = constructCellRendererPixbufPixbufExpanderClosed
    attrClear = clearCellRendererPixbufPixbufExpanderClosed
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CellRendererPixbuf.pixbufExpanderClosed"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CellRendererPixbuf.html#g:attr:pixbufExpanderClosed"
        })
#endif

-- VVV Prop "pixbuf-expander-open"
   -- Type: TInterface (Name {namespace = "GdkPixbuf", name = "Pixbuf"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@pixbuf-expander-open@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' cellRendererPixbuf #pixbufExpanderOpen
-- @
getCellRendererPixbufPixbufExpanderOpen :: (MonadIO m, IsCellRendererPixbuf o) => o -> m (Maybe GdkPixbuf.Pixbuf.Pixbuf)
getCellRendererPixbufPixbufExpanderOpen obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "pixbuf-expander-open" GdkPixbuf.Pixbuf.Pixbuf

-- | Set the value of the “@pixbuf-expander-open@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' cellRendererPixbuf [ #pixbufExpanderOpen 'Data.GI.Base.Attributes.:=' value ]
-- @
setCellRendererPixbufPixbufExpanderOpen :: (MonadIO m, IsCellRendererPixbuf o, GdkPixbuf.Pixbuf.IsPixbuf a) => o -> a -> m ()
setCellRendererPixbufPixbufExpanderOpen obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "pixbuf-expander-open" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@pixbuf-expander-open@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructCellRendererPixbufPixbufExpanderOpen :: (IsCellRendererPixbuf o, MIO.MonadIO m, GdkPixbuf.Pixbuf.IsPixbuf a) => a -> m (GValueConstruct o)
constructCellRendererPixbufPixbufExpanderOpen val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "pixbuf-expander-open" (P.Just val)

-- | Set the value of the “@pixbuf-expander-open@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #pixbufExpanderOpen
-- @
clearCellRendererPixbufPixbufExpanderOpen :: (MonadIO m, IsCellRendererPixbuf o) => o -> m ()
clearCellRendererPixbufPixbufExpanderOpen obj = liftIO $ B.Properties.setObjectPropertyObject obj "pixbuf-expander-open" (Nothing :: Maybe GdkPixbuf.Pixbuf.Pixbuf)

#if defined(ENABLE_OVERLOADING)
data CellRendererPixbufPixbufExpanderOpenPropertyInfo
instance AttrInfo CellRendererPixbufPixbufExpanderOpenPropertyInfo where
    type AttrAllowedOps CellRendererPixbufPixbufExpanderOpenPropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint CellRendererPixbufPixbufExpanderOpenPropertyInfo = IsCellRendererPixbuf
    type AttrSetTypeConstraint CellRendererPixbufPixbufExpanderOpenPropertyInfo = GdkPixbuf.Pixbuf.IsPixbuf
    type AttrTransferTypeConstraint CellRendererPixbufPixbufExpanderOpenPropertyInfo = GdkPixbuf.Pixbuf.IsPixbuf
    type AttrTransferType CellRendererPixbufPixbufExpanderOpenPropertyInfo = GdkPixbuf.Pixbuf.Pixbuf
    type AttrGetType CellRendererPixbufPixbufExpanderOpenPropertyInfo = (Maybe GdkPixbuf.Pixbuf.Pixbuf)
    type AttrLabel CellRendererPixbufPixbufExpanderOpenPropertyInfo = "pixbuf-expander-open"
    type AttrOrigin CellRendererPixbufPixbufExpanderOpenPropertyInfo = CellRendererPixbuf
    attrGet = getCellRendererPixbufPixbufExpanderOpen
    attrSet = setCellRendererPixbufPixbufExpanderOpen
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo GdkPixbuf.Pixbuf.Pixbuf v
    attrConstruct = constructCellRendererPixbufPixbufExpanderOpen
    attrClear = clearCellRendererPixbufPixbufExpanderOpen
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CellRendererPixbuf.pixbufExpanderOpen"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CellRendererPixbuf.html#g:attr:pixbufExpanderOpen"
        })
#endif

-- VVV Prop "texture"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Texture"})
   -- Flags: [PropertyReadable,PropertyWritable]
   -- Nullable: (Nothing,Nothing)

-- | Get the value of the “@texture@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' cellRendererPixbuf #texture
-- @
getCellRendererPixbufTexture :: (MonadIO m, IsCellRendererPixbuf o) => o -> m (Maybe Gdk.Texture.Texture)
getCellRendererPixbufTexture obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "texture" Gdk.Texture.Texture

-- | Set the value of the “@texture@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' cellRendererPixbuf [ #texture 'Data.GI.Base.Attributes.:=' value ]
-- @
setCellRendererPixbufTexture :: (MonadIO m, IsCellRendererPixbuf o, Gdk.Texture.IsTexture a) => o -> a -> m ()
setCellRendererPixbufTexture obj val = MIO.liftIO $ do
    B.Properties.setObjectPropertyObject obj "texture" (Just val)

-- | Construct a t'GValueConstruct' with valid value for the “@texture@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructCellRendererPixbufTexture :: (IsCellRendererPixbuf o, MIO.MonadIO m, Gdk.Texture.IsTexture a) => a -> m (GValueConstruct o)
constructCellRendererPixbufTexture val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "texture" (P.Just val)

-- | Set the value of the “@texture@” property to `Nothing`.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.clear' #texture
-- @
clearCellRendererPixbufTexture :: (MonadIO m, IsCellRendererPixbuf o) => o -> m ()
clearCellRendererPixbufTexture obj = liftIO $ B.Properties.setObjectPropertyObject obj "texture" (Nothing :: Maybe Gdk.Texture.Texture)

#if defined(ENABLE_OVERLOADING)
data CellRendererPixbufTexturePropertyInfo
instance AttrInfo CellRendererPixbufTexturePropertyInfo where
    type AttrAllowedOps CellRendererPixbufTexturePropertyInfo = '[ 'AttrSet, 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint CellRendererPixbufTexturePropertyInfo = IsCellRendererPixbuf
    type AttrSetTypeConstraint CellRendererPixbufTexturePropertyInfo = Gdk.Texture.IsTexture
    type AttrTransferTypeConstraint CellRendererPixbufTexturePropertyInfo = Gdk.Texture.IsTexture
    type AttrTransferType CellRendererPixbufTexturePropertyInfo = Gdk.Texture.Texture
    type AttrGetType CellRendererPixbufTexturePropertyInfo = (Maybe Gdk.Texture.Texture)
    type AttrLabel CellRendererPixbufTexturePropertyInfo = "texture"
    type AttrOrigin CellRendererPixbufTexturePropertyInfo = CellRendererPixbuf
    attrGet = getCellRendererPixbufTexture
    attrSet = setCellRendererPixbufTexture
    attrPut = undefined
    attrTransfer _ v = do
        unsafeCastTo Gdk.Texture.Texture v
    attrConstruct = constructCellRendererPixbufTexture
    attrClear = clearCellRendererPixbufTexture
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gtk.Objects.CellRendererPixbuf.texture"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gtk-4.0.11/docs/GI-Gtk-Objects-CellRendererPixbuf.html#g:attr:texture"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList CellRendererPixbuf
type instance O.AttributeList CellRendererPixbuf = CellRendererPixbufAttributeList
type CellRendererPixbufAttributeList = ('[ '("cellBackground", Gtk.CellRenderer.CellRendererCellBackgroundPropertyInfo), '("cellBackgroundRgba", Gtk.CellRenderer.CellRendererCellBackgroundRgbaPropertyInfo), '("cellBackgroundSet", Gtk.CellRenderer.CellRendererCellBackgroundSetPropertyInfo), '("editing", Gtk.CellRenderer.CellRendererEditingPropertyInfo), '("gicon", CellRendererPixbufGiconPropertyInfo), '("height", Gtk.CellRenderer.CellRendererHeightPropertyInfo), '("iconName", CellRendererPixbufIconNamePropertyInfo), '("iconSize", CellRendererPixbufIconSizePropertyInfo), '("isExpanded", Gtk.CellRenderer.CellRendererIsExpandedPropertyInfo), '("isExpander", Gtk.CellRenderer.CellRendererIsExpanderPropertyInfo), '("mode", Gtk.CellRenderer.CellRendererModePropertyInfo), '("pixbuf", CellRendererPixbufPixbufPropertyInfo), '("pixbufExpanderClosed", CellRendererPixbufPixbufExpanderClosedPropertyInfo), '("pixbufExpanderOpen", CellRendererPixbufPixbufExpanderOpenPropertyInfo), '("sensitive", Gtk.CellRenderer.CellRendererSensitivePropertyInfo), '("texture", CellRendererPixbufTexturePropertyInfo), '("visible", Gtk.CellRenderer.CellRendererVisiblePropertyInfo), '("width", Gtk.CellRenderer.CellRendererWidthPropertyInfo), '("xalign", Gtk.CellRenderer.CellRendererXalignPropertyInfo), '("xpad", Gtk.CellRenderer.CellRendererXpadPropertyInfo), '("yalign", Gtk.CellRenderer.CellRendererYalignPropertyInfo), '("ypad", Gtk.CellRenderer.CellRendererYpadPropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
cellRendererPixbufGicon :: AttrLabelProxy "gicon"
cellRendererPixbufGicon = AttrLabelProxy

cellRendererPixbufIconName :: AttrLabelProxy "iconName"
cellRendererPixbufIconName = AttrLabelProxy

cellRendererPixbufIconSize :: AttrLabelProxy "iconSize"
cellRendererPixbufIconSize = AttrLabelProxy

cellRendererPixbufPixbuf :: AttrLabelProxy "pixbuf"
cellRendererPixbufPixbuf = AttrLabelProxy

cellRendererPixbufPixbufExpanderClosed :: AttrLabelProxy "pixbufExpanderClosed"
cellRendererPixbufPixbufExpanderClosed = AttrLabelProxy

cellRendererPixbufPixbufExpanderOpen :: AttrLabelProxy "pixbufExpanderOpen"
cellRendererPixbufPixbufExpanderOpen = AttrLabelProxy

cellRendererPixbufTexture :: AttrLabelProxy "texture"
cellRendererPixbufTexture = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList CellRendererPixbuf = CellRendererPixbufSignalList
type CellRendererPixbufSignalList = ('[ '("editingCanceled", Gtk.CellRenderer.CellRendererEditingCanceledSignalInfo), '("editingStarted", Gtk.CellRenderer.CellRendererEditingStartedSignalInfo), '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method CellRendererPixbuf::new
-- method type : Constructor
-- Args: []
-- Lengths: []
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gtk" , name = "CellRendererPixbuf" })
-- throws : False
-- Skip return : False

foreign import ccall "gtk_cell_renderer_pixbuf_new" gtk_cell_renderer_pixbuf_new :: 
    IO (Ptr CellRendererPixbuf)

{-# DEPRECATED cellRendererPixbufNew ["(Since version 4.10)"] #-}
-- | Creates a new @GtkCellRendererPixbuf@. Adjust rendering
-- parameters using object properties. Object properties can be set
-- globally (with @/g_object_set()/@). Also, with @GtkTreeViewColumn@, you
-- can bind a property to a value in a @GtkTreeModel@. For example, you
-- can bind the “pixbuf” property on the cell renderer to a pixbuf value
-- in the model, thus rendering a different image in each row of the
-- @GtkTreeView@.
cellRendererPixbufNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m CellRendererPixbuf
    -- ^ __Returns:__ the new cell renderer
cellRendererPixbufNew  = liftIO $ do
    result <- gtk_cell_renderer_pixbuf_new
    checkUnexpectedReturnNULL "cellRendererPixbufNew" result
    result' <- (newObject CellRendererPixbuf) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif


