
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kaboutdata_wrapper.h"

// Argument includes
#include <QList>
#include <QString>
#include <kaboutdata.h>
#include <qbytearray.h>
#include <qobject.h>
#include <qobjectdefs.h>
#include <qurl.h>
#include <qvariant.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KAboutData_Type = nullptr;
static PyTypeObject *Sbk_KAboutData_TypeF(void)
{
    return _Sbk_KAboutData_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KAboutData_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KAboutData >()))
        return -1;

    ::KAboutData *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[9];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 9));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);
    if (numArgs == 4)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOOOOOO:KAboutData", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6]), &(pyArgs[7]), &(pyArgs[8])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KAboutData::KAboutData(KAboutData)
    // 1: KAboutData::KAboutData(const QString&=,const QString&=,const QString&=)
    // 2: KAboutData::KAboutData(QString,QString,QString,QString,KAboutLicense::LicenseKey,const QString&=,const QString&=,const QString&=,const QString&=)
    if (numArgs == 0) {
        overloadId = 1; // KAboutData(QString,QString,QString)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // KAboutData(QString,QString,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // KAboutData(QString,QString,QString)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 1; // KAboutData(QString,QString,QString)
                } else if (numArgs >= 5
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))
                    && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_LicenseKey_IDX])))->converter, (pyArgs[4])))) {
                    if (numArgs == 5) {
                        overloadId = 2; // KAboutData(QString,QString,QString,QString,KAboutLicense::LicenseKey,QString,QString,QString,QString)
                    } else if (numArgs >= 6
                        && (pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[5])))) {
                        if (numArgs == 6) {
                            overloadId = 2; // KAboutData(QString,QString,QString,QString,KAboutLicense::LicenseKey,QString,QString,QString,QString)
                        } else if (numArgs >= 7
                            && (pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[6])))) {
                            if (numArgs == 7) {
                                overloadId = 2; // KAboutData(QString,QString,QString,QString,KAboutLicense::LicenseKey,QString,QString,QString,QString)
                            } else if (numArgs >= 8
                                && (pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[7])))) {
                                if (numArgs == 8) {
                                    overloadId = 2; // KAboutData(QString,QString,QString,QString,KAboutLicense::LicenseKey,QString,QString,QString,QString)
                                } else if (numArgs >= 9
                                    && (pythonToCpp[8] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[8])))) {
                                    overloadId = 2; // KAboutData(QString,QString,QString,QString,KAboutLicense::LicenseKey,QString,QString,QString,QString)
                                }
                            }
                        }
                    }
                }
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KAboutData(KAboutData)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // KAboutData(const KAboutData &other)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::KAboutData cppArg0_local;
            ::KAboutData *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // KAboutData(KAboutData)
                cptr = new ::KAboutData(*cppArg0);
            }
            break;
        }
        case 1: // KAboutData(const QString &componentName, const QString &displayName, const QString &version)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[3] = {{"componentName", 0}, {"displayName", 1}, {"version", 2}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 3, errInfo, pyArgs)
                    || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0]))))
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);
                }
            }
            ::QString cppArg0{};
            if (pythonToCpp[0])
                pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1{};
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2{};
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KAboutData(QString,QString,QString)
                cptr = new ::KAboutData(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 2: // KAboutData(const QString &componentName, const QString &displayName, const QString &version, const QString &shortDescription, KAboutLicense::LicenseKey licenseType, const QString &copyrightStatement, const QString &otherText, const QString &homePageAddress, const QString &bugAddress)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[4] = {{"copyrightStatement", 5}, {"otherText", 6}, {"homePageAddress", 7}, {"bugAddress", 8}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 4, errInfo, pyArgs)
                    || (pyArgs[5] != nullptr && !(pythonToCpp[5] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[5]))))
                    || (pyArgs[6] != nullptr && !(pythonToCpp[6] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[6]))))
                    || (pyArgs[7] != nullptr && !(pythonToCpp[7] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[7]))))
                    || (pyArgs[8] != nullptr && !(pythonToCpp[8] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[8]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::KAboutLicense::LicenseKey cppArg4{KAboutLicense::Unknown};
            pythonToCpp[4](pyArgs[4], &cppArg4);
            ::QString cppArg5 = QString();
            if (pythonToCpp[5])
                pythonToCpp[5](pyArgs[5], &cppArg5);
            ::QString cppArg6 = QString();
            if (pythonToCpp[6])
                pythonToCpp[6](pyArgs[6], &cppArg6);
            ::QString cppArg7 = QString();
            if (pythonToCpp[7])
                pythonToCpp[7](pyArgs[7], &cppArg7);
            ::QString cppArg8 = QStringLiteral("submit@bugs.kde.org");
            if (pythonToCpp[8])
                pythonToCpp[8](pyArgs[8], &cppArg8);

            if (Shiboken::Errors::occurred() == nullptr) {
                // KAboutData(QString,QString,QString,QString,KAboutLicense::LicenseKey,QString,QString,QString,QString)
                cptr = new ::KAboutData(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4, cppArg5, cppArg6, cppArg7, cppArg8);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::KAboutData >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_KAboutDataFunc_aboutTranslationTeam(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // aboutTranslationTeam()
        QString cppResult = ::KAboutData::aboutTranslationTeam();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_addAuthor(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[5];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 5));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "addAuthor", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOO:addAuthor", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KAboutData::addAuthor(KAboutPerson)->KAboutData&
    // 1: KAboutData::addAuthor(QString,QString,QString,QString,QString)->KAboutData&
    // 2: KAboutData::addAuthor(QString,const QString&=,const QString&=,const QString&=,const QUrl&=)->KAboutData&
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // addAuthor(QString,QString,QString,QString,QUrl)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // addAuthor(QString,QString,QString,QString,QUrl)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 2; // addAuthor(QString,QString,QString,QString,QUrl)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 2; // addAuthor(QString,QString,QString,QString,QUrl)
                    } else if (numArgs == 5
                        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[4])))) {
                        overloadId = 1; // addAuthor(QString,QString,QString,QString,QString)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[4])))) {
                        overloadId = 2; // addAuthor(QString,QString,QString,QString,QUrl)
                    }
                }
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutPerson_IDX]), (pyArgs[0])))) {
        overloadId = 0; // addAuthor(KAboutPerson)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addAuthor", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // addAuthor(const KAboutPerson &author)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "addAuthor", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::KAboutPerson cppArg0_local;
            ::KAboutPerson *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // addAuthor(KAboutPerson)
                KAboutData & cppResult = cppSelf->addAuthor(*cppArg0);
                pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
            }
            break;
        }
        case 1: // addAuthor(const QString &name, const QString &task, const QString &emailAddress, const QString &webAddress, const QString &kdeStoreUsername)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "addAuthor", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QString cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);

            if (Shiboken::Errors::occurred() == nullptr) {
                // addAuthor(QString,QString,QString,QString,QString)
                KAboutData & cppResult = cppSelf->addAuthor(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
                pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
            }
            break;
        }
        case 2: // addAuthor(const QString &name, const QString &task, const QString &emailAddress, const QString &webAddress, const QUrl &avatarUrl)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[4] = {{"task", 1}, {"emailAddress", 2}, {"webAddress", 3}, {"avatarUrl", 4}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 4, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2]))))
                    || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3]))))
                    || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[4]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "addAuthor", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QString();
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2 = QString();
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3 = QString();
            if (pythonToCpp[3])
                pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return {};
            ::QUrl cppArg4_local = QUrl();
            ::QUrl *cppArg4 = &cppArg4_local;
            if (pythonToCpp[4]) {
                if (pythonToCpp[4].isValue())
                    pythonToCpp[4](pyArgs[4], &cppArg4_local);
                else
                    pythonToCpp[4](pyArgs[4], &cppArg4);
                }

            if (Shiboken::Errors::occurred() == nullptr) {
                // addAuthor(QString,QString,QString,QString,QUrl)
                KAboutData & cppResult = cppSelf->addAuthor(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4);
                pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_addComponent(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[5];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 5));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "addComponent", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOO:addComponent", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KAboutData::addComponent(KAboutComponent)->KAboutData&
    // 1: KAboutData::addComponent(QString,const QString&=,const QString&=,const QString&=,KAboutLicense::LicenseKey=)->KAboutData&
    // 2: KAboutData::addComponent(QString,QString,QString,QString,QString)->KAboutData&
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // addComponent(QString,QString,QString,QString,KAboutLicense::LicenseKey)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // addComponent(QString,QString,QString,QString,KAboutLicense::LicenseKey)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 1; // addComponent(QString,QString,QString,QString,KAboutLicense::LicenseKey)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 1; // addComponent(QString,QString,QString,QString,KAboutLicense::LicenseKey)
                    } else if (numArgs == 5
                        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[4])))) {
                        overloadId = 2; // addComponent(QString,QString,QString,QString,QString)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_LicenseKey_IDX])))->converter, (pyArgs[4])))) {
                        overloadId = 1; // addComponent(QString,QString,QString,QString,KAboutLicense::LicenseKey)
                    }
                }
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutComponent_IDX]), (pyArgs[0])))) {
        overloadId = 0; // addComponent(KAboutComponent)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addComponent", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // addComponent(const KAboutComponent &component)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "addComponent", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::KAboutComponent cppArg0_local;
            ::KAboutComponent *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // addComponent(KAboutComponent)
                KAboutData & cppResult = cppSelf->addComponent(*cppArg0);
                pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
            }
            break;
        }
        case 1: // addComponent(const QString &name, const QString &description, const QString &version, const QString &webAddress, KAboutLicense::LicenseKey licenseKey)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[4] = {{"description", 1}, {"version", 2}, {"webAddress", 3}, {"licenseKey", 4}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 4, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2]))))
                    || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3]))))
                    || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_LicenseKey_IDX])))->converter, (pyArgs[4]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "addComponent", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QString();
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2 = QString();
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3 = QString();
            if (pythonToCpp[3])
                pythonToCpp[3](pyArgs[3], &cppArg3);
            ::KAboutLicense::LicenseKey cppArg4(KAboutLicense::Unknown);
            if (pythonToCpp[4])
                pythonToCpp[4](pyArgs[4], &cppArg4);

            if (Shiboken::Errors::occurred() == nullptr) {
                // addComponent(QString,QString,QString,QString,KAboutLicense::LicenseKey)
                KAboutData & cppResult = cppSelf->addComponent(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
                pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
            }
            break;
        }
        case 2: // addComponent(const QString &name, const QString &description, const QString &version, const QString &webAddress, const QString &pathToLicenseFile)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "addComponent", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QString cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);

            if (Shiboken::Errors::occurred() == nullptr) {
                // addComponent(QString,QString,QString,QString,QString)
                KAboutData & cppResult = cppSelf->addComponent(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
                pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_addCredit(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[5];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 5));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "addCredit", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);

    if (PyArg_ParseTuple(args, "|OOOOO:addCredit", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KAboutData::addCredit(KAboutPerson)->KAboutData&
    // 1: KAboutData::addCredit(QString,QString,QString,QString,QString)->KAboutData&
    // 2: KAboutData::addCredit(QString,const QString&=,const QString&=,const QString&=,const QUrl&=)->KAboutData&
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // addCredit(QString,QString,QString,QString,QUrl)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // addCredit(QString,QString,QString,QString,QUrl)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 2; // addCredit(QString,QString,QString,QString,QUrl)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 2; // addCredit(QString,QString,QString,QString,QUrl)
                    } else if (numArgs == 5
                        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[4])))) {
                        overloadId = 1; // addCredit(QString,QString,QString,QString,QString)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[4])))) {
                        overloadId = 2; // addCredit(QString,QString,QString,QString,QUrl)
                    }
                }
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutPerson_IDX]), (pyArgs[0])))) {
        overloadId = 0; // addCredit(KAboutPerson)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addCredit", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // addCredit(const KAboutPerson &person)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "addCredit", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::KAboutPerson cppArg0_local;
            ::KAboutPerson *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // addCredit(KAboutPerson)
                KAboutData & cppResult = cppSelf->addCredit(*cppArg0);
                pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
            }
            break;
        }
        case 1: // addCredit(const QString &name, const QString &task, const QString &emailAddress, const QString &webAddress, const QString &kdeStoreUsername)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "addCredit", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);
            ::QString cppArg4;
            pythonToCpp[4](pyArgs[4], &cppArg4);

            if (Shiboken::Errors::occurred() == nullptr) {
                // addCredit(QString,QString,QString,QString,QString)
                KAboutData & cppResult = cppSelf->addCredit(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
                pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
            }
            break;
        }
        case 2: // addCredit(const QString &name, const QString &task, const QString &emailAddress, const QString &webAddress, const QUrl &avatarUrl)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[4] = {{"task", 1}, {"emailAddress", 2}, {"webAddress", 3}, {"avatarUrl", 4}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 4, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1]))))
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2]))))
                    || (pyArgs[3] != nullptr && !(pythonToCpp[3] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[3]))))
                    || (pyArgs[4] != nullptr && !(pythonToCpp[4] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[4]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "addCredit", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QString();
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2 = QString();
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3 = QString();
            if (pythonToCpp[3])
                pythonToCpp[3](pyArgs[3], &cppArg3);
            if (!Shiboken::Object::isValid(pyArgs[4]))
                return {};
            ::QUrl cppArg4_local = QUrl();
            ::QUrl *cppArg4 = &cppArg4_local;
            if (pythonToCpp[4]) {
                if (pythonToCpp[4].isValue())
                    pythonToCpp[4](pyArgs[4], &cppArg4_local);
                else
                    pythonToCpp[4](pyArgs[4], &cppArg4);
                }

            if (Shiboken::Errors::occurred() == nullptr) {
                // addCredit(QString,QString,QString,QString,QUrl)
                KAboutData & cppResult = cppSelf->addCredit(cppArg0, cppArg1, cppArg2, cppArg3, *cppArg4);
                pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_addLicense(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "addLicense", 1, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KAboutData::addLicense(KAboutLicense::LicenseKey)->KAboutData&
    // 1: KAboutData::addLicense(KAboutLicense::LicenseKey,KAboutLicense::VersionRestriction)->KAboutData&
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_LicenseKey_IDX])))->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // addLicense(KAboutLicense::LicenseKey)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_VersionRestriction_IDX])))->converter, (pyArgs[1])))) {
            overloadId = 1; // addLicense(KAboutLicense::LicenseKey,KAboutLicense::VersionRestriction)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addLicense", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // addLicense(KAboutLicense::LicenseKey licenseKey)
        {
            ::KAboutLicense::LicenseKey cppArg0{KAboutLicense::Unknown};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // addLicense(KAboutLicense::LicenseKey)
                KAboutData & cppResult = cppSelf->addLicense(cppArg0);
                pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
            }
            break;
        }
        case 1: // addLicense(KAboutLicense::LicenseKey licenseKey, KAboutLicense::VersionRestriction versionRestriction)
        {
            ::KAboutLicense::LicenseKey cppArg0{KAboutLicense::Unknown};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::KAboutLicense::VersionRestriction cppArg1{KAboutLicense::OnlyThisVersion};
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // addLicense(KAboutLicense::LicenseKey,KAboutLicense::VersionRestriction)
                KAboutData & cppResult = cppSelf->addLicense(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_addLicenseText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAboutData::addLicenseText(QString)->KAboutData&
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // addLicenseText(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "addLicenseText", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addLicenseText(QString)
            KAboutData & cppResult = cppSelf->addLicenseText(cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_addLicenseTextFile(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAboutData::addLicenseTextFile(QString)->KAboutData&
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // addLicenseTextFile(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "addLicenseTextFile", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addLicenseTextFile(QString)
            KAboutData & cppResult = cppSelf->addLicenseTextFile(cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_applicationData(PyObject *self)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // applicationData()
        KAboutData cppResult = ::KAboutData::applicationData();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_authors(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // authors()const
        QList<KAboutPerson> cppResult = const_cast<const ::KAboutData *>(cppSelf)->authors();
        pyResult = Shiboken::Conversions::copyToPython(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KAboutPerson_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_bugAddress(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // bugAddress()const
        QString cppResult = const_cast<const ::KAboutData *>(cppSelf)->bugAddress();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_componentName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // componentName()const
        QString cppResult = const_cast<const ::KAboutData *>(cppSelf)->componentName();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_components(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // components()const
        QList<KAboutComponent> cppResult = const_cast<const ::KAboutData *>(cppSelf)->components();
        pyResult = Shiboken::Conversions::copyToPython(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KAboutComponent_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_copyrightStatement(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // copyrightStatement()const
        QString cppResult = const_cast<const ::KAboutData *>(cppSelf)->copyrightStatement();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_credits(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // credits()const
        QList<KAboutPerson> cppResult = const_cast<const ::KAboutData *>(cppSelf)->credits();
        pyResult = Shiboken::Conversions::copyToPython(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KAboutPerson_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_customAuthorPlainText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // customAuthorPlainText()const
        QString cppResult = const_cast<const ::KAboutData *>(cppSelf)->customAuthorPlainText();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_customAuthorRichText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // customAuthorRichText()const
        QString cppResult = const_cast<const ::KAboutData *>(cppSelf)->customAuthorRichText();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_customAuthorTextEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // customAuthorTextEnabled()const
        bool cppResult = const_cast<const ::KAboutData *>(cppSelf)->customAuthorTextEnabled();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_desktopFileName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // desktopFileName()const
        QString cppResult = const_cast<const ::KAboutData *>(cppSelf)->desktopFileName();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_displayName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // displayName()const
        QString cppResult = const_cast<const ::KAboutData *>(cppSelf)->displayName();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_homepage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // homepage()const
        QString cppResult = const_cast<const ::KAboutData *>(cppSelf)->homepage();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_internalBugAddress(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // internalBugAddress()const
        const char * cppResult = const_cast<const ::KAboutData *>(cppSelf)->internalBugAddress();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_internalProductName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // internalProductName()const
        const char * cppResult = const_cast<const ::KAboutData *>(cppSelf)->internalProductName();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_internalProgramName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // internalProgramName()const
        const char * cppResult = const_cast<const ::KAboutData *>(cppSelf)->internalProgramName();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_internalVersion(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // internalVersion()const
        const char * cppResult = const_cast<const ::KAboutData *>(cppSelf)->internalVersion();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_licenses(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // licenses()const
        QList<KAboutLicense> cppResult = const_cast<const ::KAboutData *>(cppSelf)->licenses();
        pyResult = Shiboken::Conversions::copyToPython(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KAboutLicense_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_organizationDomain(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // organizationDomain()const
        QString cppResult = const_cast<const ::KAboutData *>(cppSelf)->organizationDomain();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_otherText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // otherText()const
        QString cppResult = const_cast<const ::KAboutData *>(cppSelf)->otherText();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_processCommandLine(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAboutData::processCommandLine(QCommandLineParser*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QCommandLineParser_IDX]), (pyArg)))) {
        overloadId = 0; // processCommandLine(QCommandLineParser*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "processCommandLine", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QCommandLineParser *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // processCommandLine(QCommandLineParser*)
            cppSelf->processCommandLine(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KAboutDataFunc_productName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // productName()const
        QString cppResult = const_cast<const ::KAboutData *>(cppSelf)->productName();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_programLogo(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // programLogo()const
        QVariant cppResult = const_cast<const ::KAboutData *>(cppSelf)->programLogo();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_setApplicationData(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KAboutData::setApplicationData(KAboutData)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), (pyArg)))) {
        overloadId = 0; // setApplicationData(KAboutData)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setApplicationData", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KAboutData cppArg0_local;
        ::KAboutData *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setApplicationData(KAboutData)
            ::KAboutData::setApplicationData(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KAboutDataFunc_setBugAddress(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAboutData::setBugAddress(QByteArray)->KAboutData&
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), (pyArg)))) {
        overloadId = 0; // setBugAddress(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setBugAddress", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setBugAddress(QByteArray)
            KAboutData & cppResult = cppSelf->setBugAddress(*cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_setComponentName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAboutData::setComponentName(QString)->KAboutData&
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setComponentName(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setComponentName", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setComponentName(QString)
            KAboutData & cppResult = cppSelf->setComponentName(cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_setCopyrightStatement(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAboutData::setCopyrightStatement(QString)->KAboutData&
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setCopyrightStatement(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setCopyrightStatement", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setCopyrightStatement(QString)
            KAboutData & cppResult = cppSelf->setCopyrightStatement(cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_setCustomAuthorText(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setCustomAuthorText", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KAboutData::setCustomAuthorText(QString,QString)->KAboutData&
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // setCustomAuthorText(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setCustomAuthorText", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setCustomAuthorText(QString,QString)
            KAboutData & cppResult = cppSelf->setCustomAuthorText(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_setDesktopFileName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAboutData::setDesktopFileName(QString)->KAboutData&
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setDesktopFileName(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setDesktopFileName", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setDesktopFileName(QString)
            KAboutData & cppResult = cppSelf->setDesktopFileName(cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_setDisplayName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAboutData::setDisplayName(QString)->KAboutData&
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setDisplayName(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setDisplayName", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setDisplayName(QString)
            KAboutData & cppResult = cppSelf->setDisplayName(cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_setHomepage(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAboutData::setHomepage(QString)->KAboutData&
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setHomepage(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setHomepage", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setHomepage(QString)
            KAboutData & cppResult = cppSelf->setHomepage(cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_setLicense(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setLicense", 1, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KAboutData::setLicense(KAboutLicense::LicenseKey)->KAboutData&
    // 1: KAboutData::setLicense(KAboutLicense::LicenseKey,KAboutLicense::VersionRestriction)->KAboutData&
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_LicenseKey_IDX])))->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setLicense(KAboutLicense::LicenseKey)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutLicense_VersionRestriction_IDX])))->converter, (pyArgs[1])))) {
            overloadId = 1; // setLicense(KAboutLicense::LicenseKey,KAboutLicense::VersionRestriction)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setLicense", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // setLicense(KAboutLicense::LicenseKey licenseKey)
        {
            ::KAboutLicense::LicenseKey cppArg0{KAboutLicense::Unknown};
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // setLicense(KAboutLicense::LicenseKey)
                KAboutData & cppResult = cppSelf->setLicense(cppArg0);
                pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
            }
            break;
        }
        case 1: // setLicense(KAboutLicense::LicenseKey licenseKey, KAboutLicense::VersionRestriction versionRestriction)
        {
            ::KAboutLicense::LicenseKey cppArg0{KAboutLicense::Unknown};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::KAboutLicense::VersionRestriction cppArg1{KAboutLicense::OnlyThisVersion};
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (Shiboken::Errors::occurred() == nullptr) {
                // setLicense(KAboutLicense::LicenseKey,KAboutLicense::VersionRestriction)
                KAboutData & cppResult = cppSelf->setLicense(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_setLicenseText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAboutData::setLicenseText(QString)->KAboutData&
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setLicenseText(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setLicenseText", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setLicenseText(QString)
            KAboutData & cppResult = cppSelf->setLicenseText(cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_setLicenseTextFile(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAboutData::setLicenseTextFile(QString)->KAboutData&
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setLicenseTextFile(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setLicenseTextFile", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setLicenseTextFile(QString)
            KAboutData & cppResult = cppSelf->setLicenseTextFile(cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_setOrganizationDomain(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAboutData::setOrganizationDomain(QByteArray)->KAboutData&
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), (pyArg)))) {
        overloadId = 0; // setOrganizationDomain(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setOrganizationDomain", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setOrganizationDomain(QByteArray)
            KAboutData & cppResult = cppSelf->setOrganizationDomain(*cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_setOtherText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAboutData::setOtherText(QString)->KAboutData&
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setOtherText(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setOtherText", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setOtherText(QString)
            KAboutData & cppResult = cppSelf->setOtherText(cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_setProductName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAboutData::setProductName(QByteArray)->KAboutData&
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), (pyArg)))) {
        overloadId = 0; // setProductName(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setProductName", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setProductName(QByteArray)
            KAboutData & cppResult = cppSelf->setProductName(*cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_setProgramLogo(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAboutData::setProgramLogo(QVariant)->KAboutData&
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], (pyArg)))) {
        overloadId = 0; // setProgramLogo(QVariant)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setProgramLogo", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);

    // Call function/method
    {
        ::QVariant cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setProgramLogo(QVariant)
            KAboutData & cppResult = cppSelf->setProgramLogo(cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_setShortDescription(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAboutData::setShortDescription(QString)->KAboutData&
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // setShortDescription(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setShortDescription", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setShortDescription(QString)
            KAboutData & cppResult = cppSelf->setShortDescription(cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_setTranslator(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setTranslator", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KAboutData::setTranslator(QString,QString)->KAboutData&
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // setTranslator(QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setTranslator", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setTranslator(QString,QString)
            KAboutData & cppResult = cppSelf->setTranslator(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_setVersion(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAboutData::setVersion(QByteArray)->KAboutData&
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), (pyArg)))) {
        overloadId = 0; // setVersion(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setVersion", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setVersion(QByteArray)
            KAboutData & cppResult = cppSelf->setVersion(*cppArg0);
            pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_setupCommandLine(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KAboutData::setupCommandLine(QCommandLineParser*)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QCommandLineParser_IDX]), (pyArg)))) {
        overloadId = 0; // setupCommandLine(QCommandLineParser*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setupCommandLine", errInfo, SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QCommandLineParser *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setupCommandLine(QCommandLineParser*)
            bool cppResult = cppSelf->setupCommandLine(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_shortDescription(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // shortDescription()const
        QString cppResult = const_cast<const ::KAboutData *>(cppSelf)->shortDescription();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_translators(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // translators()const
        QList<KAboutPerson> cppResult = const_cast<const ::KAboutData *>(cppSelf)->translators();
        pyResult = Shiboken::Conversions::copyToPython(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KAboutPerson_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_unsetCustomAuthorText(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // unsetCustomAuthorText()
        KAboutData & cppResult = cppSelf->unsetCustomAuthorText();
        pyResult = Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutDataFunc_version(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // version()const
        QString cppResult = const_cast<const ::KAboutData *>(cppSelf)->version();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KAboutData__copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), &cppSelf);
    if (Shiboken::Errors::occurred() != nullptr || pyResult == nullptr) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_KAboutData_PropertyStrings[] = {
    "authors:",
    "bugAddress:",
    "componentName:",
    "components:",
    "copyrightStatement:",
    "credits:",
    "desktopFileName:",
    "displayName:",
    "homepage:",
    "licenses:",
    "otherText:",
    "productName:",
    "programLogo:",
    "shortDescription:",
    "translators:",
    "version:",
    nullptr // Sentinel
};

static PyMethodDef Sbk_KAboutData_methods[] = {
    {"aboutTranslationTeam", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_aboutTranslationTeam), METH_NOARGS|METH_STATIC, nullptr},
    {"addAuthor", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_addAuthor), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"addComponent", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_addComponent), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"addCredit", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_addCredit), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"addLicense", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_addLicense), METH_VARARGS, nullptr},
    {"addLicenseText", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_addLicenseText), METH_O, nullptr},
    {"addLicenseTextFile", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_addLicenseTextFile), METH_O, nullptr},
    {"applicationData", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_applicationData), METH_NOARGS|METH_STATIC, nullptr},
    {"authors", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_authors), METH_NOARGS, nullptr},
    {"bugAddress", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_bugAddress), METH_NOARGS, nullptr},
    {"componentName", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_componentName), METH_NOARGS, nullptr},
    {"components", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_components), METH_NOARGS, nullptr},
    {"copyrightStatement", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_copyrightStatement), METH_NOARGS, nullptr},
    {"credits", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_credits), METH_NOARGS, nullptr},
    {"customAuthorPlainText", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_customAuthorPlainText), METH_NOARGS, nullptr},
    {"customAuthorRichText", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_customAuthorRichText), METH_NOARGS, nullptr},
    {"customAuthorTextEnabled", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_customAuthorTextEnabled), METH_NOARGS, nullptr},
    {"desktopFileName", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_desktopFileName), METH_NOARGS, nullptr},
    {"displayName", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_displayName), METH_NOARGS, nullptr},
    {"homepage", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_homepage), METH_NOARGS, nullptr},
    {"internalBugAddress", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_internalBugAddress), METH_NOARGS, nullptr},
    {"internalProductName", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_internalProductName), METH_NOARGS, nullptr},
    {"internalProgramName", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_internalProgramName), METH_NOARGS, nullptr},
    {"internalVersion", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_internalVersion), METH_NOARGS, nullptr},
    {"licenses", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_licenses), METH_NOARGS, nullptr},
    {"organizationDomain", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_organizationDomain), METH_NOARGS, nullptr},
    {"otherText", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_otherText), METH_NOARGS, nullptr},
    {"processCommandLine", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_processCommandLine), METH_O, nullptr},
    {"productName", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_productName), METH_NOARGS, nullptr},
    {"programLogo", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_programLogo), METH_NOARGS, nullptr},
    {"setApplicationData", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_setApplicationData), METH_O|METH_STATIC, nullptr},
    {"setBugAddress", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_setBugAddress), METH_O, nullptr},
    {"setComponentName", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_setComponentName), METH_O, nullptr},
    {"setCopyrightStatement", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_setCopyrightStatement), METH_O, nullptr},
    {"setCustomAuthorText", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_setCustomAuthorText), METH_VARARGS, nullptr},
    {"setDesktopFileName", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_setDesktopFileName), METH_O, nullptr},
    {"setDisplayName", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_setDisplayName), METH_O, nullptr},
    {"setHomepage", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_setHomepage), METH_O, nullptr},
    {"setLicense", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_setLicense), METH_VARARGS, nullptr},
    {"setLicenseText", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_setLicenseText), METH_O, nullptr},
    {"setLicenseTextFile", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_setLicenseTextFile), METH_O, nullptr},
    {"setOrganizationDomain", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_setOrganizationDomain), METH_O, nullptr},
    {"setOtherText", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_setOtherText), METH_O, nullptr},
    {"setProductName", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_setProductName), METH_O, nullptr},
    {"setProgramLogo", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_setProgramLogo), METH_O, nullptr},
    {"setShortDescription", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_setShortDescription), METH_O, nullptr},
    {"setTranslator", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_setTranslator), METH_VARARGS, nullptr},
    {"setVersion", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_setVersion), METH_O, nullptr},
    {"setupCommandLine", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_setupCommandLine), METH_O, nullptr},
    {"shortDescription", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_shortDescription), METH_NOARGS, nullptr},
    {"translators", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_translators), METH_NOARGS, nullptr},
    {"unsetCustomAuthorText", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_unsetCustomAuthorText), METH_NOARGS, nullptr},
    {"version", reinterpret_cast<PyCFunction>(Sbk_KAboutDataFunc_version), METH_NOARGS, nullptr},
    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_KAboutData__copy__), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KAboutData_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KAboutData_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KAboutData_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KAboutData_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KAboutData_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KAboutData_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KAboutData_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KAboutData_spec = {
    "1:KCoreAddons.KAboutData",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KAboutData_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KAboutData_PythonToCpp_KAboutData_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KAboutData_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KAboutData_PythonToCpp_KAboutData_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KAboutData_TypeF()))
        return KAboutData_PythonToCpp_KAboutData_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KAboutData_PTR_CppToPython_KAboutData(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_KAboutData_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_KAboutData_TypeF(), const_cast<void *>(cppIn), false);

}

// C++ to Python copy conversion.
static PyObject *KAboutData_COPY_CppToPython_KAboutData(const void *cppIn)
{
    auto *source = reinterpret_cast<const ::KAboutData *>(cppIn);
    return Shiboken::Object::newObject(Sbk_KAboutData_TypeF(), new ::KAboutData(*source), true, true);
}

// Python to C++ copy conversion.
static void KAboutData_PythonToCpp_KAboutData_COPY(PyObject *pyIn, void *cppOut)
{
    *reinterpret_cast<::KAboutData *>(cppOut) = *reinterpret_cast< ::KAboutData *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX]), reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_KAboutData_PythonToCpp_KAboutData_COPY_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Sbk_KAboutData_TypeF()))
        return KAboutData_PythonToCpp_KAboutData_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KAboutData_SignatureStrings[] = {
    "2:KCoreAddons.KAboutData(self,other:KCoreAddons.KAboutData,*:KeywordOnly=None,displayName:QString=None,productName:QString=None,componentName:QString=None,programLogo:QVariant=None,shortDescription:QString=None,homepage:QString=None,bugAddress:QString=None,version:QString=None,otherText:QString=None,authors:QList[KCoreAddons.KAboutPerson]=None,credits:QList[KCoreAddons.KAboutPerson]=None,translators:QList[KCoreAddons.KAboutPerson]=None,components:QList[KCoreAddons.KAboutComponent]=None,licenses:QList[KCoreAddons.KAboutLicense]=None,copyrightStatement:QString=None,desktopFileName:QString=None)",
    "1:KCoreAddons.KAboutData(self,componentName:QString={},displayName:QString={},version:QString={},*:KeywordOnly=None,displayName:QString=None,productName:QString=None,componentName:QString=None,programLogo:QVariant=None,shortDescription:QString=None,homepage:QString=None,bugAddress:QString=None,version:QString=None,otherText:QString=None,authors:QList[KCoreAddons.KAboutPerson]=None,credits:QList[KCoreAddons.KAboutPerson]=None,translators:QList[KCoreAddons.KAboutPerson]=None,components:QList[KCoreAddons.KAboutComponent]=None,licenses:QList[KCoreAddons.KAboutLicense]=None,copyrightStatement:QString=None,desktopFileName:QString=None)",
    R"CPP(0:KCoreAddons.KAboutData(self,componentName:QString,displayName:QString,version:QString,shortDescription:QString,licenseType:KCoreAddons.KAboutLicense.LicenseKey,copyrightStatement:QString=QString(),otherText:QString=QString(),homePageAddress:QString=QString(),bugAddress:QString=QStringLiteral("submit@bugs.kde.org"),*:KeywordOnly=None,displayName:QString=None,productName:QString=None,componentName:QString=None,programLogo:QVariant=None,shortDescription:QString=None,homepage:QString=None,bugAddress:QString=None,version:QString=None,otherText:QString=None,authors:QList[KCoreAddons.KAboutPerson]=None,credits:QList[KCoreAddons.KAboutPerson]=None,translators:QList[KCoreAddons.KAboutPerson]=None,components:QList[KCoreAddons.KAboutComponent]=None,licenses:QList[KCoreAddons.KAboutLicense]=None,copyrightStatement:QString=None,desktopFileName:QString=None))CPP",
    "KCoreAddons.KAboutData.aboutTranslationTeam()->QString",
    "2:KCoreAddons.KAboutData.addAuthor(self,author:KCoreAddons.KAboutPerson)->KCoreAddons.KAboutData",
    "1:KCoreAddons.KAboutData.addAuthor(self,name:QString,task:QString,emailAddress:QString,webAddress:QString,kdeStoreUsername:QString)->KCoreAddons.KAboutData",
    "0:KCoreAddons.KAboutData.addAuthor(self,name:QString,task:QString=QString(),emailAddress:QString=QString(),webAddress:QString=QString(),avatarUrl:typing.Union[PySide6.QtCore.QUrl, QString]=QUrl())->KCoreAddons.KAboutData",
    "2:KCoreAddons.KAboutData.addComponent(self,component:KCoreAddons.KAboutComponent)->KCoreAddons.KAboutData",
    "1:KCoreAddons.KAboutData.addComponent(self,name:QString,description:QString=QString(),version:QString=QString(),webAddress:QString=QString(),licenseKey:KCoreAddons.KAboutLicense.LicenseKey=KAboutLicense.Unknown)->KCoreAddons.KAboutData",
    "0:KCoreAddons.KAboutData.addComponent(self,name:QString,description:QString,version:QString,webAddress:QString,pathToLicenseFile:QString)->KCoreAddons.KAboutData",
    "2:KCoreAddons.KAboutData.addCredit(self,person:KCoreAddons.KAboutPerson)->KCoreAddons.KAboutData",
    "1:KCoreAddons.KAboutData.addCredit(self,name:QString,task:QString,emailAddress:QString,webAddress:QString,kdeStoreUsername:QString)->KCoreAddons.KAboutData",
    "0:KCoreAddons.KAboutData.addCredit(self,name:QString,task:QString=QString(),emailAddress:QString=QString(),webAddress:QString=QString(),avatarUrl:typing.Union[PySide6.QtCore.QUrl, QString]=QUrl())->KCoreAddons.KAboutData",
    "1:KCoreAddons.KAboutData.addLicense(self,licenseKey:KCoreAddons.KAboutLicense.LicenseKey)->KCoreAddons.KAboutData",
    "0:KCoreAddons.KAboutData.addLicense(self,licenseKey:KCoreAddons.KAboutLicense.LicenseKey,versionRestriction:KCoreAddons.KAboutLicense.VersionRestriction)->KCoreAddons.KAboutData",
    "KCoreAddons.KAboutData.addLicenseText(self,license:QString)->KCoreAddons.KAboutData",
    "KCoreAddons.KAboutData.addLicenseTextFile(self,file:QString)->KCoreAddons.KAboutData",
    "KCoreAddons.KAboutData.applicationData()->KCoreAddons.KAboutData",
    "KCoreAddons.KAboutData.authors(self)->QList[KCoreAddons.KAboutPerson]",
    "KCoreAddons.KAboutData.bugAddress(self)->QString",
    "KCoreAddons.KAboutData.componentName(self)->QString",
    "KCoreAddons.KAboutData.components(self)->QList[KCoreAddons.KAboutComponent]",
    "KCoreAddons.KAboutData.copyrightStatement(self)->QString",
    "KCoreAddons.KAboutData.credits(self)->QList[KCoreAddons.KAboutPerson]",
    "KCoreAddons.KAboutData.customAuthorPlainText(self)->QString",
    "KCoreAddons.KAboutData.customAuthorRichText(self)->QString",
    "KCoreAddons.KAboutData.customAuthorTextEnabled(self)->bool",
    "KCoreAddons.KAboutData.desktopFileName(self)->QString",
    "KCoreAddons.KAboutData.displayName(self)->QString",
    "KCoreAddons.KAboutData.homepage(self)->QString",
    "KCoreAddons.KAboutData.internalBugAddress(self)->char*",
    "KCoreAddons.KAboutData.internalProductName(self)->char*",
    "KCoreAddons.KAboutData.internalProgramName(self)->char*",
    "KCoreAddons.KAboutData.internalVersion(self)->char*",
    "KCoreAddons.KAboutData.licenses(self)->QList[KCoreAddons.KAboutLicense]",
    "KCoreAddons.KAboutData.organizationDomain(self)->QString",
    "KCoreAddons.KAboutData.otherText(self)->QString",
    "KCoreAddons.KAboutData.processCommandLine(self,parser:PySide6.QtCore.QCommandLineParser)",
    "KCoreAddons.KAboutData.productName(self)->QString",
    "KCoreAddons.KAboutData.programLogo(self)->QVariant",
    "KCoreAddons.KAboutData.setApplicationData(aboutData:KCoreAddons.KAboutData)",
    "KCoreAddons.KAboutData.setBugAddress(self,bugAddress:typing.Union[PySide6.QtCore.QByteArray, char*])->KCoreAddons.KAboutData",
    "KCoreAddons.KAboutData.setComponentName(self,componentName:QString)->KCoreAddons.KAboutData",
    "KCoreAddons.KAboutData.setCopyrightStatement(self,copyrightStatement:QString)->KCoreAddons.KAboutData",
    "KCoreAddons.KAboutData.setCustomAuthorText(self,plainText:QString,richText:QString)->KCoreAddons.KAboutData",
    "KCoreAddons.KAboutData.setDesktopFileName(self,desktopFileName:QString)->KCoreAddons.KAboutData",
    "KCoreAddons.KAboutData.setDisplayName(self,displayName:QString)->KCoreAddons.KAboutData",
    "KCoreAddons.KAboutData.setHomepage(self,homepage:QString)->KCoreAddons.KAboutData",
    "1:KCoreAddons.KAboutData.setLicense(self,licenseKey:KCoreAddons.KAboutLicense.LicenseKey)->KCoreAddons.KAboutData",
    "0:KCoreAddons.KAboutData.setLicense(self,licenseKey:KCoreAddons.KAboutLicense.LicenseKey,versionRestriction:KCoreAddons.KAboutLicense.VersionRestriction)->KCoreAddons.KAboutData",
    "KCoreAddons.KAboutData.setLicenseText(self,license:QString)->KCoreAddons.KAboutData",
    "KCoreAddons.KAboutData.setLicenseTextFile(self,file:QString)->KCoreAddons.KAboutData",
    "KCoreAddons.KAboutData.setOrganizationDomain(self,domain:typing.Union[PySide6.QtCore.QByteArray, char*])->KCoreAddons.KAboutData",
    "KCoreAddons.KAboutData.setOtherText(self,otherText:QString)->KCoreAddons.KAboutData",
    "KCoreAddons.KAboutData.setProductName(self,name:typing.Union[PySide6.QtCore.QByteArray, char*])->KCoreAddons.KAboutData",
    "KCoreAddons.KAboutData.setProgramLogo(self,image:QVariant)->KCoreAddons.KAboutData",
    "KCoreAddons.KAboutData.setShortDescription(self,shortDescription:QString)->KCoreAddons.KAboutData",
    "KCoreAddons.KAboutData.setTranslator(self,name:QString,emailAddress:QString)->KCoreAddons.KAboutData",
    "KCoreAddons.KAboutData.setVersion(self,version:typing.Union[PySide6.QtCore.QByteArray, char*])->KCoreAddons.KAboutData",
    "KCoreAddons.KAboutData.setupCommandLine(self,parser:PySide6.QtCore.QCommandLineParser)->bool",
    "KCoreAddons.KAboutData.shortDescription(self)->QString",
    "KCoreAddons.KAboutData.translators(self)->QList[KCoreAddons.KAboutPerson]",
    "KCoreAddons.KAboutData.unsetCustomAuthorText(self)->KCoreAddons.KAboutData",
    "KCoreAddons.KAboutData.version(self)->QString",
    "KCoreAddons.KAboutData.__copy__(self)->typing._Self",
    nullptr}; // Sentinel
#else
static constexpr size_t KAboutData_SignatureByteSize = 1069;
static constexpr uint8_t KAboutData_SignatureBytes[1069] = {
    0x78, 0xda, 0xed, 0x58, 0xcd, 0x4f, 0xdb, 0x30, 0x14, 0xbf, 0xf3, 0x57, 0x20, 0x4e, 0x2d, 0xea,
    0x22, 0xc6, 0x61, 0x87, 0x48, 0x4c, 0x2b, 0xb0, 0x69, 0x12, 0x15, 0xb4, 0x6b, 0xcb, 0x05, 0xa1,
    0xca, 0x4d, 0x4c, 0x6b, 0x35, 0xb1, 0x23, 0xdb, 0x85, 0x65, 0xd3, 0xfe, 0xf7, 0x39, 0x89, 0x93,
    0x26, 0x8e, 0x9d, 0xaf, 0x02, 0xe2, 0xd0, 0x53, 0x5a, 0xdb, 0xef, 0xc3, 0xef, 0xfd, 0xde, 0x97,
    0xcf, 0xed, 0x9b, 0x2b, 0x42, 0xe1, 0xd0, 0x75, 0x09, 0x66, 0xd6, 0xcd, 0x70, 0x49, 0xb6, 0xfc,
    0x1a, 0x70, 0xd0, 0x63, 0xd0, 0x7b, 0x1a, 0x10, 0xbe, 0x86, 0xd4, 0x70, 0x62, 0x70, 0x6a, 0xdf,
    0xc0, 0xf0, 0x85, 0x50, 0xf7, 0x0e, 0x7b, 0xe1, 0xc5, 0x2d, 0xc1, 0x70, 0xe0, 0x22, 0x16, 0x78,
    0x20, 0xbc, 0x05, 0x3e, 0xb4, 0x27, 0x53, 0x4e, 0x11, 0x5e, 0x25, 0x1b, 0x01, 0x25, 0xee, 0xd6,
    0xe1, 0xe5, 0x0d, 0x87, 0xf8, 0x81, 0xf8, 0x62, 0xae, 0xa5, 0x59, 0x51, 0xe0, 0x8f, 0xc8, 0x8a,
    0xd8, 0x93, 0x7b, 0x40, 0x11, 0xc0, 0x3c, 0xd9, 0x61, 0x6b, 0x42, 0xf9, 0x35, 0x64, 0x0e, 0x45,
    0x01, 0x47, 0x04, 0x17, 0xe9, 0xd6, 0xc4, 0x87, 0x01, 0x58, 0x29, 0xdc, 0x96, 0xdb, 0x95, 0xb8,
    0x02, 0x85, 0x8c, 0x15, 0xd7, 0x9f, 0x21, 0x65, 0x25, 0x16, 0xf1, 0xbd, 0x67, 0xf0, 0x37, 0x2f,
    0x2e, 0x83, 0x2d, 0x17, 0x92, 0x05, 0x83, 0x11, 0x62, 0xfc, 0xa1, 0x6c, 0x96, 0xb1, 0xe0, 0x45,
    0xf0, 0xa3, 0xbc, 0x19, 0x85, 0x2e, 0xe2, 0x0d, 0x0f, 0x73, 0x0a, 0x30, 0xf3, 0x00, 0x6f, 0xce,
    0x3d, 0xb5, 0x9b, 0xf9, 0xfc, 0x55, 0x7a, 0x44, 0x92, 0x78, 0xc8, 0x81, 0x98, 0x41, 0x33, 0xc1,
    0x28, 0x39, 0x90, 0x49, 0x08, 0x42, 0x8a, 0x56, 0x6b, 0x3e, 0xe5, 0x80, 0x43, 0x5f, 0xf0, 0x29,
    0x1a, 0xc3, 0x85, 0x6c, 0xc3, 0x49, 0xf0, 0x03, 0x79, 0xb0, 0xe4, 0xbb, 0xfe, 0xd1, 0xe7, 0x4a,
    0x5c, 0xe9, 0xbd, 0xfe, 0xf7, 0x9f, 0x16, 0x40, 0x62, 0x59, 0x75, 0x92, 0x58, 0x3a, 0xa0, 0xef,
    0x80, 0x3e, 0x23, 0xfa, 0xce, 0xda, 0xa3, 0x4f, 0x87, 0x1e, 0xd5, 0x3d, 0x46, 0xd7, 0xa7, 0xb7,
    0x9b, 0x85, 0x01, 0xb4, 0x8d, 0x57, 0xb3, 0xe4, 0x57, 0x00, 0xb7, 0xea, 0x7e, 0xf2, 0xdb, 0xeb,
    0x6b, 0x80, 0xb0, 0xdb, 0x8b, 0x70, 0x36, 0x16, 0x38, 0x53, 0x61, 0xb5, 0x3b, 0xa1, 0xc1, 0x9c,
    0xfc, 0x8e, 0x10, 0x87, 0x14, 0x78, 0xbd, 0x13, 0xb6, 0x5d, 0xfa, 0x88, 0x7f, 0x13, 0x27, 0x99,
    0xb5, 0x71, 0xa1, 0x45, 0xe8, 0xea, 0xa4, 0x7f, 0x08, 0xad, 0x43, 0x68, 0x99, 0x43, 0x4b, 0x1f,
    0x58, 0x16, 0x88, 0x7e, 0xcd, 0xe4, 0x65, 0x85, 0xd9, 0x67, 0x10, 0xf8, 0xbd, 0xfe, 0xa7, 0xaf,
    0x92, 0xf8, 0xe8, 0xdc, 0x36, 0x11, 0xba, 0xee, 0x30, 0xb6, 0x7e, 0x12, 0x9b, 0x89, 0x27, 0x6c,
    0x93, 0x91, 0x04, 0x47, 0x3d, 0x1f, 0x63, 0xc1, 0x51, 0x05, 0xe0, 0x7c, 0x7c, 0x73, 0xc0, 0x36,
    0xd9, 0x1f, 0xe8, 0x03, 0xe4, 0x29, 0x50, 0x1a, 0xbc, 0xc0, 0xa5, 0xba, 0x24, 0x02, 0x65, 0x2a,
    0xfc, 0x09, 0xe7, 0x0c, 0xd2, 0x3c, 0x37, 0xb3, 0x6e, 0x67, 0xfb, 0xea, 0x96, 0x8b, 0x6a, 0x9d,
    0x96, 0xb9, 0xed, 0xb2, 0xbe, 0xb9, 0x4d, 0xf0, 0x2c, 0x84, 0xd2, 0x39, 0xf5, 0x6c, 0x1e, 0x06,
    0x62, 0xc9, 0x9a, 0x63, 0xe1, 0xaa, 0x87, 0x71, 0x38, 0x45, 0x2e, 0xfc, 0x62, 0x4d, 0x78, 0xa4,
    0xa5, 0x35, 0x11, 0x07, 0x06, 0xc7, 0x92, 0xea, 0xf1, 0x22, 0xfa, 0xdb, 0xeb, 0x9b, 0x2f, 0x57,
    0xe5, 0xd9, 0x0c, 0xa9, 0x4a, 0xe2, 0xb5, 0x2b, 0x40, 0xdd, 0xcd, 0xc5, 0x8a, 0xa4, 0x82, 0x25,
    0x5d, 0x4d, 0x42, 0xd9, 0x19, 0x45, 0xcd, 0x13, 0x0d, 0x6d, 0xe9, 0x65, 0xb9, 0xbc, 0x51, 0xc2,
    0xbf, 0x28, 0x6e, 0xcc, 0xf1, 0x06, 0x93, 0x17, 0xdc, 0x0d, 0x32, 0x2d, 0xef, 0x5a, 0xaa, 0x62,
    0x1a, 0x4c, 0x07, 0x80, 0xaf, 0x67, 0x44, 0x6a, 0x17, 0x45, 0x7e, 0x3d, 0xa8, 0x2b, 0xfd, 0x1e,
    0xa7, 0xc8, 0x44, 0xbd, 0x20, 0x0e, 0xdc, 0x57, 0x8e, 0xe8, 0xbc, 0x80, 0x8f, 0x16, 0xd1, 0x8d,
    0x74, 0xfb, 0xc8, 0x11, 0x5d, 0x65, 0x78, 0x09, 0x91, 0xe4, 0x76, 0x2d, 0x63, 0xa0, 0x9b, 0x39,
    0xf7, 0x91, 0x98, 0x42, 0xff, 0x17, 0x64, 0xe2, 0xee, 0x4e, 0x1c, 0x15, 0x66, 0xba, 0xfb, 0xd2,
    0x61, 0xb3, 0xc6, 0xb5, 0xfa, 0x46, 0x4d, 0x46, 0x41, 0xe7, 0x7a, 0x50, 0x35, 0xe2, 0x19, 0x05,
    0x67, 0xc2, 0xf7, 0xa9, 0x51, 0x98, 0x9a, 0x98, 0x06, 0x81, 0xd0, 0x2b, 0x2e, 0xd5, 0x71, 0x63,
    0xdc, 0x9e, 0x41, 0xd2, 0x32, 0xc5, 0xaa, 0x44, 0x75, 0xbe, 0xba, 0xb7, 0x31, 0x71, 0xd9, 0x35,
    0x6f, 0x19, 0x23, 0xd9, 0x30, 0x18, 0x08, 0x0a, 0x6d, 0x65, 0x5b, 0x9a, 0x5a, 0x6d, 0x77, 0x9d,
    0x95, 0x99, 0x97, 0xda, 0x3c, 0x35, 0x55, 0x22, 0xe9, 0x1a, 0xf7, 0xb4, 0x97, 0xb3, 0x65, 0x9c,
    0xf8, 0x49, 0xcf, 0x30, 0xf6, 0x00, 0xc2, 0x19, 0xcc, 0x1a, 0x68, 0x90, 0xa3, 0xfd, 0x85, 0x9c,
    0x75, 0x47, 0xd2, 0x88, 0xec, 0x3b, 0x06, 0x4b, 0x0f, 0xba, 0x29, 0xf5, 0x92, 0x10, 0xcf, 0x44,
    0xaa, 0x74, 0x93, 0x0d, 0x05, 0xe6, 0xe6, 0x8d, 0x86, 0x14, 0xe9, 0x70, 0xd0, 0xf0, 0x38, 0xc2,
    0x3c, 0xca, 0xf5, 0xde, 0x65, 0x09, 0x80, 0xce, 0x1a, 0xd0, 0xd3, 0x3a, 0xb2, 0xf1, 0x6e, 0xec,
    0x69, 0x4b, 0x17, 0x8d, 0x3e, 0xad, 0xe9, 0x64, 0x6a, 0x6a, 0x44, 0x93, 0x8e, 0x03, 0x75, 0x50,
    0x4b, 0xa7, 0x02, 0x13, 0x1f, 0x31, 0x0c, 0x02, 0x8c, 0xfe, 0x24, 0x39, 0x82, 0x88, 0x22, 0x85,
    0x1b, 0xda, 0x36, 0x1b, 0xb2, 0x1a, 0x9e, 0x17, 0xf3, 0xa0, 0x23, 0x1c, 0x20, 0x82, 0xcf, 0x07,
    0x58, 0xe4, 0x3a, 0x2c, 0x13, 0x5c, 0x00, 0xa8, 0x28, 0xc8, 0xb6, 0x5a, 0xcc, 0x72, 0xe7, 0xc6,
    0xf1, 0x89, 0x7e, 0x05, 0x63, 0xd5, 0x4b, 0xf5, 0xaa, 0xa4, 0xa3, 0x69, 0x46, 0x21, 0x27, 0x54,
    0x13, 0x09, 0x83, 0x7c, 0xa8, 0x24, 0x53, 0x90, 0x6e, 0x1a, 0xca, 0x5a, 0xbf, 0x82, 0x97, 0x02,
    0xc8, 0xfc, 0x78, 0x5b, 0x59, 0xe2, 0x2f, 0x43, 0x0e, 0x87, 0x94, 0x82, 0x70, 0x70, 0x1c, 0xa3,
    0xe3, 0xb1, 0x75, 0x46, 0x17, 0xc2, 0xaf, 0x4a, 0xd9, 0x55, 0x3f, 0xc7, 0x77, 0xe3, 0xad, 0xcd,
    0x9c, 0x15, 0xe3, 0x68, 0x27, 0x29, 0x4a, 0xa6, 0x92, 0x48, 0x4a, 0x53, 0x65, 0xd6, 0x8b, 0x51,
    0x99, 0x00, 0xf7, 0x91, 0x75, 0xad, 0x49, 0x6d, 0xa6, 0xe9, 0xb9, 0x13, 0x7f, 0x25, 0x09, 0xea,
    0x5e, 0x61, 0xba, 0xf0, 0xfd, 0x99, 0x4f, 0x95, 0xa5, 0x57, 0x95, 0x0e, 0x7d, 0xa1, 0xe0, 0xf9,
    0xce, 0x7d, 0xe1, 0x9e, 0x12, 0xdf, 0xbd, 0x2f, 0xdc, 0xe9, 0xfb, 0x7a, 0x7d, 0x61, 0x91, 0xe7,
    0x2b, 0xf5, 0x85, 0x82, 0xe9, 0x9d, 0x3e, 0xef, 0x0f, 0xdc, 0xf8, 0xf7, 0x3b, 0x64, 0xa1, 0xbb,
    0x42, 0xfd, 0x28, 0xbf, 0xd9, 0x75, 0xe1, 0xa9, 0x16, 0xec, 0x64, 0x32, 0x7b, 0xfb, 0xbb, 0x8c,
    0x95, 0x82, 0x32, 0x40, 0x7e, 0x1c, 0x6b, 0xb2, 0xa8, 0x74, 0x61, 0x39, 0x55, 0x1e, 0x49, 0x13,
    0xbe, 0xa6, 0xa7, 0xd3, 0x2e, 0x12, 0x66, 0xd9, 0xa3, 0xa5, 0x66, 0x8a, 0xd5, 0x8d, 0xab, 0x5d,
    0x84, 0xe4, 0x5b, 0x9a, 0xec, 0x89, 0xe2, 0xed, 0x1d, 0xb2, 0x0d, 0xba, 0xf7, 0x19, 0xd5, 0x9d,
    0x2e, 0xd3, 0xf9, 0xa5, 0xbe, 0xe5, 0xc8, 0xbd, 0x10, 0xef, 0x39, 0x1c, 0x6c, 0xb1, 0xa9, 0x00,
    0xb6, 0x36, 0xd4, 0x73, 0xb1, 0xdf, 0xac, 0xb9, 0xc2, 0x62, 0x11, 0x15, 0xf1, 0xc5, 0x22, 0x3d,
    0x2e, 0xbd, 0xb8, 0x98, 0x8a, 0xbf, 0x47, 0xff, 0x01, 0x03, 0xde, 0x2e, 0xb7
};
#endif

PyTypeObject *init_KAboutData(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX].type;

    Shiboken::AutoDecRef Sbk_KAboutData_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KAboutData_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KAboutData",
        "KAboutData",
        &Sbk_KAboutData_spec,
        &Shiboken::callCppDestructor< ::KAboutData >,
        Sbk_KAboutData_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::Value);
    auto *pyType = Sbk_KAboutData_TypeF(); // references _Sbk_KAboutData_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KAboutData_SignatureStrings);
#else
    InitSignatureBytes(pyType, KAboutData_SignatureBytes, KAboutData_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KAboutData_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KAboutData_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KAboutData_PythonToCpp_KAboutData_PTR,
        is_KAboutData_PythonToCpp_KAboutData_PTR_Convertible,
        KAboutData_PTR_CppToPython_KAboutData,
        KAboutData_COPY_CppToPython_KAboutData);

    Shiboken::Conversions::registerConverterName(converter, "KAboutData");
    Shiboken::Conversions::registerConverterName(converter, "KAboutData*");
    Shiboken::Conversions::registerConverterName(converter, "KAboutData&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KAboutData).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        KAboutData_PythonToCpp_KAboutData_COPY,
        is_KAboutData_PythonToCpp_KAboutData_COPY_Convertible);

    qRegisterMetaType< ::KAboutData >("KAboutData");

    return pyType;
}
