
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kstringhandler_wrapper.h"

// Argument includes
#include <QString>
#include <QStringList>
#include <QStringView>
#include <qchar.h>
#include <qregularexpression.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KStringHandler_Type = nullptr;
static PyTypeObject *Sbk_KStringHandler_TypeF(void)
{
    return _Sbk_KStringHandler_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int Sbk_KStringHandler_Init(PyObject *, PyObject *, PyObject *)
{
    Shiboken::Errors::setInstantiateNamespace("KStringHandler");
    return -1;
}

static PyObject *Sbk_KStringHandlerFunc_capwords(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KStringHandler::capwords(QString)->QString
    // 1: static KStringHandler::capwords(QStringList)->QStringList
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], (pyArg)))) {
        overloadId = 1; // capwords(QStringList)
    } else if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // capwords(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "capwords", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKStringHandler_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // capwords(const QString &text)
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // capwords(QString)
                QString cppResult = ::KStringHandler::capwords(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
            }
            break;
        }
        case 1: // capwords(const QStringList &list)
        {
            ::QStringList cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (Shiboken::Errors::occurred() == nullptr) {
                // capwords(QStringList)
                QStringList cppResult = ::KStringHandler::capwords(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStringHandlerFunc_csqueeze(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "csqueeze", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKStringHandler_IDX]);

    if (PyArg_ParseTuple(args, "|OO:csqueeze", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KStringHandler::csqueeze(QString,int=)->QString
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // csqueeze(QString,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // csqueeze(QString,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "csqueeze", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKStringHandler_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"maxlen", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "csqueeze", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKStringHandler_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = 40;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // csqueeze(QString,int)
            QString cppResult = ::KStringHandler::csqueeze(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStringHandlerFunc_logicalLength(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KStringHandler::logicalLength(QString)->int
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // logicalLength(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "logicalLength", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKStringHandler_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // logicalLength(QString)
            int cppResult = ::KStringHandler::logicalLength(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStringHandlerFunc_lsqueeze(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "lsqueeze", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKStringHandler_IDX]);

    if (PyArg_ParseTuple(args, "|OO:lsqueeze", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KStringHandler::lsqueeze(QString,int=)->QString
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // lsqueeze(QString,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // lsqueeze(QString,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "lsqueeze", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKStringHandler_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"maxlen", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "lsqueeze", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKStringHandler_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = 40;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // lsqueeze(QString,int)
            QString cppResult = ::KStringHandler::lsqueeze(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStringHandlerFunc_obscure(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KStringHandler::obscure(QString)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // obscure(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "obscure", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKStringHandler_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // obscure(QString)
            QString cppResult = ::KStringHandler::obscure(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStringHandlerFunc_perlSplit(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "perlSplit", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKStringHandler_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:perlSplit", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KStringHandler::perlSplit(QChar,QString,int=)->QStringList
    // 1: static KStringHandler::perlSplit(QRegularExpression,QString,int=)->QStringList
    // 2: static KStringHandler::perlSplit(QString,QString,int=)->QStringList
    // 3: static KStringHandler::perlSplit(QStringView,QStringView,int)->QStringList
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 3; // perlSplit(QStringView,QStringView,int)
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 2; // perlSplit(QString,QString,int)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            overloadId = 2; // perlSplit(QString,QString,int)
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QRegularExpression_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 1; // perlSplit(QRegularExpression,QString,int)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            overloadId = 1; // perlSplit(QRegularExpression,QString,int)
        }
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QChar_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // perlSplit(QChar,QString,int)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            overloadId = 0; // perlSplit(QChar,QString,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "perlSplit", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKStringHandler_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // perlSplit(const QChar &sep, const QString &s, int max)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"max", 2}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "perlSplit", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKStringHandler_IDX]);
                }
            }
            ::QChar cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2 = 0;
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // perlSplit(QChar,QString,int)
                QStringList cppResult = ::KStringHandler::perlSplit(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
            }
            break;
        }
        case 1: // perlSplit(const QRegularExpression &sep, const QString &s, int max)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"max", 2}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "perlSplit", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKStringHandler_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QRegularExpression cppArg0_local;
            ::QRegularExpression *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2 = 0;
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // perlSplit(QRegularExpression,QString,int)
                QStringList cppResult = ::KStringHandler::perlSplit(*cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
            }
            break;
        }
        case 2: // perlSplit(const QString &sep, const QString &s, int max)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"max", 2}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments(args, "perlSplit", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKStringHandler_IDX]);
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2 = 0;
            if (pythonToCpp[2])
                pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // perlSplit(QString,QString,int)
                QStringList cppResult = ::KStringHandler::perlSplit(cppArg0, cppArg1, cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
            }
            break;
        }
        case 3: // perlSplit(const QStringView sep, const QStringView str, int max)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "perlSplit", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKStringHandler_IDX]);
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);

            if (Shiboken::Errors::occurred() == nullptr) {
                // perlSplit(QStringView,QStringView,int)
                QStringList cppResult = ::KStringHandler::perlSplit(QStringView(cppArg0), QStringView(cppArg1), cppArg2);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
            }
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStringHandlerFunc_preProcessWrap(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KStringHandler::preProcessWrap(QString)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // preProcessWrap(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "preProcessWrap", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKStringHandler_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // preProcessWrap(QString)
            QString cppResult = ::KStringHandler::preProcessWrap(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStringHandlerFunc_rsqueeze(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(self)
    SBK_UNUSED(kwds)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 1, 2));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "rsqueeze", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKStringHandler_IDX]);

    if (PyArg_ParseTuple(args, "|OO:rsqueeze", &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: static KStringHandler::rsqueeze(QString,int=)->QString
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // rsqueeze(QString,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // rsqueeze(QString,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "rsqueeze", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKStringHandler_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"maxlen", 1}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "rsqueeze", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKStringHandler_IDX]);
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = 40;
        if (pythonToCpp[1])
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // rsqueeze(QString,int)
            QString cppResult = ::KStringHandler::rsqueeze(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KStringHandlerFunc_tagUrls(PyObject *self, PyObject *pyArg)
{
    SBK_UNUSED(self)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static KStringHandler::tagUrls(QString)->QString
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // tagUrls(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "tagUrls", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKStringHandler_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // tagUrls(QString)
            QString cppResult = ::KStringHandler::tagUrls(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KStringHandler_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KStringHandler_methods[] = {
    {"capwords", reinterpret_cast<PyCFunction>(Sbk_KStringHandlerFunc_capwords), METH_O|METH_STATIC, nullptr},
    {"csqueeze", reinterpret_cast<PyCFunction>(Sbk_KStringHandlerFunc_csqueeze), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"logicalLength", reinterpret_cast<PyCFunction>(Sbk_KStringHandlerFunc_logicalLength), METH_O|METH_STATIC, nullptr},
    {"lsqueeze", reinterpret_cast<PyCFunction>(Sbk_KStringHandlerFunc_lsqueeze), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"obscure", reinterpret_cast<PyCFunction>(Sbk_KStringHandlerFunc_obscure), METH_O|METH_STATIC, nullptr},
    {"perlSplit", reinterpret_cast<PyCFunction>(Sbk_KStringHandlerFunc_perlSplit), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"preProcessWrap", reinterpret_cast<PyCFunction>(Sbk_KStringHandlerFunc_preProcessWrap), METH_O|METH_STATIC, nullptr},
    {"rsqueeze", reinterpret_cast<PyCFunction>(Sbk_KStringHandlerFunc_rsqueeze), METH_VARARGS|METH_KEYWORDS|METH_STATIC, nullptr},
    {"tagUrls", reinterpret_cast<PyCFunction>(Sbk_KStringHandlerFunc_tagUrls), METH_O|METH_STATIC, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_KStringHandler_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KStringHandler_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KStringHandler_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(Sbk_object_dealloc /* PYSIDE-832: Prevent replacement of "0" with subtype_dealloc. */)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KStringHandler_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KStringHandler_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KStringHandler_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KStringHandler_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkDummyNew /* PYSIDE-595: Prevent replacement of "0" with base->tp_new. */)},
    {0, nullptr}
};
static PyType_Spec Sbk_KStringHandler_spec = {
    "1:KCoreAddons.KStringHandler",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KStringHandler_slots
};

} //extern "C"

// Type conversion functions.

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KCoreAddonsKStringHandler_SignatureStrings[] = {
    "1:KCoreAddons.KStringHandler.capwords(text:QString)->QString",
    "0:KCoreAddons.KStringHandler.capwords(list:QStringList)->QStringList",
    "KCoreAddons.KStringHandler.csqueeze(str:QString,maxlen:int=40)->QString",
    "KCoreAddons.KStringHandler.logicalLength(text:QString)->int",
    "KCoreAddons.KStringHandler.lsqueeze(str:QString,maxlen:int=40)->QString",
    "KCoreAddons.KStringHandler.obscure(str:QString)->QString",
    "3:KCoreAddons.KStringHandler.perlSplit(sep:QChar,s:QString,max:int=0)->QStringList",
    "2:KCoreAddons.KStringHandler.perlSplit(sep:typing.Union[PySide6.QtCore.QRegularExpression, QString],s:QString,max:int=0)->QStringList",
    "1:KCoreAddons.KStringHandler.perlSplit(sep:QString,s:QString,max:int=0)->QStringList",
    "0:KCoreAddons.KStringHandler.perlSplit(sep:QString,str:QString,max:int)->QStringList",
    "KCoreAddons.KStringHandler.preProcessWrap(text:QString)->QString",
    "KCoreAddons.KStringHandler.rsqueeze(str:QString,maxlen:int=40)->QString",
    "KCoreAddons.KStringHandler.tagUrls(text:QString)->QString",
    nullptr}; // Sentinel
#else
static constexpr size_t KCoreAddonsKStringHandler_SignatureByteSize = 265;
static constexpr uint8_t KCoreAddonsKStringHandler_SignatureBytes[265] = {
    0x78, 0xda, 0xad, 0x93, 0x51, 0x4b, 0xc3, 0x30, 0x10, 0xc7, 0xdf, 0xf7, 0x29, 0x7c, 0xac, 0x50,
    0x43, 0xa7, 0xe2, 0x43, 0x41, 0x41, 0x86, 0x20, 0x6c, 0x0f, 0xab, 0x65, 0xf8, 0x20, 0x3e, 0xc4,
    0xf6, 0xc8, 0x02, 0x31, 0x89, 0x77, 0x57, 0xec, 0xfc, 0xf4, 0xa6, 0x5a, 0xb5, 0x1b, 0x2c, 0x56,
    0xd9, 0xdb, 0x85, 0xcb, 0xff, 0x97, 0xff, 0x5d, 0xee, 0xa6, 0xf9, 0x7c, 0xe6, 0x10, 0xae, 0xeb,
    0xda, 0x59, 0x12, 0xf3, 0x92, 0x51, 0x5b, 0x75, 0x2b, 0x6d, 0x6d, 0x00, 0x45, 0x25, 0xfd, 0xab,
    0xc3, 0x9a, 0x12, 0x86, 0x96, 0xf3, 0xe2, 0x33, 0x79, 0x7c, 0x72, 0xd5, 0x47, 0x93, 0x6c, 0x94,
    0xd8, 0x68, 0xfa, 0x16, 0x2f, 0x42, 0xfc, 0x03, 0xe8, 0x4e, 0x93, 0x18, 0x82, 0x5e, 0x1a, 0x80,
    0x37, 0x48, 0x88, 0xf1, 0x8b, 0x90, 0x3e, 0xcb, 0xd6, 0x80, 0xcd, 0xb5, 0xe5, 0xcb, 0xf3, 0x6c,
    0x60, 0x26, 0xc2, 0x31, 0x4e, 0xe9, 0x4a, 0x9a, 0x05, 0x58, 0xc5, 0xeb, 0xdd, 0x62, 0x02, 0x28,
    0xaa, 0x3d, 0x90, 0x07, 0xf7, 0x44, 0x55, 0x83, 0x5b, 0x98, 0x81, 0xf0, 0x2c, 0xd6, 0x49, 0x0f,
    0x68, 0x4a, 0x6f, 0x34, 0x27, 0x04, 0x3e, 0x2f, 0x66, 0x6b, 0x89, 0x29, 0x0d, 0xbd, 0x7c, 0x18,
    0xc9, 0x76, 0xfa, 0x7a, 0x3a, 0x1e, 0xc9, 0x1b, 0x1f, 0x72, 0x62, 0x65, 0xb5, 0xb3, 0x0f, 0xcb,
    0x4d, 0xa9, 0x6b, 0xb8, 0x10, 0x05, 0x77, 0x72, 0x51, 0xdc, 0x81, 0x6a, 0x8c, 0xc4, 0x9b, 0xd6,
    0x23, 0x10, 0x85, 0x1b, 0xe9, 0x51, 0xff, 0xcc, 0xe3, 0x08, 0x17, 0xd3, 0x3f, 0x14, 0xd6, 0xa3,
    0x7e, 0x87, 0x66, 0xff, 0x80, 0x6e, 0xff, 0x5e, 0x87, 0x1d, 0x3f, 0x87, 0xa1, 0xf2, 0x25, 0xba,
    0x2a, 0x94, 0x7f, 0x8f, 0xd2, 0xef, 0xdb, 0x86, 0x08, 0x00, 0x0f, 0x34, 0x44, 0x2c, 0xd5, 0x0a,
    0xcd, 0xde, 0x7d, 0x7c, 0x07, 0xf2, 0x07, 0x63, 0x22
};
#endif

PyTypeObject *init_KCoreAddonsKStringHandler(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKStringHandler_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKStringHandler_IDX].type;

    Shiboken::AutoDecRef Sbk_KStringHandler_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_KStringHandler_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KStringHandler",
        "KStringHandler",
        &Sbk_KStringHandler_spec,
        nullptr,
        Sbk_KStringHandler_Type_bases.object(),
        0);
    auto *pyType = Sbk_KStringHandler_TypeF(); // references _Sbk_KStringHandler_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KCoreAddonsKStringHandler_SignatureStrings);
#else
    InitSignatureBytes(pyType, KCoreAddonsKStringHandler_SignatureBytes, KCoreAddonsKStringHandler_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KStringHandler_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KCoreAddonsKStringHandler_IDX].type = pyType;



    return pyType;
}
