/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

// PodExtendedResourceClaimStatusApplyConfiguration represents a declarative configuration of the PodExtendedResourceClaimStatus type for use
// with apply.
type PodExtendedResourceClaimStatusApplyConfiguration struct {
	RequestMappings   []ContainerExtendedResourceRequestApplyConfiguration `json:"requestMappings,omitempty"`
	ResourceClaimName *string                                              `json:"resourceClaimName,omitempty"`
}

// PodExtendedResourceClaimStatusApplyConfiguration constructs a declarative configuration of the PodExtendedResourceClaimStatus type for use with
// apply.
func PodExtendedResourceClaimStatus() *PodExtendedResourceClaimStatusApplyConfiguration {
	return &PodExtendedResourceClaimStatusApplyConfiguration{}
}

// WithRequestMappings adds the given value to the RequestMappings field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the RequestMappings field.
func (b *PodExtendedResourceClaimStatusApplyConfiguration) WithRequestMappings(values ...*ContainerExtendedResourceRequestApplyConfiguration) *PodExtendedResourceClaimStatusApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithRequestMappings")
		}
		b.RequestMappings = append(b.RequestMappings, *values[i])
	}
	return b
}

// WithResourceClaimName sets the ResourceClaimName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ResourceClaimName field is set to the value of the last call.
func (b *PodExtendedResourceClaimStatusApplyConfiguration) WithResourceClaimName(value string) *PodExtendedResourceClaimStatusApplyConfiguration {
	b.ResourceClaimName = &value
	return b
}
