#include <sal/types.h>


#include <rtl/ustring.hxx>


extern "C" {

static constexpr OUStringLiteral langID = u"\x0073\x0072";
static constexpr OUStringLiteral langDefaultName = u"\x0053\x0065\x0072\x0062\x0069\x0061\x006e\x0020\x0043\x0079\x0072\x0069\x006c\x006c\x0069\x0063";
static constexpr OUStringLiteral countryID = u"\x0043\x0053";
static constexpr OUStringLiteral countryDefaultName = u"\x0053\x0065\x0072\x0062\x0069\x0061\x0020\x0061\x006e\x0064\x0020\x004d\x006f\x006e\x0074\x0065\x006e\x0065\x0067\x0072\x006f";
static constexpr OUStringLiteral Variant = u"";

static constexpr OUString LCInfoArray[] = {
	langID,
	langDefaultName,
	countryID,
	countryDefaultName,
	Variant
};

SAL_DLLPUBLIC_EXPORT OUString const *  getLCInfo_sr_CS(sal_Int16& count)
{
	count = std::size(LCInfoArray);
	return (OUString const *)LCInfoArray;
}
extern const OUString *  getLocaleItem_sr_RS(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getLocaleItem_sr_CS(sal_Int16& count)
{
	return getLocaleItem_sr_RS(count);
}
static const sal_Unicode replaceTo0[] = {0x5b, 0x24, 0x414, 0x418, 0x41d, 0x2d, 0x43, 0x31, 0x41, 0x5d, 0x0};
extern OUString const * getAllFormats0_sr_RS(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to);
SAL_DLLPUBLIC_EXPORT OUString const * getAllFormats0_sr_CS(sal_Int16& count, const sal_Unicode*& from, const sal_Unicode*& to)
{
	to = replaceTo0;
	const sal_Unicode* tmp;
	return getAllFormats0_sr_RS(count, from, tmp);
}
extern const OUString *  getDateAcceptancePatterns_sr_RS(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getDateAcceptancePatterns_sr_CS(sal_Int16& count)
{
	return getDateAcceptancePatterns_sr_RS(count);
}
extern const OUString *  getCollatorImplementation_sr_RS(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollatorImplementation_sr_CS(sal_Int16& count)
{
	return getCollatorImplementation_sr_RS(count);
}
extern const OUString *  getCollationOptions_sr_RS(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getCollationOptions_sr_CS(sal_Int16& count)
{
	return getCollationOptions_sr_RS(count);
}
extern const OUString *  getSearchOptions_sr_RS(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getSearchOptions_sr_CS(sal_Int16& count)
{
	return getSearchOptions_sr_RS(count);
}
extern const OUString *  getIndexAlgorithm_sr_RS(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getIndexAlgorithm_sr_CS(sal_Int16& count)
{
	return getIndexAlgorithm_sr_RS(count);
}
extern const OUString *  getUnicodeScripts_sr_RS(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getUnicodeScripts_sr_CS(sal_Int16& count)
{
	return getUnicodeScripts_sr_RS(count);
}
extern const OUString *  getFollowPageWords_sr_RS(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getFollowPageWords_sr_CS(sal_Int16& count)
{
	return getFollowPageWords_sr_RS(count);
}
extern const OUString *  getAllCalendars_sr_RS(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getAllCalendars_sr_CS(sal_Int16& count)
{
	return getAllCalendars_sr_RS(count);
}
static constexpr OUStringLiteral defaultCurrency0 = u"\x1";
static constexpr OUStringLiteral defaultCurrencyUsedInCompatibleFormatCodes0 = u"\x1";
static constexpr OUStringLiteral defaultCurrencyLegacyOnly0 = u"\x0";
static constexpr OUStringLiteral currencyID0 = u"\x0043\x0053\x0044";
static constexpr OUStringLiteral currencySymbol0 = u"\x0414\x0418\x041d";
static constexpr OUStringLiteral bankSymbol0 = u"\x0043\x0053\x0044";
static constexpr OUStringLiteral currencyName0 = u"\x0421\x0440\x043f\x0441\x043a\x0438\x0020\x0414\x0438\x043d\x0430\x0440";
static constexpr OUStringLiteral currencyDecimalPlaces0 = u"\x2";

static constexpr OUStringLiteral defaultCurrency1 = u"\x0";
static constexpr OUStringLiteral defaultCurrencyUsedInCompatibleFormatCodes1 = u"\x0";
static constexpr OUStringLiteral defaultCurrencyLegacyOnly1 = u"\x0";
static constexpr OUStringLiteral currencyID1 = u"\x0045\x0055\x0052";
static constexpr OUStringLiteral currencySymbol1 = u"\x20ac";
static constexpr OUStringLiteral bankSymbol1 = u"\x0045\x0055\x0052";
static constexpr OUStringLiteral currencyName1 = u"\x0045\x0075\x0072\x006f";
static constexpr OUStringLiteral currencyDecimalPlaces1 = u"\x2";

static const sal_Int16 currencyCount = 2;

static constexpr OUString currencies[] = {
	currencyID0,
	currencySymbol0,
	bankSymbol0,
	currencyName0,
	defaultCurrency0,
	defaultCurrencyUsedInCompatibleFormatCodes0,
	currencyDecimalPlaces0,
	defaultCurrencyLegacyOnly0,
	currencyID1,
	currencySymbol1,
	bankSymbol1,
	currencyName1,
	defaultCurrency1,
	defaultCurrencyUsedInCompatibleFormatCodes1,
	currencyDecimalPlaces1,
	defaultCurrencyLegacyOnly1,
};

SAL_DLLPUBLIC_EXPORT OUString const *  getAllCurrencies_sr_CS(sal_Int16& count)
{
	count = currencyCount;
	return (OUString const *)currencies;
}
extern const OUString *  getTransliterations_sr_RS(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getTransliterations_sr_CS(sal_Int16& count)
{
	return getTransliterations_sr_RS(count);
}
extern const OUString *  getForbiddenCharacters_sr_RS(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getForbiddenCharacters_sr_CS(sal_Int16& count)
{
	return getForbiddenCharacters_sr_RS(count);
}
extern const OUString *  getBreakIteratorRules_sr_RS(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getBreakIteratorRules_sr_CS(sal_Int16& count)
{
	return getBreakIteratorRules_sr_RS(count);
}
extern const OUString *  getReservedWords_sr_RS(sal_Int16& count);
SAL_DLLPUBLIC_EXPORT const OUString *  getReservedWords_sr_CS(sal_Int16& count)
{
	return getReservedWords_sr_RS(count);
}
// ---> ContinuousNumbering
extern const OUString **  getContinuousNumberingLevels_sr_RS(sal_Int16& nStyles, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString **  getContinuousNumberingLevels_sr_CS(sal_Int16& nStyles, sal_Int16& nAttributes)
{
	return getContinuousNumberingLevels_sr_RS(nStyles, nAttributes);
}
// ---> OutlineNumbering
extern const OUString ***  getOutlineNumberingLevels_sr_RS(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes);
SAL_DLLPUBLIC_EXPORT const OUString ***  getOutlineNumberingLevels_sr_CS(sal_Int16& nStyles, sal_Int16& nLevels, sal_Int16& nAttributes)
{
	return getOutlineNumberingLevels_sr_RS(nStyles, nLevels, nAttributes);
}
} // extern "C"

