/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Op Declarations                                                            *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|* From: RockOps.td                                                           *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

namespace mlir {
namespace rock {
/// Attention operation of transformer models
/// Performs the operation out = SOFTMAX(preSoftmaxBody(queries * keys, preSoftmaxElemWiseInputs)) * values.
/// 
///     This operation performs attention mechanism of transformer models. There is an optional element-wise 
///     fusion just before the softmax, defined by `preSoftmaxBody` with inputs `preSoftmaxElemWiseInputs`.
/// 
///     If none of the `transposed` attributes are set, then `queries` is [G] x seq_q x head_qk,
///     `keys` is [G] x head_qk x seq_k, `values` is [G] x seq_k x head_v and `out` is [G] x seq_q x head_v, 
///     where G is the optional group dimension (which is assumed to be 1 if not set).
/// 
///     The transpose attributes allow for the non-group dimensions of the matrix to be
///     transposed. For example, if `qTransposed` is set, then the argument `queries` should be
///     a [G] x head_qk x seq_q memory.
/// 
///     If causal is enabled, we implement causal masking.
/// 
///     LSE (log-sum-exp) is an optional output typically used for flash decoding.
///     For flash decoding, you can pass splitKV > 1, the default value is 1, which means flash decoding is disabled. 
///     Flash decoding multiplies the number of blocks by splitKV. Note that "lse" has to be non-null for splitKV > 1. 
///     However, "lse" can be non-null even if splitKV = 1.
/// 
///     The parameters `gridSize`, and `blockSize` are optional as they can be
///     inferred by a tuning process or a heuristic, but they must be set before
///     the `attention` is lowered into the `gridwise_attention_accel` stage of the
///     code generation pipeline.
/// 
///     `features` specifies what hardware features can be used in the generated code.
class AttentionOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Blockwise reduce operation with output broadcasting
/// The `rock.blockwise_broadcast_reduce` op does reduce at a blockwise level and
///     to fill all elements of the input tensor with reduced values. Note that both input/output
///     tensors live in registers.
/// 
///     $input tensor resides in registers, where each thread holds a subset of the elements
///     of the tensor as defined by $inputView.
/// 
///     $inputRegView should be a coordinate transform taking {tid, iter} (where iter is
///     the register number in $input and tid is the ID of the lane within the workgroup
///     and producing indices into a virtual tensor `{d0, ..., dR, ... dN}
///     which is spread across the lanes of the workgroup. Note that the reduction
///     axis (Dr) is not sliced because it is not supported.
/// 
///     $output tensor resides in registers. It would be of same shape as the input
///     tensor because the reduced value will be broadcasted to create the same shape as
///     the input tensor.
/// 
///     $workspace_buffer resides in LDS. This should be a flat tensor with at least
///     number of elements in the input tensor.
/// 
///     {$extraOut,$extraOutView} optionally be used to broadcast the output in a different
///     layout that is different to the input layout.
///     $extraOut and $extraOutView are an optional argument and a view stack, respectively,
///     that still needs to have upper dimensions equal to the input.
class BlockwiseBroadcastReduceOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Fill memory with constant value on GPU
/// The `rock.blockwise_fill` op fills a LDS memref on GPU with a constant value.
class BlockwiseFillOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Blockwise GEMM accelerated version
/// The `rock.blockwise_gemm_accel` op does GEMM at workgroup (block) level.
///     - Matrix A and Matrix B shall reside on LDS or registers (depending on loadAfromLDS and loadBfromLDS).
///     - Matrix C shall be vectors.
/// 
///     The elements of matrices A and B should be vectors of length kpack, or
///     scalars when kpack is 1.
class BlockwiseGemmAccelOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Blockwise GEMM non accelerated version
/// The `rock.blockwise_gemm` op does gemm at the blockwise level without acceleration.
/// 
///     Matrix A resides in LDS and has dimensions [k, m_c * mRepeatStride, kpack].
///     Matrix B resides in LDS and has dimensions [k, n_c * nRepeatStride, kpack].
/// 
///     Matrix C resides in registers and has dimensions [m_c, n_c].
/// 
///     The two index arguments specify a given threads's offset into the LDS buffer..
///     Each {m,n}PerThread group of elements (which may themselves be kPacks)
///     is read from LDS by a given thread, then the next mPerThread group is
///     mRepeatStride elements later in the buffer.
/// 
///     `rotate{M,N}PerThread` is used to rotate the access to LDS to avoid bank-conflicts in cases
///     where subsequent threads try to write data in the same column of the output matrix. If `kpack>1`
///     the rotation is simply the row index. If `kpack==1` the rotation takes into account the number of
///     elements reads by a thread along the `M` and/or `N` dimension, namely `in{M,N}PerThread`
class BlockwiseGemmOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// N-D convolution backward data
/// The `rock.conv_bwd_data` op computes N-D convolution backward data.
/// 
///     The kernel ID represents which of the multiple backwards data kernels
///     needed for the correct computation of the result this kernel is.
/// 
///     The boolean `usesV4R1` specifies if the broader compilation flow is using
///     the V4R1 algorithm for backwards data convs, which will require multiple
///     conv ops to be created to efficiently compute the data.
class ConvBwdDataOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// N-D convolution backward weight
/// The `rock.conv_bwd_weight` op computes N-D convolution backward weight.
class ConvBwdWeightOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// CONV-elementwise-GEMM operation
/// Performs the operation out = preSecondGemmBody(conv_forward(filter, input), elemwiseInputs) * c.
/// 
///     This operation performs fused CONV-elementwise-GEMM. There is an optional element-wise
///     fusion just before the second GEMM, defined by `preSecondGemmBody` with inputs `elemwiseInputs`.
/// 
///     If none of the `transposed` attributes are set, then `c` is [G] x N x O and `out` is [G] x M x O, 
///     where G is the optional group dimension (which is assumed to be 1 if not set). Note that input and
///     filter layouts are defined by attributes "input_layout" and "filter_layout".
/// 
///     The transpose attributes allow for the non-group dimensions of the matrix to be
///     transposed. For example, if `cTransposed` is set, then the argument `c` should be
///     a [G] x O x M memory.
/// 
///     The parameters `gridSize`, and `blockSize` are optional as they can be
///     inferred by a tuning process or a heuristic, but they must be set before
///     the `conv_elementwise_gemm` is lowered into the `gridwise_attention_accel`
///     stage of the code generation pipeline.
/// 
///     `features` specifies what hardware features can be used in the generated code.
class ConvElementwiseGemmOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// N-D convolution forward
/// The `rock.conv` op computes N-D convolution forward.
class ConvOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Copy input to output, performing a type conversion
/// Copies an input buffer to an output buffer, converting the type of each element,
///     as its own kernel.
/// 
///     This operation is needed for backwards weight atomic add kernels where
///     the output is a float smaller than f32, since the atomic add instructions
///     for smaller floating point types are not accurate enough for our purposes.
class ConvertingCopyKernelOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Multi-buffer selection op
/// " Select a single buffer among a set of `buffers` based on `selectIndex % `buffers.size()` "
class ExtractMultiBufferOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Extract a slice from a vector
/// Extracts `len(result)` contiguous elements starting at `coord`  in `vector`.
///     If `result` is a scalar type, the length is 1 and this is just `vector.extractelement`.
///     If this causes an out of bounds read, the result is undefined.
class ExtractSliceOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Fill memory with constant value on GPU
/// The `rock.fill` op fills a memref on GPU with a constant value.
class FillOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// GEMM-elementwise-GEMM operation
/// Performs the operation out = preSecondGemmBody(a * b, elemwiseInputs) * c.
/// 
///     This operation performs fused GEMM-elementwise-GEMM. There is an optional element-wise
///     fusion just before the second GEMM, defined by `preSecondGemmBody` with inputs `elemwiseInputs`.
/// 
///     If none of the `transposed` attributes are set, then `a` is [G] x M x K,
///     `b` is [G] x K x N, `c` is [G] x N x O and `out` is [G] x M x O, where G is the 
///     optional group dimension (which is assumed to be 1 if not set).
/// 
///     The transpose attributes allow for the non-group dimensions of the matrix to be
///     transposed. For example, if `aTransposed` is set, then the argument `a` should be
///     a [G] x K x M memory.
/// 
///     The parameters `gridSize`, and `blockSize` are optional as they can be
///     inferred by a tuning process or a heuristic, but they must be set before
///     the `gemm_elementwise_gemm` is lowered into the `gridwise_attention_accel`
///     stage of the code generation pipeline.
/// 
///     `features` specifies what hardware features can be used in the generated code.
class GemmElementwiseGemmOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// General matrix multiplication (GEMM)
/// Performs the operation C += A * B.
/// 
///     If none of the `transposed` attributes are set, then A is [G] x M x K,
///     B is [G] x K x N, and C is [G] x M x N, where G is the optional group dimension
///     (which is assumed to be 1 if not set).
/// 
///     The transpose attributes allow for the non-group dimensions of the matrix to be
///     transposed. For example, if `aTransposed` is set, then the argument A should be
///     a [G] x K x M memory.
/// 
///     The parameters `derivedBlockSize`, `gridSize`, and `params` are optional as
///     they can be inferred by a tuning process or a heuristic, but they must be
///     set before the `gemm` is lowered into the `gridwise_gemm` stage of the code
///     generation pipeline.
/// 
///     `features` specifies what hardware features can be used in the generated code.
class GemmOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Load from global memory, applying bounds checks
/// `global_load` loads an item or vector of items from the provided memref
///     (applying no coordinate transformations), starting at `sourceCoord`. However,
///     if `valid` is false, it will instead return 0s.
///     Note that the lowering of this operation may be optimized when `valid`
///     is unconditionally true.
/// 
///     If `needs64BitIdx` is present, then this operation will force its containing
///     kernel to be compiled with `index == i64` and will use less-efficient
///     implementations of bounds-checked load.
/// 
///     If `canReadOffEnd` is present, then the `valid` input is ignored and the
///     bounds-checked implementation of this operation is always used. This
///     is used to simplify the implementation of certain utility kernels.
class GlobalLoadOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Load from global memory to LDS, applying bounds checks
/// `global_load_to_lds` loads an item or vector of items from the provided memref
///     (applying no coordinate transformations), starting at `sourceCoord` and stores.
///     to LDS. However, if `valid` is false, it will instead store 0s.
///     Note that the lowering of this operation may be optimized when `valid`
///     is unconditionally true.
/// 
///     If `needs64BitIdx` is present, then this operation will force its containing
///     kernel to be compiled with `index == i64` and will use less-efficient
///     implementations of bounds-checked load.
/// 
///     If `canReadOffEnd` is present, then the `valid` input is ignored and the
///     bounds-checked implementation of this operation is always used. This
///     is used to simplify the implementation of certain utility kernels.
class GlobalLoadToLDSOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Store data into global memory from a source
/// `global_store` reads `length` elements starting at `%source[%sourceCoord]`
///     and writes them to successive locations in `dest` starting at `[%destCoord]`.
///     However, if `valid` is false, it instead ignores the writes.
/// 
///     The write is performed using `storeMethod`, which could be an atomic operation.
/// 
///     This operation may correspond to multiple underlying memory operations.
/// 
///     If `valid` is always true, a more optimized implementation may be used.
/// 
///     If `needs64BitIdx` is present, then the kernel containing this `global_store`
///     will be flagged for compilation with `index == i64` and a less efficient
///     implementation of the underlying operation will be used.
/// 
///     If `canWriteOffEnd` is set, then the lowering will assume that bounds checks
///     are required, irrespective of the value of `valid`. This is used to simplify
///     the implementation of certain utility kernels.
class GlobalStoreOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Memory allocation on GPU
/// The `rock.alloc` op allocates memory on GPU.
///     - Address space 0 : global.
///     - Address space 3 : LDS.
///     - Address space 5 : private (VGPR).
///     All other values would be considered as allocation on global.
class GpuAllocOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Annotate lifetime of memory allocation on GPU
/// The `rock.dealloc` op annotates lifetime of memory allocation memory on GPU.
///     - Address space 0 : global.
///     - Address space 3 : LDS.
///     - Address space 5 : private (VGPR).
///     All other values would be considered as allocation on global.
class GpuDeallocOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Gridwise attention accelerated version
/// The `rock.gridwise_attention_accel` op computes gridwise attention with acceleration.
class GridwiseAttentionAccelOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Gridwise GEMM accelerated version
/// The `rock.gridwise_gemm` op computes gridwise GEMM with acceleration.
class GridwiseGemmAccelOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Gridwise GEMM
/// The `rock.gridwise_gemm` op computes gridwise GEMM.
class GridwiseGemmOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Load one or more contiguous items from `source`
/// rock.in_bounds_loads reads either one scalar value or a vector of values
///     from a memref. The memref can be in any memory space. The read begins at
///     `coords`.
class InBoundsLoadOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Store one or more items to contiguous indices in `dest`
/// `rock.in_bounds_store` stores the item or items in `data` (which can be
///     a scalar or a vector) to the buffer `dest`, starting at `coords`.
///     The memref can be in any memory space.
///     This op assumes that all indices will land in bounds.
class InBoundsStoreOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Compute change in lower indices (map output) using index diffs
/// `rock.index_diff_update' computes the change in the output of a transform_map
///     from adding `upperDiffs` to the inputs that produced the output `lowerOrig'.
/// 
///     The operation returns both `lowerIndices`, the new indices, and `lowerDiff`,
///     the change in the lower indices compared to `lowerOrig'.
class IndexDiffUpdateOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Insert a slice into a vector
/// Inserts  `source` into contigious indices of `dest`, starting at `coord`.
///     If `source` is a scalar type, this is just `vector.insertelement`.
///     If the indices into `dest` go out of bounds, the result is undefined.
class InsertSliceOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Setup an LDS barrier
/// The `rock.lds_barrier` op sets up a workgroup-level barrier on LDS activities.
class LDSBarrierOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Axes-wide reduction operation
class ReduceOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Operation whose region represents a single scheduling unit
/// `rock.stage` represents a single scheduling unit in a loop to be pipelined. If the body of the loop
///                          is partitioned in multiple stages then, setting the `__initiation__interval__` property of the
///                         `scf.for` operation will have the effect of overlapping different iterations inside the loop. For instance,
///                          if a loop is partitioned in 3 stages S0, S1, S2, and the II is set to 2, loop pipelineing will try to
///                         overlap an iteration containing S0 and S1 and a different iteration containing S2.
class StageOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Cast transformed tensor 'result' back to underlying allocation
/// This operation exists to enable bufferization where we have the pattern
///     ```mlir
///     %buf = bufferization.alloc_tensor : T
///     %t1 = rock.transform %buf : T to I1
///     ...
///     %output = rock.transform %tK : TK to U
///     %result = rock.conv(..., %output) : ..., U
///     op(%result, ...)
///     ```
///     where op required a value of type %T.
/// 
///     This op
///     Thi op must be eliminated during bufferization.
/// 
///     If the alleged result type is not equal to the type of untransform(transformArg),
///     it is in error.
class TensorUntransformCastOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Accelerated GEMM
/// The `rock.accel_gemm` op is an abstraction of doing GEMM based on an accelerator.
///     It would employ a series of accelerator (e.g., mfma or wmma) operations.
/// 
///     Matrices A and B reside in LDS, the buffers live in registers, C is a vector
class ThreadwiseAccelGemmOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Threadwise register-to-register copy
/// `rock.threadwise_copy` accepts a source view and a destination view and copy
///     data from source to destination. The only requirements are that both `source` and
///     `dest` views have the same upper shape and that their transform stack lowers to a flat buffer
class ThreadwiseCopyOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Threadwise GEMM non accelerated version
/// The `rock.threadwise_gemm` op does GEMM at thread level.
///     All arguments should be in registers (memref address space 5).
/// 
///     The dimensions of the multiplication arguments are
///      [m, n] = [k, m, kPack] * [k, n, kPack].
class ThreadwiseGemmOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Read values from transformed source into destination
/// A high-level representation of a global -> register read loop that
///     accounts for coordinate transformations.
/// 
///     If `%source = rock.transform #transform_mapN %buffer`
///     (with the one transformation representing an entire sequence),
///     and `%buffer` is in global memory, the operation
/// 
///     ```mlir
///     rock.threadwise_read_into [#transform_mapM](%source) -> %dest
///     ```
/// 
///     will lower to
///     ```mlir
///     %bid = rock.workgroup_id
///     %tid = rock.workitem_id
///     rock.transforming_for
///       (%args, ...) = MAPS(%bid, %tid, %c0)
///       (%_, %_, %i) = [](%c0, %c0, %c0)
///       (%isValid, %isValid) = isValid
///       bounds = [1, 1, L], strides = [1, 1, V] {
///         %v = rock.global_load {length = V} %buffer[%args] if %isValid
///         rock.in_bounds_store %v -> %dest[%i]
///     }
///     ```
///     where MAPS is `[#transform_mapM, #transform_mapN]`,
///     L is the length of `%dest`, V is the maximum vectorization computed
///     for MAPS.
/// 
///     The input to extraViews ; (the transforms on %source) must have the form
///     (extraIdx0, ... , extraIdxN, iteration_number)
/// 
///     Primarily, extraIndices would be used to pass in tid and bid. This would need
///     to have a matching view in [extraViews]source. The extraIndices could be used
///     to integrate loop induction vars that is outside of the op.
///     If extraIndices are used, the [extraViews]source must have the form
///     (extraIdx0, ... , extraIdxN, iteration_number).
/// 
///     If any `dynamicValidities` are passed in, they must have the same shape
///     as the output registers, and the booleans in each of these validities will be
///     ANDed together with the validity implied by the coordinate transformations
///     to determine whether the read is to actually be performed.
/// 
///     Note that using dynamic validities forces the vectorization width to 1 (but
///     that merely requesting a validity vector does not). There isn't any inherent
///     reason for this limitation other than that support for post-vectorization
///     masking wasn't needed in the initial usecase for this feature.
/// 
///     If `validityRecord` is specified, it will be filled with a boolean indicating
///     whether each of the values in `dest` was actually read from memory or if it
///     fell into some padded or otherwise invalid (ex. a coordinate went negative)
///     region. This is used to allow manually applying re-applying padding after
///     an input fusion that could cause the padded region to be non-zero.
/// 
///     This operation is also used during fusion to represent loads from additional
///     arguments like bias tensors.
class ThreadwiseReadIntoOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Write out values in registers to transformed destination
/// A high-level representation of a register -> somewhere write loop that
///     accounts for coordinate transformations.
/// 
///     If `%dest = rock.transform #transform_mapN %buffer`
///     (with the one transformation representing an entire sequence),
///     and `%buffer` is in global memory, the operation
/// 
///     ```mlir
///     rock.threadwise_write_all %source -> [#transform_mapM](%dest) by set
///     ```
/// 
///     will lower to
///     ```mlir
///     %bid = rock.workgroup_id
///     %tid = rock.workitem_id
///     rock.transforming_for (%_, %_, %i) = [](%c0, %c0, %c0)
///       (%args, ...) = MAPS(%bid, %tid, %c0)
///       (%na, %isValid) = validity
///       bounds = [1, 1, L], strides = [1, 1, V] {
///         rock.global_store set {length = V} %source[%i] -> %buffer[%args] if %isValid
///     }
///     ```
///     where MAPS is `[#transform_mapM, #transform_mapN]`,
///     L is the length of `%source`, V is the maximum vectorization computed
///     for MAPS, and the oob dimensions are those combputed on MAPS.
/// 
///     The input to extraViews ; (the transforms on %dest) must have the form
///     (extraIdx0, ... , extraIdxN, iteration_number).
/// 
///     Primarily, extraIndices would be used to pass in tid and bid. This would need
///     to have a matching view in [extraViews]dest. The extraIndices could be used
///     to integrate loop induction vars that is outside of the op.
/// 
///     If extraIndices are used, the [extraViews]dest must have the form
///     (extraIdx0, ... , extraIdxN, iteration_number).
/// 
///     This is used during fusion to allow rewriting
///     ```mlir
///     %tmp = memref.alloc()
///     ...
///     rock.threadwise_write_all [...](%result) -> %tmp
///     linalg.generic (%tmp) -> (%output) { ... }
///     ```
/// 
///     to
///     ```mlir
///     linalg.generic (%result) -> (%result_2) { ... }
///     rock.threadwise_write_all [...](%result_2) -> %out
///     ```
class ThreadwiseWriteAllOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Tensor transformation
/// Create a viee `output` of the tensor `input` with the same element type
///     such that, when the coordinates used to index into `output` are passed through
///     the coordinate transformations `transforms` from left to right,
///     they become coordinates into the `input` tensor.
class TransformOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// for loop with coordinate transforms
/// Loops over several a rectangular region of dimensions `bounds` in several
///     iteration domains, which are coordinate spaces that are the upper coordinates
///     for a sequence of coordinate transformations.
/// 
///     For each domain, when we have
///     `(%l0, %l1, ... %lL) = [#transform_map1](%u0, %u1, ... %uU)`
///     with bounds `[b0, b1, ... bU]` and strides `[1, 1, ..., 1]`
///     the loop arguments %l0, ... %lL will take on the values
///     - (%l0, ... %lL) = #transform_map1(%u0, %u1, ... %uU)
///     - (%l0, ... %lL) = #transform_map1(%u0, %u1, ... %uU + 1)
///     - ...
///     - (%l0, ... %lL) = #transform_map1(%u0, %u1, ... %uU + bU - 1)
///     - (%l0, ... %lL) = #transform_map1(%u0, %u1, ... %u(U-1) + 1, %uU)
///     - ...
///     - (%l0, ... %lL) = #transform_map1(%u0 + b0 - 1, ... %uU + bU - 1)
/// 
///     That is, the loop
///     ```mlir
///     %res = rock.transforming_for (%a1, %a2, %a3) = [#transform_map1](%i0, %j0), (%i, %j) = [](%cst0, %cst0)
///       (%v1, %v2) = validity
///       iter_args(%arg0 = %c0) -> (index) bounds = [4, 8] strides = [1, 1]{
///       %v = rock.buffer_load {...} %place[%a1, %a2, %a3] if %v1
///       rock.buffer_store {...} %v -> %buffer[%i, %j] if %v2
///       %cont = addi %arg0, %c1
///       rock.yield %cont : index
///     }
///     ```
///     will lower to
///     ```mlir
///     %res = affine.for %d0 = 0 to 4 step 1 (%arg0 = %cst0 : index) {
///       %res1 = affine.for %d1 = 0 to 8 step 1 (%arg1 = %arg0 : index) {
///         %i0_shifted = arith.addi %i0, %d0
///         %j0_shifted = arith.addi %j0, %d1
///         %a1, %a2, %a3 = [expand affine map in #transform_map1 at %i0_shifted, %j0_shifted]
///         %v1 = [compute validity in #transform_map1 as needed]
///         %v2 = true
///         %v = rock.buffer_load {...} %place[%a1, %a2, %a3]
///         rock.buffer_store {...} %v -> %buffer[%d0, %d1]
///         %cont = arith.addi %arg1, %c1 : index
///         affine.yield %cont : index
///       }
///       affine.yield %res1
///     }
///     ```
/// 
///     When multiple transform_maps are specified for an interatino domain,
///     they are composed, with the left one applying first (to the upper coordinates),
///     and a lack of transform_maps simply passes the upper cooridate values through.
/// 
///     If `strides` is not specified during building, it will default to all 1s.
/// 
///     If the `forceUnroll` attribute is specified, the loops above are unrolled
///     after being generated.
/// 
///     If `useIndexDiffs` is set, instead of computing the affine map within each
///     loop, the index diff mechanism is used to determine the change in the lower
///     coordinates based on the induction variables of the affine loops and
///     the values of the lower coordinates at the initial start values.
/// 
///     The purpose of this looping construct is to remove redundancy and make the
///     application of coordinate transformations more explicit in the IR.
class TransformingForOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Setup an workgroup barrier
/// The `rock.workgroup_barrier` op sets up a workgroup-level barrier.
class WorkgroupBarrierOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Get current workgroup ID
/// The `rock.workgroup_id` op gets the current workgroup ID.
class WorkgroupIdOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// Get current workitem ID
/// The `rock.workgroup_id` op gets the current workitem ID.
class WorkitemIdOp;
} // namespace rock
} // namespace mlir
namespace mlir {
namespace rock {
/// yield for Rock loops
/// Op that terminates the Rock looping constructs (currently transforming for).
/// 
///     If the loops produce any values, then this op's arguments should match the types
///     of those values. Otherwise, this op is implicit and can be omitted.
/// 
///     Note that, in a transforming_for, you don't need to yield back the lower coordinates,
///     as these are managed implicitly.
class YieldOp;
} // namespace rock
} // namespace mlir
#ifdef GET_OP_CLASSES
#undef GET_OP_CLASSES

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::AttentionOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class AttentionOpGenericAdaptorBase {
public:
  struct Properties {
    using causalTy = ::mlir::UnitAttr;
    causalTy causal;

    auto getCausal() const {
      auto &propStorage = this->causal;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setCausal(const ::mlir::UnitAttr &propValue) {
      this->causal = propValue;
    }
    using featuresTy = ::mlir::rock::GemmFeaturesAttr;
    featuresTy features;

    auto getFeatures() const {
      auto &propStorage = this->features;
      return ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(propStorage);
    }
    void setFeatures(const ::mlir::rock::GemmFeaturesAttr &propValue) {
      this->features = propValue;
    }
    using firstGemmIndicesTy = ::mlir::DenseI64ArrayAttr;
    firstGemmIndicesTy firstGemmIndices;

    auto getFirstGemmIndices() const {
      auto &propStorage = this->firstGemmIndices;
      return ::llvm::cast<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setFirstGemmIndices(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->firstGemmIndices = propValue;
    }
    using kTransposedTy = ::mlir::UnitAttr;
    kTransposedTy kTransposed;

    auto getKTransposed() const {
      auto &propStorage = this->kTransposed;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setKTransposed(const ::mlir::UnitAttr &propValue) {
      this->kTransposed = propValue;
    }
    using numHeadsKVTy = ::mlir::IntegerAttr;
    numHeadsKVTy numHeadsKV;

    auto getNumHeadsKV() const {
      auto &propStorage = this->numHeadsKV;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setNumHeadsKV(const ::mlir::IntegerAttr &propValue) {
      this->numHeadsKV = propValue;
    }
    using numHeadsQTy = ::mlir::IntegerAttr;
    numHeadsQTy numHeadsQ;

    auto getNumHeadsQ() const {
      auto &propStorage = this->numHeadsQ;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setNumHeadsQ(const ::mlir::IntegerAttr &propValue) {
      this->numHeadsQ = propValue;
    }
    using oTransposedTy = ::mlir::UnitAttr;
    oTransposedTy oTransposed;

    auto getOTransposed() const {
      auto &propStorage = this->oTransposed;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setOTransposed(const ::mlir::UnitAttr &propValue) {
      this->oTransposed = propValue;
    }
    using params0Ty = ::mlir::rock::RockTuningParamAttrInterface;
    params0Ty params0;

    auto getParams0() const {
      auto &propStorage = this->params0;
      return ::llvm::dyn_cast_or_null<::mlir::rock::RockTuningParamAttrInterface>(propStorage);
    }
    void setParams0(const ::mlir::rock::RockTuningParamAttrInterface &propValue) {
      this->params0 = propValue;
    }
    using params1Ty = ::mlir::rock::RockTuningParamAttrInterface;
    params1Ty params1;

    auto getParams1() const {
      auto &propStorage = this->params1;
      return ::llvm::dyn_cast_or_null<::mlir::rock::RockTuningParamAttrInterface>(propStorage);
    }
    void setParams1(const ::mlir::rock::RockTuningParamAttrInterface &propValue) {
      this->params1 = propValue;
    }
    using qTransposedTy = ::mlir::UnitAttr;
    qTransposedTy qTransposed;

    auto getQTransposed() const {
      auto &propStorage = this->qTransposed;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setQTransposed(const ::mlir::UnitAttr &propValue) {
      this->qTransposed = propValue;
    }
    using softmaxTypeTy = ::mlir::TypeAttr;
    softmaxTypeTy softmaxType;

    auto getSoftmaxType() const {
      auto &propStorage = this->softmaxType;
      return ::llvm::dyn_cast_or_null<::mlir::TypeAttr>(propStorage);
    }
    void setSoftmaxType(const ::mlir::TypeAttr &propValue) {
      this->softmaxType = propValue;
    }
    using splitKVTy = ::mlir::IntegerAttr;
    splitKVTy splitKV;

    auto getSplitKV() const {
      auto &propStorage = this->splitKV;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSplitKV(const ::mlir::IntegerAttr &propValue) {
      this->splitKV = propValue;
    }
    using storeMethodTy = ::mlir::rock::StoreMethodAttr;
    storeMethodTy storeMethod;

    auto getStoreMethod() const {
      auto &propStorage = this->storeMethod;
      return ::llvm::cast<::mlir::rock::StoreMethodAttr>(propStorage);
    }
    void setStoreMethod(const ::mlir::rock::StoreMethodAttr &propValue) {
      this->storeMethod = propValue;
    }
    using vTransposedTy = ::mlir::UnitAttr;
    vTransposedTy vTransposed;

    auto getVTransposed() const {
      auto &propStorage = this->vTransposed;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setVTransposed(const ::mlir::UnitAttr &propValue) {
      this->vTransposed = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 7>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    using resultSegmentSizesTy = std::array<int32_t, 2>;
    resultSegmentSizesTy resultSegmentSizes;
    ::llvm::ArrayRef<int32_t> getResultSegmentSizes() const {
      auto &propStorage = this->resultSegmentSizes;
      return propStorage;
    }
    void setResultSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->resultSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.causal == this->causal &&
        rhs.features == this->features &&
        rhs.firstGemmIndices == this->firstGemmIndices &&
        rhs.kTransposed == this->kTransposed &&
        rhs.numHeadsKV == this->numHeadsKV &&
        rhs.numHeadsQ == this->numHeadsQ &&
        rhs.oTransposed == this->oTransposed &&
        rhs.params0 == this->params0 &&
        rhs.params1 == this->params1 &&
        rhs.qTransposed == this->qTransposed &&
        rhs.softmaxType == this->softmaxType &&
        rhs.splitKV == this->splitKV &&
        rhs.storeMethod == this->storeMethod &&
        rhs.vTransposed == this->vTransposed &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        rhs.resultSegmentSizes == this->resultSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  AttentionOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.attention", odsAttrs.getContext());
  }

  AttentionOpGenericAdaptorBase(AttentionOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getNumHeadsQAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().numHeadsQ);
    return attr;
  }

  uint32_t getNumHeadsQ();
  ::mlir::IntegerAttr getNumHeadsKVAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().numHeadsKV);
    return attr;
  }

  uint32_t getNumHeadsKV();
  ::mlir::UnitAttr getQTransposedAttr();
  bool getQTransposed();
  ::mlir::UnitAttr getKTransposedAttr();
  bool getKTransposed();
  ::mlir::UnitAttr getVTransposedAttr();
  bool getVTransposed();
  ::mlir::UnitAttr getOTransposedAttr();
  bool getOTransposed();
  ::mlir::UnitAttr getCausalAttr();
  bool getCausal();
  ::mlir::IntegerAttr getSplitKVAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().splitKV);
    return attr;
  }

  uint32_t getSplitKV();
  ::mlir::rock::GemmFeaturesAttr getFeaturesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(getProperties().features);
    return attr;
  }

  ::std::optional<::mlir::rock::GemmFeatures> getFeatures();
  ::mlir::rock::StoreMethodAttr getStoreMethodAttr() {
    auto attr = ::llvm::cast<::mlir::rock::StoreMethodAttr>(getProperties().storeMethod);
    return attr;
  }

  ::mlir::rock::StoreMethod getStoreMethod();
  ::mlir::TypeAttr getSoftmaxTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::TypeAttr>(getProperties().softmaxType);
    return attr;
  }

  ::std::optional<::mlir::Type> getSoftmaxType();
  ::mlir::rock::RockTuningParamAttrInterface getParams0Attr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::rock::RockTuningParamAttrInterface>(getProperties().params0);
    return attr;
  }

  ::std::optional<::mlir::rock::RockTuningParamAttrInterface> getParams0();
  ::mlir::rock::RockTuningParamAttrInterface getParams1Attr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::rock::RockTuningParamAttrInterface>(getProperties().params1);
    return attr;
  }

  ::std::optional<::mlir::rock::RockTuningParamAttrInterface> getParams1();
  ::mlir::DenseI64ArrayAttr getFirstGemmIndicesAttr() {
    auto attr = ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().firstGemmIndices);
    return attr;
  }

  ::llvm::ArrayRef<int64_t> getFirstGemmIndices();
  ::mlir::Region &getPreSoftmaxBody() {
    return *odsRegions[0];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};
} // namespace detail
template <typename RangeT>
class AttentionOpGenericAdaptor : public detail::AttentionOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::AttentionOpGenericAdaptorBase;
  static constexpr int odsIndex_queries = 0;
  static constexpr int odsIndex_keys = 1;
  static constexpr int odsIndex_values = 2;
  static constexpr int odsIndex_preSoftmaxElemWiseInputs = 3;
  static constexpr int odsIndex_currentSeqLen = 4;
  static constexpr int odsIndex_out = 5;
  static constexpr int odsIndex_lse = 6;
public:
  AttentionOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  AttentionOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : AttentionOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  AttentionOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : AttentionOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  AttentionOpGenericAdaptor(RangeT values, const AttentionOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = AttentionOp, typename = std::enable_if_t<std::is_same_v<LateInst, AttentionOp>>>
  AttentionOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getQueries() {
    return (*getODSOperands(0).begin());
  }

  ValueT getKeys() {
    return (*getODSOperands(1).begin());
  }

  ValueT getValues() {
    return (*getODSOperands(2).begin());
  }

  RangeT getPreSoftmaxElemWiseInputs() {
    return getODSOperands(3);
  }

  ValueT getCurrentSeqLen() {
    auto operands = getODSOperands(4);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getOut() {
    return (*getODSOperands(5).begin());
  }

  ValueT getLse() {
    auto operands = getODSOperands(6);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class AttentionOpAdaptor : public AttentionOpGenericAdaptor<::mlir::ValueRange> {
public:
  using AttentionOpGenericAdaptor::AttentionOpGenericAdaptor;
  AttentionOpAdaptor(AttentionOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class AttentionOp : public ::mlir::Op<AttentionOp, ::mlir::OpTrait::OneRegion, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<4>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::AttrSizedResultSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::rock::RockGemmGemmWrapperInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::rock::RockGemmFeaturesInterface::Trait, mlir::OpTrait::rock::FusionRoot, ::mlir::OpAsmOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = AttentionOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = AttentionOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_queries = 0;
  static constexpr int odsIndex_keys = 1;
  static constexpr int odsIndex_values = 2;
  static constexpr int odsIndex_preSoftmaxElemWiseInputs = 3;
  static constexpr int odsIndex_currentSeqLen = 4;
  static constexpr int odsIndex_out = 5;
  static constexpr int odsIndex_lse = 6;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("causal"), ::llvm::StringRef("features"), ::llvm::StringRef("firstGemmIndices"), ::llvm::StringRef("kTransposed"), ::llvm::StringRef("numHeadsKV"), ::llvm::StringRef("numHeadsQ"), ::llvm::StringRef("oTransposed"), ::llvm::StringRef("params0"), ::llvm::StringRef("params1"), ::llvm::StringRef("qTransposed"), ::llvm::StringRef("softmaxType"), ::llvm::StringRef("splitKV"), ::llvm::StringRef("storeMethod"), ::llvm::StringRef("vTransposed"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getCausalAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getCausalAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getFeaturesAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getFeaturesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getFirstGemmIndicesAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getFirstGemmIndicesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getKTransposedAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getKTransposedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getNumHeadsKVAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getNumHeadsKVAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getNumHeadsQAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getNumHeadsQAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getOTransposedAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getOTransposedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getParams0AttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getParams0AttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getParams1AttrName() {
    return getAttributeNameForIndex(8);
  }

  static ::mlir::StringAttr getParams1AttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 8);
  }

  ::mlir::StringAttr getQTransposedAttrName() {
    return getAttributeNameForIndex(9);
  }

  static ::mlir::StringAttr getQTransposedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 9);
  }

  ::mlir::StringAttr getSoftmaxTypeAttrName() {
    return getAttributeNameForIndex(10);
  }

  static ::mlir::StringAttr getSoftmaxTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 10);
  }

  ::mlir::StringAttr getSplitKVAttrName() {
    return getAttributeNameForIndex(11);
  }

  static ::mlir::StringAttr getSplitKVAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 11);
  }

  ::mlir::StringAttr getStoreMethodAttrName() {
    return getAttributeNameForIndex(12);
  }

  static ::mlir::StringAttr getStoreMethodAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 12);
  }

  ::mlir::StringAttr getVTransposedAttrName() {
    return getAttributeNameForIndex(13);
  }

  static ::mlir::StringAttr getVTransposedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 13);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  void getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn);
  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.attention");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::ShapedType> getQueries() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::ShapedType> getKeys() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::ShapedType> getValues() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*getODSOperands(2).begin());
  }

  ::mlir::Operation::operand_range getPreSoftmaxElemWiseInputs() {
    return getODSOperands(3);
  }

  ::mlir::TypedValue<::mlir::ShapedType> getCurrentSeqLen() {
    auto operands = getODSOperands(4);
    return operands.empty() ? ::mlir::TypedValue<::mlir::ShapedType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::ShapedType> getOut() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*getODSOperands(5).begin());
  }

  ::mlir::TypedValue<::mlir::ShapedType> getLse() {
    auto operands = getODSOperands(6);
    return operands.empty() ? ::mlir::TypedValue<::mlir::ShapedType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*operands.begin());
  }

  ::mlir::OpOperand &getQueriesMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getKeysMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getValuesMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getPreSoftmaxElemWiseInputsMutable();
  ::mlir::MutableOperandRange getCurrentSeqLenMutable();
  ::mlir::OpOperand &getOutMutable() {
    auto range = getODSOperandIndexAndLength(5);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getLseMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getResult() {
    auto results = getODSResults(0);
    return results.empty() ? ::mlir::TypedValue<::mlir::TensorType>() : ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*results.begin());
  }

  ::mlir::TypedValue<::mlir::TensorType> getLseOut() {
    auto results = getODSResults(1);
    return results.empty() ? ::mlir::TypedValue<::mlir::TensorType>() : ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*results.begin());
  }

  ::mlir::Region &getPreSoftmaxBody() {
    return (*this)->getRegion(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getNumHeadsQAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().numHeadsQ);
  }

  uint32_t getNumHeadsQ();
  ::mlir::IntegerAttr getNumHeadsKVAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().numHeadsKV);
  }

  uint32_t getNumHeadsKV();
  ::mlir::UnitAttr getQTransposedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().qTransposed);
  }

  bool getQTransposed();
  ::mlir::UnitAttr getKTransposedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().kTransposed);
  }

  bool getKTransposed();
  ::mlir::UnitAttr getVTransposedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().vTransposed);
  }

  bool getVTransposed();
  ::mlir::UnitAttr getOTransposedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().oTransposed);
  }

  bool getOTransposed();
  ::mlir::UnitAttr getCausalAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().causal);
  }

  bool getCausal();
  ::mlir::IntegerAttr getSplitKVAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().splitKV);
  }

  uint32_t getSplitKV();
  ::mlir::rock::GemmFeaturesAttr getFeaturesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(getProperties().features);
  }

  ::std::optional<::mlir::rock::GemmFeatures> getFeatures();
  ::mlir::rock::StoreMethodAttr getStoreMethodAttr() {
    return ::llvm::cast<::mlir::rock::StoreMethodAttr>(getProperties().storeMethod);
  }

  ::mlir::rock::StoreMethod getStoreMethod();
  ::mlir::TypeAttr getSoftmaxTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::TypeAttr>(getProperties().softmaxType);
  }

  ::std::optional<::mlir::Type> getSoftmaxType();
  ::mlir::rock::RockTuningParamAttrInterface getParams0Attr() {
    return ::llvm::dyn_cast_or_null<::mlir::rock::RockTuningParamAttrInterface>(getProperties().params0);
  }

  ::std::optional<::mlir::rock::RockTuningParamAttrInterface> getParams0();
  ::mlir::rock::RockTuningParamAttrInterface getParams1Attr() {
    return ::llvm::dyn_cast_or_null<::mlir::rock::RockTuningParamAttrInterface>(getProperties().params1);
  }

  ::std::optional<::mlir::rock::RockTuningParamAttrInterface> getParams1();
  ::mlir::DenseI64ArrayAttr getFirstGemmIndicesAttr() {
    return ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().firstGemmIndices);
  }

  ::llvm::ArrayRef<int64_t> getFirstGemmIndices();
  void setNumHeadsQAttr(::mlir::IntegerAttr attr) {
    getProperties().numHeadsQ = attr;
  }

  void setNumHeadsQ(uint32_t attrValue);
  void setNumHeadsKVAttr(::mlir::IntegerAttr attr) {
    getProperties().numHeadsKV = attr;
  }

  void setNumHeadsKV(uint32_t attrValue);
  void setQTransposedAttr(::mlir::UnitAttr attr) {
    getProperties().qTransposed = attr;
  }

  void setQTransposed(bool attrValue);
  void setKTransposedAttr(::mlir::UnitAttr attr) {
    getProperties().kTransposed = attr;
  }

  void setKTransposed(bool attrValue);
  void setVTransposedAttr(::mlir::UnitAttr attr) {
    getProperties().vTransposed = attr;
  }

  void setVTransposed(bool attrValue);
  void setOTransposedAttr(::mlir::UnitAttr attr) {
    getProperties().oTransposed = attr;
  }

  void setOTransposed(bool attrValue);
  void setCausalAttr(::mlir::UnitAttr attr) {
    getProperties().causal = attr;
  }

  void setCausal(bool attrValue);
  void setSplitKVAttr(::mlir::IntegerAttr attr) {
    getProperties().splitKV = attr;
  }

  void setSplitKV(uint32_t attrValue);
  void setFeaturesAttr(::mlir::rock::GemmFeaturesAttr attr) {
    getProperties().features = attr;
  }

  void setFeatures(::std::optional<::mlir::rock::GemmFeatures> attrValue);
  void setStoreMethodAttr(::mlir::rock::StoreMethodAttr attr) {
    getProperties().storeMethod = attr;
  }

  void setStoreMethod(::mlir::rock::StoreMethod attrValue);
  void setSoftmaxTypeAttr(::mlir::TypeAttr attr) {
    getProperties().softmaxType = attr;
  }

  void setSoftmaxType(::std::optional<::mlir::Type> attrValue);
  void setParams0Attr(::mlir::rock::RockTuningParamAttrInterface attr) {
    getProperties().params0 = attr;
  }

  void setParams1Attr(::mlir::rock::RockTuningParamAttrInterface attr) {
    getProperties().params1 = attr;
  }

  void setFirstGemmIndicesAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().firstGemmIndices = attr;
  }

  void setFirstGemmIndices(::llvm::ArrayRef<int64_t> attrValue);
  ::mlir::Attribute removeQTransposedAttr() {
      auto attr = getProperties().qTransposed;
      getProperties().qTransposed = {};
      return attr;
  }

  ::mlir::Attribute removeKTransposedAttr() {
      auto attr = getProperties().kTransposed;
      getProperties().kTransposed = {};
      return attr;
  }

  ::mlir::Attribute removeVTransposedAttr() {
      auto attr = getProperties().vTransposed;
      getProperties().vTransposed = {};
      return attr;
  }

  ::mlir::Attribute removeOTransposedAttr() {
      auto attr = getProperties().oTransposed;
      getProperties().oTransposed = {};
      return attr;
  }

  ::mlir::Attribute removeCausalAttr() {
      auto attr = getProperties().causal;
      getProperties().causal = {};
      return attr;
  }

  ::mlir::Attribute removeFeaturesAttr() {
      auto attr = getProperties().features;
      getProperties().features = {};
      return attr;
  }

  ::mlir::Attribute removeSoftmaxTypeAttr() {
      auto attr = getProperties().softmaxType;
      getProperties().softmaxType = {};
      return attr;
  }

  ::mlir::Attribute removeParams0Attr() {
      auto attr = getProperties().params0;
      getProperties().params0 = {};
      return attr;
  }

  ::mlir::Attribute removeParams1Attr() {
      auto attr = getProperties().params1;
      getProperties().params1 = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Type result, /*optional*/::mlir::Type lseOut, ::mlir::Value queries, ::mlir::Value keys, ::mlir::Value values, ::mlir::ValueRange preSoftmaxElemWiseInputs, /*optional*/::mlir::Value currentSeqLen, ::mlir::Value out, /*optional*/::mlir::Value lse, ::mlir::IntegerAttr numHeadsQ, ::mlir::IntegerAttr numHeadsKV, /*optional*/::mlir::UnitAttr qTransposed, /*optional*/::mlir::UnitAttr kTransposed, /*optional*/::mlir::UnitAttr vTransposed, /*optional*/::mlir::UnitAttr oTransposed, /*optional*/::mlir::UnitAttr causal, ::mlir::IntegerAttr splitKV, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, /*optional*/::mlir::TypeAttr softmaxType, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::mlir::DenseI64ArrayAttr firstGemmIndices);
  static AttentionOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Type result, /*optional*/::mlir::Type lseOut, ::mlir::Value queries, ::mlir::Value keys, ::mlir::Value values, ::mlir::ValueRange preSoftmaxElemWiseInputs, /*optional*/::mlir::Value currentSeqLen, ::mlir::Value out, /*optional*/::mlir::Value lse, ::mlir::IntegerAttr numHeadsQ, ::mlir::IntegerAttr numHeadsKV, /*optional*/::mlir::UnitAttr qTransposed, /*optional*/::mlir::UnitAttr kTransposed, /*optional*/::mlir::UnitAttr vTransposed, /*optional*/::mlir::UnitAttr oTransposed, /*optional*/::mlir::UnitAttr causal, ::mlir::IntegerAttr splitKV, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, /*optional*/::mlir::TypeAttr softmaxType, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::mlir::DenseI64ArrayAttr firstGemmIndices);
  static AttentionOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Type result, /*optional*/::mlir::Type lseOut, ::mlir::Value queries, ::mlir::Value keys, ::mlir::Value values, ::mlir::ValueRange preSoftmaxElemWiseInputs, /*optional*/::mlir::Value currentSeqLen, ::mlir::Value out, /*optional*/::mlir::Value lse, ::mlir::IntegerAttr numHeadsQ, ::mlir::IntegerAttr numHeadsKV, /*optional*/::mlir::UnitAttr qTransposed, /*optional*/::mlir::UnitAttr kTransposed, /*optional*/::mlir::UnitAttr vTransposed, /*optional*/::mlir::UnitAttr oTransposed, /*optional*/::mlir::UnitAttr causal, ::mlir::IntegerAttr splitKV, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, /*optional*/::mlir::TypeAttr softmaxType, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::mlir::DenseI64ArrayAttr firstGemmIndices);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value queries, ::mlir::Value keys, ::mlir::Value values, ::mlir::ValueRange preSoftmaxElemWiseInputs, /*optional*/::mlir::Value currentSeqLen, ::mlir::Value out, /*optional*/::mlir::Value lse, ::mlir::IntegerAttr numHeadsQ, ::mlir::IntegerAttr numHeadsKV, /*optional*/::mlir::UnitAttr qTransposed, /*optional*/::mlir::UnitAttr kTransposed, /*optional*/::mlir::UnitAttr vTransposed, /*optional*/::mlir::UnitAttr oTransposed, /*optional*/::mlir::UnitAttr causal, ::mlir::IntegerAttr splitKV, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, /*optional*/::mlir::TypeAttr softmaxType, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::mlir::DenseI64ArrayAttr firstGemmIndices);
  static AttentionOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value queries, ::mlir::Value keys, ::mlir::Value values, ::mlir::ValueRange preSoftmaxElemWiseInputs, /*optional*/::mlir::Value currentSeqLen, ::mlir::Value out, /*optional*/::mlir::Value lse, ::mlir::IntegerAttr numHeadsQ, ::mlir::IntegerAttr numHeadsKV, /*optional*/::mlir::UnitAttr qTransposed, /*optional*/::mlir::UnitAttr kTransposed, /*optional*/::mlir::UnitAttr vTransposed, /*optional*/::mlir::UnitAttr oTransposed, /*optional*/::mlir::UnitAttr causal, ::mlir::IntegerAttr splitKV, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, /*optional*/::mlir::TypeAttr softmaxType, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::mlir::DenseI64ArrayAttr firstGemmIndices);
  static AttentionOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value queries, ::mlir::Value keys, ::mlir::Value values, ::mlir::ValueRange preSoftmaxElemWiseInputs, /*optional*/::mlir::Value currentSeqLen, ::mlir::Value out, /*optional*/::mlir::Value lse, ::mlir::IntegerAttr numHeadsQ, ::mlir::IntegerAttr numHeadsKV, /*optional*/::mlir::UnitAttr qTransposed, /*optional*/::mlir::UnitAttr kTransposed, /*optional*/::mlir::UnitAttr vTransposed, /*optional*/::mlir::UnitAttr oTransposed, /*optional*/::mlir::UnitAttr causal, ::mlir::IntegerAttr splitKV, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, /*optional*/::mlir::TypeAttr softmaxType, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::mlir::DenseI64ArrayAttr firstGemmIndices);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Type result, /*optional*/::mlir::Type lseOut, ::mlir::Value queries, ::mlir::Value keys, ::mlir::Value values, ::mlir::ValueRange preSoftmaxElemWiseInputs, /*optional*/::mlir::Value currentSeqLen, ::mlir::Value out, /*optional*/::mlir::Value lse, uint32_t numHeadsQ, uint32_t numHeadsKV, /*optional*/bool qTransposed, /*optional*/bool kTransposed, /*optional*/bool vTransposed, /*optional*/bool oTransposed, /*optional*/bool causal, uint32_t splitKV, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, /*optional*/::mlir::TypeAttr softmaxType, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::llvm::ArrayRef<int64_t> firstGemmIndices);
  static AttentionOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Type result, /*optional*/::mlir::Type lseOut, ::mlir::Value queries, ::mlir::Value keys, ::mlir::Value values, ::mlir::ValueRange preSoftmaxElemWiseInputs, /*optional*/::mlir::Value currentSeqLen, ::mlir::Value out, /*optional*/::mlir::Value lse, uint32_t numHeadsQ, uint32_t numHeadsKV, /*optional*/bool qTransposed, /*optional*/bool kTransposed, /*optional*/bool vTransposed, /*optional*/bool oTransposed, /*optional*/bool causal, uint32_t splitKV, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, /*optional*/::mlir::TypeAttr softmaxType, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::llvm::ArrayRef<int64_t> firstGemmIndices);
  static AttentionOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Type result, /*optional*/::mlir::Type lseOut, ::mlir::Value queries, ::mlir::Value keys, ::mlir::Value values, ::mlir::ValueRange preSoftmaxElemWiseInputs, /*optional*/::mlir::Value currentSeqLen, ::mlir::Value out, /*optional*/::mlir::Value lse, uint32_t numHeadsQ, uint32_t numHeadsKV, /*optional*/bool qTransposed, /*optional*/bool kTransposed, /*optional*/bool vTransposed, /*optional*/bool oTransposed, /*optional*/bool causal, uint32_t splitKV, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, /*optional*/::mlir::TypeAttr softmaxType, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::llvm::ArrayRef<int64_t> firstGemmIndices);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value queries, ::mlir::Value keys, ::mlir::Value values, ::mlir::ValueRange preSoftmaxElemWiseInputs, /*optional*/::mlir::Value currentSeqLen, ::mlir::Value out, /*optional*/::mlir::Value lse, uint32_t numHeadsQ, uint32_t numHeadsKV, /*optional*/bool qTransposed, /*optional*/bool kTransposed, /*optional*/bool vTransposed, /*optional*/bool oTransposed, /*optional*/bool causal, uint32_t splitKV, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, /*optional*/::mlir::TypeAttr softmaxType, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::llvm::ArrayRef<int64_t> firstGemmIndices);
  static AttentionOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value queries, ::mlir::Value keys, ::mlir::Value values, ::mlir::ValueRange preSoftmaxElemWiseInputs, /*optional*/::mlir::Value currentSeqLen, ::mlir::Value out, /*optional*/::mlir::Value lse, uint32_t numHeadsQ, uint32_t numHeadsKV, /*optional*/bool qTransposed, /*optional*/bool kTransposed, /*optional*/bool vTransposed, /*optional*/bool oTransposed, /*optional*/bool causal, uint32_t splitKV, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, /*optional*/::mlir::TypeAttr softmaxType, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::llvm::ArrayRef<int64_t> firstGemmIndices);
  static AttentionOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value queries, ::mlir::Value keys, ::mlir::Value values, ::mlir::ValueRange preSoftmaxElemWiseInputs, /*optional*/::mlir::Value currentSeqLen, ::mlir::Value out, /*optional*/::mlir::Value lse, uint32_t numHeadsQ, uint32_t numHeadsKV, /*optional*/bool qTransposed, /*optional*/bool kTransposed, /*optional*/bool vTransposed, /*optional*/bool oTransposed, /*optional*/bool causal, uint32_t splitKV, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, /*optional*/::mlir::TypeAttr softmaxType, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::llvm::ArrayRef<int64_t> firstGemmIndices);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AttentionOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static AttentionOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AttentionOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static AttentionOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::mlir::rock::KernelType getKernelType();
  OpOperand *getOutArgument();
  ::mlir::rock::GemmGemmSize getGemmGemmSize();
  ::mlir::Type getAType();
  ::mlir::Type getBType();
  ::mlir::Type getCType();
  ::mlir::Type getOutType();
  bool getTransposedA();
  bool getTransposedB();
  bool getTransposedC();
  bool getTransposedOut();
  Region&getPreSecondGemmRegion();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  SmallVector<::mlir::Type> getTypesForFeature();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 14 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  ::mlir::OpOperand* getOutLseArgument() { return getLse() ? &(*this)->getOpOperand(getNumOperands() - 1) : nullptr; }
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::AttentionOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::BlockwiseBroadcastReduceOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BlockwiseBroadcastReduceOpGenericAdaptorBase {
public:
  struct Properties {
    using axisTy = ::mlir::IntegerAttr;
    axisTy axis;

    auto getAxis() const {
      auto &propStorage = this->axis;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setAxis(const ::mlir::IntegerAttr &propValue) {
      this->axis = propValue;
    }
    using blockSizeTy = ::mlir::IntegerAttr;
    blockSizeTy blockSize;

    auto getBlockSize() const {
      auto &propStorage = this->blockSize;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setBlockSize(const ::mlir::IntegerAttr &propValue) {
      this->blockSize = propValue;
    }
    using extraOutViewTy = ::mlir::ArrayAttr;
    extraOutViewTy extraOutView;

    auto getExtraOutView() const {
      auto &propStorage = this->extraOutView;
      return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(propStorage);
    }
    void setExtraOutView(const ::mlir::ArrayAttr &propValue) {
      this->extraOutView = propValue;
    }
    using inputRegViewTy = ::mlir::ArrayAttr;
    inputRegViewTy inputRegView;

    auto getInputRegView() const {
      auto &propStorage = this->inputRegView;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setInputRegView(const ::mlir::ArrayAttr &propValue) {
      this->inputRegView = propValue;
    }
    using iterSubTileSliceViewTy = ::mlir::ArrayAttr;
    iterSubTileSliceViewTy iterSubTileSliceView;

    auto getIterSubTileSliceView() const {
      auto &propStorage = this->iterSubTileSliceView;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setIterSubTileSliceView(const ::mlir::ArrayAttr &propValue) {
      this->iterSubTileSliceView = propValue;
    }
    using reduceMethodTy = ::mlir::rock::ReduceMethodAttr;
    reduceMethodTy reduceMethod;

    auto getReduceMethod() const {
      auto &propStorage = this->reduceMethod;
      return ::llvm::cast<::mlir::rock::ReduceMethodAttr>(propStorage);
    }
    void setReduceMethod(const ::mlir::rock::ReduceMethodAttr &propValue) {
      this->reduceMethod = propValue;
    }
    using tidSubTileSliceViewTy = ::mlir::ArrayAttr;
    tidSubTileSliceViewTy tidSubTileSliceView;

    auto getTidSubTileSliceView() const {
      auto &propStorage = this->tidSubTileSliceView;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setTidSubTileSliceView(const ::mlir::ArrayAttr &propValue) {
      this->tidSubTileSliceView = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.axis == this->axis &&
        rhs.blockSize == this->blockSize &&
        rhs.extraOutView == this->extraOutView &&
        rhs.inputRegView == this->inputRegView &&
        rhs.iterSubTileSliceView == this->iterSubTileSliceView &&
        rhs.reduceMethod == this->reduceMethod &&
        rhs.tidSubTileSliceView == this->tidSubTileSliceView &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BlockwiseBroadcastReduceOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.blockwise_broadcast_reduce", odsAttrs.getContext());
  }

  BlockwiseBroadcastReduceOpGenericAdaptorBase(BlockwiseBroadcastReduceOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getAxisAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().axis);
    return attr;
  }

  ::llvm::APInt getAxis();
  ::mlir::rock::ReduceMethodAttr getReduceMethodAttr() {
    auto attr = ::llvm::cast<::mlir::rock::ReduceMethodAttr>(getProperties().reduceMethod);
    return attr;
  }

  ::mlir::rock::ReduceMethod getReduceMethod();
  ::mlir::ArrayAttr getInputRegViewAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().inputRegView);
    return attr;
  }

  ::mlir::ArrayAttr getInputRegView();
  ::mlir::ArrayAttr getTidSubTileSliceViewAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().tidSubTileSliceView);
    return attr;
  }

  ::mlir::ArrayAttr getTidSubTileSliceView();
  ::mlir::ArrayAttr getIterSubTileSliceViewAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().iterSubTileSliceView);
    return attr;
  }

  ::mlir::ArrayAttr getIterSubTileSliceView();
  ::mlir::ArrayAttr getExtraOutViewAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().extraOutView);
    return attr;
  }

  ::std::optional< ::mlir::ArrayAttr > getExtraOutView();
  ::mlir::IntegerAttr getBlockSizeAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().blockSize);
    return attr;
  }

  uint32_t getBlockSize();
};
} // namespace detail
template <typename RangeT>
class BlockwiseBroadcastReduceOpGenericAdaptor : public detail::BlockwiseBroadcastReduceOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BlockwiseBroadcastReduceOpGenericAdaptorBase;
  static constexpr int odsIndex_input = 0;
  static constexpr int odsIndex_workspace_buffer = 1;
  static constexpr int odsIndex_output = 2;
  static constexpr int odsIndex_extraOut = 3;
public:
  BlockwiseBroadcastReduceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BlockwiseBroadcastReduceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BlockwiseBroadcastReduceOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BlockwiseBroadcastReduceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BlockwiseBroadcastReduceOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BlockwiseBroadcastReduceOpGenericAdaptor(RangeT values, const BlockwiseBroadcastReduceOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BlockwiseBroadcastReduceOp, typename = std::enable_if_t<std::is_same_v<LateInst, BlockwiseBroadcastReduceOp>>>
  BlockwiseBroadcastReduceOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  ValueT getWorkspaceBuffer() {
    return (*getODSOperands(1).begin());
  }

  ValueT getOutput() {
    return (*getODSOperands(2).begin());
  }

  ValueT getExtraOut() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BlockwiseBroadcastReduceOpAdaptor : public BlockwiseBroadcastReduceOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BlockwiseBroadcastReduceOpGenericAdaptor::BlockwiseBroadcastReduceOpGenericAdaptor;
  BlockwiseBroadcastReduceOpAdaptor(BlockwiseBroadcastReduceOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BlockwiseBroadcastReduceOp : public ::mlir::Op<BlockwiseBroadcastReduceOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BlockwiseBroadcastReduceOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BlockwiseBroadcastReduceOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_input = 0;
  static constexpr int odsIndex_workspace_buffer = 1;
  static constexpr int odsIndex_output = 2;
  static constexpr int odsIndex_extraOut = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("axis"), ::llvm::StringRef("blockSize"), ::llvm::StringRef("extraOutView"), ::llvm::StringRef("inputRegView"), ::llvm::StringRef("iterSubTileSliceView"), ::llvm::StringRef("reduceMethod"), ::llvm::StringRef("tidSubTileSliceView")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAxisAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAxisAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getBlockSizeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getBlockSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getExtraOutViewAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getExtraOutViewAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getInputRegViewAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getInputRegViewAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getIterSubTileSliceViewAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getIterSubTileSliceViewAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getReduceMethodAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getReduceMethodAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getTidSubTileSliceViewAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getTidSubTileSliceViewAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.blockwise_broadcast_reduce");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::MemRefType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getWorkspaceBuffer() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getExtraOut() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ::mlir::TypedValue<::mlir::MemRefType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*operands.begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getWorkspaceBufferMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getOutputMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getExtraOutMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getAxisAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().axis);
  }

  ::llvm::APInt getAxis();
  ::mlir::rock::ReduceMethodAttr getReduceMethodAttr() {
    return ::llvm::cast<::mlir::rock::ReduceMethodAttr>(getProperties().reduceMethod);
  }

  ::mlir::rock::ReduceMethod getReduceMethod();
  ::mlir::ArrayAttr getInputRegViewAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().inputRegView);
  }

  ::mlir::ArrayAttr getInputRegView();
  ::mlir::ArrayAttr getTidSubTileSliceViewAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().tidSubTileSliceView);
  }

  ::mlir::ArrayAttr getTidSubTileSliceView();
  ::mlir::ArrayAttr getIterSubTileSliceViewAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().iterSubTileSliceView);
  }

  ::mlir::ArrayAttr getIterSubTileSliceView();
  ::mlir::ArrayAttr getExtraOutViewAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::ArrayAttr>(getProperties().extraOutView);
  }

  ::std::optional< ::mlir::ArrayAttr > getExtraOutView();
  ::mlir::IntegerAttr getBlockSizeAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().blockSize);
  }

  uint32_t getBlockSize();
  void setAxisAttr(::mlir::IntegerAttr attr) {
    getProperties().axis = attr;
  }

  void setAxis(::llvm::APInt attrValue);
  void setReduceMethodAttr(::mlir::rock::ReduceMethodAttr attr) {
    getProperties().reduceMethod = attr;
  }

  void setReduceMethod(::mlir::rock::ReduceMethod attrValue);
  void setInputRegViewAttr(::mlir::ArrayAttr attr) {
    getProperties().inputRegView = attr;
  }

  void setTidSubTileSliceViewAttr(::mlir::ArrayAttr attr) {
    getProperties().tidSubTileSliceView = attr;
  }

  void setIterSubTileSliceViewAttr(::mlir::ArrayAttr attr) {
    getProperties().iterSubTileSliceView = attr;
  }

  void setExtraOutViewAttr(::mlir::ArrayAttr attr) {
    getProperties().extraOutView = attr;
  }

  void setBlockSizeAttr(::mlir::IntegerAttr attr) {
    getProperties().blockSize = attr;
  }

  void setBlockSize(uint32_t attrValue);
  ::mlir::Attribute removeExtraOutViewAttr() {
      auto attr = getProperties().extraOutView;
      getProperties().extraOutView = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value input, ::mlir::Value workspace_buffer, ::mlir::Value output, /*optional*/::mlir::Value extraOut, ::mlir::IntegerAttr axis, ::mlir::rock::ReduceMethodAttr reduceMethod, ::mlir::ArrayAttr inputRegView, ::mlir::ArrayAttr tidSubTileSliceView, ::mlir::ArrayAttr iterSubTileSliceView, /*optional*/::mlir::ArrayAttr extraOutView, ::mlir::IntegerAttr blockSize);
  static BlockwiseBroadcastReduceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value input, ::mlir::Value workspace_buffer, ::mlir::Value output, /*optional*/::mlir::Value extraOut, ::mlir::IntegerAttr axis, ::mlir::rock::ReduceMethodAttr reduceMethod, ::mlir::ArrayAttr inputRegView, ::mlir::ArrayAttr tidSubTileSliceView, ::mlir::ArrayAttr iterSubTileSliceView, /*optional*/::mlir::ArrayAttr extraOutView, ::mlir::IntegerAttr blockSize);
  static BlockwiseBroadcastReduceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value input, ::mlir::Value workspace_buffer, ::mlir::Value output, /*optional*/::mlir::Value extraOut, ::mlir::IntegerAttr axis, ::mlir::rock::ReduceMethodAttr reduceMethod, ::mlir::ArrayAttr inputRegView, ::mlir::ArrayAttr tidSubTileSliceView, ::mlir::ArrayAttr iterSubTileSliceView, /*optional*/::mlir::ArrayAttr extraOutView, ::mlir::IntegerAttr blockSize);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value workspace_buffer, ::mlir::Value output, /*optional*/::mlir::Value extraOut, ::mlir::IntegerAttr axis, ::mlir::rock::ReduceMethodAttr reduceMethod, ::mlir::ArrayAttr inputRegView, ::mlir::ArrayAttr tidSubTileSliceView, ::mlir::ArrayAttr iterSubTileSliceView, /*optional*/::mlir::ArrayAttr extraOutView, ::mlir::IntegerAttr blockSize);
  static BlockwiseBroadcastReduceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value workspace_buffer, ::mlir::Value output, /*optional*/::mlir::Value extraOut, ::mlir::IntegerAttr axis, ::mlir::rock::ReduceMethodAttr reduceMethod, ::mlir::ArrayAttr inputRegView, ::mlir::ArrayAttr tidSubTileSliceView, ::mlir::ArrayAttr iterSubTileSliceView, /*optional*/::mlir::ArrayAttr extraOutView, ::mlir::IntegerAttr blockSize);
  static BlockwiseBroadcastReduceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value workspace_buffer, ::mlir::Value output, /*optional*/::mlir::Value extraOut, ::mlir::IntegerAttr axis, ::mlir::rock::ReduceMethodAttr reduceMethod, ::mlir::ArrayAttr inputRegView, ::mlir::ArrayAttr tidSubTileSliceView, ::mlir::ArrayAttr iterSubTileSliceView, /*optional*/::mlir::ArrayAttr extraOutView, ::mlir::IntegerAttr blockSize);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value input, ::mlir::Value workspace_buffer, ::mlir::Value output, /*optional*/::mlir::Value extraOut, ::llvm::APInt axis, ::mlir::rock::ReduceMethod reduceMethod, ::mlir::ArrayAttr inputRegView, ::mlir::ArrayAttr tidSubTileSliceView, ::mlir::ArrayAttr iterSubTileSliceView, /*optional*/::mlir::ArrayAttr extraOutView, uint32_t blockSize);
  static BlockwiseBroadcastReduceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value input, ::mlir::Value workspace_buffer, ::mlir::Value output, /*optional*/::mlir::Value extraOut, ::llvm::APInt axis, ::mlir::rock::ReduceMethod reduceMethod, ::mlir::ArrayAttr inputRegView, ::mlir::ArrayAttr tidSubTileSliceView, ::mlir::ArrayAttr iterSubTileSliceView, /*optional*/::mlir::ArrayAttr extraOutView, uint32_t blockSize);
  static BlockwiseBroadcastReduceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value input, ::mlir::Value workspace_buffer, ::mlir::Value output, /*optional*/::mlir::Value extraOut, ::llvm::APInt axis, ::mlir::rock::ReduceMethod reduceMethod, ::mlir::ArrayAttr inputRegView, ::mlir::ArrayAttr tidSubTileSliceView, ::mlir::ArrayAttr iterSubTileSliceView, /*optional*/::mlir::ArrayAttr extraOutView, uint32_t blockSize);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value workspace_buffer, ::mlir::Value output, /*optional*/::mlir::Value extraOut, ::llvm::APInt axis, ::mlir::rock::ReduceMethod reduceMethod, ::mlir::ArrayAttr inputRegView, ::mlir::ArrayAttr tidSubTileSliceView, ::mlir::ArrayAttr iterSubTileSliceView, /*optional*/::mlir::ArrayAttr extraOutView, uint32_t blockSize);
  static BlockwiseBroadcastReduceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value workspace_buffer, ::mlir::Value output, /*optional*/::mlir::Value extraOut, ::llvm::APInt axis, ::mlir::rock::ReduceMethod reduceMethod, ::mlir::ArrayAttr inputRegView, ::mlir::ArrayAttr tidSubTileSliceView, ::mlir::ArrayAttr iterSubTileSliceView, /*optional*/::mlir::ArrayAttr extraOutView, uint32_t blockSize);
  static BlockwiseBroadcastReduceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value workspace_buffer, ::mlir::Value output, /*optional*/::mlir::Value extraOut, ::llvm::APInt axis, ::mlir::rock::ReduceMethod reduceMethod, ::mlir::ArrayAttr inputRegView, ::mlir::ArrayAttr tidSubTileSliceView, ::mlir::ArrayAttr iterSubTileSliceView, /*optional*/::mlir::ArrayAttr extraOutView, uint32_t blockSize);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockwiseBroadcastReduceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockwiseBroadcastReduceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockwiseBroadcastReduceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockwiseBroadcastReduceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 7 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::BlockwiseBroadcastReduceOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::BlockwiseFillOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BlockwiseFillOpGenericAdaptorBase {
public:
  struct Properties {
    using blockSizeTy = ::mlir::IntegerAttr;
    blockSizeTy blockSize;

    auto getBlockSize() const {
      auto &propStorage = this->blockSize;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setBlockSize(const ::mlir::IntegerAttr &propValue) {
      this->blockSize = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.blockSize == this->blockSize &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BlockwiseFillOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.blockwise_fill", odsAttrs.getContext());
  }

  BlockwiseFillOpGenericAdaptorBase(BlockwiseFillOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getBlockSizeAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().blockSize);
    return attr;
  }

  uint32_t getBlockSize();
};
} // namespace detail
template <typename RangeT>
class BlockwiseFillOpGenericAdaptor : public detail::BlockwiseFillOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BlockwiseFillOpGenericAdaptorBase;
  static constexpr int odsIndex_memref = 0;
  static constexpr int odsIndex_value = 1;
public:
  BlockwiseFillOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BlockwiseFillOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BlockwiseFillOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BlockwiseFillOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BlockwiseFillOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BlockwiseFillOpGenericAdaptor(RangeT values, const BlockwiseFillOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BlockwiseFillOp, typename = std::enable_if_t<std::is_same_v<LateInst, BlockwiseFillOp>>>
  BlockwiseFillOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getMemref() {
    return (*getODSOperands(0).begin());
  }

  ValueT getValue() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BlockwiseFillOpAdaptor : public BlockwiseFillOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BlockwiseFillOpGenericAdaptor::BlockwiseFillOpGenericAdaptor;
  BlockwiseFillOpAdaptor(BlockwiseFillOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BlockwiseFillOp : public ::mlir::Op<BlockwiseFillOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BlockwiseFillOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BlockwiseFillOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_memref = 0;
  static constexpr int odsIndex_value = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("blockSize")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBlockSizeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBlockSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.blockwise_fill");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::MemRefType> getMemref() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getMemrefMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getValueMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getBlockSizeAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().blockSize);
  }

  uint32_t getBlockSize();
  void setBlockSizeAttr(::mlir::IntegerAttr attr) {
    getProperties().blockSize = attr;
  }

  void setBlockSize(uint32_t attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value memref, ::mlir::Value value, ::mlir::IntegerAttr blockSize);
  static BlockwiseFillOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value memref, ::mlir::Value value, ::mlir::IntegerAttr blockSize);
  static BlockwiseFillOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value memref, ::mlir::Value value, ::mlir::IntegerAttr blockSize);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value memref, ::mlir::Value value, ::mlir::IntegerAttr blockSize);
  static BlockwiseFillOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value memref, ::mlir::Value value, ::mlir::IntegerAttr blockSize);
  static BlockwiseFillOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value memref, ::mlir::Value value, ::mlir::IntegerAttr blockSize);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value memref, ::mlir::Value value, uint32_t blockSize);
  static BlockwiseFillOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value memref, ::mlir::Value value, uint32_t blockSize);
  static BlockwiseFillOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value memref, ::mlir::Value value, uint32_t blockSize);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value memref, ::mlir::Value value, uint32_t blockSize);
  static BlockwiseFillOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value memref, ::mlir::Value value, uint32_t blockSize);
  static BlockwiseFillOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value memref, ::mlir::Value value, uint32_t blockSize);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockwiseFillOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockwiseFillOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockwiseFillOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockwiseFillOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::BlockwiseFillOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::BlockwiseGemmAccelOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BlockwiseGemmAccelOpGenericAdaptorBase {
public:
  struct Properties {
    using blockSizeTy = ::mlir::IntegerAttr;
    blockSizeTy blockSize;

    auto getBlockSize() const {
      auto &propStorage = this->blockSize;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setBlockSize(const ::mlir::IntegerAttr &propValue) {
      this->blockSize = propValue;
    }
    using featuresTy = ::mlir::rock::GemmFeaturesAttr;
    featuresTy features;

    auto getFeatures() const {
      auto &propStorage = this->features;
      return ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(propStorage);
    }
    void setFeatures(const ::mlir::rock::GemmFeaturesAttr &propValue) {
      this->features = propValue;
    }
    using inMPerThreadTy = ::mlir::IntegerAttr;
    inMPerThreadTy inMPerThread;

    auto getInMPerThread() const {
      auto &propStorage = this->inMPerThread;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setInMPerThread(const ::mlir::IntegerAttr &propValue) {
      this->inMPerThread = propValue;
    }
    using inNPerThreadTy = ::mlir::IntegerAttr;
    inNPerThreadTy inNPerThread;

    auto getInNPerThread() const {
      auto &propStorage = this->inNPerThread;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setInNPerThread(const ::mlir::IntegerAttr &propValue) {
      this->inNPerThread = propValue;
    }
    using loadAfromLDSTy = ::mlir::UnitAttr;
    loadAfromLDSTy loadAfromLDS;

    auto getLoadAfromLDS() const {
      auto &propStorage = this->loadAfromLDS;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setLoadAfromLDS(const ::mlir::UnitAttr &propValue) {
      this->loadAfromLDS = propValue;
    }
    using loadBfromLDSTy = ::mlir::UnitAttr;
    loadBfromLDSTy loadBfromLDS;

    auto getLoadBfromLDS() const {
      auto &propStorage = this->loadBfromLDS;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setLoadBfromLDS(const ::mlir::UnitAttr &propValue) {
      this->loadBfromLDS = propValue;
    }
    using paramsTy = ::mlir::rock::RockAccelTuningParamAttrInterface;
    paramsTy params;

    auto getParams() const {
      auto &propStorage = this->params;
      return ::llvm::cast<::mlir::rock::RockAccelTuningParamAttrInterface>(propStorage);
    }
    void setParams(const ::mlir::rock::RockAccelTuningParamAttrInterface &propValue) {
      this->params = propValue;
    }
    using rotateMWithKTy = ::mlir::UnitAttr;
    rotateMWithKTy rotateMWithK;

    auto getRotateMWithK() const {
      auto &propStorage = this->rotateMWithK;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setRotateMWithK(const ::mlir::UnitAttr &propValue) {
      this->rotateMWithK = propValue;
    }
    using rotateNWithKTy = ::mlir::UnitAttr;
    rotateNWithKTy rotateNWithK;

    auto getRotateNWithK() const {
      auto &propStorage = this->rotateNWithK;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setRotateNWithK(const ::mlir::UnitAttr &propValue) {
      this->rotateNWithK = propValue;
    }
    using splitKAcrossThreadsFirstATy = ::mlir::UnitAttr;
    splitKAcrossThreadsFirstATy splitKAcrossThreadsFirstA;

    auto getSplitKAcrossThreadsFirstA() const {
      auto &propStorage = this->splitKAcrossThreadsFirstA;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setSplitKAcrossThreadsFirstA(const ::mlir::UnitAttr &propValue) {
      this->splitKAcrossThreadsFirstA = propValue;
    }
    using splitKAcrossThreadsFirstBTy = ::mlir::UnitAttr;
    splitKAcrossThreadsFirstBTy splitKAcrossThreadsFirstB;

    auto getSplitKAcrossThreadsFirstB() const {
      auto &propStorage = this->splitKAcrossThreadsFirstB;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setSplitKAcrossThreadsFirstB(const ::mlir::UnitAttr &propValue) {
      this->splitKAcrossThreadsFirstB = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.blockSize == this->blockSize &&
        rhs.features == this->features &&
        rhs.inMPerThread == this->inMPerThread &&
        rhs.inNPerThread == this->inNPerThread &&
        rhs.loadAfromLDS == this->loadAfromLDS &&
        rhs.loadBfromLDS == this->loadBfromLDS &&
        rhs.params == this->params &&
        rhs.rotateMWithK == this->rotateMWithK &&
        rhs.rotateNWithK == this->rotateNWithK &&
        rhs.splitKAcrossThreadsFirstA == this->splitKAcrossThreadsFirstA &&
        rhs.splitKAcrossThreadsFirstB == this->splitKAcrossThreadsFirstB &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BlockwiseGemmAccelOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.blockwise_gemm_accel", odsAttrs.getContext());
  }

  BlockwiseGemmAccelOpGenericAdaptorBase(BlockwiseGemmAccelOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getInMPerThreadAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().inMPerThread);
    return attr;
  }

  uint32_t getInMPerThread();
  ::mlir::IntegerAttr getInNPerThreadAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().inNPerThread);
    return attr;
  }

  uint32_t getInNPerThread();
  ::mlir::UnitAttr getRotateMWithKAttr();
  bool getRotateMWithK();
  ::mlir::UnitAttr getRotateNWithKAttr();
  bool getRotateNWithK();
  ::mlir::UnitAttr getLoadAfromLDSAttr();
  bool getLoadAfromLDS();
  ::mlir::UnitAttr getLoadBfromLDSAttr();
  bool getLoadBfromLDS();
  ::mlir::UnitAttr getSplitKAcrossThreadsFirstAAttr();
  bool getSplitKAcrossThreadsFirstA();
  ::mlir::UnitAttr getSplitKAcrossThreadsFirstBAttr();
  bool getSplitKAcrossThreadsFirstB();
  ::mlir::rock::GemmFeaturesAttr getFeaturesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(getProperties().features);
    return attr;
  }

  ::std::optional<::mlir::rock::GemmFeatures> getFeatures();
  ::mlir::IntegerAttr getBlockSizeAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().blockSize);
    return attr;
  }

  uint32_t getBlockSize();
  ::mlir::rock::RockAccelTuningParamAttrInterface getParamsAttr() {
    auto attr = ::llvm::cast<::mlir::rock::RockAccelTuningParamAttrInterface>(getProperties().params);
    return attr;
  }

  ::mlir::rock::RockAccelTuningParamAttrInterface getParams();
};
} // namespace detail
template <typename RangeT>
class BlockwiseGemmAccelOpGenericAdaptor : public detail::BlockwiseGemmAccelOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BlockwiseGemmAccelOpGenericAdaptorBase;
  static constexpr int odsIndex_matrixA = 0;
  static constexpr int odsIndex_matrixB = 1;
  static constexpr int odsIndex_bufferA = 2;
  static constexpr int odsIndex_bufferB = 3;
  static constexpr int odsIndex_matrixC = 4;
public:
  BlockwiseGemmAccelOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BlockwiseGemmAccelOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BlockwiseGemmAccelOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BlockwiseGemmAccelOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BlockwiseGemmAccelOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BlockwiseGemmAccelOpGenericAdaptor(RangeT values, const BlockwiseGemmAccelOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BlockwiseGemmAccelOp, typename = std::enable_if_t<std::is_same_v<LateInst, BlockwiseGemmAccelOp>>>
  BlockwiseGemmAccelOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getMatrixA() {
    return (*getODSOperands(0).begin());
  }

  ValueT getMatrixB() {
    return (*getODSOperands(1).begin());
  }

  ValueT getBufferA() {
    return (*getODSOperands(2).begin());
  }

  ValueT getBufferB() {
    return (*getODSOperands(3).begin());
  }

  ValueT getMatrixC() {
    return (*getODSOperands(4).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BlockwiseGemmAccelOpAdaptor : public BlockwiseGemmAccelOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BlockwiseGemmAccelOpGenericAdaptor::BlockwiseGemmAccelOpGenericAdaptor;
  BlockwiseGemmAccelOpAdaptor(BlockwiseGemmAccelOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BlockwiseGemmAccelOp : public ::mlir::Op<BlockwiseGemmAccelOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<5>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::rock::RockGemmFeaturesInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BlockwiseGemmAccelOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BlockwiseGemmAccelOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_matrixA = 0;
  static constexpr int odsIndex_matrixB = 1;
  static constexpr int odsIndex_bufferA = 2;
  static constexpr int odsIndex_bufferB = 3;
  static constexpr int odsIndex_matrixC = 4;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("blockSize"), ::llvm::StringRef("features"), ::llvm::StringRef("inMPerThread"), ::llvm::StringRef("inNPerThread"), ::llvm::StringRef("loadAfromLDS"), ::llvm::StringRef("loadBfromLDS"), ::llvm::StringRef("params"), ::llvm::StringRef("rotateMWithK"), ::llvm::StringRef("rotateNWithK"), ::llvm::StringRef("splitKAcrossThreadsFirstA"), ::llvm::StringRef("splitKAcrossThreadsFirstB")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBlockSizeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBlockSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getFeaturesAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getFeaturesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getInMPerThreadAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getInMPerThreadAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getInNPerThreadAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getInNPerThreadAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getLoadAfromLDSAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getLoadAfromLDSAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getLoadBfromLDSAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getLoadBfromLDSAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getParamsAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getParamsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getRotateMWithKAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getRotateMWithKAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getRotateNWithKAttrName() {
    return getAttributeNameForIndex(8);
  }

  static ::mlir::StringAttr getRotateNWithKAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 8);
  }

  ::mlir::StringAttr getSplitKAcrossThreadsFirstAAttrName() {
    return getAttributeNameForIndex(9);
  }

  static ::mlir::StringAttr getSplitKAcrossThreadsFirstAAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 9);
  }

  ::mlir::StringAttr getSplitKAcrossThreadsFirstBAttrName() {
    return getAttributeNameForIndex(10);
  }

  static ::mlir::StringAttr getSplitKAcrossThreadsFirstBAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 10);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.blockwise_gemm_accel");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::MemRefType> getMatrixA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getMatrixB() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getBufferA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getBufferB() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(3).begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getMatrixC() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(4).begin());
  }

  ::mlir::OpOperand &getMatrixAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMatrixBMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getBufferAMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getBufferBMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMatrixCMutable() {
    auto range = getODSOperandIndexAndLength(4);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getInMPerThreadAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().inMPerThread);
  }

  uint32_t getInMPerThread();
  ::mlir::IntegerAttr getInNPerThreadAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().inNPerThread);
  }

  uint32_t getInNPerThread();
  ::mlir::UnitAttr getRotateMWithKAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().rotateMWithK);
  }

  bool getRotateMWithK();
  ::mlir::UnitAttr getRotateNWithKAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().rotateNWithK);
  }

  bool getRotateNWithK();
  ::mlir::UnitAttr getLoadAfromLDSAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().loadAfromLDS);
  }

  bool getLoadAfromLDS();
  ::mlir::UnitAttr getLoadBfromLDSAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().loadBfromLDS);
  }

  bool getLoadBfromLDS();
  ::mlir::UnitAttr getSplitKAcrossThreadsFirstAAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().splitKAcrossThreadsFirstA);
  }

  bool getSplitKAcrossThreadsFirstA();
  ::mlir::UnitAttr getSplitKAcrossThreadsFirstBAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().splitKAcrossThreadsFirstB);
  }

  bool getSplitKAcrossThreadsFirstB();
  ::mlir::rock::GemmFeaturesAttr getFeaturesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(getProperties().features);
  }

  ::std::optional<::mlir::rock::GemmFeatures> getFeatures();
  ::mlir::IntegerAttr getBlockSizeAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().blockSize);
  }

  uint32_t getBlockSize();
  ::mlir::rock::RockAccelTuningParamAttrInterface getParamsAttr() {
    return ::llvm::cast<::mlir::rock::RockAccelTuningParamAttrInterface>(getProperties().params);
  }

  ::mlir::rock::RockAccelTuningParamAttrInterface getParams();
  void setInMPerThreadAttr(::mlir::IntegerAttr attr) {
    getProperties().inMPerThread = attr;
  }

  void setInMPerThread(uint32_t attrValue);
  void setInNPerThreadAttr(::mlir::IntegerAttr attr) {
    getProperties().inNPerThread = attr;
  }

  void setInNPerThread(uint32_t attrValue);
  void setRotateMWithKAttr(::mlir::UnitAttr attr) {
    getProperties().rotateMWithK = attr;
  }

  void setRotateMWithK(bool attrValue);
  void setRotateNWithKAttr(::mlir::UnitAttr attr) {
    getProperties().rotateNWithK = attr;
  }

  void setRotateNWithK(bool attrValue);
  void setLoadAfromLDSAttr(::mlir::UnitAttr attr) {
    getProperties().loadAfromLDS = attr;
  }

  void setLoadAfromLDS(bool attrValue);
  void setLoadBfromLDSAttr(::mlir::UnitAttr attr) {
    getProperties().loadBfromLDS = attr;
  }

  void setLoadBfromLDS(bool attrValue);
  void setSplitKAcrossThreadsFirstAAttr(::mlir::UnitAttr attr) {
    getProperties().splitKAcrossThreadsFirstA = attr;
  }

  void setSplitKAcrossThreadsFirstA(bool attrValue);
  void setSplitKAcrossThreadsFirstBAttr(::mlir::UnitAttr attr) {
    getProperties().splitKAcrossThreadsFirstB = attr;
  }

  void setSplitKAcrossThreadsFirstB(bool attrValue);
  void setFeaturesAttr(::mlir::rock::GemmFeaturesAttr attr) {
    getProperties().features = attr;
  }

  void setFeatures(::std::optional<::mlir::rock::GemmFeatures> attrValue);
  void setBlockSizeAttr(::mlir::IntegerAttr attr) {
    getProperties().blockSize = attr;
  }

  void setBlockSize(uint32_t attrValue);
  void setParamsAttr(::mlir::rock::RockAccelTuningParamAttrInterface attr) {
    getProperties().params = attr;
  }

  ::mlir::Attribute removeRotateMWithKAttr() {
      auto attr = getProperties().rotateMWithK;
      getProperties().rotateMWithK = {};
      return attr;
  }

  ::mlir::Attribute removeRotateNWithKAttr() {
      auto attr = getProperties().rotateNWithK;
      getProperties().rotateNWithK = {};
      return attr;
  }

  ::mlir::Attribute removeLoadAfromLDSAttr() {
      auto attr = getProperties().loadAfromLDS;
      getProperties().loadAfromLDS = {};
      return attr;
  }

  ::mlir::Attribute removeLoadBfromLDSAttr() {
      auto attr = getProperties().loadBfromLDS;
      getProperties().loadBfromLDS = {};
      return attr;
  }

  ::mlir::Attribute removeSplitKAcrossThreadsFirstAAttr() {
      auto attr = getProperties().splitKAcrossThreadsFirstA;
      getProperties().splitKAcrossThreadsFirstA = {};
      return attr;
  }

  ::mlir::Attribute removeSplitKAcrossThreadsFirstBAttr() {
      auto attr = getProperties().splitKAcrossThreadsFirstB;
      getProperties().splitKAcrossThreadsFirstB = {};
      return attr;
  }

  ::mlir::Attribute removeFeaturesAttr() {
      auto attr = getProperties().features;
      getProperties().features = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value matrixA, ::mlir::Value matrixB, ::mlir::IntegerAttr inMPerThread, ::mlir::IntegerAttr inNPerThread, /*optional*/::mlir::UnitAttr rotateMWithK, /*optional*/::mlir::UnitAttr rotateNWithK, /*optional*/::mlir::UnitAttr loadAfromLDS, /*optional*/::mlir::UnitAttr loadBfromLDS, /*optional*/::mlir::UnitAttr splitKAcrossThreadsFirstA, /*optional*/::mlir::UnitAttr splitKAcrossThreadsFirstB, ::mlir::Value bufferA, ::mlir::Value bufferB, ::mlir::Value matrixC, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::IntegerAttr blockSize, ::mlir::rock::RockAccelTuningParamAttrInterface params);
  static BlockwiseGemmAccelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value matrixA, ::mlir::Value matrixB, ::mlir::IntegerAttr inMPerThread, ::mlir::IntegerAttr inNPerThread, /*optional*/::mlir::UnitAttr rotateMWithK, /*optional*/::mlir::UnitAttr rotateNWithK, /*optional*/::mlir::UnitAttr loadAfromLDS, /*optional*/::mlir::UnitAttr loadBfromLDS, /*optional*/::mlir::UnitAttr splitKAcrossThreadsFirstA, /*optional*/::mlir::UnitAttr splitKAcrossThreadsFirstB, ::mlir::Value bufferA, ::mlir::Value bufferB, ::mlir::Value matrixC, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::IntegerAttr blockSize, ::mlir::rock::RockAccelTuningParamAttrInterface params);
  static BlockwiseGemmAccelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value matrixA, ::mlir::Value matrixB, ::mlir::IntegerAttr inMPerThread, ::mlir::IntegerAttr inNPerThread, /*optional*/::mlir::UnitAttr rotateMWithK, /*optional*/::mlir::UnitAttr rotateNWithK, /*optional*/::mlir::UnitAttr loadAfromLDS, /*optional*/::mlir::UnitAttr loadBfromLDS, /*optional*/::mlir::UnitAttr splitKAcrossThreadsFirstA, /*optional*/::mlir::UnitAttr splitKAcrossThreadsFirstB, ::mlir::Value bufferA, ::mlir::Value bufferB, ::mlir::Value matrixC, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::IntegerAttr blockSize, ::mlir::rock::RockAccelTuningParamAttrInterface params);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value matrixA, ::mlir::Value matrixB, ::mlir::IntegerAttr inMPerThread, ::mlir::IntegerAttr inNPerThread, /*optional*/::mlir::UnitAttr rotateMWithK, /*optional*/::mlir::UnitAttr rotateNWithK, /*optional*/::mlir::UnitAttr loadAfromLDS, /*optional*/::mlir::UnitAttr loadBfromLDS, /*optional*/::mlir::UnitAttr splitKAcrossThreadsFirstA, /*optional*/::mlir::UnitAttr splitKAcrossThreadsFirstB, ::mlir::Value bufferA, ::mlir::Value bufferB, ::mlir::Value matrixC, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::IntegerAttr blockSize, ::mlir::rock::RockAccelTuningParamAttrInterface params);
  static BlockwiseGemmAccelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value matrixA, ::mlir::Value matrixB, ::mlir::IntegerAttr inMPerThread, ::mlir::IntegerAttr inNPerThread, /*optional*/::mlir::UnitAttr rotateMWithK, /*optional*/::mlir::UnitAttr rotateNWithK, /*optional*/::mlir::UnitAttr loadAfromLDS, /*optional*/::mlir::UnitAttr loadBfromLDS, /*optional*/::mlir::UnitAttr splitKAcrossThreadsFirstA, /*optional*/::mlir::UnitAttr splitKAcrossThreadsFirstB, ::mlir::Value bufferA, ::mlir::Value bufferB, ::mlir::Value matrixC, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::IntegerAttr blockSize, ::mlir::rock::RockAccelTuningParamAttrInterface params);
  static BlockwiseGemmAccelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value matrixA, ::mlir::Value matrixB, ::mlir::IntegerAttr inMPerThread, ::mlir::IntegerAttr inNPerThread, /*optional*/::mlir::UnitAttr rotateMWithK, /*optional*/::mlir::UnitAttr rotateNWithK, /*optional*/::mlir::UnitAttr loadAfromLDS, /*optional*/::mlir::UnitAttr loadBfromLDS, /*optional*/::mlir::UnitAttr splitKAcrossThreadsFirstA, /*optional*/::mlir::UnitAttr splitKAcrossThreadsFirstB, ::mlir::Value bufferA, ::mlir::Value bufferB, ::mlir::Value matrixC, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::IntegerAttr blockSize, ::mlir::rock::RockAccelTuningParamAttrInterface params);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value matrixA, ::mlir::Value matrixB, uint32_t inMPerThread, uint32_t inNPerThread, /*optional*/bool rotateMWithK, /*optional*/bool rotateNWithK, /*optional*/bool loadAfromLDS, /*optional*/bool loadBfromLDS, /*optional*/bool splitKAcrossThreadsFirstA, /*optional*/bool splitKAcrossThreadsFirstB, ::mlir::Value bufferA, ::mlir::Value bufferB, ::mlir::Value matrixC, /*optional*/::mlir::rock::GemmFeaturesAttr features, uint32_t blockSize, ::mlir::rock::RockAccelTuningParamAttrInterface params);
  static BlockwiseGemmAccelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value matrixA, ::mlir::Value matrixB, uint32_t inMPerThread, uint32_t inNPerThread, /*optional*/bool rotateMWithK, /*optional*/bool rotateNWithK, /*optional*/bool loadAfromLDS, /*optional*/bool loadBfromLDS, /*optional*/bool splitKAcrossThreadsFirstA, /*optional*/bool splitKAcrossThreadsFirstB, ::mlir::Value bufferA, ::mlir::Value bufferB, ::mlir::Value matrixC, /*optional*/::mlir::rock::GemmFeaturesAttr features, uint32_t blockSize, ::mlir::rock::RockAccelTuningParamAttrInterface params);
  static BlockwiseGemmAccelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value matrixA, ::mlir::Value matrixB, uint32_t inMPerThread, uint32_t inNPerThread, /*optional*/bool rotateMWithK, /*optional*/bool rotateNWithK, /*optional*/bool loadAfromLDS, /*optional*/bool loadBfromLDS, /*optional*/bool splitKAcrossThreadsFirstA, /*optional*/bool splitKAcrossThreadsFirstB, ::mlir::Value bufferA, ::mlir::Value bufferB, ::mlir::Value matrixC, /*optional*/::mlir::rock::GemmFeaturesAttr features, uint32_t blockSize, ::mlir::rock::RockAccelTuningParamAttrInterface params);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value matrixA, ::mlir::Value matrixB, uint32_t inMPerThread, uint32_t inNPerThread, /*optional*/bool rotateMWithK, /*optional*/bool rotateNWithK, /*optional*/bool loadAfromLDS, /*optional*/bool loadBfromLDS, /*optional*/bool splitKAcrossThreadsFirstA, /*optional*/bool splitKAcrossThreadsFirstB, ::mlir::Value bufferA, ::mlir::Value bufferB, ::mlir::Value matrixC, /*optional*/::mlir::rock::GemmFeaturesAttr features, uint32_t blockSize, ::mlir::rock::RockAccelTuningParamAttrInterface params);
  static BlockwiseGemmAccelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value matrixA, ::mlir::Value matrixB, uint32_t inMPerThread, uint32_t inNPerThread, /*optional*/bool rotateMWithK, /*optional*/bool rotateNWithK, /*optional*/bool loadAfromLDS, /*optional*/bool loadBfromLDS, /*optional*/bool splitKAcrossThreadsFirstA, /*optional*/bool splitKAcrossThreadsFirstB, ::mlir::Value bufferA, ::mlir::Value bufferB, ::mlir::Value matrixC, /*optional*/::mlir::rock::GemmFeaturesAttr features, uint32_t blockSize, ::mlir::rock::RockAccelTuningParamAttrInterface params);
  static BlockwiseGemmAccelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value matrixA, ::mlir::Value matrixB, uint32_t inMPerThread, uint32_t inNPerThread, /*optional*/bool rotateMWithK, /*optional*/bool rotateNWithK, /*optional*/bool loadAfromLDS, /*optional*/bool loadBfromLDS, /*optional*/bool splitKAcrossThreadsFirstA, /*optional*/bool splitKAcrossThreadsFirstB, ::mlir::Value bufferA, ::mlir::Value bufferB, ::mlir::Value matrixC, /*optional*/::mlir::rock::GemmFeaturesAttr features, uint32_t blockSize, ::mlir::rock::RockAccelTuningParamAttrInterface params);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockwiseGemmAccelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockwiseGemmAccelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockwiseGemmAccelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockwiseGemmAccelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  SmallVector<::mlir::Type> getTypesForFeature();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 11 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::BlockwiseGemmAccelOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::BlockwiseGemmOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class BlockwiseGemmOpGenericAdaptorBase {
public:
  struct Properties {
    using inMPerThreadTy = ::mlir::IntegerAttr;
    inMPerThreadTy inMPerThread;

    auto getInMPerThread() const {
      auto &propStorage = this->inMPerThread;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setInMPerThread(const ::mlir::IntegerAttr &propValue) {
      this->inMPerThread = propValue;
    }
    using inNPerThreadTy = ::mlir::IntegerAttr;
    inNPerThreadTy inNPerThread;

    auto getInNPerThread() const {
      auto &propStorage = this->inNPerThread;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setInNPerThread(const ::mlir::IntegerAttr &propValue) {
      this->inNPerThread = propValue;
    }
    using paramsTy = ::mlir::rock::GeneralGemmParamsAttr;
    paramsTy params;

    auto getParams() const {
      auto &propStorage = this->params;
      return ::llvm::cast<::mlir::rock::GeneralGemmParamsAttr>(propStorage);
    }
    void setParams(const ::mlir::rock::GeneralGemmParamsAttr &propValue) {
      this->params = propValue;
    }
    using rotateMWithKTy = ::mlir::UnitAttr;
    rotateMWithKTy rotateMWithK;

    auto getRotateMWithK() const {
      auto &propStorage = this->rotateMWithK;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setRotateMWithK(const ::mlir::UnitAttr &propValue) {
      this->rotateMWithK = propValue;
    }
    using rotateNWithKTy = ::mlir::UnitAttr;
    rotateNWithKTy rotateNWithK;

    auto getRotateNWithK() const {
      auto &propStorage = this->rotateNWithK;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setRotateNWithK(const ::mlir::UnitAttr &propValue) {
      this->rotateNWithK = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.inMPerThread == this->inMPerThread &&
        rhs.inNPerThread == this->inNPerThread &&
        rhs.params == this->params &&
        rhs.rotateMWithK == this->rotateMWithK &&
        rhs.rotateNWithK == this->rotateNWithK &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  BlockwiseGemmOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.blockwise_gemm", odsAttrs.getContext());
  }

  BlockwiseGemmOpGenericAdaptorBase(BlockwiseGemmOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getInMPerThreadAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().inMPerThread);
    return attr;
  }

  uint32_t getInMPerThread();
  ::mlir::IntegerAttr getInNPerThreadAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().inNPerThread);
    return attr;
  }

  uint32_t getInNPerThread();
  ::mlir::UnitAttr getRotateMWithKAttr();
  bool getRotateMWithK();
  ::mlir::UnitAttr getRotateNWithKAttr();
  bool getRotateNWithK();
  ::mlir::rock::GeneralGemmParamsAttr getParamsAttr() {
    auto attr = ::llvm::cast<::mlir::rock::GeneralGemmParamsAttr>(getProperties().params);
    return attr;
  }

  ::mlir::rock::GeneralGemmParamsAttr getParams();
};
} // namespace detail
template <typename RangeT>
class BlockwiseGemmOpGenericAdaptor : public detail::BlockwiseGemmOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::BlockwiseGemmOpGenericAdaptorBase;
  static constexpr int odsIndex_matrixA = 0;
  static constexpr int odsIndex_matrixB = 1;
  static constexpr int odsIndex_matrixC = 2;
public:
  BlockwiseGemmOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  BlockwiseGemmOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : BlockwiseGemmOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  BlockwiseGemmOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : BlockwiseGemmOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  BlockwiseGemmOpGenericAdaptor(RangeT values, const BlockwiseGemmOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = BlockwiseGemmOp, typename = std::enable_if_t<std::is_same_v<LateInst, BlockwiseGemmOp>>>
  BlockwiseGemmOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getMatrixA() {
    return (*getODSOperands(0).begin());
  }

  ValueT getMatrixB() {
    return (*getODSOperands(1).begin());
  }

  ValueT getMatrixC() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class BlockwiseGemmOpAdaptor : public BlockwiseGemmOpGenericAdaptor<::mlir::ValueRange> {
public:
  using BlockwiseGemmOpGenericAdaptor::BlockwiseGemmOpGenericAdaptor;
  BlockwiseGemmOpAdaptor(BlockwiseGemmOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class BlockwiseGemmOp : public ::mlir::Op<BlockwiseGemmOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::rock::RockWriterOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = BlockwiseGemmOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = BlockwiseGemmOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_matrixA = 0;
  static constexpr int odsIndex_matrixB = 1;
  static constexpr int odsIndex_matrixC = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("inMPerThread"), ::llvm::StringRef("inNPerThread"), ::llvm::StringRef("params"), ::llvm::StringRef("rotateMWithK"), ::llvm::StringRef("rotateNWithK")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getInMPerThreadAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getInMPerThreadAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getInNPerThreadAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getInNPerThreadAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getParamsAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getParamsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getRotateMWithKAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getRotateMWithKAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getRotateNWithKAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getRotateNWithKAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.blockwise_gemm");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::MemRefType> getMatrixA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getMatrixB() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getMatrixC() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getMatrixAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMatrixBMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMatrixCMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getInMPerThreadAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().inMPerThread);
  }

  uint32_t getInMPerThread();
  ::mlir::IntegerAttr getInNPerThreadAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().inNPerThread);
  }

  uint32_t getInNPerThread();
  ::mlir::UnitAttr getRotateMWithKAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().rotateMWithK);
  }

  bool getRotateMWithK();
  ::mlir::UnitAttr getRotateNWithKAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().rotateNWithK);
  }

  bool getRotateNWithK();
  ::mlir::rock::GeneralGemmParamsAttr getParamsAttr() {
    return ::llvm::cast<::mlir::rock::GeneralGemmParamsAttr>(getProperties().params);
  }

  ::mlir::rock::GeneralGemmParamsAttr getParams();
  void setInMPerThreadAttr(::mlir::IntegerAttr attr) {
    getProperties().inMPerThread = attr;
  }

  void setInMPerThread(uint32_t attrValue);
  void setInNPerThreadAttr(::mlir::IntegerAttr attr) {
    getProperties().inNPerThread = attr;
  }

  void setInNPerThread(uint32_t attrValue);
  void setRotateMWithKAttr(::mlir::UnitAttr attr) {
    getProperties().rotateMWithK = attr;
  }

  void setRotateMWithK(bool attrValue);
  void setRotateNWithKAttr(::mlir::UnitAttr attr) {
    getProperties().rotateNWithK = attr;
  }

  void setRotateNWithK(bool attrValue);
  void setParamsAttr(::mlir::rock::GeneralGemmParamsAttr attr) {
    getProperties().params = attr;
  }

  ::mlir::Attribute removeRotateMWithKAttr() {
      auto attr = getProperties().rotateMWithK;
      getProperties().rotateMWithK = {};
      return attr;
  }

  ::mlir::Attribute removeRotateNWithKAttr() {
      auto attr = getProperties().rotateNWithK;
      getProperties().rotateNWithK = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value matrixA, ::mlir::Value matrixB, ::mlir::Value matrixC, ::mlir::IntegerAttr inMPerThread, ::mlir::IntegerAttr inNPerThread, /*optional*/::mlir::UnitAttr rotateMWithK, /*optional*/::mlir::UnitAttr rotateNWithK, ::mlir::rock::GeneralGemmParamsAttr params);
  static BlockwiseGemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value matrixA, ::mlir::Value matrixB, ::mlir::Value matrixC, ::mlir::IntegerAttr inMPerThread, ::mlir::IntegerAttr inNPerThread, /*optional*/::mlir::UnitAttr rotateMWithK, /*optional*/::mlir::UnitAttr rotateNWithK, ::mlir::rock::GeneralGemmParamsAttr params);
  static BlockwiseGemmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value matrixA, ::mlir::Value matrixB, ::mlir::Value matrixC, ::mlir::IntegerAttr inMPerThread, ::mlir::IntegerAttr inNPerThread, /*optional*/::mlir::UnitAttr rotateMWithK, /*optional*/::mlir::UnitAttr rotateNWithK, ::mlir::rock::GeneralGemmParamsAttr params);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value matrixA, ::mlir::Value matrixB, ::mlir::Value matrixC, ::mlir::IntegerAttr inMPerThread, ::mlir::IntegerAttr inNPerThread, /*optional*/::mlir::UnitAttr rotateMWithK, /*optional*/::mlir::UnitAttr rotateNWithK, ::mlir::rock::GeneralGemmParamsAttr params);
  static BlockwiseGemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value matrixA, ::mlir::Value matrixB, ::mlir::Value matrixC, ::mlir::IntegerAttr inMPerThread, ::mlir::IntegerAttr inNPerThread, /*optional*/::mlir::UnitAttr rotateMWithK, /*optional*/::mlir::UnitAttr rotateNWithK, ::mlir::rock::GeneralGemmParamsAttr params);
  static BlockwiseGemmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value matrixA, ::mlir::Value matrixB, ::mlir::Value matrixC, ::mlir::IntegerAttr inMPerThread, ::mlir::IntegerAttr inNPerThread, /*optional*/::mlir::UnitAttr rotateMWithK, /*optional*/::mlir::UnitAttr rotateNWithK, ::mlir::rock::GeneralGemmParamsAttr params);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value matrixA, ::mlir::Value matrixB, ::mlir::Value matrixC, uint32_t inMPerThread, uint32_t inNPerThread, /*optional*/bool rotateMWithK, /*optional*/bool rotateNWithK, ::mlir::rock::GeneralGemmParamsAttr params);
  static BlockwiseGemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value matrixA, ::mlir::Value matrixB, ::mlir::Value matrixC, uint32_t inMPerThread, uint32_t inNPerThread, /*optional*/bool rotateMWithK, /*optional*/bool rotateNWithK, ::mlir::rock::GeneralGemmParamsAttr params);
  static BlockwiseGemmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value matrixA, ::mlir::Value matrixB, ::mlir::Value matrixC, uint32_t inMPerThread, uint32_t inNPerThread, /*optional*/bool rotateMWithK, /*optional*/bool rotateNWithK, ::mlir::rock::GeneralGemmParamsAttr params);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value matrixA, ::mlir::Value matrixB, ::mlir::Value matrixC, uint32_t inMPerThread, uint32_t inNPerThread, /*optional*/bool rotateMWithK, /*optional*/bool rotateNWithK, ::mlir::rock::GeneralGemmParamsAttr params);
  static BlockwiseGemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value matrixA, ::mlir::Value matrixB, ::mlir::Value matrixC, uint32_t inMPerThread, uint32_t inNPerThread, /*optional*/bool rotateMWithK, /*optional*/bool rotateNWithK, ::mlir::rock::GeneralGemmParamsAttr params);
  static BlockwiseGemmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value matrixA, ::mlir::Value matrixB, ::mlir::Value matrixC, uint32_t inMPerThread, uint32_t inNPerThread, /*optional*/bool rotateMWithK, /*optional*/bool rotateNWithK, ::mlir::rock::GeneralGemmParamsAttr params);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockwiseGemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static BlockwiseGemmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockwiseGemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static BlockwiseGemmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  Value getDest();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 5 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::BlockwiseGemmOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::ConvBwdDataOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ConvBwdDataOpGenericAdaptorBase {
public:
  struct Properties {
    using derivedBlockSizeTy = ::mlir::IntegerAttr;
    derivedBlockSizeTy derivedBlockSize;

    auto getDerivedBlockSize() const {
      auto &propStorage = this->derivedBlockSize;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setDerivedBlockSize(const ::mlir::IntegerAttr &propValue) {
      this->derivedBlockSize = propValue;
    }
    using dilationsTy = ::mlir::ArrayAttr;
    dilationsTy dilations;

    auto getDilations() const {
      auto &propStorage = this->dilations;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setDilations(const ::mlir::ArrayAttr &propValue) {
      this->dilations = propValue;
    }
    using featuresTy = ::mlir::rock::GemmFeaturesAttr;
    featuresTy features;

    auto getFeatures() const {
      auto &propStorage = this->features;
      return ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(propStorage);
    }
    void setFeatures(const ::mlir::rock::GemmFeaturesAttr &propValue) {
      this->features = propValue;
    }
    using gridSizeTy = ::mlir::IntegerAttr;
    gridSizeTy gridSize;

    auto getGridSize() const {
      auto &propStorage = this->gridSize;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setGridSize(const ::mlir::IntegerAttr &propValue) {
      this->gridSize = propValue;
    }
    using kernelIdTy = ::mlir::IntegerAttr;
    kernelIdTy kernelId;

    auto getKernelId() const {
      auto &propStorage = this->kernelId;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setKernelId(const ::mlir::IntegerAttr &propValue) {
      this->kernelId = propValue;
    }
    using paddingTy = ::mlir::ArrayAttr;
    paddingTy padding;

    auto getPadding() const {
      auto &propStorage = this->padding;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setPadding(const ::mlir::ArrayAttr &propValue) {
      this->padding = propValue;
    }
    using paramsTy = ::mlir::rock::RockTuningParamAttrInterface;
    paramsTy params;

    auto getParams() const {
      auto &propStorage = this->params;
      return ::llvm::dyn_cast_or_null<::mlir::rock::RockTuningParamAttrInterface>(propStorage);
    }
    void setParams(const ::mlir::rock::RockTuningParamAttrInterface &propValue) {
      this->params = propValue;
    }
    using stridesTy = ::mlir::ArrayAttr;
    stridesTy strides;

    auto getStrides() const {
      auto &propStorage = this->strides;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setStrides(const ::mlir::ArrayAttr &propValue) {
      this->strides = propValue;
    }
    using usesV4R1Ty = ::mlir::BoolAttr;
    usesV4R1Ty usesV4R1;

    auto getUsesV4R1() const {
      auto &propStorage = this->usesV4R1;
      return ::llvm::cast<::mlir::BoolAttr>(propStorage);
    }
    void setUsesV4R1(const ::mlir::BoolAttr &propValue) {
      this->usesV4R1 = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.derivedBlockSize == this->derivedBlockSize &&
        rhs.dilations == this->dilations &&
        rhs.features == this->features &&
        rhs.gridSize == this->gridSize &&
        rhs.kernelId == this->kernelId &&
        rhs.padding == this->padding &&
        rhs.params == this->params &&
        rhs.strides == this->strides &&
        rhs.usesV4R1 == this->usesV4R1 &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ConvBwdDataOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.conv_bwd_data", odsAttrs.getContext());
  }

  ConvBwdDataOpGenericAdaptorBase(ConvBwdDataOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::rock::GemmFeaturesAttr getFeaturesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(getProperties().features);
    return attr;
  }

  ::std::optional<::mlir::rock::GemmFeatures> getFeatures();
  ::mlir::IntegerAttr getDerivedBlockSizeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().derivedBlockSize);
    return attr;
  }

  ::std::optional<uint32_t> getDerivedBlockSize();
  ::mlir::IntegerAttr getGridSizeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().gridSize);
    return attr;
  }

  ::std::optional<uint32_t> getGridSize();
  ::mlir::ArrayAttr getPaddingAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().padding);
    return attr;
  }

  ::mlir::ArrayAttr getPadding();
  ::mlir::ArrayAttr getStridesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().strides);
    return attr;
  }

  ::mlir::ArrayAttr getStrides();
  ::mlir::ArrayAttr getDilationsAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().dilations);
    return attr;
  }

  ::mlir::ArrayAttr getDilations();
  ::mlir::rock::RockTuningParamAttrInterface getParamsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::rock::RockTuningParamAttrInterface>(getProperties().params);
    return attr;
  }

  ::std::optional<::mlir::rock::RockTuningParamAttrInterface> getParams();
  ::mlir::IntegerAttr getKernelIdAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().kernelId);
    return attr;
  }

  ::llvm::APInt getKernelId();
  ::mlir::BoolAttr getUsesV4R1Attr() {
    auto attr = ::llvm::cast<::mlir::BoolAttr>(getProperties().usesV4R1);
    return attr;
  }

  bool getUsesV4R1();
};
} // namespace detail
template <typename RangeT>
class ConvBwdDataOpGenericAdaptor : public detail::ConvBwdDataOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ConvBwdDataOpGenericAdaptorBase;
  static constexpr int odsIndex_filter = 0;
  static constexpr int odsIndex_input = 1;
  static constexpr int odsIndex_output = 2;
public:
  ConvBwdDataOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ConvBwdDataOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ConvBwdDataOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ConvBwdDataOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ConvBwdDataOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ConvBwdDataOpGenericAdaptor(RangeT values, const ConvBwdDataOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ConvBwdDataOp, typename = std::enable_if_t<std::is_same_v<LateInst, ConvBwdDataOp>>>
  ConvBwdDataOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getFilter() {
    return (*getODSOperands(0).begin());
  }

  ValueT getInput() {
    return (*getODSOperands(1).begin());
  }

  ValueT getOutput() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ConvBwdDataOpAdaptor : public ConvBwdDataOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ConvBwdDataOpGenericAdaptor::ConvBwdDataOpGenericAdaptor;
  ConvBwdDataOpAdaptor(ConvBwdDataOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ConvBwdDataOp : public ::mlir::Op<ConvBwdDataOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::rock::RockGemmWrapperInterface::Trait, ::mlir::rock::RockConvInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::rock::RockGemmFeaturesInterface::Trait, mlir::OpTrait::rock::FusionRoot> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ConvBwdDataOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ConvBwdDataOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_filter = 0;
  static constexpr int odsIndex_input = 1;
  static constexpr int odsIndex_output = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("derivedBlockSize"), ::llvm::StringRef("dilations"), ::llvm::StringRef("features"), ::llvm::StringRef("gridSize"), ::llvm::StringRef("kernelId"), ::llvm::StringRef("padding"), ::llvm::StringRef("params"), ::llvm::StringRef("strides"), ::llvm::StringRef("usesV4R1")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDerivedBlockSizeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDerivedBlockSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getDilationsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getDilationsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getFeaturesAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getFeaturesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getGridSizeAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getGridSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getKernelIdAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getKernelIdAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getPaddingAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getPaddingAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getParamsAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getParamsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getStridesAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getStridesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getUsesV4R1AttrName() {
    return getAttributeNameForIndex(8);
  }

  static ::mlir::StringAttr getUsesV4R1AttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 8);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.conv_bwd_data");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::ShapedType> getFilter() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::ShapedType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::ShapedType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getFilterMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getOutputMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    auto results = getODSResults(0);
    return results.empty() ? ::mlir::TypedValue<::mlir::RankedTensorType>() : ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*results.begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::rock::GemmFeaturesAttr getFeaturesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(getProperties().features);
  }

  ::std::optional<::mlir::rock::GemmFeatures> getFeatures();
  ::mlir::IntegerAttr getDerivedBlockSizeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().derivedBlockSize);
  }

  ::std::optional<uint32_t> getDerivedBlockSize();
  ::mlir::IntegerAttr getGridSizeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().gridSize);
  }

  ::std::optional<uint32_t> getGridSize();
  ::mlir::ArrayAttr getPaddingAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().padding);
  }

  ::mlir::ArrayAttr getPadding();
  ::mlir::ArrayAttr getStridesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().strides);
  }

  ::mlir::ArrayAttr getStrides();
  ::mlir::ArrayAttr getDilationsAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().dilations);
  }

  ::mlir::ArrayAttr getDilations();
  ::mlir::rock::RockTuningParamAttrInterface getParamsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::rock::RockTuningParamAttrInterface>(getProperties().params);
  }

  ::std::optional<::mlir::rock::RockTuningParamAttrInterface> getParams();
  ::mlir::IntegerAttr getKernelIdAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().kernelId);
  }

  ::llvm::APInt getKernelId();
  ::mlir::BoolAttr getUsesV4R1Attr() {
    return ::llvm::cast<::mlir::BoolAttr>(getProperties().usesV4R1);
  }

  bool getUsesV4R1();
  void setFeaturesAttr(::mlir::rock::GemmFeaturesAttr attr) {
    getProperties().features = attr;
  }

  void setFeatures(::std::optional<::mlir::rock::GemmFeatures> attrValue);
  void setDerivedBlockSizeAttr(::mlir::IntegerAttr attr) {
    getProperties().derivedBlockSize = attr;
  }

  void setDerivedBlockSize(::std::optional<uint32_t> attrValue);
  void setGridSizeAttr(::mlir::IntegerAttr attr) {
    getProperties().gridSize = attr;
  }

  void setGridSize(::std::optional<uint32_t> attrValue);
  void setPaddingAttr(::mlir::ArrayAttr attr) {
    getProperties().padding = attr;
  }

  void setStridesAttr(::mlir::ArrayAttr attr) {
    getProperties().strides = attr;
  }

  void setDilationsAttr(::mlir::ArrayAttr attr) {
    getProperties().dilations = attr;
  }

  void setParamsAttr(::mlir::rock::RockTuningParamAttrInterface attr) {
    getProperties().params = attr;
  }

  void setKernelIdAttr(::mlir::IntegerAttr attr) {
    getProperties().kernelId = attr;
  }

  void setKernelId(::llvm::APInt attrValue);
  void setUsesV4R1Attr(::mlir::BoolAttr attr) {
    getProperties().usesV4R1 = attr;
  }

  void setUsesV4R1(bool attrValue);
  ::mlir::Attribute removeFeaturesAttr() {
      auto attr = getProperties().features;
      getProperties().features = {};
      return attr;
  }

  ::mlir::Attribute removeDerivedBlockSizeAttr() {
      auto attr = getProperties().derivedBlockSize;
      getProperties().derivedBlockSize = {};
      return attr;
  }

  ::mlir::Attribute removeGridSizeAttr() {
      auto attr = getProperties().gridSize;
      getProperties().gridSize = {};
      return attr;
  }

  ::mlir::Attribute removeParamsAttr() {
      auto attr = getProperties().params;
      getProperties().params = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Type result, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value output, /*optional*/::mlir::rock::GemmFeaturesAttr features, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params, ::mlir::IntegerAttr kernelId, ::mlir::BoolAttr usesV4R1);
  static ConvBwdDataOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Type result, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value output, /*optional*/::mlir::rock::GemmFeaturesAttr features, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params, ::mlir::IntegerAttr kernelId, ::mlir::BoolAttr usesV4R1);
  static ConvBwdDataOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Type result, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value output, /*optional*/::mlir::rock::GemmFeaturesAttr features, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params, ::mlir::IntegerAttr kernelId, ::mlir::BoolAttr usesV4R1);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value output, /*optional*/::mlir::rock::GemmFeaturesAttr features, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params, ::mlir::IntegerAttr kernelId, ::mlir::BoolAttr usesV4R1);
  static ConvBwdDataOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value output, /*optional*/::mlir::rock::GemmFeaturesAttr features, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params, ::mlir::IntegerAttr kernelId, ::mlir::BoolAttr usesV4R1);
  static ConvBwdDataOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value output, /*optional*/::mlir::rock::GemmFeaturesAttr features, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params, ::mlir::IntegerAttr kernelId, ::mlir::BoolAttr usesV4R1);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Type result, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value output, /*optional*/::mlir::rock::GemmFeaturesAttr features, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params, ::llvm::APInt kernelId, bool usesV4R1);
  static ConvBwdDataOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Type result, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value output, /*optional*/::mlir::rock::GemmFeaturesAttr features, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params, ::llvm::APInt kernelId, bool usesV4R1);
  static ConvBwdDataOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Type result, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value output, /*optional*/::mlir::rock::GemmFeaturesAttr features, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params, ::llvm::APInt kernelId, bool usesV4R1);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value output, /*optional*/::mlir::rock::GemmFeaturesAttr features, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params, ::llvm::APInt kernelId, bool usesV4R1);
  static ConvBwdDataOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value output, /*optional*/::mlir::rock::GemmFeaturesAttr features, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params, ::llvm::APInt kernelId, bool usesV4R1);
  static ConvBwdDataOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value output, /*optional*/::mlir::rock::GemmFeaturesAttr features, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params, ::llvm::APInt kernelId, bool usesV4R1);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvBwdDataOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvBwdDataOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvBwdDataOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvBwdDataOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::mlir::rock::KernelType getKernelType();
  OpOperand *getOutArgument();
  ::mlir::rock::GemmSize getGemmSize();
  ::mlir::Type getAType();
  ::mlir::Type getBType();
  ::mlir::Type getCType();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  SmallVector<::mlir::Type> getTypesForFeature();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 9 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::ConvBwdDataOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::ConvBwdWeightOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ConvBwdWeightOpGenericAdaptorBase {
public:
  struct Properties {
    using derivedBlockSizeTy = ::mlir::IntegerAttr;
    derivedBlockSizeTy derivedBlockSize;

    auto getDerivedBlockSize() const {
      auto &propStorage = this->derivedBlockSize;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setDerivedBlockSize(const ::mlir::IntegerAttr &propValue) {
      this->derivedBlockSize = propValue;
    }
    using dilationsTy = ::mlir::ArrayAttr;
    dilationsTy dilations;

    auto getDilations() const {
      auto &propStorage = this->dilations;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setDilations(const ::mlir::ArrayAttr &propValue) {
      this->dilations = propValue;
    }
    using featuresTy = ::mlir::rock::GemmFeaturesAttr;
    featuresTy features;

    auto getFeatures() const {
      auto &propStorage = this->features;
      return ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(propStorage);
    }
    void setFeatures(const ::mlir::rock::GemmFeaturesAttr &propValue) {
      this->features = propValue;
    }
    using gridSizeTy = ::mlir::IntegerAttr;
    gridSizeTy gridSize;

    auto getGridSize() const {
      auto &propStorage = this->gridSize;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setGridSize(const ::mlir::IntegerAttr &propValue) {
      this->gridSize = propValue;
    }
    using kBlocksTy = ::mlir::IntegerAttr;
    kBlocksTy kBlocks;

    auto getKBlocks() const {
      auto &propStorage = this->kBlocks;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setKBlocks(const ::mlir::IntegerAttr &propValue) {
      this->kBlocks = propValue;
    }
    using paddingTy = ::mlir::ArrayAttr;
    paddingTy padding;

    auto getPadding() const {
      auto &propStorage = this->padding;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setPadding(const ::mlir::ArrayAttr &propValue) {
      this->padding = propValue;
    }
    using paramsTy = ::mlir::rock::RockTuningParamAttrInterface;
    paramsTy params;

    auto getParams() const {
      auto &propStorage = this->params;
      return ::llvm::dyn_cast_or_null<::mlir::rock::RockTuningParamAttrInterface>(propStorage);
    }
    void setParams(const ::mlir::rock::RockTuningParamAttrInterface &propValue) {
      this->params = propValue;
    }
    using stridesTy = ::mlir::ArrayAttr;
    stridesTy strides;

    auto getStrides() const {
      auto &propStorage = this->strides;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setStrides(const ::mlir::ArrayAttr &propValue) {
      this->strides = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.derivedBlockSize == this->derivedBlockSize &&
        rhs.dilations == this->dilations &&
        rhs.features == this->features &&
        rhs.gridSize == this->gridSize &&
        rhs.kBlocks == this->kBlocks &&
        rhs.padding == this->padding &&
        rhs.params == this->params &&
        rhs.strides == this->strides &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ConvBwdWeightOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.conv_bwd_weight", odsAttrs.getContext());
  }

  ConvBwdWeightOpGenericAdaptorBase(ConvBwdWeightOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::rock::GemmFeaturesAttr getFeaturesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(getProperties().features);
    return attr;
  }

  ::std::optional<::mlir::rock::GemmFeatures> getFeatures();
  ::mlir::IntegerAttr getDerivedBlockSizeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().derivedBlockSize);
    return attr;
  }

  ::std::optional<uint32_t> getDerivedBlockSize();
  ::mlir::IntegerAttr getGridSizeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().gridSize);
    return attr;
  }

  ::std::optional<uint32_t> getGridSize();
  ::mlir::ArrayAttr getPaddingAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().padding);
    return attr;
  }

  ::mlir::ArrayAttr getPadding();
  ::mlir::ArrayAttr getStridesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().strides);
    return attr;
  }

  ::mlir::ArrayAttr getStrides();
  ::mlir::ArrayAttr getDilationsAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().dilations);
    return attr;
  }

  ::mlir::ArrayAttr getDilations();
  ::mlir::rock::RockTuningParamAttrInterface getParamsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::rock::RockTuningParamAttrInterface>(getProperties().params);
    return attr;
  }

  ::std::optional<::mlir::rock::RockTuningParamAttrInterface> getParams();
  ::mlir::IntegerAttr getKBlocksAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().kBlocks);
    return attr;
  }

  ::std::optional< ::llvm::APInt > getKBlocks();
};
} // namespace detail
template <typename RangeT>
class ConvBwdWeightOpGenericAdaptor : public detail::ConvBwdWeightOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ConvBwdWeightOpGenericAdaptorBase;
  static constexpr int odsIndex_filter = 0;
  static constexpr int odsIndex_input = 1;
  static constexpr int odsIndex_output = 2;
  static constexpr int odsIndex_workspace = 3;
public:
  ConvBwdWeightOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ConvBwdWeightOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ConvBwdWeightOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ConvBwdWeightOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ConvBwdWeightOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ConvBwdWeightOpGenericAdaptor(RangeT values, const ConvBwdWeightOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ConvBwdWeightOp, typename = std::enable_if_t<std::is_same_v<LateInst, ConvBwdWeightOp>>>
  ConvBwdWeightOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getFilter() {
    return (*getODSOperands(0).begin());
  }

  ValueT getInput() {
    return (*getODSOperands(1).begin());
  }

  ValueT getOutput() {
    return (*getODSOperands(2).begin());
  }

  ValueT getWorkspace() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ConvBwdWeightOpAdaptor : public ConvBwdWeightOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ConvBwdWeightOpGenericAdaptor::ConvBwdWeightOpGenericAdaptor;
  ConvBwdWeightOpAdaptor(ConvBwdWeightOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ConvBwdWeightOp : public ::mlir::Op<ConvBwdWeightOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::rock::RockGemmWrapperInterface::Trait, ::mlir::rock::RockConvInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::rock::RockGemmFeaturesInterface::Trait, mlir::OpTrait::rock::FusionRoot> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ConvBwdWeightOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ConvBwdWeightOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_filter = 0;
  static constexpr int odsIndex_input = 1;
  static constexpr int odsIndex_output = 2;
  static constexpr int odsIndex_workspace = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("derivedBlockSize"), ::llvm::StringRef("dilations"), ::llvm::StringRef("features"), ::llvm::StringRef("gridSize"), ::llvm::StringRef("kBlocks"), ::llvm::StringRef("padding"), ::llvm::StringRef("params"), ::llvm::StringRef("strides")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDerivedBlockSizeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDerivedBlockSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getDilationsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getDilationsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getFeaturesAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getFeaturesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getGridSizeAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getGridSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getKBlocksAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getKBlocksAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getPaddingAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getPaddingAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getParamsAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getParamsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getStridesAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getStridesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.conv_bwd_weight");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::ShapedType> getFilter() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::ShapedType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::ShapedType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::ShapedType> getWorkspace() {
    auto operands = getODSOperands(3);
    return operands.empty() ? ::mlir::TypedValue<::mlir::ShapedType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*operands.begin());
  }

  ::mlir::OpOperand &getFilterMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getOutputMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getWorkspaceMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    auto results = getODSResults(0);
    return results.empty() ? ::mlir::TypedValue<::mlir::RankedTensorType>() : ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*results.begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::rock::GemmFeaturesAttr getFeaturesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(getProperties().features);
  }

  ::std::optional<::mlir::rock::GemmFeatures> getFeatures();
  ::mlir::IntegerAttr getDerivedBlockSizeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().derivedBlockSize);
  }

  ::std::optional<uint32_t> getDerivedBlockSize();
  ::mlir::IntegerAttr getGridSizeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().gridSize);
  }

  ::std::optional<uint32_t> getGridSize();
  ::mlir::ArrayAttr getPaddingAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().padding);
  }

  ::mlir::ArrayAttr getPadding();
  ::mlir::ArrayAttr getStridesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().strides);
  }

  ::mlir::ArrayAttr getStrides();
  ::mlir::ArrayAttr getDilationsAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().dilations);
  }

  ::mlir::ArrayAttr getDilations();
  ::mlir::rock::RockTuningParamAttrInterface getParamsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::rock::RockTuningParamAttrInterface>(getProperties().params);
  }

  ::std::optional<::mlir::rock::RockTuningParamAttrInterface> getParams();
  ::mlir::IntegerAttr getKBlocksAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().kBlocks);
  }

  ::std::optional< ::llvm::APInt > getKBlocks();
  void setFeaturesAttr(::mlir::rock::GemmFeaturesAttr attr) {
    getProperties().features = attr;
  }

  void setFeatures(::std::optional<::mlir::rock::GemmFeatures> attrValue);
  void setDerivedBlockSizeAttr(::mlir::IntegerAttr attr) {
    getProperties().derivedBlockSize = attr;
  }

  void setDerivedBlockSize(::std::optional<uint32_t> attrValue);
  void setGridSizeAttr(::mlir::IntegerAttr attr) {
    getProperties().gridSize = attr;
  }

  void setGridSize(::std::optional<uint32_t> attrValue);
  void setPaddingAttr(::mlir::ArrayAttr attr) {
    getProperties().padding = attr;
  }

  void setStridesAttr(::mlir::ArrayAttr attr) {
    getProperties().strides = attr;
  }

  void setDilationsAttr(::mlir::ArrayAttr attr) {
    getProperties().dilations = attr;
  }

  void setParamsAttr(::mlir::rock::RockTuningParamAttrInterface attr) {
    getProperties().params = attr;
  }

  void setKBlocksAttr(::mlir::IntegerAttr attr) {
    getProperties().kBlocks = attr;
  }

  void setKBlocks(::std::optional<::llvm::APInt> attrValue);
  ::mlir::Attribute removeFeaturesAttr() {
      auto attr = getProperties().features;
      getProperties().features = {};
      return attr;
  }

  ::mlir::Attribute removeDerivedBlockSizeAttr() {
      auto attr = getProperties().derivedBlockSize;
      getProperties().derivedBlockSize = {};
      return attr;
  }

  ::mlir::Attribute removeGridSizeAttr() {
      auto attr = getProperties().gridSize;
      getProperties().gridSize = {};
      return attr;
  }

  ::mlir::Attribute removeParamsAttr() {
      auto attr = getProperties().params;
      getProperties().params = {};
      return attr;
  }

  ::mlir::Attribute removeKBlocksAttr() {
      auto attr = getProperties().kBlocks;
      getProperties().kBlocks = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Type result, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value output, /*optional*/::mlir::rock::GemmFeaturesAttr features, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params, /*optional*/::mlir::Value workspace, /*optional*/::mlir::IntegerAttr kBlocks);
  static ConvBwdWeightOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Type result, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value output, /*optional*/::mlir::rock::GemmFeaturesAttr features, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params, /*optional*/::mlir::Value workspace, /*optional*/::mlir::IntegerAttr kBlocks);
  static ConvBwdWeightOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Type result, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value output, /*optional*/::mlir::rock::GemmFeaturesAttr features, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params, /*optional*/::mlir::Value workspace, /*optional*/::mlir::IntegerAttr kBlocks);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value output, /*optional*/::mlir::rock::GemmFeaturesAttr features, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params, /*optional*/::mlir::Value workspace, /*optional*/::mlir::IntegerAttr kBlocks);
  static ConvBwdWeightOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value output, /*optional*/::mlir::rock::GemmFeaturesAttr features, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params, /*optional*/::mlir::Value workspace, /*optional*/::mlir::IntegerAttr kBlocks);
  static ConvBwdWeightOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value output, /*optional*/::mlir::rock::GemmFeaturesAttr features, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params, /*optional*/::mlir::Value workspace, /*optional*/::mlir::IntegerAttr kBlocks);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvBwdWeightOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvBwdWeightOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvBwdWeightOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvBwdWeightOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::mlir::rock::KernelType getKernelType();
  OpOperand *getOutArgument();
  ::mlir::rock::GemmSize getGemmSize();
  ::mlir::Type getAType();
  ::mlir::Type getBType();
  ::mlir::Type getCType();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  SmallVector<::mlir::Type> getTypesForFeature();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 8 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::ConvBwdWeightOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::ConvElementwiseGemmOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ConvElementwiseGemmOpGenericAdaptorBase {
public:
  struct Properties {
    using cTransposedTy = ::mlir::UnitAttr;
    cTransposedTy cTransposed;

    auto getCTransposed() const {
      auto &propStorage = this->cTransposed;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setCTransposed(const ::mlir::UnitAttr &propValue) {
      this->cTransposed = propValue;
    }
    using dilationsTy = ::mlir::ArrayAttr;
    dilationsTy dilations;

    auto getDilations() const {
      auto &propStorage = this->dilations;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setDilations(const ::mlir::ArrayAttr &propValue) {
      this->dilations = propValue;
    }
    using featuresTy = ::mlir::rock::GemmFeaturesAttr;
    featuresTy features;

    auto getFeatures() const {
      auto &propStorage = this->features;
      return ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(propStorage);
    }
    void setFeatures(const ::mlir::rock::GemmFeaturesAttr &propValue) {
      this->features = propValue;
    }
    using firstGemmIndicesTy = ::mlir::DenseI64ArrayAttr;
    firstGemmIndicesTy firstGemmIndices;

    auto getFirstGemmIndices() const {
      auto &propStorage = this->firstGemmIndices;
      return ::llvm::cast<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setFirstGemmIndices(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->firstGemmIndices = propValue;
    }
    using oTransposedTy = ::mlir::UnitAttr;
    oTransposedTy oTransposed;

    auto getOTransposed() const {
      auto &propStorage = this->oTransposed;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setOTransposed(const ::mlir::UnitAttr &propValue) {
      this->oTransposed = propValue;
    }
    using paddingTy = ::mlir::ArrayAttr;
    paddingTy padding;

    auto getPadding() const {
      auto &propStorage = this->padding;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setPadding(const ::mlir::ArrayAttr &propValue) {
      this->padding = propValue;
    }
    using params0Ty = ::mlir::rock::RockTuningParamAttrInterface;
    params0Ty params0;

    auto getParams0() const {
      auto &propStorage = this->params0;
      return ::llvm::dyn_cast_or_null<::mlir::rock::RockTuningParamAttrInterface>(propStorage);
    }
    void setParams0(const ::mlir::rock::RockTuningParamAttrInterface &propValue) {
      this->params0 = propValue;
    }
    using params1Ty = ::mlir::rock::RockTuningParamAttrInterface;
    params1Ty params1;

    auto getParams1() const {
      auto &propStorage = this->params1;
      return ::llvm::dyn_cast_or_null<::mlir::rock::RockTuningParamAttrInterface>(propStorage);
    }
    void setParams1(const ::mlir::rock::RockTuningParamAttrInterface &propValue) {
      this->params1 = propValue;
    }
    using storeMethodTy = ::mlir::rock::StoreMethodAttr;
    storeMethodTy storeMethod;

    auto getStoreMethod() const {
      auto &propStorage = this->storeMethod;
      return ::llvm::cast<::mlir::rock::StoreMethodAttr>(propStorage);
    }
    void setStoreMethod(const ::mlir::rock::StoreMethodAttr &propValue) {
      this->storeMethod = propValue;
    }
    using stridesTy = ::mlir::ArrayAttr;
    stridesTy strides;

    auto getStrides() const {
      auto &propStorage = this->strides;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setStrides(const ::mlir::ArrayAttr &propValue) {
      this->strides = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.cTransposed == this->cTransposed &&
        rhs.dilations == this->dilations &&
        rhs.features == this->features &&
        rhs.firstGemmIndices == this->firstGemmIndices &&
        rhs.oTransposed == this->oTransposed &&
        rhs.padding == this->padding &&
        rhs.params0 == this->params0 &&
        rhs.params1 == this->params1 &&
        rhs.storeMethod == this->storeMethod &&
        rhs.strides == this->strides &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ConvElementwiseGemmOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.conv_elementwise_gemm", odsAttrs.getContext());
  }

  ConvElementwiseGemmOpGenericAdaptorBase(ConvElementwiseGemmOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::UnitAttr getCTransposedAttr();
  bool getCTransposed();
  ::mlir::UnitAttr getOTransposedAttr();
  bool getOTransposed();
  ::mlir::rock::GemmFeaturesAttr getFeaturesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(getProperties().features);
    return attr;
  }

  ::std::optional<::mlir::rock::GemmFeatures> getFeatures();
  ::mlir::rock::StoreMethodAttr getStoreMethodAttr() {
    auto attr = ::llvm::cast<::mlir::rock::StoreMethodAttr>(getProperties().storeMethod);
    return attr;
  }

  ::mlir::rock::StoreMethod getStoreMethod();
  ::mlir::ArrayAttr getPaddingAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().padding);
    return attr;
  }

  ::mlir::ArrayAttr getPadding();
  ::mlir::ArrayAttr getStridesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().strides);
    return attr;
  }

  ::mlir::ArrayAttr getStrides();
  ::mlir::ArrayAttr getDilationsAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().dilations);
    return attr;
  }

  ::mlir::ArrayAttr getDilations();
  ::mlir::rock::RockTuningParamAttrInterface getParams0Attr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::rock::RockTuningParamAttrInterface>(getProperties().params0);
    return attr;
  }

  ::std::optional<::mlir::rock::RockTuningParamAttrInterface> getParams0();
  ::mlir::rock::RockTuningParamAttrInterface getParams1Attr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::rock::RockTuningParamAttrInterface>(getProperties().params1);
    return attr;
  }

  ::std::optional<::mlir::rock::RockTuningParamAttrInterface> getParams1();
  ::mlir::DenseI64ArrayAttr getFirstGemmIndicesAttr() {
    auto attr = ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().firstGemmIndices);
    return attr;
  }

  ::llvm::ArrayRef<int64_t> getFirstGemmIndices();
  ::mlir::Region &getPreSecondGemmBody() {
    return *odsRegions[0];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};
} // namespace detail
template <typename RangeT>
class ConvElementwiseGemmOpGenericAdaptor : public detail::ConvElementwiseGemmOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ConvElementwiseGemmOpGenericAdaptorBase;
  static constexpr int odsIndex_filter = 0;
  static constexpr int odsIndex_input = 1;
  static constexpr int odsIndex_c = 2;
  static constexpr int odsIndex_elemwiseInputs = 3;
  static constexpr int odsIndex_out = 4;
public:
  ConvElementwiseGemmOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ConvElementwiseGemmOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ConvElementwiseGemmOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ConvElementwiseGemmOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ConvElementwiseGemmOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ConvElementwiseGemmOpGenericAdaptor(RangeT values, const ConvElementwiseGemmOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ConvElementwiseGemmOp, typename = std::enable_if_t<std::is_same_v<LateInst, ConvElementwiseGemmOp>>>
  ConvElementwiseGemmOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getFilter() {
    return (*getODSOperands(0).begin());
  }

  ValueT getInput() {
    return (*getODSOperands(1).begin());
  }

  ValueT getC() {
    return (*getODSOperands(2).begin());
  }

  RangeT getElemwiseInputs() {
    return getODSOperands(3);
  }

  ValueT getOut() {
    return (*getODSOperands(4).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ConvElementwiseGemmOpAdaptor : public ConvElementwiseGemmOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ConvElementwiseGemmOpGenericAdaptor::ConvElementwiseGemmOpGenericAdaptor;
  ConvElementwiseGemmOpAdaptor(ConvElementwiseGemmOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ConvElementwiseGemmOp : public ::mlir::Op<ConvElementwiseGemmOp, ::mlir::OpTrait::OneRegion, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<4>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::rock::RockGemmGemmWrapperInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::rock::RockGemmFeaturesInterface::Trait, mlir::OpTrait::rock::FusionRoot> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ConvElementwiseGemmOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ConvElementwiseGemmOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_filter = 0;
  static constexpr int odsIndex_input = 1;
  static constexpr int odsIndex_c = 2;
  static constexpr int odsIndex_elemwiseInputs = 3;
  static constexpr int odsIndex_out = 4;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("cTransposed"), ::llvm::StringRef("dilations"), ::llvm::StringRef("features"), ::llvm::StringRef("firstGemmIndices"), ::llvm::StringRef("oTransposed"), ::llvm::StringRef("padding"), ::llvm::StringRef("params0"), ::llvm::StringRef("params1"), ::llvm::StringRef("storeMethod"), ::llvm::StringRef("strides")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getCTransposedAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getCTransposedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getDilationsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getDilationsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getFeaturesAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getFeaturesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getFirstGemmIndicesAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getFirstGemmIndicesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getOTransposedAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getOTransposedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getPaddingAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getPaddingAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getParams0AttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getParams0AttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getParams1AttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getParams1AttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getStoreMethodAttrName() {
    return getAttributeNameForIndex(8);
  }

  static ::mlir::StringAttr getStoreMethodAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 8);
  }

  ::mlir::StringAttr getStridesAttrName() {
    return getAttributeNameForIndex(9);
  }

  static ::mlir::StringAttr getStridesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 9);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.conv_elementwise_gemm");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::ShapedType> getFilter() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::ShapedType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::ShapedType> getC() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*getODSOperands(2).begin());
  }

  ::mlir::Operation::operand_range getElemwiseInputs() {
    return getODSOperands(3);
  }

  ::mlir::TypedValue<::mlir::ShapedType> getOut() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*getODSOperands(4).begin());
  }

  ::mlir::OpOperand &getFilterMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getCMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getElemwiseInputsMutable();
  ::mlir::OpOperand &getOutMutable() {
    auto range = getODSOperandIndexAndLength(4);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getResult() {
    auto results = getODSResults(0);
    return results.empty() ? ::mlir::TypedValue<::mlir::TensorType>() : ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*results.begin());
  }

  ::mlir::Region &getPreSecondGemmBody() {
    return (*this)->getRegion(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::UnitAttr getCTransposedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().cTransposed);
  }

  bool getCTransposed();
  ::mlir::UnitAttr getOTransposedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().oTransposed);
  }

  bool getOTransposed();
  ::mlir::rock::GemmFeaturesAttr getFeaturesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(getProperties().features);
  }

  ::std::optional<::mlir::rock::GemmFeatures> getFeatures();
  ::mlir::rock::StoreMethodAttr getStoreMethodAttr() {
    return ::llvm::cast<::mlir::rock::StoreMethodAttr>(getProperties().storeMethod);
  }

  ::mlir::rock::StoreMethod getStoreMethod();
  ::mlir::ArrayAttr getPaddingAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().padding);
  }

  ::mlir::ArrayAttr getPadding();
  ::mlir::ArrayAttr getStridesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().strides);
  }

  ::mlir::ArrayAttr getStrides();
  ::mlir::ArrayAttr getDilationsAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().dilations);
  }

  ::mlir::ArrayAttr getDilations();
  ::mlir::rock::RockTuningParamAttrInterface getParams0Attr() {
    return ::llvm::dyn_cast_or_null<::mlir::rock::RockTuningParamAttrInterface>(getProperties().params0);
  }

  ::std::optional<::mlir::rock::RockTuningParamAttrInterface> getParams0();
  ::mlir::rock::RockTuningParamAttrInterface getParams1Attr() {
    return ::llvm::dyn_cast_or_null<::mlir::rock::RockTuningParamAttrInterface>(getProperties().params1);
  }

  ::std::optional<::mlir::rock::RockTuningParamAttrInterface> getParams1();
  ::mlir::DenseI64ArrayAttr getFirstGemmIndicesAttr() {
    return ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().firstGemmIndices);
  }

  ::llvm::ArrayRef<int64_t> getFirstGemmIndices();
  void setCTransposedAttr(::mlir::UnitAttr attr) {
    getProperties().cTransposed = attr;
  }

  void setCTransposed(bool attrValue);
  void setOTransposedAttr(::mlir::UnitAttr attr) {
    getProperties().oTransposed = attr;
  }

  void setOTransposed(bool attrValue);
  void setFeaturesAttr(::mlir::rock::GemmFeaturesAttr attr) {
    getProperties().features = attr;
  }

  void setFeatures(::std::optional<::mlir::rock::GemmFeatures> attrValue);
  void setStoreMethodAttr(::mlir::rock::StoreMethodAttr attr) {
    getProperties().storeMethod = attr;
  }

  void setStoreMethod(::mlir::rock::StoreMethod attrValue);
  void setPaddingAttr(::mlir::ArrayAttr attr) {
    getProperties().padding = attr;
  }

  void setStridesAttr(::mlir::ArrayAttr attr) {
    getProperties().strides = attr;
  }

  void setDilationsAttr(::mlir::ArrayAttr attr) {
    getProperties().dilations = attr;
  }

  void setParams0Attr(::mlir::rock::RockTuningParamAttrInterface attr) {
    getProperties().params0 = attr;
  }

  void setParams1Attr(::mlir::rock::RockTuningParamAttrInterface attr) {
    getProperties().params1 = attr;
  }

  void setFirstGemmIndicesAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().firstGemmIndices = attr;
  }

  void setFirstGemmIndices(::llvm::ArrayRef<int64_t> attrValue);
  ::mlir::Attribute removeCTransposedAttr() {
      auto attr = getProperties().cTransposed;
      getProperties().cTransposed = {};
      return attr;
  }

  ::mlir::Attribute removeOTransposedAttr() {
      auto attr = getProperties().oTransposed;
      getProperties().oTransposed = {};
      return attr;
  }

  ::mlir::Attribute removeFeaturesAttr() {
      auto attr = getProperties().features;
      getProperties().features = {};
      return attr;
  }

  ::mlir::Attribute removeParams0Attr() {
      auto attr = getProperties().params0;
      getProperties().params0 = {};
      return attr;
  }

  ::mlir::Attribute removeParams1Attr() {
      auto attr = getProperties().params1;
      getProperties().params1 = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Type result, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value c, ::mlir::ValueRange elemwiseInputs, ::mlir::Value out, /*optional*/::mlir::UnitAttr cTransposed, /*optional*/::mlir::UnitAttr oTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::mlir::DenseI64ArrayAttr firstGemmIndices);
  static ConvElementwiseGemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Type result, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value c, ::mlir::ValueRange elemwiseInputs, ::mlir::Value out, /*optional*/::mlir::UnitAttr cTransposed, /*optional*/::mlir::UnitAttr oTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::mlir::DenseI64ArrayAttr firstGemmIndices);
  static ConvElementwiseGemmOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Type result, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value c, ::mlir::ValueRange elemwiseInputs, ::mlir::Value out, /*optional*/::mlir::UnitAttr cTransposed, /*optional*/::mlir::UnitAttr oTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::mlir::DenseI64ArrayAttr firstGemmIndices);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value c, ::mlir::ValueRange elemwiseInputs, ::mlir::Value out, /*optional*/::mlir::UnitAttr cTransposed, /*optional*/::mlir::UnitAttr oTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::mlir::DenseI64ArrayAttr firstGemmIndices);
  static ConvElementwiseGemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value c, ::mlir::ValueRange elemwiseInputs, ::mlir::Value out, /*optional*/::mlir::UnitAttr cTransposed, /*optional*/::mlir::UnitAttr oTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::mlir::DenseI64ArrayAttr firstGemmIndices);
  static ConvElementwiseGemmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value c, ::mlir::ValueRange elemwiseInputs, ::mlir::Value out, /*optional*/::mlir::UnitAttr cTransposed, /*optional*/::mlir::UnitAttr oTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::mlir::DenseI64ArrayAttr firstGemmIndices);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Type result, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value c, ::mlir::ValueRange elemwiseInputs, ::mlir::Value out, /*optional*/bool cTransposed, /*optional*/bool oTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::llvm::ArrayRef<int64_t> firstGemmIndices);
  static ConvElementwiseGemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Type result, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value c, ::mlir::ValueRange elemwiseInputs, ::mlir::Value out, /*optional*/bool cTransposed, /*optional*/bool oTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::llvm::ArrayRef<int64_t> firstGemmIndices);
  static ConvElementwiseGemmOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Type result, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value c, ::mlir::ValueRange elemwiseInputs, ::mlir::Value out, /*optional*/bool cTransposed, /*optional*/bool oTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::llvm::ArrayRef<int64_t> firstGemmIndices);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value c, ::mlir::ValueRange elemwiseInputs, ::mlir::Value out, /*optional*/bool cTransposed, /*optional*/bool oTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::llvm::ArrayRef<int64_t> firstGemmIndices);
  static ConvElementwiseGemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value c, ::mlir::ValueRange elemwiseInputs, ::mlir::Value out, /*optional*/bool cTransposed, /*optional*/bool oTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::llvm::ArrayRef<int64_t> firstGemmIndices);
  static ConvElementwiseGemmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value c, ::mlir::ValueRange elemwiseInputs, ::mlir::Value out, /*optional*/bool cTransposed, /*optional*/bool oTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::llvm::ArrayRef<int64_t> firstGemmIndices);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvElementwiseGemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvElementwiseGemmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvElementwiseGemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvElementwiseGemmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::mlir::rock::KernelType getKernelType();
  OpOperand *getOutArgument();
  ::mlir::rock::GemmGemmSize getGemmGemmSize();
  ::mlir::Type getAType();
  ::mlir::Type getBType();
  ::mlir::Type getCType();
  ::mlir::Type getOutType();
  bool getTransposedA();
  bool getTransposedB();
  bool getTransposedC();
  bool getTransposedOut();
  Region&getPreSecondGemmRegion();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  SmallVector<::mlir::Type> getTypesForFeature();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 10 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::ConvElementwiseGemmOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::ConvOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ConvOpGenericAdaptorBase {
public:
  struct Properties {
    using derivedBlockSizeTy = ::mlir::IntegerAttr;
    derivedBlockSizeTy derivedBlockSize;

    auto getDerivedBlockSize() const {
      auto &propStorage = this->derivedBlockSize;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setDerivedBlockSize(const ::mlir::IntegerAttr &propValue) {
      this->derivedBlockSize = propValue;
    }
    using dilationsTy = ::mlir::ArrayAttr;
    dilationsTy dilations;

    auto getDilations() const {
      auto &propStorage = this->dilations;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setDilations(const ::mlir::ArrayAttr &propValue) {
      this->dilations = propValue;
    }
    using featuresTy = ::mlir::rock::GemmFeaturesAttr;
    featuresTy features;

    auto getFeatures() const {
      auto &propStorage = this->features;
      return ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(propStorage);
    }
    void setFeatures(const ::mlir::rock::GemmFeaturesAttr &propValue) {
      this->features = propValue;
    }
    using gridSizeTy = ::mlir::IntegerAttr;
    gridSizeTy gridSize;

    auto getGridSize() const {
      auto &propStorage = this->gridSize;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setGridSize(const ::mlir::IntegerAttr &propValue) {
      this->gridSize = propValue;
    }
    using paddingTy = ::mlir::ArrayAttr;
    paddingTy padding;

    auto getPadding() const {
      auto &propStorage = this->padding;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setPadding(const ::mlir::ArrayAttr &propValue) {
      this->padding = propValue;
    }
    using paramsTy = ::mlir::rock::RockTuningParamAttrInterface;
    paramsTy params;

    auto getParams() const {
      auto &propStorage = this->params;
      return ::llvm::dyn_cast_or_null<::mlir::rock::RockTuningParamAttrInterface>(propStorage);
    }
    void setParams(const ::mlir::rock::RockTuningParamAttrInterface &propValue) {
      this->params = propValue;
    }
    using stridesTy = ::mlir::ArrayAttr;
    stridesTy strides;

    auto getStrides() const {
      auto &propStorage = this->strides;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setStrides(const ::mlir::ArrayAttr &propValue) {
      this->strides = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.derivedBlockSize == this->derivedBlockSize &&
        rhs.dilations == this->dilations &&
        rhs.features == this->features &&
        rhs.gridSize == this->gridSize &&
        rhs.padding == this->padding &&
        rhs.params == this->params &&
        rhs.strides == this->strides &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ConvOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.conv", odsAttrs.getContext());
  }

  ConvOpGenericAdaptorBase(ConvOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::rock::GemmFeaturesAttr getFeaturesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(getProperties().features);
    return attr;
  }

  ::std::optional<::mlir::rock::GemmFeatures> getFeatures();
  ::mlir::IntegerAttr getDerivedBlockSizeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().derivedBlockSize);
    return attr;
  }

  ::std::optional<uint32_t> getDerivedBlockSize();
  ::mlir::IntegerAttr getGridSizeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().gridSize);
    return attr;
  }

  ::std::optional<uint32_t> getGridSize();
  ::mlir::ArrayAttr getPaddingAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().padding);
    return attr;
  }

  ::mlir::ArrayAttr getPadding();
  ::mlir::ArrayAttr getStridesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().strides);
    return attr;
  }

  ::mlir::ArrayAttr getStrides();
  ::mlir::ArrayAttr getDilationsAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().dilations);
    return attr;
  }

  ::mlir::ArrayAttr getDilations();
  ::mlir::rock::RockTuningParamAttrInterface getParamsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::rock::RockTuningParamAttrInterface>(getProperties().params);
    return attr;
  }

  ::std::optional<::mlir::rock::RockTuningParamAttrInterface> getParams();
};
} // namespace detail
template <typename RangeT>
class ConvOpGenericAdaptor : public detail::ConvOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ConvOpGenericAdaptorBase;
  static constexpr int odsIndex_filter = 0;
  static constexpr int odsIndex_input = 1;
  static constexpr int odsIndex_output = 2;
public:
  ConvOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ConvOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ConvOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ConvOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ConvOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ConvOpGenericAdaptor(RangeT values, const ConvOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ConvOp, typename = std::enable_if_t<std::is_same_v<LateInst, ConvOp>>>
  ConvOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getFilter() {
    return (*getODSOperands(0).begin());
  }

  ValueT getInput() {
    return (*getODSOperands(1).begin());
  }

  ValueT getOutput() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ConvOpAdaptor : public ConvOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ConvOpGenericAdaptor::ConvOpGenericAdaptor;
  ConvOpAdaptor(ConvOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ConvOp : public ::mlir::Op<ConvOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::rock::RockGemmWrapperInterface::Trait, ::mlir::rock::RockConvInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::rock::RockGemmFeaturesInterface::Trait, mlir::OpTrait::rock::FusionRoot> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ConvOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ConvOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_filter = 0;
  static constexpr int odsIndex_input = 1;
  static constexpr int odsIndex_output = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("derivedBlockSize"), ::llvm::StringRef("dilations"), ::llvm::StringRef("features"), ::llvm::StringRef("gridSize"), ::llvm::StringRef("padding"), ::llvm::StringRef("params"), ::llvm::StringRef("strides")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getDerivedBlockSizeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getDerivedBlockSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getDilationsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getDilationsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getFeaturesAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getFeaturesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getGridSizeAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getGridSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getPaddingAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getPaddingAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getParamsAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getParamsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getStridesAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getStridesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.conv");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::ShapedType> getFilter() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::ShapedType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::ShapedType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getFilterMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getOutputMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    auto results = getODSResults(0);
    return results.empty() ? ::mlir::TypedValue<::mlir::RankedTensorType>() : ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*results.begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::rock::GemmFeaturesAttr getFeaturesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(getProperties().features);
  }

  ::std::optional<::mlir::rock::GemmFeatures> getFeatures();
  ::mlir::IntegerAttr getDerivedBlockSizeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().derivedBlockSize);
  }

  ::std::optional<uint32_t> getDerivedBlockSize();
  ::mlir::IntegerAttr getGridSizeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().gridSize);
  }

  ::std::optional<uint32_t> getGridSize();
  ::mlir::ArrayAttr getPaddingAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().padding);
  }

  ::mlir::ArrayAttr getPadding();
  ::mlir::ArrayAttr getStridesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().strides);
  }

  ::mlir::ArrayAttr getStrides();
  ::mlir::ArrayAttr getDilationsAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().dilations);
  }

  ::mlir::ArrayAttr getDilations();
  ::mlir::rock::RockTuningParamAttrInterface getParamsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::rock::RockTuningParamAttrInterface>(getProperties().params);
  }

  ::std::optional<::mlir::rock::RockTuningParamAttrInterface> getParams();
  void setFeaturesAttr(::mlir::rock::GemmFeaturesAttr attr) {
    getProperties().features = attr;
  }

  void setFeatures(::std::optional<::mlir::rock::GemmFeatures> attrValue);
  void setDerivedBlockSizeAttr(::mlir::IntegerAttr attr) {
    getProperties().derivedBlockSize = attr;
  }

  void setDerivedBlockSize(::std::optional<uint32_t> attrValue);
  void setGridSizeAttr(::mlir::IntegerAttr attr) {
    getProperties().gridSize = attr;
  }

  void setGridSize(::std::optional<uint32_t> attrValue);
  void setPaddingAttr(::mlir::ArrayAttr attr) {
    getProperties().padding = attr;
  }

  void setStridesAttr(::mlir::ArrayAttr attr) {
    getProperties().strides = attr;
  }

  void setDilationsAttr(::mlir::ArrayAttr attr) {
    getProperties().dilations = attr;
  }

  void setParamsAttr(::mlir::rock::RockTuningParamAttrInterface attr) {
    getProperties().params = attr;
  }

  ::mlir::Attribute removeFeaturesAttr() {
      auto attr = getProperties().features;
      getProperties().features = {};
      return attr;
  }

  ::mlir::Attribute removeDerivedBlockSizeAttr() {
      auto attr = getProperties().derivedBlockSize;
      getProperties().derivedBlockSize = {};
      return attr;
  }

  ::mlir::Attribute removeGridSizeAttr() {
      auto attr = getProperties().gridSize;
      getProperties().gridSize = {};
      return attr;
  }

  ::mlir::Attribute removeParamsAttr() {
      auto attr = getProperties().params;
      getProperties().params = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Type result, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value output, /*optional*/::mlir::rock::GemmFeaturesAttr features, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params);
  static ConvOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Type result, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value output, /*optional*/::mlir::rock::GemmFeaturesAttr features, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params);
  static ConvOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Type result, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value output, /*optional*/::mlir::rock::GemmFeaturesAttr features, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value output, /*optional*/::mlir::rock::GemmFeaturesAttr features, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params);
  static ConvOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value output, /*optional*/::mlir::rock::GemmFeaturesAttr features, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params);
  static ConvOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value filter, ::mlir::Value input, ::mlir::Value output, /*optional*/::mlir::rock::GemmFeaturesAttr features, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, ::mlir::ArrayAttr padding, ::mlir::ArrayAttr strides, ::mlir::ArrayAttr dilations, /*optional*/::mlir::rock::RockTuningParamAttrInterface params);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::mlir::rock::KernelType getKernelType();
  OpOperand *getOutArgument();
  ::mlir::rock::GemmSize getGemmSize();
  ::mlir::Type getAType();
  ::mlir::Type getBType();
  ::mlir::Type getCType();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  SmallVector<::mlir::Type> getTypesForFeature();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 7 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::ConvOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::ConvertingCopyKernelOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ConvertingCopyKernelOpGenericAdaptorBase {
public:
  struct Properties {
    using blockSizeTy = ::mlir::IntegerAttr;
    blockSizeTy blockSize;

    auto getBlockSize() const {
      auto &propStorage = this->blockSize;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setBlockSize(const ::mlir::IntegerAttr &propValue) {
      this->blockSize = propValue;
    }
    using elemsPerThreadTy = ::mlir::IntegerAttr;
    elemsPerThreadTy elemsPerThread;

    auto getElemsPerThread() const {
      auto &propStorage = this->elemsPerThread;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setElemsPerThread(const ::mlir::IntegerAttr &propValue) {
      this->elemsPerThread = propValue;
    }
    using gridSizeTy = ::mlir::IntegerAttr;
    gridSizeTy gridSize;

    auto getGridSize() const {
      auto &propStorage = this->gridSize;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setGridSize(const ::mlir::IntegerAttr &propValue) {
      this->gridSize = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.blockSize == this->blockSize &&
        rhs.elemsPerThread == this->elemsPerThread &&
        rhs.gridSize == this->gridSize &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ConvertingCopyKernelOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.converting_copy_kernel", odsAttrs.getContext());
  }

  ConvertingCopyKernelOpGenericAdaptorBase(ConvertingCopyKernelOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getBlockSizeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().blockSize);
    return attr;
  }

  ::std::optional<uint32_t> getBlockSize();
  ::mlir::IntegerAttr getGridSizeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().gridSize);
    return attr;
  }

  ::std::optional<uint32_t> getGridSize();
  ::mlir::IntegerAttr getElemsPerThreadAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().elemsPerThread);
    return attr;
  }

  ::std::optional< ::llvm::APInt > getElemsPerThread();
};
} // namespace detail
template <typename RangeT>
class ConvertingCopyKernelOpGenericAdaptor : public detail::ConvertingCopyKernelOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ConvertingCopyKernelOpGenericAdaptorBase;
  static constexpr int odsIndex_input = 0;
  static constexpr int odsIndex_output = 1;
public:
  ConvertingCopyKernelOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ConvertingCopyKernelOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ConvertingCopyKernelOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ConvertingCopyKernelOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ConvertingCopyKernelOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ConvertingCopyKernelOpGenericAdaptor(RangeT values, const ConvertingCopyKernelOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ConvertingCopyKernelOp, typename = std::enable_if_t<std::is_same_v<LateInst, ConvertingCopyKernelOp>>>
  ConvertingCopyKernelOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  ValueT getOutput() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ConvertingCopyKernelOpAdaptor : public ConvertingCopyKernelOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ConvertingCopyKernelOpGenericAdaptor::ConvertingCopyKernelOpGenericAdaptor;
  ConvertingCopyKernelOpAdaptor(ConvertingCopyKernelOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ConvertingCopyKernelOp : public ::mlir::Op<ConvertingCopyKernelOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ConvertingCopyKernelOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ConvertingCopyKernelOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_input = 0;
  static constexpr int odsIndex_output = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("blockSize"), ::llvm::StringRef("elemsPerThread"), ::llvm::StringRef("gridSize")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBlockSizeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBlockSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getElemsPerThreadAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getElemsPerThreadAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getGridSizeAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getGridSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.converting_copy_kernel");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::ShapedType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::ShapedType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getOutputMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getResult() {
    auto results = getODSResults(0);
    return results.empty() ? ::mlir::TypedValue<::mlir::TensorType>() : ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*results.begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getBlockSizeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().blockSize);
  }

  ::std::optional<uint32_t> getBlockSize();
  ::mlir::IntegerAttr getGridSizeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().gridSize);
  }

  ::std::optional<uint32_t> getGridSize();
  ::mlir::IntegerAttr getElemsPerThreadAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().elemsPerThread);
  }

  ::std::optional< ::llvm::APInt > getElemsPerThread();
  void setBlockSizeAttr(::mlir::IntegerAttr attr) {
    getProperties().blockSize = attr;
  }

  void setBlockSize(::std::optional<uint32_t> attrValue);
  void setGridSizeAttr(::mlir::IntegerAttr attr) {
    getProperties().gridSize = attr;
  }

  void setGridSize(::std::optional<uint32_t> attrValue);
  void setElemsPerThreadAttr(::mlir::IntegerAttr attr) {
    getProperties().elemsPerThread = attr;
  }

  void setElemsPerThread(::std::optional<::llvm::APInt> attrValue);
  ::mlir::Attribute removeBlockSizeAttr() {
      auto attr = getProperties().blockSize;
      getProperties().blockSize = {};
      return attr;
  }

  ::mlir::Attribute removeGridSizeAttr() {
      auto attr = getProperties().gridSize;
      getProperties().gridSize = {};
      return attr;
  }

  ::mlir::Attribute removeElemsPerThreadAttr() {
      auto attr = getProperties().elemsPerThread;
      getProperties().elemsPerThread = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Type result, ::mlir::Value input, ::mlir::Value output, /*optional*/::mlir::IntegerAttr blockSize, /*optional*/::mlir::IntegerAttr gridSize, /*optional*/::mlir::IntegerAttr elemsPerThread);
  static ConvertingCopyKernelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Type result, ::mlir::Value input, ::mlir::Value output, /*optional*/::mlir::IntegerAttr blockSize, /*optional*/::mlir::IntegerAttr gridSize, /*optional*/::mlir::IntegerAttr elemsPerThread);
  static ConvertingCopyKernelOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Type result, ::mlir::Value input, ::mlir::Value output, /*optional*/::mlir::IntegerAttr blockSize, /*optional*/::mlir::IntegerAttr gridSize, /*optional*/::mlir::IntegerAttr elemsPerThread);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value output, /*optional*/::mlir::IntegerAttr blockSize, /*optional*/::mlir::IntegerAttr gridSize, /*optional*/::mlir::IntegerAttr elemsPerThread);
  static ConvertingCopyKernelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value output, /*optional*/::mlir::IntegerAttr blockSize, /*optional*/::mlir::IntegerAttr gridSize, /*optional*/::mlir::IntegerAttr elemsPerThread);
  static ConvertingCopyKernelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value output, /*optional*/::mlir::IntegerAttr blockSize, /*optional*/::mlir::IntegerAttr gridSize, /*optional*/::mlir::IntegerAttr elemsPerThread);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertingCopyKernelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ConvertingCopyKernelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertingCopyKernelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ConvertingCopyKernelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  ::mlir::OpOperand* getOutArgument() { return &(*this)->getOpOperand(1); }
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::ConvertingCopyKernelOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::ExtractMultiBufferOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ExtractMultiBufferOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ExtractMultiBufferOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.extract_multibuffer", odsAttrs.getContext());
  }

  ExtractMultiBufferOpGenericAdaptorBase(ExtractMultiBufferOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class ExtractMultiBufferOpGenericAdaptor : public detail::ExtractMultiBufferOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ExtractMultiBufferOpGenericAdaptorBase;
  static constexpr int odsIndex_buffers = 0;
  static constexpr int odsIndex_selectIndex = 1;
public:
  ExtractMultiBufferOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ExtractMultiBufferOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ExtractMultiBufferOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ExtractMultiBufferOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ExtractMultiBufferOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ExtractMultiBufferOpGenericAdaptor(RangeT values, const ExtractMultiBufferOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ExtractMultiBufferOp, typename = std::enable_if_t<std::is_same_v<LateInst, ExtractMultiBufferOp>>>
  ExtractMultiBufferOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getBuffers() {
    return getODSOperands(0);
  }

  ValueT getSelectIndex() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ExtractMultiBufferOpAdaptor : public ExtractMultiBufferOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ExtractMultiBufferOpGenericAdaptor::ExtractMultiBufferOpGenericAdaptor;
  ExtractMultiBufferOpAdaptor(ExtractMultiBufferOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ExtractMultiBufferOp : public ::mlir::Op<ExtractMultiBufferOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::MemRefType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ExtractMultiBufferOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ExtractMultiBufferOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_buffers = 0;
  static constexpr int odsIndex_selectIndex = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.extract_multibuffer");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getBuffers() {
    return getODSOperands(0);
  }

  ::mlir::TypedValue<::mlir::IndexType> getSelectIndex() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IndexType>>(*getODSOperands(1).begin());
  }

  ::mlir::MutableOperandRange getBuffersMutable();
  ::mlir::OpOperand &getSelectIndexMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::MemRefType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::ValueRange buffers, ::mlir::Value selectIndex);
  static ExtractMultiBufferOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type output, ::mlir::ValueRange buffers, ::mlir::Value selectIndex);
  static ExtractMultiBufferOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type output, ::mlir::ValueRange buffers, ::mlir::Value selectIndex);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange buffers, ::mlir::Value selectIndex);
  static ExtractMultiBufferOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange buffers, ::mlir::Value selectIndex);
  static ExtractMultiBufferOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange buffers, ::mlir::Value selectIndex);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExtractMultiBufferOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExtractMultiBufferOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExtractMultiBufferOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExtractMultiBufferOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::ExtractMultiBufferOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::ExtractSliceOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ExtractSliceOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ExtractSliceOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.extract_slice", odsAttrs.getContext());
  }

  ExtractSliceOpGenericAdaptorBase(ExtractSliceOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class ExtractSliceOpGenericAdaptor : public detail::ExtractSliceOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ExtractSliceOpGenericAdaptorBase;
  static constexpr int odsIndex_vector = 0;
  static constexpr int odsIndex_coord = 1;
public:
  ExtractSliceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ExtractSliceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ExtractSliceOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ExtractSliceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ExtractSliceOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ExtractSliceOpGenericAdaptor(RangeT values, const ExtractSliceOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ExtractSliceOp, typename = std::enable_if_t<std::is_same_v<LateInst, ExtractSliceOp>>>
  ExtractSliceOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getVector() {
    return (*getODSOperands(0).begin());
  }

  ValueT getCoord() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ExtractSliceOpAdaptor : public ExtractSliceOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ExtractSliceOpGenericAdaptor::ExtractSliceOpGenericAdaptor;
  ExtractSliceOpAdaptor(ExtractSliceOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ExtractSliceOp : public ::mlir::Op<ExtractSliceOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ExtractSliceOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ExtractSliceOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_vector = 0;
  static constexpr int odsIndex_coord = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.extract_slice");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getVector() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IndexType> getCoord() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IndexType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getVectorMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getCoordMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value vector, ::mlir::Value coord);
  static ExtractSliceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value vector, ::mlir::Value coord);
  static ExtractSliceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value vector, ::mlir::Value coord);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value vector, ::mlir::Value coord);
  static ExtractSliceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value vector, ::mlir::Value coord);
  static ExtractSliceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value vector, ::mlir::Value coord);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExtractSliceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ExtractSliceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExtractSliceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ExtractSliceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult canonicalize(ExtractSliceOp op, ::mlir::PatternRewriter &rewriter);
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::ExtractSliceOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::FillOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class FillOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  FillOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.fill", odsAttrs.getContext());
  }

  FillOpGenericAdaptorBase(FillOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class FillOpGenericAdaptor : public detail::FillOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::FillOpGenericAdaptorBase;
  static constexpr int odsIndex_input = 0;
  static constexpr int odsIndex_value = 1;
public:
  FillOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  FillOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : FillOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  FillOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : FillOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  FillOpGenericAdaptor(RangeT values, const FillOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = FillOp, typename = std::enable_if_t<std::is_same_v<LateInst, FillOp>>>
  FillOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  ValueT getValue() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class FillOpAdaptor : public FillOpGenericAdaptor<::mlir::ValueRange> {
public:
  using FillOpGenericAdaptor::FillOpGenericAdaptor;
  FillOpAdaptor(FillOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class FillOp : public ::mlir::Op<FillOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = FillOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = FillOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_input = 0;
  static constexpr int odsIndex_value = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.fill");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::MemRefType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::Type> getValue() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getValueMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value input, ::mlir::Value value);
  static FillOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value input, ::mlir::Value value);
  static FillOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value input, ::mlir::Value value);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value value);
  static FillOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value value);
  static FillOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::Value value);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FillOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static FillOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FillOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static FillOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::FillOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::GemmElementwiseGemmOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class GemmElementwiseGemmOpGenericAdaptorBase {
public:
  struct Properties {
    using aTransposedTy = ::mlir::UnitAttr;
    aTransposedTy aTransposed;

    auto getATransposed() const {
      auto &propStorage = this->aTransposed;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setATransposed(const ::mlir::UnitAttr &propValue) {
      this->aTransposed = propValue;
    }
    using bTransposedTy = ::mlir::UnitAttr;
    bTransposedTy bTransposed;

    auto getBTransposed() const {
      auto &propStorage = this->bTransposed;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setBTransposed(const ::mlir::UnitAttr &propValue) {
      this->bTransposed = propValue;
    }
    using cTransposedTy = ::mlir::UnitAttr;
    cTransposedTy cTransposed;

    auto getCTransposed() const {
      auto &propStorage = this->cTransposed;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setCTransposed(const ::mlir::UnitAttr &propValue) {
      this->cTransposed = propValue;
    }
    using featuresTy = ::mlir::rock::GemmFeaturesAttr;
    featuresTy features;

    auto getFeatures() const {
      auto &propStorage = this->features;
      return ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(propStorage);
    }
    void setFeatures(const ::mlir::rock::GemmFeaturesAttr &propValue) {
      this->features = propValue;
    }
    using firstGemmIndicesTy = ::mlir::DenseI64ArrayAttr;
    firstGemmIndicesTy firstGemmIndices;

    auto getFirstGemmIndices() const {
      auto &propStorage = this->firstGemmIndices;
      return ::llvm::cast<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setFirstGemmIndices(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->firstGemmIndices = propValue;
    }
    using oTransposedTy = ::mlir::UnitAttr;
    oTransposedTy oTransposed;

    auto getOTransposed() const {
      auto &propStorage = this->oTransposed;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setOTransposed(const ::mlir::UnitAttr &propValue) {
      this->oTransposed = propValue;
    }
    using params0Ty = ::mlir::rock::RockTuningParamAttrInterface;
    params0Ty params0;

    auto getParams0() const {
      auto &propStorage = this->params0;
      return ::llvm::dyn_cast_or_null<::mlir::rock::RockTuningParamAttrInterface>(propStorage);
    }
    void setParams0(const ::mlir::rock::RockTuningParamAttrInterface &propValue) {
      this->params0 = propValue;
    }
    using params1Ty = ::mlir::rock::RockTuningParamAttrInterface;
    params1Ty params1;

    auto getParams1() const {
      auto &propStorage = this->params1;
      return ::llvm::dyn_cast_or_null<::mlir::rock::RockTuningParamAttrInterface>(propStorage);
    }
    void setParams1(const ::mlir::rock::RockTuningParamAttrInterface &propValue) {
      this->params1 = propValue;
    }
    using storeMethodTy = ::mlir::rock::StoreMethodAttr;
    storeMethodTy storeMethod;

    auto getStoreMethod() const {
      auto &propStorage = this->storeMethod;
      return ::llvm::cast<::mlir::rock::StoreMethodAttr>(propStorage);
    }
    void setStoreMethod(const ::mlir::rock::StoreMethodAttr &propValue) {
      this->storeMethod = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.aTransposed == this->aTransposed &&
        rhs.bTransposed == this->bTransposed &&
        rhs.cTransposed == this->cTransposed &&
        rhs.features == this->features &&
        rhs.firstGemmIndices == this->firstGemmIndices &&
        rhs.oTransposed == this->oTransposed &&
        rhs.params0 == this->params0 &&
        rhs.params1 == this->params1 &&
        rhs.storeMethod == this->storeMethod &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  GemmElementwiseGemmOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.gemm_elementwise_gemm", odsAttrs.getContext());
  }

  GemmElementwiseGemmOpGenericAdaptorBase(GemmElementwiseGemmOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::UnitAttr getATransposedAttr();
  bool getATransposed();
  ::mlir::UnitAttr getBTransposedAttr();
  bool getBTransposed();
  ::mlir::UnitAttr getCTransposedAttr();
  bool getCTransposed();
  ::mlir::UnitAttr getOTransposedAttr();
  bool getOTransposed();
  ::mlir::rock::GemmFeaturesAttr getFeaturesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(getProperties().features);
    return attr;
  }

  ::std::optional<::mlir::rock::GemmFeatures> getFeatures();
  ::mlir::rock::StoreMethodAttr getStoreMethodAttr() {
    auto attr = ::llvm::cast<::mlir::rock::StoreMethodAttr>(getProperties().storeMethod);
    return attr;
  }

  ::mlir::rock::StoreMethod getStoreMethod();
  ::mlir::rock::RockTuningParamAttrInterface getParams0Attr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::rock::RockTuningParamAttrInterface>(getProperties().params0);
    return attr;
  }

  ::std::optional<::mlir::rock::RockTuningParamAttrInterface> getParams0();
  ::mlir::rock::RockTuningParamAttrInterface getParams1Attr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::rock::RockTuningParamAttrInterface>(getProperties().params1);
    return attr;
  }

  ::std::optional<::mlir::rock::RockTuningParamAttrInterface> getParams1();
  ::mlir::DenseI64ArrayAttr getFirstGemmIndicesAttr() {
    auto attr = ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().firstGemmIndices);
    return attr;
  }

  ::llvm::ArrayRef<int64_t> getFirstGemmIndices();
  ::mlir::Region &getPreSecondGemmBody() {
    return *odsRegions[0];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};
} // namespace detail
template <typename RangeT>
class GemmElementwiseGemmOpGenericAdaptor : public detail::GemmElementwiseGemmOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::GemmElementwiseGemmOpGenericAdaptorBase;
  static constexpr int odsIndex_a = 0;
  static constexpr int odsIndex_b = 1;
  static constexpr int odsIndex_c = 2;
  static constexpr int odsIndex_elemwiseInputs = 3;
  static constexpr int odsIndex_out = 4;
public:
  GemmElementwiseGemmOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  GemmElementwiseGemmOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : GemmElementwiseGemmOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  GemmElementwiseGemmOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : GemmElementwiseGemmOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  GemmElementwiseGemmOpGenericAdaptor(RangeT values, const GemmElementwiseGemmOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = GemmElementwiseGemmOp, typename = std::enable_if_t<std::is_same_v<LateInst, GemmElementwiseGemmOp>>>
  GemmElementwiseGemmOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getA() {
    return (*getODSOperands(0).begin());
  }

  ValueT getB() {
    return (*getODSOperands(1).begin());
  }

  ValueT getC() {
    return (*getODSOperands(2).begin());
  }

  RangeT getElemwiseInputs() {
    return getODSOperands(3);
  }

  ValueT getOut() {
    return (*getODSOperands(4).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class GemmElementwiseGemmOpAdaptor : public GemmElementwiseGemmOpGenericAdaptor<::mlir::ValueRange> {
public:
  using GemmElementwiseGemmOpGenericAdaptor::GemmElementwiseGemmOpGenericAdaptor;
  GemmElementwiseGemmOpAdaptor(GemmElementwiseGemmOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class GemmElementwiseGemmOp : public ::mlir::Op<GemmElementwiseGemmOp, ::mlir::OpTrait::OneRegion, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<4>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::rock::RockGemmGemmWrapperInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::rock::RockGemmFeaturesInterface::Trait, mlir::OpTrait::rock::FusionRoot> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = GemmElementwiseGemmOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = GemmElementwiseGemmOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_a = 0;
  static constexpr int odsIndex_b = 1;
  static constexpr int odsIndex_c = 2;
  static constexpr int odsIndex_elemwiseInputs = 3;
  static constexpr int odsIndex_out = 4;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("aTransposed"), ::llvm::StringRef("bTransposed"), ::llvm::StringRef("cTransposed"), ::llvm::StringRef("features"), ::llvm::StringRef("firstGemmIndices"), ::llvm::StringRef("oTransposed"), ::llvm::StringRef("params0"), ::llvm::StringRef("params1"), ::llvm::StringRef("storeMethod")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getATransposedAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getATransposedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getBTransposedAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getBTransposedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getCTransposedAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getCTransposedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getFeaturesAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getFeaturesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getFirstGemmIndicesAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getFirstGemmIndicesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getOTransposedAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getOTransposedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getParams0AttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getParams0AttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getParams1AttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getParams1AttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getStoreMethodAttrName() {
    return getAttributeNameForIndex(8);
  }

  static ::mlir::StringAttr getStoreMethodAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 8);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.gemm_elementwise_gemm");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::ShapedType> getA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::ShapedType> getB() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::ShapedType> getC() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*getODSOperands(2).begin());
  }

  ::mlir::Operation::operand_range getElemwiseInputs() {
    return getODSOperands(3);
  }

  ::mlir::TypedValue<::mlir::ShapedType> getOut() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*getODSOperands(4).begin());
  }

  ::mlir::OpOperand &getAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getBMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getCMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getElemwiseInputsMutable();
  ::mlir::OpOperand &getOutMutable() {
    auto range = getODSOperandIndexAndLength(4);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getResult() {
    auto results = getODSResults(0);
    return results.empty() ? ::mlir::TypedValue<::mlir::TensorType>() : ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*results.begin());
  }

  ::mlir::Region &getPreSecondGemmBody() {
    return (*this)->getRegion(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::UnitAttr getATransposedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().aTransposed);
  }

  bool getATransposed();
  ::mlir::UnitAttr getBTransposedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().bTransposed);
  }

  bool getBTransposed();
  ::mlir::UnitAttr getCTransposedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().cTransposed);
  }

  bool getCTransposed();
  ::mlir::UnitAttr getOTransposedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().oTransposed);
  }

  bool getOTransposed();
  ::mlir::rock::GemmFeaturesAttr getFeaturesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(getProperties().features);
  }

  ::std::optional<::mlir::rock::GemmFeatures> getFeatures();
  ::mlir::rock::StoreMethodAttr getStoreMethodAttr() {
    return ::llvm::cast<::mlir::rock::StoreMethodAttr>(getProperties().storeMethod);
  }

  ::mlir::rock::StoreMethod getStoreMethod();
  ::mlir::rock::RockTuningParamAttrInterface getParams0Attr() {
    return ::llvm::dyn_cast_or_null<::mlir::rock::RockTuningParamAttrInterface>(getProperties().params0);
  }

  ::std::optional<::mlir::rock::RockTuningParamAttrInterface> getParams0();
  ::mlir::rock::RockTuningParamAttrInterface getParams1Attr() {
    return ::llvm::dyn_cast_or_null<::mlir::rock::RockTuningParamAttrInterface>(getProperties().params1);
  }

  ::std::optional<::mlir::rock::RockTuningParamAttrInterface> getParams1();
  ::mlir::DenseI64ArrayAttr getFirstGemmIndicesAttr() {
    return ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().firstGemmIndices);
  }

  ::llvm::ArrayRef<int64_t> getFirstGemmIndices();
  void setATransposedAttr(::mlir::UnitAttr attr) {
    getProperties().aTransposed = attr;
  }

  void setATransposed(bool attrValue);
  void setBTransposedAttr(::mlir::UnitAttr attr) {
    getProperties().bTransposed = attr;
  }

  void setBTransposed(bool attrValue);
  void setCTransposedAttr(::mlir::UnitAttr attr) {
    getProperties().cTransposed = attr;
  }

  void setCTransposed(bool attrValue);
  void setOTransposedAttr(::mlir::UnitAttr attr) {
    getProperties().oTransposed = attr;
  }

  void setOTransposed(bool attrValue);
  void setFeaturesAttr(::mlir::rock::GemmFeaturesAttr attr) {
    getProperties().features = attr;
  }

  void setFeatures(::std::optional<::mlir::rock::GemmFeatures> attrValue);
  void setStoreMethodAttr(::mlir::rock::StoreMethodAttr attr) {
    getProperties().storeMethod = attr;
  }

  void setStoreMethod(::mlir::rock::StoreMethod attrValue);
  void setParams0Attr(::mlir::rock::RockTuningParamAttrInterface attr) {
    getProperties().params0 = attr;
  }

  void setParams1Attr(::mlir::rock::RockTuningParamAttrInterface attr) {
    getProperties().params1 = attr;
  }

  void setFirstGemmIndicesAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().firstGemmIndices = attr;
  }

  void setFirstGemmIndices(::llvm::ArrayRef<int64_t> attrValue);
  ::mlir::Attribute removeATransposedAttr() {
      auto attr = getProperties().aTransposed;
      getProperties().aTransposed = {};
      return attr;
  }

  ::mlir::Attribute removeBTransposedAttr() {
      auto attr = getProperties().bTransposed;
      getProperties().bTransposed = {};
      return attr;
  }

  ::mlir::Attribute removeCTransposedAttr() {
      auto attr = getProperties().cTransposed;
      getProperties().cTransposed = {};
      return attr;
  }

  ::mlir::Attribute removeOTransposedAttr() {
      auto attr = getProperties().oTransposed;
      getProperties().oTransposed = {};
      return attr;
  }

  ::mlir::Attribute removeFeaturesAttr() {
      auto attr = getProperties().features;
      getProperties().features = {};
      return attr;
  }

  ::mlir::Attribute removeParams0Attr() {
      auto attr = getProperties().params0;
      getProperties().params0 = {};
      return attr;
  }

  ::mlir::Attribute removeParams1Attr() {
      auto attr = getProperties().params1;
      getProperties().params1 = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Type result, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, ::mlir::ValueRange elemwiseInputs, ::mlir::Value out, /*optional*/::mlir::UnitAttr aTransposed, /*optional*/::mlir::UnitAttr bTransposed, /*optional*/::mlir::UnitAttr cTransposed, /*optional*/::mlir::UnitAttr oTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::mlir::DenseI64ArrayAttr firstGemmIndices);
  static GemmElementwiseGemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Type result, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, ::mlir::ValueRange elemwiseInputs, ::mlir::Value out, /*optional*/::mlir::UnitAttr aTransposed, /*optional*/::mlir::UnitAttr bTransposed, /*optional*/::mlir::UnitAttr cTransposed, /*optional*/::mlir::UnitAttr oTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::mlir::DenseI64ArrayAttr firstGemmIndices);
  static GemmElementwiseGemmOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Type result, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, ::mlir::ValueRange elemwiseInputs, ::mlir::Value out, /*optional*/::mlir::UnitAttr aTransposed, /*optional*/::mlir::UnitAttr bTransposed, /*optional*/::mlir::UnitAttr cTransposed, /*optional*/::mlir::UnitAttr oTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::mlir::DenseI64ArrayAttr firstGemmIndices);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, ::mlir::ValueRange elemwiseInputs, ::mlir::Value out, /*optional*/::mlir::UnitAttr aTransposed, /*optional*/::mlir::UnitAttr bTransposed, /*optional*/::mlir::UnitAttr cTransposed, /*optional*/::mlir::UnitAttr oTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::mlir::DenseI64ArrayAttr firstGemmIndices);
  static GemmElementwiseGemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, ::mlir::ValueRange elemwiseInputs, ::mlir::Value out, /*optional*/::mlir::UnitAttr aTransposed, /*optional*/::mlir::UnitAttr bTransposed, /*optional*/::mlir::UnitAttr cTransposed, /*optional*/::mlir::UnitAttr oTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::mlir::DenseI64ArrayAttr firstGemmIndices);
  static GemmElementwiseGemmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, ::mlir::ValueRange elemwiseInputs, ::mlir::Value out, /*optional*/::mlir::UnitAttr aTransposed, /*optional*/::mlir::UnitAttr bTransposed, /*optional*/::mlir::UnitAttr cTransposed, /*optional*/::mlir::UnitAttr oTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::mlir::DenseI64ArrayAttr firstGemmIndices);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Type result, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, ::mlir::ValueRange elemwiseInputs, ::mlir::Value out, /*optional*/bool aTransposed, /*optional*/bool bTransposed, /*optional*/bool cTransposed, /*optional*/bool oTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::llvm::ArrayRef<int64_t> firstGemmIndices);
  static GemmElementwiseGemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Type result, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, ::mlir::ValueRange elemwiseInputs, ::mlir::Value out, /*optional*/bool aTransposed, /*optional*/bool bTransposed, /*optional*/bool cTransposed, /*optional*/bool oTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::llvm::ArrayRef<int64_t> firstGemmIndices);
  static GemmElementwiseGemmOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Type result, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, ::mlir::ValueRange elemwiseInputs, ::mlir::Value out, /*optional*/bool aTransposed, /*optional*/bool bTransposed, /*optional*/bool cTransposed, /*optional*/bool oTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::llvm::ArrayRef<int64_t> firstGemmIndices);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, ::mlir::ValueRange elemwiseInputs, ::mlir::Value out, /*optional*/bool aTransposed, /*optional*/bool bTransposed, /*optional*/bool cTransposed, /*optional*/bool oTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::llvm::ArrayRef<int64_t> firstGemmIndices);
  static GemmElementwiseGemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, ::mlir::ValueRange elemwiseInputs, ::mlir::Value out, /*optional*/bool aTransposed, /*optional*/bool bTransposed, /*optional*/bool cTransposed, /*optional*/bool oTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::llvm::ArrayRef<int64_t> firstGemmIndices);
  static GemmElementwiseGemmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, ::mlir::ValueRange elemwiseInputs, ::mlir::Value out, /*optional*/bool aTransposed, /*optional*/bool bTransposed, /*optional*/bool cTransposed, /*optional*/bool oTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, /*optional*/::mlir::rock::RockTuningParamAttrInterface params0, /*optional*/::mlir::rock::RockTuningParamAttrInterface params1, ::llvm::ArrayRef<int64_t> firstGemmIndices);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GemmElementwiseGemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GemmElementwiseGemmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GemmElementwiseGemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GemmElementwiseGemmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::mlir::rock::KernelType getKernelType();
  OpOperand *getOutArgument();
  ::mlir::rock::GemmGemmSize getGemmGemmSize();
  ::mlir::Type getAType();
  ::mlir::Type getBType();
  ::mlir::Type getCType();
  ::mlir::Type getOutType();
  bool getTransposedA();
  bool getTransposedB();
  bool getTransposedC();
  bool getTransposedOut();
  Region&getPreSecondGemmRegion();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  SmallVector<::mlir::Type> getTypesForFeature();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 9 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::GemmElementwiseGemmOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::GemmOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class GemmOpGenericAdaptorBase {
public:
  struct Properties {
    using aTransposedTy = ::mlir::UnitAttr;
    aTransposedTy aTransposed;

    auto getATransposed() const {
      auto &propStorage = this->aTransposed;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setATransposed(const ::mlir::UnitAttr &propValue) {
      this->aTransposed = propValue;
    }
    using bTransposedTy = ::mlir::UnitAttr;
    bTransposedTy bTransposed;

    auto getBTransposed() const {
      auto &propStorage = this->bTransposed;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setBTransposed(const ::mlir::UnitAttr &propValue) {
      this->bTransposed = propValue;
    }
    using cTransposedTy = ::mlir::UnitAttr;
    cTransposedTy cTransposed;

    auto getCTransposed() const {
      auto &propStorage = this->cTransposed;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setCTransposed(const ::mlir::UnitAttr &propValue) {
      this->cTransposed = propValue;
    }
    using derivedBlockSizeTy = ::mlir::IntegerAttr;
    derivedBlockSizeTy derivedBlockSize;

    auto getDerivedBlockSize() const {
      auto &propStorage = this->derivedBlockSize;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setDerivedBlockSize(const ::mlir::IntegerAttr &propValue) {
      this->derivedBlockSize = propValue;
    }
    using featuresTy = ::mlir::rock::GemmFeaturesAttr;
    featuresTy features;

    auto getFeatures() const {
      auto &propStorage = this->features;
      return ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(propStorage);
    }
    void setFeatures(const ::mlir::rock::GemmFeaturesAttr &propValue) {
      this->features = propValue;
    }
    using gridSizeTy = ::mlir::IntegerAttr;
    gridSizeTy gridSize;

    auto getGridSize() const {
      auto &propStorage = this->gridSize;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setGridSize(const ::mlir::IntegerAttr &propValue) {
      this->gridSize = propValue;
    }
    using paramsTy = ::mlir::rock::RockTuningParamAttrInterface;
    paramsTy params;

    auto getParams() const {
      auto &propStorage = this->params;
      return ::llvm::dyn_cast_or_null<::mlir::rock::RockTuningParamAttrInterface>(propStorage);
    }
    void setParams(const ::mlir::rock::RockTuningParamAttrInterface &propValue) {
      this->params = propValue;
    }
    using storeMethodTy = ::mlir::rock::StoreMethodAttr;
    storeMethodTy storeMethod;

    auto getStoreMethod() const {
      auto &propStorage = this->storeMethod;
      return ::llvm::cast<::mlir::rock::StoreMethodAttr>(propStorage);
    }
    void setStoreMethod(const ::mlir::rock::StoreMethodAttr &propValue) {
      this->storeMethod = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.aTransposed == this->aTransposed &&
        rhs.bTransposed == this->bTransposed &&
        rhs.cTransposed == this->cTransposed &&
        rhs.derivedBlockSize == this->derivedBlockSize &&
        rhs.features == this->features &&
        rhs.gridSize == this->gridSize &&
        rhs.params == this->params &&
        rhs.storeMethod == this->storeMethod &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  GemmOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.gemm", odsAttrs.getContext());
  }

  GemmOpGenericAdaptorBase(GemmOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::UnitAttr getATransposedAttr();
  bool getATransposed();
  ::mlir::UnitAttr getBTransposedAttr();
  bool getBTransposed();
  ::mlir::UnitAttr getCTransposedAttr();
  bool getCTransposed();
  ::mlir::rock::GemmFeaturesAttr getFeaturesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(getProperties().features);
    return attr;
  }

  ::std::optional<::mlir::rock::GemmFeatures> getFeatures();
  ::mlir::rock::StoreMethodAttr getStoreMethodAttr() {
    auto attr = ::llvm::cast<::mlir::rock::StoreMethodAttr>(getProperties().storeMethod);
    return attr;
  }

  ::mlir::rock::StoreMethod getStoreMethod();
  ::mlir::IntegerAttr getDerivedBlockSizeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().derivedBlockSize);
    return attr;
  }

  ::std::optional<uint32_t> getDerivedBlockSize();
  ::mlir::IntegerAttr getGridSizeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().gridSize);
    return attr;
  }

  ::std::optional<uint32_t> getGridSize();
  ::mlir::rock::RockTuningParamAttrInterface getParamsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::rock::RockTuningParamAttrInterface>(getProperties().params);
    return attr;
  }

  ::std::optional<::mlir::rock::RockTuningParamAttrInterface> getParams();
};
} // namespace detail
template <typename RangeT>
class GemmOpGenericAdaptor : public detail::GemmOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::GemmOpGenericAdaptorBase;
  static constexpr int odsIndex_a = 0;
  static constexpr int odsIndex_b = 1;
  static constexpr int odsIndex_c = 2;
public:
  GemmOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  GemmOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : GemmOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  GemmOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : GemmOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  GemmOpGenericAdaptor(RangeT values, const GemmOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = GemmOp, typename = std::enable_if_t<std::is_same_v<LateInst, GemmOp>>>
  GemmOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getA() {
    return (*getODSOperands(0).begin());
  }

  ValueT getB() {
    return (*getODSOperands(1).begin());
  }

  ValueT getC() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class GemmOpAdaptor : public GemmOpGenericAdaptor<::mlir::ValueRange> {
public:
  using GemmOpGenericAdaptor::GemmOpGenericAdaptor;
  GemmOpAdaptor(GemmOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class GemmOp : public ::mlir::Op<GemmOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::rock::RockGemmWrapperInterface::Trait, ::mlir::rock::RockGemmFeaturesInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, mlir::OpTrait::rock::FusionRoot> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = GemmOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = GemmOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_a = 0;
  static constexpr int odsIndex_b = 1;
  static constexpr int odsIndex_c = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("aTransposed"), ::llvm::StringRef("bTransposed"), ::llvm::StringRef("cTransposed"), ::llvm::StringRef("derivedBlockSize"), ::llvm::StringRef("features"), ::llvm::StringRef("gridSize"), ::llvm::StringRef("params"), ::llvm::StringRef("storeMethod")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getATransposedAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getATransposedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getBTransposedAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getBTransposedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getCTransposedAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getCTransposedAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getDerivedBlockSizeAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getDerivedBlockSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getFeaturesAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getFeaturesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getGridSizeAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getGridSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getParamsAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getParamsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getStoreMethodAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getStoreMethodAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.gemm");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::ShapedType> getA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::ShapedType> getB() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::ShapedType> getC() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getBMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getCMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getResult() {
    auto results = getODSResults(0);
    return results.empty() ? ::mlir::TypedValue<::mlir::RankedTensorType>() : ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*results.begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::UnitAttr getATransposedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().aTransposed);
  }

  bool getATransposed();
  ::mlir::UnitAttr getBTransposedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().bTransposed);
  }

  bool getBTransposed();
  ::mlir::UnitAttr getCTransposedAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().cTransposed);
  }

  bool getCTransposed();
  ::mlir::rock::GemmFeaturesAttr getFeaturesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(getProperties().features);
  }

  ::std::optional<::mlir::rock::GemmFeatures> getFeatures();
  ::mlir::rock::StoreMethodAttr getStoreMethodAttr() {
    return ::llvm::cast<::mlir::rock::StoreMethodAttr>(getProperties().storeMethod);
  }

  ::mlir::rock::StoreMethod getStoreMethod();
  ::mlir::IntegerAttr getDerivedBlockSizeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().derivedBlockSize);
  }

  ::std::optional<uint32_t> getDerivedBlockSize();
  ::mlir::IntegerAttr getGridSizeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().gridSize);
  }

  ::std::optional<uint32_t> getGridSize();
  ::mlir::rock::RockTuningParamAttrInterface getParamsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::rock::RockTuningParamAttrInterface>(getProperties().params);
  }

  ::std::optional<::mlir::rock::RockTuningParamAttrInterface> getParams();
  void setATransposedAttr(::mlir::UnitAttr attr) {
    getProperties().aTransposed = attr;
  }

  void setATransposed(bool attrValue);
  void setBTransposedAttr(::mlir::UnitAttr attr) {
    getProperties().bTransposed = attr;
  }

  void setBTransposed(bool attrValue);
  void setCTransposedAttr(::mlir::UnitAttr attr) {
    getProperties().cTransposed = attr;
  }

  void setCTransposed(bool attrValue);
  void setFeaturesAttr(::mlir::rock::GemmFeaturesAttr attr) {
    getProperties().features = attr;
  }

  void setFeatures(::std::optional<::mlir::rock::GemmFeatures> attrValue);
  void setStoreMethodAttr(::mlir::rock::StoreMethodAttr attr) {
    getProperties().storeMethod = attr;
  }

  void setStoreMethod(::mlir::rock::StoreMethod attrValue);
  void setDerivedBlockSizeAttr(::mlir::IntegerAttr attr) {
    getProperties().derivedBlockSize = attr;
  }

  void setDerivedBlockSize(::std::optional<uint32_t> attrValue);
  void setGridSizeAttr(::mlir::IntegerAttr attr) {
    getProperties().gridSize = attr;
  }

  void setGridSize(::std::optional<uint32_t> attrValue);
  void setParamsAttr(::mlir::rock::RockTuningParamAttrInterface attr) {
    getProperties().params = attr;
  }

  ::mlir::Attribute removeATransposedAttr() {
      auto attr = getProperties().aTransposed;
      getProperties().aTransposed = {};
      return attr;
  }

  ::mlir::Attribute removeBTransposedAttr() {
      auto attr = getProperties().bTransposed;
      getProperties().bTransposed = {};
      return attr;
  }

  ::mlir::Attribute removeCTransposedAttr() {
      auto attr = getProperties().cTransposed;
      getProperties().cTransposed = {};
      return attr;
  }

  ::mlir::Attribute removeFeaturesAttr() {
      auto attr = getProperties().features;
      getProperties().features = {};
      return attr;
  }

  ::mlir::Attribute removeDerivedBlockSizeAttr() {
      auto attr = getProperties().derivedBlockSize;
      getProperties().derivedBlockSize = {};
      return attr;
  }

  ::mlir::Attribute removeGridSizeAttr() {
      auto attr = getProperties().gridSize;
      getProperties().gridSize = {};
      return attr;
  }

  ::mlir::Attribute removeParamsAttr() {
      auto attr = getProperties().params;
      getProperties().params = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Type result, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::UnitAttr aTransposed, /*optional*/::mlir::UnitAttr bTransposed, /*optional*/::mlir::UnitAttr cTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, /*optional*/::mlir::rock::RockTuningParamAttrInterface params);
  static GemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Type result, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::UnitAttr aTransposed, /*optional*/::mlir::UnitAttr bTransposed, /*optional*/::mlir::UnitAttr cTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, /*optional*/::mlir::rock::RockTuningParamAttrInterface params);
  static GemmOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Type result, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::UnitAttr aTransposed, /*optional*/::mlir::UnitAttr bTransposed, /*optional*/::mlir::UnitAttr cTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, /*optional*/::mlir::rock::RockTuningParamAttrInterface params);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::UnitAttr aTransposed, /*optional*/::mlir::UnitAttr bTransposed, /*optional*/::mlir::UnitAttr cTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, /*optional*/::mlir::rock::RockTuningParamAttrInterface params);
  static GemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::UnitAttr aTransposed, /*optional*/::mlir::UnitAttr bTransposed, /*optional*/::mlir::UnitAttr cTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, /*optional*/::mlir::rock::RockTuningParamAttrInterface params);
  static GemmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::UnitAttr aTransposed, /*optional*/::mlir::UnitAttr bTransposed, /*optional*/::mlir::UnitAttr cTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, /*optional*/::mlir::rock::RockTuningParamAttrInterface params);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Type result, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/bool aTransposed, /*optional*/bool bTransposed, /*optional*/bool cTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, /*optional*/::mlir::rock::RockTuningParamAttrInterface params);
  static GemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Type result, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/bool aTransposed, /*optional*/bool bTransposed, /*optional*/bool cTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, /*optional*/::mlir::rock::RockTuningParamAttrInterface params);
  static GemmOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Type result, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/bool aTransposed, /*optional*/bool bTransposed, /*optional*/bool cTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, /*optional*/::mlir::rock::RockTuningParamAttrInterface params);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/bool aTransposed, /*optional*/bool bTransposed, /*optional*/bool cTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, /*optional*/::mlir::rock::RockTuningParamAttrInterface params);
  static GemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/bool aTransposed, /*optional*/bool bTransposed, /*optional*/bool cTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, /*optional*/::mlir::rock::RockTuningParamAttrInterface params);
  static GemmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/bool aTransposed, /*optional*/bool bTransposed, /*optional*/bool cTransposed, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, /*optional*/::mlir::IntegerAttr derivedBlockSize, /*optional*/::mlir::IntegerAttr gridSize, /*optional*/::mlir::rock::RockTuningParamAttrInterface params);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GemmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GemmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  ::mlir::rock::KernelType getKernelType();
  OpOperand *getOutArgument();
  ::mlir::rock::GemmSize getGemmSize();
  ::mlir::Type getAType();
  ::mlir::Type getBType();
  ::mlir::Type getCType();
  SmallVector<::mlir::Type> getTypesForFeature();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 8 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::GemmOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::GlobalLoadOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class GlobalLoadOpGenericAdaptorBase {
public:
  struct Properties {
    using canReadOffEndTy = ::mlir::UnitAttr;
    canReadOffEndTy canReadOffEnd;

    auto getCanReadOffEnd() const {
      auto &propStorage = this->canReadOffEnd;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setCanReadOffEnd(const ::mlir::UnitAttr &propValue) {
      this->canReadOffEnd = propValue;
    }
    using needs64BitIdxTy = ::mlir::UnitAttr;
    needs64BitIdxTy needs64BitIdx;

    auto getNeeds64BitIdx() const {
      auto &propStorage = this->needs64BitIdx;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setNeeds64BitIdx(const ::mlir::UnitAttr &propValue) {
      this->needs64BitIdx = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.canReadOffEnd == this->canReadOffEnd &&
        rhs.needs64BitIdx == this->needs64BitIdx &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  GlobalLoadOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.global_load", odsAttrs.getContext());
  }

  GlobalLoadOpGenericAdaptorBase(GlobalLoadOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::UnitAttr getNeeds64BitIdxAttr();
  bool getNeeds64BitIdx();
  ::mlir::UnitAttr getCanReadOffEndAttr();
  bool getCanReadOffEnd();
};
} // namespace detail
template <typename RangeT>
class GlobalLoadOpGenericAdaptor : public detail::GlobalLoadOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::GlobalLoadOpGenericAdaptorBase;
  static constexpr int odsIndex_source = 0;
  static constexpr int odsIndex_valid = 1;
  static constexpr int odsIndex_sourceCoord = 2;
public:
  GlobalLoadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  GlobalLoadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : GlobalLoadOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  GlobalLoadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : GlobalLoadOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  GlobalLoadOpGenericAdaptor(RangeT values, const GlobalLoadOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = GlobalLoadOp, typename = std::enable_if_t<std::is_same_v<LateInst, GlobalLoadOp>>>
  GlobalLoadOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSource() {
    return (*getODSOperands(0).begin());
  }

  ValueT getValid() {
    return (*getODSOperands(1).begin());
  }

  RangeT getSourceCoord() {
    return getODSOperands(2);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class GlobalLoadOpAdaptor : public GlobalLoadOpGenericAdaptor<::mlir::ValueRange> {
public:
  using GlobalLoadOpGenericAdaptor::GlobalLoadOpGenericAdaptor;
  GlobalLoadOpAdaptor(GlobalLoadOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class GlobalLoadOp : public ::mlir::Op<GlobalLoadOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = GlobalLoadOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = GlobalLoadOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_source = 0;
  static constexpr int odsIndex_valid = 1;
  static constexpr int odsIndex_sourceCoord = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("canReadOffEnd"), ::llvm::StringRef("needs64BitIdx")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getCanReadOffEndAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getCanReadOffEndAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getNeeds64BitIdxAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getNeeds64BitIdxAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.global_load");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::MemRefType> getSource() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getValid() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(1).begin());
  }

  ::mlir::Operation::operand_range getSourceCoord() {
    return getODSOperands(2);
  }

  ::mlir::OpOperand &getSourceMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getValidMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getSourceCoordMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::UnitAttr getNeeds64BitIdxAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().needs64BitIdx);
  }

  bool getNeeds64BitIdx();
  ::mlir::UnitAttr getCanReadOffEndAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().canReadOffEnd);
  }

  bool getCanReadOffEnd();
  void setNeeds64BitIdxAttr(::mlir::UnitAttr attr) {
    getProperties().needs64BitIdx = attr;
  }

  void setNeeds64BitIdx(bool attrValue);
  void setCanReadOffEndAttr(::mlir::UnitAttr attr) {
    getProperties().canReadOffEnd = attr;
  }

  void setCanReadOffEnd(bool attrValue);
  ::mlir::Attribute removeNeeds64BitIdxAttr() {
      auto attr = getProperties().needs64BitIdx;
      getProperties().needs64BitIdx = {};
      return attr;
  }

  ::mlir::Attribute removeCanReadOffEndAttr() {
      auto attr = getProperties().canReadOffEnd;
      getProperties().canReadOffEnd = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value source, ::mlir::Value valid, ::mlir::ValueRange sourceCoord, /*optional*/::mlir::UnitAttr needs64BitIdx, /*optional*/::mlir::UnitAttr canReadOffEnd = nullptr);
  static GlobalLoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value source, ::mlir::Value valid, ::mlir::ValueRange sourceCoord, /*optional*/::mlir::UnitAttr needs64BitIdx, /*optional*/::mlir::UnitAttr canReadOffEnd = nullptr);
  static GlobalLoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value source, ::mlir::Value valid, ::mlir::ValueRange sourceCoord, /*optional*/::mlir::UnitAttr needs64BitIdx, /*optional*/::mlir::UnitAttr canReadOffEnd = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value valid, ::mlir::ValueRange sourceCoord, /*optional*/::mlir::UnitAttr needs64BitIdx, /*optional*/::mlir::UnitAttr canReadOffEnd = nullptr);
  static GlobalLoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value valid, ::mlir::ValueRange sourceCoord, /*optional*/::mlir::UnitAttr needs64BitIdx, /*optional*/::mlir::UnitAttr canReadOffEnd = nullptr);
  static GlobalLoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value valid, ::mlir::ValueRange sourceCoord, /*optional*/::mlir::UnitAttr needs64BitIdx, /*optional*/::mlir::UnitAttr canReadOffEnd = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value source, ::mlir::Value valid, ::mlir::ValueRange sourceCoord, /*optional*/bool needs64BitIdx = false, /*optional*/bool canReadOffEnd = false);
  static GlobalLoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value source, ::mlir::Value valid, ::mlir::ValueRange sourceCoord, /*optional*/bool needs64BitIdx = false, /*optional*/bool canReadOffEnd = false);
  static GlobalLoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value source, ::mlir::Value valid, ::mlir::ValueRange sourceCoord, /*optional*/bool needs64BitIdx = false, /*optional*/bool canReadOffEnd = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value valid, ::mlir::ValueRange sourceCoord, /*optional*/bool needs64BitIdx = false, /*optional*/bool canReadOffEnd = false);
  static GlobalLoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value valid, ::mlir::ValueRange sourceCoord, /*optional*/bool needs64BitIdx = false, /*optional*/bool canReadOffEnd = false);
  static GlobalLoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value valid, ::mlir::ValueRange sourceCoord, /*optional*/bool needs64BitIdx = false, /*optional*/bool canReadOffEnd = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GlobalLoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GlobalLoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GlobalLoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GlobalLoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::GlobalLoadOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::GlobalLoadToLDSOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class GlobalLoadToLDSOpGenericAdaptorBase {
public:
  struct Properties {
    using canReadOffEndTy = ::mlir::UnitAttr;
    canReadOffEndTy canReadOffEnd;

    auto getCanReadOffEnd() const {
      auto &propStorage = this->canReadOffEnd;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setCanReadOffEnd(const ::mlir::UnitAttr &propValue) {
      this->canReadOffEnd = propValue;
    }
    using needs64BitIdxTy = ::mlir::UnitAttr;
    needs64BitIdxTy needs64BitIdx;

    auto getNeeds64BitIdx() const {
      auto &propStorage = this->needs64BitIdx;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setNeeds64BitIdx(const ::mlir::UnitAttr &propValue) {
      this->needs64BitIdx = propValue;
    }
    using transferTypeTy = ::mlir::TypeAttr;
    transferTypeTy transferType;

    auto getTransferType() const {
      auto &propStorage = this->transferType;
      return ::llvm::cast<::mlir::TypeAttr>(propStorage);
    }
    void setTransferType(const ::mlir::TypeAttr &propValue) {
      this->transferType = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 5>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.canReadOffEnd == this->canReadOffEnd &&
        rhs.needs64BitIdx == this->needs64BitIdx &&
        rhs.transferType == this->transferType &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  GlobalLoadToLDSOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.global_load_to_lds", odsAttrs.getContext());
  }

  GlobalLoadToLDSOpGenericAdaptorBase(GlobalLoadToLDSOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::TypeAttr getTransferTypeAttr() {
    auto attr = ::llvm::cast<::mlir::TypeAttr>(getProperties().transferType);
    return attr;
  }

  ::mlir::Type getTransferType();
  ::mlir::UnitAttr getNeeds64BitIdxAttr();
  bool getNeeds64BitIdx();
  ::mlir::UnitAttr getCanReadOffEndAttr();
  bool getCanReadOffEnd();
};
} // namespace detail
template <typename RangeT>
class GlobalLoadToLDSOpGenericAdaptor : public detail::GlobalLoadToLDSOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::GlobalLoadToLDSOpGenericAdaptorBase;
  static constexpr int odsIndex_source = 0;
  static constexpr int odsIndex_dest = 1;
  static constexpr int odsIndex_valid = 2;
  static constexpr int odsIndex_sourceCoord = 3;
  static constexpr int odsIndex_destCoord = 4;
public:
  GlobalLoadToLDSOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  GlobalLoadToLDSOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : GlobalLoadToLDSOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  GlobalLoadToLDSOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : GlobalLoadToLDSOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  GlobalLoadToLDSOpGenericAdaptor(RangeT values, const GlobalLoadToLDSOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = GlobalLoadToLDSOp, typename = std::enable_if_t<std::is_same_v<LateInst, GlobalLoadToLDSOp>>>
  GlobalLoadToLDSOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSource() {
    return (*getODSOperands(0).begin());
  }

  ValueT getDest() {
    return (*getODSOperands(1).begin());
  }

  ValueT getValid() {
    return (*getODSOperands(2).begin());
  }

  RangeT getSourceCoord() {
    return getODSOperands(3);
  }

  RangeT getDestCoord() {
    return getODSOperands(4);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class GlobalLoadToLDSOpAdaptor : public GlobalLoadToLDSOpGenericAdaptor<::mlir::ValueRange> {
public:
  using GlobalLoadToLDSOpGenericAdaptor::GlobalLoadToLDSOpGenericAdaptor;
  GlobalLoadToLDSOpAdaptor(GlobalLoadToLDSOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class GlobalLoadToLDSOp : public ::mlir::Op<GlobalLoadToLDSOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<3>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = GlobalLoadToLDSOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = GlobalLoadToLDSOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_source = 0;
  static constexpr int odsIndex_dest = 1;
  static constexpr int odsIndex_valid = 2;
  static constexpr int odsIndex_sourceCoord = 3;
  static constexpr int odsIndex_destCoord = 4;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("canReadOffEnd"), ::llvm::StringRef("needs64BitIdx"), ::llvm::StringRef("transferType"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getCanReadOffEndAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getCanReadOffEndAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getNeeds64BitIdxAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getNeeds64BitIdxAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getTransferTypeAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getTransferTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.global_load_to_lds");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::MemRefType> getSource() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getDest() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getValid() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(2).begin());
  }

  ::mlir::Operation::operand_range getSourceCoord() {
    return getODSOperands(3);
  }

  ::mlir::Operation::operand_range getDestCoord() {
    return getODSOperands(4);
  }

  ::mlir::OpOperand &getSourceMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getDestMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getValidMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getSourceCoordMutable();
  ::mlir::MutableOperandRange getDestCoordMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::TypeAttr getTransferTypeAttr() {
    return ::llvm::cast<::mlir::TypeAttr>(getProperties().transferType);
  }

  ::mlir::Type getTransferType();
  ::mlir::UnitAttr getNeeds64BitIdxAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().needs64BitIdx);
  }

  bool getNeeds64BitIdx();
  ::mlir::UnitAttr getCanReadOffEndAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().canReadOffEnd);
  }

  bool getCanReadOffEnd();
  void setTransferTypeAttr(::mlir::TypeAttr attr) {
    getProperties().transferType = attr;
  }

  void setTransferType(::mlir::Type attrValue);
  void setNeeds64BitIdxAttr(::mlir::UnitAttr attr) {
    getProperties().needs64BitIdx = attr;
  }

  void setNeeds64BitIdx(bool attrValue);
  void setCanReadOffEndAttr(::mlir::UnitAttr attr) {
    getProperties().canReadOffEnd = attr;
  }

  void setCanReadOffEnd(bool attrValue);
  ::mlir::Attribute removeNeeds64BitIdxAttr() {
      auto attr = getProperties().needs64BitIdx;
      getProperties().needs64BitIdx = {};
      return attr;
  }

  ::mlir::Attribute removeCanReadOffEndAttr() {
      auto attr = getProperties().canReadOffEnd;
      getProperties().canReadOffEnd = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value source, ::mlir::Value dest, ::mlir::Value valid, ::mlir::TypeAttr transferType, ::mlir::ValueRange sourceCoord, ::mlir::ValueRange destCoord, /*optional*/::mlir::UnitAttr needs64BitIdx = nullptr, /*optional*/::mlir::UnitAttr canReadOffEnd = nullptr);
  static GlobalLoadToLDSOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value source, ::mlir::Value dest, ::mlir::Value valid, ::mlir::TypeAttr transferType, ::mlir::ValueRange sourceCoord, ::mlir::ValueRange destCoord, /*optional*/::mlir::UnitAttr needs64BitIdx = nullptr, /*optional*/::mlir::UnitAttr canReadOffEnd = nullptr);
  static GlobalLoadToLDSOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value source, ::mlir::Value dest, ::mlir::Value valid, ::mlir::TypeAttr transferType, ::mlir::ValueRange sourceCoord, ::mlir::ValueRange destCoord, /*optional*/::mlir::UnitAttr needs64BitIdx = nullptr, /*optional*/::mlir::UnitAttr canReadOffEnd = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value dest, ::mlir::Value valid, ::mlir::TypeAttr transferType, ::mlir::ValueRange sourceCoord, ::mlir::ValueRange destCoord, /*optional*/::mlir::UnitAttr needs64BitIdx = nullptr, /*optional*/::mlir::UnitAttr canReadOffEnd = nullptr);
  static GlobalLoadToLDSOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value dest, ::mlir::Value valid, ::mlir::TypeAttr transferType, ::mlir::ValueRange sourceCoord, ::mlir::ValueRange destCoord, /*optional*/::mlir::UnitAttr needs64BitIdx = nullptr, /*optional*/::mlir::UnitAttr canReadOffEnd = nullptr);
  static GlobalLoadToLDSOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value dest, ::mlir::Value valid, ::mlir::TypeAttr transferType, ::mlir::ValueRange sourceCoord, ::mlir::ValueRange destCoord, /*optional*/::mlir::UnitAttr needs64BitIdx = nullptr, /*optional*/::mlir::UnitAttr canReadOffEnd = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value source, ::mlir::Value dest, ::mlir::Value valid, ::mlir::Type transferType, ::mlir::ValueRange sourceCoord, ::mlir::ValueRange destCoord, /*optional*/bool needs64BitIdx = false, /*optional*/bool canReadOffEnd = false);
  static GlobalLoadToLDSOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value source, ::mlir::Value dest, ::mlir::Value valid, ::mlir::Type transferType, ::mlir::ValueRange sourceCoord, ::mlir::ValueRange destCoord, /*optional*/bool needs64BitIdx = false, /*optional*/bool canReadOffEnd = false);
  static GlobalLoadToLDSOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value source, ::mlir::Value dest, ::mlir::Value valid, ::mlir::Type transferType, ::mlir::ValueRange sourceCoord, ::mlir::ValueRange destCoord, /*optional*/bool needs64BitIdx = false, /*optional*/bool canReadOffEnd = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value dest, ::mlir::Value valid, ::mlir::Type transferType, ::mlir::ValueRange sourceCoord, ::mlir::ValueRange destCoord, /*optional*/bool needs64BitIdx = false, /*optional*/bool canReadOffEnd = false);
  static GlobalLoadToLDSOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value dest, ::mlir::Value valid, ::mlir::Type transferType, ::mlir::ValueRange sourceCoord, ::mlir::ValueRange destCoord, /*optional*/bool needs64BitIdx = false, /*optional*/bool canReadOffEnd = false);
  static GlobalLoadToLDSOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value dest, ::mlir::Value valid, ::mlir::Type transferType, ::mlir::ValueRange sourceCoord, ::mlir::ValueRange destCoord, /*optional*/bool needs64BitIdx = false, /*optional*/bool canReadOffEnd = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GlobalLoadToLDSOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GlobalLoadToLDSOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GlobalLoadToLDSOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GlobalLoadToLDSOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::GlobalLoadToLDSOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::GlobalStoreOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class GlobalStoreOpGenericAdaptorBase {
public:
  struct Properties {
    using canStoreOffEndTy = ::mlir::UnitAttr;
    canStoreOffEndTy canStoreOffEnd;

    auto getCanStoreOffEnd() const {
      auto &propStorage = this->canStoreOffEnd;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setCanStoreOffEnd(const ::mlir::UnitAttr &propValue) {
      this->canStoreOffEnd = propValue;
    }
    using lengthTy = ::mlir::IntegerAttr;
    lengthTy length;

    auto getLength() const {
      auto &propStorage = this->length;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setLength(const ::mlir::IntegerAttr &propValue) {
      this->length = propValue;
    }
    using needs64BitIdxTy = ::mlir::UnitAttr;
    needs64BitIdxTy needs64BitIdx;

    auto getNeeds64BitIdx() const {
      auto &propStorage = this->needs64BitIdx;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setNeeds64BitIdx(const ::mlir::UnitAttr &propValue) {
      this->needs64BitIdx = propValue;
    }
    using nontemporalTy = ::mlir::BoolAttr;
    nontemporalTy nontemporal;

    auto getNontemporal() const {
      auto &propStorage = this->nontemporal;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setNontemporal(const ::mlir::BoolAttr &propValue) {
      this->nontemporal = propValue;
    }
    using storeMethodTy = ::mlir::rock::StoreMethodAttr;
    storeMethodTy storeMethod;

    auto getStoreMethod() const {
      auto &propStorage = this->storeMethod;
      return ::llvm::cast<::mlir::rock::StoreMethodAttr>(propStorage);
    }
    void setStoreMethod(const ::mlir::rock::StoreMethodAttr &propValue) {
      this->storeMethod = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.canStoreOffEnd == this->canStoreOffEnd &&
        rhs.length == this->length &&
        rhs.needs64BitIdx == this->needs64BitIdx &&
        rhs.nontemporal == this->nontemporal &&
        rhs.storeMethod == this->storeMethod &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  GlobalStoreOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.global_store", odsAttrs.getContext());
  }

  GlobalStoreOpGenericAdaptorBase(GlobalStoreOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::IntegerAttr getLengthAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().length);
    return attr;
  }

  ::llvm::APInt getLength();
  ::mlir::rock::StoreMethodAttr getStoreMethodAttr() {
    auto attr = ::llvm::cast<::mlir::rock::StoreMethodAttr>(getProperties().storeMethod);
    return attr;
  }

  ::mlir::rock::StoreMethod getStoreMethod();
  ::mlir::UnitAttr getNeeds64BitIdxAttr();
  bool getNeeds64BitIdx();
  ::mlir::UnitAttr getCanStoreOffEndAttr();
  bool getCanStoreOffEnd();
  ::mlir::BoolAttr getNontemporalAttr();
  bool getNontemporal();
};
} // namespace detail
template <typename RangeT>
class GlobalStoreOpGenericAdaptor : public detail::GlobalStoreOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::GlobalStoreOpGenericAdaptorBase;
  static constexpr int odsIndex_source = 0;
  static constexpr int odsIndex_dest = 1;
  static constexpr int odsIndex_sourceCoord = 2;
  static constexpr int odsIndex_valid = 3;
  static constexpr int odsIndex_destCoord = 4;
public:
  GlobalStoreOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  GlobalStoreOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : GlobalStoreOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  GlobalStoreOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : GlobalStoreOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  GlobalStoreOpGenericAdaptor(RangeT values, const GlobalStoreOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = GlobalStoreOp, typename = std::enable_if_t<std::is_same_v<LateInst, GlobalStoreOp>>>
  GlobalStoreOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSource() {
    return (*getODSOperands(0).begin());
  }

  ValueT getDest() {
    return (*getODSOperands(1).begin());
  }

  ValueT getSourceCoord() {
    return (*getODSOperands(2).begin());
  }

  ValueT getValid() {
    return (*getODSOperands(3).begin());
  }

  RangeT getDestCoord() {
    return getODSOperands(4);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class GlobalStoreOpAdaptor : public GlobalStoreOpGenericAdaptor<::mlir::ValueRange> {
public:
  using GlobalStoreOpGenericAdaptor::GlobalStoreOpGenericAdaptor;
  GlobalStoreOpAdaptor(GlobalStoreOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class GlobalStoreOp : public ::mlir::Op<GlobalStoreOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<4>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = GlobalStoreOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = GlobalStoreOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_source = 0;
  static constexpr int odsIndex_dest = 1;
  static constexpr int odsIndex_sourceCoord = 2;
  static constexpr int odsIndex_valid = 3;
  static constexpr int odsIndex_destCoord = 4;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("canStoreOffEnd"), ::llvm::StringRef("length"), ::llvm::StringRef("needs64BitIdx"), ::llvm::StringRef("nontemporal"), ::llvm::StringRef("storeMethod")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getCanStoreOffEndAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getCanStoreOffEndAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getLengthAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getLengthAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getNeeds64BitIdxAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getNeeds64BitIdxAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getNontemporalAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getNontemporalAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getStoreMethodAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getStoreMethodAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.global_store");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::MemRefType> getSource() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getDest() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IndexType> getSourceCoord() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IndexType>>(*getODSOperands(2).begin());
  }

  ::mlir::TypedValue<::mlir::IntegerType> getValid() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IntegerType>>(*getODSOperands(3).begin());
  }

  ::mlir::Operation::operand_range getDestCoord() {
    return getODSOperands(4);
  }

  ::mlir::OpOperand &getSourceMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getDestMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getSourceCoordMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getValidMutable() {
    auto range = getODSOperandIndexAndLength(3);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getDestCoordMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::IntegerAttr getLengthAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().length);
  }

  ::llvm::APInt getLength();
  ::mlir::rock::StoreMethodAttr getStoreMethodAttr() {
    return ::llvm::cast<::mlir::rock::StoreMethodAttr>(getProperties().storeMethod);
  }

  ::mlir::rock::StoreMethod getStoreMethod();
  ::mlir::UnitAttr getNeeds64BitIdxAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().needs64BitIdx);
  }

  bool getNeeds64BitIdx();
  ::mlir::UnitAttr getCanStoreOffEndAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().canStoreOffEnd);
  }

  bool getCanStoreOffEnd();
  ::mlir::BoolAttr getNontemporalAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().nontemporal);
  }

  bool getNontemporal();
  void setLengthAttr(::mlir::IntegerAttr attr) {
    getProperties().length = attr;
  }

  void setLength(::llvm::APInt attrValue);
  void setStoreMethodAttr(::mlir::rock::StoreMethodAttr attr) {
    getProperties().storeMethod = attr;
  }

  void setStoreMethod(::mlir::rock::StoreMethod attrValue);
  void setNeeds64BitIdxAttr(::mlir::UnitAttr attr) {
    getProperties().needs64BitIdx = attr;
  }

  void setNeeds64BitIdx(bool attrValue);
  void setCanStoreOffEndAttr(::mlir::UnitAttr attr) {
    getProperties().canStoreOffEnd = attr;
  }

  void setCanStoreOffEnd(bool attrValue);
  void setNontemporalAttr(::mlir::BoolAttr attr) {
    getProperties().nontemporal = attr;
  }

  void setNontemporal(::std::optional<bool> attrValue);
  ::mlir::Attribute removeNeeds64BitIdxAttr() {
      auto attr = getProperties().needs64BitIdx;
      getProperties().needs64BitIdx = {};
      return attr;
  }

  ::mlir::Attribute removeCanStoreOffEndAttr() {
      auto attr = getProperties().canStoreOffEnd;
      getProperties().canStoreOffEnd = {};
      return attr;
  }

  ::mlir::Attribute removeNontemporalAttr() {
      auto attr = getProperties().nontemporal;
      getProperties().nontemporal = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value source, ::mlir::Value dest, ::mlir::IntegerAttr length, ::mlir::rock::StoreMethodAttr storeMethod, ::mlir::Value sourceCoord, ::mlir::Value valid, ::mlir::ValueRange destCoord, /*optional*/::mlir::UnitAttr needs64BitIdx = nullptr, /*optional*/::mlir::UnitAttr canStoreOffEnd = nullptr, /*optional*/::mlir::BoolAttr nontemporal = nullptr);
  static GlobalStoreOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value source, ::mlir::Value dest, ::mlir::IntegerAttr length, ::mlir::rock::StoreMethodAttr storeMethod, ::mlir::Value sourceCoord, ::mlir::Value valid, ::mlir::ValueRange destCoord, /*optional*/::mlir::UnitAttr needs64BitIdx = nullptr, /*optional*/::mlir::UnitAttr canStoreOffEnd = nullptr, /*optional*/::mlir::BoolAttr nontemporal = nullptr);
  static GlobalStoreOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value source, ::mlir::Value dest, ::mlir::IntegerAttr length, ::mlir::rock::StoreMethodAttr storeMethod, ::mlir::Value sourceCoord, ::mlir::Value valid, ::mlir::ValueRange destCoord, /*optional*/::mlir::UnitAttr needs64BitIdx = nullptr, /*optional*/::mlir::UnitAttr canStoreOffEnd = nullptr, /*optional*/::mlir::BoolAttr nontemporal = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value dest, ::mlir::IntegerAttr length, ::mlir::rock::StoreMethodAttr storeMethod, ::mlir::Value sourceCoord, ::mlir::Value valid, ::mlir::ValueRange destCoord, /*optional*/::mlir::UnitAttr needs64BitIdx = nullptr, /*optional*/::mlir::UnitAttr canStoreOffEnd = nullptr, /*optional*/::mlir::BoolAttr nontemporal = nullptr);
  static GlobalStoreOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value dest, ::mlir::IntegerAttr length, ::mlir::rock::StoreMethodAttr storeMethod, ::mlir::Value sourceCoord, ::mlir::Value valid, ::mlir::ValueRange destCoord, /*optional*/::mlir::UnitAttr needs64BitIdx = nullptr, /*optional*/::mlir::UnitAttr canStoreOffEnd = nullptr, /*optional*/::mlir::BoolAttr nontemporal = nullptr);
  static GlobalStoreOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value dest, ::mlir::IntegerAttr length, ::mlir::rock::StoreMethodAttr storeMethod, ::mlir::Value sourceCoord, ::mlir::Value valid, ::mlir::ValueRange destCoord, /*optional*/::mlir::UnitAttr needs64BitIdx = nullptr, /*optional*/::mlir::UnitAttr canStoreOffEnd = nullptr, /*optional*/::mlir::BoolAttr nontemporal = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value source, ::mlir::Value dest, ::llvm::APInt length, ::mlir::rock::StoreMethod storeMethod, ::mlir::Value sourceCoord, ::mlir::Value valid, ::mlir::ValueRange destCoord, /*optional*/bool needs64BitIdx = false, /*optional*/bool canStoreOffEnd = false, /*optional*/bool nontemporal = false);
  static GlobalStoreOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value source, ::mlir::Value dest, ::llvm::APInt length, ::mlir::rock::StoreMethod storeMethod, ::mlir::Value sourceCoord, ::mlir::Value valid, ::mlir::ValueRange destCoord, /*optional*/bool needs64BitIdx = false, /*optional*/bool canStoreOffEnd = false, /*optional*/bool nontemporal = false);
  static GlobalStoreOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value source, ::mlir::Value dest, ::llvm::APInt length, ::mlir::rock::StoreMethod storeMethod, ::mlir::Value sourceCoord, ::mlir::Value valid, ::mlir::ValueRange destCoord, /*optional*/bool needs64BitIdx = false, /*optional*/bool canStoreOffEnd = false, /*optional*/bool nontemporal = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value dest, ::llvm::APInt length, ::mlir::rock::StoreMethod storeMethod, ::mlir::Value sourceCoord, ::mlir::Value valid, ::mlir::ValueRange destCoord, /*optional*/bool needs64BitIdx = false, /*optional*/bool canStoreOffEnd = false, /*optional*/bool nontemporal = false);
  static GlobalStoreOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value dest, ::llvm::APInt length, ::mlir::rock::StoreMethod storeMethod, ::mlir::Value sourceCoord, ::mlir::Value valid, ::mlir::ValueRange destCoord, /*optional*/bool needs64BitIdx = false, /*optional*/bool canStoreOffEnd = false, /*optional*/bool nontemporal = false);
  static GlobalStoreOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value dest, ::llvm::APInt length, ::mlir::rock::StoreMethod storeMethod, ::mlir::Value sourceCoord, ::mlir::Value valid, ::mlir::ValueRange destCoord, /*optional*/bool needs64BitIdx = false, /*optional*/bool canStoreOffEnd = false, /*optional*/bool nontemporal = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GlobalStoreOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GlobalStoreOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GlobalStoreOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GlobalStoreOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 5 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::GlobalStoreOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::GpuAllocOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class GpuAllocOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  GpuAllocOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.alloc", odsAttrs.getContext());
  }

  GpuAllocOpGenericAdaptorBase(GpuAllocOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class GpuAllocOpGenericAdaptor : public detail::GpuAllocOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::GpuAllocOpGenericAdaptorBase;
public:
  GpuAllocOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  GpuAllocOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : GpuAllocOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  GpuAllocOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : GpuAllocOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  GpuAllocOpGenericAdaptor(RangeT values, const GpuAllocOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = GpuAllocOp, typename = std::enable_if_t<std::is_same_v<LateInst, GpuAllocOp>>>
  GpuAllocOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class GpuAllocOpAdaptor : public GpuAllocOpGenericAdaptor<::mlir::ValueRange> {
public:
  using GpuAllocOpGenericAdaptor::GpuAllocOpGenericAdaptor;
  GpuAllocOpAdaptor(GpuAllocOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class GpuAllocOp : public ::mlir::Op<GpuAllocOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::MemRefType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = GpuAllocOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = GpuAllocOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.alloc");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::MemRefType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output);
  static GpuAllocOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type output);
  static GpuAllocOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type output);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static GpuAllocOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static GpuAllocOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GpuAllocOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GpuAllocOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GpuAllocOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GpuAllocOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::GpuAllocOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::GpuDeallocOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class GpuDeallocOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  GpuDeallocOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.dealloc", odsAttrs.getContext());
  }

  GpuDeallocOpGenericAdaptorBase(GpuDeallocOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class GpuDeallocOpGenericAdaptor : public detail::GpuDeallocOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::GpuDeallocOpGenericAdaptorBase;
  static constexpr int odsIndex_memref = 0;
public:
  GpuDeallocOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  GpuDeallocOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : GpuDeallocOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  GpuDeallocOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : GpuDeallocOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  GpuDeallocOpGenericAdaptor(RangeT values, const GpuDeallocOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = GpuDeallocOp, typename = std::enable_if_t<std::is_same_v<LateInst, GpuDeallocOp>>>
  GpuDeallocOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getMemref() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class GpuDeallocOpAdaptor : public GpuDeallocOpGenericAdaptor<::mlir::ValueRange> {
public:
  using GpuDeallocOpGenericAdaptor::GpuDeallocOpGenericAdaptor;
  GpuDeallocOpAdaptor(GpuDeallocOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class GpuDeallocOp : public ::mlir::Op<GpuDeallocOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = GpuDeallocOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = GpuDeallocOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_memref = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.dealloc");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::MemRefType> getMemref() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getMemrefMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value memref);
  static GpuDeallocOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value memref);
  static GpuDeallocOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value memref);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value memref);
  static GpuDeallocOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value memref);
  static GpuDeallocOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value memref);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GpuDeallocOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GpuDeallocOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GpuDeallocOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GpuDeallocOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::GpuDeallocOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::GridwiseAttentionAccelOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class GridwiseAttentionAccelOpGenericAdaptorBase {
public:
  struct Properties {
    using blockSizeTy = ::mlir::IntegerAttr;
    blockSizeTy blockSize;

    auto getBlockSize() const {
      auto &propStorage = this->blockSize;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setBlockSize(const ::mlir::IntegerAttr &propValue) {
      this->blockSize = propValue;
    }
    using causalTy = ::mlir::UnitAttr;
    causalTy causal;

    auto getCausal() const {
      auto &propStorage = this->causal;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setCausal(const ::mlir::UnitAttr &propValue) {
      this->causal = propValue;
    }
    using disableQBypassLDSTy = ::mlir::UnitAttr;
    disableQBypassLDSTy disableQBypassLDS;

    auto getDisableQBypassLDS() const {
      auto &propStorage = this->disableQBypassLDS;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setDisableQBypassLDS(const ::mlir::UnitAttr &propValue) {
      this->disableQBypassLDS = propValue;
    }
    using enableSoftmaxTy = ::mlir::BoolAttr;
    enableSoftmaxTy enableSoftmax;

    auto getEnableSoftmax() const {
      auto &propStorage = this->enableSoftmax;
      return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(propStorage);
    }
    void setEnableSoftmax(const ::mlir::BoolAttr &propValue) {
      this->enableSoftmax = propValue;
    }
    using featuresTy = ::mlir::rock::GemmFeaturesAttr;
    featuresTy features;

    auto getFeatures() const {
      auto &propStorage = this->features;
      return ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(propStorage);
    }
    void setFeatures(const ::mlir::rock::GemmFeaturesAttr &propValue) {
      this->features = propValue;
    }
    using firstGemmIndicesTy = ::mlir::DenseI64ArrayAttr;
    firstGemmIndicesTy firstGemmIndices;

    auto getFirstGemmIndices() const {
      auto &propStorage = this->firstGemmIndices;
      return ::llvm::cast<::mlir::DenseI64ArrayAttr>(propStorage);
    }
    void setFirstGemmIndices(const ::mlir::DenseI64ArrayAttr &propValue) {
      this->firstGemmIndices = propValue;
    }
    using gridSizeTy = ::mlir::IntegerAttr;
    gridSizeTy gridSize;

    auto getGridSize() const {
      auto &propStorage = this->gridSize;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setGridSize(const ::mlir::IntegerAttr &propValue) {
      this->gridSize = propValue;
    }
    using numRepeatsGQATy = ::mlir::IntegerAttr;
    numRepeatsGQATy numRepeatsGQA;

    auto getNumRepeatsGQA() const {
      auto &propStorage = this->numRepeatsGQA;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setNumRepeatsGQA(const ::mlir::IntegerAttr &propValue) {
      this->numRepeatsGQA = propValue;
    }
    using params0Ty = ::mlir::rock::RockAccelTuningParamAttrInterface;
    params0Ty params0;

    auto getParams0() const {
      auto &propStorage = this->params0;
      return ::llvm::cast<::mlir::rock::RockAccelTuningParamAttrInterface>(propStorage);
    }
    void setParams0(const ::mlir::rock::RockAccelTuningParamAttrInterface &propValue) {
      this->params0 = propValue;
    }
    using params1Ty = ::mlir::rock::RockAccelTuningParamAttrInterface;
    params1Ty params1;

    auto getParams1() const {
      auto &propStorage = this->params1;
      return ::llvm::cast<::mlir::rock::RockAccelTuningParamAttrInterface>(propStorage);
    }
    void setParams1(const ::mlir::rock::RockAccelTuningParamAttrInterface &propValue) {
      this->params1 = propValue;
    }
    using prePadG0MTy = ::mlir::IntegerAttr;
    prePadG0MTy prePadG0M;

    auto getPrePadG0M() const {
      auto &propStorage = this->prePadG0M;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setPrePadG0M(const ::mlir::IntegerAttr &propValue) {
      this->prePadG0M = propValue;
    }
    using prePadG0NTy = ::mlir::IntegerAttr;
    prePadG0NTy prePadG0N;

    auto getPrePadG0N() const {
      auto &propStorage = this->prePadG0N;
      return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(propStorage);
    }
    void setPrePadG0N(const ::mlir::IntegerAttr &propValue) {
      this->prePadG0N = propValue;
    }
    using softmaxTypeTy = ::mlir::TypeAttr;
    softmaxTypeTy softmaxType;

    auto getSoftmaxType() const {
      auto &propStorage = this->softmaxType;
      return ::llvm::dyn_cast_or_null<::mlir::TypeAttr>(propStorage);
    }
    void setSoftmaxType(const ::mlir::TypeAttr &propValue) {
      this->softmaxType = propValue;
    }
    using splitKVTy = ::mlir::IntegerAttr;
    splitKVTy splitKV;

    auto getSplitKV() const {
      auto &propStorage = this->splitKV;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setSplitKV(const ::mlir::IntegerAttr &propValue) {
      this->splitKV = propValue;
    }
    using storeMethodTy = ::mlir::rock::StoreMethodAttr;
    storeMethodTy storeMethod;

    auto getStoreMethod() const {
      auto &propStorage = this->storeMethod;
      return ::llvm::cast<::mlir::rock::StoreMethodAttr>(propStorage);
    }
    void setStoreMethod(const ::mlir::rock::StoreMethodAttr &propValue) {
      this->storeMethod = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 7>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.blockSize == this->blockSize &&
        rhs.causal == this->causal &&
        rhs.disableQBypassLDS == this->disableQBypassLDS &&
        rhs.enableSoftmax == this->enableSoftmax &&
        rhs.features == this->features &&
        rhs.firstGemmIndices == this->firstGemmIndices &&
        rhs.gridSize == this->gridSize &&
        rhs.numRepeatsGQA == this->numRepeatsGQA &&
        rhs.params0 == this->params0 &&
        rhs.params1 == this->params1 &&
        rhs.prePadG0M == this->prePadG0M &&
        rhs.prePadG0N == this->prePadG0N &&
        rhs.softmaxType == this->softmaxType &&
        rhs.splitKV == this->splitKV &&
        rhs.storeMethod == this->storeMethod &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  GridwiseAttentionAccelOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.gridwise_attention_accel", odsAttrs.getContext());
  }

  GridwiseAttentionAccelOpGenericAdaptorBase(GridwiseAttentionAccelOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::UnitAttr getCausalAttr();
  bool getCausal();
  ::mlir::IntegerAttr getSplitKVAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().splitKV);
    return attr;
  }

  uint32_t getSplitKV();
  ::mlir::rock::GemmFeaturesAttr getFeaturesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(getProperties().features);
    return attr;
  }

  ::std::optional<::mlir::rock::GemmFeatures> getFeatures();
  ::mlir::rock::StoreMethodAttr getStoreMethodAttr() {
    auto attr = ::llvm::cast<::mlir::rock::StoreMethodAttr>(getProperties().storeMethod);
    return attr;
  }

  ::mlir::rock::StoreMethod getStoreMethod();
  ::mlir::IntegerAttr getBlockSizeAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().blockSize);
    return attr;
  }

  uint32_t getBlockSize();
  ::mlir::IntegerAttr getGridSizeAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().gridSize);
    return attr;
  }

  uint32_t getGridSize();
  ::mlir::UnitAttr getDisableQBypassLDSAttr();
  bool getDisableQBypassLDS();
  ::mlir::IntegerAttr getPrePadG0MAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().prePadG0M);
    return attr;
  }

  ::std::optional< ::llvm::APInt > getPrePadG0M();
  ::mlir::IntegerAttr getPrePadG0NAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().prePadG0N);
    return attr;
  }

  ::std::optional< ::llvm::APInt > getPrePadG0N();
  ::mlir::IntegerAttr getNumRepeatsGQAAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().numRepeatsGQA);
    return attr;
  }

  ::std::optional< ::llvm::APInt > getNumRepeatsGQA();
  ::mlir::TypeAttr getSoftmaxTypeAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::TypeAttr>(getProperties().softmaxType);
    return attr;
  }

  ::std::optional<::mlir::Type> getSoftmaxType();
  ::mlir::rock::RockAccelTuningParamAttrInterface getParams0Attr() {
    auto attr = ::llvm::cast<::mlir::rock::RockAccelTuningParamAttrInterface>(getProperties().params0);
    return attr;
  }

  ::mlir::rock::RockAccelTuningParamAttrInterface getParams0();
  ::mlir::rock::RockAccelTuningParamAttrInterface getParams1Attr() {
    auto attr = ::llvm::cast<::mlir::rock::RockAccelTuningParamAttrInterface>(getProperties().params1);
    return attr;
  }

  ::mlir::rock::RockAccelTuningParamAttrInterface getParams1();
  ::mlir::DenseI64ArrayAttr getFirstGemmIndicesAttr() {
    auto attr = ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().firstGemmIndices);
    return attr;
  }

  ::llvm::ArrayRef<int64_t> getFirstGemmIndices();
  ::mlir::BoolAttr getEnableSoftmaxAttr();
  bool getEnableSoftmax();
  ::mlir::Region &getPreSoftmaxBody() {
    return *odsRegions[0];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};
} // namespace detail
template <typename RangeT>
class GridwiseAttentionAccelOpGenericAdaptor : public detail::GridwiseAttentionAccelOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::GridwiseAttentionAccelOpGenericAdaptorBase;
  static constexpr int odsIndex_queries = 0;
  static constexpr int odsIndex_keys = 1;
  static constexpr int odsIndex_values = 2;
  static constexpr int odsIndex_preSoftmaxElemWiseInputs = 3;
  static constexpr int odsIndex_currentSeqLen = 4;
  static constexpr int odsIndex_out = 5;
  static constexpr int odsIndex_lse = 6;
public:
  GridwiseAttentionAccelOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  GridwiseAttentionAccelOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : GridwiseAttentionAccelOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  GridwiseAttentionAccelOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : GridwiseAttentionAccelOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  GridwiseAttentionAccelOpGenericAdaptor(RangeT values, const GridwiseAttentionAccelOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = GridwiseAttentionAccelOp, typename = std::enable_if_t<std::is_same_v<LateInst, GridwiseAttentionAccelOp>>>
  GridwiseAttentionAccelOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getQueries() {
    return (*getODSOperands(0).begin());
  }

  ValueT getKeys() {
    return (*getODSOperands(1).begin());
  }

  ValueT getValues() {
    return (*getODSOperands(2).begin());
  }

  RangeT getPreSoftmaxElemWiseInputs() {
    return getODSOperands(3);
  }

  ValueT getCurrentSeqLen() {
    auto operands = getODSOperands(4);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  ValueT getOut() {
    return (*getODSOperands(5).begin());
  }

  ValueT getLse() {
    auto operands = getODSOperands(6);
    return operands.empty() ? ValueT{} : (*operands.begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class GridwiseAttentionAccelOpAdaptor : public GridwiseAttentionAccelOpGenericAdaptor<::mlir::ValueRange> {
public:
  using GridwiseAttentionAccelOpGenericAdaptor::GridwiseAttentionAccelOpGenericAdaptor;
  GridwiseAttentionAccelOpAdaptor(GridwiseAttentionAccelOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class GridwiseAttentionAccelOp : public ::mlir::Op<GridwiseAttentionAccelOp, ::mlir::OpTrait::OneRegion, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<4>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::rock::RockGemmFeaturesInterface::Trait, mlir::OpTrait::rock::FusionRoot> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = GridwiseAttentionAccelOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = GridwiseAttentionAccelOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_queries = 0;
  static constexpr int odsIndex_keys = 1;
  static constexpr int odsIndex_values = 2;
  static constexpr int odsIndex_preSoftmaxElemWiseInputs = 3;
  static constexpr int odsIndex_currentSeqLen = 4;
  static constexpr int odsIndex_out = 5;
  static constexpr int odsIndex_lse = 6;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("blockSize"), ::llvm::StringRef("causal"), ::llvm::StringRef("disableQBypassLDS"), ::llvm::StringRef("enableSoftmax"), ::llvm::StringRef("features"), ::llvm::StringRef("firstGemmIndices"), ::llvm::StringRef("gridSize"), ::llvm::StringRef("numRepeatsGQA"), ::llvm::StringRef("params0"), ::llvm::StringRef("params1"), ::llvm::StringRef("prePadG0M"), ::llvm::StringRef("prePadG0N"), ::llvm::StringRef("softmaxType"), ::llvm::StringRef("splitKV"), ::llvm::StringRef("storeMethod"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBlockSizeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBlockSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getCausalAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getCausalAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getDisableQBypassLDSAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getDisableQBypassLDSAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getEnableSoftmaxAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getEnableSoftmaxAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getFeaturesAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getFeaturesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getFirstGemmIndicesAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getFirstGemmIndicesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getGridSizeAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getGridSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getNumRepeatsGQAAttrName() {
    return getAttributeNameForIndex(7);
  }

  static ::mlir::StringAttr getNumRepeatsGQAAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 7);
  }

  ::mlir::StringAttr getParams0AttrName() {
    return getAttributeNameForIndex(8);
  }

  static ::mlir::StringAttr getParams0AttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 8);
  }

  ::mlir::StringAttr getParams1AttrName() {
    return getAttributeNameForIndex(9);
  }

  static ::mlir::StringAttr getParams1AttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 9);
  }

  ::mlir::StringAttr getPrePadG0MAttrName() {
    return getAttributeNameForIndex(10);
  }

  static ::mlir::StringAttr getPrePadG0MAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 10);
  }

  ::mlir::StringAttr getPrePadG0NAttrName() {
    return getAttributeNameForIndex(11);
  }

  static ::mlir::StringAttr getPrePadG0NAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 11);
  }

  ::mlir::StringAttr getSoftmaxTypeAttrName() {
    return getAttributeNameForIndex(12);
  }

  static ::mlir::StringAttr getSoftmaxTypeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 12);
  }

  ::mlir::StringAttr getSplitKVAttrName() {
    return getAttributeNameForIndex(13);
  }

  static ::mlir::StringAttr getSplitKVAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 13);
  }

  ::mlir::StringAttr getStoreMethodAttrName() {
    return getAttributeNameForIndex(14);
  }

  static ::mlir::StringAttr getStoreMethodAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 14);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.gridwise_attention_accel");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::MemRefType> getQueries() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getKeys() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getValues() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(2).begin());
  }

  ::mlir::Operation::operand_range getPreSoftmaxElemWiseInputs() {
    return getODSOperands(3);
  }

  ::mlir::TypedValue<::mlir::MemRefType> getCurrentSeqLen() {
    auto operands = getODSOperands(4);
    return operands.empty() ? ::mlir::TypedValue<::mlir::MemRefType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*operands.begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getOut() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(5).begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getLse() {
    auto operands = getODSOperands(6);
    return operands.empty() ? ::mlir::TypedValue<::mlir::MemRefType>{} : ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*operands.begin());
  }

  ::mlir::OpOperand &getQueriesMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getKeysMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getValuesMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getPreSoftmaxElemWiseInputsMutable();
  ::mlir::MutableOperandRange getCurrentSeqLenMutable();
  ::mlir::OpOperand &getOutMutable() {
    auto range = getODSOperandIndexAndLength(5);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getLseMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Region &getPreSoftmaxBody() {
    return (*this)->getRegion(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::UnitAttr getCausalAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().causal);
  }

  bool getCausal();
  ::mlir::IntegerAttr getSplitKVAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().splitKV);
  }

  uint32_t getSplitKV();
  ::mlir::rock::GemmFeaturesAttr getFeaturesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(getProperties().features);
  }

  ::std::optional<::mlir::rock::GemmFeatures> getFeatures();
  ::mlir::rock::StoreMethodAttr getStoreMethodAttr() {
    return ::llvm::cast<::mlir::rock::StoreMethodAttr>(getProperties().storeMethod);
  }

  ::mlir::rock::StoreMethod getStoreMethod();
  ::mlir::IntegerAttr getBlockSizeAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().blockSize);
  }

  uint32_t getBlockSize();
  ::mlir::IntegerAttr getGridSizeAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().gridSize);
  }

  uint32_t getGridSize();
  ::mlir::UnitAttr getDisableQBypassLDSAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().disableQBypassLDS);
  }

  bool getDisableQBypassLDS();
  ::mlir::IntegerAttr getPrePadG0MAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().prePadG0M);
  }

  ::std::optional< ::llvm::APInt > getPrePadG0M();
  ::mlir::IntegerAttr getPrePadG0NAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().prePadG0N);
  }

  ::std::optional< ::llvm::APInt > getPrePadG0N();
  ::mlir::IntegerAttr getNumRepeatsGQAAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::IntegerAttr>(getProperties().numRepeatsGQA);
  }

  ::std::optional< ::llvm::APInt > getNumRepeatsGQA();
  ::mlir::TypeAttr getSoftmaxTypeAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::TypeAttr>(getProperties().softmaxType);
  }

  ::std::optional<::mlir::Type> getSoftmaxType();
  ::mlir::rock::RockAccelTuningParamAttrInterface getParams0Attr() {
    return ::llvm::cast<::mlir::rock::RockAccelTuningParamAttrInterface>(getProperties().params0);
  }

  ::mlir::rock::RockAccelTuningParamAttrInterface getParams0();
  ::mlir::rock::RockAccelTuningParamAttrInterface getParams1Attr() {
    return ::llvm::cast<::mlir::rock::RockAccelTuningParamAttrInterface>(getProperties().params1);
  }

  ::mlir::rock::RockAccelTuningParamAttrInterface getParams1();
  ::mlir::DenseI64ArrayAttr getFirstGemmIndicesAttr() {
    return ::llvm::cast<::mlir::DenseI64ArrayAttr>(getProperties().firstGemmIndices);
  }

  ::llvm::ArrayRef<int64_t> getFirstGemmIndices();
  ::mlir::BoolAttr getEnableSoftmaxAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::BoolAttr>(getProperties().enableSoftmax);
  }

  bool getEnableSoftmax();
  void setCausalAttr(::mlir::UnitAttr attr) {
    getProperties().causal = attr;
  }

  void setCausal(bool attrValue);
  void setSplitKVAttr(::mlir::IntegerAttr attr) {
    getProperties().splitKV = attr;
  }

  void setSplitKV(uint32_t attrValue);
  void setFeaturesAttr(::mlir::rock::GemmFeaturesAttr attr) {
    getProperties().features = attr;
  }

  void setFeatures(::std::optional<::mlir::rock::GemmFeatures> attrValue);
  void setStoreMethodAttr(::mlir::rock::StoreMethodAttr attr) {
    getProperties().storeMethod = attr;
  }

  void setStoreMethod(::mlir::rock::StoreMethod attrValue);
  void setBlockSizeAttr(::mlir::IntegerAttr attr) {
    getProperties().blockSize = attr;
  }

  void setBlockSize(uint32_t attrValue);
  void setGridSizeAttr(::mlir::IntegerAttr attr) {
    getProperties().gridSize = attr;
  }

  void setGridSize(uint32_t attrValue);
  void setDisableQBypassLDSAttr(::mlir::UnitAttr attr) {
    getProperties().disableQBypassLDS = attr;
  }

  void setDisableQBypassLDS(bool attrValue);
  void setPrePadG0MAttr(::mlir::IntegerAttr attr) {
    getProperties().prePadG0M = attr;
  }

  void setPrePadG0M(::std::optional<::llvm::APInt> attrValue);
  void setPrePadG0NAttr(::mlir::IntegerAttr attr) {
    getProperties().prePadG0N = attr;
  }

  void setPrePadG0N(::std::optional<::llvm::APInt> attrValue);
  void setNumRepeatsGQAAttr(::mlir::IntegerAttr attr) {
    getProperties().numRepeatsGQA = attr;
  }

  void setNumRepeatsGQA(::std::optional<::llvm::APInt> attrValue);
  void setSoftmaxTypeAttr(::mlir::TypeAttr attr) {
    getProperties().softmaxType = attr;
  }

  void setSoftmaxType(::std::optional<::mlir::Type> attrValue);
  void setParams0Attr(::mlir::rock::RockAccelTuningParamAttrInterface attr) {
    getProperties().params0 = attr;
  }

  void setParams1Attr(::mlir::rock::RockAccelTuningParamAttrInterface attr) {
    getProperties().params1 = attr;
  }

  void setFirstGemmIndicesAttr(::mlir::DenseI64ArrayAttr attr) {
    getProperties().firstGemmIndices = attr;
  }

  void setFirstGemmIndices(::llvm::ArrayRef<int64_t> attrValue);
  void setEnableSoftmaxAttr(::mlir::BoolAttr attr) {
    getProperties().enableSoftmax = attr;
  }

  void setEnableSoftmax(::std::optional<bool> attrValue);
  ::mlir::Attribute removeCausalAttr() {
      auto attr = getProperties().causal;
      getProperties().causal = {};
      return attr;
  }

  ::mlir::Attribute removeFeaturesAttr() {
      auto attr = getProperties().features;
      getProperties().features = {};
      return attr;
  }

  ::mlir::Attribute removeDisableQBypassLDSAttr() {
      auto attr = getProperties().disableQBypassLDS;
      getProperties().disableQBypassLDS = {};
      return attr;
  }

  ::mlir::Attribute removePrePadG0MAttr() {
      auto attr = getProperties().prePadG0M;
      getProperties().prePadG0M = {};
      return attr;
  }

  ::mlir::Attribute removePrePadG0NAttr() {
      auto attr = getProperties().prePadG0N;
      getProperties().prePadG0N = {};
      return attr;
  }

  ::mlir::Attribute removeNumRepeatsGQAAttr() {
      auto attr = getProperties().numRepeatsGQA;
      getProperties().numRepeatsGQA = {};
      return attr;
  }

  ::mlir::Attribute removeSoftmaxTypeAttr() {
      auto attr = getProperties().softmaxType;
      getProperties().softmaxType = {};
      return attr;
  }

  ::mlir::Attribute removeEnableSoftmaxAttr() {
      auto attr = getProperties().enableSoftmax;
      getProperties().enableSoftmax = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value queries, ::mlir::Value keys, ::mlir::Value values, ::mlir::ValueRange preSoftmaxElemWiseInputs, /*optional*/::mlir::Value currentSeqLen, ::mlir::Value out, /*optional*/::mlir::Value lse, /*optional*/::mlir::UnitAttr causal, ::mlir::IntegerAttr splitKV, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, ::mlir::IntegerAttr blockSize, ::mlir::IntegerAttr gridSize, /*optional*/::mlir::UnitAttr disableQBypassLDS, /*optional*/::mlir::IntegerAttr prePadG0M, /*optional*/::mlir::IntegerAttr prePadG0N, /*optional*/::mlir::IntegerAttr numRepeatsGQA, /*optional*/::mlir::TypeAttr softmaxType, ::mlir::rock::RockAccelTuningParamAttrInterface params0, ::mlir::rock::RockAccelTuningParamAttrInterface params1, ::mlir::DenseI64ArrayAttr firstGemmIndices, /*optional*/::mlir::BoolAttr enableSoftmax = nullptr);
  static GridwiseAttentionAccelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value queries, ::mlir::Value keys, ::mlir::Value values, ::mlir::ValueRange preSoftmaxElemWiseInputs, /*optional*/::mlir::Value currentSeqLen, ::mlir::Value out, /*optional*/::mlir::Value lse, /*optional*/::mlir::UnitAttr causal, ::mlir::IntegerAttr splitKV, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, ::mlir::IntegerAttr blockSize, ::mlir::IntegerAttr gridSize, /*optional*/::mlir::UnitAttr disableQBypassLDS, /*optional*/::mlir::IntegerAttr prePadG0M, /*optional*/::mlir::IntegerAttr prePadG0N, /*optional*/::mlir::IntegerAttr numRepeatsGQA, /*optional*/::mlir::TypeAttr softmaxType, ::mlir::rock::RockAccelTuningParamAttrInterface params0, ::mlir::rock::RockAccelTuningParamAttrInterface params1, ::mlir::DenseI64ArrayAttr firstGemmIndices, /*optional*/::mlir::BoolAttr enableSoftmax = nullptr);
  static GridwiseAttentionAccelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value queries, ::mlir::Value keys, ::mlir::Value values, ::mlir::ValueRange preSoftmaxElemWiseInputs, /*optional*/::mlir::Value currentSeqLen, ::mlir::Value out, /*optional*/::mlir::Value lse, /*optional*/::mlir::UnitAttr causal, ::mlir::IntegerAttr splitKV, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, ::mlir::IntegerAttr blockSize, ::mlir::IntegerAttr gridSize, /*optional*/::mlir::UnitAttr disableQBypassLDS, /*optional*/::mlir::IntegerAttr prePadG0M, /*optional*/::mlir::IntegerAttr prePadG0N, /*optional*/::mlir::IntegerAttr numRepeatsGQA, /*optional*/::mlir::TypeAttr softmaxType, ::mlir::rock::RockAccelTuningParamAttrInterface params0, ::mlir::rock::RockAccelTuningParamAttrInterface params1, ::mlir::DenseI64ArrayAttr firstGemmIndices, /*optional*/::mlir::BoolAttr enableSoftmax = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value queries, ::mlir::Value keys, ::mlir::Value values, ::mlir::ValueRange preSoftmaxElemWiseInputs, /*optional*/::mlir::Value currentSeqLen, ::mlir::Value out, /*optional*/::mlir::Value lse, /*optional*/::mlir::UnitAttr causal, ::mlir::IntegerAttr splitKV, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, ::mlir::IntegerAttr blockSize, ::mlir::IntegerAttr gridSize, /*optional*/::mlir::UnitAttr disableQBypassLDS, /*optional*/::mlir::IntegerAttr prePadG0M, /*optional*/::mlir::IntegerAttr prePadG0N, /*optional*/::mlir::IntegerAttr numRepeatsGQA, /*optional*/::mlir::TypeAttr softmaxType, ::mlir::rock::RockAccelTuningParamAttrInterface params0, ::mlir::rock::RockAccelTuningParamAttrInterface params1, ::mlir::DenseI64ArrayAttr firstGemmIndices, /*optional*/::mlir::BoolAttr enableSoftmax = nullptr);
  static GridwiseAttentionAccelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value queries, ::mlir::Value keys, ::mlir::Value values, ::mlir::ValueRange preSoftmaxElemWiseInputs, /*optional*/::mlir::Value currentSeqLen, ::mlir::Value out, /*optional*/::mlir::Value lse, /*optional*/::mlir::UnitAttr causal, ::mlir::IntegerAttr splitKV, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, ::mlir::IntegerAttr blockSize, ::mlir::IntegerAttr gridSize, /*optional*/::mlir::UnitAttr disableQBypassLDS, /*optional*/::mlir::IntegerAttr prePadG0M, /*optional*/::mlir::IntegerAttr prePadG0N, /*optional*/::mlir::IntegerAttr numRepeatsGQA, /*optional*/::mlir::TypeAttr softmaxType, ::mlir::rock::RockAccelTuningParamAttrInterface params0, ::mlir::rock::RockAccelTuningParamAttrInterface params1, ::mlir::DenseI64ArrayAttr firstGemmIndices, /*optional*/::mlir::BoolAttr enableSoftmax = nullptr);
  static GridwiseAttentionAccelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value queries, ::mlir::Value keys, ::mlir::Value values, ::mlir::ValueRange preSoftmaxElemWiseInputs, /*optional*/::mlir::Value currentSeqLen, ::mlir::Value out, /*optional*/::mlir::Value lse, /*optional*/::mlir::UnitAttr causal, ::mlir::IntegerAttr splitKV, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, ::mlir::IntegerAttr blockSize, ::mlir::IntegerAttr gridSize, /*optional*/::mlir::UnitAttr disableQBypassLDS, /*optional*/::mlir::IntegerAttr prePadG0M, /*optional*/::mlir::IntegerAttr prePadG0N, /*optional*/::mlir::IntegerAttr numRepeatsGQA, /*optional*/::mlir::TypeAttr softmaxType, ::mlir::rock::RockAccelTuningParamAttrInterface params0, ::mlir::rock::RockAccelTuningParamAttrInterface params1, ::mlir::DenseI64ArrayAttr firstGemmIndices, /*optional*/::mlir::BoolAttr enableSoftmax = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value queries, ::mlir::Value keys, ::mlir::Value values, ::mlir::ValueRange preSoftmaxElemWiseInputs, /*optional*/::mlir::Value currentSeqLen, ::mlir::Value out, /*optional*/::mlir::Value lse, /*optional*/bool causal, uint32_t splitKV, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, uint32_t blockSize, uint32_t gridSize, /*optional*/bool disableQBypassLDS, /*optional*/::mlir::IntegerAttr prePadG0M, /*optional*/::mlir::IntegerAttr prePadG0N, /*optional*/::mlir::IntegerAttr numRepeatsGQA, /*optional*/::mlir::TypeAttr softmaxType, ::mlir::rock::RockAccelTuningParamAttrInterface params0, ::mlir::rock::RockAccelTuningParamAttrInterface params1, ::llvm::ArrayRef<int64_t> firstGemmIndices, /*optional*/bool enableSoftmax = true);
  static GridwiseAttentionAccelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value queries, ::mlir::Value keys, ::mlir::Value values, ::mlir::ValueRange preSoftmaxElemWiseInputs, /*optional*/::mlir::Value currentSeqLen, ::mlir::Value out, /*optional*/::mlir::Value lse, /*optional*/bool causal, uint32_t splitKV, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, uint32_t blockSize, uint32_t gridSize, /*optional*/bool disableQBypassLDS, /*optional*/::mlir::IntegerAttr prePadG0M, /*optional*/::mlir::IntegerAttr prePadG0N, /*optional*/::mlir::IntegerAttr numRepeatsGQA, /*optional*/::mlir::TypeAttr softmaxType, ::mlir::rock::RockAccelTuningParamAttrInterface params0, ::mlir::rock::RockAccelTuningParamAttrInterface params1, ::llvm::ArrayRef<int64_t> firstGemmIndices, /*optional*/bool enableSoftmax = true);
  static GridwiseAttentionAccelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value queries, ::mlir::Value keys, ::mlir::Value values, ::mlir::ValueRange preSoftmaxElemWiseInputs, /*optional*/::mlir::Value currentSeqLen, ::mlir::Value out, /*optional*/::mlir::Value lse, /*optional*/bool causal, uint32_t splitKV, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, uint32_t blockSize, uint32_t gridSize, /*optional*/bool disableQBypassLDS, /*optional*/::mlir::IntegerAttr prePadG0M, /*optional*/::mlir::IntegerAttr prePadG0N, /*optional*/::mlir::IntegerAttr numRepeatsGQA, /*optional*/::mlir::TypeAttr softmaxType, ::mlir::rock::RockAccelTuningParamAttrInterface params0, ::mlir::rock::RockAccelTuningParamAttrInterface params1, ::llvm::ArrayRef<int64_t> firstGemmIndices, /*optional*/bool enableSoftmax = true);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value queries, ::mlir::Value keys, ::mlir::Value values, ::mlir::ValueRange preSoftmaxElemWiseInputs, /*optional*/::mlir::Value currentSeqLen, ::mlir::Value out, /*optional*/::mlir::Value lse, /*optional*/bool causal, uint32_t splitKV, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, uint32_t blockSize, uint32_t gridSize, /*optional*/bool disableQBypassLDS, /*optional*/::mlir::IntegerAttr prePadG0M, /*optional*/::mlir::IntegerAttr prePadG0N, /*optional*/::mlir::IntegerAttr numRepeatsGQA, /*optional*/::mlir::TypeAttr softmaxType, ::mlir::rock::RockAccelTuningParamAttrInterface params0, ::mlir::rock::RockAccelTuningParamAttrInterface params1, ::llvm::ArrayRef<int64_t> firstGemmIndices, /*optional*/bool enableSoftmax = true);
  static GridwiseAttentionAccelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value queries, ::mlir::Value keys, ::mlir::Value values, ::mlir::ValueRange preSoftmaxElemWiseInputs, /*optional*/::mlir::Value currentSeqLen, ::mlir::Value out, /*optional*/::mlir::Value lse, /*optional*/bool causal, uint32_t splitKV, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, uint32_t blockSize, uint32_t gridSize, /*optional*/bool disableQBypassLDS, /*optional*/::mlir::IntegerAttr prePadG0M, /*optional*/::mlir::IntegerAttr prePadG0N, /*optional*/::mlir::IntegerAttr numRepeatsGQA, /*optional*/::mlir::TypeAttr softmaxType, ::mlir::rock::RockAccelTuningParamAttrInterface params0, ::mlir::rock::RockAccelTuningParamAttrInterface params1, ::llvm::ArrayRef<int64_t> firstGemmIndices, /*optional*/bool enableSoftmax = true);
  static GridwiseAttentionAccelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value queries, ::mlir::Value keys, ::mlir::Value values, ::mlir::ValueRange preSoftmaxElemWiseInputs, /*optional*/::mlir::Value currentSeqLen, ::mlir::Value out, /*optional*/::mlir::Value lse, /*optional*/bool causal, uint32_t splitKV, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, uint32_t blockSize, uint32_t gridSize, /*optional*/bool disableQBypassLDS, /*optional*/::mlir::IntegerAttr prePadG0M, /*optional*/::mlir::IntegerAttr prePadG0N, /*optional*/::mlir::IntegerAttr numRepeatsGQA, /*optional*/::mlir::TypeAttr softmaxType, ::mlir::rock::RockAccelTuningParamAttrInterface params0, ::mlir::rock::RockAccelTuningParamAttrInterface params1, ::llvm::ArrayRef<int64_t> firstGemmIndices, /*optional*/bool enableSoftmax = true);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GridwiseAttentionAccelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GridwiseAttentionAccelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GridwiseAttentionAccelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GridwiseAttentionAccelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  SmallVector<::mlir::Type> getTypesForFeature();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 15 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::GridwiseAttentionAccelOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::GridwiseGemmAccelOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class GridwiseGemmAccelOpGenericAdaptorBase {
public:
  struct Properties {
    using blockSizeTy = ::mlir::IntegerAttr;
    blockSizeTy blockSize;

    auto getBlockSize() const {
      auto &propStorage = this->blockSize;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setBlockSize(const ::mlir::IntegerAttr &propValue) {
      this->blockSize = propValue;
    }
    using featuresTy = ::mlir::rock::GemmFeaturesAttr;
    featuresTy features;

    auto getFeatures() const {
      auto &propStorage = this->features;
      return ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(propStorage);
    }
    void setFeatures(const ::mlir::rock::GemmFeaturesAttr &propValue) {
      this->features = propValue;
    }
    using gridSizeTy = ::mlir::IntegerAttr;
    gridSizeTy gridSize;

    auto getGridSize() const {
      auto &propStorage = this->gridSize;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setGridSize(const ::mlir::IntegerAttr &propValue) {
      this->gridSize = propValue;
    }
    using paramsTy = ::mlir::rock::RockAccelTuningParamAttrInterface;
    paramsTy params;

    auto getParams() const {
      auto &propStorage = this->params;
      return ::llvm::cast<::mlir::rock::RockAccelTuningParamAttrInterface>(propStorage);
    }
    void setParams(const ::mlir::rock::RockAccelTuningParamAttrInterface &propValue) {
      this->params = propValue;
    }
    using storeMethodTy = ::mlir::rock::StoreMethodAttr;
    storeMethodTy storeMethod;

    auto getStoreMethod() const {
      auto &propStorage = this->storeMethod;
      return ::llvm::cast<::mlir::rock::StoreMethodAttr>(propStorage);
    }
    void setStoreMethod(const ::mlir::rock::StoreMethodAttr &propValue) {
      this->storeMethod = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.blockSize == this->blockSize &&
        rhs.features == this->features &&
        rhs.gridSize == this->gridSize &&
        rhs.params == this->params &&
        rhs.storeMethod == this->storeMethod &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  GridwiseGemmAccelOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.gridwise_gemm_accel", odsAttrs.getContext());
  }

  GridwiseGemmAccelOpGenericAdaptorBase(GridwiseGemmAccelOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::rock::GemmFeaturesAttr getFeaturesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(getProperties().features);
    return attr;
  }

  ::std::optional<::mlir::rock::GemmFeatures> getFeatures();
  ::mlir::rock::StoreMethodAttr getStoreMethodAttr() {
    auto attr = ::llvm::cast<::mlir::rock::StoreMethodAttr>(getProperties().storeMethod);
    return attr;
  }

  ::mlir::rock::StoreMethod getStoreMethod();
  ::mlir::IntegerAttr getBlockSizeAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().blockSize);
    return attr;
  }

  uint32_t getBlockSize();
  ::mlir::IntegerAttr getGridSizeAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().gridSize);
    return attr;
  }

  uint32_t getGridSize();
  ::mlir::rock::RockAccelTuningParamAttrInterface getParamsAttr() {
    auto attr = ::llvm::cast<::mlir::rock::RockAccelTuningParamAttrInterface>(getProperties().params);
    return attr;
  }

  ::mlir::rock::RockAccelTuningParamAttrInterface getParams();
};
} // namespace detail
template <typename RangeT>
class GridwiseGemmAccelOpGenericAdaptor : public detail::GridwiseGemmAccelOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::GridwiseGemmAccelOpGenericAdaptorBase;
  static constexpr int odsIndex_a = 0;
  static constexpr int odsIndex_b = 1;
  static constexpr int odsIndex_c = 2;
public:
  GridwiseGemmAccelOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  GridwiseGemmAccelOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : GridwiseGemmAccelOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  GridwiseGemmAccelOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : GridwiseGemmAccelOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  GridwiseGemmAccelOpGenericAdaptor(RangeT values, const GridwiseGemmAccelOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = GridwiseGemmAccelOp, typename = std::enable_if_t<std::is_same_v<LateInst, GridwiseGemmAccelOp>>>
  GridwiseGemmAccelOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getA() {
    return (*getODSOperands(0).begin());
  }

  ValueT getB() {
    return (*getODSOperands(1).begin());
  }

  ValueT getC() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class GridwiseGemmAccelOpAdaptor : public GridwiseGemmAccelOpGenericAdaptor<::mlir::ValueRange> {
public:
  using GridwiseGemmAccelOpGenericAdaptor::GridwiseGemmAccelOpGenericAdaptor;
  GridwiseGemmAccelOpAdaptor(GridwiseGemmAccelOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class GridwiseGemmAccelOp : public ::mlir::Op<GridwiseGemmAccelOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::rock::RockGemmFeaturesInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, mlir::OpTrait::rock::FusionRoot> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = GridwiseGemmAccelOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = GridwiseGemmAccelOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_a = 0;
  static constexpr int odsIndex_b = 1;
  static constexpr int odsIndex_c = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("blockSize"), ::llvm::StringRef("features"), ::llvm::StringRef("gridSize"), ::llvm::StringRef("params"), ::llvm::StringRef("storeMethod")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBlockSizeAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBlockSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getFeaturesAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getFeaturesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getGridSizeAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getGridSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getParamsAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getParamsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getStoreMethodAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getStoreMethodAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.gridwise_gemm_accel");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::MemRefType> getA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getB() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getC() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getBMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getCMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::rock::GemmFeaturesAttr getFeaturesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(getProperties().features);
  }

  ::std::optional<::mlir::rock::GemmFeatures> getFeatures();
  ::mlir::rock::StoreMethodAttr getStoreMethodAttr() {
    return ::llvm::cast<::mlir::rock::StoreMethodAttr>(getProperties().storeMethod);
  }

  ::mlir::rock::StoreMethod getStoreMethod();
  ::mlir::IntegerAttr getBlockSizeAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().blockSize);
  }

  uint32_t getBlockSize();
  ::mlir::IntegerAttr getGridSizeAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().gridSize);
  }

  uint32_t getGridSize();
  ::mlir::rock::RockAccelTuningParamAttrInterface getParamsAttr() {
    return ::llvm::cast<::mlir::rock::RockAccelTuningParamAttrInterface>(getProperties().params);
  }

  ::mlir::rock::RockAccelTuningParamAttrInterface getParams();
  void setFeaturesAttr(::mlir::rock::GemmFeaturesAttr attr) {
    getProperties().features = attr;
  }

  void setFeatures(::std::optional<::mlir::rock::GemmFeatures> attrValue);
  void setStoreMethodAttr(::mlir::rock::StoreMethodAttr attr) {
    getProperties().storeMethod = attr;
  }

  void setStoreMethod(::mlir::rock::StoreMethod attrValue);
  void setBlockSizeAttr(::mlir::IntegerAttr attr) {
    getProperties().blockSize = attr;
  }

  void setBlockSize(uint32_t attrValue);
  void setGridSizeAttr(::mlir::IntegerAttr attr) {
    getProperties().gridSize = attr;
  }

  void setGridSize(uint32_t attrValue);
  void setParamsAttr(::mlir::rock::RockAccelTuningParamAttrInterface attr) {
    getProperties().params = attr;
  }

  ::mlir::Attribute removeFeaturesAttr() {
      auto attr = getProperties().features;
      getProperties().features = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, ::mlir::IntegerAttr blockSize, ::mlir::IntegerAttr gridSize, ::mlir::rock::RockAccelTuningParamAttrInterface params);
  static GridwiseGemmAccelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, ::mlir::IntegerAttr blockSize, ::mlir::IntegerAttr gridSize, ::mlir::rock::RockAccelTuningParamAttrInterface params);
  static GridwiseGemmAccelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, ::mlir::IntegerAttr blockSize, ::mlir::IntegerAttr gridSize, ::mlir::rock::RockAccelTuningParamAttrInterface params);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, ::mlir::IntegerAttr blockSize, ::mlir::IntegerAttr gridSize, ::mlir::rock::RockAccelTuningParamAttrInterface params);
  static GridwiseGemmAccelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, ::mlir::IntegerAttr blockSize, ::mlir::IntegerAttr gridSize, ::mlir::rock::RockAccelTuningParamAttrInterface params);
  static GridwiseGemmAccelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, ::mlir::IntegerAttr blockSize, ::mlir::IntegerAttr gridSize, ::mlir::rock::RockAccelTuningParamAttrInterface params);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, uint32_t blockSize, uint32_t gridSize, ::mlir::rock::RockAccelTuningParamAttrInterface params);
  static GridwiseGemmAccelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, uint32_t blockSize, uint32_t gridSize, ::mlir::rock::RockAccelTuningParamAttrInterface params);
  static GridwiseGemmAccelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, uint32_t blockSize, uint32_t gridSize, ::mlir::rock::RockAccelTuningParamAttrInterface params);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, uint32_t blockSize, uint32_t gridSize, ::mlir::rock::RockAccelTuningParamAttrInterface params);
  static GridwiseGemmAccelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, uint32_t blockSize, uint32_t gridSize, ::mlir::rock::RockAccelTuningParamAttrInterface params);
  static GridwiseGemmAccelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, uint32_t blockSize, uint32_t gridSize, ::mlir::rock::RockAccelTuningParamAttrInterface params);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GridwiseGemmAccelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GridwiseGemmAccelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GridwiseGemmAccelOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GridwiseGemmAccelOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  SmallVector<::mlir::Type> getTypesForFeature();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 5 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::GridwiseGemmAccelOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::GridwiseGemmOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class GridwiseGemmOpGenericAdaptorBase {
public:
  struct Properties {
    using featuresTy = ::mlir::rock::GemmFeaturesAttr;
    featuresTy features;

    auto getFeatures() const {
      auto &propStorage = this->features;
      return ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(propStorage);
    }
    void setFeatures(const ::mlir::rock::GemmFeaturesAttr &propValue) {
      this->features = propValue;
    }
    using gridSizeTy = ::mlir::IntegerAttr;
    gridSizeTy gridSize;

    auto getGridSize() const {
      auto &propStorage = this->gridSize;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setGridSize(const ::mlir::IntegerAttr &propValue) {
      this->gridSize = propValue;
    }
    using paramsTy = ::mlir::rock::GeneralGemmParamsAttr;
    paramsTy params;

    auto getParams() const {
      auto &propStorage = this->params;
      return ::llvm::cast<::mlir::rock::GeneralGemmParamsAttr>(propStorage);
    }
    void setParams(const ::mlir::rock::GeneralGemmParamsAttr &propValue) {
      this->params = propValue;
    }
    using storeMethodTy = ::mlir::rock::StoreMethodAttr;
    storeMethodTy storeMethod;

    auto getStoreMethod() const {
      auto &propStorage = this->storeMethod;
      return ::llvm::cast<::mlir::rock::StoreMethodAttr>(propStorage);
    }
    void setStoreMethod(const ::mlir::rock::StoreMethodAttr &propValue) {
      this->storeMethod = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.features == this->features &&
        rhs.gridSize == this->gridSize &&
        rhs.params == this->params &&
        rhs.storeMethod == this->storeMethod &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  GridwiseGemmOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.gridwise_gemm", odsAttrs.getContext());
  }

  GridwiseGemmOpGenericAdaptorBase(GridwiseGemmOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::rock::GemmFeaturesAttr getFeaturesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(getProperties().features);
    return attr;
  }

  ::std::optional<::mlir::rock::GemmFeatures> getFeatures();
  ::mlir::rock::StoreMethodAttr getStoreMethodAttr() {
    auto attr = ::llvm::cast<::mlir::rock::StoreMethodAttr>(getProperties().storeMethod);
    return attr;
  }

  ::mlir::rock::StoreMethod getStoreMethod();
  ::mlir::IntegerAttr getGridSizeAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().gridSize);
    return attr;
  }

  uint32_t getGridSize();
  ::mlir::rock::GeneralGemmParamsAttr getParamsAttr() {
    auto attr = ::llvm::cast<::mlir::rock::GeneralGemmParamsAttr>(getProperties().params);
    return attr;
  }

  ::mlir::rock::GeneralGemmParamsAttr getParams();
};
} // namespace detail
template <typename RangeT>
class GridwiseGemmOpGenericAdaptor : public detail::GridwiseGemmOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::GridwiseGemmOpGenericAdaptorBase;
  static constexpr int odsIndex_a = 0;
  static constexpr int odsIndex_b = 1;
  static constexpr int odsIndex_c = 2;
public:
  GridwiseGemmOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  GridwiseGemmOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : GridwiseGemmOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  GridwiseGemmOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : GridwiseGemmOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  GridwiseGemmOpGenericAdaptor(RangeT values, const GridwiseGemmOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = GridwiseGemmOp, typename = std::enable_if_t<std::is_same_v<LateInst, GridwiseGemmOp>>>
  GridwiseGemmOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getA() {
    return (*getODSOperands(0).begin());
  }

  ValueT getB() {
    return (*getODSOperands(1).begin());
  }

  ValueT getC() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class GridwiseGemmOpAdaptor : public GridwiseGemmOpGenericAdaptor<::mlir::ValueRange> {
public:
  using GridwiseGemmOpGenericAdaptor::GridwiseGemmOpGenericAdaptor;
  GridwiseGemmOpAdaptor(GridwiseGemmOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class GridwiseGemmOp : public ::mlir::Op<GridwiseGemmOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::rock::RockGemmFeaturesInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait, mlir::OpTrait::rock::FusionRoot> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = GridwiseGemmOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = GridwiseGemmOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_a = 0;
  static constexpr int odsIndex_b = 1;
  static constexpr int odsIndex_c = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("features"), ::llvm::StringRef("gridSize"), ::llvm::StringRef("params"), ::llvm::StringRef("storeMethod")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getFeaturesAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getFeaturesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getGridSizeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getGridSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getParamsAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getParamsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getStoreMethodAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getStoreMethodAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.gridwise_gemm");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::MemRefType> getA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getB() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getC() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getBMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getCMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::rock::GemmFeaturesAttr getFeaturesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(getProperties().features);
  }

  ::std::optional<::mlir::rock::GemmFeatures> getFeatures();
  ::mlir::rock::StoreMethodAttr getStoreMethodAttr() {
    return ::llvm::cast<::mlir::rock::StoreMethodAttr>(getProperties().storeMethod);
  }

  ::mlir::rock::StoreMethod getStoreMethod();
  ::mlir::IntegerAttr getGridSizeAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().gridSize);
  }

  uint32_t getGridSize();
  ::mlir::rock::GeneralGemmParamsAttr getParamsAttr() {
    return ::llvm::cast<::mlir::rock::GeneralGemmParamsAttr>(getProperties().params);
  }

  ::mlir::rock::GeneralGemmParamsAttr getParams();
  void setFeaturesAttr(::mlir::rock::GemmFeaturesAttr attr) {
    getProperties().features = attr;
  }

  void setFeatures(::std::optional<::mlir::rock::GemmFeatures> attrValue);
  void setStoreMethodAttr(::mlir::rock::StoreMethodAttr attr) {
    getProperties().storeMethod = attr;
  }

  void setStoreMethod(::mlir::rock::StoreMethod attrValue);
  void setGridSizeAttr(::mlir::IntegerAttr attr) {
    getProperties().gridSize = attr;
  }

  void setGridSize(uint32_t attrValue);
  void setParamsAttr(::mlir::rock::GeneralGemmParamsAttr attr) {
    getProperties().params = attr;
  }

  ::mlir::Attribute removeFeaturesAttr() {
      auto attr = getProperties().features;
      getProperties().features = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, ::mlir::IntegerAttr gridSize, ::mlir::rock::GeneralGemmParamsAttr params);
  static GridwiseGemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, ::mlir::IntegerAttr gridSize, ::mlir::rock::GeneralGemmParamsAttr params);
  static GridwiseGemmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, ::mlir::IntegerAttr gridSize, ::mlir::rock::GeneralGemmParamsAttr params);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, ::mlir::IntegerAttr gridSize, ::mlir::rock::GeneralGemmParamsAttr params);
  static GridwiseGemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, ::mlir::IntegerAttr gridSize, ::mlir::rock::GeneralGemmParamsAttr params);
  static GridwiseGemmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethodAttr storeMethod, ::mlir::IntegerAttr gridSize, ::mlir::rock::GeneralGemmParamsAttr params);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, uint32_t gridSize, ::mlir::rock::GeneralGemmParamsAttr params);
  static GridwiseGemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, uint32_t gridSize, ::mlir::rock::GeneralGemmParamsAttr params);
  static GridwiseGemmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, uint32_t gridSize, ::mlir::rock::GeneralGemmParamsAttr params);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, uint32_t gridSize, ::mlir::rock::GeneralGemmParamsAttr params);
  static GridwiseGemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, uint32_t gridSize, ::mlir::rock::GeneralGemmParamsAttr params);
  static GridwiseGemmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value a, ::mlir::Value b, ::mlir::Value c, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::StoreMethod storeMethod, uint32_t gridSize, ::mlir::rock::GeneralGemmParamsAttr params);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GridwiseGemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static GridwiseGemmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GridwiseGemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static GridwiseGemmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  SmallVector<::mlir::Type> getTypesForFeature();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 4 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::GridwiseGemmOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::InBoundsLoadOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class InBoundsLoadOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  InBoundsLoadOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.in_bounds_load", odsAttrs.getContext());
  }

  InBoundsLoadOpGenericAdaptorBase(InBoundsLoadOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class InBoundsLoadOpGenericAdaptor : public detail::InBoundsLoadOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::InBoundsLoadOpGenericAdaptorBase;
  static constexpr int odsIndex_source = 0;
  static constexpr int odsIndex_coords = 1;
public:
  InBoundsLoadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  InBoundsLoadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : InBoundsLoadOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  InBoundsLoadOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : InBoundsLoadOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  InBoundsLoadOpGenericAdaptor(RangeT values, const InBoundsLoadOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = InBoundsLoadOp, typename = std::enable_if_t<std::is_same_v<LateInst, InBoundsLoadOp>>>
  InBoundsLoadOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSource() {
    return (*getODSOperands(0).begin());
  }

  RangeT getCoords() {
    return getODSOperands(1);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class InBoundsLoadOpAdaptor : public InBoundsLoadOpGenericAdaptor<::mlir::ValueRange> {
public:
  using InBoundsLoadOpGenericAdaptor::InBoundsLoadOpGenericAdaptor;
  InBoundsLoadOpAdaptor(InBoundsLoadOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class InBoundsLoadOp : public ::mlir::Op<InBoundsLoadOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::Type>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<1>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = InBoundsLoadOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = InBoundsLoadOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_source = 0;
  static constexpr int odsIndex_coords = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.in_bounds_load");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::MemRefType> getSource() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getCoords() {
    return getODSOperands(1);
  }

  ::mlir::OpOperand &getSourceMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getCoordsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value source, ::mlir::ValueRange coords);
  static InBoundsLoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value source, ::mlir::ValueRange coords);
  static InBoundsLoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value source, ::mlir::ValueRange coords);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::ValueRange coords);
  static InBoundsLoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::ValueRange coords);
  static InBoundsLoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::ValueRange coords);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static InBoundsLoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static InBoundsLoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static InBoundsLoadOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static InBoundsLoadOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::InBoundsLoadOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::InBoundsStoreOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class InBoundsStoreOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  InBoundsStoreOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.in_bounds_store", odsAttrs.getContext());
  }

  InBoundsStoreOpGenericAdaptorBase(InBoundsStoreOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class InBoundsStoreOpGenericAdaptor : public detail::InBoundsStoreOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::InBoundsStoreOpGenericAdaptorBase;
  static constexpr int odsIndex_data = 0;
  static constexpr int odsIndex_dest = 1;
  static constexpr int odsIndex_coords = 2;
public:
  InBoundsStoreOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  InBoundsStoreOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : InBoundsStoreOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  InBoundsStoreOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : InBoundsStoreOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  InBoundsStoreOpGenericAdaptor(RangeT values, const InBoundsStoreOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = InBoundsStoreOp, typename = std::enable_if_t<std::is_same_v<LateInst, InBoundsStoreOp>>>
  InBoundsStoreOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getData() {
    return (*getODSOperands(0).begin());
  }

  ValueT getDest() {
    return (*getODSOperands(1).begin());
  }

  RangeT getCoords() {
    return getODSOperands(2);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class InBoundsStoreOpAdaptor : public InBoundsStoreOpGenericAdaptor<::mlir::ValueRange> {
public:
  using InBoundsStoreOpGenericAdaptor::InBoundsStoreOpGenericAdaptor;
  InBoundsStoreOpAdaptor(InBoundsStoreOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class InBoundsStoreOp : public ::mlir::Op<InBoundsStoreOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = InBoundsStoreOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = InBoundsStoreOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_data = 0;
  static constexpr int odsIndex_dest = 1;
  static constexpr int odsIndex_coords = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.in_bounds_store");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getData() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getDest() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(1).begin());
  }

  ::mlir::Operation::operand_range getCoords() {
    return getODSOperands(2);
  }

  ::mlir::OpOperand &getDataMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getDestMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getCoordsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value data, ::mlir::Value dest, ::mlir::ValueRange coords);
  static InBoundsStoreOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value data, ::mlir::Value dest, ::mlir::ValueRange coords);
  static InBoundsStoreOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value data, ::mlir::Value dest, ::mlir::ValueRange coords);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value data, ::mlir::Value dest, ::mlir::ValueRange coords);
  static InBoundsStoreOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value data, ::mlir::Value dest, ::mlir::ValueRange coords);
  static InBoundsStoreOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value data, ::mlir::Value dest, ::mlir::ValueRange coords);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static InBoundsStoreOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static InBoundsStoreOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static InBoundsStoreOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static InBoundsStoreOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::InBoundsStoreOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::IndexDiffUpdateOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class IndexDiffUpdateOpGenericAdaptorBase {
public:
  struct Properties {
    using mapTy = ::mlir::rock::TransformMapAttr;
    mapTy map;

    auto getMap() const {
      auto &propStorage = this->map;
      return ::llvm::cast<::mlir::rock::TransformMapAttr>(propStorage);
    }
    void setMap(const ::mlir::rock::TransformMapAttr &propValue) {
      this->map = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 2>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.map == this->map &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  IndexDiffUpdateOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.index_diff_update", odsAttrs.getContext());
  }

  IndexDiffUpdateOpGenericAdaptorBase(IndexDiffUpdateOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::rock::TransformMapAttr getMapAttr() {
    auto attr = ::llvm::cast<::mlir::rock::TransformMapAttr>(getProperties().map);
    return attr;
  }

  ::mlir::rock::TransformMapAttr getMap();
};
} // namespace detail
template <typename RangeT>
class IndexDiffUpdateOpGenericAdaptor : public detail::IndexDiffUpdateOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::IndexDiffUpdateOpGenericAdaptorBase;
  static constexpr int odsIndex_upperDiffs = 0;
  static constexpr int odsIndex_lowerOrig = 1;
public:
  IndexDiffUpdateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  IndexDiffUpdateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : IndexDiffUpdateOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  IndexDiffUpdateOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : IndexDiffUpdateOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  IndexDiffUpdateOpGenericAdaptor(RangeT values, const IndexDiffUpdateOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = IndexDiffUpdateOp, typename = std::enable_if_t<std::is_same_v<LateInst, IndexDiffUpdateOp>>>
  IndexDiffUpdateOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getUpperDiffs() {
    return getODSOperands(0);
  }

  RangeT getLowerOrig() {
    return getODSOperands(1);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class IndexDiffUpdateOpAdaptor : public IndexDiffUpdateOpGenericAdaptor<::mlir::ValueRange> {
public:
  using IndexDiffUpdateOpGenericAdaptor::IndexDiffUpdateOpGenericAdaptor;
  IndexDiffUpdateOpAdaptor(IndexDiffUpdateOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class IndexDiffUpdateOp : public ::mlir::Op<IndexDiffUpdateOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpAsmOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = IndexDiffUpdateOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = IndexDiffUpdateOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_upperDiffs = 0;
  static constexpr int odsIndex_lowerOrig = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("map"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getMapAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getMapAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  void getAsmResultNames(::mlir::OpAsmSetValueNameFn setNameFn);
  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.index_diff_update");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getUpperDiffs() {
    return getODSOperands(0);
  }

  ::mlir::Operation::operand_range getLowerOrig() {
    return getODSOperands(1);
  }

  ::mlir::MutableOperandRange getUpperDiffsMutable();
  ::mlir::MutableOperandRange getLowerOrigMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::result_range getLowerIndices() {
    return getODSResults(0);
  }

  ::mlir::Operation::result_range getLowerDiff() {
    return getODSResults(1);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::rock::TransformMapAttr getMapAttr() {
    return ::llvm::cast<::mlir::rock::TransformMapAttr>(getProperties().map);
  }

  ::mlir::rock::TransformMapAttr getMap();
  void setMapAttr(::mlir::rock::TransformMapAttr attr) {
    getProperties().map = attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, TransformMapAttr transform, ValueRange upperDiffs, ValueRange lowerOrig);
  static IndexDiffUpdateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, TransformMapAttr transform, ValueRange upperDiffs, ValueRange lowerOrig);
  static IndexDiffUpdateOp create(::mlir::ImplicitLocOpBuilder &builder, TransformMapAttr transform, ValueRange upperDiffs, ValueRange lowerOrig);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange lowerIndices, ::mlir::TypeRange lowerDiff, ::mlir::rock::TransformMapAttr map, ::mlir::ValueRange upperDiffs, ::mlir::ValueRange lowerOrig);
  static IndexDiffUpdateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange lowerIndices, ::mlir::TypeRange lowerDiff, ::mlir::rock::TransformMapAttr map, ::mlir::ValueRange upperDiffs, ::mlir::ValueRange lowerOrig);
  static IndexDiffUpdateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange lowerIndices, ::mlir::TypeRange lowerDiff, ::mlir::rock::TransformMapAttr map, ::mlir::ValueRange upperDiffs, ::mlir::ValueRange lowerOrig);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::rock::TransformMapAttr map, ::mlir::ValueRange upperDiffs, ::mlir::ValueRange lowerOrig);
  static IndexDiffUpdateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::rock::TransformMapAttr map, ::mlir::ValueRange upperDiffs, ::mlir::ValueRange lowerOrig);
  static IndexDiffUpdateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::rock::TransformMapAttr map, ::mlir::ValueRange upperDiffs, ::mlir::ValueRange lowerOrig);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static IndexDiffUpdateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static IndexDiffUpdateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static IndexDiffUpdateOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static IndexDiffUpdateOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::IndexDiffUpdateOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::InsertSliceOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class InsertSliceOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  InsertSliceOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.insert_slice", odsAttrs.getContext());
  }

  InsertSliceOpGenericAdaptorBase(InsertSliceOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class InsertSliceOpGenericAdaptor : public detail::InsertSliceOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::InsertSliceOpGenericAdaptorBase;
  static constexpr int odsIndex_source = 0;
  static constexpr int odsIndex_dest = 1;
  static constexpr int odsIndex_coord = 2;
public:
  InsertSliceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  InsertSliceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : InsertSliceOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  InsertSliceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : InsertSliceOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  InsertSliceOpGenericAdaptor(RangeT values, const InsertSliceOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = InsertSliceOp, typename = std::enable_if_t<std::is_same_v<LateInst, InsertSliceOp>>>
  InsertSliceOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSource() {
    return (*getODSOperands(0).begin());
  }

  ValueT getDest() {
    return (*getODSOperands(1).begin());
  }

  ValueT getCoord() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class InsertSliceOpAdaptor : public InsertSliceOpGenericAdaptor<::mlir::ValueRange> {
public:
  using InsertSliceOpGenericAdaptor::InsertSliceOpGenericAdaptor;
  InsertSliceOpAdaptor(InsertSliceOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class InsertSliceOp : public ::mlir::Op<InsertSliceOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::VectorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = InsertSliceOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = InsertSliceOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_source = 0;
  static constexpr int odsIndex_dest = 1;
  static constexpr int odsIndex_coord = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.insert_slice");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::Type> getSource() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::Type>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::VectorType> getDest() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::IndexType> getCoord() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IndexType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getSourceMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getDestMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getCoordMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type result, ::mlir::Value source, ::mlir::Value dest, ::mlir::Value coord);
  static InsertSliceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type result, ::mlir::Value source, ::mlir::Value dest, ::mlir::Value coord);
  static InsertSliceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type result, ::mlir::Value source, ::mlir::Value dest, ::mlir::Value coord);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value dest, ::mlir::Value coord);
  static InsertSliceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value dest, ::mlir::Value coord);
  static InsertSliceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value dest, ::mlir::Value coord);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static InsertSliceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static InsertSliceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static InsertSliceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static InsertSliceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  static ::llvm::LogicalResult canonicalize(InsertSliceOp op, ::mlir::PatternRewriter &rewriter);
  static void getCanonicalizationPatterns(::mlir::RewritePatternSet &results, ::mlir::MLIRContext *context);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::InsertSliceOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::LDSBarrierOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class LDSBarrierOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  LDSBarrierOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.lds_barrier", odsAttrs.getContext());
  }

  LDSBarrierOpGenericAdaptorBase(LDSBarrierOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class LDSBarrierOpGenericAdaptor : public detail::LDSBarrierOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::LDSBarrierOpGenericAdaptorBase;
public:
  LDSBarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  LDSBarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : LDSBarrierOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  LDSBarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : LDSBarrierOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  LDSBarrierOpGenericAdaptor(RangeT values, const LDSBarrierOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = LDSBarrierOp, typename = std::enable_if_t<std::is_same_v<LateInst, LDSBarrierOp>>>
  LDSBarrierOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class LDSBarrierOpAdaptor : public LDSBarrierOpGenericAdaptor<::mlir::ValueRange> {
public:
  using LDSBarrierOpGenericAdaptor::LDSBarrierOpGenericAdaptor;
  LDSBarrierOpAdaptor(LDSBarrierOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class LDSBarrierOp : public ::mlir::Op<LDSBarrierOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = LDSBarrierOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = LDSBarrierOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.lds_barrier");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState);
  static LDSBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location);
  static LDSBarrierOp create(::mlir::ImplicitLocOpBuilder &builder);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static LDSBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static LDSBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static LDSBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static LDSBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static LDSBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static LDSBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::LDSBarrierOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::ReduceOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ReduceOpGenericAdaptorBase {
public:
  struct Properties {
    using axisTy = ::mlir::IntegerAttr;
    axisTy axis;

    auto getAxis() const {
      auto &propStorage = this->axis;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setAxis(const ::mlir::IntegerAttr &propValue) {
      this->axis = propValue;
    }
    using blockSizeTy = ::mlir::IntegerAttr;
    blockSizeTy blockSize;

    auto getBlockSize() const {
      auto &propStorage = this->blockSize;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setBlockSize(const ::mlir::IntegerAttr &propValue) {
      this->blockSize = propValue;
    }
    using gridSizeTy = ::mlir::IntegerAttr;
    gridSizeTy gridSize;

    auto getGridSize() const {
      auto &propStorage = this->gridSize;
      return ::llvm::cast<::mlir::IntegerAttr>(propStorage);
    }
    void setGridSize(const ::mlir::IntegerAttr &propValue) {
      this->gridSize = propValue;
    }
    using reduceMethodTy = ::mlir::rock::ReduceMethodAttr;
    reduceMethodTy reduceMethod;

    auto getReduceMethod() const {
      auto &propStorage = this->reduceMethod;
      return ::llvm::cast<::mlir::rock::ReduceMethodAttr>(propStorage);
    }
    void setReduceMethod(const ::mlir::rock::ReduceMethodAttr &propValue) {
      this->reduceMethod = propValue;
    }
    using useDPPTy = ::mlir::UnitAttr;
    useDPPTy useDPP;

    auto getUseDPP() const {
      auto &propStorage = this->useDPP;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setUseDPP(const ::mlir::UnitAttr &propValue) {
      this->useDPP = propValue;
    }
    using useLDSTy = ::mlir::UnitAttr;
    useLDSTy useLDS;

    auto getUseLDS() const {
      auto &propStorage = this->useLDS;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setUseLDS(const ::mlir::UnitAttr &propValue) {
      this->useLDS = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.axis == this->axis &&
        rhs.blockSize == this->blockSize &&
        rhs.gridSize == this->gridSize &&
        rhs.reduceMethod == this->reduceMethod &&
        rhs.useDPP == this->useDPP &&
        rhs.useLDS == this->useLDS &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ReduceOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.reduce", odsAttrs.getContext());
  }

  ReduceOpGenericAdaptorBase(ReduceOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::rock::ReduceMethodAttr getReduceMethodAttr() {
    auto attr = ::llvm::cast<::mlir::rock::ReduceMethodAttr>(getProperties().reduceMethod);
    return attr;
  }

  ::mlir::rock::ReduceMethod getReduceMethod();
  ::mlir::IntegerAttr getAxisAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().axis);
    return attr;
  }

  ::llvm::APInt getAxis();
  ::mlir::IntegerAttr getBlockSizeAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().blockSize);
    return attr;
  }

  uint32_t getBlockSize();
  ::mlir::IntegerAttr getGridSizeAttr() {
    auto attr = ::llvm::cast<::mlir::IntegerAttr>(getProperties().gridSize);
    return attr;
  }

  uint32_t getGridSize();
  ::mlir::UnitAttr getUseLDSAttr();
  bool getUseLDS();
  ::mlir::UnitAttr getUseDPPAttr();
  bool getUseDPP();
};
} // namespace detail
template <typename RangeT>
class ReduceOpGenericAdaptor : public detail::ReduceOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ReduceOpGenericAdaptorBase;
  static constexpr int odsIndex_in = 0;
  static constexpr int odsIndex_out = 1;
public:
  ReduceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ReduceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ReduceOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ReduceOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ReduceOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ReduceOpGenericAdaptor(RangeT values, const ReduceOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ReduceOp, typename = std::enable_if_t<std::is_same_v<LateInst, ReduceOp>>>
  ReduceOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getIn() {
    return (*getODSOperands(0).begin());
  }

  ValueT getOut() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ReduceOpAdaptor : public ReduceOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ReduceOpGenericAdaptor::ReduceOpGenericAdaptor;
  ReduceOpAdaptor(ReduceOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ReduceOp : public ::mlir::Op<ReduceOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ReduceOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ReduceOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_in = 0;
  static constexpr int odsIndex_out = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("axis"), ::llvm::StringRef("blockSize"), ::llvm::StringRef("gridSize"), ::llvm::StringRef("reduceMethod"), ::llvm::StringRef("useDPP"), ::llvm::StringRef("useLDS")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getAxisAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getAxisAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getBlockSizeAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getBlockSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getGridSizeAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getGridSizeAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getReduceMethodAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getReduceMethodAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getUseDPPAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getUseDPPAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getUseLDSAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getUseLDSAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.reduce");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::ShapedType> getIn() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::ShapedType> getOut() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getInMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getOutMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::TensorType> getResult() {
    auto results = getODSResults(0);
    return results.empty() ? ::mlir::TypedValue<::mlir::TensorType>() : ::llvm::cast<::mlir::TypedValue<::mlir::TensorType>>(*results.begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::rock::ReduceMethodAttr getReduceMethodAttr() {
    return ::llvm::cast<::mlir::rock::ReduceMethodAttr>(getProperties().reduceMethod);
  }

  ::mlir::rock::ReduceMethod getReduceMethod();
  ::mlir::IntegerAttr getAxisAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().axis);
  }

  ::llvm::APInt getAxis();
  ::mlir::IntegerAttr getBlockSizeAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().blockSize);
  }

  uint32_t getBlockSize();
  ::mlir::IntegerAttr getGridSizeAttr() {
    return ::llvm::cast<::mlir::IntegerAttr>(getProperties().gridSize);
  }

  uint32_t getGridSize();
  ::mlir::UnitAttr getUseLDSAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().useLDS);
  }

  bool getUseLDS();
  ::mlir::UnitAttr getUseDPPAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().useDPP);
  }

  bool getUseDPP();
  void setReduceMethodAttr(::mlir::rock::ReduceMethodAttr attr) {
    getProperties().reduceMethod = attr;
  }

  void setReduceMethod(::mlir::rock::ReduceMethod attrValue);
  void setAxisAttr(::mlir::IntegerAttr attr) {
    getProperties().axis = attr;
  }

  void setAxis(::llvm::APInt attrValue);
  void setBlockSizeAttr(::mlir::IntegerAttr attr) {
    getProperties().blockSize = attr;
  }

  void setBlockSize(uint32_t attrValue);
  void setGridSizeAttr(::mlir::IntegerAttr attr) {
    getProperties().gridSize = attr;
  }

  void setGridSize(uint32_t attrValue);
  void setUseLDSAttr(::mlir::UnitAttr attr) {
    getProperties().useLDS = attr;
  }

  void setUseLDS(bool attrValue);
  void setUseDPPAttr(::mlir::UnitAttr attr) {
    getProperties().useDPP = attr;
  }

  void setUseDPP(bool attrValue);
  ::mlir::Attribute removeUseLDSAttr() {
      auto attr = getProperties().useLDS;
      getProperties().useLDS = {};
      return attr;
  }

  ::mlir::Attribute removeUseDPPAttr() {
      auto attr = getProperties().useDPP;
      getProperties().useDPP = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Type result, ::mlir::Value in, ::mlir::Value out, ::mlir::rock::ReduceMethodAttr reduceMethod, ::mlir::IntegerAttr axis, ::mlir::IntegerAttr blockSize, ::mlir::IntegerAttr gridSize, /*optional*/::mlir::UnitAttr useLDS = nullptr, /*optional*/::mlir::UnitAttr useDPP = nullptr);
  static ReduceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Type result, ::mlir::Value in, ::mlir::Value out, ::mlir::rock::ReduceMethodAttr reduceMethod, ::mlir::IntegerAttr axis, ::mlir::IntegerAttr blockSize, ::mlir::IntegerAttr gridSize, /*optional*/::mlir::UnitAttr useLDS = nullptr, /*optional*/::mlir::UnitAttr useDPP = nullptr);
  static ReduceOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Type result, ::mlir::Value in, ::mlir::Value out, ::mlir::rock::ReduceMethodAttr reduceMethod, ::mlir::IntegerAttr axis, ::mlir::IntegerAttr blockSize, ::mlir::IntegerAttr gridSize, /*optional*/::mlir::UnitAttr useLDS = nullptr, /*optional*/::mlir::UnitAttr useDPP = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::Value out, ::mlir::rock::ReduceMethodAttr reduceMethod, ::mlir::IntegerAttr axis, ::mlir::IntegerAttr blockSize, ::mlir::IntegerAttr gridSize, /*optional*/::mlir::UnitAttr useLDS = nullptr, /*optional*/::mlir::UnitAttr useDPP = nullptr);
  static ReduceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::Value out, ::mlir::rock::ReduceMethodAttr reduceMethod, ::mlir::IntegerAttr axis, ::mlir::IntegerAttr blockSize, ::mlir::IntegerAttr gridSize, /*optional*/::mlir::UnitAttr useLDS = nullptr, /*optional*/::mlir::UnitAttr useDPP = nullptr);
  static ReduceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::Value out, ::mlir::rock::ReduceMethodAttr reduceMethod, ::mlir::IntegerAttr axis, ::mlir::IntegerAttr blockSize, ::mlir::IntegerAttr gridSize, /*optional*/::mlir::UnitAttr useLDS = nullptr, /*optional*/::mlir::UnitAttr useDPP = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Type result, ::mlir::Value in, ::mlir::Value out, ::mlir::rock::ReduceMethod reduceMethod, ::llvm::APInt axis, uint32_t blockSize, uint32_t gridSize, /*optional*/bool useLDS = false, /*optional*/bool useDPP = false);
  static ReduceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Type result, ::mlir::Value in, ::mlir::Value out, ::mlir::rock::ReduceMethod reduceMethod, ::llvm::APInt axis, uint32_t blockSize, uint32_t gridSize, /*optional*/bool useLDS = false, /*optional*/bool useDPP = false);
  static ReduceOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Type result, ::mlir::Value in, ::mlir::Value out, ::mlir::rock::ReduceMethod reduceMethod, ::llvm::APInt axis, uint32_t blockSize, uint32_t gridSize, /*optional*/bool useLDS = false, /*optional*/bool useDPP = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::Value out, ::mlir::rock::ReduceMethod reduceMethod, ::llvm::APInt axis, uint32_t blockSize, uint32_t gridSize, /*optional*/bool useLDS = false, /*optional*/bool useDPP = false);
  static ReduceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::Value out, ::mlir::rock::ReduceMethod reduceMethod, ::llvm::APInt axis, uint32_t blockSize, uint32_t gridSize, /*optional*/bool useLDS = false, /*optional*/bool useDPP = false);
  static ReduceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value in, ::mlir::Value out, ::mlir::rock::ReduceMethod reduceMethod, ::llvm::APInt axis, uint32_t blockSize, uint32_t gridSize, /*optional*/bool useLDS = false, /*optional*/bool useDPP = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ReduceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ReduceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ReduceOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ReduceOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 6 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  ::mlir::OpOperand* getOutArgument() { return &(*this)->getOpOperand(1); }

  SmallVector<::mlir::Type> getTypesForFeature() {
    return {getIn().getType()};
  }
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::ReduceOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::StageOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class StageOpGenericAdaptorBase {
public:
  struct Properties {
    using nameTy = ::mlir::StringAttr;
    nameTy name;

    auto getName() const {
      auto &propStorage = this->name;
      return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(propStorage);
    }
    void setName(const ::mlir::StringAttr &propValue) {
      this->name = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.name == this->name &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  StageOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.stage", odsAttrs.getContext());
  }

  StageOpGenericAdaptorBase(StageOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::StringAttr getNameAttr();
  ::llvm::StringRef getName();
  ::mlir::Region &getRegion() {
    return *odsRegions[0];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};
} // namespace detail
template <typename RangeT>
class StageOpGenericAdaptor : public detail::StageOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::StageOpGenericAdaptorBase;
public:
  StageOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  StageOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : StageOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  StageOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : StageOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  StageOpGenericAdaptor(RangeT values, const StageOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = StageOp, typename = std::enable_if_t<std::is_same_v<LateInst, StageOp>>>
  StageOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class StageOpAdaptor : public StageOpGenericAdaptor<::mlir::ValueRange> {
public:
  using StageOpGenericAdaptor::StageOpGenericAdaptor;
  StageOpAdaptor(StageOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class StageOp : public ::mlir::Op<StageOp, ::mlir::OpTrait::OneRegion, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = StageOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = StageOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("name")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getNameAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getNameAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.stage");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Region &getRegion() {
    return (*this)->getRegion(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::StringAttr getNameAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::StringAttr>(getProperties().name);
  }

  ::llvm::StringRef getName();
  void setNameAttr(::mlir::StringAttr attr) {
    getProperties().name = attr;
  }

  void setName(::llvm::StringRef attrValue);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::StringAttr name);
  static StageOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::StringAttr name);
  static StageOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::StringAttr name);
  static StageOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::StringAttr name);
  static StageOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::StringAttr name);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::llvm::StringRef name = "stage");
  static StageOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::llvm::StringRef name = "stage");
  static StageOp create(::mlir::ImplicitLocOpBuilder &builder, ::llvm::StringRef name = "stage");
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::llvm::StringRef name = "stage");
  static StageOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::llvm::StringRef name = "stage");
  static StageOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::llvm::StringRef name = "stage");
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static StageOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static StageOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static StageOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static StageOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static void populateDefaultProperties(::mlir::OperationName opName, Properties &properties);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &p);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::StageOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::TensorUntransformCastOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class TensorUntransformCastOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  TensorUntransformCastOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.tensor_untransform_cast", odsAttrs.getContext());
  }

  TensorUntransformCastOpGenericAdaptorBase(TensorUntransformCastOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class TensorUntransformCastOpGenericAdaptor : public detail::TensorUntransformCastOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::TensorUntransformCastOpGenericAdaptorBase;
  static constexpr int odsIndex_transformedResult = 0;
  static constexpr int odsIndex_transformedArg = 1;
public:
  TensorUntransformCastOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  TensorUntransformCastOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : TensorUntransformCastOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  TensorUntransformCastOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : TensorUntransformCastOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  TensorUntransformCastOpGenericAdaptor(RangeT values, const TensorUntransformCastOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = TensorUntransformCastOp, typename = std::enable_if_t<std::is_same_v<LateInst, TensorUntransformCastOp>>>
  TensorUntransformCastOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getTransformedResult() {
    return (*getODSOperands(0).begin());
  }

  ValueT getTransformedArg() {
    return (*getODSOperands(1).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class TensorUntransformCastOpAdaptor : public TensorUntransformCastOpGenericAdaptor<::mlir::ValueRange> {
public:
  using TensorUntransformCastOpGenericAdaptor::TensorUntransformCastOpGenericAdaptor;
  TensorUntransformCastOpAdaptor(TensorUntransformCastOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class TensorUntransformCastOp : public ::mlir::Op<TensorUntransformCastOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::RankedTensorType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = TensorUntransformCastOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = TensorUntransformCastOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_transformedResult = 0;
  static constexpr int odsIndex_transformedArg = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.tensor_untransform_cast");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getTransformedResult() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getTransformedArg() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSOperands(1).begin());
  }

  ::mlir::OpOperand &getTransformedResultMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getTransformedArgMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::RankedTensorType> getUntransformed() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::RankedTensorType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type untransformed, ::mlir::Value transformedResult, ::mlir::Value transformedArg);
  static TensorUntransformCastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type untransformed, ::mlir::Value transformedResult, ::mlir::Value transformedArg);
  static TensorUntransformCastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type untransformed, ::mlir::Value transformedResult, ::mlir::Value transformedArg);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value transformedResult, ::mlir::Value transformedArg);
  static TensorUntransformCastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value transformedResult, ::mlir::Value transformedArg);
  static TensorUntransformCastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value transformedResult, ::mlir::Value transformedArg);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static TensorUntransformCastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static TensorUntransformCastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static TensorUntransformCastOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static TensorUntransformCastOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::TensorUntransformCastOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::ThreadwiseAccelGemmOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ThreadwiseAccelGemmOpGenericAdaptorBase {
public:
  struct Properties {
    using featuresTy = ::mlir::rock::GemmFeaturesAttr;
    featuresTy features;

    auto getFeatures() const {
      auto &propStorage = this->features;
      return ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(propStorage);
    }
    void setFeatures(const ::mlir::rock::GemmFeaturesAttr &propValue) {
      this->features = propValue;
    }
    using paramsTy = ::mlir::rock::RockAccelTuningParamAttrInterface;
    paramsTy params;

    auto getParams() const {
      auto &propStorage = this->params;
      return ::llvm::cast<::mlir::rock::RockAccelTuningParamAttrInterface>(propStorage);
    }
    void setParams(const ::mlir::rock::RockAccelTuningParamAttrInterface &propValue) {
      this->params = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.features == this->features &&
        rhs.params == this->params &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ThreadwiseAccelGemmOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.threadwise_accel_gemm", odsAttrs.getContext());
  }

  ThreadwiseAccelGemmOpGenericAdaptorBase(ThreadwiseAccelGemmOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::rock::GemmFeaturesAttr getFeaturesAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(getProperties().features);
    return attr;
  }

  ::std::optional<::mlir::rock::GemmFeatures> getFeatures();
  ::mlir::rock::RockAccelTuningParamAttrInterface getParamsAttr() {
    auto attr = ::llvm::cast<::mlir::rock::RockAccelTuningParamAttrInterface>(getProperties().params);
    return attr;
  }

  ::mlir::rock::RockAccelTuningParamAttrInterface getParams();
};
} // namespace detail
template <typename RangeT>
class ThreadwiseAccelGemmOpGenericAdaptor : public detail::ThreadwiseAccelGemmOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ThreadwiseAccelGemmOpGenericAdaptorBase;
  static constexpr int odsIndex_matrixA = 0;
  static constexpr int odsIndex_matrixB = 1;
  static constexpr int odsIndex_matrixC = 2;
  static constexpr int odsIndex_computeIndices = 3;
public:
  ThreadwiseAccelGemmOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ThreadwiseAccelGemmOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ThreadwiseAccelGemmOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ThreadwiseAccelGemmOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ThreadwiseAccelGemmOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ThreadwiseAccelGemmOpGenericAdaptor(RangeT values, const ThreadwiseAccelGemmOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ThreadwiseAccelGemmOp, typename = std::enable_if_t<std::is_same_v<LateInst, ThreadwiseAccelGemmOp>>>
  ThreadwiseAccelGemmOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getMatrixA() {
    return (*getODSOperands(0).begin());
  }

  ValueT getMatrixB() {
    return (*getODSOperands(1).begin());
  }

  ValueT getMatrixC() {
    return (*getODSOperands(2).begin());
  }

  RangeT getComputeIndices() {
    return getODSOperands(3);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ThreadwiseAccelGemmOpAdaptor : public ThreadwiseAccelGemmOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ThreadwiseAccelGemmOpGenericAdaptor::ThreadwiseAccelGemmOpGenericAdaptor;
  ThreadwiseAccelGemmOpAdaptor(ThreadwiseAccelGemmOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ThreadwiseAccelGemmOp : public ::mlir::Op<ThreadwiseAccelGemmOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::rock::RockGemmFeaturesInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ThreadwiseAccelGemmOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ThreadwiseAccelGemmOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_matrixA = 0;
  static constexpr int odsIndex_matrixB = 1;
  static constexpr int odsIndex_matrixC = 2;
  static constexpr int odsIndex_computeIndices = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("features"), ::llvm::StringRef("params")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getFeaturesAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getFeaturesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getParamsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getParamsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.threadwise_accel_gemm");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::MemRefType> getMatrixA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getMatrixB() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getMatrixC() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(2).begin());
  }

  ::mlir::Operation::operand_range getComputeIndices() {
    return getODSOperands(3);
  }

  ::mlir::OpOperand &getMatrixAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMatrixBMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMatrixCMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getComputeIndicesMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::rock::GemmFeaturesAttr getFeaturesAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::rock::GemmFeaturesAttr>(getProperties().features);
  }

  ::std::optional<::mlir::rock::GemmFeatures> getFeatures();
  ::mlir::rock::RockAccelTuningParamAttrInterface getParamsAttr() {
    return ::llvm::cast<::mlir::rock::RockAccelTuningParamAttrInterface>(getProperties().params);
  }

  ::mlir::rock::RockAccelTuningParamAttrInterface getParams();
  void setFeaturesAttr(::mlir::rock::GemmFeaturesAttr attr) {
    getProperties().features = attr;
  }

  void setFeatures(::std::optional<::mlir::rock::GemmFeatures> attrValue);
  void setParamsAttr(::mlir::rock::RockAccelTuningParamAttrInterface attr) {
    getProperties().params = attr;
  }

  ::mlir::Attribute removeFeaturesAttr() {
      auto attr = getProperties().features;
      getProperties().features = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value matrixA, ::mlir::Value matrixB, ::mlir::Value matrixC, ::mlir::ValueRange computeIndices, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::RockAccelTuningParamAttrInterface params);
  static ThreadwiseAccelGemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value matrixA, ::mlir::Value matrixB, ::mlir::Value matrixC, ::mlir::ValueRange computeIndices, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::RockAccelTuningParamAttrInterface params);
  static ThreadwiseAccelGemmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value matrixA, ::mlir::Value matrixB, ::mlir::Value matrixC, ::mlir::ValueRange computeIndices, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::RockAccelTuningParamAttrInterface params);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value matrixA, ::mlir::Value matrixB, ::mlir::Value matrixC, ::mlir::ValueRange computeIndices, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::RockAccelTuningParamAttrInterface params);
  static ThreadwiseAccelGemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value matrixA, ::mlir::Value matrixB, ::mlir::Value matrixC, ::mlir::ValueRange computeIndices, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::RockAccelTuningParamAttrInterface params);
  static ThreadwiseAccelGemmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value matrixA, ::mlir::Value matrixB, ::mlir::Value matrixC, ::mlir::ValueRange computeIndices, /*optional*/::mlir::rock::GemmFeaturesAttr features, ::mlir::rock::RockAccelTuningParamAttrInterface params);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ThreadwiseAccelGemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ThreadwiseAccelGemmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ThreadwiseAccelGemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ThreadwiseAccelGemmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  SmallVector<::mlir::Type> getTypesForFeature();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::ThreadwiseAccelGemmOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::ThreadwiseCopyOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ThreadwiseCopyOpGenericAdaptorBase {
public:
  struct Properties {
    using forceUnrollTy = ::mlir::UnitAttr;
    forceUnrollTy forceUnroll;

    auto getForceUnroll() const {
      auto &propStorage = this->forceUnroll;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setForceUnroll(const ::mlir::UnitAttr &propValue) {
      this->forceUnroll = propValue;
    }
    using useIndexDiffsTy = ::mlir::UnitAttr;
    useIndexDiffsTy useIndexDiffs;

    auto getUseIndexDiffs() const {
      auto &propStorage = this->useIndexDiffs;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setUseIndexDiffs(const ::mlir::UnitAttr &propValue) {
      this->useIndexDiffs = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.forceUnroll == this->forceUnroll &&
        rhs.useIndexDiffs == this->useIndexDiffs &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ThreadwiseCopyOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.threadwise_copy", odsAttrs.getContext());
  }

  ThreadwiseCopyOpGenericAdaptorBase(ThreadwiseCopyOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::UnitAttr getForceUnrollAttr();
  bool getForceUnroll();
  ::mlir::UnitAttr getUseIndexDiffsAttr();
  bool getUseIndexDiffs();
};
} // namespace detail
template <typename RangeT>
class ThreadwiseCopyOpGenericAdaptor : public detail::ThreadwiseCopyOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ThreadwiseCopyOpGenericAdaptorBase;
  static constexpr int odsIndex_source = 0;
  static constexpr int odsIndex_extraIndicesSource = 1;
  static constexpr int odsIndex_dest = 2;
  static constexpr int odsIndex_extraIndicesDest = 3;
public:
  ThreadwiseCopyOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ThreadwiseCopyOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ThreadwiseCopyOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ThreadwiseCopyOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : ThreadwiseCopyOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ThreadwiseCopyOpGenericAdaptor(RangeT values, const ThreadwiseCopyOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ThreadwiseCopyOp, typename = std::enable_if_t<std::is_same_v<LateInst, ThreadwiseCopyOp>>>
  ThreadwiseCopyOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSource() {
    return (*getODSOperands(0).begin());
  }

  RangeT getExtraIndicesSource() {
    return getODSOperands(1);
  }

  ValueT getDest() {
    return (*getODSOperands(2).begin());
  }

  RangeT getExtraIndicesDest() {
    return getODSOperands(3);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ThreadwiseCopyOpAdaptor : public ThreadwiseCopyOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ThreadwiseCopyOpGenericAdaptor::ThreadwiseCopyOpGenericAdaptor;
  ThreadwiseCopyOpAdaptor(ThreadwiseCopyOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ThreadwiseCopyOp : public ::mlir::Op<ThreadwiseCopyOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<2>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::rock::RockAcceptingViewOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ThreadwiseCopyOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ThreadwiseCopyOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_source = 0;
  static constexpr int odsIndex_extraIndicesSource = 1;
  static constexpr int odsIndex_dest = 2;
  static constexpr int odsIndex_extraIndicesDest = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("forceUnroll"), ::llvm::StringRef("useIndexDiffs"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getForceUnrollAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getForceUnrollAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getUseIndexDiffsAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getUseIndexDiffsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.threadwise_copy");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::MemRefType> getSource() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(0).begin());
  }

  ::mlir::Operation::operand_range getExtraIndicesSource() {
    return getODSOperands(1);
  }

  ::mlir::TypedValue<::mlir::MemRefType> getDest() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(2).begin());
  }

  ::mlir::Operation::operand_range getExtraIndicesDest() {
    return getODSOperands(3);
  }

  ::mlir::OpOperand &getSourceMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getExtraIndicesSourceMutable();
  ::mlir::OpOperand &getDestMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getExtraIndicesDestMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::UnitAttr getForceUnrollAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().forceUnroll);
  }

  bool getForceUnroll();
  ::mlir::UnitAttr getUseIndexDiffsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().useIndexDiffs);
  }

  bool getUseIndexDiffs();
  void setForceUnrollAttr(::mlir::UnitAttr attr) {
    getProperties().forceUnroll = attr;
  }

  void setForceUnroll(bool attrValue);
  void setUseIndexDiffsAttr(::mlir::UnitAttr attr) {
    getProperties().useIndexDiffs = attr;
  }

  void setUseIndexDiffs(bool attrValue);
  ::mlir::Attribute removeForceUnrollAttr() {
      auto attr = getProperties().forceUnroll;
      getProperties().forceUnroll = {};
      return attr;
  }

  ::mlir::Attribute removeUseIndexDiffsAttr() {
      auto attr = getProperties().useIndexDiffs;
      getProperties().useIndexDiffs = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value source, Value dest, bool forceUnroll = false, bool useIndexDiffs = false);
  static ThreadwiseCopyOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Value source, Value dest, bool forceUnroll = false, bool useIndexDiffs = false);
  static ThreadwiseCopyOp create(::mlir::ImplicitLocOpBuilder &builder, Value source, Value dest, bool forceUnroll = false, bool useIndexDiffs = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value source, ::mlir::ValueRange extraIndicesSource, ::mlir::Value dest, ::mlir::ValueRange extraIndicesDest, /*optional*/::mlir::UnitAttr forceUnroll, /*optional*/::mlir::UnitAttr useIndexDiffs = nullptr);
  static ThreadwiseCopyOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value source, ::mlir::ValueRange extraIndicesSource, ::mlir::Value dest, ::mlir::ValueRange extraIndicesDest, /*optional*/::mlir::UnitAttr forceUnroll, /*optional*/::mlir::UnitAttr useIndexDiffs = nullptr);
  static ThreadwiseCopyOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value source, ::mlir::ValueRange extraIndicesSource, ::mlir::Value dest, ::mlir::ValueRange extraIndicesDest, /*optional*/::mlir::UnitAttr forceUnroll, /*optional*/::mlir::UnitAttr useIndexDiffs = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::ValueRange extraIndicesSource, ::mlir::Value dest, ::mlir::ValueRange extraIndicesDest, /*optional*/::mlir::UnitAttr forceUnroll, /*optional*/::mlir::UnitAttr useIndexDiffs = nullptr);
  static ThreadwiseCopyOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::ValueRange extraIndicesSource, ::mlir::Value dest, ::mlir::ValueRange extraIndicesDest, /*optional*/::mlir::UnitAttr forceUnroll, /*optional*/::mlir::UnitAttr useIndexDiffs = nullptr);
  static ThreadwiseCopyOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::ValueRange extraIndicesSource, ::mlir::Value dest, ::mlir::ValueRange extraIndicesDest, /*optional*/::mlir::UnitAttr forceUnroll, /*optional*/::mlir::UnitAttr useIndexDiffs = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value source, ::mlir::ValueRange extraIndicesSource, ::mlir::Value dest, ::mlir::ValueRange extraIndicesDest, /*optional*/bool forceUnroll = false, /*optional*/bool useIndexDiffs = false);
  static ThreadwiseCopyOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value source, ::mlir::ValueRange extraIndicesSource, ::mlir::Value dest, ::mlir::ValueRange extraIndicesDest, /*optional*/bool forceUnroll = false, /*optional*/bool useIndexDiffs = false);
  static ThreadwiseCopyOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value source, ::mlir::ValueRange extraIndicesSource, ::mlir::Value dest, ::mlir::ValueRange extraIndicesDest, /*optional*/bool forceUnroll = false, /*optional*/bool useIndexDiffs = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::ValueRange extraIndicesSource, ::mlir::Value dest, ::mlir::ValueRange extraIndicesDest, /*optional*/bool forceUnroll = false, /*optional*/bool useIndexDiffs = false);
  static ThreadwiseCopyOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::ValueRange extraIndicesSource, ::mlir::Value dest, ::mlir::ValueRange extraIndicesDest, /*optional*/bool forceUnroll = false, /*optional*/bool useIndexDiffs = false);
  static ThreadwiseCopyOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::ValueRange extraIndicesSource, ::mlir::Value dest, ::mlir::ValueRange extraIndicesDest, /*optional*/bool forceUnroll = false, /*optional*/bool useIndexDiffs = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ThreadwiseCopyOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ThreadwiseCopyOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ThreadwiseCopyOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ThreadwiseCopyOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  Operation *cloneWithExtraIndices(OpBuilder&  builder, OpOperand&operand, Value view, ArrayRef<Value> newExtraIndices);
  std::optional<OperandRange> getExtraIndices(OpOperand&operand);
  llvm::SmallPtrSet<OpOperand*, 2> getAcceptingViewOperands();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 2 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::ThreadwiseCopyOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::ThreadwiseGemmOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ThreadwiseGemmOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ThreadwiseGemmOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.threadwise_gemm", odsAttrs.getContext());
  }

  ThreadwiseGemmOpGenericAdaptorBase(ThreadwiseGemmOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class ThreadwiseGemmOpGenericAdaptor : public detail::ThreadwiseGemmOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ThreadwiseGemmOpGenericAdaptorBase;
  static constexpr int odsIndex_matrixA = 0;
  static constexpr int odsIndex_matrixB = 1;
  static constexpr int odsIndex_matrixC = 2;
public:
  ThreadwiseGemmOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ThreadwiseGemmOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ThreadwiseGemmOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ThreadwiseGemmOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ThreadwiseGemmOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ThreadwiseGemmOpGenericAdaptor(RangeT values, const ThreadwiseGemmOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ThreadwiseGemmOp, typename = std::enable_if_t<std::is_same_v<LateInst, ThreadwiseGemmOp>>>
  ThreadwiseGemmOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getMatrixA() {
    return (*getODSOperands(0).begin());
  }

  ValueT getMatrixB() {
    return (*getODSOperands(1).begin());
  }

  ValueT getMatrixC() {
    return (*getODSOperands(2).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ThreadwiseGemmOpAdaptor : public ThreadwiseGemmOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ThreadwiseGemmOpGenericAdaptor::ThreadwiseGemmOpGenericAdaptor;
  ThreadwiseGemmOpAdaptor(ThreadwiseGemmOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ThreadwiseGemmOp : public ::mlir::Op<ThreadwiseGemmOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::NOperands<3>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ThreadwiseGemmOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ThreadwiseGemmOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_matrixA = 0;
  static constexpr int odsIndex_matrixB = 1;
  static constexpr int odsIndex_matrixC = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.threadwise_gemm");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::MemRefType> getMatrixA() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getMatrixB() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(1).begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getMatrixC() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(2).begin());
  }

  ::mlir::OpOperand &getMatrixAMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMatrixBMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getMatrixCMutable() {
    auto range = getODSOperandIndexAndLength(2);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value matrixA, ::mlir::Value matrixB, ::mlir::Value matrixC);
  static ThreadwiseGemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value matrixA, ::mlir::Value matrixB, ::mlir::Value matrixC);
  static ThreadwiseGemmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value matrixA, ::mlir::Value matrixB, ::mlir::Value matrixC);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value matrixA, ::mlir::Value matrixB, ::mlir::Value matrixC);
  static ThreadwiseGemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value matrixA, ::mlir::Value matrixB, ::mlir::Value matrixC);
  static ThreadwiseGemmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value matrixA, ::mlir::Value matrixB, ::mlir::Value matrixC);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ThreadwiseGemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ThreadwiseGemmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ThreadwiseGemmOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ThreadwiseGemmOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::ThreadwiseGemmOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::ThreadwiseReadIntoOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ThreadwiseReadIntoOpGenericAdaptorBase {
public:
  struct Properties {
    using extraViewsTy = ::mlir::ArrayAttr;
    extraViewsTy extraViews;

    auto getExtraViews() const {
      auto &propStorage = this->extraViews;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setExtraViews(const ::mlir::ArrayAttr &propValue) {
      this->extraViews = propValue;
    }
    using forceUnrollTy = ::mlir::UnitAttr;
    forceUnrollTy forceUnroll;

    auto getForceUnroll() const {
      auto &propStorage = this->forceUnroll;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setForceUnroll(const ::mlir::UnitAttr &propValue) {
      this->forceUnroll = propValue;
    }
    using useIndexDiffsTy = ::mlir::UnitAttr;
    useIndexDiffsTy useIndexDiffs;

    auto getUseIndexDiffs() const {
      auto &propStorage = this->useIndexDiffs;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setUseIndexDiffs(const ::mlir::UnitAttr &propValue) {
      this->useIndexDiffs = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 4>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.extraViews == this->extraViews &&
        rhs.forceUnroll == this->forceUnroll &&
        rhs.useIndexDiffs == this->useIndexDiffs &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ThreadwiseReadIntoOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.threadwise_read_into", odsAttrs.getContext());
  }

  ThreadwiseReadIntoOpGenericAdaptorBase(ThreadwiseReadIntoOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ArrayAttr getExtraViewsAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().extraViews);
    return attr;
  }

  ::mlir::ArrayAttr getExtraViews();
  ::mlir::UnitAttr getForceUnrollAttr();
  bool getForceUnroll();
  ::mlir::UnitAttr getUseIndexDiffsAttr();
  bool getUseIndexDiffs();
};
} // namespace detail
template <typename RangeT>
class ThreadwiseReadIntoOpGenericAdaptor : public detail::ThreadwiseReadIntoOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ThreadwiseReadIntoOpGenericAdaptorBase;
  static constexpr int odsIndex_source = 0;
  static constexpr int odsIndex_dest = 1;
  static constexpr int odsIndex_dynamicValidities = 2;
  static constexpr int odsIndex_extraIndices = 3;
public:
  ThreadwiseReadIntoOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ThreadwiseReadIntoOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ThreadwiseReadIntoOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ThreadwiseReadIntoOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : ThreadwiseReadIntoOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ThreadwiseReadIntoOpGenericAdaptor(RangeT values, const ThreadwiseReadIntoOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ThreadwiseReadIntoOp, typename = std::enable_if_t<std::is_same_v<LateInst, ThreadwiseReadIntoOp>>>
  ThreadwiseReadIntoOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSource() {
    return (*getODSOperands(0).begin());
  }

  ValueT getDest() {
    return (*getODSOperands(1).begin());
  }

  RangeT getDynamicValidities() {
    return getODSOperands(2);
  }

  RangeT getExtraIndices() {
    return getODSOperands(3);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ThreadwiseReadIntoOpAdaptor : public ThreadwiseReadIntoOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ThreadwiseReadIntoOpGenericAdaptor::ThreadwiseReadIntoOpGenericAdaptor;
  ThreadwiseReadIntoOpAdaptor(ThreadwiseReadIntoOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ThreadwiseReadIntoOp : public ::mlir::Op<ThreadwiseReadIntoOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<2>::Impl, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::rock::RockAcceptingViewOpInterface::Trait, ::mlir::rock::RockWriterOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ThreadwiseReadIntoOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ThreadwiseReadIntoOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_source = 0;
  static constexpr int odsIndex_dest = 1;
  static constexpr int odsIndex_dynamicValidities = 2;
  static constexpr int odsIndex_extraIndices = 3;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("extraViews"), ::llvm::StringRef("forceUnroll"), ::llvm::StringRef("useIndexDiffs"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getExtraViewsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getExtraViewsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getForceUnrollAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getForceUnrollAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getUseIndexDiffsAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getUseIndexDiffsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.threadwise_read_into");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::MemRefType> getSource() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getDest() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(1).begin());
  }

  ::mlir::Operation::operand_range getDynamicValidities() {
    return getODSOperands(2);
  }

  ::mlir::Operation::operand_range getExtraIndices() {
    return getODSOperands(3);
  }

  ::mlir::OpOperand &getSourceMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getDestMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getDynamicValiditiesMutable();
  ::mlir::MutableOperandRange getExtraIndicesMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::VectorType> getValidityRecord() {
    auto results = getODSResults(0);
    return results.empty() ? ::mlir::TypedValue<::mlir::VectorType>() : ::llvm::cast<::mlir::TypedValue<::mlir::VectorType>>(*results.begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ArrayAttr getExtraViewsAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().extraViews);
  }

  ::mlir::ArrayAttr getExtraViews();
  ::mlir::UnitAttr getForceUnrollAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().forceUnroll);
  }

  bool getForceUnroll();
  ::mlir::UnitAttr getUseIndexDiffsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().useIndexDiffs);
  }

  bool getUseIndexDiffs();
  void setExtraViewsAttr(::mlir::ArrayAttr attr) {
    getProperties().extraViews = attr;
  }

  void setForceUnrollAttr(::mlir::UnitAttr attr) {
    getProperties().forceUnroll = attr;
  }

  void setForceUnroll(bool attrValue);
  void setUseIndexDiffsAttr(::mlir::UnitAttr attr) {
    getProperties().useIndexDiffs = attr;
  }

  void setUseIndexDiffs(bool attrValue);
  ::mlir::Attribute removeForceUnrollAttr() {
      auto attr = getProperties().forceUnroll;
      getProperties().forceUnroll = {};
      return attr;
  }

  ::mlir::Attribute removeUseIndexDiffsAttr() {
      auto attr = getProperties().useIndexDiffs;
      getProperties().useIndexDiffs = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value source, Value dest, ArrayAttr extraViews, ValueRange extraIndices, bool forceUnroll, bool useIndexDiffs);
  static ThreadwiseReadIntoOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Value source, Value dest, ArrayAttr extraViews, ValueRange extraIndices, bool forceUnroll, bool useIndexDiffs);
  static ThreadwiseReadIntoOp create(::mlir::ImplicitLocOpBuilder &builder, Value source, Value dest, ArrayAttr extraViews, ValueRange extraIndices, bool forceUnroll, bool useIndexDiffs);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Type validityRecord, ::mlir::Value source, ::mlir::Value dest, ::mlir::ValueRange dynamicValidities, ::mlir::ArrayAttr extraViews, ::mlir::ValueRange extraIndices, /*optional*/::mlir::UnitAttr forceUnroll, /*optional*/::mlir::UnitAttr useIndexDiffs = nullptr);
  static ThreadwiseReadIntoOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Type validityRecord, ::mlir::Value source, ::mlir::Value dest, ::mlir::ValueRange dynamicValidities, ::mlir::ArrayAttr extraViews, ::mlir::ValueRange extraIndices, /*optional*/::mlir::UnitAttr forceUnroll, /*optional*/::mlir::UnitAttr useIndexDiffs = nullptr);
  static ThreadwiseReadIntoOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Type validityRecord, ::mlir::Value source, ::mlir::Value dest, ::mlir::ValueRange dynamicValidities, ::mlir::ArrayAttr extraViews, ::mlir::ValueRange extraIndices, /*optional*/::mlir::UnitAttr forceUnroll, /*optional*/::mlir::UnitAttr useIndexDiffs = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value dest, ::mlir::ValueRange dynamicValidities, ::mlir::ArrayAttr extraViews, ::mlir::ValueRange extraIndices, /*optional*/::mlir::UnitAttr forceUnroll, /*optional*/::mlir::UnitAttr useIndexDiffs = nullptr);
  static ThreadwiseReadIntoOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value dest, ::mlir::ValueRange dynamicValidities, ::mlir::ArrayAttr extraViews, ::mlir::ValueRange extraIndices, /*optional*/::mlir::UnitAttr forceUnroll, /*optional*/::mlir::UnitAttr useIndexDiffs = nullptr);
  static ThreadwiseReadIntoOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value dest, ::mlir::ValueRange dynamicValidities, ::mlir::ArrayAttr extraViews, ::mlir::ValueRange extraIndices, /*optional*/::mlir::UnitAttr forceUnroll, /*optional*/::mlir::UnitAttr useIndexDiffs = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, /*optional*/::mlir::Type validityRecord, ::mlir::Value source, ::mlir::Value dest, ::mlir::ValueRange dynamicValidities, ::mlir::ArrayAttr extraViews, ::mlir::ValueRange extraIndices, /*optional*/bool forceUnroll = false, /*optional*/bool useIndexDiffs = false);
  static ThreadwiseReadIntoOp create(::mlir::OpBuilder &builder, ::mlir::Location location, /*optional*/::mlir::Type validityRecord, ::mlir::Value source, ::mlir::Value dest, ::mlir::ValueRange dynamicValidities, ::mlir::ArrayAttr extraViews, ::mlir::ValueRange extraIndices, /*optional*/bool forceUnroll = false, /*optional*/bool useIndexDiffs = false);
  static ThreadwiseReadIntoOp create(::mlir::ImplicitLocOpBuilder &builder, /*optional*/::mlir::Type validityRecord, ::mlir::Value source, ::mlir::Value dest, ::mlir::ValueRange dynamicValidities, ::mlir::ArrayAttr extraViews, ::mlir::ValueRange extraIndices, /*optional*/bool forceUnroll = false, /*optional*/bool useIndexDiffs = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value dest, ::mlir::ValueRange dynamicValidities, ::mlir::ArrayAttr extraViews, ::mlir::ValueRange extraIndices, /*optional*/bool forceUnroll = false, /*optional*/bool useIndexDiffs = false);
  static ThreadwiseReadIntoOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value dest, ::mlir::ValueRange dynamicValidities, ::mlir::ArrayAttr extraViews, ::mlir::ValueRange extraIndices, /*optional*/bool forceUnroll = false, /*optional*/bool useIndexDiffs = false);
  static ThreadwiseReadIntoOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value dest, ::mlir::ValueRange dynamicValidities, ::mlir::ArrayAttr extraViews, ::mlir::ValueRange extraIndices, /*optional*/bool forceUnroll = false, /*optional*/bool useIndexDiffs = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ThreadwiseReadIntoOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ThreadwiseReadIntoOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ThreadwiseReadIntoOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ThreadwiseReadIntoOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  Operation *cloneWithExtraIndices(OpBuilder&  builder, OpOperand&operand, Value view, ArrayRef<Value> newExtraIndices);
  std::optional<OperandRange> getExtraIndices(OpOperand&operand);
  llvm::SmallPtrSet<OpOperand*, 2> getAcceptingViewOperands();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 3 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::ThreadwiseReadIntoOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::ThreadwiseWriteAllOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class ThreadwiseWriteAllOpGenericAdaptorBase {
public:
  struct Properties {
    using extraViewsTy = ::mlir::ArrayAttr;
    extraViewsTy extraViews;

    auto getExtraViews() const {
      auto &propStorage = this->extraViews;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setExtraViews(const ::mlir::ArrayAttr &propValue) {
      this->extraViews = propValue;
    }
    using forceUnrollTy = ::mlir::UnitAttr;
    forceUnrollTy forceUnroll;

    auto getForceUnroll() const {
      auto &propStorage = this->forceUnroll;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setForceUnroll(const ::mlir::UnitAttr &propValue) {
      this->forceUnroll = propValue;
    }
    using storeMethodTy = ::mlir::rock::StoreMethodAttr;
    storeMethodTy storeMethod;

    auto getStoreMethod() const {
      auto &propStorage = this->storeMethod;
      return ::llvm::cast<::mlir::rock::StoreMethodAttr>(propStorage);
    }
    void setStoreMethod(const ::mlir::rock::StoreMethodAttr &propValue) {
      this->storeMethod = propValue;
    }
    using useIndexDiffsTy = ::mlir::UnitAttr;
    useIndexDiffsTy useIndexDiffs;

    auto getUseIndexDiffs() const {
      auto &propStorage = this->useIndexDiffs;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setUseIndexDiffs(const ::mlir::UnitAttr &propValue) {
      this->useIndexDiffs = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.extraViews == this->extraViews &&
        rhs.forceUnroll == this->forceUnroll &&
        rhs.storeMethod == this->storeMethod &&
        rhs.useIndexDiffs == this->useIndexDiffs &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  ThreadwiseWriteAllOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.threadwise_write_all", odsAttrs.getContext());
  }

  ThreadwiseWriteAllOpGenericAdaptorBase(ThreadwiseWriteAllOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ArrayAttr getExtraViewsAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().extraViews);
    return attr;
  }

  ::mlir::ArrayAttr getExtraViews();
  ::mlir::rock::StoreMethodAttr getStoreMethodAttr() {
    auto attr = ::llvm::cast<::mlir::rock::StoreMethodAttr>(getProperties().storeMethod);
    return attr;
  }

  ::mlir::rock::StoreMethod getStoreMethod();
  ::mlir::UnitAttr getForceUnrollAttr();
  bool getForceUnroll();
  ::mlir::UnitAttr getUseIndexDiffsAttr();
  bool getUseIndexDiffs();
};
} // namespace detail
template <typename RangeT>
class ThreadwiseWriteAllOpGenericAdaptor : public detail::ThreadwiseWriteAllOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::ThreadwiseWriteAllOpGenericAdaptorBase;
  static constexpr int odsIndex_source = 0;
  static constexpr int odsIndex_dest = 1;
  static constexpr int odsIndex_extraIndices = 2;
public:
  ThreadwiseWriteAllOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  ThreadwiseWriteAllOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : ThreadwiseWriteAllOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  ThreadwiseWriteAllOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : ThreadwiseWriteAllOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  ThreadwiseWriteAllOpGenericAdaptor(RangeT values, const ThreadwiseWriteAllOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = ThreadwiseWriteAllOp, typename = std::enable_if_t<std::is_same_v<LateInst, ThreadwiseWriteAllOp>>>
  ThreadwiseWriteAllOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getSource() {
    return (*getODSOperands(0).begin());
  }

  ValueT getDest() {
    return (*getODSOperands(1).begin());
  }

  RangeT getExtraIndices() {
    return getODSOperands(2);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class ThreadwiseWriteAllOpAdaptor : public ThreadwiseWriteAllOpGenericAdaptor<::mlir::ValueRange> {
public:
  using ThreadwiseWriteAllOpGenericAdaptor::ThreadwiseWriteAllOpGenericAdaptor;
  ThreadwiseWriteAllOpAdaptor(ThreadwiseWriteAllOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class ThreadwiseWriteAllOp : public ::mlir::Op<ThreadwiseWriteAllOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::AtLeastNOperands<2>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::rock::RockAcceptingViewOpInterface::Trait, ::mlir::rock::RockWriterOpInterface::Trait, ::mlir::MemoryEffectOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = ThreadwiseWriteAllOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = ThreadwiseWriteAllOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_source = 0;
  static constexpr int odsIndex_dest = 1;
  static constexpr int odsIndex_extraIndices = 2;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("extraViews"), ::llvm::StringRef("forceUnroll"), ::llvm::StringRef("storeMethod"), ::llvm::StringRef("useIndexDiffs")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getExtraViewsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getExtraViewsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getForceUnrollAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getForceUnrollAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getStoreMethodAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getStoreMethodAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getUseIndexDiffsAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getUseIndexDiffsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.threadwise_write_all");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::MemRefType> getSource() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(0).begin());
  }

  ::mlir::TypedValue<::mlir::MemRefType> getDest() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::MemRefType>>(*getODSOperands(1).begin());
  }

  ::mlir::Operation::operand_range getExtraIndices() {
    return getODSOperands(2);
  }

  ::mlir::OpOperand &getSourceMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::OpOperand &getDestMutable() {
    auto range = getODSOperandIndexAndLength(1);
    return getOperation()->getOpOperand(range.first);
  }

  ::mlir::MutableOperandRange getExtraIndicesMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ArrayAttr getExtraViewsAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().extraViews);
  }

  ::mlir::ArrayAttr getExtraViews();
  ::mlir::rock::StoreMethodAttr getStoreMethodAttr() {
    return ::llvm::cast<::mlir::rock::StoreMethodAttr>(getProperties().storeMethod);
  }

  ::mlir::rock::StoreMethod getStoreMethod();
  ::mlir::UnitAttr getForceUnrollAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().forceUnroll);
  }

  bool getForceUnroll();
  ::mlir::UnitAttr getUseIndexDiffsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().useIndexDiffs);
  }

  bool getUseIndexDiffs();
  void setExtraViewsAttr(::mlir::ArrayAttr attr) {
    getProperties().extraViews = attr;
  }

  void setStoreMethodAttr(::mlir::rock::StoreMethodAttr attr) {
    getProperties().storeMethod = attr;
  }

  void setStoreMethod(::mlir::rock::StoreMethod attrValue);
  void setForceUnrollAttr(::mlir::UnitAttr attr) {
    getProperties().forceUnroll = attr;
  }

  void setForceUnroll(bool attrValue);
  void setUseIndexDiffsAttr(::mlir::UnitAttr attr) {
    getProperties().useIndexDiffs = attr;
  }

  void setUseIndexDiffs(bool attrValue);
  ::mlir::Attribute removeForceUnrollAttr() {
      auto attr = getProperties().forceUnroll;
      getProperties().forceUnroll = {};
      return attr;
  }

  ::mlir::Attribute removeUseIndexDiffsAttr() {
      auto attr = getProperties().useIndexDiffs;
      getProperties().useIndexDiffs = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value source, ::mlir::Value dest, ::mlir::ArrayAttr extraViews, ::mlir::ValueRange extraIndices, ::mlir::rock::StoreMethodAttr storeMethod, /*optional*/::mlir::UnitAttr forceUnroll = nullptr, /*optional*/::mlir::UnitAttr useIndexDiffs = nullptr);
  static ThreadwiseWriteAllOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value source, ::mlir::Value dest, ::mlir::ArrayAttr extraViews, ::mlir::ValueRange extraIndices, ::mlir::rock::StoreMethodAttr storeMethod, /*optional*/::mlir::UnitAttr forceUnroll = nullptr, /*optional*/::mlir::UnitAttr useIndexDiffs = nullptr);
  static ThreadwiseWriteAllOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value source, ::mlir::Value dest, ::mlir::ArrayAttr extraViews, ::mlir::ValueRange extraIndices, ::mlir::rock::StoreMethodAttr storeMethod, /*optional*/::mlir::UnitAttr forceUnroll = nullptr, /*optional*/::mlir::UnitAttr useIndexDiffs = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value dest, ::mlir::ArrayAttr extraViews, ::mlir::ValueRange extraIndices, ::mlir::rock::StoreMethodAttr storeMethod, /*optional*/::mlir::UnitAttr forceUnroll = nullptr, /*optional*/::mlir::UnitAttr useIndexDiffs = nullptr);
  static ThreadwiseWriteAllOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value dest, ::mlir::ArrayAttr extraViews, ::mlir::ValueRange extraIndices, ::mlir::rock::StoreMethodAttr storeMethod, /*optional*/::mlir::UnitAttr forceUnroll = nullptr, /*optional*/::mlir::UnitAttr useIndexDiffs = nullptr);
  static ThreadwiseWriteAllOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value dest, ::mlir::ArrayAttr extraViews, ::mlir::ValueRange extraIndices, ::mlir::rock::StoreMethodAttr storeMethod, /*optional*/::mlir::UnitAttr forceUnroll = nullptr, /*optional*/::mlir::UnitAttr useIndexDiffs = nullptr);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Value source, ::mlir::Value dest, ::mlir::ArrayAttr extraViews, ::mlir::ValueRange extraIndices, ::mlir::rock::StoreMethod storeMethod, /*optional*/bool forceUnroll = false, /*optional*/bool useIndexDiffs = false);
  static ThreadwiseWriteAllOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Value source, ::mlir::Value dest, ::mlir::ArrayAttr extraViews, ::mlir::ValueRange extraIndices, ::mlir::rock::StoreMethod storeMethod, /*optional*/bool forceUnroll = false, /*optional*/bool useIndexDiffs = false);
  static ThreadwiseWriteAllOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Value source, ::mlir::Value dest, ::mlir::ArrayAttr extraViews, ::mlir::ValueRange extraIndices, ::mlir::rock::StoreMethod storeMethod, /*optional*/bool forceUnroll = false, /*optional*/bool useIndexDiffs = false);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value dest, ::mlir::ArrayAttr extraViews, ::mlir::ValueRange extraIndices, ::mlir::rock::StoreMethod storeMethod, /*optional*/bool forceUnroll = false, /*optional*/bool useIndexDiffs = false);
  static ThreadwiseWriteAllOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value dest, ::mlir::ArrayAttr extraViews, ::mlir::ValueRange extraIndices, ::mlir::rock::StoreMethod storeMethod, /*optional*/bool forceUnroll = false, /*optional*/bool useIndexDiffs = false);
  static ThreadwiseWriteAllOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value source, ::mlir::Value dest, ::mlir::ArrayAttr extraViews, ::mlir::ValueRange extraIndices, ::mlir::rock::StoreMethod storeMethod, /*optional*/bool forceUnroll = false, /*optional*/bool useIndexDiffs = false);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ThreadwiseWriteAllOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static ThreadwiseWriteAllOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ThreadwiseWriteAllOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static ThreadwiseWriteAllOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  Operation *cloneWithExtraIndices(OpBuilder&  builder, OpOperand&operand, Value view, ArrayRef<Value> newExtraIndices);
  std::optional<OperandRange> getExtraIndices(OpOperand&operand);
  llvm::SmallPtrSet<OpOperand*, 2> getAcceptingViewOperands();
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 4 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::ThreadwiseWriteAllOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::TransformOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class TransformOpGenericAdaptorBase {
public:
  struct Properties {
    using transformTy = ::mlir::rock::TransformMapAttr;
    transformTy transform;

    auto getTransform() const {
      auto &propStorage = this->transform;
      return ::llvm::cast<::mlir::rock::TransformMapAttr>(propStorage);
    }
    void setTransform(const ::mlir::rock::TransformMapAttr &propValue) {
      this->transform = propValue;
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.transform == this->transform &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  TransformOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.transform", odsAttrs.getContext());
  }

  TransformOpGenericAdaptorBase(TransformOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::rock::TransformMapAttr getTransformAttr() {
    auto attr = ::llvm::cast<::mlir::rock::TransformMapAttr>(getProperties().transform);
    return attr;
  }

  ::mlir::rock::TransformMapAttr getTransform();
};
} // namespace detail
template <typename RangeT>
class TransformOpGenericAdaptor : public detail::TransformOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::TransformOpGenericAdaptorBase;
  static constexpr int odsIndex_input = 0;
public:
  TransformOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  TransformOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : TransformOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  TransformOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : TransformOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  TransformOpGenericAdaptor(RangeT values, const TransformOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = TransformOp, typename = std::enable_if_t<std::is_same_v<LateInst, TransformOp>>>
  TransformOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  ValueT getInput() {
    return (*getODSOperands(0).begin());
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class TransformOpAdaptor : public TransformOpGenericAdaptor<::mlir::ValueRange> {
public:
  using TransformOpGenericAdaptor::TransformOpGenericAdaptor;
  TransformOpAdaptor(TransformOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class TransformOp : public ::mlir::Op<TransformOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::ShapedType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::OneOperand, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::ViewLikeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = TransformOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = TransformOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_input = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("transform")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getTransformAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getTransformAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.transform");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::ShapedType> getInput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*getODSOperands(0).begin());
  }

  ::mlir::OpOperand &getInputMutable() {
    auto range = getODSOperandIndexAndLength(0);
    return getOperation()->getOpOperand(range.first);
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::ShapedType> getOutput() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::ShapedType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::rock::TransformMapAttr getTransformAttr() {
    return ::llvm::cast<::mlir::rock::TransformMapAttr>(getProperties().transform);
  }

  ::mlir::rock::TransformMapAttr getTransform();
  void setTransformAttr(::mlir::rock::TransformMapAttr attr) {
    getProperties().transform = attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, Value input, TransformMapAttr transform);
  static TransformOp create(::mlir::OpBuilder &builder, ::mlir::Location location, Value input, TransformMapAttr transform);
  static TransformOp create(::mlir::ImplicitLocOpBuilder &builder, Value input, TransformMapAttr transform);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type output, ::mlir::Value input, ::mlir::rock::TransformMapAttr transform);
  static TransformOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type output, ::mlir::Value input, ::mlir::rock::TransformMapAttr transform);
  static TransformOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type output, ::mlir::Value input, ::mlir::rock::TransformMapAttr transform);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::rock::TransformMapAttr transform);
  static TransformOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::rock::TransformMapAttr transform);
  static TransformOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::Value input, ::mlir::rock::TransformMapAttr transform);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static TransformOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static TransformOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static TransformOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static TransformOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 1 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  Value getViewSource() { return getInput(); }
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::TransformOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::TransformingForOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class TransformingForOpGenericAdaptorBase {
public:
  struct Properties {
    using boundsTy = ::mlir::ArrayAttr;
    boundsTy bounds;

    auto getBounds() const {
      auto &propStorage = this->bounds;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setBounds(const ::mlir::ArrayAttr &propValue) {
      this->bounds = propValue;
    }
    using forceUnrollTy = ::mlir::UnitAttr;
    forceUnrollTy forceUnroll;

    auto getForceUnroll() const {
      auto &propStorage = this->forceUnroll;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setForceUnroll(const ::mlir::UnitAttr &propValue) {
      this->forceUnroll = propValue;
    }
    using lowerStartsTy = ::mlir::DenseIntElementsAttr;
    lowerStartsTy lowerStarts;

    auto getLowerStarts() const {
      auto &propStorage = this->lowerStarts;
      return ::llvm::cast<::mlir::DenseIntElementsAttr>(propStorage);
    }
    void setLowerStarts(const ::mlir::DenseIntElementsAttr &propValue) {
      this->lowerStarts = propValue;
    }
    using stridesTy = ::mlir::ArrayAttr;
    stridesTy strides;

    auto getStrides() const {
      auto &propStorage = this->strides;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setStrides(const ::mlir::ArrayAttr &propValue) {
      this->strides = propValue;
    }
    using transformsTy = ::mlir::ArrayAttr;
    transformsTy transforms;

    auto getTransforms() const {
      auto &propStorage = this->transforms;
      return ::llvm::cast<::mlir::ArrayAttr>(propStorage);
    }
    void setTransforms(const ::mlir::ArrayAttr &propValue) {
      this->transforms = propValue;
    }
    using useIndexDiffsTy = ::mlir::UnitAttr;
    useIndexDiffsTy useIndexDiffs;

    auto getUseIndexDiffs() const {
      auto &propStorage = this->useIndexDiffs;
      return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(propStorage);
    }
    void setUseIndexDiffs(const ::mlir::UnitAttr &propValue) {
      this->useIndexDiffs = propValue;
    }
    using operandSegmentSizesTy = std::array<int32_t, 2>;
    operandSegmentSizesTy operandSegmentSizes;
    ::llvm::ArrayRef<int32_t> getOperandSegmentSizes() const {
      auto &propStorage = this->operandSegmentSizes;
      return propStorage;
    }
    void setOperandSegmentSizes(::llvm::ArrayRef<int32_t> propValue) {
      auto &propStorage = this->operandSegmentSizes;
      ::llvm::copy(propValue, propStorage.begin());
    }
    bool operator==(const Properties &rhs) const {
      return 
        rhs.bounds == this->bounds &&
        rhs.forceUnroll == this->forceUnroll &&
        rhs.lowerStarts == this->lowerStarts &&
        rhs.strides == this->strides &&
        rhs.transforms == this->transforms &&
        rhs.useIndexDiffs == this->useIndexDiffs &&
        rhs.operandSegmentSizes == this->operandSegmentSizes &&
        true;
    }
    bool operator!=(const Properties &rhs) const {
      return !(*this == rhs);
    }
  };
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  TransformingForOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.transforming_for", odsAttrs.getContext());
  }

  TransformingForOpGenericAdaptorBase(TransformingForOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

  ::mlir::ArrayAttr getTransformsAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().transforms);
    return attr;
  }

  ::mlir::ArrayAttr getTransforms();
  ::mlir::ArrayAttr getBoundsAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().bounds);
    return attr;
  }

  ::mlir::ArrayAttr getBounds();
  ::mlir::ArrayAttr getStridesAttr() {
    auto attr = ::llvm::cast<::mlir::ArrayAttr>(getProperties().strides);
    return attr;
  }

  ::mlir::ArrayAttr getStrides();
  ::mlir::DenseIntElementsAttr getLowerStartsAttr() {
    auto attr = ::llvm::cast<::mlir::DenseIntElementsAttr>(getProperties().lowerStarts);
    return attr;
  }

  ::mlir::DenseIntElementsAttr getLowerStarts();
  ::mlir::UnitAttr getUseIndexDiffsAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().useIndexDiffs);
    return attr;
  }

  ::std::optional<bool> getUseIndexDiffs();
  ::mlir::UnitAttr getForceUnrollAttr() {
    auto attr = ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().forceUnroll);
    return attr;
  }

  ::std::optional<bool> getForceUnroll();
  ::mlir::Region &getRegion() {
    return *odsRegions[0];
  }

  ::mlir::RegionRange getRegions() {
    return odsRegions;
  }

};
} // namespace detail
template <typename RangeT>
class TransformingForOpGenericAdaptor : public detail::TransformingForOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::TransformingForOpGenericAdaptorBase;
  static constexpr int odsIndex_upperInits = 0;
  static constexpr int odsIndex_iterInits = 1;
public:
  TransformingForOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  TransformingForOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : TransformingForOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  TransformingForOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs) : TransformingForOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  TransformingForOpGenericAdaptor(RangeT values, const TransformingForOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = TransformingForOp, typename = std::enable_if_t<std::is_same_v<LateInst, TransformingForOp>>>
  TransformingForOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getUpperInits() {
    return getODSOperands(0);
  }

  RangeT getIterInits() {
    return getODSOperands(1);
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class TransformingForOpAdaptor : public TransformingForOpGenericAdaptor<::mlir::ValueRange> {
public:
  using TransformingForOpGenericAdaptor::TransformingForOpGenericAdaptor;
  TransformingForOpAdaptor(TransformingForOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class TransformingForOp : public ::mlir::Op<TransformingForOp, ::mlir::OpTrait::OneRegion, ::mlir::OpTrait::VariadicResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::AttrSizedOperandSegments, ::mlir::OpTrait::SingleBlock, ::mlir::OpTrait::SingleBlockImplicitTerminator<::mlir::rock::YieldOp>::Impl, ::mlir::OpTrait::OpInvariants, ::mlir::BytecodeOpInterface::Trait, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::RecursivelySpeculatableImplTrait, ::mlir::OpTrait::HasRecursiveMemoryEffects, ::mlir::LoopLikeOpInterface::Trait, ::mlir::DerivedAttributeOpInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = TransformingForOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = TransformingForOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_upperInits = 0;
  static constexpr int odsIndex_iterInits = 1;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    static ::llvm::StringRef attrNames[] = {::llvm::StringRef("bounds"), ::llvm::StringRef("forceUnroll"), ::llvm::StringRef("lowerStarts"), ::llvm::StringRef("strides"), ::llvm::StringRef("transforms"), ::llvm::StringRef("upperLen"), ::llvm::StringRef("useIndexDiffs"), ::llvm::StringRef("operandSegmentSizes")};
    return ::llvm::ArrayRef(attrNames);
  }

  ::mlir::StringAttr getBoundsAttrName() {
    return getAttributeNameForIndex(0);
  }

  static ::mlir::StringAttr getBoundsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 0);
  }

  ::mlir::StringAttr getForceUnrollAttrName() {
    return getAttributeNameForIndex(1);
  }

  static ::mlir::StringAttr getForceUnrollAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 1);
  }

  ::mlir::StringAttr getLowerStartsAttrName() {
    return getAttributeNameForIndex(2);
  }

  static ::mlir::StringAttr getLowerStartsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 2);
  }

  ::mlir::StringAttr getStridesAttrName() {
    return getAttributeNameForIndex(3);
  }

  static ::mlir::StringAttr getStridesAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 3);
  }

  ::mlir::StringAttr getTransformsAttrName() {
    return getAttributeNameForIndex(4);
  }

  static ::mlir::StringAttr getTransformsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 4);
  }

  ::mlir::StringAttr getUpperLenAttrName() {
    return getAttributeNameForIndex(5);
  }

  static ::mlir::StringAttr getUpperLenAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 5);
  }

  ::mlir::StringAttr getUseIndexDiffsAttrName() {
    return getAttributeNameForIndex(6);
  }

  static ::mlir::StringAttr getUseIndexDiffsAttrName(::mlir::OperationName name) {
    return getAttributeNameForIndex(name, 6);
  }

  ::mlir::StringAttr getOperandSegmentSizesAttrName() {
   return (*this)->getName().getAttributeNames().back();
  }

  static ::mlir::StringAttr getOperandSegmentSizesAttrName(::mlir::OperationName name) {
   return name.getAttributeNames().back();
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.transforming_for");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getUpperInits() {
    return getODSOperands(0);
  }

  ::mlir::Operation::operand_range getIterInits() {
    return getODSOperands(1);
  }

  ::mlir::MutableOperandRange getUpperInitsMutable();
  ::mlir::MutableOperandRange getIterInitsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index);
  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::result_range getResults() {
    return getODSResults(0);
  }

  ::mlir::Region &getRegion() {
    return (*this)->getRegion(0);
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::llvm::LogicalResult readProperties(::mlir::DialectBytecodeReader &reader, ::mlir::OperationState &state);
  void writeProperties(::mlir::DialectBytecodeWriter &writer);
  ::mlir::ArrayAttr getTransformsAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().transforms);
  }

  ::mlir::ArrayAttr getTransforms();
  ::mlir::ArrayAttr getBoundsAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().bounds);
  }

  ::mlir::ArrayAttr getBounds();
  ::mlir::ArrayAttr getStridesAttr() {
    return ::llvm::cast<::mlir::ArrayAttr>(getProperties().strides);
  }

  ::mlir::ArrayAttr getStrides();
  ::mlir::DenseIntElementsAttr getLowerStartsAttr() {
    return ::llvm::cast<::mlir::DenseIntElementsAttr>(getProperties().lowerStarts);
  }

  ::mlir::DenseIntElementsAttr getLowerStarts();
  ::mlir::UnitAttr getUseIndexDiffsAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().useIndexDiffs);
  }

  ::std::optional<bool> getUseIndexDiffs();
  ::mlir::UnitAttr getForceUnrollAttr() {
    return ::llvm::dyn_cast_or_null<::mlir::UnitAttr>(getProperties().forceUnroll);
  }

  ::std::optional<bool> getForceUnroll();
  uint32_t getUpperLen();
  static bool isDerivedAttribute(::llvm::StringRef name);
  ::mlir::DictionaryAttr materializeDerivedAttributes();
  void setTransformsAttr(::mlir::ArrayAttr attr) {
    getProperties().transforms = attr;
  }

  void setBoundsAttr(::mlir::ArrayAttr attr) {
    getProperties().bounds = attr;
  }

  void setStridesAttr(::mlir::ArrayAttr attr) {
    getProperties().strides = attr;
  }

  void setLowerStartsAttr(::mlir::DenseIntElementsAttr attr) {
    getProperties().lowerStarts = attr;
  }

  void setUseIndexDiffsAttr(::mlir::UnitAttr attr) {
    getProperties().useIndexDiffs = attr;
  }

  void setUseIndexDiffs(bool attrValue);
  void setForceUnrollAttr(::mlir::UnitAttr attr) {
    getProperties().forceUnroll = attr;
  }

  void setForceUnroll(bool attrValue);
  ::mlir::Attribute removeUseIndexDiffsAttr() {
      auto attr = getProperties().useIndexDiffs;
      getProperties().useIndexDiffs = {};
      return attr;
  }

  ::mlir::Attribute removeForceUnrollAttr() {
      auto attr = getProperties().forceUnroll;
      getProperties().forceUnroll = {};
      return attr;
  }

  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ArrayRef<ValueRange> inits, ArrayRef<Attribute> transforms, ArrayRef<int64_t> bounds, std::optional<ArrayRef<int64_t>> strides, bool forceUnroll, bool useIndexDiffs, ValueRange iterArgs = std::nullopt);
  static TransformingForOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ArrayRef<ValueRange> inits, ArrayRef<Attribute> transforms, ArrayRef<int64_t> bounds, std::optional<ArrayRef<int64_t>> strides, bool forceUnroll, bool useIndexDiffs, ValueRange iterArgs = std::nullopt);
  static TransformingForOp create(::mlir::ImplicitLocOpBuilder &builder, ArrayRef<ValueRange> inits, ArrayRef<Attribute> transforms, ArrayRef<int64_t> bounds, std::optional<ArrayRef<int64_t>> strides, bool forceUnroll, bool useIndexDiffs, ValueRange iterArgs = std::nullopt);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ArrayRef<ValueRange> inits, ArrayRef<Attribute> transforms, ArrayAttr bounds, ArrayAttr strides, bool forceUnroll, bool useIndexDiffs, ValueRange iterArgs = std::nullopt);
  static TransformingForOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ArrayRef<ValueRange> inits, ArrayRef<Attribute> transforms, ArrayAttr bounds, ArrayAttr strides, bool forceUnroll, bool useIndexDiffs, ValueRange iterArgs = std::nullopt);
  static TransformingForOp create(::mlir::ImplicitLocOpBuilder &builder, ArrayRef<ValueRange> inits, ArrayRef<Attribute> transforms, ArrayAttr bounds, ArrayAttr strides, bool forceUnroll, bool useIndexDiffs, ValueRange iterArgs = std::nullopt);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ArrayRef<ValueRange> inits, ArrayAttr transforms, ArrayRef<int64_t> bounds, std::optional<ArrayRef<int64_t>> strides, bool forceUnroll, bool useIndexDiffs, ValueRange iterArgs = std::nullopt);
  static TransformingForOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ArrayRef<ValueRange> inits, ArrayAttr transforms, ArrayRef<int64_t> bounds, std::optional<ArrayRef<int64_t>> strides, bool forceUnroll, bool useIndexDiffs, ValueRange iterArgs = std::nullopt);
  static TransformingForOp create(::mlir::ImplicitLocOpBuilder &builder, ArrayRef<ValueRange> inits, ArrayAttr transforms, ArrayRef<int64_t> bounds, std::optional<ArrayRef<int64_t>> strides, bool forceUnroll, bool useIndexDiffs, ValueRange iterArgs = std::nullopt);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ArrayRef<ValueRange> inits, ArrayAttr transforms, ArrayAttr bounds, ArrayAttr strides, bool forceUnroll, bool useIndexDiffs, ValueRange iterArgs = std::nullopt);
  static TransformingForOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ArrayRef<ValueRange> inits, ArrayAttr transforms, ArrayAttr bounds, ArrayAttr strides, bool forceUnroll, bool useIndexDiffs, ValueRange iterArgs = std::nullopt);
  static TransformingForOp create(::mlir::ImplicitLocOpBuilder &builder, ArrayRef<ValueRange> inits, ArrayAttr transforms, ArrayAttr bounds, ArrayAttr strides, bool forceUnroll, bool useIndexDiffs, ValueRange iterArgs = std::nullopt);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &p);
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::llvm::LogicalResult verify();
  bool isDefinedOutsideOfLoop(::mlir::Value  value);
  ::llvm::SmallVector<::mlir::Region *> getLoopRegions();
  static ::llvm::LogicalResult setPropertiesFromParsedAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
private:
  ::mlir::StringAttr getAttributeNameForIndex(unsigned index) {
    return getAttributeNameForIndex((*this)->getName(), index);
  }

  static ::mlir::StringAttr getAttributeNameForIndex(::mlir::OperationName name, unsigned index) {
    assert(index < 7 && "invalid attribute index");
    assert(name.getStringRef() == getOperationName() && "invalid operation name");
    assert(name.isRegistered() && "Operation isn't registered, missing a "
          "dependent dialect loading?");
    return name.getAttributeNames()[index];
  }

public:
  void moveOutOfLoop(ArrayRef<Operation *> ops);

  uint32_t getLowerStart(uint32_t n) {
    return *(getLowerStarts().getValues<uint32_t>().begin() + n);
  }

  // Retrieve the block arguments corresponding to the lower coordinates
  // for a given iteration domain.
  Block::BlockArgListType getLowerCoords(uint32_t domain) {
    uint32_t start = getLowerStart(domain);
    uint32_t end = getLowerStart(domain + 1);
    return getBody()->getArguments().slice(start, end - start);
  }
  Block::BlockArgListType getLowerCoords() {
    assert(getLowerStarts().size() == 3 && "Ambiguous call to getLowerCoords() with multple iteration domains");
    return getBody()->getArguments().take_front(getLowerStart(1));
  }

  Block::BlockArgListType getValidities() {
    uint32_t validityDomain = getLowerStarts().size() - 2;
    return getLowerCoords(validityDomain);
  }

  TypedValue<IntegerType> getValidity(uint32_t domain) {
    return cast<TypedValue<IntegerType>>(getValidities()[domain]);
  }

  Block::BlockArgListType getIterArgs() {
    return getBody()->getArguments().drop_front(getLowerStart(getLowerStarts().size() - 1));
  }

  ValueTypeRange<Block::BlockArgListType> getIterArgTypes() {
    return ValueTypeRange<Block::BlockArgListType>(getIterArgs());
  }

  Operation::operand_range getUpperInits(uint32_t domain) {
    uint32_t theUpperLen = getUpperLen();
    return getUpperInits().slice(domain * theUpperLen, theUpperLen);
  }

  ArrayAttr getTransforms(uint32_t domain) {
    return cast<ArrayAttr>(getTransforms()[domain]);
  }

  uint32_t domains() {
    return getTransforms().size();
  }
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::TransformingForOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::WorkgroupBarrierOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class WorkgroupBarrierOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  WorkgroupBarrierOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.workgroup_barrier", odsAttrs.getContext());
  }

  WorkgroupBarrierOpGenericAdaptorBase(WorkgroupBarrierOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class WorkgroupBarrierOpGenericAdaptor : public detail::WorkgroupBarrierOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::WorkgroupBarrierOpGenericAdaptorBase;
public:
  WorkgroupBarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  WorkgroupBarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : WorkgroupBarrierOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  WorkgroupBarrierOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : WorkgroupBarrierOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  WorkgroupBarrierOpGenericAdaptor(RangeT values, const WorkgroupBarrierOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = WorkgroupBarrierOp, typename = std::enable_if_t<std::is_same_v<LateInst, WorkgroupBarrierOp>>>
  WorkgroupBarrierOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class WorkgroupBarrierOpAdaptor : public WorkgroupBarrierOpGenericAdaptor<::mlir::ValueRange> {
public:
  using WorkgroupBarrierOpGenericAdaptor::WorkgroupBarrierOpGenericAdaptor;
  WorkgroupBarrierOpAdaptor(WorkgroupBarrierOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class WorkgroupBarrierOp : public ::mlir::Op<WorkgroupBarrierOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = WorkgroupBarrierOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = WorkgroupBarrierOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.workgroup_barrier");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState);
  static WorkgroupBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location);
  static WorkgroupBarrierOp create(::mlir::ImplicitLocOpBuilder &builder);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static WorkgroupBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static WorkgroupBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static WorkgroupBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static WorkgroupBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static WorkgroupBarrierOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static WorkgroupBarrierOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::WorkgroupBarrierOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::WorkgroupIdOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class WorkgroupIdOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  WorkgroupIdOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.workgroup_id", odsAttrs.getContext());
  }

  WorkgroupIdOpGenericAdaptorBase(WorkgroupIdOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class WorkgroupIdOpGenericAdaptor : public detail::WorkgroupIdOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::WorkgroupIdOpGenericAdaptorBase;
public:
  WorkgroupIdOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  WorkgroupIdOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : WorkgroupIdOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  WorkgroupIdOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : WorkgroupIdOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  WorkgroupIdOpGenericAdaptor(RangeT values, const WorkgroupIdOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = WorkgroupIdOp, typename = std::enable_if_t<std::is_same_v<LateInst, WorkgroupIdOp>>>
  WorkgroupIdOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class WorkgroupIdOpAdaptor : public WorkgroupIdOpGenericAdaptor<::mlir::ValueRange> {
public:
  using WorkgroupIdOpGenericAdaptor::WorkgroupIdOpGenericAdaptor;
  WorkgroupIdOpAdaptor(WorkgroupIdOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class WorkgroupIdOp : public ::mlir::Op<WorkgroupIdOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IndexType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferIntRangeInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = WorkgroupIdOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = WorkgroupIdOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.workgroup_id");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IndexType> getId() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IndexType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type id);
  static WorkgroupIdOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type id);
  static WorkgroupIdOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type id);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static WorkgroupIdOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static WorkgroupIdOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static WorkgroupIdOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static WorkgroupIdOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static WorkgroupIdOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static WorkgroupIdOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void inferResultRanges(::llvm::ArrayRef<::mlir::ConstantIntRanges> argRanges, ::mlir::SetIntRangeFn setResultRanges);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::WorkgroupIdOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::WorkitemIdOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class WorkitemIdOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  WorkitemIdOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.workitem_id", odsAttrs.getContext());
  }

  WorkitemIdOpGenericAdaptorBase(WorkitemIdOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize) {
    return {index, 1};
  }

  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class WorkitemIdOpGenericAdaptor : public detail::WorkitemIdOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::WorkitemIdOpGenericAdaptorBase;
public:
  WorkitemIdOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  WorkitemIdOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : WorkitemIdOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  WorkitemIdOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : WorkitemIdOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  WorkitemIdOpGenericAdaptor(RangeT values, const WorkitemIdOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = WorkitemIdOp, typename = std::enable_if_t<std::is_same_v<LateInst, WorkitemIdOp>>>
  WorkitemIdOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return odsOperands;
  }

private:
  RangeT odsOperands;
};
class WorkitemIdOpAdaptor : public WorkitemIdOpGenericAdaptor<::mlir::ValueRange> {
public:
  using WorkitemIdOpGenericAdaptor::WorkitemIdOpGenericAdaptor;
  WorkitemIdOpAdaptor(WorkitemIdOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class WorkitemIdOp : public ::mlir::Op<WorkitemIdOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::OneResult, ::mlir::OpTrait::OneTypedResult<::mlir::IndexType>::Impl, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::ZeroOperands, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::InferIntRangeInterface::Trait> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = WorkitemIdOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = WorkitemIdOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.workitem_id");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::TypedValue<::mlir::IndexType> getId() {
    return ::llvm::cast<::mlir::TypedValue<::mlir::IndexType>>(*getODSResults(0).begin());
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::Type id);
  static WorkitemIdOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::Type id);
  static WorkitemIdOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::Type id);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes);
  static WorkitemIdOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes);
  static WorkitemIdOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static WorkitemIdOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static WorkitemIdOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static WorkitemIdOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static WorkitemIdOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  void inferResultRanges(::llvm::ArrayRef<::mlir::ConstantIntRanges> argRanges, ::mlir::SetIntRangeFn setResultRanges);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::WorkitemIdOp)

namespace mlir {
namespace rock {

//===----------------------------------------------------------------------===//
// ::mlir::rock::YieldOp declarations
//===----------------------------------------------------------------------===//

namespace detail {
class YieldOpGenericAdaptorBase {
public:
  using Properties = ::mlir::EmptyProperties;
protected:
  ::mlir::DictionaryAttr odsAttrs;
  ::std::optional<::mlir::OperationName> odsOpName;
  Properties properties;
  ::mlir::RegionRange odsRegions;
public:
  YieldOpGenericAdaptorBase(::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : odsAttrs(attrs), properties(properties), odsRegions(regions) {  if (odsAttrs)
      odsOpName.emplace("rock.yield", odsAttrs.getContext());
  }

  YieldOpGenericAdaptorBase(YieldOp op);

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index, unsigned odsOperandsSize);
  const Properties &getProperties() {
    return properties;
  }

  ::mlir::DictionaryAttr getAttributes() {
    return odsAttrs;
  }

};
} // namespace detail
template <typename RangeT>
class YieldOpGenericAdaptor : public detail::YieldOpGenericAdaptorBase {
  using ValueT = ::llvm::detail::ValueOfRange<RangeT>;
  using Base = detail::YieldOpGenericAdaptorBase;
  static constexpr int odsIndex_operands = 0;
public:
  YieldOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, const Properties &properties, ::mlir::RegionRange regions = {}) : Base(attrs, properties, regions), odsOperands(values) {}

  YieldOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs, ::mlir::OpaqueProperties properties, ::mlir::RegionRange regions = {}) : YieldOpGenericAdaptor(values, attrs, (properties ? *properties.as<Properties *>() : Properties{}), regions) {}

  YieldOpGenericAdaptor(RangeT values, ::mlir::DictionaryAttr attrs = nullptr) : YieldOpGenericAdaptor(values, attrs, Properties{}, {}) {}

  YieldOpGenericAdaptor(RangeT values, const YieldOpGenericAdaptorBase &base) : Base(base), odsOperands(values) {}

  template <typename LateInst = YieldOp, typename = std::enable_if_t<std::is_same_v<LateInst, YieldOp>>>
  YieldOpGenericAdaptor(RangeT values, LateInst op) : Base(op), odsOperands(values) {}

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index) {
    return Base::getODSOperandIndexAndLength(index, odsOperands.size());
  }

  RangeT getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(odsOperands.begin(), valueRange.first),
             std::next(odsOperands.begin(), valueRange.first + valueRange.second)};
  }

  RangeT getOperands() {
    return getODSOperands(0);
  }

private:
  RangeT odsOperands;
};
class YieldOpAdaptor : public YieldOpGenericAdaptor<::mlir::ValueRange> {
public:
  using YieldOpGenericAdaptor::YieldOpGenericAdaptor;
  YieldOpAdaptor(YieldOp op);

  ::llvm::LogicalResult verify(::mlir::Location loc);
};
class YieldOp : public ::mlir::Op<YieldOp, ::mlir::OpTrait::ZeroRegions, ::mlir::OpTrait::ZeroResults, ::mlir::OpTrait::ZeroSuccessors, ::mlir::OpTrait::VariadicOperands, ::mlir::OpTrait::OpInvariants, ::mlir::ConditionallySpeculatable::Trait, ::mlir::OpTrait::AlwaysSpeculatableImplTrait, ::mlir::MemoryEffectOpInterface::Trait, ::mlir::OpTrait::IsTerminator, ::mlir::RegionBranchTerminatorOpInterface::Trait, ::mlir::OpTrait::ReturnLike> {
public:
  using Op::Op;
  using Op::print;
  using Adaptor = YieldOpAdaptor;
  template <typename RangeT>
  using GenericAdaptor = YieldOpGenericAdaptor<RangeT>;
  using FoldAdaptor = GenericAdaptor<::llvm::ArrayRef<::mlir::Attribute>>;
  static constexpr int odsIndex_operands = 0;
  using Properties = FoldAdaptor::Properties;
  static ::llvm::ArrayRef<::llvm::StringRef> getAttributeNames() {
    return {};
  }

  static constexpr ::llvm::StringLiteral getOperationName() {
    return ::llvm::StringLiteral("rock.yield");
  }

  std::pair<unsigned, unsigned> getODSOperandIndexAndLength(unsigned index);
  ::mlir::Operation::operand_range getODSOperands(unsigned index) {
    auto valueRange = getODSOperandIndexAndLength(index);
    return {std::next(getOperation()->operand_begin(), valueRange.first),
             std::next(getOperation()->operand_begin(), valueRange.first + valueRange.second)};
  }

  ::mlir::Operation::operand_range getOperands() {
    return getODSOperands(0);
  }

  ::mlir::MutableOperandRange getOperandsMutable();
  std::pair<unsigned, unsigned> getODSResultIndexAndLength(unsigned index) {
    return {index, 1};
  }

  ::mlir::Operation::result_range getODSResults(unsigned index) {
    auto valueRange = getODSResultIndexAndLength(index);
    return {std::next(getOperation()->result_begin(), valueRange.first),
             std::next(getOperation()->result_begin(), valueRange.first + valueRange.second)};
  }

  static ::llvm::LogicalResult setPropertiesFromAttr(Properties &prop, ::mlir::Attribute attr, ::llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static ::mlir::Attribute getPropertiesAsAttr(::mlir::MLIRContext *ctx, const Properties &prop);
  static llvm::hash_code computePropertiesHash(const Properties &prop);
  static std::optional<mlir::Attribute> getInherentAttr(::mlir::MLIRContext *ctx, const Properties &prop, llvm::StringRef name);
  static void setInherentAttr(Properties &prop, llvm::StringRef name, mlir::Attribute value);
  static void populateInherentAttrs(::mlir::MLIRContext *ctx, const Properties &prop, ::mlir::NamedAttrList &attrs);
  static ::llvm::LogicalResult verifyInherentAttrs(::mlir::OperationName opName, ::mlir::NamedAttrList &attrs, llvm::function_ref<::mlir::InFlightDiagnostic()> emitError);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState);
  static YieldOp create(::mlir::OpBuilder &builder, ::mlir::Location location);
  static YieldOp create(::mlir::ImplicitLocOpBuilder &builder);
  static void build(::mlir::OpBuilder &odsBuilder, ::mlir::OperationState &odsState, ::mlir::ValueRange operands);
  static YieldOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::ValueRange operands);
  static YieldOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::ValueRange operands);
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static YieldOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static YieldOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, ::llvm::ArrayRef<::mlir::NamedAttribute> attributes = {});
  static void build(::mlir::OpBuilder &, ::mlir::OperationState &odsState, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static YieldOp create(::mlir::OpBuilder &builder, ::mlir::Location location, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  static YieldOp create(::mlir::ImplicitLocOpBuilder &builder, ::mlir::TypeRange resultTypes, ::mlir::ValueRange operands, const Properties &properties, ::llvm::ArrayRef<::mlir::NamedAttribute> discardableAttributes = {});
  ::llvm::LogicalResult verifyInvariantsImpl();
  ::llvm::LogicalResult verifyInvariants();
  ::mlir::MutableOperandRange getMutableSuccessorOperands(::mlir::RegionBranchPoint point);
  static ::mlir::ParseResult parse(::mlir::OpAsmParser &parser, ::mlir::OperationState &result);
  void print(::mlir::OpAsmPrinter &_odsPrinter);
  void getEffects(::llvm::SmallVectorImpl<::mlir::SideEffects::EffectInstance<::mlir::MemoryEffects::Effect>> &effects);
public:
};
} // namespace rock
} // namespace mlir
MLIR_DECLARE_EXPLICIT_TYPE_ID(::mlir::rock::YieldOp)


#endif  // GET_OP_CLASSES

