/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkLabelToRGBImageFilter.h"
#include "itkLabelToRGBImageFilter.h"

// Additional include files
#include "sitkLabelFunctorUtils.hxx"
// Done with additional include files

namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
LabelToRGBImageFilter::LabelToRGBImageFilter ()
{
  this->m_MemberFactory =  std::make_unique<detail::MemberFunctionFactory<MemberFunctionType>>( this );

  this->m_MemberFactory->RegisterMemberFunctions< PixelIDTypeList, 2, 3 > ();



}

//
// Destructor
//
LabelToRGBImageFilter::~LabelToRGBImageFilter() = default;



//
// ToString
//
std::string LabelToRGBImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::LabelToRGBImageFilter\n";
  out << "  BackgroundValue: ";
  this->ToStringHelper(out, this->m_BackgroundValue);
  out << std::endl;
  out << "  Colormap: ";
  this->ToStringHelper(out, this->m_Colormap);
  out << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}

//
// Execute
//
Image LabelToRGBImageFilter::Execute ( const Image& image1 )
{
  const PixelIDValueEnum type = image1.GetPixelID();
  const unsigned int dimension = image1.GetDimension();

  return this->m_MemberFactory->GetMemberFunction( type, dimension )( image1 );
}
Image LabelToRGBImageFilter::Execute ( Image&& image1 )
{
  Image &temp = image1;
  auto autoResetInPlace = make_scope_exit([this, &temp]{this->m_InPlace=false; Image moved(std::move(temp));});
  if (temp.IsUnique())
    {
    m_InPlace = true;
    }
  return this->Execute( image1 );
}


//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType>
Image LabelToRGBImageFilter::ExecuteInternal ( const Image& inImage1 )
{
  // Define the input and output image types
  using InputImageType = TImageType;


  //Define output image type
  using OutputImageType = itk::VectorImage< uint8_t, InputImageType::ImageDimension>;

  // Get the pointer to the ITK image contained in image1
  typename InputImageType::ConstPointer image1 = this->CastImageToITK<InputImageType>( inImage1 );


  using FilterType =  itk::LabelToRGBImageFilter<InputImageType,  OutputImageType>;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();

  filter->SetInput( 0, image1 );



  filter->SetBackgroundValue ( static_cast< typename InputImageType::PixelType> ( this->m_BackgroundValue ) );
  SetLabelFunctorFromColormap(filter->GetFunctor(),this->m_Colormap);
  filter->SetInPlace( m_InPlace );
         



  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}

sitkClangDiagnosticPop();

//-----------------------------------------------------------------------------


//
// Function to run the Execute method of this filter
//
Image LabelToRGB ( const Image& image1, double backgroundValue, std::vector<uint8_t> colormap )
{
  LabelToRGBImageFilter filter;
  filter.SetBackgroundValue( backgroundValue );  filter.SetColormap( colormap );
  return filter.Execute ( image1 );
}
//
// Function to run the Execute method of this filter
//
Image LabelToRGB ( Image&& image1, double backgroundValue, std::vector<uint8_t> colormap )
{
  LabelToRGBImageFilter filter;
  filter.SetBackgroundValue( backgroundValue );  filter.SetColormap( colormap );
  return filter.Execute ( std::move(image1) );
}

}
