/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.cxx.in to make changes.
 */

#include "itkImage.h"
#include "itkVectorImage.h"
#include "itkLabelMap.h"
#include "itkLabelObject.h"
#include "itkNumericTraits.h"
#include "itkNumericTraitsVariableLengthVectorPixel.h"
#include "itkVectorIndexSelectionCastImageFilter.h"
#include "itkComposeImageFilter.h"

#include "sitkScalarConnectedComponentImageFilter.h"
#include "itkScalarConnectedComponentImageFilter.h"



namespace itk::simple {

//-----------------------------------------------------------------------------

//
// Default constructor that initializes parameters
//
ScalarConnectedComponentImageFilter::ScalarConnectedComponentImageFilter ()
{
  this->m_MemberFactory =  std::make_unique<detail::MemberFunctionFactory<MemberFunctionType>>( this );

  this->m_MemberFactory->RegisterMemberFunctions< PixelIDTypeList, 2, 3 > ();



}

//
// Destructor
//
ScalarConnectedComponentImageFilter::~ScalarConnectedComponentImageFilter() = default;



//
// ToString
//
std::string ScalarConnectedComponentImageFilter::ToString() const
{
  std::ostringstream out;
  out << "itk::simple::ScalarConnectedComponentImageFilter\n";
  out << "  DistanceThreshold: ";
  this->ToStringHelper(out, this->m_DistanceThreshold);
  out << std::endl;
  out << "  FullyConnected: ";
  this->ToStringHelper(out, this->m_FullyConnected);
  out << std::endl;

  out << ProcessObject::ToString();
  return out.str();
}

//
// Execute
//
Image ScalarConnectedComponentImageFilter::Execute ( const Image & image, const Image & maskImage )
{
  const PixelIDValueEnum type = image.GetPixelID();
  const unsigned int dimension = image.GetDimension();
  CheckImageMatchingDimension(  image, maskImage, "maskImage" );
  CheckImageMatchingSize(  image, maskImage, "maskImage" );

  return this->m_MemberFactory->GetMemberFunction( type, dimension )( &image, &maskImage );
}
Image ScalarConnectedComponentImageFilter::Execute ( const Image & image )
{
  const PixelIDValueEnum type = image.GetPixelID();
  const unsigned int dimension = image.GetDimension();

  return this->m_MemberFactory->GetMemberFunction( type, dimension )( &image, nullptr );
}



//-----------------------------------------------------------------------------

sitkClangDiagnosticPush();
sitkClangWarningIgnore("-Wunused-local-typedef");

//
// ExecuteInternal
//
template <class TImageType>
Image ScalarConnectedComponentImageFilter::ExecuteInternal ( const Image * inImage, const Image * inMaskImage )
{
  // Define the input and output image types
  using InputImageType = TImageType;


  // Define output image type
  using OutputImageType = itk::Image< uint32_t, InputImageType::ImageDimension >;



  using FilterType = itk::ScalarConnectedComponentImageFilter<InputImageType, OutputImageType, itk::Image<uint8_t, InputImageType::ImageDimension> >;
  // Set up the ITK filter
  typename FilterType::Pointer filter = FilterType::New();


  assert( inImage != nullptr );
  typename FilterType::InputImageType::ConstPointer image1 = this->CastImageToITK<typename FilterType::InputImageType>( *inImage );
  filter->SetInput( image1 );
  if ( inMaskImage != nullptr ) {
  typename FilterType::MaskImageType::ConstPointer image2 = this->CastImageToITK<typename FilterType::MaskImageType>( *inMaskImage );
  filter->SetMaskImage( image2 );
  }


  filter->SetDistanceThreshold ( static_cast< typename InputImageType::PixelType> ( this->m_DistanceThreshold ) );
  filter->SetFullyConnected ( this->m_FullyConnected );




  this->PreUpdate( filter.GetPointer() );



  // Run the ITK filter and return the output as a SimpleITK image
  filter->Update();



  typename FilterType::OutputImageType::Pointer itkOutImage{ filter->GetOutput()};
  filter = nullptr;
  this->FixNonZeroIndex( itkOutImage.GetPointer() );
  return Image{ this->CastITKToImage( itkOutImage.GetPointer() ) };

}

sitkClangDiagnosticPop();

//-----------------------------------------------------------------------------


//
// Function to run the Execute method of this filter
//
Image ScalarConnectedComponent ( const Image & image, const Image & maskImage, double distanceThreshold, bool fullyConnected )
{
  ScalarConnectedComponentImageFilter filter;
  filter.SetDistanceThreshold( distanceThreshold );  filter.SetFullyConnected( fullyConnected );
  return filter.Execute ( image, maskImage );
}
//
// Function to run the Execute method of this filter
//
Image ScalarConnectedComponent ( const Image & image, double distanceThreshold, bool fullyConnected )
{
  ScalarConnectedComponentImageFilter filter;
  filter.SetDistanceThreshold( distanceThreshold );  filter.SetFullyConnected( fullyConnected );
  return filter.Execute ( image );
}


}
