﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/athena/Athena_EXPORTS.h>
#include <aws/athena/model/WorkGroupSummary.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Athena {
namespace Model {
class ListWorkGroupsResult {
 public:
  AWS_ATHENA_API ListWorkGroupsResult() = default;
  AWS_ATHENA_API ListWorkGroupsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_ATHENA_API ListWorkGroupsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>A list of <a>WorkGroupSummary</a> objects that include the names,
   * descriptions, creation times, and states for each workgroup.</p>
   */
  inline const Aws::Vector<WorkGroupSummary>& GetWorkGroups() const { return m_workGroups; }
  template <typename WorkGroupsT = Aws::Vector<WorkGroupSummary>>
  void SetWorkGroups(WorkGroupsT&& value) {
    m_workGroupsHasBeenSet = true;
    m_workGroups = std::forward<WorkGroupsT>(value);
  }
  template <typename WorkGroupsT = Aws::Vector<WorkGroupSummary>>
  ListWorkGroupsResult& WithWorkGroups(WorkGroupsT&& value) {
    SetWorkGroups(std::forward<WorkGroupsT>(value));
    return *this;
  }
  template <typename WorkGroupsT = WorkGroupSummary>
  ListWorkGroupsResult& AddWorkGroups(WorkGroupsT&& value) {
    m_workGroupsHasBeenSet = true;
    m_workGroups.emplace_back(std::forward<WorkGroupsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A token generated by the Athena service that specifies where to continue
   * pagination if a previous request was truncated. To obtain the next set of pages,
   * pass in the <code>NextToken</code> from the response object of the previous page
   * call.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListWorkGroupsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListWorkGroupsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<WorkGroupSummary> m_workGroups;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_workGroupsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Athena
}  // namespace Aws
