/*
 * Copyright (C) 2014-2026 CZ.NIC
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * In addition, as a special exception, the copyright holders give
 * permission to link the code of portions of this program with the
 * OpenSSL library under certain conditions as described in each
 * individual source file, and distribute linked combinations including
 * the two.
 */

#include <QMap>
#include <QPair>
#include <QString>
#include <QVector>

#include "src/datovka_shared/io/db_tables.h"
#include "src/datovka_shared/io/draft_db_tables.h"

namespace DbInfoTbl {
	static const QString tabName("_db_info");

	static const QVector< QPair<QString, enum EntryType> > knownAttrs = {
	{"id", DB_INTEGER}, /* NOT NULL */
	{"entry_name", DB_TEXT}, /* NOT_NULL */
	{"entry_json", DB_TEXT}
	/*
	 * PRIMARY KEY (id),
	 * UNIQUE (entry_name)
	 */
	};

	static const QMap<QString, QString> colConstraints = {
	    {"id", "NOT NULL"},
	    {"entry_name", "NOT NULL"}
	};

	static const QString &tblConstraint(
	    ",\n"
	    "        CONSTRAINT pk_id PRIMARY KEY (id),\n"
	    "        CONSTRAINT uq_entry_name UNIQUE (entry_name)"
	);

	static const QMap<QString, SQLiteTbl::AttrProp> attrProps = {
	{"id", {DB_INTEGER, ""}},
	{"entry_name", {DB_TEXT, ""}},
	{"entry_json", {DB_TEXT, ""}}
	};
} /* namespace DbInfoTbl */
SQLiteTbl DraftDbTables::_dbInfoTbl(DbInfoTbl::tabName,
    DbInfoTbl::knownAttrs, DbInfoTbl::attrProps, DbInfoTbl::colConstraints,
    DbInfoTbl::tblConstraint);

namespace DraftTbl {
	const QString tabName("drafts");

	const QVector< QPair<QString, enum EntryType> > knownAttrs = {
	{"id", DB_INTEGER}, /* NOT NULL */
	{"username", DB_TEXT}, /* NOT NULL */
	{"test_env", DB_INTEGER}, /* NOT NULL */
	{"location_key", DB_TEXT}, /* NOT NULL */
	{"creationTime", DB_DATETIME}, /* NOT NULL */
	{"updateTime", DB_DATETIME},
	{"jsonData", DB_TEXT} /* NOT NULL */
	/*
	 * PRIMARY KEY (id),
	 * UNIQUE (location_key)
	 * CHECK (test_env IN (0, 1))
	*/
	};

	const QMap<QString, QString> colConstraints = {
	    {"id", "NOT NULL"},
	    {"username", "NOT NULL"},
	    {"test_env", "NOT NULL"},
	    {"location_key", "NOT NULL"},
	    {"creationTime", "NOT NULL"},
	    {"jsonData", "NOT NULL"}
	};

	const QString tblConstraint(
	    ",\n"
	    "        CONSTRAINT pk_id PRIMARY KEY (id),\n"
	    "        CONSTRAINT uq_location_key UNIQUE (location_key),\n"
	    "        CONSTRAINT ck_test_env CHECK (test_env IN (0, 1))"
	);

	const QMap<QString, SQLiteTbl::AttrProp> attrProps = {
	{"id",                    {DB_INTEGER, ""}},
	{"username",              {DB_TEXT, ""}},
	{"test_env",              {DB_INTEGER, ""}},
	{"location_key",          {DB_TEXT, ""}},
	{"creationTime",          {DB_DATETIME, SQLiteTbls::tr("Creation Time")}},
	{"updateTime",            {DB_DATETIME, SQLiteTbls::tr("Update Time")}},
	{"jsonData",              {DB_TEXT, ""}}
	};
} /* namespace DraftTbl */
SQLiteTbl DraftDbTables::draftTbl(DraftTbl::tabName,
    DraftTbl::knownAttrs, DraftTbl::attrProps, DraftTbl::colConstraints,
    DraftTbl::tblConstraint);
