#ifndef _EFL_UI_FOCUS_COMPOSITION_ADAPTER_EO_H_
#define _EFL_UI_FOCUS_COMPOSITION_ADAPTER_EO_H_

#ifndef _EFL_UI_FOCUS_COMPOSITION_ADAPTER_EO_CLASS_TYPE
#define _EFL_UI_FOCUS_COMPOSITION_ADAPTER_EO_CLASS_TYPE

typedef Eo Efl_Ui_Focus_Composition_Adapter;

#endif

#ifndef _EFL_UI_FOCUS_COMPOSITION_ADAPTER_EO_TYPES
#define _EFL_UI_FOCUS_COMPOSITION_ADAPTER_EO_TYPES


#endif
#ifdef EFL_BETA_API_SUPPORT
/**
 * @brief This class allows an @ref Efl_Canvas_Object to receive focus as if
 * they were @ref Efl_Ui_Widget.
 *
 * Instantiate this class and manually set its properties to the appropriate
 * objects.
 *
 * @ingroup Efl_Ui_Focus_Composition_Adapter
 */
#define EFL_UI_FOCUS_COMPOSITION_ADAPTER_CLASS efl_ui_focus_composition_adapter_class_get()

EAPI EAPI_WEAK const Efl_Class *efl_ui_focus_composition_adapter_class_get(void) EINA_CONST;

/**
 * @brief The canvas object that needs to receive focus.
 *
 * @param[in] obj The object.
 * @param[in] v The canvas object.
 *
 * @ingroup Efl_Ui_Focus_Composition_Adapter
 */
EAPI EAPI_WEAK void efl_ui_focus_composition_adapter_canvas_object_set(Eo *obj, Efl_Canvas_Object *v);

/**
 * @brief The canvas object that needs to receive focus.
 *
 * @param[in] obj The object.
 *
 * @return The canvas object.
 *
 * @ingroup Efl_Ui_Focus_Composition_Adapter
 */
EAPI EAPI_WEAK Efl_Canvas_Object *efl_ui_focus_composition_adapter_canvas_object_get(const Eo *obj);

/**
 * @brief The focus manager handling the focus for the
 * @ref efl_ui_focus_composition_adapter_canvas_object_get.
 *
 * @param[in] obj The object.
 * @param[in] v The focus manager.
 *
 * @ingroup Efl_Ui_Focus_Composition_Adapter
 */
EAPI EAPI_WEAK void efl_ui_focus_composition_adapter_focus_manager_object_set(Eo *obj, Efl_Ui_Focus_Manager *v);

/**
 * @brief The focus parent for the
 * @ref efl_ui_focus_composition_adapter_canvas_object_get.
 *
 * @param[in] obj The object.
 * @param[in] parent The focus parent.
 *
 * @ingroup Efl_Ui_Focus_Composition_Adapter
 */
EAPI EAPI_WEAK void efl_ui_focus_composition_adapter_focus_manager_parent_set(Eo *obj, Efl_Ui_Focus_Object *parent);
#endif /* EFL_BETA_API_SUPPORT */

#endif
