/*
 * File automatically generated by
 * gengen 1.4.3 by Lorenzo Bettini 
 * http://www.gnu.org/software/gengen
 */

#ifndef LUA_SOURCE_GEN_CLASS_H
#define LUA_SOURCE_GEN_CLASS_H

#include <string>
#include <iostream>

using std::string;
using std::ostream;

class lua_source_gen_class
{
 protected:
  string author;
  string genconvfun;
  string genfunbody;
  string genstringfun;
  string headerfile;
  string othercomments;
  string package;
  string version;

 public:
  lua_source_gen_class()
  {
  }
  
  lua_source_gen_class(const string &_author, const string &_genconvfun, const string &_genfunbody, const string &_genstringfun, const string &_headerfile, const string &_othercomments, const string &_package, const string &_version) :
    author (_author), genconvfun (_genconvfun), genfunbody (_genfunbody), genstringfun (_genstringfun), headerfile (_headerfile), othercomments (_othercomments), package (_package), version (_version)
  {
  }

  virtual ~lua_source_gen_class()
  {
  }

  static void
  generate_string(const string &s, ostream &stream, unsigned int indent)
  {
    if (!indent || s.find('\n') == string::npos)
      {
        stream << s;
        return;
      }

    string::size_type pos;
    string::size_type start = 0;
    string ind (indent, ' ');
    while ( (pos=s.find('\n', start)) != string::npos)
      {
        stream << s.substr (start, (pos+1)-start);
        start = pos+1;
        if (start+1 <= s.size ())
          stream << ind;
      }
    if (start+1 <= s.size ())
      stream << s.substr (start);
  }

  void set_author(const string &_author)
  {
    author = _author;
  }

  virtual void generate_genconvfun(ostream &stream, unsigned int indent) = 0;

  void set_genconvfun(const string &_genconvfun)
  {
    genconvfun = _genconvfun;
  }

  virtual void generate_genfunbody(ostream &stream, unsigned int indent) = 0;

  void set_genfunbody(const string &_genfunbody)
  {
    genfunbody = _genfunbody;
  }

  virtual void generate_genstringfun(ostream &stream, unsigned int indent) = 0;

  void set_genstringfun(const string &_genstringfun)
  {
    genstringfun = _genstringfun;
  }

  void set_headerfile(const string &_headerfile)
  {
    headerfile = _headerfile;
  }

  void set_othercomments(const string &_othercomments)
  {
    othercomments = _othercomments;
  }

  void set_package(const string &_package)
  {
    package = _package;
  }

  void set_version(const string &_version)
  {
    version = _version;
  }

  void generate_lua_source(ostream &stream, unsigned int indent = 0)
  {
    string indent_str (indent, ' ');
    indent = 0;
  
    stream << "\n";
    stream << indent_str;
    stream << "--[[";
    stream << "\n";
    stream << indent_str;
    stream << "    File automatically generated by";
    stream << "\n";
    stream << indent_str;
    indent = 4;
    stream << "    ";
    stream << package;
    stream << " ";
    stream << version;
    stream << " ";
    stream << author;
    indent = 0;
    stream << "\n";
    stream << indent_str;
    indent = 4;
    stream << "    ";
    stream << othercomments;
    indent = 0;
    stream << "\n";
    stream << indent_str;
    stream << "--]]";
    stream << "\n";
    stream << indent_str;
    stream << "\n";
    stream << indent_str;
    stream << "dofile(\"";
    stream << headerfile;
    stream << "\")";
    stream << "\n";
    stream << indent_str;
    stream << "\n";
    stream << indent_str;
    if (genstringfun.size () > 0)
      generate_string (genstringfun, stream, indent + indent_str.length ());
    else
      generate_genstringfun (stream, indent + indent_str.length ());
    stream << indent_str;
    if (genconvfun.size () > 0)
      generate_string (genconvfun, stream, indent + indent_str.length ());
    else
      generate_genconvfun (stream, indent + indent_str.length ());
    stream << indent_str;
    if (genfunbody.size () > 0)
      generate_string (genfunbody, stream, indent + indent_str.length ());
    else
      generate_genfunbody (stream, indent + indent_str.length ());
    stream << "\n";
    stream << indent_str;
  }
};

#endif // LUA_SOURCE_GEN_CLASS_H
