/* gitg-files-tree-store.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-files-tree-store.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2012 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include "files.h"
#include <glib.h>
#include <libgit2-glib/ggit.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GITG_FILES_TREE_STORE_0_PROPERTY,
	GITG_FILES_TREE_STORE_TREE_PROPERTY,
	GITG_FILES_TREE_STORE_NUM_PROPERTIES
};
static GParamSpec* gitg_files_tree_store_properties[GITG_FILES_TREE_STORE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GgitOId_free0(var) ((var == NULL) ? NULL : (var = (_vala_GgitOId_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GITG_FILES_TREE_STORE_TYPE_ITEM (gitg_files_tree_store_item_get_type ())
typedef struct _GitgFilesTreeStoreItem GitgFilesTreeStoreItem;
typedef struct _Block4Data Block4Data;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _ggit_tree_entry_unref0(var) ((var == NULL) ? NULL : (var = (ggit_tree_entry_unref (var), NULL)))
#define __vala_GtkTreeIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreeIter_free (var), NULL)))

struct _GitgFilesTreeStorePrivate {
	guint d_update_id;
	GgitTree* d_tree;
};

struct _GitgFilesTreeStoreItem {
	gchar* root;
	GgitTreeEntry* entry;
};

struct _Block4Data {
	int _ref_count_;
	GitgFilesTreeStore* self;
	GList* items;
	GHashTable* paths;
};

static gint GitgFilesTreeStore_private_offset;
static gpointer gitg_files_tree_store_parent_class = NULL;
static GType gitg_files_tree_store_type_id = 0;

static void gitg_files_tree_store_real_dispose (GObject* base);
static void _vala_GgitOId_free (GgitOId* self);
static GIcon* gitg_files_tree_store_get_entry_icon (GitgFilesTreeStore* self,
                                             GgitTreeEntry* entry);
static void gitg_files_tree_store_update (GitgFilesTreeStore* self);
static GType gitg_files_tree_store_item_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GitgFilesTreeStoreItem* gitg_files_tree_store_item_dup (const GitgFilesTreeStoreItem* self);
static void gitg_files_tree_store_item_free (GitgFilesTreeStoreItem* self);
static void gitg_files_tree_store_item_copy (const GitgFilesTreeStoreItem* self,
                                      GitgFilesTreeStoreItem* dest);
static void gitg_files_tree_store_item_destroy (GitgFilesTreeStoreItem* self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void _gitg_files_tree_store_item_free0_ (gpointer var);
static inline void _g_list_free__gitg_files_tree_store_item_free0_ (GList* self);
static void block4_data_unref (void * _userdata_);
static gint ___lambda4_ (Block4Data* _data4_,
                  const gchar* root,
                  GgitTreeEntry* entry);
static gint ____lambda4__ggit_tree_walk_callback (const gchar* root,
                                           GgitTreeEntry* entry,
                                           gpointer self);
static void _g_free0_ (gpointer var);
static void _vala_GtkTreePath_free (GtkTreePath* self);
static void __vala_GtkTreePath_free0_ (gpointer var);
static gboolean __lambda5_ (Block4Data* _data4_);
static void _vala_GtkTreeIter_free (GtkTreeIter* self);
static GtkTreeIter* _vala_GtkTreeIter_copy (GtkTreeIter* self);
static gboolean ___lambda5__gsource_func (gpointer self);
static GObject * gitg_files_tree_store_constructor (GType type,
                                             guint n_construct_properties,
                                             GObjectConstructParam * construct_properties);
static gint _gitg_files_tree_store___lambda6_ (GitgFilesTreeStore* self,
                                        GtkTreeModel* model,
                                        GtkTreeIter* a,
                                        GtkTreeIter* b);
static gint __gitg_files_tree_store___lambda6__gtk_tree_iter_compare_func (GtkTreeModel* model,
                                                                    GtkTreeIter* a,
                                                                    GtkTreeIter* b,
                                                                    gpointer self);
static void gitg_files_tree_store_finalize (GObject * obj);
static void _vala_gitg_files_tree_store_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec);
static void _vala_gitg_files_tree_store_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec);

static inline gpointer
gitg_files_tree_store_get_instance_private (GitgFilesTreeStore* self)
{
	return G_STRUCT_MEMBER_P (self, GitgFilesTreeStore_private_offset);
}

static void
gitg_files_tree_store_real_dispose (GObject* base)
{
	GitgFilesTreeStore * self;
	self = (GitgFilesTreeStore*) base;
	if (self->priv->d_update_id != ((guint) 0)) {
		g_source_remove (self->priv->d_update_id);
		self->priv->d_update_id = (guint) 0;
	}
	G_OBJECT_CLASS (gitg_files_tree_store_parent_class)->dispose ((GObject*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_tree_store_get_type (), GtkTreeStore));
}

static void
_vala_GgitOId_free (GgitOId* self)
{
	g_boxed_free (ggit_oid_get_type (), self);
}

GgitOId*
gitg_files_tree_store_get_id (GitgFilesTreeStore* self,
                              GtkTreeIter* iter)
{
	GgitOId* ret = NULL;
	GtkTreeIter _tmp0_;
	GgitOId* _tmp1_ = NULL;
	GgitOId* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = *iter;
	gtk_tree_model_get ((GtkTreeModel*) self, &_tmp0_, 3, &_tmp1_, -1);
	__vala_GgitOId_free0 (ret);
	ret = _tmp1_;
	result = ret;
	return result;
}

gchar*
gitg_files_tree_store_get_full_path (GitgFilesTreeStore* self,
                                     GtkTreeIter* iter)
{
	gchar* ret = NULL;
	GtkTreeIter _tmp0_;
	gchar* _tmp1_;
	GtkTreeIter parent = {0};
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = *iter;
	_tmp1_ = gitg_files_tree_store_get_name (self, &_tmp0_);
	ret = _tmp1_;
	while (TRUE) {
		GtkTreeIter _tmp2_;
		GtkTreeIter _tmp3_ = {0};
		gboolean _tmp4_;
		GtkTreeIter _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		GtkTreeIter _tmp10_;
		_tmp2_ = *iter;
		_tmp4_ = gtk_tree_model_iter_parent ((GtkTreeModel*) self, &_tmp3_, &_tmp2_);
		parent = _tmp3_;
		if (!_tmp4_) {
			break;
		}
		_tmp5_ = parent;
		_tmp6_ = gitg_files_tree_store_get_name (self, &_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = ret;
		_tmp9_ = g_build_filename (_tmp7_, _tmp8_, NULL);
		_g_free0 (ret);
		ret = _tmp9_;
		_g_free0 (_tmp7_);
		_tmp10_ = parent;
		*iter = _tmp10_;
	}
	result = ret;
	return result;
}

gchar*
gitg_files_tree_store_get_name (GitgFilesTreeStore* self,
                                GtkTreeIter* iter)
{
	gchar* ret = NULL;
	GtkTreeIter _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = *iter;
	gtk_tree_model_get ((GtkTreeModel*) self, &_tmp0_, 1, &_tmp1_, -1);
	_g_free0 (ret);
	ret = _tmp1_;
	result = ret;
	return result;
}

gboolean
gitg_files_tree_store_get_isdir (GitgFilesTreeStore* self,
                                 GtkTreeIter* iter)
{
	gboolean ret = FALSE;
	GtkTreeIter _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	gtk_tree_model_get ((GtkTreeModel*) self, &_tmp0_, 2, &_tmp1_, -1);
	ret = _tmp1_;
	result = ret;
	return result;
}

static GIcon*
gitg_files_tree_store_get_entry_icon (GitgFilesTreeStore* self,
                                      GgitTreeEntry* entry)
{
	GIcon* icon = NULL;
	gboolean isdir = FALSE;
	GIcon* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (entry != NULL, NULL);
	isdir = ggit_tree_entry_get_file_mode (entry) == GGIT_FILE_MODE_TREE;
	if (isdir) {
		GThemedIcon* _tmp0_;
		_tmp0_ = (GThemedIcon*) g_themed_icon_new ("folder");
		_g_object_unref0 (icon);
		icon = (GIcon*) _tmp0_;
	} else {
		gchar* ct = NULL;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp1_ = ggit_tree_entry_get_name (entry);
		_tmp2_ = g_content_type_guess (_tmp1_, NULL, (gsize) 0, NULL);
		ct = _tmp2_;
		_tmp3_ = ct;
		if (g_content_type_is_unknown (_tmp3_)) {
			GThemedIcon* _tmp4_;
			_tmp4_ = (GThemedIcon*) g_themed_icon_new ("text-x-generic");
			_g_object_unref0 (icon);
			icon = (GIcon*) _tmp4_;
		} else {
			const gchar* _tmp5_;
			GIcon* _tmp6_;
			_tmp5_ = ct;
			_tmp6_ = g_content_type_get_icon (_tmp5_);
			_g_object_unref0 (icon);
			icon = _tmp6_;
		}
		_g_free0 (ct);
	}
	result = icon;
	return result;
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
_gitg_files_tree_store_item_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (gitg_files_tree_store_item_free (var), NULL));
}

static inline void
_g_list_free__gitg_files_tree_store_item_free0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _gitg_files_tree_store_item_free0_);
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		GitgFilesTreeStore* self;
		self = _data4_->self;
		_g_hash_table_unref0 (_data4_->paths);
		(_data4_->items == NULL) ? NULL : (_data4_->items = (_g_list_free__gitg_files_tree_store_item_free0_ (_data4_->items), NULL));
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static gpointer
_ggit_tree_entry_ref0 (gpointer self)
{
	return self ? ggit_tree_entry_ref (self) : NULL;
}

static gpointer
_gitg_files_tree_store_item_dup0 (gpointer self)
{
	return self ? gitg_files_tree_store_item_dup (self) : NULL;
}

static gint
___lambda4_ (Block4Data* _data4_,
             const gchar* root,
             GgitTreeEntry* entry)
{
	GitgFilesTreeStore* self;
	GitgFilesTreeStoreItem item = {0};
	gchar* _tmp0_;
	GgitTreeEntry* _tmp1_;
	GitgFilesTreeStoreItem _tmp2_;
	GitgFilesTreeStoreItem _tmp3_;
	GitgFilesTreeStoreItem* _tmp4_;
	gint result;
	self = _data4_->self;
	g_return_val_if_fail (root != NULL, 0);
	g_return_val_if_fail (entry != NULL, 0);
	memset (&item, 0, sizeof (GitgFilesTreeStoreItem));
	_tmp0_ = g_strdup (root);
	_g_free0 (item.root);
	item.root = _tmp0_;
	_tmp1_ = _ggit_tree_entry_ref0 (entry);
	_ggit_tree_entry_unref0 (item.entry);
	item.entry = _tmp1_;
	_tmp2_ = item;
	_tmp3_ = _tmp2_;
	_tmp4_ = _gitg_files_tree_store_item_dup0 (&_tmp3_);
	_data4_->items = g_list_prepend (_data4_->items, _tmp4_);
	result = 0;
	gitg_files_tree_store_item_destroy (&item);
	return result;
}

static gint
____lambda4__ggit_tree_walk_callback (const gchar* root,
                                      GgitTreeEntry* entry,
                                      gpointer self)
{
	gint result;
	result = ___lambda4_ (self, root, entry);
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
	g_boxed_free (gtk_tree_path_get_type (), self);
}

static void
__vala_GtkTreePath_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL));
}

static void
_vala_GtkTreeIter_free (GtkTreeIter* self)
{
	g_boxed_free (gtk_tree_iter_get_type (), self);
}

static GtkTreeIter*
_vala_GtkTreeIter_copy (GtkTreeIter* self)
{
	return g_boxed_copy (gtk_tree_iter_get_type (), self);
}

static gpointer
__vala_GtkTreeIter_copy0 (gpointer self)
{
	return self ? _vala_GtkTreeIter_copy (self) : NULL;
}

static gboolean
__lambda5_ (Block4Data* _data4_)
{
	GitgFilesTreeStore* self;
	GList* _tmp0_;
	GitgFilesTreeStoreItem item = {0};
	GList* _tmp1_;
	gconstpointer _tmp2_;
	GitgFilesTreeStoreItem _tmp3_;
	GitgFilesTreeStoreItem _tmp4_ = {0};
	GList* _tmp5_;
	gchar* root = NULL;
	GitgFilesTreeStoreItem _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GgitTreeEntry* entry = NULL;
	GitgFilesTreeStoreItem _tmp9_;
	GgitTreeEntry* _tmp10_;
	GgitTreeEntry* _tmp11_;
	gboolean isdir = FALSE;
	GgitTreeEntry* _tmp12_;
	GtkTreeIter* parent = NULL;
	const gchar* _tmp13_;
	GIcon* icon = NULL;
	GgitTreeEntry* _tmp20_;
	GIcon* _tmp21_;
	GtkTreeIter iter = {0};
	GtkTreeIter* _tmp22_;
	GtkTreeIter _tmp23_ = {0};
	GtkTreeIter _tmp24_;
	GIcon* _tmp25_;
	GgitTreeEntry* _tmp26_;
	const gchar* _tmp27_;
	GgitTreeEntry* _tmp28_;
	GgitOId* _tmp29_;
	GgitOId* _tmp30_;
	gboolean result;
	self = _data4_->self;
	_tmp0_ = _data4_->items;
	if (_tmp0_ == NULL) {
		self->priv->d_update_id = (guint) 0;
		result = FALSE;
		return result;
	}
	_tmp1_ = _data4_->items;
	_tmp2_ = _tmp1_->data;
	_tmp3_ = *((GitgFilesTreeStoreItem*) _tmp2_);
	gitg_files_tree_store_item_copy (&_tmp3_, &_tmp4_);
	item = _tmp4_;
	_tmp5_ = _data4_->items;
	_data4_->items = g_list_remove_link (_data4_->items, _tmp5_);
	_tmp6_ = item;
	_tmp7_ = _tmp6_.root;
	_tmp8_ = g_strdup (_tmp7_);
	root = _tmp8_;
	_tmp9_ = item;
	_tmp10_ = _tmp9_.entry;
	_tmp11_ = _ggit_tree_entry_ref0 (_tmp10_);
	entry = _tmp11_;
	_tmp12_ = entry;
	isdir = ggit_tree_entry_get_file_mode (_tmp12_) == GGIT_FILE_MODE_TREE;
	parent = NULL;
	_tmp13_ = root;
	if (g_strcmp0 (_tmp13_, "") != 0) {
		GHashTable* _tmp14_;
		const gchar* _tmp15_;
		gconstpointer _tmp16_;
		GtkTreeIter _tmp17_ = {0};
		GtkTreeIter _tmp18_;
		GtkTreeIter* _tmp19_;
		_tmp14_ = _data4_->paths;
		_tmp15_ = root;
		_tmp16_ = g_hash_table_lookup (_tmp14_, _tmp15_);
		gtk_tree_model_get_iter ((GtkTreeModel*) self, &_tmp17_, (GtkTreePath*) _tmp16_);
		__vala_GtkTreeIter_free0 (parent);
		_tmp18_ = _tmp17_;
		_tmp19_ = __vala_GtkTreeIter_copy0 (&_tmp18_);
		parent = _tmp19_;
	}
	_tmp20_ = entry;
	_tmp21_ = gitg_files_tree_store_get_entry_icon (self, _tmp20_);
	icon = _tmp21_;
	_tmp22_ = parent;
	gtk_tree_store_append ((GtkTreeStore*) self, &_tmp23_, _tmp22_);
	iter = _tmp23_;
	_tmp24_ = iter;
	_tmp25_ = icon;
	_tmp26_ = entry;
	_tmp27_ = ggit_tree_entry_get_name (_tmp26_);
	_tmp28_ = entry;
	_tmp29_ = ggit_tree_entry_get_id (_tmp28_);
	_tmp30_ = _tmp29_;
	gtk_tree_store_set ((GtkTreeStore*) self, &_tmp24_, 0, _tmp25_, 1, _tmp27_, 2, isdir, 3, _tmp30_, -1);
	__vala_GgitOId_free0 (_tmp30_);
	if (isdir) {
		gchar* path = NULL;
		const gchar* _tmp31_;
		GgitTreeEntry* _tmp32_;
		const gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		GHashTable* _tmp38_;
		const gchar* _tmp39_;
		gchar* _tmp40_;
		GtkTreeIter _tmp41_;
		GtkTreePath* _tmp42_;
		_tmp31_ = root;
		_tmp32_ = entry;
		_tmp33_ = ggit_tree_entry_get_name (_tmp32_);
		_tmp34_ = g_strconcat (_tmp31_, _tmp33_, NULL);
		_tmp35_ = _tmp34_;
		_tmp36_ = g_strconcat (_tmp35_, G_DIR_SEPARATOR_S, NULL);
		_tmp37_ = _tmp36_;
		_g_free0 (_tmp35_);
		path = _tmp37_;
		_tmp38_ = _data4_->paths;
		_tmp39_ = path;
		_tmp40_ = g_strdup (_tmp39_);
		_tmp41_ = iter;
		_tmp42_ = gtk_tree_model_get_path ((GtkTreeModel*) self, &_tmp41_);
		g_hash_table_insert (_tmp38_, _tmp40_, _tmp42_);
		_g_free0 (path);
	}
	result = TRUE;
	_g_object_unref0 (icon);
	__vala_GtkTreeIter_free0 (parent);
	_ggit_tree_entry_unref0 (entry);
	_g_free0 (root);
	gitg_files_tree_store_item_destroy (&item);
	return result;
}

static gboolean
___lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda5_ (self);
	return result;
}

static void
gitg_files_tree_store_update (GitgFilesTreeStore* self)
{
	Block4Data* _data4_;
	GgitTree* _tmp0_;
	GList* _tmp2_;
	GHashFunc _tmp3_;
	GEqualFunc _tmp4_;
	GHashTable* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	if (self->priv->d_update_id != ((guint) 0)) {
		g_source_remove (self->priv->d_update_id);
		self->priv->d_update_id = (guint) 0;
	}
	gtk_tree_store_clear ((GtkTreeStore*) self);
	_tmp0_ = self->priv->d_tree;
	if (_tmp0_ == NULL) {
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return;
	}
	_data4_->items = NULL;
	{
		GgitTree* _tmp1_;
		_tmp1_ = self->priv->d_tree;
		ggit_tree_walk (_tmp1_, GGIT_TREE_WALK_MODE_PRE, ____lambda4__ggit_tree_walk_callback, _data4_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		block4_data_unref (_data4_);
		_data4_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp2_ = _data4_->items;
	if (_tmp2_ == NULL) {
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return;
	}
	_data4_->items = g_list_reverse (_data4_->items);
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, __vala_GtkTreePath_free0_);
	_data4_->paths = _tmp5_;
	self->priv->d_update_id = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda5__gsource_func, block4_data_ref (_data4_), block4_data_unref);
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

GitgFilesTreeStore*
gitg_files_tree_store_construct (GType object_type)
{
	GitgFilesTreeStore * self = NULL;
	self = (GitgFilesTreeStore*) g_object_new (object_type, NULL);
	return self;
}

GitgFilesTreeStore*
gitg_files_tree_store_new (void)
{
	return gitg_files_tree_store_construct (GITG_FILES_TYPE_TREE_STORE);
}

GgitTree*
gitg_files_tree_store_get_tree (GitgFilesTreeStore* self)
{
	GgitTree* result;
	GgitTree* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->d_tree;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
gitg_files_tree_store_set_tree (GitgFilesTreeStore* self,
                                GgitTree* value)
{
	GgitTree* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->d_tree);
	self->priv->d_tree = _tmp0_;
	gitg_files_tree_store_update (self);
	g_object_notify_by_pspec ((GObject *) self, gitg_files_tree_store_properties[GITG_FILES_TREE_STORE_TREE_PROPERTY]);
}

static void
gitg_files_tree_store_item_copy (const GitgFilesTreeStoreItem* self,
                                 GitgFilesTreeStoreItem* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GgitTreeEntry* _tmp2_;
	GgitTreeEntry* _tmp3_;
	_tmp0_ = (*self).root;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).root);
	(*dest).root = _tmp1_;
	_tmp2_ = (*self).entry;
	_tmp3_ = _ggit_tree_entry_ref0 (_tmp2_);
	_ggit_tree_entry_unref0 ((*dest).entry);
	(*dest).entry = _tmp3_;
}

static void
gitg_files_tree_store_item_destroy (GitgFilesTreeStoreItem* self)
{
	_g_free0 ((*self).root);
	_ggit_tree_entry_unref0 ((*self).entry);
}

static GitgFilesTreeStoreItem*
gitg_files_tree_store_item_dup (const GitgFilesTreeStoreItem* self)
{
	GitgFilesTreeStoreItem* dup;
	dup = g_new0 (GitgFilesTreeStoreItem, 1);
	gitg_files_tree_store_item_copy (self, dup);
	return dup;
}

static void
gitg_files_tree_store_item_free (GitgFilesTreeStoreItem* self)
{
	gitg_files_tree_store_item_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
gitg_files_tree_store_item_get_type_once (void)
{
	GType gitg_files_tree_store_item_type_id;
	gitg_files_tree_store_item_type_id = g_boxed_type_register_static ("GitgFilesTreeStoreItem", (GBoxedCopyFunc) gitg_files_tree_store_item_dup, (GBoxedFreeFunc) gitg_files_tree_store_item_free);
	return gitg_files_tree_store_item_type_id;
}

static GType
gitg_files_tree_store_item_get_type (void)
{
	static gsize gitg_files_tree_store_item_type_id__once = 0;
	if (g_once_init_enter (&gitg_files_tree_store_item_type_id__once)) {
		GType gitg_files_tree_store_item_type_id;
		gitg_files_tree_store_item_type_id = gitg_files_tree_store_item_get_type_once ();
		g_once_init_leave (&gitg_files_tree_store_item_type_id__once, gitg_files_tree_store_item_type_id);
	}
	return gitg_files_tree_store_item_type_id__once;
}

static gint
_gitg_files_tree_store___lambda6_ (GitgFilesTreeStore* self,
                                   GtkTreeModel* model,
                                   GtkTreeIter* a,
                                   GtkTreeIter* b)
{
	gchar* aname = NULL;
	gchar* bname = NULL;
	gboolean aisdir = FALSE;
	gboolean bisdir = FALSE;
	GtkTreeIter _tmp0_;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	GtkTreeIter _tmp3_;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	gint result;
	g_return_val_if_fail (model != NULL, 0);
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = *a;
	gtk_tree_model_get (model, &_tmp0_, 1, &_tmp1_, 2, &_tmp2_, -1);
	_g_free0 (aname);
	aname = _tmp1_;
	aisdir = _tmp2_;
	_tmp3_ = *b;
	gtk_tree_model_get (model, &_tmp3_, 1, &_tmp4_, 2, &_tmp5_, -1);
	_g_free0 (bname);
	bname = _tmp4_;
	bisdir = _tmp5_;
	if (aisdir == bisdir) {
		GCompareFunc _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gint _tmp13_;
		_tmp6_ = ((GCompareFunc) g_strcmp0);
		_tmp7_ = aname;
		_tmp8_ = g_utf8_collate_key_for_filename (_tmp7_, (gssize) -1);
		_tmp9_ = _tmp8_;
		_tmp10_ = bname;
		_tmp11_ = g_utf8_collate_key_for_filename (_tmp10_, (gssize) -1);
		_tmp12_ = _tmp11_;
		_tmp13_ = _tmp6_ (_tmp9_, _tmp12_);
		_g_free0 (_tmp12_);
		_g_free0 (_tmp9_);
		result = _tmp13_;
		_g_free0 (bname);
		_g_free0 (aname);
		return result;
	} else {
		if (aisdir) {
			result = -1;
			_g_free0 (bname);
			_g_free0 (aname);
			return result;
		} else {
			result = 1;
			_g_free0 (bname);
			_g_free0 (aname);
			return result;
		}
	}
	_g_free0 (bname);
	_g_free0 (aname);
}

static gint
__gitg_files_tree_store___lambda6__gtk_tree_iter_compare_func (GtkTreeModel* model,
                                                               GtkTreeIter* a,
                                                               GtkTreeIter* b,
                                                               gpointer self)
{
	gint result;
	result = _gitg_files_tree_store___lambda6_ ((GitgFilesTreeStore*) self, model, a, b);
	return result;
}

static GObject *
gitg_files_tree_store_constructor (GType type,
                                   guint n_construct_properties,
                                   GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GitgFilesTreeStore * self;
	GType* _tmp0_;
	GType* _tmp1_;
	gint _tmp1__length1;
	parent_class = G_OBJECT_CLASS (gitg_files_tree_store_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_FILES_TYPE_TREE_STORE, GitgFilesTreeStore);
	_tmp0_ = g_new0 (GType, 4);
	_tmp0_[0] = g_icon_get_type ();
	_tmp0_[1] = G_TYPE_STRING;
	_tmp0_[2] = G_TYPE_BOOLEAN;
	_tmp0_[3] = ggit_oid_get_type ();
	_tmp1_ = _tmp0_;
	_tmp1__length1 = 4;
	gtk_tree_store_set_column_types ((GtkTreeStore*) self, (gint) 4, _tmp1_);
	_tmp1_ = (g_free (_tmp1_), NULL);
	gtk_tree_sortable_set_sort_func ((GtkTreeSortable*) self, 0, __gitg_files_tree_store___lambda6__gtk_tree_iter_compare_func, g_object_ref (self), g_object_unref);
	gtk_tree_sortable_set_sort_column_id ((GtkTreeSortable*) self, 0, GTK_SORT_ASCENDING);
	return obj;
}

static void
gitg_files_tree_store_class_init (GitgFilesTreeStoreClass * klass,
                                  gpointer klass_data)
{
	gitg_files_tree_store_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgFilesTreeStore_private_offset);
	((GObjectClass *) klass)->dispose = (void (*) (GObject*)) gitg_files_tree_store_real_dispose;
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_files_tree_store_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_files_tree_store_set_property;
	G_OBJECT_CLASS (klass)->constructor = gitg_files_tree_store_constructor;
	G_OBJECT_CLASS (klass)->finalize = gitg_files_tree_store_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_FILES_TREE_STORE_TREE_PROPERTY, gitg_files_tree_store_properties[GITG_FILES_TREE_STORE_TREE_PROPERTY] = g_param_spec_object ("tree", "tree", "tree", ggit_tree_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
gitg_files_tree_store_instance_init (GitgFilesTreeStore * self,
                                     gpointer klass)
{
	self->priv = gitg_files_tree_store_get_instance_private (self);
}

static void
gitg_files_tree_store_finalize (GObject * obj)
{
	GitgFilesTreeStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_FILES_TYPE_TREE_STORE, GitgFilesTreeStore);
	_g_object_unref0 (self->priv->d_tree);
	G_OBJECT_CLASS (gitg_files_tree_store_parent_class)->finalize (obj);
}

GType
gitg_files_tree_store_get_type (void)
{
	return gitg_files_tree_store_type_id;
}

GType
gitg_files_tree_store_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgFilesTreeStoreClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_files_tree_store_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgFilesTreeStore), 0, (GInstanceInitFunc) gitg_files_tree_store_instance_init, NULL };
	gitg_files_tree_store_type_id = g_type_module_register_type (module, gtk_tree_store_get_type (), "GitgFilesTreeStore", &g_define_type_info, 0);
	GitgFilesTreeStore_private_offset = sizeof (GitgFilesTreeStorePrivate);
	return gitg_files_tree_store_type_id;
}

static void
_vala_gitg_files_tree_store_get_property (GObject * object,
                                          guint property_id,
                                          GValue * value,
                                          GParamSpec * pspec)
{
	GitgFilesTreeStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_FILES_TYPE_TREE_STORE, GitgFilesTreeStore);
	switch (property_id) {
		case GITG_FILES_TREE_STORE_TREE_PROPERTY:
		g_value_set_object (value, gitg_files_tree_store_get_tree (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_files_tree_store_set_property (GObject * object,
                                          guint property_id,
                                          const GValue * value,
                                          GParamSpec * pspec)
{
	GitgFilesTreeStore * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_FILES_TYPE_TREE_STORE, GitgFilesTreeStore);
	switch (property_id) {
		case GITG_FILES_TREE_STORE_TREE_PROPERTY:
		gitg_files_tree_store_set_tree (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

