// Code generated by protoc-gen-go-grpc. DO NOT EDIT.
// versions:
// - protoc-gen-go-grpc v1.5.1
// - protoc             v6.30.2
// source: operations.proto

package gitalypb

import (
	context "context"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
)

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
// Requires gRPC-Go v1.64.0 or later.
const _ = grpc.SupportPackageIsVersion9

const (
	OperationService_UserCreateBranch_FullMethodName      = "/gitaly.OperationService/UserCreateBranch"
	OperationService_UserUpdateBranch_FullMethodName      = "/gitaly.OperationService/UserUpdateBranch"
	OperationService_UserDeleteBranch_FullMethodName      = "/gitaly.OperationService/UserDeleteBranch"
	OperationService_UserCreateTag_FullMethodName         = "/gitaly.OperationService/UserCreateTag"
	OperationService_UserDeleteTag_FullMethodName         = "/gitaly.OperationService/UserDeleteTag"
	OperationService_UserMergeToRef_FullMethodName        = "/gitaly.OperationService/UserMergeToRef"
	OperationService_UserRebaseToRef_FullMethodName       = "/gitaly.OperationService/UserRebaseToRef"
	OperationService_UserMergeBranch_FullMethodName       = "/gitaly.OperationService/UserMergeBranch"
	OperationService_UserFFBranch_FullMethodName          = "/gitaly.OperationService/UserFFBranch"
	OperationService_UserCherryPick_FullMethodName        = "/gitaly.OperationService/UserCherryPick"
	OperationService_UserCommitFiles_FullMethodName       = "/gitaly.OperationService/UserCommitFiles"
	OperationService_UserRebaseConfirmable_FullMethodName = "/gitaly.OperationService/UserRebaseConfirmable"
	OperationService_UserRevert_FullMethodName            = "/gitaly.OperationService/UserRevert"
	OperationService_UserSquash_FullMethodName            = "/gitaly.OperationService/UserSquash"
	OperationService_UserApplyPatch_FullMethodName        = "/gitaly.OperationService/UserApplyPatch"
	OperationService_UserUpdateSubmodule_FullMethodName   = "/gitaly.OperationService/UserUpdateSubmodule"
)

// OperationServiceClient is the client API for OperationService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://pkg.go.dev/google.golang.org/grpc/?tab=doc#ClientConn.NewStream.
//
// OperationService provides an interface for performing mutating git
// operations on a repository on behalf of a user. The user's operation is
// treated as untrusted. Any reference update is thus checked against GitLab's
// '/allowed' endpoint.
type OperationServiceClient interface {
	// UserCreateBranch creates a single branch in the context of a specific user. It executes
	// hooks and contacts Rails to verify that the user is allowed to create the branch. The
	// following known error conditions may happen:
	//
	//   - `FailedPrecondition` if the Git revision provided in start_point can't be found or updated.
	//   - `InvalidArgument` if the commit ID resolved from the start_point can't be parsed.
	//   - `PermissionDenied` with an embedded `UserCreateBranchError` if any custom hooks return a
	//     non-zero exit code.
	UserCreateBranch(ctx context.Context, in *UserCreateBranchRequest, opts ...grpc.CallOption) (*UserCreateBranchResponse, error)
	// UserUpdateBranch updates a branch to point to a new revision. It executes hooks and
	// contacts Rails to verify that the user is allowed to update the branch. The following
	// known error conditions may happen:
	//
	//   - `InvalidArgument` if any of the request fields can't be validated.
	//   - `Internal` if the newrev or oldrev are invalid in the context of the repository.
	//   - `UserUpdateBranchResponse` with the `PreReceiveError` field set, if any custom hooks
	//     return a non-zero exit code.
	UserUpdateBranch(ctx context.Context, in *UserUpdateBranchRequest, opts ...grpc.CallOption) (*UserUpdateBranchResponse, error)
	// UserDeleteBranch force-deletes a single branch in the context of a specific user. It executes
	// hooks and contacts Rails to verify that the user is indeed allowed to delete that branch. The
	// following known error conditions may happen:
	//
	//   - Returns `InvalidArgument` in case either the branch name or user are not set.
	//   - Returns `FailedPrecondition` in case the branch does not exist.
	//   - Returns `OK` with a `PreReceiveError` in case custom hooks refused the update. If the
	//     `gitaly_user_delete_branch_structured_errors` feature flag is enabled this error case will
	//     instead return `PermissionDenied` with either a `CustomHook` or AccessCheck` structured
	//     error.
	//   - Returns `FailedPrecondition` in case updating the reference fails because
	//     of a concurrent write to the same reference. If the
	//     `gitaly_user_delete_branch_structured_errors` feature flag is set this error case will
	//     instead return `FailedPrecondition` with a `ReferenceUpdate` structured error.
	UserDeleteBranch(ctx context.Context, in *UserDeleteBranchRequest, opts ...grpc.CallOption) (*UserDeleteBranchResponse, error)
	// UserCreateTag creates a new tag. This RPC knows to create both lightweight and annotated tags
	// depending on whether a message is set.
	UserCreateTag(ctx context.Context, in *UserCreateTagRequest, opts ...grpc.CallOption) (*UserCreateTagResponse, error)
	// UserDeleteTag deletes an existing tag. It executes hooks and contacts Rails to verify that
	// the user is allowed to delete the tag. The following known error conditions may happen:
	//
	//   - `InvalidArgument` if the repository, tag_name, user, or expected_old_oid (if provided)
	//     are invalid.
	//   - `FailedPrecondition` if the tag_name can't be found, or the ref couldn't be deleted due
	//     to a concurrent write to the same ref.
	//   - `Internal` if the tag_name can't be resolved or an unknown error occurs.
	UserDeleteTag(ctx context.Context, in *UserDeleteTagRequest, opts ...grpc.CallOption) (*UserDeleteTagResponse, error)
	// UserMergeToRef creates a merge commit and updates target_ref to point to that
	// new commit. The first parent of the merge commit (the main line) is taken
	// from first_parent_ref. The second parent is specified by its commit ID in source_sha.
	// If target_ref already exists it will be overwritten.
	UserMergeToRef(ctx context.Context, in *UserMergeToRefRequest, opts ...grpc.CallOption) (*UserMergeToRefResponse, error)
	// UserRebaseToRef rebases source_sha on top of first_parent_ref and updates
	// target_ref to point to that new commit. If target_ref already exists, then
	// it will be overwritten. This operation is intended to be used on internal
	// refs (e.g. refs/merge-requests/*) and does not call hooks.
	UserRebaseToRef(ctx context.Context, in *UserRebaseToRefRequest, opts ...grpc.CallOption) (*UserRebaseToRefResponse, error)
	// UserMergeBranch tries to merge the given commit into the target branch.
	// The merge commit is created with the given user as author/committer and
	// the given message.
	//
	// This is a two-stage RPC that requires confirmation to make user-visible
	// changes to the repository:
	//   - The first request contains details about the requested merge, which
	//     will result in a response with the created merge commit ID.
	//   - The second request should set `apply = true` to apply the merge.
	//
	// After the second request, it executes hooks and contacts Rails to verify
	// that the user is allowed to update the branch. The following known error
	// conditions may happen:
	//
	//   - `InvalidArgument` if request fields can't be validated or resolved.
	//   - `NotFound` if the branch can't be found.
	//   - `FailedPrecondition` if there are merge conflicts, if the merge is
	//     aborted by setting `apply = false` in the second request, or if the
	//     merge fails due to a concurrent write to the same ref.
	//   - `PermissionDenied` if the user doesn't have permissions to merge a branch.
	UserMergeBranch(ctx context.Context, opts ...grpc.CallOption) (grpc.BidiStreamingClient[UserMergeBranchRequest, UserMergeBranchResponse], error)
	// UserFFBranch tries to perform a fast-forward merge of a given commit into
	// the given branch. If the merge is not a fast-forward merge, the request
	// will fail. The RPC will return an empty response in case updating the
	// reference fails e.g. because of a race.
	UserFFBranch(ctx context.Context, in *UserFFBranchRequest, opts ...grpc.CallOption) (*UserFFBranchResponse, error)
	// UserCherryPick tries to perform a cherry-pick of a given commit onto a
	// branch.
	UserCherryPick(ctx context.Context, in *UserCherryPickRequest, opts ...grpc.CallOption) (*UserCherryPickResponse, error)
	// UserCommitFiles builds a commit from a stream of actions and updates the target branch to point to it.
	// userCommitFilesRequest with a UserCommitFilesRequestHeader must be sent as the first message of the stream.
	// Following that, a variable number of actions can be sent to build a new commit. Each action consists of
	// a header followed by content if used by the action.
	UserCommitFiles(ctx context.Context, opts ...grpc.CallOption) (grpc.ClientStreamingClient[UserCommitFilesRequest, UserCommitFilesResponse], error)
	// UserRebaseConfirmable rebases the given remote branch onto a target
	// branch. The remote branch may be part of another repository.
	//
	// This RPC requires confirmation to make any user-visible changes to the
	// repository. The first request sent shall contains details about the
	// requested rebase, which will result in a response with the created rebase
	// commit ID. Only if a second message with `apply = true` is sent will the
	// rebase be applied.
	UserRebaseConfirmable(ctx context.Context, opts ...grpc.CallOption) (grpc.BidiStreamingClient[UserRebaseConfirmableRequest, UserRebaseConfirmableResponse], error)
	// UserRevert tries to perform a revert of a given commit onto a branch.
	UserRevert(ctx context.Context, in *UserRevertRequest, opts ...grpc.CallOption) (*UserRevertResponse, error)
	// UserSquash squashes a range of commits into a single commit. If
	// successful, it returns the object ID of the newly created squash commit.
	// On error, it returns a gRPC error. Some specific errors will have an
	// embedded UserSquashError such that clients can deduce what exactly has
	// failed.
	UserSquash(ctx context.Context, in *UserSquashRequest, opts ...grpc.CallOption) (*UserSquashResponse, error)
	// UserApplyPatch applies patches to a given branch.
	UserApplyPatch(ctx context.Context, opts ...grpc.CallOption) (grpc.ClientStreamingClient[UserApplyPatchRequest, UserApplyPatchResponse], error)
	// UserUpdateSubmodule updates a submodule to point to a new commit.
	UserUpdateSubmodule(ctx context.Context, in *UserUpdateSubmoduleRequest, opts ...grpc.CallOption) (*UserUpdateSubmoduleResponse, error)
}

type operationServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewOperationServiceClient(cc grpc.ClientConnInterface) OperationServiceClient {
	return &operationServiceClient{cc}
}

func (c *operationServiceClient) UserCreateBranch(ctx context.Context, in *UserCreateBranchRequest, opts ...grpc.CallOption) (*UserCreateBranchResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(UserCreateBranchResponse)
	err := c.cc.Invoke(ctx, OperationService_UserCreateBranch_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationServiceClient) UserUpdateBranch(ctx context.Context, in *UserUpdateBranchRequest, opts ...grpc.CallOption) (*UserUpdateBranchResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(UserUpdateBranchResponse)
	err := c.cc.Invoke(ctx, OperationService_UserUpdateBranch_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationServiceClient) UserDeleteBranch(ctx context.Context, in *UserDeleteBranchRequest, opts ...grpc.CallOption) (*UserDeleteBranchResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(UserDeleteBranchResponse)
	err := c.cc.Invoke(ctx, OperationService_UserDeleteBranch_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationServiceClient) UserCreateTag(ctx context.Context, in *UserCreateTagRequest, opts ...grpc.CallOption) (*UserCreateTagResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(UserCreateTagResponse)
	err := c.cc.Invoke(ctx, OperationService_UserCreateTag_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationServiceClient) UserDeleteTag(ctx context.Context, in *UserDeleteTagRequest, opts ...grpc.CallOption) (*UserDeleteTagResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(UserDeleteTagResponse)
	err := c.cc.Invoke(ctx, OperationService_UserDeleteTag_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationServiceClient) UserMergeToRef(ctx context.Context, in *UserMergeToRefRequest, opts ...grpc.CallOption) (*UserMergeToRefResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(UserMergeToRefResponse)
	err := c.cc.Invoke(ctx, OperationService_UserMergeToRef_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationServiceClient) UserRebaseToRef(ctx context.Context, in *UserRebaseToRefRequest, opts ...grpc.CallOption) (*UserRebaseToRefResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(UserRebaseToRefResponse)
	err := c.cc.Invoke(ctx, OperationService_UserRebaseToRef_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationServiceClient) UserMergeBranch(ctx context.Context, opts ...grpc.CallOption) (grpc.BidiStreamingClient[UserMergeBranchRequest, UserMergeBranchResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &OperationService_ServiceDesc.Streams[0], OperationService_UserMergeBranch_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[UserMergeBranchRequest, UserMergeBranchResponse]{ClientStream: stream}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type OperationService_UserMergeBranchClient = grpc.BidiStreamingClient[UserMergeBranchRequest, UserMergeBranchResponse]

func (c *operationServiceClient) UserFFBranch(ctx context.Context, in *UserFFBranchRequest, opts ...grpc.CallOption) (*UserFFBranchResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(UserFFBranchResponse)
	err := c.cc.Invoke(ctx, OperationService_UserFFBranch_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationServiceClient) UserCherryPick(ctx context.Context, in *UserCherryPickRequest, opts ...grpc.CallOption) (*UserCherryPickResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(UserCherryPickResponse)
	err := c.cc.Invoke(ctx, OperationService_UserCherryPick_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationServiceClient) UserCommitFiles(ctx context.Context, opts ...grpc.CallOption) (grpc.ClientStreamingClient[UserCommitFilesRequest, UserCommitFilesResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &OperationService_ServiceDesc.Streams[1], OperationService_UserCommitFiles_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[UserCommitFilesRequest, UserCommitFilesResponse]{ClientStream: stream}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type OperationService_UserCommitFilesClient = grpc.ClientStreamingClient[UserCommitFilesRequest, UserCommitFilesResponse]

func (c *operationServiceClient) UserRebaseConfirmable(ctx context.Context, opts ...grpc.CallOption) (grpc.BidiStreamingClient[UserRebaseConfirmableRequest, UserRebaseConfirmableResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &OperationService_ServiceDesc.Streams[2], OperationService_UserRebaseConfirmable_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[UserRebaseConfirmableRequest, UserRebaseConfirmableResponse]{ClientStream: stream}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type OperationService_UserRebaseConfirmableClient = grpc.BidiStreamingClient[UserRebaseConfirmableRequest, UserRebaseConfirmableResponse]

func (c *operationServiceClient) UserRevert(ctx context.Context, in *UserRevertRequest, opts ...grpc.CallOption) (*UserRevertResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(UserRevertResponse)
	err := c.cc.Invoke(ctx, OperationService_UserRevert_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationServiceClient) UserSquash(ctx context.Context, in *UserSquashRequest, opts ...grpc.CallOption) (*UserSquashResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(UserSquashResponse)
	err := c.cc.Invoke(ctx, OperationService_UserSquash_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *operationServiceClient) UserApplyPatch(ctx context.Context, opts ...grpc.CallOption) (grpc.ClientStreamingClient[UserApplyPatchRequest, UserApplyPatchResponse], error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	stream, err := c.cc.NewStream(ctx, &OperationService_ServiceDesc.Streams[3], OperationService_UserApplyPatch_FullMethodName, cOpts...)
	if err != nil {
		return nil, err
	}
	x := &grpc.GenericClientStream[UserApplyPatchRequest, UserApplyPatchResponse]{ClientStream: stream}
	return x, nil
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type OperationService_UserApplyPatchClient = grpc.ClientStreamingClient[UserApplyPatchRequest, UserApplyPatchResponse]

func (c *operationServiceClient) UserUpdateSubmodule(ctx context.Context, in *UserUpdateSubmoduleRequest, opts ...grpc.CallOption) (*UserUpdateSubmoduleResponse, error) {
	cOpts := append([]grpc.CallOption{grpc.StaticMethod()}, opts...)
	out := new(UserUpdateSubmoduleResponse)
	err := c.cc.Invoke(ctx, OperationService_UserUpdateSubmodule_FullMethodName, in, out, cOpts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// OperationServiceServer is the server API for OperationService service.
// All implementations must embed UnimplementedOperationServiceServer
// for forward compatibility.
//
// OperationService provides an interface for performing mutating git
// operations on a repository on behalf of a user. The user's operation is
// treated as untrusted. Any reference update is thus checked against GitLab's
// '/allowed' endpoint.
type OperationServiceServer interface {
	// UserCreateBranch creates a single branch in the context of a specific user. It executes
	// hooks and contacts Rails to verify that the user is allowed to create the branch. The
	// following known error conditions may happen:
	//
	//   - `FailedPrecondition` if the Git revision provided in start_point can't be found or updated.
	//   - `InvalidArgument` if the commit ID resolved from the start_point can't be parsed.
	//   - `PermissionDenied` with an embedded `UserCreateBranchError` if any custom hooks return a
	//     non-zero exit code.
	UserCreateBranch(context.Context, *UserCreateBranchRequest) (*UserCreateBranchResponse, error)
	// UserUpdateBranch updates a branch to point to a new revision. It executes hooks and
	// contacts Rails to verify that the user is allowed to update the branch. The following
	// known error conditions may happen:
	//
	//   - `InvalidArgument` if any of the request fields can't be validated.
	//   - `Internal` if the newrev or oldrev are invalid in the context of the repository.
	//   - `UserUpdateBranchResponse` with the `PreReceiveError` field set, if any custom hooks
	//     return a non-zero exit code.
	UserUpdateBranch(context.Context, *UserUpdateBranchRequest) (*UserUpdateBranchResponse, error)
	// UserDeleteBranch force-deletes a single branch in the context of a specific user. It executes
	// hooks and contacts Rails to verify that the user is indeed allowed to delete that branch. The
	// following known error conditions may happen:
	//
	//   - Returns `InvalidArgument` in case either the branch name or user are not set.
	//   - Returns `FailedPrecondition` in case the branch does not exist.
	//   - Returns `OK` with a `PreReceiveError` in case custom hooks refused the update. If the
	//     `gitaly_user_delete_branch_structured_errors` feature flag is enabled this error case will
	//     instead return `PermissionDenied` with either a `CustomHook` or AccessCheck` structured
	//     error.
	//   - Returns `FailedPrecondition` in case updating the reference fails because
	//     of a concurrent write to the same reference. If the
	//     `gitaly_user_delete_branch_structured_errors` feature flag is set this error case will
	//     instead return `FailedPrecondition` with a `ReferenceUpdate` structured error.
	UserDeleteBranch(context.Context, *UserDeleteBranchRequest) (*UserDeleteBranchResponse, error)
	// UserCreateTag creates a new tag. This RPC knows to create both lightweight and annotated tags
	// depending on whether a message is set.
	UserCreateTag(context.Context, *UserCreateTagRequest) (*UserCreateTagResponse, error)
	// UserDeleteTag deletes an existing tag. It executes hooks and contacts Rails to verify that
	// the user is allowed to delete the tag. The following known error conditions may happen:
	//
	//   - `InvalidArgument` if the repository, tag_name, user, or expected_old_oid (if provided)
	//     are invalid.
	//   - `FailedPrecondition` if the tag_name can't be found, or the ref couldn't be deleted due
	//     to a concurrent write to the same ref.
	//   - `Internal` if the tag_name can't be resolved or an unknown error occurs.
	UserDeleteTag(context.Context, *UserDeleteTagRequest) (*UserDeleteTagResponse, error)
	// UserMergeToRef creates a merge commit and updates target_ref to point to that
	// new commit. The first parent of the merge commit (the main line) is taken
	// from first_parent_ref. The second parent is specified by its commit ID in source_sha.
	// If target_ref already exists it will be overwritten.
	UserMergeToRef(context.Context, *UserMergeToRefRequest) (*UserMergeToRefResponse, error)
	// UserRebaseToRef rebases source_sha on top of first_parent_ref and updates
	// target_ref to point to that new commit. If target_ref already exists, then
	// it will be overwritten. This operation is intended to be used on internal
	// refs (e.g. refs/merge-requests/*) and does not call hooks.
	UserRebaseToRef(context.Context, *UserRebaseToRefRequest) (*UserRebaseToRefResponse, error)
	// UserMergeBranch tries to merge the given commit into the target branch.
	// The merge commit is created with the given user as author/committer and
	// the given message.
	//
	// This is a two-stage RPC that requires confirmation to make user-visible
	// changes to the repository:
	//   - The first request contains details about the requested merge, which
	//     will result in a response with the created merge commit ID.
	//   - The second request should set `apply = true` to apply the merge.
	//
	// After the second request, it executes hooks and contacts Rails to verify
	// that the user is allowed to update the branch. The following known error
	// conditions may happen:
	//
	//   - `InvalidArgument` if request fields can't be validated or resolved.
	//   - `NotFound` if the branch can't be found.
	//   - `FailedPrecondition` if there are merge conflicts, if the merge is
	//     aborted by setting `apply = false` in the second request, or if the
	//     merge fails due to a concurrent write to the same ref.
	//   - `PermissionDenied` if the user doesn't have permissions to merge a branch.
	UserMergeBranch(grpc.BidiStreamingServer[UserMergeBranchRequest, UserMergeBranchResponse]) error
	// UserFFBranch tries to perform a fast-forward merge of a given commit into
	// the given branch. If the merge is not a fast-forward merge, the request
	// will fail. The RPC will return an empty response in case updating the
	// reference fails e.g. because of a race.
	UserFFBranch(context.Context, *UserFFBranchRequest) (*UserFFBranchResponse, error)
	// UserCherryPick tries to perform a cherry-pick of a given commit onto a
	// branch.
	UserCherryPick(context.Context, *UserCherryPickRequest) (*UserCherryPickResponse, error)
	// UserCommitFiles builds a commit from a stream of actions and updates the target branch to point to it.
	// userCommitFilesRequest with a UserCommitFilesRequestHeader must be sent as the first message of the stream.
	// Following that, a variable number of actions can be sent to build a new commit. Each action consists of
	// a header followed by content if used by the action.
	UserCommitFiles(grpc.ClientStreamingServer[UserCommitFilesRequest, UserCommitFilesResponse]) error
	// UserRebaseConfirmable rebases the given remote branch onto a target
	// branch. The remote branch may be part of another repository.
	//
	// This RPC requires confirmation to make any user-visible changes to the
	// repository. The first request sent shall contains details about the
	// requested rebase, which will result in a response with the created rebase
	// commit ID. Only if a second message with `apply = true` is sent will the
	// rebase be applied.
	UserRebaseConfirmable(grpc.BidiStreamingServer[UserRebaseConfirmableRequest, UserRebaseConfirmableResponse]) error
	// UserRevert tries to perform a revert of a given commit onto a branch.
	UserRevert(context.Context, *UserRevertRequest) (*UserRevertResponse, error)
	// UserSquash squashes a range of commits into a single commit. If
	// successful, it returns the object ID of the newly created squash commit.
	// On error, it returns a gRPC error. Some specific errors will have an
	// embedded UserSquashError such that clients can deduce what exactly has
	// failed.
	UserSquash(context.Context, *UserSquashRequest) (*UserSquashResponse, error)
	// UserApplyPatch applies patches to a given branch.
	UserApplyPatch(grpc.ClientStreamingServer[UserApplyPatchRequest, UserApplyPatchResponse]) error
	// UserUpdateSubmodule updates a submodule to point to a new commit.
	UserUpdateSubmodule(context.Context, *UserUpdateSubmoduleRequest) (*UserUpdateSubmoduleResponse, error)
	mustEmbedUnimplementedOperationServiceServer()
}

// UnimplementedOperationServiceServer must be embedded to have
// forward compatible implementations.
//
// NOTE: this should be embedded by value instead of pointer to avoid a nil
// pointer dereference when methods are called.
type UnimplementedOperationServiceServer struct{}

func (UnimplementedOperationServiceServer) UserCreateBranch(context.Context, *UserCreateBranchRequest) (*UserCreateBranchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserCreateBranch not implemented")
}
func (UnimplementedOperationServiceServer) UserUpdateBranch(context.Context, *UserUpdateBranchRequest) (*UserUpdateBranchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserUpdateBranch not implemented")
}
func (UnimplementedOperationServiceServer) UserDeleteBranch(context.Context, *UserDeleteBranchRequest) (*UserDeleteBranchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserDeleteBranch not implemented")
}
func (UnimplementedOperationServiceServer) UserCreateTag(context.Context, *UserCreateTagRequest) (*UserCreateTagResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserCreateTag not implemented")
}
func (UnimplementedOperationServiceServer) UserDeleteTag(context.Context, *UserDeleteTagRequest) (*UserDeleteTagResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserDeleteTag not implemented")
}
func (UnimplementedOperationServiceServer) UserMergeToRef(context.Context, *UserMergeToRefRequest) (*UserMergeToRefResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserMergeToRef not implemented")
}
func (UnimplementedOperationServiceServer) UserRebaseToRef(context.Context, *UserRebaseToRefRequest) (*UserRebaseToRefResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserRebaseToRef not implemented")
}
func (UnimplementedOperationServiceServer) UserMergeBranch(grpc.BidiStreamingServer[UserMergeBranchRequest, UserMergeBranchResponse]) error {
	return status.Errorf(codes.Unimplemented, "method UserMergeBranch not implemented")
}
func (UnimplementedOperationServiceServer) UserFFBranch(context.Context, *UserFFBranchRequest) (*UserFFBranchResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserFFBranch not implemented")
}
func (UnimplementedOperationServiceServer) UserCherryPick(context.Context, *UserCherryPickRequest) (*UserCherryPickResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserCherryPick not implemented")
}
func (UnimplementedOperationServiceServer) UserCommitFiles(grpc.ClientStreamingServer[UserCommitFilesRequest, UserCommitFilesResponse]) error {
	return status.Errorf(codes.Unimplemented, "method UserCommitFiles not implemented")
}
func (UnimplementedOperationServiceServer) UserRebaseConfirmable(grpc.BidiStreamingServer[UserRebaseConfirmableRequest, UserRebaseConfirmableResponse]) error {
	return status.Errorf(codes.Unimplemented, "method UserRebaseConfirmable not implemented")
}
func (UnimplementedOperationServiceServer) UserRevert(context.Context, *UserRevertRequest) (*UserRevertResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserRevert not implemented")
}
func (UnimplementedOperationServiceServer) UserSquash(context.Context, *UserSquashRequest) (*UserSquashResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserSquash not implemented")
}
func (UnimplementedOperationServiceServer) UserApplyPatch(grpc.ClientStreamingServer[UserApplyPatchRequest, UserApplyPatchResponse]) error {
	return status.Errorf(codes.Unimplemented, "method UserApplyPatch not implemented")
}
func (UnimplementedOperationServiceServer) UserUpdateSubmodule(context.Context, *UserUpdateSubmoduleRequest) (*UserUpdateSubmoduleResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UserUpdateSubmodule not implemented")
}
func (UnimplementedOperationServiceServer) mustEmbedUnimplementedOperationServiceServer() {}
func (UnimplementedOperationServiceServer) testEmbeddedByValue()                          {}

// UnsafeOperationServiceServer may be embedded to opt out of forward compatibility for this service.
// Use of this interface is not recommended, as added methods to OperationServiceServer will
// result in compilation errors.
type UnsafeOperationServiceServer interface {
	mustEmbedUnimplementedOperationServiceServer()
}

func RegisterOperationServiceServer(s grpc.ServiceRegistrar, srv OperationServiceServer) {
	// If the following call pancis, it indicates UnimplementedOperationServiceServer was
	// embedded by pointer and is nil.  This will cause panics if an
	// unimplemented method is ever invoked, so we test this at initialization
	// time to prevent it from happening at runtime later due to I/O.
	if t, ok := srv.(interface{ testEmbeddedByValue() }); ok {
		t.testEmbeddedByValue()
	}
	s.RegisterService(&OperationService_ServiceDesc, srv)
}

func _OperationService_UserCreateBranch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserCreateBranchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationServiceServer).UserCreateBranch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OperationService_UserCreateBranch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationServiceServer).UserCreateBranch(ctx, req.(*UserCreateBranchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OperationService_UserUpdateBranch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserUpdateBranchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationServiceServer).UserUpdateBranch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OperationService_UserUpdateBranch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationServiceServer).UserUpdateBranch(ctx, req.(*UserUpdateBranchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OperationService_UserDeleteBranch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserDeleteBranchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationServiceServer).UserDeleteBranch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OperationService_UserDeleteBranch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationServiceServer).UserDeleteBranch(ctx, req.(*UserDeleteBranchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OperationService_UserCreateTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserCreateTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationServiceServer).UserCreateTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OperationService_UserCreateTag_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationServiceServer).UserCreateTag(ctx, req.(*UserCreateTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OperationService_UserDeleteTag_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserDeleteTagRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationServiceServer).UserDeleteTag(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OperationService_UserDeleteTag_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationServiceServer).UserDeleteTag(ctx, req.(*UserDeleteTagRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OperationService_UserMergeToRef_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserMergeToRefRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationServiceServer).UserMergeToRef(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OperationService_UserMergeToRef_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationServiceServer).UserMergeToRef(ctx, req.(*UserMergeToRefRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OperationService_UserRebaseToRef_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserRebaseToRefRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationServiceServer).UserRebaseToRef(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OperationService_UserRebaseToRef_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationServiceServer).UserRebaseToRef(ctx, req.(*UserRebaseToRefRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OperationService_UserMergeBranch_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(OperationServiceServer).UserMergeBranch(&grpc.GenericServerStream[UserMergeBranchRequest, UserMergeBranchResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type OperationService_UserMergeBranchServer = grpc.BidiStreamingServer[UserMergeBranchRequest, UserMergeBranchResponse]

func _OperationService_UserFFBranch_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserFFBranchRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationServiceServer).UserFFBranch(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OperationService_UserFFBranch_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationServiceServer).UserFFBranch(ctx, req.(*UserFFBranchRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OperationService_UserCherryPick_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserCherryPickRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationServiceServer).UserCherryPick(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OperationService_UserCherryPick_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationServiceServer).UserCherryPick(ctx, req.(*UserCherryPickRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OperationService_UserCommitFiles_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(OperationServiceServer).UserCommitFiles(&grpc.GenericServerStream[UserCommitFilesRequest, UserCommitFilesResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type OperationService_UserCommitFilesServer = grpc.ClientStreamingServer[UserCommitFilesRequest, UserCommitFilesResponse]

func _OperationService_UserRebaseConfirmable_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(OperationServiceServer).UserRebaseConfirmable(&grpc.GenericServerStream[UserRebaseConfirmableRequest, UserRebaseConfirmableResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type OperationService_UserRebaseConfirmableServer = grpc.BidiStreamingServer[UserRebaseConfirmableRequest, UserRebaseConfirmableResponse]

func _OperationService_UserRevert_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserRevertRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationServiceServer).UserRevert(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OperationService_UserRevert_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationServiceServer).UserRevert(ctx, req.(*UserRevertRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OperationService_UserSquash_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserSquashRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationServiceServer).UserSquash(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OperationService_UserSquash_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationServiceServer).UserSquash(ctx, req.(*UserSquashRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OperationService_UserApplyPatch_Handler(srv interface{}, stream grpc.ServerStream) error {
	return srv.(OperationServiceServer).UserApplyPatch(&grpc.GenericServerStream[UserApplyPatchRequest, UserApplyPatchResponse]{ServerStream: stream})
}

// This type alias is provided for backwards compatibility with existing code that references the prior non-generic stream type by name.
type OperationService_UserApplyPatchServer = grpc.ClientStreamingServer[UserApplyPatchRequest, UserApplyPatchResponse]

func _OperationService_UserUpdateSubmodule_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UserUpdateSubmoduleRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OperationServiceServer).UserUpdateSubmodule(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: OperationService_UserUpdateSubmodule_FullMethodName,
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OperationServiceServer).UserUpdateSubmodule(ctx, req.(*UserUpdateSubmoduleRequest))
	}
	return interceptor(ctx, in, info, handler)
}

// OperationService_ServiceDesc is the grpc.ServiceDesc for OperationService service.
// It's only intended for direct use with grpc.RegisterService,
// and not to be introspected or modified (even as a copy)
var OperationService_ServiceDesc = grpc.ServiceDesc{
	ServiceName: "gitaly.OperationService",
	HandlerType: (*OperationServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "UserCreateBranch",
			Handler:    _OperationService_UserCreateBranch_Handler,
		},
		{
			MethodName: "UserUpdateBranch",
			Handler:    _OperationService_UserUpdateBranch_Handler,
		},
		{
			MethodName: "UserDeleteBranch",
			Handler:    _OperationService_UserDeleteBranch_Handler,
		},
		{
			MethodName: "UserCreateTag",
			Handler:    _OperationService_UserCreateTag_Handler,
		},
		{
			MethodName: "UserDeleteTag",
			Handler:    _OperationService_UserDeleteTag_Handler,
		},
		{
			MethodName: "UserMergeToRef",
			Handler:    _OperationService_UserMergeToRef_Handler,
		},
		{
			MethodName: "UserRebaseToRef",
			Handler:    _OperationService_UserRebaseToRef_Handler,
		},
		{
			MethodName: "UserFFBranch",
			Handler:    _OperationService_UserFFBranch_Handler,
		},
		{
			MethodName: "UserCherryPick",
			Handler:    _OperationService_UserCherryPick_Handler,
		},
		{
			MethodName: "UserRevert",
			Handler:    _OperationService_UserRevert_Handler,
		},
		{
			MethodName: "UserSquash",
			Handler:    _OperationService_UserSquash_Handler,
		},
		{
			MethodName: "UserUpdateSubmodule",
			Handler:    _OperationService_UserUpdateSubmodule_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "UserMergeBranch",
			Handler:       _OperationService_UserMergeBranch_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "UserCommitFiles",
			Handler:       _OperationService_UserCommitFiles_Handler,
			ClientStreams: true,
		},
		{
			StreamName:    "UserRebaseConfirmable",
			Handler:       _OperationService_UserRebaseConfirmable_Handler,
			ServerStreams: true,
			ClientStreams: true,
		},
		{
			StreamName:    "UserApplyPatch",
			Handler:       _OperationService_UserApplyPatch_Handler,
			ClientStreams: true,
		},
	},
	Metadata: "operations.proto",
}
