
// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "kcoreaddons_python.h"

// main header
#include "kcompositejob_wrapper.h"

// Wrappers providing overrides
#include "kjobtrackerinterface_wrapper.h"
#include "kjob_wrapper.h"
#include "ksignalhandler_wrapper.h"
#include "kprocess_wrapper.h"
#include "kjobuidelegate_wrapper.h"

// Argument includes
#include <QList>
#include <QString>
#include <kjob.h>
#include <qobject.h>
#include <qobjectdefs.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_KCompositeJob_Type = nullptr;
static PyTypeObject *Sbk_KCompositeJob_TypeF(void)
{
    return _Sbk_KCompositeJob_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void KCompositeJobWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

KCompositeJobWrapper::KCompositeJobWrapper(::QObject * parent) : KCompositeJob(parent)
{
}

bool KCompositeJobWrapper::addSubjob(::KJob * job)
{
    static const char *funcName = "addSubjob";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCompositeJob_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::KCompositeJob::addSubjob(job);
    }
    return KJobUiDelegateWrapper::sbk_o_setJob("KCompositeJob", funcName, gil, pyOverride, job);
}

void KCompositeJobWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCompositeJob_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    KSignalHandlerWrapper::sbk_o_childEvent("KCompositeJob", funcName, gil, pyOverride, event);
}

void KCompositeJobWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCompositeJob_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    KSignalHandlerWrapper::sbk_o_connectNotify("KCompositeJob", funcName, gil, pyOverride, signal);
}

void KCompositeJobWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCompositeJob_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    KSignalHandlerWrapper::sbk_o_customEvent("KCompositeJob", funcName, gil, pyOverride, event);
}

void KCompositeJobWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCompositeJob_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    KSignalHandlerWrapper::sbk_o_connectNotify("KCompositeJob", funcName, gil, pyOverride, signal);
}

bool KCompositeJobWrapper::doKill()
{
    static const char *funcName = "doKill";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCompositeJob_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJob::doKill();
    }
    return KProcessWrapper::sbk_o_atEnd("KCompositeJob", funcName, gil, pyOverride);
}

bool KCompositeJobWrapper::doResume()
{
    static const char *funcName = "doResume";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCompositeJob_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJob::doResume();
    }
    return KProcessWrapper::sbk_o_atEnd("KCompositeJob", funcName, gil, pyOverride);
}

bool KCompositeJobWrapper::doSuspend()
{
    static const char *funcName = "doSuspend";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCompositeJob_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJob::doSuspend();
    }
    return KProcessWrapper::sbk_o_atEnd("KCompositeJob", funcName, gil, pyOverride);
}

::QString KCompositeJobWrapper::errorString() const
{
    // This method belongs to a property.
    static const char *funcName = "1:errorString";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCompositeJob_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::KJob::errorString();
    }
    return KJobWrapper::sbk_o_errorString("KCompositeJob", funcName, gil, pyOverride);
}

bool KCompositeJobWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCompositeJob_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return KSignalHandlerWrapper::sbk_o_event("KCompositeJob", funcName, gil, pyOverride, event);
}

bool KCompositeJobWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCompositeJob_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return KSignalHandlerWrapper::sbk_o_eventFilter("KCompositeJob", funcName, gil, pyOverride, watched, event);
}

bool KCompositeJobWrapper::removeSubjob(::KJob * job)
{
    static const char *funcName = "removeSubjob";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCompositeJob_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::KCompositeJob::removeSubjob(job);
    }
    return KJobUiDelegateWrapper::sbk_o_setJob("KCompositeJob", funcName, gil, pyOverride, job);
}

void KCompositeJobWrapper::slotInfoMessage(::KJob * job, const ::QString & message)
{
    static const char *funcName = "slotInfoMessage";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCompositeJob_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::KCompositeJob::slotInfoMessage(job, message);
    }
    KJobUiDelegateWrapper::sbk_o_slotWarning("KCompositeJob", funcName, gil, pyOverride, job, message);
}

void KCompositeJobWrapper::slotResult(::KJob * job)
{
    static const char *funcName = "slotResult";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCompositeJob_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::KCompositeJob::slotResult(job);
    }
    KJobTrackerInterfaceWrapper::sbk_o_finished("KCompositeJob", funcName, gil, pyOverride, job);
}

void KCompositeJobWrapper::start()
{
    static const char *funcName = "start";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCompositeJob_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("KCompositeJob.start");
        return;
    }
    KJobUiDelegateWrapper::sbk_o_showErrorMessage("KCompositeJob", funcName, gil, pyOverride);
}

void KCompositeJobWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_KCompositeJob_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    KSignalHandlerWrapper::sbk_o_timerEvent("KCompositeJob", funcName, gil, pyOverride, event);
}

const QMetaObject *KCompositeJobWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return KCompositeJob::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int KCompositeJobWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = KCompositeJob::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *KCompositeJobWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< KCompositeJobWrapper *>(this));
    }
    return KCompositeJob::qt_metacast(_clname);
}

KCompositeJobWrapper::~KCompositeJobWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_KCompositeJob_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_KCompositeJob_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(args)
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PyTypeObject *type = self->ob_type;
    PyTypeObject *myType = Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KCompositeJob_IDX]);
    if (type == myType) {
        Shiboken::Errors::setInstantiateAbstractClass("KCompositeJob");
        return -1;
    }

    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::KCompositeJob >()))
        return -1;

    KCompositeJobWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:KCompositeJob", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: KCompositeJob::KCompositeJob(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // KCompositeJob(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // KCompositeJob(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCompositeJob_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkKCoreAddonsTypeStructs[SBK_KCompositeJob_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCompositeJob_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // KCompositeJob(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) KCompositeJobWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new KCompositeJobWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< KCompositeJob >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCompositeJob_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCompositeJob_IDX]);
    };


    return 1;
}

static PyObject *Sbk_KCompositeJobFunc_addSubjob(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCompositeJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KCompositeJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KCompositeJob::addSubjob(KJob*)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // addSubjob(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "addSubjob", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCompositeJob_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addSubjob(KJob*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KCompositeJob::addSubjob(cppArg0)
                : cppSelf->addSubjob(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KCompositeJobFunc_clearSubjobs(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCompositeJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KCompositeJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // clearSubjobs()
        cppSelf->clearSubjobs();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KCompositeJobFunc_hasSubjobs(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCompositeJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KCompositeJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // hasSubjobs()const
        bool cppResult = const_cast<const ::KCompositeJob *>(cppSelf)->hasSubjobs();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KCompositeJobFunc_removeSubjob(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCompositeJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KCompositeJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KCompositeJob::removeSubjob(KJob*)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // removeSubjob(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeSubjob", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCompositeJob_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // removeSubjob(KJob*)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KCompositeJob::removeSubjob(cppArg0)
                : cppSelf->removeSubjob(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_KCompositeJobFunc_slotInfoMessage(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCompositeJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KCompositeJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "slotInfoMessage", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: KCompositeJob::slotInfoMessage(KJob*,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))) {
        overloadId = 0; // slotInfoMessage(KJob*,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "slotInfoMessage", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCompositeJob_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::KJob *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // slotInfoMessage(KJob*,QString)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KCompositeJob::slotInfoMessage(cppArg0, cppArg1)
                : cppSelf->slotInfoMessage(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KCompositeJobFunc_slotResult(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCompositeJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KCompositeJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: KCompositeJob::slotResult(KJob*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]), (pyArg)))) {
        overloadId = 0; // slotResult(KJob*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "slotResult", errInfo, SbkKCoreAddonsTypeStructs[SBK_KCompositeJob_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::KJob *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // slotResult(KJob*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::KCompositeJob::slotResult(cppArg0)
                : cppSelf->slotResult(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_KCompositeJobFunc_subjobs(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::KCompositeJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KCompositeJob_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // subjobs()const
        const QList<KJob*> & cppResult = const_cast<const ::KCompositeJob *>(cppSelf)->subjobs();
        pyResult = Shiboken::Conversions::copyToPython(SbkKCoreAddonsTypeConverters[SBK_KCoreAddons_QList_KJobPTR_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_KCompositeJob_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_KCompositeJob_methods[] = {
    {"addSubjob", reinterpret_cast<PyCFunction>(Sbk_KCompositeJobFunc_addSubjob), METH_O, nullptr},
    {"clearSubjobs", reinterpret_cast<PyCFunction>(Sbk_KCompositeJobFunc_clearSubjobs), METH_NOARGS, nullptr},
    {"hasSubjobs", reinterpret_cast<PyCFunction>(Sbk_KCompositeJobFunc_hasSubjobs), METH_NOARGS, nullptr},
    {"removeSubjob", reinterpret_cast<PyCFunction>(Sbk_KCompositeJobFunc_removeSubjob), METH_O, nullptr},
    {"slotInfoMessage", reinterpret_cast<PyCFunction>(Sbk_KCompositeJobFunc_slotInfoMessage), METH_VARARGS, nullptr},
    {"slotResult", reinterpret_cast<PyCFunction>(Sbk_KCompositeJobFunc_slotResult), METH_O, nullptr},
    {"subjobs", reinterpret_cast<PyCFunction>(Sbk_KCompositeJobFunc_subjobs), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_KCompositeJob_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::KCompositeJob *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KCompositeJob_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<KCompositeJobWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_KCompositeJob_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_KCompositeJob_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_KCompositeJob_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_KCompositeJob_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_KCompositeJob_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_KCompositeJob_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_KCompositeJob_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_KCompositeJob_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_KCompositeJob_spec = {
    "1:KCoreAddons.KCompositeJob",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_KCompositeJob_slots
};

} //extern "C"

static void *Sbk_KCompositeJob_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::KCompositeJob *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void KCompositeJob_PythonToCpp_KCompositeJob_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_KCompositeJob_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_KCompositeJob_PythonToCpp_KCompositeJob_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_KCompositeJob_TypeF()))
        return KCompositeJob_PythonToCpp_KCompositeJob_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *KCompositeJob_PTR_CppToPython_KCompositeJob(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::KCompositeJob *>(const_cast<void *>(cppIn)), Sbk_KCompositeJob_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *KCompositeJob_SignatureStrings[] = {
    "KCoreAddons.KCompositeJob(self,parent:PySide6.QtCore.QObject=nullptr)",
    "KCoreAddons.KCompositeJob.addSubjob(self,job:KCoreAddons.KJob)->bool",
    "KCoreAddons.KCompositeJob.clearSubjobs(self)",
    "KCoreAddons.KCompositeJob.hasSubjobs(self)->bool",
    "KCoreAddons.KCompositeJob.removeSubjob(self,job:KCoreAddons.KJob)->bool",
    "KCoreAddons.KCompositeJob.slotInfoMessage(self,job:KCoreAddons.KJob,message:QString)",
    "KCoreAddons.KCompositeJob.slotResult(self,job:KCoreAddons.KJob)",
    "KCoreAddons.KCompositeJob.subjobs(self)->QList[KCoreAddons.KJob]",
    nullptr}; // Sentinel
#else
static constexpr size_t KCompositeJob_SignatureByteSize = 180;
static constexpr uint8_t KCompositeJob_SignatureBytes[180] = {
    0x78, 0xda, 0xa5, 0xd0, 0xb1, 0x0e, 0x82, 0x30, 0x10, 0x80, 0xe1, 0x9d, 0x27, 0x91, 0x04, 0x19,
    0x1d, 0x48, 0x34, 0x31, 0x4c, 0x8a, 0x46, 0x2b, 0xa3, 0x71, 0x68, 0xe9, 0x81, 0x90, 0xd2, 0x23,
    0xbd, 0xc3, 0xc4, 0xb7, 0x17, 0x25, 0x0e, 0x98, 0x00, 0x83, 0xdb, 0x0d, 0x7f, 0xbf, 0x5e, 0x2e,
    0x89, 0xd1, 0xc1, 0x56, 0x6b, 0xb4, 0x14, 0x26, 0x31, 0xd6, 0x0d, 0x52, 0xc9, 0xb0, 0x47, 0xb5,
    0x20, 0x30, 0x79, 0xd0, 0x48, 0x07, 0x96, 0xa3, 0xf3, 0x33, 0x2d, 0x35, 0xac, 0x42, 0xc1, 0xef,
    0x3c, 0x14, 0x27, 0x55, 0x41, 0xc6, 0x6b, 0xdb, 0x1a, 0xd3, 0xb0, 0xf3, 0xbd, 0x64, 0x4c, 0x09,
    0xa5, 0xd6, 0x69, 0xab, 0xaa, 0xaf, 0xd7, 0x0d, 0xd1, 0x20, 0xee, 0x1a, 0x7f, 0xb9, 0x51, 0x88,
    0x66, 0x02, 0xc9, 0x0c, 0x48, 0xd7, 0x33, 0xf4, 0x71, 0xa6, 0x7e, 0xbc, 0x4b, 0x1a, 0xa4, 0xb3,
    0xba, 0x83, 0x1a, 0x1f, 0xf0, 0xff, 0x96, 0x64, 0x90, 0x77, 0x36, 0xc7, 0x23, 0x10, 0xc9, 0x02,
    0xc6, 0xa9, 0xa0, 0xee, 0x8b, 0x48, 0xa4, 0xec, 0x4a, 0x5b, 0xf8, 0x33, 0xe8, 0x05, 0xa8, 0x35,
    0x3c, 0xb1, 0xda, 0xd4, 0xfb, 0xe1, 0x29, 0xc4, 0xa1, 0x24, 0xbe, 0xfe, 0x02, 0x37, 0xef, 0x05,
    0x17, 0x07, 0xbc, 0x90
};
#endif

PyTypeObject *init_KCompositeJob(PyObject *module)
{
    if (SbkKCoreAddonsTypeStructs[SBK_KCompositeJob_IDX].type != nullptr)
        return SbkKCoreAddonsTypeStructs[SBK_KCompositeJob_IDX].type;

    Shiboken::AutoDecRef Sbk_KCompositeJob_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkKCoreAddonsTypeStructs[SBK_KJob_IDX]))));

    _Sbk_KCompositeJob_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "KCompositeJob",
        "KCompositeJob*",
        &Sbk_KCompositeJob_spec,
        &Shiboken::callCppDestructor< KCompositeJob >,
        Sbk_KCompositeJob_Type_bases.object(),
        0);
    auto *pyType = _Sbk_KCompositeJob_Type; // references _Sbk_KCompositeJob_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, KCompositeJob_SignatureStrings);
#else
    InitSignatureBytes(pyType, KCompositeJob_SignatureBytes, KCompositeJob_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_KCompositeJob_PropertyStrings);
    SbkKCoreAddonsTypeStructs[SBK_KCompositeJob_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        KCompositeJob_PythonToCpp_KCompositeJob_PTR,
        is_KCompositeJob_PythonToCpp_KCompositeJob_PTR_Convertible,
        KCompositeJob_PTR_CppToPython_KCompositeJob);

    Shiboken::Conversions::registerConverterName(converter, "KCompositeJob");
    Shiboken::Conversions::registerConverterName(converter, "KCompositeJob*");
    Shiboken::Conversions::registerConverterName(converter, "KCompositeJob&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::KCompositeJob).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(KCompositeJobWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_KCompositeJob_TypeF(), &Sbk_KCompositeJob_typeDiscovery);

    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::KCompositeJob::staticMetaObject, sizeof(KCompositeJobWrapper));

    return pyType;
}
