/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 16 "gram.y"

#include "./dbpmda.h"
#include "./lex.h"

extern int stmt_type;

static union {
    pmID	whole;
    __pmID_int	part;
} pmid;

static union {
    pmInDom		whole;
    __pmInDom_int	part;
} indom;


static int	inst;
static char	*str;
#define MYWARNSTRSZ 80
static char	warnStr[MYWARNSTRSZ];

param_t	param;

/*
 * pmidp may contain a dynamic PMID ... if so, ask the PMDA to
 * translate name if possible
 */
static int
fix_dynamic_pmid(const char *name, pmID *pmidp)
{
    int		sts;
    __pmPDU	*pb;
    extern int	toPMDA;
    extern int	fromPMDA;
    extern pmdaInterface	dispatch;

    if (IS_DYNAMIC_ROOT(*pmidp)) {
	if (connmode == CONN_DSO) {
	    if (dispatch.comm.pmda_interface >= PMDA_INTERFACE_4) {
		sts = dispatch.version.four.pmid(name, pmidp, dispatch.version.four.ext);
		if (sts < 0) return sts;
	    }
	}
	else if (connmode == CONN_DAEMON) {
	    sts = __pmSendNameList(toPMDA, FROM_ANON, 1, &name, NULL);
	    if (sts < 0) return sts;
	    sts = __pmGetPDU(fromPMDA, ANY_SIZE, TIMEOUT_NEVER, &pb);
	    if (sts < 0) return sts;
	    if (sts == PDU_PMNS_IDS) {
		int	xsts;
		sts = __pmDecodeIDList(pb, 1, pmidp, &xsts);
		__pmUnpinPDUBuf(pb);
		if (sts < 0) return sts;
		return xsts;
	    }
	    else if (sts == PDU_ERROR) {
		__pmDecodeError(pb, &sts);
		__pmUnpinPDUBuf(pb);
		return sts;
	    }
	}
    }
    return 0;
}



#line 140 "gram.tab.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "gram.tab.h"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_NUMBER2D = 3,                   /* NUMBER2D  */
  YYSYMBOL_NUMBER3D = 4,                   /* NUMBER3D  */
  YYSYMBOL_NUMBER = 5,                     /* NUMBER  */
  YYSYMBOL_NEGNUMBER = 6,                  /* NEGNUMBER  */
  YYSYMBOL_FLAG = 7,                       /* FLAG  */
  YYSYMBOL_NAME = 8,                       /* NAME  */
  YYSYMBOL_PATHNAME = 9,                   /* PATHNAME  */
  YYSYMBOL_MACRO = 10,                     /* MACRO  */
  YYSYMBOL_STRING = 11,                    /* STRING  */
  YYSYMBOL_NEGNAME = 12,                   /* NEGNAME  */
  YYSYMBOL_COMMA = 13,                     /* COMMA  */
  YYSYMBOL_EQUAL = 14,                     /* EQUAL  */
  YYSYMBOL_OPEN = 15,                      /* OPEN  */
  YYSYMBOL_CLOSE = 16,                     /* CLOSE  */
  YYSYMBOL_DESC = 17,                      /* DESC  */
  YYSYMBOL_GETDESC = 18,                   /* GETDESC  */
  YYSYMBOL_GETINAME = 19,                  /* GETINAME  */
  YYSYMBOL_FETCH = 20,                     /* FETCH  */
  YYSYMBOL_INSTANCE = 21,                  /* INSTANCE  */
  YYSYMBOL_PROFILE = 22,                   /* PROFILE  */
  YYSYMBOL_HELP = 23,                      /* HELP  */
  YYSYMBOL_WATCH = 24,                     /* WATCH  */
  YYSYMBOL_DBG = 25,                       /* DBG  */
  YYSYMBOL_QUIT = 26,                      /* QUIT  */
  YYSYMBOL_STATUS = 27,                    /* STATUS  */
  YYSYMBOL_STORE = 28,                     /* STORE  */
  YYSYMBOL_INFO = 29,                      /* INFO  */
  YYSYMBOL_TIMER = 30,                     /* TIMER  */
  YYSYMBOL_NAMESPACE = 31,                 /* NAMESPACE  */
  YYSYMBOL_WAIT = 32,                      /* WAIT  */
  YYSYMBOL_PMNS_NAME = 33,                 /* PMNS_NAME  */
  YYSYMBOL_PMNS_PMID = 34,                 /* PMNS_PMID  */
  YYSYMBOL_PMNS_CHILDREN = 35,             /* PMNS_CHILDREN  */
  YYSYMBOL_PMNS_TRAVERSE = 36,             /* PMNS_TRAVERSE  */
  YYSYMBOL_ATTR = 37,                      /* ATTR  */
  YYSYMBOL_LABEL = 38,                     /* LABEL  */
  YYSYMBOL_CTXT = 39,                      /* CTXT  */
  YYSYMBOL_DOMAIN = 40,                    /* DOMAIN  */
  YYSYMBOL_INDOM = 41,                     /* INDOM  */
  YYSYMBOL_CLUSTER = 42,                   /* CLUSTER  */
  YYSYMBOL_ITEM = 43,                      /* ITEM  */
  YYSYMBOL_INSTANCES = 44,                 /* INSTANCES  */
  YYSYMBOL_DSO = 45,                       /* DSO  */
  YYSYMBOL_PIPE = 46,                      /* PIPE  */
  YYSYMBOL_SOCK = 47,                      /* SOCK  */
  YYSYMBOL_UNIX = 48,                      /* UNIX  */
  YYSYMBOL_INET = 49,                      /* INET  */
  YYSYMBOL_IPV6 = 50,                      /* IPV6  */
  YYSYMBOL_ADD = 51,                       /* ADD  */
  YYSYMBOL_DEL = 52,                       /* DEL  */
  YYSYMBOL_ALL = 53,                       /* ALL  */
  YYSYMBOL_NONE = 54,                      /* NONE  */
  YYSYMBOL_ON = 55,                        /* ON  */
  YYSYMBOL_OFF = 56,                       /* OFF  */
  YYSYMBOL_PLUS = 57,                      /* PLUS  */
  YYSYMBOL_EOL = 58,                       /* EOL  */
  YYSYMBOL_YYACCEPT = 59,                  /* $accept  */
  YYSYMBOL_stmt = 60,                      /* stmt  */
  YYSYMBOL_fname = 61,                     /* fname  */
  YYSYMBOL_optdomain = 62,                 /* optdomain  */
  YYSYMBOL_attribute = 63,                 /* attribute  */
  YYSYMBOL_servport = 64,                  /* servport  */
  YYSYMBOL_metric = 65,                    /* metric  */
  YYSYMBOL_cluster = 66,                   /* cluster  */
  YYSYMBOL_indom = 67,                     /* indom  */
  YYSYMBOL_raw_pmid = 68,                  /* raw_pmid  */
  YYSYMBOL_metriclist = 69,                /* metriclist  */
  YYSYMBOL_arglist = 70,                   /* arglist  */
  YYSYMBOL_inst = 71,                      /* inst  */
  YYSYMBOL_debug = 72,                     /* debug  */
  YYSYMBOL_flag = 73                       /* flag  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_uint8 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  128
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   259

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  59
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  15
/* YYNRULES -- Number of rules.  */
#define YYNRULES  128
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  231

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   313


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   137,   137,   141,   145,   149,   153,   157,   161,   165,
     168,   172,   176,   180,   183,   187,   192,   196,   201,   206,
     210,   216,   222,   228,   232,   242,   252,   264,   276,   280,
     284,   288,   292,   296,   300,   304,   308,   312,   316,   320,
     324,   329,   334,   338,   342,   346,   351,   356,   361,   367,
     371,   375,   379,   383,   387,   391,   395,   399,   403,   407,
     411,   415,   419,   423,   427,   431,   435,   439,   443,   447,
     451,   455,   459,   464,   465,   469,   478,   487,   490,   493,
     497,   500,   503,   507,   510,   513,   517,   520,   523,   527,
     530,   531,   541,   552,   555,   556,   559,   568,   579,   580,
     593,   606,   621,   637,   652,   656,   664,   668,   672,   680,
     689,   690,   691,   695,   698,   699,   702,   714,   727,   739,
     751,   764,   784,   785,   786,   787,   788,   789,   790
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "NUMBER2D", "NUMBER3D",
  "NUMBER", "NEGNUMBER", "FLAG", "NAME", "PATHNAME", "MACRO", "STRING",
  "NEGNAME", "COMMA", "EQUAL", "OPEN", "CLOSE", "DESC", "GETDESC",
  "GETINAME", "FETCH", "INSTANCE", "PROFILE", "HELP", "WATCH", "DBG",
  "QUIT", "STATUS", "STORE", "INFO", "TIMER", "NAMESPACE", "WAIT",
  "PMNS_NAME", "PMNS_PMID", "PMNS_CHILDREN", "PMNS_TRAVERSE", "ATTR",
  "LABEL", "CTXT", "DOMAIN", "INDOM", "CLUSTER", "ITEM", "INSTANCES",
  "DSO", "PIPE", "SOCK", "UNIX", "INET", "IPV6", "ADD", "DEL", "ALL",
  "NONE", "ON", "OFF", "PLUS", "EOL", "$accept", "stmt", "fname",
  "optdomain", "attribute", "servport", "metric", "cluster", "indom",
  "raw_pmid", "metriclist", "arglist", "inst", "debug", "flag", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-92)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-1)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
     132,    16,   -12,    17,    22,    34,    23,    33,    39,   167,
      21,    45,    -7,     1,    29,     2,    68,   108,    13,     0,
      27,    46,    48,    12,   175,   -92,    76,   108,   108,    64,
     -92,   -92,   -92,   -92,   -92,   -92,   -92,    10,    25,    47,
     -92,    49,    51,   -92,   -92,   -92,    11,   -92,   -92,   -92,
     -92,    44,   -92,    85,    53,    62,    70,    75,    83,    86,
      87,   113,   114,   115,   116,   117,   118,   119,   120,   121,
     122,   123,   149,   150,   152,   153,   154,   -92,   -92,   -92,
     -92,   162,   -92,   -92,   -92,   -92,   -92,   -92,   -92,   -92,
     164,   166,   -92,    88,   -92,   -92,   -92,   -92,   111,   137,
     -92,   168,   169,   170,   -92,   171,   172,   -92,   -92,   -92,
     173,   174,   -92,   176,   -92,   177,   -92,   -92,   -92,   -92,
      37,   178,   179,   137,    61,   127,   137,   -92,   -92,   231,
     -92,   108,    36,    36,   -92,   -92,   -92,   -92,   -92,   -92,
     127,   -92,   -92,   183,   -92,   -92,   -92,   185,   239,   240,
     188,   189,   -92,   -92,   -92,   -92,   -92,   -92,   -92,   -92,
     -92,   -92,   -92,   -92,   -92,   -92,   -92,   -92,   -92,   -92,
     -92,   -92,   -92,   -92,   -92,   -92,   -92,   -92,   -92,   201,
     -92,   -92,   190,   191,   -92,   -92,   -92,   -92,   -92,   -92,
     -92,   -92,   -92,   192,   -92,   -92,   -92,   193,   -92,   -92,
     194,   195,   196,   250,   -92,   -92,   -92,   -92,   -92,   -92,
     -92,   -92,   -92,   198,   199,   -92,   -92,   -92,   -92,   -92,
     -92,   -92,   -92,   -92,   -92,   -92,   -92,   200,   -92,   -92,
     -92
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
      91,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    90,     0,     0,     0,     0,
       2,     9,   101,   102,   100,   103,    10,     0,     0,     0,
      82,     0,     0,    85,    12,   110,     0,   108,   106,   107,
      19,     0,    23,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    49,    92,    93,
      28,     0,   116,   122,   123,   124,   125,   128,   126,   127,
       0,     0,    74,     0,   117,    73,    78,    14,     0,     0,
      16,     0,     0,     0,    79,     0,     0,    88,   109,    30,
       0,     0,    32,     0,    34,     0,    36,    96,    97,    39,
       0,     0,     0,     0,     0,     0,     0,    42,     1,     0,
     113,     0,     0,     0,     5,    11,    83,    84,    86,    87,
       0,    13,   111,     0,   115,   114,    20,     0,     0,     0,
       0,     0,    61,    51,    53,    55,    56,    54,    58,    66,
      72,    52,    67,    68,    69,    57,    70,    60,    71,    63,
      64,    62,    65,    50,    59,    29,    75,    76,   118,     0,
      77,   120,     0,     0,    17,    80,    81,    38,    89,    31,
      33,    35,    37,     0,    40,    43,    44,     0,   105,   104,
       0,     0,     0,    95,     4,     6,    98,    99,     7,     8,
     112,    21,    22,     0,     0,    24,    25,   119,   121,    15,
      18,    41,    45,    46,    47,    48,    94,     0,    26,    27,
       3
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int8 yypgoto[] =
{
     -92,   -92,   -16,   -92,   -92,   126,    -6,   -92,    -5,   -92,
     -92,   -92,   -92,   -92,   -91
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_uint8 yydefgoto[] =
{
       0,    26,    81,   227,   120,   208,    37,   200,    51,   110,
      46,   204,   147,    93,    94
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_uint8 yytable[] =
{
      45,   105,   181,    53,   108,    32,    33,    34,    98,   101,
      35,   129,   130,   134,    32,    33,    34,   117,   106,    35,
      32,    33,    34,   118,   140,    35,    32,    33,    34,    78,
      79,    35,    32,    33,    34,   111,    47,    35,    48,    49,
     142,   206,    47,    99,    48,    49,    31,   207,   193,   143,
      82,    95,   144,    83,   113,   145,   115,    84,   109,    96,
     100,    27,    28,    29,   198,    85,   199,    86,   135,   141,
     119,   107,    78,    79,    30,    36,   128,    38,    39,    80,
      40,    44,    87,   136,    88,   112,    89,    97,   218,    41,
      42,    50,    43,   178,   183,   194,    83,    52,    90,    91,
      84,   179,   146,    92,   114,   137,   116,   138,    85,   139,
      86,   152,   131,   132,   133,   205,    78,    79,   197,   201,
     153,   202,   182,   102,   103,    87,   104,    88,   154,    89,
      32,    33,    34,   155,   210,    35,   148,   149,   150,   151,
      47,   156,    48,    49,   157,   158,   180,     1,     2,     3,
       4,     5,     6,     7,     8,     9,    10,    11,    12,    13,
      14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,   159,   160,   161,   162,   163,   164,   165,   166,   167,
     168,   169,    54,    55,    56,    57,    58,    59,    60,    61,
      25,    62,    63,    64,    65,    66,    67,    68,    69,    70,
      71,    72,    73,    74,    75,    76,   217,   170,   171,    83,
     172,   173,   174,    84,   121,   122,   123,   124,   125,   126,
     175,    85,   176,    86,   177,    77,   184,   185,   186,   187,
     188,   189,   190,   127,   191,   192,   195,   196,    87,   203,
      88,   211,    89,   212,   213,   214,   215,   216,   219,   220,
     221,   222,   223,   224,   225,   226,   228,   229,   230,   209
};

static const yytype_uint8 yycheck[] =
{
       6,    17,    93,     8,     4,     3,     4,     5,    14,    15,
       8,    27,    28,    29,     3,     4,     5,     5,     5,     8,
       3,     4,     5,    11,    13,     8,     3,     4,     5,     8,
       9,     8,     3,     4,     5,     8,     3,     8,     5,     6,
      46,     5,     3,    41,     5,     6,    58,    11,    11,     5,
       5,    58,     8,     8,     8,    11,     8,    12,    58,    58,
      58,    45,    46,    47,     3,    20,     5,    22,    58,    58,
      58,    58,     8,     9,    58,    58,     0,    55,    56,    58,
      58,    58,    37,    58,    39,    58,    41,    58,   179,    55,
      56,    58,    58,     5,    99,    58,     8,    58,    53,    54,
      12,    13,    58,    58,    58,    58,    58,    58,    20,    58,
      22,    58,    48,    49,    50,   131,     8,     9,   123,   125,
      58,   126,    11,    55,    56,    37,    58,    39,    58,    41,
       3,     4,     5,    58,   140,     8,    51,    52,    53,    54,
       3,    58,     5,     6,    58,    58,    58,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    34,    35,    36,    37,
      38,    58,    58,    58,    58,    58,    58,    58,    58,    58,
      58,    58,    15,    16,    17,    18,    19,    20,    21,    22,
      58,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,    36,    37,    38,     5,    58,    58,     8,
      58,    58,    58,    12,    39,    40,    41,    42,    43,    44,
      58,    20,    58,    22,    58,    58,    58,    58,    58,    58,
      58,    58,    58,    58,    58,    58,    58,    58,    37,     8,
      39,    58,    41,    58,     5,     5,    58,    58,    58,    58,
      58,    58,    58,    58,    58,     5,    58,    58,    58,   133
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int8 yystos[] =
{
       0,    15,    16,    17,    18,    19,    20,    21,    22,    23,
      24,    25,    26,    27,    28,    29,    30,    31,    32,    33,
      34,    35,    36,    37,    38,    58,    60,    45,    46,    47,
      58,    58,     3,     4,     5,     8,    58,    65,    55,    56,
      58,    55,    56,    58,    58,    65,    69,     3,     5,     6,
      58,    67,    58,    67,    15,    16,    17,    18,    19,    20,
      21,    22,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,    36,    37,    38,    58,     8,     9,
      58,    61,     5,     8,    12,    20,    22,    37,    39,    41,
      53,    54,    58,    72,    73,    58,    58,    58,    65,    41,
      58,    65,    55,    56,    58,    61,     5,    58,     4,    58,
      68,     8,    58,     8,    58,     8,    58,     5,    11,    58,
      63,    39,    40,    41,    42,    43,    44,    58,     0,    61,
      61,    48,    49,    50,    61,    58,    58,    58,    58,    58,
      13,    58,    65,     5,     8,    11,    58,    71,    51,    52,
      53,    54,    58,    58,    58,    58,    58,    58,    58,    58,
      58,    58,    58,    58,    58,    58,    58,    58,    58,    58,
      58,    58,    58,    58,    58,    58,    58,    58,     5,    13,
      58,    73,    11,    67,    58,    58,    58,    58,    58,    58,
      58,    58,    58,    11,    58,    58,    58,    67,     3,     5,
      66,    65,    67,     8,    70,    61,     5,    11,    64,    64,
      65,    58,    58,     5,     5,    58,    58,     5,    73,    58,
      58,    58,    58,    58,    58,    58,     5,    62,    58,    58,
      58
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr1[] =
{
       0,    59,    60,    60,    60,    60,    60,    60,    60,    60,
      60,    60,    60,    60,    60,    60,    60,    60,    60,    60,
      60,    60,    60,    60,    60,    60,    60,    60,    60,    60,
      60,    60,    60,    60,    60,    60,    60,    60,    60,    60,
      60,    60,    60,    60,    60,    60,    60,    60,    60,    60,
      60,    60,    60,    60,    60,    60,    60,    60,    60,    60,
      60,    60,    60,    60,    60,    60,    60,    60,    60,    60,
      60,    60,    60,    60,    60,    60,    60,    60,    60,    60,
      60,    60,    60,    60,    60,    60,    60,    60,    60,    60,
      60,    60,    61,    61,    62,    62,    63,    63,    64,    64,
      65,    65,    65,    65,    66,    66,    67,    67,    67,    68,
      69,    69,    69,    70,    71,    71,    72,    72,    72,    72,
      72,    72,    73,    73,    73,    73,    73,    73,    73
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     2,     6,     4,     3,     4,     4,     4,     2,
       2,     3,     2,     3,     2,     4,     2,     3,     4,     2,
       3,     4,     4,     2,     4,     4,     5,     5,     2,     3,
       2,     3,     2,     3,     2,     3,     2,     3,     3,     2,
       3,     4,     2,     3,     3,     4,     4,     4,     4,     2,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     2,     2,     3,     3,     3,     2,     2,
       3,     3,     2,     3,     3,     2,     3,     3,     2,     3,
       1,     0,     1,     1,     1,     0,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     2,     3,     0,     1,     1,     1,     1,     2,     3,
       2,     3,     1,     1,     1,     1,     1,     1,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 2: /* stmt: OPEN EOL  */
#line 137 "gram.y"
                                                {
		param.number = OPEN; param.pmid = HELP_USAGE;
		stmt_type = HELP; YYACCEPT;
	    }
#line 1361 "gram.tab.c"
    break;

  case 3: /* stmt: OPEN DSO fname NAME optdomain EOL  */
#line 141 "gram.y"
                                                {
		opendso((yyvsp[-3].y_str), (yyvsp[-2].y_str), (yyvsp[-1].y_num));
		stmt_type = OPEN; YYACCEPT;
	    }
#line 1370 "gram.tab.c"
    break;

  case 4: /* stmt: OPEN PIPE fname arglist  */
#line 145 "gram.y"
                                                {
		openpmda((yyvsp[-1].y_str));
		stmt_type = OPEN; YYACCEPT;
	    }
#line 1379 "gram.tab.c"
    break;

  case 5: /* stmt: OPEN SOCK fname  */
#line 149 "gram.y"
                                                {
		open_unix_socket((yyvsp[0].y_str));
		stmt_type = OPEN; YYACCEPT;
	    }
#line 1388 "gram.tab.c"
    break;

  case 6: /* stmt: OPEN SOCK UNIX fname  */
#line 153 "gram.y"
                                                {
		open_unix_socket((yyvsp[0].y_str));
		stmt_type = OPEN; YYACCEPT;
	    }
#line 1397 "gram.tab.c"
    break;

  case 7: /* stmt: OPEN SOCK INET servport  */
#line 157 "gram.y"
                                                {
		open_inet_socket((yyvsp[0].y_num));
		stmt_type = OPEN; YYACCEPT;
	    }
#line 1406 "gram.tab.c"
    break;

  case 8: /* stmt: OPEN SOCK IPV6 servport  */
#line 161 "gram.y"
                                                {
		open_ipv6_socket((yyvsp[0].y_num));
		stmt_type = OPEN; YYACCEPT;
	    }
#line 1415 "gram.tab.c"
    break;

  case 9: /* stmt: CLOSE EOL  */
#line 165 "gram.y"
                                                { 
		stmt_type = CLOSE; YYACCEPT; 
	    }
#line 1423 "gram.tab.c"
    break;

  case 10: /* stmt: DESC EOL  */
#line 168 "gram.y"
                                                {
		param.number = DESC; param.pmid = HELP_USAGE;
		stmt_type = HELP; YYACCEPT;
	    }
#line 1432 "gram.tab.c"
    break;

  case 11: /* stmt: DESC metric EOL  */
#line 172 "gram.y"
                                                {
		param.pmid = (yyvsp[-1].y_num);
		stmt_type = DESC; YYACCEPT;
	    }
#line 1441 "gram.tab.c"
    break;

  case 12: /* stmt: FETCH EOL  */
#line 176 "gram.y"
                                                {
		param.number = FETCH; param.pmid = HELP_USAGE;
		stmt_type = HELP; YYACCEPT;
	    }
#line 1450 "gram.tab.c"
    break;

  case 13: /* stmt: FETCH metriclist EOL  */
#line 180 "gram.y"
                                                { 
		stmt_type = FETCH; YYACCEPT; 
	    }
#line 1458 "gram.tab.c"
    break;

  case 14: /* stmt: STORE EOL  */
#line 183 "gram.y"
                                                {
		param.number = STORE; param.pmid = HELP_USAGE;
		stmt_type = HELP; YYACCEPT;
	    }
#line 1467 "gram.tab.c"
    break;

  case 15: /* stmt: STORE metric STRING EOL  */
#line 187 "gram.y"
                                                {
		param.name = (yyvsp[-1].y_str);
		param.pmid = (pmID)(yyvsp[-2].y_num);
		stmt_type = STORE; YYACCEPT;
	    }
#line 1477 "gram.tab.c"
    break;

  case 16: /* stmt: INFO EOL  */
#line 192 "gram.y"
                                                {
		param.number = INFO; param.pmid = HELP_USAGE;
		stmt_type = HELP; YYACCEPT;
	    }
#line 1486 "gram.tab.c"
    break;

  case 17: /* stmt: INFO metric EOL  */
#line 196 "gram.y"
                                                {
		param.number = PM_TEXT_PMID;
		param.pmid = (pmID)(yyvsp[-1].y_num);
		stmt_type = INFO; YYACCEPT;
	    }
#line 1496 "gram.tab.c"
    break;

  case 18: /* stmt: INFO INDOM indom EOL  */
#line 201 "gram.y"
                                                {
		param.number = PM_TEXT_INDOM;
		param.indom = indom.whole;
		stmt_type = INFO; YYACCEPT;
	    }
#line 1506 "gram.tab.c"
    break;

  case 19: /* stmt: INSTANCE EOL  */
#line 206 "gram.y"
                                                {
		param.number = INSTANCE; param.pmid = HELP_USAGE;
		stmt_type = HELP; YYACCEPT;
	    }
#line 1515 "gram.tab.c"
    break;

  case 20: /* stmt: INSTANCE indom EOL  */
#line 210 "gram.y"
                                                {
		param.indom = indom.whole;
		param.number = PM_IN_NULL;
		param.name = NULL;
		stmt_type = INSTANCE; YYACCEPT;
	    }
#line 1526 "gram.tab.c"
    break;

  case 21: /* stmt: INSTANCE indom NUMBER EOL  */
#line 216 "gram.y"
                                                {
		param.indom = indom.whole;
		param.number = (yyvsp[-1].y_num);
		param.name = NULL;
		stmt_type = INSTANCE; YYACCEPT;
	    }
#line 1537 "gram.tab.c"
    break;

  case 22: /* stmt: INSTANCE indom inst EOL  */
#line 222 "gram.y"
                                                {
		param.indom = indom.whole;
		param.number = PM_IN_NULL;
		param.name = (yyvsp[-1].y_str);
		stmt_type = INSTANCE; YYACCEPT;
	    }
#line 1548 "gram.tab.c"
    break;

  case 23: /* stmt: PROFILE EOL  */
#line 228 "gram.y"
                                                {
		param.number = PROFILE; param.pmid = HELP_USAGE;
		stmt_type = HELP; YYACCEPT;
	    }
#line 1557 "gram.tab.c"
    break;

  case 24: /* stmt: PROFILE indom ALL EOL  */
#line 232 "gram.y"
                                                {
		int sts = pmAddProfile((yyvsp[-2].y_num), 0, NULL);
		if (sts < 0) {
		    yyerror(pmErrStr(sts));
		    YYERROR;
		}
		profile_changed = 1;
		stmt_type = EOL;
		YYACCEPT;
	    }
#line 1572 "gram.tab.c"
    break;

  case 25: /* stmt: PROFILE indom NONE EOL  */
#line 242 "gram.y"
                                                {
		int sts = pmDelProfile((yyvsp[-2].y_num), 0, NULL);
		if (sts < 0) {
		    yyerror(pmErrStr(sts));
		    YYERROR;
		}
		profile_changed = 1;
		stmt_type = EOL;
		YYACCEPT;
	    }
#line 1587 "gram.tab.c"
    break;

  case 26: /* stmt: PROFILE indom ADD NUMBER EOL  */
#line 252 "gram.y"
                                                {
		int sts;
		inst = (yyvsp[-1].y_num);
		sts = pmAddProfile((yyvsp[-3].y_num), 1, &inst);
		if (sts < 0) {
		    yyerror(pmErrStr(sts));
		    YYERROR;
		}
		profile_changed = 1;
		stmt_type = EOL;
		YYACCEPT;
	    }
#line 1604 "gram.tab.c"
    break;

  case 27: /* stmt: PROFILE indom DEL NUMBER EOL  */
#line 264 "gram.y"
                                                {
		int sts;
		inst = (yyvsp[-1].y_num);
		sts = pmDelProfile((yyvsp[-3].y_num), 1, &inst);
		if (sts < 0) {
		    yyerror(pmErrStr(sts));
		    YYERROR;
		}
		profile_changed = 1;
		stmt_type = EOL;
		YYACCEPT;
	    }
#line 1621 "gram.tab.c"
    break;

  case 28: /* stmt: WATCH EOL  */
#line 276 "gram.y"
                                                {
		param.number = WATCH; param.pmid = HELP_USAGE;
		stmt_type = HELP; YYACCEPT;
	    }
#line 1630 "gram.tab.c"
    break;

  case 29: /* stmt: WATCH fname EOL  */
#line 280 "gram.y"
                                                {
		watch((yyvsp[-1].y_str));
		stmt_type = WATCH; YYACCEPT;
	    }
#line 1639 "gram.tab.c"
    break;

  case 30: /* stmt: PMNS_NAME EOL  */
#line 284 "gram.y"
                                                {
		param.number = PMNS_NAME; param.pmid = HELP_USAGE;
		stmt_type = HELP; YYACCEPT;
	    }
#line 1648 "gram.tab.c"
    break;

  case 31: /* stmt: PMNS_NAME raw_pmid EOL  */
#line 288 "gram.y"
                                                {
		param.pmid = (yyvsp[-1].y_num);
		stmt_type = PMNS_NAME; YYACCEPT;
	    }
#line 1657 "gram.tab.c"
    break;

  case 32: /* stmt: PMNS_PMID EOL  */
#line 292 "gram.y"
                                                {
		param.number = PMNS_PMID; param.pmid = HELP_USAGE;
		stmt_type = HELP; YYACCEPT;
	    }
#line 1666 "gram.tab.c"
    break;

  case 33: /* stmt: PMNS_PMID NAME EOL  */
#line 296 "gram.y"
                                                {
		param.name = (yyvsp[-1].y_str);
		stmt_type = PMNS_PMID; YYACCEPT;
	    }
#line 1675 "gram.tab.c"
    break;

  case 34: /* stmt: PMNS_CHILDREN EOL  */
#line 300 "gram.y"
                                                {
		param.number = PMNS_CHILDREN; param.pmid = HELP_USAGE;
		stmt_type = HELP; YYACCEPT;
	    }
#line 1684 "gram.tab.c"
    break;

  case 35: /* stmt: PMNS_CHILDREN NAME EOL  */
#line 304 "gram.y"
                                                {
		param.name = (yyvsp[-1].y_str);
		stmt_type = PMNS_CHILDREN; YYACCEPT;
	    }
#line 1693 "gram.tab.c"
    break;

  case 36: /* stmt: PMNS_TRAVERSE EOL  */
#line 308 "gram.y"
                                                {
		param.number = PMNS_TRAVERSE; param.pmid = HELP_USAGE;
		stmt_type = HELP; YYACCEPT;
	    }
#line 1702 "gram.tab.c"
    break;

  case 37: /* stmt: PMNS_TRAVERSE NAME EOL  */
#line 312 "gram.y"
                                                {
		param.name = (yyvsp[-1].y_str);
		stmt_type = PMNS_TRAVERSE; YYACCEPT;
	    }
#line 1711 "gram.tab.c"
    break;

  case 38: /* stmt: NAMESPACE fname EOL  */
#line 316 "gram.y"
                                                {
		param.name = (yyvsp[-1].y_str);
		stmt_type = NAMESPACE; YYACCEPT;
	    }
#line 1720 "gram.tab.c"
    break;

  case 39: /* stmt: ATTR EOL  */
#line 320 "gram.y"
                                                {
		param.number = ATTR; param.pmid = HELP_USAGE;
		stmt_type = HELP; YYACCEPT;
	    }
#line 1729 "gram.tab.c"
    break;

  case 40: /* stmt: ATTR attribute EOL  */
#line 324 "gram.y"
                                                {
		param.number = (yyvsp[-1].y_num);
		param.name = NULL;
		stmt_type = ATTR; YYACCEPT;
	    }
#line 1739 "gram.tab.c"
    break;

  case 41: /* stmt: ATTR attribute STRING EOL  */
#line 329 "gram.y"
                                                {
		param.number = (yyvsp[-2].y_num);
		param.name = (yyvsp[-1].y_str);
		stmt_type = ATTR; YYACCEPT;
	    }
#line 1749 "gram.tab.c"
    break;

  case 42: /* stmt: LABEL EOL  */
#line 334 "gram.y"
                                                {
		param.number = LABEL; param.pmid = HELP_USAGE;
		stmt_type = HELP; YYACCEPT;
	    }
#line 1758 "gram.tab.c"
    break;

  case 43: /* stmt: LABEL CTXT EOL  */
#line 338 "gram.y"
                                                {
		param.number = PM_LABEL_CONTEXT;
		stmt_type = LABEL; YYACCEPT;
	    }
#line 1767 "gram.tab.c"
    break;

  case 44: /* stmt: LABEL DOMAIN EOL  */
#line 342 "gram.y"
                                                {
		param.number = PM_LABEL_DOMAIN;
		stmt_type = LABEL; YYACCEPT;
	    }
#line 1776 "gram.tab.c"
    break;

  case 45: /* stmt: LABEL INDOM indom EOL  */
#line 346 "gram.y"
                                                {
		param.number = PM_LABEL_INDOM;
		param.indom = indom.whole;
		stmt_type = LABEL; YYACCEPT;
	    }
#line 1786 "gram.tab.c"
    break;

  case 46: /* stmt: LABEL CLUSTER cluster EOL  */
#line 351 "gram.y"
                                                {
		param.number = PM_LABEL_CLUSTER;
		param.pmid = (pmID)(yyvsp[-1].y_num);
		stmt_type = LABEL; YYACCEPT;
	    }
#line 1796 "gram.tab.c"
    break;

  case 47: /* stmt: LABEL ITEM metric EOL  */
#line 356 "gram.y"
                                                {
		param.number = PM_LABEL_ITEM;
		param.pmid = (pmID)(yyvsp[-1].y_num);
		stmt_type = LABEL; YYACCEPT;
	    }
#line 1806 "gram.tab.c"
    break;

  case 48: /* stmt: LABEL INSTANCES indom EOL  */
#line 361 "gram.y"
                                                {
		param.number = PM_LABEL_INSTANCES;
		param.indom = indom.whole;
		stmt_type = LABEL; YYACCEPT;
	    }
#line 1816 "gram.tab.c"
    break;

  case 49: /* stmt: HELP EOL  */
#line 367 "gram.y"
                                                { 
		param.number = -1; param.pmid = HELP_FULL; 
		stmt_type = HELP; YYACCEPT; 
	    }
#line 1825 "gram.tab.c"
    break;

  case 50: /* stmt: HELP ATTR EOL  */
#line 371 "gram.y"
                                                {
		param.number = ATTR; param.pmid = HELP_FULL; 
		stmt_type = HELP; YYACCEPT;
	    }
#line 1834 "gram.tab.c"
    break;

  case 51: /* stmt: HELP CLOSE EOL  */
#line 375 "gram.y"
                                                {
		param.number = CLOSE; param.pmid = HELP_FULL; 
		stmt_type = HELP; YYACCEPT;
	    }
#line 1843 "gram.tab.c"
    break;

  case 52: /* stmt: HELP DBG EOL  */
#line 379 "gram.y"
                                                {
		param.number = DBG; param.pmid = HELP_FULL; 
		stmt_type = HELP; YYACCEPT;
	    }
#line 1852 "gram.tab.c"
    break;

  case 53: /* stmt: HELP DESC EOL  */
#line 383 "gram.y"
                                                {
		param.number = DESC; param.pmid = HELP_FULL; 
		stmt_type = HELP; YYACCEPT;
	    }
#line 1861 "gram.tab.c"
    break;

  case 54: /* stmt: HELP FETCH EOL  */
#line 387 "gram.y"
                                                {
		param.number = FETCH; param.pmid = HELP_FULL; 
		stmt_type = HELP; YYACCEPT;
	    }
#line 1870 "gram.tab.c"
    break;

  case 55: /* stmt: HELP GETDESC EOL  */
#line 391 "gram.y"
                                                {
		param.number = GETDESC; param.pmid = HELP_FULL; 
		stmt_type = HELP; YYACCEPT;
	    }
#line 1879 "gram.tab.c"
    break;

  case 56: /* stmt: HELP GETINAME EOL  */
#line 395 "gram.y"
                                                {
		param.number = GETINAME; param.pmid = HELP_FULL; 
		stmt_type = HELP; YYACCEPT;
	    }
#line 1888 "gram.tab.c"
    break;

  case 57: /* stmt: HELP INFO EOL  */
#line 399 "gram.y"
                                                {
		param.number = INFO; param.pmid = HELP_FULL;
		stmt_type = HELP; YYACCEPT;
	    }
#line 1897 "gram.tab.c"
    break;

  case 58: /* stmt: HELP INSTANCE EOL  */
#line 403 "gram.y"
                                                {
		param.number = INSTANCE; param.pmid = HELP_FULL; 
		stmt_type = HELP; YYACCEPT;
	    }
#line 1906 "gram.tab.c"
    break;

  case 59: /* stmt: HELP LABEL EOL  */
#line 407 "gram.y"
                                                {
		param.number = LABEL; param.pmid = HELP_FULL; 
		stmt_type = HELP; YYACCEPT;
	    }
#line 1915 "gram.tab.c"
    break;

  case 60: /* stmt: HELP NAMESPACE EOL  */
#line 411 "gram.y"
                                                {
		param.number = NAMESPACE; param.pmid = HELP_FULL; 
		stmt_type = HELP; YYACCEPT;
	    }
#line 1924 "gram.tab.c"
    break;

  case 61: /* stmt: HELP OPEN EOL  */
#line 415 "gram.y"
                                                {
		param.number = OPEN; param.pmid = HELP_FULL; 
		stmt_type = HELP; YYACCEPT;
	    }
#line 1933 "gram.tab.c"
    break;

  case 62: /* stmt: HELP PMNS_CHILDREN EOL  */
#line 419 "gram.y"
                                                {
		param.number = PMNS_CHILDREN; param.pmid = HELP_FULL; 
		stmt_type = HELP; YYACCEPT;
	    }
#line 1942 "gram.tab.c"
    break;

  case 63: /* stmt: HELP PMNS_NAME EOL  */
#line 423 "gram.y"
                                                {
		param.number = PMNS_NAME; param.pmid = HELP_FULL; 
		stmt_type = HELP; YYACCEPT;
	    }
#line 1951 "gram.tab.c"
    break;

  case 64: /* stmt: HELP PMNS_PMID EOL  */
#line 427 "gram.y"
                                                {
		param.number = PMNS_PMID; param.pmid = HELP_FULL; 
		stmt_type = HELP; YYACCEPT;
	    }
#line 1960 "gram.tab.c"
    break;

  case 65: /* stmt: HELP PMNS_TRAVERSE EOL  */
#line 431 "gram.y"
                                                {
		param.number = PMNS_TRAVERSE; param.pmid = HELP_FULL; 
		stmt_type = HELP; YYACCEPT;
	    }
#line 1969 "gram.tab.c"
    break;

  case 66: /* stmt: HELP PROFILE EOL  */
#line 435 "gram.y"
                                                {
		param.number = PROFILE; param.pmid = HELP_FULL; 
		stmt_type = HELP; YYACCEPT;
	    }
#line 1978 "gram.tab.c"
    break;

  case 67: /* stmt: HELP QUIT EOL  */
#line 439 "gram.y"
                                                {
		param.number = QUIT; param.pmid = HELP_FULL; 
		stmt_type = HELP; YYACCEPT;
	    }
#line 1987 "gram.tab.c"
    break;

  case 68: /* stmt: HELP STATUS EOL  */
#line 443 "gram.y"
                                                {
		param.number = STATUS; param.pmid = HELP_FULL; 
		stmt_type = HELP; YYACCEPT;
	    }
#line 1996 "gram.tab.c"
    break;

  case 69: /* stmt: HELP STORE EOL  */
#line 447 "gram.y"
                                                {
		param.number = STORE; param.pmid = HELP_FULL; 
		stmt_type = HELP; YYACCEPT;
	    }
#line 2005 "gram.tab.c"
    break;

  case 70: /* stmt: HELP TIMER EOL  */
#line 451 "gram.y"
                                                        {
		param.number = TIMER; param.pmid = HELP_FULL;
		stmt_type = HELP; YYACCEPT;
	    }
#line 2014 "gram.tab.c"
    break;

  case 71: /* stmt: HELP WAIT EOL  */
#line 455 "gram.y"
                                                {
		param.number = WAIT; param.pmid = HELP_FULL;
		stmt_type = HELP; YYACCEPT;
	    }
#line 2023 "gram.tab.c"
    break;

  case 72: /* stmt: HELP WATCH EOL  */
#line 459 "gram.y"
                                                {
		param.number = WATCH; param.pmid = HELP_FULL; 
		stmt_type = HELP; YYACCEPT;
	    }
#line 2032 "gram.tab.c"
    break;

  case 73: /* stmt: QUIT EOL  */
#line 464 "gram.y"
                                                { stmt_type = QUIT; YYACCEPT; }
#line 2038 "gram.tab.c"
    break;

  case 74: /* stmt: DBG EOL  */
#line 465 "gram.y"
                                                {
		param.number = DBG; param.pmid = HELP_USAGE; 
		stmt_type = HELP; YYACCEPT;
	    }
#line 2047 "gram.tab.c"
    break;

  case 75: /* stmt: DBG ALL EOL  */
#line 469 "gram.y"
                                                {
		int sts = pmSetDebug("all");
		if (sts < 0) {
		    pmsprintf(warnStr, MYWARNSTRSZ, "pmSetDebug(\"all\") failed\n");
		    yywarn(warnStr);
		    YYERROR;
		}
		stmt_type = DBG; YYACCEPT;
	    }
#line 2061 "gram.tab.c"
    break;

  case 76: /* stmt: DBG NONE EOL  */
#line 478 "gram.y"
                                                {
		int sts = pmClearDebug("all");
		if (sts < 0) {
		    pmsprintf(warnStr, MYWARNSTRSZ, "pmClearDebug(\"all\") failed\n");
		    yywarn(warnStr);
		    YYERROR;
		}
		stmt_type = DBG; YYACCEPT;
	    }
#line 2075 "gram.tab.c"
    break;

  case 77: /* stmt: DBG debug EOL  */
#line 487 "gram.y"
                                                {
	        stmt_type = DBG; YYACCEPT;
	    }
#line 2083 "gram.tab.c"
    break;

  case 78: /* stmt: STATUS EOL  */
#line 490 "gram.y"
                                                { 
		stmt_type = STATUS; YYACCEPT; 
	    }
#line 2091 "gram.tab.c"
    break;

  case 79: /* stmt: TIMER EOL  */
#line 493 "gram.y"
                                                {
		param.number = TIMER; param.pmid = HELP_USAGE;
		stmt_type = HELP; YYACCEPT;
	    }
#line 2100 "gram.tab.c"
    break;

  case 80: /* stmt: TIMER ON EOL  */
#line 497 "gram.y"
                                                { 
		timer = 1; stmt_type = EOL; YYACCEPT; 
	    }
#line 2108 "gram.tab.c"
    break;

  case 81: /* stmt: TIMER OFF EOL  */
#line 500 "gram.y"
                                                { 
		timer = 0; stmt_type = EOL; YYACCEPT; 
	    }
#line 2116 "gram.tab.c"
    break;

  case 82: /* stmt: GETDESC EOL  */
#line 503 "gram.y"
                                                {
		param.number = GETDESC; param.pmid = HELP_USAGE;
		stmt_type = HELP; YYACCEPT;
	    }
#line 2125 "gram.tab.c"
    break;

  case 83: /* stmt: GETDESC ON EOL  */
#line 507 "gram.y"
                                                        { 
		get_desc = 1; stmt_type = EOL; YYACCEPT; 
	    }
#line 2133 "gram.tab.c"
    break;

  case 84: /* stmt: GETDESC OFF EOL  */
#line 510 "gram.y"
                                                        { 
		get_desc = 0; stmt_type = EOL; YYACCEPT; 
	    }
#line 2141 "gram.tab.c"
    break;

  case 85: /* stmt: GETINAME EOL  */
#line 513 "gram.y"
                                                {
		param.number = GETINAME; param.pmid = HELP_USAGE;
		stmt_type = HELP; YYACCEPT;
	    }
#line 2150 "gram.tab.c"
    break;

  case 86: /* stmt: GETINAME ON EOL  */
#line 517 "gram.y"
                                                        { 
		get_iname = 1; stmt_type = EOL; YYACCEPT; 
	    }
#line 2158 "gram.tab.c"
    break;

  case 87: /* stmt: GETINAME OFF EOL  */
#line 520 "gram.y"
                                                        { 
		get_iname = 0; stmt_type = EOL; YYACCEPT; 
	    }
#line 2166 "gram.tab.c"
    break;

  case 88: /* stmt: WAIT EOL  */
#line 523 "gram.y"
                                                {
		param.number = WAIT; param.pmid = HELP_USAGE;
		stmt_type = HELP; YYACCEPT;
	    }
#line 2175 "gram.tab.c"
    break;

  case 89: /* stmt: WAIT NUMBER EOL  */
#line 527 "gram.y"
                                                { 
		stmt_type = EOL; sleep((yyvsp[-1].y_num)); YYACCEPT;
	    }
#line 2183 "gram.tab.c"
    break;

  case 90: /* stmt: EOL  */
#line 530 "gram.y"
                                                { stmt_type = EOL; YYACCEPT; }
#line 2189 "gram.tab.c"
    break;

  case 91: /* stmt: %empty  */
#line 531 "gram.y"
                                                {
		if (yywrap())
		    YYACCEPT;
		else {
		    yyerror("Unrecognized command");
		    YYERROR;
		}
	    }
#line 2202 "gram.tab.c"
    break;

  case 92: /* fname: NAME  */
#line 541 "gram.y"
                                                {
		    /* check for absolute path - *nix and Windows style */
		    if ((yyvsp[0].y_str)[0] == '/' ||
		        (strlen((yyvsp[0].y_str)) > 4 && (yyvsp[0].y_str)[1] == ':' && (yyvsp[0].y_str)[2] == '/'))
			(yyval.y_str) = (yyvsp[0].y_str);
		    else {
			/* relative path */
			(yyval.y_str) = strcons("./", (yyvsp[0].y_str));
			gc_add((yyval.y_str));
		    }
	    }
#line 2218 "gram.tab.c"
    break;

  case 93: /* fname: PATHNAME  */
#line 552 "gram.y"
                                                { (yyval.y_str) = (yyvsp[0].y_str); }
#line 2224 "gram.tab.c"
    break;

  case 94: /* optdomain: NUMBER  */
#line 555 "gram.y"
                                                { (yyval.y_num) = (yyvsp[0].y_num); }
#line 2230 "gram.tab.c"
    break;

  case 95: /* optdomain: %empty  */
#line 556 "gram.y"
                                                { (yyval.y_num) = 0; }
#line 2236 "gram.tab.c"
    break;

  case 96: /* attribute: NUMBER  */
#line 559 "gram.y"
                                                {
		int sts = __pmAttrKeyStr_r((yyvsp[0].y_num), warnStr, sizeof(warnStr));
		if (sts <= 0) {
		    pmsprintf(warnStr, MYWARNSTRSZ, "Attribute (%d) is not recognised", (yyvsp[0].y_num));
		    yyerror(warnStr);
		    YYERROR;
		}
		(yyval.y_num) = (yyvsp[0].y_num);
	    }
#line 2250 "gram.tab.c"
    break;

  case 97: /* attribute: STRING  */
#line 568 "gram.y"
                                                { 
		int sts = __pmLookupAttrKey((yyvsp[0].y_str), strlen((yyvsp[0].y_str))+1);
		if (sts <= 0) {
		    pmsprintf(warnStr, MYWARNSTRSZ, "Attribute (%s) is not recognised", (yyvsp[0].y_str));
		    yyerror(warnStr);
		    YYERROR;
		}
		(yyval.y_num) = sts;
	    }
#line 2264 "gram.tab.c"
    break;

  case 98: /* servport: NUMBER  */
#line 579 "gram.y"
                                                { (yyval.y_num) = (yyvsp[0].y_num); }
#line 2270 "gram.tab.c"
    break;

  case 99: /* servport: STRING  */
#line 580 "gram.y"
                                                {
		struct servent *srv = getservbyname((yyvsp[0].y_str), NULL);
		if (srv == NULL) {
		    pmsprintf(warnStr, MYWARNSTRSZ, "Failed to map (%s) to a port number", (yyvsp[0].y_str));
		    yyerror(warnStr);
		    YYERROR;
		}
		pmsprintf(warnStr, MYWARNSTRSZ, "Mapped %s to port number %d", (yyvsp[0].y_str), srv->s_port);
		yywarn(warnStr);
		(yyval.y_num) = srv->s_port;
	    }
#line 2286 "gram.tab.c"
    break;

  case 100: /* metric: NUMBER  */
#line 593 "gram.y"
                                                { 
		int sts;
		pmid.whole = (yyvsp[0].y_num);
		sts = pmNameID(pmid.whole, &str);
		if (sts < 0) {
		    pmsprintf(warnStr, MYWARNSTRSZ, "PMID (%s) is not defined in the PMNS",
			    pmIDStr(pmid.whole));
		    yywarn(warnStr);
		}
		else
		    free(str);
		(yyval.y_num) = (int)pmid.whole; 
	    }
#line 2304 "gram.tab.c"
    break;

  case 101: /* metric: NUMBER2D  */
#line 606 "gram.y"
                                                {
		int sts;
		pmid.whole = 0;
		pmid.part.cluster = (yyvsp[0].y_2num).num1;
		pmid.part.item = (yyvsp[0].y_2num).num2;
		sts = pmNameID(pmid.whole, &str);
		if (sts < 0) {
		    pmsprintf(warnStr, MYWARNSTRSZ, "PMID (%s) is not defined in the PMNS",
			    pmIDStr(pmid.whole));
		    yywarn(warnStr);
		}
		else
		    free(str);
		(yyval.y_num) = (int)pmid.whole;
	    }
#line 2324 "gram.tab.c"
    break;

  case 102: /* metric: NUMBER3D  */
#line 621 "gram.y"
                                                {
		int sts;
		pmid.whole = 0;
		pmid.part.domain = (yyvsp[0].y_3num).num1;
		pmid.part.cluster = (yyvsp[0].y_3num).num2;
		pmid.part.item = (yyvsp[0].y_3num).num3;
		sts = pmNameID(pmid.whole, &str);
		if (sts < 0) {
		    pmsprintf(warnStr, MYWARNSTRSZ, "PMID (%s) is not defined in the PMNS",
			    pmIDStr(pmid.whole));
		    yywarn(warnStr);
		}
		else
		    free(str);
		(yyval.y_num) = (int)pmid.whole;
	    }
#line 2345 "gram.tab.c"
    break;

  case 103: /* metric: NAME  */
#line 637 "gram.y"
                                                {
		int sts = pmLookupName(1, (const char **)&(yyvsp[0].y_str), &pmid.whole);
		if (sts < 0) {
		    yyerror(pmErrStr(sts));
		    YYERROR;
		}
		sts = fix_dynamic_pmid((yyvsp[0].y_str), &pmid.whole);
		if (sts < 0) {
		    yyerror(pmErrStr(sts));
		    YYERROR;
		}
		(yyval.y_num) = (int)pmid.whole;
	    }
#line 2363 "gram.tab.c"
    break;

  case 104: /* cluster: NUMBER  */
#line 652 "gram.y"
                                                { 
		pmid.whole = (yyvsp[0].y_num);
	        (yyval.y_num) = (int)pmid.whole;
	    }
#line 2372 "gram.tab.c"
    break;

  case 105: /* cluster: NUMBER2D  */
#line 656 "gram.y"
                                                {
		pmid.whole = 0;
		pmid.part.domain = (yyvsp[0].y_2num).num1;
		pmid.part.cluster = (yyvsp[0].y_2num).num2;
		(yyval.y_num) = (int)pmid.whole;
	    }
#line 2383 "gram.tab.c"
    break;

  case 106: /* indom: NUMBER  */
#line 664 "gram.y"
                                                { 
		indom.whole = (yyvsp[0].y_num);
	        (yyval.y_num) = (int)indom.whole;
	    }
#line 2392 "gram.tab.c"
    break;

  case 107: /* indom: NEGNUMBER  */
#line 668 "gram.y"
                                                { 
		indom.whole = (yyvsp[0].y_num);
		(yyval.y_num) = (int)indom.whole;
	    }
#line 2401 "gram.tab.c"
    break;

  case 108: /* indom: NUMBER2D  */
#line 672 "gram.y"
                                                {
		indom.whole = 0;
		indom.part.domain = (yyvsp[0].y_2num).num1;
		indom.part.serial = (yyvsp[0].y_2num).num2;
		(yyval.y_num) = (int)indom.whole;
	    }
#line 2412 "gram.tab.c"
    break;

  case 109: /* raw_pmid: NUMBER3D  */
#line 680 "gram.y"
                                                {
		pmid.whole = 0;
		pmid.part.domain = (yyvsp[0].y_3num).num1;
		pmid.part.cluster = (yyvsp[0].y_3num).num2;
		pmid.part.item = (yyvsp[0].y_3num).num3;
		(yyval.y_num) = (int)pmid.whole;
	    }
#line 2424 "gram.tab.c"
    break;

  case 110: /* metriclist: metric  */
#line 689 "gram.y"
                                                { addmetriclist((pmID)(yyvsp[0].y_num)); }
#line 2430 "gram.tab.c"
    break;

  case 111: /* metriclist: metriclist metric  */
#line 690 "gram.y"
                                                { addmetriclist((pmID)(yyvsp[0].y_num)); }
#line 2436 "gram.tab.c"
    break;

  case 112: /* metriclist: metriclist COMMA metric  */
#line 691 "gram.y"
                                                { addmetriclist((pmID)(yyvsp[0].y_num)); }
#line 2442 "gram.tab.c"
    break;

  case 113: /* arglist: %empty  */
#line 695 "gram.y"
                                                { doargs(); }
#line 2448 "gram.tab.c"
    break;

  case 114: /* inst: STRING  */
#line 698 "gram.y"
                                                { (yyval.y_str) = (yyvsp[0].y_str); }
#line 2454 "gram.tab.c"
    break;

  case 115: /* inst: NAME  */
#line 699 "gram.y"
                                                { (yyval.y_str) = (yyvsp[0].y_str); }
#line 2460 "gram.tab.c"
    break;

  case 116: /* debug: NUMBER  */
#line 702 "gram.y"
                                        {
			int	sts;
			char	nbuf[12];
			pmsprintf(nbuf, sizeof(nbuf), "%d", (yyvsp[0].y_num));
			sts = pmSetDebug(nbuf);
			if (sts < 0) {
			    pmsprintf(warnStr, MYWARNSTRSZ, "Bad debug flag (%s)", nbuf);
			    yyerror(warnStr);
			    YYERROR;
			}
			(yyval.y_num) = 0;
		    }
#line 2477 "gram.tab.c"
    break;

  case 117: /* debug: flag  */
#line 714 "gram.y"
                                                {
			int 	sts;
			if ((yyvsp[0].y_str)[0] == '-')
			    sts = pmClearDebug(&(yyvsp[0].y_str)[1]);
			else
			    sts = pmSetDebug((yyvsp[0].y_str));
			if (sts < 0) {
			    pmsprintf(warnStr, MYWARNSTRSZ, "Bad debug flag (%s)", (yyvsp[0].y_str));
			    yyerror(warnStr);
			    YYERROR;
			}
			(yyval.y_num) = 0;
		    }
#line 2495 "gram.tab.c"
    break;

  case 118: /* debug: debug NUMBER  */
#line 727 "gram.y"
                                                {
			int 	sts;
			char	nbuf[12];
			pmsprintf(nbuf, sizeof(nbuf), "%d", (yyvsp[0].y_num));
			sts = pmSetDebug(nbuf);
			if (sts < 0) {
			    pmsprintf(warnStr, MYWARNSTRSZ, "Bad debug flag (%s)", nbuf);
			    yyerror(warnStr);
			    YYERROR;
			}
			(yyval.y_num) = 0;
		    }
#line 2512 "gram.tab.c"
    break;

  case 119: /* debug: debug COMMA NUMBER  */
#line 739 "gram.y"
                                                        {
			int 	sts;
			char	nbuf[12];
			pmsprintf(nbuf, sizeof(nbuf), "%d", (yyvsp[0].y_num));
			sts = pmSetDebug(nbuf);
			if (sts < 0) {
			    pmsprintf(warnStr, MYWARNSTRSZ, "Bad debug flag (%s)", nbuf);
			    yyerror(warnStr);
			    YYERROR;
			}
			(yyval.y_num) = 0;
		    }
#line 2529 "gram.tab.c"
    break;

  case 120: /* debug: debug flag  */
#line 751 "gram.y"
                                                        {
			int 	sts;
			if ((yyvsp[0].y_str)[0] == '-')
			    sts = pmClearDebug(&(yyvsp[0].y_str)[1]);
			else
			    sts = pmSetDebug((yyvsp[0].y_str));
			if (sts < 0) {
			    pmsprintf(warnStr, MYWARNSTRSZ, "Bad debug flag (%s)", (yyvsp[0].y_str));
			    yyerror(warnStr);
			    YYERROR;
			}
			(yyval.y_num) = 0;
		    }
#line 2547 "gram.tab.c"
    break;

  case 121: /* debug: debug COMMA flag  */
#line 764 "gram.y"
                                                                {
			int 	sts;
			if ((yyvsp[0].y_str)[0] == '-')
			    sts = pmClearDebug(&(yyvsp[0].y_str)[1]);
			else
			    sts = pmSetDebug((yyvsp[0].y_str));
			if (sts < 0) {
			    pmsprintf(warnStr, MYWARNSTRSZ, "Bad debug flag (%s)", (yyvsp[0].y_str));
			    yyerror(warnStr);
			    YYERROR;
			}
			(yyval.y_num) = 0;
		    }
#line 2565 "gram.tab.c"
    break;

  case 122: /* flag: NAME  */
#line 784 "gram.y"
                        { (yyval.y_str) = (yyvsp[0].y_str); }
#line 2571 "gram.tab.c"
    break;

  case 123: /* flag: NEGNAME  */
#line 785 "gram.y"
                        { (yyval.y_str) = (yyvsp[0].y_str); }
#line 2577 "gram.tab.c"
    break;

  case 124: /* flag: FETCH  */
#line 786 "gram.y"
                        { (yyval.y_str) = strdup("fetch"); gc_add((yyval.y_str)); }
#line 2583 "gram.tab.c"
    break;

  case 125: /* flag: PROFILE  */
#line 787 "gram.y"
                        { (yyval.y_str) = strdup("profile"); gc_add((yyval.y_str)); }
#line 2589 "gram.tab.c"
    break;

  case 126: /* flag: CTXT  */
#line 788 "gram.y"
                        { (yyval.y_str) = strdup("context"); gc_add((yyval.y_str)); }
#line 2595 "gram.tab.c"
    break;

  case 127: /* flag: INDOM  */
#line 789 "gram.y"
                        { (yyval.y_str) = strdup("indom"); gc_add((yyval.y_str)); }
#line 2601 "gram.tab.c"
    break;

  case 128: /* flag: ATTR  */
#line 790 "gram.y"
                        { (yyval.y_str) = strdup("attr"); gc_add((yyval.y_str)); }
#line 2607 "gram.tab.c"
    break;


#line 2611 "gram.tab.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (YY_("syntax error"));
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 793 "gram.y"

