/* This file is part of GDB.

   Copyright 2002, 2007 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.

   --

   This file was generated by the program igen */

#ifndef SUPPORT_C
#define SUPPORT_C

#include "cpu.h"
#include "idecode.h"
#ifdef HAVE_COMMON_FPU
#include "sim-inline.h"
#include "sim-fpu.h"
#endif
#include "support.h"

PSIM_INLINE_SUPPORT\
(unsigned_word)
semantic_illegal
(cpu *processor,
 idecode_cache *cache_entry,
 unsigned_word cia)
#line 982 "../../sim/ppc/powerpc.igen"
{
  program_interrupt(processor, cia,
                    illegal_instruction_program_interrupt);
  error("Internal function must longjump\n");
  return 0;
}
#line 47 "support.c"

PSIM_INLINE_SUPPORT\
(unsigned_word)
semantic_floating_point_unavailable
(cpu *processor,
 idecode_cache *cache_entry,
 unsigned_word cia)
#line 990 "../../sim/ppc/powerpc.igen"
{
  floating_point_unavailable_interrupt(processor, cia);
  error("Internal function must longjump\n");
  return 0;
}
#line 61 "support.c"

PSIM_INLINE_SUPPORT\
(uint64_t)
DOUBLE
(uint32_t WORD)
#line 999 "../../sim/ppc/powerpc.igen"
{
  uint64_t FRT;
  if (EXTRACTED32(WORD, 1, 8) > 0
      && EXTRACTED32(WORD, 1, 8) < 255) {
    /* normalized operand */
    int not_word_1_1 = !EXTRACTED32(WORD, 1, 1); /*2.6.3 bug*/
    FRT = (INSERTED64(EXTRACTED32(WORD, 0, 1), 0, 1)
           | INSERTED64(not_word_1_1, 2, 2)
           | INSERTED64(not_word_1_1, 3, 3)
           | INSERTED64(not_word_1_1, 4, 4)
           | INSERTED64(EXTRACTED32(WORD, 2, 31), 5, (63 - 29)));
  }
  else if (EXTRACTED32(WORD, 1, 8) == 0
           && EXTRACTED32(WORD, 9, 31) != 0) {
    /* denormalized operand */
    int sign = EXTRACTED32(WORD, 0, 0);
    int exp = -126;
    uint64_t frac = INSERTED64(EXTRACTED32(WORD, 9, 31), 1, (52 - 29));
    /* normalize the operand */
    while (MASKED64(frac, 0, 0) == 0) {
      frac <<= 1;
      exp -= 1;
    }
    FRT = (INSERTED64(sign, 0, 0)
           | INSERTED64(exp + 1023, 1, 11)
           | INSERTED64(EXTRACTED64(frac, 1, 52), 12, 63));
  }
  else if (EXTRACTED32(WORD, 1, 8) == 255
  	 || EXTRACTED32(WORD, 1, 31) == 0) {
    FRT = (INSERTED64(EXTRACTED32(WORD, 0, 1), 0, 1)
           | INSERTED64(EXTRACTED32(WORD, 1, 1), 2, 2)
           | INSERTED64(EXTRACTED32(WORD, 1, 1), 3, 3)
           | INSERTED64(EXTRACTED32(WORD, 1, 1), 4, 4)
           | INSERTED64(EXTRACTED32(WORD, 2, 31), 5, (63 - 29)));
  }
  else {
    error("DOUBLE - unknown case\n");
    FRT = 0;
  }
  return FRT;
}
#line 109 "support.c"

PSIM_INLINE_SUPPORT\
(uint32_t)
SINGLE
(uint64_t FRS)
#line 1041 "../../sim/ppc/powerpc.igen"
{
  uint32_t WORD;
  if (EXTRACTED64(FRS, 1, 11) > 896
      || EXTRACTED64(FRS, 1, 63) == 0) {
    /* no denormalization required (includes Zero/Infinity/NaN) */
    WORD = (INSERTED32(EXTRACTED64(FRS, 0, 1), 0, 1)
            | INSERTED32(EXTRACTED64(FRS, 5, 34), 2, 31));
  }
  else if (874 <= EXTRACTED64(FRS, 1, 11)
           && EXTRACTED64(FRS, 1, 11) <= 896) {
    /* denormalization required */
    int sign = EXTRACTED64(FRS, 0, 0);
    int exp = EXTRACTED64(FRS, 1, 11) - 1023;
    uint64_t frac = (BIT64(0)
                       | INSERTED64(EXTRACTED64(FRS, 12, 63), 1, 52));
    /* denormalize the operand */
    while (exp < -126) {
      frac = INSERTED64(EXTRACTED64(frac, 0, 62), 1, 63);
      exp += 1;
    }
    WORD = (INSERTED32(sign, 0, 0)
            | INSERTED32(0x00, 1, 8)
            | INSERTED32(EXTRACTED64(frac, 1, 23), 9, 31));
  }
  else {
    WORD = 0x0; /* ??? */
  }	  
  return WORD;
}
#line 145 "support.c"

PSIM_INLINE_SUPPORT\
(void)
Round_Single
(cpu *processor, int sign, int *exp, uint64_t *frac_grx)
#line 1072 "../../sim/ppc/powerpc.igen"
{
  /* comparisons ignore u bits */
  uint64_t out;
  int inc = 0;
  int lsb = EXTRACTED64(*frac_grx, 23, 23);
  int gbit = EXTRACTED64(*frac_grx, 24, 24);
  int rbit = EXTRACTED64(*frac_grx, 25, 25);
  int xbit = EXTRACTED64(*frac_grx, 26, 55) != 0;
  if ((FPSCR & fpscr_rn) == fpscr_rn_round_to_nearest) {
    if (lsb == 1 && gbit == 1) inc = 1;
    if (lsb == 0 && gbit == 1 && rbit == 1) inc = 1;
    if (lsb == 0 && gbit == 1 && xbit == 1) inc = 1;
  }
  if ((FPSCR & fpscr_rn) == fpscr_rn_round_towards_pos_infinity) {
    if (sign == 0 && gbit == 1) inc = 1;
    if (sign == 0 && rbit == 1) inc = 1;
    if (sign == 0 && xbit == 1) inc = 1;
  }
  if ((FPSCR & fpscr_rn) == fpscr_rn_round_towards_neg_infinity) {
    if (sign == 1 && gbit == 1) inc = 1;
    if (sign == 1 && rbit == 1) inc = 1;
    if (sign == 1 && xbit == 1) inc = 1;
  }
  /* work out addition in low 25 bits of out */
  out = EXTRACTED64(*frac_grx, 0, 23) + inc;
  *frac_grx = INSERTED64(out, 0, 23);
  if (out & BIT64(64 - 23 - 1 - 1)) {
    *frac_grx = (BIT64(0) |
                 INSERTED64(EXTRACTED64(*frac_grx, 0, 22), 1, 23));
    *exp = *exp + 1;
  }
  /* frac_grx[24:52] = 0 already */
  FPSCR_SET_FR(inc);
  FPSCR_SET_FI(gbit || rbit || xbit);
}
#line 187 "support.c"

PSIM_INLINE_SUPPORT\
(void)
Round_Integer
(cpu *processor, int sign, uint64_t *frac, int *frac64, int gbit, int rbit, int xbit, fpscreg round_mode)
#line 1109 "../../sim/ppc/powerpc.igen"
{
  int inc = 0;
  if (round_mode == fpscr_rn_round_to_nearest) {
    if (*frac64 == 1 && gbit == 1) inc = 1;
    if (*frac64 == 0 && gbit == 1 && rbit == 1) inc = 1;
    if (*frac64 == 0 && gbit == 1 && xbit == 1) inc = 1;
  }
  if (round_mode == fpscr_rn_round_towards_pos_infinity) {
    if (sign == 0 && gbit == 1) inc = 1;
    if (sign == 0 && rbit == 1) inc = 1;
    if (sign == 0 && xbit == 1) inc = 1;
  }
  if (round_mode == fpscr_rn_round_towards_neg_infinity) {
    if (sign == 1 && gbit == 1) inc = 1;
    if (sign == 1 && rbit == 1) inc = 1;
    if (sign == 1 && xbit == 1) inc = 1;
  }
  /* frac[0:64] = frac[0:64} + inc */
  *frac += (*frac64 && inc ? 1 : 0);
  *frac64 = (*frac64 + inc) & 0x1;
  FPSCR_SET_FR(inc);
  FPSCR_SET_FI(gbit | rbit | xbit);
}
#line 217 "support.c"

PSIM_INLINE_SUPPORT\
(void)
Round_Float
(cpu *processor, int sign, int *exp, uint64_t *frac, fpscreg round_mode)
#line 1133 "../../sim/ppc/powerpc.igen"
{
  int carry_out;
  int inc = 0;
  int lsb = EXTRACTED64(*frac, 52, 52);
  int gbit = EXTRACTED64(*frac, 53, 53);
  int rbit = EXTRACTED64(*frac, 54, 54);
  int xbit = EXTRACTED64(*frac, 55, 55);
  if (round_mode == fpscr_rn_round_to_nearest) {
    if (lsb == 1 && gbit == 1) inc = 1;
    if (lsb == 0 && gbit == 1 && rbit == 1) inc = 1;
    if (lsb == 0 && gbit == 1 && xbit == 1) inc = 1;
  }
  if (round_mode == fpscr_rn_round_towards_pos_infinity) {
    if (sign == 0 && gbit == 1) inc = 1;
    if (sign == 0 && rbit == 1) inc = 1;
    if (sign == 0 && xbit == 1) inc = 1;
  }
  if (round_mode == fpscr_rn_round_towards_neg_infinity) {
    if (sign == 1 && gbit == 1) inc = 1;
    if (sign == 1 && rbit == 1) inc = 1;
    if (sign == 1 && xbit == 1) inc = 1;
  }
  /* frac//carry_out = frac + inc */
  *frac = (*frac >> 1) + (INSERTED64(inc, 52, 52) >> 1);
  carry_out = EXTRACTED64(*frac, 0, 0);
  *frac <<= 1;
  if (carry_out == 1) *exp = *exp + 1;
  FPSCR_SET_FR(inc);
  FPSCR_SET_FI(gbit | rbit | xbit);
  FPSCR_SET_XX(FPSCR & fpscr_fi);
}
#line 255 "support.c"

PSIM_INLINE_SUPPORT\
(void)
convert_to_integer
(cpu *processor, unsigned_word cia, uint64_t *frt, uint64_t frb, fpscreg round_mode, int tgt_precision)
#line 1166 "../../sim/ppc/powerpc.igen"
{
  int i;
  int exp = 0;
  uint64_t frac = 0;
  int frac64 = 0;
  int gbit = 0;
  int rbit = 0;
  int xbit = 0;
  int sign = EXTRACTED64(frb, 0, 0);
  /***/
    if (EXTRACTED64(frb, 1, 11) == 2047 && EXTRACTED64(frb, 12, 63) == 0)
      GOTO(Infinity_Operand);
    if (EXTRACTED64(frb, 1, 11) == 2047 && EXTRACTED64(frb, 12, 12) == 0)
      GOTO(SNaN_Operand);
    if (EXTRACTED64(frb, 1, 11) == 2047 && EXTRACTED64(frb, 12, 12) == 1)
      GOTO(QNaN_Operand);
    if (EXTRACTED64(frb, 1, 11) > 1086) GOTO(Large_Operand);
    if (EXTRACTED64(frb, 1, 11) > 0) exp = EXTRACTED64(frb, 1, 11) - 1023;
    if (EXTRACTED64(frb, 1, 11) == 0) exp = -1022;
    if (EXTRACTED64(frb, 1, 11) > 0) { /* normal */
      frac = BIT64(1) | INSERTED64(EXTRACTED64(frb, 12, 63), 2, 53);
      frac64 = 0;
    }
    if (EXTRACTED64(frb, 1, 11) == 0) { /* denorm */
      frac = INSERTED64(EXTRACTED64(frb, 12, 63), 2, 53);
      frac64 = 0;
    }
    gbit = 0, rbit = 0, xbit = 0;
    for (i = 1; i <= 63 - exp; i++) {
      xbit = rbit | xbit;
      rbit = gbit;
      gbit = frac64;
      frac64 = EXTRACTED64(frac, 63, 63);
      frac = INSERTED64(EXTRACTED64(frac, 0, 62), 1, 63);
    }
    Round_Integer(processor, sign, &frac, &frac64, gbit, rbit, xbit, round_mode);
    if (sign == 1) { /* frac[0:64] = ~frac[0:64] + 1 */
      frac = ~frac;
      frac64 ^= 1;
      frac += (frac64 ? 1 : 0);
      frac64 = (frac64 + 1) & 0x1;
    }
    if (tgt_precision == 32 /* can ignore frac64 in compare */
        && (int64_t)frac > (int64_t)MASK64(33+1, 63)/*2^31-1 >>1*/)
      GOTO(Large_Operand);
    if (tgt_precision == 64 /* can ignore frac64 in compare */
        && (int64_t)frac > (int64_t)MASK64(1+1, 63)/*2^63-1 >>1*/)
      GOTO(Large_Operand);
    if (tgt_precision == 32 /* can ignore frac64 in compare */
        && (int64_t)frac < (int64_t)MASK64(0, 32+1)/*-2^31 >>1*/)
      GOTO(Large_Operand);
    if (tgt_precision == 64 /* can ignore frac64 in compare */
        && (int64_t)frac < (int64_t)MASK64(0, 0+1)/*-2^63 >>1*/)
      GOTO(Large_Operand);
    FPSCR_SET_XX(FPSCR & fpscr_fi);
    if (tgt_precision == 32)
      *frt = MASKED64(*frt, 0, 31) | (EXTRACTED64(frac, 33, 63) << 1) | frac64;
    if (tgt_precision == 64)
      *frt = (EXTRACTED64(frac, 1, 63) << 1) | frac64;
    /*FPSCR[fprf] = undefined */
    GOTO(Done);
    /**/
  LABEL(Infinity_Operand):
    FPSCR_SET_FR(0);
    FPSCR_SET_FI(0);
    FPSCR_OR_VX(fpscr_vxcvi);
    if ((FPSCR & fpscr_ve) == 0) {
      if (tgt_precision == 32) {
        if (sign == 0) *frt = MASKED64(*frt, 0, 31) | 0x7FFFFFFF;
        if (sign == 1) *frt = MASKED64(*frt, 0, 31) | 0x80000000;
      }
      else {
        if (sign == 0) *frt = MASK64(1, 63); /*0x7FFF_FFFF_FFFF_FFFF*/
        if (sign == 1) *frt = BIT64(0); /*0x8000_0000_0000_0000*/
      }
      /* FPSCR[FPRF] = undefined */
    }
    GOTO(Done);
  /**/
  LABEL(SNaN_Operand):
    FPSCR_SET_FR(0);
    FPSCR_SET_FI(0);
    FPSCR_OR_VX(fpscr_vxsnan | fpscr_vxcvi);
    if ((FPSCR & fpscr_ve) == 0) {
      if (tgt_precision == 32) *frt = MASKED64(*frt, 0, 31) | 0x80000000;
      if (tgt_precision == 64) *frt = BIT64(0); /*0x8000_0000_0000_0000*/
      /* FPSCR[fprf] = undefined */
    }
    GOTO(Done);
  /**/
  LABEL(QNaN_Operand):
    FPSCR_SET_FR(0);
    FPSCR_SET_FI(0);
    FPSCR_OR_VX(fpscr_vxcvi);
    if ((FPSCR & fpscr_ve) == 0) {
      if (tgt_precision == 32) *frt = MASKED64(*frt, 0, 31) | 0x80000000;
      if (tgt_precision == 64) *frt = BIT64(0);/*0x8000_0000_0000_0000*/
      /* FPSCR[fprf] = undefined */
    }
    GOTO(Done);
  /**/
  LABEL(Large_Operand):
    FPSCR_SET_FR(0);
    FPSCR_SET_FI(0);
    FPSCR_OR_VX(fpscr_vxcvi);
    if ((FPSCR & fpscr_ve) == 0) {
      if (tgt_precision == 32) {
        if (sign == 0) *frt = MASKED64(*frt, 0, 31) | 0x7fffffff;
        if (sign == 1) *frt = MASKED64(*frt, 0, 31) | 0x80000000;
      }
      else {
        if (sign == 0) *frt = MASK64(1, 63); /*0x7FFF_FFFF_FFFF_FFFF*/
        if (sign == 1) *frt = BIT64(0); /*0x8000_0000_0000_0000*/
      }
      /* FPSCR[fprf] = undefined */
    }
  /**/
  LABEL(Done):;
}
#line 381 "support.c"

PSIM_INLINE_SUPPORT\
(int)
sign
(uint64_t FRS)
#line 1287 "../../sim/ppc/powerpc.igen"
{
  return (MASKED64(FRS, 0, 0)
          ? -1
          : 1);
}
#line 393 "support.c"

PSIM_INLINE_SUPPORT\
(int)
biased_exp
(uint64_t frs, int single)
#line 1291 "../../sim/ppc/powerpc.igen"
{
  if (single)
    return EXTRACTED64(frs, 1, 8);
  else
    return EXTRACTED64(frs, 1, 11);
}
#line 406 "support.c"

PSIM_INLINE_SUPPORT\
(uint64_t)
fraction
(uint64_t frs, int single)
#line 1296 "../../sim/ppc/powerpc.igen"
{
  if (single)
    return EXTRACTED64(frs, 9, 31);
  else
    return EXTRACTED64(frs, 12, 63);
}
#line 419 "support.c"

PSIM_INLINE_SUPPORT\
(int)
is_nor
(uint64_t frs, int single)
#line 1304 "../../sim/ppc/powerpc.igen"
{
  int exp = biased_exp(frs, single);
  return (exp >= 1
          && exp <= (single ? 254 : 2046));
}
#line 431 "support.c"

PSIM_INLINE_SUPPORT\
(int)
is_zero
(uint64_t FRS)
#line 1308 "../../sim/ppc/powerpc.igen"
{
  return (MASKED64(FRS, 1, 63) == 0
          ? sign(FRS)
          : 0);
}
#line 443 "support.c"

PSIM_INLINE_SUPPORT\
(int)
is_den
(uint64_t frs, int single)
#line 1312 "../../sim/ppc/powerpc.igen"
{
  int exp = biased_exp(frs, single);
  uint64_t frac = fraction(frs, single);
  return (exp == 0 && frac != 0
          ? sign(frs)
          : 0);
}
#line 457 "support.c"

PSIM_INLINE_SUPPORT\
(int)
is_inf
(uint64_t frs, int single)
#line 1318 "../../sim/ppc/powerpc.igen"
{
  int exp = biased_exp(frs, single);
  uint64_t frac = fraction(frs, single);
  return (exp == (single ? 255 : 2047) && frac == 0
          ? sign(frs)
          : 0);
}
#line 471 "support.c"

PSIM_INLINE_SUPPORT\
(int)
is_NaN
(uint64_t frs, int single)
#line 1324 "../../sim/ppc/powerpc.igen"
{
  int exp = biased_exp(frs, single);
  uint64_t frac = fraction(frs, single);
  return (exp == (single ? 255 : 2047) && frac != 0
          ? sign(frs)
          : 0);
}
#line 485 "support.c"

PSIM_INLINE_SUPPORT\
(int)
is_SNaN
(uint64_t frs, int single)
#line 1330 "../../sim/ppc/powerpc.igen"
{
  return (is_NaN(frs, single)
          && !(frs & (single ? MASK64(9, 9) : MASK64(12, 12)))
               ? sign(frs)
               : 0);
}
#line 498 "support.c"

PSIM_INLINE_SUPPORT\
(int)
is_QNaN
(uint64_t frs, int single)
#line 1335 "../../sim/ppc/powerpc.igen"
{
  return (is_NaN(frs, single) && !is_SNaN(frs, single));
}
#line 508 "support.c"

PSIM_INLINE_SUPPORT\
(int)
is_less_than
(uint64_t *fra, uint64_t *frb)
#line 1337 "../../sim/ppc/powerpc.igen"
{
  return *(double*)fra < *(double*)frb;
}
#line 518 "support.c"

PSIM_INLINE_SUPPORT\
(int)
is_greater_than
(uint64_t *fra, uint64_t *frb)
#line 1339 "../../sim/ppc/powerpc.igen"
{
  return *(double*)fra > *(double*)frb;
}
#line 528 "support.c"

PSIM_INLINE_SUPPORT\
(int)
is_equan_to
(uint64_t *fra, uint64_t *frb)
#line 1341 "../../sim/ppc/powerpc.igen"
{
  return *(double*)fra == *(double*)frb;
}
#line 538 "support.c"

PSIM_INLINE_SUPPORT\
(uint64_t)
select_qnan
(uint64_t fra, uint64_t frb, uint64_t frc, int instruction_is_frsp, int generate_qnan, int single)
#line 1346 "../../sim/ppc/powerpc.igen"
{
  uint64_t frt = 0;
  if (is_NaN(fra, single))
    frt = fra;
  else if (is_NaN(frb, single))
    if (instruction_is_frsp)
      frt = MASKED64(frb, 0, 34);
    else
      frt = frb;
  else if (is_NaN(frc, single))
    frt = frc;
  else if (generate_qnan)
    frt = MASK64(1, 12); /* 0x7FF8_0000_0000_0000 */
  else
    error("select_qnan - default reached\n");
  return frt;
}
#line 562 "support.c"

PSIM_INLINE_SUPPORT\
(int)
is_invalid_operation
(cpu *processor, unsigned_word cia, uint64_t fra, uint64_t frb, fpscreg check, int single, int negate)
#line 1365 "../../sim/ppc/powerpc.igen"
{
  int fail = 0;
  if ((check & fpscr_vxsnan)
      && (is_SNaN(fra, single) || is_SNaN(frb, single))) {
    FPSCR_OR_VX(fpscr_vxsnan);
    fail = 1;
  }
  if ((check & fpscr_vxisi)
      && (is_inf(fra, single) && is_inf(frb, single))
      && ((negate && sign(fra) != sign(frb))
          || (!negate && sign(fra) == sign(frb)))) {
     /*FIXME: don't handle inf-inf VS inf+-inf */
    FPSCR_OR_VX(fpscr_vxisi);
    fail = 1;
  }
  if ((check & fpscr_vxidi)
      && (is_inf(fra, single) && is_inf(frb, single))) {
    FPSCR_OR_VX(fpscr_vxidi);
    fail = 1;
  }
  if ((check & fpscr_vxzdz)
      && (is_zero(fra) && is_zero(frb))) {
    FPSCR_OR_VX(fpscr_vxzdz);
    fail = 1;
  }
  if ((check & fpscr_vximz)
      && (is_zero(fra) && is_inf(frb, single))) {
    FPSCR_OR_VX(fpscr_vximz);
    fail = 1;
  }
  if ((check & fpscr_vxvc)
      && (is_NaN(fra, single) || is_NaN(frb, single))) {
    FPSCR_OR_VX(fpscr_vxvc);
    fail = 1;
  }
  if ((check & fpscr_vxsoft)) {
    FPSCR_OR_VX(fpscr_vxsoft);
    fail = 1;
  }
  if ((check & fpscr_vxsqrt)
      && sign(fra) < 0) {
    FPSCR_OR_VX(fpscr_vxsqrt);
    fail = 1;
  }
  /* if ((check && fpscr_vxcvi) {
      && (is_inf(fra, single) || is_NaN(fra, single) || is_large(fra, single)))
    FPSCR_OR_VX(fpscr_vxcvi);
    fail = 1;
  }
  */
  return fail;
}
#line 621 "support.c"

PSIM_INLINE_SUPPORT\
(void)
invalid_arithemetic_operation
(cpu *processor, unsigned_word cia, uint64_t *frt, uint64_t fra, uint64_t frb, uint64_t frc, int instruction_is_frsp, int instruction_is_convert_to_64bit, int instruction_is_convert_to_32bit, int single)
#line 1422 "../../sim/ppc/powerpc.igen"
{
  if (FPSCR & fpscr_ve) {
    /* invalid operation exception enabled */
    /* FRT unchaged */
    FPSCR_SET_FR(0);
    FPSCR_SET_FI(0);
    /* fpscr_FPRF unchanged */
  }
  else {
    /* invalid operation exception disabled */
    if (instruction_is_convert_to_64bit) {
      error("oopsi");
    }
    else if (instruction_is_convert_to_32bit) {
      error("oopsi");
    }
    else { /* arrith, frsp */
      *frt = select_qnan(fra, frb, frc,
                         instruction_is_frsp, 1/*generate*/, single);
      FPSCR_SET_FR(0);
      FPSCR_SET_FI(0);
      FPSCR_SET_FPRF(fpscr_rf_quiet_nan);
    }
  }
}
#line 653 "support.c"

PSIM_INLINE_SUPPORT\
(int)
is_invalid_zero_divide
(cpu *processor, unsigned_word cia, uint64_t fra, uint64_t frb, int single)
#line 1451 "../../sim/ppc/powerpc.igen"
{
  int fail = 0;
  if (is_zero (frb)) {
    FPSCR_SET_ZX (1);
    fail = 1;
  }
  return fail;
}
#line 668 "support.c"

PSIM_INLINE_SUPPORT\
(void)
invalid_zero_divide_operation
(cpu *processor, unsigned_word cia, uint64_t *frt, uint64_t fra, uint64_t frb, int single)
#line 1463 "../../sim/ppc/powerpc.igen"
{
  if (FPSCR & fpscr_ze) {
    /* zero-divide exception enabled */
    /* FRT unchaged */
    FPSCR_SET_FR(0);
    FPSCR_SET_FI(0);
    /* fpscr_FPRF unchanged */
  }
  else {
    /* zero-divide exception disabled */
    FPSCR_SET_FR(0);
    FPSCR_SET_FI(0);
    if ((sign (fra) < 0 && sign (frb) < 0)
        || (sign (fra) > 0 && sign (frb) > 0)) {
      *frt = MASK64 (1, 11); /* 0 : 2047 : 0..0 */
      FPSCR_SET_FPRF(fpscr_rf_pos_infinity);
    }
    else {
      *frt = MASK64 (0, 11); /* 1 : 2047 : 0..0 */
      FPSCR_SET_FPRF(fpscr_rf_neg_infinity);
    }
  }
}
#line 698 "support.c"


#endif /* _SUPPORT_C_*/
