use crate::spec::{Abi, Arch, FloatAbi, Target, TargetMetadata, TargetOptions, base};

pub(crate) fn target() -> Target {
    Target {
        llvm_target: "armv6-unknown-netbsdelf-eabihf".into(),
        metadata: TargetMetadata {
            description: Some("Armv6 NetBSD w/hard-float".into()),
            tier: Some(3),
            host_tools: Some(true),
            std: Some(true),
        },
        pointer_width: 32,
        data_layout: "e-m:e-p:32:32-Fi8-i64:64-v128:64:128-a:0:32-n32-S64".into(),
        arch: Arch::Arm,
        options: TargetOptions {
            abi: Abi::EabiHf,
            llvm_floatabi: Some(FloatAbi::Hard),
            features: "+v6,+vfp2,-d32".into(),
            max_atomic_width: Some(64),
            mcount: "__mcount".into(),
            ..base::netbsd::opts()
        },
    }
}
