/* parser auto-generated by pidl */

#include "replace.h"
#include "bin/default/librpc/gen_ndr/ndr_ntlmssp.h"

#include "librpc/gen_ndr/ndr_security.h"
static enum ndr_err_code ndr_push_ntlmssp_MessageType(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum ntlmssp_MessageType r)
{
	NDR_CHECK(ndr_push_enum_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ntlmssp_MessageType(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum ntlmssp_MessageType *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_enum_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ntlmssp_MessageType(struct ndr_print *ndr, const char *name, enum ntlmssp_MessageType r)
{
	const char *val = NULL;

	switch (r) {
		case NtLmNegotiate: val = "NtLmNegotiate"; break;
		case NtLmChallenge: val = "NtLmChallenge"; break;
		case NtLmAuthenticate: val = "NtLmAuthenticate"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_NEGOTIATE(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_NEGOTIATE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_NEGOTIATE(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NTLMSSP_NEGOTIATE_UNICODE", NTLMSSP_NEGOTIATE_UNICODE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NTLMSSP_NEGOTIATE_OEM", NTLMSSP_NEGOTIATE_OEM, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NTLMSSP_REQUEST_TARGET", NTLMSSP_REQUEST_TARGET, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NTLMSSP_NEGOTIATE_SIGN", NTLMSSP_NEGOTIATE_SIGN, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NTLMSSP_NEGOTIATE_SEAL", NTLMSSP_NEGOTIATE_SEAL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NTLMSSP_NEGOTIATE_DATAGRAM", NTLMSSP_NEGOTIATE_DATAGRAM, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NTLMSSP_NEGOTIATE_LM_KEY", NTLMSSP_NEGOTIATE_LM_KEY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NTLMSSP_NEGOTIATE_NETWARE", NTLMSSP_NEGOTIATE_NETWARE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NTLMSSP_NEGOTIATE_NTLM", NTLMSSP_NEGOTIATE_NTLM, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NTLMSSP_NEGOTIATE_NT_ONLY", NTLMSSP_NEGOTIATE_NT_ONLY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NTLMSSP_ANONYMOUS", NTLMSSP_ANONYMOUS, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NTLMSSP_NEGOTIATE_OEM_DOMAIN_SUPPLIED", NTLMSSP_NEGOTIATE_OEM_DOMAIN_SUPPLIED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NTLMSSP_NEGOTIATE_OEM_WORKSTATION_SUPPLIED", NTLMSSP_NEGOTIATE_OEM_WORKSTATION_SUPPLIED, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NTLMSSP_NEGOTIATE_THIS_IS_LOCAL_CALL", NTLMSSP_NEGOTIATE_THIS_IS_LOCAL_CALL, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NTLMSSP_NEGOTIATE_ALWAYS_SIGN", NTLMSSP_NEGOTIATE_ALWAYS_SIGN, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NTLMSSP_TARGET_TYPE_DOMAIN", NTLMSSP_TARGET_TYPE_DOMAIN, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NTLMSSP_TARGET_TYPE_SERVER", NTLMSSP_TARGET_TYPE_SERVER, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NTLMSSP_TARGET_TYPE_SHARE", NTLMSSP_TARGET_TYPE_SHARE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NTLMSSP_NEGOTIATE_EXTENDED_SESSIONSECURITY", NTLMSSP_NEGOTIATE_EXTENDED_SESSIONSECURITY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NTLMSSP_NEGOTIATE_IDENTIFY", NTLMSSP_NEGOTIATE_IDENTIFY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NTLMSSP_REQUEST_NON_NT_SESSION_KEY", NTLMSSP_REQUEST_NON_NT_SESSION_KEY, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NTLMSSP_NEGOTIATE_TARGET_INFO", NTLMSSP_NEGOTIATE_TARGET_INFO, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NTLMSSP_NEGOTIATE_VERSION", NTLMSSP_NEGOTIATE_VERSION, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NTLMSSP_NEGOTIATE_128", NTLMSSP_NEGOTIATE_128, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NTLMSSP_NEGOTIATE_KEY_EXCH", NTLMSSP_NEGOTIATE_KEY_EXCH, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NTLMSSP_NEGOTIATE_56", NTLMSSP_NEGOTIATE_56, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_ntlmssp_WindowsMajorVersion(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum ntlmssp_WindowsMajorVersion r)
{
	NDR_CHECK(ndr_push_enum_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ntlmssp_WindowsMajorVersion(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum ntlmssp_WindowsMajorVersion *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_enum_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ntlmssp_WindowsMajorVersion(struct ndr_print *ndr, const char *name, enum ntlmssp_WindowsMajorVersion r)
{
	const char *val = NULL;

	switch (r) {
		case NTLMSSP_WINDOWS_MAJOR_VERSION_5: val = "NTLMSSP_WINDOWS_MAJOR_VERSION_5"; break;
		case NTLMSSP_WINDOWS_MAJOR_VERSION_6: val = "NTLMSSP_WINDOWS_MAJOR_VERSION_6"; break;
		case NTLMSSP_WINDOWS_MAJOR_VERSION_10: val = "NTLMSSP_WINDOWS_MAJOR_VERSION_10"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_ntlmssp_WindowsMinorVersion(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum ntlmssp_WindowsMinorVersion r)
{
	NDR_CHECK(ndr_push_enum_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ntlmssp_WindowsMinorVersion(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum ntlmssp_WindowsMinorVersion *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_enum_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ntlmssp_WindowsMinorVersion(struct ndr_print *ndr, const char *name, enum ntlmssp_WindowsMinorVersion r)
{
	const char *val = NULL;

	switch (r) {
		case NTLMSSP_WINDOWS_MINOR_VERSION_0: val = "NTLMSSP_WINDOWS_MINOR_VERSION_0"; break;
		case NTLMSSP_WINDOWS_MINOR_VERSION_1: val = "NTLMSSP_WINDOWS_MINOR_VERSION_1"; break;
		case NTLMSSP_WINDOWS_MINOR_VERSION_2: val = "NTLMSSP_WINDOWS_MINOR_VERSION_2"; break;
		case NTLMSSP_WINDOWS_MINOR_VERSION_3: val = "NTLMSSP_WINDOWS_MINOR_VERSION_3"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_ntlmssp_NTLMRevisionCurrent(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum ntlmssp_NTLMRevisionCurrent r)
{
	NDR_CHECK(ndr_push_enum_uint8(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ntlmssp_NTLMRevisionCurrent(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum ntlmssp_NTLMRevisionCurrent *r)
{
	uint8_t v;
	NDR_CHECK(ndr_pull_enum_uint8(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ntlmssp_NTLMRevisionCurrent(struct ndr_print *ndr, const char *name, enum ntlmssp_NTLMRevisionCurrent r)
{
	const char *val = NULL;

	switch (r) {
		case NTLMSSP_REVISION_W2K3_RC1: val = "NTLMSSP_REVISION_W2K3_RC1"; break;
		case NTLMSSP_REVISION_W2K3: val = "NTLMSSP_REVISION_W2K3"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

_PUBLIC_ enum ndr_err_code ndr_push_ntlmssp_VERSION(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct ntlmssp_VERSION *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 2));
		NDR_CHECK(ndr_push_ntlmssp_WindowsMajorVersion(ndr, NDR_SCALARS, r->ProductMajorVersion));
		NDR_CHECK(ndr_push_ntlmssp_WindowsMinorVersion(ndr, NDR_SCALARS, r->ProductMinorVersion));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->ProductBuild));
		NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->Reserved, 3));
		NDR_CHECK(ndr_push_ntlmssp_NTLMRevisionCurrent(ndr, NDR_SCALARS, r->NTLMRevisionCurrent));
		NDR_CHECK(ndr_push_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_ntlmssp_VERSION(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct ntlmssp_VERSION *r)
{
	uint32_t size_Reserved_0 = 0;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 2));
		NDR_CHECK(ndr_pull_ntlmssp_WindowsMajorVersion(ndr, NDR_SCALARS, &r->ProductMajorVersion));
		NDR_CHECK(ndr_pull_ntlmssp_WindowsMinorVersion(ndr, NDR_SCALARS, &r->ProductMinorVersion));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->ProductBuild));
		size_Reserved_0 = 3;
		NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->Reserved, size_Reserved_0));
		NDR_CHECK(ndr_pull_ntlmssp_NTLMRevisionCurrent(ndr, NDR_SCALARS, &r->NTLMRevisionCurrent));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 2));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_ntlmssp_VERSION(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct ntlmssp_VERSION *r)
{
	ndr_print_ntlmssp_VERSION(ndr, name, r);
}

_PUBLIC_ void ndr_print_ntlmssp_VERSION(struct ndr_print *ndr, const char *name, const struct ntlmssp_VERSION *r)
{
	ndr_print_struct(ndr, name, "ntlmssp_VERSION");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_ntlmssp_WindowsMajorVersion(ndr, "ProductMajorVersion", r->ProductMajorVersion);
	ndr_print_ntlmssp_WindowsMinorVersion(ndr, "ProductMinorVersion", r->ProductMinorVersion);
	ndr_print_uint16(ndr, "ProductBuild", r->ProductBuild);
	ndr_print_array_uint8(ndr, "Reserved", r->Reserved, 3);
	ndr_print_ntlmssp_NTLMRevisionCurrent(ndr, "NTLMRevisionCurrent", r->NTLMRevisionCurrent);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_ntlmssp_Version(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union ntlmssp_Version *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 2));
		switch (level) {
			case NTLMSSP_NEGOTIATE_VERSION: {
				NDR_CHECK(ndr_push_ntlmssp_VERSION(ndr, NDR_SCALARS, &r->version));
			break; }

			default: {
			break; }

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ntlmssp_Version(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union ntlmssp_Version *r)
{
	uint32_t level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 2));
		switch (level) {
			case NTLMSSP_NEGOTIATE_VERSION: {
				NDR_CHECK(ndr_pull_ntlmssp_VERSION(ndr, NDR_SCALARS, &r->version));
			break; }

			default: {
			break; }

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_push_NEGOTIATE_MESSAGE(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct NEGOTIATE_MESSAGE *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 5));
		NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, "NTLMSSP", 8, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_push_ntlmssp_MessageType(ndr, NDR_SCALARS, NtLmNegotiate));
		NDR_CHECK(ndr_push_NEGOTIATE(ndr, NDR_SCALARS, r->NegotiateFlags));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->DomainName?strlen(r->DomainName):0));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->DomainName?strlen(r->DomainName):0));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(NTLMSSP_NEGOTIATE_OEM));
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->DomainName));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->Workstation?strlen(r->Workstation):0));
		NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->Workstation?strlen(r->Workstation):0));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(NTLMSSP_NEGOTIATE_OEM));
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->Workstation));
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->Version, r->NegotiateFlags & NTLMSSP_NEGOTIATE_VERSION));
		NDR_CHECK(ndr_push_ntlmssp_Version(ndr, NDR_SCALARS, &r->Version));
		NDR_CHECK(ndr_push_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(NTLMSSP_NEGOTIATE_OEM));
			if (r->DomainName) {
				NDR_CHECK(ndr_push_relative_ptr2_start(ndr, r->DomainName));
				{
					struct ndr_push *_ndr_DomainName;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_DomainName, 0, r->DomainName?strlen(r->DomainName):0));
					NDR_CHECK(ndr_push_string(_ndr_DomainName, NDR_SCALARS, r->DomainName));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_DomainName, 0, r->DomainName?strlen(r->DomainName):0));
				}
				NDR_CHECK(ndr_push_relative_ptr2_end(ndr, r->DomainName));
			}
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(NTLMSSP_NEGOTIATE_OEM));
			if (r->Workstation) {
				NDR_CHECK(ndr_push_relative_ptr2_start(ndr, r->Workstation));
				{
					struct ndr_push *_ndr_Workstation;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_Workstation, 0, r->Workstation?strlen(r->Workstation):0));
					NDR_CHECK(ndr_push_string(_ndr_Workstation, NDR_SCALARS, r->Workstation));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_Workstation, 0, r->Workstation?strlen(r->Workstation):0));
				}
				NDR_CHECK(ndr_push_relative_ptr2_end(ndr, r->Workstation));
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_push_set_switch_value(ndr, &r->Version, r->NegotiateFlags & NTLMSSP_NEGOTIATE_VERSION));
		NDR_CHECK(ndr_push_ntlmssp_Version(ndr, NDR_BUFFERS, &r->Version));
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_NEGOTIATE_MESSAGE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct NEGOTIATE_MESSAGE *r)
{
	uint32_t size_Signature_0 = 0;
	uint32_t _ptr_DomainName;
	TALLOC_CTX *_mem_save_DomainName_0 = NULL;
	uint32_t _ptr_Workstation;
	TALLOC_CTX *_mem_save_Workstation_0 = NULL;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 5));
		size_Signature_0 = 8;
		NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->Signature, size_Signature_0, sizeof(uint8_t), CH_DOS));
		NDR_CHECK(ndr_pull_ntlmssp_MessageType(ndr, NDR_SCALARS, &r->MessageType));
		NDR_CHECK(ndr_pull_NEGOTIATE(ndr, NDR_SCALARS, &r->NegotiateFlags));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->DomainNameLen));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->DomainNameMaxLen));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(NTLMSSP_NEGOTIATE_OEM));
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_DomainName));
			if (_ptr_DomainName) {
				NDR_PULL_ALLOC(ndr, r->DomainName);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->DomainName, _ptr_DomainName));
			} else {
				r->DomainName = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->WorkstationLen));
		NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->WorkstationMaxLen));
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(NTLMSSP_NEGOTIATE_OEM));
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Workstation));
			if (_ptr_Workstation) {
				NDR_PULL_ALLOC(ndr, r->Workstation);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->Workstation, _ptr_Workstation));
			} else {
				r->Workstation = NULL;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->Version, r->NegotiateFlags & NTLMSSP_NEGOTIATE_VERSION));
		NDR_CHECK(ndr_pull_ntlmssp_Version(ndr, NDR_SCALARS, &r->Version));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
	}
	if (ndr_flags & NDR_BUFFERS) {
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(NTLMSSP_NEGOTIATE_OEM));
			if (r->DomainName) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->DomainName));
				_mem_save_DomainName_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->DomainName, 0);
				{
					struct ndr_pull *_ndr_DomainName;
					ssize_t sub_size = r->DomainNameLen;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_DomainName, 0, sub_size));
					NDR_CHECK(ndr_pull_string(_ndr_DomainName, NDR_SCALARS, &r->DomainName));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_DomainName, 0, sub_size));
				}
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_DomainName_0, 0);
				if (ndr->offset > ndr->relative_highest_offset) {
					ndr->relative_highest_offset = ndr->offset;
				}
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(NTLMSSP_NEGOTIATE_OEM));
			if (r->Workstation) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->Workstation));
				_mem_save_Workstation_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->Workstation, 0);
				{
					struct ndr_pull *_ndr_Workstation;
					ssize_t sub_size = r->WorkstationLen;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_Workstation, 0, sub_size));
					NDR_CHECK(ndr_pull_string(_ndr_Workstation, NDR_SCALARS, &r->Workstation));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_Workstation, 0, sub_size));
				}
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Workstation_0, 0);
				if (ndr->offset > ndr->relative_highest_offset) {
					ndr->relative_highest_offset = ndr->offset;
				}
				ndr->offset = _relative_save_offset;
			}
			ndr->flags = _flags_save_string;
		}
		NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->Version, r->NegotiateFlags & NTLMSSP_NEGOTIATE_VERSION));
		NDR_CHECK(ndr_pull_ntlmssp_Version(ndr, NDR_BUFFERS, &r->Version));
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_NEGOTIATE_MESSAGE(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct NEGOTIATE_MESSAGE *r)
{
	ndr_print_NEGOTIATE_MESSAGE(ndr, name, r);
}

_PUBLIC_ void ndr_print_NEGOTIATE_MESSAGE(struct ndr_print *ndr, const char *name, const struct NEGOTIATE_MESSAGE *r)
{
	ndr_print_struct(ndr, name, "NEGOTIATE_MESSAGE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_string(ndr, "Signature", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?"NTLMSSP":r->Signature);
	ndr_print_ntlmssp_MessageType(ndr, "MessageType", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?NtLmNegotiate:r->MessageType);
	ndr_print_NEGOTIATE(ndr, "NegotiateFlags", r->NegotiateFlags);
	ndr_print_uint16(ndr, "DomainNameLen", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->DomainName?strlen(r->DomainName):0:r->DomainNameLen);
	ndr_print_uint16(ndr, "DomainNameMaxLen", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->DomainNameLen:r->DomainNameMaxLen);
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(NTLMSSP_NEGOTIATE_OEM));
		ndr_print_ptr(ndr, "DomainName", r->DomainName);
		ndr->depth++;
		if (r->DomainName) {
			ndr_print_string(ndr, "DomainName", r->DomainName);
		}
		ndr->depth--;
		ndr->flags = _flags_save_string;
	}
	ndr_print_uint16(ndr, "WorkstationLen", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->Workstation?strlen(r->Workstation):0:r->WorkstationLen);
	ndr_print_uint16(ndr, "WorkstationMaxLen", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->WorkstationLen:r->WorkstationMaxLen);
	{
		libndr_flags _flags_save_string = ndr->flags;
		ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(NTLMSSP_NEGOTIATE_OEM));
		ndr_print_ptr(ndr, "Workstation", r->Workstation);
		ndr->depth++;
		if (r->Workstation) {
			ndr_print_string(ndr, "Workstation", r->Workstation);
		}
		ndr->depth--;
		ndr->flags = _flags_save_string;
	}
	ndr_print_set_switch_value(ndr, &r->Version, r->NegotiateFlags & NTLMSSP_NEGOTIATE_VERSION);
	ndr_print_ntlmssp_Version(ndr, "Version", &r->Version);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_ntlmssp_AvId(struct ndr_push *ndr, ndr_flags_type ndr_flags, enum ntlmssp_AvId r)
{
	NDR_CHECK(ndr_push_enum_uint1632(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ntlmssp_AvId(struct ndr_pull *ndr, ndr_flags_type ndr_flags, enum ntlmssp_AvId *r)
{
	uint16_t v;
	NDR_CHECK(ndr_pull_enum_uint1632(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ntlmssp_AvId(struct ndr_print *ndr, const char *name, enum ntlmssp_AvId r)
{
	const char *val = NULL;

	switch (r) {
		case MsvAvEOL: val = "MsvAvEOL"; break;
		case MsvAvNbComputerName: val = "MsvAvNbComputerName"; break;
		case MsvAvNbDomainName: val = "MsvAvNbDomainName"; break;
		case MsvAvDnsComputerName: val = "MsvAvDnsComputerName"; break;
		case MsvAvDnsDomainName: val = "MsvAvDnsDomainName"; break;
		case MsvAvDnsTreeName: val = "MsvAvDnsTreeName"; break;
		case MsvAvFlags: val = "MsvAvFlags"; break;
		case MsvAvTimestamp: val = "MsvAvTimestamp"; break;
		case MsvAvSingleHost: val = "MsvAvSingleHost"; break;
		case MsvAvTargetName: val = "MsvAvTargetName"; break;
		case MsvChannelBindings: val = "MsvChannelBindings"; break;
	}
	ndr_print_enum(ndr, name, "ENUM", val, r);
}

static enum ndr_err_code ndr_push_ntlmssp_SingleHostData(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct ntlmssp_SingleHostData *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 8 + ndr_size_LSAP_TOKEN_INFO_INTEGRITY(&r->token_info, 0) + r->remaining.length));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, 0));
			NDR_CHECK(ndr_push_LSAP_TOKEN_INFO_INTEGRITY(ndr, NDR_SCALARS, &r->token_info));
			{
				libndr_flags _flags_save_DATA_BLOB = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
				NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->remaining));
				ndr->flags = _flags_save_DATA_BLOB;
			}
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ntlmssp_SingleHostData(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct ntlmssp_SingleHostData *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Size));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Z4));
			NDR_CHECK(ndr_pull_LSAP_TOKEN_INFO_INTEGRITY(ndr, NDR_SCALARS, &r->token_info));
			{
				libndr_flags _flags_save_DATA_BLOB = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
				NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->remaining));
				ndr->flags = _flags_save_DATA_BLOB;
			}
			NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ntlmssp_SingleHostData(struct ndr_print *ndr, const char *name, const struct ntlmssp_SingleHostData *r)
{
	ndr_print_struct(ndr, name, "ntlmssp_SingleHostData");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_uint32(ndr, "Size", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?8 + ndr_size_LSAP_TOKEN_INFO_INTEGRITY(&r->token_info, 0) + r->remaining.length:r->Size);
		ndr_print_uint32(ndr, "Z4", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?0:r->Z4);
		ndr_print_LSAP_TOKEN_INFO_INTEGRITY(ndr, "token_info", &r->token_info);
		{
			libndr_flags _flags_save_DATA_BLOB = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			ndr_print_DATA_BLOB(ndr, "remaining", r->remaining);
			ndr->flags = _flags_save_DATA_BLOB;
		}
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_ntlmssp_AvFlags(struct ndr_push *ndr, ndr_flags_type ndr_flags, uint32_t r)
{
	NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r));
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ntlmssp_AvFlags(struct ndr_pull *ndr, ndr_flags_type ndr_flags, uint32_t *r)
{
	uint32_t v;
	NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &v));
	*r = v;
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ntlmssp_AvFlags(struct ndr_print *ndr, const char *name, uint32_t r)
{
	ndr_print_uint32(ndr, name, r);
	ndr->depth++;
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NTLMSSP_AVFLAG_CONSTRAINTED_ACCOUNT", NTLMSSP_AVFLAG_CONSTRAINTED_ACCOUNT, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NTLMSSP_AVFLAG_MIC_IN_AUTHENTICATE_MESSAGE", NTLMSSP_AVFLAG_MIC_IN_AUTHENTICATE_MESSAGE, r);
	ndr_print_bitmap_flag(ndr, sizeof(uint32_t), "NTLMSSP_AVFLAG_TARGET_SPN_FROM_UNTRUSTED_SOURCE", NTLMSSP_AVFLAG_TARGET_SPN_FROM_UNTRUSTED_SOURCE, r);
	ndr->depth--;
}

static enum ndr_err_code ndr_push_ntlmssp_AvValue(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union ntlmssp_AvValue *r)
{
	uint32_t level;
	{
		libndr_flags _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
			NDR_CHECK(ndr_push_union_align(ndr, 4));
			switch (level) {
				case MsvAvEOL: {
				break; }

				case MsvAvNbComputerName: {
					{
						libndr_flags _flags_save_string = ndr->flags;
						ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(NTLMSSP_NEGOTIATE_UNICODE));
						NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->AvNbComputerName));
						ndr->flags = _flags_save_string;
					}
				break; }

				case MsvAvNbDomainName: {
					{
						libndr_flags _flags_save_string = ndr->flags;
						ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(NTLMSSP_NEGOTIATE_UNICODE));
						NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->AvNbDomainName));
						ndr->flags = _flags_save_string;
					}
				break; }

				case MsvAvDnsComputerName: {
					{
						libndr_flags _flags_save_string = ndr->flags;
						ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(NTLMSSP_NEGOTIATE_UNICODE));
						NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->AvDnsComputerName));
						ndr->flags = _flags_save_string;
					}
				break; }

				case MsvAvDnsDomainName: {
					{
						libndr_flags _flags_save_string = ndr->flags;
						ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(NTLMSSP_NEGOTIATE_UNICODE));
						NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->AvDnsDomainName));
						ndr->flags = _flags_save_string;
					}
				break; }

				case MsvAvDnsTreeName: {
					{
						libndr_flags _flags_save_string = ndr->flags;
						ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(NTLMSSP_NEGOTIATE_UNICODE));
						NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->AvDnsTreeName));
						ndr->flags = _flags_save_string;
					}
				break; }

				case MsvAvFlags: {
					NDR_CHECK(ndr_push_ntlmssp_AvFlags(ndr, NDR_SCALARS, r->AvFlags));
				break; }

				case MsvAvTimestamp: {
					NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->AvTimestamp));
				break; }

				case MsvAvSingleHost: {
					NDR_CHECK(ndr_push_ntlmssp_SingleHostData(ndr, NDR_SCALARS, &r->AvSingleHost));
				break; }

				case MsvAvTargetName: {
					{
						libndr_flags _flags_save_string = ndr->flags;
						ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(NTLMSSP_NEGOTIATE_UNICODE));
						NDR_CHECK(ndr_push_string(ndr, NDR_SCALARS, r->AvTargetName));
						ndr->flags = _flags_save_string;
					}
				break; }

				case MsvChannelBindings: {
					NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->ChannelBindings, 16));
				break; }

				default: {
					{
						libndr_flags _flags_save_DATA_BLOB = ndr->flags;
						ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
						NDR_CHECK(ndr_push_DATA_BLOB(ndr, NDR_SCALARS, r->blob));
						ndr->flags = _flags_save_DATA_BLOB;
					}
				break; }

			}
		}
		ndr->flags = _flags_save_UNION;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ntlmssp_AvValue(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union ntlmssp_AvValue *r)
{
	uint32_t level;
	uint32_t size_ChannelBindings_0 = 0;
	{
		libndr_flags _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
			NDR_CHECK(ndr_pull_union_align(ndr, 4));
			switch (level) {
				case MsvAvEOL: {
				break; }

				case MsvAvNbComputerName: {
					{
						libndr_flags _flags_save_string = ndr->flags;
						ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(NTLMSSP_NEGOTIATE_UNICODE));
						NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->AvNbComputerName));
						ndr->flags = _flags_save_string;
					}
				break; }

				case MsvAvNbDomainName: {
					{
						libndr_flags _flags_save_string = ndr->flags;
						ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(NTLMSSP_NEGOTIATE_UNICODE));
						NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->AvNbDomainName));
						ndr->flags = _flags_save_string;
					}
				break; }

				case MsvAvDnsComputerName: {
					{
						libndr_flags _flags_save_string = ndr->flags;
						ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(NTLMSSP_NEGOTIATE_UNICODE));
						NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->AvDnsComputerName));
						ndr->flags = _flags_save_string;
					}
				break; }

				case MsvAvDnsDomainName: {
					{
						libndr_flags _flags_save_string = ndr->flags;
						ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(NTLMSSP_NEGOTIATE_UNICODE));
						NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->AvDnsDomainName));
						ndr->flags = _flags_save_string;
					}
				break; }

				case MsvAvDnsTreeName: {
					{
						libndr_flags _flags_save_string = ndr->flags;
						ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(NTLMSSP_NEGOTIATE_UNICODE));
						NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->AvDnsTreeName));
						ndr->flags = _flags_save_string;
					}
				break; }

				case MsvAvFlags: {
					NDR_CHECK(ndr_pull_ntlmssp_AvFlags(ndr, NDR_SCALARS, &r->AvFlags));
				break; }

				case MsvAvTimestamp: {
					NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->AvTimestamp));
				break; }

				case MsvAvSingleHost: {
					NDR_CHECK(ndr_pull_ntlmssp_SingleHostData(ndr, NDR_SCALARS, &r->AvSingleHost));
				break; }

				case MsvAvTargetName: {
					{
						libndr_flags _flags_save_string = ndr->flags;
						ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(NTLMSSP_NEGOTIATE_UNICODE));
						NDR_CHECK(ndr_pull_string(ndr, NDR_SCALARS, &r->AvTargetName));
						ndr->flags = _flags_save_string;
					}
				break; }

				case MsvChannelBindings: {
					size_ChannelBindings_0 = 16;
					NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->ChannelBindings, size_ChannelBindings_0));
				break; }

				default: {
					{
						libndr_flags _flags_save_DATA_BLOB = ndr->flags;
						ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
						NDR_CHECK(ndr_pull_DATA_BLOB(ndr, NDR_SCALARS, &r->blob));
						ndr->flags = _flags_save_DATA_BLOB;
					}
				break; }

			}
		}
		ndr->flags = _flags_save_UNION;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ntlmssp_AvValue(struct ndr_print *ndr, const char *name, const union ntlmssp_AvValue *r)
{
	uint32_t level;
	{
		libndr_flags _flags_save_UNION = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		level = ndr_print_steal_switch_value(ndr, r);
		ndr_print_union(ndr, name, level, "ntlmssp_AvValue");
		switch (level) {
			case MsvAvEOL:
			break;

			case MsvAvNbComputerName:
				{
					libndr_flags _flags_save_string = ndr->flags;
					ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(NTLMSSP_NEGOTIATE_UNICODE));
					ndr_print_string(ndr, "AvNbComputerName", r->AvNbComputerName);
					ndr->flags = _flags_save_string;
				}
			break;

			case MsvAvNbDomainName:
				{
					libndr_flags _flags_save_string = ndr->flags;
					ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(NTLMSSP_NEGOTIATE_UNICODE));
					ndr_print_string(ndr, "AvNbDomainName", r->AvNbDomainName);
					ndr->flags = _flags_save_string;
				}
			break;

			case MsvAvDnsComputerName:
				{
					libndr_flags _flags_save_string = ndr->flags;
					ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(NTLMSSP_NEGOTIATE_UNICODE));
					ndr_print_string(ndr, "AvDnsComputerName", r->AvDnsComputerName);
					ndr->flags = _flags_save_string;
				}
			break;

			case MsvAvDnsDomainName:
				{
					libndr_flags _flags_save_string = ndr->flags;
					ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(NTLMSSP_NEGOTIATE_UNICODE));
					ndr_print_string(ndr, "AvDnsDomainName", r->AvDnsDomainName);
					ndr->flags = _flags_save_string;
				}
			break;

			case MsvAvDnsTreeName:
				{
					libndr_flags _flags_save_string = ndr->flags;
					ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(NTLMSSP_NEGOTIATE_UNICODE));
					ndr_print_string(ndr, "AvDnsTreeName", r->AvDnsTreeName);
					ndr->flags = _flags_save_string;
				}
			break;

			case MsvAvFlags:
				ndr_print_ntlmssp_AvFlags(ndr, "AvFlags", r->AvFlags);
			break;

			case MsvAvTimestamp:
				ndr_print_NTTIME(ndr, "AvTimestamp", r->AvTimestamp);
			break;

			case MsvAvSingleHost:
				ndr_print_ntlmssp_SingleHostData(ndr, "AvSingleHost", &r->AvSingleHost);
			break;

			case MsvAvTargetName:
				{
					libndr_flags _flags_save_string = ndr->flags;
					ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(NTLMSSP_NEGOTIATE_UNICODE));
					ndr_print_string(ndr, "AvTargetName", r->AvTargetName);
					ndr->flags = _flags_save_string;
				}
			break;

			case MsvChannelBindings:
				ndr_print_array_uint8(ndr, "ChannelBindings", r->ChannelBindings, 16);
			break;

			default:
				{
					libndr_flags _flags_save_DATA_BLOB = ndr->flags;
					ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
					ndr_print_DATA_BLOB(ndr, "blob", r->blob);
					ndr->flags = _flags_save_DATA_BLOB;
				}
			break;

		}
		ndr->flags = _flags_save_UNION;
	}
}

static size_t ndr_size_ntlmssp_AvValue(const union ntlmssp_AvValue *r, uint32_t level, libndr_flags flags)
{
	flags |= LIBNDR_FLAG_NOALIGN;
	return ndr_size_union(r, flags, level, (ndr_push_flags_fn_t)ndr_push_ntlmssp_AvValue);
}

_PUBLIC_ enum ndr_err_code ndr_push_AV_PAIR(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct AV_PAIR *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_ntlmssp_AvId(ndr, NDR_SCALARS, r->AvId));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, ndr_size_ntlmssp_AvValue(&r->Value, r->AvId, 0)));
			{
				struct ndr_push *_ndr_Value;
				NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_Value, 0, ndr_size_ntlmssp_AvValue(&r->Value, r->AvId, 0)));
				NDR_CHECK(ndr_push_set_switch_value(_ndr_Value, &r->Value, r->AvId));
				NDR_CHECK(ndr_push_ntlmssp_AvValue(_ndr_Value, NDR_SCALARS|NDR_BUFFERS, &r->Value));
				NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_Value, 0, ndr_size_ntlmssp_AvValue(&r->Value, r->AvId, 0)));
			}
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_AV_PAIR(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct AV_PAIR *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_ntlmssp_AvId(ndr, NDR_SCALARS, &r->AvId));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->AvLen));
			{
				struct ndr_pull *_ndr_Value;
				ssize_t sub_size = r->AvLen;
				NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_Value, 0, sub_size));
				NDR_CHECK(ndr_pull_set_switch_value(_ndr_Value, &r->Value, r->AvId));
				NDR_CHECK(ndr_pull_ntlmssp_AvValue(_ndr_Value, NDR_SCALARS|NDR_BUFFERS, &r->Value));
				NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_Value, 0, sub_size));
			}
			NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_AV_PAIR(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct AV_PAIR *r)
{
	ndr_print_AV_PAIR(ndr, name, r);
}

_PUBLIC_ void ndr_print_AV_PAIR(struct ndr_print *ndr, const char *name, const struct AV_PAIR *r)
{
	ndr_print_struct(ndr, name, "AV_PAIR");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		ndr->depth++;
		ndr_print_ntlmssp_AvId(ndr, "AvId", r->AvId);
		ndr_print_uint16(ndr, "AvLen", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_ntlmssp_AvValue(&r->Value, r->AvId, 0):r->AvLen);
		ndr_print_set_switch_value(ndr, &r->Value, r->AvId);
		ndr_print_ntlmssp_AvValue(ndr, "Value", &r->Value);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static void ndr_print_flags_AV_PAIR_LIST(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct AV_PAIR_LIST *r)
{
	ndr_print_AV_PAIR_LIST(ndr, name, r);
}

_PUBLIC_ void ndr_print_AV_PAIR_LIST(struct ndr_print *ndr, const char *name, const struct AV_PAIR_LIST *r)
{
	uint32_t cntr_pair_0;
	ndr_print_struct(ndr, name, "AV_PAIR_LIST");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_NOALIGN);
		ndr->depth++;
		ndr_print_uint32(ndr, "count", r->count);
		ndr->print(ndr, "%s: ARRAY(%"PRIu32")", "pair", (uint32_t)(r->count));
		ndr->depth++;
		for (cntr_pair_0 = 0; cntr_pair_0 < (r->count); cntr_pair_0++) {
			ndr_print_AV_PAIR(ndr, "pair", &r->pair[cntr_pair_0]);
		}
		ndr->depth--;
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ size_t ndr_size_AV_PAIR_LIST(const struct AV_PAIR_LIST *r, libndr_flags flags)
{
	flags |= LIBNDR_FLAG_NOALIGN;
	return ndr_size_struct(r, flags, (ndr_push_flags_fn_t)ndr_push_AV_PAIR_LIST);
}

_PUBLIC_ enum ndr_err_code ndr_push_CHALLENGE_MESSAGE(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct CHALLENGE_MESSAGE *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 5));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, "NTLMSSP", 8, sizeof(uint8_t), CH_DOS));
			NDR_CHECK(ndr_push_ntlmssp_MessageType(ndr, NDR_SCALARS, NtLmChallenge));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, ndr_ntlmssp_string_length(r->NegotiateFlags, r->TargetName)));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, ndr_ntlmssp_string_length(r->NegotiateFlags, r->TargetName)));
			{
				libndr_flags _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(r->NegotiateFlags));
				NDR_CHECK(ndr_push_relative_ptr1(ndr, r->TargetName));
				ndr->flags = _flags_save_string;
			}
			NDR_CHECK(ndr_push_NEGOTIATE(ndr, NDR_SCALARS, r->NegotiateFlags));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->ServerChallenge, 8));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->Reserved, 8));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, ndr_size_AV_PAIR_LIST(r->TargetInfo, ndr->flags)));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, ndr_size_AV_PAIR_LIST(r->TargetInfo, ndr->flags)));
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->TargetInfo));
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->Version, r->NegotiateFlags & NTLMSSP_NEGOTIATE_VERSION));
			NDR_CHECK(ndr_push_ntlmssp_Version(ndr, NDR_SCALARS, &r->Version));
			NDR_CHECK(ndr_push_trailer_align(ndr, 5));
		}
		if (ndr_flags & NDR_BUFFERS) {
			{
				libndr_flags _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(r->NegotiateFlags));
				if (r->TargetName) {
					NDR_CHECK(ndr_push_relative_ptr2_start(ndr, r->TargetName));
					{
						struct ndr_push *_ndr_TargetName;
						NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_TargetName, 0, ndr_ntlmssp_string_length(r->NegotiateFlags, r->TargetName)));
						NDR_CHECK(ndr_push_string(_ndr_TargetName, NDR_SCALARS, r->TargetName));
						NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_TargetName, 0, ndr_ntlmssp_string_length(r->NegotiateFlags, r->TargetName)));
					}
					NDR_CHECK(ndr_push_relative_ptr2_end(ndr, r->TargetName));
				}
				ndr->flags = _flags_save_string;
			}
			if (r->TargetInfo) {
				NDR_CHECK(ndr_push_relative_ptr2_start(ndr, r->TargetInfo));
				{
					struct ndr_push *_ndr_TargetInfo;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_TargetInfo, 0, ndr_size_AV_PAIR_LIST(r->TargetInfo, ndr->flags)));
					NDR_CHECK(ndr_push_AV_PAIR_LIST(_ndr_TargetInfo, NDR_SCALARS|NDR_BUFFERS, r->TargetInfo));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_TargetInfo, 0, ndr_size_AV_PAIR_LIST(r->TargetInfo, ndr->flags)));
				}
				NDR_CHECK(ndr_push_relative_ptr2_end(ndr, r->TargetInfo));
			}
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->Version, r->NegotiateFlags & NTLMSSP_NEGOTIATE_VERSION));
			NDR_CHECK(ndr_push_ntlmssp_Version(ndr, NDR_BUFFERS, &r->Version));
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_CHALLENGE_MESSAGE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct CHALLENGE_MESSAGE *r)
{
	uint32_t size_Signature_0 = 0;
	uint32_t _ptr_TargetName;
	TALLOC_CTX *_mem_save_TargetName_0 = NULL;
	uint32_t size_ServerChallenge_0 = 0;
	uint32_t size_Reserved_0 = 0;
	uint32_t _ptr_TargetInfo;
	TALLOC_CTX *_mem_save_TargetInfo_0 = NULL;
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 5));
			size_Signature_0 = 8;
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->Signature, size_Signature_0, sizeof(uint8_t), CH_DOS));
			NDR_CHECK(ndr_pull_ntlmssp_MessageType(ndr, NDR_SCALARS, &r->MessageType));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->TargetNameLen));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->TargetNameMaxLen));
			{
				libndr_flags _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(r->NegotiateFlags));
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_TargetName));
				if (_ptr_TargetName) {
					NDR_PULL_ALLOC(ndr, r->TargetName);
					NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->TargetName, _ptr_TargetName));
				} else {
					r->TargetName = NULL;
				}
				ndr->flags = _flags_save_string;
			}
			NDR_CHECK(ndr_pull_NEGOTIATE(ndr, NDR_SCALARS, &r->NegotiateFlags));
			size_ServerChallenge_0 = 8;
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->ServerChallenge, size_ServerChallenge_0));
			size_Reserved_0 = 8;
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->Reserved, size_Reserved_0));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->TargetInfoLen));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->TargetInfoMaxLen));
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_TargetInfo));
			if (_ptr_TargetInfo) {
				NDR_PULL_ALLOC(ndr, r->TargetInfo);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->TargetInfo, _ptr_TargetInfo));
			} else {
				r->TargetInfo = NULL;
			}
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->Version, r->NegotiateFlags & NTLMSSP_NEGOTIATE_VERSION));
			NDR_CHECK(ndr_pull_ntlmssp_Version(ndr, NDR_SCALARS, &r->Version));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
		}
		if (ndr_flags & NDR_BUFFERS) {
			{
				libndr_flags _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(r->NegotiateFlags));
				if (r->TargetName) {
					uint32_t _relative_save_offset;
					_relative_save_offset = ndr->offset;
					NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->TargetName));
					_mem_save_TargetName_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->TargetName, 0);
					{
						struct ndr_pull *_ndr_TargetName;
						ssize_t sub_size = r->TargetNameLen;
						NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_TargetName, 0, sub_size));
						NDR_CHECK(ndr_pull_string(_ndr_TargetName, NDR_SCALARS, &r->TargetName));
						NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_TargetName, 0, sub_size));
					}
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_TargetName_0, 0);
					if (ndr->offset > ndr->relative_highest_offset) {
						ndr->relative_highest_offset = ndr->offset;
					}
					ndr->offset = _relative_save_offset;
				}
				ndr->flags = _flags_save_string;
			}
			if (r->TargetInfo) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->TargetInfo));
				_mem_save_TargetInfo_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->TargetInfo, 0);
				{
					struct ndr_pull *_ndr_TargetInfo;
					ssize_t sub_size = r->TargetInfoLen;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_TargetInfo, 0, sub_size));
					NDR_CHECK(ndr_pull_AV_PAIR_LIST(_ndr_TargetInfo, NDR_SCALARS|NDR_BUFFERS, r->TargetInfo));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_TargetInfo, 0, sub_size));
				}
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_TargetInfo_0, 0);
				if (ndr->offset > ndr->relative_highest_offset) {
					ndr->relative_highest_offset = ndr->offset;
				}
				ndr->offset = _relative_save_offset;
			}
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->Version, r->NegotiateFlags & NTLMSSP_NEGOTIATE_VERSION));
			NDR_CHECK(ndr_pull_ntlmssp_Version(ndr, NDR_BUFFERS, &r->Version));
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_CHALLENGE_MESSAGE(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct CHALLENGE_MESSAGE *r)
{
	ndr_print_CHALLENGE_MESSAGE(ndr, name, r);
}

_PUBLIC_ void ndr_print_CHALLENGE_MESSAGE(struct ndr_print *ndr, const char *name, const struct CHALLENGE_MESSAGE *r)
{
	ndr_print_struct(ndr, name, "CHALLENGE_MESSAGE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_string(ndr, "Signature", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?"NTLMSSP":r->Signature);
		ndr_print_ntlmssp_MessageType(ndr, "MessageType", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?NtLmChallenge:r->MessageType);
		ndr_print_uint16(ndr, "TargetNameLen", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_ntlmssp_string_length(r->NegotiateFlags, r->TargetName):r->TargetNameLen);
		ndr_print_uint16(ndr, "TargetNameMaxLen", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->TargetNameLen:r->TargetNameMaxLen);
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(r->NegotiateFlags));
			ndr_print_ptr(ndr, "TargetName", r->TargetName);
			ndr->depth++;
			if (r->TargetName) {
				ndr_print_string(ndr, "TargetName", r->TargetName);
			}
			ndr->depth--;
			ndr->flags = _flags_save_string;
		}
		ndr_print_NEGOTIATE(ndr, "NegotiateFlags", r->NegotiateFlags);
		ndr_print_array_uint8(ndr, "ServerChallenge", r->ServerChallenge, 8);
		ndr_print_array_uint8(ndr, "Reserved", r->Reserved, 8);
		ndr_print_uint16(ndr, "TargetInfoLen", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_size_AV_PAIR_LIST(r->TargetInfo, ndr->flags):r->TargetInfoLen);
		ndr_print_uint16(ndr, "TargetInfoMaxLen", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->TargetInfoLen:r->TargetInfoMaxLen);
		ndr_print_ptr(ndr, "TargetInfo", r->TargetInfo);
		ndr->depth++;
		if (r->TargetInfo) {
			ndr_print_AV_PAIR_LIST(ndr, "TargetInfo", r->TargetInfo);
		}
		ndr->depth--;
		ndr_print_set_switch_value(ndr, &r->Version, r->NegotiateFlags & NTLMSSP_NEGOTIATE_VERSION);
		ndr_print_ntlmssp_Version(ndr, "Version", &r->Version);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_LM_RESPONSE(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct LM_RESPONSE *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 1));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->Response, 24));
			NDR_CHECK(ndr_push_trailer_align(ndr, 1));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_LM_RESPONSE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct LM_RESPONSE *r)
{
	uint32_t size_Response_0 = 0;
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 1));
			size_Response_0 = 24;
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->Response, size_Response_0));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_LM_RESPONSE(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct LM_RESPONSE *r)
{
	ndr_print_LM_RESPONSE(ndr, name, r);
}

_PUBLIC_ void ndr_print_LM_RESPONSE(struct ndr_print *ndr, const char *name, const struct LM_RESPONSE *r)
{
	ndr_print_struct(ndr, name, "LM_RESPONSE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "Response", r->Response, 24);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_LMv2_RESPONSE(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct LMv2_RESPONSE *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 1));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->Response, 16));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->ChallengeFromClient, 8));
			NDR_CHECK(ndr_push_trailer_align(ndr, 1));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_LMv2_RESPONSE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct LMv2_RESPONSE *r)
{
	uint32_t size_Response_0 = 0;
	uint32_t size_ChallengeFromClient_0 = 0;
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 1));
			size_Response_0 = 16;
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->Response, size_Response_0));
			size_ChallengeFromClient_0 = 8;
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->ChallengeFromClient, size_ChallengeFromClient_0));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_LMv2_RESPONSE(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct LMv2_RESPONSE *r)
{
	ndr_print_LMv2_RESPONSE(ndr, name, r);
}

_PUBLIC_ void ndr_print_LMv2_RESPONSE(struct ndr_print *ndr, const char *name, const struct LMv2_RESPONSE *r)
{
	ndr_print_struct(ndr, name, "LMv2_RESPONSE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "Response", r->Response, 16);
		ndr_print_array_uint8(ndr, "ChallengeFromClient", r->ChallengeFromClient, 8);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_ntlmssp_LM_RESPONSE_with_len(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union ntlmssp_LM_RESPONSE_with_len *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 1));
		switch (level) {
			case 24: {
				NDR_CHECK(ndr_push_LM_RESPONSE(ndr, NDR_SCALARS, &r->v1));
			break; }

			default: {
			break; }

		}
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_ntlmssp_LM_RESPONSE_with_len(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union ntlmssp_LM_RESPONSE_with_len *r)
{
	uint32_t level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 1));
		switch (level) {
			case 24: {
				NDR_CHECK(ndr_pull_LM_RESPONSE(ndr, NDR_SCALARS, &r->v1));
			break; }

			default: {
			break; }

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ntlmssp_LM_RESPONSE_with_len(struct ndr_print *ndr, const char *name, const union ntlmssp_LM_RESPONSE_with_len *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "ntlmssp_LM_RESPONSE_with_len");
	switch (level) {
		case 24:
			ndr_print_LM_RESPONSE(ndr, "v1", &r->v1);
		break;

		default:
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_NTLM_RESPONSE(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct NTLM_RESPONSE *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 1));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->Response, 24));
			NDR_CHECK(ndr_push_trailer_align(ndr, 1));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_NTLM_RESPONSE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct NTLM_RESPONSE *r)
{
	uint32_t size_Response_0 = 0;
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 1));
			size_Response_0 = 24;
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->Response, size_Response_0));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 1));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_NTLM_RESPONSE(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct NTLM_RESPONSE *r)
{
	ndr_print_NTLM_RESPONSE(ndr, name, r);
}

_PUBLIC_ void ndr_print_NTLM_RESPONSE(struct ndr_print *ndr, const char *name, const struct NTLM_RESPONSE *r)
{
	ndr_print_struct(ndr, name, "NTLM_RESPONSE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "Response", r->Response, 24);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

static enum ndr_err_code ndr_push_NTLMv2_CLIENT_CHALLENGE(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct NTLMv2_CLIENT_CHALLENGE *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, 1));
			NDR_CHECK(ndr_push_uint8(ndr, NDR_SCALARS, 1));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->Reserved1));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->Reserved2));
			NDR_CHECK(ndr_push_NTTIME(ndr, NDR_SCALARS, r->TimeStamp));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->ChallengeFromClient, 8));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->Reserved3));
			{
				libndr_flags _flags_save_AV_PAIR_LIST = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
				{
					struct ndr_push *_ndr_AvPairs;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_AvPairs, 0, -1));
					NDR_CHECK(ndr_push_AV_PAIR_LIST(_ndr_AvPairs, NDR_SCALARS|NDR_BUFFERS, &r->AvPairs));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_AvPairs, 0, -1));
				}
				ndr->flags = _flags_save_AV_PAIR_LIST;
			}
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
			{
				libndr_flags _flags_save_AV_PAIR_LIST = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
				ndr->flags = _flags_save_AV_PAIR_LIST;
			}
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static enum ndr_err_code ndr_pull_NTLMv2_CLIENT_CHALLENGE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct NTLMv2_CLIENT_CHALLENGE *r)
{
	uint32_t size_ChallengeFromClient_0 = 0;
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->RespType));
			NDR_CHECK(ndr_pull_uint8(ndr, NDR_SCALARS, &r->HiRespType));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->Reserved1));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Reserved2));
			NDR_CHECK(ndr_pull_NTTIME(ndr, NDR_SCALARS, &r->TimeStamp));
			size_ChallengeFromClient_0 = 8;
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->ChallengeFromClient, size_ChallengeFromClient_0));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Reserved3));
			{
				libndr_flags _flags_save_AV_PAIR_LIST = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
				{
					struct ndr_pull *_ndr_AvPairs;
					ssize_t sub_size = -1;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_AvPairs, 0, sub_size));
					NDR_CHECK(ndr_pull_AV_PAIR_LIST(_ndr_AvPairs, NDR_SCALARS|NDR_BUFFERS, &r->AvPairs));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_AvPairs, 0, sub_size));
				}
				ndr->flags = _flags_save_AV_PAIR_LIST;
			}
			NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
			{
				libndr_flags _flags_save_AV_PAIR_LIST = ndr->flags;
				ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
				ndr->flags = _flags_save_AV_PAIR_LIST;
			}
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_NTLMv2_CLIENT_CHALLENGE(struct ndr_print *ndr, const char *name, const struct NTLMv2_CLIENT_CHALLENGE *r)
{
	ndr_print_struct(ndr, name, "NTLMv2_CLIENT_CHALLENGE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_uint8(ndr, "RespType", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?1:r->RespType);
		ndr_print_uint8(ndr, "HiRespType", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?1:r->HiRespType);
		ndr_print_uint16(ndr, "Reserved1", r->Reserved1);
		ndr_print_uint32(ndr, "Reserved2", r->Reserved2);
		ndr_print_NTTIME(ndr, "TimeStamp", r->TimeStamp);
		ndr_print_array_uint8(ndr, "ChallengeFromClient", r->ChallengeFromClient, 8);
		ndr_print_uint32(ndr, "Reserved3", r->Reserved3);
		{
			libndr_flags _flags_save_AV_PAIR_LIST = ndr->flags;
			ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
			ndr_print_AV_PAIR_LIST(ndr, "AvPairs", &r->AvPairs);
			ndr->flags = _flags_save_AV_PAIR_LIST;
		}
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_NTLMv2_RESPONSE(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct NTLMv2_RESPONSE *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->Response, 16));
			NDR_CHECK(ndr_push_NTLMv2_CLIENT_CHALLENGE(ndr, NDR_SCALARS, &r->Challenge));
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
			NDR_CHECK(ndr_push_NTLMv2_CLIENT_CHALLENGE(ndr, NDR_BUFFERS, &r->Challenge));
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_NTLMv2_RESPONSE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct NTLMv2_RESPONSE *r)
{
	uint32_t size_Response_0 = 0;
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			size_Response_0 = 16;
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->Response, size_Response_0));
			NDR_CHECK(ndr_pull_NTLMv2_CLIENT_CHALLENGE(ndr, NDR_SCALARS, &r->Challenge));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
			NDR_CHECK(ndr_pull_NTLMv2_CLIENT_CHALLENGE(ndr, NDR_BUFFERS, &r->Challenge));
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_NTLMv2_RESPONSE(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct NTLMv2_RESPONSE *r)
{
	ndr_print_NTLMv2_RESPONSE(ndr, name, r);
}

_PUBLIC_ void ndr_print_NTLMv2_RESPONSE(struct ndr_print *ndr, const char *name, const struct NTLMv2_RESPONSE *r)
{
	ndr_print_struct(ndr, name, "NTLMv2_RESPONSE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_array_uint8(ndr, "Response", r->Response, 16);
		ndr_print_NTLMv2_CLIENT_CHALLENGE(ndr, "Challenge", &r->Challenge);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_ntlmssp_NTLM_RESPONSE_with_len(struct ndr_push *ndr, ndr_flags_type ndr_flags, const union ntlmssp_NTLM_RESPONSE_with_len *r)
{
	uint32_t level;
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_push_union_align(ndr, 4));
		switch (level) {
			case 0: {
			break; }

			case 0x18: {
				NDR_CHECK(ndr_push_NTLM_RESPONSE(ndr, NDR_SCALARS, &r->v1));
			break; }

			default: {
				NDR_CHECK(ndr_push_NTLMv2_RESPONSE(ndr, NDR_SCALARS, &r->v2));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_push_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 0:
			break;

			case 0x18:
			break;

			default:
				NDR_CHECK(ndr_push_NTLMv2_RESPONSE(ndr, NDR_BUFFERS, &r->v2));
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_ntlmssp_NTLM_RESPONSE_with_len(struct ndr_pull *ndr, ndr_flags_type ndr_flags, union ntlmssp_NTLM_RESPONSE_with_len *r)
{
	uint32_t level;
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		/* This token is not used again (except perhaps below in the NDR_BUFFERS case) */
		NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		NDR_CHECK(ndr_pull_union_align(ndr, 4));
		switch (level) {
			case 0: {
			break; }

			case 0x18: {
				NDR_CHECK(ndr_pull_NTLM_RESPONSE(ndr, NDR_SCALARS, &r->v1));
			break; }

			default: {
				NDR_CHECK(ndr_pull_NTLMv2_RESPONSE(ndr, NDR_SCALARS, &r->v2));
			break; }

		}
	}
	if (ndr_flags & NDR_BUFFERS) {
		if (!(ndr_flags & NDR_SCALARS)) {
			/* We didn't get it above, and the token is not needed after this. */
			NDR_CHECK(ndr_pull_steal_switch_value(ndr, r, &level));
		}
		switch (level) {
			case 0:
			break;

			case 0x18:
			break;

			default:
				NDR_CHECK(ndr_pull_NTLMv2_RESPONSE(ndr, NDR_BUFFERS, &r->v2));
			break;

		}
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ void ndr_print_ntlmssp_NTLM_RESPONSE_with_len(struct ndr_print *ndr, const char *name, const union ntlmssp_NTLM_RESPONSE_with_len *r)
{
	uint32_t level;
	level = ndr_print_steal_switch_value(ndr, r);
	ndr_print_union(ndr, name, level, "ntlmssp_NTLM_RESPONSE_with_len");
	switch (level) {
		case 0:
		break;

		case 0x18:
			ndr_print_NTLM_RESPONSE(ndr, "v1", &r->v1);
		break;

		default:
			ndr_print_NTLMv2_RESPONSE(ndr, "v2", &r->v2);
		break;

	}
}

_PUBLIC_ enum ndr_err_code ndr_push_AUTHENTICATE_MESSAGE(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct AUTHENTICATE_MESSAGE *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 5));
			NDR_CHECK(ndr_push_charset(ndr, NDR_SCALARS, "NTLMSSP", 8, sizeof(uint8_t), CH_DOS));
			NDR_CHECK(ndr_push_ntlmssp_MessageType(ndr, NDR_SCALARS, NtLmAuthenticate));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->LmChallengeResponseLen));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->LmChallengeResponseLen));
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->LmChallengeResponse));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->NtChallengeResponseLen));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->NtChallengeResponseLen));
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->NtChallengeResponse));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, ndr_ntlmssp_string_length(r->NegotiateFlags, r->DomainName)));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, ndr_ntlmssp_string_length(r->NegotiateFlags, r->DomainName)));
			{
				libndr_flags _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(r->NegotiateFlags));
				NDR_CHECK(ndr_push_relative_ptr1(ndr, r->DomainName));
				ndr->flags = _flags_save_string;
			}
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, ndr_ntlmssp_string_length(r->NegotiateFlags, r->UserName)));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, ndr_ntlmssp_string_length(r->NegotiateFlags, r->UserName)));
			{
				libndr_flags _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(r->NegotiateFlags));
				NDR_CHECK(ndr_push_relative_ptr1(ndr, r->UserName));
				ndr->flags = _flags_save_string;
			}
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, ndr_ntlmssp_string_length(r->NegotiateFlags, r->Workstation)));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, ndr_ntlmssp_string_length(r->NegotiateFlags, r->Workstation)));
			{
				libndr_flags _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(r->NegotiateFlags));
				NDR_CHECK(ndr_push_relative_ptr1(ndr, r->Workstation));
				ndr->flags = _flags_save_string;
			}
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->EncryptedRandomSessionKey == NULL?0:r->EncryptedRandomSessionKey->length));
			NDR_CHECK(ndr_push_uint16(ndr, NDR_SCALARS, r->EncryptedRandomSessionKey == NULL?0:r->EncryptedRandomSessionKey->length));
			NDR_CHECK(ndr_push_relative_ptr1(ndr, r->EncryptedRandomSessionKey));
			NDR_CHECK(ndr_push_NEGOTIATE(ndr, NDR_SCALARS, r->NegotiateFlags));
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->Version, r->NegotiateFlags & NTLMSSP_NEGOTIATE_VERSION));
			NDR_CHECK(ndr_push_ntlmssp_Version(ndr, NDR_SCALARS, &r->Version));
			NDR_CHECK(ndr_push_trailer_align(ndr, 5));
		}
		if (ndr_flags & NDR_BUFFERS) {
			if (r->LmChallengeResponse) {
				NDR_CHECK(ndr_push_relative_ptr2_start(ndr, r->LmChallengeResponse));
				{
					struct ndr_push *_ndr_LmChallengeResponse;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_LmChallengeResponse, 0, r->LmChallengeResponseLen));
					NDR_CHECK(ndr_push_set_switch_value(_ndr_LmChallengeResponse, r->LmChallengeResponse, r->LmChallengeResponseLen));
					NDR_CHECK(ndr_push_ntlmssp_LM_RESPONSE_with_len(_ndr_LmChallengeResponse, NDR_SCALARS|NDR_BUFFERS, r->LmChallengeResponse));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_LmChallengeResponse, 0, r->LmChallengeResponseLen));
				}
				NDR_CHECK(ndr_push_relative_ptr2_end(ndr, r->LmChallengeResponse));
			}
			if (r->NtChallengeResponse) {
				NDR_CHECK(ndr_push_relative_ptr2_start(ndr, r->NtChallengeResponse));
				{
					struct ndr_push *_ndr_NtChallengeResponse;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_NtChallengeResponse, 0, r->NtChallengeResponseLen));
					NDR_CHECK(ndr_push_set_switch_value(_ndr_NtChallengeResponse, r->NtChallengeResponse, r->NtChallengeResponseLen));
					NDR_CHECK(ndr_push_ntlmssp_NTLM_RESPONSE_with_len(_ndr_NtChallengeResponse, NDR_SCALARS|NDR_BUFFERS, r->NtChallengeResponse));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_NtChallengeResponse, 0, r->NtChallengeResponseLen));
				}
				NDR_CHECK(ndr_push_relative_ptr2_end(ndr, r->NtChallengeResponse));
			}
			{
				libndr_flags _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(r->NegotiateFlags));
				if (r->DomainName) {
					NDR_CHECK(ndr_push_relative_ptr2_start(ndr, r->DomainName));
					{
						struct ndr_push *_ndr_DomainName;
						NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_DomainName, 0, ndr_ntlmssp_string_length(r->NegotiateFlags, r->DomainName)));
						NDR_CHECK(ndr_push_string(_ndr_DomainName, NDR_SCALARS, r->DomainName));
						NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_DomainName, 0, ndr_ntlmssp_string_length(r->NegotiateFlags, r->DomainName)));
					}
					NDR_CHECK(ndr_push_relative_ptr2_end(ndr, r->DomainName));
				}
				ndr->flags = _flags_save_string;
			}
			{
				libndr_flags _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(r->NegotiateFlags));
				if (r->UserName) {
					NDR_CHECK(ndr_push_relative_ptr2_start(ndr, r->UserName));
					{
						struct ndr_push *_ndr_UserName;
						NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_UserName, 0, ndr_ntlmssp_string_length(r->NegotiateFlags, r->UserName)));
						NDR_CHECK(ndr_push_string(_ndr_UserName, NDR_SCALARS, r->UserName));
						NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_UserName, 0, ndr_ntlmssp_string_length(r->NegotiateFlags, r->UserName)));
					}
					NDR_CHECK(ndr_push_relative_ptr2_end(ndr, r->UserName));
				}
				ndr->flags = _flags_save_string;
			}
			{
				libndr_flags _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(r->NegotiateFlags));
				if (r->Workstation) {
					NDR_CHECK(ndr_push_relative_ptr2_start(ndr, r->Workstation));
					{
						struct ndr_push *_ndr_Workstation;
						NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_Workstation, 0, ndr_ntlmssp_string_length(r->NegotiateFlags, r->Workstation)));
						NDR_CHECK(ndr_push_string(_ndr_Workstation, NDR_SCALARS, r->Workstation));
						NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_Workstation, 0, ndr_ntlmssp_string_length(r->NegotiateFlags, r->Workstation)));
					}
					NDR_CHECK(ndr_push_relative_ptr2_end(ndr, r->Workstation));
				}
				ndr->flags = _flags_save_string;
			}
			if (r->EncryptedRandomSessionKey) {
				NDR_CHECK(ndr_push_relative_ptr2_start(ndr, r->EncryptedRandomSessionKey));
				{
					struct ndr_push *_ndr_EncryptedRandomSessionKey;
					NDR_CHECK(ndr_push_subcontext_start(ndr, &_ndr_EncryptedRandomSessionKey, 0, r->EncryptedRandomSessionKey == NULL?0:r->EncryptedRandomSessionKey->length));
					NDR_CHECK(ndr_push_DATA_BLOB(_ndr_EncryptedRandomSessionKey, NDR_SCALARS, *r->EncryptedRandomSessionKey));
					NDR_CHECK(ndr_push_subcontext_end(ndr, _ndr_EncryptedRandomSessionKey, 0, r->EncryptedRandomSessionKey == NULL?0:r->EncryptedRandomSessionKey->length));
				}
				NDR_CHECK(ndr_push_relative_ptr2_end(ndr, r->EncryptedRandomSessionKey));
			}
			NDR_CHECK(ndr_push_set_switch_value(ndr, &r->Version, r->NegotiateFlags & NTLMSSP_NEGOTIATE_VERSION));
			NDR_CHECK(ndr_push_ntlmssp_Version(ndr, NDR_BUFFERS, &r->Version));
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_AUTHENTICATE_MESSAGE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct AUTHENTICATE_MESSAGE *r)
{
	uint32_t size_Signature_0 = 0;
	uint32_t _ptr_LmChallengeResponse;
	TALLOC_CTX *_mem_save_LmChallengeResponse_0 = NULL;
	uint32_t _ptr_NtChallengeResponse;
	TALLOC_CTX *_mem_save_NtChallengeResponse_0 = NULL;
	uint32_t _ptr_DomainName;
	TALLOC_CTX *_mem_save_DomainName_0 = NULL;
	uint32_t _ptr_UserName;
	TALLOC_CTX *_mem_save_UserName_0 = NULL;
	uint32_t _ptr_Workstation;
	TALLOC_CTX *_mem_save_Workstation_0 = NULL;
	uint32_t _ptr_EncryptedRandomSessionKey;
	TALLOC_CTX *_mem_save_EncryptedRandomSessionKey_0 = NULL;
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 5));
			size_Signature_0 = 8;
			NDR_CHECK(ndr_pull_charset(ndr, NDR_SCALARS, &r->Signature, size_Signature_0, sizeof(uint8_t), CH_DOS));
			NDR_CHECK(ndr_pull_ntlmssp_MessageType(ndr, NDR_SCALARS, &r->MessageType));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->LmChallengeResponseLen));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->LmChallengeResponseMaxLen));
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_LmChallengeResponse));
			if (_ptr_LmChallengeResponse) {
				NDR_PULL_ALLOC(ndr, r->LmChallengeResponse);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->LmChallengeResponse, _ptr_LmChallengeResponse));
			} else {
				r->LmChallengeResponse = NULL;
			}
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->NtChallengeResponseLen));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->NtChallengeResponseMaxLen));
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_NtChallengeResponse));
			if (_ptr_NtChallengeResponse) {
				NDR_PULL_ALLOC(ndr, r->NtChallengeResponse);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->NtChallengeResponse, _ptr_NtChallengeResponse));
			} else {
				r->NtChallengeResponse = NULL;
			}
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->DomainNameLen));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->DomainNameMaxLen));
			{
				libndr_flags _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(r->NegotiateFlags));
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_DomainName));
				if (_ptr_DomainName) {
					NDR_PULL_ALLOC(ndr, r->DomainName);
					NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->DomainName, _ptr_DomainName));
				} else {
					r->DomainName = NULL;
				}
				ndr->flags = _flags_save_string;
			}
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->UserNameLen));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->UserNameMaxLen));
			{
				libndr_flags _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(r->NegotiateFlags));
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_UserName));
				if (_ptr_UserName) {
					NDR_PULL_ALLOC(ndr, r->UserName);
					NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->UserName, _ptr_UserName));
				} else {
					r->UserName = NULL;
				}
				ndr->flags = _flags_save_string;
			}
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->WorkstationLen));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->WorkstationMaxLen));
			{
				libndr_flags _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(r->NegotiateFlags));
				NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_Workstation));
				if (_ptr_Workstation) {
					NDR_PULL_ALLOC(ndr, r->Workstation);
					NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->Workstation, _ptr_Workstation));
				} else {
					r->Workstation = NULL;
				}
				ndr->flags = _flags_save_string;
			}
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->EncryptedRandomSessionKeyLen));
			NDR_CHECK(ndr_pull_uint16(ndr, NDR_SCALARS, &r->EncryptedRandomSessionKeyMaxLen));
			NDR_CHECK(ndr_pull_generic_ptr(ndr, &_ptr_EncryptedRandomSessionKey));
			if (_ptr_EncryptedRandomSessionKey) {
				NDR_PULL_ALLOC(ndr, r->EncryptedRandomSessionKey);
				NDR_CHECK(ndr_pull_relative_ptr1(ndr, r->EncryptedRandomSessionKey, _ptr_EncryptedRandomSessionKey));
			} else {
				r->EncryptedRandomSessionKey = NULL;
			}
			NDR_CHECK(ndr_pull_NEGOTIATE(ndr, NDR_SCALARS, &r->NegotiateFlags));
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->Version, r->NegotiateFlags & NTLMSSP_NEGOTIATE_VERSION));
			NDR_CHECK(ndr_pull_ntlmssp_Version(ndr, NDR_SCALARS, &r->Version));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 5));
		}
		if (ndr_flags & NDR_BUFFERS) {
			if (r->LmChallengeResponse) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->LmChallengeResponse));
				_mem_save_LmChallengeResponse_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->LmChallengeResponse, 0);
				{
					struct ndr_pull *_ndr_LmChallengeResponse;
					ssize_t sub_size = r->LmChallengeResponseLen;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_LmChallengeResponse, 0, sub_size));
					NDR_CHECK(ndr_pull_set_switch_value(_ndr_LmChallengeResponse, r->LmChallengeResponse, r->LmChallengeResponseLen));
					NDR_CHECK(ndr_pull_ntlmssp_LM_RESPONSE_with_len(_ndr_LmChallengeResponse, NDR_SCALARS|NDR_BUFFERS, r->LmChallengeResponse));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_LmChallengeResponse, 0, sub_size));
				}
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_LmChallengeResponse_0, 0);
				if (ndr->offset > ndr->relative_highest_offset) {
					ndr->relative_highest_offset = ndr->offset;
				}
				ndr->offset = _relative_save_offset;
			}
			if (r->NtChallengeResponse) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->NtChallengeResponse));
				_mem_save_NtChallengeResponse_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->NtChallengeResponse, 0);
				{
					struct ndr_pull *_ndr_NtChallengeResponse;
					ssize_t sub_size = r->NtChallengeResponseMaxLen;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_NtChallengeResponse, 0, sub_size));
					NDR_CHECK(ndr_pull_set_switch_value(_ndr_NtChallengeResponse, r->NtChallengeResponse, r->NtChallengeResponseLen));
					NDR_CHECK(ndr_pull_ntlmssp_NTLM_RESPONSE_with_len(_ndr_NtChallengeResponse, NDR_SCALARS|NDR_BUFFERS, r->NtChallengeResponse));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_NtChallengeResponse, 0, sub_size));
				}
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_NtChallengeResponse_0, 0);
				if (ndr->offset > ndr->relative_highest_offset) {
					ndr->relative_highest_offset = ndr->offset;
				}
				ndr->offset = _relative_save_offset;
			}
			{
				libndr_flags _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(r->NegotiateFlags));
				if (r->DomainName) {
					uint32_t _relative_save_offset;
					_relative_save_offset = ndr->offset;
					NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->DomainName));
					_mem_save_DomainName_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->DomainName, 0);
					{
						struct ndr_pull *_ndr_DomainName;
						ssize_t sub_size = r->DomainNameLen;
						NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_DomainName, 0, sub_size));
						NDR_CHECK(ndr_pull_string(_ndr_DomainName, NDR_SCALARS, &r->DomainName));
						NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_DomainName, 0, sub_size));
					}
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_DomainName_0, 0);
					if (ndr->offset > ndr->relative_highest_offset) {
						ndr->relative_highest_offset = ndr->offset;
					}
					ndr->offset = _relative_save_offset;
				}
				ndr->flags = _flags_save_string;
			}
			{
				libndr_flags _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(r->NegotiateFlags));
				if (r->UserName) {
					uint32_t _relative_save_offset;
					_relative_save_offset = ndr->offset;
					NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->UserName));
					_mem_save_UserName_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->UserName, 0);
					{
						struct ndr_pull *_ndr_UserName;
						ssize_t sub_size = r->UserNameLen;
						NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_UserName, 0, sub_size));
						NDR_CHECK(ndr_pull_string(_ndr_UserName, NDR_SCALARS, &r->UserName));
						NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_UserName, 0, sub_size));
					}
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_UserName_0, 0);
					if (ndr->offset > ndr->relative_highest_offset) {
						ndr->relative_highest_offset = ndr->offset;
					}
					ndr->offset = _relative_save_offset;
				}
				ndr->flags = _flags_save_string;
			}
			{
				libndr_flags _flags_save_string = ndr->flags;
				ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(r->NegotiateFlags));
				if (r->Workstation) {
					uint32_t _relative_save_offset;
					_relative_save_offset = ndr->offset;
					NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->Workstation));
					_mem_save_Workstation_0 = NDR_PULL_GET_MEM_CTX(ndr);
					NDR_PULL_SET_MEM_CTX(ndr, r->Workstation, 0);
					{
						struct ndr_pull *_ndr_Workstation;
						ssize_t sub_size = r->WorkstationLen;
						NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_Workstation, 0, sub_size));
						NDR_CHECK(ndr_pull_string(_ndr_Workstation, NDR_SCALARS, &r->Workstation));
						NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_Workstation, 0, sub_size));
					}
					NDR_PULL_SET_MEM_CTX(ndr, _mem_save_Workstation_0, 0);
					if (ndr->offset > ndr->relative_highest_offset) {
						ndr->relative_highest_offset = ndr->offset;
					}
					ndr->offset = _relative_save_offset;
				}
				ndr->flags = _flags_save_string;
			}
			if (r->EncryptedRandomSessionKey) {
				uint32_t _relative_save_offset;
				_relative_save_offset = ndr->offset;
				NDR_CHECK(ndr_pull_relative_ptr2(ndr, r->EncryptedRandomSessionKey));
				_mem_save_EncryptedRandomSessionKey_0 = NDR_PULL_GET_MEM_CTX(ndr);
				NDR_PULL_SET_MEM_CTX(ndr, r->EncryptedRandomSessionKey, 0);
				{
					struct ndr_pull *_ndr_EncryptedRandomSessionKey;
					ssize_t sub_size = r->EncryptedRandomSessionKeyLen;
					NDR_CHECK(ndr_pull_subcontext_start(ndr, &_ndr_EncryptedRandomSessionKey, 0, sub_size));
					NDR_CHECK(ndr_pull_DATA_BLOB(_ndr_EncryptedRandomSessionKey, NDR_SCALARS, r->EncryptedRandomSessionKey));
					NDR_CHECK(ndr_pull_subcontext_end(ndr, _ndr_EncryptedRandomSessionKey, 0, sub_size));
				}
				NDR_PULL_SET_MEM_CTX(ndr, _mem_save_EncryptedRandomSessionKey_0, 0);
				if (ndr->offset > ndr->relative_highest_offset) {
					ndr->relative_highest_offset = ndr->offset;
				}
				ndr->offset = _relative_save_offset;
			}
			NDR_CHECK(ndr_pull_set_switch_value(ndr, &r->Version, r->NegotiateFlags & NTLMSSP_NEGOTIATE_VERSION));
			NDR_CHECK(ndr_pull_ntlmssp_Version(ndr, NDR_BUFFERS, &r->Version));
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_AUTHENTICATE_MESSAGE(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct AUTHENTICATE_MESSAGE *r)
{
	ndr_print_AUTHENTICATE_MESSAGE(ndr, name, r);
}

_PUBLIC_ void ndr_print_AUTHENTICATE_MESSAGE(struct ndr_print *ndr, const char *name, const struct AUTHENTICATE_MESSAGE *r)
{
	ndr_print_struct(ndr, name, "AUTHENTICATE_MESSAGE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_FLAG_REMAINING);
		ndr->depth++;
		ndr_print_string(ndr, "Signature", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?"NTLMSSP":r->Signature);
		ndr_print_ntlmssp_MessageType(ndr, "MessageType", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?NtLmAuthenticate:r->MessageType);
		ndr_print_uint16(ndr, "LmChallengeResponseLen", r->LmChallengeResponseLen);
		ndr_print_uint16(ndr, "LmChallengeResponseMaxLen", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->LmChallengeResponseLen:r->LmChallengeResponseMaxLen);
		ndr_print_ptr(ndr, "LmChallengeResponse", r->LmChallengeResponse);
		ndr->depth++;
		if (r->LmChallengeResponse) {
			ndr_print_set_switch_value(ndr, r->LmChallengeResponse, r->LmChallengeResponseLen);
			ndr_print_ntlmssp_LM_RESPONSE_with_len(ndr, "LmChallengeResponse", r->LmChallengeResponse);
		}
		ndr->depth--;
		ndr_print_uint16(ndr, "NtChallengeResponseLen", r->NtChallengeResponseLen);
		ndr_print_uint16(ndr, "NtChallengeResponseMaxLen", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->NtChallengeResponseLen:r->NtChallengeResponseMaxLen);
		ndr_print_ptr(ndr, "NtChallengeResponse", r->NtChallengeResponse);
		ndr->depth++;
		if (r->NtChallengeResponse) {
			ndr_print_set_switch_value(ndr, r->NtChallengeResponse, r->NtChallengeResponseLen);
			ndr_print_ntlmssp_NTLM_RESPONSE_with_len(ndr, "NtChallengeResponse", r->NtChallengeResponse);
		}
		ndr->depth--;
		ndr_print_uint16(ndr, "DomainNameLen", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_ntlmssp_string_length(r->NegotiateFlags, r->DomainName):r->DomainNameLen);
		ndr_print_uint16(ndr, "DomainNameMaxLen", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->DomainNameLen:r->DomainNameMaxLen);
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(r->NegotiateFlags));
			ndr_print_ptr(ndr, "DomainName", r->DomainName);
			ndr->depth++;
			if (r->DomainName) {
				ndr_print_string(ndr, "DomainName", r->DomainName);
			}
			ndr->depth--;
			ndr->flags = _flags_save_string;
		}
		ndr_print_uint16(ndr, "UserNameLen", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_ntlmssp_string_length(r->NegotiateFlags, r->UserName):r->UserNameLen);
		ndr_print_uint16(ndr, "UserNameMaxLen", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->UserNameLen:r->UserNameMaxLen);
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(r->NegotiateFlags));
			ndr_print_ptr(ndr, "UserName", r->UserName);
			ndr->depth++;
			if (r->UserName) {
				ndr_print_string(ndr, "UserName", r->UserName);
			}
			ndr->depth--;
			ndr->flags = _flags_save_string;
		}
		ndr_print_uint16(ndr, "WorkstationLen", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?ndr_ntlmssp_string_length(r->NegotiateFlags, r->Workstation):r->WorkstationLen);
		ndr_print_uint16(ndr, "WorkstationMaxLen", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->WorkstationLen:r->WorkstationMaxLen);
		{
			libndr_flags _flags_save_string = ndr->flags;
			ndr_set_flags(&ndr->flags, ndr_ntlmssp_negotiated_string_flags(r->NegotiateFlags));
			ndr_print_ptr(ndr, "Workstation", r->Workstation);
			ndr->depth++;
			if (r->Workstation) {
				ndr_print_string(ndr, "Workstation", r->Workstation);
			}
			ndr->depth--;
			ndr->flags = _flags_save_string;
		}
		ndr_print_uint16(ndr, "EncryptedRandomSessionKeyLen", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->EncryptedRandomSessionKey == NULL?0:r->EncryptedRandomSessionKey->length:r->EncryptedRandomSessionKeyLen);
		ndr_print_uint16(ndr, "EncryptedRandomSessionKeyMaxLen", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?r->EncryptedRandomSessionKeyLen:r->EncryptedRandomSessionKeyMaxLen);
		ndr_print_ptr(ndr, "EncryptedRandomSessionKey", r->EncryptedRandomSessionKey);
		ndr->depth++;
		if (r->EncryptedRandomSessionKey) {
			ndr_print_DATA_BLOB(ndr, "EncryptedRandomSessionKey", *r->EncryptedRandomSessionKey);
		}
		ndr->depth--;
		ndr_print_NEGOTIATE(ndr, "NegotiateFlags", r->NegotiateFlags);
		ndr_print_set_switch_value(ndr, &r->Version, r->NegotiateFlags & NTLMSSP_NEGOTIATE_VERSION);
		ndr_print_ntlmssp_Version(ndr, "Version", &r->Version);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

_PUBLIC_ enum ndr_err_code ndr_push_NTLMSSP_MESSAGE_SIGNATURE(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct NTLMSSP_MESSAGE_SIGNATURE *r)
{
	NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_push_align(ndr, 4));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, NTLMSSP_SIGN_VERSION));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->RandomPad));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->Checksum));
		NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->SeqNum));
		NDR_CHECK(ndr_push_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_NTLMSSP_MESSAGE_SIGNATURE(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct NTLMSSP_MESSAGE_SIGNATURE *r)
{
	NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
	if (ndr_flags & NDR_SCALARS) {
		NDR_CHECK(ndr_pull_align(ndr, 4));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Version));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->RandomPad));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Checksum));
		NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->SeqNum));
		NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
	}
	if (ndr_flags & NDR_BUFFERS) {
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_NTLMSSP_MESSAGE_SIGNATURE(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct NTLMSSP_MESSAGE_SIGNATURE *r)
{
	ndr_print_NTLMSSP_MESSAGE_SIGNATURE(ndr, name, r);
}

_PUBLIC_ void ndr_print_NTLMSSP_MESSAGE_SIGNATURE(struct ndr_print *ndr, const char *name, const struct NTLMSSP_MESSAGE_SIGNATURE *r)
{
	ndr_print_struct(ndr, name, "NTLMSSP_MESSAGE_SIGNATURE");
	if (r == NULL) { ndr_print_null(ndr); return; }
	ndr->depth++;
	ndr_print_uint32(ndr, "Version", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?NTLMSSP_SIGN_VERSION:r->Version);
	ndr_print_uint32(ndr, "RandomPad", r->RandomPad);
	ndr_print_uint32(ndr, "Checksum", r->Checksum);
	ndr_print_uint32(ndr, "SeqNum", r->SeqNum);
	ndr->depth--;
}

_PUBLIC_ enum ndr_err_code ndr_push_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2(struct ndr_push *ndr, ndr_flags_type ndr_flags, const struct NTLMSSP_MESSAGE_SIGNATURE_NTLMv2 *r)
{
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PUSH_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_push_align(ndr, 4));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, NTLMSSP_SIGN_VERSION));
			NDR_CHECK(ndr_push_array_uint8(ndr, NDR_SCALARS, r->Checksum, 8));
			NDR_CHECK(ndr_push_uint32(ndr, NDR_SCALARS, r->SeqNum));
			NDR_CHECK(ndr_push_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

_PUBLIC_ enum ndr_err_code ndr_pull_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2(struct ndr_pull *ndr, ndr_flags_type ndr_flags, struct NTLMSSP_MESSAGE_SIGNATURE_NTLMv2 *r)
{
	uint32_t size_Checksum_0 = 0;
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		NDR_PULL_CHECK_FLAGS(ndr, ndr_flags);
		if (ndr_flags & NDR_SCALARS) {
			NDR_CHECK(ndr_pull_align(ndr, 4));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->Version));
			size_Checksum_0 = 8;
			NDR_CHECK(ndr_pull_array_uint8(ndr, NDR_SCALARS, r->Checksum, size_Checksum_0));
			NDR_CHECK(ndr_pull_uint32(ndr, NDR_SCALARS, &r->SeqNum));
			NDR_CHECK(ndr_pull_trailer_align(ndr, 4));
		}
		if (ndr_flags & NDR_BUFFERS) {
		}
		ndr->flags = _flags_save_STRUCT;
	}
	return NDR_ERR_SUCCESS;
}

static void ndr_print_flags_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2(struct ndr_print *ndr, const char *name, ndr_flags_type unused, const struct NTLMSSP_MESSAGE_SIGNATURE_NTLMv2 *r)
{
	ndr_print_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2(ndr, name, r);
}

_PUBLIC_ void ndr_print_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2(struct ndr_print *ndr, const char *name, const struct NTLMSSP_MESSAGE_SIGNATURE_NTLMv2 *r)
{
	ndr_print_struct(ndr, name, "NTLMSSP_MESSAGE_SIGNATURE_NTLMv2");
	if (r == NULL) { ndr_print_null(ndr); return; }
	{
		libndr_flags _flags_save_STRUCT = ndr->flags;
		ndr_set_flags(&ndr->flags, LIBNDR_PRINT_ARRAY_HEX);
		ndr->depth++;
		ndr_print_uint32(ndr, "Version", (ndr->flags & LIBNDR_PRINT_SET_VALUES)?NTLMSSP_SIGN_VERSION:r->Version);
		ndr_print_array_uint8(ndr, "Checksum", r->Checksum, 8);
		ndr_print_uint32(ndr, "SeqNum", r->SeqNum);
		ndr->depth--;
		ndr->flags = _flags_save_STRUCT;
	}
}

#ifndef SKIP_NDR_TABLE_ntlmssp
static const struct ndr_interface_public_struct ntlmssp_public_structs[] = {
	{
		.name = "ntlmssp_VERSION",
		.struct_size = sizeof(struct ntlmssp_VERSION ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_ntlmssp_VERSION,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_ntlmssp_VERSION,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_ntlmssp_VERSION,
	},
	{
		.name = "NEGOTIATE_MESSAGE",
		.struct_size = sizeof(struct NEGOTIATE_MESSAGE ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_NEGOTIATE_MESSAGE,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_NEGOTIATE_MESSAGE,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_NEGOTIATE_MESSAGE,
	},
	{
		.name = "AV_PAIR",
		.struct_size = sizeof(struct AV_PAIR ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_AV_PAIR,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_AV_PAIR,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_AV_PAIR,
	},
	{
		.name = "AV_PAIR_LIST",
		.struct_size = sizeof(struct AV_PAIR_LIST ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_AV_PAIR_LIST,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_AV_PAIR_LIST,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_AV_PAIR_LIST,
	},
	{
		.name = "CHALLENGE_MESSAGE",
		.struct_size = sizeof(struct CHALLENGE_MESSAGE ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_CHALLENGE_MESSAGE,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_CHALLENGE_MESSAGE,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_CHALLENGE_MESSAGE,
	},
	{
		.name = "LM_RESPONSE",
		.struct_size = sizeof(struct LM_RESPONSE ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_LM_RESPONSE,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_LM_RESPONSE,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_LM_RESPONSE,
	},
	{
		.name = "LMv2_RESPONSE",
		.struct_size = sizeof(struct LMv2_RESPONSE ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_LMv2_RESPONSE,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_LMv2_RESPONSE,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_LMv2_RESPONSE,
	},
	{
		.name = "NTLM_RESPONSE",
		.struct_size = sizeof(struct NTLM_RESPONSE ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_NTLM_RESPONSE,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_NTLM_RESPONSE,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_NTLM_RESPONSE,
	},
	{
		.name = "NTLMv2_RESPONSE",
		.struct_size = sizeof(struct NTLMv2_RESPONSE ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_NTLMv2_RESPONSE,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_NTLMv2_RESPONSE,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_NTLMv2_RESPONSE,
	},
	{
		.name = "AUTHENTICATE_MESSAGE",
		.struct_size = sizeof(struct AUTHENTICATE_MESSAGE ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_AUTHENTICATE_MESSAGE,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_AUTHENTICATE_MESSAGE,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_AUTHENTICATE_MESSAGE,
	},
	{
		.name = "NTLMSSP_MESSAGE_SIGNATURE",
		.struct_size = sizeof(struct NTLMSSP_MESSAGE_SIGNATURE ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_NTLMSSP_MESSAGE_SIGNATURE,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_NTLMSSP_MESSAGE_SIGNATURE,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_NTLMSSP_MESSAGE_SIGNATURE,
	},
	{
		.name = "NTLMSSP_MESSAGE_SIGNATURE_NTLMv2",
		.struct_size = sizeof(struct NTLMSSP_MESSAGE_SIGNATURE_NTLMv2 ),
		.ndr_push = (ndr_push_flags_fn_t) ndr_push_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2,
		.ndr_pull = (ndr_pull_flags_fn_t) ndr_pull_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2,
		.ndr_print = (ndr_print_function_t) ndr_print_flags_NTLMSSP_MESSAGE_SIGNATURE_NTLMv2,
	},
	{ .name = NULL }
};

static const struct ndr_interface_call ntlmssp_calls[] = {
	{ .name = NULL }
};

static const char * const ntlmssp_endpoint_strings[] = {
	"ncacn_np:[\\pipe\\ntlmssp]", 
};

static const struct ndr_interface_string_array ntlmssp_endpoints = {
	.count	= 1,
	.names	= ntlmssp_endpoint_strings
};

static const char * const ntlmssp_authservice_strings[] = {
	"host", 
};

static const struct ndr_interface_string_array ntlmssp_authservices = {
	.count	= 1,
	.names	= ntlmssp_authservice_strings
};


const struct ndr_interface_table ndr_table_ntlmssp = {
	.name		= "ntlmssp",
	.syntax_id	= {
		{0x6e746c6d,0x7373,0x700a,{0x00,0x00},{0x00,0x00,0x00,0x00}},
		NDR_NTLMSSP_VERSION
	},
	.helpstring	= NDR_NTLMSSP_HELPSTRING,
	.num_calls	= 0,
	.calls		= ntlmssp_calls,
	.num_public_structs	= 12,
	.public_structs		= ntlmssp_public_structs,
	.endpoints	= &ntlmssp_endpoints,
	.authservices	= &ntlmssp_authservices
};

#endif /* SKIP_NDR_TABLE_ntlmssp */
