/* TimedQueue.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from TimedQueue.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/* TimedQueue is a specialized collection class.  It holds items in order, but rather than being*/
/* manually dequeued, they are dequeued automatically after a specified amount of time has elapsed*/
/* for that item.  As of today, it's possible the item will be dequeued a bit later than asked*/
/* for, but it will never be early.  Future implementations might tighten up the lateness.*/
/**/
/* The original design was to use a signal to notify when an item has been dequeued, but Vala has*/
/* a bug with passing an unnamed type as a signal parameter:*/
/* https://bugzilla.gnome.org/show_bug.cgi?id=628639*/
/**/
/* The rate the items come off the queue can be spaced out.  Note that this can cause items to back*/
/* up.  As of today, TimedQueue makes no effort to combat this.*/

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <gobject/gvaluecollector.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef void (*DequeuedCallback) (gconstpointer item, gpointer user_data);

#define TYPE_HASH_TIMED_QUEUE (hash_timed_queue_get_type ())
#define HASH_TIMED_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HASH_TIMED_QUEUE, HashTimedQueue))
#define HASH_TIMED_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HASH_TIMED_QUEUE, HashTimedQueueClass))
#define IS_HASH_TIMED_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HASH_TIMED_QUEUE))
#define IS_HASH_TIMED_QUEUE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HASH_TIMED_QUEUE))
#define HASH_TIMED_QUEUE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HASH_TIMED_QUEUE, HashTimedQueueClass))

typedef struct _HashTimedQueue HashTimedQueue;
typedef struct _HashTimedQueueClass HashTimedQueueClass;
typedef struct _HashTimedQueuePrivate HashTimedQueuePrivate;

#define TYPE_SORTED_LIST (sorted_list_get_type ())
#define SORTED_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SORTED_LIST, SortedList))
#define SORTED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SORTED_LIST, SortedListClass))
#define IS_SORTED_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SORTED_LIST))
#define IS_SORTED_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SORTED_LIST))
#define SORTED_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SORTED_LIST, SortedListClass))

typedef struct _SortedList SortedList;
typedef struct _SortedListClass SortedListClass;

#define HASH_TIMED_QUEUE_TYPE_ELEMENT (hash_timed_queue_element_get_type ())
#define HASH_TIMED_QUEUE_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), HASH_TIMED_QUEUE_TYPE_ELEMENT, HashTimedQueueElement))
#define HASH_TIMED_QUEUE_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), HASH_TIMED_QUEUE_TYPE_ELEMENT, HashTimedQueueElementClass))
#define HASH_TIMED_QUEUE_IS_ELEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), HASH_TIMED_QUEUE_TYPE_ELEMENT))
#define HASH_TIMED_QUEUE_IS_ELEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), HASH_TIMED_QUEUE_TYPE_ELEMENT))
#define HASH_TIMED_QUEUE_ELEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), HASH_TIMED_QUEUE_TYPE_ELEMENT, HashTimedQueueElementClass))

typedef struct _HashTimedQueueElement HashTimedQueueElement;
typedef struct _HashTimedQueueElementClass HashTimedQueueElementClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef gint64 (*Comparator) (void* a, void* b, gpointer user_data);
#define _hash_timed_queue_element_unref0(var) ((var == NULL) ? NULL : (var = (hash_timed_queue_element_unref (var), NULL)))
typedef struct _HashTimedQueueElementPrivate HashTimedQueueElementPrivate;
typedef struct _HashTimedQueueParamSpecElement HashTimedQueueParamSpecElement;
typedef struct _ParamSpecHashTimedQueue ParamSpecHashTimedQueue;
enum  {
	HASH_TIMED_QUEUE_PAUSED_SIGNAL,
	HASH_TIMED_QUEUE_NUM_SIGNALS
};
static guint hash_timed_queue_signals[HASH_TIMED_QUEUE_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _HashTimedQueue {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HashTimedQueuePrivate * priv;
};

struct _HashTimedQueueClass {
	GTypeClass parent_class;
	void (*finalize) (HashTimedQueue *self);
	void (*paused) (HashTimedQueue* self, gboolean is_paused);
};

struct _HashTimedQueuePrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	guint hold_msec;
	DequeuedCallback callback;
	gpointer callback_target;
	GeeEqualDataFunc equal_func;
	gpointer equal_func_target;
	GDestroyNotify equal_func_target_destroy_notify;
	gint priority;
	guint timer_id;
	SortedList* queue;
	GRecMutex __lock_queue;
	guint dequeue_spacing_msec;
	gulong last_dequeue;
	gboolean paused_state;
	GeeHashMap* item_count;
};

struct _HashTimedQueueElement {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HashTimedQueueElementPrivate * priv;
	gpointer item;
	gulong ready;
};

struct _HashTimedQueueElementClass {
	GTypeClass parent_class;
	void (*finalize) (HashTimedQueueElement *self);
};

struct _HashTimedQueueElementPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

struct _HashTimedQueueParamSpecElement {
	GParamSpec parent_instance;
};

struct _ParamSpecHashTimedQueue {
	GParamSpec parent_instance;
};

static gint HashTimedQueue_private_offset;
static gpointer hash_timed_queue_parent_class = NULL;
static gint HashTimedQueueElement_private_offset;
static gpointer hash_timed_queue_element_parent_class = NULL;

VALA_EXTERN gpointer hash_timed_queue_ref (gpointer instance);
VALA_EXTERN void hash_timed_queue_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_hash_timed_queue (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void value_set_hash_timed_queue (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void value_take_hash_timed_queue (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer value_get_hash_timed_queue (const GValue* value);
VALA_EXTERN GType hash_timed_queue_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (HashTimedQueue, hash_timed_queue_unref)
VALA_EXTERN GType sorted_list_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SortedList, g_object_unref)
static gpointer hash_timed_queue_element_ref (gpointer instance);
static void hash_timed_queue_element_unref (gpointer instance);
static GParamSpec* hash_timed_queue_param_spec_element (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags) G_GNUC_UNUSED ;
static void hash_timed_queue_value_set_element (GValue* value,
                                         gpointer v_object) G_GNUC_UNUSED ;
static void hash_timed_queue_value_take_element (GValue* value,
                                          gpointer v_object) G_GNUC_UNUSED ;
static gpointer hash_timed_queue_value_get_element (const GValue* value) G_GNUC_UNUSED ;
static GType hash_timed_queue_element_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (HashTimedQueueElement, hash_timed_queue_element_unref)
VALA_EXTERN HashTimedQueue* hash_timed_queue_new (GType g_type,
                                      GBoxedCopyFunc g_dup_func,
                                      GDestroyNotify g_destroy_func,
                                      guint hold_msec,
                                      DequeuedCallback callback,
                                      gpointer callback_target,
                                      GeeHashDataFunc hash_func,
                                      gpointer hash_func_target,
                                      GDestroyNotify hash_func_target_destroy_notify,
                                      GeeEqualDataFunc equal_func,
                                      gpointer equal_func_target,
                                      GDestroyNotify equal_func_target_destroy_notify,
                                      gint priority);
VALA_EXTERN HashTimedQueue* hash_timed_queue_construct (GType object_type,
                                            GType g_type,
                                            GBoxedCopyFunc g_dup_func,
                                            GDestroyNotify g_destroy_func,
                                            guint hold_msec,
                                            DequeuedCallback callback,
                                            gpointer callback_target,
                                            GeeHashDataFunc hash_func,
                                            gpointer hash_func_target,
                                            GDestroyNotify hash_func_target_destroy_notify,
                                            GeeEqualDataFunc equal_func,
                                            gpointer equal_func_target,
                                            GDestroyNotify equal_func_target_destroy_notify,
                                            gint priority);
static gint64 hash_timed_queue_element_comparator (void* a,
                                            void* b);
static gint64 _hash_timed_queue_element_comparator_comparator (void* a,
                                                        void* b,
                                                        gpointer self);
VALA_EXTERN SortedList* sorted_list_new (GType g_type,
                             GBoxedCopyFunc g_dup_func,
                             GDestroyNotify g_destroy_func,
                             Comparator cmp,
                             gpointer cmp_target);
VALA_EXTERN SortedList* sorted_list_construct (GType object_type,
                                   GType g_type,
                                   GBoxedCopyFunc g_dup_func,
                                   GDestroyNotify g_destroy_func,
                                   Comparator cmp,
                                   gpointer cmp_target);
static guint hash_timed_queue_get_heartbeat_timeout (HashTimedQueue* self);
static gboolean hash_timed_queue_on_heartbeat (HashTimedQueue* self);
static gboolean _hash_timed_queue_on_heartbeat_gsource_func (gpointer self);
VALA_EXTERN guint hash_timed_queue_get_dequeue_spacing_msec (HashTimedQueue* self);
VALA_EXTERN void hash_timed_queue_set_dequeue_spacing_msec (HashTimedQueue* self,
                                                guint msec);
VALA_EXTERN gboolean hash_timed_queue_is_paused (HashTimedQueue* self);
VALA_EXTERN void hash_timed_queue_pause (HashTimedQueue* self);
VALA_EXTERN void hash_timed_queue_unpause (HashTimedQueue* self);
VALA_EXTERN void hash_timed_queue_clear (HashTimedQueue* self);
VALA_EXTERN gboolean hash_timed_queue_contains (HashTimedQueue* self,
                                    gconstpointer item);
VALA_EXTERN gboolean hash_timed_queue_enqueue (HashTimedQueue* self,
                                   gconstpointer item);
static gulong hash_timed_queue_calc_ready_time (HashTimedQueue* self);
static HashTimedQueueElement* hash_timed_queue_element_new (GType g_type,
                                                     GBoxedCopyFunc g_dup_func,
                                                     GDestroyNotify g_destroy_func,
                                                     gconstpointer item,
                                                     gulong ready);
static HashTimedQueueElement* hash_timed_queue_element_construct (GType object_type,
                                                           GType g_type,
                                                           GBoxedCopyFunc g_dup_func,
                                                           GDestroyNotify g_destroy_func,
                                                           gconstpointer item,
                                                           gulong ready);
VALA_EXTERN gboolean hash_timed_queue_enqueue_many (HashTimedQueue* self,
                                        GeeCollection* items);
VALA_EXTERN gboolean sorted_list_add_list (SortedList* self,
                               GeeList* items);
VALA_EXTERN gboolean hash_timed_queue_remove_first (HashTimedQueue* self,
                                        gconstpointer item);
static void hash_timed_queue_removed (HashTimedQueue* self,
                               gconstpointer item);
VALA_EXTERN gulong now_ms (void);
VALA_EXTERN gpointer sorted_list_get_at (SortedList* self,
                             gint index);
VALA_EXTERN gpointer sorted_list_remove_at (SortedList* self,
                                gint index);
VALA_EXTERN gint hash_timed_queue_get_size (HashTimedQueue* self);
static void hash_timed_queue_real_paused (HashTimedQueue* self,
                                   gboolean is_paused);
static void hash_timed_queue_element_finalize (HashTimedQueueElement * obj);
static GType hash_timed_queue_element_get_type_once (void);
static void hash_timed_queue_finalize (HashTimedQueue * obj);
static GType hash_timed_queue_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
hash_timed_queue_get_instance_private (HashTimedQueue* self)
{
	return G_STRUCT_MEMBER_P (self, HashTimedQueue_private_offset);
}

static gint64
_hash_timed_queue_element_comparator_comparator (void* a,
                                                 void* b,
                                                 gpointer self)
{
	gint64 result;
	result = hash_timed_queue_element_comparator (a, b);
	return result;
}

static gboolean
_hash_timed_queue_on_heartbeat_gsource_func (gpointer self)
{
	gboolean result;
	result = hash_timed_queue_on_heartbeat ((HashTimedQueue*) self);
	return result;
}

HashTimedQueue*
hash_timed_queue_construct (GType object_type,
                            GType g_type,
                            GBoxedCopyFunc g_dup_func,
                            GDestroyNotify g_destroy_func,
                            guint hold_msec,
                            DequeuedCallback callback,
                            gpointer callback_target,
                            GeeHashDataFunc hash_func,
                            gpointer hash_func_target,
                            GDestroyNotify hash_func_target_destroy_notify,
                            GeeEqualDataFunc equal_func,
                            gpointer equal_func_target,
                            GDestroyNotify equal_func_target_destroy_notify,
                            gint priority)
{
	HashTimedQueue* self = NULL;
	SortedList* _tmp4_;
	GeeHashDataFunc _tmp5_;
	gpointer _tmp5__target;
	GDestroyNotify _tmp5__target_destroy_notify;
	GeeEqualDataFunc _tmp6_;
	gpointer _tmp6__target;
	GDestroyNotify _tmp6__target_destroy_notify;
	GeeHashMap* _tmp7_;
	self = (HashTimedQueue*) g_type_create_instance (object_type);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	self->priv->hold_msec = hold_msec;
	self->priv->callback = callback;
	self->priv->callback_target = callback_target;
	if (equal_func != NULL) {
		GeeEqualDataFunc _tmp0_;
		gpointer _tmp0__target;
		GDestroyNotify _tmp0__target_destroy_notify;
		_tmp0_ = equal_func;
		_tmp0__target = equal_func_target;
		_tmp0__target_destroy_notify = equal_func_target_destroy_notify;
		equal_func = NULL;
		equal_func_target = NULL;
		equal_func_target_destroy_notify = NULL;
		(self->priv->equal_func_target_destroy_notify == NULL) ? NULL : (self->priv->equal_func_target_destroy_notify (self->priv->equal_func_target), NULL);
		self->priv->equal_func = NULL;
		self->priv->equal_func_target = NULL;
		self->priv->equal_func_target_destroy_notify = NULL;
		self->priv->equal_func = _tmp0_;
		self->priv->equal_func_target = _tmp0__target;
		self->priv->equal_func_target_destroy_notify = _tmp0__target_destroy_notify;
	} else {
		gpointer _tmp1_ = NULL;
		GDestroyNotify _tmp2_ = NULL;
		GeeEqualDataFunc _tmp3_;
		_tmp3_ = gee_functions_get_equal_func_for (g_type, &_tmp1_, &_tmp2_);
		(self->priv->equal_func_target_destroy_notify == NULL) ? NULL : (self->priv->equal_func_target_destroy_notify (self->priv->equal_func_target), NULL);
		self->priv->equal_func = NULL;
		self->priv->equal_func_target = NULL;
		self->priv->equal_func_target_destroy_notify = NULL;
		self->priv->equal_func = (GeeEqualDataFunc) _tmp3_;
		self->priv->equal_func_target = _tmp1_;
		self->priv->equal_func_target_destroy_notify = _tmp2_;
	}
	self->priv->priority = priority;
	_tmp4_ = sorted_list_new (HASH_TIMED_QUEUE_TYPE_ELEMENT, (GBoxedCopyFunc) hash_timed_queue_element_ref, (GDestroyNotify) hash_timed_queue_element_unref, _hash_timed_queue_element_comparator_comparator, NULL);
	_g_object_unref0 (self->priv->queue);
	self->priv->queue = _tmp4_;
	self->priv->timer_id = g_timeout_add_full (priority, hash_timed_queue_get_heartbeat_timeout (self), _hash_timed_queue_on_heartbeat_gsource_func, hash_timed_queue_ref (self), hash_timed_queue_unref);
	_tmp5_ = hash_func;
	_tmp5__target = hash_func_target;
	_tmp5__target_destroy_notify = hash_func_target_destroy_notify;
	hash_func = NULL;
	hash_func_target = NULL;
	hash_func_target_destroy_notify = NULL;
	_tmp6_ = equal_func;
	_tmp6__target = equal_func_target;
	_tmp6__target_destroy_notify = equal_func_target_destroy_notify;
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	_tmp7_ = gee_hash_map_new (g_type, (GBoxedCopyFunc) g_dup_func, (GDestroyNotify) g_destroy_func, G_TYPE_INT, NULL, NULL, _tmp5_, _tmp5__target, _tmp5__target_destroy_notify, _tmp6_, _tmp6__target, _tmp6__target_destroy_notify, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->item_count);
	self->priv->item_count = _tmp7_;
	(hash_func_target_destroy_notify == NULL) ? NULL : (hash_func_target_destroy_notify (hash_func_target), NULL);
	hash_func = NULL;
	hash_func_target = NULL;
	hash_func_target_destroy_notify = NULL;
	(equal_func_target_destroy_notify == NULL) ? NULL : (equal_func_target_destroy_notify (equal_func_target), NULL);
	equal_func = NULL;
	equal_func_target = NULL;
	equal_func_target_destroy_notify = NULL;
	return self;
}

HashTimedQueue*
hash_timed_queue_new (GType g_type,
                      GBoxedCopyFunc g_dup_func,
                      GDestroyNotify g_destroy_func,
                      guint hold_msec,
                      DequeuedCallback callback,
                      gpointer callback_target,
                      GeeHashDataFunc hash_func,
                      gpointer hash_func_target,
                      GDestroyNotify hash_func_target_destroy_notify,
                      GeeEqualDataFunc equal_func,
                      gpointer equal_func_target,
                      GDestroyNotify equal_func_target_destroy_notify,
                      gint priority)
{
	return hash_timed_queue_construct (TYPE_HASH_TIMED_QUEUE, g_type, g_dup_func, g_destroy_func, hold_msec, callback, callback_target, hash_func, hash_func_target, hash_func_target_destroy_notify, equal_func, equal_func_target, equal_func_target_destroy_notify, priority);
}

guint
hash_timed_queue_get_dequeue_spacing_msec (HashTimedQueue* self)
{
	guint result;
	g_return_val_if_fail (IS_HASH_TIMED_QUEUE (self), 0U);
	result = self->priv->dequeue_spacing_msec;
	return result;
}

void
hash_timed_queue_set_dequeue_spacing_msec (HashTimedQueue* self,
                                           guint msec)
{
	g_return_if_fail (IS_HASH_TIMED_QUEUE (self));
	if (msec == self->priv->dequeue_spacing_msec) {
		return;
	}
	if (self->priv->timer_id != ((guint) 0)) {
		g_source_remove (self->priv->timer_id);
	}
	self->priv->dequeue_spacing_msec = msec;
	self->priv->timer_id = g_timeout_add_full (self->priv->priority, hash_timed_queue_get_heartbeat_timeout (self), _hash_timed_queue_on_heartbeat_gsource_func, hash_timed_queue_ref (self), hash_timed_queue_unref);
}

static guint
hash_timed_queue_get_heartbeat_timeout (HashTimedQueue* self)
{
	guint _tmp0_ = 0U;
	guint result;
	g_return_val_if_fail (IS_HASH_TIMED_QUEUE (self), 0U);
	if (self->priv->dequeue_spacing_msec == ((guint) 0)) {
		_tmp0_ = self->priv->hold_msec / 10;
	} else {
		_tmp0_ = self->priv->dequeue_spacing_msec / 2;
	}
	result = CLAMP (_tmp0_, (guint) 10, G_MAXUINT);
	return result;
}

gboolean
hash_timed_queue_is_paused (HashTimedQueue* self)
{
	gboolean result;
	g_return_val_if_fail (IS_HASH_TIMED_QUEUE (self), FALSE);
	result = self->priv->paused_state;
	return result;
}

void
hash_timed_queue_pause (HashTimedQueue* self)
{
	g_return_if_fail (IS_HASH_TIMED_QUEUE (self));
	if (self->priv->paused_state) {
		return;
	}
	self->priv->paused_state = TRUE;
	g_signal_emit (self, hash_timed_queue_signals[HASH_TIMED_QUEUE_PAUSED_SIGNAL], 0, TRUE);
}

void
hash_timed_queue_unpause (HashTimedQueue* self)
{
	g_return_if_fail (IS_HASH_TIMED_QUEUE (self));
	if (!self->priv->paused_state) {
		return;
	}
	self->priv->paused_state = FALSE;
	g_signal_emit (self, hash_timed_queue_signals[HASH_TIMED_QUEUE_PAUSED_SIGNAL], 0, FALSE);
}

void
hash_timed_queue_clear (HashTimedQueue* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_HASH_TIMED_QUEUE (self));
	{
		SortedList* _tmp0_;
		_tmp0_ = self->priv->queue;
		g_rec_mutex_lock (&self->priv->__lock_queue);
		{
			GeeHashMap* _tmp1_;
			SortedList* _tmp2_;
			_tmp1_ = self->priv->item_count;
			gee_abstract_map_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap));
			_tmp2_ = self->priv->queue;
			gee_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection));
		}
		__finally0:
		{
			SortedList* _tmp3_;
			_tmp3_ = self->priv->queue;
			g_rec_mutex_unlock (&self->priv->__lock_queue);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

gboolean
hash_timed_queue_contains (HashTimedQueue* self,
                           gconstpointer item)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_HASH_TIMED_QUEUE (self), FALSE);
	{
		SortedList* _tmp0_;
		gboolean _tmp4_ = FALSE;
		_tmp0_ = self->priv->queue;
		g_rec_mutex_lock (&self->priv->__lock_queue);
		{
			GeeHashMap* _tmp1_;
			_tmp1_ = self->priv->item_count;
			result = gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), item);
			{
				SortedList* _tmp2_;
				_tmp2_ = self->priv->queue;
				g_rec_mutex_unlock (&self->priv->__lock_queue);
			}
			return result;
		}
		__finally0:
		{
			SortedList* _tmp3_;
			_tmp3_ = self->priv->queue;
			g_rec_mutex_unlock (&self->priv->__lock_queue);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp4_;
	}
}

gboolean
hash_timed_queue_enqueue (HashTimedQueue* self,
                          gconstpointer item)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_HASH_TIMED_QUEUE (self), FALSE);
	{
		SortedList* _tmp0_;
		gboolean _tmp13_ = FALSE;
		_tmp0_ = self->priv->queue;
		g_rec_mutex_lock (&self->priv->__lock_queue);
		{
			SortedList* _tmp1_;
			HashTimedQueueElement* _tmp2_;
			HashTimedQueueElement* _tmp3_;
			gboolean _tmp4_;
			gint _tmp6_ = 0;
			GeeHashMap* _tmp7_;
			GeeHashMap* _tmp10_;
			_tmp1_ = self->priv->queue;
			_tmp2_ = hash_timed_queue_element_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, item, hash_timed_queue_calc_ready_time (self));
			_tmp3_ = _tmp2_;
			_tmp4_ = !gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection), _tmp3_);
			_hash_timed_queue_element_unref0 (_tmp3_);
			if (_tmp4_) {
				result = FALSE;
				{
					SortedList* _tmp5_;
					_tmp5_ = self->priv->queue;
					g_rec_mutex_unlock (&self->priv->__lock_queue);
				}
				return result;
			}
			_tmp7_ = self->priv->item_count;
			if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), item)) {
				GeeHashMap* _tmp8_;
				gpointer _tmp9_;
				_tmp8_ = self->priv->item_count;
				_tmp9_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), item);
				_tmp6_ = ((gint) ((gintptr) _tmp9_)) + 1;
			} else {
				_tmp6_ = 1;
			}
			_tmp10_ = self->priv->item_count;
			gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), item, (gpointer) ((gintptr) _tmp6_));
			result = TRUE;
			{
				SortedList* _tmp11_;
				_tmp11_ = self->priv->queue;
				g_rec_mutex_unlock (&self->priv->__lock_queue);
			}
			return result;
		}
		__finally0:
		{
			SortedList* _tmp12_;
			_tmp12_ = self->priv->queue;
			g_rec_mutex_unlock (&self->priv->__lock_queue);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp13_;
	}
}

gboolean
hash_timed_queue_enqueue_many (HashTimedQueue* self,
                               GeeCollection* items)
{
	gulong ready_time = 0UL;
	GeeArrayList* elements = NULL;
	GeeArrayList* _tmp0_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_HASH_TIMED_QUEUE (self), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (items, GEE_TYPE_COLLECTION), FALSE);
	ready_time = hash_timed_queue_calc_ready_time (self);
	_tmp0_ = gee_array_list_new (HASH_TIMED_QUEUE_TYPE_ELEMENT, (GBoxedCopyFunc) hash_timed_queue_element_ref, (GDestroyNotify) hash_timed_queue_element_unref, NULL, NULL, NULL);
	elements = _tmp0_;
	{
		GeeIterator* _item_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (items, GEE_TYPE_ITERABLE, GeeIterable));
		_item_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			gpointer item = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			GeeArrayList* _tmp5_;
			gconstpointer _tmp6_;
			HashTimedQueueElement* _tmp7_;
			HashTimedQueueElement* _tmp8_;
			_tmp2_ = _item_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _item_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			item = _tmp4_;
			_tmp5_ = elements;
			_tmp6_ = item;
			_tmp7_ = hash_timed_queue_element_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, (GDestroyNotify) self->priv->g_destroy_func, _tmp6_, ready_time);
			_tmp8_ = _tmp7_;
			gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp8_);
			_hash_timed_queue_element_unref0 (_tmp8_);
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
		}
		_g_object_unref0 (_item_it);
	}
	{
		SortedList* _tmp9_;
		_tmp9_ = self->priv->queue;
		g_rec_mutex_lock (&self->priv->__lock_queue);
		{
			SortedList* _tmp10_;
			GeeArrayList* _tmp11_;
			_tmp10_ = self->priv->queue;
			_tmp11_ = elements;
			if (!sorted_list_add_list (_tmp10_, G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, GEE_TYPE_LIST, GeeList))) {
				result = FALSE;
				{
					SortedList* _tmp12_;
					_tmp12_ = self->priv->queue;
					g_rec_mutex_unlock (&self->priv->__lock_queue);
				}
				_g_object_unref0 (elements);
				return result;
			}
			{
				GeeIterator* _item_it = NULL;
				GeeIterator* _tmp13_;
				_tmp13_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (items, GEE_TYPE_ITERABLE, GeeIterable));
				_item_it = _tmp13_;
				while (TRUE) {
					GeeIterator* _tmp14_;
					gpointer item = NULL;
					GeeIterator* _tmp15_;
					gpointer _tmp16_;
					gint _tmp17_ = 0;
					GeeHashMap* _tmp18_;
					gconstpointer _tmp19_;
					GeeHashMap* _tmp23_;
					gconstpointer _tmp24_;
					_tmp14_ = _item_it;
					if (!gee_iterator_next (_tmp14_)) {
						break;
					}
					_tmp15_ = _item_it;
					_tmp16_ = gee_iterator_get (_tmp15_);
					item = _tmp16_;
					_tmp18_ = self->priv->item_count;
					_tmp19_ = item;
					if (gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp19_)) {
						GeeHashMap* _tmp20_;
						gconstpointer _tmp21_;
						gpointer _tmp22_;
						_tmp20_ = self->priv->item_count;
						_tmp21_ = item;
						_tmp22_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp21_);
						_tmp17_ = ((gint) ((gintptr) _tmp22_)) + 1;
					} else {
						_tmp17_ = 1;
					}
					_tmp23_ = self->priv->item_count;
					_tmp24_ = item;
					gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), _tmp24_, (gpointer) ((gintptr) _tmp17_));
					((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
				}
				_g_object_unref0 (_item_it);
			}
		}
		__finally0:
		{
			SortedList* _tmp25_;
			_tmp25_ = self->priv->queue;
			g_rec_mutex_unlock (&self->priv->__lock_queue);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp26_ = FALSE;
			_g_object_unref0 (elements);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp26_;
		}
	}
	result = TRUE;
	_g_object_unref0 (elements);
	return result;
}

gboolean
hash_timed_queue_remove_first (HashTimedQueue* self,
                               gconstpointer item)
{
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_HASH_TIMED_QUEUE (self), FALSE);
	{
		SortedList* _tmp0_;
		_tmp0_ = self->priv->queue;
		g_rec_mutex_lock (&self->priv->__lock_queue);
		{
			gboolean item_removed = FALSE;
			GeeIterator* iter = NULL;
			SortedList* _tmp1_;
			GeeIterator* _tmp2_;
			item_removed = FALSE;
			_tmp1_ = self->priv->queue;
			_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
			iter = _tmp2_;
			while (TRUE) {
				GeeIterator* _tmp3_;
				HashTimedQueueElement* e = NULL;
				GeeIterator* _tmp4_;
				gpointer _tmp5_;
				GeeEqualDataFunc _tmp6_;
				gpointer _tmp6__target;
				HashTimedQueueElement* _tmp7_;
				gconstpointer _tmp8_;
				_tmp3_ = iter;
				if (!gee_iterator_next (_tmp3_)) {
					break;
				}
				_tmp4_ = iter;
				_tmp5_ = gee_iterator_get (_tmp4_);
				e = (HashTimedQueueElement*) _tmp5_;
				_tmp6_ = self->priv->equal_func;
				_tmp6__target = self->priv->equal_func_target;
				_tmp7_ = e;
				_tmp8_ = _tmp7_->item;
				if (_tmp6_ (item, _tmp8_, _tmp6__target)) {
					GeeIterator* _tmp9_;
					_tmp9_ = iter;
					gee_iterator_remove (_tmp9_);
					item_removed = TRUE;
					_hash_timed_queue_element_unref0 (e);
					break;
				}
				_hash_timed_queue_element_unref0 (e);
			}
			if (!item_removed) {
				result = FALSE;
				_g_object_unref0 (iter);
				{
					SortedList* _tmp10_;
					_tmp10_ = self->priv->queue;
					g_rec_mutex_unlock (&self->priv->__lock_queue);
				}
				return result;
			}
			hash_timed_queue_removed (self, item);
			_g_object_unref0 (iter);
		}
		__finally0:
		{
			SortedList* _tmp11_;
			_tmp11_ = self->priv->queue;
			g_rec_mutex_unlock (&self->priv->__lock_queue);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp12_ = FALSE;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp12_;
		}
	}
	result = TRUE;
	return result;
}

static gulong
hash_timed_queue_calc_ready_time (HashTimedQueue* self)
{
	gulong result;
	g_return_val_if_fail (IS_HASH_TIMED_QUEUE (self), 0UL);
	result = now_ms () + ((gulong) self->priv->hold_msec);
	return result;
}

static gboolean
hash_timed_queue_on_heartbeat (HashTimedQueue* self)
{
	gulong now = 0UL;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (IS_HASH_TIMED_QUEUE (self), FALSE);
	if (self->priv->paused_state) {
		result = TRUE;
		return result;
	}
	now = (gulong) 0;
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			SortedList* _tmp1_;
			gint _tmp2_;
			gint _tmp3_;
			gpointer item = NULL;
			DequeuedCallback _tmp23_;
			gpointer _tmp23__target;
			gconstpointer _tmp24_;
			if (!_tmp0_) {
			}
			_tmp0_ = FALSE;
			_tmp1_ = self->priv->queue;
			_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp3_ = _tmp2_;
			if (_tmp3_ == 0) {
				break;
			}
			item = NULL;
			{
				SortedList* _tmp4_;
				_tmp4_ = self->priv->queue;
				g_rec_mutex_lock (&self->priv->__lock_queue);
				{
					HashTimedQueueElement* head = NULL;
					SortedList* _tmp5_;
					gpointer _tmp6_;
					HashTimedQueueElement* _tmp7_;
					HashTimedQueueElement* _tmp8_;
					gboolean _tmp10_ = FALSE;
					HashTimedQueueElement* h = NULL;
					SortedList* _tmp12_;
					gpointer _tmp13_;
					HashTimedQueueElement* _tmp14_;
					HashTimedQueueElement* _tmp15_;
					HashTimedQueueElement* _tmp16_;
					gconstpointer _tmp17_;
					HashTimedQueueElement* _tmp18_;
					gconstpointer _tmp19_;
					gpointer _tmp20_;
					_tmp5_ = self->priv->queue;
					_tmp6_ = sorted_list_get_at (_tmp5_, 0);
					head = (HashTimedQueueElement*) _tmp6_;
					_tmp7_ = head;
					_vala_assert (_tmp7_ != NULL, "head != null");
					if (now == ((gulong) 0)) {
						now = now_ms ();
					}
					_tmp8_ = head;
					if (_tmp8_->ready > now) {
						_hash_timed_queue_element_unref0 (head);
						{
							SortedList* _tmp9_;
							_tmp9_ = self->priv->queue;
							g_rec_mutex_unlock (&self->priv->__lock_queue);
						}
						((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
						break;
					}
					if (self->priv->dequeue_spacing_msec != ((guint) 0)) {
						_tmp10_ = (now - self->priv->last_dequeue) < ((gulong) self->priv->dequeue_spacing_msec);
					} else {
						_tmp10_ = FALSE;
					}
					if (_tmp10_) {
						_hash_timed_queue_element_unref0 (head);
						{
							SortedList* _tmp11_;
							_tmp11_ = self->priv->queue;
							g_rec_mutex_unlock (&self->priv->__lock_queue);
						}
						((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
						break;
					}
					_tmp12_ = self->priv->queue;
					_tmp13_ = sorted_list_remove_at (_tmp12_, 0);
					h = (HashTimedQueueElement*) _tmp13_;
					_tmp14_ = head;
					_tmp15_ = h;
					_vala_assert (_tmp14_ == _tmp15_, "head == h");
					_tmp16_ = head;
					_tmp17_ = _tmp16_->item;
					hash_timed_queue_removed (self, _tmp17_);
					_tmp18_ = head;
					_tmp19_ = _tmp18_->item;
					_tmp20_ = ((_tmp19_ != NULL) && (self->priv->g_dup_func != NULL)) ? self->priv->g_dup_func ((gpointer) _tmp19_) : ((gpointer) _tmp19_);
					((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
					item = _tmp20_;
					_hash_timed_queue_element_unref0 (h);
					_hash_timed_queue_element_unref0 (head);
				}
				__finally0:
				{
					SortedList* _tmp21_;
					_tmp21_ = self->priv->queue;
					g_rec_mutex_unlock (&self->priv->__lock_queue);
				}
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gboolean _tmp22_ = FALSE;
					((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return _tmp22_;
				}
			}
			_tmp23_ = self->priv->callback;
			_tmp23__target = self->priv->callback_target;
			_tmp24_ = item;
			_tmp23_ (_tmp24_, _tmp23__target);
			self->priv->last_dequeue = now;
			if (self->priv->dequeue_spacing_msec != ((guint) 0)) {
				((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
				break;
			}
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
		}
	}
	result = TRUE;
	return result;
}

static void
hash_timed_queue_removed (HashTimedQueue* self,
                          gconstpointer item)
{
	GeeHashMap* _tmp0_;
	gint count = 0;
	GeeHashMap* _tmp1_;
	gpointer _tmp2_;
	gint _tmp3_;
	g_return_if_fail (IS_HASH_TIMED_QUEUE (self));
	_tmp0_ = self->priv->item_count;
	if (!gee_abstract_map_has_key (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), item)) {
		return;
	}
	_tmp1_ = self->priv->item_count;
	_tmp2_ = gee_abstract_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), item);
	count = (gint) ((gintptr) _tmp2_);
	_vala_assert (count > 0, "count > 0");
	count = count - 1;
	_tmp3_ = count;
	if (_tmp3_ == 0) {
		GeeHashMap* _tmp4_;
		_tmp4_ = self->priv->item_count;
		gee_abstract_map_unset (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), item, NULL);
	} else {
		GeeHashMap* _tmp5_;
		_tmp5_ = self->priv->item_count;
		gee_abstract_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_MAP, GeeAbstractMap), item, (gpointer) ((gintptr) count));
	}
}

gint
hash_timed_queue_get_size (HashTimedQueue* self)
{
	gint result;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (IS_HASH_TIMED_QUEUE (self), 0);
	{
		SortedList* _tmp0_;
		gint _tmp6_ = -1;
		_tmp0_ = self->priv->queue;
		g_rec_mutex_lock (&self->priv->__lock_queue);
		{
			SortedList* _tmp1_;
			gint _tmp2_;
			gint _tmp3_;
			_tmp1_ = self->priv->queue;
			_tmp2_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_COLLECTION, GeeCollection));
			_tmp3_ = _tmp2_;
			result = _tmp3_;
			{
				SortedList* _tmp4_;
				_tmp4_ = self->priv->queue;
				g_rec_mutex_unlock (&self->priv->__lock_queue);
			}
			return result;
		}
		__finally0:
		{
			SortedList* _tmp5_;
			_tmp5_ = self->priv->queue;
			g_rec_mutex_unlock (&self->priv->__lock_queue);
		}
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp6_;
	}
}

static void
hash_timed_queue_real_paused (HashTimedQueue* self,
                              gboolean is_paused)
{
}

static inline gpointer
hash_timed_queue_element_get_instance_private (HashTimedQueueElement* self)
{
	return G_STRUCT_MEMBER_P (self, HashTimedQueueElement_private_offset);
}

static HashTimedQueueElement*
hash_timed_queue_element_construct (GType object_type,
                                    GType g_type,
                                    GBoxedCopyFunc g_dup_func,
                                    GDestroyNotify g_destroy_func,
                                    gconstpointer item,
                                    gulong ready)
{
	HashTimedQueueElement* self = NULL;
	gpointer _tmp0_;
	self = (HashTimedQueueElement*) g_type_create_instance (object_type);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = ((item != NULL) && (g_dup_func != NULL)) ? g_dup_func ((gpointer) item) : ((gpointer) item);
	((self->item == NULL) || (g_destroy_func == NULL)) ? NULL : (self->item = (g_destroy_func (self->item), NULL));
	self->item = _tmp0_;
	self->ready = ready;
	return self;
}

static HashTimedQueueElement*
hash_timed_queue_element_new (GType g_type,
                              GBoxedCopyFunc g_dup_func,
                              GDestroyNotify g_destroy_func,
                              gconstpointer item,
                              gulong ready)
{
	return hash_timed_queue_element_construct (HASH_TIMED_QUEUE_TYPE_ELEMENT, g_type, g_dup_func, g_destroy_func, item, ready);
}

static gint64
hash_timed_queue_element_comparator (void* a,
                                     void* b)
{
	gint64 result;
	result = ((gint64) G_TYPE_CHECK_INSTANCE_CAST ((HashTimedQueueElement*) a, HASH_TIMED_QUEUE_TYPE_ELEMENT, HashTimedQueueElement)->ready) - ((gint64) G_TYPE_CHECK_INSTANCE_CAST ((HashTimedQueueElement*) b, HASH_TIMED_QUEUE_TYPE_ELEMENT, HashTimedQueueElement)->ready);
	return result;
}

static void
hash_timed_queue_value_element_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
hash_timed_queue_value_element_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		hash_timed_queue_element_unref (value->data[0].v_pointer);
	}
}

static void
hash_timed_queue_value_element_copy_value (const GValue* src_value,
                                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = hash_timed_queue_element_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
hash_timed_queue_value_element_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
hash_timed_queue_value_element_collect_value (GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		HashTimedQueueElement * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = hash_timed_queue_element_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
hash_timed_queue_value_element_lcopy_value (const GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	HashTimedQueueElement ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = hash_timed_queue_element_ref (value->data[0].v_pointer);
	}
	return NULL;
}

static GParamSpec*
hash_timed_queue_param_spec_element (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags)
{
	HashTimedQueueParamSpecElement* spec;
	g_return_val_if_fail (g_type_is_a (object_type, HASH_TIMED_QUEUE_TYPE_ELEMENT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

static gpointer
hash_timed_queue_value_get_element (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, HASH_TIMED_QUEUE_TYPE_ELEMENT), NULL);
	return value->data[0].v_pointer;
}

static void
hash_timed_queue_value_set_element (GValue* value,
                                    gpointer v_object)
{
	HashTimedQueueElement * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, HASH_TIMED_QUEUE_TYPE_ELEMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, HASH_TIMED_QUEUE_TYPE_ELEMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		hash_timed_queue_element_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		hash_timed_queue_element_unref (old);
	}
}

static void
hash_timed_queue_value_take_element (GValue* value,
                                     gpointer v_object)
{
	HashTimedQueueElement * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, HASH_TIMED_QUEUE_TYPE_ELEMENT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, HASH_TIMED_QUEUE_TYPE_ELEMENT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		hash_timed_queue_element_unref (old);
	}
}

static void
hash_timed_queue_element_class_init (HashTimedQueueElementClass * klass,
                                     gpointer klass_data)
{
	hash_timed_queue_element_parent_class = g_type_class_peek_parent (klass);
	((HashTimedQueueElementClass *) klass)->finalize = hash_timed_queue_element_finalize;
	g_type_class_adjust_private_offset (klass, &HashTimedQueueElement_private_offset);
}

static void
hash_timed_queue_element_instance_init (HashTimedQueueElement * self,
                                        gpointer klass)
{
	self->priv = hash_timed_queue_element_get_instance_private (self);
	self->ref_count = 1;
}

static void
hash_timed_queue_element_finalize (HashTimedQueueElement * obj)
{
	HashTimedQueueElement * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, HASH_TIMED_QUEUE_TYPE_ELEMENT, HashTimedQueueElement);
	g_signal_handlers_destroy (self);
	((self->item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (self->item = (self->priv->g_destroy_func (self->item), NULL));
}

static GType
hash_timed_queue_element_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { hash_timed_queue_value_element_init, hash_timed_queue_value_element_free_value, hash_timed_queue_value_element_copy_value, hash_timed_queue_value_element_peek_pointer, "p", hash_timed_queue_value_element_collect_value, "p", hash_timed_queue_value_element_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (HashTimedQueueElementClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) hash_timed_queue_element_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HashTimedQueueElement), 0, (GInstanceInitFunc) hash_timed_queue_element_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType hash_timed_queue_element_type_id;
	hash_timed_queue_element_type_id = g_type_register_fundamental (g_type_fundamental_next (), "HashTimedQueueElement", &g_define_type_info, &g_define_type_fundamental_info, 0);
	HashTimedQueueElement_private_offset = g_type_add_instance_private (hash_timed_queue_element_type_id, sizeof (HashTimedQueueElementPrivate));
	return hash_timed_queue_element_type_id;
}

static GType
hash_timed_queue_element_get_type (void)
{
	static volatile gsize hash_timed_queue_element_type_id__once = 0;
	if (g_once_init_enter (&hash_timed_queue_element_type_id__once)) {
		GType hash_timed_queue_element_type_id;
		hash_timed_queue_element_type_id = hash_timed_queue_element_get_type_once ();
		g_once_init_leave (&hash_timed_queue_element_type_id__once, hash_timed_queue_element_type_id);
	}
	return hash_timed_queue_element_type_id__once;
}

static gpointer
hash_timed_queue_element_ref (gpointer instance)
{
	HashTimedQueueElement * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

static void
hash_timed_queue_element_unref (gpointer instance)
{
	HashTimedQueueElement * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		HASH_TIMED_QUEUE_ELEMENT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
value_hash_timed_queue_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_hash_timed_queue_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		hash_timed_queue_unref (value->data[0].v_pointer);
	}
}

static void
value_hash_timed_queue_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = hash_timed_queue_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_hash_timed_queue_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_hash_timed_queue_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		HashTimedQueue * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = hash_timed_queue_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_hash_timed_queue_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	HashTimedQueue ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = hash_timed_queue_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_hash_timed_queue (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	ParamSpecHashTimedQueue* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_HASH_TIMED_QUEUE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_hash_timed_queue (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HASH_TIMED_QUEUE), NULL);
	return value->data[0].v_pointer;
}

void
value_set_hash_timed_queue (GValue* value,
                            gpointer v_object)
{
	HashTimedQueue * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HASH_TIMED_QUEUE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HASH_TIMED_QUEUE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		hash_timed_queue_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		hash_timed_queue_unref (old);
	}
}

void
value_take_hash_timed_queue (GValue* value,
                             gpointer v_object)
{
	HashTimedQueue * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_HASH_TIMED_QUEUE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_HASH_TIMED_QUEUE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		hash_timed_queue_unref (old);
	}
}

static void
hash_timed_queue_class_init (HashTimedQueueClass * klass,
                             gpointer klass_data)
{
	hash_timed_queue_parent_class = g_type_class_peek_parent (klass);
	((HashTimedQueueClass *) klass)->finalize = hash_timed_queue_finalize;
	g_type_class_adjust_private_offset (klass, &HashTimedQueue_private_offset);
	((HashTimedQueueClass *) klass)->paused = hash_timed_queue_real_paused;
	hash_timed_queue_signals[HASH_TIMED_QUEUE_PAUSED_SIGNAL] = g_signal_new ("paused", TYPE_HASH_TIMED_QUEUE, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (HashTimedQueueClass, paused), NULL, NULL, g_cclosure_marshal_VOID__BOOLEAN, G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
}

static void
hash_timed_queue_instance_init (HashTimedQueue * self,
                                gpointer klass)
{
	self->priv = hash_timed_queue_get_instance_private (self);
	self->priv->timer_id = (guint) 0;
	g_rec_mutex_init (&self->priv->__lock_queue);
	self->priv->dequeue_spacing_msec = (guint) 0;
	self->priv->last_dequeue = (gulong) 0;
	self->priv->paused_state = FALSE;
	self->ref_count = 1;
}

static void
hash_timed_queue_finalize (HashTimedQueue * obj)
{
	HashTimedQueue * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_HASH_TIMED_QUEUE, HashTimedQueue);
	g_signal_handlers_destroy (self);
	if (self->priv->timer_id != ((guint) 0)) {
		g_source_remove (self->priv->timer_id);
	}
	(self->priv->equal_func_target_destroy_notify == NULL) ? NULL : (self->priv->equal_func_target_destroy_notify (self->priv->equal_func_target), NULL);
	self->priv->equal_func = NULL;
	self->priv->equal_func_target = NULL;
	self->priv->equal_func_target_destroy_notify = NULL;
	g_rec_mutex_clear (&self->priv->__lock_queue);
	_g_object_unref0 (self->priv->queue);
	_g_object_unref0 (self->priv->item_count);
}

static GType
hash_timed_queue_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_hash_timed_queue_init, value_hash_timed_queue_free_value, value_hash_timed_queue_copy_value, value_hash_timed_queue_peek_pointer, "p", value_hash_timed_queue_collect_value, "p", value_hash_timed_queue_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (HashTimedQueueClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) hash_timed_queue_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (HashTimedQueue), 0, (GInstanceInitFunc) hash_timed_queue_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType hash_timed_queue_type_id;
	hash_timed_queue_type_id = g_type_register_fundamental (g_type_fundamental_next (), "HashTimedQueue", &g_define_type_info, &g_define_type_fundamental_info, 0);
	HashTimedQueue_private_offset = g_type_add_instance_private (hash_timed_queue_type_id, sizeof (HashTimedQueuePrivate));
	return hash_timed_queue_type_id;
}

GType
hash_timed_queue_get_type (void)
{
	static volatile gsize hash_timed_queue_type_id__once = 0;
	if (g_once_init_enter (&hash_timed_queue_type_id__once)) {
		GType hash_timed_queue_type_id;
		hash_timed_queue_type_id = hash_timed_queue_get_type_once ();
		g_once_init_leave (&hash_timed_queue_type_id__once, hash_timed_queue_type_id);
	}
	return hash_timed_queue_type_id__once;
}

gpointer
hash_timed_queue_ref (gpointer instance)
{
	HashTimedQueue * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
hash_timed_queue_unref (gpointer instance)
{
	HashTimedQueue * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		HASH_TIMED_QUEUE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

