#ifndef DOM_BINDINGNAMES_H_
#define DOM_BINDINGNAMES_H_

#include <stddef.h>
#include <stdint.h>
#include "mozilla/Attributes.h"

namespace mozilla::dom {

enum class BindingNamesOffset : uint16_t {
  ANGLE_instanced_arrays = 0,
  APZHitResultFlags = 23,
  AbortController = 41,
  AbortSignal = 57,
  AbstractRange = 69,
  AccessibleNode = 83,
  Addon = 98,
  AddonEvent = 104,
  AddonInstall = 115,
  AddonManager = 128,
  AddonManagerPermissions = 141,
  AnalyserNode = 165,
  Animation = 178,
  AnimationEffect = 188,
  AnimationEvent = 204,
  AnimationPlaybackEvent = 219,
  AnimationTimeline = 242,
  AnonymousContent = 260,
  Attr = 277,
  Audio = 282,
  AudioBuffer = 288,
  AudioBufferSourceNode = 300,
  AudioContext = 322,
  AudioData = 335,
  AudioDecoder = 345,
  AudioDestinationNode = 358,
  AudioEncoder = 379,
  AudioListener = 392,
  AudioNode = 406,
  AudioParam = 416,
  AudioParamMap = 427,
  AudioProcessingEvent = 441,
  AudioScheduledSourceNode = 462,
  AudioTrack = 487,
  AudioTrackList = 498,
  AudioWorklet = 513,
  AudioWorkletGlobalScope = 526,
  AudioWorkletNode = 550,
  AudioWorkletProcessor = 567,
  AuthenticatorAssertionResponse = 589,
  AuthenticatorAttestationResponse = 620,
  AuthenticatorResponse = 653,
  BarProp = 675,
  BaseAudioContext = 683,
  BatteryManager = 700,
  BeforeUnloadEvent = 715,
  BiquadFilterNode = 733,
  Blob = 750,
  BlobEvent = 755,
  BroadcastChannel = 765,
  BrowsingContext = 782,
  BrowsingContextGroup = 798,
  ByteLengthQueuingStrategy = 819,
  CDATASection = 845,
  CSPViolationReportBody = 858,
  CSS = 881,
  CSSAnimation = 885,
  CSSColor = 898,
  CSSColorValue = 907,
  CSSConditionRule = 921,
  CSSContainerRule = 938,
  CSSCounterStyleRule = 955,
  CSSCustomMediaRule = 975,
  CSSCustomPropertyRegisteredEvent = 994,
  CSSFontFaceRule = 1027,
  CSSFontFeatureValuesRule = 1043,
  CSSFontPaletteValuesRule = 1068,
  CSSGroupingRule = 1093,
  CSSHSL = 1109,
  CSSHWB = 1116,
  CSSImageValue = 1123,
  CSSImportRule = 1137,
  CSSKeyframeRule = 1151,
  CSSKeyframesRule = 1167,
  CSSKeywordValue = 1184,
  CSSLCH = 1200,
  CSSLab = 1207,
  CSSLayerBlockRule = 1214,
  CSSLayerStatementRule = 1232,
  CSSMarginRule = 1254,
  CSSMathClamp = 1268,
  CSSMathInvert = 1281,
  CSSMathMax = 1295,
  CSSMathMin = 1306,
  CSSMathNegate = 1317,
  CSSMathProduct = 1331,
  CSSMathSum = 1346,
  CSSMathValue = 1357,
  CSSMatrixComponent = 1370,
  CSSMediaRule = 1389,
  CSSMozDocumentRule = 1402,
  CSSNamespaceRule = 1421,
  CSSNestedDeclarations = 1438,
  CSSNumericArray = 1460,
  CSSNumericValue = 1476,
  CSSOKLCH = 1492,
  CSSOKLab = 1501,
  CSSPageDescriptors = 1510,
  CSSPageRule = 1529,
  CSSPerspective = 1541,
  CSSPositionTryDescriptors = 1556,
  CSSPositionTryRule = 1582,
  CSSPropertyRule = 1601,
  CSSPseudoElement = 1617,
  CSSRGB = 1634,
  CSSRotate = 1641,
  CSSRule = 1651,
  CSSRuleList = 1659,
  CSSScale = 1671,
  CSSScopeRule = 1680,
  CSSSkew = 1693,
  CSSSkewX = 1701,
  CSSSkewY = 1710,
  CSSStartingStyleRule = 1719,
  CSSStyleDeclaration = 1740,
  CSSStyleProperties = 1760,
  CSSStyleRule = 1779,
  CSSStyleSheet = 1792,
  CSSStyleValue = 1806,
  CSSSupportsRule = 1820,
  CSSTransformComponent = 1836,
  CSSTransformValue = 1858,
  CSSTransition = 1876,
  CSSTranslate = 1890,
  CSSUnitValue = 1903,
  CSSUnparsedValue = 1916,
  CSSVariableReferenceValue = 1933,
  Cache = 1959,
  CacheStorage = 1965,
  CallbackDebuggerNotification = 1978,
  CanonicalBrowsingContext = 2007,
  CanvasCaptureMediaStream = 2032,
  CanvasGradient = 2057,
  CanvasPattern = 2072,
  CanvasRenderingContext2D = 2086,
  CaretPosition = 2111,
  CaretStateChangedEvent = 2125,
  ChannelMergerNode = 2148,
  ChannelSplitterNode = 2166,
  ChannelWrapper = 2186,
  CharacterData = 2201,
  CheckerboardReportService = 2215,
  ChildProcessMessageManager = 2241,
  ChildSHistory = 2268,
  ChromeMessageBroadcaster = 2282,
  ChromeMessageSender = 2307,
  ChromeNodeList = 2327,
  ChromeUtils = 2342,
  ChromeWorker = 2354,
  Client = 2367,
  Clients = 2374,
  Clipboard = 2382,
  ClipboardEvent = 2392,
  ClipboardItem = 2407,
  ClonedErrorHolder = 2421,
  CloseEvent = 2439,
  CloseWatcher = 2450,
  CommandEvent = 2463,
  Comment = 2476,
  CompositionEvent = 2484,
  CompressionStream = 2501,
  ConsoleInstance = 2519,
  ConstantSourceNode = 2535,
  ContentFrameMessageManager = 2554,
  ContentProcessMessageManager = 2581,
  ContentVisibilityAutoStateChangeEvent = 2610,
  ConvolverNode = 2648,
  CookieChangeEvent = 2662,
  CookieStore = 2680,
  CookieStoreManager = 2692,
  CountQueuingStrategy = 2711,
  CreateOfferRequest = 2732,
  Credential = 2751,
  CredentialsContainer = 2762,
  Crypto = 2783,
  CryptoKey = 2790,
  CustomElementRegistry = 2800,
  CustomEvent = 2822,
  CustomStateSet = 2834,
  DOMException = 2849,
  DOMImplementation = 2862,
  DOMLocalization = 2880,
  DOMMatrix = 2896,
  DOMMatrixReadOnly = 2906,
  DOMParser = 2924,
  DOMPoint = 2934,
  DOMPointReadOnly = 2943,
  DOMQuad = 2960,
  DOMRect = 2968,
  DOMRectList = 2976,
  DOMRectReadOnly = 2988,
  DOMStringList = 3004,
  DOMStringMap = 3018,
  DOMTokenList = 3031,
  DataTransfer = 3044,
  DataTransferItem = 3057,
  DataTransferItemList = 3074,
  DebuggerNotification = 3095,
  DebuggerNotificationObserver = 3116,
  DecompressionStream = 3145,
  DedicatedWorkerGlobalScope = 3165,
  DelayNode = 3192,
  DeprecationReportBody = 3202,
  DeviceAcceleration = 3224,
  DeviceLightEvent = 3243,
  DeviceMotionEvent = 3260,
  DeviceOrientationEvent = 3278,
  DeviceRotationRate = 3301,
  Directory = 3320,
  Document = 3330,
  DocumentFragment = 3339,
  DocumentL10n = 3356,
  DocumentTimeline = 3369,
  DocumentType = 3386,
  DominatorTree = 3399,
  DragEvent = 3413,
  DynamicsCompressorNode = 3423,
  EXT_blend_minmax = 3446,
  EXT_color_buffer_float = 3463,
  EXT_color_buffer_half_float = 3486,
  EXT_depth_clamp = 3514,
  EXT_disjoint_timer_query = 3530,
  EXT_float_blend = 3555,
  EXT_frag_depth = 3571,
  EXT_sRGB = 3586,
  EXT_shader_texture_lod = 3595,
  EXT_texture_compression_bptc = 3618,
  EXT_texture_compression_rgtc = 3647,
  EXT_texture_filter_anisotropic = 3676,
  EXT_texture_norm16 = 3707,
  Element = 3726,
  ElementInternals = 3734,
  EncodedAudioChunk = 3751,
  EncodedVideoChunk = 3769,
  ErrorEvent = 3787,
  Event = 3798,
  EventCallbackDebuggerNotification = 3804,
  EventCounts = 3838,
  EventSource = 3850,
  EventTarget = 3862,
  Exception = 3874,
  ExtendableCookieChangeEvent = 3884,
  ExtendableEvent = 3912,
  ExtendableMessageEvent = 3928,
  ExtensionAlarms = 3951,
  ExtensionBrowser = 3967,
  ExtensionBrowserSettings = 3984,
  ExtensionBrowserSettingsColorManagement = 4009,
  ExtensionDns = 4049,
  ExtensionEventManager = 4062,
  ExtensionMockAPI = 4084,
  ExtensionPort = 4101,
  ExtensionProxy = 4115,
  ExtensionRuntime = 4130,
  ExtensionScripting = 4147,
  ExtensionSetting = 4166,
  ExtensionTest = 4183,
  External = 4197,
  FeaturePolicy = 4206,
  FeaturePolicyViolationReportBody = 4220,
  FetchEvent = 4253,
  FetchObserver = 4264,
  File = 4278,
  FileList = 4283,
  FileReader = 4292,
  FileReaderSync = 4303,
  FileSystem = 4318,
  FileSystemDirectoryEntry = 4329,
  FileSystemDirectoryHandle = 4354,
  FileSystemDirectoryHandle_AsyncIterator = 4380,
  FileSystemDirectoryIterator = 4420,
  FileSystemDirectoryReader = 4448,
  FileSystemEntry = 4474,
  FileSystemFileEntry = 4490,
  FileSystemFileHandle = 4510,
  FileSystemHandle = 4531,
  FileSystemSyncAccessHandle = 4548,
  FileSystemWritableFileStream = 4575,
  Flex = 4604,
  FlexItemValues = 4609,
  FlexLineValues = 4624,
  FluentBundle = 4639,
  FluentBundleAsyncIterator = 4652,
  FluentBundleIterator = 4678,
  FluentPattern = 4699,
  FluentResource = 4713,
  FocusEvent = 4728,
  FontFace = 4739,
  FontFaceSet = 4748,
  FontFaceSetIterator = 4760,
  FontFaceSetLoadEvent = 4780,
  FormData = 4801,
  FormData_Iterator = 4810,
  FormDataEvent = 4828,
  FragmentDirective = 4842,
  FrameCrashedEvent = 4860,
  FrameLoader = 4878,
  GPU = 4890,
  GPUAdapter = 4894,
  GPUAdapterInfo = 4905,
  GPUBindGroup = 4920,
  GPUBindGroupLayout = 4933,
  GPUBuffer = 4952,
  GPUBufferUsage = 4962,
  GPUCanvasContext = 4977,
  GPUColorWrite = 4994,
  GPUCommandBuffer = 5008,
  GPUCommandEncoder = 5025,
  GPUCompilationInfo = 5043,
  GPUCompilationMessage = 5062,
  GPUComputePassEncoder = 5084,
  GPUComputePipeline = 5106,
  GPUDevice = 5125,
  GPUDeviceLostInfo = 5135,
  GPUError = 5153,
  GPUExternalTexture = 5162,
  GPUInternalError = 5181,
  GPUMapMode = 5198,
  GPUOutOfMemoryError = 5209,
  GPUPipelineError = 5229,
  GPUPipelineLayout = 5246,
  GPUQuerySet = 5264,
  GPUQueue = 5276,
  GPURenderBundle = 5285,
  GPURenderBundleEncoder = 5301,
  GPURenderPassEncoder = 5324,
  GPURenderPipeline = 5345,
  GPUSampler = 5363,
  GPUShaderModule = 5374,
  GPUShaderStage = 5390,
  GPUSupportedFeatures = 5405,
  GPUSupportedLimits = 5426,
  GPUTexture = 5445,
  GPUTextureUsage = 5456,
  GPUTextureView = 5472,
  GPUUncapturedErrorEvent = 5487,
  GPUValidationError = 5511,
  GainNode = 5530,
  Gamepad = 5539,
  GamepadAxisMoveEvent = 5547,
  GamepadButton = 5568,
  GamepadButtonEvent = 5582,
  GamepadEvent = 5601,
  GamepadHapticActuator = 5614,
  GamepadLightIndicator = 5636,
  GamepadPose = 5658,
  GamepadServiceTest = 5670,
  GamepadTouch = 5689,
  Geolocation = 5702,
  GeolocationCoordinates = 5714,
  GeolocationPosition = 5737,
  GeolocationPositionError = 5757,
  GetUserMediaRequest = 5782,
  GleanBoolean = 5802,
  GleanCategory = 5815,
  GleanCounter = 5829,
  GleanCustomDistribution = 5842,
  GleanDatetime = 5866,
  GleanDenominator = 5880,
  GleanDualLabeledCounter = 5897,
  GleanEvent = 5921,
  GleanImpl = 5932,
  GleanLabeled = 5942,
  GleanMemoryDistribution = 5955,
  GleanMetric = 5979,
  GleanNumerator = 5991,
  GleanObject = 6006,
  GleanPingsImpl = 6018,
  GleanQuantity = 6033,
  GleanRate = 6047,
  GleanString = 6057,
  GleanStringList = 6069,
  GleanText = 6085,
  GleanTimespan = 6095,
  GleanTimingDistribution = 6109,
  GleanUrl = 6133,
  GleanUuid = 6142,
  Grid = 6152,
  GridArea = 6157,
  GridDimension = 6166,
  GridLine = 6180,
  GridLines = 6189,
  GridTrack = 6199,
  GridTracks = 6209,
  HTMLAllCollection = 6220,
  HTMLAnchorElement = 6238,
  HTMLAreaElement = 6256,
  HTMLAudioElement = 6272,
  HTMLBRElement = 6289,
  HTMLBaseElement = 6303,
  HTMLBodyElement = 6319,
  HTMLButtonElement = 6335,
  HTMLCanvasElement = 6353,
  HTMLCollection = 6371,
  HTMLDListElement = 6386,
  HTMLDataElement = 6403,
  HTMLDataListElement = 6419,
  HTMLDetailsElement = 6439,
  HTMLDialogElement = 6458,
  HTMLDirectoryElement = 6476,
  HTMLDivElement = 6497,
  HTMLDocument = 6512,
  HTMLElement = 6525,
  HTMLEmbedElement = 6537,
  HTMLFieldSetElement = 6554,
  HTMLFontElement = 6574,
  HTMLFormControlsCollection = 6590,
  HTMLFormElement = 6617,
  HTMLFrameElement = 6633,
  HTMLFrameSetElement = 6650,
  HTMLHRElement = 6670,
  HTMLHeadElement = 6684,
  HTMLHeadingElement = 6700,
  HTMLHtmlElement = 6719,
  HTMLIFrameElement = 6735,
  HTMLImageElement = 6753,
  HTMLInputElement = 6770,
  HTMLLIElement = 6787,
  HTMLLabelElement = 6801,
  HTMLLegendElement = 6818,
  HTMLLinkElement = 6836,
  HTMLMapElement = 6852,
  HTMLMarqueeElement = 6867,
  HTMLMediaElement = 6886,
  HTMLMenuElement = 6903,
  HTMLMetaElement = 6919,
  HTMLMeterElement = 6935,
  HTMLModElement = 6952,
  HTMLOListElement = 6967,
  HTMLObjectElement = 6984,
  HTMLOptGroupElement = 7002,
  HTMLOptionElement = 7022,
  HTMLOptionsCollection = 7040,
  HTMLOutputElement = 7062,
  HTMLParagraphElement = 7080,
  HTMLParamElement = 7101,
  HTMLPictureElement = 7118,
  HTMLPreElement = 7137,
  HTMLProgressElement = 7152,
  HTMLQuoteElement = 7172,
  HTMLScriptElement = 7189,
  HTMLSelectElement = 7207,
  HTMLSlotElement = 7225,
  HTMLSourceElement = 7241,
  HTMLSpanElement = 7259,
  HTMLStyleElement = 7275,
  HTMLTableCaptionElement = 7292,
  HTMLTableCellElement = 7316,
  HTMLTableColElement = 7337,
  HTMLTableElement = 7357,
  HTMLTableRowElement = 7374,
  HTMLTableSectionElement = 7394,
  HTMLTemplateElement = 7418,
  HTMLTextAreaElement = 7438,
  HTMLTimeElement = 7458,
  HTMLTitleElement = 7474,
  HTMLTrackElement = 7491,
  HTMLUListElement = 7508,
  HTMLUnknownElement = 7525,
  HTMLVideoElement = 7544,
  HashChangeEvent = 7561,
  Headers = 7577,
  Headers_Iterator = 7585,
  HeapSnapshot = 7602,
  Highlight = 7615,
  HighlightRegistry = 7625,
  History = 7643,
  IDBCursor = 7651,
  IDBCursorWithValue = 7661,
  IDBDatabase = 7680,
  IDBFactory = 7692,
  IDBIndex = 7703,
  IDBKeyRange = 7712,
  IDBObjectStore = 7724,
  IDBOpenDBRequest = 7739,
  IDBRequest = 7756,
  IDBTransaction = 7767,
  IDBVersionChangeEvent = 7782,
  IIRFilterNode = 7804,
  IOUtils = 7818,
  IdentityCredential = 7826,
  IdentityProvider = 7845,
  IdleDeadline = 7862,
  Image = 7875,
  ImageBitmap = 7881,
  ImageBitmapRenderingContext = 7893,
  ImageCapture = 7921,
  ImageCaptureError = 7934,
  ImageCaptureErrorEvent = 7952,
  ImageData = 7975,
  ImageDecoder = 7985,
  ImageDocument = 7998,
  ImageTrack = 8012,
  ImageTrackList = 8023,
  InferenceSession = 8038,
  InputEvent = 8055,
  InspectorCSSParser = 8066,
  InspectorFontFace = 8085,
  InspectorUtils = 8103,
  IntersectionObserver = 8118,
  IntersectionObserverEntry = 8139,
  IntlUtils = 8165,
  JSActorTypeUtils = 8175,
  JSProcessActorChild = 8192,
  JSProcessActorParent = 8212,
  JSWindowActorChild = 8233,
  JSWindowActorParent = 8252,
  KeyEvent = 8272,
  KeyboardEvent = 8281,
  KeyframeEffect = 8295,
  L10nFileSource = 8310,
  L10nOverlays = 8325,
  L10nRegistry = 8338,
  LargestContentfulPaint = 8351,
  LegacyMozTCPSocket = 8374,
  LlamaRunner = 8393,
  Localization = 8405,
  Location = 8418,
  Lock = 8427,
  LockManager = 8432,
  MIDIAccess = 8444,
  MIDIConnectionEvent = 8455,
  MIDIInput = 8475,
  MIDIInputMap = 8485,
  MIDIMessageEvent = 8498,
  MIDIOutput = 8515,
  MIDIOutputMap = 8526,
  MIDIPort = 8540,
  MLS = 8549,
  MLSGroupView = 8553,
  MOZ_debug = 8566,
  MatchGlob = 8576,
  MatchPattern = 8586,
  MatchPatternSet = 8599,
  MathMLElement = 8615,
  MediaCapabilities = 8629,
  MediaControlService = 8647,
  MediaController = 8667,
  MediaDeviceInfo = 8683,
  MediaDevices = 8699,
  MediaElementAudioSourceNode = 8712,
  MediaEncryptedEvent = 8740,
  MediaError = 8760,
  MediaKeyError = 8771,
  MediaKeyMessageEvent = 8785,
  MediaKeySession = 8806,
  MediaKeyStatusMap = 8822,
  MediaKeyStatusMap_Iterator = 8840,
  MediaKeySystemAccess = 8867,
  MediaKeys = 8888,
  MediaList = 8898,
  MediaMetadata = 8908,
  MediaQueryList = 8922,
  MediaQueryListEvent = 8937,
  MediaRecorder = 8957,
  MediaRecorderErrorEvent = 8971,
  MediaSession = 8995,
  MediaSource = 9008,
  MediaStream = 9020,
  MediaStreamAudioDestinationNode = 9032,
  MediaStreamAudioSourceNode = 9064,
  MediaStreamError = 9091,
  MediaStreamEvent = 9108,
  MediaStreamTrack = 9125,
  MediaStreamTrackAudioSourceNode = 9142,
  MediaStreamTrackEvent = 9174,
  MerchantValidationEvent = 9196,
  MessageBroadcaster = 9220,
  MessageChannel = 9239,
  MessageEvent = 9254,
  MessageListenerManager = 9267,
  MessagePort = 9290,
  MessageSender = 9302,
  MimeType = 9316,
  MimeTypeArray = 9325,
  MouseEvent = 9339,
  MouseScrollEvent = 9350,
  MozCanvasPrintState = 9367,
  MozDocumentMatcher = 9387,
  MozDocumentObserver = 9406,
  MozQueryInterface = 9426,
  MozSharedMap = 9444,
  MozSharedMap_Iterator = 9457,
  MozSharedMapChangeEvent = 9479,
  MozStorageAsyncStatementParams = 9503,
  MozStorageStatementParams = 9534,
  MozStorageStatementRow = 9560,
  MozWritableSharedMap = 9583,
  MutationObserver = 9604,
  MutationRecord = 9621,
  NamedNodeMap = 9636,
  NavigateEvent = 9649,
  Navigation = 9663,
  NavigationActivation = 9674,
  NavigationCurrentEntryChangeEvent = 9695,
  NavigationDestination = 9729,
  NavigationHistoryEntry = 9751,
  NavigationPrecommitController = 9774,
  NavigationPreloadManager = 9804,
  NavigationTransition = 9829,
  Navigator = 9850,
  NavigatorLogin = 9860,
  NetworkInformation = 9875,
  Node = 9894,
  NodeFilter = 9899,
  NodeIterator = 9910,
  NodeList = 9923,
  Notification = 9932,
  NotificationEvent = 9945,
  NotifyPaintEvent = 9963,
  OES_draw_buffers_indexed = 9980,
  OES_element_index_uint = 10005,
  OES_fbo_render_mipmap = 10028,
  OES_standard_derivatives = 10050,
  OES_texture_float = 10075,
  OES_texture_float_linear = 10093,
  OES_texture_half_float = 10118,
  OES_texture_half_float_linear = 10141,
  OES_vertex_array_object = 10171,
  OVR_multiview2 = 10195,
  OfflineAudioCompletionEvent = 10210,
  OfflineAudioContext = 10238,
  OffscreenCanvas = 10258,
  OffscreenCanvasRenderingContext2D = 10274,
  OnlyForUseInConstructor = 10308,
  Option = 10332,
  OscillatorNode = 10339,
  PageTransitionEvent = 10354,
  PaintRequest = 10374,
  PaintRequestList = 10387,
  PaintWorkletGlobalScope = 10404,
  PannerNode = 10428,
  ParentProcessMessageManager = 10439,
  Path2D = 10467,
  PathUtils = 10474,
  PaymentAddress = 10484,
  PaymentMethodChangeEvent = 10499,
  PaymentRequest = 10524,
  PaymentRequestUpdateEvent = 10539,
  PaymentResponse = 10565,
  PeerConnectionImpl = 10581,
  PeerConnectionObserver = 10600,
  Performance = 10623,
  PerformanceEntry = 10635,
  PerformanceEntryEvent = 10652,
  PerformanceEventTiming = 10674,
  PerformanceMark = 10697,
  PerformanceMeasure = 10713,
  PerformanceNavigation = 10732,
  PerformanceNavigationTiming = 10754,
  PerformanceObserver = 10782,
  PerformanceObserverEntryList = 10802,
  PerformancePaintTiming = 10831,
  PerformanceResourceTiming = 10854,
  PerformanceServerTiming = 10880,
  PerformanceTiming = 10904,
  PeriodicWave = 10922,
  PermissionStatus = 10935,
  Permissions = 10952,
  PlacesBookmark = 10964,
  PlacesBookmarkAddition = 10979,
  PlacesBookmarkChanged = 11002,
  PlacesBookmarkGuid = 11024,
  PlacesBookmarkKeyword = 11043,
  PlacesBookmarkMoved = 11065,
  PlacesBookmarkRemoved = 11085,
  PlacesBookmarkTags = 11107,
  PlacesBookmarkTime = 11126,
  PlacesBookmarkTitle = 11145,
  PlacesBookmarkUrl = 11165,
  PlacesEvent = 11183,
  PlacesEventCounts = 11195,
  PlacesFavicon = 11213,
  PlacesHistoryCleared = 11227,
  PlacesObservers = 11248,
  PlacesPurgeCaches = 11264,
  PlacesRanking = 11282,
  PlacesVisit = 11296,
  PlacesVisitRemoved = 11308,
  PlacesVisitTitle = 11327,
  PlacesWeakCallbackWrapper = 11344,
  Plugin = 11370,
  PluginArray = 11377,
  PluginCrashedEvent = 11389,
  PointerEvent = 11408,
  PopStateEvent = 11421,
  PopupBlockedEvent = 11435,
  PopupPositionedEvent = 11453,
  PositionStateEvent = 11474,
  PrecompiledScript = 11493,
  PrivateAttribution = 11511,
  ProcessMessageManager = 11530,
  ProcessingInstruction = 11552,
  ProgressEvent = 11574,
  PromiseDebugging = 11588,
  PromiseNativeHandler = 11605,
  PromiseRejectionEvent = 11626,
  PublicKeyCredential = 11648,
  PushEvent = 11668,
  PushManager = 11678,
  PushManagerImpl = 11690,
  PushMessageData = 11706,
  PushSubscription = 11722,
  PushSubscriptionChangeEvent = 11739,
  PushSubscriptionOptions = 11767,
  RTCCertificate = 11791,
  RTCDTMFSender = 11806,
  RTCDTMFToneChangeEvent = 11820,
  RTCDataChannel = 11843,
  RTCDataChannelEvent = 11858,
  RTCDtlsTransport = 11878,
  RTCEncodedAudioFrame = 11895,
  RTCEncodedVideoFrame = 11916,
  RTCIceCandidate = 11937,
  RTCIceTransport = 11953,
  RTCIdentityProviderRegistrar = 11969,
  RTCPeerConnection = 11998,
  RTCPeerConnectionIceEvent = 12016,
  RTCPeerConnectionStatic = 12042,
  RTCRtpReceiver = 12066,
  RTCRtpScriptTransform = 12081,
  RTCRtpScriptTransformer = 12103,
  RTCRtpSender = 12127,
  RTCRtpTransceiver = 12140,
  RTCSctpTransport = 12158,
  RTCSessionDescription = 12175,
  RTCStatsReport = 12197,
  RTCTrackEvent = 12212,
  RTCTransformEvent = 12226,
  RadioNodeList = 12244,
  Range = 12258,
  ReadableByteStreamController = 12264,
  ReadableStream = 12293,
  ReadableStream_AsyncIterator = 12308,
  ReadableStreamBYOBReader = 12337,
  ReadableStreamBYOBRequest = 12362,
  ReadableStreamDefaultController = 12388,
  ReadableStreamDefaultReader = 12420,
  RedirectBlockedEvent = 12448,
  Report = 12469,
  ReportBody = 12476,
  ReportingObserver = 12487,
  Request = 12505,
  ResizeObserver = 12513,
  ResizeObserverEntry = 12528,
  ResizeObserverSize = 12548,
  Response = 12567,
  SVGAElement = 12576,
  SVGAngle = 12588,
  SVGAnimateElement = 12597,
  SVGAnimateMotionElement = 12615,
  SVGAnimateTransformElement = 12639,
  SVGAnimatedAngle = 12666,
  SVGAnimatedBoolean = 12683,
  SVGAnimatedEnumeration = 12702,
  SVGAnimatedInteger = 12725,
  SVGAnimatedLength = 12744,
  SVGAnimatedLengthList = 12762,
  SVGAnimatedNumber = 12784,
  SVGAnimatedNumberList = 12802,
  SVGAnimatedPreserveAspectRatio = 12824,
  SVGAnimatedRect = 12855,
  SVGAnimatedString = 12871,
  SVGAnimatedTransformList = 12889,
  SVGAnimationElement = 12914,
  SVGCircleElement = 12934,
  SVGClipPathElement = 12951,
  SVGComponentTransferFunctionElement = 12970,
  SVGDefsElement = 13006,
  SVGDescElement = 13021,
  SVGElement = 13036,
  SVGEllipseElement = 13047,
  SVGFEBlendElement = 13065,
  SVGFEColorMatrixElement = 13083,
  SVGFEComponentTransferElement = 13107,
  SVGFECompositeElement = 13137,
  SVGFEConvolveMatrixElement = 13159,
  SVGFEDiffuseLightingElement = 13186,
  SVGFEDisplacementMapElement = 13214,
  SVGFEDistantLightElement = 13242,
  SVGFEDropShadowElement = 13267,
  SVGFEFloodElement = 13290,
  SVGFEFuncAElement = 13308,
  SVGFEFuncBElement = 13326,
  SVGFEFuncGElement = 13344,
  SVGFEFuncRElement = 13362,
  SVGFEGaussianBlurElement = 13380,
  SVGFEImageElement = 13405,
  SVGFEMergeElement = 13423,
  SVGFEMergeNodeElement = 13441,
  SVGFEMorphologyElement = 13463,
  SVGFEOffsetElement = 13486,
  SVGFEPointLightElement = 13505,
  SVGFESpecularLightingElement = 13528,
  SVGFESpotLightElement = 13557,
  SVGFETileElement = 13579,
  SVGFETurbulenceElement = 13596,
  SVGFilterElement = 13619,
  SVGForeignObjectElement = 13636,
  SVGGElement = 13660,
  SVGGeometryElement = 13672,
  SVGGradientElement = 13691,
  SVGGraphicsElement = 13710,
  SVGImageElement = 13729,
  SVGLength = 13745,
  SVGLengthList = 13755,
  SVGLineElement = 13769,
  SVGLinearGradientElement = 13784,
  SVGMPathElement = 13809,
  SVGMarkerElement = 13825,
  SVGMaskElement = 13842,
  SVGMatrix = 13857,
  SVGMetadataElement = 13867,
  SVGNumber = 13886,
  SVGNumberList = 13896,
  SVGPathElement = 13910,
  SVGPathSegment = 13925,
  SVGPatternElement = 13940,
  SVGPoint = 13958,
  SVGPointList = 13967,
  SVGPolygonElement = 13980,
  SVGPolylineElement = 13998,
  SVGPreserveAspectRatio = 14017,
  SVGRadialGradientElement = 14040,
  SVGRect = 14065,
  SVGRectElement = 14073,
  SVGSVGElement = 14088,
  SVGScriptElement = 14102,
  SVGSetElement = 14119,
  SVGStopElement = 14133,
  SVGStringList = 14148,
  SVGStyleElement = 14162,
  SVGSwitchElement = 14178,
  SVGSymbolElement = 14195,
  SVGTSpanElement = 14212,
  SVGTextContentElement = 14228,
  SVGTextElement = 14250,
  SVGTextPathElement = 14265,
  SVGTextPositioningElement = 14284,
  SVGTitleElement = 14310,
  SVGTransform = 14326,
  SVGTransformList = 14339,
  SVGUnitTypes = 14356,
  SVGUseElement = 14369,
  SVGViewElement = 14383,
  Sanitizer = 14398,
  Scheduler = 14408,
  Screen = 14418,
  ScreenLuminance = 14425,
  ScreenOrientation = 14441,
  ScriptProcessorNode = 14459,
  ScrollAreaEvent = 14479,
  SecurityPolicyViolationEvent = 14495,
  Selection = 14524,
  ServiceWorker = 14534,
  ServiceWorkerContainer = 14548,
  ServiceWorkerGlobalScope = 14571,
  ServiceWorkerRegistration = 14596,
  SessionStoreFormData = 14622,
  SessionStoreScrollData = 14643,
  SessionStoreUtils = 14666,
  ShadowRealmGlobalScope = 14684,
  ShadowRoot = 14707,
  SharedWorker = 14718,
  SharedWorkerGlobalScope = 14731,
  SimpleGestureEvent = 14755,
  SourceBuffer = 14774,
  SourceBufferList = 14787,
  SpeechGrammar = 14804,
  SpeechGrammarList = 14818,
  SpeechRecognition = 14836,
  SpeechRecognitionAlternative = 14854,
  SpeechRecognitionError = 14883,
  SpeechRecognitionEvent = 14906,
  SpeechRecognitionResult = 14929,
  SpeechRecognitionResultList = 14953,
  SpeechSynthesis = 14981,
  SpeechSynthesisErrorEvent = 14997,
  SpeechSynthesisEvent = 15023,
  SpeechSynthesisUtterance = 15044,
  SpeechSynthesisVoice = 15069,
  StaticRange = 15090,
  StereoPannerNode = 15102,
  Storage = 15119,
  StorageEvent = 15127,
  StorageManager = 15140,
  StreamFilter = 15155,
  StreamFilterDataEvent = 15168,
  StructuredCloneHolder = 15190,
  StructuredCloneTester = 15212,
  StylePropertyMap = 15234,
  StylePropertyMapReadOnly = 15251,
  StylePropertyMapReadOnly_Iterator = 15276,
  StyleSheet = 15310,
  StyleSheetApplicableStateChangeEvent = 15321,
  StyleSheetList = 15358,
  StyleSheetRemovedEvent = 15373,
  SubmitEvent = 15396,
  SubtleCrypto = 15408,
  SyncMessageSender = 15421,
  SyncReadFile = 15439,
  TCPServerSocket = 15452,
  TCPServerSocketEvent = 15468,
  TCPSocket = 15489,
  TCPSocketErrorEvent = 15499,
  TCPSocketEvent = 15519,
  TaskController = 15534,
  TaskPriorityChangeEvent = 15549,
  TaskSignal = 15573,
  Tensor = 15584,
  TestAttributesOnTypes = 15591,
  TestCEReactionsInterface = 15613,
  TestCImplementedInterface = 15638,
  TestCImplementedInterface2 = 15664,
  TestCallbackDictUnionOverload = 15691,
  TestChildInterface = 15721,
  TestConstructorForFuncInterface = 15740,
  TestConstructorForPrefInterface = 15772,
  TestConstructorForSCInterface = 15804,
  TestCppKeywordNamedMethodsInterface = 15834,
  TestDeprecatedInterface = 15870,
  TestExampleInterface = 15894,
  TestExampleProxyInterface = 15915,
  TestExampleThrowingConstructorInterface = 15941,
  TestExampleWorkerInterface = 15981,
  TestFuncConstructorForDifferentFuncInterface = 16008,
  TestFuncConstructorForInterface = 16053,
  TestHTMLConstructorInterface = 16085,
  TestIndexedAndNamedGetterAndSetterInterface = 16114,
  TestIndexedAndNamedGetterInterface = 16158,
  TestIndexedAndNamedSetterInterface = 16193,
  TestIndexedGetterAndSetterAndNamedGetterInterface = 16228,
  TestIndexedGetterInterface = 16278,
  TestIndexedSetterInterface = 16305,
  TestInterface = 16332,
  TestInterfaceWithPromiseConstructorArg = 16346,
  TestJSImplInterface = 16385,
  TestJSImplInterface2 = 16405,
  TestJSImplInterface3 = 16426,
  TestJSImplInterface4 = 16447,
  TestJSImplInterface5 = 16468,
  TestJSImplInterface6 = 16489,
  TestJSImplNoInterfaceObject = 16510,
  TestLegacyFactoryFunctionInterface = 16538,
  TestLegacyFactoryFunctionInterface2 = 16573,
  TestNamedDeleterInterface = 16609,
  TestNamedDeleterWithRetvalInterface = 16635,
  TestNamedGetterInterface = 16671,
  TestNamedSetterInterface = 16696,
  TestNamespace = 16721,
  TestNonWrapperCacheInterface = 16735,
  TestParentInterface = 16764,
  TestPrefChromeOnlySCFuncConstructorForInterface = 16784,
  TestPrefConstructorForDifferentPrefInterface = 16832,
  TestPrefConstructorForInterface = 16877,
  TestProtoObjectHackedNamespace = 16909,
  TestRenamedInterface = 16940,
  TestRenamedNamespace = 16961,
  TestSCConstructorForInterface = 16982,
  TestSecureContextInterface = 17012,
  TestThrowingConstructorInterface = 17039,
  TestUtils = 17072,
  TestWorkerExposedInterface = 17082,
  TestingDeprecatedInterface = 17109,
  Text = 17136,
  TextClause = 17141,
  TextDecoder = 17152,
  TextDecoderStream = 17164,
  TextEncoder = 17182,
  TextEncoderStream = 17194,
  TextEvent = 17212,
  TextMetrics = 17222,
  TextTrack = 17234,
  TextTrackCue = 17244,
  TextTrackCueList = 17257,
  TextTrackList = 17274,
  TimeEvent = 17288,
  TimeRanges = 17298,
  ToggleEvent = 17309,
  Touch = 17321,
  TouchEvent = 17327,
  TouchList = 17338,
  TrackEvent = 17348,
  TransformStream = 17359,
  TransformStreamDefaultController = 17375,
  TransitionEvent = 17408,
  TreeColumn = 17424,
  TreeColumns = 17435,
  TreeContentView = 17447,
  TreeWalker = 17463,
  TrustedHTML = 17474,
  TrustedScript = 17486,
  TrustedScriptURL = 17500,
  TrustedTypePolicy = 17517,
  TrustedTypePolicyFactory = 17535,
  UDPMessageEvent = 17560,
  UDPSocket = 17576,
  UIEvent = 17586,
  URL = 17594,
  URLPattern = 17598,
  URLSearchParams = 17609,
  URLSearchParams_Iterator = 17625,
  UniFFIPointer = 17650,
  UniFFIScaffolding = 17664,
  UserActivation = 17682,
  UserInteraction = 17697,
  UserProximityEvent = 17713,
  VRDisplay = 17732,
  VRDisplayCapabilities = 17742,
  VRDisplayEvent = 17764,
  VREyeParameters = 17779,
  VRFieldOfView = 17795,
  VRFrameData = 17809,
  VRMockController = 17821,
  VRMockDisplay = 17838,
  VRPose = 17852,
  VRServiceTest = 17859,
  VRStageParameters = 17873,
  VTTCue = 17891,
  VTTRegion = 17898,
  ValidityState = 17908,
  VideoColorSpace = 17922,
  VideoDecoder = 17938,
  VideoEncoder = 17951,
  VideoFrame = 17964,
  VideoPlaybackQuality = 17975,
  VideoTrack = 17996,
  VideoTrackList = 18007,
  ViewTransition = 18022,
  ViewTransitionTypeSet = 18037,
  VisualViewport = 18059,
  WEBGL_color_buffer_float = 18074,
  WEBGL_compressed_texture_astc = 18099,
  WEBGL_compressed_texture_etc = 18129,
  WEBGL_compressed_texture_etc1 = 18158,
  WEBGL_compressed_texture_pvrtc = 18188,
  WEBGL_compressed_texture_s3tc = 18219,
  WEBGL_compressed_texture_s3tc_srgb = 18249,
  WEBGL_debug_renderer_info = 18284,
  WEBGL_debug_shaders = 18310,
  WEBGL_depth_texture = 18330,
  WEBGL_draw_buffers = 18350,
  WEBGL_explicit_present = 18369,
  WEBGL_lose_context = 18392,
  WEBGL_provoking_vertex = 18411,
  WGSLLanguageFeatures = 18434,
  WakeLock = 18455,
  WakeLockSentinel = 18464,
  WaveShaperNode = 18481,
  WebExtensionContentScript = 18496,
  WebExtensionPolicy = 18522,
  WebGL2RenderingContext = 18541,
  WebGLActiveInfo = 18564,
  WebGLBuffer = 18580,
  WebGLContextEvent = 18592,
  WebGLFramebuffer = 18610,
  WebGLProgram = 18627,
  WebGLQuery = 18640,
  WebGLRenderbuffer = 18651,
  WebGLRenderingContext = 18669,
  WebGLSampler = 18691,
  WebGLShader = 18704,
  WebGLShaderPrecisionFormat = 18716,
  WebGLSync = 18743,
  WebGLTexture = 18753,
  WebGLTransformFeedback = 18766,
  WebGLUniformLocation = 18789,
  WebGLVertexArrayObject = 18810,
  WebKitCSSMatrix = 18833,
  WebSocket = 18849,
  WebTransport = 18859,
  WebTransportBidirectionalStream = 18872,
  WebTransportDatagramDuplexStream = 18904,
  WebTransportError = 18937,
  WebTransportReceiveStream = 18955,
  WebTransportSendStream = 18981,
  WebrtcGlobalInformation = 19004,
  WheelEvent = 19028,
  Window = 19039,
  WindowClient = 19046,
  WindowContext = 19059,
  WindowGlobalChild = 19073,
  WindowGlobalParent = 19091,
  WindowRoot = 19110,
  Worker = 19121,
  WorkerDebuggerGlobalScope = 19128,
  WorkerGlobalScope = 19154,
  WorkerLocation = 19172,
  WorkerNavigator = 19187,
  WorkerTestUtils = 19203,
  Worklet = 19219,
  WorkletGlobalScope = 19227,
  WritableStream = 19246,
  WritableStreamDefaultController = 19261,
  WritableStreamDefaultWriter = 19293,
  XMLDocument = 19321,
  XMLHttpRequest = 19333,
  XMLHttpRequestEventTarget = 19348,
  XMLHttpRequestUpload = 19374,
  XMLSerializer = 19395,
  XPathEvaluator = 19409,
  XPathExpression = 19424,
  XPathResult = 19440,
  XRBoundedReferenceSpace = 19452,
  XRFrame = 19476,
  XRInputSource = 19484,
  XRInputSourceArray = 19498,
  XRInputSourceEvent = 19517,
  XRInputSourcesChangeEvent = 19536,
  XRPose = 19562,
  XRReferenceSpace = 19569,
  XRReferenceSpaceEvent = 19586,
  XRRenderState = 19608,
  XRRigidTransform = 19622,
  XRSession = 19639,
  XRSessionEvent = 19649,
  XRSpace = 19664,
  XRSystem = 19672,
  XRView = 19681,
  XRViewerPose = 19688,
  XRViewport = 19701,
  XRWebGLLayer = 19712,
  XSLTProcessor = 19725,
  XULCommandEvent = 19739,
  XULElement = 19755,
  XULFrameElement = 19766,
  XULMenuElement = 19782,
  XULPopupElement = 19797,
  XULResizerElement = 19813,
  XULTextElement = 19831,
  XULTreeElement = 19846,
  console = 19861,
  webkitSpeechGrammar = 19869,
  webkitSpeechGrammarList = 19889,
  webkitSpeechRecognition = 19913,
  webkitURL = 19937,
};

namespace binding_detail {
extern const char sBindingNames[];
}  // namespace binding_detail

MOZ_ALWAYS_INLINE const char* BindingName(BindingNamesOffset aOffset) {
  return binding_detail::sBindingNames + static_cast<size_t>(aOffset);
}

} // namespace mozilla::dom


#endif // DOM_BINDINGNAMES_H_
