/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	apisv1 "sigs.k8s.io/gateway-api/apis/v1"
)

// ListenerTLSConfigApplyConfiguration represents a declarative configuration of the ListenerTLSConfig type for use
// with apply.
type ListenerTLSConfigApplyConfiguration struct {
	Mode            *apisv1.TLSModeType                             `json:"mode,omitempty"`
	CertificateRefs []SecretObjectReferenceApplyConfiguration       `json:"certificateRefs,omitempty"`
	Options         map[apisv1.AnnotationKey]apisv1.AnnotationValue `json:"options,omitempty"`
}

// ListenerTLSConfigApplyConfiguration constructs a declarative configuration of the ListenerTLSConfig type for use with
// apply.
func ListenerTLSConfig() *ListenerTLSConfigApplyConfiguration {
	return &ListenerTLSConfigApplyConfiguration{}
}

// WithMode sets the Mode field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Mode field is set to the value of the last call.
func (b *ListenerTLSConfigApplyConfiguration) WithMode(value apisv1.TLSModeType) *ListenerTLSConfigApplyConfiguration {
	b.Mode = &value
	return b
}

// WithCertificateRefs adds the given value to the CertificateRefs field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the CertificateRefs field.
func (b *ListenerTLSConfigApplyConfiguration) WithCertificateRefs(values ...*SecretObjectReferenceApplyConfiguration) *ListenerTLSConfigApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithCertificateRefs")
		}
		b.CertificateRefs = append(b.CertificateRefs, *values[i])
	}
	return b
}

// WithOptions puts the entries into the Options field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Options field,
// overwriting an existing map entries in Options field with the same key.
func (b *ListenerTLSConfigApplyConfiguration) WithOptions(entries map[apisv1.AnnotationKey]apisv1.AnnotationValue) *ListenerTLSConfigApplyConfiguration {
	if b.Options == nil && len(entries) > 0 {
		b.Options = make(map[apisv1.AnnotationKey]apisv1.AnnotationValue, len(entries))
	}
	for k, v := range entries {
		b.Options[k] = v
	}
	return b
}
