//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/imaging/hd/basisCurvesTopologySchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"
#include "pxr/imaging/hd/basisCurvesSchema.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdBasisCurvesTopologySchemaTokens,
    HD_BASIS_CURVES_TOPOLOGY_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdIntArrayDataSourceHandle
HdBasisCurvesTopologySchema::GetCurveVertexCounts() const
{
    return _GetTypedDataSource<HdIntArrayDataSource>(
        HdBasisCurvesTopologySchemaTokens->curveVertexCounts);
}

HdIntArrayDataSourceHandle
HdBasisCurvesTopologySchema::GetCurveIndices() const
{
    return _GetTypedDataSource<HdIntArrayDataSource>(
        HdBasisCurvesTopologySchemaTokens->curveIndices);
}

HdTokenDataSourceHandle
HdBasisCurvesTopologySchema::GetBasis() const
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdBasisCurvesTopologySchemaTokens->basis);
}

HdTokenDataSourceHandle
HdBasisCurvesTopologySchema::GetType() const
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdBasisCurvesTopologySchemaTokens->type);
}

HdTokenDataSourceHandle
HdBasisCurvesTopologySchema::GetWrap() const
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdBasisCurvesTopologySchemaTokens->wrap);
}

/*static*/
HdContainerDataSourceHandle
HdBasisCurvesTopologySchema::BuildRetained(
        const HdIntArrayDataSourceHandle &curveVertexCounts,
        const HdIntArrayDataSourceHandle &curveIndices,
        const HdTokenDataSourceHandle &basis,
        const HdTokenDataSourceHandle &type,
        const HdTokenDataSourceHandle &wrap
)
{
    TfToken _names[5];
    HdDataSourceBaseHandle _values[5];

    size_t _count = 0;

    if (curveVertexCounts) {
        _names[_count] = HdBasisCurvesTopologySchemaTokens->curveVertexCounts;
        _values[_count++] = curveVertexCounts;
    }

    if (curveIndices) {
        _names[_count] = HdBasisCurvesTopologySchemaTokens->curveIndices;
        _values[_count++] = curveIndices;
    }

    if (basis) {
        _names[_count] = HdBasisCurvesTopologySchemaTokens->basis;
        _values[_count++] = basis;
    }

    if (type) {
        _names[_count] = HdBasisCurvesTopologySchemaTokens->type;
        _values[_count++] = type;
    }

    if (wrap) {
        _names[_count] = HdBasisCurvesTopologySchemaTokens->wrap;
        _values[_count++] = wrap;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdBasisCurvesTopologySchema::Builder &
HdBasisCurvesTopologySchema::Builder::SetCurveVertexCounts(
    const HdIntArrayDataSourceHandle &curveVertexCounts)
{
    _curveVertexCounts = curveVertexCounts;
    return *this;
}

HdBasisCurvesTopologySchema::Builder &
HdBasisCurvesTopologySchema::Builder::SetCurveIndices(
    const HdIntArrayDataSourceHandle &curveIndices)
{
    _curveIndices = curveIndices;
    return *this;
}

HdBasisCurvesTopologySchema::Builder &
HdBasisCurvesTopologySchema::Builder::SetBasis(
    const HdTokenDataSourceHandle &basis)
{
    _basis = basis;
    return *this;
}

HdBasisCurvesTopologySchema::Builder &
HdBasisCurvesTopologySchema::Builder::SetType(
    const HdTokenDataSourceHandle &type)
{
    _type = type;
    return *this;
}

HdBasisCurvesTopologySchema::Builder &
HdBasisCurvesTopologySchema::Builder::SetWrap(
    const HdTokenDataSourceHandle &wrap)
{
    _wrap = wrap;
    return *this;
}

HdContainerDataSourceHandle
HdBasisCurvesTopologySchema::Builder::Build()
{
    return HdBasisCurvesTopologySchema::BuildRetained(
        _curveVertexCounts,
        _curveIndices,
        _basis,
        _type,
        _wrap
    );
}

/*static*/
HdBasisCurvesTopologySchema
HdBasisCurvesTopologySchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return HdBasisCurvesTopologySchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                HdBasisCurvesTopologySchemaTokens->topology))
        : nullptr);
}

/*static*/
const TfToken &
HdBasisCurvesTopologySchema::GetSchemaToken()
{
    return HdBasisCurvesTopologySchemaTokens->topology;
}

/*static*/
const HdDataSourceLocator &
HdBasisCurvesTopologySchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator =
        HdBasisCurvesSchema::GetDefaultLocator().Append(GetSchemaToken());
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE