//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/imaging/hd/materialInterfaceParameterSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdMaterialInterfaceParameterSchemaTokens,
    HD_MATERIAL_INTERFACE_PARAMETER_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--
// --(END CUSTOM CODE: Schema Methods)--

HdTokenDataSourceHandle
HdMaterialInterfaceParameterSchema::GetDisplayGroup() const
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdMaterialInterfaceParameterSchemaTokens->displayGroup);
}

HdTokenDataSourceHandle
HdMaterialInterfaceParameterSchema::GetDisplayName() const
{
    return _GetTypedDataSource<HdTokenDataSource>(
        HdMaterialInterfaceParameterSchemaTokens->displayName);
}

HdMaterialInterfaceMappingVectorSchema
HdMaterialInterfaceParameterSchema::GetMappings() const
{
    return HdMaterialInterfaceMappingVectorSchema(_GetTypedDataSource<HdVectorDataSource>(
        HdMaterialInterfaceParameterSchemaTokens->mappings));
}

/*static*/
HdContainerDataSourceHandle
HdMaterialInterfaceParameterSchema::BuildRetained(
        const HdTokenDataSourceHandle &displayGroup,
        const HdTokenDataSourceHandle &displayName,
        const HdVectorDataSourceHandle &mappings
)
{
    TfToken _names[3];
    HdDataSourceBaseHandle _values[3];

    size_t _count = 0;

    if (displayGroup) {
        _names[_count] = HdMaterialInterfaceParameterSchemaTokens->displayGroup;
        _values[_count++] = displayGroup;
    }

    if (displayName) {
        _names[_count] = HdMaterialInterfaceParameterSchemaTokens->displayName;
        _values[_count++] = displayName;
    }

    if (mappings) {
        _names[_count] = HdMaterialInterfaceParameterSchemaTokens->mappings;
        _values[_count++] = mappings;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdMaterialInterfaceParameterSchema::Builder &
HdMaterialInterfaceParameterSchema::Builder::SetDisplayGroup(
    const HdTokenDataSourceHandle &displayGroup)
{
    _displayGroup = displayGroup;
    return *this;
}

HdMaterialInterfaceParameterSchema::Builder &
HdMaterialInterfaceParameterSchema::Builder::SetDisplayName(
    const HdTokenDataSourceHandle &displayName)
{
    _displayName = displayName;
    return *this;
}

HdMaterialInterfaceParameterSchema::Builder &
HdMaterialInterfaceParameterSchema::Builder::SetMappings(
    const HdVectorDataSourceHandle &mappings)
{
    _mappings = mappings;
    return *this;
}

HdContainerDataSourceHandle
HdMaterialInterfaceParameterSchema::Builder::Build()
{
    return HdMaterialInterfaceParameterSchema::BuildRetained(
        _displayGroup,
        _displayName,
        _mappings
    );
} 

PXR_NAMESPACE_CLOSE_SCOPE