/** @file
 * VirtualBox API class wrapper code for IPlatformProperties.
 *
 * DO NOT EDIT! This is a generated file.
 * Generated from: src/VBox/Main/idl/VirtualBox.xidl
 * Generator: src/VBox/Main/idl/apiwrap-server.xsl
 */

/*
 * Copyright (C) 2010-2026 Oracle and/or its affiliates.
 *
 * This file is part of VirtualBox base platform packages, as
 * available from https://www.virtualbox.org.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation, in version 3 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <https://www.gnu.org/licenses>.
 *
 * SPDX-License-Identifier: GPL-3.0-only
 */

#define LOG_GROUP LOG_GROUP_MAIN_PLATFORMPROPERTIES

#include "PlatformPropertiesWrap.h"
#include "LoggingNew.h"
#ifdef VBOX_WITH_DTRACE_R3_MAIN
# include "dtrace/VBoxAPI.h"
#endif

DEFINE_EMPTY_CTOR_DTOR(PlatformPropertiesWrap)

//
// IPlatformProperties properties
//

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(RawModeSupported)(BOOL *aRawModeSupported)
{
    LogRelFlow(("{%p} %s: enter aRawModeSupported=%p\n", this, "PlatformProperties::getRawModeSupported", aRawModeSupported));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aRawModeSupported);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_RAWMODESUPPORTED_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getRawModeSupported(aRawModeSupported);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_RAWMODESUPPORTED_RETURN(this, hrc, 0 /*normal*/,*aRawModeSupported != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_RAWMODESUPPORTED_RETURN(this, hrc, 1 /*hrc exception*/,*aRawModeSupported != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_RAWMODESUPPORTED_RETURN(this, hrc, 9 /*unhandled exception*/,*aRawModeSupported != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aRawModeSupported=%RTbool hrc=%Rhrc\n", this, "PlatformProperties::getRawModeSupported", *aRawModeSupported, hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(ExclusiveHwVirt)(BOOL *aExclusiveHwVirt)
{
    LogRelFlow(("{%p} %s: enter aExclusiveHwVirt=%p\n", this, "PlatformProperties::getExclusiveHwVirt", aExclusiveHwVirt));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aExclusiveHwVirt);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_EXCLUSIVEHWVIRT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getExclusiveHwVirt(aExclusiveHwVirt);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_EXCLUSIVEHWVIRT_RETURN(this, hrc, 0 /*normal*/,*aExclusiveHwVirt != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_EXCLUSIVEHWVIRT_RETURN(this, hrc, 1 /*hrc exception*/,*aExclusiveHwVirt != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_EXCLUSIVEHWVIRT_RETURN(this, hrc, 9 /*unhandled exception*/,*aExclusiveHwVirt != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aExclusiveHwVirt=%RTbool hrc=%Rhrc\n", this, "PlatformProperties::getExclusiveHwVirt", *aExclusiveHwVirt, hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::COMSETTER(ExclusiveHwVirt)(BOOL aExclusiveHwVirt)
{
    LogRelFlow(("{%p} %s: enter aExclusiveHwVirt=%RTbool\n", this, "PlatformProperties::setExclusiveHwVirt", aExclusiveHwVirt));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_SET_EXCLUSIVEHWVIRT_ENTER(this, aExclusiveHwVirt != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = setExclusiveHwVirt(aExclusiveHwVirt != FALSE);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_SET_EXCLUSIVEHWVIRT_RETURN(this, hrc, 0 /*normal*/,aExclusiveHwVirt != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_SET_EXCLUSIVEHWVIRT_RETURN(this, hrc, 1 /*hrc exception*/,aExclusiveHwVirt != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_SET_EXCLUSIVEHWVIRT_RETURN(this, hrc, 9 /*unhandled exception*/,aExclusiveHwVirt != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave hrc=%Rhrc\n", this, "PlatformProperties::setExclusiveHwVirt", hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(SerialPortCount)(ULONG *aSerialPortCount)
{
    LogRelFlow(("{%p} %s: enter aSerialPortCount=%p\n", this, "PlatformProperties::getSerialPortCount", aSerialPortCount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSerialPortCount);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SERIALPORTCOUNT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSerialPortCount(aSerialPortCount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SERIALPORTCOUNT_RETURN(this, hrc, 0 /*normal*/,*aSerialPortCount);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SERIALPORTCOUNT_RETURN(this, hrc, 1 /*hrc exception*/,*aSerialPortCount);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SERIALPORTCOUNT_RETURN(this, hrc, 9 /*unhandled exception*/,*aSerialPortCount);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSerialPortCount=%RU32 hrc=%Rhrc\n", this, "PlatformProperties::getSerialPortCount", *aSerialPortCount, hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(ParallelPortCount)(ULONG *aParallelPortCount)
{
    LogRelFlow(("{%p} %s: enter aParallelPortCount=%p\n", this, "PlatformProperties::getParallelPortCount", aParallelPortCount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aParallelPortCount);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_PARALLELPORTCOUNT_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getParallelPortCount(aParallelPortCount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_PARALLELPORTCOUNT_RETURN(this, hrc, 0 /*normal*/,*aParallelPortCount);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_PARALLELPORTCOUNT_RETURN(this, hrc, 1 /*hrc exception*/,*aParallelPortCount);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_PARALLELPORTCOUNT_RETURN(this, hrc, 9 /*unhandled exception*/,*aParallelPortCount);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aParallelPortCount=%RU32 hrc=%Rhrc\n", this, "PlatformProperties::getParallelPortCount", *aParallelPortCount, hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(MaxBootPosition)(ULONG *aMaxBootPosition)
{
    LogRelFlow(("{%p} %s: enter aMaxBootPosition=%p\n", this, "PlatformProperties::getMaxBootPosition", aMaxBootPosition));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMaxBootPosition);
        
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_MAXBOOTPOSITION_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMaxBootPosition(aMaxBootPosition);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_MAXBOOTPOSITION_RETURN(this, hrc, 0 /*normal*/,*aMaxBootPosition);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_MAXBOOTPOSITION_RETURN(this, hrc, 1 /*hrc exception*/,*aMaxBootPosition);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_MAXBOOTPOSITION_RETURN(this, hrc, 9 /*unhandled exception*/,*aMaxBootPosition);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMaxBootPosition=%RU32 hrc=%Rhrc\n", this, "PlatformProperties::getMaxBootPosition", *aMaxBootPosition, hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(SupportedParavirtProviders)(ComSafeArrayOut(ParavirtProvider_T, aSupportedParavirtProviders))
{
    LogRelFlow(("{%p} %s: enter aSupportedParavirtProviders=%p\n", this, "PlatformProperties::getSupportedParavirtProviders", aSupportedParavirtProviders));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedParavirtProviders);
        ArrayOutConverter<ParavirtProvider_T> TmpSupportedParavirtProviders(ComSafeArrayOutArg(aSupportedParavirtProviders));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDPARAVIRTPROVIDERS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedParavirtProviders(TmpSupportedParavirtProviders.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDPARAVIRTPROVIDERS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedParavirtProviders.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDPARAVIRTPROVIDERS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDPARAVIRTPROVIDERS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedParavirtProviders=%zu hrc=%Rhrc\n", this, "PlatformProperties::getSupportedParavirtProviders", ComSafeArraySize(*aSupportedParavirtProviders), hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(SupportedFirmwareTypes)(ComSafeArrayOut(FirmwareType_T, aSupportedFirmwareTypes))
{
    LogRelFlow(("{%p} %s: enter aSupportedFirmwareTypes=%p\n", this, "PlatformProperties::getSupportedFirmwareTypes", aSupportedFirmwareTypes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedFirmwareTypes);
        ArrayOutConverter<FirmwareType_T> TmpSupportedFirmwareTypes(ComSafeArrayOutArg(aSupportedFirmwareTypes));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDFIRMWARETYPES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedFirmwareTypes(TmpSupportedFirmwareTypes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDFIRMWARETYPES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedFirmwareTypes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDFIRMWARETYPES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDFIRMWARETYPES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedFirmwareTypes=%zu hrc=%Rhrc\n", this, "PlatformProperties::getSupportedFirmwareTypes", ComSafeArraySize(*aSupportedFirmwareTypes), hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(SupportedGuestOSTypes)(ComSafeArrayOut(IGuestOSType *, aSupportedGuestOSTypes))
{
    LogRelFlow(("{%p} %s: enter aSupportedGuestOSTypes=%p\n", this, "PlatformProperties::getSupportedGuestOSTypes", aSupportedGuestOSTypes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedGuestOSTypes);
        ArrayComTypeOutConverter<IGuestOSType> TmpSupportedGuestOSTypes(ComSafeArrayOutArg(aSupportedGuestOSTypes));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDGUESTOSTYPES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedGuestOSTypes(TmpSupportedGuestOSTypes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDGUESTOSTYPES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedGuestOSTypes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDGUESTOSTYPES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDGUESTOSTYPES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedGuestOSTypes=%zu hrc=%Rhrc\n", this, "PlatformProperties::getSupportedGuestOSTypes", ComSafeArraySize(*aSupportedGuestOSTypes), hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(SupportedGfxControllerTypes)(ComSafeArrayOut(GraphicsControllerType_T, aSupportedGfxControllerTypes))
{
    LogRelFlow(("{%p} %s: enter aSupportedGfxControllerTypes=%p\n", this, "PlatformProperties::getSupportedGfxControllerTypes", aSupportedGfxControllerTypes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedGfxControllerTypes);
        ArrayOutConverter<GraphicsControllerType_T> TmpSupportedGfxControllerTypes(ComSafeArrayOutArg(aSupportedGfxControllerTypes));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDGFXCONTROLLERTYPES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedGfxControllerTypes(TmpSupportedGfxControllerTypes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDGFXCONTROLLERTYPES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedGfxControllerTypes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDGFXCONTROLLERTYPES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDGFXCONTROLLERTYPES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedGfxControllerTypes=%zu hrc=%Rhrc\n", this, "PlatformProperties::getSupportedGfxControllerTypes", ComSafeArraySize(*aSupportedGfxControllerTypes), hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(SupportedNetAdpPromiscModePols)(ComSafeArrayOut(NetworkAdapterPromiscModePolicy_T, aSupportedNetAdpPromiscModePols))
{
    LogRelFlow(("{%p} %s: enter aSupportedNetAdpPromiscModePols=%p\n", this, "PlatformProperties::getSupportedNetAdpPromiscModePols", aSupportedNetAdpPromiscModePols));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedNetAdpPromiscModePols);
        ArrayOutConverter<NetworkAdapterPromiscModePolicy_T> TmpSupportedNetAdpPromiscModePols(ComSafeArrayOutArg(aSupportedNetAdpPromiscModePols));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDNETADPPROMISCMODEPOLS_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedNetAdpPromiscModePols(TmpSupportedNetAdpPromiscModePols.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDNETADPPROMISCMODEPOLS_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedNetAdpPromiscModePols.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDNETADPPROMISCMODEPOLS_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDNETADPPROMISCMODEPOLS_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedNetAdpPromiscModePols=%zu hrc=%Rhrc\n", this, "PlatformProperties::getSupportedNetAdpPromiscModePols", ComSafeArraySize(*aSupportedNetAdpPromiscModePols), hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(SupportedNetworkAdapterTypes)(ComSafeArrayOut(NetworkAdapterType_T, aSupportedNetworkAdapterTypes))
{
    LogRelFlow(("{%p} %s: enter aSupportedNetworkAdapterTypes=%p\n", this, "PlatformProperties::getSupportedNetworkAdapterTypes", aSupportedNetworkAdapterTypes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedNetworkAdapterTypes);
        ArrayOutConverter<NetworkAdapterType_T> TmpSupportedNetworkAdapterTypes(ComSafeArrayOutArg(aSupportedNetworkAdapterTypes));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDNETWORKADAPTERTYPES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedNetworkAdapterTypes(TmpSupportedNetworkAdapterTypes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDNETWORKADAPTERTYPES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedNetworkAdapterTypes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDNETWORKADAPTERTYPES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDNETWORKADAPTERTYPES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedNetworkAdapterTypes=%zu hrc=%Rhrc\n", this, "PlatformProperties::getSupportedNetworkAdapterTypes", ComSafeArraySize(*aSupportedNetworkAdapterTypes), hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(SupportedUartTypes)(ComSafeArrayOut(UartType_T, aSupportedUartTypes))
{
    LogRelFlow(("{%p} %s: enter aSupportedUartTypes=%p\n", this, "PlatformProperties::getSupportedUartTypes", aSupportedUartTypes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedUartTypes);
        ArrayOutConverter<UartType_T> TmpSupportedUartTypes(ComSafeArrayOutArg(aSupportedUartTypes));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDUARTTYPES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedUartTypes(TmpSupportedUartTypes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDUARTTYPES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedUartTypes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDUARTTYPES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDUARTTYPES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedUartTypes=%zu hrc=%Rhrc\n", this, "PlatformProperties::getSupportedUartTypes", ComSafeArraySize(*aSupportedUartTypes), hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(SupportedUSBControllerTypes)(ComSafeArrayOut(USBControllerType_T, aSupportedUSBControllerTypes))
{
    LogRelFlow(("{%p} %s: enter aSupportedUSBControllerTypes=%p\n", this, "PlatformProperties::getSupportedUSBControllerTypes", aSupportedUSBControllerTypes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedUSBControllerTypes);
        ArrayOutConverter<USBControllerType_T> TmpSupportedUSBControllerTypes(ComSafeArrayOutArg(aSupportedUSBControllerTypes));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDUSBCONTROLLERTYPES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedUSBControllerTypes(TmpSupportedUSBControllerTypes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDUSBCONTROLLERTYPES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedUSBControllerTypes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDUSBCONTROLLERTYPES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDUSBCONTROLLERTYPES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedUSBControllerTypes=%zu hrc=%Rhrc\n", this, "PlatformProperties::getSupportedUSBControllerTypes", ComSafeArraySize(*aSupportedUSBControllerTypes), hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(SupportedAudioControllerTypes)(ComSafeArrayOut(AudioControllerType_T, aSupportedAudioControllerTypes))
{
    LogRelFlow(("{%p} %s: enter aSupportedAudioControllerTypes=%p\n", this, "PlatformProperties::getSupportedAudioControllerTypes", aSupportedAudioControllerTypes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedAudioControllerTypes);
        ArrayOutConverter<AudioControllerType_T> TmpSupportedAudioControllerTypes(ComSafeArrayOutArg(aSupportedAudioControllerTypes));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDAUDIOCONTROLLERTYPES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedAudioControllerTypes(TmpSupportedAudioControllerTypes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDAUDIOCONTROLLERTYPES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedAudioControllerTypes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDAUDIOCONTROLLERTYPES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDAUDIOCONTROLLERTYPES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedAudioControllerTypes=%zu hrc=%Rhrc\n", this, "PlatformProperties::getSupportedAudioControllerTypes", ComSafeArraySize(*aSupportedAudioControllerTypes), hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(SupportedBootDevices)(ComSafeArrayOut(DeviceType_T, aSupportedBootDevices))
{
    LogRelFlow(("{%p} %s: enter aSupportedBootDevices=%p\n", this, "PlatformProperties::getSupportedBootDevices", aSupportedBootDevices));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedBootDevices);
        ArrayOutConverter<DeviceType_T> TmpSupportedBootDevices(ComSafeArrayOutArg(aSupportedBootDevices));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDBOOTDEVICES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedBootDevices(TmpSupportedBootDevices.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDBOOTDEVICES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedBootDevices.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDBOOTDEVICES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDBOOTDEVICES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedBootDevices=%zu hrc=%Rhrc\n", this, "PlatformProperties::getSupportedBootDevices", ComSafeArraySize(*aSupportedBootDevices), hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(SupportedStorageBuses)(ComSafeArrayOut(StorageBus_T, aSupportedStorageBuses))
{
    LogRelFlow(("{%p} %s: enter aSupportedStorageBuses=%p\n", this, "PlatformProperties::getSupportedStorageBuses", aSupportedStorageBuses));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedStorageBuses);
        ArrayOutConverter<StorageBus_T> TmpSupportedStorageBuses(ComSafeArrayOutArg(aSupportedStorageBuses));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDSTORAGEBUSES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedStorageBuses(TmpSupportedStorageBuses.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDSTORAGEBUSES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedStorageBuses.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDSTORAGEBUSES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDSTORAGEBUSES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedStorageBuses=%zu hrc=%Rhrc\n", this, "PlatformProperties::getSupportedStorageBuses", ComSafeArraySize(*aSupportedStorageBuses), hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(SupportedStorageControllerTypes)(ComSafeArrayOut(StorageControllerType_T, aSupportedStorageControllerTypes))
{
    LogRelFlow(("{%p} %s: enter aSupportedStorageControllerTypes=%p\n", this, "PlatformProperties::getSupportedStorageControllerTypes", aSupportedStorageControllerTypes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedStorageControllerTypes);
        ArrayOutConverter<StorageControllerType_T> TmpSupportedStorageControllerTypes(ComSafeArrayOutArg(aSupportedStorageControllerTypes));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDSTORAGECONTROLLERTYPES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedStorageControllerTypes(TmpSupportedStorageControllerTypes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDSTORAGECONTROLLERTYPES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedStorageControllerTypes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDSTORAGECONTROLLERTYPES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDSTORAGECONTROLLERTYPES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedStorageControllerTypes=%zu hrc=%Rhrc\n", this, "PlatformProperties::getSupportedStorageControllerTypes", ComSafeArraySize(*aSupportedStorageControllerTypes), hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(SupportedChipsetTypes)(ComSafeArrayOut(ChipsetType_T, aSupportedChipsetTypes))
{
    LogRelFlow(("{%p} %s: enter aSupportedChipsetTypes=%p\n", this, "PlatformProperties::getSupportedChipsetTypes", aSupportedChipsetTypes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedChipsetTypes);
        ArrayOutConverter<ChipsetType_T> TmpSupportedChipsetTypes(ComSafeArrayOutArg(aSupportedChipsetTypes));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDCHIPSETTYPES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedChipsetTypes(TmpSupportedChipsetTypes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDCHIPSETTYPES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedChipsetTypes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDCHIPSETTYPES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDCHIPSETTYPES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedChipsetTypes=%zu hrc=%Rhrc\n", this, "PlatformProperties::getSupportedChipsetTypes", ComSafeArraySize(*aSupportedChipsetTypes), hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(SupportedIommuTypes)(ComSafeArrayOut(IommuType_T, aSupportedIommuTypes))
{
    LogRelFlow(("{%p} %s: enter aSupportedIommuTypes=%p\n", this, "PlatformProperties::getSupportedIommuTypes", aSupportedIommuTypes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedIommuTypes);
        ArrayOutConverter<IommuType_T> TmpSupportedIommuTypes(ComSafeArrayOutArg(aSupportedIommuTypes));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDIOMMUTYPES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedIommuTypes(TmpSupportedIommuTypes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDIOMMUTYPES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedIommuTypes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDIOMMUTYPES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDIOMMUTYPES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedIommuTypes=%zu hrc=%Rhrc\n", this, "PlatformProperties::getSupportedIommuTypes", ComSafeArraySize(*aSupportedIommuTypes), hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(SupportedTpmTypes)(ComSafeArrayOut(TpmType_T, aSupportedTpmTypes))
{
    LogRelFlow(("{%p} %s: enter aSupportedTpmTypes=%p\n", this, "PlatformProperties::getSupportedTpmTypes", aSupportedTpmTypes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedTpmTypes);
        ArrayOutConverter<TpmType_T> TmpSupportedTpmTypes(ComSafeArrayOutArg(aSupportedTpmTypes));
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDTPMTYPES_ENTER(this);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedTpmTypes(TmpSupportedTpmTypes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDTPMTYPES_RETURN(this, hrc, 0 /*normal*/,(uint32_t)TmpSupportedTpmTypes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDTPMTYPES_RETURN(this, hrc, 1 /*hrc exception*/,0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GET_SUPPORTEDTPMTYPES_RETURN(this, hrc, 9 /*unhandled exception*/,0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aSupportedTpmTypes=%zu hrc=%Rhrc\n", this, "PlatformProperties::getSupportedTpmTypes", ComSafeArraySize(*aSupportedTpmTypes), hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(InternalAndReservedAttribute1IPlatformProperties)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(InternalAndReservedAttribute2IPlatformProperties)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(InternalAndReservedAttribute3IPlatformProperties)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(InternalAndReservedAttribute4IPlatformProperties)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(InternalAndReservedAttribute5IPlatformProperties)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(InternalAndReservedAttribute6IPlatformProperties)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(InternalAndReservedAttribute7IPlatformProperties)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(InternalAndReservedAttribute8IPlatformProperties)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(InternalAndReservedAttribute9IPlatformProperties)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(InternalAndReservedAttribute10IPlatformProperties)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(InternalAndReservedAttribute11IPlatformProperties)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(InternalAndReservedAttribute12IPlatformProperties)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(InternalAndReservedAttribute13IPlatformProperties)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(InternalAndReservedAttribute14IPlatformProperties)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(InternalAndReservedAttribute15IPlatformProperties)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}

STDMETHODIMP PlatformPropertiesWrap::COMGETTER(InternalAndReservedAttribute16IPlatformProperties)(ULONG *aReserved)
{
    NOREF(aReserved);
    return E_NOTIMPL;
}


//
// IPlatformProperties methods
//

STDMETHODIMP PlatformPropertiesWrap::GetMaxNetworkAdapters(ChipsetType_T aChipset,
                                                           ULONG *aMaxNetworkAdapters)
{
    LogRelFlow(("{%p} %s: enter aChipset=%RU32 aMaxNetworkAdapters=%p\n", this, "PlatformProperties::getMaxNetworkAdapters", aChipset, aMaxNetworkAdapters));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMaxNetworkAdapters);


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETMAXNETWORKADAPTERS_ENTER(this, aChipset);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMaxNetworkAdapters(aChipset,
                                        aMaxNetworkAdapters);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETMAXNETWORKADAPTERS_RETURN(this, hrc, 0 /*normal*/, aChipset, *aMaxNetworkAdapters);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETMAXNETWORKADAPTERS_RETURN(this, hrc, 1 /*hrc exception*/, aChipset, *aMaxNetworkAdapters);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETMAXNETWORKADAPTERS_RETURN(this, hrc, 9 /*unhandled exception*/, aChipset, *aMaxNetworkAdapters);
#endif
    }

    LogRelFlow(("{%p} %s: leave aMaxNetworkAdapters=%RU32 hrc=%Rhrc\n", this, "PlatformProperties::getMaxNetworkAdapters", *aMaxNetworkAdapters, hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::GetMaxNetworkAdaptersOfType(ChipsetType_T aChipset,
                                                                 NetworkAttachmentType_T aType,
                                                                 ULONG *aMaxNetworkAdapters)
{
    LogRelFlow(("{%p} %s: enter aChipset=%RU32 aType=%RU32 aMaxNetworkAdapters=%p\n", this, "PlatformProperties::getMaxNetworkAdaptersOfType", aChipset, aType, aMaxNetworkAdapters));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMaxNetworkAdapters);


        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETMAXNETWORKADAPTERSOFTYPE_ENTER(this, aChipset, aType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMaxNetworkAdaptersOfType(aChipset,
                                              aType,
                                              aMaxNetworkAdapters);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETMAXNETWORKADAPTERSOFTYPE_RETURN(this, hrc, 0 /*normal*/, aChipset, aType, *aMaxNetworkAdapters);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETMAXNETWORKADAPTERSOFTYPE_RETURN(this, hrc, 1 /*hrc exception*/, aChipset, aType, *aMaxNetworkAdapters);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETMAXNETWORKADAPTERSOFTYPE_RETURN(this, hrc, 9 /*unhandled exception*/, aChipset, aType, *aMaxNetworkAdapters);
#endif
    }

    LogRelFlow(("{%p} %s: leave aMaxNetworkAdapters=%RU32 hrc=%Rhrc\n", this, "PlatformProperties::getMaxNetworkAdaptersOfType", *aMaxNetworkAdapters, hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::GetMaxDevicesPerPortForStorageBus(StorageBus_T aBus,
                                                                       ULONG *aMaxDevicesPerPort)
{
    LogRelFlow(("{%p} %s: enter aBus=%RU32 aMaxDevicesPerPort=%p\n", this, "PlatformProperties::getMaxDevicesPerPortForStorageBus", aBus, aMaxDevicesPerPort));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMaxDevicesPerPort);


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETMAXDEVICESPERPORTFORSTORAGEBUS_ENTER(this, aBus);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMaxDevicesPerPortForStorageBus(aBus,
                                                    aMaxDevicesPerPort);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETMAXDEVICESPERPORTFORSTORAGEBUS_RETURN(this, hrc, 0 /*normal*/, aBus, *aMaxDevicesPerPort);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETMAXDEVICESPERPORTFORSTORAGEBUS_RETURN(this, hrc, 1 /*hrc exception*/, aBus, *aMaxDevicesPerPort);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETMAXDEVICESPERPORTFORSTORAGEBUS_RETURN(this, hrc, 9 /*unhandled exception*/, aBus, *aMaxDevicesPerPort);
#endif
    }

    LogRelFlow(("{%p} %s: leave aMaxDevicesPerPort=%RU32 hrc=%Rhrc\n", this, "PlatformProperties::getMaxDevicesPerPortForStorageBus", *aMaxDevicesPerPort, hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::GetMinPortCountForStorageBus(StorageBus_T aBus,
                                                                  ULONG *aMinPortCount)
{
    LogRelFlow(("{%p} %s: enter aBus=%RU32 aMinPortCount=%p\n", this, "PlatformProperties::getMinPortCountForStorageBus", aBus, aMinPortCount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMinPortCount);


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETMINPORTCOUNTFORSTORAGEBUS_ENTER(this, aBus);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMinPortCountForStorageBus(aBus,
                                               aMinPortCount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETMINPORTCOUNTFORSTORAGEBUS_RETURN(this, hrc, 0 /*normal*/, aBus, *aMinPortCount);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETMINPORTCOUNTFORSTORAGEBUS_RETURN(this, hrc, 1 /*hrc exception*/, aBus, *aMinPortCount);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETMINPORTCOUNTFORSTORAGEBUS_RETURN(this, hrc, 9 /*unhandled exception*/, aBus, *aMinPortCount);
#endif
    }

    LogRelFlow(("{%p} %s: leave aMinPortCount=%RU32 hrc=%Rhrc\n", this, "PlatformProperties::getMinPortCountForStorageBus", *aMinPortCount, hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::GetMaxPortCountForStorageBus(StorageBus_T aBus,
                                                                  ULONG *aMaxPortCount)
{
    LogRelFlow(("{%p} %s: enter aBus=%RU32 aMaxPortCount=%p\n", this, "PlatformProperties::getMaxPortCountForStorageBus", aBus, aMaxPortCount));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMaxPortCount);


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETMAXPORTCOUNTFORSTORAGEBUS_ENTER(this, aBus);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMaxPortCountForStorageBus(aBus,
                                               aMaxPortCount);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETMAXPORTCOUNTFORSTORAGEBUS_RETURN(this, hrc, 0 /*normal*/, aBus, *aMaxPortCount);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETMAXPORTCOUNTFORSTORAGEBUS_RETURN(this, hrc, 1 /*hrc exception*/, aBus, *aMaxPortCount);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETMAXPORTCOUNTFORSTORAGEBUS_RETURN(this, hrc, 9 /*unhandled exception*/, aBus, *aMaxPortCount);
#endif
    }

    LogRelFlow(("{%p} %s: leave aMaxPortCount=%RU32 hrc=%Rhrc\n", this, "PlatformProperties::getMaxPortCountForStorageBus", *aMaxPortCount, hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::GetMaxInstancesOfStorageBus(ChipsetType_T aChipset,
                                                                 StorageBus_T aBus,
                                                                 ULONG *aMaxInstances)
{
    LogRelFlow(("{%p} %s: enter aChipset=%RU32 aBus=%RU32 aMaxInstances=%p\n", this, "PlatformProperties::getMaxInstancesOfStorageBus", aChipset, aBus, aMaxInstances));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMaxInstances);


        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETMAXINSTANCESOFSTORAGEBUS_ENTER(this, aChipset, aBus);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMaxInstancesOfStorageBus(aChipset,
                                              aBus,
                                              aMaxInstances);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETMAXINSTANCESOFSTORAGEBUS_RETURN(this, hrc, 0 /*normal*/, aChipset, aBus, *aMaxInstances);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETMAXINSTANCESOFSTORAGEBUS_RETURN(this, hrc, 1 /*hrc exception*/, aChipset, aBus, *aMaxInstances);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETMAXINSTANCESOFSTORAGEBUS_RETURN(this, hrc, 9 /*unhandled exception*/, aChipset, aBus, *aMaxInstances);
#endif
    }

    LogRelFlow(("{%p} %s: leave aMaxInstances=%RU32 hrc=%Rhrc\n", this, "PlatformProperties::getMaxInstancesOfStorageBus", *aMaxInstances, hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::GetSupportedVRAMRange(GraphicsControllerType_T aGraphicsControllerType,
                                                           BOOL aAccelerate3DEnabled,
                                                           ULONG *aMinMB,
                                                           ULONG *aMaxMB,
                                                           ULONG *aStrideSizeMB)
{
    LogRelFlow(("{%p} %s: enter aGraphicsControllerType=%RU32 aAccelerate3DEnabled=%RTbool aMinMB=%p aMaxMB=%p aStrideSizeMB=%p\n", this, "PlatformProperties::getSupportedVRAMRange", aGraphicsControllerType, aAccelerate3DEnabled, aMinMB, aMaxMB, aStrideSizeMB));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMinMB);
        CheckComArgOutPointerValidThrow(aMaxMB);
        CheckComArgOutPointerValidThrow(aStrideSizeMB);


        
        
        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETSUPPORTEDVRAMRANGE_ENTER(this, aGraphicsControllerType, aAccelerate3DEnabled != FALSE);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedVRAMRange(aGraphicsControllerType,
                                        aAccelerate3DEnabled != FALSE,
                                        aMinMB,
                                        aMaxMB,
                                        aStrideSizeMB);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETSUPPORTEDVRAMRANGE_RETURN(this, hrc, 0 /*normal*/, aGraphicsControllerType, aAccelerate3DEnabled != FALSE, *aMinMB, *aMaxMB, *aStrideSizeMB);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETSUPPORTEDVRAMRANGE_RETURN(this, hrc, 1 /*hrc exception*/, aGraphicsControllerType, aAccelerate3DEnabled != FALSE, *aMinMB, *aMaxMB, *aStrideSizeMB);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETSUPPORTEDVRAMRANGE_RETURN(this, hrc, 9 /*unhandled exception*/, aGraphicsControllerType, aAccelerate3DEnabled != FALSE, *aMinMB, *aMaxMB, *aStrideSizeMB);
#endif
    }

    LogRelFlow(("{%p} %s: leave *aMinMB=%RU32 *aMaxMB=%RU32 aStrideSizeMB=%RU32 hrc=%Rhrc\n", this, "PlatformProperties::getSupportedVRAMRange", *aMinMB, *aMaxMB, *aStrideSizeMB, hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::GetSupportedGfxFeaturesForType(GraphicsControllerType_T aGraphicsControllerType,
                                                                    ComSafeArrayOut(GraphicsFeature_T, aSupportedControllerFeatures))
{
    LogRelFlow(("{%p} %s: enter aGraphicsControllerType=%RU32 aSupportedControllerFeatures=%p\n", this, "PlatformProperties::getSupportedGfxFeaturesForType", aGraphicsControllerType, aSupportedControllerFeatures));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aSupportedControllerFeatures);


        
        ArrayOutConverter<GraphicsFeature_T> TmpSupportedControllerFeatures(ComSafeArrayOutArg(aSupportedControllerFeatures));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETSUPPORTEDGFXFEATURESFORTYPE_ENTER(this, aGraphicsControllerType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getSupportedGfxFeaturesForType(aGraphicsControllerType,
                                                 TmpSupportedControllerFeatures.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETSUPPORTEDGFXFEATURESFORTYPE_RETURN(this, hrc, 0 /*normal*/, aGraphicsControllerType, (uint32_t)TmpSupportedControllerFeatures.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETSUPPORTEDGFXFEATURESFORTYPE_RETURN(this, hrc, 1 /*hrc exception*/, aGraphicsControllerType, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETSUPPORTEDGFXFEATURESFORTYPE_RETURN(this, hrc, 9 /*unhandled exception*/, aGraphicsControllerType, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aSupportedControllerFeatures=%zu hrc=%Rhrc\n", this, "PlatformProperties::getSupportedGfxFeaturesForType", ComSafeArraySize(*aSupportedControllerFeatures), hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::GetDeviceTypesForStorageBus(StorageBus_T aBus,
                                                                 ComSafeArrayOut(DeviceType_T, aDeviceTypes))
{
    LogRelFlow(("{%p} %s: enter aBus=%RU32 aDeviceTypes=%p\n", this, "PlatformProperties::getDeviceTypesForStorageBus", aBus, aDeviceTypes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aDeviceTypes);


        
        ArrayOutConverter<DeviceType_T> TmpDeviceTypes(ComSafeArrayOutArg(aDeviceTypes));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETDEVICETYPESFORSTORAGEBUS_ENTER(this, aBus);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getDeviceTypesForStorageBus(aBus,
                                              TmpDeviceTypes.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETDEVICETYPESFORSTORAGEBUS_RETURN(this, hrc, 0 /*normal*/, aBus, (uint32_t)TmpDeviceTypes.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETDEVICETYPESFORSTORAGEBUS_RETURN(this, hrc, 1 /*hrc exception*/, aBus, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETDEVICETYPESFORSTORAGEBUS_RETURN(this, hrc, 9 /*unhandled exception*/, aBus, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aDeviceTypes=%zu hrc=%Rhrc\n", this, "PlatformProperties::getDeviceTypesForStorageBus", ComSafeArraySize(*aDeviceTypes), hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::GetStorageBusForControllerType(StorageControllerType_T aStorageControllerType,
                                                                    StorageBus_T *aStorageBus)
{
    LogRelFlow(("{%p} %s: enter aStorageControllerType=%RU32 aStorageBus=%p\n", this, "PlatformProperties::getStorageBusForControllerType", aStorageControllerType, aStorageBus));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aStorageBus);


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETSTORAGEBUSFORCONTROLLERTYPE_ENTER(this, aStorageControllerType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getStorageBusForControllerType(aStorageControllerType,
                                                 aStorageBus);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETSTORAGEBUSFORCONTROLLERTYPE_RETURN(this, hrc, 0 /*normal*/, aStorageControllerType, *aStorageBus);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETSTORAGEBUSFORCONTROLLERTYPE_RETURN(this, hrc, 1 /*hrc exception*/, aStorageControllerType, *aStorageBus);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETSTORAGEBUSFORCONTROLLERTYPE_RETURN(this, hrc, 9 /*unhandled exception*/, aStorageControllerType, *aStorageBus);
#endif
    }

    LogRelFlow(("{%p} %s: leave aStorageBus=%RU32 hrc=%Rhrc\n", this, "PlatformProperties::getStorageBusForControllerType", *aStorageBus, hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::GetStorageControllerTypesForBus(StorageBus_T aStorageBus,
                                                                     ComSafeArrayOut(StorageControllerType_T, aStorageControllerType))
{
    LogRelFlow(("{%p} %s: enter aStorageBus=%RU32 aStorageControllerType=%p\n", this, "PlatformProperties::getStorageControllerTypesForBus", aStorageBus, aStorageControllerType));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aStorageControllerType);


        
        ArrayOutConverter<StorageControllerType_T> TmpStorageControllerType(ComSafeArrayOutArg(aStorageControllerType));

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETSTORAGECONTROLLERTYPESFORBUS_ENTER(this, aStorageBus);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getStorageControllerTypesForBus(aStorageBus,
                                                  TmpStorageControllerType.array());
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETSTORAGECONTROLLERTYPESFORBUS_RETURN(this, hrc, 0 /*normal*/, aStorageBus, (uint32_t)TmpStorageControllerType.array().size(), NULL /*for now*/);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETSTORAGECONTROLLERTYPESFORBUS_RETURN(this, hrc, 1 /*hrc exception*/, aStorageBus, 0, 0);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETSTORAGECONTROLLERTYPESFORBUS_RETURN(this, hrc, 9 /*unhandled exception*/, aStorageBus, 0, 0);
#endif
    }

    LogRelFlow(("{%p} %s: leave aStorageControllerType=%zu hrc=%Rhrc\n", this, "PlatformProperties::getStorageControllerTypesForBus", ComSafeArraySize(*aStorageControllerType), hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::GetStorageControllerHotplugCapable(StorageControllerType_T aControllerType,
                                                                        BOOL *aHotplugCapable)
{
    LogRelFlow(("{%p} %s: enter aControllerType=%RU32 aHotplugCapable=%p\n", this, "PlatformProperties::getStorageControllerHotplugCapable", aControllerType, aHotplugCapable));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aHotplugCapable);


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETSTORAGECONTROLLERHOTPLUGCAPABLE_ENTER(this, aControllerType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getStorageControllerHotplugCapable(aControllerType,
                                                     aHotplugCapable);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETSTORAGECONTROLLERHOTPLUGCAPABLE_RETURN(this, hrc, 0 /*normal*/, aControllerType, *aHotplugCapable != FALSE);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETSTORAGECONTROLLERHOTPLUGCAPABLE_RETURN(this, hrc, 1 /*hrc exception*/, aControllerType, *aHotplugCapable != FALSE);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETSTORAGECONTROLLERHOTPLUGCAPABLE_RETURN(this, hrc, 9 /*unhandled exception*/, aControllerType, *aHotplugCapable != FALSE);
#endif
    }

    LogRelFlow(("{%p} %s: leave aHotplugCapable=%RTbool hrc=%Rhrc\n", this, "PlatformProperties::getStorageControllerHotplugCapable", *aHotplugCapable, hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::GetMaxInstancesOfUSBControllerType(ChipsetType_T aChipset,
                                                                        USBControllerType_T aType,
                                                                        ULONG *aMaxInstances)
{
    LogRelFlow(("{%p} %s: enter aChipset=%RU32 aType=%RU32 aMaxInstances=%p\n", this, "PlatformProperties::getMaxInstancesOfUSBControllerType", aChipset, aType, aMaxInstances));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMaxInstances);


        
        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETMAXINSTANCESOFUSBCONTROLLERTYPE_ENTER(this, aChipset, aType);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMaxInstancesOfUSBControllerType(aChipset,
                                                     aType,
                                                     aMaxInstances);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETMAXINSTANCESOFUSBCONTROLLERTYPE_RETURN(this, hrc, 0 /*normal*/, aChipset, aType, *aMaxInstances);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETMAXINSTANCESOFUSBCONTROLLERTYPE_RETURN(this, hrc, 1 /*hrc exception*/, aChipset, aType, *aMaxInstances);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETMAXINSTANCESOFUSBCONTROLLERTYPE_RETURN(this, hrc, 9 /*unhandled exception*/, aChipset, aType, *aMaxInstances);
#endif
    }

    LogRelFlow(("{%p} %s: leave aMaxInstances=%RU32 hrc=%Rhrc\n", this, "PlatformProperties::getMaxInstancesOfUSBControllerType", *aMaxInstances, hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::GetMinGuestRAM(FirmwareType_T aFirmware,
                                                    ULONG *aMinMegabytes)
{
    LogRelFlow(("{%p} %s: enter aFirmware=%RU32 aMinMegabytes=%p\n", this, "PlatformProperties::getMinGuestRAM", aFirmware, aMinMegabytes));

    // Clear error info, to make in-process calls behave the same as
    // cross-apartment calls or out-of-process calls.
    VirtualBoxBase::clearError();

    HRESULT hrc;

    try
    {
        CheckComArgOutPointerValidThrow(aMinMegabytes);


        
        

#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETMINGUESTRAM_ENTER(this, aFirmware);
#endif
        AutoCaller autoCaller(this);
        hrc = autoCaller.hrc();
        if (SUCCEEDED(hrc))
        {
            hrc = getMinGuestRAM(aFirmware,
                                 aMinMegabytes);
        }
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETMINGUESTRAM_RETURN(this, hrc, 0 /*normal*/, aFirmware, *aMinMegabytes);
#endif
    }
    catch (HRESULT hrc2)
    {
        hrc = hrc2;
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETMINGUESTRAM_RETURN(this, hrc, 1 /*hrc exception*/, aFirmware, *aMinMegabytes);
#endif
    }
    catch (...)
    {
        hrc = VirtualBoxBase::handleUnexpectedExceptions(this, RT_SRC_POS);
#ifdef VBOX_WITH_DTRACE_R3_MAIN
        VBOXAPI_PLATFORMPROPERTIES_GETMINGUESTRAM_RETURN(this, hrc, 9 /*unhandled exception*/, aFirmware, *aMinMegabytes);
#endif
    }

    LogRelFlow(("{%p} %s: leave aMinMegabytes=%RU32 hrc=%Rhrc\n", this, "PlatformProperties::getMinGuestRAM", *aMinMegabytes, hrc));
    return hrc;
}

STDMETHODIMP PlatformPropertiesWrap::InternalAndReservedMethod1IPlatformProperties()
{
    return E_NOTIMPL;
}

STDMETHODIMP PlatformPropertiesWrap::InternalAndReservedMethod2IPlatformProperties()
{
    return E_NOTIMPL;
}

STDMETHODIMP PlatformPropertiesWrap::InternalAndReservedMethod3IPlatformProperties()
{
    return E_NOTIMPL;
}

#ifdef VBOX_WITH_XPCOM
NS_DECL_CLASSINFO(PlatformPropertiesWrap)
NS_IMPL_THREADSAFE_ISUPPORTS1_CI(PlatformPropertiesWrap, IPlatformProperties)
#endif // VBOX_WITH_XPCOM
