#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkMultiBlockUnstructuredGridVolumeMapper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkMultiBlockVolumeMapper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOpenGLGPUVolumeRayCastMapper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOpenGLProjectedTetrahedraMapper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOpenGLRayCastImageDisplayHelper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkOpenGLSurfaceProbeVolumeMapper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkSmartVolumeMapper_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkVolumeTexture_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkRenderingVolumeOpenGL2CS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkMultiBlockUnstructuredGridVolumeMapper_Init(csi);
  vtkMultiBlockVolumeMapper_Init(csi);
  vtkOpenGLGPUVolumeRayCastMapper_Init(csi);
  vtkOpenGLProjectedTetrahedraMapper_Init(csi);
  vtkOpenGLRayCastImageDisplayHelper_Init(csi);
  vtkOpenGLSurfaceProbeVolumeMapper_Init(csi);
  vtkSmartVolumeMapper_Init(csi);
  vtkVolumeTexture_Init(csi);
}
